/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.NotTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.SystemReader;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.jgit.ExactPathFilter;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.ListBranchCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public final class Utils {
    private Utils() {
    }

    public static Repository getRepositoryForWorkingDir(File workDir) throws IOException, IllegalArgumentException {
        FileRepositoryBuilder builder = (FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(workDir);
        try {
            builder.setInitialBranch(Utils.getInitBranchName());
        }
        catch (IOException | InvalidRefNameException | ConfigInvalidException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, "can not set initial branch name", ex);
        }
        Repository repo = builder.build();
        repo.getConfig().setBoolean("pack", null, "buildbitmaps", false);
        return repo;
    }

    private static String getInitBranchName() throws IOException, ConfigInvalidException {
        return Utils.getGitSettingString("init", null, "defaultbranch");
    }

    private static String getGitSettingString(String section, String subsection, String name) throws IOException, ConfigInvalidException {
        SystemReader reader = SystemReader.getInstance();
        String value = reader.getUserConfig().getString(section, subsection, name);
        return value != null && !value.isEmpty() ? value : reader.getSystemConfig().getString(section, subsection, name);
    }

    public static File getMetadataFolder(File workDir) {
        return new File(workDir, ".git");
    }

    public static boolean checkExecutable(Repository repository) {
        return repository.getConfig().getBoolean("core", null, "filemode", true);
    }

    public static Collection<PathFilter> getPathFilters(File workDir, File[] roots) {
        List<String> relativePaths = Utils.getRelativePaths(workDir, roots);
        return Utils.getPathFilters(relativePaths);
    }

    public static TreeFilter getExcludeExactPathsFilter(File workDir, File[] roots) {
        List<String> relativePaths = Utils.getRelativePaths(workDir, roots);
        TreeFilter filter = null;
        if (relativePaths.size() > 0) {
            Collection<PathFilter> filters = Utils.getPathFilters(relativePaths);
            LinkedList<ExactPathFilter> exactPathFilters = new LinkedList<ExactPathFilter>();
            for (PathFilter f : filters) {
                exactPathFilters.add(ExactPathFilter.create(f));
            }
            return NotTreeFilter.create((TreeFilter)(exactPathFilters.size() == 1 ? (TreeFilter)exactPathFilters.get(0) : OrTreeFilter.create(exactPathFilters)));
        }
        return filter;
    }

    public static List<GitRevisionInfo.GitFileInfo> getDiffEntries(Repository repository, TreeWalk walk, GitClassFactory fac) throws IOException {
        ArrayList<GitRevisionInfo.GitFileInfo> result = new ArrayList<GitRevisionInfo.GitFileInfo>();
        List entries = DiffEntry.scan((TreeWalk)walk);
        RenameDetector rd = new RenameDetector(repository);
        rd.addAll((Collection)entries);
        entries = rd.compute();
        for (DiffEntry e : entries) {
            GitRevisionInfo.GitFileInfo.Status status;
            File oldFile = null;
            String oldPath = null;
            String path = e.getOldPath();
            if (path == null) {
                path = e.getNewPath();
            }
            switch (e.getChangeType()) {
                case ADD: {
                    status = GitRevisionInfo.GitFileInfo.Status.ADDED;
                    path = e.getNewPath();
                    break;
                }
                case COPY: {
                    status = GitRevisionInfo.GitFileInfo.Status.COPIED;
                    oldFile = new File(repository.getWorkTree(), e.getOldPath());
                    oldPath = e.getOldPath();
                    path = e.getNewPath();
                    break;
                }
                case DELETE: {
                    status = GitRevisionInfo.GitFileInfo.Status.REMOVED;
                    path = e.getOldPath();
                    break;
                }
                case MODIFY: {
                    status = GitRevisionInfo.GitFileInfo.Status.MODIFIED;
                    path = e.getOldPath();
                    break;
                }
                case RENAME: {
                    status = GitRevisionInfo.GitFileInfo.Status.RENAMED;
                    oldFile = new File(repository.getWorkTree(), e.getOldPath());
                    oldPath = e.getOldPath();
                    path = e.getNewPath();
                    break;
                }
                default: {
                    status = GitRevisionInfo.GitFileInfo.Status.UNKNOWN;
                }
            }
            if (status == GitRevisionInfo.GitFileInfo.Status.RENAMED) {
                result.add(fac.createFileInfo(new File(repository.getWorkTree(), e.getOldPath()), e.getOldPath(), GitRevisionInfo.GitFileInfo.Status.REMOVED, null, null));
            }
            result.add(fac.createFileInfo(new File(repository.getWorkTree(), path), path, status, oldFile, oldPath));
        }
        return result;
    }

    public static Collection<PathFilter> getPathFilters(Collection<String> relativePaths) {
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>(relativePaths.size());
        for (String path : relativePaths) {
            filters.add(PathFilter.create((String)path));
        }
        return filters;
    }

    public static List<String> getRelativePaths(File workDir, File[] roots) {
        ArrayList<String> paths = new ArrayList<String>(roots.length);
        for (File root : roots) {
            if (workDir.equals(root)) {
                paths.clear();
                break;
            }
            paths.add(Utils.getRelativePath(workDir, root));
        }
        return paths;
    }

    public static String getRelativePath(File repo, File file) {
        return Utils.getRelativePath(repo, file, false);
    }

    public static Path getLinkPath(Path p) throws IOException {
        return Files.readSymbolicLink(p);
    }

    private static String getRelativePath(File repo, File file, boolean canonicalized) {
        StringBuilder relativePath = new StringBuilder("");
        File parent = file;
        if (!parent.equals(repo)) {
            while (parent != null && !parent.equals(repo)) {
                relativePath.insert(0, "/").insert(0, parent.getName());
                parent = parent.getParentFile();
            }
            if (parent == null) {
                if (!canonicalized) {
                    try {
                        return Utils.getRelativePath(repo.getCanonicalFile(), file.getCanonicalFile(), true);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Utils.class.getName()).log(Level.FINE, null, ex);
                    }
                }
                throw new IllegalArgumentException(file.getPath() + " is not under " + repo.getPath());
            }
            relativePath.deleteCharAt(relativePath.length() - 1);
        }
        return relativePath.toString();
    }

    public static boolean isUnderOrEqual(TreeWalk treeWalk, Collection<PathFilter> filters) {
        boolean retval = filters.isEmpty();
        for (PathFilter filter : filters) {
            if (!filter.include(treeWalk) || treeWalk.getPathString().length() < filter.getPath().length()) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public static Collection<byte[]> getPaths(Collection<PathFilter> pathFilters) {
        LinkedList<byte[]> paths = new LinkedList<byte[]>();
        for (PathFilter filter : pathFilters) {
            paths.add(Constants.encode((String)filter.getPath()));
        }
        return paths;
    }

    public static RevCommit findCommit(Repository repository, String revision) throws GitException.MissingObjectException, GitException {
        return Utils.findCommit(repository, revision, null);
    }

    public static RevCommit findCommit(Repository repository, String revision, RevWalk walk) throws GitException.MissingObjectException, GitException {
        ObjectId commitId = Utils.parseObjectId(repository, revision);
        if (commitId == null) {
            throw new GitException.MissingObjectException(revision, GitObjectType.COMMIT);
        }
        return Utils.findCommit(repository, commitId, walk);
    }

    public static RevCommit findCommit(Repository repository, ObjectId commitId, RevWalk walk) throws GitException.MissingObjectException, GitException {
        try {
            return (walk == null ? new RevWalk(repository) : walk).parseCommit((AnyObjectId)commitId);
        }
        catch (MissingObjectException ex) {
            throw new GitException.MissingObjectException(commitId.name(), GitObjectType.COMMIT, ex);
        }
        catch (IncorrectObjectTypeException ex) {
            throw new GitException(MessageFormat.format(Utils.getBundle(Utils.class).getString("MSG_Exception_IdNotACommit"), commitId.name()));
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    public static ObjectId parseObjectId(Repository repository, String objectId) throws GitException {
        try {
            return repository.resolve(objectId);
        }
        catch (RevisionSyntaxException ex) {
            throw new GitException.MissingObjectException(objectId, GitObjectType.COMMIT, ex);
        }
        catch (AmbiguousObjectException ex) {
            throw new GitException(MessageFormat.format(Utils.getBundle(Utils.class).getString("MSG_Exception_IdAmbiguous"), objectId), ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    public static RevObject findObject(Repository repository, String objectId) throws GitException.MissingObjectException, GitException {
        try {
            ObjectId commitId = Utils.parseObjectId(repository, objectId);
            if (commitId == null) {
                throw new GitException.MissingObjectException(objectId, GitObjectType.UNKNOWN);
            }
            return new RevWalk(repository).parseAny((AnyObjectId)commitId);
        }
        catch (MissingObjectException ex) {
            throw new GitException.MissingObjectException(objectId, GitObjectType.UNKNOWN, ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Utils.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    public static String getRefName(Ref ref) {
        String name = ref.getName();
        for (String prefix : Arrays.asList("refs/heads/", "refs/remotes/", "refs/tags/", "refs/")) {
            if (!name.startsWith(prefix)) continue;
            name = name.substring(prefix.length());
        }
        return name;
    }

    public static Map<String, GitBranch> refsToBranches(Collection<Ref> allRefs, String prefix, GitClassFactory factory) {
        LinkedHashMap<String, GitBranch> branches = new LinkedHashMap<String, GitBranch>();
        Ref head = null;
        for (Ref ref : allRefs) {
            if (!ref.getLeaf().getName().equals("HEAD")) continue;
            head = ref;
            break;
        }
        for (Ref ref : RefComparator.sort(allRefs)) {
            String refName = ref.getLeaf().getName();
            if (!refName.startsWith(prefix)) continue;
            String name = refName.substring(prefix.length());
            ObjectId id = ref.getLeaf().getObjectId();
            if (id == null) {
                Logger.getLogger(Utils.class.getName()).log(Level.INFO, "Null object id for ref: {0}, {1}:{2}, {3}", new Object[]{ref.toString(), ref.getName(), ref.getObjectId(), ref.getLeaf()});
                continue;
            }
            branches.put(name, factory.createBranch(name, false, head != null && ref.getObjectId().equals((AnyObjectId)head.getObjectId()), id));
        }
        return branches;
    }

    public static Map<String, String> refsToTags(Collection<Ref> allRefs) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        for (Ref ref : RefComparator.sort(allRefs)) {
            String refName = ref.getLeaf().getName();
            if (!refName.startsWith("refs/tags/")) continue;
            String name = refName.substring("refs/tags/".length());
            tags.put(name, ObjectId.toString((ObjectId)ref.getLeaf().getObjectId()));
        }
        return tags;
    }

    public static ResourceBundle getBundle(Class clazz) {
        Object pref = clazz.getName();
        int last = ((String)pref).lastIndexOf(46);
        pref = last >= 0 ? ((String)pref).substring(0, last + 1) + "Bundle" : "Bundle";
        return ResourceBundle.getBundle((String)pref);
    }

    public static boolean isFromNested(int fm) {
        return fm == 57344;
    }

    public static GitBranch getTrackedBranch(Config config, String branchName, Map<String, GitBranch> allBranches) {
        Object remoteName = config.getString("branch", branchName, "remote");
        String trackedBranchName = config.getString("branch", branchName, "merge");
        if (trackedBranchName != null) {
            if (trackedBranchName.startsWith("refs/heads/")) {
                trackedBranchName = trackedBranchName.substring("refs/heads/".length());
            } else if (trackedBranchName.startsWith("refs/remotes/")) {
                trackedBranchName = trackedBranchName.substring("refs/remotes/".length());
            }
        }
        if (trackedBranchName == null) {
            return null;
        }
        remoteName = remoteName != null && ".".equals(remoteName) ? "" : (String)remoteName + "/";
        return allBranches.get((String)remoteName + trackedBranchName);
    }

    public static Map<String, GitBranch> getAllBranches(Repository repository, GitClassFactory fac, ProgressMonitor monitor) throws GitException {
        ListBranchCommand cmd = new ListBranchCommand(repository, fac, true, monitor);
        cmd.execute();
        return cmd.getBranches();
    }

    public static RawText getRawText(ObjectId id, ObjectDatabase db) throws IOException {
        if (id.equals((AnyObjectId)ObjectId.zeroId())) {
            return RawText.EMPTY_TEXT;
        }
        return new RawText(db.open((AnyObjectId)id, 3).getCachedBytes());
    }
}

