/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NetworkSecurityGroupVnic
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="timeAssociated")
    private final Date timeAssociated;
    @JsonProperty(value="vnicId")
    private final String vnicId;

    @Deprecated
    @ConstructorProperties(value={"resourceId", "timeAssociated", "vnicId"})
    public NetworkSecurityGroupVnic(String resourceId, Date timeAssociated, String vnicId) {
        this.resourceId = resourceId;
        this.timeAssociated = timeAssociated;
        this.vnicId = vnicId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Date getTimeAssociated() {
        return this.timeAssociated;
    }

    public String getVnicId() {
        return this.vnicId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkSecurityGroupVnic(");
        sb.append("super=").append(super.toString());
        sb.append("resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", timeAssociated=").append(String.valueOf(this.timeAssociated));
        sb.append(", vnicId=").append(String.valueOf(this.vnicId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkSecurityGroupVnic)) {
            return false;
        }
        NetworkSecurityGroupVnic other = (NetworkSecurityGroupVnic)((Object)o);
        return Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.timeAssociated, other.timeAssociated) && Objects.equals(this.vnicId, other.vnicId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.timeAssociated == null ? 43 : this.timeAssociated.hashCode());
        result = result * 59 + (this.vnicId == null ? 43 : this.vnicId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="timeAssociated")
        private Date timeAssociated;
        @JsonProperty(value="vnicId")
        private String vnicId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder timeAssociated(Date timeAssociated) {
            this.timeAssociated = timeAssociated;
            this.__explicitlySet__.add("timeAssociated");
            return this;
        }

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            this.__explicitlySet__.add("vnicId");
            return this;
        }

        public NetworkSecurityGroupVnic build() {
            NetworkSecurityGroupVnic model = new NetworkSecurityGroupVnic(this.resourceId, this.timeAssociated, this.vnicId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NetworkSecurityGroupVnic model) {
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("timeAssociated")) {
                this.timeAssociated(model.getTimeAssociated());
            }
            if (model.wasPropertyExplicitlySet("vnicId")) {
                this.vnicId(model.getVnicId());
            }
            return this;
        }
    }
}

