/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetInstanceConfigurationRequest
extends BmcRequest<Void> {
    private String instanceConfigurationId;

    public String getInstanceConfigurationId() {
        return this.instanceConfigurationId;
    }

    public Builder toBuilder() {
        return new Builder().instanceConfigurationId(this.instanceConfigurationId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceConfigurationId=").append(String.valueOf(this.instanceConfigurationId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetInstanceConfigurationRequest)) {
            return false;
        }
        GetInstanceConfigurationRequest other = (GetInstanceConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceConfigurationId, other.instanceConfigurationId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceConfigurationId == null ? 43 : this.instanceConfigurationId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInstanceConfigurationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceConfigurationId = null;

        public Builder instanceConfigurationId(String instanceConfigurationId) {
            this.instanceConfigurationId = instanceConfigurationId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInstanceConfigurationRequest o) {
            this.instanceConfigurationId(o.getInstanceConfigurationId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInstanceConfigurationRequest build() {
            GetInstanceConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetInstanceConfigurationRequest buildWithoutInvocationCallback() {
            GetInstanceConfigurationRequest request = new GetInstanceConfigurationRequest();
            request.instanceConfigurationId = this.instanceConfigurationId;
            return request;
        }
    }
}

