/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateRouteTableDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateRouteTableRequest
extends BmcRequest<UpdateRouteTableDetails> {
    private String rtId;
    private UpdateRouteTableDetails updateRouteTableDetails;
    private String ifMatch;

    public String getRtId() {
        return this.rtId;
    }

    public UpdateRouteTableDetails getUpdateRouteTableDetails() {
        return this.updateRouteTableDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateRouteTableDetails getBody$() {
        return this.updateRouteTableDetails;
    }

    public Builder toBuilder() {
        return new Builder().rtId(this.rtId).updateRouteTableDetails(this.updateRouteTableDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",rtId=").append(String.valueOf(this.rtId));
        sb.append(",updateRouteTableDetails=").append(String.valueOf((Object)this.updateRouteTableDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRouteTableRequest)) {
            return false;
        }
        UpdateRouteTableRequest other = (UpdateRouteTableRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.rtId, other.rtId) && Objects.equals((Object)this.updateRouteTableDetails, (Object)other.updateRouteTableDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.rtId == null ? 43 : this.rtId.hashCode());
        result = result * 59 + (this.updateRouteTableDetails == null ? 43 : this.updateRouteTableDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateRouteTableRequest, UpdateRouteTableDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String rtId = null;
        private UpdateRouteTableDetails updateRouteTableDetails = null;
        private String ifMatch = null;

        public Builder rtId(String rtId) {
            this.rtId = rtId;
            return this;
        }

        public Builder updateRouteTableDetails(UpdateRouteTableDetails updateRouteTableDetails) {
            this.updateRouteTableDetails = updateRouteTableDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateRouteTableRequest o) {
            this.rtId(o.getRtId());
            this.updateRouteTableDetails(o.getUpdateRouteTableDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateRouteTableRequest build() {
            UpdateRouteTableRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateRouteTableDetails body) {
            this.updateRouteTableDetails(body);
            return this;
        }

        public UpdateRouteTableRequest buildWithoutInvocationCallback() {
            UpdateRouteTableRequest request = new UpdateRouteTableRequest();
            request.rtId = this.rtId;
            request.updateRouteTableDetails = this.updateRouteTableDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

