/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ui.nodes;

import java.awt.Component;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.modules.tomcat5.customizer.Customizer;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.ui.nodes.actions.AdminConsoleAction;
import org.netbeans.modules.tomcat5.ui.nodes.actions.EditContextXmlAction;
import org.netbeans.modules.tomcat5.ui.nodes.actions.EditServerXmlAction;
import org.netbeans.modules.tomcat5.ui.nodes.actions.OpenServerOutputAction;
import org.netbeans.modules.tomcat5.ui.nodes.actions.ServerLogAction;
import org.netbeans.modules.tomcat5.ui.nodes.actions.SharedContextLogAction;
import org.netbeans.modules.tomcat5.ui.nodes.actions.TerminateAction;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class TomcatInstanceNode
extends AbstractNode
implements Node.Cookie {
    private TomcatManager tm;

    public TomcatInstanceNode(Children children, Lookup lookup) {
        super(children);
        this.tm = (TomcatManager)lookup.lookup(TomcatManager.class);
        this.setIconBaseWithExtension("org/netbeans/modules/tomcat5/resources/tomcat.png");
        this.getCookieSet().add((Node.Cookie)this);
    }

    public String getShortDescription() {
        return NbBundle.getMessage(TomcatInstanceNode.class, (String)"LBL_TomcatInstanceNode", (Object)String.valueOf(this.tm.getCurrentServerPort()));
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new Customizer(this.tm);
    }

    public TomcatManager getTomcatManager() {
        return this.tm;
    }

    public Action[] getActions(boolean context) {
        LinkedList<SystemAction> actions = new LinkedList<SystemAction>();
        if (!Utilities.isWindows()) {
            actions.add(null);
            actions.add(SystemAction.get(TerminateAction.class));
        }
        actions.add(null);
        actions.add(SystemAction.get(EditServerXmlAction.class));
        actions.add(SystemAction.get(EditContextXmlAction.class));
        if (this.tm.isTomcat50() || this.tm.isTomcat55()) {
            actions.add(SystemAction.get(AdminConsoleAction.class));
        }
        if (this.tm.isTomcat50()) {
            actions.add(SystemAction.get(SharedContextLogAction.class));
        }
        if (!this.tm.isTomcat50()) {
            actions.add(SystemAction.get(ServerLogAction.class));
        }
        actions.add(SystemAction.get(OpenServerOutputAction.class));
        return (Action[])actions.toArray(new SystemAction[0]);
    }

    private FileObject getTomcatConf() {
        this.tm.ensureCatalinaBaseReady();
        TomcatProperties tp = this.tm.getTomcatProperties();
        return FileUtil.toFileObject((File)tp.getServerXml());
    }

    public void editServerXml() {
        FileObject fileObject = this.getTomcatConf();
        if (fileObject != null) {
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(TomcatInstanceNode.class.getName()).log(Level.INFO, null, ex);
            }
            if (dataObject != null) {
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    editorCookie.open();
                } else {
                    Logger.getLogger(TomcatInstanceNode.class.getName()).log(Level.INFO, "Cannot find EditorCookie.");
                }
            }
        }
    }

    private FileObject getTomcatContextXml() {
        this.tm.ensureCatalinaBaseReady();
        TomcatProperties tp = this.tm.getTomcatProperties();
        return FileUtil.toFileObject((File)tp.getContextXml());
    }

    public void editContextXml() {
        FileObject fileObject = this.getTomcatContextXml();
        if (fileObject != null) {
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(TomcatInstanceNode.class.getName()).log(Level.INFO, null, ex);
            }
            if (dataObject != null) {
                EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                if (editorCookie != null) {
                    editorCookie.open();
                } else {
                    Logger.getLogger(TomcatInstanceNode.class.getName()).log(Level.INFO, "Cannot find EditorCookie.");
                }
            }
        }
    }

    public void openServerLog() {
        this.tm.logManager().openServerLog();
    }

    public boolean hasServerLog() {
        return this.tm.logManager().hasServerLog();
    }

    public static MultiViewEditorElement createMultiViewEditorElement(Lookup context) {
        return new MultiViewEditorElement(context);
    }
}

