/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.php.smarty.editor.completion.CodeCompletionUtils;
import org.netbeans.modules.php.smarty.editor.completion.TplCompletionProvider;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;

public class TplCompletionItem
implements CompletionItem {
    protected static final int DEFAULT_SORT_PRIORITY = 22;
    protected String text;
    protected String help;
    protected String helpUrl;
    protected boolean shift;

    protected TplCompletionItem(String text) {
        this.text = text;
    }

    protected TplCompletionItem(String text, String help) {
        this.text = text;
        this.help = help;
    }

    protected TplCompletionItem(String text, String help, String helpUrl) {
        this(text);
        this.help = help;
        this.helpUrl = helpUrl;
    }

    public String getItemText() {
        return this.text;
    }

    public String getItemHelp() {
        return this.help;
    }

    public int getSortPriority() {
        return 22;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent e) {
        this.shift = e.getKeyCode() == 10 && e.getID() == 401 && e.isShiftDown();
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            if (!this.shift) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
            }
            this.substituteText(component, CodeCompletionUtils.getSubstitutionLenght(component.getDocument(), component.getCaretPosition()));
        }
    }

    protected int getMoveBackLength() {
        return 0;
    }

    protected String getSubstituteText() {
        return this.getItemText();
    }

    protected boolean substituteText(JTextComponent c, int len) {
        return this.substituteText(c, len, this.getMoveBackLength());
    }

    protected boolean substituteText(JTextComponent c, int len, int moveBack) {
        return this.substituteText(c, this.getSubstituteText(), len, moveBack);
    }

    protected boolean substituteText(final JTextComponent c, final String substituteText, final int len, int moveBack) {
        final BaseDocument doc = (BaseDocument)c.getDocument();
        final boolean[] result = new boolean[]{true};
        doc.runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    int substitutionOffset = c.getCaretPosition() - CodeCompletionUtils.getSubstitutionLenght(c.getDocument(), c.getCaretPosition());
                    String currentText = doc.getText(substitutionOffset, doc.getLength() - substitutionOffset < substituteText.length() ? doc.getLength() - substitutionOffset : substituteText.length());
                    if (!substituteText.equals(currentText)) {
                        doc.remove(substitutionOffset, len);
                        doc.insertString(substitutionOffset, substituteText, null);
                    } else {
                        c.setCaretPosition(c.getCaret().getDot() + substituteText.length() - len);
                    }
                }
                catch (BadLocationException ex) {
                    result[0] = false;
                }
            }
        });
        this.reindent(c);
        if (moveBack != 0) {
            Caret caret = c.getCaret();
            int dot = caret.getDot();
            caret.setDot(dot - moveBack);
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindent(JTextComponent component) {
        final BaseDocument doc = (BaseDocument)component.getDocument();
        final int dotPos = component.getCaretPosition();
        final Indent indent = Indent.get((Document)doc);
        indent.lock();
        try {
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        int startOffset = LineDocumentUtils.getLineStartOffset((LineDocument)doc, (int)dotPos);
                        int endOffset = LineDocumentUtils.getLineEndOffset((LineDocument)doc, (int)dotPos);
                        indent.reindent(startOffset, endOffset);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        finally {
            indent.unlock();
        }
    }

    public boolean instantSubstitution(JTextComponent component) {
        if (component != null) {
            try {
                int substitutionOffset = CodeCompletionUtils.getSubstitutionLenght(component.getDocument(), component.getCaretPosition());
                int caretOffset = component.getSelectionEnd();
                if (caretOffset > substitutionOffset) {
                    String currentText = component.getDocument().getText(substitutionOffset, caretOffset - substitutionOffset);
                    if (!this.getSubstituteText().toString().startsWith(currentText)) {
                        return false;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.defaultAction(component);
        return true;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)Color.BLACK, (int)width, (int)height, (boolean)selected);
    }

    protected ImageIcon getIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/smarty/resources/tpl-cc-icon.png", (boolean)false);
    }

    protected String getLeftHtmlText() {
        return this.getItemText();
    }

    protected String getRightHtmlText() {
        return null;
    }

    public String getHelp() {
        return this.getItemHelp();
    }

    public boolean hasHelp() {
        return this.help != null && this.help.length() > 0;
    }

    public URL getHelpURL() {
        if (this.help == null || this.help.equals("")) {
            return null;
        }
        try {
            return new URL(this.helpUrl);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new TplCompletionProvider.DocQuery(this));
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public static final String hexColorCode(Color c) {
        return Integer.toHexString(c.getRGB()).substring(2);
    }

    public static class VariableModifiersCompletionItem
    extends TplCompletionItem {
        protected static final String ATTR_NAME_COLOR = VariableModifiersCompletionItem.hexColorCode(Color.blue.darker());

        public VariableModifiersCompletionItem(String value, String help, String helpUrl) {
            super(value, help, helpUrl);
        }

        @Override
        protected String getLeftHtmlText() {
            return "<font color=#" + ATTR_NAME_COLOR + ">" + this.getItemText() + "</font>";
        }

        @Override
        public int getSortPriority() {
            return 25;
        }
    }

    public static class FunctionParametersCompletionItem
    extends TplCompletionItem {
        protected static final String CUSTOM_FUNC_COLOR = "D6822D";

        public FunctionParametersCompletionItem(String value, String help) {
            super(value, help);
        }

        @Override
        protected String getLeftHtmlText() {
            return "<font color=#D6822D>" + this.getItemText() + "</font>";
        }

        @Override
        public int getSortPriority() {
            return 18;
        }
    }

    public static class CustomFunctionsCompletionItem
    extends BuiltInFunctionsCompletionItem {
        protected static final String CUSTOM_FUNC_COLOR = "3B713B";

        public CustomFunctionsCompletionItem(String value, String help, String helpUrl) {
            super(value, help, helpUrl);
        }

        @Override
        protected String getLeftHtmlText() {
            return "<font color=#3B713B>" + this.getItemText() + "</font>";
        }
    }

    public static class BuiltInFunctionsCompletionItem
    extends TplCompletionItem {
        protected static final String BUILT_IN_FUNC_COLOR = "529854";

        public BuiltInFunctionsCompletionItem(String value, String help, String helpUrl) {
            super(value, help, helpUrl);
        }

        @Override
        protected String getLeftHtmlText() {
            return "<font color=#529854>" + this.getItemText() + "</font>";
        }

        @Override
        public int getSortPriority() {
            return 20;
        }
    }
}

