/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.Folds;
import org.netbeans.modules.languages.features.LocalizationSupport;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.text.NbDocument;

public class LanguagesFoldManager
extends ASTEvaluator
implements FoldManager {
    static final String FOLD = "FOLD";
    private static final int EVALUATING = 0;
    private static final int STOPPED = 1;
    private FoldOperation operation;
    private Document doc;
    private ParserManagerImpl parserManager;
    private int evalState = 1;
    private static FoldType defaultFoldType = new FoldType("default");
    private List<FoldItem> folds;

    public void init(FoldOperation operation) {
        Document d = operation.getHierarchy().getComponent().getDocument();
        if (d instanceof NbEditorDocument) {
            this.doc = d;
            this.operation = operation;
            this.parserManager = ParserManagerImpl.getImpl(this.doc);
            this.parserManager.addASTEvaluator(this);
            this.parserManager.fire(this.parserManager.getState(), null, Collections.singletonMap(FOLD, Collections.singleton(this)), this.parserManager.getAST());
        }
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold epmtyFold) {
    }

    public void removeDamagedNotify(Fold damagedFold) {
    }

    public void expandNotify(Fold expandedFold) {
    }

    public void release() {
        if (this.doc != null) {
            this.parserManager.removeASTEvaluator(this);
        }
        this.parserManager = null;
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode root) {
        this.evalState = 0;
        this.folds = null;
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode root) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (LanguagesFoldManager.this.operation == null) {
                    LanguagesFoldManager.this.evalState = 1;
                    return;
                }
                FoldHierarchy fh = LanguagesFoldManager.this.operation.getHierarchy();
                try {
                    Fold fold = LanguagesFoldManager.this.operation.getHierarchy().getRootFold();
                    ArrayList existingFolds = new ArrayList();
                    LanguagesFoldManager.this.collectFolds(fold, existingFolds);
                    List generated = LanguagesFoldManager.this.folds != null ? LanguagesFoldManager.this.folds : new ArrayList();
                    HashSet<FoldItem> newborns = new HashSet<FoldItem>(generated.size() / 2);
                    HashSet<Fold> zombies = new HashSet<Fold>(generated.size() / 2);
                    Iterator genItr = generated.iterator();
                    Hashtable<Integer, FoldItem> newbornsLinesCache = new Hashtable<Integer, FoldItem>();
                    HashSet<FoldItem> duplicateNewborns = new HashSet<FoldItem>();
                    while (genItr.hasNext()) {
                        FoldItem fi = (FoldItem)genItr.next();
                        int fiLineOffset = LineDocumentUtils.getLineIndex((LineDocument)((BaseDocument)LanguagesFoldManager.this.doc), (int)fi.start);
                        FoldItem found = (FoldItem)newbornsLinesCache.get(fiLineOffset);
                        if (found != null && found.end < fi.end) {
                            duplicateNewborns.add(found);
                        }
                        newbornsLinesCache.put(fiLineOffset, fi);
                        Fold fs = FoldUtilities.findNearestFold((FoldHierarchy)fh, (int)fi.start);
                        if (fs != null) {
                            try {
                                LanguagesFoldManager.this.operation.getExtraInfo(fs);
                            }
                            catch (IllegalStateException e) {
                                fs = null;
                            }
                        }
                        if (fs != null && fs.getStartOffset() == fi.start && fs.getEndOffset() == fi.end) {
                            if (fi.type == fs.getType() && fi.foldName.equals(fs.getDescription())) continue;
                            zombies.add(fs);
                            newborns.add(fi);
                            continue;
                        }
                        newborns.add(fi);
                    }
                    newborns.removeAll(duplicateNewborns);
                    existingFolds.removeAll(zombies);
                    Hashtable<Integer, Fold> linesToFoldsCache = new Hashtable<Integer, Fold>();
                    for (Fold f : existingFolds) {
                        Iterator genItr2 = generated.iterator();
                        boolean found = false;
                        while (genItr2.hasNext()) {
                            FoldItem fi = (FoldItem)genItr2.next();
                            if (f.getStartOffset() != fi.start || f.getEndOffset() != fi.end) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            zombies.add(f);
                            continue;
                        }
                        int lineoffset = LineDocumentUtils.getLineIndex((LineDocument)((BaseDocument)LanguagesFoldManager.this.doc), (int)f.getStartOffset());
                        linesToFoldsCache.put(lineoffset, f);
                    }
                    Iterator newbornsItr = newborns.iterator();
                    HashSet<FoldItem> newbornsToRemove = new HashSet<FoldItem>();
                    while (newbornsItr.hasNext()) {
                        FoldItem fi = (FoldItem)newbornsItr.next();
                        Fold existing = (Fold)linesToFoldsCache.get(LineDocumentUtils.getLineIndex((LineDocument)((BaseDocument)LanguagesFoldManager.this.doc), (int)fi.start));
                        if (existing == null) continue;
                        if (existing.getEndOffset() < fi.end) {
                            zombies.add(existing);
                            continue;
                        }
                        newbornsToRemove.add(fi);
                    }
                    newborns.removeAll(newbornsToRemove);
                    ((BaseDocument)LanguagesFoldManager.this.doc).readLock();
                    try {
                        fh.lock();
                        try {
                            FoldHierarchyTransaction transaction = LanguagesFoldManager.this.operation.openTransaction();
                            try {
                                for (Fold f : zombies) {
                                    if (LanguagesFoldManager.this.doc.getLength() == 0) break;
                                    LanguagesFoldManager.this.operation.removeFromHierarchy(f, transaction);
                                }
                                for (FoldItem f : newborns) {
                                    if (LanguagesFoldManager.this.doc.getLength() == 0) {
                                        break;
                                    }
                                    if (f.start < 0 || f.end < 0 || f.start >= f.end || f.end > LanguagesFoldManager.this.doc.getLength()) continue;
                                    LanguagesFoldManager.this.operation.addToHierarchy(f.type, f.foldName, false, f.start, f.end, 0, 0, (Object)fh, transaction);
                                }
                            }
                            catch (BadLocationException ble) {
                                ble.printStackTrace();
                            }
                            finally {
                                transaction.commit();
                            }
                        }
                        finally {
                            fh.unlock();
                        }
                    }
                    finally {
                        ((BaseDocument)LanguagesFoldManager.this.doc).readUnlock();
                    }
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
                finally {
                    LanguagesFoldManager.this.evalState = 1;
                }
            }
        });
    }

    private void collectFolds(Fold fold, List<Fold> existingFolds) {
        int k = fold.getFoldCount();
        for (int i = 0; i < k; ++i) {
            Fold f = fold.getFold(i);
            try {
                this.operation.getExtraInfo(f);
                existingFolds.add(f);
                this.collectFolds(f, existingFolds);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getFeatureName() {
        return FOLD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(ParserManager.State state, List<ASTItem> path, Feature fold) {
        String foldName;
        boolean isTokenFold;
        int eln;
        ASTItem item = path.get(path.size() - 1);
        int s = item.getOffset();
        int e = item.getEndOffset();
        int sln = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)s);
        if (sln == (eln = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)e))) {
            return;
        }
        String mimeType = item.getMimeType();
        Language language = (Language)item.getLanguage();
        boolean bl = isTokenFold = item instanceof ASTToken && fold == language.getFeatureList().getFeature(FOLD, ((ASTToken)item).getTypeName());
        if (!isTokenFold) {
            TokenHierarchy th = TokenHierarchy.get((Document)this.doc);
            if (this.doc instanceof NbEditorDocument) {
                ((NbEditorDocument)this.doc).readLock();
            }
            try {
                TokenSequence ts = th.tokenSequence();
                ts.move(e - 1);
                if (!ts.moveNext()) {
                    return;
                }
                while (!ts.language().mimeType().equals(mimeType)) {
                    if ((ts = ts.embedded()) == null) {
                        return;
                    }
                    ts.move(e - 1);
                    if (ts.moveNext()) continue;
                    return;
                }
                Token t = ts.token();
                Set<Integer> skip = language.getAnalyser().getSkipTokenTypes();
                while (skip.contains(t.id().ordinal()) && ts.movePrevious()) {
                    t = ts.token();
                }
                e = ts.offset() + t.length();
                String tokenText = t.text().toString();
                if (tokenText.endsWith("\n")) {
                    --e;
                }
                sln = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)s);
                eln = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)e);
                if (eln - sln < 1) {
                    return;
                }
            }
            finally {
                if (this.doc instanceof NbEditorDocument) {
                    ((NbEditorDocument)this.doc).readUnlock();
                }
            }
        }
        if (fold.hasSingleValue()) {
            foldName = LocalizationSupport.localize(language, (String)fold.getValue(SyntaxContext.create(this.doc, ASTPath.create(path))));
            if (foldName == null) {
                return;
            }
            this.addFold(new FoldItem(foldName, s, e, defaultFoldType));
            return;
        }
        foldName = LocalizationSupport.localize(language, (String)fold.getValue("fold_display_name", SyntaxContext.create(this.doc, ASTPath.create(path))));
        if (foldName == null) {
            foldName = "...";
        }
        String foldType = LocalizationSupport.localize(language, (String)fold.getValue("collapse_type_action_name"));
        this.addFold(new FoldItem(foldName, s, e, Folds.getFoldType(foldType)));
    }

    private void addFold(FoldItem foldItem) {
        if (this.folds == null) {
            this.folds = new CopyOnWriteArrayList<FoldItem>();
        }
        this.folds.add(foldItem);
    }

    void init(Document doc) {
        this.doc = doc;
        this.operation = null;
        this.parserManager = ParserManagerImpl.getImpl(doc);
        this.parserManager.addASTEvaluator(this);
    }

    List<FoldItem> getFolds() {
        return this.folds;
    }

    boolean isEvaluating() {
        return this.evalState == 0;
    }

    static final class FoldItem {
        String foldName;
        int start;
        int end;
        FoldType type;

        FoldItem(String foldName, int start, int end, FoldType type) {
            this.foldName = foldName;
            this.start = start;
            this.end = end;
            this.type = type;
        }
    }

    public static final class Factory
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new LanguagesFoldManager();
        }
    }
}

