/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.tasklist.filter.FilterRepository;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.modules.tasklist.impl.ScanningScopeList;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.modules.tasklist.ui.CountStatusBar;
import org.netbeans.modules.tasklist.ui.FiltersMenuButton;
import org.netbeans.modules.tasklist.ui.FoldingTaskListModel;
import org.netbeans.modules.tasklist.ui.ScopeButton;
import org.netbeans.modules.tasklist.ui.ScopeStatusBar;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.modules.tasklist.ui.TaskListModel;
import org.netbeans.modules.tasklist.ui.TaskListTable;
import org.netbeans.modules.tasklist.ui.Util;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class TaskListTopComponent
extends TopComponent {
    private static TaskListTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/tasklist/ui/resources/taskList.png";
    private static final String PREFERRED_ID = "TaskListTopComponent";
    private TaskManagerImpl taskManager = TaskManagerImpl.getInstance();
    private PropertyChangeListener scopeListListener;
    private PropertyChangeListener scannerListListener;
    private TaskListModel model;
    private FilterRepository filters;
    private TaskListTable table;
    private PropertyChangeListener changeListener;
    private TaskList.Listener tasksListener;
    private static final boolean isMacLaf;
    private static final Color macBackground;
    private JPanel statusBarPanel;
    private JSeparator statusSeparator;
    private JPanel tableHolderPanel;
    private JScrollPane tableScroll;
    private JToolBar toolbar;
    private JSeparator toolbarSeparator;
    private ProgressHandle progress;

    private TaskListTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(TaskListTopComponent.class, (String)"CTL_TaskListTopComponent"));
        this.setToolTipText(NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_TaskListTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.tableScroll.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TaskListTopComponent.this.maybePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TaskListTopComponent.this.maybePopup(e);
            }
        });
        if (isMacLaf) {
            this.tableScroll.setBackground(macBackground);
            this.tableScroll.getViewport().setBackground(macBackground);
            this.toolbar.setBackground(macBackground);
            this.statusBarPanel.setBackground(macBackground);
        }
    }

    private void initComponents() {
        this.toolbar = new JToolBar();
        this.tableHolderPanel = new JPanel();
        this.tableScroll = new JScrollPane();
        this.toolbarSeparator = new JSeparator();
        this.statusSeparator = new JSeparator();
        this.statusBarPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.toolbar.setFloatable(false);
        this.toolbar.setOrientation(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add(this.toolbar, gridBagConstraints);
        this.tableHolderPanel.setOpaque(false);
        this.tableScroll.setBorder(null);
        GroupLayout tableHolderPanelLayout = new GroupLayout(this.tableHolderPanel);
        this.tableHolderPanel.setLayout(tableHolderPanelLayout);
        tableHolderPanelLayout.setHorizontalGroup(tableHolderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableScroll, GroupLayout.Alignment.TRAILING, -1, 397, Short.MAX_VALUE));
        tableHolderPanelLayout.setVerticalGroup(tableHolderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableScroll, -1, 299, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.tableHolderPanel, gridBagConstraints);
        this.toolbarSeparator.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add(this.toolbarSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add(this.statusSeparator, gridBagConstraints);
        this.statusBarPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        this.add(this.statusBarPanel, gridBagConstraints);
    }

    public static synchronized TaskListTopComponent getDefault() {
        if (instance == null) {
            instance = new TaskListTopComponent();
        }
        return instance;
    }

    public static synchronized TaskListTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            TaskListTopComponent.getLogger().log(Level.INFO, "Cannot find TaskList component. It will not be located properly in the window system.");
            return TaskListTopComponent.getDefault();
        }
        if (win instanceof TaskListTopComponent) {
            return (TaskListTopComponent)win;
        }
        TaskListTopComponent.getLogger().log(Level.INFO, "There seem to be multiple components with the 'TaskListTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return TaskListTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        if (null == this.model) {
            this.toolbarSeparator.setVisible(false);
            this.statusSeparator.setVisible(false);
            this.tableScroll.setViewportView(this.createNoTasksMessage());
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                TaskManagerImpl.RP.post(new Runnable(){

                    @Override
                    public void run() {
                        TaskListTopComponent.this.init();
                    }
                });
            }
        });
    }

    private void init() {
        TaskScanningScope activeScope = this.getActiveScope();
        if (null == this.filters) {
            try {
                this.filters = FilterRepository.getDefault();
                this.filters.load();
            }
            catch (IOException ioE) {
                TaskListTopComponent.getLogger().log(Level.INFO, ioE.getMessage(), ioE);
            }
        }
        if (null == this.changeListener) {
            this.changeListener = this.createChangeListener();
            this.taskManager.addPropertyChangeListener("workingStatus", this.changeListener);
        }
        if (null == this.model) {
            this.table = new TaskListTable();
            if (isMacLaf) {
                this.table.setBackground(macBackground);
            }
            this.model = new TaskListModel(this.taskManager.getTasks());
            this.table.setModel(this.model);
            this.tasksListener = new TaskList.Listener(){

                @Override
                public void tasksAdded(List<? extends Task> tasks) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            TaskListTopComponent.this.tableScroll.setViewportView(TaskListTopComponent.this.table);
                            Color background = UIManager.getColor("TextArea.background");
                            if (null != background) {
                                TaskListTopComponent.this.tableScroll.getViewport().setBackground(background);
                            }
                            TaskListTopComponent.this.tableScroll.setBorder(BorderFactory.createEmptyBorder());
                            if (isMacLaf) {
                                TaskListTopComponent.this.table.setBackground(macBackground);
                                TaskListTopComponent.this.tableScroll.getViewport().setBackground(macBackground);
                            }
                        }
                    };
                    TaskListTopComponent.this.taskManager.getTasks().removeListener(TaskListTopComponent.this.tasksListener);
                    if (SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        SwingUtilities.invokeLater(runnable);
                    }
                    TaskListTopComponent.this.tasksListener = null;
                }

                @Override
                public void tasksRemoved(List<? extends Task> tasks) {
                }

                @Override
                public void cleared() {
                }
            };
            this.taskManager.getTasks().addListener(this.tasksListener);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskListTopComponent.this.tableScroll.setViewportView(TaskListTopComponent.this.createNoTasksMessage());
                    TaskListTopComponent.this.tableScroll.setBorder(BorderFactory.createEmptyBorder());
                    TaskListTopComponent.this.statusBarPanel.add((Component)new CountStatusBar(TaskListTopComponent.this.taskManager.getTasks()), "West");
                    TaskListTopComponent.this.statusBarPanel.add((Component)new ScopeStatusBar(TaskListTopComponent.this.taskManager), "Center");
                    TaskListTopComponent.this.toolbarSeparator.setVisible(true);
                    TaskListTopComponent.this.statusSeparator.setVisible(true);
                    TaskListTopComponent.this.rebuildToolbar();
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScanningScopeList.getDefault().addPropertyChangeListener(TaskListTopComponent.this.getScopeListListener());
                ScannerList.getFileScannerList().addPropertyChangeListener(TaskListTopComponent.this.getScannerListListener());
                ScannerList.getPushScannerList().addPropertyChangeListener(TaskListTopComponent.this.getScannerListListener());
            }
        });
        TaskScanningScope scopeToObserve = activeScope;
        this.taskManager.observe(scopeToObserve, this.filters.getActive());
    }

    private Component createNoTasksMessage() {
        JPanel panel = new JPanel(new BorderLayout());
        if (isMacLaf) {
            panel.setBackground(macBackground);
        } else {
            Color background = UIManager.getColor("TextArea.background");
            if (null != background) {
                panel.setBackground(background);
            }
        }
        JLabel msg = new JLabel(NbBundle.getMessage(TaskListTopComponent.class, (String)"LBL_NoTasks"));
        msg.setHorizontalAlignment(0);
        msg.setEnabled(false);
        msg.setOpaque(false);
        panel.add((Component)msg, "Center");
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentClosed() {
        ScanningScopeList.getDefault().removePropertyChangeListener(this.getScopeListListener());
        ScannerList.getFileScannerList().removePropertyChangeListener(this.getScannerListListener());
        ScannerList.getPushScannerList().removePropertyChangeListener(this.getScannerListListener());
        this.taskManager.observe(null, null);
        if (null != this.changeListener) {
            this.taskManager.removePropertyChangeListener("workingStatus", this.changeListener);
            this.changeListener = null;
        }
        TaskListTopComponent taskListTopComponent = this;
        synchronized (taskListTopComponent) {
            if (null != this.progress) {
                this.progress.finish();
            }
            this.progress = null;
        }
        try {
            FilterRepository.getDefault().save();
        }
        catch (IOException ioE) {
            TaskListTopComponent.getLogger().log(Level.INFO, null, ioE);
        }
    }

    public void requestActive() {
        super.requestActive();
        if (null != this.table) {
            this.table.requestFocusInWindow();
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void maybePopup(MouseEvent e) {
        if (e.isPopupTrigger() && null != this.table) {
            e.consume();
            JPopupMenu popup = Util.createPopup(this.table);
            popup.show((Component)((Object)this), e.getX(), e.getY());
        }
    }

    private PropertyChangeListener getScopeListListener() {
        if (null == this.scopeListListener) {
            this.scopeListListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    ScanningScopeList scopeList = ScanningScopeList.getDefault();
                    List<TaskScanningScope> newScopes = scopeList.getTaskScanningScopes();
                    if (newScopes.isEmpty()) {
                        TaskListTopComponent.getLogger().log(Level.INFO, "No task scanning scope found");
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TaskListTopComponent.this.rebuildToolbar();
                        }
                    });
                }
            };
        }
        return this.scopeListListener;
    }

    private PropertyChangeListener getScannerListListener() {
        if (null == this.scannerListListener) {
            this.scannerListListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    final TaskScanningScope scopeToObserve = TaskListTopComponent.this.taskManager.getScope();
                    TaskListTopComponent.this.taskManager.observe(null, null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TaskListTopComponent.this.taskManager.observe(scopeToObserve, TaskListTopComponent.this.filters.getActive());
                        }
                    });
                }
            };
        }
        return this.scannerListListener;
    }

    private void rebuildToolbar() {
        this.toolbar.removeAll();
        this.toolbar.setFocusable(false);
        List<TaskScanningScope> scopes = ScanningScopeList.getDefault().getTaskScanningScopes();
        for (TaskScanningScope scope : scopes) {
            ScopeButton scopeButton = new ScopeButton(this.taskManager, scope);
            scopeButton.setSelected(scope.equals(Settings.getDefault().getActiveScanningScope()));
            this.toolbar.add(scopeButton);
        }
        this.toolbar.add(new JToolBar.Separator());
        FiltersMenuButton toggleFilter = new FiltersMenuButton(this.filters.getActive());
        this.toolbar.add(toggleFilter);
        this.toolbar.addSeparator();
        final JToggleButton toggleGroups = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/tasklist/ui/resources/groups.png", (boolean)false));
        toggleGroups.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TaskListTopComponent.this.switchTableModel(e.getStateChange() == 1);
                Settings.getDefault().setGroupTasksByCategory(toggleGroups.isSelected());
                toggleGroups.setToolTipText(toggleGroups.isSelected() ? NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_TasksAsList") : NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_GrouppedTasks"));
            }
        });
        toggleGroups.setSelected(Settings.getDefault().getGroupTasksByCategory());
        toggleGroups.setToolTipText(toggleGroups.isSelected() ? NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_TasksAsList") : NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_GrouppedTasks"));
        toggleGroups.setFocusable(false);
        this.toolbar.add(toggleGroups);
    }

    private void switchTableModel(boolean useFoldingModel) {
        if (useFoldingModel) {
            this.model = new FoldingTaskListModel(this.taskManager.getTasks());
            this.table.setModel(this.model);
            this.statusBarPanel.removeAll();
        } else {
            this.model = new TaskListModel(this.taskManager.getTasks());
            this.table.setModel(this.model);
            this.statusBarPanel.add((Component)new CountStatusBar(this.taskManager.getTasks()), "West");
            this.statusBarPanel.add((Component)new ScopeStatusBar(this.taskManager), "Center");
        }
        this.statusBarPanel.setVisible(!useFoldingModel);
        this.statusSeparator.setVisible(!useFoldingModel);
    }

    private static Logger getLogger() {
        return Logger.getLogger(TaskListTopComponent.class.getName());
    }

    private PropertyChangeListener createChangeListener() {
        return new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TaskListTopComponent taskListTopComponent = TaskListTopComponent.this;
                synchronized (taskListTopComponent) {
                    if (((Boolean)e.getNewValue()).booleanValue()) {
                        if (null == TaskListTopComponent.this.progress) {
                            TaskListTopComponent.this.progress = ProgressHandle.createHandle((String)NbBundle.getMessage(TaskListTopComponent.class, (String)"LBL_ScanProgress"), (Cancellable)new Cancellable(){

                                public boolean cancel() {
                                    TaskListTopComponent.this.taskManager.abort();
                                    return true;
                                }
                            });
                            TaskListTopComponent.this.progress.start();
                            TaskListTopComponent.this.progress.switchToIndeterminate();
                        }
                    } else {
                        if (null != TaskListTopComponent.this.progress) {
                            TaskListTopComponent.this.progress.finish();
                        }
                        TaskListTopComponent.this.progress = null;
                    }
                }
            }
        };
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TaskListTopComponent.class);
    }

    private TaskScanningScope getActiveScope() {
        TaskScanningScope activeScope = Settings.getDefault().getActiveScanningScope();
        if (null == activeScope) {
            activeScope = ScanningScopeList.getDefault().getDefaultScope();
        }
        return activeScope;
    }

    static {
        isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
        macBackground = UIManager.getColor("NbExplorerView.background");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return TaskListTopComponent.getDefault();
        }
    }
}

