/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dashboard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.dashboard.DashboardManager;
import org.netbeans.modules.dashboard.Bundle;
import org.netbeans.modules.dashboard.DashboardPanel;
import org.netbeans.modules.dashboard.DefaultDashboardDisplayer;
import org.netbeans.spi.dashboard.DashboardDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

@TopComponent.Description(preferredID="DashboardDisplayer", persistenceType=1)
public final class DashboardTopComponent
extends TopComponent {
    private static final String ID = "DashboardDisplayer";
    private List<DashboardDisplayer.WidgetReference> widgetRefs;
    private DashboardPanel dashboardPanel;
    private JPanel dashContainer;
    private JLabel emptyLabel;
    private JScrollPane scrollPane;

    public DashboardTopComponent() {
        this.initComponents();
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.setName(Bundle.CTL_DashboardTopComponent());
        this.setToolTipText(Bundle.HINT_DashboardTopComponent());
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.dashContainer = new JPanel();
        this.emptyLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.scrollPane.setBorder(null);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setViewportBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.dashContainer.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.emptyLabel, (String)NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.emptyLabel.text"));
        this.dashContainer.add((Component)this.emptyLabel, new GridBagConstraints());
        this.scrollPane.setViewportView(this.dashContainer);
        this.add(this.scrollPane, "Center");
    }

    public void componentShowing() {
        if (this.dashboardPanel != null) {
            this.dashboardPanel.notifyShowing();
        }
    }

    public void componentHidden() {
        if (this.dashboardPanel != null) {
            this.dashboardPanel.notifyHidden();
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void installWidgets(DefaultDashboardDisplayer displayer, List<DashboardDisplayer.WidgetReference> widgetRefs) {
        if (this.widgetRefs != null && this.widgetRefs.equals(widgetRefs)) {
            return;
        }
        this.widgetRefs = List.copyOf(widgetRefs);
        this.dashboardPanel = new DashboardPanel(displayer, widgetRefs);
        this.dashContainer.removeAll();
        this.dashContainer.add(this.dashboardPanel);
        this.dashboardPanel.notifyShowing();
    }

    static void show(DefaultDashboardDisplayer displayer, List<DashboardDisplayer.WidgetReference> widgetRefs) {
        DashboardTopComponent dashTC = DashboardTopComponent.find();
        if (dashTC == null) {
            return;
        }
        if (widgetRefs.isEmpty()) {
            dashTC.close();
            return;
        }
        dashTC.installWidgets(displayer, widgetRefs);
        if (!dashTC.isOpened()) {
            dashTC.openAtTabPosition(0);
        }
        dashTC.requestActive();
    }

    private static DashboardTopComponent find() {
        TopComponent tc = WindowManager.getDefault().findTopComponent(ID);
        if (tc instanceof DashboardTopComponent) {
            DashboardTopComponent dashTC = (DashboardTopComponent)tc;
            return dashTC;
        }
        return null;
    }

    public static final class Startup
    implements Runnable {
        @Override
        public void run() {
            if (DefaultDashboardDisplayer.isDefaultDisplayer() && this.isShowOnStartup()) {
                WindowManager.getDefault().invokeWhenUIReady(() -> DashboardManager.getDefault().show());
            } else {
                DashboardTopComponent tc = DashboardTopComponent.find();
                if (tc != null && tc.isOpened()) {
                    tc.close();
                }
            }
            WindowManager.getDefault().addWindowSystemListener(new WindowSystemListener(){

                public void afterLoad(WindowSystemEvent event) {
                }

                public void afterSave(WindowSystemEvent event) {
                }

                public void beforeLoad(WindowSystemEvent event) {
                }

                public void beforeSave(WindowSystemEvent event) {
                    WindowManager.getDefault().removeWindowSystemListener((WindowSystemListener)this);
                    DashboardTopComponent tc = DashboardTopComponent.find();
                    if (DefaultDashboardDisplayer.isDefaultDisplayer() && this.isShowOnStartup()) {
                        if (tc != null) {
                            tc.open();
                            tc.requestActive();
                        }
                    } else if (tc != null) {
                        tc.close();
                    }
                }
            });
        }

        private boolean isShowOnStartup() {
            FileObject config = FileUtil.getConfigFile((String)"Dashboard/Main");
            if (config == null) {
                return false;
            }
            return Boolean.TRUE.equals(config.getAttribute("showOnStartup"));
        }
    }
}

