/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.editor.codegen.ui.Bundle;
import org.netbeans.modules.java.editor.codegen.ui.CheckTreeView;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;

public class ElementSelectorPanel
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager = new ExplorerManager();
    private CheckTreeView elementView;

    public ElementSelectorPanel(ElementNode.Description elementDescription, boolean singleSelection) {
        this(elementDescription, singleSelection, false);
    }

    public ElementSelectorPanel(ElementNode.Description elementDescription, boolean singleSelection, boolean enableButtons) {
        this.setLayout(new BorderLayout());
        this.elementView = new CheckTreeView();
        this.elementView.setRootVisible(false);
        this.add((Component)((Object)this.elementView), "Center");
        this.setRootElement(elementDescription, singleSelection);
        Node root = this.manager.getRootContext();
        Node[] children = root.getChildren().getNodes();
        if (null != children && children.length > 0 && !elementDescription.hasSelection(true)) {
            try {
                this.manager.setSelectedNodes(new Node[]{children[0]});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (!singleSelection && this.hasMultipleSelectables(elementDescription)) {
            final JButton selectAll = new JButton();
            JButton selectNone = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)selectAll, (String)Bundle.BTN_SelectAll());
            Mnemonics.setLocalizedText((AbstractButton)selectNone, (String)Bundle.BTN_SelectNone());
            JPanel buttonPanel = new JPanel(new FlowLayout(0));
            buttonPanel.add(selectAll);
            buttonPanel.add(selectNone);
            this.add((Component)buttonPanel, "South");
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ElementSelectorPanel.this.selectAllNodes(e.getSource() == selectAll);
                }
            };
            selectAll.addActionListener(al);
            selectNone.addActionListener(al);
        }
    }

    private boolean hasMultipleSelectables(ElementNode.Description elementDescription) {
        ArrayDeque<ElementNode.Description> toProcess = new ArrayDeque<ElementNode.Description>();
        if (elementDescription != null) {
            toProcess.add(elementDescription);
        }
        boolean selectableFound = false;
        while (!toProcess.isEmpty()) {
            ElementNode.Description d = (ElementNode.Description)toProcess.poll();
            List<ElementNode.Description> subs = d.getSubs();
            if (subs == null) {
                if (!d.isSelectable()) continue;
                if (selectableFound) {
                    return true;
                }
                selectableFound = true;
                continue;
            }
            toProcess.addAll(subs);
        }
        return false;
    }

    private void selectAllNodes(boolean select) {
        boolean oldScroll = this.elementView.getScrollsOnExpand();
        this.elementView.setScrollsOnExpand(false);
        Node root = this.getExplorerManager().getRootContext();
        ArrayDeque<Node> toProcess = new ArrayDeque<Node>(Arrays.asList(root.getChildren().getNodes(true)));
        while (!toProcess.isEmpty()) {
            Node n = (Node)toProcess.poll();
            ElementNode.Description desc = ElementSelectorPanel.getDescription(n);
            if (desc == null) continue;
            if (desc.hasSelectableSubs()) {
                this.elementView.expandNode(n);
                toProcess.addAll(Arrays.asList(n.getChildren().getNodes(true)));
                continue;
            }
            if (!desc.isSelectable()) continue;
            desc.setSelected(select);
        }
        this.elementView.setScrollsOnExpand(oldScroll);
    }

    public List<ElementHandle<? extends Element>> getTreeSelectedElements() {
        ArrayList<ElementHandle<? extends Element>> handles = new ArrayList<ElementHandle<? extends Element>>();
        for (Node node : this.manager.getSelectedNodes()) {
            if (!(node instanceof ElementNode)) continue;
            ElementNode.Description description = (ElementNode.Description)node.getLookup().lookup(ElementNode.Description.class);
            handles.add(description.getElementHandle());
        }
        return handles;
    }

    public List<ElementHandle<? extends Element>> getSelectedElements() {
        ArrayList<ElementHandle<? extends Element>> handles = new ArrayList<ElementHandle<? extends Element>>();
        Node n = this.manager.getRootContext();
        ElementNode.Description description = (ElementNode.Description)n.getLookup().lookup(ElementNode.Description.class);
        this.getSelectedHandles(description, handles);
        return handles;
    }

    public void setRootElement(ElementNode.Description elementDescription, boolean singleSelection) {
        Object n;
        if (elementDescription != null) {
            ElementNode en = new ElementNode(elementDescription);
            en.setSingleSelection(singleSelection);
            n = en;
        } else {
            n = Node.EMPTY;
        }
        this.manager.setRootContext(n);
    }

    private static ElementNode.Description getDescription(Node n) {
        return (ElementNode.Description)n.getLookup().lookup(ElementNode.Description.class);
    }

    public void doInitialExpansion(int howMuch) {
        Node root = this.getExplorerManager().getRootContext();
        Node[] subNodes = root.getChildren().getNodes(true);
        if (subNodes == null) {
            return;
        }
        Node toSelect = null;
        int row = 0;
        boolean oldScroll = this.elementView.getScrollsOnExpand();
        this.elementView.setScrollsOnExpand(false);
        for (int i = 0; subNodes != null && i < (howMuch == -1 || howMuch > subNodes.length ? subNodes.length : howMuch); ++i) {
            this.elementView.expandNode(subNodes[i]);
            Node[] ssn = subNodes[i].getChildren().getNodes(true);
            row += ssn.length;
            if (toSelect != null || ssn.length <= 0) continue;
            toSelect = ssn[0];
        }
        Node toSelect2 = null;
        ArrayDeque<Node> toProcess = new ArrayDeque<Node>(Arrays.asList(subNodes));
        while (!toProcess.isEmpty()) {
            Node n = (Node)toProcess.poll();
            ElementNode.Description desc = ElementSelectorPanel.getDescription(n);
            if (desc == null) continue;
            if (desc.isSelected() && toSelect2 == null) {
                toSelect2 = n;
            }
            if (!desc.hasSelection(false)) continue;
            this.elementView.expandNode(n);
            toProcess.addAll(Arrays.asList(n.getChildren().getNodes(true)));
        }
        if (toSelect2 != null) {
            toSelect = toSelect2;
        }
        this.elementView.setScrollsOnExpand(oldScroll);
        try {
            if (toSelect != null) {
                this.getExplorerManager().setSelectedNodes(new Node[]{toSelect});
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void getSelectedHandles(ElementNode.Description description, ArrayList<ElementHandle<? extends Element>> target) {
        if (description == null) {
            return;
        }
        List<ElementNode.Description> subs = description.getSubs();
        if (subs == null) {
            return;
        }
        for (ElementNode.Description d : subs) {
            if (d.isSelectable() && d.isSelected()) {
                target.add(d.getElementHandle());
                continue;
            }
            this.getSelectedHandles(d, target);
        }
    }
}

