/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netbinox;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.osgi.launch.EquinoxFactory;
import org.netbeans.core.netigso.spi.NetigsoArchive;
import org.netbeans.modules.netbinox.Netbinox;
import org.netbeans.modules.netbinox.NetbinoxHooks;
import org.openide.util.Utilities;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class NetbinoxFactory
implements FrameworkFactory {
    static final Logger LOG = Logger.getLogger("org.netbeans.modules.netbinox");

    public Framework newFramework(Map map) {
        int exclaim;
        Object rawBundleMap;
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.putAll(map);
        configMap.put("org.osgi.framework.bundle.parent", "ext");
        configMap.put("osgi.hook.configurators.include", NetbinoxHooks.class.getName());
        String userArea = NetbinoxFactory.toFileURL(System.getProperty("netbeans.user"));
        configMap.put("osgi.user.area.default", userArea);
        configMap.put("osgi.user.area", userArea);
        configMap.put("osgi.instance.area", userArea);
        configMap.put("osgi.instance.area.default", userArea);
        String installArea = NetbinoxFactory.toFileURL(NetbinoxFactory.findInstallArea());
        LOG.log(Level.INFO, "Install area set to {0}", installArea);
        configMap.put("osgi.install.area", installArea);
        configMap.put("osgi.framework.properties", System.getProperty("netbeans.user"));
        configMap.put("eclipse.parsers.setTCCL", "false");
        configMap.put("org.osgi.framework.storage", NetbinoxFactory.toFileURL((String)map.get("org.osgi.framework.storage")));
        if (System.getProperty("osgi.locking") == null) {
            configMap.put("osgi.locking", "none");
        }
        Integer javaSpecificationMajorVersion = null;
        try {
            Object runtimeVersion = Runtime.class.getMethod("version", new Class[0]).invoke(null, new Object[0]);
            javaSpecificationMajorVersion = (int)((Integer)runtimeVersion.getClass().getMethod("major", new Class[0]).invoke(runtimeVersion, new Object[0]));
        }
        catch (ReflectiveOperationException ignore) {
            LOG.log(Level.FINE, "Failed to invoke Runtime#version or Runtime.Version#major to determine JavaSE major version", ignore);
        }
        if (javaSpecificationMajorVersion != null && javaSpecificationMajorVersion > 8) {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add("OSGi/Minimum-1.0");
            values.add("OSGi/Minimum-1.1");
            values.add("OSGi/Minimum-1.2");
            values.add("JavaSE/compact1-1.8");
            values.add("JavaSE/compact2-1.8");
            values.add("JavaSE/compact3-1.8");
            values.add("JRE-1.1");
            values.add("J2SE-1.2");
            values.add("J2SE-1.3");
            values.add("J2SE-1.4");
            values.add("J2SE-1.5");
            values.add("JavaSE-1.6");
            values.add("JavaSE-1.7");
            values.add("JavaSE-1.8");
            for (int i = 9; i <= javaSpecificationMajorVersion; ++i) {
                values.add("JavaSE-" + i);
            }
            configMap.put("org.osgi.framework.executionenvironment", values.stream().collect(Collectors.joining(", ")));
        }
        Map bundleMap = (rawBundleMap = configMap.get("felix.bootdelegation.classloaders")) == null ? null : (Map)rawBundleMap;
        NetbinoxHooks.registerMap(bundleMap);
        NetbinoxHooks.registerArchive((NetigsoArchive)configMap.get("netigso.archive"));
        String loc = EquinoxFactory.class.getProtectionDomain().getCodeSource().getLocation().toExternalForm();
        int file = loc.indexOf("file:");
        if (file > 0) {
            loc = loc.substring(file);
        }
        if ((exclaim = loc.indexOf("!")) > 0) {
            loc = loc.substring(0, exclaim);
        }
        configMap.put("osgi.framework", loc);
        return new Netbinox(configMap);
    }

    private static String findInstallArea() {
        String ia = System.getProperty("netbeans.home");
        LOG.log(Level.FINE, "Home is {0}", ia);
        String rest = System.getProperty("netbeans.dirs");
        if (rest != null) {
            for (String c : rest.split(File.pathSeparator)) {
                File cf = new File(c);
                if (!cf.isAbsolute() || !cf.exists()) {
                    LOG.log(Level.FINE, "Skipping non-existent {0}", c);
                    continue;
                }
                int prefix = NetbinoxFactory.findCommonPrefix(ia, c);
                if (prefix == ia.length()) {
                    LOG.log(Level.FINE, "No change to prefix by {0}", c);
                    continue;
                }
                if (prefix <= 3) {
                    LOG.log(Level.WARNING, "Cannot compute install area. No common prefix between {0} and {1}", new Object[]{ia, c});
                    continue;
                }
                LOG.log(Level.FINE, "Prefix shortened by {0} to {1} chars", new Object[]{c, prefix});
                ia = ia.substring(0, prefix);
                LOG.log(Level.FINE, "New prefix {0}", ia);
            }
        } else {
            LOG.fine("No dirs");
        }
        return ia;
    }

    static int findCommonPrefix(String s1, String s2) {
        if (Utilities.isWindows() || Utilities.isMac()) {
            s1 = s1.toUpperCase();
            s2 = s2.toUpperCase();
        }
        int len = Math.min(s1.length(), s2.length());
        int max = 0;
        for (int i = 0; i < len; ++i) {
            char ch = s1.charAt(i);
            if (ch != s2.charAt(i)) {
                return max;
            }
            if (ch != '/' && ch != File.separatorChar) continue;
            max = i + 1;
        }
        return len;
    }

    private static String toFileURL(String file) {
        if (file == null) {
            return null;
        }
        if (file.startsWith("file:")) {
            return file;
        }
        if (file.startsWith("/")) {
            return "file:" + file;
        }
        return "file:/" + file.replace(File.separatorChar, '/');
    }
}

