/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.cpu.SnapshotCPUView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.actions.CompareSnapshotsAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.TimelineView;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class TracerView {
    private final TracerModel model;
    private final TracerController controller;
    private LoadedSnapshot lsF;
    private TimelineView timelineView;
    private SnapshotView snapshotView;

    public TracerView(TracerModel model, TracerController controller) {
        this.model = model;
        this.controller = controller;
    }

    public JComponent createComponent() {
        final JPanel component = new JPanel(new BorderLayout());
        this.timelineView = new TimelineView(this.model);
        JPanel timelinePanel = new JPanel(new BorderLayout());
        timelinePanel.add((Component)this.timelineView.getView(), "Center");
        timelinePanel.add((Component)new JSeparator(), "South");
        final JPanel container = new JPanel(null){

            @Override
            public void doLayout() {
                Component[] components;
                for (Component component : components = this.getComponents()) {
                    component.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return this.getComponent(this.getComponentCount() - 1).getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getComponent(this.getComponentCount() - 1).getMinimumSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getComponent(this.getComponentCount() - 1).getMaximumSize();
            }

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        JPanel glass = new JPanel(null);
        glass.setOpaque(false);
        glass.setCursor(Cursor.getPredefinedCursor(3));
        glass.addMouseListener(new MouseAdapter(){});
        glass.addMouseMotionListener(new MouseMotionAdapter(){});
        glass.addKeyListener(new KeyAdapter(){});
        container.add(glass);
        container.add(timelinePanel);
        component.add((Component)container, "North");
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                TracerView.this.initProbes();
                TracerView.this.initTimeline();
                TracerView.this.initData(component, container);
                TracerView.this.initListeners(component);
            }
        });
        ActionMap map = component.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TracerView.this.snapshotView != null && TracerView.this.snapshotView.isShowing()) {
                    TracerView.this.snapshotView.getActionMap().get("filter-action-key").actionPerformed(e);
                }
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TracerView.this.snapshotView != null && TracerView.this.snapshotView.isShowing()) {
                    TracerView.this.snapshotView.getActionMap().get("find-action-key").actionPerformed(e);
                }
            }
        });
        return component;
    }

    private void initProbes() {
        List<TracerPackage> packages = TracerSupportImpl.getInstance().getPackages(this.model.getSnapshot());
        for (TracerPackage p : packages) {
            this.model.addDescriptors(p, p.getProbeDescriptors());
        }
    }

    private void initTimeline() {
        TimelineSupport support = this.model.getTimelineSupport();
        long start = this.model.firstTimestamp();
        if (start == -1L) {
            return;
        }
        long end = this.model.lastTimestamp();
        if (end == -1L) {
            return;
        }
        support.dataLoadingStarted(end - start);
    }

    private void initData(final JPanel component, final JPanel container) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JLabel progress = new JLabel(Bundle.MSG_LoadingSnapshot(), 0);
                progress.setCursor(Cursor.getPredefinedCursor(3));
                TracerView.this.addContents(component, progress);
                TracerSupportImpl.getInstance().perform(new Runnable(){

                    @Override
                    public void run() {
                        TracerView.this.controller.performSession();
                        TracerView.this.controller.performAfterSession(new Runnable(){

                            @Override
                            public void run() {
                                TimelineSupport support = TracerView.this.model.getTimelineSupport();
                                support.dataLoadingFinished();
                                support.selectAll();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        TracerView.this.timelineView.updateActions();
                                    }
                                });
                                component.remove(container);
                                component.add(container.getComponent(1), "North");
                                component.revalidate();
                                component.repaint();
                            }
                        });
                    }
                });
            }
        });
    }

    private void initListeners(final JPanel component) {
        final TimelineSupport support = this.model.getTimelineSupport();
        support.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void intervalsSelectionChanged() {
            }

            @Override
            public void indexSelectionChanged() {
                final int startIndex = Math.min(support.getStartIndex(), support.getEndIndex());
                final int endIndex = Math.max(support.getStartIndex(), support.getEndIndex());
                JLabel progress = new JLabel(Bundle.MSG_ProcessingSelection(), 0);
                TracerView.this.addContents(component, progress);
                TracerView.this.controller.performAfterSession(new Runnable(){

                    @Override
                    public void run() {
                        if (startIndex == endIndex) {
                            TracerView.this.displayThreadDump(component, startIndex);
                        } else {
                            TracerView.this.displaySnapshot(component, startIndex, endIndex);
                        }
                    }
                });
            }

            @Override
            public void timeSelectionChanged(boolean timestampsSelected, boolean justHovering) {
            }
        });
    }

    private void displaySnapshot(final JPanel p, int s1, int s2) {
        LoadedSnapshot ls = null;
        try {
            ls = this.model.getSnapshot().getCPUSnapshot(s1, s2);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.lsF = ls;
        if (this.lsF != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CPUResultsSnapshot s = (CPUResultsSnapshot)TracerView.this.lsF.getSnapshot();
                    if (TracerView.this.snapshotView == null) {
                        CompareSnapshotsAction aCompare = new CompareSnapshotsAction(TracerView.this.lsF);
                        ResultsManager.SnapshotHandle handle = new ResultsManager.SnapshotHandle(){

                            public LoadedSnapshot getSnapshot() {
                                return TracerView.this.lsF;
                            }
                        };
                        ExportUtils.Exportable exporter = ResultsManager.getDefault().createSnapshotExporter(handle);
                        TracerView.this.snapshotView = new SnapshotView(s, (Action)aCompare, exporter);
                        aCompare.setPerformer(new CompareSnapshotsAction.Performer(){

                            public void compare(LoadedSnapshot snapshot) {
                                TracerView.this.snapshotView.setRefSnapshot((CPUResultsSnapshot)snapshot.getSnapshot());
                            }
                        });
                    } else {
                        TracerView.this.snapshotView.setData(s);
                    }
                    TracerView.this.addContents(p, (JComponent)((Object)TracerView.this.snapshotView));
                }
            });
        }
    }

    private void displayThreadDump(final JPanel p, int s) {
        String td = null;
        try {
            td = this.model.getSnapshot().getThreadDump(s);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        final String tdF = td;
        if (tdF != null) {
            this.lsF = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HTMLTextArea a = new HTMLTextArea(tdF){

                        protected void showURL(URL url) {
                            if (url == null) {
                                return;
                            }
                            String urls = url.toString();
                            TracerView.this.showURL(urls);
                        }
                    };
                    a.setCaretPosition(0);
                    JScrollPane sp = new JScrollPane((Component)a);
                    sp.setBorder(BorderFactory.createEmptyBorder());
                    sp.setViewportBorder(BorderFactory.createEmptyBorder());
                    TracerView.this.addContents(p, sp);
                }
            });
        }
    }

    private void addContents(JComponent container, JComponent contents) {
        BorderLayout layout = (BorderLayout)container.getLayout();
        Component oldContents = layout.getLayoutComponent("Center");
        if (oldContents != contents) {
            if (oldContents != null) {
                container.remove(oldContents);
            }
            container.add((Component)contents, "Center");
            contents.requestFocusInWindow();
            container.revalidate();
            container.repaint();
        }
    }

    void showURL(String urls) {
        if (urls.startsWith("file:/stackframe/")) {
            urls = urls.substring("file:/stackframe/".length());
            String[] parts = urls.split("\\|");
            String className = parts[0];
            String method = parts[1];
            int linenumber = Integer.parseInt(parts[2]);
            GoToSource.openSource(null, (String)className, (String)method, (int)linenumber);
        }
    }

    private final class SnapshotView
    extends SnapshotCPUView {
        SnapshotView(CPUResultsSnapshot snapshot, Action compare, ExportUtils.Exportable exporter) {
            super(snapshot, true, null, compare, null, exporter);
        }

        void setData(CPUResultsSnapshot snapshot) {
            super.setSnapshot(snapshot, true);
        }

        protected boolean profileMethodEnabled() {
            return false;
        }

        protected boolean profileMethodSupported() {
            return ProfilerFeature.Registry.hasProviders();
        }

        protected boolean profileClassSupported() {
            return ProfilerFeature.Registry.hasProviders();
        }

        protected boolean showSourceSupported() {
            return GoToSource.isAvailable();
        }

        protected void showSource(ClientUtils.SourceCodeSelection value) {
            String className = value.getClassName();
            String methodName = value.getMethodName();
            String methodSig = value.getMethodSignature();
            GoToSource.openSource(null, (String)className, (String)methodName, (String)methodSig);
        }

        protected void selectForProfiling(final ClientUtils.SourceCodeSelection value) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    String name = "*".equals(value.getMethodName()) ? Bundle.LBL_ProfileClass() : Bundle.LBL_ProfileMethod();
                    ProfilerSession.findAndConfigure((Lookup)Lookups.fixed((Object[])new Object[]{value}), null, (String)name);
                }
            });
        }

        protected void customizeNodePopup(DataView invoker, JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
            if (value instanceof PrestimeCPUCCTNode) {
                popup.add(new FindMethodAction((PrestimeCPUCCTNode)value));
                popup.addSeparator();
            }
        }
    }

    private class FindMethodAction
    extends AbstractAction {
        private final PrestimeCPUCCTNode node;

        private FindMethodAction(PrestimeCPUCCTNode node) {
            super(Bundle.LBL_FindMethod());
            this.node = node;
            this.setEnabled(this.isRegular(node));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressHandle pHandle = null;
                    try {
                        pHandle = ProgressHandle.createHandle((String)Bundle.LBL_SelectingIntervals());
                        pHandle.setInitialDelay(0);
                        pHandle.start();
                        List<Integer> ints = TracerView.this.model.getIntervals(FindMethodAction.this.node);
                        assert (ints.size() % 2 == 0);
                        final Iterator<Integer> iter = ints.iterator();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TimelineSupport support = TracerView.this.model.getTimelineSupport();
                                support.resetSelectedIntervals();
                                while (iter.hasNext()) {
                                    int start = (Integer)iter.next();
                                    int stop = (Integer)iter.next();
                                    support.selectInterval(start, stop);
                                }
                                support.selectedIntervalsChanged();
                            }
                        });
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        if (pHandle != null) {
                            pHandle.finish();
                        }
                    }
                }
            });
        }

        private boolean isRegular(PrestimeCPUCCTNode n) {
            return n.getThreadId() != -1 && n.getMethodId() != 0 && !n.isFiltered();
        }
    }
}

