/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.wizards.Bundle;
import org.netbeans.modules.autoupdate.ui.wizards.InstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.OperationPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.netbeans.modules.autoupdate.ui.wizards.UninstallUnitWizardModel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

public class UninstallStep
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.wizards.UninstallStep");
    private OperationPanel panel;
    private PanelBodyContainer component;
    private UninstallUnitWizardModel model = null;
    private WizardDescriptor wd = null;
    private OperationSupport.Restarter restarter = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private boolean wasStored = false;
    private OperationSupport support;

    public UninstallStep(UninstallUnitWizardModel model) {
        this.model = model;
    }

    public boolean isFinishPanel() {
        return true;
    }

    public PanelBodyContainer getComponent() {
        if (this.component == null) {
            this.panel = new OperationPanel(false);
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("run-action".equals(evt.getPropertyName())) {
                        UninstallStep.this.doAction();
                    }
                }
            });
            switch (this.model.getOperation()) {
                case UNINSTALL: {
                    this.component = new PanelBodyContainer(Bundle.UninstallStep_Header_Uninstall_Head(), Bundle.UninstallStep_Header_Uninstall_Content(), this.panel);
                    break;
                }
                case ENABLE: {
                    this.component = new PanelBodyContainer(Bundle.UninstallStep_Header_Activate_Head(), Bundle.UninstallStep_Header_Activate_Content(), this.panel);
                    break;
                }
                case DISABLE: {
                    this.component = new PanelBodyContainer(Bundle.UninstallStep_Header_Deactivate_Head(), Bundle.UninstallStep_Header_Deactivate_Content(), this.panel);
                    break;
                }
                default: {
                    assert (false) : "Unknown OperationType " + this.model.getOperation();
                    break;
                }
            }
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
        }
        return this.component;
    }

    private void doAction() {
        try {
            OperationSupport.Restarter r = this.handleAction();
            if (r != null) {
                this.presentActionNeedsRestart(r);
            } else {
                this.presentActionDone();
            }
        }
        catch (OperationException ex) {
            this.presentActionFailed(ex);
        }
        this.fireChange();
    }

    private OperationSupport.Restarter handleAction() throws OperationException {
        assert (this.model.getBaseContainer() != null) : "getBaseContainers() returns not null container.";
        this.support = (OperationSupport)this.model.getBaseContainer().getSupport();
        assert (this.support != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
        if (this.support == null) {
            err.log(Level.WARNING, "OperationSupport cannot be null because OperationContainer contains elements: {0} and invalid elements {1}", new Object[]{this.model.getBaseContainer().listAll(), this.model.getBaseContainer().listInvalid()});
            if (!this.model.getBaseContainer().listInvalid().isEmpty()) {
                throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL, Bundle.UninstallStep_NullSupport_InvalidElements(this.model.getBaseContainer().listInvalid()));
            }
            if (this.model.getBaseContainer().listAll().isEmpty()) {
                throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL, Bundle.UninstallStep_NullSupport_NullElements());
            }
            throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL, "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid());
        }
        ProgressHandle handle = null;
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                handle = ProgressHandle.createHandle((String)Bundle.UninstallStep_ProgressName_Uninstall());
                break;
            }
            case ENABLE: {
                handle = ProgressHandle.createHandle((String)Bundle.UninstallStep_ProgressName_Activate());
                break;
            }
            case DISABLE: {
                handle = ProgressHandle.createHandle((String)Bundle.UninstallStep_ProgressName_Deactivate());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + this.model.getOperation();
                break;
            }
        }
        JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
        JLabel mainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
        JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        this.model.modifyOptionsForDisabledCancel(this.wd);
        this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, detailLabel);
        OperationSupport.Restarter r = null;
        try {
            r = this.support.doOperation(handle);
            this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(Bundle.UninstallStep_Done()));
        }
        catch (OperationException ex) {
            err.log(Level.INFO, ex.getMessage(), ex);
            this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(Bundle.UninstallStep_Failed(ex.getLocalizedMessage())));
            throw ex;
        }
        return r;
    }

    private void presentActionDone() {
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.component.setHeadAndContent(Bundle.UninstallStep_Header_UninstallDone_Head(), Bundle.UninstallStep_Header_UninstallDone_Content());
                break;
            }
            case ENABLE: {
                this.component.setHeadAndContent(Bundle.UninstallStep_Header_ActivateDone_Head(), Bundle.UninstallStep_Header_ActivateDone_Content());
                break;
            }
            case DISABLE: {
                this.component.setHeadAndContent(Bundle.UninstallStep_Header_DeactivateDone_Head(), Bundle.UninstallStep_Header_DeactivateDone_Content());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + this.model.getOperation();
                break;
            }
        }
        this.model.modifyOptionsForDoClose(this.wd);
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.panel.setBody(Bundle.UninstallStep_UninstallDone_Text(), this.model.getAllVisibleUpdateElements());
                break;
            }
            case ENABLE: {
                this.panel.setBody(Bundle.UninstallStep_ActivateDone_Text(), this.model.getAllVisibleUpdateElements());
                break;
            }
            case DISABLE: {
                this.panel.setBody(Bundle.UninstallStep_DeactivateDone_Text(), this.model.getAllVisibleUpdateElements());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + this.model.getOperation();
                break;
            }
        }
    }

    private void presentActionFailed(OperationException ex) {
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.component.setHeadAndContent(Bundle.UninstallStep_Header_UninstallFailed_Head(), Bundle.UninstallStep_Header_UninstallFailed_Content());
                break;
            }
            case ENABLE: {
                this.component.setHeadAndContent(Bundle.UninstallStep_Header_ActivateFailed_Head(), Bundle.UninstallStep_Header_ActivateFailed_Content());
                break;
            }
            case DISABLE: {
                this.component.setHeadAndContent(Bundle.UninstallStep_Header_DeactivateFailed_Head(), Bundle.UninstallStep_Header_DeactivateFailed_Content());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + this.model.getOperation();
                break;
            }
        }
        this.model.modifyOptionsForFailed(this.wd);
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.panel.setBody("", Bundle.UninstallStep_UninstallFailed_Text(ex.getLocalizedMessage()));
                break;
            }
            case ENABLE: {
                this.panel.setBody("", Bundle.UninstallStep_ActivateFailed_Text(ex.getLocalizedMessage()));
                break;
            }
            case DISABLE: {
                this.panel.setBody("", Bundle.UninstallStep_DeactivateFailed_Text(ex.getLocalizedMessage()));
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + this.model.getOperation();
                break;
            }
        }
    }

    private void presentActionNeedsRestart(OperationSupport.Restarter r) {
        if (this.model.getOperation() == OperationWizardModel.OperationType.ENABLE) {
            this.component.setHeadAndContent(Bundle.UninstallStep_Activate_Header_Restart_Head(), Bundle.UninstallStep_Activate_Header_Restart_Content());
        } else {
            this.component.setHeadAndContent(Bundle.UninstallStep_Header_Restart_Head(), Bundle.UninstallStep_Header_Restart_Content());
        }
        this.model.modifyOptionsForDoClose(this.wd, true);
        this.restarter = r;
        this.panel.setRestartButtonsVisible(true);
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.panel.setBody(Bundle.UninstallStep_UninstallLater_Text(), this.model.getAllVisibleUpdateElements());
                break;
            }
            case ENABLE: {
                this.panel.setBody(Bundle.UninstallStep_ActivateLater_Text(), this.model.getAllVisibleUpdateElements());
                break;
            }
            case DISABLE: {
                this.panel.setBody(Bundle.UninstallStep_UninstallLater_Text(), this.model.getAllVisibleUpdateElements());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + this.model.getOperation();
                break;
            }
        }
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wd) {
        this.wd = wd;
        this.wasStored = false;
    }

    public void storeSettings(WizardDescriptor wd) {
        assert (!WizardDescriptor.PREVIOUS_OPTION.equals(wd.getValue())) : "Cannot invoke Back in this case.";
        if (this.wasStored) {
            return;
        }
        this.wasStored = true;
        if (WizardDescriptor.CANCEL_OPTION.equals(wd.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wd.getValue())) {
            try {
                this.model.doCleanup(true);
            }
            catch (OperationException x) {
                Logger.getLogger(UninstallStep.class.getName()).log(Level.INFO, x.getMessage(), x);
            }
        } else if (this.restarter != null) {
            assert (this.support != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
            if (this.support == null) {
                err.log(Level.INFO, "OperationSupport cannot be null because OperationContainer contains elements: {0} and invalid elements {1}", new Object[]{this.model.getBaseContainer().listAll(), this.model.getBaseContainer().listInvalid()});
                try {
                    this.model.doCleanup(true);
                }
                catch (OperationException x) {
                    Logger.getLogger(UninstallStep.class.getName()).log(Level.INFO, x.getMessage(), x);
                }
            }
            if (this.panel.restartNow()) {
                try {
                    this.support.doRestart(this.restarter, null);
                }
                catch (OperationException x) {
                    err.log(Level.INFO, x.getMessage(), x);
                }
            } else {
                this.support.doRestartLater(this.restarter);
                try {
                    this.model.doCleanup(false);
                }
                catch (OperationException x) {
                    err.log(Level.INFO, x.getMessage(), x);
                }
                Runnable onMouseClick = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UninstallStep.this.support.doRestart(UninstallStep.this.restarter, null);
                        }
                        catch (OperationException x) {
                            err.log(Level.INFO, x.getMessage(), x);
                        }
                    }
                };
                InstallStep.notifyRestartNeeded(onMouseClick, Bundle.UninstallSupport_RestartNeeded());
            }
        } else {
            try {
                this.model.doCleanup(!WizardDescriptor.FINISH_OPTION.equals(wd.getValue()));
            }
            catch (OperationException x) {
                err.log(Level.INFO, x.getMessage(), x);
            }
        }
    }

    public boolean isValid() {
        return true;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> templist;
        ChangeEvent e = new ChangeEvent(this);
        UninstallStep uninstallStep = this;
        synchronized (uninstallStep) {
            templist = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : templist) {
            l.stateChanged(e);
        }
    }
}

