/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.util.PListReader;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.dlg.AddTableColumnDialog;
import org.netbeans.modules.db.explorer.dlg.ColumnItem;
import org.netbeans.modules.db.explorer.dlg.CreateTableDDL;
import org.netbeans.modules.db.explorer.dlg.DataModel;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CreateTableDialog {
    Dialog dialog = null;
    JTextField dbnamefield;
    JTextField dbownerfield;
    JTable table;
    JButton addbtn;
    JButton delbtn;
    JButton editBtn;
    JButton upBtn;
    JButton downBtn;
    Specification spec;
    private final BaseNode tablesNode;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport statusLine;
    private static Map dlgtab = null;
    private static final String filename = "org/netbeans/modules/db/resources/CreateTableDialog.plist";
    private static final Logger LOGGER = Logger.getLogger(CreateTableDialog.class.getName());

    public static Map getProperties() {
        if (dlgtab == null) {
            try {
                ClassLoader cl = CreateTableDialog.class.getClassLoader();
                InputStream stream = cl.getResourceAsStream(filename);
                if (stream == null) {
                    String message = NbBundle.getMessage(CreateTableDialog.class, (String)"EXC_UnableToOpenStream", (Object)filename);
                    throw new Exception(message);
                }
                PListReader reader = new PListReader(stream);
                dlgtab = reader.getData();
                stream.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                dlgtab = null;
            }
        }
        return dlgtab;
    }

    public CreateTableDialog(BaseNode node, final String schema) {
        DatabaseConnection connection = (DatabaseConnection)node.getLookup().lookup(DatabaseConnection.class);
        this.spec = connection.getConnector().getDatabaseSpecification();
        this.tablesNode = node;
        try {
            JPanel pane = new JPanel();
            pane.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constr = new GridBagConstraints();
            pane.setLayout(layout);
            pane.setMinimumSize(new Dimension(200, 100));
            JLabel label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableName"));
            label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableNameA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 0;
            layout.setConstraints(label, constr);
            pane.add(label);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.weighty = 0.0;
            constr.gridx = 1;
            constr.gridy = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            this.dbnamefield = new JTextField(this.getTableUntitledName(), 10);
            this.dbnamefield.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableNameTextFieldA11yDesc"));
            this.dbnamefield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableNameTextFieldA11yName"));
            label.setLabelFor(this.dbnamefield);
            layout.setConstraints(this.dbnamefield, constr);
            pane.add(this.dbnamefield);
            this.dbnamefield.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CreateTableDialog.this.validate();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CreateTableDialog.this.validate();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    CreateTableDialog.this.validate();
                }
            });
            constr.fill = 1;
            constr.weightx = 1.0;
            constr.weighty = 1.0;
            constr.gridx = 0;
            constr.gridy = 1;
            constr.gridwidth = 4;
            constr.gridheight = 3;
            constr.insets = new Insets(2, 2, 2, 2);
            this.table = new DataTable(new DataModel());
            this.table.setAutoResizeMode(0);
            this.table.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableColumnTableA11yDesc"));
            this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableColumnTableA11yName"));
            this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableColumnTableA11yDesc"));
            JScrollPane scrollpane = new JScrollPane(this.table);
            scrollpane.setBorder(new BevelBorder(1));
            layout.setConstraints(scrollpane, constr);
            pane.add(scrollpane);
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        CreateTableDialog.this.editBtn.doClick();
                    }
                }
            });
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    CreateTableDialog.this.validate();
                }
            });
            this.table.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    CreateTableDialog.this.validate();
                }
            });
            constr.fill = 2;
            constr.anchor = 11;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            constr.gridx = 4;
            constr.gridy = 1;
            constr.insets = new Insets(2, 8, 2, 2);
            JPanel btnpane = new JPanel();
            GridLayout btnlay = new GridLayout(5, 1, 0, 5);
            btnpane.setLayout(btnlay);
            layout.setConstraints(btnpane, constr);
            pane.add(btnpane);
            this.addbtn = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.addbtn, (String)NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableAddButtonTitle"));
            this.addbtn.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableAddButtonTitleA11yDesc"));
            btnpane.add(this.addbtn);
            this.addbtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ColumnItem columnItem = AddTableColumnDialog.showDialog(CreateTableDialog.this.spec, null);
                    if (columnItem != null) {
                        DataModel model = (DataModel)CreateTableDialog.this.table.getModel();
                        model.addRow(columnItem);
                    }
                }
            });
            this.editBtn = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.editBtn, (String)NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableEditButtonTitle"));
            this.editBtn.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableEditButtonTitleA11yDesc"));
            btnpane.add(this.editBtn);
            this.editBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ColumnItem selectedColumnItem;
                    ColumnItem columnItemModified;
                    int selectedIndex = CreateTableDialog.this.table.getSelectedRow();
                    if (selectedIndex != -1 && (columnItemModified = AddTableColumnDialog.showDialog(CreateTableDialog.this.spec, selectedColumnItem = ((DataModel)CreateTableDialog.this.table.getModel()).getRow(selectedIndex))) != null) {
                        DataModel model = (DataModel)CreateTableDialog.this.table.getModel();
                        model.removeRow(selectedIndex);
                        model.insertRow(selectedIndex, columnItemModified);
                    }
                }
            });
            this.delbtn = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.delbtn, (String)NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableRemoveButtonTitle"));
            this.delbtn.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableRemoveButtonTitleA11yDesc"));
            btnpane.add(this.delbtn);
            this.delbtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    int idx = CreateTableDialog.this.table.getSelectedRow();
                    if (idx != -1) {
                        ((DataModel)CreateTableDialog.this.table.getModel()).removeRow(idx);
                    }
                }
            });
            this.upBtn = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.upBtn, (String)NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableUpButtonTitle"));
            this.upBtn.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableUpButtonTitleA11yDesc"));
            btnpane.add(this.upBtn);
            this.upBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    int idx = CreateTableDialog.this.table.getSelectedRow();
                    if (idx > 0) {
                        DataModel dm = (DataModel)CreateTableDialog.this.table.getModel();
                        ColumnItem ci = dm.getRow(idx);
                        dm.removeRow(idx);
                        dm.insertRow(idx - 1, ci);
                        CreateTableDialog.this.table.getSelectionModel().setSelectionInterval(idx - 1, idx - 1);
                    }
                }
            });
            this.downBtn = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.downBtn, (String)NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableDownButtonTitle"));
            this.downBtn.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableDownButtonTitleA11yDesc"));
            btnpane.add(this.downBtn);
            this.downBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    int idx = CreateTableDialog.this.table.getSelectedRow();
                    if (idx < CreateTableDialog.this.table.getRowCount() - 1) {
                        DataModel dm = (DataModel)CreateTableDialog.this.table.getModel();
                        ColumnItem ci = dm.getRow(idx);
                        dm.removeRow(idx);
                        dm.insertRow(idx + 1, ci);
                        CreateTableDialog.this.table.getSelectionModel().setSelectionInterval(idx + 1, idx + 1);
                    }
                }
            });
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ActionEvent evt = event;
                    if (evt.getSource() == DialogDescriptor.OK_OPTION) {
                        try {
                            final String tablename = CreateTableDialog.this.getTableName();
                            final DataModel dataModel = (DataModel)CreateTableDialog.this.table.getModel();
                            final List data = dataModel.getData();
                            boolean wasException = DbUtilities.doWithProgress(null, new Callable<Boolean>(){

                                @Override
                                public Boolean call() throws Exception {
                                    CreateTableDDL ddl = new CreateTableDDL(CreateTableDialog.this.spec, schema, tablename);
                                    return ddl.execute(data, dataModel.getTablePrimaryKeys());
                                }
                            });
                            if (!wasException) {
                                CreateTableDialog.this.dialog.setVisible(false);
                                CreateTableDialog.this.dialog.dispose();
                            }
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof DDLException) {
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                            }
                            LOGGER.log(Level.INFO, cause.getLocalizedMessage(), cause);
                            DbUtilities.reportError(NbBundle.getMessage(CreateTableDialog.class, (String)"ERR_UnableToCreateTable"), e.getMessage());
                        }
                    }
                }
            };
            pane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableDialogA11yDesc"));
            this.descriptor = new DialogDescriptor((Object)pane, NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableDialogTitle"), true, listener);
            this.descriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.db.explorer.actions.CreateTableAction"));
            this.statusLine = this.descriptor.createNotificationLineSupport();
            Object[] closingOptions = new Object[]{DialogDescriptor.CANCEL_OPTION};
            this.descriptor.setClosingOptions(closingOptions);
            this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
            this.dialog.setResizable(true);
            this.validate();
        }
        catch (MissingResourceException ex) {
            LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public static boolean showDialogAndCreate(BaseNode node, String schema) {
        CreateTableDialog dlg = new CreateTableDialog(node, schema);
        dlg.dialog.setVisible(true);
        return dlg.descriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    private String getTableUntitledName() {
        boolean existsSameTableName;
        String nameBase = NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableUntitledName");
        Object name = nameBase;
        int counter = 1;
        do {
            existsSameTableName = false;
            for (Node node : this.tablesNode.getChildNodes()) {
                if (!(node instanceof TableNode) || !node.getName().equalsIgnoreCase((String)name)) continue;
                name = nameBase + ++counter;
                existsSameTableName = true;
            }
        } while (existsSameTableName);
        return name;
    }

    private String getTableName() {
        return this.dbnamefield.getText();
    }

    private void validate() {
        assert (this.statusLine != null) : "Notification status line not available";
        int selectedIndex = this.table.getSelectedRow();
        boolean oneRowSelected = this.table.getSelectedRowCount() == 1;
        this.editBtn.setEnabled(oneRowSelected);
        this.delbtn.setEnabled(oneRowSelected);
        this.upBtn.setEnabled(oneRowSelected && selectedIndex > 0);
        this.downBtn.setEnabled(oneRowSelected && selectedIndex < this.table.getRowCount() - 1);
        String tname = this.getTableName();
        if (tname == null || tname.length() < 1) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableMissingTableName"));
            this.updateOK(false);
            return;
        }
        if (this.table.getModel().getRowCount() == 0) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableNoColumns"));
            this.updateOK(false);
            return;
        }
        this.statusLine.clearMessages();
        this.updateOK(true);
    }

    private void updateOK(boolean valid) {
        if (this.descriptor != null) {
            this.descriptor.setValid(valid);
        }
    }

    class DataTable
    extends JTable {
        static final long serialVersionUID = 1222037401669064863L;

        public DataTable(TableModel model) {
            super(model);
            this.setSurrendersFocusOnKeystroke(true);
            TableColumnModel cmodel = this.getColumnModel();
            int ccount = model.getColumnCount();
            int width = 0;
            for (int i = 0; i < ccount; ++i) {
                TableColumn col = cmodel.getColumn(i);
                Map cmap = ColumnItem.getColumnProperty(i);
                col.setIdentifier(cmap.get("name"));
                String columnName = NbBundle.getMessage(CreateTableDialog.class, (String)("CreateTable_" + i));
                int columnWidth = (int)this.getFontMetrics(this.getFont()).getStringBounds(columnName, this.getGraphics()).getWidth() + 20;
                if (cmap.containsKey("width")) {
                    if ((Integer)cmap.get("width") < columnWidth) {
                        col.setPreferredWidth(columnWidth);
                    } else {
                        col.setPreferredWidth((Integer)cmap.get("width"));
                    }
                    int n = col.getPreferredWidth();
                }
                if (cmap.containsKey("minwidth")) {
                    if ((Integer)cmap.get("minwidth") < columnWidth) {
                        col.setMinWidth(columnWidth);
                    } else {
                        col.setMinWidth((Integer)cmap.get("minwidth"));
                    }
                }
                if (i >= 7) continue;
                width += col.getPreferredWidth();
            }
            width = Math.min(Math.max(width, 380), Toolkit.getDefaultToolkit().getScreenSize().width - 100);
            this.setPreferredScrollableViewportSize(new Dimension(width, 150));
        }
    }
}

