/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorResumeNextNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSAsyncGeneratorObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayDeque;

public class AsyncGeneratorEnqueueNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSFunctionCallNode callPromiseRejectNode;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapabilityNode;
    @Node.Child
    private AsyncGeneratorResumeNextNode asyncGeneratorResumeNextNode;
    private final ConditionProfile notExecutingProf = ConditionProfile.create();

    protected AsyncGeneratorEnqueueNode(JSContext context) {
        this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
        this.asyncGeneratorResumeNextNode = AsyncGeneratorResumeNextNode.create(context);
    }

    protected AsyncGeneratorEnqueueNode(JSContext context, AsyncGeneratorResumeNextNode impl) {
        this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
        this.asyncGeneratorResumeNextNode = impl;
    }

    public static AsyncGeneratorEnqueueNode create(JSContext context) {
        return new AsyncGeneratorEnqueueNode(context);
    }

    public static AsyncGeneratorEnqueueNode create(JSContext context, AsyncGeneratorResumeNextNode impl) {
        return new AsyncGeneratorEnqueueNode(context, impl);
    }

    public Object execute(VirtualFrame frame, Object generator, Completion completion) {
        JSAsyncGeneratorObject asyncGeneratorObject;
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        if (!(generator instanceof JSAsyncGeneratorObject) || (asyncGeneratorObject = (JSAsyncGeneratorObject)((Object)generator)).hasGeneratorBrand()) {
            this.enterErrorBranch();
            return this.badGeneratorError(promiseCapability);
        }
        assert (asyncGeneratorObject.getAsyncGeneratorContext() != null);
        ArrayDeque<AsyncGeneratorRequest> queue = asyncGeneratorObject.getAsyncGeneratorQueue();
        AsyncGeneratorRequest request = AsyncGeneratorRequest.create(completion, promiseCapability);
        Boundaries.queueAdd(queue, request);
        JSFunction.AsyncGeneratorState state = asyncGeneratorObject.getAsyncGeneratorState();
        if (this.notExecutingProf.profile(state != JSFunction.AsyncGeneratorState.Executing)) {
            this.asyncGeneratorResumeNextNode.execute(frame, asyncGeneratorObject);
        }
        return promiseCapability.getPromise();
    }

    private PromiseCapabilityRecord newPromiseCapability() {
        return this.newPromiseCapabilityNode.executeDefault();
    }

    private void enterErrorBranch() {
        if (this.callPromiseRejectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callPromiseRejectNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
    }

    private Object badGeneratorError(PromiseCapabilityRecord promiseCapability) {
        Object badGeneratorError = Errors.createTypeErrorAsyncGeneratorObjectExpected().getErrorObject();
        Object reject = promiseCapability.getReject();
        this.callPromiseRejectNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, reject, badGeneratorError));
        return promiseCapability.getPromise();
    }
}

