/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.BorderFactory;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipAware;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;

public class JExtendedTree
extends JTree
implements CellTipAware {
    protected JToolTip cellTip;
    protected Rectangle rendererRect;
    protected TreePath lastTreePath = null;
    private PrivateComponentListener componentListener = new PrivateComponentListener();

    public JExtendedTree() {
        this.addMouseListener(this.componentListener);
        this.addMouseMotionListener(this.componentListener);
        this.setRowHeight(UIUtils.getDefaultRowHeight());
        this.cellTip = this.createCellTip();
        this.cellTip.setBackground(this.getBackground());
        this.cellTip.setBorder(BorderFactory.createLineBorder(UIConstants.TABLE_VERTICAL_GRID_COLOR));
        this.cellTip.setLayout(new BorderLayout());
        CellTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public JToolTip getCellTip() {
        return this.cellTip;
    }

    @Override
    public Point getCellTipLocation() {
        if (this.rendererRect == null) {
            return null;
        }
        return new Point(this.rendererRect.getLocation().x - 1, this.rendererRect.getLocation().y - 1);
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (e instanceof MouseWheelEvent) {
            Container target = this.getParent();
            if (!(target instanceof JViewport)) {
                target = this;
            }
            MouseEvent mwe = SwingUtilities.convertMouseEvent(this, (MouseWheelEvent)e, target);
            target.dispatchEvent((MouseWheelEvent)mwe);
        } else {
            super.processMouseEvent(e);
        }
    }

    protected JToolTip createCellTip() {
        return new JToolTip();
    }

    protected void processCellTipMouseMove(MouseEvent e) {
        TreePath currentTreePath = this.getPathForLocation(e.getX(), e.getY());
        if (currentTreePath == this.lastTreePath) {
            return;
        }
        this.lastTreePath = currentTreePath;
        if (this.lastTreePath == null) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        int row = this.getRowForPath(this.lastTreePath);
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (!(treeCellRenderer instanceof TreeCellRendererPersistent)) {
            return;
        }
        Component cellRenderer = treeCellRenderer.getTreeCellRendererComponent(this, this.lastTreePath.getLastPathComponent(), false, this.isExpanded(row), this.getModel().isLeaf(this.lastTreePath.getLastPathComponent()), row, false);
        Component cellRendererPersistent = ((TreeCellRendererPersistent)treeCellRenderer).getTreeCellRendererComponentPersistent(this, this.lastTreePath.getLastPathComponent(), false, this.isExpanded(row), this.getModel().isLeaf(this.lastTreePath.getLastPathComponent()), row, false);
        if (cellRenderer == null) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        Point cellStart = this.getPathBounds(this.lastTreePath).getLocation();
        this.rendererRect = new Rectangle(cellStart.x, cellStart.y, cellRenderer.getPreferredSize().width, cellRenderer.getPreferredSize().height + 2);
        if (!this.rendererRect.contains(e.getPoint())) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        Rectangle visibleRect = this.getVisibleRect();
        if (this.rendererRect.x >= visibleRect.x && this.rendererRect.x + this.rendererRect.width <= visibleRect.x + visibleRect.width) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        while (this.cellTip.getComponentCount() > 0) {
            this.cellTip.remove(0);
        }
        this.cellTip.add(cellRendererPersistent, "Center");
        this.cellTip.setPreferredSize(new Dimension(cellRendererPersistent.getPreferredSize().width + 2, this.getRowHeight() + 2));
        CellTipManager.sharedInstance().setEnabled(true);
    }

    private class PrivateComponentListener
    implements MouseListener,
    MouseMotionListener {
        private PrivateComponentListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            CellTipManager.sharedInstance().setEnabled(false);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (JExtendedTree.this.contains(e.getPoint()) && JExtendedTree.this.cellTip.isShowing()) {
                return;
            }
            CellTipManager.sharedInstance().setEnabled(false);
            JExtendedTree.this.lastTreePath = null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JExtendedTree.this.processCellTipMouseMove(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

