/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.actions;

import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.RenameAction;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class RenameGroupAction
extends RenameAction {
    protected void performAction(Node[] nodes) {
        if (nodes != null && nodes.length == 1) {
            SaasGroup group = (SaasGroup)nodes[0].getLookup().lookup(SaasGroup.class);
            if (group == null) {
                return;
            }
            Node n = nodes[0];
            NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine(NbBundle.getMessage(RenameAction.class, (String)"CTL_RenameLabel"), NbBundle.getMessage(RenameAction.class, (String)"CTL_RenameTitle"));
            dlg.setInputText(n.getName());
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg))) {
                String name = dlg.getInputText().trim();
                if (group.getParent().getChildGroup(name) != null) {
                    String msg = NbBundle.getMessage(RenameGroupAction.class, (String)"MSG_DuplicateGroupName");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                    return;
                }
                SaasServicesModel.getInstance().renameGroup(group, name);
                n.setName(name);
            }
        }
    }
}

