/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.xml.text.indent.XMLFormatSupport;
import org.netbeans.modules.xml.text.syntax.javacc.lib.JJEditorSyntax;

public class DTDFormatter
extends ExtFormatter {
    public DTDFormatter(Class kitClass) {
        super(kitClass);
    }

    public FormatSupport createFormatSupport(FormatWriter fw) {
        return new XMLFormatSupport(fw);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JJEditorSyntax;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indentNewLine(Document doc, int offset) {
        if (doc instanceof BaseDocument) {
            BaseDocument bdoc = (BaseDocument)doc;
            bdoc.atomicLock();
            try {
                bdoc.insertString(offset, "\n", null);
                int fullLine = LineDocumentUtils.getPreviousNonWhitespace((LineDocument)bdoc, (int)(++offset - 1));
                int indent = Utilities.getRowIndent((BaseDocument)bdoc, (int)fullLine);
                String indentation = this.getIndentString(bdoc, indent);
                bdoc.insertString(offset, indentation, null);
                offset += indentation.length();
            }
            catch (BadLocationException e) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    e.printStackTrace();
                }
            }
            finally {
                bdoc.atomicUnlock();
            }
            return offset;
        }
        return super.indentNewLine(doc, offset);
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("xml-strip-whitespace-at-line-end-layer");
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new XMLFormatSupport(fw);
        }

        public void format(FormatWriter fw) {
            FormatTokenPosition pos;
            XMLFormatSupport xfs = (XMLFormatSupport)this.createFormatSupport(fw);
            if (xfs.isLineStart(pos = xfs.getFormatStartPosition()) && !xfs.isIndentOnly()) {
                while (pos.getToken() != null) {
                    if ((pos = xfs.removeLineEndWhitespace(pos)).getToken() == null) continue;
                    pos = xfs.getNextPosition(pos);
                }
            }
        }
    }
}

