/*
Package wrapperunionoc is a generated package which contains definitions
of structs which represent a YANG schema. The generated schema can be
compressed by a series of transformations (compression was true
in this case).

NOTE WELL: This is an example code file that is distributed with ygot.
It should not be used within your application, as it WILL change,
without warning. Rather, you should generate structs directly from
OpenConfig models using the ygot package.

NOTE WELL: This is an example code file that is distributed with ygot.
It should not be used within your application, as it WILL change,
without warning. Rather, you should generate structs directly from
OpenConfig models using the ygot package.

This package was generated by github.com/openconfig/ygot
using the following YANG input files:
  - public/release/models/network-instance/openconfig-network-instance.yang
  - public/release/models/optical-transport/openconfig-optical-amplifier.yang
  - public/release/models/optical-transport/openconfig-terminal-device.yang
  - public/release/models/optical-transport/openconfig-transport-line-protection.yang
  - public/release/models/platform/openconfig-platform.yang
  - public/release/models/policy/openconfig-routing-policy.yang
  - public/release/models/lacp/openconfig-lacp.yang
  - public/release/models/system/openconfig-system.yang
  - public/release/models/stp/openconfig-spanning-tree.yang
  - public/release/models/interfaces/openconfig-interfaces.yang
  - public/release/models/interfaces/openconfig-if-ip.yang
  - public/release/models/interfaces/openconfig-if-aggregate.yang
  - public/release/models/interfaces/openconfig-if-ethernet.yang
  - public/release/models/interfaces/openconfig-if-ip-ext.yang
  - public/release/models/relay-agent/openconfig-relay-agent.yang
  - public/release/models/lldp/openconfig-lldp.yang

Imported modules were sourced from:
  - public/...
  - deps/...
*/
package wrapperunionoc

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/ygot/ytypes"
)

// Binary is a type that is used for fields that have a YANG type of
// binary. It is used such that binary fields can be distinguished from
// leaf-lists of uint8s (which are mapped to []uint8, equivalent to
// []byte in reflection).
type Binary []byte

// YANGEmpty is a type that is used for fields that have a YANG type of
// empty. It is used such that empty fields can be distinguished from boolean fields
// in the generated code.
type YANGEmpty bool

var (
	SchemaTree map[string]*yang.Entry
	ΛEnumTypes map[string][]reflect.Type
)

func init() {
	var err error
	initΛEnumTypes()
	if SchemaTree, err = UnzipSchema(); err != nil {
		panic("schema error: " + err.Error())
	}
}

// Schema returns the details of the generated schema.
func Schema() (*ytypes.Schema, error) {
	uzp, err := UnzipSchema()
	if err != nil {
		return nil, fmt.Errorf("cannot unzip schema, %v", err)
	}

	return &ytypes.Schema{
		Root:       &Device{},
		SchemaTree: uzp,
		Unmarshal:  Unmarshal,
	}, nil
}

// UnzipSchema unzips the zipped schema and returns a map of yang.Entry nodes,
// keyed by the name of the struct that the yang.Entry describes the schema for.
func UnzipSchema() (map[string]*yang.Entry, error) {
	var schemaTree map[string]*yang.Entry
	var err error
	if schemaTree, err = ygot.GzipToSchema(ySchema); err != nil {
		return nil, fmt.Errorf("could not unzip the schema; %v", err)
	}
	return schemaTree, nil
}

// Unmarshal unmarshals data, which must be RFC7951 JSON format, into
// destStruct, which must be non-nil and the correct GoStruct type. It returns
// an error if the destStruct is not found in the schema or the data cannot be
// unmarshaled. The supplied options (opts) are used to control the behaviour
// of the unmarshal function - for example, determining whether errors are
// thrown for unknown fields in the input JSON.
func Unmarshal(data []byte, destStruct ygot.GoStruct, opts ...ytypes.UnmarshalOpt) error {
	tn := reflect.TypeOf(destStruct).Elem().Name()
	schema, ok := SchemaTree[tn]
	if !ok {
		return fmt.Errorf("could not find schema for type %s", tn)
	}
	var jsonTree interface{}
	if err := json.Unmarshal([]byte(data), &jsonTree); err != nil {
		return err
	}
	return ytypes.Unmarshal(schema, destStruct, jsonTree, opts...)
}

// Acl represents the /openconfig-acl/acl YANG schema element.
type Acl struct {
	ΛMetadata          []ygot.Annotation              `path:"@" ygotAnnotation:"true"`
	AclSet             map[Acl_AclSet_Key]*Acl_AclSet `path:"acl-sets/acl-set" module:"openconfig-acl/openconfig-acl"`
	ΛAclSet            []ygot.Annotation              `path:"acl-sets/@acl-set" ygotAnnotation:"true"`
	CounterCapability  E_Acl_ACL_COUNTER_CAPABILITY   `path:"state/counter-capability" module:"openconfig-acl/openconfig-acl"`
	ΛCounterCapability []ygot.Annotation              `path:"state/@counter-capability" ygotAnnotation:"true"`
	Interface          map[string]*Acl_Interface      `path:"interfaces/interface" module:"openconfig-acl/openconfig-acl"`
	ΛInterface         []ygot.Annotation              `path:"interfaces/@interface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl) IsYANGGoStruct() {}

// Acl_AclSet_Key represents the key for list AclSet of element /openconfig-acl/acl.
type Acl_AclSet_Key struct {
	Name string         `path:"name"`
	Type E_Acl_ACL_TYPE `path:"type"`
}

// IsYANGGoKeyStruct ensures that Acl_AclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (Acl_AclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the Acl_AclSet_Key key struct.
func (t Acl_AclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"name": t.Name,
		"type": t.Type,
	}, nil
}

// NewAclSet creates a new entry in the AclSet list of the
// Acl struct. The keys of the list are populated from the input
// arguments.
func (t *Acl) NewAclSet(Name string, Type E_Acl_ACL_TYPE) (*Acl_AclSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclSet == nil {
		t.AclSet = make(map[Acl_AclSet_Key]*Acl_AclSet)
	}

	key := Acl_AclSet_Key{
		Name: Name,
		Type: Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclSet", key)
	}

	t.AclSet[key] = &Acl_AclSet{
		Name: &Name,
		Type: Type,
	}

	return t.AclSet[key], nil
}

// RenameAclSet renames an entry in the list AclSet within
// the Acl struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Acl) RenameAclSet(oldK, newK Acl_AclSet_Key) error {
	if _, ok := t.AclSet[newK]; ok {
		return fmt.Errorf("key %v already exists in AclSet", newK)
	}

	e, ok := t.AclSet[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in AclSet", oldK)
	}
	e.Name = &newK.Name
	e.Type = newK.Type

	t.AclSet[newK] = e
	delete(t.AclSet, oldK)
	return nil
}

// GetOrCreateAclSet retrieves the value with the specified keys from
// the receiver Acl. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Acl) GetOrCreateAclSet(Name string, Type E_Acl_ACL_TYPE) *Acl_AclSet {

	key := Acl_AclSet_Key{
		Name: Name,
		Type: Type,
	}

	if v, ok := t.AclSet[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewAclSet(Name, Type)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateAclSet got unexpected error: %v", err))
	}
	return v
}

// GetAclSet retrieves the value with the specified key from
// the AclSet map field of Acl. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Acl) GetAclSet(Name string, Type E_Acl_ACL_TYPE) *Acl_AclSet {

	if t == nil {
		return nil
	}

	key := Acl_AclSet_Key{
		Name: Name,
		Type: Type,
	}

	if lm, ok := t.AclSet[key]; ok {
		return lm
	}
	return nil
}

// AppendAclSet appends the supplied Acl_AclSet struct to the
// list AclSet of Acl. If the key value(s) specified in
// the supplied Acl_AclSet already exist in the list, an error is
// returned.
func (t *Acl) AppendAclSet(v *Acl_AclSet) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key for Name")
	}

	key := Acl_AclSet_Key{
		Name: *v.Name,
		Type: v.Type,
	}

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclSet == nil {
		t.AclSet = make(map[Acl_AclSet_Key]*Acl_AclSet)
	}

	if _, ok := t.AclSet[key]; ok {
		return fmt.Errorf("duplicate key for list AclSet %v", key)
	}

	t.AclSet[key] = v
	return nil
}

// NewInterface creates a new entry in the Interface list of the
// Acl struct. The keys of the list are populated from the input
// arguments.
func (t *Acl) NewInterface(Id string) (*Acl_Interface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*Acl_Interface)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &Acl_Interface{
		Id: &Id,
	}

	return t.Interface[key], nil
}

// RenameInterface renames an entry in the list Interface within
// the Acl struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Acl) RenameInterface(oldK, newK string) error {
	if _, ok := t.Interface[newK]; ok {
		return fmt.Errorf("key %v already exists in Interface", newK)
	}

	e, ok := t.Interface[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Interface", oldK)
	}
	e.Id = &newK

	t.Interface[newK] = e
	delete(t.Interface, oldK)
	return nil
}

// GetOrCreateInterface retrieves the value with the specified keys from
// the receiver Acl. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Acl) GetOrCreateInterface(Id string) *Acl_Interface {

	key := Id

	if v, ok := t.Interface[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewInterface(Id)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateInterface got unexpected error: %v", err))
	}
	return v
}

// GetInterface retrieves the value with the specified key from
// the Interface map field of Acl. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Acl) GetInterface(Id string) *Acl_Interface {

	if t == nil {
		return nil
	}

	key := Id

	if lm, ok := t.Interface[key]; ok {
		return lm
	}
	return nil
}

// AppendInterface appends the supplied Acl_Interface struct to the
// list Interface of Acl. If the key value(s) specified in
// the supplied Acl_Interface already exist in the list, an error is
// returned.
func (t *Acl) AppendInterface(v *Acl_Interface) error {
	if v.Id == nil {
		return fmt.Errorf("invalid nil key received for Id")
	}

	key := *v.Id

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*Acl_Interface)
	}

	if _, ok := t.Interface[key]; ok {
		return fmt.Errorf("duplicate key for list Interface %v", key)
	}

	t.Interface[key] = v
	return nil
}

// GetCounterCapability retrieves the value of the leaf CounterCapability from the Acl
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if CounterCapability is set, it can
// safely use t.GetCounterCapability() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.CounterCapability == nil' before retrieving the leaf's value.
func (t *Acl) GetCounterCapability() E_Acl_ACL_COUNTER_CAPABILITY {
	if t == nil || t.CounterCapability == 0 {
		return 0
	}
	return t.CounterCapability
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl.
func (*Acl) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_AclSet represents the /openconfig-acl/acl/acl-sets/acl-set YANG schema element.
type Acl_AclSet struct {
	ΛMetadata    []ygot.Annotation               `path:"@" ygotAnnotation:"true"`
	AclEntry     map[uint32]*Acl_AclSet_AclEntry `path:"acl-entries/acl-entry" module:"openconfig-acl/openconfig-acl"`
	ΛAclEntry    []ygot.Annotation               `path:"acl-entries/@acl-entry" ygotAnnotation:"true"`
	Description  *string                         `path:"config/description" module:"openconfig-acl/openconfig-acl"`
	ΛDescription []ygot.Annotation               `path:"config/@description" ygotAnnotation:"true"`
	Name         *string                         `path:"config/name|name" module:"openconfig-acl/openconfig-acl|openconfig-acl"`
	ΛName        []ygot.Annotation               `path:"config/@name|@name" ygotAnnotation:"true"`
	Type         E_Acl_ACL_TYPE                  `path:"config/type|type" module:"openconfig-acl/openconfig-acl|openconfig-acl"`
	ΛType        []ygot.Annotation               `path:"config/@type|@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_AclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_AclSet) IsYANGGoStruct() {}

// NewAclEntry creates a new entry in the AclEntry list of the
// Acl_AclSet struct. The keys of the list are populated from the input
// arguments.
func (t *Acl_AclSet) NewAclEntry(SequenceId uint32) (*Acl_AclSet_AclEntry, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*Acl_AclSet_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &Acl_AclSet_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// RenameAclEntry renames an entry in the list AclEntry within
// the Acl_AclSet struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Acl_AclSet) RenameAclEntry(oldK, newK uint32) error {
	if _, ok := t.AclEntry[newK]; ok {
		return fmt.Errorf("key %v already exists in AclEntry", newK)
	}

	e, ok := t.AclEntry[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in AclEntry", oldK)
	}
	e.SequenceId = &newK

	t.AclEntry[newK] = e
	delete(t.AclEntry, oldK)
	return nil
}

// GetOrCreateAclEntry retrieves the value with the specified keys from
// the receiver Acl_AclSet. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Acl_AclSet) GetOrCreateAclEntry(SequenceId uint32) *Acl_AclSet_AclEntry {

	key := SequenceId

	if v, ok := t.AclEntry[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewAclEntry(SequenceId)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateAclEntry got unexpected error: %v", err))
	}
	return v
}

// GetAclEntry retrieves the value with the specified key from
// the AclEntry map field of Acl_AclSet. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Acl_AclSet) GetAclEntry(SequenceId uint32) *Acl_AclSet_AclEntry {

	if t == nil {
		return nil
	}

	key := SequenceId

	if lm, ok := t.AclEntry[key]; ok {
		return lm
	}
	return nil
}

// AppendAclEntry appends the supplied Acl_AclSet_AclEntry struct to the
// list AclEntry of Acl_AclSet. If the key value(s) specified in
// the supplied Acl_AclSet_AclEntry already exist in the list, an error is
// returned.
func (t *Acl_AclSet) AppendAclEntry(v *Acl_AclSet_AclEntry) error {
	if v.SequenceId == nil {
		return fmt.Errorf("invalid nil key received for SequenceId")
	}

	key := *v.SequenceId

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*Acl_AclSet_AclEntry)
	}

	if _, ok := t.AclEntry[key]; ok {
		return fmt.Errorf("duplicate key for list AclEntry %v", key)
	}

	t.AclEntry[key] = v
	return nil
}

// GetDescription retrieves the value of the leaf Description from the Acl_AclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *Acl_AclSet) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetName retrieves the value of the leaf Name from the Acl_AclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *Acl_AclSet) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetType retrieves the value of the leaf Type from the Acl_AclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *Acl_AclSet) GetType() E_Acl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// ΛListKeyMap returns the keys of the Acl_AclSet struct, which is a YANG list entry.
func (t *Acl_AclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
		"type": t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_AclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_AclSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_AclSet.
func (*Acl_AclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_AclSet_AclEntry represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry YANG schema element.
type Acl_AclSet_AclEntry struct {
	ΛMetadata       []ygot.Annotation                   `path:"@" ygotAnnotation:"true"`
	Actions         *Acl_AclSet_AclEntry_Actions        `path:"actions" module:"openconfig-acl"`
	ΛActions        []ygot.Annotation                   `path:"@actions" ygotAnnotation:"true"`
	Description     *string                             `path:"config/description" module:"openconfig-acl/openconfig-acl"`
	ΛDescription    []ygot.Annotation                   `path:"config/@description" ygotAnnotation:"true"`
	InputInterface  *Acl_AclSet_AclEntry_InputInterface `path:"input-interface" module:"openconfig-acl"`
	ΛInputInterface []ygot.Annotation                   `path:"@input-interface" ygotAnnotation:"true"`
	Ipv4            *Acl_AclSet_AclEntry_Ipv4           `path:"ipv4" module:"openconfig-acl"`
	ΛIpv4           []ygot.Annotation                   `path:"@ipv4" ygotAnnotation:"true"`
	Ipv6            *Acl_AclSet_AclEntry_Ipv6           `path:"ipv6" module:"openconfig-acl"`
	ΛIpv6           []ygot.Annotation                   `path:"@ipv6" ygotAnnotation:"true"`
	L2              *Acl_AclSet_AclEntry_L2             `path:"l2" module:"openconfig-acl"`
	ΛL2             []ygot.Annotation                   `path:"@l2" ygotAnnotation:"true"`
	MatchedOctets   *uint64                             `path:"state/matched-octets" module:"openconfig-acl/openconfig-acl"`
	ΛMatchedOctets  []ygot.Annotation                   `path:"state/@matched-octets" ygotAnnotation:"true"`
	MatchedPackets  *uint64                             `path:"state/matched-packets" module:"openconfig-acl/openconfig-acl"`
	ΛMatchedPackets []ygot.Annotation                   `path:"state/@matched-packets" ygotAnnotation:"true"`
	Mpls            *Acl_AclSet_AclEntry_Mpls           `path:"mpls" module:"openconfig-acl"`
	ΛMpls           []ygot.Annotation                   `path:"@mpls" ygotAnnotation:"true"`
	SequenceId      *uint32                             `path:"config/sequence-id|sequence-id" module:"openconfig-acl/openconfig-acl|openconfig-acl"`
	ΛSequenceId     []ygot.Annotation                   `path:"config/@sequence-id|@sequence-id" ygotAnnotation:"true"`
	Transport       *Acl_AclSet_AclEntry_Transport      `path:"transport" module:"openconfig-acl"`
	ΛTransport      []ygot.Annotation                   `path:"@transport" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_AclSet_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_AclSet_AclEntry) IsYANGGoStruct() {}

// GetOrCreateActions retrieves the value of the Actions field
// or returns the existing field if it already exists.
func (t *Acl_AclSet_AclEntry) GetOrCreateActions() *Acl_AclSet_AclEntry_Actions {
	if t.Actions != nil {
		return t.Actions
	}
	t.Actions = &Acl_AclSet_AclEntry_Actions{}
	return t.Actions
}

// GetOrCreateInputInterface retrieves the value of the InputInterface field
// or returns the existing field if it already exists.
func (t *Acl_AclSet_AclEntry) GetOrCreateInputInterface() *Acl_AclSet_AclEntry_InputInterface {
	if t.InputInterface != nil {
		return t.InputInterface
	}
	t.InputInterface = &Acl_AclSet_AclEntry_InputInterface{}
	return t.InputInterface
}

// GetOrCreateIpv4 retrieves the value of the Ipv4 field
// or returns the existing field if it already exists.
func (t *Acl_AclSet_AclEntry) GetOrCreateIpv4() *Acl_AclSet_AclEntry_Ipv4 {
	if t.Ipv4 != nil {
		return t.Ipv4
	}
	t.Ipv4 = &Acl_AclSet_AclEntry_Ipv4{}
	return t.Ipv4
}

// GetOrCreateIpv6 retrieves the value of the Ipv6 field
// or returns the existing field if it already exists.
func (t *Acl_AclSet_AclEntry) GetOrCreateIpv6() *Acl_AclSet_AclEntry_Ipv6 {
	if t.Ipv6 != nil {
		return t.Ipv6
	}
	t.Ipv6 = &Acl_AclSet_AclEntry_Ipv6{}
	return t.Ipv6
}

// GetOrCreateL2 retrieves the value of the L2 field
// or returns the existing field if it already exists.
func (t *Acl_AclSet_AclEntry) GetOrCreateL2() *Acl_AclSet_AclEntry_L2 {
	if t.L2 != nil {
		return t.L2
	}
	t.L2 = &Acl_AclSet_AclEntry_L2{}
	return t.L2
}

// GetOrCreateMpls retrieves the value of the Mpls field
// or returns the existing field if it already exists.
func (t *Acl_AclSet_AclEntry) GetOrCreateMpls() *Acl_AclSet_AclEntry_Mpls {
	if t.Mpls != nil {
		return t.Mpls
	}
	t.Mpls = &Acl_AclSet_AclEntry_Mpls{}
	return t.Mpls
}

// GetOrCreateTransport retrieves the value of the Transport field
// or returns the existing field if it already exists.
func (t *Acl_AclSet_AclEntry) GetOrCreateTransport() *Acl_AclSet_AclEntry_Transport {
	if t.Transport != nil {
		return t.Transport
	}
	t.Transport = &Acl_AclSet_AclEntry_Transport{}
	return t.Transport
}

// GetActions returns the value of the Actions struct pointer
// from Acl_AclSet_AclEntry. If the receiver or the field Actions is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Acl_AclSet_AclEntry) GetActions() *Acl_AclSet_AclEntry_Actions {
	if t != nil && t.Actions != nil {
		return t.Actions
	}
	return nil
}

// GetInputInterface returns the value of the InputInterface struct pointer
// from Acl_AclSet_AclEntry. If the receiver or the field InputInterface is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Acl_AclSet_AclEntry) GetInputInterface() *Acl_AclSet_AclEntry_InputInterface {
	if t != nil && t.InputInterface != nil {
		return t.InputInterface
	}
	return nil
}

// GetIpv4 returns the value of the Ipv4 struct pointer
// from Acl_AclSet_AclEntry. If the receiver or the field Ipv4 is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Acl_AclSet_AclEntry) GetIpv4() *Acl_AclSet_AclEntry_Ipv4 {
	if t != nil && t.Ipv4 != nil {
		return t.Ipv4
	}
	return nil
}

// GetIpv6 returns the value of the Ipv6 struct pointer
// from Acl_AclSet_AclEntry. If the receiver or the field Ipv6 is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Acl_AclSet_AclEntry) GetIpv6() *Acl_AclSet_AclEntry_Ipv6 {
	if t != nil && t.Ipv6 != nil {
		return t.Ipv6
	}
	return nil
}

// GetL2 returns the value of the L2 struct pointer
// from Acl_AclSet_AclEntry. If the receiver or the field L2 is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Acl_AclSet_AclEntry) GetL2() *Acl_AclSet_AclEntry_L2 {
	if t != nil && t.L2 != nil {
		return t.L2
	}
	return nil
}

// GetMpls returns the value of the Mpls struct pointer
// from Acl_AclSet_AclEntry. If the receiver or the field Mpls is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Acl_AclSet_AclEntry) GetMpls() *Acl_AclSet_AclEntry_Mpls {
	if t != nil && t.Mpls != nil {
		return t.Mpls
	}
	return nil
}

// GetTransport returns the value of the Transport struct pointer
// from Acl_AclSet_AclEntry. If the receiver or the field Transport is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Acl_AclSet_AclEntry) GetTransport() *Acl_AclSet_AclEntry_Transport {
	if t != nil && t.Transport != nil {
		return t.Transport
	}
	return nil
}

// GetDescription retrieves the value of the leaf Description from the Acl_AclSet_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetMatchedOctets retrieves the value of the leaf MatchedOctets from the Acl_AclSet_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedOctets is set, it can
// safely use t.GetMatchedOctets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedOctets == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry) GetMatchedOctets() uint64 {
	if t == nil || t.MatchedOctets == nil {
		return 0
	}
	return *t.MatchedOctets
}

// GetMatchedPackets retrieves the value of the leaf MatchedPackets from the Acl_AclSet_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedPackets is set, it can
// safely use t.GetMatchedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedPackets == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry) GetMatchedPackets() uint64 {
	if t == nil || t.MatchedPackets == nil {
		return 0
	}
	return *t.MatchedPackets
}

// GetSequenceId retrieves the value of the leaf SequenceId from the Acl_AclSet_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SequenceId is set, it can
// safely use t.GetSequenceId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SequenceId == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry) GetSequenceId() uint32 {
	if t == nil || t.SequenceId == nil {
		return 0
	}
	return *t.SequenceId
}

// ΛListKeyMap returns the keys of the Acl_AclSet_AclEntry struct, which is a YANG list entry.
func (t *Acl_AclSet_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_AclSet_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_AclSet_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_AclSet_AclEntry.
func (*Acl_AclSet_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_AclSet_AclEntry_Actions represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions YANG schema element.
type Acl_AclSet_AclEntry_Actions struct {
	ΛMetadata         []ygot.Annotation       `path:"@" ygotAnnotation:"true"`
	ForwardingAction  E_Acl_FORWARDING_ACTION `path:"config/forwarding-action" module:"openconfig-acl/openconfig-acl"`
	ΛForwardingAction []ygot.Annotation       `path:"config/@forwarding-action" ygotAnnotation:"true"`
	LogAction         E_Acl_LOG_ACTION        `path:"config/log-action" module:"openconfig-acl/openconfig-acl"`
	ΛLogAction        []ygot.Annotation       `path:"config/@log-action" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_AclSet_AclEntry_Actions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_AclSet_AclEntry_Actions) IsYANGGoStruct() {}

// GetForwardingAction retrieves the value of the leaf ForwardingAction from the Acl_AclSet_AclEntry_Actions
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ForwardingAction is set, it can
// safely use t.GetForwardingAction() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ForwardingAction == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Actions) GetForwardingAction() E_Acl_FORWARDING_ACTION {
	if t == nil || t.ForwardingAction == 0 {
		return 0
	}
	return t.ForwardingAction
}

// GetLogAction retrieves the value of the leaf LogAction from the Acl_AclSet_AclEntry_Actions
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LogAction is set, it can
// safely use t.GetLogAction() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LogAction == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Actions) GetLogAction() E_Acl_LOG_ACTION {
	if t == nil || t.LogAction == 0 {
		return Acl_LOG_ACTION_LOG_NONE
	}
	return t.LogAction
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_Actions) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_AclSet_AclEntry_Actions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_Actions) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_AclSet_AclEntry_Actions) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_AclSet_AclEntry_Actions.
func (*Acl_AclSet_AclEntry_Actions) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_AclSet_AclEntry_InputInterface represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface YANG schema element.
type Acl_AclSet_AclEntry_InputInterface struct {
	ΛMetadata     []ygot.Annotation                                `path:"@" ygotAnnotation:"true"`
	InterfaceRef  *Acl_AclSet_AclEntry_InputInterface_InterfaceRef `path:"interface-ref" module:"openconfig-acl"`
	ΛInterfaceRef []ygot.Annotation                                `path:"@interface-ref" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_AclSet_AclEntry_InputInterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_AclSet_AclEntry_InputInterface) IsYANGGoStruct() {}

// GetOrCreateInterfaceRef retrieves the value of the InterfaceRef field
// or returns the existing field if it already exists.
func (t *Acl_AclSet_AclEntry_InputInterface) GetOrCreateInterfaceRef() *Acl_AclSet_AclEntry_InputInterface_InterfaceRef {
	if t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	t.InterfaceRef = &Acl_AclSet_AclEntry_InputInterface_InterfaceRef{}
	return t.InterfaceRef
}

// GetInterfaceRef returns the value of the InterfaceRef struct pointer
// from Acl_AclSet_AclEntry_InputInterface. If the receiver or the field InterfaceRef is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Acl_AclSet_AclEntry_InputInterface) GetInterfaceRef() *Acl_AclSet_AclEntry_InputInterface_InterfaceRef {
	if t != nil && t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_InputInterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_AclSet_AclEntry_InputInterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_InputInterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_AclSet_AclEntry_InputInterface) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_AclSet_AclEntry_InputInterface.
func (*Acl_AclSet_AclEntry_InputInterface) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_AclSet_AclEntry_InputInterface_InterfaceRef represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref YANG schema element.
type Acl_AclSet_AclEntry_InputInterface_InterfaceRef struct {
	ΛMetadata     []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Interface     *string           `path:"config/interface" module:"openconfig-acl/openconfig-acl"`
	ΛInterface    []ygot.Annotation `path:"config/@interface" ygotAnnotation:"true"`
	Subinterface  *uint32           `path:"config/subinterface" module:"openconfig-acl/openconfig-acl"`
	ΛSubinterface []ygot.Annotation `path:"config/@subinterface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_AclSet_AclEntry_InputInterface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_AclSet_AclEntry_InputInterface_InterfaceRef) IsYANGGoStruct() {}

// GetInterface retrieves the value of the leaf Interface from the Acl_AclSet_AclEntry_InputInterface_InterfaceRef
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interface is set, it can
// safely use t.GetInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interface == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_InputInterface_InterfaceRef) GetInterface() string {
	if t == nil || t.Interface == nil {
		return ""
	}
	return *t.Interface
}

// GetSubinterface retrieves the value of the leaf Subinterface from the Acl_AclSet_AclEntry_InputInterface_InterfaceRef
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Subinterface is set, it can
// safely use t.GetSubinterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Subinterface == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_InputInterface_InterfaceRef) GetSubinterface() uint32 {
	if t == nil || t.Subinterface == nil {
		return 0
	}
	return *t.Subinterface
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_InputInterface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_AclSet_AclEntry_InputInterface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_InputInterface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_AclSet_AclEntry_InputInterface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_AclSet_AclEntry_InputInterface_InterfaceRef.
func (*Acl_AclSet_AclEntry_InputInterface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_AclSet_AclEntry_Ipv4 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4 YANG schema element.
type Acl_AclSet_AclEntry_Ipv4 struct {
	ΛMetadata           []ygot.Annotation                       `path:"@" ygotAnnotation:"true"`
	DestinationAddress  *string                                 `path:"config/destination-address" module:"openconfig-acl/openconfig-acl"`
	ΛDestinationAddress []ygot.Annotation                       `path:"config/@destination-address" ygotAnnotation:"true"`
	Dscp                *uint8                                  `path:"config/dscp" module:"openconfig-acl/openconfig-acl"`
	ΛDscp               []ygot.Annotation                       `path:"config/@dscp" ygotAnnotation:"true"`
	DscpSet             []uint8                                 `path:"config/dscp-set" module:"openconfig-acl/openconfig-acl"`
	ΛDscpSet            []ygot.Annotation                       `path:"config/@dscp-set" ygotAnnotation:"true"`
	HopLimit            *uint8                                  `path:"config/hop-limit" module:"openconfig-acl/openconfig-acl"`
	ΛHopLimit           []ygot.Annotation                       `path:"config/@hop-limit" ygotAnnotation:"true"`
	Protocol            Acl_AclSet_AclEntry_Ipv4_Protocol_Union `path:"config/protocol" module:"openconfig-acl/openconfig-acl"`
	ΛProtocol           []ygot.Annotation                       `path:"config/@protocol" ygotAnnotation:"true"`
	SourceAddress       *string                                 `path:"config/source-address" module:"openconfig-acl/openconfig-acl"`
	ΛSourceAddress      []ygot.Annotation                       `path:"config/@source-address" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_AclSet_AclEntry_Ipv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_AclSet_AclEntry_Ipv4) IsYANGGoStruct() {}

// GetDestinationAddress retrieves the value of the leaf DestinationAddress from the Acl_AclSet_AclEntry_Ipv4
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationAddress is set, it can
// safely use t.GetDestinationAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationAddress == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv4) GetDestinationAddress() string {
	if t == nil || t.DestinationAddress == nil {
		return ""
	}
	return *t.DestinationAddress
}

// GetDscp retrieves the value of the leaf Dscp from the Acl_AclSet_AclEntry_Ipv4
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Dscp is set, it can
// safely use t.GetDscp() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Dscp == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv4) GetDscp() uint8 {
	if t == nil || t.Dscp == nil {
		return 0
	}
	return *t.Dscp
}

// GetDscpSet retrieves the value of the leaf DscpSet from the Acl_AclSet_AclEntry_Ipv4
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DscpSet is set, it can
// safely use t.GetDscpSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DscpSet == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv4) GetDscpSet() []uint8 {
	if t == nil || t.DscpSet == nil {
		return nil
	}
	return t.DscpSet
}

// GetHopLimit retrieves the value of the leaf HopLimit from the Acl_AclSet_AclEntry_Ipv4
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HopLimit is set, it can
// safely use t.GetHopLimit() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HopLimit == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv4) GetHopLimit() uint8 {
	if t == nil || t.HopLimit == nil {
		return 0
	}
	return *t.HopLimit
}

// GetProtocol retrieves the value of the leaf Protocol from the Acl_AclSet_AclEntry_Ipv4
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Protocol is set, it can
// safely use t.GetProtocol() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Protocol == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv4) GetProtocol() Acl_AclSet_AclEntry_Ipv4_Protocol_Union {
	if t == nil || t.Protocol == nil {
		return nil
	}
	return t.Protocol
}

// GetSourceAddress retrieves the value of the leaf SourceAddress from the Acl_AclSet_AclEntry_Ipv4
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceAddress is set, it can
// safely use t.GetSourceAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceAddress == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv4) GetSourceAddress() string {
	if t == nil || t.SourceAddress == nil {
		return ""
	}
	return *t.SourceAddress
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_Ipv4) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_AclSet_AclEntry_Ipv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_Ipv4) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_AclSet_AclEntry_Ipv4) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_AclSet_AclEntry_Ipv4.
func (*Acl_AclSet_AclEntry_Ipv4) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_AclSet_AclEntry_Ipv4_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol within the YANG schema.
type Acl_AclSet_AclEntry_Ipv4_Protocol_Union interface {
	Is_Acl_AclSet_AclEntry_Ipv4_Protocol_Union()
}

// Acl_AclSet_AclEntry_Ipv4_Protocol_Union_E_PacketMatchTypes_IP_PROTOCOL is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol
// is to be set to a E_PacketMatchTypes_IP_PROTOCOL value.
type Acl_AclSet_AclEntry_Ipv4_Protocol_Union_E_PacketMatchTypes_IP_PROTOCOL struct {
	E_PacketMatchTypes_IP_PROTOCOL E_PacketMatchTypes_IP_PROTOCOL
}

// Is_Acl_AclSet_AclEntry_Ipv4_Protocol_Union ensures that Acl_AclSet_AclEntry_Ipv4_Protocol_Union_E_PacketMatchTypes_IP_PROTOCOL
// implements the Acl_AclSet_AclEntry_Ipv4_Protocol_Union interface.
func (*Acl_AclSet_AclEntry_Ipv4_Protocol_Union_E_PacketMatchTypes_IP_PROTOCOL) Is_Acl_AclSet_AclEntry_Ipv4_Protocol_Union() {
}

// Acl_AclSet_AclEntry_Ipv4_Protocol_Union_Uint8 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol
// is to be set to a uint8 value.
type Acl_AclSet_AclEntry_Ipv4_Protocol_Union_Uint8 struct {
	Uint8 uint8
}

// Is_Acl_AclSet_AclEntry_Ipv4_Protocol_Union ensures that Acl_AclSet_AclEntry_Ipv4_Protocol_Union_Uint8
// implements the Acl_AclSet_AclEntry_Ipv4_Protocol_Union interface.
func (*Acl_AclSet_AclEntry_Ipv4_Protocol_Union_Uint8) Is_Acl_AclSet_AclEntry_Ipv4_Protocol_Union() {}

// To_Acl_AclSet_AclEntry_Ipv4_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the Acl_AclSet_AclEntry_Ipv4_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *Acl_AclSet_AclEntry_Ipv4) To_Acl_AclSet_AclEntry_Ipv4_Protocol_Union(i interface{}) (Acl_AclSet_AclEntry_Ipv4_Protocol_Union, error) {
	switch v := i.(type) {
	case E_PacketMatchTypes_IP_PROTOCOL:
		return &Acl_AclSet_AclEntry_Ipv4_Protocol_Union_E_PacketMatchTypes_IP_PROTOCOL{v}, nil
	case uint8:
		return &Acl_AclSet_AclEntry_Ipv4_Protocol_Union_Uint8{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to Acl_AclSet_AclEntry_Ipv4_Protocol_Union, unknown union type, got: %T, want any of [E_PacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
	}
}

// Acl_AclSet_AclEntry_Ipv6 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6 YANG schema element.
type Acl_AclSet_AclEntry_Ipv6 struct {
	ΛMetadata             []ygot.Annotation                       `path:"@" ygotAnnotation:"true"`
	DestinationAddress    *string                                 `path:"config/destination-address" module:"openconfig-acl/openconfig-acl"`
	ΛDestinationAddress   []ygot.Annotation                       `path:"config/@destination-address" ygotAnnotation:"true"`
	DestinationFlowLabel  *uint32                                 `path:"config/destination-flow-label" module:"openconfig-acl/openconfig-acl"`
	ΛDestinationFlowLabel []ygot.Annotation                       `path:"config/@destination-flow-label" ygotAnnotation:"true"`
	Dscp                  *uint8                                  `path:"config/dscp" module:"openconfig-acl/openconfig-acl"`
	ΛDscp                 []ygot.Annotation                       `path:"config/@dscp" ygotAnnotation:"true"`
	DscpSet               []uint8                                 `path:"config/dscp-set" module:"openconfig-acl/openconfig-acl"`
	ΛDscpSet              []ygot.Annotation                       `path:"config/@dscp-set" ygotAnnotation:"true"`
	HopLimit              *uint8                                  `path:"config/hop-limit" module:"openconfig-acl/openconfig-acl"`
	ΛHopLimit             []ygot.Annotation                       `path:"config/@hop-limit" ygotAnnotation:"true"`
	Protocol              Acl_AclSet_AclEntry_Ipv6_Protocol_Union `path:"config/protocol" module:"openconfig-acl/openconfig-acl"`
	ΛProtocol             []ygot.Annotation                       `path:"config/@protocol" ygotAnnotation:"true"`
	SourceAddress         *string                                 `path:"config/source-address" module:"openconfig-acl/openconfig-acl"`
	ΛSourceAddress        []ygot.Annotation                       `path:"config/@source-address" ygotAnnotation:"true"`
	SourceFlowLabel       *uint32                                 `path:"config/source-flow-label" module:"openconfig-acl/openconfig-acl"`
	ΛSourceFlowLabel      []ygot.Annotation                       `path:"config/@source-flow-label" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_AclSet_AclEntry_Ipv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_AclSet_AclEntry_Ipv6) IsYANGGoStruct() {}

// GetDestinationAddress retrieves the value of the leaf DestinationAddress from the Acl_AclSet_AclEntry_Ipv6
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationAddress is set, it can
// safely use t.GetDestinationAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationAddress == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv6) GetDestinationAddress() string {
	if t == nil || t.DestinationAddress == nil {
		return ""
	}
	return *t.DestinationAddress
}

// GetDestinationFlowLabel retrieves the value of the leaf DestinationFlowLabel from the Acl_AclSet_AclEntry_Ipv6
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationFlowLabel is set, it can
// safely use t.GetDestinationFlowLabel() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationFlowLabel == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv6) GetDestinationFlowLabel() uint32 {
	if t == nil || t.DestinationFlowLabel == nil {
		return 0
	}
	return *t.DestinationFlowLabel
}

// GetDscp retrieves the value of the leaf Dscp from the Acl_AclSet_AclEntry_Ipv6
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Dscp is set, it can
// safely use t.GetDscp() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Dscp == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv6) GetDscp() uint8 {
	if t == nil || t.Dscp == nil {
		return 0
	}
	return *t.Dscp
}

// GetDscpSet retrieves the value of the leaf DscpSet from the Acl_AclSet_AclEntry_Ipv6
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DscpSet is set, it can
// safely use t.GetDscpSet() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DscpSet == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv6) GetDscpSet() []uint8 {
	if t == nil || t.DscpSet == nil {
		return nil
	}
	return t.DscpSet
}

// GetHopLimit retrieves the value of the leaf HopLimit from the Acl_AclSet_AclEntry_Ipv6
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HopLimit is set, it can
// safely use t.GetHopLimit() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HopLimit == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv6) GetHopLimit() uint8 {
	if t == nil || t.HopLimit == nil {
		return 0
	}
	return *t.HopLimit
}

// GetProtocol retrieves the value of the leaf Protocol from the Acl_AclSet_AclEntry_Ipv6
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Protocol is set, it can
// safely use t.GetProtocol() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Protocol == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv6) GetProtocol() Acl_AclSet_AclEntry_Ipv6_Protocol_Union {
	if t == nil || t.Protocol == nil {
		return nil
	}
	return t.Protocol
}

// GetSourceAddress retrieves the value of the leaf SourceAddress from the Acl_AclSet_AclEntry_Ipv6
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceAddress is set, it can
// safely use t.GetSourceAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceAddress == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv6) GetSourceAddress() string {
	if t == nil || t.SourceAddress == nil {
		return ""
	}
	return *t.SourceAddress
}

// GetSourceFlowLabel retrieves the value of the leaf SourceFlowLabel from the Acl_AclSet_AclEntry_Ipv6
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceFlowLabel is set, it can
// safely use t.GetSourceFlowLabel() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceFlowLabel == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Ipv6) GetSourceFlowLabel() uint32 {
	if t == nil || t.SourceFlowLabel == nil {
		return 0
	}
	return *t.SourceFlowLabel
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_Ipv6) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_AclSet_AclEntry_Ipv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_Ipv6) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_AclSet_AclEntry_Ipv6) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_AclSet_AclEntry_Ipv6.
func (*Acl_AclSet_AclEntry_Ipv6) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_AclSet_AclEntry_Ipv6_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol within the YANG schema.
type Acl_AclSet_AclEntry_Ipv6_Protocol_Union interface {
	Is_Acl_AclSet_AclEntry_Ipv6_Protocol_Union()
}

// Acl_AclSet_AclEntry_Ipv6_Protocol_Union_E_PacketMatchTypes_IP_PROTOCOL is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol
// is to be set to a E_PacketMatchTypes_IP_PROTOCOL value.
type Acl_AclSet_AclEntry_Ipv6_Protocol_Union_E_PacketMatchTypes_IP_PROTOCOL struct {
	E_PacketMatchTypes_IP_PROTOCOL E_PacketMatchTypes_IP_PROTOCOL
}

// Is_Acl_AclSet_AclEntry_Ipv6_Protocol_Union ensures that Acl_AclSet_AclEntry_Ipv6_Protocol_Union_E_PacketMatchTypes_IP_PROTOCOL
// implements the Acl_AclSet_AclEntry_Ipv6_Protocol_Union interface.
func (*Acl_AclSet_AclEntry_Ipv6_Protocol_Union_E_PacketMatchTypes_IP_PROTOCOL) Is_Acl_AclSet_AclEntry_Ipv6_Protocol_Union() {
}

// Acl_AclSet_AclEntry_Ipv6_Protocol_Union_Uint8 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol
// is to be set to a uint8 value.
type Acl_AclSet_AclEntry_Ipv6_Protocol_Union_Uint8 struct {
	Uint8 uint8
}

// Is_Acl_AclSet_AclEntry_Ipv6_Protocol_Union ensures that Acl_AclSet_AclEntry_Ipv6_Protocol_Union_Uint8
// implements the Acl_AclSet_AclEntry_Ipv6_Protocol_Union interface.
func (*Acl_AclSet_AclEntry_Ipv6_Protocol_Union_Uint8) Is_Acl_AclSet_AclEntry_Ipv6_Protocol_Union() {}

// To_Acl_AclSet_AclEntry_Ipv6_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the Acl_AclSet_AclEntry_Ipv6_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *Acl_AclSet_AclEntry_Ipv6) To_Acl_AclSet_AclEntry_Ipv6_Protocol_Union(i interface{}) (Acl_AclSet_AclEntry_Ipv6_Protocol_Union, error) {
	switch v := i.(type) {
	case E_PacketMatchTypes_IP_PROTOCOL:
		return &Acl_AclSet_AclEntry_Ipv6_Protocol_Union_E_PacketMatchTypes_IP_PROTOCOL{v}, nil
	case uint8:
		return &Acl_AclSet_AclEntry_Ipv6_Protocol_Union_Uint8{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to Acl_AclSet_AclEntry_Ipv6_Protocol_Union, unknown union type, got: %T, want any of [E_PacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
	}
}

// Acl_AclSet_AclEntry_L2 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2 YANG schema element.
type Acl_AclSet_AclEntry_L2 struct {
	ΛMetadata           []ygot.Annotation                      `path:"@" ygotAnnotation:"true"`
	DestinationMac      *string                                `path:"config/destination-mac" module:"openconfig-acl/openconfig-acl"`
	ΛDestinationMac     []ygot.Annotation                      `path:"config/@destination-mac" ygotAnnotation:"true"`
	DestinationMacMask  *string                                `path:"config/destination-mac-mask" module:"openconfig-acl/openconfig-acl"`
	ΛDestinationMacMask []ygot.Annotation                      `path:"config/@destination-mac-mask" ygotAnnotation:"true"`
	Ethertype           Acl_AclSet_AclEntry_L2_Ethertype_Union `path:"config/ethertype" module:"openconfig-acl/openconfig-acl"`
	ΛEthertype          []ygot.Annotation                      `path:"config/@ethertype" ygotAnnotation:"true"`
	SourceMac           *string                                `path:"config/source-mac" module:"openconfig-acl/openconfig-acl"`
	ΛSourceMac          []ygot.Annotation                      `path:"config/@source-mac" ygotAnnotation:"true"`
	SourceMacMask       *string                                `path:"config/source-mac-mask" module:"openconfig-acl/openconfig-acl"`
	ΛSourceMacMask      []ygot.Annotation                      `path:"config/@source-mac-mask" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_AclSet_AclEntry_L2 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_AclSet_AclEntry_L2) IsYANGGoStruct() {}

// GetDestinationMac retrieves the value of the leaf DestinationMac from the Acl_AclSet_AclEntry_L2
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationMac is set, it can
// safely use t.GetDestinationMac() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationMac == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_L2) GetDestinationMac() string {
	if t == nil || t.DestinationMac == nil {
		return ""
	}
	return *t.DestinationMac
}

// GetDestinationMacMask retrieves the value of the leaf DestinationMacMask from the Acl_AclSet_AclEntry_L2
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationMacMask is set, it can
// safely use t.GetDestinationMacMask() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationMacMask == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_L2) GetDestinationMacMask() string {
	if t == nil || t.DestinationMacMask == nil {
		return ""
	}
	return *t.DestinationMacMask
}

// GetEthertype retrieves the value of the leaf Ethertype from the Acl_AclSet_AclEntry_L2
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Ethertype is set, it can
// safely use t.GetEthertype() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Ethertype == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_L2) GetEthertype() Acl_AclSet_AclEntry_L2_Ethertype_Union {
	if t == nil || t.Ethertype == nil {
		return nil
	}
	return t.Ethertype
}

// GetSourceMac retrieves the value of the leaf SourceMac from the Acl_AclSet_AclEntry_L2
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceMac is set, it can
// safely use t.GetSourceMac() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceMac == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_L2) GetSourceMac() string {
	if t == nil || t.SourceMac == nil {
		return ""
	}
	return *t.SourceMac
}

// GetSourceMacMask retrieves the value of the leaf SourceMacMask from the Acl_AclSet_AclEntry_L2
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourceMacMask is set, it can
// safely use t.GetSourceMacMask() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourceMacMask == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_L2) GetSourceMacMask() string {
	if t == nil || t.SourceMacMask == nil {
		return ""
	}
	return *t.SourceMacMask
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_L2) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_AclSet_AclEntry_L2"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_L2) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_AclSet_AclEntry_L2) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_AclSet_AclEntry_L2.
func (*Acl_AclSet_AclEntry_L2) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_AclSet_AclEntry_L2_Ethertype_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype within the YANG schema.
type Acl_AclSet_AclEntry_L2_Ethertype_Union interface {
	Is_Acl_AclSet_AclEntry_L2_Ethertype_Union()
}

// Acl_AclSet_AclEntry_L2_Ethertype_Union_E_PacketMatchTypes_ETHERTYPE is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype
// is to be set to a E_PacketMatchTypes_ETHERTYPE value.
type Acl_AclSet_AclEntry_L2_Ethertype_Union_E_PacketMatchTypes_ETHERTYPE struct {
	E_PacketMatchTypes_ETHERTYPE E_PacketMatchTypes_ETHERTYPE
}

// Is_Acl_AclSet_AclEntry_L2_Ethertype_Union ensures that Acl_AclSet_AclEntry_L2_Ethertype_Union_E_PacketMatchTypes_ETHERTYPE
// implements the Acl_AclSet_AclEntry_L2_Ethertype_Union interface.
func (*Acl_AclSet_AclEntry_L2_Ethertype_Union_E_PacketMatchTypes_ETHERTYPE) Is_Acl_AclSet_AclEntry_L2_Ethertype_Union() {
}

// Acl_AclSet_AclEntry_L2_Ethertype_Union_Uint16 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype
// is to be set to a uint16 value.
type Acl_AclSet_AclEntry_L2_Ethertype_Union_Uint16 struct {
	Uint16 uint16
}

// Is_Acl_AclSet_AclEntry_L2_Ethertype_Union ensures that Acl_AclSet_AclEntry_L2_Ethertype_Union_Uint16
// implements the Acl_AclSet_AclEntry_L2_Ethertype_Union interface.
func (*Acl_AclSet_AclEntry_L2_Ethertype_Union_Uint16) Is_Acl_AclSet_AclEntry_L2_Ethertype_Union() {}

// To_Acl_AclSet_AclEntry_L2_Ethertype_Union takes an input interface{} and attempts to convert it to a struct
// which implements the Acl_AclSet_AclEntry_L2_Ethertype_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *Acl_AclSet_AclEntry_L2) To_Acl_AclSet_AclEntry_L2_Ethertype_Union(i interface{}) (Acl_AclSet_AclEntry_L2_Ethertype_Union, error) {
	switch v := i.(type) {
	case E_PacketMatchTypes_ETHERTYPE:
		return &Acl_AclSet_AclEntry_L2_Ethertype_Union_E_PacketMatchTypes_ETHERTYPE{v}, nil
	case uint16:
		return &Acl_AclSet_AclEntry_L2_Ethertype_Union_Uint16{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to Acl_AclSet_AclEntry_L2_Ethertype_Union, unknown union type, got: %T, want any of [E_PacketMatchTypes_ETHERTYPE, uint16]", i, i)
	}
}

// Acl_AclSet_AclEntry_Mpls represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls YANG schema element.
type Acl_AclSet_AclEntry_Mpls struct {
	ΛMetadata        []ygot.Annotation                              `path:"@" ygotAnnotation:"true"`
	EndLabelValue    Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union   `path:"config/end-label-value" module:"openconfig-acl/openconfig-acl"`
	ΛEndLabelValue   []ygot.Annotation                              `path:"config/@end-label-value" ygotAnnotation:"true"`
	StartLabelValue  Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union `path:"config/start-label-value" module:"openconfig-acl/openconfig-acl"`
	ΛStartLabelValue []ygot.Annotation                              `path:"config/@start-label-value" ygotAnnotation:"true"`
	TrafficClass     *uint8                                         `path:"config/traffic-class" module:"openconfig-acl/openconfig-acl"`
	ΛTrafficClass    []ygot.Annotation                              `path:"config/@traffic-class" ygotAnnotation:"true"`
	TtlValue         *uint8                                         `path:"config/ttl-value" module:"openconfig-acl/openconfig-acl"`
	ΛTtlValue        []ygot.Annotation                              `path:"config/@ttl-value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_AclSet_AclEntry_Mpls implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_AclSet_AclEntry_Mpls) IsYANGGoStruct() {}

// GetEndLabelValue retrieves the value of the leaf EndLabelValue from the Acl_AclSet_AclEntry_Mpls
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EndLabelValue is set, it can
// safely use t.GetEndLabelValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EndLabelValue == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Mpls) GetEndLabelValue() Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union {
	if t == nil || t.EndLabelValue == nil {
		return nil
	}
	return t.EndLabelValue
}

// GetStartLabelValue retrieves the value of the leaf StartLabelValue from the Acl_AclSet_AclEntry_Mpls
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if StartLabelValue is set, it can
// safely use t.GetStartLabelValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.StartLabelValue == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Mpls) GetStartLabelValue() Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union {
	if t == nil || t.StartLabelValue == nil {
		return nil
	}
	return t.StartLabelValue
}

// GetTrafficClass retrieves the value of the leaf TrafficClass from the Acl_AclSet_AclEntry_Mpls
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TrafficClass is set, it can
// safely use t.GetTrafficClass() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TrafficClass == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Mpls) GetTrafficClass() uint8 {
	if t == nil || t.TrafficClass == nil {
		return 0
	}
	return *t.TrafficClass
}

// GetTtlValue retrieves the value of the leaf TtlValue from the Acl_AclSet_AclEntry_Mpls
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TtlValue is set, it can
// safely use t.GetTtlValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TtlValue == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Mpls) GetTtlValue() uint8 {
	if t == nil || t.TtlValue == nil {
		return 0
	}
	return *t.TtlValue
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_Mpls) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_AclSet_AclEntry_Mpls"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_Mpls) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_AclSet_AclEntry_Mpls) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_AclSet_AclEntry_Mpls.
func (*Acl_AclSet_AclEntry_Mpls) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/end-label-value within the YANG schema.
type Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union interface {
	Is_Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union()
}

// Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union_E_MplsTypes_MplsLabel_Enum is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/end-label-value
// is to be set to a E_MplsTypes_MplsLabel_Enum value.
type Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union_E_MplsTypes_MplsLabel_Enum struct {
	E_MplsTypes_MplsLabel_Enum E_MplsTypes_MplsLabel_Enum
}

// Is_Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union ensures that Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union_E_MplsTypes_MplsLabel_Enum
// implements the Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union interface.
func (*Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union_E_MplsTypes_MplsLabel_Enum) Is_Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union() {
}

// Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union_Uint32 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/end-label-value
// is to be set to a uint32 value.
type Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union_Uint32 struct {
	Uint32 uint32
}

// Is_Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union ensures that Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union_Uint32
// implements the Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union interface.
func (*Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union_Uint32) Is_Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union() {
}

// To_Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *Acl_AclSet_AclEntry_Mpls) To_Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union(i interface{}) (Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union, error) {
	switch v := i.(type) {
	case E_MplsTypes_MplsLabel_Enum:
		return &Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union_E_MplsTypes_MplsLabel_Enum{v}, nil
	case uint32:
		return &Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union_Uint32{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to Acl_AclSet_AclEntry_Mpls_EndLabelValue_Union, unknown union type, got: %T, want any of [E_MplsTypes_MplsLabel_Enum, uint32]", i, i)
	}
}

// Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/start-label-value within the YANG schema.
type Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union interface {
	Is_Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union()
}

// Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union_E_MplsTypes_MplsLabel_Enum is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/start-label-value
// is to be set to a E_MplsTypes_MplsLabel_Enum value.
type Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union_E_MplsTypes_MplsLabel_Enum struct {
	E_MplsTypes_MplsLabel_Enum E_MplsTypes_MplsLabel_Enum
}

// Is_Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union ensures that Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union_E_MplsTypes_MplsLabel_Enum
// implements the Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union interface.
func (*Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union_E_MplsTypes_MplsLabel_Enum) Is_Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union() {
}

// Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union_Uint32 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/start-label-value
// is to be set to a uint32 value.
type Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union_Uint32 struct {
	Uint32 uint32
}

// Is_Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union ensures that Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union_Uint32
// implements the Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union interface.
func (*Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union_Uint32) Is_Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union() {
}

// To_Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *Acl_AclSet_AclEntry_Mpls) To_Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union(i interface{}) (Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union, error) {
	switch v := i.(type) {
	case E_MplsTypes_MplsLabel_Enum:
		return &Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union_E_MplsTypes_MplsLabel_Enum{v}, nil
	case uint32:
		return &Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union_Uint32{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to Acl_AclSet_AclEntry_Mpls_StartLabelValue_Union, unknown union type, got: %T, want any of [E_MplsTypes_MplsLabel_Enum, uint32]", i, i)
	}
}

// Acl_AclSet_AclEntry_Transport represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport YANG schema element.
type Acl_AclSet_AclEntry_Transport struct {
	ΛMetadata        []ygot.Annotation                                   `path:"@" ygotAnnotation:"true"`
	DestinationPort  Acl_AclSet_AclEntry_Transport_DestinationPort_Union `path:"config/destination-port" module:"openconfig-acl/openconfig-acl"`
	ΛDestinationPort []ygot.Annotation                                   `path:"config/@destination-port" ygotAnnotation:"true"`
	SourcePort       Acl_AclSet_AclEntry_Transport_SourcePort_Union      `path:"config/source-port" module:"openconfig-acl/openconfig-acl"`
	ΛSourcePort      []ygot.Annotation                                   `path:"config/@source-port" ygotAnnotation:"true"`
	TcpFlags         []E_PacketMatchTypes_TCP_FLAGS                      `path:"config/tcp-flags" module:"openconfig-acl/openconfig-acl"`
	ΛTcpFlags        []ygot.Annotation                                   `path:"config/@tcp-flags" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_AclSet_AclEntry_Transport implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_AclSet_AclEntry_Transport) IsYANGGoStruct() {}

// GetDestinationPort retrieves the value of the leaf DestinationPort from the Acl_AclSet_AclEntry_Transport
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DestinationPort is set, it can
// safely use t.GetDestinationPort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DestinationPort == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Transport) GetDestinationPort() Acl_AclSet_AclEntry_Transport_DestinationPort_Union {
	if t == nil || t.DestinationPort == nil {
		return nil
	}
	return t.DestinationPort
}

// GetSourcePort retrieves the value of the leaf SourcePort from the Acl_AclSet_AclEntry_Transport
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SourcePort is set, it can
// safely use t.GetSourcePort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SourcePort == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Transport) GetSourcePort() Acl_AclSet_AclEntry_Transport_SourcePort_Union {
	if t == nil || t.SourcePort == nil {
		return nil
	}
	return t.SourcePort
}

// GetTcpFlags retrieves the value of the leaf TcpFlags from the Acl_AclSet_AclEntry_Transport
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TcpFlags is set, it can
// safely use t.GetTcpFlags() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TcpFlags == nil' before retrieving the leaf's value.
func (t *Acl_AclSet_AclEntry_Transport) GetTcpFlags() []E_PacketMatchTypes_TCP_FLAGS {
	if t == nil || t.TcpFlags == nil {
		return nil
	}
	return t.TcpFlags
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_Transport) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_AclSet_AclEntry_Transport"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_AclSet_AclEntry_Transport) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_AclSet_AclEntry_Transport) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_AclSet_AclEntry_Transport.
func (*Acl_AclSet_AclEntry_Transport) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_AclSet_AclEntry_Transport_DestinationPort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port within the YANG schema.
type Acl_AclSet_AclEntry_Transport_DestinationPort_Union interface {
	Is_Acl_AclSet_AclEntry_Transport_DestinationPort_Union()
}

// Acl_AclSet_AclEntry_Transport_DestinationPort_Union_E_PacketMatchTypes_PortNumRange_Enum is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port
// is to be set to a E_PacketMatchTypes_PortNumRange_Enum value.
type Acl_AclSet_AclEntry_Transport_DestinationPort_Union_E_PacketMatchTypes_PortNumRange_Enum struct {
	E_PacketMatchTypes_PortNumRange_Enum E_PacketMatchTypes_PortNumRange_Enum
}

// Is_Acl_AclSet_AclEntry_Transport_DestinationPort_Union ensures that Acl_AclSet_AclEntry_Transport_DestinationPort_Union_E_PacketMatchTypes_PortNumRange_Enum
// implements the Acl_AclSet_AclEntry_Transport_DestinationPort_Union interface.
func (*Acl_AclSet_AclEntry_Transport_DestinationPort_Union_E_PacketMatchTypes_PortNumRange_Enum) Is_Acl_AclSet_AclEntry_Transport_DestinationPort_Union() {
}

// Acl_AclSet_AclEntry_Transport_DestinationPort_Union_String is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port
// is to be set to a string value.
type Acl_AclSet_AclEntry_Transport_DestinationPort_Union_String struct {
	String string
}

// Is_Acl_AclSet_AclEntry_Transport_DestinationPort_Union ensures that Acl_AclSet_AclEntry_Transport_DestinationPort_Union_String
// implements the Acl_AclSet_AclEntry_Transport_DestinationPort_Union interface.
func (*Acl_AclSet_AclEntry_Transport_DestinationPort_Union_String) Is_Acl_AclSet_AclEntry_Transport_DestinationPort_Union() {
}

// Acl_AclSet_AclEntry_Transport_DestinationPort_Union_Uint16 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port
// is to be set to a uint16 value.
type Acl_AclSet_AclEntry_Transport_DestinationPort_Union_Uint16 struct {
	Uint16 uint16
}

// Is_Acl_AclSet_AclEntry_Transport_DestinationPort_Union ensures that Acl_AclSet_AclEntry_Transport_DestinationPort_Union_Uint16
// implements the Acl_AclSet_AclEntry_Transport_DestinationPort_Union interface.
func (*Acl_AclSet_AclEntry_Transport_DestinationPort_Union_Uint16) Is_Acl_AclSet_AclEntry_Transport_DestinationPort_Union() {
}

// To_Acl_AclSet_AclEntry_Transport_DestinationPort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the Acl_AclSet_AclEntry_Transport_DestinationPort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *Acl_AclSet_AclEntry_Transport) To_Acl_AclSet_AclEntry_Transport_DestinationPort_Union(i interface{}) (Acl_AclSet_AclEntry_Transport_DestinationPort_Union, error) {
	switch v := i.(type) {
	case E_PacketMatchTypes_PortNumRange_Enum:
		return &Acl_AclSet_AclEntry_Transport_DestinationPort_Union_E_PacketMatchTypes_PortNumRange_Enum{v}, nil
	case string:
		return &Acl_AclSet_AclEntry_Transport_DestinationPort_Union_String{v}, nil
	case uint16:
		return &Acl_AclSet_AclEntry_Transport_DestinationPort_Union_Uint16{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to Acl_AclSet_AclEntry_Transport_DestinationPort_Union, unknown union type, got: %T, want any of [E_PacketMatchTypes_PortNumRange_Enum, string, uint16]", i, i)
	}
}

// Acl_AclSet_AclEntry_Transport_SourcePort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port within the YANG schema.
type Acl_AclSet_AclEntry_Transport_SourcePort_Union interface {
	Is_Acl_AclSet_AclEntry_Transport_SourcePort_Union()
}

// Acl_AclSet_AclEntry_Transport_SourcePort_Union_E_PacketMatchTypes_PortNumRange_Enum is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port
// is to be set to a E_PacketMatchTypes_PortNumRange_Enum value.
type Acl_AclSet_AclEntry_Transport_SourcePort_Union_E_PacketMatchTypes_PortNumRange_Enum struct {
	E_PacketMatchTypes_PortNumRange_Enum E_PacketMatchTypes_PortNumRange_Enum
}

// Is_Acl_AclSet_AclEntry_Transport_SourcePort_Union ensures that Acl_AclSet_AclEntry_Transport_SourcePort_Union_E_PacketMatchTypes_PortNumRange_Enum
// implements the Acl_AclSet_AclEntry_Transport_SourcePort_Union interface.
func (*Acl_AclSet_AclEntry_Transport_SourcePort_Union_E_PacketMatchTypes_PortNumRange_Enum) Is_Acl_AclSet_AclEntry_Transport_SourcePort_Union() {
}

// Acl_AclSet_AclEntry_Transport_SourcePort_Union_String is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port
// is to be set to a string value.
type Acl_AclSet_AclEntry_Transport_SourcePort_Union_String struct {
	String string
}

// Is_Acl_AclSet_AclEntry_Transport_SourcePort_Union ensures that Acl_AclSet_AclEntry_Transport_SourcePort_Union_String
// implements the Acl_AclSet_AclEntry_Transport_SourcePort_Union interface.
func (*Acl_AclSet_AclEntry_Transport_SourcePort_Union_String) Is_Acl_AclSet_AclEntry_Transport_SourcePort_Union() {
}

// Acl_AclSet_AclEntry_Transport_SourcePort_Union_Uint16 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port
// is to be set to a uint16 value.
type Acl_AclSet_AclEntry_Transport_SourcePort_Union_Uint16 struct {
	Uint16 uint16
}

// Is_Acl_AclSet_AclEntry_Transport_SourcePort_Union ensures that Acl_AclSet_AclEntry_Transport_SourcePort_Union_Uint16
// implements the Acl_AclSet_AclEntry_Transport_SourcePort_Union interface.
func (*Acl_AclSet_AclEntry_Transport_SourcePort_Union_Uint16) Is_Acl_AclSet_AclEntry_Transport_SourcePort_Union() {
}

// To_Acl_AclSet_AclEntry_Transport_SourcePort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the Acl_AclSet_AclEntry_Transport_SourcePort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *Acl_AclSet_AclEntry_Transport) To_Acl_AclSet_AclEntry_Transport_SourcePort_Union(i interface{}) (Acl_AclSet_AclEntry_Transport_SourcePort_Union, error) {
	switch v := i.(type) {
	case E_PacketMatchTypes_PortNumRange_Enum:
		return &Acl_AclSet_AclEntry_Transport_SourcePort_Union_E_PacketMatchTypes_PortNumRange_Enum{v}, nil
	case string:
		return &Acl_AclSet_AclEntry_Transport_SourcePort_Union_String{v}, nil
	case uint16:
		return &Acl_AclSet_AclEntry_Transport_SourcePort_Union_Uint16{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to Acl_AclSet_AclEntry_Transport_SourcePort_Union, unknown union type, got: %T, want any of [E_PacketMatchTypes_PortNumRange_Enum, string, uint16]", i, i)
	}
}

// Acl_Interface represents the /openconfig-acl/acl/interfaces/interface YANG schema element.
type Acl_Interface struct {
	ΛMetadata      []ygot.Annotation                                                `path:"@" ygotAnnotation:"true"`
	EgressAclSet   map[Acl_Interface_EgressAclSet_Key]*Acl_Interface_EgressAclSet   `path:"egress-acl-sets/egress-acl-set" module:"openconfig-acl/openconfig-acl"`
	ΛEgressAclSet  []ygot.Annotation                                                `path:"egress-acl-sets/@egress-acl-set" ygotAnnotation:"true"`
	Id             *string                                                          `path:"config/id|id" module:"openconfig-acl/openconfig-acl|openconfig-acl"`
	ΛId            []ygot.Annotation                                                `path:"config/@id|@id" ygotAnnotation:"true"`
	IngressAclSet  map[Acl_Interface_IngressAclSet_Key]*Acl_Interface_IngressAclSet `path:"ingress-acl-sets/ingress-acl-set" module:"openconfig-acl/openconfig-acl"`
	ΛIngressAclSet []ygot.Annotation                                                `path:"ingress-acl-sets/@ingress-acl-set" ygotAnnotation:"true"`
	InterfaceRef   *Acl_Interface_InterfaceRef                                      `path:"interface-ref" module:"openconfig-acl"`
	ΛInterfaceRef  []ygot.Annotation                                                `path:"@interface-ref" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_Interface) IsYANGGoStruct() {}

// Acl_Interface_EgressAclSet_Key represents the key for list EgressAclSet of element /openconfig-acl/acl/interfaces/interface.
type Acl_Interface_EgressAclSet_Key struct {
	SetName string         `path:"set-name"`
	Type    E_Acl_ACL_TYPE `path:"type"`
}

// IsYANGGoKeyStruct ensures that Acl_Interface_EgressAclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (Acl_Interface_EgressAclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the Acl_Interface_EgressAclSet_Key key struct.
func (t Acl_Interface_EgressAclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"set-name": t.SetName,
		"type":     t.Type,
	}, nil
}

// Acl_Interface_IngressAclSet_Key represents the key for list IngressAclSet of element /openconfig-acl/acl/interfaces/interface.
type Acl_Interface_IngressAclSet_Key struct {
	SetName string         `path:"set-name"`
	Type    E_Acl_ACL_TYPE `path:"type"`
}

// IsYANGGoKeyStruct ensures that Acl_Interface_IngressAclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (Acl_Interface_IngressAclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the Acl_Interface_IngressAclSet_Key key struct.
func (t Acl_Interface_IngressAclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"set-name": t.SetName,
		"type":     t.Type,
	}, nil
}

// NewEgressAclSet creates a new entry in the EgressAclSet list of the
// Acl_Interface struct. The keys of the list are populated from the input
// arguments.
func (t *Acl_Interface) NewEgressAclSet(SetName string, Type E_Acl_ACL_TYPE) (*Acl_Interface_EgressAclSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.EgressAclSet == nil {
		t.EgressAclSet = make(map[Acl_Interface_EgressAclSet_Key]*Acl_Interface_EgressAclSet)
	}

	key := Acl_Interface_EgressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.EgressAclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list EgressAclSet", key)
	}

	t.EgressAclSet[key] = &Acl_Interface_EgressAclSet{
		SetName: &SetName,
		Type:    Type,
	}

	return t.EgressAclSet[key], nil
}

// RenameEgressAclSet renames an entry in the list EgressAclSet within
// the Acl_Interface struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Acl_Interface) RenameEgressAclSet(oldK, newK Acl_Interface_EgressAclSet_Key) error {
	if _, ok := t.EgressAclSet[newK]; ok {
		return fmt.Errorf("key %v already exists in EgressAclSet", newK)
	}

	e, ok := t.EgressAclSet[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in EgressAclSet", oldK)
	}
	e.SetName = &newK.SetName
	e.Type = newK.Type

	t.EgressAclSet[newK] = e
	delete(t.EgressAclSet, oldK)
	return nil
}

// GetOrCreateEgressAclSet retrieves the value with the specified keys from
// the receiver Acl_Interface. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Acl_Interface) GetOrCreateEgressAclSet(SetName string, Type E_Acl_ACL_TYPE) *Acl_Interface_EgressAclSet {

	key := Acl_Interface_EgressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	if v, ok := t.EgressAclSet[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewEgressAclSet(SetName, Type)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateEgressAclSet got unexpected error: %v", err))
	}
	return v
}

// GetEgressAclSet retrieves the value with the specified key from
// the EgressAclSet map field of Acl_Interface. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Acl_Interface) GetEgressAclSet(SetName string, Type E_Acl_ACL_TYPE) *Acl_Interface_EgressAclSet {

	if t == nil {
		return nil
	}

	key := Acl_Interface_EgressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	if lm, ok := t.EgressAclSet[key]; ok {
		return lm
	}
	return nil
}

// AppendEgressAclSet appends the supplied Acl_Interface_EgressAclSet struct to the
// list EgressAclSet of Acl_Interface. If the key value(s) specified in
// the supplied Acl_Interface_EgressAclSet already exist in the list, an error is
// returned.
func (t *Acl_Interface) AppendEgressAclSet(v *Acl_Interface_EgressAclSet) error {
	if v.SetName == nil {
		return fmt.Errorf("invalid nil key for SetName")
	}

	key := Acl_Interface_EgressAclSet_Key{
		SetName: *v.SetName,
		Type:    v.Type,
	}

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.EgressAclSet == nil {
		t.EgressAclSet = make(map[Acl_Interface_EgressAclSet_Key]*Acl_Interface_EgressAclSet)
	}

	if _, ok := t.EgressAclSet[key]; ok {
		return fmt.Errorf("duplicate key for list EgressAclSet %v", key)
	}

	t.EgressAclSet[key] = v
	return nil
}

// NewIngressAclSet creates a new entry in the IngressAclSet list of the
// Acl_Interface struct. The keys of the list are populated from the input
// arguments.
func (t *Acl_Interface) NewIngressAclSet(SetName string, Type E_Acl_ACL_TYPE) (*Acl_Interface_IngressAclSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.IngressAclSet == nil {
		t.IngressAclSet = make(map[Acl_Interface_IngressAclSet_Key]*Acl_Interface_IngressAclSet)
	}

	key := Acl_Interface_IngressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.IngressAclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list IngressAclSet", key)
	}

	t.IngressAclSet[key] = &Acl_Interface_IngressAclSet{
		SetName: &SetName,
		Type:    Type,
	}

	return t.IngressAclSet[key], nil
}

// RenameIngressAclSet renames an entry in the list IngressAclSet within
// the Acl_Interface struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Acl_Interface) RenameIngressAclSet(oldK, newK Acl_Interface_IngressAclSet_Key) error {
	if _, ok := t.IngressAclSet[newK]; ok {
		return fmt.Errorf("key %v already exists in IngressAclSet", newK)
	}

	e, ok := t.IngressAclSet[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in IngressAclSet", oldK)
	}
	e.SetName = &newK.SetName
	e.Type = newK.Type

	t.IngressAclSet[newK] = e
	delete(t.IngressAclSet, oldK)
	return nil
}

// GetOrCreateIngressAclSet retrieves the value with the specified keys from
// the receiver Acl_Interface. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Acl_Interface) GetOrCreateIngressAclSet(SetName string, Type E_Acl_ACL_TYPE) *Acl_Interface_IngressAclSet {

	key := Acl_Interface_IngressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	if v, ok := t.IngressAclSet[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewIngressAclSet(SetName, Type)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateIngressAclSet got unexpected error: %v", err))
	}
	return v
}

// GetIngressAclSet retrieves the value with the specified key from
// the IngressAclSet map field of Acl_Interface. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Acl_Interface) GetIngressAclSet(SetName string, Type E_Acl_ACL_TYPE) *Acl_Interface_IngressAclSet {

	if t == nil {
		return nil
	}

	key := Acl_Interface_IngressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	if lm, ok := t.IngressAclSet[key]; ok {
		return lm
	}
	return nil
}

// AppendIngressAclSet appends the supplied Acl_Interface_IngressAclSet struct to the
// list IngressAclSet of Acl_Interface. If the key value(s) specified in
// the supplied Acl_Interface_IngressAclSet already exist in the list, an error is
// returned.
func (t *Acl_Interface) AppendIngressAclSet(v *Acl_Interface_IngressAclSet) error {
	if v.SetName == nil {
		return fmt.Errorf("invalid nil key for SetName")
	}

	key := Acl_Interface_IngressAclSet_Key{
		SetName: *v.SetName,
		Type:    v.Type,
	}

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.IngressAclSet == nil {
		t.IngressAclSet = make(map[Acl_Interface_IngressAclSet_Key]*Acl_Interface_IngressAclSet)
	}

	if _, ok := t.IngressAclSet[key]; ok {
		return fmt.Errorf("duplicate key for list IngressAclSet %v", key)
	}

	t.IngressAclSet[key] = v
	return nil
}

// GetOrCreateInterfaceRef retrieves the value of the InterfaceRef field
// or returns the existing field if it already exists.
func (t *Acl_Interface) GetOrCreateInterfaceRef() *Acl_Interface_InterfaceRef {
	if t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	t.InterfaceRef = &Acl_Interface_InterfaceRef{}
	return t.InterfaceRef
}

// GetInterfaceRef returns the value of the InterfaceRef struct pointer
// from Acl_Interface. If the receiver or the field InterfaceRef is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Acl_Interface) GetInterfaceRef() *Acl_Interface_InterfaceRef {
	if t != nil && t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	return nil
}

// GetId retrieves the value of the leaf Id from the Acl_Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Id is set, it can
// safely use t.GetId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Id == nil' before retrieving the leaf's value.
func (t *Acl_Interface) GetId() string {
	if t == nil || t.Id == nil {
		return ""
	}
	return *t.Id
}

// ΛListKeyMap returns the keys of the Acl_Interface struct, which is a YANG list entry.
func (t *Acl_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_Interface.
func (*Acl_Interface) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_Interface_EgressAclSet represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set YANG schema element.
type Acl_Interface_EgressAclSet struct {
	ΛMetadata []ygot.Annotation                               `path:"@" ygotAnnotation:"true"`
	AclEntry  map[uint32]*Acl_Interface_EgressAclSet_AclEntry `path:"acl-entries/acl-entry" module:"openconfig-acl/openconfig-acl"`
	ΛAclEntry []ygot.Annotation                               `path:"acl-entries/@acl-entry" ygotAnnotation:"true"`
	SetName   *string                                         `path:"config/set-name|set-name" module:"openconfig-acl/openconfig-acl|openconfig-acl"`
	ΛSetName  []ygot.Annotation                               `path:"config/@set-name|@set-name" ygotAnnotation:"true"`
	Type      E_Acl_ACL_TYPE                                  `path:"config/type|type" module:"openconfig-acl/openconfig-acl|openconfig-acl"`
	ΛType     []ygot.Annotation                               `path:"config/@type|@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_Interface_EgressAclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_Interface_EgressAclSet) IsYANGGoStruct() {}

// NewAclEntry creates a new entry in the AclEntry list of the
// Acl_Interface_EgressAclSet struct. The keys of the list are populated from the input
// arguments.
func (t *Acl_Interface_EgressAclSet) NewAclEntry(SequenceId uint32) (*Acl_Interface_EgressAclSet_AclEntry, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*Acl_Interface_EgressAclSet_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &Acl_Interface_EgressAclSet_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// RenameAclEntry renames an entry in the list AclEntry within
// the Acl_Interface_EgressAclSet struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Acl_Interface_EgressAclSet) RenameAclEntry(oldK, newK uint32) error {
	if _, ok := t.AclEntry[newK]; ok {
		return fmt.Errorf("key %v already exists in AclEntry", newK)
	}

	e, ok := t.AclEntry[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in AclEntry", oldK)
	}
	e.SequenceId = &newK

	t.AclEntry[newK] = e
	delete(t.AclEntry, oldK)
	return nil
}

// GetOrCreateAclEntry retrieves the value with the specified keys from
// the receiver Acl_Interface_EgressAclSet. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Acl_Interface_EgressAclSet) GetOrCreateAclEntry(SequenceId uint32) *Acl_Interface_EgressAclSet_AclEntry {

	key := SequenceId

	if v, ok := t.AclEntry[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewAclEntry(SequenceId)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateAclEntry got unexpected error: %v", err))
	}
	return v
}

// GetAclEntry retrieves the value with the specified key from
// the AclEntry map field of Acl_Interface_EgressAclSet. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Acl_Interface_EgressAclSet) GetAclEntry(SequenceId uint32) *Acl_Interface_EgressAclSet_AclEntry {

	if t == nil {
		return nil
	}

	key := SequenceId

	if lm, ok := t.AclEntry[key]; ok {
		return lm
	}
	return nil
}

// AppendAclEntry appends the supplied Acl_Interface_EgressAclSet_AclEntry struct to the
// list AclEntry of Acl_Interface_EgressAclSet. If the key value(s) specified in
// the supplied Acl_Interface_EgressAclSet_AclEntry already exist in the list, an error is
// returned.
func (t *Acl_Interface_EgressAclSet) AppendAclEntry(v *Acl_Interface_EgressAclSet_AclEntry) error {
	if v.SequenceId == nil {
		return fmt.Errorf("invalid nil key received for SequenceId")
	}

	key := *v.SequenceId

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*Acl_Interface_EgressAclSet_AclEntry)
	}

	if _, ok := t.AclEntry[key]; ok {
		return fmt.Errorf("duplicate key for list AclEntry %v", key)
	}

	t.AclEntry[key] = v
	return nil
}

// GetSetName retrieves the value of the leaf SetName from the Acl_Interface_EgressAclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SetName is set, it can
// safely use t.GetSetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SetName == nil' before retrieving the leaf's value.
func (t *Acl_Interface_EgressAclSet) GetSetName() string {
	if t == nil || t.SetName == nil {
		return ""
	}
	return *t.SetName
}

// GetType retrieves the value of the leaf Type from the Acl_Interface_EgressAclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *Acl_Interface_EgressAclSet) GetType() E_Acl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// ΛListKeyMap returns the keys of the Acl_Interface_EgressAclSet struct, which is a YANG list entry.
func (t *Acl_Interface_EgressAclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SetName == nil {
		return nil, fmt.Errorf("nil value for key SetName")
	}

	return map[string]interface{}{
		"set-name": *t.SetName,
		"type":     t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface_EgressAclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_Interface_EgressAclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface_EgressAclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_Interface_EgressAclSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_Interface_EgressAclSet.
func (*Acl_Interface_EgressAclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_Interface_EgressAclSet_AclEntry represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry YANG schema element.
type Acl_Interface_EgressAclSet_AclEntry struct {
	ΛMetadata       []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	MatchedOctets   *uint64           `path:"state/matched-octets" module:"openconfig-acl/openconfig-acl"`
	ΛMatchedOctets  []ygot.Annotation `path:"state/@matched-octets" ygotAnnotation:"true"`
	MatchedPackets  *uint64           `path:"state/matched-packets" module:"openconfig-acl/openconfig-acl"`
	ΛMatchedPackets []ygot.Annotation `path:"state/@matched-packets" ygotAnnotation:"true"`
	SequenceId      *uint32           `path:"state/sequence-id|sequence-id" module:"openconfig-acl/openconfig-acl|openconfig-acl"`
	ΛSequenceId     []ygot.Annotation `path:"state/@sequence-id|@sequence-id" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_Interface_EgressAclSet_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_Interface_EgressAclSet_AclEntry) IsYANGGoStruct() {}

// GetMatchedOctets retrieves the value of the leaf MatchedOctets from the Acl_Interface_EgressAclSet_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedOctets is set, it can
// safely use t.GetMatchedOctets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedOctets == nil' before retrieving the leaf's value.
func (t *Acl_Interface_EgressAclSet_AclEntry) GetMatchedOctets() uint64 {
	if t == nil || t.MatchedOctets == nil {
		return 0
	}
	return *t.MatchedOctets
}

// GetMatchedPackets retrieves the value of the leaf MatchedPackets from the Acl_Interface_EgressAclSet_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedPackets is set, it can
// safely use t.GetMatchedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedPackets == nil' before retrieving the leaf's value.
func (t *Acl_Interface_EgressAclSet_AclEntry) GetMatchedPackets() uint64 {
	if t == nil || t.MatchedPackets == nil {
		return 0
	}
	return *t.MatchedPackets
}

// GetSequenceId retrieves the value of the leaf SequenceId from the Acl_Interface_EgressAclSet_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SequenceId is set, it can
// safely use t.GetSequenceId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SequenceId == nil' before retrieving the leaf's value.
func (t *Acl_Interface_EgressAclSet_AclEntry) GetSequenceId() uint32 {
	if t == nil || t.SequenceId == nil {
		return 0
	}
	return *t.SequenceId
}

// ΛListKeyMap returns the keys of the Acl_Interface_EgressAclSet_AclEntry struct, which is a YANG list entry.
func (t *Acl_Interface_EgressAclSet_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface_EgressAclSet_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_Interface_EgressAclSet_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface_EgressAclSet_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_Interface_EgressAclSet_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_Interface_EgressAclSet_AclEntry.
func (*Acl_Interface_EgressAclSet_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_Interface_IngressAclSet represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set YANG schema element.
type Acl_Interface_IngressAclSet struct {
	ΛMetadata []ygot.Annotation                                `path:"@" ygotAnnotation:"true"`
	AclEntry  map[uint32]*Acl_Interface_IngressAclSet_AclEntry `path:"acl-entries/acl-entry" module:"openconfig-acl/openconfig-acl"`
	ΛAclEntry []ygot.Annotation                                `path:"acl-entries/@acl-entry" ygotAnnotation:"true"`
	SetName   *string                                          `path:"config/set-name|set-name" module:"openconfig-acl/openconfig-acl|openconfig-acl"`
	ΛSetName  []ygot.Annotation                                `path:"config/@set-name|@set-name" ygotAnnotation:"true"`
	Type      E_Acl_ACL_TYPE                                   `path:"config/type|type" module:"openconfig-acl/openconfig-acl|openconfig-acl"`
	ΛType     []ygot.Annotation                                `path:"config/@type|@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_Interface_IngressAclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_Interface_IngressAclSet) IsYANGGoStruct() {}

// NewAclEntry creates a new entry in the AclEntry list of the
// Acl_Interface_IngressAclSet struct. The keys of the list are populated from the input
// arguments.
func (t *Acl_Interface_IngressAclSet) NewAclEntry(SequenceId uint32) (*Acl_Interface_IngressAclSet_AclEntry, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*Acl_Interface_IngressAclSet_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &Acl_Interface_IngressAclSet_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// RenameAclEntry renames an entry in the list AclEntry within
// the Acl_Interface_IngressAclSet struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Acl_Interface_IngressAclSet) RenameAclEntry(oldK, newK uint32) error {
	if _, ok := t.AclEntry[newK]; ok {
		return fmt.Errorf("key %v already exists in AclEntry", newK)
	}

	e, ok := t.AclEntry[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in AclEntry", oldK)
	}
	e.SequenceId = &newK

	t.AclEntry[newK] = e
	delete(t.AclEntry, oldK)
	return nil
}

// GetOrCreateAclEntry retrieves the value with the specified keys from
// the receiver Acl_Interface_IngressAclSet. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Acl_Interface_IngressAclSet) GetOrCreateAclEntry(SequenceId uint32) *Acl_Interface_IngressAclSet_AclEntry {

	key := SequenceId

	if v, ok := t.AclEntry[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewAclEntry(SequenceId)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateAclEntry got unexpected error: %v", err))
	}
	return v
}

// GetAclEntry retrieves the value with the specified key from
// the AclEntry map field of Acl_Interface_IngressAclSet. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Acl_Interface_IngressAclSet) GetAclEntry(SequenceId uint32) *Acl_Interface_IngressAclSet_AclEntry {

	if t == nil {
		return nil
	}

	key := SequenceId

	if lm, ok := t.AclEntry[key]; ok {
		return lm
	}
	return nil
}

// AppendAclEntry appends the supplied Acl_Interface_IngressAclSet_AclEntry struct to the
// list AclEntry of Acl_Interface_IngressAclSet. If the key value(s) specified in
// the supplied Acl_Interface_IngressAclSet_AclEntry already exist in the list, an error is
// returned.
func (t *Acl_Interface_IngressAclSet) AppendAclEntry(v *Acl_Interface_IngressAclSet_AclEntry) error {
	if v.SequenceId == nil {
		return fmt.Errorf("invalid nil key received for SequenceId")
	}

	key := *v.SequenceId

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*Acl_Interface_IngressAclSet_AclEntry)
	}

	if _, ok := t.AclEntry[key]; ok {
		return fmt.Errorf("duplicate key for list AclEntry %v", key)
	}

	t.AclEntry[key] = v
	return nil
}

// GetSetName retrieves the value of the leaf SetName from the Acl_Interface_IngressAclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SetName is set, it can
// safely use t.GetSetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SetName == nil' before retrieving the leaf's value.
func (t *Acl_Interface_IngressAclSet) GetSetName() string {
	if t == nil || t.SetName == nil {
		return ""
	}
	return *t.SetName
}

// GetType retrieves the value of the leaf Type from the Acl_Interface_IngressAclSet
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *Acl_Interface_IngressAclSet) GetType() E_Acl_ACL_TYPE {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// ΛListKeyMap returns the keys of the Acl_Interface_IngressAclSet struct, which is a YANG list entry.
func (t *Acl_Interface_IngressAclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SetName == nil {
		return nil, fmt.Errorf("nil value for key SetName")
	}

	return map[string]interface{}{
		"set-name": *t.SetName,
		"type":     t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface_IngressAclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_Interface_IngressAclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface_IngressAclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_Interface_IngressAclSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_Interface_IngressAclSet.
func (*Acl_Interface_IngressAclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_Interface_IngressAclSet_AclEntry represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry YANG schema element.
type Acl_Interface_IngressAclSet_AclEntry struct {
	ΛMetadata       []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	MatchedOctets   *uint64           `path:"state/matched-octets" module:"openconfig-acl/openconfig-acl"`
	ΛMatchedOctets  []ygot.Annotation `path:"state/@matched-octets" ygotAnnotation:"true"`
	MatchedPackets  *uint64           `path:"state/matched-packets" module:"openconfig-acl/openconfig-acl"`
	ΛMatchedPackets []ygot.Annotation `path:"state/@matched-packets" ygotAnnotation:"true"`
	SequenceId      *uint32           `path:"state/sequence-id|sequence-id" module:"openconfig-acl/openconfig-acl|openconfig-acl"`
	ΛSequenceId     []ygot.Annotation `path:"state/@sequence-id|@sequence-id" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_Interface_IngressAclSet_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_Interface_IngressAclSet_AclEntry) IsYANGGoStruct() {}

// GetMatchedOctets retrieves the value of the leaf MatchedOctets from the Acl_Interface_IngressAclSet_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedOctets is set, it can
// safely use t.GetMatchedOctets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedOctets == nil' before retrieving the leaf's value.
func (t *Acl_Interface_IngressAclSet_AclEntry) GetMatchedOctets() uint64 {
	if t == nil || t.MatchedOctets == nil {
		return 0
	}
	return *t.MatchedOctets
}

// GetMatchedPackets retrieves the value of the leaf MatchedPackets from the Acl_Interface_IngressAclSet_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MatchedPackets is set, it can
// safely use t.GetMatchedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MatchedPackets == nil' before retrieving the leaf's value.
func (t *Acl_Interface_IngressAclSet_AclEntry) GetMatchedPackets() uint64 {
	if t == nil || t.MatchedPackets == nil {
		return 0
	}
	return *t.MatchedPackets
}

// GetSequenceId retrieves the value of the leaf SequenceId from the Acl_Interface_IngressAclSet_AclEntry
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SequenceId is set, it can
// safely use t.GetSequenceId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SequenceId == nil' before retrieving the leaf's value.
func (t *Acl_Interface_IngressAclSet_AclEntry) GetSequenceId() uint32 {
	if t == nil || t.SequenceId == nil {
		return 0
	}
	return *t.SequenceId
}

// ΛListKeyMap returns the keys of the Acl_Interface_IngressAclSet_AclEntry struct, which is a YANG list entry.
func (t *Acl_Interface_IngressAclSet_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface_IngressAclSet_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_Interface_IngressAclSet_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface_IngressAclSet_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_Interface_IngressAclSet_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_Interface_IngressAclSet_AclEntry.
func (*Acl_Interface_IngressAclSet_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Acl_Interface_InterfaceRef represents the /openconfig-acl/acl/interfaces/interface/interface-ref YANG schema element.
type Acl_Interface_InterfaceRef struct {
	ΛMetadata     []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Interface     *string           `path:"config/interface" module:"openconfig-acl/openconfig-acl"`
	ΛInterface    []ygot.Annotation `path:"config/@interface" ygotAnnotation:"true"`
	Subinterface  *uint32           `path:"config/subinterface" module:"openconfig-acl/openconfig-acl"`
	ΛSubinterface []ygot.Annotation `path:"config/@subinterface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Acl_Interface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Acl_Interface_InterfaceRef) IsYANGGoStruct() {}

// GetInterface retrieves the value of the leaf Interface from the Acl_Interface_InterfaceRef
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interface is set, it can
// safely use t.GetInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interface == nil' before retrieving the leaf's value.
func (t *Acl_Interface_InterfaceRef) GetInterface() string {
	if t == nil || t.Interface == nil {
		return ""
	}
	return *t.Interface
}

// GetSubinterface retrieves the value of the leaf Subinterface from the Acl_Interface_InterfaceRef
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Subinterface is set, it can
// safely use t.GetSubinterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Subinterface == nil' before retrieving the leaf's value.
func (t *Acl_Interface_InterfaceRef) GetSubinterface() uint32 {
	if t == nil || t.Subinterface == nil {
		return 0
	}
	return *t.Subinterface
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Acl_Interface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Acl_Interface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Acl_Interface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Acl_Interface_InterfaceRef.
func (*Acl_Interface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-acl"
}

// Aps represents the /openconfig-transport-line-protection/aps YANG schema element.
type Aps struct {
	ΛMetadata  []ygot.Annotation         `path:"@" ygotAnnotation:"true"`
	ApsModule  map[string]*Aps_ApsModule `path:"aps-modules/aps-module" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛApsModule []ygot.Annotation         `path:"aps-modules/@aps-module" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps) IsYANGGoStruct() {}

// NewApsModule creates a new entry in the ApsModule list of the
// Aps struct. The keys of the list are populated from the input
// arguments.
func (t *Aps) NewApsModule(Name string) (*Aps_ApsModule, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.ApsModule == nil {
		t.ApsModule = make(map[string]*Aps_ApsModule)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.ApsModule[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list ApsModule", key)
	}

	t.ApsModule[key] = &Aps_ApsModule{
		Name: &Name,
	}

	return t.ApsModule[key], nil
}

// RenameApsModule renames an entry in the list ApsModule within
// the Aps struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Aps) RenameApsModule(oldK, newK string) error {
	if _, ok := t.ApsModule[newK]; ok {
		return fmt.Errorf("key %v already exists in ApsModule", newK)
	}

	e, ok := t.ApsModule[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in ApsModule", oldK)
	}
	e.Name = &newK

	t.ApsModule[newK] = e
	delete(t.ApsModule, oldK)
	return nil
}

// GetOrCreateApsModule retrieves the value with the specified keys from
// the receiver Aps. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Aps) GetOrCreateApsModule(Name string) *Aps_ApsModule {

	key := Name

	if v, ok := t.ApsModule[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewApsModule(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateApsModule got unexpected error: %v", err))
	}
	return v
}

// GetApsModule retrieves the value with the specified key from
// the ApsModule map field of Aps. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Aps) GetApsModule(Name string) *Aps_ApsModule {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.ApsModule[key]; ok {
		return lm
	}
	return nil
}

// AppendApsModule appends the supplied Aps_ApsModule struct to the
// list ApsModule of Aps. If the key value(s) specified in
// the supplied Aps_ApsModule already exist in the list, an error is
// returned.
func (t *Aps) AppendApsModule(v *Aps_ApsModule) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.ApsModule == nil {
		t.ApsModule = make(map[string]*Aps_ApsModule)
	}

	if _, ok := t.ApsModule[key]; ok {
		return fmt.Errorf("duplicate key for list ApsModule %v", key)
	}

	t.ApsModule[key] = v
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps.
func (*Aps) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module YANG schema element.
type Aps_ApsModule struct {
	ΛMetadata                      []ygot.Annotation                   `path:"@" ygotAnnotation:"true"`
	ActivePath                     E_TransportLineProtection_APS_PATHS `path:"state/active-path" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛActivePath                    []ygot.Annotation                   `path:"state/@active-path" ygotAnnotation:"true"`
	ForceToPort                    E_ApsModule_ForceToPort             `path:"config/force-to-port" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛForceToPort                   []ygot.Annotation                   `path:"config/@force-to-port" ygotAnnotation:"true"`
	HoldOffTime                    *uint32                             `path:"config/hold-off-time" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛHoldOffTime                   []ygot.Annotation                   `path:"config/@hold-off-time" ygotAnnotation:"true"`
	Name                           *string                             `path:"config/name|name" module:"openconfig-transport-line-protection/openconfig-transport-line-protection|openconfig-transport-line-protection"`
	ΛName                          []ygot.Annotation                   `path:"config/@name|@name" ygotAnnotation:"true"`
	Ports                          *Aps_ApsModule_Ports                `path:"ports" module:"openconfig-transport-line-protection"`
	ΛPorts                         []ygot.Annotation                   `path:"@ports" ygotAnnotation:"true"`
	PrimarySwitchHysteresis        *float64                            `path:"config/primary-switch-hysteresis" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛPrimarySwitchHysteresis       []ygot.Annotation                   `path:"config/@primary-switch-hysteresis" ygotAnnotation:"true"`
	PrimarySwitchThreshold         *float64                            `path:"config/primary-switch-threshold" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛPrimarySwitchThreshold        []ygot.Annotation                   `path:"config/@primary-switch-threshold" ygotAnnotation:"true"`
	RelativeSwitchThreshold        *float64                            `path:"config/relative-switch-threshold" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛRelativeSwitchThreshold       []ygot.Annotation                   `path:"config/@relative-switch-threshold" ygotAnnotation:"true"`
	RelativeSwitchThresholdOffset  *float64                            `path:"config/relative-switch-threshold-offset" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛRelativeSwitchThresholdOffset []ygot.Annotation                   `path:"config/@relative-switch-threshold-offset" ygotAnnotation:"true"`
	Revertive                      *bool                               `path:"config/revertive" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛRevertive                     []ygot.Annotation                   `path:"config/@revertive" ygotAnnotation:"true"`
	SecondarySwitchThreshold       *float64                            `path:"config/secondary-switch-threshold" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛSecondarySwitchThreshold      []ygot.Annotation                   `path:"config/@secondary-switch-threshold" ygotAnnotation:"true"`
	WaitToRestoreTime              *uint32                             `path:"config/wait-to-restore-time" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛWaitToRestoreTime             []ygot.Annotation                   `path:"config/@wait-to-restore-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule) IsYANGGoStruct() {}

// GetOrCreatePorts retrieves the value of the Ports field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule) GetOrCreatePorts() *Aps_ApsModule_Ports {
	if t.Ports != nil {
		return t.Ports
	}
	t.Ports = &Aps_ApsModule_Ports{}
	return t.Ports
}

// GetPorts returns the value of the Ports struct pointer
// from Aps_ApsModule. If the receiver or the field Ports is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule) GetPorts() *Aps_ApsModule_Ports {
	if t != nil && t.Ports != nil {
		return t.Ports
	}
	return nil
}

// GetActivePath retrieves the value of the leaf ActivePath from the Aps_ApsModule
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ActivePath is set, it can
// safely use t.GetActivePath() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ActivePath == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule) GetActivePath() E_TransportLineProtection_APS_PATHS {
	if t == nil || t.ActivePath == 0 {
		return 0
	}
	return t.ActivePath
}

// GetForceToPort retrieves the value of the leaf ForceToPort from the Aps_ApsModule
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ForceToPort is set, it can
// safely use t.GetForceToPort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ForceToPort == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule) GetForceToPort() E_ApsModule_ForceToPort {
	if t == nil || t.ForceToPort == 0 {
		return ApsModule_ForceToPort_NONE
	}
	return t.ForceToPort
}

// GetHoldOffTime retrieves the value of the leaf HoldOffTime from the Aps_ApsModule
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HoldOffTime is set, it can
// safely use t.GetHoldOffTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HoldOffTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule) GetHoldOffTime() uint32 {
	if t == nil || t.HoldOffTime == nil {
		return 0
	}
	return *t.HoldOffTime
}

// GetName retrieves the value of the leaf Name from the Aps_ApsModule
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetPrimarySwitchHysteresis retrieves the value of the leaf PrimarySwitchHysteresis from the Aps_ApsModule
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if PrimarySwitchHysteresis is set, it can
// safely use t.GetPrimarySwitchHysteresis() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.PrimarySwitchHysteresis == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule) GetPrimarySwitchHysteresis() float64 {
	if t == nil || t.PrimarySwitchHysteresis == nil {
		return 0
	}
	return *t.PrimarySwitchHysteresis
}

// GetPrimarySwitchThreshold retrieves the value of the leaf PrimarySwitchThreshold from the Aps_ApsModule
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if PrimarySwitchThreshold is set, it can
// safely use t.GetPrimarySwitchThreshold() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.PrimarySwitchThreshold == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule) GetPrimarySwitchThreshold() float64 {
	if t == nil || t.PrimarySwitchThreshold == nil {
		return 0.0
	}
	return *t.PrimarySwitchThreshold
}

// GetRelativeSwitchThreshold retrieves the value of the leaf RelativeSwitchThreshold from the Aps_ApsModule
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RelativeSwitchThreshold is set, it can
// safely use t.GetRelativeSwitchThreshold() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RelativeSwitchThreshold == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule) GetRelativeSwitchThreshold() float64 {
	if t == nil || t.RelativeSwitchThreshold == nil {
		return 0
	}
	return *t.RelativeSwitchThreshold
}

// GetRelativeSwitchThresholdOffset retrieves the value of the leaf RelativeSwitchThresholdOffset from the Aps_ApsModule
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RelativeSwitchThresholdOffset is set, it can
// safely use t.GetRelativeSwitchThresholdOffset() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RelativeSwitchThresholdOffset == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule) GetRelativeSwitchThresholdOffset() float64 {
	if t == nil || t.RelativeSwitchThresholdOffset == nil {
		return 0
	}
	return *t.RelativeSwitchThresholdOffset
}

// GetRevertive retrieves the value of the leaf Revertive from the Aps_ApsModule
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Revertive is set, it can
// safely use t.GetRevertive() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Revertive == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule) GetRevertive() bool {
	if t == nil || t.Revertive == nil {
		return false
	}
	return *t.Revertive
}

// GetSecondarySwitchThreshold retrieves the value of the leaf SecondarySwitchThreshold from the Aps_ApsModule
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SecondarySwitchThreshold is set, it can
// safely use t.GetSecondarySwitchThreshold() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SecondarySwitchThreshold == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule) GetSecondarySwitchThreshold() float64 {
	if t == nil || t.SecondarySwitchThreshold == nil {
		return 0.0
	}
	return *t.SecondarySwitchThreshold
}

// GetWaitToRestoreTime retrieves the value of the leaf WaitToRestoreTime from the Aps_ApsModule
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if WaitToRestoreTime is set, it can
// safely use t.GetWaitToRestoreTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.WaitToRestoreTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule) GetWaitToRestoreTime() uint32 {
	if t == nil || t.WaitToRestoreTime == nil {
		return 0
	}
	return *t.WaitToRestoreTime
}

// ΛListKeyMap returns the keys of the Aps_ApsModule struct, which is a YANG list entry.
func (t *Aps_ApsModule) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule.
func (*Aps_ApsModule) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports YANG schema element.
type Aps_ApsModule_Ports struct {
	ΛMetadata         []ygot.Annotation                     `path:"@" ygotAnnotation:"true"`
	CommonIn          *Aps_ApsModule_Ports_CommonIn         `path:"common-in" module:"openconfig-transport-line-protection"`
	ΛCommonIn         []ygot.Annotation                     `path:"@common-in" ygotAnnotation:"true"`
	CommonOutput      *Aps_ApsModule_Ports_CommonOutput     `path:"common-output" module:"openconfig-transport-line-protection"`
	ΛCommonOutput     []ygot.Annotation                     `path:"@common-output" ygotAnnotation:"true"`
	LinePrimaryIn     *Aps_ApsModule_Ports_LinePrimaryIn    `path:"line-primary-in" module:"openconfig-transport-line-protection"`
	ΛLinePrimaryIn    []ygot.Annotation                     `path:"@line-primary-in" ygotAnnotation:"true"`
	LinePrimaryOut    *Aps_ApsModule_Ports_LinePrimaryOut   `path:"line-primary-out" module:"openconfig-transport-line-protection"`
	ΛLinePrimaryOut   []ygot.Annotation                     `path:"@line-primary-out" ygotAnnotation:"true"`
	LineSecondaryIn   *Aps_ApsModule_Ports_LineSecondaryIn  `path:"line-secondary-in" module:"openconfig-transport-line-protection"`
	ΛLineSecondaryIn  []ygot.Annotation                     `path:"@line-secondary-in" ygotAnnotation:"true"`
	LineSecondaryOut  *Aps_ApsModule_Ports_LineSecondaryOut `path:"line-secondary-out" module:"openconfig-transport-line-protection"`
	ΛLineSecondaryOut []ygot.Annotation                     `path:"@line-secondary-out" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports) IsYANGGoStruct() {}

// GetOrCreateCommonIn retrieves the value of the CommonIn field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports) GetOrCreateCommonIn() *Aps_ApsModule_Ports_CommonIn {
	if t.CommonIn != nil {
		return t.CommonIn
	}
	t.CommonIn = &Aps_ApsModule_Ports_CommonIn{}
	return t.CommonIn
}

// GetOrCreateCommonOutput retrieves the value of the CommonOutput field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports) GetOrCreateCommonOutput() *Aps_ApsModule_Ports_CommonOutput {
	if t.CommonOutput != nil {
		return t.CommonOutput
	}
	t.CommonOutput = &Aps_ApsModule_Ports_CommonOutput{}
	return t.CommonOutput
}

// GetOrCreateLinePrimaryIn retrieves the value of the LinePrimaryIn field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports) GetOrCreateLinePrimaryIn() *Aps_ApsModule_Ports_LinePrimaryIn {
	if t.LinePrimaryIn != nil {
		return t.LinePrimaryIn
	}
	t.LinePrimaryIn = &Aps_ApsModule_Ports_LinePrimaryIn{}
	return t.LinePrimaryIn
}

// GetOrCreateLinePrimaryOut retrieves the value of the LinePrimaryOut field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports) GetOrCreateLinePrimaryOut() *Aps_ApsModule_Ports_LinePrimaryOut {
	if t.LinePrimaryOut != nil {
		return t.LinePrimaryOut
	}
	t.LinePrimaryOut = &Aps_ApsModule_Ports_LinePrimaryOut{}
	return t.LinePrimaryOut
}

// GetOrCreateLineSecondaryIn retrieves the value of the LineSecondaryIn field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports) GetOrCreateLineSecondaryIn() *Aps_ApsModule_Ports_LineSecondaryIn {
	if t.LineSecondaryIn != nil {
		return t.LineSecondaryIn
	}
	t.LineSecondaryIn = &Aps_ApsModule_Ports_LineSecondaryIn{}
	return t.LineSecondaryIn
}

// GetOrCreateLineSecondaryOut retrieves the value of the LineSecondaryOut field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports) GetOrCreateLineSecondaryOut() *Aps_ApsModule_Ports_LineSecondaryOut {
	if t.LineSecondaryOut != nil {
		return t.LineSecondaryOut
	}
	t.LineSecondaryOut = &Aps_ApsModule_Ports_LineSecondaryOut{}
	return t.LineSecondaryOut
}

// GetCommonIn returns the value of the CommonIn struct pointer
// from Aps_ApsModule_Ports. If the receiver or the field CommonIn is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports) GetCommonIn() *Aps_ApsModule_Ports_CommonIn {
	if t != nil && t.CommonIn != nil {
		return t.CommonIn
	}
	return nil
}

// GetCommonOutput returns the value of the CommonOutput struct pointer
// from Aps_ApsModule_Ports. If the receiver or the field CommonOutput is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports) GetCommonOutput() *Aps_ApsModule_Ports_CommonOutput {
	if t != nil && t.CommonOutput != nil {
		return t.CommonOutput
	}
	return nil
}

// GetLinePrimaryIn returns the value of the LinePrimaryIn struct pointer
// from Aps_ApsModule_Ports. If the receiver or the field LinePrimaryIn is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports) GetLinePrimaryIn() *Aps_ApsModule_Ports_LinePrimaryIn {
	if t != nil && t.LinePrimaryIn != nil {
		return t.LinePrimaryIn
	}
	return nil
}

// GetLinePrimaryOut returns the value of the LinePrimaryOut struct pointer
// from Aps_ApsModule_Ports. If the receiver or the field LinePrimaryOut is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports) GetLinePrimaryOut() *Aps_ApsModule_Ports_LinePrimaryOut {
	if t != nil && t.LinePrimaryOut != nil {
		return t.LinePrimaryOut
	}
	return nil
}

// GetLineSecondaryIn returns the value of the LineSecondaryIn struct pointer
// from Aps_ApsModule_Ports. If the receiver or the field LineSecondaryIn is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports) GetLineSecondaryIn() *Aps_ApsModule_Ports_LineSecondaryIn {
	if t != nil && t.LineSecondaryIn != nil {
		return t.LineSecondaryIn
	}
	return nil
}

// GetLineSecondaryOut returns the value of the LineSecondaryOut struct pointer
// from Aps_ApsModule_Ports. If the receiver or the field LineSecondaryOut is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports) GetLineSecondaryOut() *Aps_ApsModule_Ports_LineSecondaryOut {
	if t != nil && t.LineSecondaryOut != nil {
		return t.LineSecondaryOut
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports.
func (*Aps_ApsModule_Ports) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_CommonIn represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in YANG schema element.
type Aps_ApsModule_Ports_CommonIn struct {
	ΛMetadata          []ygot.Annotation                          `path:"@" ygotAnnotation:"true"`
	Attenuation        *float64                                   `path:"state/attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛAttenuation       []ygot.Annotation                          `path:"state/@attenuation" ygotAnnotation:"true"`
	Enabled            *bool                                      `path:"config/enabled" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛEnabled           []ygot.Annotation                          `path:"config/@enabled" ygotAnnotation:"true"`
	OpticalPower       *Aps_ApsModule_Ports_CommonIn_OpticalPower `path:"state/optical-power" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛOpticalPower      []ygot.Annotation                          `path:"state/@optical-power" ygotAnnotation:"true"`
	TargetAttenuation  *float64                                   `path:"config/target-attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛTargetAttenuation []ygot.Annotation                          `path:"config/@target-attenuation" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_CommonIn implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_CommonIn) IsYANGGoStruct() {}

// GetOrCreateOpticalPower retrieves the value of the OpticalPower field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports_CommonIn) GetOrCreateOpticalPower() *Aps_ApsModule_Ports_CommonIn_OpticalPower {
	if t.OpticalPower != nil {
		return t.OpticalPower
	}
	t.OpticalPower = &Aps_ApsModule_Ports_CommonIn_OpticalPower{}
	return t.OpticalPower
}

// GetOpticalPower returns the value of the OpticalPower struct pointer
// from Aps_ApsModule_Ports_CommonIn. If the receiver or the field OpticalPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports_CommonIn) GetOpticalPower() *Aps_ApsModule_Ports_CommonIn_OpticalPower {
	if t != nil && t.OpticalPower != nil {
		return t.OpticalPower
	}
	return nil
}

// GetAttenuation retrieves the value of the leaf Attenuation from the Aps_ApsModule_Ports_CommonIn
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Attenuation is set, it can
// safely use t.GetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Attenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonIn) GetAttenuation() float64 {
	if t == nil || t.Attenuation == nil {
		return 0.0
	}
	return *t.Attenuation
}

// GetEnabled retrieves the value of the leaf Enabled from the Aps_ApsModule_Ports_CommonIn
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonIn) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return true
	}
	return *t.Enabled
}

// GetTargetAttenuation retrieves the value of the leaf TargetAttenuation from the Aps_ApsModule_Ports_CommonIn
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TargetAttenuation is set, it can
// safely use t.GetTargetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TargetAttenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonIn) GetTargetAttenuation() float64 {
	if t == nil || t.TargetAttenuation == nil {
		return 0.0
	}
	return *t.TargetAttenuation
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_CommonIn) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_CommonIn"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_CommonIn) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_CommonIn) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_CommonIn.
func (*Aps_ApsModule_Ports_CommonIn) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-transport-line-protection"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-transport-line-protection"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-transport-line-protection"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-transport-line-protection"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-transport-line-protection"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-transport-line-protection"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-transport-line-protection"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_CommonIn_OpticalPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_CommonIn_OpticalPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Aps_ApsModule_Ports_CommonIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonIn_OpticalPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Aps_ApsModule_Ports_CommonIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonIn_OpticalPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Aps_ApsModule_Ports_CommonIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonIn_OpticalPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Aps_ApsModule_Ports_CommonIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonIn_OpticalPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Aps_ApsModule_Ports_CommonIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonIn_OpticalPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Aps_ApsModule_Ports_CommonIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonIn_OpticalPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Aps_ApsModule_Ports_CommonIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonIn_OpticalPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_CommonIn_OpticalPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_CommonIn_OpticalPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_CommonIn_OpticalPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_CommonIn_OpticalPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_CommonIn_OpticalPower.
func (*Aps_ApsModule_Ports_CommonIn_OpticalPower) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_CommonOutput represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output YANG schema element.
type Aps_ApsModule_Ports_CommonOutput struct {
	ΛMetadata          []ygot.Annotation                              `path:"@" ygotAnnotation:"true"`
	Attenuation        *float64                                       `path:"state/attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛAttenuation       []ygot.Annotation                              `path:"state/@attenuation" ygotAnnotation:"true"`
	OpticalPower       *Aps_ApsModule_Ports_CommonOutput_OpticalPower `path:"state/optical-power" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛOpticalPower      []ygot.Annotation                              `path:"state/@optical-power" ygotAnnotation:"true"`
	TargetAttenuation  *float64                                       `path:"config/target-attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛTargetAttenuation []ygot.Annotation                              `path:"config/@target-attenuation" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_CommonOutput implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_CommonOutput) IsYANGGoStruct() {}

// GetOrCreateOpticalPower retrieves the value of the OpticalPower field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports_CommonOutput) GetOrCreateOpticalPower() *Aps_ApsModule_Ports_CommonOutput_OpticalPower {
	if t.OpticalPower != nil {
		return t.OpticalPower
	}
	t.OpticalPower = &Aps_ApsModule_Ports_CommonOutput_OpticalPower{}
	return t.OpticalPower
}

// GetOpticalPower returns the value of the OpticalPower struct pointer
// from Aps_ApsModule_Ports_CommonOutput. If the receiver or the field OpticalPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports_CommonOutput) GetOpticalPower() *Aps_ApsModule_Ports_CommonOutput_OpticalPower {
	if t != nil && t.OpticalPower != nil {
		return t.OpticalPower
	}
	return nil
}

// GetAttenuation retrieves the value of the leaf Attenuation from the Aps_ApsModule_Ports_CommonOutput
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Attenuation is set, it can
// safely use t.GetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Attenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonOutput) GetAttenuation() float64 {
	if t == nil || t.Attenuation == nil {
		return 0.0
	}
	return *t.Attenuation
}

// GetTargetAttenuation retrieves the value of the leaf TargetAttenuation from the Aps_ApsModule_Ports_CommonOutput
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TargetAttenuation is set, it can
// safely use t.GetTargetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TargetAttenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonOutput) GetTargetAttenuation() float64 {
	if t == nil || t.TargetAttenuation == nil {
		return 0.0
	}
	return *t.TargetAttenuation
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_CommonOutput) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_CommonOutput"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_CommonOutput) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_CommonOutput) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_CommonOutput.
func (*Aps_ApsModule_Ports_CommonOutput) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-transport-line-protection"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-transport-line-protection"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-transport-line-protection"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-transport-line-protection"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-transport-line-protection"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-transport-line-protection"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-transport-line-protection"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_CommonOutput_OpticalPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_CommonOutput_OpticalPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Aps_ApsModule_Ports_CommonOutput_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonOutput_OpticalPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Aps_ApsModule_Ports_CommonOutput_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonOutput_OpticalPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Aps_ApsModule_Ports_CommonOutput_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonOutput_OpticalPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Aps_ApsModule_Ports_CommonOutput_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonOutput_OpticalPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Aps_ApsModule_Ports_CommonOutput_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonOutput_OpticalPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Aps_ApsModule_Ports_CommonOutput_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonOutput_OpticalPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Aps_ApsModule_Ports_CommonOutput_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_CommonOutput_OpticalPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_CommonOutput_OpticalPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_CommonOutput_OpticalPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_CommonOutput_OpticalPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_CommonOutput_OpticalPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_CommonOutput_OpticalPower.
func (*Aps_ApsModule_Ports_CommonOutput_OpticalPower) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_LinePrimaryIn represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn struct {
	ΛMetadata          []ygot.Annotation                               `path:"@" ygotAnnotation:"true"`
	Attenuation        *float64                                        `path:"state/attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛAttenuation       []ygot.Annotation                               `path:"state/@attenuation" ygotAnnotation:"true"`
	Enabled            *bool                                           `path:"config/enabled" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛEnabled           []ygot.Annotation                               `path:"config/@enabled" ygotAnnotation:"true"`
	OpticalPower       *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower `path:"state/optical-power" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛOpticalPower      []ygot.Annotation                               `path:"state/@optical-power" ygotAnnotation:"true"`
	TargetAttenuation  *float64                                        `path:"config/target-attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛTargetAttenuation []ygot.Annotation                               `path:"config/@target-attenuation" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_LinePrimaryIn implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_LinePrimaryIn) IsYANGGoStruct() {}

// GetOrCreateOpticalPower retrieves the value of the OpticalPower field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports_LinePrimaryIn) GetOrCreateOpticalPower() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower {
	if t.OpticalPower != nil {
		return t.OpticalPower
	}
	t.OpticalPower = &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower{}
	return t.OpticalPower
}

// GetOpticalPower returns the value of the OpticalPower struct pointer
// from Aps_ApsModule_Ports_LinePrimaryIn. If the receiver or the field OpticalPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports_LinePrimaryIn) GetOpticalPower() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower {
	if t != nil && t.OpticalPower != nil {
		return t.OpticalPower
	}
	return nil
}

// GetAttenuation retrieves the value of the leaf Attenuation from the Aps_ApsModule_Ports_LinePrimaryIn
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Attenuation is set, it can
// safely use t.GetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Attenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryIn) GetAttenuation() float64 {
	if t == nil || t.Attenuation == nil {
		return 0.0
	}
	return *t.Attenuation
}

// GetEnabled retrieves the value of the leaf Enabled from the Aps_ApsModule_Ports_LinePrimaryIn
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryIn) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return true
	}
	return *t.Enabled
}

// GetTargetAttenuation retrieves the value of the leaf TargetAttenuation from the Aps_ApsModule_Ports_LinePrimaryIn
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TargetAttenuation is set, it can
// safely use t.GetTargetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TargetAttenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryIn) GetTargetAttenuation() float64 {
	if t == nil || t.TargetAttenuation == nil {
		return 0.0
	}
	return *t.TargetAttenuation
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LinePrimaryIn) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_LinePrimaryIn"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LinePrimaryIn) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_LinePrimaryIn) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_LinePrimaryIn.
func (*Aps_ApsModule_Ports_LinePrimaryIn) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-transport-line-protection"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-transport-line-protection"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-transport-line-protection"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-transport-line-protection"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-transport-line-protection"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-transport-line-protection"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-transport-line-protection"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower.
func (*Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_LinePrimaryOut represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut struct {
	ΛMetadata          []ygot.Annotation                                `path:"@" ygotAnnotation:"true"`
	Attenuation        *float64                                         `path:"state/attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛAttenuation       []ygot.Annotation                                `path:"state/@attenuation" ygotAnnotation:"true"`
	OpticalPower       *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower `path:"state/optical-power" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛOpticalPower      []ygot.Annotation                                `path:"state/@optical-power" ygotAnnotation:"true"`
	TargetAttenuation  *float64                                         `path:"config/target-attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛTargetAttenuation []ygot.Annotation                                `path:"config/@target-attenuation" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_LinePrimaryOut implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_LinePrimaryOut) IsYANGGoStruct() {}

// GetOrCreateOpticalPower retrieves the value of the OpticalPower field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports_LinePrimaryOut) GetOrCreateOpticalPower() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower {
	if t.OpticalPower != nil {
		return t.OpticalPower
	}
	t.OpticalPower = &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower{}
	return t.OpticalPower
}

// GetOpticalPower returns the value of the OpticalPower struct pointer
// from Aps_ApsModule_Ports_LinePrimaryOut. If the receiver or the field OpticalPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports_LinePrimaryOut) GetOpticalPower() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower {
	if t != nil && t.OpticalPower != nil {
		return t.OpticalPower
	}
	return nil
}

// GetAttenuation retrieves the value of the leaf Attenuation from the Aps_ApsModule_Ports_LinePrimaryOut
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Attenuation is set, it can
// safely use t.GetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Attenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryOut) GetAttenuation() float64 {
	if t == nil || t.Attenuation == nil {
		return 0.0
	}
	return *t.Attenuation
}

// GetTargetAttenuation retrieves the value of the leaf TargetAttenuation from the Aps_ApsModule_Ports_LinePrimaryOut
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TargetAttenuation is set, it can
// safely use t.GetTargetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TargetAttenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryOut) GetTargetAttenuation() float64 {
	if t == nil || t.TargetAttenuation == nil {
		return 0.0
	}
	return *t.TargetAttenuation
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LinePrimaryOut) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_LinePrimaryOut"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LinePrimaryOut) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_LinePrimaryOut) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_LinePrimaryOut.
func (*Aps_ApsModule_Ports_LinePrimaryOut) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-transport-line-protection"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-transport-line-protection"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-transport-line-protection"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-transport-line-protection"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-transport-line-protection"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-transport-line-protection"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-transport-line-protection"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower.
func (*Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_LineSecondaryIn represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn struct {
	ΛMetadata          []ygot.Annotation                                 `path:"@" ygotAnnotation:"true"`
	Attenuation        *float64                                          `path:"state/attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛAttenuation       []ygot.Annotation                                 `path:"state/@attenuation" ygotAnnotation:"true"`
	Enabled            *bool                                             `path:"config/enabled" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛEnabled           []ygot.Annotation                                 `path:"config/@enabled" ygotAnnotation:"true"`
	OpticalPower       *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower `path:"state/optical-power" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛOpticalPower      []ygot.Annotation                                 `path:"state/@optical-power" ygotAnnotation:"true"`
	TargetAttenuation  *float64                                          `path:"config/target-attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛTargetAttenuation []ygot.Annotation                                 `path:"config/@target-attenuation" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_LineSecondaryIn implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_LineSecondaryIn) IsYANGGoStruct() {}

// GetOrCreateOpticalPower retrieves the value of the OpticalPower field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports_LineSecondaryIn) GetOrCreateOpticalPower() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower {
	if t.OpticalPower != nil {
		return t.OpticalPower
	}
	t.OpticalPower = &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower{}
	return t.OpticalPower
}

// GetOpticalPower returns the value of the OpticalPower struct pointer
// from Aps_ApsModule_Ports_LineSecondaryIn. If the receiver or the field OpticalPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports_LineSecondaryIn) GetOpticalPower() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower {
	if t != nil && t.OpticalPower != nil {
		return t.OpticalPower
	}
	return nil
}

// GetAttenuation retrieves the value of the leaf Attenuation from the Aps_ApsModule_Ports_LineSecondaryIn
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Attenuation is set, it can
// safely use t.GetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Attenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryIn) GetAttenuation() float64 {
	if t == nil || t.Attenuation == nil {
		return 0.0
	}
	return *t.Attenuation
}

// GetEnabled retrieves the value of the leaf Enabled from the Aps_ApsModule_Ports_LineSecondaryIn
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryIn) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return true
	}
	return *t.Enabled
}

// GetTargetAttenuation retrieves the value of the leaf TargetAttenuation from the Aps_ApsModule_Ports_LineSecondaryIn
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TargetAttenuation is set, it can
// safely use t.GetTargetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TargetAttenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryIn) GetTargetAttenuation() float64 {
	if t == nil || t.TargetAttenuation == nil {
		return 0.0
	}
	return *t.TargetAttenuation
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LineSecondaryIn) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_LineSecondaryIn"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LineSecondaryIn) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_LineSecondaryIn) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_LineSecondaryIn.
func (*Aps_ApsModule_Ports_LineSecondaryIn) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-transport-line-protection"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-transport-line-protection"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-transport-line-protection"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-transport-line-protection"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-transport-line-protection"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-transport-line-protection"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-transport-line-protection"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower.
func (*Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_LineSecondaryOut represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut struct {
	ΛMetadata          []ygot.Annotation                                  `path:"@" ygotAnnotation:"true"`
	Attenuation        *float64                                           `path:"state/attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛAttenuation       []ygot.Annotation                                  `path:"state/@attenuation" ygotAnnotation:"true"`
	OpticalPower       *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower `path:"state/optical-power" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛOpticalPower      []ygot.Annotation                                  `path:"state/@optical-power" ygotAnnotation:"true"`
	TargetAttenuation  *float64                                           `path:"config/target-attenuation" module:"openconfig-transport-line-protection/openconfig-transport-line-protection"`
	ΛTargetAttenuation []ygot.Annotation                                  `path:"config/@target-attenuation" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_LineSecondaryOut implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_LineSecondaryOut) IsYANGGoStruct() {}

// GetOrCreateOpticalPower retrieves the value of the OpticalPower field
// or returns the existing field if it already exists.
func (t *Aps_ApsModule_Ports_LineSecondaryOut) GetOrCreateOpticalPower() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower {
	if t.OpticalPower != nil {
		return t.OpticalPower
	}
	t.OpticalPower = &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower{}
	return t.OpticalPower
}

// GetOpticalPower returns the value of the OpticalPower struct pointer
// from Aps_ApsModule_Ports_LineSecondaryOut. If the receiver or the field OpticalPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Aps_ApsModule_Ports_LineSecondaryOut) GetOpticalPower() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower {
	if t != nil && t.OpticalPower != nil {
		return t.OpticalPower
	}
	return nil
}

// GetAttenuation retrieves the value of the leaf Attenuation from the Aps_ApsModule_Ports_LineSecondaryOut
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Attenuation is set, it can
// safely use t.GetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Attenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryOut) GetAttenuation() float64 {
	if t == nil || t.Attenuation == nil {
		return 0.0
	}
	return *t.Attenuation
}

// GetTargetAttenuation retrieves the value of the leaf TargetAttenuation from the Aps_ApsModule_Ports_LineSecondaryOut
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TargetAttenuation is set, it can
// safely use t.GetTargetAttenuation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TargetAttenuation == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryOut) GetTargetAttenuation() float64 {
	if t == nil || t.TargetAttenuation == nil {
		return 0.0
	}
	return *t.TargetAttenuation
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LineSecondaryOut) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_LineSecondaryOut"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LineSecondaryOut) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_LineSecondaryOut) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_LineSecondaryOut.
func (*Aps_ApsModule_Ports_LineSecondaryOut) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-transport-line-protection"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-transport-line-protection"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-transport-line-protection"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-transport-line-protection"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-transport-line-protection"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-transport-line-protection"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-transport-line-protection"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower.
func (*Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower) ΛBelongingModule() string {
	return "openconfig-transport-line-protection"
}

// Bfd represents the /openconfig-bfd/bfd YANG schema element.
type Bfd struct {
	ΛMetadata  []ygot.Annotation         `path:"@" ygotAnnotation:"true"`
	Interface  map[string]*Bfd_Interface `path:"interfaces/interface" module:"openconfig-bfd/openconfig-bfd"`
	ΛInterface []ygot.Annotation         `path:"interfaces/@interface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Bfd implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Bfd) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// Bfd struct. The keys of the list are populated from the input
// arguments.
func (t *Bfd) NewInterface(Id string) (*Bfd_Interface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*Bfd_Interface)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &Bfd_Interface{
		Id: &Id,
	}

	return t.Interface[key], nil
}

// RenameInterface renames an entry in the list Interface within
// the Bfd struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Bfd) RenameInterface(oldK, newK string) error {
	if _, ok := t.Interface[newK]; ok {
		return fmt.Errorf("key %v already exists in Interface", newK)
	}

	e, ok := t.Interface[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Interface", oldK)
	}
	e.Id = &newK

	t.Interface[newK] = e
	delete(t.Interface, oldK)
	return nil
}

// GetOrCreateInterface retrieves the value with the specified keys from
// the receiver Bfd. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Bfd) GetOrCreateInterface(Id string) *Bfd_Interface {

	key := Id

	if v, ok := t.Interface[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewInterface(Id)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateInterface got unexpected error: %v", err))
	}
	return v
}

// GetInterface retrieves the value with the specified key from
// the Interface map field of Bfd. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Bfd) GetInterface(Id string) *Bfd_Interface {

	if t == nil {
		return nil
	}

	key := Id

	if lm, ok := t.Interface[key]; ok {
		return lm
	}
	return nil
}

// AppendInterface appends the supplied Bfd_Interface struct to the
// list Interface of Bfd. If the key value(s) specified in
// the supplied Bfd_Interface already exist in the list, an error is
// returned.
func (t *Bfd) AppendInterface(v *Bfd_Interface) error {
	if v.Id == nil {
		return fmt.Errorf("invalid nil key received for Id")
	}

	key := *v.Id

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*Bfd_Interface)
	}

	if _, ok := t.Interface[key]; ok {
		return fmt.Errorf("duplicate key for list Interface %v", key)
	}

	t.Interface[key] = v
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Bfd"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Bfd) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Bfd.
func (*Bfd) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// Bfd_Interface represents the /openconfig-bfd/bfd/interfaces/interface YANG schema element.
type Bfd_Interface struct {
	ΛMetadata                 []ygot.Annotation                         `path:"@" ygotAnnotation:"true"`
	DesiredMinimumTxInterval  *uint32                                   `path:"config/desired-minimum-tx-interval" module:"openconfig-bfd/openconfig-bfd"`
	ΛDesiredMinimumTxInterval []ygot.Annotation                         `path:"config/@desired-minimum-tx-interval" ygotAnnotation:"true"`
	DetectionMultiplier       *uint8                                    `path:"config/detection-multiplier" module:"openconfig-bfd/openconfig-bfd"`
	ΛDetectionMultiplier      []ygot.Annotation                         `path:"config/@detection-multiplier" ygotAnnotation:"true"`
	EnablePerMemberLink       *bool                                     `path:"config/enable-per-member-link" module:"openconfig-bfd/openconfig-bfd"`
	ΛEnablePerMemberLink      []ygot.Annotation                         `path:"config/@enable-per-member-link" ygotAnnotation:"true"`
	Enabled                   *bool                                     `path:"config/enabled" module:"openconfig-bfd/openconfig-bfd"`
	ΛEnabled                  []ygot.Annotation                         `path:"config/@enabled" ygotAnnotation:"true"`
	Id                        *string                                   `path:"config/id|id" module:"openconfig-bfd/openconfig-bfd|openconfig-bfd"`
	ΛId                       []ygot.Annotation                         `path:"config/@id|@id" ygotAnnotation:"true"`
	InterfaceRef              *Bfd_Interface_InterfaceRef               `path:"interface-ref" module:"openconfig-bfd"`
	ΛInterfaceRef             []ygot.Annotation                         `path:"@interface-ref" ygotAnnotation:"true"`
	LocalAddress              *string                                   `path:"config/local-address" module:"openconfig-bfd/openconfig-bfd"`
	ΛLocalAddress             []ygot.Annotation                         `path:"config/@local-address" ygotAnnotation:"true"`
	MicroBfdSession           map[string]*Bfd_Interface_MicroBfdSession `path:"micro-bfd-sessions/micro-bfd-session" module:"openconfig-bfd/openconfig-bfd"`
	ΛMicroBfdSession          []ygot.Annotation                         `path:"micro-bfd-sessions/@micro-bfd-session" ygotAnnotation:"true"`
	Peer                      map[string]*Bfd_Interface_Peer            `path:"peers/peer" module:"openconfig-bfd/openconfig-bfd"`
	ΛPeer                     []ygot.Annotation                         `path:"peers/@peer" ygotAnnotation:"true"`
	RequiredMinimumReceive    *uint32                                   `path:"config/required-minimum-receive" module:"openconfig-bfd/openconfig-bfd"`
	ΛRequiredMinimumReceive   []ygot.Annotation                         `path:"config/@required-minimum-receive" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Bfd_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Bfd_Interface) IsYANGGoStruct() {}

// NewMicroBfdSession creates a new entry in the MicroBfdSession list of the
// Bfd_Interface struct. The keys of the list are populated from the input
// arguments.
func (t *Bfd_Interface) NewMicroBfdSession(MemberInterface string) (*Bfd_Interface_MicroBfdSession, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.MicroBfdSession == nil {
		t.MicroBfdSession = make(map[string]*Bfd_Interface_MicroBfdSession)
	}

	key := MemberInterface

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.MicroBfdSession[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list MicroBfdSession", key)
	}

	t.MicroBfdSession[key] = &Bfd_Interface_MicroBfdSession{
		MemberInterface: &MemberInterface,
	}

	return t.MicroBfdSession[key], nil
}

// RenameMicroBfdSession renames an entry in the list MicroBfdSession within
// the Bfd_Interface struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Bfd_Interface) RenameMicroBfdSession(oldK, newK string) error {
	if _, ok := t.MicroBfdSession[newK]; ok {
		return fmt.Errorf("key %v already exists in MicroBfdSession", newK)
	}

	e, ok := t.MicroBfdSession[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in MicroBfdSession", oldK)
	}
	e.MemberInterface = &newK

	t.MicroBfdSession[newK] = e
	delete(t.MicroBfdSession, oldK)
	return nil
}

// GetOrCreateMicroBfdSession retrieves the value with the specified keys from
// the receiver Bfd_Interface. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Bfd_Interface) GetOrCreateMicroBfdSession(MemberInterface string) *Bfd_Interface_MicroBfdSession {

	key := MemberInterface

	if v, ok := t.MicroBfdSession[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewMicroBfdSession(MemberInterface)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateMicroBfdSession got unexpected error: %v", err))
	}
	return v
}

// GetMicroBfdSession retrieves the value with the specified key from
// the MicroBfdSession map field of Bfd_Interface. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Bfd_Interface) GetMicroBfdSession(MemberInterface string) *Bfd_Interface_MicroBfdSession {

	if t == nil {
		return nil
	}

	key := MemberInterface

	if lm, ok := t.MicroBfdSession[key]; ok {
		return lm
	}
	return nil
}

// AppendMicroBfdSession appends the supplied Bfd_Interface_MicroBfdSession struct to the
// list MicroBfdSession of Bfd_Interface. If the key value(s) specified in
// the supplied Bfd_Interface_MicroBfdSession already exist in the list, an error is
// returned.
func (t *Bfd_Interface) AppendMicroBfdSession(v *Bfd_Interface_MicroBfdSession) error {
	if v.MemberInterface == nil {
		return fmt.Errorf("invalid nil key received for MemberInterface")
	}

	key := *v.MemberInterface

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.MicroBfdSession == nil {
		t.MicroBfdSession = make(map[string]*Bfd_Interface_MicroBfdSession)
	}

	if _, ok := t.MicroBfdSession[key]; ok {
		return fmt.Errorf("duplicate key for list MicroBfdSession %v", key)
	}

	t.MicroBfdSession[key] = v
	return nil
}

// NewPeer creates a new entry in the Peer list of the
// Bfd_Interface struct. The keys of the list are populated from the input
// arguments.
func (t *Bfd_Interface) NewPeer(LocalDiscriminator string) (*Bfd_Interface_Peer, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Peer == nil {
		t.Peer = make(map[string]*Bfd_Interface_Peer)
	}

	key := LocalDiscriminator

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Peer[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Peer", key)
	}

	t.Peer[key] = &Bfd_Interface_Peer{
		LocalDiscriminator: &LocalDiscriminator,
	}

	return t.Peer[key], nil
}

// RenamePeer renames an entry in the list Peer within
// the Bfd_Interface struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Bfd_Interface) RenamePeer(oldK, newK string) error {
	if _, ok := t.Peer[newK]; ok {
		return fmt.Errorf("key %v already exists in Peer", newK)
	}

	e, ok := t.Peer[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Peer", oldK)
	}
	e.LocalDiscriminator = &newK

	t.Peer[newK] = e
	delete(t.Peer, oldK)
	return nil
}

// GetOrCreatePeer retrieves the value with the specified keys from
// the receiver Bfd_Interface. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Bfd_Interface) GetOrCreatePeer(LocalDiscriminator string) *Bfd_Interface_Peer {

	key := LocalDiscriminator

	if v, ok := t.Peer[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewPeer(LocalDiscriminator)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreatePeer got unexpected error: %v", err))
	}
	return v
}

// GetPeer retrieves the value with the specified key from
// the Peer map field of Bfd_Interface. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Bfd_Interface) GetPeer(LocalDiscriminator string) *Bfd_Interface_Peer {

	if t == nil {
		return nil
	}

	key := LocalDiscriminator

	if lm, ok := t.Peer[key]; ok {
		return lm
	}
	return nil
}

// AppendPeer appends the supplied Bfd_Interface_Peer struct to the
// list Peer of Bfd_Interface. If the key value(s) specified in
// the supplied Bfd_Interface_Peer already exist in the list, an error is
// returned.
func (t *Bfd_Interface) AppendPeer(v *Bfd_Interface_Peer) error {
	if v.LocalDiscriminator == nil {
		return fmt.Errorf("invalid nil key received for LocalDiscriminator")
	}

	key := *v.LocalDiscriminator

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Peer == nil {
		t.Peer = make(map[string]*Bfd_Interface_Peer)
	}

	if _, ok := t.Peer[key]; ok {
		return fmt.Errorf("duplicate key for list Peer %v", key)
	}

	t.Peer[key] = v
	return nil
}

// GetOrCreateInterfaceRef retrieves the value of the InterfaceRef field
// or returns the existing field if it already exists.
func (t *Bfd_Interface) GetOrCreateInterfaceRef() *Bfd_Interface_InterfaceRef {
	if t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	t.InterfaceRef = &Bfd_Interface_InterfaceRef{}
	return t.InterfaceRef
}

// GetInterfaceRef returns the value of the InterfaceRef struct pointer
// from Bfd_Interface. If the receiver or the field InterfaceRef is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Bfd_Interface) GetInterfaceRef() *Bfd_Interface_InterfaceRef {
	if t != nil && t.InterfaceRef != nil {
		return t.InterfaceRef
	}
	return nil
}

// GetDesiredMinimumTxInterval retrieves the value of the leaf DesiredMinimumTxInterval from the Bfd_Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DesiredMinimumTxInterval is set, it can
// safely use t.GetDesiredMinimumTxInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DesiredMinimumTxInterval == nil' before retrieving the leaf's value.
func (t *Bfd_Interface) GetDesiredMinimumTxInterval() uint32 {
	if t == nil || t.DesiredMinimumTxInterval == nil {
		return 0
	}
	return *t.DesiredMinimumTxInterval
}

// GetDetectionMultiplier retrieves the value of the leaf DetectionMultiplier from the Bfd_Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DetectionMultiplier is set, it can
// safely use t.GetDetectionMultiplier() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DetectionMultiplier == nil' before retrieving the leaf's value.
func (t *Bfd_Interface) GetDetectionMultiplier() uint8 {
	if t == nil || t.DetectionMultiplier == nil {
		return 0
	}
	return *t.DetectionMultiplier
}

// GetEnablePerMemberLink retrieves the value of the leaf EnablePerMemberLink from the Bfd_Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EnablePerMemberLink is set, it can
// safely use t.GetEnablePerMemberLink() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EnablePerMemberLink == nil' before retrieving the leaf's value.
func (t *Bfd_Interface) GetEnablePerMemberLink() bool {
	if t == nil || t.EnablePerMemberLink == nil {
		return false
	}
	return *t.EnablePerMemberLink
}

// GetEnabled retrieves the value of the leaf Enabled from the Bfd_Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *Bfd_Interface) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return false
	}
	return *t.Enabled
}

// GetId retrieves the value of the leaf Id from the Bfd_Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Id is set, it can
// safely use t.GetId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Id == nil' before retrieving the leaf's value.
func (t *Bfd_Interface) GetId() string {
	if t == nil || t.Id == nil {
		return ""
	}
	return *t.Id
}

// GetLocalAddress retrieves the value of the leaf LocalAddress from the Bfd_Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalAddress is set, it can
// safely use t.GetLocalAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalAddress == nil' before retrieving the leaf's value.
func (t *Bfd_Interface) GetLocalAddress() string {
	if t == nil || t.LocalAddress == nil {
		return ""
	}
	return *t.LocalAddress
}

// GetRequiredMinimumReceive retrieves the value of the leaf RequiredMinimumReceive from the Bfd_Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RequiredMinimumReceive is set, it can
// safely use t.GetRequiredMinimumReceive() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RequiredMinimumReceive == nil' before retrieving the leaf's value.
func (t *Bfd_Interface) GetRequiredMinimumReceive() uint32 {
	if t == nil || t.RequiredMinimumReceive == nil {
		return 0
	}
	return *t.RequiredMinimumReceive
}

// ΛListKeyMap returns the keys of the Bfd_Interface struct, which is a YANG list entry.
func (t *Bfd_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Bfd_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Bfd_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Bfd_Interface.
func (*Bfd_Interface) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// Bfd_Interface_InterfaceRef represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref YANG schema element.
type Bfd_Interface_InterfaceRef struct {
	ΛMetadata     []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Interface     *string           `path:"config/interface" module:"openconfig-bfd/openconfig-bfd"`
	ΛInterface    []ygot.Annotation `path:"config/@interface" ygotAnnotation:"true"`
	Subinterface  *uint32           `path:"config/subinterface" module:"openconfig-bfd/openconfig-bfd"`
	ΛSubinterface []ygot.Annotation `path:"config/@subinterface" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Bfd_Interface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Bfd_Interface_InterfaceRef) IsYANGGoStruct() {}

// GetInterface retrieves the value of the leaf Interface from the Bfd_Interface_InterfaceRef
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interface is set, it can
// safely use t.GetInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interface == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_InterfaceRef) GetInterface() string {
	if t == nil || t.Interface == nil {
		return ""
	}
	return *t.Interface
}

// GetSubinterface retrieves the value of the leaf Subinterface from the Bfd_Interface_InterfaceRef
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Subinterface is set, it can
// safely use t.GetSubinterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Subinterface == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_InterfaceRef) GetSubinterface() uint32 {
	if t == nil || t.Subinterface == nil {
		return 0
	}
	return *t.Subinterface
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Bfd_Interface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Bfd_Interface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Bfd_Interface_InterfaceRef.
func (*Bfd_Interface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// Bfd_Interface_MicroBfdSession represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session YANG schema element.
type Bfd_Interface_MicroBfdSession struct {
	ΛMetadata                      []ygot.Annotation                    `path:"@" ygotAnnotation:"true"`
	Async                          *Bfd_Interface_MicroBfdSession_Async `path:"state/async" module:"openconfig-bfd/openconfig-bfd"`
	ΛAsync                         []ygot.Annotation                    `path:"state/@async" ygotAnnotation:"true"`
	DemandModeRequested            *bool                                `path:"state/demand-mode-requested" module:"openconfig-bfd/openconfig-bfd"`
	ΛDemandModeRequested           []ygot.Annotation                    `path:"state/@demand-mode-requested" ygotAnnotation:"true"`
	FailureTransitions             *uint64                              `path:"state/failure-transitions" module:"openconfig-bfd/openconfig-bfd"`
	ΛFailureTransitions            []ygot.Annotation                    `path:"state/@failure-transitions" ygotAnnotation:"true"`
	LastFailureTime                *uint64                              `path:"state/last-failure-time" module:"openconfig-bfd/openconfig-bfd"`
	ΛLastFailureTime               []ygot.Annotation                    `path:"state/@last-failure-time" ygotAnnotation:"true"`
	LocalAddress                   *string                              `path:"config/local-address" module:"openconfig-bfd/openconfig-bfd"`
	ΛLocalAddress                  []ygot.Annotation                    `path:"config/@local-address" ygotAnnotation:"true"`
	LocalDiagnosticCode            E_Bfd_BfdDiagnosticCode              `path:"state/local-diagnostic-code" module:"openconfig-bfd/openconfig-bfd"`
	ΛLocalDiagnosticCode           []ygot.Annotation                    `path:"state/@local-diagnostic-code" ygotAnnotation:"true"`
	LocalDiscriminator             *string                              `path:"state/local-discriminator" module:"openconfig-bfd/openconfig-bfd"`
	ΛLocalDiscriminator            []ygot.Annotation                    `path:"state/@local-discriminator" ygotAnnotation:"true"`
	MemberInterface                *string                              `path:"config/member-interface|member-interface" module:"openconfig-bfd/openconfig-bfd|openconfig-bfd"`
	ΛMemberInterface               []ygot.Annotation                    `path:"config/@member-interface|@member-interface" ygotAnnotation:"true"`
	RemoteAddress                  *string                              `path:"config/remote-address" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteAddress                 []ygot.Annotation                    `path:"config/@remote-address" ygotAnnotation:"true"`
	RemoteAuthenticationEnabled    *bool                                `path:"state/remote-authentication-enabled" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteAuthenticationEnabled   []ygot.Annotation                    `path:"state/@remote-authentication-enabled" ygotAnnotation:"true"`
	RemoteControlPlaneIndependent  *bool                                `path:"state/remote-control-plane-independent" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteControlPlaneIndependent []ygot.Annotation                    `path:"state/@remote-control-plane-independent" ygotAnnotation:"true"`
	RemoteDiagnosticCode           E_Bfd_BfdDiagnosticCode              `path:"state/remote-diagnostic-code" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteDiagnosticCode          []ygot.Annotation                    `path:"state/@remote-diagnostic-code" ygotAnnotation:"true"`
	RemoteDiscriminator            *string                              `path:"state/remote-discriminator" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteDiscriminator           []ygot.Annotation                    `path:"state/@remote-discriminator" ygotAnnotation:"true"`
	RemoteMinimumReceiveInterval   *uint32                              `path:"state/remote-minimum-receive-interval" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteMinimumReceiveInterval  []ygot.Annotation                    `path:"state/@remote-minimum-receive-interval" ygotAnnotation:"true"`
	RemoteSessionState             E_Bfd_BfdSessionState                `path:"state/remote-session-state" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteSessionState            []ygot.Annotation                    `path:"state/@remote-session-state" ygotAnnotation:"true"`
	SessionState                   E_Bfd_BfdSessionState                `path:"state/session-state" module:"openconfig-bfd/openconfig-bfd"`
	ΛSessionState                  []ygot.Annotation                    `path:"state/@session-state" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Bfd_Interface_MicroBfdSession implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Bfd_Interface_MicroBfdSession) IsYANGGoStruct() {}

// GetOrCreateAsync retrieves the value of the Async field
// or returns the existing field if it already exists.
func (t *Bfd_Interface_MicroBfdSession) GetOrCreateAsync() *Bfd_Interface_MicroBfdSession_Async {
	if t.Async != nil {
		return t.Async
	}
	t.Async = &Bfd_Interface_MicroBfdSession_Async{}
	return t.Async
}

// GetAsync returns the value of the Async struct pointer
// from Bfd_Interface_MicroBfdSession. If the receiver or the field Async is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Bfd_Interface_MicroBfdSession) GetAsync() *Bfd_Interface_MicroBfdSession_Async {
	if t != nil && t.Async != nil {
		return t.Async
	}
	return nil
}

// GetDemandModeRequested retrieves the value of the leaf DemandModeRequested from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DemandModeRequested is set, it can
// safely use t.GetDemandModeRequested() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DemandModeRequested == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetDemandModeRequested() bool {
	if t == nil || t.DemandModeRequested == nil {
		return false
	}
	return *t.DemandModeRequested
}

// GetFailureTransitions retrieves the value of the leaf FailureTransitions from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FailureTransitions is set, it can
// safely use t.GetFailureTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FailureTransitions == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetFailureTransitions() uint64 {
	if t == nil || t.FailureTransitions == nil {
		return 0
	}
	return *t.FailureTransitions
}

// GetLastFailureTime retrieves the value of the leaf LastFailureTime from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastFailureTime is set, it can
// safely use t.GetLastFailureTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastFailureTime == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetLastFailureTime() uint64 {
	if t == nil || t.LastFailureTime == nil {
		return 0
	}
	return *t.LastFailureTime
}

// GetLocalAddress retrieves the value of the leaf LocalAddress from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalAddress is set, it can
// safely use t.GetLocalAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalAddress == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetLocalAddress() string {
	if t == nil || t.LocalAddress == nil {
		return ""
	}
	return *t.LocalAddress
}

// GetLocalDiagnosticCode retrieves the value of the leaf LocalDiagnosticCode from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalDiagnosticCode is set, it can
// safely use t.GetLocalDiagnosticCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalDiagnosticCode == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetLocalDiagnosticCode() E_Bfd_BfdDiagnosticCode {
	if t == nil || t.LocalDiagnosticCode == 0 {
		return 0
	}
	return t.LocalDiagnosticCode
}

// GetLocalDiscriminator retrieves the value of the leaf LocalDiscriminator from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalDiscriminator is set, it can
// safely use t.GetLocalDiscriminator() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalDiscriminator == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetLocalDiscriminator() string {
	if t == nil || t.LocalDiscriminator == nil {
		return ""
	}
	return *t.LocalDiscriminator
}

// GetMemberInterface retrieves the value of the leaf MemberInterface from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MemberInterface is set, it can
// safely use t.GetMemberInterface() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MemberInterface == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetMemberInterface() string {
	if t == nil || t.MemberInterface == nil {
		return ""
	}
	return *t.MemberInterface
}

// GetRemoteAddress retrieves the value of the leaf RemoteAddress from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteAddress is set, it can
// safely use t.GetRemoteAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteAddress == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetRemoteAddress() string {
	if t == nil || t.RemoteAddress == nil {
		return ""
	}
	return *t.RemoteAddress
}

// GetRemoteAuthenticationEnabled retrieves the value of the leaf RemoteAuthenticationEnabled from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteAuthenticationEnabled is set, it can
// safely use t.GetRemoteAuthenticationEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteAuthenticationEnabled == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetRemoteAuthenticationEnabled() bool {
	if t == nil || t.RemoteAuthenticationEnabled == nil {
		return false
	}
	return *t.RemoteAuthenticationEnabled
}

// GetRemoteControlPlaneIndependent retrieves the value of the leaf RemoteControlPlaneIndependent from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteControlPlaneIndependent is set, it can
// safely use t.GetRemoteControlPlaneIndependent() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteControlPlaneIndependent == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetRemoteControlPlaneIndependent() bool {
	if t == nil || t.RemoteControlPlaneIndependent == nil {
		return false
	}
	return *t.RemoteControlPlaneIndependent
}

// GetRemoteDiagnosticCode retrieves the value of the leaf RemoteDiagnosticCode from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteDiagnosticCode is set, it can
// safely use t.GetRemoteDiagnosticCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteDiagnosticCode == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetRemoteDiagnosticCode() E_Bfd_BfdDiagnosticCode {
	if t == nil || t.RemoteDiagnosticCode == 0 {
		return 0
	}
	return t.RemoteDiagnosticCode
}

// GetRemoteDiscriminator retrieves the value of the leaf RemoteDiscriminator from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteDiscriminator is set, it can
// safely use t.GetRemoteDiscriminator() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteDiscriminator == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetRemoteDiscriminator() string {
	if t == nil || t.RemoteDiscriminator == nil {
		return ""
	}
	return *t.RemoteDiscriminator
}

// GetRemoteMinimumReceiveInterval retrieves the value of the leaf RemoteMinimumReceiveInterval from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteMinimumReceiveInterval is set, it can
// safely use t.GetRemoteMinimumReceiveInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteMinimumReceiveInterval == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetRemoteMinimumReceiveInterval() uint32 {
	if t == nil || t.RemoteMinimumReceiveInterval == nil {
		return 0
	}
	return *t.RemoteMinimumReceiveInterval
}

// GetRemoteSessionState retrieves the value of the leaf RemoteSessionState from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteSessionState is set, it can
// safely use t.GetRemoteSessionState() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteSessionState == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetRemoteSessionState() E_Bfd_BfdSessionState {
	if t == nil || t.RemoteSessionState == 0 {
		return 0
	}
	return t.RemoteSessionState
}

// GetSessionState retrieves the value of the leaf SessionState from the Bfd_Interface_MicroBfdSession
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SessionState is set, it can
// safely use t.GetSessionState() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SessionState == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession) GetSessionState() E_Bfd_BfdSessionState {
	if t == nil || t.SessionState == 0 {
		return 0
	}
	return t.SessionState
}

// ΛListKeyMap returns the keys of the Bfd_Interface_MicroBfdSession struct, which is a YANG list entry.
func (t *Bfd_Interface_MicroBfdSession) ΛListKeyMap() (map[string]interface{}, error) {
	if t.MemberInterface == nil {
		return nil, fmt.Errorf("nil value for key MemberInterface")
	}

	return map[string]interface{}{
		"member-interface": *t.MemberInterface,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_MicroBfdSession) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Bfd_Interface_MicroBfdSession"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_MicroBfdSession) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Bfd_Interface_MicroBfdSession) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Bfd_Interface_MicroBfdSession.
func (*Bfd_Interface_MicroBfdSession) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// Bfd_Interface_MicroBfdSession_Async represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async YANG schema element.
type Bfd_Interface_MicroBfdSession_Async struct {
	ΛMetadata              []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	LastPacketReceived     *uint64           `path:"last-packet-received" module:"openconfig-bfd"`
	ΛLastPacketReceived    []ygot.Annotation `path:"@last-packet-received" ygotAnnotation:"true"`
	LastPacketTransmitted  *uint64           `path:"last-packet-transmitted" module:"openconfig-bfd"`
	ΛLastPacketTransmitted []ygot.Annotation `path:"@last-packet-transmitted" ygotAnnotation:"true"`
	ReceivedPackets        *uint64           `path:"received-packets" module:"openconfig-bfd"`
	ΛReceivedPackets       []ygot.Annotation `path:"@received-packets" ygotAnnotation:"true"`
	TransmittedPackets     *uint64           `path:"transmitted-packets" module:"openconfig-bfd"`
	ΛTransmittedPackets    []ygot.Annotation `path:"@transmitted-packets" ygotAnnotation:"true"`
	UpTransitions          *uint64           `path:"up-transitions" module:"openconfig-bfd"`
	ΛUpTransitions         []ygot.Annotation `path:"@up-transitions" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Bfd_Interface_MicroBfdSession_Async implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Bfd_Interface_MicroBfdSession_Async) IsYANGGoStruct() {}

// GetLastPacketReceived retrieves the value of the leaf LastPacketReceived from the Bfd_Interface_MicroBfdSession_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketReceived is set, it can
// safely use t.GetLastPacketReceived() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketReceived == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession_Async) GetLastPacketReceived() uint64 {
	if t == nil || t.LastPacketReceived == nil {
		return 0
	}
	return *t.LastPacketReceived
}

// GetLastPacketTransmitted retrieves the value of the leaf LastPacketTransmitted from the Bfd_Interface_MicroBfdSession_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketTransmitted is set, it can
// safely use t.GetLastPacketTransmitted() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketTransmitted == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession_Async) GetLastPacketTransmitted() uint64 {
	if t == nil || t.LastPacketTransmitted == nil {
		return 0
	}
	return *t.LastPacketTransmitted
}

// GetReceivedPackets retrieves the value of the leaf ReceivedPackets from the Bfd_Interface_MicroBfdSession_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReceivedPackets is set, it can
// safely use t.GetReceivedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReceivedPackets == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession_Async) GetReceivedPackets() uint64 {
	if t == nil || t.ReceivedPackets == nil {
		return 0
	}
	return *t.ReceivedPackets
}

// GetTransmittedPackets retrieves the value of the leaf TransmittedPackets from the Bfd_Interface_MicroBfdSession_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TransmittedPackets is set, it can
// safely use t.GetTransmittedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TransmittedPackets == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession_Async) GetTransmittedPackets() uint64 {
	if t == nil || t.TransmittedPackets == nil {
		return 0
	}
	return *t.TransmittedPackets
}

// GetUpTransitions retrieves the value of the leaf UpTransitions from the Bfd_Interface_MicroBfdSession_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UpTransitions is set, it can
// safely use t.GetUpTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UpTransitions == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_MicroBfdSession_Async) GetUpTransitions() uint64 {
	if t == nil || t.UpTransitions == nil {
		return 0
	}
	return *t.UpTransitions
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_MicroBfdSession_Async) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Bfd_Interface_MicroBfdSession_Async"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_MicroBfdSession_Async) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Bfd_Interface_MicroBfdSession_Async) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Bfd_Interface_MicroBfdSession_Async.
func (*Bfd_Interface_MicroBfdSession_Async) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// Bfd_Interface_Peer represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer YANG schema element.
type Bfd_Interface_Peer struct {
	ΛMetadata                      []ygot.Annotation                     `path:"@" ygotAnnotation:"true"`
	Async                          *Bfd_Interface_Peer_Async             `path:"state/async" module:"openconfig-bfd/openconfig-bfd"`
	ΛAsync                         []ygot.Annotation                     `path:"state/@async" ygotAnnotation:"true"`
	DemandModeRequested            *bool                                 `path:"state/demand-mode-requested" module:"openconfig-bfd/openconfig-bfd"`
	ΛDemandModeRequested           []ygot.Annotation                     `path:"state/@demand-mode-requested" ygotAnnotation:"true"`
	Echo                           *Bfd_Interface_Peer_Echo              `path:"state/echo" module:"openconfig-bfd/openconfig-bfd"`
	ΛEcho                          []ygot.Annotation                     `path:"state/@echo" ygotAnnotation:"true"`
	FailureTransitions             *uint64                               `path:"state/failure-transitions" module:"openconfig-bfd/openconfig-bfd"`
	ΛFailureTransitions            []ygot.Annotation                     `path:"state/@failure-transitions" ygotAnnotation:"true"`
	LastFailureTime                *uint64                               `path:"state/last-failure-time" module:"openconfig-bfd/openconfig-bfd"`
	ΛLastFailureTime               []ygot.Annotation                     `path:"state/@last-failure-time" ygotAnnotation:"true"`
	LocalAddress                   *string                               `path:"state/local-address" module:"openconfig-bfd/openconfig-bfd"`
	ΛLocalAddress                  []ygot.Annotation                     `path:"state/@local-address" ygotAnnotation:"true"`
	LocalDiagnosticCode            E_Bfd_BfdDiagnosticCode               `path:"state/local-diagnostic-code" module:"openconfig-bfd/openconfig-bfd"`
	ΛLocalDiagnosticCode           []ygot.Annotation                     `path:"state/@local-diagnostic-code" ygotAnnotation:"true"`
	LocalDiscriminator             *string                               `path:"state/local-discriminator|local-discriminator" module:"openconfig-bfd/openconfig-bfd|openconfig-bfd"`
	ΛLocalDiscriminator            []ygot.Annotation                     `path:"state/@local-discriminator|@local-discriminator" ygotAnnotation:"true"`
	RemoteAddress                  *string                               `path:"state/remote-address" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteAddress                 []ygot.Annotation                     `path:"state/@remote-address" ygotAnnotation:"true"`
	RemoteAuthenticationEnabled    *bool                                 `path:"state/remote-authentication-enabled" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteAuthenticationEnabled   []ygot.Annotation                     `path:"state/@remote-authentication-enabled" ygotAnnotation:"true"`
	RemoteControlPlaneIndependent  *bool                                 `path:"state/remote-control-plane-independent" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteControlPlaneIndependent []ygot.Annotation                     `path:"state/@remote-control-plane-independent" ygotAnnotation:"true"`
	RemoteDiagnosticCode           E_Bfd_BfdDiagnosticCode               `path:"state/remote-diagnostic-code" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteDiagnosticCode          []ygot.Annotation                     `path:"state/@remote-diagnostic-code" ygotAnnotation:"true"`
	RemoteDiscriminator            *string                               `path:"state/remote-discriminator" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteDiscriminator           []ygot.Annotation                     `path:"state/@remote-discriminator" ygotAnnotation:"true"`
	RemoteMinimumReceiveInterval   *uint32                               `path:"state/remote-minimum-receive-interval" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteMinimumReceiveInterval  []ygot.Annotation                     `path:"state/@remote-minimum-receive-interval" ygotAnnotation:"true"`
	RemoteSessionState             E_Bfd_BfdSessionState                 `path:"state/remote-session-state" module:"openconfig-bfd/openconfig-bfd"`
	ΛRemoteSessionState            []ygot.Annotation                     `path:"state/@remote-session-state" ygotAnnotation:"true"`
	SessionState                   E_Bfd_BfdSessionState                 `path:"state/session-state" module:"openconfig-bfd/openconfig-bfd"`
	ΛSessionState                  []ygot.Annotation                     `path:"state/@session-state" ygotAnnotation:"true"`
	SubscribedProtocols            []E_PolicyTypes_INSTALL_PROTOCOL_TYPE `path:"state/subscribed-protocols" module:"openconfig-bfd/openconfig-bfd"`
	ΛSubscribedProtocols           []ygot.Annotation                     `path:"state/@subscribed-protocols" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Bfd_Interface_Peer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Bfd_Interface_Peer) IsYANGGoStruct() {}

// GetOrCreateAsync retrieves the value of the Async field
// or returns the existing field if it already exists.
func (t *Bfd_Interface_Peer) GetOrCreateAsync() *Bfd_Interface_Peer_Async {
	if t.Async != nil {
		return t.Async
	}
	t.Async = &Bfd_Interface_Peer_Async{}
	return t.Async
}

// GetOrCreateEcho retrieves the value of the Echo field
// or returns the existing field if it already exists.
func (t *Bfd_Interface_Peer) GetOrCreateEcho() *Bfd_Interface_Peer_Echo {
	if t.Echo != nil {
		return t.Echo
	}
	t.Echo = &Bfd_Interface_Peer_Echo{}
	return t.Echo
}

// GetAsync returns the value of the Async struct pointer
// from Bfd_Interface_Peer. If the receiver or the field Async is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Bfd_Interface_Peer) GetAsync() *Bfd_Interface_Peer_Async {
	if t != nil && t.Async != nil {
		return t.Async
	}
	return nil
}

// GetEcho returns the value of the Echo struct pointer
// from Bfd_Interface_Peer. If the receiver or the field Echo is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Bfd_Interface_Peer) GetEcho() *Bfd_Interface_Peer_Echo {
	if t != nil && t.Echo != nil {
		return t.Echo
	}
	return nil
}

// GetDemandModeRequested retrieves the value of the leaf DemandModeRequested from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DemandModeRequested is set, it can
// safely use t.GetDemandModeRequested() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DemandModeRequested == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetDemandModeRequested() bool {
	if t == nil || t.DemandModeRequested == nil {
		return false
	}
	return *t.DemandModeRequested
}

// GetFailureTransitions retrieves the value of the leaf FailureTransitions from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FailureTransitions is set, it can
// safely use t.GetFailureTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FailureTransitions == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetFailureTransitions() uint64 {
	if t == nil || t.FailureTransitions == nil {
		return 0
	}
	return *t.FailureTransitions
}

// GetLastFailureTime retrieves the value of the leaf LastFailureTime from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastFailureTime is set, it can
// safely use t.GetLastFailureTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastFailureTime == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetLastFailureTime() uint64 {
	if t == nil || t.LastFailureTime == nil {
		return 0
	}
	return *t.LastFailureTime
}

// GetLocalAddress retrieves the value of the leaf LocalAddress from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalAddress is set, it can
// safely use t.GetLocalAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalAddress == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetLocalAddress() string {
	if t == nil || t.LocalAddress == nil {
		return ""
	}
	return *t.LocalAddress
}

// GetLocalDiagnosticCode retrieves the value of the leaf LocalDiagnosticCode from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalDiagnosticCode is set, it can
// safely use t.GetLocalDiagnosticCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalDiagnosticCode == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetLocalDiagnosticCode() E_Bfd_BfdDiagnosticCode {
	if t == nil || t.LocalDiagnosticCode == 0 {
		return 0
	}
	return t.LocalDiagnosticCode
}

// GetLocalDiscriminator retrieves the value of the leaf LocalDiscriminator from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LocalDiscriminator is set, it can
// safely use t.GetLocalDiscriminator() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LocalDiscriminator == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetLocalDiscriminator() string {
	if t == nil || t.LocalDiscriminator == nil {
		return ""
	}
	return *t.LocalDiscriminator
}

// GetRemoteAddress retrieves the value of the leaf RemoteAddress from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteAddress is set, it can
// safely use t.GetRemoteAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteAddress == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetRemoteAddress() string {
	if t == nil || t.RemoteAddress == nil {
		return ""
	}
	return *t.RemoteAddress
}

// GetRemoteAuthenticationEnabled retrieves the value of the leaf RemoteAuthenticationEnabled from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteAuthenticationEnabled is set, it can
// safely use t.GetRemoteAuthenticationEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteAuthenticationEnabled == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetRemoteAuthenticationEnabled() bool {
	if t == nil || t.RemoteAuthenticationEnabled == nil {
		return false
	}
	return *t.RemoteAuthenticationEnabled
}

// GetRemoteControlPlaneIndependent retrieves the value of the leaf RemoteControlPlaneIndependent from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteControlPlaneIndependent is set, it can
// safely use t.GetRemoteControlPlaneIndependent() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteControlPlaneIndependent == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetRemoteControlPlaneIndependent() bool {
	if t == nil || t.RemoteControlPlaneIndependent == nil {
		return false
	}
	return *t.RemoteControlPlaneIndependent
}

// GetRemoteDiagnosticCode retrieves the value of the leaf RemoteDiagnosticCode from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteDiagnosticCode is set, it can
// safely use t.GetRemoteDiagnosticCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteDiagnosticCode == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetRemoteDiagnosticCode() E_Bfd_BfdDiagnosticCode {
	if t == nil || t.RemoteDiagnosticCode == 0 {
		return 0
	}
	return t.RemoteDiagnosticCode
}

// GetRemoteDiscriminator retrieves the value of the leaf RemoteDiscriminator from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteDiscriminator is set, it can
// safely use t.GetRemoteDiscriminator() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteDiscriminator == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetRemoteDiscriminator() string {
	if t == nil || t.RemoteDiscriminator == nil {
		return ""
	}
	return *t.RemoteDiscriminator
}

// GetRemoteMinimumReceiveInterval retrieves the value of the leaf RemoteMinimumReceiveInterval from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteMinimumReceiveInterval is set, it can
// safely use t.GetRemoteMinimumReceiveInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteMinimumReceiveInterval == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetRemoteMinimumReceiveInterval() uint32 {
	if t == nil || t.RemoteMinimumReceiveInterval == nil {
		return 0
	}
	return *t.RemoteMinimumReceiveInterval
}

// GetRemoteSessionState retrieves the value of the leaf RemoteSessionState from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RemoteSessionState is set, it can
// safely use t.GetRemoteSessionState() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RemoteSessionState == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetRemoteSessionState() E_Bfd_BfdSessionState {
	if t == nil || t.RemoteSessionState == 0 {
		return 0
	}
	return t.RemoteSessionState
}

// GetSessionState retrieves the value of the leaf SessionState from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SessionState is set, it can
// safely use t.GetSessionState() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SessionState == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetSessionState() E_Bfd_BfdSessionState {
	if t == nil || t.SessionState == 0 {
		return 0
	}
	return t.SessionState
}

// GetSubscribedProtocols retrieves the value of the leaf SubscribedProtocols from the Bfd_Interface_Peer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SubscribedProtocols is set, it can
// safely use t.GetSubscribedProtocols() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SubscribedProtocols == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer) GetSubscribedProtocols() []E_PolicyTypes_INSTALL_PROTOCOL_TYPE {
	if t == nil || t.SubscribedProtocols == nil {
		return nil
	}
	return t.SubscribedProtocols
}

// ΛListKeyMap returns the keys of the Bfd_Interface_Peer struct, which is a YANG list entry.
func (t *Bfd_Interface_Peer) ΛListKeyMap() (map[string]interface{}, error) {
	if t.LocalDiscriminator == nil {
		return nil, fmt.Errorf("nil value for key LocalDiscriminator")
	}

	return map[string]interface{}{
		"local-discriminator": *t.LocalDiscriminator,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_Peer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Bfd_Interface_Peer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_Peer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Bfd_Interface_Peer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Bfd_Interface_Peer.
func (*Bfd_Interface_Peer) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// Bfd_Interface_Peer_Async represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async YANG schema element.
type Bfd_Interface_Peer_Async struct {
	ΛMetadata              []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	LastPacketReceived     *uint64           `path:"last-packet-received" module:"openconfig-bfd"`
	ΛLastPacketReceived    []ygot.Annotation `path:"@last-packet-received" ygotAnnotation:"true"`
	LastPacketTransmitted  *uint64           `path:"last-packet-transmitted" module:"openconfig-bfd"`
	ΛLastPacketTransmitted []ygot.Annotation `path:"@last-packet-transmitted" ygotAnnotation:"true"`
	ReceivedPackets        *uint64           `path:"received-packets" module:"openconfig-bfd"`
	ΛReceivedPackets       []ygot.Annotation `path:"@received-packets" ygotAnnotation:"true"`
	TransmittedPackets     *uint64           `path:"transmitted-packets" module:"openconfig-bfd"`
	ΛTransmittedPackets    []ygot.Annotation `path:"@transmitted-packets" ygotAnnotation:"true"`
	UpTransitions          *uint64           `path:"up-transitions" module:"openconfig-bfd"`
	ΛUpTransitions         []ygot.Annotation `path:"@up-transitions" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Bfd_Interface_Peer_Async implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Bfd_Interface_Peer_Async) IsYANGGoStruct() {}

// GetLastPacketReceived retrieves the value of the leaf LastPacketReceived from the Bfd_Interface_Peer_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketReceived is set, it can
// safely use t.GetLastPacketReceived() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketReceived == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer_Async) GetLastPacketReceived() uint64 {
	if t == nil || t.LastPacketReceived == nil {
		return 0
	}
	return *t.LastPacketReceived
}

// GetLastPacketTransmitted retrieves the value of the leaf LastPacketTransmitted from the Bfd_Interface_Peer_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketTransmitted is set, it can
// safely use t.GetLastPacketTransmitted() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketTransmitted == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer_Async) GetLastPacketTransmitted() uint64 {
	if t == nil || t.LastPacketTransmitted == nil {
		return 0
	}
	return *t.LastPacketTransmitted
}

// GetReceivedPackets retrieves the value of the leaf ReceivedPackets from the Bfd_Interface_Peer_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReceivedPackets is set, it can
// safely use t.GetReceivedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReceivedPackets == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer_Async) GetReceivedPackets() uint64 {
	if t == nil || t.ReceivedPackets == nil {
		return 0
	}
	return *t.ReceivedPackets
}

// GetTransmittedPackets retrieves the value of the leaf TransmittedPackets from the Bfd_Interface_Peer_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TransmittedPackets is set, it can
// safely use t.GetTransmittedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TransmittedPackets == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer_Async) GetTransmittedPackets() uint64 {
	if t == nil || t.TransmittedPackets == nil {
		return 0
	}
	return *t.TransmittedPackets
}

// GetUpTransitions retrieves the value of the leaf UpTransitions from the Bfd_Interface_Peer_Async
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UpTransitions is set, it can
// safely use t.GetUpTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UpTransitions == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer_Async) GetUpTransitions() uint64 {
	if t == nil || t.UpTransitions == nil {
		return 0
	}
	return *t.UpTransitions
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_Peer_Async) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Bfd_Interface_Peer_Async"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_Peer_Async) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Bfd_Interface_Peer_Async) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Bfd_Interface_Peer_Async.
func (*Bfd_Interface_Peer_Async) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// Bfd_Interface_Peer_Echo represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo YANG schema element.
type Bfd_Interface_Peer_Echo struct {
	ΛMetadata              []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Active                 *bool             `path:"active" module:"openconfig-bfd"`
	ΛActive                []ygot.Annotation `path:"@active" ygotAnnotation:"true"`
	LastPacketReceived     *uint64           `path:"last-packet-received" module:"openconfig-bfd"`
	ΛLastPacketReceived    []ygot.Annotation `path:"@last-packet-received" ygotAnnotation:"true"`
	LastPacketTransmitted  *uint64           `path:"last-packet-transmitted" module:"openconfig-bfd"`
	ΛLastPacketTransmitted []ygot.Annotation `path:"@last-packet-transmitted" ygotAnnotation:"true"`
	ReceivedPackets        *uint64           `path:"received-packets" module:"openconfig-bfd"`
	ΛReceivedPackets       []ygot.Annotation `path:"@received-packets" ygotAnnotation:"true"`
	TransmittedPackets     *uint64           `path:"transmitted-packets" module:"openconfig-bfd"`
	ΛTransmittedPackets    []ygot.Annotation `path:"@transmitted-packets" ygotAnnotation:"true"`
	UpTransitions          *uint64           `path:"up-transitions" module:"openconfig-bfd"`
	ΛUpTransitions         []ygot.Annotation `path:"@up-transitions" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Bfd_Interface_Peer_Echo implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Bfd_Interface_Peer_Echo) IsYANGGoStruct() {}

// GetActive retrieves the value of the leaf Active from the Bfd_Interface_Peer_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Active is set, it can
// safely use t.GetActive() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Active == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer_Echo) GetActive() bool {
	if t == nil || t.Active == nil {
		return false
	}
	return *t.Active
}

// GetLastPacketReceived retrieves the value of the leaf LastPacketReceived from the Bfd_Interface_Peer_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketReceived is set, it can
// safely use t.GetLastPacketReceived() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketReceived == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer_Echo) GetLastPacketReceived() uint64 {
	if t == nil || t.LastPacketReceived == nil {
		return 0
	}
	return *t.LastPacketReceived
}

// GetLastPacketTransmitted retrieves the value of the leaf LastPacketTransmitted from the Bfd_Interface_Peer_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastPacketTransmitted is set, it can
// safely use t.GetLastPacketTransmitted() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastPacketTransmitted == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer_Echo) GetLastPacketTransmitted() uint64 {
	if t == nil || t.LastPacketTransmitted == nil {
		return 0
	}
	return *t.LastPacketTransmitted
}

// GetReceivedPackets retrieves the value of the leaf ReceivedPackets from the Bfd_Interface_Peer_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReceivedPackets is set, it can
// safely use t.GetReceivedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReceivedPackets == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer_Echo) GetReceivedPackets() uint64 {
	if t == nil || t.ReceivedPackets == nil {
		return 0
	}
	return *t.ReceivedPackets
}

// GetTransmittedPackets retrieves the value of the leaf TransmittedPackets from the Bfd_Interface_Peer_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TransmittedPackets is set, it can
// safely use t.GetTransmittedPackets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TransmittedPackets == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer_Echo) GetTransmittedPackets() uint64 {
	if t == nil || t.TransmittedPackets == nil {
		return 0
	}
	return *t.TransmittedPackets
}

// GetUpTransitions retrieves the value of the leaf UpTransitions from the Bfd_Interface_Peer_Echo
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UpTransitions is set, it can
// safely use t.GetUpTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UpTransitions == nil' before retrieving the leaf's value.
func (t *Bfd_Interface_Peer_Echo) GetUpTransitions() uint64 {
	if t == nil || t.UpTransitions == nil {
		return 0
	}
	return *t.UpTransitions
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_Peer_Echo) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Bfd_Interface_Peer_Echo"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Bfd_Interface_Peer_Echo) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Bfd_Interface_Peer_Echo) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Bfd_Interface_Peer_Echo.
func (*Bfd_Interface_Peer_Echo) ΛBelongingModule() string {
	return "openconfig-bfd"
}

// Component represents the /openconfig-platform/components/component YANG schema element.
type Component struct {
	ΛMetadata             []ygot.Annotation                       `path:"@" ygotAnnotation:"true"`
	AllocatedPower        *uint32                                 `path:"state/allocated-power" module:"openconfig-platform/openconfig-platform"`
	ΛAllocatedPower       []ygot.Annotation                       `path:"state/@allocated-power" ygotAnnotation:"true"`
	Backplane             *Component_Backplane                    `path:"backplane" module:"openconfig-platform"`
	ΛBackplane            []ygot.Annotation                       `path:"@backplane" ygotAnnotation:"true"`
	BaseMacAddress        *string                                 `path:"state/base-mac-address" module:"openconfig-platform/openconfig-platform"`
	ΛBaseMacAddress       []ygot.Annotation                       `path:"state/@base-mac-address" ygotAnnotation:"true"`
	Chassis               *Component_Chassis                      `path:"chassis" module:"openconfig-platform"`
	ΛChassis              []ygot.Annotation                       `path:"@chassis" ygotAnnotation:"true"`
	CleiCode              *string                                 `path:"state/clei-code" module:"openconfig-platform/openconfig-platform"`
	ΛCleiCode             []ygot.Annotation                       `path:"state/@clei-code" ygotAnnotation:"true"`
	ControllerCard        *Component_ControllerCard               `path:"controller-card" module:"openconfig-platform"`
	ΛControllerCard       []ygot.Annotation                       `path:"@controller-card" ygotAnnotation:"true"`
	Cpu                   *Component_Cpu                          `path:"cpu" module:"openconfig-platform"`
	ΛCpu                  []ygot.Annotation                       `path:"@cpu" ygotAnnotation:"true"`
	Description           *string                                 `path:"state/description" module:"openconfig-platform/openconfig-platform"`
	ΛDescription          []ygot.Annotation                       `path:"state/@description" ygotAnnotation:"true"`
	Empty                 *bool                                   `path:"state/empty" module:"openconfig-platform/openconfig-platform"`
	ΛEmpty                []ygot.Annotation                       `path:"state/@empty" ygotAnnotation:"true"`
	EquipmentFailure      *bool                                   `path:"state/equipment-failure" module:"openconfig-platform/openconfig-alarms"`
	ΛEquipmentFailure     []ygot.Annotation                       `path:"state/@equipment-failure" ygotAnnotation:"true"`
	EquipmentMismatch     *bool                                   `path:"state/equipment-mismatch" module:"openconfig-platform/openconfig-alarms"`
	ΛEquipmentMismatch    []ygot.Annotation                       `path:"state/@equipment-mismatch" ygotAnnotation:"true"`
	Fabric                *Component_Fabric                       `path:"fabric" module:"openconfig-platform"`
	ΛFabric               []ygot.Annotation                       `path:"@fabric" ygotAnnotation:"true"`
	Fan                   *Component_Fan                          `path:"fan" module:"openconfig-platform"`
	ΛFan                  []ygot.Annotation                       `path:"@fan" ygotAnnotation:"true"`
	FirmwareVersion       *string                                 `path:"state/firmware-version" module:"openconfig-platform/openconfig-platform"`
	ΛFirmwareVersion      []ygot.Annotation                       `path:"state/@firmware-version" ygotAnnotation:"true"`
	HardwareVersion       *string                                 `path:"state/hardware-version" module:"openconfig-platform/openconfig-platform"`
	ΛHardwareVersion      []ygot.Annotation                       `path:"state/@hardware-version" ygotAnnotation:"true"`
	Id                    *string                                 `path:"state/id" module:"openconfig-platform/openconfig-platform"`
	ΛId                   []ygot.Annotation                       `path:"state/@id" ygotAnnotation:"true"`
	IntegratedCircuit     *Component_IntegratedCircuit            `path:"integrated-circuit" module:"openconfig-platform"`
	ΛIntegratedCircuit    []ygot.Annotation                       `path:"@integrated-circuit" ygotAnnotation:"true"`
	LastRebootReason      E_PlatformTypes_COMPONENT_REBOOT_REASON `path:"state/last-reboot-reason" module:"openconfig-platform/openconfig-platform"`
	ΛLastRebootReason     []ygot.Annotation                       `path:"state/@last-reboot-reason" ygotAnnotation:"true"`
	LastRebootTime        *uint64                                 `path:"state/last-reboot-time" module:"openconfig-platform/openconfig-platform"`
	ΛLastRebootTime       []ygot.Annotation                       `path:"state/@last-reboot-time" ygotAnnotation:"true"`
	LastSwitchoverReason  *Component_LastSwitchoverReason         `path:"state/last-switchover-reason" module:"openconfig-platform/openconfig-platform"`
	ΛLastSwitchoverReason []ygot.Annotation                       `path:"state/@last-switchover-reason" ygotAnnotation:"true"`
	LastSwitchoverTime    *uint64                                 `path:"state/last-switchover-time" module:"openconfig-platform/openconfig-platform"`
	ΛLastSwitchoverTime   []ygot.Annotation                       `path:"state/@last-switchover-time" ygotAnnotation:"true"`
	Location              *string                                 `path:"state/location" module:"openconfig-platform/openconfig-platform"`
	ΛLocation             []ygot.Annotation                       `path:"state/@location" ygotAnnotation:"true"`
	Memory                *Component_Memory                       `path:"state/memory" module:"openconfig-platform/openconfig-platform"`
	ΛMemory               []ygot.Annotation                       `path:"state/@memory" ygotAnnotation:"true"`
	MfgDate               *string                                 `path:"state/mfg-date" module:"openconfig-platform/openconfig-platform"`
	ΛMfgDate              []ygot.Annotation                       `path:"state/@mfg-date" ygotAnnotation:"true"`
	MfgName               *string                                 `path:"state/mfg-name" module:"openconfig-platform/openconfig-platform"`
	ΛMfgName              []ygot.Annotation                       `path:"state/@mfg-name" ygotAnnotation:"true"`
	Name                  *string                                 `path:"config/name|name" module:"openconfig-platform/openconfig-platform|openconfig-platform"`
	ΛName                 []ygot.Annotation                       `path:"config/@name|@name" ygotAnnotation:"true"`
	OperStatus            E_PlatformTypes_COMPONENT_OPER_STATUS   `path:"state/oper-status" module:"openconfig-platform/openconfig-platform"`
	ΛOperStatus           []ygot.Annotation                       `path:"state/@oper-status" ygotAnnotation:"true"`
	OpticalChannel        *Component_OpticalChannel               `path:"optical-channel" module:"openconfig-terminal-device"`
	ΛOpticalChannel       []ygot.Annotation                       `path:"@optical-channel" ygotAnnotation:"true"`
	Parent                *string                                 `path:"state/parent" module:"openconfig-platform/openconfig-platform"`
	ΛParent               []ygot.Annotation                       `path:"state/@parent" ygotAnnotation:"true"`
	PartNo                *string                                 `path:"state/part-no" module:"openconfig-platform/openconfig-platform"`
	ΛPartNo               []ygot.Annotation                       `path:"state/@part-no" ygotAnnotation:"true"`
	Pcie                  *Component_Pcie                         `path:"state/pcie" module:"openconfig-platform/openconfig-platform"`
	ΛPcie                 []ygot.Annotation                       `path:"state/@pcie" ygotAnnotation:"true"`
	Port                  *Component_Port                         `path:"port" module:"openconfig-platform"`
	ΛPort                 []ygot.Annotation                       `path:"@port" ygotAnnotation:"true"`
	PowerSupply           *Component_PowerSupply                  `path:"power-supply" module:"openconfig-platform"`
	ΛPowerSupply          []ygot.Annotation                       `path:"@power-supply" ygotAnnotation:"true"`
	Property              map[string]*Component_Property          `path:"properties/property" module:"openconfig-platform/openconfig-platform"`
	ΛProperty             []ygot.Annotation                       `path:"properties/@property" ygotAnnotation:"true"`
	RedundantRole         E_PlatformTypes_ComponentRedundantRole  `path:"state/redundant-role" module:"openconfig-platform/openconfig-platform"`
	ΛRedundantRole        []ygot.Annotation                       `path:"state/@redundant-role" ygotAnnotation:"true"`
	Removable             *bool                                   `path:"state/removable" module:"openconfig-platform/openconfig-platform"`
	ΛRemovable            []ygot.Annotation                       `path:"state/@removable" ygotAnnotation:"true"`
	SerialNo              *string                                 `path:"state/serial-no" module:"openconfig-platform/openconfig-platform"`
	ΛSerialNo             []ygot.Annotation                       `path:"state/@serial-no" ygotAnnotation:"true"`
	SoftwareModule        *Component_SoftwareModule               `path:"software-module" module:"openconfig-platform"`
	ΛSoftwareModule       []ygot.Annotation                       `path:"@software-module" ygotAnnotation:"true"`
	SoftwareVersion       *string                                 `path:"state/software-version" module:"openconfig-platform/openconfig-platform"`
	ΛSoftwareVersion      []ygot.Annotation                       `path:"state/@software-version" ygotAnnotation:"true"`
	Storage               *Component_Storage                      `path:"storage" module:"openconfig-platform"`
	ΛStorage              []ygot.Annotation                       `path:"@storage" ygotAnnotation:"true"`
	Subcomponent          map[string]*Component_Subcomponent      `path:"subcomponents/subcomponent" module:"openconfig-platform/openconfig-platform"`
	ΛSubcomponent         []ygot.Annotation                       `path:"subcomponents/@subcomponent" ygotAnnotation:"true"`
	SwitchoverReady       *bool                                   `path:"state/switchover-ready" module:"openconfig-platform/openconfig-platform"`
	ΛSwitchoverReady      []ygot.Annotation                       `path:"state/@switchover-ready" ygotAnnotation:"true"`
	Temperature           *Component_Temperature                  `path:"state/temperature" module:"openconfig-platform/openconfig-platform"`
	ΛTemperature          []ygot.Annotation                       `path:"state/@temperature" ygotAnnotation:"true"`
	Transceiver           *Component_Transceiver                  `path:"transceiver" module:"openconfig-platform-transceiver"`
	ΛTransceiver          []ygot.Annotation                       `path:"@transceiver" ygotAnnotation:"true"`
	Type                  Component_Type_Union                    `path:"state/type" module:"openconfig-platform/openconfig-platform"`
	ΛType                 []ygot.Annotation                       `path:"state/@type" ygotAnnotation:"true"`
	UsedPower             *uint32                                 `path:"state/used-power" module:"openconfig-platform/openconfig-platform"`
	ΛUsedPower            []ygot.Annotation                       `path:"state/@used-power" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component) IsYANGGoStruct() {}

// NewProperty creates a new entry in the Property list of the
// Component struct. The keys of the list are populated from the input
// arguments.
func (t *Component) NewProperty(Name string) (*Component_Property, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Property == nil {
		t.Property = make(map[string]*Component_Property)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Property[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Property", key)
	}

	t.Property[key] = &Component_Property{
		Name: &Name,
	}

	return t.Property[key], nil
}

// RenameProperty renames an entry in the list Property within
// the Component struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Component) RenameProperty(oldK, newK string) error {
	if _, ok := t.Property[newK]; ok {
		return fmt.Errorf("key %v already exists in Property", newK)
	}

	e, ok := t.Property[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Property", oldK)
	}
	e.Name = &newK

	t.Property[newK] = e
	delete(t.Property, oldK)
	return nil
}

// GetOrCreateProperty retrieves the value with the specified keys from
// the receiver Component. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Component) GetOrCreateProperty(Name string) *Component_Property {

	key := Name

	if v, ok := t.Property[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewProperty(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateProperty got unexpected error: %v", err))
	}
	return v
}

// GetProperty retrieves the value with the specified key from
// the Property map field of Component. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Component) GetProperty(Name string) *Component_Property {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Property[key]; ok {
		return lm
	}
	return nil
}

// AppendProperty appends the supplied Component_Property struct to the
// list Property of Component. If the key value(s) specified in
// the supplied Component_Property already exist in the list, an error is
// returned.
func (t *Component) AppendProperty(v *Component_Property) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Property == nil {
		t.Property = make(map[string]*Component_Property)
	}

	if _, ok := t.Property[key]; ok {
		return fmt.Errorf("duplicate key for list Property %v", key)
	}

	t.Property[key] = v
	return nil
}

// NewSubcomponent creates a new entry in the Subcomponent list of the
// Component struct. The keys of the list are populated from the input
// arguments.
func (t *Component) NewSubcomponent(Name string) (*Component_Subcomponent, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subcomponent == nil {
		t.Subcomponent = make(map[string]*Component_Subcomponent)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Subcomponent[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Subcomponent", key)
	}

	t.Subcomponent[key] = &Component_Subcomponent{
		Name: &Name,
	}

	return t.Subcomponent[key], nil
}

// RenameSubcomponent renames an entry in the list Subcomponent within
// the Component struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Component) RenameSubcomponent(oldK, newK string) error {
	if _, ok := t.Subcomponent[newK]; ok {
		return fmt.Errorf("key %v already exists in Subcomponent", newK)
	}

	e, ok := t.Subcomponent[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Subcomponent", oldK)
	}
	e.Name = &newK

	t.Subcomponent[newK] = e
	delete(t.Subcomponent, oldK)
	return nil
}

// GetOrCreateSubcomponent retrieves the value with the specified keys from
// the receiver Component. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Component) GetOrCreateSubcomponent(Name string) *Component_Subcomponent {

	key := Name

	if v, ok := t.Subcomponent[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewSubcomponent(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateSubcomponent got unexpected error: %v", err))
	}
	return v
}

// GetSubcomponent retrieves the value with the specified key from
// the Subcomponent map field of Component. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Component) GetSubcomponent(Name string) *Component_Subcomponent {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Subcomponent[key]; ok {
		return lm
	}
	return nil
}

// AppendSubcomponent appends the supplied Component_Subcomponent struct to the
// list Subcomponent of Component. If the key value(s) specified in
// the supplied Component_Subcomponent already exist in the list, an error is
// returned.
func (t *Component) AppendSubcomponent(v *Component_Subcomponent) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subcomponent == nil {
		t.Subcomponent = make(map[string]*Component_Subcomponent)
	}

	if _, ok := t.Subcomponent[key]; ok {
		return fmt.Errorf("duplicate key for list Subcomponent %v", key)
	}

	t.Subcomponent[key] = v
	return nil
}

// GetOrCreateBackplane retrieves the value of the Backplane field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateBackplane() *Component_Backplane {
	if t.Backplane != nil {
		return t.Backplane
	}
	t.Backplane = &Component_Backplane{}
	return t.Backplane
}

// GetOrCreateChassis retrieves the value of the Chassis field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateChassis() *Component_Chassis {
	if t.Chassis != nil {
		return t.Chassis
	}
	t.Chassis = &Component_Chassis{}
	return t.Chassis
}

// GetOrCreateControllerCard retrieves the value of the ControllerCard field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateControllerCard() *Component_ControllerCard {
	if t.ControllerCard != nil {
		return t.ControllerCard
	}
	t.ControllerCard = &Component_ControllerCard{}
	return t.ControllerCard
}

// GetOrCreateCpu retrieves the value of the Cpu field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateCpu() *Component_Cpu {
	if t.Cpu != nil {
		return t.Cpu
	}
	t.Cpu = &Component_Cpu{}
	return t.Cpu
}

// GetOrCreateFabric retrieves the value of the Fabric field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateFabric() *Component_Fabric {
	if t.Fabric != nil {
		return t.Fabric
	}
	t.Fabric = &Component_Fabric{}
	return t.Fabric
}

// GetOrCreateFan retrieves the value of the Fan field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateFan() *Component_Fan {
	if t.Fan != nil {
		return t.Fan
	}
	t.Fan = &Component_Fan{}
	return t.Fan
}

// GetOrCreateIntegratedCircuit retrieves the value of the IntegratedCircuit field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateIntegratedCircuit() *Component_IntegratedCircuit {
	if t.IntegratedCircuit != nil {
		return t.IntegratedCircuit
	}
	t.IntegratedCircuit = &Component_IntegratedCircuit{}
	return t.IntegratedCircuit
}

// GetOrCreateLastSwitchoverReason retrieves the value of the LastSwitchoverReason field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateLastSwitchoverReason() *Component_LastSwitchoverReason {
	if t.LastSwitchoverReason != nil {
		return t.LastSwitchoverReason
	}
	t.LastSwitchoverReason = &Component_LastSwitchoverReason{}
	return t.LastSwitchoverReason
}

// GetOrCreateMemory retrieves the value of the Memory field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateMemory() *Component_Memory {
	if t.Memory != nil {
		return t.Memory
	}
	t.Memory = &Component_Memory{}
	return t.Memory
}

// GetOrCreateOpticalChannel retrieves the value of the OpticalChannel field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateOpticalChannel() *Component_OpticalChannel {
	if t.OpticalChannel != nil {
		return t.OpticalChannel
	}
	t.OpticalChannel = &Component_OpticalChannel{}
	return t.OpticalChannel
}

// GetOrCreatePcie retrieves the value of the Pcie field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreatePcie() *Component_Pcie {
	if t.Pcie != nil {
		return t.Pcie
	}
	t.Pcie = &Component_Pcie{}
	return t.Pcie
}

// GetOrCreatePort retrieves the value of the Port field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreatePort() *Component_Port {
	if t.Port != nil {
		return t.Port
	}
	t.Port = &Component_Port{}
	return t.Port
}

// GetOrCreatePowerSupply retrieves the value of the PowerSupply field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreatePowerSupply() *Component_PowerSupply {
	if t.PowerSupply != nil {
		return t.PowerSupply
	}
	t.PowerSupply = &Component_PowerSupply{}
	return t.PowerSupply
}

// GetOrCreateSoftwareModule retrieves the value of the SoftwareModule field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateSoftwareModule() *Component_SoftwareModule {
	if t.SoftwareModule != nil {
		return t.SoftwareModule
	}
	t.SoftwareModule = &Component_SoftwareModule{}
	return t.SoftwareModule
}

// GetOrCreateStorage retrieves the value of the Storage field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateStorage() *Component_Storage {
	if t.Storage != nil {
		return t.Storage
	}
	t.Storage = &Component_Storage{}
	return t.Storage
}

// GetOrCreateTemperature retrieves the value of the Temperature field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateTemperature() *Component_Temperature {
	if t.Temperature != nil {
		return t.Temperature
	}
	t.Temperature = &Component_Temperature{}
	return t.Temperature
}

// GetOrCreateTransceiver retrieves the value of the Transceiver field
// or returns the existing field if it already exists.
func (t *Component) GetOrCreateTransceiver() *Component_Transceiver {
	if t.Transceiver != nil {
		return t.Transceiver
	}
	t.Transceiver = &Component_Transceiver{}
	return t.Transceiver
}

// GetBackplane returns the value of the Backplane struct pointer
// from Component. If the receiver or the field Backplane is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetBackplane() *Component_Backplane {
	if t != nil && t.Backplane != nil {
		return t.Backplane
	}
	return nil
}

// GetChassis returns the value of the Chassis struct pointer
// from Component. If the receiver or the field Chassis is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetChassis() *Component_Chassis {
	if t != nil && t.Chassis != nil {
		return t.Chassis
	}
	return nil
}

// GetControllerCard returns the value of the ControllerCard struct pointer
// from Component. If the receiver or the field ControllerCard is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetControllerCard() *Component_ControllerCard {
	if t != nil && t.ControllerCard != nil {
		return t.ControllerCard
	}
	return nil
}

// GetCpu returns the value of the Cpu struct pointer
// from Component. If the receiver or the field Cpu is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetCpu() *Component_Cpu {
	if t != nil && t.Cpu != nil {
		return t.Cpu
	}
	return nil
}

// GetFabric returns the value of the Fabric struct pointer
// from Component. If the receiver or the field Fabric is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetFabric() *Component_Fabric {
	if t != nil && t.Fabric != nil {
		return t.Fabric
	}
	return nil
}

// GetFan returns the value of the Fan struct pointer
// from Component. If the receiver or the field Fan is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetFan() *Component_Fan {
	if t != nil && t.Fan != nil {
		return t.Fan
	}
	return nil
}

// GetIntegratedCircuit returns the value of the IntegratedCircuit struct pointer
// from Component. If the receiver or the field IntegratedCircuit is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetIntegratedCircuit() *Component_IntegratedCircuit {
	if t != nil && t.IntegratedCircuit != nil {
		return t.IntegratedCircuit
	}
	return nil
}

// GetLastSwitchoverReason returns the value of the LastSwitchoverReason struct pointer
// from Component. If the receiver or the field LastSwitchoverReason is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetLastSwitchoverReason() *Component_LastSwitchoverReason {
	if t != nil && t.LastSwitchoverReason != nil {
		return t.LastSwitchoverReason
	}
	return nil
}

// GetMemory returns the value of the Memory struct pointer
// from Component. If the receiver or the field Memory is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetMemory() *Component_Memory {
	if t != nil && t.Memory != nil {
		return t.Memory
	}
	return nil
}

// GetOpticalChannel returns the value of the OpticalChannel struct pointer
// from Component. If the receiver or the field OpticalChannel is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetOpticalChannel() *Component_OpticalChannel {
	if t != nil && t.OpticalChannel != nil {
		return t.OpticalChannel
	}
	return nil
}

// GetPcie returns the value of the Pcie struct pointer
// from Component. If the receiver or the field Pcie is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetPcie() *Component_Pcie {
	if t != nil && t.Pcie != nil {
		return t.Pcie
	}
	return nil
}

// GetPort returns the value of the Port struct pointer
// from Component. If the receiver or the field Port is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetPort() *Component_Port {
	if t != nil && t.Port != nil {
		return t.Port
	}
	return nil
}

// GetPowerSupply returns the value of the PowerSupply struct pointer
// from Component. If the receiver or the field PowerSupply is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetPowerSupply() *Component_PowerSupply {
	if t != nil && t.PowerSupply != nil {
		return t.PowerSupply
	}
	return nil
}

// GetSoftwareModule returns the value of the SoftwareModule struct pointer
// from Component. If the receiver or the field SoftwareModule is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetSoftwareModule() *Component_SoftwareModule {
	if t != nil && t.SoftwareModule != nil {
		return t.SoftwareModule
	}
	return nil
}

// GetStorage returns the value of the Storage struct pointer
// from Component. If the receiver or the field Storage is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetStorage() *Component_Storage {
	if t != nil && t.Storage != nil {
		return t.Storage
	}
	return nil
}

// GetTemperature returns the value of the Temperature struct pointer
// from Component. If the receiver or the field Temperature is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetTemperature() *Component_Temperature {
	if t != nil && t.Temperature != nil {
		return t.Temperature
	}
	return nil
}

// GetTransceiver returns the value of the Transceiver struct pointer
// from Component. If the receiver or the field Transceiver is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component) GetTransceiver() *Component_Transceiver {
	if t != nil && t.Transceiver != nil {
		return t.Transceiver
	}
	return nil
}

// GetAllocatedPower retrieves the value of the leaf AllocatedPower from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AllocatedPower is set, it can
// safely use t.GetAllocatedPower() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AllocatedPower == nil' before retrieving the leaf's value.
func (t *Component) GetAllocatedPower() uint32 {
	if t == nil || t.AllocatedPower == nil {
		return 0
	}
	return *t.AllocatedPower
}

// GetBaseMacAddress retrieves the value of the leaf BaseMacAddress from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if BaseMacAddress is set, it can
// safely use t.GetBaseMacAddress() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.BaseMacAddress == nil' before retrieving the leaf's value.
func (t *Component) GetBaseMacAddress() string {
	if t == nil || t.BaseMacAddress == nil {
		return ""
	}
	return *t.BaseMacAddress
}

// GetCleiCode retrieves the value of the leaf CleiCode from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if CleiCode is set, it can
// safely use t.GetCleiCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.CleiCode == nil' before retrieving the leaf's value.
func (t *Component) GetCleiCode() string {
	if t == nil || t.CleiCode == nil {
		return ""
	}
	return *t.CleiCode
}

// GetDescription retrieves the value of the leaf Description from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *Component) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetEmpty retrieves the value of the leaf Empty from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Empty is set, it can
// safely use t.GetEmpty() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Empty == nil' before retrieving the leaf's value.
func (t *Component) GetEmpty() bool {
	if t == nil || t.Empty == nil {
		return false
	}
	return *t.Empty
}

// GetEquipmentFailure retrieves the value of the leaf EquipmentFailure from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EquipmentFailure is set, it can
// safely use t.GetEquipmentFailure() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EquipmentFailure == nil' before retrieving the leaf's value.
func (t *Component) GetEquipmentFailure() bool {
	if t == nil || t.EquipmentFailure == nil {
		return false
	}
	return *t.EquipmentFailure
}

// GetEquipmentMismatch retrieves the value of the leaf EquipmentMismatch from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EquipmentMismatch is set, it can
// safely use t.GetEquipmentMismatch() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EquipmentMismatch == nil' before retrieving the leaf's value.
func (t *Component) GetEquipmentMismatch() bool {
	if t == nil || t.EquipmentMismatch == nil {
		return false
	}
	return *t.EquipmentMismatch
}

// GetFirmwareVersion retrieves the value of the leaf FirmwareVersion from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FirmwareVersion is set, it can
// safely use t.GetFirmwareVersion() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FirmwareVersion == nil' before retrieving the leaf's value.
func (t *Component) GetFirmwareVersion() string {
	if t == nil || t.FirmwareVersion == nil {
		return ""
	}
	return *t.FirmwareVersion
}

// GetHardwareVersion retrieves the value of the leaf HardwareVersion from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HardwareVersion is set, it can
// safely use t.GetHardwareVersion() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HardwareVersion == nil' before retrieving the leaf's value.
func (t *Component) GetHardwareVersion() string {
	if t == nil || t.HardwareVersion == nil {
		return ""
	}
	return *t.HardwareVersion
}

// GetId retrieves the value of the leaf Id from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Id is set, it can
// safely use t.GetId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Id == nil' before retrieving the leaf's value.
func (t *Component) GetId() string {
	if t == nil || t.Id == nil {
		return ""
	}
	return *t.Id
}

// GetLastRebootReason retrieves the value of the leaf LastRebootReason from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastRebootReason is set, it can
// safely use t.GetLastRebootReason() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastRebootReason == nil' before retrieving the leaf's value.
func (t *Component) GetLastRebootReason() E_PlatformTypes_COMPONENT_REBOOT_REASON {
	if t == nil || t.LastRebootReason == 0 {
		return 0
	}
	return t.LastRebootReason
}

// GetLastRebootTime retrieves the value of the leaf LastRebootTime from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastRebootTime is set, it can
// safely use t.GetLastRebootTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastRebootTime == nil' before retrieving the leaf's value.
func (t *Component) GetLastRebootTime() uint64 {
	if t == nil || t.LastRebootTime == nil {
		return 0
	}
	return *t.LastRebootTime
}

// GetLastSwitchoverTime retrieves the value of the leaf LastSwitchoverTime from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastSwitchoverTime is set, it can
// safely use t.GetLastSwitchoverTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastSwitchoverTime == nil' before retrieving the leaf's value.
func (t *Component) GetLastSwitchoverTime() uint64 {
	if t == nil || t.LastSwitchoverTime == nil {
		return 0
	}
	return *t.LastSwitchoverTime
}

// GetLocation retrieves the value of the leaf Location from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Location is set, it can
// safely use t.GetLocation() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Location == nil' before retrieving the leaf's value.
func (t *Component) GetLocation() string {
	if t == nil || t.Location == nil {
		return ""
	}
	return *t.Location
}

// GetMfgDate retrieves the value of the leaf MfgDate from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MfgDate is set, it can
// safely use t.GetMfgDate() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MfgDate == nil' before retrieving the leaf's value.
func (t *Component) GetMfgDate() string {
	if t == nil || t.MfgDate == nil {
		return ""
	}
	return *t.MfgDate
}

// GetMfgName retrieves the value of the leaf MfgName from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MfgName is set, it can
// safely use t.GetMfgName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MfgName == nil' before retrieving the leaf's value.
func (t *Component) GetMfgName() string {
	if t == nil || t.MfgName == nil {
		return ""
	}
	return *t.MfgName
}

// GetName retrieves the value of the leaf Name from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *Component) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetOperStatus retrieves the value of the leaf OperStatus from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OperStatus is set, it can
// safely use t.GetOperStatus() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OperStatus == nil' before retrieving the leaf's value.
func (t *Component) GetOperStatus() E_PlatformTypes_COMPONENT_OPER_STATUS {
	if t == nil || t.OperStatus == 0 {
		return 0
	}
	return t.OperStatus
}

// GetParent retrieves the value of the leaf Parent from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Parent is set, it can
// safely use t.GetParent() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Parent == nil' before retrieving the leaf's value.
func (t *Component) GetParent() string {
	if t == nil || t.Parent == nil {
		return ""
	}
	return *t.Parent
}

// GetPartNo retrieves the value of the leaf PartNo from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if PartNo is set, it can
// safely use t.GetPartNo() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.PartNo == nil' before retrieving the leaf's value.
func (t *Component) GetPartNo() string {
	if t == nil || t.PartNo == nil {
		return ""
	}
	return *t.PartNo
}

// GetRedundantRole retrieves the value of the leaf RedundantRole from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RedundantRole is set, it can
// safely use t.GetRedundantRole() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RedundantRole == nil' before retrieving the leaf's value.
func (t *Component) GetRedundantRole() E_PlatformTypes_ComponentRedundantRole {
	if t == nil || t.RedundantRole == 0 {
		return 0
	}
	return t.RedundantRole
}

// GetRemovable retrieves the value of the leaf Removable from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Removable is set, it can
// safely use t.GetRemovable() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Removable == nil' before retrieving the leaf's value.
func (t *Component) GetRemovable() bool {
	if t == nil || t.Removable == nil {
		return false
	}
	return *t.Removable
}

// GetSerialNo retrieves the value of the leaf SerialNo from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SerialNo is set, it can
// safely use t.GetSerialNo() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SerialNo == nil' before retrieving the leaf's value.
func (t *Component) GetSerialNo() string {
	if t == nil || t.SerialNo == nil {
		return ""
	}
	return *t.SerialNo
}

// GetSoftwareVersion retrieves the value of the leaf SoftwareVersion from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SoftwareVersion is set, it can
// safely use t.GetSoftwareVersion() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SoftwareVersion == nil' before retrieving the leaf's value.
func (t *Component) GetSoftwareVersion() string {
	if t == nil || t.SoftwareVersion == nil {
		return ""
	}
	return *t.SoftwareVersion
}

// GetSwitchoverReady retrieves the value of the leaf SwitchoverReady from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SwitchoverReady is set, it can
// safely use t.GetSwitchoverReady() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SwitchoverReady == nil' before retrieving the leaf's value.
func (t *Component) GetSwitchoverReady() bool {
	if t == nil || t.SwitchoverReady == nil {
		return false
	}
	return *t.SwitchoverReady
}

// GetType retrieves the value of the leaf Type from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *Component) GetType() Component_Type_Union {
	if t == nil || t.Type == nil {
		return nil
	}
	return t.Type
}

// GetUsedPower retrieves the value of the leaf UsedPower from the Component
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UsedPower is set, it can
// safely use t.GetUsedPower() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UsedPower == nil' before retrieving the leaf's value.
func (t *Component) GetUsedPower() uint32 {
	if t == nil || t.UsedPower == nil {
		return 0
	}
	return *t.UsedPower
}

// ΛListKeyMap returns the keys of the Component struct, which is a YANG list entry.
func (t *Component) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component.
func (*Component) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Type_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-platform/components/component/state/type within the YANG schema.
type Component_Type_Union interface {
	Is_Component_Type_Union()
}

// Component_Type_Union_E_PlatformTypes_OPENCONFIG_HARDWARE_COMPONENT is used when /openconfig-platform/components/component/state/type
// is to be set to a E_PlatformTypes_OPENCONFIG_HARDWARE_COMPONENT value.
type Component_Type_Union_E_PlatformTypes_OPENCONFIG_HARDWARE_COMPONENT struct {
	E_PlatformTypes_OPENCONFIG_HARDWARE_COMPONENT E_PlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
}

// Is_Component_Type_Union ensures that Component_Type_Union_E_PlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
// implements the Component_Type_Union interface.
func (*Component_Type_Union_E_PlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) Is_Component_Type_Union() {
}

// Component_Type_Union_E_PlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT is used when /openconfig-platform/components/component/state/type
// is to be set to a E_PlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT value.
type Component_Type_Union_E_PlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT struct {
	E_PlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT E_PlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
}

// Is_Component_Type_Union ensures that Component_Type_Union_E_PlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
// implements the Component_Type_Union interface.
func (*Component_Type_Union_E_PlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) Is_Component_Type_Union() {
}

// To_Component_Type_Union takes an input interface{} and attempts to convert it to a struct
// which implements the Component_Type_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *Component) To_Component_Type_Union(i interface{}) (Component_Type_Union, error) {
	switch v := i.(type) {
	case E_PlatformTypes_OPENCONFIG_HARDWARE_COMPONENT:
		return &Component_Type_Union_E_PlatformTypes_OPENCONFIG_HARDWARE_COMPONENT{v}, nil
	case E_PlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT:
		return &Component_Type_Union_E_PlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to Component_Type_Union, unknown union type, got: %T, want any of [E_PlatformTypes_OPENCONFIG_HARDWARE_COMPONENT, E_PlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT]", i, i)
	}
}

// Component_Backplane represents the /openconfig-platform/components/component/backplane YANG schema element.
type Component_Backplane struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Backplane implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Backplane) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Backplane) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Backplane"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Backplane) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Backplane) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Backplane.
func (*Component_Backplane) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Chassis represents the /openconfig-platform/components/component/chassis YANG schema element.
type Component_Chassis struct {
	ΛMetadata    []ygot.Annotation              `path:"@" ygotAnnotation:"true"`
	Utilization  *Component_Chassis_Utilization `path:"utilization" module:"openconfig-platform"`
	ΛUtilization []ygot.Annotation              `path:"@utilization" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Chassis implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Chassis) IsYANGGoStruct() {}

// GetOrCreateUtilization retrieves the value of the Utilization field
// or returns the existing field if it already exists.
func (t *Component_Chassis) GetOrCreateUtilization() *Component_Chassis_Utilization {
	if t.Utilization != nil {
		return t.Utilization
	}
	t.Utilization = &Component_Chassis_Utilization{}
	return t.Utilization
}

// GetUtilization returns the value of the Utilization struct pointer
// from Component_Chassis. If the receiver or the field Utilization is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Chassis) GetUtilization() *Component_Chassis_Utilization {
	if t != nil && t.Utilization != nil {
		return t.Utilization
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Chassis) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Chassis"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Chassis) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Chassis) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Chassis.
func (*Component_Chassis) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Chassis_Utilization represents the /openconfig-platform/components/component/chassis/utilization YANG schema element.
type Component_Chassis_Utilization struct {
	ΛMetadata []ygot.Annotation                                  `path:"@" ygotAnnotation:"true"`
	Resource  map[string]*Component_Chassis_Utilization_Resource `path:"resources/resource" module:"openconfig-platform/openconfig-platform"`
	ΛResource []ygot.Annotation                                  `path:"resources/@resource" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Chassis_Utilization implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Chassis_Utilization) IsYANGGoStruct() {}

// NewResource creates a new entry in the Resource list of the
// Component_Chassis_Utilization struct. The keys of the list are populated from the input
// arguments.
func (t *Component_Chassis_Utilization) NewResource(Name string) (*Component_Chassis_Utilization_Resource, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Resource == nil {
		t.Resource = make(map[string]*Component_Chassis_Utilization_Resource)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Resource[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Resource", key)
	}

	t.Resource[key] = &Component_Chassis_Utilization_Resource{
		Name: &Name,
	}

	return t.Resource[key], nil
}

// RenameResource renames an entry in the list Resource within
// the Component_Chassis_Utilization struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Component_Chassis_Utilization) RenameResource(oldK, newK string) error {
	if _, ok := t.Resource[newK]; ok {
		return fmt.Errorf("key %v already exists in Resource", newK)
	}

	e, ok := t.Resource[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Resource", oldK)
	}
	e.Name = &newK

	t.Resource[newK] = e
	delete(t.Resource, oldK)
	return nil
}

// GetOrCreateResource retrieves the value with the specified keys from
// the receiver Component_Chassis_Utilization. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Component_Chassis_Utilization) GetOrCreateResource(Name string) *Component_Chassis_Utilization_Resource {

	key := Name

	if v, ok := t.Resource[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewResource(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateResource got unexpected error: %v", err))
	}
	return v
}

// GetResource retrieves the value with the specified key from
// the Resource map field of Component_Chassis_Utilization. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Component_Chassis_Utilization) GetResource(Name string) *Component_Chassis_Utilization_Resource {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Resource[key]; ok {
		return lm
	}
	return nil
}

// AppendResource appends the supplied Component_Chassis_Utilization_Resource struct to the
// list Resource of Component_Chassis_Utilization. If the key value(s) specified in
// the supplied Component_Chassis_Utilization_Resource already exist in the list, an error is
// returned.
func (t *Component_Chassis_Utilization) AppendResource(v *Component_Chassis_Utilization_Resource) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Resource == nil {
		t.Resource = make(map[string]*Component_Chassis_Utilization_Resource)
	}

	if _, ok := t.Resource[key]; ok {
		return fmt.Errorf("duplicate key for list Resource %v", key)
	}

	t.Resource[key] = v
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Chassis_Utilization) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Chassis_Utilization"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Chassis_Utilization) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Chassis_Utilization) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Chassis_Utilization.
func (*Component_Chassis_Utilization) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Chassis_Utilization_Resource represents the /openconfig-platform/components/component/chassis/utilization/resources/resource YANG schema element.
type Component_Chassis_Utilization_Resource struct {
	ΛMetadata          []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Committed          *uint64           `path:"state/committed" module:"openconfig-platform/openconfig-platform"`
	ΛCommitted         []ygot.Annotation `path:"state/@committed" ygotAnnotation:"true"`
	Free               *uint64           `path:"state/free" module:"openconfig-platform/openconfig-platform"`
	ΛFree              []ygot.Annotation `path:"state/@free" ygotAnnotation:"true"`
	HighWatermark      *uint64           `path:"state/high-watermark" module:"openconfig-platform/openconfig-platform"`
	ΛHighWatermark     []ygot.Annotation `path:"state/@high-watermark" ygotAnnotation:"true"`
	LastHighWatermark  *uint64           `path:"state/last-high-watermark" module:"openconfig-platform/openconfig-platform"`
	ΛLastHighWatermark []ygot.Annotation `path:"state/@last-high-watermark" ygotAnnotation:"true"`
	MaxLimit           *uint64           `path:"state/max-limit" module:"openconfig-platform/openconfig-platform"`
	ΛMaxLimit          []ygot.Annotation `path:"state/@max-limit" ygotAnnotation:"true"`
	Name               *string           `path:"config/name|name" module:"openconfig-platform/openconfig-platform|openconfig-platform"`
	ΛName              []ygot.Annotation `path:"config/@name|@name" ygotAnnotation:"true"`
	Used               *uint64           `path:"state/used" module:"openconfig-platform/openconfig-platform"`
	ΛUsed              []ygot.Annotation `path:"state/@used" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Chassis_Utilization_Resource implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Chassis_Utilization_Resource) IsYANGGoStruct() {}

// GetCommitted retrieves the value of the leaf Committed from the Component_Chassis_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Committed is set, it can
// safely use t.GetCommitted() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Committed == nil' before retrieving the leaf's value.
func (t *Component_Chassis_Utilization_Resource) GetCommitted() uint64 {
	if t == nil || t.Committed == nil {
		return 0
	}
	return *t.Committed
}

// GetFree retrieves the value of the leaf Free from the Component_Chassis_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Free is set, it can
// safely use t.GetFree() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Free == nil' before retrieving the leaf's value.
func (t *Component_Chassis_Utilization_Resource) GetFree() uint64 {
	if t == nil || t.Free == nil {
		return 0
	}
	return *t.Free
}

// GetHighWatermark retrieves the value of the leaf HighWatermark from the Component_Chassis_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HighWatermark is set, it can
// safely use t.GetHighWatermark() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HighWatermark == nil' before retrieving the leaf's value.
func (t *Component_Chassis_Utilization_Resource) GetHighWatermark() uint64 {
	if t == nil || t.HighWatermark == nil {
		return 0
	}
	return *t.HighWatermark
}

// GetLastHighWatermark retrieves the value of the leaf LastHighWatermark from the Component_Chassis_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastHighWatermark is set, it can
// safely use t.GetLastHighWatermark() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastHighWatermark == nil' before retrieving the leaf's value.
func (t *Component_Chassis_Utilization_Resource) GetLastHighWatermark() uint64 {
	if t == nil || t.LastHighWatermark == nil {
		return 0
	}
	return *t.LastHighWatermark
}

// GetMaxLimit retrieves the value of the leaf MaxLimit from the Component_Chassis_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxLimit is set, it can
// safely use t.GetMaxLimit() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxLimit == nil' before retrieving the leaf's value.
func (t *Component_Chassis_Utilization_Resource) GetMaxLimit() uint64 {
	if t == nil || t.MaxLimit == nil {
		return 0
	}
	return *t.MaxLimit
}

// GetName retrieves the value of the leaf Name from the Component_Chassis_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *Component_Chassis_Utilization_Resource) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetUsed retrieves the value of the leaf Used from the Component_Chassis_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Used is set, it can
// safely use t.GetUsed() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Used == nil' before retrieving the leaf's value.
func (t *Component_Chassis_Utilization_Resource) GetUsed() uint64 {
	if t == nil || t.Used == nil {
		return 0
	}
	return *t.Used
}

// ΛListKeyMap returns the keys of the Component_Chassis_Utilization_Resource struct, which is a YANG list entry.
func (t *Component_Chassis_Utilization_Resource) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Chassis_Utilization_Resource) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Chassis_Utilization_Resource"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Chassis_Utilization_Resource) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Chassis_Utilization_Resource) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Chassis_Utilization_Resource.
func (*Component_Chassis_Utilization_Resource) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_ControllerCard represents the /openconfig-platform/components/component/controller-card YANG schema element.
type Component_ControllerCard struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_ControllerCard implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_ControllerCard) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_ControllerCard) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_ControllerCard"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_ControllerCard) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_ControllerCard) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_ControllerCard.
func (*Component_ControllerCard) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Cpu represents the /openconfig-platform/components/component/cpu YANG schema element.
type Component_Cpu struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Cpu implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Cpu) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Cpu) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Cpu"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Cpu) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Cpu) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Cpu.
func (*Component_Cpu) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Fabric represents the /openconfig-platform/components/component/fabric YANG schema element.
type Component_Fabric struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Fabric implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Fabric) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Fabric) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Fabric"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Fabric) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Fabric) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Fabric.
func (*Component_Fabric) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Fan represents the /openconfig-platform/components/component/fan YANG schema element.
type Component_Fan struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Fan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Fan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Fan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Fan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Fan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Fan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Fan.
func (*Component_Fan) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_IntegratedCircuit represents the /openconfig-platform/components/component/integrated-circuit YANG schema element.
type Component_IntegratedCircuit struct {
	ΛMetadata    []ygot.Annotation                        `path:"@" ygotAnnotation:"true"`
	Utilization  *Component_IntegratedCircuit_Utilization `path:"utilization" module:"openconfig-platform"`
	ΛUtilization []ygot.Annotation                        `path:"@utilization" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_IntegratedCircuit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_IntegratedCircuit) IsYANGGoStruct() {}

// GetOrCreateUtilization retrieves the value of the Utilization field
// or returns the existing field if it already exists.
func (t *Component_IntegratedCircuit) GetOrCreateUtilization() *Component_IntegratedCircuit_Utilization {
	if t.Utilization != nil {
		return t.Utilization
	}
	t.Utilization = &Component_IntegratedCircuit_Utilization{}
	return t.Utilization
}

// GetUtilization returns the value of the Utilization struct pointer
// from Component_IntegratedCircuit. If the receiver or the field Utilization is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_IntegratedCircuit) GetUtilization() *Component_IntegratedCircuit_Utilization {
	if t != nil && t.Utilization != nil {
		return t.Utilization
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_IntegratedCircuit) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_IntegratedCircuit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_IntegratedCircuit) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_IntegratedCircuit) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_IntegratedCircuit.
func (*Component_IntegratedCircuit) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_IntegratedCircuit_Utilization represents the /openconfig-platform/components/component/integrated-circuit/utilization YANG schema element.
type Component_IntegratedCircuit_Utilization struct {
	ΛMetadata []ygot.Annotation                                            `path:"@" ygotAnnotation:"true"`
	Resource  map[string]*Component_IntegratedCircuit_Utilization_Resource `path:"resources/resource" module:"openconfig-platform/openconfig-platform"`
	ΛResource []ygot.Annotation                                            `path:"resources/@resource" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_IntegratedCircuit_Utilization implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_IntegratedCircuit_Utilization) IsYANGGoStruct() {}

// NewResource creates a new entry in the Resource list of the
// Component_IntegratedCircuit_Utilization struct. The keys of the list are populated from the input
// arguments.
func (t *Component_IntegratedCircuit_Utilization) NewResource(Name string) (*Component_IntegratedCircuit_Utilization_Resource, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Resource == nil {
		t.Resource = make(map[string]*Component_IntegratedCircuit_Utilization_Resource)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Resource[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Resource", key)
	}

	t.Resource[key] = &Component_IntegratedCircuit_Utilization_Resource{
		Name: &Name,
	}

	return t.Resource[key], nil
}

// RenameResource renames an entry in the list Resource within
// the Component_IntegratedCircuit_Utilization struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Component_IntegratedCircuit_Utilization) RenameResource(oldK, newK string) error {
	if _, ok := t.Resource[newK]; ok {
		return fmt.Errorf("key %v already exists in Resource", newK)
	}

	e, ok := t.Resource[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Resource", oldK)
	}
	e.Name = &newK

	t.Resource[newK] = e
	delete(t.Resource, oldK)
	return nil
}

// GetOrCreateResource retrieves the value with the specified keys from
// the receiver Component_IntegratedCircuit_Utilization. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Component_IntegratedCircuit_Utilization) GetOrCreateResource(Name string) *Component_IntegratedCircuit_Utilization_Resource {

	key := Name

	if v, ok := t.Resource[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewResource(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateResource got unexpected error: %v", err))
	}
	return v
}

// GetResource retrieves the value with the specified key from
// the Resource map field of Component_IntegratedCircuit_Utilization. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Component_IntegratedCircuit_Utilization) GetResource(Name string) *Component_IntegratedCircuit_Utilization_Resource {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Resource[key]; ok {
		return lm
	}
	return nil
}

// AppendResource appends the supplied Component_IntegratedCircuit_Utilization_Resource struct to the
// list Resource of Component_IntegratedCircuit_Utilization. If the key value(s) specified in
// the supplied Component_IntegratedCircuit_Utilization_Resource already exist in the list, an error is
// returned.
func (t *Component_IntegratedCircuit_Utilization) AppendResource(v *Component_IntegratedCircuit_Utilization_Resource) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Resource == nil {
		t.Resource = make(map[string]*Component_IntegratedCircuit_Utilization_Resource)
	}

	if _, ok := t.Resource[key]; ok {
		return fmt.Errorf("duplicate key for list Resource %v", key)
	}

	t.Resource[key] = v
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_IntegratedCircuit_Utilization) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_IntegratedCircuit_Utilization"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_IntegratedCircuit_Utilization) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_IntegratedCircuit_Utilization) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_IntegratedCircuit_Utilization.
func (*Component_IntegratedCircuit_Utilization) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_IntegratedCircuit_Utilization_Resource represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource struct {
	ΛMetadata          []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Committed          *uint64           `path:"state/committed" module:"openconfig-platform/openconfig-platform"`
	ΛCommitted         []ygot.Annotation `path:"state/@committed" ygotAnnotation:"true"`
	Free               *uint64           `path:"state/free" module:"openconfig-platform/openconfig-platform"`
	ΛFree              []ygot.Annotation `path:"state/@free" ygotAnnotation:"true"`
	HighWatermark      *uint64           `path:"state/high-watermark" module:"openconfig-platform/openconfig-platform"`
	ΛHighWatermark     []ygot.Annotation `path:"state/@high-watermark" ygotAnnotation:"true"`
	LastHighWatermark  *uint64           `path:"state/last-high-watermark" module:"openconfig-platform/openconfig-platform"`
	ΛLastHighWatermark []ygot.Annotation `path:"state/@last-high-watermark" ygotAnnotation:"true"`
	MaxLimit           *uint64           `path:"state/max-limit" module:"openconfig-platform/openconfig-platform"`
	ΛMaxLimit          []ygot.Annotation `path:"state/@max-limit" ygotAnnotation:"true"`
	Name               *string           `path:"config/name|name" module:"openconfig-platform/openconfig-platform|openconfig-platform"`
	ΛName              []ygot.Annotation `path:"config/@name|@name" ygotAnnotation:"true"`
	Used               *uint64           `path:"state/used" module:"openconfig-platform/openconfig-platform"`
	ΛUsed              []ygot.Annotation `path:"state/@used" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_IntegratedCircuit_Utilization_Resource implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_IntegratedCircuit_Utilization_Resource) IsYANGGoStruct() {}

// GetCommitted retrieves the value of the leaf Committed from the Component_IntegratedCircuit_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Committed is set, it can
// safely use t.GetCommitted() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Committed == nil' before retrieving the leaf's value.
func (t *Component_IntegratedCircuit_Utilization_Resource) GetCommitted() uint64 {
	if t == nil || t.Committed == nil {
		return 0
	}
	return *t.Committed
}

// GetFree retrieves the value of the leaf Free from the Component_IntegratedCircuit_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Free is set, it can
// safely use t.GetFree() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Free == nil' before retrieving the leaf's value.
func (t *Component_IntegratedCircuit_Utilization_Resource) GetFree() uint64 {
	if t == nil || t.Free == nil {
		return 0
	}
	return *t.Free
}

// GetHighWatermark retrieves the value of the leaf HighWatermark from the Component_IntegratedCircuit_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HighWatermark is set, it can
// safely use t.GetHighWatermark() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HighWatermark == nil' before retrieving the leaf's value.
func (t *Component_IntegratedCircuit_Utilization_Resource) GetHighWatermark() uint64 {
	if t == nil || t.HighWatermark == nil {
		return 0
	}
	return *t.HighWatermark
}

// GetLastHighWatermark retrieves the value of the leaf LastHighWatermark from the Component_IntegratedCircuit_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastHighWatermark is set, it can
// safely use t.GetLastHighWatermark() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastHighWatermark == nil' before retrieving the leaf's value.
func (t *Component_IntegratedCircuit_Utilization_Resource) GetLastHighWatermark() uint64 {
	if t == nil || t.LastHighWatermark == nil {
		return 0
	}
	return *t.LastHighWatermark
}

// GetMaxLimit retrieves the value of the leaf MaxLimit from the Component_IntegratedCircuit_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxLimit is set, it can
// safely use t.GetMaxLimit() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxLimit == nil' before retrieving the leaf's value.
func (t *Component_IntegratedCircuit_Utilization_Resource) GetMaxLimit() uint64 {
	if t == nil || t.MaxLimit == nil {
		return 0
	}
	return *t.MaxLimit
}

// GetName retrieves the value of the leaf Name from the Component_IntegratedCircuit_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *Component_IntegratedCircuit_Utilization_Resource) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetUsed retrieves the value of the leaf Used from the Component_IntegratedCircuit_Utilization_Resource
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Used is set, it can
// safely use t.GetUsed() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Used == nil' before retrieving the leaf's value.
func (t *Component_IntegratedCircuit_Utilization_Resource) GetUsed() uint64 {
	if t == nil || t.Used == nil {
		return 0
	}
	return *t.Used
}

// ΛListKeyMap returns the keys of the Component_IntegratedCircuit_Utilization_Resource struct, which is a YANG list entry.
func (t *Component_IntegratedCircuit_Utilization_Resource) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_IntegratedCircuit_Utilization_Resource) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_IntegratedCircuit_Utilization_Resource"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_IntegratedCircuit_Utilization_Resource) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_IntegratedCircuit_Utilization_Resource) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_IntegratedCircuit_Utilization_Resource.
func (*Component_IntegratedCircuit_Utilization_Resource) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_LastSwitchoverReason represents the /openconfig-platform/components/component/state/last-switchover-reason YANG schema element.
type Component_LastSwitchoverReason struct {
	ΛMetadata []ygot.Annotation                                             `path:"@" ygotAnnotation:"true"`
	Details   *string                                                       `path:"details" module:"openconfig-platform"`
	ΛDetails  []ygot.Annotation                                             `path:"@details" ygotAnnotation:"true"`
	Trigger   E_PlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger `path:"trigger" module:"openconfig-platform"`
	ΛTrigger  []ygot.Annotation                                             `path:"@trigger" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_LastSwitchoverReason implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_LastSwitchoverReason) IsYANGGoStruct() {}

// GetDetails retrieves the value of the leaf Details from the Component_LastSwitchoverReason
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Details is set, it can
// safely use t.GetDetails() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Details == nil' before retrieving the leaf's value.
func (t *Component_LastSwitchoverReason) GetDetails() string {
	if t == nil || t.Details == nil {
		return ""
	}
	return *t.Details
}

// GetTrigger retrieves the value of the leaf Trigger from the Component_LastSwitchoverReason
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Trigger is set, it can
// safely use t.GetTrigger() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Trigger == nil' before retrieving the leaf's value.
func (t *Component_LastSwitchoverReason) GetTrigger() E_PlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger {
	if t == nil || t.Trigger == 0 {
		return 0
	}
	return t.Trigger
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_LastSwitchoverReason) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_LastSwitchoverReason"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_LastSwitchoverReason) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_LastSwitchoverReason) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_LastSwitchoverReason.
func (*Component_LastSwitchoverReason) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Memory represents the /openconfig-platform/components/component/state/memory YANG schema element.
type Component_Memory struct {
	ΛMetadata  []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Available  *uint64           `path:"available" module:"openconfig-platform"`
	ΛAvailable []ygot.Annotation `path:"@available" ygotAnnotation:"true"`
	Utilized   *uint64           `path:"utilized" module:"openconfig-platform"`
	ΛUtilized  []ygot.Annotation `path:"@utilized" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Memory implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Memory) IsYANGGoStruct() {}

// GetAvailable retrieves the value of the leaf Available from the Component_Memory
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Available is set, it can
// safely use t.GetAvailable() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Available == nil' before retrieving the leaf's value.
func (t *Component_Memory) GetAvailable() uint64 {
	if t == nil || t.Available == nil {
		return 0
	}
	return *t.Available
}

// GetUtilized retrieves the value of the leaf Utilized from the Component_Memory
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Utilized is set, it can
// safely use t.GetUtilized() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Utilized == nil' before retrieving the leaf's value.
func (t *Component_Memory) GetUtilized() uint64 {
	if t == nil || t.Utilized == nil {
		return 0
	}
	return *t.Utilized
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Memory) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Memory"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Memory) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Memory) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Memory.
func (*Component_Memory) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_OpticalChannel represents the /openconfig-platform/components/component/optical-channel YANG schema element.
type Component_OpticalChannel struct {
	ΛMetadata                              []ygot.Annotation                                               `path:"@" ygotAnnotation:"true"`
	CarrierFrequencyOffset                 *Component_OpticalChannel_CarrierFrequencyOffset                `path:"state/carrier-frequency-offset" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛCarrierFrequencyOffset                []ygot.Annotation                                               `path:"state/@carrier-frequency-offset" ygotAnnotation:"true"`
	ChromaticDispersion                    *Component_OpticalChannel_ChromaticDispersion                   `path:"state/chromatic-dispersion" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛChromaticDispersion                   []ygot.Annotation                                               `path:"state/@chromatic-dispersion" ygotAnnotation:"true"`
	Esnr                                   *Component_OpticalChannel_Esnr                                  `path:"state/esnr" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛEsnr                                  []ygot.Annotation                                               `path:"state/@esnr" ygotAnnotation:"true"`
	FecUncorrectableBlocks                 *uint64                                                         `path:"state/fec-uncorrectable-blocks" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛFecUncorrectableBlocks                []ygot.Annotation                                               `path:"state/@fec-uncorrectable-blocks" ygotAnnotation:"true"`
	Frequency                              *uint64                                                         `path:"config/frequency" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛFrequency                             []ygot.Annotation                                               `path:"config/@frequency" ygotAnnotation:"true"`
	GroupId                                *uint32                                                         `path:"state/group-id" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛGroupId                               []ygot.Annotation                                               `path:"state/@group-id" ygotAnnotation:"true"`
	InputPower                             *Component_OpticalChannel_InputPower                            `path:"state/input-power" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛInputPower                            []ygot.Annotation                                               `path:"state/@input-power" ygotAnnotation:"true"`
	LaserBiasCurrent                       *Component_OpticalChannel_LaserBiasCurrent                      `path:"state/laser-bias-current" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛLaserBiasCurrent                      []ygot.Annotation                                               `path:"state/@laser-bias-current" ygotAnnotation:"true"`
	LinePort                               *string                                                         `path:"config/line-port" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛLinePort                              []ygot.Annotation                                               `path:"config/@line-port" ygotAnnotation:"true"`
	ModulationErrorRatio                   *Component_OpticalChannel_ModulationErrorRatio                  `path:"state/modulation-error-ratio" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛModulationErrorRatio                  []ygot.Annotation                                               `path:"state/@modulation-error-ratio" ygotAnnotation:"true"`
	ModulatorBiasXPhase                    *Component_OpticalChannel_ModulatorBiasXPhase                   `path:"state/modulator-bias-x-phase" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛModulatorBiasXPhase                   []ygot.Annotation                                               `path:"state/@modulator-bias-x-phase" ygotAnnotation:"true"`
	ModulatorBiasXi                        *Component_OpticalChannel_ModulatorBiasXi                       `path:"state/modulator-bias-xi" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛModulatorBiasXi                       []ygot.Annotation                                               `path:"state/@modulator-bias-xi" ygotAnnotation:"true"`
	ModulatorBiasXq                        *Component_OpticalChannel_ModulatorBiasXq                       `path:"state/modulator-bias-xq" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛModulatorBiasXq                       []ygot.Annotation                                               `path:"state/@modulator-bias-xq" ygotAnnotation:"true"`
	ModulatorBiasYPhase                    *Component_OpticalChannel_ModulatorBiasYPhase                   `path:"state/modulator-bias-y-phase" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛModulatorBiasYPhase                   []ygot.Annotation                                               `path:"state/@modulator-bias-y-phase" ygotAnnotation:"true"`
	ModulatorBiasYi                        *Component_OpticalChannel_ModulatorBiasYi                       `path:"state/modulator-bias-yi" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛModulatorBiasYi                       []ygot.Annotation                                               `path:"state/@modulator-bias-yi" ygotAnnotation:"true"`
	ModulatorBiasYq                        *Component_OpticalChannel_ModulatorBiasYq                       `path:"state/modulator-bias-yq" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛModulatorBiasYq                       []ygot.Annotation                                               `path:"state/@modulator-bias-yq" ygotAnnotation:"true"`
	OperationalMode                        *uint16                                                         `path:"config/operational-mode" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛOperationalMode                       []ygot.Annotation                                               `path:"config/@operational-mode" ygotAnnotation:"true"`
	Osnr                                   *Component_OpticalChannel_Osnr                                  `path:"state/osnr" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛOsnr                                  []ygot.Annotation                                               `path:"state/@osnr" ygotAnnotation:"true"`
	OutputPower                            *Component_OpticalChannel_OutputPower                           `path:"state/output-power" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛOutputPower                           []ygot.Annotation                                               `path:"state/@output-power" ygotAnnotation:"true"`
	PolarizationDependentLoss              *Component_OpticalChannel_PolarizationDependentLoss             `path:"state/polarization-dependent-loss" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛPolarizationDependentLoss             []ygot.Annotation                                               `path:"state/@polarization-dependent-loss" ygotAnnotation:"true"`
	PolarizationModeDispersion             *Component_OpticalChannel_PolarizationModeDispersion            `path:"state/polarization-mode-dispersion" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛPolarizationModeDispersion            []ygot.Annotation                                               `path:"state/@polarization-mode-dispersion" ygotAnnotation:"true"`
	PostFecBer                             *Component_OpticalChannel_PostFecBer                            `path:"state/post-fec-ber" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛPostFecBer                            []ygot.Annotation                                               `path:"state/@post-fec-ber" ygotAnnotation:"true"`
	PreFecBer                              *Component_OpticalChannel_PreFecBer                             `path:"state/pre-fec-ber" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛPreFecBer                             []ygot.Annotation                                               `path:"state/@pre-fec-ber" ygotAnnotation:"true"`
	QValue                                 *Component_OpticalChannel_QValue                                `path:"state/q-value" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛQValue                                []ygot.Annotation                                               `path:"state/@q-value" ygotAnnotation:"true"`
	SecondOrderPolarizationModeDispersion  *Component_OpticalChannel_SecondOrderPolarizationModeDispersion `path:"state/second-order-polarization-mode-dispersion" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛSecondOrderPolarizationModeDispersion []ygot.Annotation                                               `path:"state/@second-order-polarization-mode-dispersion" ygotAnnotation:"true"`
	SopRoc                                 *Component_OpticalChannel_SopRoc                                `path:"state/sop-roc" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛSopRoc                                []ygot.Annotation                                               `path:"state/@sop-roc" ygotAnnotation:"true"`
	TargetOutputPower                      *float64                                                        `path:"config/target-output-power" module:"openconfig-terminal-device/openconfig-terminal-device"`
	ΛTargetOutputPower                     []ygot.Annotation                                               `path:"config/@target-output-power" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel) IsYANGGoStruct() {}

// GetOrCreateCarrierFrequencyOffset retrieves the value of the CarrierFrequencyOffset field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateCarrierFrequencyOffset() *Component_OpticalChannel_CarrierFrequencyOffset {
	if t.CarrierFrequencyOffset != nil {
		return t.CarrierFrequencyOffset
	}
	t.CarrierFrequencyOffset = &Component_OpticalChannel_CarrierFrequencyOffset{}
	return t.CarrierFrequencyOffset
}

// GetOrCreateChromaticDispersion retrieves the value of the ChromaticDispersion field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateChromaticDispersion() *Component_OpticalChannel_ChromaticDispersion {
	if t.ChromaticDispersion != nil {
		return t.ChromaticDispersion
	}
	t.ChromaticDispersion = &Component_OpticalChannel_ChromaticDispersion{}
	return t.ChromaticDispersion
}

// GetOrCreateEsnr retrieves the value of the Esnr field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateEsnr() *Component_OpticalChannel_Esnr {
	if t.Esnr != nil {
		return t.Esnr
	}
	t.Esnr = &Component_OpticalChannel_Esnr{}
	return t.Esnr
}

// GetOrCreateInputPower retrieves the value of the InputPower field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateInputPower() *Component_OpticalChannel_InputPower {
	if t.InputPower != nil {
		return t.InputPower
	}
	t.InputPower = &Component_OpticalChannel_InputPower{}
	return t.InputPower
}

// GetOrCreateLaserBiasCurrent retrieves the value of the LaserBiasCurrent field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateLaserBiasCurrent() *Component_OpticalChannel_LaserBiasCurrent {
	if t.LaserBiasCurrent != nil {
		return t.LaserBiasCurrent
	}
	t.LaserBiasCurrent = &Component_OpticalChannel_LaserBiasCurrent{}
	return t.LaserBiasCurrent
}

// GetOrCreateModulationErrorRatio retrieves the value of the ModulationErrorRatio field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateModulationErrorRatio() *Component_OpticalChannel_ModulationErrorRatio {
	if t.ModulationErrorRatio != nil {
		return t.ModulationErrorRatio
	}
	t.ModulationErrorRatio = &Component_OpticalChannel_ModulationErrorRatio{}
	return t.ModulationErrorRatio
}

// GetOrCreateModulatorBiasXPhase retrieves the value of the ModulatorBiasXPhase field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateModulatorBiasXPhase() *Component_OpticalChannel_ModulatorBiasXPhase {
	if t.ModulatorBiasXPhase != nil {
		return t.ModulatorBiasXPhase
	}
	t.ModulatorBiasXPhase = &Component_OpticalChannel_ModulatorBiasXPhase{}
	return t.ModulatorBiasXPhase
}

// GetOrCreateModulatorBiasXi retrieves the value of the ModulatorBiasXi field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateModulatorBiasXi() *Component_OpticalChannel_ModulatorBiasXi {
	if t.ModulatorBiasXi != nil {
		return t.ModulatorBiasXi
	}
	t.ModulatorBiasXi = &Component_OpticalChannel_ModulatorBiasXi{}
	return t.ModulatorBiasXi
}

// GetOrCreateModulatorBiasXq retrieves the value of the ModulatorBiasXq field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateModulatorBiasXq() *Component_OpticalChannel_ModulatorBiasXq {
	if t.ModulatorBiasXq != nil {
		return t.ModulatorBiasXq
	}
	t.ModulatorBiasXq = &Component_OpticalChannel_ModulatorBiasXq{}
	return t.ModulatorBiasXq
}

// GetOrCreateModulatorBiasYPhase retrieves the value of the ModulatorBiasYPhase field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateModulatorBiasYPhase() *Component_OpticalChannel_ModulatorBiasYPhase {
	if t.ModulatorBiasYPhase != nil {
		return t.ModulatorBiasYPhase
	}
	t.ModulatorBiasYPhase = &Component_OpticalChannel_ModulatorBiasYPhase{}
	return t.ModulatorBiasYPhase
}

// GetOrCreateModulatorBiasYi retrieves the value of the ModulatorBiasYi field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateModulatorBiasYi() *Component_OpticalChannel_ModulatorBiasYi {
	if t.ModulatorBiasYi != nil {
		return t.ModulatorBiasYi
	}
	t.ModulatorBiasYi = &Component_OpticalChannel_ModulatorBiasYi{}
	return t.ModulatorBiasYi
}

// GetOrCreateModulatorBiasYq retrieves the value of the ModulatorBiasYq field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateModulatorBiasYq() *Component_OpticalChannel_ModulatorBiasYq {
	if t.ModulatorBiasYq != nil {
		return t.ModulatorBiasYq
	}
	t.ModulatorBiasYq = &Component_OpticalChannel_ModulatorBiasYq{}
	return t.ModulatorBiasYq
}

// GetOrCreateOsnr retrieves the value of the Osnr field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateOsnr() *Component_OpticalChannel_Osnr {
	if t.Osnr != nil {
		return t.Osnr
	}
	t.Osnr = &Component_OpticalChannel_Osnr{}
	return t.Osnr
}

// GetOrCreateOutputPower retrieves the value of the OutputPower field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateOutputPower() *Component_OpticalChannel_OutputPower {
	if t.OutputPower != nil {
		return t.OutputPower
	}
	t.OutputPower = &Component_OpticalChannel_OutputPower{}
	return t.OutputPower
}

// GetOrCreatePolarizationDependentLoss retrieves the value of the PolarizationDependentLoss field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreatePolarizationDependentLoss() *Component_OpticalChannel_PolarizationDependentLoss {
	if t.PolarizationDependentLoss != nil {
		return t.PolarizationDependentLoss
	}
	t.PolarizationDependentLoss = &Component_OpticalChannel_PolarizationDependentLoss{}
	return t.PolarizationDependentLoss
}

// GetOrCreatePolarizationModeDispersion retrieves the value of the PolarizationModeDispersion field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreatePolarizationModeDispersion() *Component_OpticalChannel_PolarizationModeDispersion {
	if t.PolarizationModeDispersion != nil {
		return t.PolarizationModeDispersion
	}
	t.PolarizationModeDispersion = &Component_OpticalChannel_PolarizationModeDispersion{}
	return t.PolarizationModeDispersion
}

// GetOrCreatePostFecBer retrieves the value of the PostFecBer field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreatePostFecBer() *Component_OpticalChannel_PostFecBer {
	if t.PostFecBer != nil {
		return t.PostFecBer
	}
	t.PostFecBer = &Component_OpticalChannel_PostFecBer{}
	return t.PostFecBer
}

// GetOrCreatePreFecBer retrieves the value of the PreFecBer field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreatePreFecBer() *Component_OpticalChannel_PreFecBer {
	if t.PreFecBer != nil {
		return t.PreFecBer
	}
	t.PreFecBer = &Component_OpticalChannel_PreFecBer{}
	return t.PreFecBer
}

// GetOrCreateQValue retrieves the value of the QValue field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateQValue() *Component_OpticalChannel_QValue {
	if t.QValue != nil {
		return t.QValue
	}
	t.QValue = &Component_OpticalChannel_QValue{}
	return t.QValue
}

// GetOrCreateSecondOrderPolarizationModeDispersion retrieves the value of the SecondOrderPolarizationModeDispersion field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateSecondOrderPolarizationModeDispersion() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion {
	if t.SecondOrderPolarizationModeDispersion != nil {
		return t.SecondOrderPolarizationModeDispersion
	}
	t.SecondOrderPolarizationModeDispersion = &Component_OpticalChannel_SecondOrderPolarizationModeDispersion{}
	return t.SecondOrderPolarizationModeDispersion
}

// GetOrCreateSopRoc retrieves the value of the SopRoc field
// or returns the existing field if it already exists.
func (t *Component_OpticalChannel) GetOrCreateSopRoc() *Component_OpticalChannel_SopRoc {
	if t.SopRoc != nil {
		return t.SopRoc
	}
	t.SopRoc = &Component_OpticalChannel_SopRoc{}
	return t.SopRoc
}

// GetCarrierFrequencyOffset returns the value of the CarrierFrequencyOffset struct pointer
// from Component_OpticalChannel. If the receiver or the field CarrierFrequencyOffset is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetCarrierFrequencyOffset() *Component_OpticalChannel_CarrierFrequencyOffset {
	if t != nil && t.CarrierFrequencyOffset != nil {
		return t.CarrierFrequencyOffset
	}
	return nil
}

// GetChromaticDispersion returns the value of the ChromaticDispersion struct pointer
// from Component_OpticalChannel. If the receiver or the field ChromaticDispersion is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetChromaticDispersion() *Component_OpticalChannel_ChromaticDispersion {
	if t != nil && t.ChromaticDispersion != nil {
		return t.ChromaticDispersion
	}
	return nil
}

// GetEsnr returns the value of the Esnr struct pointer
// from Component_OpticalChannel. If the receiver or the field Esnr is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetEsnr() *Component_OpticalChannel_Esnr {
	if t != nil && t.Esnr != nil {
		return t.Esnr
	}
	return nil
}

// GetInputPower returns the value of the InputPower struct pointer
// from Component_OpticalChannel. If the receiver or the field InputPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetInputPower() *Component_OpticalChannel_InputPower {
	if t != nil && t.InputPower != nil {
		return t.InputPower
	}
	return nil
}

// GetLaserBiasCurrent returns the value of the LaserBiasCurrent struct pointer
// from Component_OpticalChannel. If the receiver or the field LaserBiasCurrent is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetLaserBiasCurrent() *Component_OpticalChannel_LaserBiasCurrent {
	if t != nil && t.LaserBiasCurrent != nil {
		return t.LaserBiasCurrent
	}
	return nil
}

// GetModulationErrorRatio returns the value of the ModulationErrorRatio struct pointer
// from Component_OpticalChannel. If the receiver or the field ModulationErrorRatio is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetModulationErrorRatio() *Component_OpticalChannel_ModulationErrorRatio {
	if t != nil && t.ModulationErrorRatio != nil {
		return t.ModulationErrorRatio
	}
	return nil
}

// GetModulatorBiasXPhase returns the value of the ModulatorBiasXPhase struct pointer
// from Component_OpticalChannel. If the receiver or the field ModulatorBiasXPhase is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetModulatorBiasXPhase() *Component_OpticalChannel_ModulatorBiasXPhase {
	if t != nil && t.ModulatorBiasXPhase != nil {
		return t.ModulatorBiasXPhase
	}
	return nil
}

// GetModulatorBiasXi returns the value of the ModulatorBiasXi struct pointer
// from Component_OpticalChannel. If the receiver or the field ModulatorBiasXi is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetModulatorBiasXi() *Component_OpticalChannel_ModulatorBiasXi {
	if t != nil && t.ModulatorBiasXi != nil {
		return t.ModulatorBiasXi
	}
	return nil
}

// GetModulatorBiasXq returns the value of the ModulatorBiasXq struct pointer
// from Component_OpticalChannel. If the receiver or the field ModulatorBiasXq is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetModulatorBiasXq() *Component_OpticalChannel_ModulatorBiasXq {
	if t != nil && t.ModulatorBiasXq != nil {
		return t.ModulatorBiasXq
	}
	return nil
}

// GetModulatorBiasYPhase returns the value of the ModulatorBiasYPhase struct pointer
// from Component_OpticalChannel. If the receiver or the field ModulatorBiasYPhase is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetModulatorBiasYPhase() *Component_OpticalChannel_ModulatorBiasYPhase {
	if t != nil && t.ModulatorBiasYPhase != nil {
		return t.ModulatorBiasYPhase
	}
	return nil
}

// GetModulatorBiasYi returns the value of the ModulatorBiasYi struct pointer
// from Component_OpticalChannel. If the receiver or the field ModulatorBiasYi is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetModulatorBiasYi() *Component_OpticalChannel_ModulatorBiasYi {
	if t != nil && t.ModulatorBiasYi != nil {
		return t.ModulatorBiasYi
	}
	return nil
}

// GetModulatorBiasYq returns the value of the ModulatorBiasYq struct pointer
// from Component_OpticalChannel. If the receiver or the field ModulatorBiasYq is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetModulatorBiasYq() *Component_OpticalChannel_ModulatorBiasYq {
	if t != nil && t.ModulatorBiasYq != nil {
		return t.ModulatorBiasYq
	}
	return nil
}

// GetOsnr returns the value of the Osnr struct pointer
// from Component_OpticalChannel. If the receiver or the field Osnr is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetOsnr() *Component_OpticalChannel_Osnr {
	if t != nil && t.Osnr != nil {
		return t.Osnr
	}
	return nil
}

// GetOutputPower returns the value of the OutputPower struct pointer
// from Component_OpticalChannel. If the receiver or the field OutputPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetOutputPower() *Component_OpticalChannel_OutputPower {
	if t != nil && t.OutputPower != nil {
		return t.OutputPower
	}
	return nil
}

// GetPolarizationDependentLoss returns the value of the PolarizationDependentLoss struct pointer
// from Component_OpticalChannel. If the receiver or the field PolarizationDependentLoss is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetPolarizationDependentLoss() *Component_OpticalChannel_PolarizationDependentLoss {
	if t != nil && t.PolarizationDependentLoss != nil {
		return t.PolarizationDependentLoss
	}
	return nil
}

// GetPolarizationModeDispersion returns the value of the PolarizationModeDispersion struct pointer
// from Component_OpticalChannel. If the receiver or the field PolarizationModeDispersion is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetPolarizationModeDispersion() *Component_OpticalChannel_PolarizationModeDispersion {
	if t != nil && t.PolarizationModeDispersion != nil {
		return t.PolarizationModeDispersion
	}
	return nil
}

// GetPostFecBer returns the value of the PostFecBer struct pointer
// from Component_OpticalChannel. If the receiver or the field PostFecBer is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetPostFecBer() *Component_OpticalChannel_PostFecBer {
	if t != nil && t.PostFecBer != nil {
		return t.PostFecBer
	}
	return nil
}

// GetPreFecBer returns the value of the PreFecBer struct pointer
// from Component_OpticalChannel. If the receiver or the field PreFecBer is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetPreFecBer() *Component_OpticalChannel_PreFecBer {
	if t != nil && t.PreFecBer != nil {
		return t.PreFecBer
	}
	return nil
}

// GetQValue returns the value of the QValue struct pointer
// from Component_OpticalChannel. If the receiver or the field QValue is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetQValue() *Component_OpticalChannel_QValue {
	if t != nil && t.QValue != nil {
		return t.QValue
	}
	return nil
}

// GetSecondOrderPolarizationModeDispersion returns the value of the SecondOrderPolarizationModeDispersion struct pointer
// from Component_OpticalChannel. If the receiver or the field SecondOrderPolarizationModeDispersion is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetSecondOrderPolarizationModeDispersion() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion {
	if t != nil && t.SecondOrderPolarizationModeDispersion != nil {
		return t.SecondOrderPolarizationModeDispersion
	}
	return nil
}

// GetSopRoc returns the value of the SopRoc struct pointer
// from Component_OpticalChannel. If the receiver or the field SopRoc is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_OpticalChannel) GetSopRoc() *Component_OpticalChannel_SopRoc {
	if t != nil && t.SopRoc != nil {
		return t.SopRoc
	}
	return nil
}

// GetFecUncorrectableBlocks retrieves the value of the leaf FecUncorrectableBlocks from the Component_OpticalChannel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FecUncorrectableBlocks is set, it can
// safely use t.GetFecUncorrectableBlocks() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FecUncorrectableBlocks == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel) GetFecUncorrectableBlocks() uint64 {
	if t == nil || t.FecUncorrectableBlocks == nil {
		return 0
	}
	return *t.FecUncorrectableBlocks
}

// GetFrequency retrieves the value of the leaf Frequency from the Component_OpticalChannel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Frequency is set, it can
// safely use t.GetFrequency() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Frequency == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel) GetFrequency() uint64 {
	if t == nil || t.Frequency == nil {
		return 0
	}
	return *t.Frequency
}

// GetGroupId retrieves the value of the leaf GroupId from the Component_OpticalChannel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if GroupId is set, it can
// safely use t.GetGroupId() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.GroupId == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel) GetGroupId() uint32 {
	if t == nil || t.GroupId == nil {
		return 0
	}
	return *t.GroupId
}

// GetLinePort retrieves the value of the leaf LinePort from the Component_OpticalChannel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LinePort is set, it can
// safely use t.GetLinePort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LinePort == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel) GetLinePort() string {
	if t == nil || t.LinePort == nil {
		return ""
	}
	return *t.LinePort
}

// GetOperationalMode retrieves the value of the leaf OperationalMode from the Component_OpticalChannel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OperationalMode is set, it can
// safely use t.GetOperationalMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OperationalMode == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel) GetOperationalMode() uint16 {
	if t == nil || t.OperationalMode == nil {
		return 0
	}
	return *t.OperationalMode
}

// GetTargetOutputPower retrieves the value of the leaf TargetOutputPower from the Component_OpticalChannel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TargetOutputPower is set, it can
// safely use t.GetTargetOutputPower() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TargetOutputPower == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel) GetTargetOutputPower() float64 {
	if t == nil || t.TargetOutputPower == nil {
		return 0.0
	}
	return *t.TargetOutputPower
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel.
func (*Component_OpticalChannel) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_CarrierFrequencyOffset represents the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_CarrierFrequencyOffset implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_CarrierFrequencyOffset) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_CarrierFrequencyOffset
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_CarrierFrequencyOffset) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_CarrierFrequencyOffset
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_CarrierFrequencyOffset) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_CarrierFrequencyOffset
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_CarrierFrequencyOffset) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_CarrierFrequencyOffset
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_CarrierFrequencyOffset) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_CarrierFrequencyOffset
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_CarrierFrequencyOffset) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_CarrierFrequencyOffset
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_CarrierFrequencyOffset) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_CarrierFrequencyOffset
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_CarrierFrequencyOffset) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_CarrierFrequencyOffset) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_CarrierFrequencyOffset"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_CarrierFrequencyOffset) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_CarrierFrequencyOffset) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_CarrierFrequencyOffset.
func (*Component_OpticalChannel_CarrierFrequencyOffset) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_ChromaticDispersion represents the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion YANG schema element.
type Component_OpticalChannel_ChromaticDispersion struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_ChromaticDispersion implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_ChromaticDispersion) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_ChromaticDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ChromaticDispersion) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_ChromaticDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ChromaticDispersion) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_ChromaticDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ChromaticDispersion) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_ChromaticDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ChromaticDispersion) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_ChromaticDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ChromaticDispersion) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_ChromaticDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ChromaticDispersion) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_ChromaticDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ChromaticDispersion) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ChromaticDispersion) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_ChromaticDispersion"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ChromaticDispersion) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_ChromaticDispersion) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_ChromaticDispersion.
func (*Component_OpticalChannel_ChromaticDispersion) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_Esnr represents the /openconfig-platform/components/component/optical-channel/state/esnr YANG schema element.
type Component_OpticalChannel_Esnr struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_Esnr implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_Esnr) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_Esnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Esnr) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_Esnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Esnr) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_Esnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Esnr) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_Esnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Esnr) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_Esnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Esnr) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_Esnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Esnr) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_Esnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Esnr) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_Esnr) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_Esnr"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_Esnr) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_Esnr) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_Esnr.
func (*Component_OpticalChannel_Esnr) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_InputPower represents the /openconfig-platform/components/component/optical-channel/state/input-power YANG schema element.
type Component_OpticalChannel_InputPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_InputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_InputPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_InputPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_InputPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_InputPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_InputPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_InputPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_InputPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_InputPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_InputPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_InputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_InputPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_InputPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_InputPower.
func (*Component_OpticalChannel_InputPower) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_LaserBiasCurrent represents the /openconfig-platform/components/component/optical-channel/state/laser-bias-current YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_LaserBiasCurrent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_LaserBiasCurrent) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_LaserBiasCurrent) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_LaserBiasCurrent) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_LaserBiasCurrent) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_LaserBiasCurrent) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_LaserBiasCurrent) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_LaserBiasCurrent) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_LaserBiasCurrent) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_LaserBiasCurrent) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_LaserBiasCurrent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_LaserBiasCurrent) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_LaserBiasCurrent) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_LaserBiasCurrent.
func (*Component_OpticalChannel_LaserBiasCurrent) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_ModulationErrorRatio represents the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_ModulationErrorRatio implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_ModulationErrorRatio) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_ModulationErrorRatio
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulationErrorRatio) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_ModulationErrorRatio
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulationErrorRatio) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_ModulationErrorRatio
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulationErrorRatio) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_ModulationErrorRatio
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulationErrorRatio) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_ModulationErrorRatio
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulationErrorRatio) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_ModulationErrorRatio
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulationErrorRatio) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_ModulationErrorRatio
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulationErrorRatio) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulationErrorRatio) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_ModulationErrorRatio"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulationErrorRatio) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_ModulationErrorRatio) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_ModulationErrorRatio.
func (*Component_OpticalChannel_ModulationErrorRatio) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_ModulatorBiasXPhase represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_ModulatorBiasXPhase implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_ModulatorBiasXPhase) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_ModulatorBiasXPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXPhase) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_ModulatorBiasXPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXPhase) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_ModulatorBiasXPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXPhase) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_ModulatorBiasXPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXPhase) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_ModulatorBiasXPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXPhase) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_ModulatorBiasXPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXPhase) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_ModulatorBiasXPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXPhase) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasXPhase) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_ModulatorBiasXPhase"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasXPhase) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_ModulatorBiasXPhase) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_ModulatorBiasXPhase.
func (*Component_OpticalChannel_ModulatorBiasXPhase) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_ModulatorBiasXi represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_ModulatorBiasXi implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_ModulatorBiasXi) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_ModulatorBiasXi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXi) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_ModulatorBiasXi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXi) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_ModulatorBiasXi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXi) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_ModulatorBiasXi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXi) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_ModulatorBiasXi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXi) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_ModulatorBiasXi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXi) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_ModulatorBiasXi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXi) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasXi) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_ModulatorBiasXi"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasXi) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_ModulatorBiasXi) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_ModulatorBiasXi.
func (*Component_OpticalChannel_ModulatorBiasXi) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_ModulatorBiasXq represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_ModulatorBiasXq implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_ModulatorBiasXq) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_ModulatorBiasXq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXq) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_ModulatorBiasXq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXq) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_ModulatorBiasXq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXq) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_ModulatorBiasXq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXq) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_ModulatorBiasXq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXq) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_ModulatorBiasXq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXq) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_ModulatorBiasXq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasXq) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasXq) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_ModulatorBiasXq"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasXq) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_ModulatorBiasXq) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_ModulatorBiasXq.
func (*Component_OpticalChannel_ModulatorBiasXq) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_ModulatorBiasYPhase represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_ModulatorBiasYPhase implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_ModulatorBiasYPhase) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_ModulatorBiasYPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYPhase) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_ModulatorBiasYPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYPhase) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_ModulatorBiasYPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYPhase) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_ModulatorBiasYPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYPhase) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_ModulatorBiasYPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYPhase) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_ModulatorBiasYPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYPhase) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_ModulatorBiasYPhase
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYPhase) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasYPhase) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_ModulatorBiasYPhase"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasYPhase) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_ModulatorBiasYPhase) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_ModulatorBiasYPhase.
func (*Component_OpticalChannel_ModulatorBiasYPhase) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_ModulatorBiasYi represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_ModulatorBiasYi implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_ModulatorBiasYi) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_ModulatorBiasYi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYi) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_ModulatorBiasYi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYi) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_ModulatorBiasYi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYi) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_ModulatorBiasYi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYi) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_ModulatorBiasYi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYi) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_ModulatorBiasYi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYi) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_ModulatorBiasYi
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYi) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasYi) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_ModulatorBiasYi"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasYi) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_ModulatorBiasYi) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_ModulatorBiasYi.
func (*Component_OpticalChannel_ModulatorBiasYi) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_ModulatorBiasYq represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_ModulatorBiasYq implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_ModulatorBiasYq) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_ModulatorBiasYq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYq) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_ModulatorBiasYq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYq) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_ModulatorBiasYq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYq) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_ModulatorBiasYq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYq) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_ModulatorBiasYq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYq) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_ModulatorBiasYq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYq) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_ModulatorBiasYq
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_ModulatorBiasYq) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasYq) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_ModulatorBiasYq"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_ModulatorBiasYq) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_ModulatorBiasYq) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_ModulatorBiasYq.
func (*Component_OpticalChannel_ModulatorBiasYq) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_Osnr represents the /openconfig-platform/components/component/optical-channel/state/osnr YANG schema element.
type Component_OpticalChannel_Osnr struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_Osnr implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_Osnr) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_Osnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Osnr) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_Osnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Osnr) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_Osnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Osnr) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_Osnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Osnr) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_Osnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Osnr) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_Osnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Osnr) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_Osnr
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_Osnr) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_Osnr) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_Osnr"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_Osnr) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_Osnr) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_Osnr.
func (*Component_OpticalChannel_Osnr) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_OutputPower represents the /openconfig-platform/components/component/optical-channel/state/output-power YANG schema element.
type Component_OpticalChannel_OutputPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_OutputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_OutputPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_OutputPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_OutputPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_OutputPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_OutputPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_OutputPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_OutputPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_OutputPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_OutputPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_OutputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_OutputPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_OutputPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_OutputPower.
func (*Component_OpticalChannel_OutputPower) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_PolarizationDependentLoss represents the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_PolarizationDependentLoss implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_PolarizationDependentLoss) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_PolarizationDependentLoss
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationDependentLoss) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_PolarizationDependentLoss
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationDependentLoss) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_PolarizationDependentLoss
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationDependentLoss) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_PolarizationDependentLoss
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationDependentLoss) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_PolarizationDependentLoss
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationDependentLoss) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_PolarizationDependentLoss
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationDependentLoss) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_PolarizationDependentLoss
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationDependentLoss) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_PolarizationDependentLoss) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_PolarizationDependentLoss"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_PolarizationDependentLoss) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_PolarizationDependentLoss) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_PolarizationDependentLoss.
func (*Component_OpticalChannel_PolarizationDependentLoss) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_PolarizationModeDispersion represents the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_PolarizationModeDispersion implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_PolarizationModeDispersion) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_PolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationModeDispersion) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_PolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationModeDispersion) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_PolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationModeDispersion) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_PolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationModeDispersion) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_PolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationModeDispersion) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_PolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationModeDispersion) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_PolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PolarizationModeDispersion) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_PolarizationModeDispersion) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_PolarizationModeDispersion"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_PolarizationModeDispersion) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_PolarizationModeDispersion) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_PolarizationModeDispersion.
func (*Component_OpticalChannel_PolarizationModeDispersion) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_PostFecBer represents the /openconfig-platform/components/component/optical-channel/state/post-fec-ber YANG schema element.
type Component_OpticalChannel_PostFecBer struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_PostFecBer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_PostFecBer) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PostFecBer) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PostFecBer) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PostFecBer) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PostFecBer) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PostFecBer) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PostFecBer) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PostFecBer) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_PostFecBer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_PostFecBer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_PostFecBer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_PostFecBer) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_PostFecBer.
func (*Component_OpticalChannel_PostFecBer) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_PreFecBer represents the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber YANG schema element.
type Component_OpticalChannel_PreFecBer struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_PreFecBer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_PreFecBer) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PreFecBer) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PreFecBer) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PreFecBer) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PreFecBer) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PreFecBer) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PreFecBer) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_PreFecBer) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_PreFecBer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_PreFecBer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_PreFecBer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_PreFecBer) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_PreFecBer.
func (*Component_OpticalChannel_PreFecBer) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_QValue represents the /openconfig-platform/components/component/optical-channel/state/q-value YANG schema element.
type Component_OpticalChannel_QValue struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_QValue implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_QValue) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_QValue
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_QValue) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_QValue
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_QValue) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_QValue
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_QValue) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_QValue
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_QValue) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_QValue
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_QValue) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_QValue
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_QValue) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_QValue
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_QValue) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_QValue) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_QValue"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_QValue) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_QValue) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_QValue.
func (*Component_OpticalChannel_QValue) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion represents the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_SecondOrderPolarizationModeDispersion implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_SecondOrderPolarizationModeDispersion) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_SecondOrderPolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SecondOrderPolarizationModeDispersion) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_SecondOrderPolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SecondOrderPolarizationModeDispersion) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_SecondOrderPolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SecondOrderPolarizationModeDispersion) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_SecondOrderPolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SecondOrderPolarizationModeDispersion) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_SecondOrderPolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SecondOrderPolarizationModeDispersion) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_SecondOrderPolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SecondOrderPolarizationModeDispersion) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_SecondOrderPolarizationModeDispersion
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SecondOrderPolarizationModeDispersion) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_SecondOrderPolarizationModeDispersion) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_SecondOrderPolarizationModeDispersion"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_SecondOrderPolarizationModeDispersion) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_SecondOrderPolarizationModeDispersion) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_SecondOrderPolarizationModeDispersion.
func (*Component_OpticalChannel_SecondOrderPolarizationModeDispersion) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_OpticalChannel_SopRoc represents the /openconfig-platform/components/component/optical-channel/state/sop-roc YANG schema element.
type Component_OpticalChannel_SopRoc struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-terminal-device"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-terminal-device"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-terminal-device"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-terminal-device"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-terminal-device"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-terminal-device"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-terminal-device"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_OpticalChannel_SopRoc implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_OpticalChannel_SopRoc) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_OpticalChannel_SopRoc
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SopRoc) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_OpticalChannel_SopRoc
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SopRoc) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_OpticalChannel_SopRoc
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SopRoc) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_OpticalChannel_SopRoc
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SopRoc) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_OpticalChannel_SopRoc
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SopRoc) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_OpticalChannel_SopRoc
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SopRoc) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_OpticalChannel_SopRoc
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_OpticalChannel_SopRoc) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_SopRoc) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_OpticalChannel_SopRoc"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_OpticalChannel_SopRoc) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_OpticalChannel_SopRoc) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_OpticalChannel_SopRoc.
func (*Component_OpticalChannel_SopRoc) ΛBelongingModule() string {
	return "openconfig-terminal-device"
}

// Component_Pcie represents the /openconfig-platform/components/component/state/pcie YANG schema element.
type Component_Pcie struct {
	ΛMetadata          []ygot.Annotation                 `path:"@" ygotAnnotation:"true"`
	CorrectableErrors  *Component_Pcie_CorrectableErrors `path:"correctable-errors" module:"openconfig-platform"`
	ΛCorrectableErrors []ygot.Annotation                 `path:"@correctable-errors" ygotAnnotation:"true"`
	FatalErrors        *Component_Pcie_FatalErrors       `path:"fatal-errors" module:"openconfig-platform"`
	ΛFatalErrors       []ygot.Annotation                 `path:"@fatal-errors" ygotAnnotation:"true"`
	NonFatalErrors     *Component_Pcie_NonFatalErrors    `path:"non-fatal-errors" module:"openconfig-platform"`
	ΛNonFatalErrors    []ygot.Annotation                 `path:"@non-fatal-errors" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Pcie implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Pcie) IsYANGGoStruct() {}

// GetOrCreateCorrectableErrors retrieves the value of the CorrectableErrors field
// or returns the existing field if it already exists.
func (t *Component_Pcie) GetOrCreateCorrectableErrors() *Component_Pcie_CorrectableErrors {
	if t.CorrectableErrors != nil {
		return t.CorrectableErrors
	}
	t.CorrectableErrors = &Component_Pcie_CorrectableErrors{}
	return t.CorrectableErrors
}

// GetOrCreateFatalErrors retrieves the value of the FatalErrors field
// or returns the existing field if it already exists.
func (t *Component_Pcie) GetOrCreateFatalErrors() *Component_Pcie_FatalErrors {
	if t.FatalErrors != nil {
		return t.FatalErrors
	}
	t.FatalErrors = &Component_Pcie_FatalErrors{}
	return t.FatalErrors
}

// GetOrCreateNonFatalErrors retrieves the value of the NonFatalErrors field
// or returns the existing field if it already exists.
func (t *Component_Pcie) GetOrCreateNonFatalErrors() *Component_Pcie_NonFatalErrors {
	if t.NonFatalErrors != nil {
		return t.NonFatalErrors
	}
	t.NonFatalErrors = &Component_Pcie_NonFatalErrors{}
	return t.NonFatalErrors
}

// GetCorrectableErrors returns the value of the CorrectableErrors struct pointer
// from Component_Pcie. If the receiver or the field CorrectableErrors is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Pcie) GetCorrectableErrors() *Component_Pcie_CorrectableErrors {
	if t != nil && t.CorrectableErrors != nil {
		return t.CorrectableErrors
	}
	return nil
}

// GetFatalErrors returns the value of the FatalErrors struct pointer
// from Component_Pcie. If the receiver or the field FatalErrors is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Pcie) GetFatalErrors() *Component_Pcie_FatalErrors {
	if t != nil && t.FatalErrors != nil {
		return t.FatalErrors
	}
	return nil
}

// GetNonFatalErrors returns the value of the NonFatalErrors struct pointer
// from Component_Pcie. If the receiver or the field NonFatalErrors is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Pcie) GetNonFatalErrors() *Component_Pcie_NonFatalErrors {
	if t != nil && t.NonFatalErrors != nil {
		return t.NonFatalErrors
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Pcie) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Pcie"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Pcie) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Pcie) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Pcie.
func (*Component_Pcie) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Pcie_CorrectableErrors represents the /openconfig-platform/components/component/state/pcie/correctable-errors YANG schema element.
type Component_Pcie_CorrectableErrors struct {
	ΛMetadata               []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	AdvisoryNonFatalErrors  *uint64           `path:"advisory-non-fatal-errors" module:"openconfig-platform"`
	ΛAdvisoryNonFatalErrors []ygot.Annotation `path:"@advisory-non-fatal-errors" ygotAnnotation:"true"`
	BadDllpErrors           *uint64           `path:"bad-dllp-errors" module:"openconfig-platform"`
	ΛBadDllpErrors          []ygot.Annotation `path:"@bad-dllp-errors" ygotAnnotation:"true"`
	BadTlpErrors            *uint64           `path:"bad-tlp-errors" module:"openconfig-platform"`
	ΛBadTlpErrors           []ygot.Annotation `path:"@bad-tlp-errors" ygotAnnotation:"true"`
	HdrLogOverflowErrors    *uint64           `path:"hdr-log-overflow-errors" module:"openconfig-platform"`
	ΛHdrLogOverflowErrors   []ygot.Annotation `path:"@hdr-log-overflow-errors" ygotAnnotation:"true"`
	InternalErrors          *uint64           `path:"internal-errors" module:"openconfig-platform"`
	ΛInternalErrors         []ygot.Annotation `path:"@internal-errors" ygotAnnotation:"true"`
	ReceiverErrors          *uint64           `path:"receiver-errors" module:"openconfig-platform"`
	ΛReceiverErrors         []ygot.Annotation `path:"@receiver-errors" ygotAnnotation:"true"`
	RelayRolloverErrors     *uint64           `path:"relay-rollover-errors" module:"openconfig-platform"`
	ΛRelayRolloverErrors    []ygot.Annotation `path:"@relay-rollover-errors" ygotAnnotation:"true"`
	ReplayTimeoutErrors     *uint64           `path:"replay-timeout-errors" module:"openconfig-platform"`
	ΛReplayTimeoutErrors    []ygot.Annotation `path:"@replay-timeout-errors" ygotAnnotation:"true"`
	TotalErrors             *uint64           `path:"total-errors" module:"openconfig-platform"`
	ΛTotalErrors            []ygot.Annotation `path:"@total-errors" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Pcie_CorrectableErrors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Pcie_CorrectableErrors) IsYANGGoStruct() {}

// GetAdvisoryNonFatalErrors retrieves the value of the leaf AdvisoryNonFatalErrors from the Component_Pcie_CorrectableErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AdvisoryNonFatalErrors is set, it can
// safely use t.GetAdvisoryNonFatalErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AdvisoryNonFatalErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_CorrectableErrors) GetAdvisoryNonFatalErrors() uint64 {
	if t == nil || t.AdvisoryNonFatalErrors == nil {
		return 0
	}
	return *t.AdvisoryNonFatalErrors
}

// GetBadDllpErrors retrieves the value of the leaf BadDllpErrors from the Component_Pcie_CorrectableErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if BadDllpErrors is set, it can
// safely use t.GetBadDllpErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.BadDllpErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_CorrectableErrors) GetBadDllpErrors() uint64 {
	if t == nil || t.BadDllpErrors == nil {
		return 0
	}
	return *t.BadDllpErrors
}

// GetBadTlpErrors retrieves the value of the leaf BadTlpErrors from the Component_Pcie_CorrectableErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if BadTlpErrors is set, it can
// safely use t.GetBadTlpErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.BadTlpErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_CorrectableErrors) GetBadTlpErrors() uint64 {
	if t == nil || t.BadTlpErrors == nil {
		return 0
	}
	return *t.BadTlpErrors
}

// GetHdrLogOverflowErrors retrieves the value of the leaf HdrLogOverflowErrors from the Component_Pcie_CorrectableErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HdrLogOverflowErrors is set, it can
// safely use t.GetHdrLogOverflowErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HdrLogOverflowErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_CorrectableErrors) GetHdrLogOverflowErrors() uint64 {
	if t == nil || t.HdrLogOverflowErrors == nil {
		return 0
	}
	return *t.HdrLogOverflowErrors
}

// GetInternalErrors retrieves the value of the leaf InternalErrors from the Component_Pcie_CorrectableErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InternalErrors is set, it can
// safely use t.GetInternalErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InternalErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_CorrectableErrors) GetInternalErrors() uint64 {
	if t == nil || t.InternalErrors == nil {
		return 0
	}
	return *t.InternalErrors
}

// GetReceiverErrors retrieves the value of the leaf ReceiverErrors from the Component_Pcie_CorrectableErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReceiverErrors is set, it can
// safely use t.GetReceiverErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReceiverErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_CorrectableErrors) GetReceiverErrors() uint64 {
	if t == nil || t.ReceiverErrors == nil {
		return 0
	}
	return *t.ReceiverErrors
}

// GetRelayRolloverErrors retrieves the value of the leaf RelayRolloverErrors from the Component_Pcie_CorrectableErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RelayRolloverErrors is set, it can
// safely use t.GetRelayRolloverErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RelayRolloverErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_CorrectableErrors) GetRelayRolloverErrors() uint64 {
	if t == nil || t.RelayRolloverErrors == nil {
		return 0
	}
	return *t.RelayRolloverErrors
}

// GetReplayTimeoutErrors retrieves the value of the leaf ReplayTimeoutErrors from the Component_Pcie_CorrectableErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReplayTimeoutErrors is set, it can
// safely use t.GetReplayTimeoutErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReplayTimeoutErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_CorrectableErrors) GetReplayTimeoutErrors() uint64 {
	if t == nil || t.ReplayTimeoutErrors == nil {
		return 0
	}
	return *t.ReplayTimeoutErrors
}

// GetTotalErrors retrieves the value of the leaf TotalErrors from the Component_Pcie_CorrectableErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TotalErrors is set, it can
// safely use t.GetTotalErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TotalErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_CorrectableErrors) GetTotalErrors() uint64 {
	if t == nil || t.TotalErrors == nil {
		return 0
	}
	return *t.TotalErrors
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Pcie_CorrectableErrors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Pcie_CorrectableErrors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Pcie_CorrectableErrors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Pcie_CorrectableErrors) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Pcie_CorrectableErrors.
func (*Component_Pcie_CorrectableErrors) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Pcie_FatalErrors represents the /openconfig-platform/components/component/state/pcie/fatal-errors YANG schema element.
type Component_Pcie_FatalErrors struct {
	ΛMetadata                   []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	AcsViolationErrors          *uint64           `path:"acs-violation-errors" module:"openconfig-platform"`
	ΛAcsViolationErrors         []ygot.Annotation `path:"@acs-violation-errors" ygotAnnotation:"true"`
	AtomicOpBlockedErrors       *uint64           `path:"atomic-op-blocked-errors" module:"openconfig-platform"`
	ΛAtomicOpBlockedErrors      []ygot.Annotation `path:"@atomic-op-blocked-errors" ygotAnnotation:"true"`
	BlockedTlpErrors            *uint64           `path:"blocked-tlp-errors" module:"openconfig-platform"`
	ΛBlockedTlpErrors           []ygot.Annotation `path:"@blocked-tlp-errors" ygotAnnotation:"true"`
	CompletionAbortErrors       *uint64           `path:"completion-abort-errors" module:"openconfig-platform"`
	ΛCompletionAbortErrors      []ygot.Annotation `path:"@completion-abort-errors" ygotAnnotation:"true"`
	CompletionTimeoutErrors     *uint64           `path:"completion-timeout-errors" module:"openconfig-platform"`
	ΛCompletionTimeoutErrors    []ygot.Annotation `path:"@completion-timeout-errors" ygotAnnotation:"true"`
	DataLinkErrors              *uint64           `path:"data-link-errors" module:"openconfig-platform"`
	ΛDataLinkErrors             []ygot.Annotation `path:"@data-link-errors" ygotAnnotation:"true"`
	EcrcErrors                  *uint64           `path:"ecrc-errors" module:"openconfig-platform"`
	ΛEcrcErrors                 []ygot.Annotation `path:"@ecrc-errors" ygotAnnotation:"true"`
	FlowControlProtocolErrors   *uint64           `path:"flow-control-protocol-errors" module:"openconfig-platform"`
	ΛFlowControlProtocolErrors  []ygot.Annotation `path:"@flow-control-protocol-errors" ygotAnnotation:"true"`
	InternalErrors              *uint64           `path:"internal-errors" module:"openconfig-platform"`
	ΛInternalErrors             []ygot.Annotation `path:"@internal-errors" ygotAnnotation:"true"`
	MalformedTlpErrors          *uint64           `path:"malformed-tlp-errors" module:"openconfig-platform"`
	ΛMalformedTlpErrors         []ygot.Annotation `path:"@malformed-tlp-errors" ygotAnnotation:"true"`
	PoisonedTlpErrors           *uint64           `path:"poisoned-tlp-errors" module:"openconfig-platform"`
	ΛPoisonedTlpErrors          []ygot.Annotation `path:"@poisoned-tlp-errors" ygotAnnotation:"true"`
	ReceiverOverflowErrors      *uint64           `path:"receiver-overflow-errors" module:"openconfig-platform"`
	ΛReceiverOverflowErrors     []ygot.Annotation `path:"@receiver-overflow-errors" ygotAnnotation:"true"`
	SurpriseDownErrors          *uint64           `path:"surprise-down-errors" module:"openconfig-platform"`
	ΛSurpriseDownErrors         []ygot.Annotation `path:"@surprise-down-errors" ygotAnnotation:"true"`
	TlpPrefixBlockedErrors      *uint64           `path:"tlp-prefix-blocked-errors" module:"openconfig-platform"`
	ΛTlpPrefixBlockedErrors     []ygot.Annotation `path:"@tlp-prefix-blocked-errors" ygotAnnotation:"true"`
	TotalErrors                 *uint64           `path:"total-errors" module:"openconfig-platform"`
	ΛTotalErrors                []ygot.Annotation `path:"@total-errors" ygotAnnotation:"true"`
	UndefinedErrors             *uint64           `path:"undefined-errors" module:"openconfig-platform"`
	ΛUndefinedErrors            []ygot.Annotation `path:"@undefined-errors" ygotAnnotation:"true"`
	UnexpectedCompletionErrors  *uint64           `path:"unexpected-completion-errors" module:"openconfig-platform"`
	ΛUnexpectedCompletionErrors []ygot.Annotation `path:"@unexpected-completion-errors" ygotAnnotation:"true"`
	UnsupportedRequestErrors    *uint64           `path:"unsupported-request-errors" module:"openconfig-platform"`
	ΛUnsupportedRequestErrors   []ygot.Annotation `path:"@unsupported-request-errors" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Pcie_FatalErrors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Pcie_FatalErrors) IsYANGGoStruct() {}

// GetAcsViolationErrors retrieves the value of the leaf AcsViolationErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AcsViolationErrors is set, it can
// safely use t.GetAcsViolationErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AcsViolationErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetAcsViolationErrors() uint64 {
	if t == nil || t.AcsViolationErrors == nil {
		return 0
	}
	return *t.AcsViolationErrors
}

// GetAtomicOpBlockedErrors retrieves the value of the leaf AtomicOpBlockedErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AtomicOpBlockedErrors is set, it can
// safely use t.GetAtomicOpBlockedErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AtomicOpBlockedErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetAtomicOpBlockedErrors() uint64 {
	if t == nil || t.AtomicOpBlockedErrors == nil {
		return 0
	}
	return *t.AtomicOpBlockedErrors
}

// GetBlockedTlpErrors retrieves the value of the leaf BlockedTlpErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if BlockedTlpErrors is set, it can
// safely use t.GetBlockedTlpErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.BlockedTlpErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetBlockedTlpErrors() uint64 {
	if t == nil || t.BlockedTlpErrors == nil {
		return 0
	}
	return *t.BlockedTlpErrors
}

// GetCompletionAbortErrors retrieves the value of the leaf CompletionAbortErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if CompletionAbortErrors is set, it can
// safely use t.GetCompletionAbortErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.CompletionAbortErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetCompletionAbortErrors() uint64 {
	if t == nil || t.CompletionAbortErrors == nil {
		return 0
	}
	return *t.CompletionAbortErrors
}

// GetCompletionTimeoutErrors retrieves the value of the leaf CompletionTimeoutErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if CompletionTimeoutErrors is set, it can
// safely use t.GetCompletionTimeoutErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.CompletionTimeoutErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetCompletionTimeoutErrors() uint64 {
	if t == nil || t.CompletionTimeoutErrors == nil {
		return 0
	}
	return *t.CompletionTimeoutErrors
}

// GetDataLinkErrors retrieves the value of the leaf DataLinkErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DataLinkErrors is set, it can
// safely use t.GetDataLinkErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DataLinkErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetDataLinkErrors() uint64 {
	if t == nil || t.DataLinkErrors == nil {
		return 0
	}
	return *t.DataLinkErrors
}

// GetEcrcErrors retrieves the value of the leaf EcrcErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EcrcErrors is set, it can
// safely use t.GetEcrcErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EcrcErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetEcrcErrors() uint64 {
	if t == nil || t.EcrcErrors == nil {
		return 0
	}
	return *t.EcrcErrors
}

// GetFlowControlProtocolErrors retrieves the value of the leaf FlowControlProtocolErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FlowControlProtocolErrors is set, it can
// safely use t.GetFlowControlProtocolErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FlowControlProtocolErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetFlowControlProtocolErrors() uint64 {
	if t == nil || t.FlowControlProtocolErrors == nil {
		return 0
	}
	return *t.FlowControlProtocolErrors
}

// GetInternalErrors retrieves the value of the leaf InternalErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InternalErrors is set, it can
// safely use t.GetInternalErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InternalErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetInternalErrors() uint64 {
	if t == nil || t.InternalErrors == nil {
		return 0
	}
	return *t.InternalErrors
}

// GetMalformedTlpErrors retrieves the value of the leaf MalformedTlpErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MalformedTlpErrors is set, it can
// safely use t.GetMalformedTlpErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MalformedTlpErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetMalformedTlpErrors() uint64 {
	if t == nil || t.MalformedTlpErrors == nil {
		return 0
	}
	return *t.MalformedTlpErrors
}

// GetPoisonedTlpErrors retrieves the value of the leaf PoisonedTlpErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if PoisonedTlpErrors is set, it can
// safely use t.GetPoisonedTlpErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.PoisonedTlpErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetPoisonedTlpErrors() uint64 {
	if t == nil || t.PoisonedTlpErrors == nil {
		return 0
	}
	return *t.PoisonedTlpErrors
}

// GetReceiverOverflowErrors retrieves the value of the leaf ReceiverOverflowErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReceiverOverflowErrors is set, it can
// safely use t.GetReceiverOverflowErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReceiverOverflowErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetReceiverOverflowErrors() uint64 {
	if t == nil || t.ReceiverOverflowErrors == nil {
		return 0
	}
	return *t.ReceiverOverflowErrors
}

// GetSurpriseDownErrors retrieves the value of the leaf SurpriseDownErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SurpriseDownErrors is set, it can
// safely use t.GetSurpriseDownErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SurpriseDownErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetSurpriseDownErrors() uint64 {
	if t == nil || t.SurpriseDownErrors == nil {
		return 0
	}
	return *t.SurpriseDownErrors
}

// GetTlpPrefixBlockedErrors retrieves the value of the leaf TlpPrefixBlockedErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TlpPrefixBlockedErrors is set, it can
// safely use t.GetTlpPrefixBlockedErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TlpPrefixBlockedErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetTlpPrefixBlockedErrors() uint64 {
	if t == nil || t.TlpPrefixBlockedErrors == nil {
		return 0
	}
	return *t.TlpPrefixBlockedErrors
}

// GetTotalErrors retrieves the value of the leaf TotalErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TotalErrors is set, it can
// safely use t.GetTotalErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TotalErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetTotalErrors() uint64 {
	if t == nil || t.TotalErrors == nil {
		return 0
	}
	return *t.TotalErrors
}

// GetUndefinedErrors retrieves the value of the leaf UndefinedErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UndefinedErrors is set, it can
// safely use t.GetUndefinedErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UndefinedErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetUndefinedErrors() uint64 {
	if t == nil || t.UndefinedErrors == nil {
		return 0
	}
	return *t.UndefinedErrors
}

// GetUnexpectedCompletionErrors retrieves the value of the leaf UnexpectedCompletionErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UnexpectedCompletionErrors is set, it can
// safely use t.GetUnexpectedCompletionErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UnexpectedCompletionErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetUnexpectedCompletionErrors() uint64 {
	if t == nil || t.UnexpectedCompletionErrors == nil {
		return 0
	}
	return *t.UnexpectedCompletionErrors
}

// GetUnsupportedRequestErrors retrieves the value of the leaf UnsupportedRequestErrors from the Component_Pcie_FatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UnsupportedRequestErrors is set, it can
// safely use t.GetUnsupportedRequestErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UnsupportedRequestErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_FatalErrors) GetUnsupportedRequestErrors() uint64 {
	if t == nil || t.UnsupportedRequestErrors == nil {
		return 0
	}
	return *t.UnsupportedRequestErrors
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Pcie_FatalErrors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Pcie_FatalErrors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Pcie_FatalErrors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Pcie_FatalErrors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Pcie_FatalErrors.
func (*Component_Pcie_FatalErrors) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Pcie_NonFatalErrors represents the /openconfig-platform/components/component/state/pcie/non-fatal-errors YANG schema element.
type Component_Pcie_NonFatalErrors struct {
	ΛMetadata                   []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	AcsViolationErrors          *uint64           `path:"acs-violation-errors" module:"openconfig-platform"`
	ΛAcsViolationErrors         []ygot.Annotation `path:"@acs-violation-errors" ygotAnnotation:"true"`
	AtomicOpBlockedErrors       *uint64           `path:"atomic-op-blocked-errors" module:"openconfig-platform"`
	ΛAtomicOpBlockedErrors      []ygot.Annotation `path:"@atomic-op-blocked-errors" ygotAnnotation:"true"`
	BlockedTlpErrors            *uint64           `path:"blocked-tlp-errors" module:"openconfig-platform"`
	ΛBlockedTlpErrors           []ygot.Annotation `path:"@blocked-tlp-errors" ygotAnnotation:"true"`
	CompletionAbortErrors       *uint64           `path:"completion-abort-errors" module:"openconfig-platform"`
	ΛCompletionAbortErrors      []ygot.Annotation `path:"@completion-abort-errors" ygotAnnotation:"true"`
	CompletionTimeoutErrors     *uint64           `path:"completion-timeout-errors" module:"openconfig-platform"`
	ΛCompletionTimeoutErrors    []ygot.Annotation `path:"@completion-timeout-errors" ygotAnnotation:"true"`
	DataLinkErrors              *uint64           `path:"data-link-errors" module:"openconfig-platform"`
	ΛDataLinkErrors             []ygot.Annotation `path:"@data-link-errors" ygotAnnotation:"true"`
	EcrcErrors                  *uint64           `path:"ecrc-errors" module:"openconfig-platform"`
	ΛEcrcErrors                 []ygot.Annotation `path:"@ecrc-errors" ygotAnnotation:"true"`
	FlowControlProtocolErrors   *uint64           `path:"flow-control-protocol-errors" module:"openconfig-platform"`
	ΛFlowControlProtocolErrors  []ygot.Annotation `path:"@flow-control-protocol-errors" ygotAnnotation:"true"`
	InternalErrors              *uint64           `path:"internal-errors" module:"openconfig-platform"`
	ΛInternalErrors             []ygot.Annotation `path:"@internal-errors" ygotAnnotation:"true"`
	MalformedTlpErrors          *uint64           `path:"malformed-tlp-errors" module:"openconfig-platform"`
	ΛMalformedTlpErrors         []ygot.Annotation `path:"@malformed-tlp-errors" ygotAnnotation:"true"`
	PoisonedTlpErrors           *uint64           `path:"poisoned-tlp-errors" module:"openconfig-platform"`
	ΛPoisonedTlpErrors          []ygot.Annotation `path:"@poisoned-tlp-errors" ygotAnnotation:"true"`
	ReceiverOverflowErrors      *uint64           `path:"receiver-overflow-errors" module:"openconfig-platform"`
	ΛReceiverOverflowErrors     []ygot.Annotation `path:"@receiver-overflow-errors" ygotAnnotation:"true"`
	SurpriseDownErrors          *uint64           `path:"surprise-down-errors" module:"openconfig-platform"`
	ΛSurpriseDownErrors         []ygot.Annotation `path:"@surprise-down-errors" ygotAnnotation:"true"`
	TlpPrefixBlockedErrors      *uint64           `path:"tlp-prefix-blocked-errors" module:"openconfig-platform"`
	ΛTlpPrefixBlockedErrors     []ygot.Annotation `path:"@tlp-prefix-blocked-errors" ygotAnnotation:"true"`
	TotalErrors                 *uint64           `path:"total-errors" module:"openconfig-platform"`
	ΛTotalErrors                []ygot.Annotation `path:"@total-errors" ygotAnnotation:"true"`
	UndefinedErrors             *uint64           `path:"undefined-errors" module:"openconfig-platform"`
	ΛUndefinedErrors            []ygot.Annotation `path:"@undefined-errors" ygotAnnotation:"true"`
	UnexpectedCompletionErrors  *uint64           `path:"unexpected-completion-errors" module:"openconfig-platform"`
	ΛUnexpectedCompletionErrors []ygot.Annotation `path:"@unexpected-completion-errors" ygotAnnotation:"true"`
	UnsupportedRequestErrors    *uint64           `path:"unsupported-request-errors" module:"openconfig-platform"`
	ΛUnsupportedRequestErrors   []ygot.Annotation `path:"@unsupported-request-errors" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Pcie_NonFatalErrors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Pcie_NonFatalErrors) IsYANGGoStruct() {}

// GetAcsViolationErrors retrieves the value of the leaf AcsViolationErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AcsViolationErrors is set, it can
// safely use t.GetAcsViolationErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AcsViolationErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetAcsViolationErrors() uint64 {
	if t == nil || t.AcsViolationErrors == nil {
		return 0
	}
	return *t.AcsViolationErrors
}

// GetAtomicOpBlockedErrors retrieves the value of the leaf AtomicOpBlockedErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AtomicOpBlockedErrors is set, it can
// safely use t.GetAtomicOpBlockedErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AtomicOpBlockedErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetAtomicOpBlockedErrors() uint64 {
	if t == nil || t.AtomicOpBlockedErrors == nil {
		return 0
	}
	return *t.AtomicOpBlockedErrors
}

// GetBlockedTlpErrors retrieves the value of the leaf BlockedTlpErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if BlockedTlpErrors is set, it can
// safely use t.GetBlockedTlpErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.BlockedTlpErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetBlockedTlpErrors() uint64 {
	if t == nil || t.BlockedTlpErrors == nil {
		return 0
	}
	return *t.BlockedTlpErrors
}

// GetCompletionAbortErrors retrieves the value of the leaf CompletionAbortErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if CompletionAbortErrors is set, it can
// safely use t.GetCompletionAbortErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.CompletionAbortErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetCompletionAbortErrors() uint64 {
	if t == nil || t.CompletionAbortErrors == nil {
		return 0
	}
	return *t.CompletionAbortErrors
}

// GetCompletionTimeoutErrors retrieves the value of the leaf CompletionTimeoutErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if CompletionTimeoutErrors is set, it can
// safely use t.GetCompletionTimeoutErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.CompletionTimeoutErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetCompletionTimeoutErrors() uint64 {
	if t == nil || t.CompletionTimeoutErrors == nil {
		return 0
	}
	return *t.CompletionTimeoutErrors
}

// GetDataLinkErrors retrieves the value of the leaf DataLinkErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DataLinkErrors is set, it can
// safely use t.GetDataLinkErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DataLinkErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetDataLinkErrors() uint64 {
	if t == nil || t.DataLinkErrors == nil {
		return 0
	}
	return *t.DataLinkErrors
}

// GetEcrcErrors retrieves the value of the leaf EcrcErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EcrcErrors is set, it can
// safely use t.GetEcrcErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EcrcErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetEcrcErrors() uint64 {
	if t == nil || t.EcrcErrors == nil {
		return 0
	}
	return *t.EcrcErrors
}

// GetFlowControlProtocolErrors retrieves the value of the leaf FlowControlProtocolErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FlowControlProtocolErrors is set, it can
// safely use t.GetFlowControlProtocolErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FlowControlProtocolErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetFlowControlProtocolErrors() uint64 {
	if t == nil || t.FlowControlProtocolErrors == nil {
		return 0
	}
	return *t.FlowControlProtocolErrors
}

// GetInternalErrors retrieves the value of the leaf InternalErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InternalErrors is set, it can
// safely use t.GetInternalErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InternalErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetInternalErrors() uint64 {
	if t == nil || t.InternalErrors == nil {
		return 0
	}
	return *t.InternalErrors
}

// GetMalformedTlpErrors retrieves the value of the leaf MalformedTlpErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MalformedTlpErrors is set, it can
// safely use t.GetMalformedTlpErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MalformedTlpErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetMalformedTlpErrors() uint64 {
	if t == nil || t.MalformedTlpErrors == nil {
		return 0
	}
	return *t.MalformedTlpErrors
}

// GetPoisonedTlpErrors retrieves the value of the leaf PoisonedTlpErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if PoisonedTlpErrors is set, it can
// safely use t.GetPoisonedTlpErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.PoisonedTlpErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetPoisonedTlpErrors() uint64 {
	if t == nil || t.PoisonedTlpErrors == nil {
		return 0
	}
	return *t.PoisonedTlpErrors
}

// GetReceiverOverflowErrors retrieves the value of the leaf ReceiverOverflowErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ReceiverOverflowErrors is set, it can
// safely use t.GetReceiverOverflowErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ReceiverOverflowErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetReceiverOverflowErrors() uint64 {
	if t == nil || t.ReceiverOverflowErrors == nil {
		return 0
	}
	return *t.ReceiverOverflowErrors
}

// GetSurpriseDownErrors retrieves the value of the leaf SurpriseDownErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SurpriseDownErrors is set, it can
// safely use t.GetSurpriseDownErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SurpriseDownErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetSurpriseDownErrors() uint64 {
	if t == nil || t.SurpriseDownErrors == nil {
		return 0
	}
	return *t.SurpriseDownErrors
}

// GetTlpPrefixBlockedErrors retrieves the value of the leaf TlpPrefixBlockedErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TlpPrefixBlockedErrors is set, it can
// safely use t.GetTlpPrefixBlockedErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TlpPrefixBlockedErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetTlpPrefixBlockedErrors() uint64 {
	if t == nil || t.TlpPrefixBlockedErrors == nil {
		return 0
	}
	return *t.TlpPrefixBlockedErrors
}

// GetTotalErrors retrieves the value of the leaf TotalErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TotalErrors is set, it can
// safely use t.GetTotalErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TotalErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetTotalErrors() uint64 {
	if t == nil || t.TotalErrors == nil {
		return 0
	}
	return *t.TotalErrors
}

// GetUndefinedErrors retrieves the value of the leaf UndefinedErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UndefinedErrors is set, it can
// safely use t.GetUndefinedErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UndefinedErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetUndefinedErrors() uint64 {
	if t == nil || t.UndefinedErrors == nil {
		return 0
	}
	return *t.UndefinedErrors
}

// GetUnexpectedCompletionErrors retrieves the value of the leaf UnexpectedCompletionErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UnexpectedCompletionErrors is set, it can
// safely use t.GetUnexpectedCompletionErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UnexpectedCompletionErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetUnexpectedCompletionErrors() uint64 {
	if t == nil || t.UnexpectedCompletionErrors == nil {
		return 0
	}
	return *t.UnexpectedCompletionErrors
}

// GetUnsupportedRequestErrors retrieves the value of the leaf UnsupportedRequestErrors from the Component_Pcie_NonFatalErrors
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if UnsupportedRequestErrors is set, it can
// safely use t.GetUnsupportedRequestErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.UnsupportedRequestErrors == nil' before retrieving the leaf's value.
func (t *Component_Pcie_NonFatalErrors) GetUnsupportedRequestErrors() uint64 {
	if t == nil || t.UnsupportedRequestErrors == nil {
		return 0
	}
	return *t.UnsupportedRequestErrors
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Pcie_NonFatalErrors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Pcie_NonFatalErrors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Pcie_NonFatalErrors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Pcie_NonFatalErrors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Pcie_NonFatalErrors.
func (*Component_Pcie_NonFatalErrors) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Port represents the /openconfig-platform/components/component/port YANG schema element.
type Component_Port struct {
	ΛMetadata     []ygot.Annotation            `path:"@" ygotAnnotation:"true"`
	BreakoutMode  *Component_Port_BreakoutMode `path:"breakout-mode" module:"openconfig-platform-port"`
	ΛBreakoutMode []ygot.Annotation            `path:"@breakout-mode" ygotAnnotation:"true"`
	OpticalPort   *Component_Port_OpticalPort  `path:"optical-port" module:"openconfig-transport-line-common"`
	ΛOpticalPort  []ygot.Annotation            `path:"@optical-port" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Port implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Port) IsYANGGoStruct() {}

// GetOrCreateBreakoutMode retrieves the value of the BreakoutMode field
// or returns the existing field if it already exists.
func (t *Component_Port) GetOrCreateBreakoutMode() *Component_Port_BreakoutMode {
	if t.BreakoutMode != nil {
		return t.BreakoutMode
	}
	t.BreakoutMode = &Component_Port_BreakoutMode{}
	return t.BreakoutMode
}

// GetOrCreateOpticalPort retrieves the value of the OpticalPort field
// or returns the existing field if it already exists.
func (t *Component_Port) GetOrCreateOpticalPort() *Component_Port_OpticalPort {
	if t.OpticalPort != nil {
		return t.OpticalPort
	}
	t.OpticalPort = &Component_Port_OpticalPort{}
	return t.OpticalPort
}

// GetBreakoutMode returns the value of the BreakoutMode struct pointer
// from Component_Port. If the receiver or the field BreakoutMode is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Port) GetBreakoutMode() *Component_Port_BreakoutMode {
	if t != nil && t.BreakoutMode != nil {
		return t.BreakoutMode
	}
	return nil
}

// GetOpticalPort returns the value of the OpticalPort struct pointer
// from Component_Port. If the receiver or the field OpticalPort is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Port) GetOpticalPort() *Component_Port_OpticalPort {
	if t != nil && t.OpticalPort != nil {
		return t.OpticalPort
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Port"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Port) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Port.
func (*Component_Port) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Port_BreakoutMode represents the /openconfig-platform/components/component/port/breakout-mode YANG schema element.
type Component_Port_BreakoutMode struct {
	ΛMetadata []ygot.Annotation                            `path:"@" ygotAnnotation:"true"`
	Group     map[uint8]*Component_Port_BreakoutMode_Group `path:"groups/group" module:"openconfig-platform-port/openconfig-platform-port"`
	ΛGroup    []ygot.Annotation                            `path:"groups/@group" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Port_BreakoutMode implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Port_BreakoutMode) IsYANGGoStruct() {}

// NewGroup creates a new entry in the Group list of the
// Component_Port_BreakoutMode struct. The keys of the list are populated from the input
// arguments.
func (t *Component_Port_BreakoutMode) NewGroup(Index uint8) (*Component_Port_BreakoutMode_Group, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Group == nil {
		t.Group = make(map[uint8]*Component_Port_BreakoutMode_Group)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Group[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Group", key)
	}

	t.Group[key] = &Component_Port_BreakoutMode_Group{
		Index: &Index,
	}

	return t.Group[key], nil
}

// RenameGroup renames an entry in the list Group within
// the Component_Port_BreakoutMode struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Component_Port_BreakoutMode) RenameGroup(oldK, newK uint8) error {
	if _, ok := t.Group[newK]; ok {
		return fmt.Errorf("key %v already exists in Group", newK)
	}

	e, ok := t.Group[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Group", oldK)
	}
	e.Index = &newK

	t.Group[newK] = e
	delete(t.Group, oldK)
	return nil
}

// GetOrCreateGroup retrieves the value with the specified keys from
// the receiver Component_Port_BreakoutMode. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Component_Port_BreakoutMode) GetOrCreateGroup(Index uint8) *Component_Port_BreakoutMode_Group {

	key := Index

	if v, ok := t.Group[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewGroup(Index)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateGroup got unexpected error: %v", err))
	}
	return v
}

// GetGroup retrieves the value with the specified key from
// the Group map field of Component_Port_BreakoutMode. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Component_Port_BreakoutMode) GetGroup(Index uint8) *Component_Port_BreakoutMode_Group {

	if t == nil {
		return nil
	}

	key := Index

	if lm, ok := t.Group[key]; ok {
		return lm
	}
	return nil
}

// AppendGroup appends the supplied Component_Port_BreakoutMode_Group struct to the
// list Group of Component_Port_BreakoutMode. If the key value(s) specified in
// the supplied Component_Port_BreakoutMode_Group already exist in the list, an error is
// returned.
func (t *Component_Port_BreakoutMode) AppendGroup(v *Component_Port_BreakoutMode_Group) error {
	if v.Index == nil {
		return fmt.Errorf("invalid nil key received for Index")
	}

	key := *v.Index

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Group == nil {
		t.Group = make(map[uint8]*Component_Port_BreakoutMode_Group)
	}

	if _, ok := t.Group[key]; ok {
		return fmt.Errorf("duplicate key for list Group %v", key)
	}

	t.Group[key] = v
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port_BreakoutMode) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Port_BreakoutMode"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port_BreakoutMode) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Port_BreakoutMode) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Port_BreakoutMode.
func (*Component_Port_BreakoutMode) ΛBelongingModule() string {
	return "openconfig-platform-port"
}

// Component_Port_BreakoutMode_Group represents the /openconfig-platform/components/component/port/breakout-mode/groups/group YANG schema element.
type Component_Port_BreakoutMode_Group struct {
	ΛMetadata            []ygot.Annotation           `path:"@" ygotAnnotation:"true"`
	BreakoutSpeed        E_IfEthernet_ETHERNET_SPEED `path:"config/breakout-speed" module:"openconfig-platform-port/openconfig-platform-port"`
	ΛBreakoutSpeed       []ygot.Annotation           `path:"config/@breakout-speed" ygotAnnotation:"true"`
	Index                *uint8                      `path:"config/index|index" module:"openconfig-platform-port/openconfig-platform-port|openconfig-platform-port"`
	ΛIndex               []ygot.Annotation           `path:"config/@index|@index" ygotAnnotation:"true"`
	NumBreakouts         *uint8                      `path:"config/num-breakouts" module:"openconfig-platform-port/openconfig-platform-port"`
	ΛNumBreakouts        []ygot.Annotation           `path:"config/@num-breakouts" ygotAnnotation:"true"`
	NumPhysicalChannels  *uint8                      `path:"config/num-physical-channels" module:"openconfig-platform-port/openconfig-platform-port"`
	ΛNumPhysicalChannels []ygot.Annotation           `path:"config/@num-physical-channels" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Port_BreakoutMode_Group implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Port_BreakoutMode_Group) IsYANGGoStruct() {}

// GetBreakoutSpeed retrieves the value of the leaf BreakoutSpeed from the Component_Port_BreakoutMode_Group
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if BreakoutSpeed is set, it can
// safely use t.GetBreakoutSpeed() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.BreakoutSpeed == nil' before retrieving the leaf's value.
func (t *Component_Port_BreakoutMode_Group) GetBreakoutSpeed() E_IfEthernet_ETHERNET_SPEED {
	if t == nil || t.BreakoutSpeed == 0 {
		return 0
	}
	return t.BreakoutSpeed
}

// GetIndex retrieves the value of the leaf Index from the Component_Port_BreakoutMode_Group
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Index is set, it can
// safely use t.GetIndex() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Index == nil' before retrieving the leaf's value.
func (t *Component_Port_BreakoutMode_Group) GetIndex() uint8 {
	if t == nil || t.Index == nil {
		return 0
	}
	return *t.Index
}

// GetNumBreakouts retrieves the value of the leaf NumBreakouts from the Component_Port_BreakoutMode_Group
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if NumBreakouts is set, it can
// safely use t.GetNumBreakouts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.NumBreakouts == nil' before retrieving the leaf's value.
func (t *Component_Port_BreakoutMode_Group) GetNumBreakouts() uint8 {
	if t == nil || t.NumBreakouts == nil {
		return 0
	}
	return *t.NumBreakouts
}

// GetNumPhysicalChannels retrieves the value of the leaf NumPhysicalChannels from the Component_Port_BreakoutMode_Group
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if NumPhysicalChannels is set, it can
// safely use t.GetNumPhysicalChannels() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.NumPhysicalChannels == nil' before retrieving the leaf's value.
func (t *Component_Port_BreakoutMode_Group) GetNumPhysicalChannels() uint8 {
	if t == nil || t.NumPhysicalChannels == nil {
		return 0
	}
	return *t.NumPhysicalChannels
}

// ΛListKeyMap returns the keys of the Component_Port_BreakoutMode_Group struct, which is a YANG list entry.
func (t *Component_Port_BreakoutMode_Group) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port_BreakoutMode_Group) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Port_BreakoutMode_Group"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port_BreakoutMode_Group) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Port_BreakoutMode_Group) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Port_BreakoutMode_Group.
func (*Component_Port_BreakoutMode_Group) ΛBelongingModule() string {
	return "openconfig-platform-port"
}

// Component_Port_OpticalPort represents the /openconfig-platform/components/component/port/optical-port YANG schema element.
type Component_Port_OpticalPort struct {
	ΛMetadata        []ygot.Annotation                       `path:"@" ygotAnnotation:"true"`
	AdminState       E_TransportTypes_AdminStateType         `path:"config/admin-state" module:"openconfig-transport-line-common/openconfig-transport-line-common"`
	ΛAdminState      []ygot.Annotation                       `path:"config/@admin-state" ygotAnnotation:"true"`
	InputPower       *Component_Port_OpticalPort_InputPower  `path:"state/input-power" module:"openconfig-transport-line-common/openconfig-transport-line-common"`
	ΛInputPower      []ygot.Annotation                       `path:"state/@input-power" ygotAnnotation:"true"`
	OpticalPortType  E_TransportTypes_OPTICAL_PORT_TYPE      `path:"state/optical-port-type" module:"openconfig-transport-line-common/openconfig-transport-line-common"`
	ΛOpticalPortType []ygot.Annotation                       `path:"state/@optical-port-type" ygotAnnotation:"true"`
	OutputPower      *Component_Port_OpticalPort_OutputPower `path:"state/output-power" module:"openconfig-transport-line-common/openconfig-transport-line-common"`
	ΛOutputPower     []ygot.Annotation                       `path:"state/@output-power" ygotAnnotation:"true"`
	Tilt             *float64                                `path:"state/tilt" module:"openconfig-transport-line-common/openconfig-transport-line-common"`
	ΛTilt            []ygot.Annotation                       `path:"state/@tilt" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Port_OpticalPort implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Port_OpticalPort) IsYANGGoStruct() {}

// GetOrCreateInputPower retrieves the value of the InputPower field
// or returns the existing field if it already exists.
func (t *Component_Port_OpticalPort) GetOrCreateInputPower() *Component_Port_OpticalPort_InputPower {
	if t.InputPower != nil {
		return t.InputPower
	}
	t.InputPower = &Component_Port_OpticalPort_InputPower{}
	return t.InputPower
}

// GetOrCreateOutputPower retrieves the value of the OutputPower field
// or returns the existing field if it already exists.
func (t *Component_Port_OpticalPort) GetOrCreateOutputPower() *Component_Port_OpticalPort_OutputPower {
	if t.OutputPower != nil {
		return t.OutputPower
	}
	t.OutputPower = &Component_Port_OpticalPort_OutputPower{}
	return t.OutputPower
}

// GetInputPower returns the value of the InputPower struct pointer
// from Component_Port_OpticalPort. If the receiver or the field InputPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Port_OpticalPort) GetInputPower() *Component_Port_OpticalPort_InputPower {
	if t != nil && t.InputPower != nil {
		return t.InputPower
	}
	return nil
}

// GetOutputPower returns the value of the OutputPower struct pointer
// from Component_Port_OpticalPort. If the receiver or the field OutputPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Port_OpticalPort) GetOutputPower() *Component_Port_OpticalPort_OutputPower {
	if t != nil && t.OutputPower != nil {
		return t.OutputPower
	}
	return nil
}

// GetAdminState retrieves the value of the leaf AdminState from the Component_Port_OpticalPort
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AdminState is set, it can
// safely use t.GetAdminState() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AdminState == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort) GetAdminState() E_TransportTypes_AdminStateType {
	if t == nil || t.AdminState == 0 {
		return 0
	}
	return t.AdminState
}

// GetOpticalPortType retrieves the value of the leaf OpticalPortType from the Component_Port_OpticalPort
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OpticalPortType is set, it can
// safely use t.GetOpticalPortType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OpticalPortType == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort) GetOpticalPortType() E_TransportTypes_OPTICAL_PORT_TYPE {
	if t == nil || t.OpticalPortType == 0 {
		return 0
	}
	return t.OpticalPortType
}

// GetTilt retrieves the value of the leaf Tilt from the Component_Port_OpticalPort
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Tilt is set, it can
// safely use t.GetTilt() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Tilt == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort) GetTilt() float64 {
	if t == nil || t.Tilt == nil {
		return 0.0
	}
	return *t.Tilt
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port_OpticalPort) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Port_OpticalPort"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port_OpticalPort) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Port_OpticalPort) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Port_OpticalPort.
func (*Component_Port_OpticalPort) ΛBelongingModule() string {
	return "openconfig-transport-line-common"
}

// Component_Port_OpticalPort_InputPower represents the /openconfig-platform/components/component/port/optical-port/state/input-power YANG schema element.
type Component_Port_OpticalPort_InputPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-transport-line-common"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-transport-line-common"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-transport-line-common"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-transport-line-common"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-transport-line-common"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-transport-line-common"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-transport-line-common"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Port_OpticalPort_InputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Port_OpticalPort_InputPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Port_OpticalPort_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_InputPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Port_OpticalPort_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_InputPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Port_OpticalPort_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_InputPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Port_OpticalPort_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_InputPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Port_OpticalPort_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_InputPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Port_OpticalPort_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_InputPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Port_OpticalPort_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_InputPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port_OpticalPort_InputPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Port_OpticalPort_InputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port_OpticalPort_InputPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Port_OpticalPort_InputPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Port_OpticalPort_InputPower.
func (*Component_Port_OpticalPort_InputPower) ΛBelongingModule() string {
	return "openconfig-transport-line-common"
}

// Component_Port_OpticalPort_OutputPower represents the /openconfig-platform/components/component/port/optical-port/state/output-power YANG schema element.
type Component_Port_OpticalPort_OutputPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-transport-line-common"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-transport-line-common"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-transport-line-common"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-transport-line-common"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-transport-line-common"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-transport-line-common"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-transport-line-common"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Port_OpticalPort_OutputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Port_OpticalPort_OutputPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Port_OpticalPort_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_OutputPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Port_OpticalPort_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_OutputPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Port_OpticalPort_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_OutputPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Port_OpticalPort_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_OutputPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Port_OpticalPort_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_OutputPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Port_OpticalPort_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_OutputPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Port_OpticalPort_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Port_OpticalPort_OutputPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port_OpticalPort_OutputPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Port_OpticalPort_OutputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Port_OpticalPort_OutputPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Port_OpticalPort_OutputPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Port_OpticalPort_OutputPower.
func (*Component_Port_OpticalPort_OutputPower) ΛBelongingModule() string {
	return "openconfig-transport-line-common"
}

// Component_PowerSupply represents the /openconfig-platform/components/component/power-supply YANG schema element.
type Component_PowerSupply struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_PowerSupply implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_PowerSupply) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_PowerSupply) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_PowerSupply"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_PowerSupply) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_PowerSupply) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_PowerSupply.
func (*Component_PowerSupply) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Property represents the /openconfig-platform/components/component/properties/property YANG schema element.
type Component_Property struct {
	ΛMetadata     []ygot.Annotation              `path:"@" ygotAnnotation:"true"`
	Configurable  *bool                          `path:"state/configurable" module:"openconfig-platform/openconfig-platform"`
	ΛConfigurable []ygot.Annotation              `path:"state/@configurable" ygotAnnotation:"true"`
	Name          *string                        `path:"config/name|name" module:"openconfig-platform/openconfig-platform|openconfig-platform"`
	ΛName         []ygot.Annotation              `path:"config/@name|@name" ygotAnnotation:"true"`
	Value         Component_Property_Value_Union `path:"config/value" module:"openconfig-platform/openconfig-platform"`
	ΛValue        []ygot.Annotation              `path:"config/@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Property implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Property) IsYANGGoStruct() {}

// GetConfigurable retrieves the value of the leaf Configurable from the Component_Property
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Configurable is set, it can
// safely use t.GetConfigurable() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Configurable == nil' before retrieving the leaf's value.
func (t *Component_Property) GetConfigurable() bool {
	if t == nil || t.Configurable == nil {
		return false
	}
	return *t.Configurable
}

// GetName retrieves the value of the leaf Name from the Component_Property
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *Component_Property) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetValue retrieves the value of the leaf Value from the Component_Property
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *Component_Property) GetValue() Component_Property_Value_Union {
	if t == nil || t.Value == nil {
		return nil
	}
	return t.Value
}

// ΛListKeyMap returns the keys of the Component_Property struct, which is a YANG list entry.
func (t *Component_Property) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Property) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Property"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Property) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Property) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Property.
func (*Component_Property) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Property_Value_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-platform/components/component/properties/property/config/value within the YANG schema.
type Component_Property_Value_Union interface {
	Is_Component_Property_Value_Union()
}

// Component_Property_Value_Union_Bool is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a bool value.
type Component_Property_Value_Union_Bool struct {
	Bool bool
}

// Is_Component_Property_Value_Union ensures that Component_Property_Value_Union_Bool
// implements the Component_Property_Value_Union interface.
func (*Component_Property_Value_Union_Bool) Is_Component_Property_Value_Union() {}

// Component_Property_Value_Union_Float64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a float64 value.
type Component_Property_Value_Union_Float64 struct {
	Float64 float64
}

// Is_Component_Property_Value_Union ensures that Component_Property_Value_Union_Float64
// implements the Component_Property_Value_Union interface.
func (*Component_Property_Value_Union_Float64) Is_Component_Property_Value_Union() {}

// Component_Property_Value_Union_Int64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a int64 value.
type Component_Property_Value_Union_Int64 struct {
	Int64 int64
}

// Is_Component_Property_Value_Union ensures that Component_Property_Value_Union_Int64
// implements the Component_Property_Value_Union interface.
func (*Component_Property_Value_Union_Int64) Is_Component_Property_Value_Union() {}

// Component_Property_Value_Union_String is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a string value.
type Component_Property_Value_Union_String struct {
	String string
}

// Is_Component_Property_Value_Union ensures that Component_Property_Value_Union_String
// implements the Component_Property_Value_Union interface.
func (*Component_Property_Value_Union_String) Is_Component_Property_Value_Union() {}

// Component_Property_Value_Union_Uint64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a uint64 value.
type Component_Property_Value_Union_Uint64 struct {
	Uint64 uint64
}

// Is_Component_Property_Value_Union ensures that Component_Property_Value_Union_Uint64
// implements the Component_Property_Value_Union interface.
func (*Component_Property_Value_Union_Uint64) Is_Component_Property_Value_Union() {}

// To_Component_Property_Value_Union takes an input interface{} and attempts to convert it to a struct
// which implements the Component_Property_Value_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *Component_Property) To_Component_Property_Value_Union(i interface{}) (Component_Property_Value_Union, error) {
	switch v := i.(type) {
	case bool:
		return &Component_Property_Value_Union_Bool{v}, nil
	case float64:
		return &Component_Property_Value_Union_Float64{v}, nil
	case int64:
		return &Component_Property_Value_Union_Int64{v}, nil
	case string:
		return &Component_Property_Value_Union_String{v}, nil
	case uint64:
		return &Component_Property_Value_Union_Uint64{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to Component_Property_Value_Union, unknown union type, got: %T, want any of [bool, float64, int64, string, uint64]", i, i)
	}
}

// Component_SoftwareModule represents the /openconfig-platform/components/component/software-module YANG schema element.
type Component_SoftwareModule struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_SoftwareModule implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_SoftwareModule) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_SoftwareModule) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_SoftwareModule"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_SoftwareModule) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_SoftwareModule) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_SoftwareModule.
func (*Component_SoftwareModule) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Storage represents the /openconfig-platform/components/component/storage YANG schema element.
type Component_Storage struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Storage implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Storage) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Storage) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Storage"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Storage) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Storage) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Storage.
func (*Component_Storage) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Subcomponent represents the /openconfig-platform/components/component/subcomponents/subcomponent YANG schema element.
type Component_Subcomponent struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Name      *string           `path:"config/name|name" module:"openconfig-platform/openconfig-platform|openconfig-platform"`
	ΛName     []ygot.Annotation `path:"config/@name|@name" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Subcomponent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Subcomponent) IsYANGGoStruct() {}

// GetName retrieves the value of the leaf Name from the Component_Subcomponent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *Component_Subcomponent) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// ΛListKeyMap returns the keys of the Component_Subcomponent struct, which is a YANG list entry.
func (t *Component_Subcomponent) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Subcomponent) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Subcomponent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Subcomponent) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Subcomponent) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Subcomponent.
func (*Component_Subcomponent) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Temperature represents the /openconfig-platform/components/component/state/temperature YANG schema element.
type Component_Temperature struct {
	ΛMetadata       []ygot.Annotation                      `path:"@" ygotAnnotation:"true"`
	AlarmSeverity   E_AlarmTypes_OPENCONFIG_ALARM_SEVERITY `path:"alarm-severity" module:"openconfig-platform"`
	ΛAlarmSeverity  []ygot.Annotation                      `path:"@alarm-severity" ygotAnnotation:"true"`
	AlarmStatus     *bool                                  `path:"alarm-status" module:"openconfig-platform"`
	ΛAlarmStatus    []ygot.Annotation                      `path:"@alarm-status" ygotAnnotation:"true"`
	AlarmThreshold  *uint32                                `path:"alarm-threshold" module:"openconfig-platform"`
	ΛAlarmThreshold []ygot.Annotation                      `path:"@alarm-threshold" ygotAnnotation:"true"`
	Avg             *float64                               `path:"avg" module:"openconfig-platform"`
	ΛAvg            []ygot.Annotation                      `path:"@avg" ygotAnnotation:"true"`
	Instant         *float64                               `path:"instant" module:"openconfig-platform"`
	ΛInstant        []ygot.Annotation                      `path:"@instant" ygotAnnotation:"true"`
	Interval        *uint64                                `path:"interval" module:"openconfig-platform"`
	ΛInterval       []ygot.Annotation                      `path:"@interval" ygotAnnotation:"true"`
	Max             *float64                               `path:"max" module:"openconfig-platform"`
	ΛMax            []ygot.Annotation                      `path:"@max" ygotAnnotation:"true"`
	MaxTime         *uint64                                `path:"max-time" module:"openconfig-platform"`
	ΛMaxTime        []ygot.Annotation                      `path:"@max-time" ygotAnnotation:"true"`
	Min             *float64                               `path:"min" module:"openconfig-platform"`
	ΛMin            []ygot.Annotation                      `path:"@min" ygotAnnotation:"true"`
	MinTime         *uint64                                `path:"min-time" module:"openconfig-platform"`
	ΛMinTime        []ygot.Annotation                      `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Temperature implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Temperature) IsYANGGoStruct() {}

// GetAlarmSeverity retrieves the value of the leaf AlarmSeverity from the Component_Temperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AlarmSeverity is set, it can
// safely use t.GetAlarmSeverity() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AlarmSeverity == nil' before retrieving the leaf's value.
func (t *Component_Temperature) GetAlarmSeverity() E_AlarmTypes_OPENCONFIG_ALARM_SEVERITY {
	if t == nil || t.AlarmSeverity == 0 {
		return 0
	}
	return t.AlarmSeverity
}

// GetAlarmStatus retrieves the value of the leaf AlarmStatus from the Component_Temperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AlarmStatus is set, it can
// safely use t.GetAlarmStatus() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AlarmStatus == nil' before retrieving the leaf's value.
func (t *Component_Temperature) GetAlarmStatus() bool {
	if t == nil || t.AlarmStatus == nil {
		return false
	}
	return *t.AlarmStatus
}

// GetAlarmThreshold retrieves the value of the leaf AlarmThreshold from the Component_Temperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AlarmThreshold is set, it can
// safely use t.GetAlarmThreshold() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AlarmThreshold == nil' before retrieving the leaf's value.
func (t *Component_Temperature) GetAlarmThreshold() uint32 {
	if t == nil || t.AlarmThreshold == nil {
		return 0
	}
	return *t.AlarmThreshold
}

// GetAvg retrieves the value of the leaf Avg from the Component_Temperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Temperature) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Temperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Temperature) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Temperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Temperature) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Temperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Temperature) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Temperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Temperature) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Temperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Temperature) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Temperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Temperature) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Temperature) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Temperature"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Temperature) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Temperature) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Temperature.
func (*Component_Temperature) ΛBelongingModule() string {
	return "openconfig-platform"
}

// Component_Transceiver represents the /openconfig-platform/components/component/transceiver YANG schema element.
type Component_Transceiver struct {
	ΛMetadata               []ygot.Annotation                                   `path:"@" ygotAnnotation:"true"`
	Channel                 map[uint16]*Component_Transceiver_Channel           `path:"physical-channels/channel" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛChannel                []ygot.Annotation                                   `path:"physical-channels/@channel" ygotAnnotation:"true"`
	ConnectorType           E_TransportTypes_FIBER_CONNECTOR_TYPE               `path:"state/connector-type" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛConnectorType          []ygot.Annotation                                   `path:"state/@connector-type" ygotAnnotation:"true"`
	DateCode                *string                                             `path:"state/date-code" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛDateCode               []ygot.Annotation                                   `path:"state/@date-code" ygotAnnotation:"true"`
	Enabled                 *bool                                               `path:"config/enabled" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛEnabled                []ygot.Annotation                                   `path:"config/@enabled" ygotAnnotation:"true"`
	EthernetPmd             E_TransportTypes_ETHERNET_PMD_TYPE                  `path:"state/ethernet-pmd" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛEthernetPmd            []ygot.Annotation                                   `path:"state/@ethernet-pmd" ygotAnnotation:"true"`
	EthernetPmdPreconf      E_TransportTypes_ETHERNET_PMD_TYPE                  `path:"config/ethernet-pmd-preconf" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛEthernetPmdPreconf     []ygot.Annotation                                   `path:"config/@ethernet-pmd-preconf" ygotAnnotation:"true"`
	FaultCondition          *bool                                               `path:"state/fault-condition" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛFaultCondition         []ygot.Annotation                                   `path:"state/@fault-condition" ygotAnnotation:"true"`
	FecCorrectedBits        *uint64                                             `path:"state/fec-corrected-bits" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛFecCorrectedBits       []ygot.Annotation                                   `path:"state/@fec-corrected-bits" ygotAnnotation:"true"`
	FecCorrectedBytes       *uint64                                             `path:"state/fec-corrected-bytes" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛFecCorrectedBytes      []ygot.Annotation                                   `path:"state/@fec-corrected-bytes" ygotAnnotation:"true"`
	FecMode                 E_PlatformTypes_FEC_MODE_TYPE                       `path:"config/fec-mode" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛFecMode                []ygot.Annotation                                   `path:"config/@fec-mode" ygotAnnotation:"true"`
	FecStatus               E_PlatformTypes_FEC_STATUS_TYPE                     `path:"state/fec-status" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛFecStatus              []ygot.Annotation                                   `path:"state/@fec-status" ygotAnnotation:"true"`
	FecUncorrectableBlocks  *uint64                                             `path:"state/fec-uncorrectable-blocks" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛFecUncorrectableBlocks []ygot.Annotation                                   `path:"state/@fec-uncorrectable-blocks" ygotAnnotation:"true"`
	FecUncorrectableWords   *uint64                                             `path:"state/fec-uncorrectable-words" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛFecUncorrectableWords  []ygot.Annotation                                   `path:"state/@fec-uncorrectable-words" ygotAnnotation:"true"`
	FormFactor              E_TransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE       `path:"state/form-factor" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛFormFactor             []ygot.Annotation                                   `path:"state/@form-factor" ygotAnnotation:"true"`
	FormFactorPreconf       E_TransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE       `path:"config/form-factor-preconf" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛFormFactorPreconf      []ygot.Annotation                                   `path:"config/@form-factor-preconf" ygotAnnotation:"true"`
	InputPower              *Component_Transceiver_InputPower                   `path:"state/input-power" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛInputPower             []ygot.Annotation                                   `path:"state/@input-power" ygotAnnotation:"true"`
	LaserBiasCurrent        *Component_Transceiver_LaserBiasCurrent             `path:"state/laser-bias-current" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛLaserBiasCurrent       []ygot.Annotation                                   `path:"state/@laser-bias-current" ygotAnnotation:"true"`
	ModuleFunctionalType    E_TransportTypes_TRANSCEIVER_MODULE_FUNCTIONAL_TYPE `path:"config/module-functional-type" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛModuleFunctionalType   []ygot.Annotation                                   `path:"config/@module-functional-type" ygotAnnotation:"true"`
	OtnComplianceCode       E_TransportTypes_OTN_APPLICATION_CODE               `path:"state/otn-compliance-code" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛOtnComplianceCode      []ygot.Annotation                                   `path:"state/@otn-compliance-code" ygotAnnotation:"true"`
	OutputPower             *Component_Transceiver_OutputPower                  `path:"state/output-power" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛOutputPower            []ygot.Annotation                                   `path:"state/@output-power" ygotAnnotation:"true"`
	PostFecBer              *Component_Transceiver_PostFecBer                   `path:"state/post-fec-ber" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛPostFecBer             []ygot.Annotation                                   `path:"state/@post-fec-ber" ygotAnnotation:"true"`
	PreFecBer               *Component_Transceiver_PreFecBer                    `path:"state/pre-fec-ber" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛPreFecBer              []ygot.Annotation                                   `path:"state/@pre-fec-ber" ygotAnnotation:"true"`
	Present                 E_Transceiver_Present                               `path:"state/present" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛPresent                []ygot.Annotation                                   `path:"state/@present" ygotAnnotation:"true"`
	SerialNo                *string                                             `path:"state/serial-no" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛSerialNo               []ygot.Annotation                                   `path:"state/@serial-no" ygotAnnotation:"true"`
	SonetSdhComplianceCode  E_TransportTypes_SONET_APPLICATION_CODE             `path:"state/sonet-sdh-compliance-code" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛSonetSdhComplianceCode []ygot.Annotation                                   `path:"state/@sonet-sdh-compliance-code" ygotAnnotation:"true"`
	SupplyVoltage           *Component_Transceiver_SupplyVoltage                `path:"state/supply-voltage" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛSupplyVoltage          []ygot.Annotation                                   `path:"state/@supply-voltage" ygotAnnotation:"true"`
	Vendor                  *string                                             `path:"state/vendor" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛVendor                 []ygot.Annotation                                   `path:"state/@vendor" ygotAnnotation:"true"`
	VendorPart              *string                                             `path:"state/vendor-part" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛVendorPart             []ygot.Annotation                                   `path:"state/@vendor-part" ygotAnnotation:"true"`
	VendorRev               *string                                             `path:"state/vendor-rev" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛVendorRev              []ygot.Annotation                                   `path:"state/@vendor-rev" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver) IsYANGGoStruct() {}

// NewChannel creates a new entry in the Channel list of the
// Component_Transceiver struct. The keys of the list are populated from the input
// arguments.
func (t *Component_Transceiver) NewChannel(Index uint16) (*Component_Transceiver_Channel, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Channel == nil {
		t.Channel = make(map[uint16]*Component_Transceiver_Channel)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Channel[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Channel", key)
	}

	t.Channel[key] = &Component_Transceiver_Channel{
		Index: &Index,
	}

	return t.Channel[key], nil
}

// RenameChannel renames an entry in the list Channel within
// the Component_Transceiver struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Component_Transceiver) RenameChannel(oldK, newK uint16) error {
	if _, ok := t.Channel[newK]; ok {
		return fmt.Errorf("key %v already exists in Channel", newK)
	}

	e, ok := t.Channel[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Channel", oldK)
	}
	e.Index = &newK

	t.Channel[newK] = e
	delete(t.Channel, oldK)
	return nil
}

// GetOrCreateChannel retrieves the value with the specified keys from
// the receiver Component_Transceiver. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Component_Transceiver) GetOrCreateChannel(Index uint16) *Component_Transceiver_Channel {

	key := Index

	if v, ok := t.Channel[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewChannel(Index)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateChannel got unexpected error: %v", err))
	}
	return v
}

// GetChannel retrieves the value with the specified key from
// the Channel map field of Component_Transceiver. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Component_Transceiver) GetChannel(Index uint16) *Component_Transceiver_Channel {

	if t == nil {
		return nil
	}

	key := Index

	if lm, ok := t.Channel[key]; ok {
		return lm
	}
	return nil
}

// AppendChannel appends the supplied Component_Transceiver_Channel struct to the
// list Channel of Component_Transceiver. If the key value(s) specified in
// the supplied Component_Transceiver_Channel already exist in the list, an error is
// returned.
func (t *Component_Transceiver) AppendChannel(v *Component_Transceiver_Channel) error {
	if v.Index == nil {
		return fmt.Errorf("invalid nil key received for Index")
	}

	key := *v.Index

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Channel == nil {
		t.Channel = make(map[uint16]*Component_Transceiver_Channel)
	}

	if _, ok := t.Channel[key]; ok {
		return fmt.Errorf("duplicate key for list Channel %v", key)
	}

	t.Channel[key] = v
	return nil
}

// GetOrCreateInputPower retrieves the value of the InputPower field
// or returns the existing field if it already exists.
func (t *Component_Transceiver) GetOrCreateInputPower() *Component_Transceiver_InputPower {
	if t.InputPower != nil {
		return t.InputPower
	}
	t.InputPower = &Component_Transceiver_InputPower{}
	return t.InputPower
}

// GetOrCreateLaserBiasCurrent retrieves the value of the LaserBiasCurrent field
// or returns the existing field if it already exists.
func (t *Component_Transceiver) GetOrCreateLaserBiasCurrent() *Component_Transceiver_LaserBiasCurrent {
	if t.LaserBiasCurrent != nil {
		return t.LaserBiasCurrent
	}
	t.LaserBiasCurrent = &Component_Transceiver_LaserBiasCurrent{}
	return t.LaserBiasCurrent
}

// GetOrCreateOutputPower retrieves the value of the OutputPower field
// or returns the existing field if it already exists.
func (t *Component_Transceiver) GetOrCreateOutputPower() *Component_Transceiver_OutputPower {
	if t.OutputPower != nil {
		return t.OutputPower
	}
	t.OutputPower = &Component_Transceiver_OutputPower{}
	return t.OutputPower
}

// GetOrCreatePostFecBer retrieves the value of the PostFecBer field
// or returns the existing field if it already exists.
func (t *Component_Transceiver) GetOrCreatePostFecBer() *Component_Transceiver_PostFecBer {
	if t.PostFecBer != nil {
		return t.PostFecBer
	}
	t.PostFecBer = &Component_Transceiver_PostFecBer{}
	return t.PostFecBer
}

// GetOrCreatePreFecBer retrieves the value of the PreFecBer field
// or returns the existing field if it already exists.
func (t *Component_Transceiver) GetOrCreatePreFecBer() *Component_Transceiver_PreFecBer {
	if t.PreFecBer != nil {
		return t.PreFecBer
	}
	t.PreFecBer = &Component_Transceiver_PreFecBer{}
	return t.PreFecBer
}

// GetOrCreateSupplyVoltage retrieves the value of the SupplyVoltage field
// or returns the existing field if it already exists.
func (t *Component_Transceiver) GetOrCreateSupplyVoltage() *Component_Transceiver_SupplyVoltage {
	if t.SupplyVoltage != nil {
		return t.SupplyVoltage
	}
	t.SupplyVoltage = &Component_Transceiver_SupplyVoltage{}
	return t.SupplyVoltage
}

// GetInputPower returns the value of the InputPower struct pointer
// from Component_Transceiver. If the receiver or the field InputPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver) GetInputPower() *Component_Transceiver_InputPower {
	if t != nil && t.InputPower != nil {
		return t.InputPower
	}
	return nil
}

// GetLaserBiasCurrent returns the value of the LaserBiasCurrent struct pointer
// from Component_Transceiver. If the receiver or the field LaserBiasCurrent is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver) GetLaserBiasCurrent() *Component_Transceiver_LaserBiasCurrent {
	if t != nil && t.LaserBiasCurrent != nil {
		return t.LaserBiasCurrent
	}
	return nil
}

// GetOutputPower returns the value of the OutputPower struct pointer
// from Component_Transceiver. If the receiver or the field OutputPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver) GetOutputPower() *Component_Transceiver_OutputPower {
	if t != nil && t.OutputPower != nil {
		return t.OutputPower
	}
	return nil
}

// GetPostFecBer returns the value of the PostFecBer struct pointer
// from Component_Transceiver. If the receiver or the field PostFecBer is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver) GetPostFecBer() *Component_Transceiver_PostFecBer {
	if t != nil && t.PostFecBer != nil {
		return t.PostFecBer
	}
	return nil
}

// GetPreFecBer returns the value of the PreFecBer struct pointer
// from Component_Transceiver. If the receiver or the field PreFecBer is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver) GetPreFecBer() *Component_Transceiver_PreFecBer {
	if t != nil && t.PreFecBer != nil {
		return t.PreFecBer
	}
	return nil
}

// GetSupplyVoltage returns the value of the SupplyVoltage struct pointer
// from Component_Transceiver. If the receiver or the field SupplyVoltage is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver) GetSupplyVoltage() *Component_Transceiver_SupplyVoltage {
	if t != nil && t.SupplyVoltage != nil {
		return t.SupplyVoltage
	}
	return nil
}

// GetConnectorType retrieves the value of the leaf ConnectorType from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ConnectorType is set, it can
// safely use t.GetConnectorType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ConnectorType == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetConnectorType() E_TransportTypes_FIBER_CONNECTOR_TYPE {
	if t == nil || t.ConnectorType == 0 {
		return 0
	}
	return t.ConnectorType
}

// GetDateCode retrieves the value of the leaf DateCode from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if DateCode is set, it can
// safely use t.GetDateCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.DateCode == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetDateCode() string {
	if t == nil || t.DateCode == nil {
		return ""
	}
	return *t.DateCode
}

// GetEnabled retrieves the value of the leaf Enabled from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return false
	}
	return *t.Enabled
}

// GetEthernetPmd retrieves the value of the leaf EthernetPmd from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EthernetPmd is set, it can
// safely use t.GetEthernetPmd() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EthernetPmd == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetEthernetPmd() E_TransportTypes_ETHERNET_PMD_TYPE {
	if t == nil || t.EthernetPmd == 0 {
		return 0
	}
	return t.EthernetPmd
}

// GetEthernetPmdPreconf retrieves the value of the leaf EthernetPmdPreconf from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if EthernetPmdPreconf is set, it can
// safely use t.GetEthernetPmdPreconf() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.EthernetPmdPreconf == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetEthernetPmdPreconf() E_TransportTypes_ETHERNET_PMD_TYPE {
	if t == nil || t.EthernetPmdPreconf == 0 {
		return 0
	}
	return t.EthernetPmdPreconf
}

// GetFaultCondition retrieves the value of the leaf FaultCondition from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FaultCondition is set, it can
// safely use t.GetFaultCondition() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FaultCondition == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetFaultCondition() bool {
	if t == nil || t.FaultCondition == nil {
		return false
	}
	return *t.FaultCondition
}

// GetFecCorrectedBits retrieves the value of the leaf FecCorrectedBits from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FecCorrectedBits is set, it can
// safely use t.GetFecCorrectedBits() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FecCorrectedBits == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetFecCorrectedBits() uint64 {
	if t == nil || t.FecCorrectedBits == nil {
		return 0
	}
	return *t.FecCorrectedBits
}

// GetFecCorrectedBytes retrieves the value of the leaf FecCorrectedBytes from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FecCorrectedBytes is set, it can
// safely use t.GetFecCorrectedBytes() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FecCorrectedBytes == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetFecCorrectedBytes() uint64 {
	if t == nil || t.FecCorrectedBytes == nil {
		return 0
	}
	return *t.FecCorrectedBytes
}

// GetFecMode retrieves the value of the leaf FecMode from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FecMode is set, it can
// safely use t.GetFecMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FecMode == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetFecMode() E_PlatformTypes_FEC_MODE_TYPE {
	if t == nil || t.FecMode == 0 {
		return 0
	}
	return t.FecMode
}

// GetFecStatus retrieves the value of the leaf FecStatus from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FecStatus is set, it can
// safely use t.GetFecStatus() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FecStatus == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetFecStatus() E_PlatformTypes_FEC_STATUS_TYPE {
	if t == nil || t.FecStatus == 0 {
		return 0
	}
	return t.FecStatus
}

// GetFecUncorrectableBlocks retrieves the value of the leaf FecUncorrectableBlocks from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FecUncorrectableBlocks is set, it can
// safely use t.GetFecUncorrectableBlocks() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FecUncorrectableBlocks == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetFecUncorrectableBlocks() uint64 {
	if t == nil || t.FecUncorrectableBlocks == nil {
		return 0
	}
	return *t.FecUncorrectableBlocks
}

// GetFecUncorrectableWords retrieves the value of the leaf FecUncorrectableWords from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FecUncorrectableWords is set, it can
// safely use t.GetFecUncorrectableWords() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FecUncorrectableWords == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetFecUncorrectableWords() uint64 {
	if t == nil || t.FecUncorrectableWords == nil {
		return 0
	}
	return *t.FecUncorrectableWords
}

// GetFormFactor retrieves the value of the leaf FormFactor from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FormFactor is set, it can
// safely use t.GetFormFactor() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FormFactor == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetFormFactor() E_TransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE {
	if t == nil || t.FormFactor == 0 {
		return 0
	}
	return t.FormFactor
}

// GetFormFactorPreconf retrieves the value of the leaf FormFactorPreconf from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if FormFactorPreconf is set, it can
// safely use t.GetFormFactorPreconf() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.FormFactorPreconf == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetFormFactorPreconf() E_TransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE {
	if t == nil || t.FormFactorPreconf == 0 {
		return 0
	}
	return t.FormFactorPreconf
}

// GetModuleFunctionalType retrieves the value of the leaf ModuleFunctionalType from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ModuleFunctionalType is set, it can
// safely use t.GetModuleFunctionalType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ModuleFunctionalType == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetModuleFunctionalType() E_TransportTypes_TRANSCEIVER_MODULE_FUNCTIONAL_TYPE {
	if t == nil || t.ModuleFunctionalType == 0 {
		return 0
	}
	return t.ModuleFunctionalType
}

// GetOtnComplianceCode retrieves the value of the leaf OtnComplianceCode from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OtnComplianceCode is set, it can
// safely use t.GetOtnComplianceCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OtnComplianceCode == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetOtnComplianceCode() E_TransportTypes_OTN_APPLICATION_CODE {
	if t == nil || t.OtnComplianceCode == 0 {
		return 0
	}
	return t.OtnComplianceCode
}

// GetPresent retrieves the value of the leaf Present from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Present is set, it can
// safely use t.GetPresent() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Present == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetPresent() E_Transceiver_Present {
	if t == nil || t.Present == 0 {
		return 0
	}
	return t.Present
}

// GetSerialNo retrieves the value of the leaf SerialNo from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SerialNo is set, it can
// safely use t.GetSerialNo() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SerialNo == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetSerialNo() string {
	if t == nil || t.SerialNo == nil {
		return ""
	}
	return *t.SerialNo
}

// GetSonetSdhComplianceCode retrieves the value of the leaf SonetSdhComplianceCode from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if SonetSdhComplianceCode is set, it can
// safely use t.GetSonetSdhComplianceCode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.SonetSdhComplianceCode == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetSonetSdhComplianceCode() E_TransportTypes_SONET_APPLICATION_CODE {
	if t == nil || t.SonetSdhComplianceCode == 0 {
		return 0
	}
	return t.SonetSdhComplianceCode
}

// GetVendor retrieves the value of the leaf Vendor from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Vendor is set, it can
// safely use t.GetVendor() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Vendor == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetVendor() string {
	if t == nil || t.Vendor == nil {
		return ""
	}
	return *t.Vendor
}

// GetVendorPart retrieves the value of the leaf VendorPart from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if VendorPart is set, it can
// safely use t.GetVendorPart() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.VendorPart == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetVendorPart() string {
	if t == nil || t.VendorPart == nil {
		return ""
	}
	return *t.VendorPart
}

// GetVendorRev retrieves the value of the leaf VendorRev from the Component_Transceiver
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if VendorRev is set, it can
// safely use t.GetVendorRev() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.VendorRev == nil' before retrieving the leaf's value.
func (t *Component_Transceiver) GetVendorRev() string {
	if t == nil || t.VendorRev == nil {
		return ""
	}
	return *t.VendorRev
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver.
func (*Component_Transceiver) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_Channel represents the /openconfig-platform/components/component/transceiver/physical-channels/channel YANG schema element.
type Component_Transceiver_Channel struct {
	ΛMetadata                 []ygot.Annotation                                       `path:"@" ygotAnnotation:"true"`
	AssociatedOpticalChannel  *string                                                 `path:"config/associated-optical-channel" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛAssociatedOpticalChannel []ygot.Annotation                                       `path:"config/@associated-optical-channel" ygotAnnotation:"true"`
	Description               *string                                                 `path:"config/description" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛDescription              []ygot.Annotation                                       `path:"config/@description" ygotAnnotation:"true"`
	Index                     *uint16                                                 `path:"config/index|index" module:"openconfig-platform-transceiver/openconfig-platform-transceiver|openconfig-platform-transceiver"`
	ΛIndex                    []ygot.Annotation                                       `path:"config/@index|@index" ygotAnnotation:"true"`
	InputPower                *Component_Transceiver_Channel_InputPower               `path:"state/input-power" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛInputPower               []ygot.Annotation                                       `path:"state/@input-power" ygotAnnotation:"true"`
	LaserAge                  *uint8                                                  `path:"state/laser-age" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛLaserAge                 []ygot.Annotation                                       `path:"state/@laser-age" ygotAnnotation:"true"`
	LaserBiasCurrent          *Component_Transceiver_Channel_LaserBiasCurrent         `path:"state/laser-bias-current" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛLaserBiasCurrent         []ygot.Annotation                                       `path:"state/@laser-bias-current" ygotAnnotation:"true"`
	LaserTemperature          *Component_Transceiver_Channel_LaserTemperature         `path:"state/laser-temperature" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛLaserTemperature         []ygot.Annotation                                       `path:"state/@laser-temperature" ygotAnnotation:"true"`
	OutputFrequency           *uint64                                                 `path:"state/output-frequency" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛOutputFrequency          []ygot.Annotation                                       `path:"state/@output-frequency" ygotAnnotation:"true"`
	OutputPower               *Component_Transceiver_Channel_OutputPower              `path:"state/output-power" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛOutputPower              []ygot.Annotation                                       `path:"state/@output-power" ygotAnnotation:"true"`
	TargetFrequencyDeviation  *Component_Transceiver_Channel_TargetFrequencyDeviation `path:"state/target-frequency-deviation" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛTargetFrequencyDeviation []ygot.Annotation                                       `path:"state/@target-frequency-deviation" ygotAnnotation:"true"`
	TargetOutputPower         *float64                                                `path:"config/target-output-power" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛTargetOutputPower        []ygot.Annotation                                       `path:"config/@target-output-power" ygotAnnotation:"true"`
	TecCurrent                *Component_Transceiver_Channel_TecCurrent               `path:"state/tec-current" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛTecCurrent               []ygot.Annotation                                       `path:"state/@tec-current" ygotAnnotation:"true"`
	TxLaser                   *bool                                                   `path:"config/tx-laser" module:"openconfig-platform-transceiver/openconfig-platform-transceiver"`
	ΛTxLaser                  []ygot.Annotation                                       `path:"config/@tx-laser" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_Channel implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_Channel) IsYANGGoStruct() {}

// GetOrCreateInputPower retrieves the value of the InputPower field
// or returns the existing field if it already exists.
func (t *Component_Transceiver_Channel) GetOrCreateInputPower() *Component_Transceiver_Channel_InputPower {
	if t.InputPower != nil {
		return t.InputPower
	}
	t.InputPower = &Component_Transceiver_Channel_InputPower{}
	return t.InputPower
}

// GetOrCreateLaserBiasCurrent retrieves the value of the LaserBiasCurrent field
// or returns the existing field if it already exists.
func (t *Component_Transceiver_Channel) GetOrCreateLaserBiasCurrent() *Component_Transceiver_Channel_LaserBiasCurrent {
	if t.LaserBiasCurrent != nil {
		return t.LaserBiasCurrent
	}
	t.LaserBiasCurrent = &Component_Transceiver_Channel_LaserBiasCurrent{}
	return t.LaserBiasCurrent
}

// GetOrCreateLaserTemperature retrieves the value of the LaserTemperature field
// or returns the existing field if it already exists.
func (t *Component_Transceiver_Channel) GetOrCreateLaserTemperature() *Component_Transceiver_Channel_LaserTemperature {
	if t.LaserTemperature != nil {
		return t.LaserTemperature
	}
	t.LaserTemperature = &Component_Transceiver_Channel_LaserTemperature{}
	return t.LaserTemperature
}

// GetOrCreateOutputPower retrieves the value of the OutputPower field
// or returns the existing field if it already exists.
func (t *Component_Transceiver_Channel) GetOrCreateOutputPower() *Component_Transceiver_Channel_OutputPower {
	if t.OutputPower != nil {
		return t.OutputPower
	}
	t.OutputPower = &Component_Transceiver_Channel_OutputPower{}
	return t.OutputPower
}

// GetOrCreateTargetFrequencyDeviation retrieves the value of the TargetFrequencyDeviation field
// or returns the existing field if it already exists.
func (t *Component_Transceiver_Channel) GetOrCreateTargetFrequencyDeviation() *Component_Transceiver_Channel_TargetFrequencyDeviation {
	if t.TargetFrequencyDeviation != nil {
		return t.TargetFrequencyDeviation
	}
	t.TargetFrequencyDeviation = &Component_Transceiver_Channel_TargetFrequencyDeviation{}
	return t.TargetFrequencyDeviation
}

// GetOrCreateTecCurrent retrieves the value of the TecCurrent field
// or returns the existing field if it already exists.
func (t *Component_Transceiver_Channel) GetOrCreateTecCurrent() *Component_Transceiver_Channel_TecCurrent {
	if t.TecCurrent != nil {
		return t.TecCurrent
	}
	t.TecCurrent = &Component_Transceiver_Channel_TecCurrent{}
	return t.TecCurrent
}

// GetInputPower returns the value of the InputPower struct pointer
// from Component_Transceiver_Channel. If the receiver or the field InputPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver_Channel) GetInputPower() *Component_Transceiver_Channel_InputPower {
	if t != nil && t.InputPower != nil {
		return t.InputPower
	}
	return nil
}

// GetLaserBiasCurrent returns the value of the LaserBiasCurrent struct pointer
// from Component_Transceiver_Channel. If the receiver or the field LaserBiasCurrent is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver_Channel) GetLaserBiasCurrent() *Component_Transceiver_Channel_LaserBiasCurrent {
	if t != nil && t.LaserBiasCurrent != nil {
		return t.LaserBiasCurrent
	}
	return nil
}

// GetLaserTemperature returns the value of the LaserTemperature struct pointer
// from Component_Transceiver_Channel. If the receiver or the field LaserTemperature is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver_Channel) GetLaserTemperature() *Component_Transceiver_Channel_LaserTemperature {
	if t != nil && t.LaserTemperature != nil {
		return t.LaserTemperature
	}
	return nil
}

// GetOutputPower returns the value of the OutputPower struct pointer
// from Component_Transceiver_Channel. If the receiver or the field OutputPower is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver_Channel) GetOutputPower() *Component_Transceiver_Channel_OutputPower {
	if t != nil && t.OutputPower != nil {
		return t.OutputPower
	}
	return nil
}

// GetTargetFrequencyDeviation returns the value of the TargetFrequencyDeviation struct pointer
// from Component_Transceiver_Channel. If the receiver or the field TargetFrequencyDeviation is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver_Channel) GetTargetFrequencyDeviation() *Component_Transceiver_Channel_TargetFrequencyDeviation {
	if t != nil && t.TargetFrequencyDeviation != nil {
		return t.TargetFrequencyDeviation
	}
	return nil
}

// GetTecCurrent returns the value of the TecCurrent struct pointer
// from Component_Transceiver_Channel. If the receiver or the field TecCurrent is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Component_Transceiver_Channel) GetTecCurrent() *Component_Transceiver_Channel_TecCurrent {
	if t != nil && t.TecCurrent != nil {
		return t.TecCurrent
	}
	return nil
}

// GetAssociatedOpticalChannel retrieves the value of the leaf AssociatedOpticalChannel from the Component_Transceiver_Channel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AssociatedOpticalChannel is set, it can
// safely use t.GetAssociatedOpticalChannel() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AssociatedOpticalChannel == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel) GetAssociatedOpticalChannel() string {
	if t == nil || t.AssociatedOpticalChannel == nil {
		return ""
	}
	return *t.AssociatedOpticalChannel
}

// GetDescription retrieves the value of the leaf Description from the Component_Transceiver_Channel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetIndex retrieves the value of the leaf Index from the Component_Transceiver_Channel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Index is set, it can
// safely use t.GetIndex() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Index == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel) GetIndex() uint16 {
	if t == nil || t.Index == nil {
		return 0
	}
	return *t.Index
}

// GetLaserAge retrieves the value of the leaf LaserAge from the Component_Transceiver_Channel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LaserAge is set, it can
// safely use t.GetLaserAge() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LaserAge == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel) GetLaserAge() uint8 {
	if t == nil || t.LaserAge == nil {
		return 0
	}
	return *t.LaserAge
}

// GetOutputFrequency retrieves the value of the leaf OutputFrequency from the Component_Transceiver_Channel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OutputFrequency is set, it can
// safely use t.GetOutputFrequency() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OutputFrequency == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel) GetOutputFrequency() uint64 {
	if t == nil || t.OutputFrequency == nil {
		return 0
	}
	return *t.OutputFrequency
}

// GetTargetOutputPower retrieves the value of the leaf TargetOutputPower from the Component_Transceiver_Channel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TargetOutputPower is set, it can
// safely use t.GetTargetOutputPower() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TargetOutputPower == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel) GetTargetOutputPower() float64 {
	if t == nil || t.TargetOutputPower == nil {
		return 0.0
	}
	return *t.TargetOutputPower
}

// GetTxLaser retrieves the value of the leaf TxLaser from the Component_Transceiver_Channel
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TxLaser is set, it can
// safely use t.GetTxLaser() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TxLaser == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel) GetTxLaser() bool {
	if t == nil || t.TxLaser == nil {
		return false
	}
	return *t.TxLaser
}

// ΛListKeyMap returns the keys of the Component_Transceiver_Channel struct, which is a YANG list entry.
func (t *Component_Transceiver_Channel) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_Channel"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_Channel) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_Channel.
func (*Component_Transceiver_Channel) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_Channel_InputPower represents the /openconfig-platform/components/component/transceiver/physical-channels/channel/state/input-power YANG schema element.
type Component_Transceiver_Channel_InputPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_Channel_InputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_Channel_InputPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_Channel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_InputPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_Channel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_InputPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_Channel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_InputPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_Channel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_InputPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_Channel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_InputPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_Channel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_InputPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_Channel_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_InputPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_InputPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_Channel_InputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_InputPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_Channel_InputPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_Channel_InputPower.
func (*Component_Transceiver_Channel_InputPower) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_Channel_LaserBiasCurrent represents the /openconfig-platform/components/component/transceiver/physical-channels/channel/state/laser-bias-current YANG schema element.
type Component_Transceiver_Channel_LaserBiasCurrent struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_Channel_LaserBiasCurrent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_Channel_LaserBiasCurrent) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_Channel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserBiasCurrent) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_Channel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserBiasCurrent) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_Channel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserBiasCurrent) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_Channel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserBiasCurrent) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_Channel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserBiasCurrent) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_Channel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserBiasCurrent) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_Channel_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserBiasCurrent) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_LaserBiasCurrent) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_Channel_LaserBiasCurrent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_LaserBiasCurrent) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_Channel_LaserBiasCurrent) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_Channel_LaserBiasCurrent.
func (*Component_Transceiver_Channel_LaserBiasCurrent) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_Channel_LaserTemperature represents the /openconfig-platform/components/component/transceiver/physical-channels/channel/state/laser-temperature YANG schema element.
type Component_Transceiver_Channel_LaserTemperature struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_Channel_LaserTemperature implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_Channel_LaserTemperature) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_Channel_LaserTemperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserTemperature) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_Channel_LaserTemperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserTemperature) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_Channel_LaserTemperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserTemperature) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_Channel_LaserTemperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserTemperature) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_Channel_LaserTemperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserTemperature) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_Channel_LaserTemperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserTemperature) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_Channel_LaserTemperature
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_LaserTemperature) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_LaserTemperature) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_Channel_LaserTemperature"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_LaserTemperature) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_Channel_LaserTemperature) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_Channel_LaserTemperature.
func (*Component_Transceiver_Channel_LaserTemperature) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_Channel_OutputPower represents the /openconfig-platform/components/component/transceiver/physical-channels/channel/state/output-power YANG schema element.
type Component_Transceiver_Channel_OutputPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_Channel_OutputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_Channel_OutputPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_Channel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_OutputPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_Channel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_OutputPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_Channel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_OutputPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_Channel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_OutputPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_Channel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_OutputPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_Channel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_OutputPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_Channel_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_OutputPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_OutputPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_Channel_OutputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_OutputPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_Channel_OutputPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_Channel_OutputPower.
func (*Component_Transceiver_Channel_OutputPower) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_Channel_TargetFrequencyDeviation represents the /openconfig-platform/components/component/transceiver/physical-channels/channel/state/target-frequency-deviation YANG schema element.
type Component_Transceiver_Channel_TargetFrequencyDeviation struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_Channel_TargetFrequencyDeviation implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_Channel_TargetFrequencyDeviation) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_Channel_TargetFrequencyDeviation
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TargetFrequencyDeviation) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_Channel_TargetFrequencyDeviation
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TargetFrequencyDeviation) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_Channel_TargetFrequencyDeviation
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TargetFrequencyDeviation) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_Channel_TargetFrequencyDeviation
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TargetFrequencyDeviation) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_Channel_TargetFrequencyDeviation
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TargetFrequencyDeviation) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_Channel_TargetFrequencyDeviation
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TargetFrequencyDeviation) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_Channel_TargetFrequencyDeviation
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TargetFrequencyDeviation) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_TargetFrequencyDeviation) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_Channel_TargetFrequencyDeviation"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_TargetFrequencyDeviation) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_Channel_TargetFrequencyDeviation) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_Channel_TargetFrequencyDeviation.
func (*Component_Transceiver_Channel_TargetFrequencyDeviation) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_Channel_TecCurrent represents the /openconfig-platform/components/component/transceiver/physical-channels/channel/state/tec-current YANG schema element.
type Component_Transceiver_Channel_TecCurrent struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_Channel_TecCurrent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_Channel_TecCurrent) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_Channel_TecCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TecCurrent) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_Channel_TecCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TecCurrent) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_Channel_TecCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TecCurrent) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_Channel_TecCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TecCurrent) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_Channel_TecCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TecCurrent) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_Channel_TecCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TecCurrent) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_Channel_TecCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_Channel_TecCurrent) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_TecCurrent) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_Channel_TecCurrent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_Channel_TecCurrent) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_Channel_TecCurrent) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_Channel_TecCurrent.
func (*Component_Transceiver_Channel_TecCurrent) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_InputPower represents the /openconfig-platform/components/component/transceiver/state/input-power YANG schema element.
type Component_Transceiver_InputPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_InputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_InputPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_InputPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_InputPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_InputPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_InputPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_InputPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_InputPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_InputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_InputPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_InputPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_InputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_InputPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_InputPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_InputPower.
func (*Component_Transceiver_InputPower) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_LaserBiasCurrent represents the /openconfig-platform/components/component/transceiver/state/laser-bias-current YANG schema element.
type Component_Transceiver_LaserBiasCurrent struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_LaserBiasCurrent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_LaserBiasCurrent) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_LaserBiasCurrent) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_LaserBiasCurrent) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_LaserBiasCurrent) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_LaserBiasCurrent) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_LaserBiasCurrent) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_LaserBiasCurrent) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_LaserBiasCurrent
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_LaserBiasCurrent) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_LaserBiasCurrent) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_LaserBiasCurrent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_LaserBiasCurrent) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_LaserBiasCurrent) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_LaserBiasCurrent.
func (*Component_Transceiver_LaserBiasCurrent) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_OutputPower represents the /openconfig-platform/components/component/transceiver/state/output-power YANG schema element.
type Component_Transceiver_OutputPower struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_OutputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_OutputPower) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_OutputPower) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_OutputPower) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_OutputPower) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_OutputPower) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_OutputPower) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_OutputPower) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_OutputPower
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_OutputPower) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_OutputPower) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_OutputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_OutputPower) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_OutputPower) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_OutputPower.
func (*Component_Transceiver_OutputPower) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_PostFecBer represents the /openconfig-platform/components/component/transceiver/state/post-fec-ber YANG schema element.
type Component_Transceiver_PostFecBer struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_PostFecBer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_PostFecBer) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PostFecBer) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PostFecBer) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PostFecBer) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PostFecBer) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PostFecBer) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PostFecBer) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_PostFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PostFecBer) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_PostFecBer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_PostFecBer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_PostFecBer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_PostFecBer) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_PostFecBer.
func (*Component_Transceiver_PostFecBer) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_PreFecBer represents the /openconfig-platform/components/component/transceiver/state/pre-fec-ber YANG schema element.
type Component_Transceiver_PreFecBer struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_PreFecBer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_PreFecBer) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PreFecBer) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PreFecBer) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PreFecBer) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PreFecBer) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PreFecBer) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PreFecBer) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_PreFecBer
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_PreFecBer) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_PreFecBer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_PreFecBer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_PreFecBer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_PreFecBer) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_PreFecBer.
func (*Component_Transceiver_PreFecBer) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Component_Transceiver_SupplyVoltage represents the /openconfig-platform/components/component/transceiver/state/supply-voltage YANG schema element.
type Component_Transceiver_SupplyVoltage struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Avg       *float64          `path:"avg" module:"openconfig-platform-transceiver"`
	ΛAvg      []ygot.Annotation `path:"@avg" ygotAnnotation:"true"`
	Instant   *float64          `path:"instant" module:"openconfig-platform-transceiver"`
	ΛInstant  []ygot.Annotation `path:"@instant" ygotAnnotation:"true"`
	Interval  *uint64           `path:"interval" module:"openconfig-platform-transceiver"`
	ΛInterval []ygot.Annotation `path:"@interval" ygotAnnotation:"true"`
	Max       *float64          `path:"max" module:"openconfig-platform-transceiver"`
	ΛMax      []ygot.Annotation `path:"@max" ygotAnnotation:"true"`
	MaxTime   *uint64           `path:"max-time" module:"openconfig-platform-transceiver"`
	ΛMaxTime  []ygot.Annotation `path:"@max-time" ygotAnnotation:"true"`
	Min       *float64          `path:"min" module:"openconfig-platform-transceiver"`
	ΛMin      []ygot.Annotation `path:"@min" ygotAnnotation:"true"`
	MinTime   *uint64           `path:"min-time" module:"openconfig-platform-transceiver"`
	ΛMinTime  []ygot.Annotation `path:"@min-time" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Component_Transceiver_SupplyVoltage implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Component_Transceiver_SupplyVoltage) IsYANGGoStruct() {}

// GetAvg retrieves the value of the leaf Avg from the Component_Transceiver_SupplyVoltage
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Avg is set, it can
// safely use t.GetAvg() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Avg == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_SupplyVoltage) GetAvg() float64 {
	if t == nil || t.Avg == nil {
		return 0.0
	}
	return *t.Avg
}

// GetInstant retrieves the value of the leaf Instant from the Component_Transceiver_SupplyVoltage
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Instant is set, it can
// safely use t.GetInstant() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Instant == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_SupplyVoltage) GetInstant() float64 {
	if t == nil || t.Instant == nil {
		return 0.0
	}
	return *t.Instant
}

// GetInterval retrieves the value of the leaf Interval from the Component_Transceiver_SupplyVoltage
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Interval is set, it can
// safely use t.GetInterval() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Interval == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_SupplyVoltage) GetInterval() uint64 {
	if t == nil || t.Interval == nil {
		return 0
	}
	return *t.Interval
}

// GetMax retrieves the value of the leaf Max from the Component_Transceiver_SupplyVoltage
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Max is set, it can
// safely use t.GetMax() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Max == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_SupplyVoltage) GetMax() float64 {
	if t == nil || t.Max == nil {
		return 0.0
	}
	return *t.Max
}

// GetMaxTime retrieves the value of the leaf MaxTime from the Component_Transceiver_SupplyVoltage
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MaxTime is set, it can
// safely use t.GetMaxTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MaxTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_SupplyVoltage) GetMaxTime() uint64 {
	if t == nil || t.MaxTime == nil {
		return 0
	}
	return *t.MaxTime
}

// GetMin retrieves the value of the leaf Min from the Component_Transceiver_SupplyVoltage
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Min is set, it can
// safely use t.GetMin() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Min == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_SupplyVoltage) GetMin() float64 {
	if t == nil || t.Min == nil {
		return 0.0
	}
	return *t.Min
}

// GetMinTime retrieves the value of the leaf MinTime from the Component_Transceiver_SupplyVoltage
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinTime is set, it can
// safely use t.GetMinTime() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinTime == nil' before retrieving the leaf's value.
func (t *Component_Transceiver_SupplyVoltage) GetMinTime() uint64 {
	if t == nil || t.MinTime == nil {
		return 0
	}
	return *t.MinTime
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_SupplyVoltage) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Component_Transceiver_SupplyVoltage"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Component_Transceiver_SupplyVoltage) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Component_Transceiver_SupplyVoltage) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Component_Transceiver_SupplyVoltage.
func (*Component_Transceiver_SupplyVoltage) ΛBelongingModule() string {
	return "openconfig-platform-transceiver"
}

// Device represents the /device YANG schema element.
type Device struct {
	ΛMetadata         []ygot.Annotation           `path:"@" ygotAnnotation:"true"`
	Acl               *Acl                        `path:"acl" module:"openconfig-acl"`
	ΛAcl              []ygot.Annotation           `path:"@acl" ygotAnnotation:"true"`
	Aps               *Aps                        `path:"aps" module:"openconfig-transport-line-protection"`
	ΛAps              []ygot.Annotation           `path:"@aps" ygotAnnotation:"true"`
	Bfd               *Bfd                        `path:"bfd" module:"openconfig-bfd"`
	ΛBfd              []ygot.Annotation           `path:"@bfd" ygotAnnotation:"true"`
	Component         map[string]*Component       `path:"components/component" module:"openconfig-platform/openconfig-platform"`
	ΛComponent        []ygot.Annotation           `path:"components/@component" ygotAnnotation:"true"`
	Interface         map[string]*Interface       `path:"interfaces/interface" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛInterface        []ygot.Annotation           `path:"interfaces/@interface" ygotAnnotation:"true"`
	Keychain          map[string]*Keychain        `path:"keychains/keychain" module:"openconfig-keychain/openconfig-keychain"`
	ΛKeychain         []ygot.Annotation           `path:"keychains/@keychain" ygotAnnotation:"true"`
	Lacp              *Lacp                       `path:"lacp" module:"openconfig-lacp"`
	ΛLacp             []ygot.Annotation           `path:"@lacp" ygotAnnotation:"true"`
	Lldp              *Lldp                       `path:"lldp" module:"openconfig-lldp"`
	ΛLldp             []ygot.Annotation           `path:"@lldp" ygotAnnotation:"true"`
	Messages          *Messages                   `path:"messages" module:"openconfig-messages"`
	ΛMessages         []ygot.Annotation           `path:"@messages" ygotAnnotation:"true"`
	NetworkInstance   map[string]*NetworkInstance `path:"network-instances/network-instance" module:"openconfig-network-instance/openconfig-network-instance"`
	ΛNetworkInstance  []ygot.Annotation           `path:"network-instances/@network-instance" ygotAnnotation:"true"`
	OpticalAmplifier  *OpticalAmplifier           `path:"optical-amplifier" module:"openconfig-optical-amplifier"`
	ΛOpticalAmplifier []ygot.Annotation           `path:"@optical-amplifier" ygotAnnotation:"true"`
	RelayAgent        *RelayAgent                 `path:"relay-agent" module:"openconfig-relay-agent"`
	ΛRelayAgent       []ygot.Annotation           `path:"@relay-agent" ygotAnnotation:"true"`
	RoutingPolicy     *RoutingPolicy              `path:"routing-policy" module:"openconfig-routing-policy"`
	ΛRoutingPolicy    []ygot.Annotation           `path:"@routing-policy" ygotAnnotation:"true"`
	Stp               *Stp                        `path:"stp" module:"openconfig-spanning-tree"`
	ΛStp              []ygot.Annotation           `path:"@stp" ygotAnnotation:"true"`
	System            *System                     `path:"system" module:"openconfig-system"`
	ΛSystem           []ygot.Annotation           `path:"@system" ygotAnnotation:"true"`
	TerminalDevice    *TerminalDevice             `path:"terminal-device" module:"openconfig-terminal-device"`
	ΛTerminalDevice   []ygot.Annotation           `path:"@terminal-device" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Device implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Device) IsYANGGoStruct() {}

// NewComponent creates a new entry in the Component list of the
// Device struct. The keys of the list are populated from the input
// arguments.
func (t *Device) NewComponent(Name string) (*Component, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Component == nil {
		t.Component = make(map[string]*Component)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Component[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Component", key)
	}

	t.Component[key] = &Component{
		Name: &Name,
	}

	return t.Component[key], nil
}

// RenameComponent renames an entry in the list Component within
// the Device struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Device) RenameComponent(oldK, newK string) error {
	if _, ok := t.Component[newK]; ok {
		return fmt.Errorf("key %v already exists in Component", newK)
	}

	e, ok := t.Component[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Component", oldK)
	}
	e.Name = &newK

	t.Component[newK] = e
	delete(t.Component, oldK)
	return nil
}

// GetOrCreateComponent retrieves the value with the specified keys from
// the receiver Device. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Device) GetOrCreateComponent(Name string) *Component {

	key := Name

	if v, ok := t.Component[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewComponent(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateComponent got unexpected error: %v", err))
	}
	return v
}

// GetComponent retrieves the value with the specified key from
// the Component map field of Device. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Device) GetComponent(Name string) *Component {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Component[key]; ok {
		return lm
	}
	return nil
}

// AppendComponent appends the supplied Component struct to the
// list Component of Device. If the key value(s) specified in
// the supplied Component already exist in the list, an error is
// returned.
func (t *Device) AppendComponent(v *Component) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Component == nil {
		t.Component = make(map[string]*Component)
	}

	if _, ok := t.Component[key]; ok {
		return fmt.Errorf("duplicate key for list Component %v", key)
	}

	t.Component[key] = v
	return nil
}

// NewInterface creates a new entry in the Interface list of the
// Device struct. The keys of the list are populated from the input
// arguments.
func (t *Device) NewInterface(Name string) (*Interface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// RenameInterface renames an entry in the list Interface within
// the Device struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Device) RenameInterface(oldK, newK string) error {
	if _, ok := t.Interface[newK]; ok {
		return fmt.Errorf("key %v already exists in Interface", newK)
	}

	e, ok := t.Interface[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Interface", oldK)
	}
	e.Name = &newK

	t.Interface[newK] = e
	delete(t.Interface, oldK)
	return nil
}

// GetOrCreateInterface retrieves the value with the specified keys from
// the receiver Device. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Device) GetOrCreateInterface(Name string) *Interface {

	key := Name

	if v, ok := t.Interface[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewInterface(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateInterface got unexpected error: %v", err))
	}
	return v
}

// GetInterface retrieves the value with the specified key from
// the Interface map field of Device. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Device) GetInterface(Name string) *Interface {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Interface[key]; ok {
		return lm
	}
	return nil
}

// AppendInterface appends the supplied Interface struct to the
// list Interface of Device. If the key value(s) specified in
// the supplied Interface already exist in the list, an error is
// returned.
func (t *Device) AppendInterface(v *Interface) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*Interface)
	}

	if _, ok := t.Interface[key]; ok {
		return fmt.Errorf("duplicate key for list Interface %v", key)
	}

	t.Interface[key] = v
	return nil
}

// NewKeychain creates a new entry in the Keychain list of the
// Device struct. The keys of the list are populated from the input
// arguments.
func (t *Device) NewKeychain(Name string) (*Keychain, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Keychain == nil {
		t.Keychain = make(map[string]*Keychain)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Keychain[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Keychain", key)
	}

	t.Keychain[key] = &Keychain{
		Name: &Name,
	}

	return t.Keychain[key], nil
}

// RenameKeychain renames an entry in the list Keychain within
// the Device struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Device) RenameKeychain(oldK, newK string) error {
	if _, ok := t.Keychain[newK]; ok {
		return fmt.Errorf("key %v already exists in Keychain", newK)
	}

	e, ok := t.Keychain[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Keychain", oldK)
	}
	e.Name = &newK

	t.Keychain[newK] = e
	delete(t.Keychain, oldK)
	return nil
}

// GetOrCreateKeychain retrieves the value with the specified keys from
// the receiver Device. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Device) GetOrCreateKeychain(Name string) *Keychain {

	key := Name

	if v, ok := t.Keychain[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewKeychain(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateKeychain got unexpected error: %v", err))
	}
	return v
}

// GetKeychain retrieves the value with the specified key from
// the Keychain map field of Device. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Device) GetKeychain(Name string) *Keychain {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.Keychain[key]; ok {
		return lm
	}
	return nil
}

// AppendKeychain appends the supplied Keychain struct to the
// list Keychain of Device. If the key value(s) specified in
// the supplied Keychain already exist in the list, an error is
// returned.
func (t *Device) AppendKeychain(v *Keychain) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Keychain == nil {
		t.Keychain = make(map[string]*Keychain)
	}

	if _, ok := t.Keychain[key]; ok {
		return fmt.Errorf("duplicate key for list Keychain %v", key)
	}

	t.Keychain[key] = v
	return nil
}

// NewNetworkInstance creates a new entry in the NetworkInstance list of the
// Device struct. The keys of the list are populated from the input
// arguments.
func (t *Device) NewNetworkInstance(Name string) (*NetworkInstance, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.NetworkInstance == nil {
		t.NetworkInstance = make(map[string]*NetworkInstance)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.NetworkInstance[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list NetworkInstance", key)
	}

	t.NetworkInstance[key] = &NetworkInstance{
		Name: &Name,
	}

	return t.NetworkInstance[key], nil
}

// RenameNetworkInstance renames an entry in the list NetworkInstance within
// the Device struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Device) RenameNetworkInstance(oldK, newK string) error {
	if _, ok := t.NetworkInstance[newK]; ok {
		return fmt.Errorf("key %v already exists in NetworkInstance", newK)
	}

	e, ok := t.NetworkInstance[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in NetworkInstance", oldK)
	}
	e.Name = &newK

	t.NetworkInstance[newK] = e
	delete(t.NetworkInstance, oldK)
	return nil
}

// GetOrCreateNetworkInstance retrieves the value with the specified keys from
// the receiver Device. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Device) GetOrCreateNetworkInstance(Name string) *NetworkInstance {

	key := Name

	if v, ok := t.NetworkInstance[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewNetworkInstance(Name)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateNetworkInstance got unexpected error: %v", err))
	}
	return v
}

// GetNetworkInstance retrieves the value with the specified key from
// the NetworkInstance map field of Device. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Device) GetNetworkInstance(Name string) *NetworkInstance {

	if t == nil {
		return nil
	}

	key := Name

	if lm, ok := t.NetworkInstance[key]; ok {
		return lm
	}
	return nil
}

// AppendNetworkInstance appends the supplied NetworkInstance struct to the
// list NetworkInstance of Device. If the key value(s) specified in
// the supplied NetworkInstance already exist in the list, an error is
// returned.
func (t *Device) AppendNetworkInstance(v *NetworkInstance) error {
	if v.Name == nil {
		return fmt.Errorf("invalid nil key received for Name")
	}

	key := *v.Name

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.NetworkInstance == nil {
		t.NetworkInstance = make(map[string]*NetworkInstance)
	}

	if _, ok := t.NetworkInstance[key]; ok {
		return fmt.Errorf("duplicate key for list NetworkInstance %v", key)
	}

	t.NetworkInstance[key] = v
	return nil
}

// GetOrCreateAcl retrieves the value of the Acl field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateAcl() *Acl {
	if t.Acl != nil {
		return t.Acl
	}
	t.Acl = &Acl{}
	return t.Acl
}

// GetOrCreateAps retrieves the value of the Aps field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateAps() *Aps {
	if t.Aps != nil {
		return t.Aps
	}
	t.Aps = &Aps{}
	return t.Aps
}

// GetOrCreateBfd retrieves the value of the Bfd field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateBfd() *Bfd {
	if t.Bfd != nil {
		return t.Bfd
	}
	t.Bfd = &Bfd{}
	return t.Bfd
}

// GetOrCreateLacp retrieves the value of the Lacp field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateLacp() *Lacp {
	if t.Lacp != nil {
		return t.Lacp
	}
	t.Lacp = &Lacp{}
	return t.Lacp
}

// GetOrCreateLldp retrieves the value of the Lldp field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateLldp() *Lldp {
	if t.Lldp != nil {
		return t.Lldp
	}
	t.Lldp = &Lldp{}
	return t.Lldp
}

// GetOrCreateMessages retrieves the value of the Messages field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateMessages() *Messages {
	if t.Messages != nil {
		return t.Messages
	}
	t.Messages = &Messages{}
	return t.Messages
}

// GetOrCreateOpticalAmplifier retrieves the value of the OpticalAmplifier field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateOpticalAmplifier() *OpticalAmplifier {
	if t.OpticalAmplifier != nil {
		return t.OpticalAmplifier
	}
	t.OpticalAmplifier = &OpticalAmplifier{}
	return t.OpticalAmplifier
}

// GetOrCreateRelayAgent retrieves the value of the RelayAgent field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateRelayAgent() *RelayAgent {
	if t.RelayAgent != nil {
		return t.RelayAgent
	}
	t.RelayAgent = &RelayAgent{}
	return t.RelayAgent
}

// GetOrCreateRoutingPolicy retrieves the value of the RoutingPolicy field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateRoutingPolicy() *RoutingPolicy {
	if t.RoutingPolicy != nil {
		return t.RoutingPolicy
	}
	t.RoutingPolicy = &RoutingPolicy{}
	return t.RoutingPolicy
}

// GetOrCreateStp retrieves the value of the Stp field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateStp() *Stp {
	if t.Stp != nil {
		return t.Stp
	}
	t.Stp = &Stp{}
	return t.Stp
}

// GetOrCreateSystem retrieves the value of the System field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateSystem() *System {
	if t.System != nil {
		return t.System
	}
	t.System = &System{}
	return t.System
}

// GetOrCreateTerminalDevice retrieves the value of the TerminalDevice field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateTerminalDevice() *TerminalDevice {
	if t.TerminalDevice != nil {
		return t.TerminalDevice
	}
	t.TerminalDevice = &TerminalDevice{}
	return t.TerminalDevice
}

// GetAcl returns the value of the Acl struct pointer
// from Device. If the receiver or the field Acl is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetAcl() *Acl {
	if t != nil && t.Acl != nil {
		return t.Acl
	}
	return nil
}

// GetAps returns the value of the Aps struct pointer
// from Device. If the receiver or the field Aps is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetAps() *Aps {
	if t != nil && t.Aps != nil {
		return t.Aps
	}
	return nil
}

// GetBfd returns the value of the Bfd struct pointer
// from Device. If the receiver or the field Bfd is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetBfd() *Bfd {
	if t != nil && t.Bfd != nil {
		return t.Bfd
	}
	return nil
}

// GetLacp returns the value of the Lacp struct pointer
// from Device. If the receiver or the field Lacp is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetLacp() *Lacp {
	if t != nil && t.Lacp != nil {
		return t.Lacp
	}
	return nil
}

// GetLldp returns the value of the Lldp struct pointer
// from Device. If the receiver or the field Lldp is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetLldp() *Lldp {
	if t != nil && t.Lldp != nil {
		return t.Lldp
	}
	return nil
}

// GetMessages returns the value of the Messages struct pointer
// from Device. If the receiver or the field Messages is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetMessages() *Messages {
	if t != nil && t.Messages != nil {
		return t.Messages
	}
	return nil
}

// GetOpticalAmplifier returns the value of the OpticalAmplifier struct pointer
// from Device. If the receiver or the field OpticalAmplifier is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetOpticalAmplifier() *OpticalAmplifier {
	if t != nil && t.OpticalAmplifier != nil {
		return t.OpticalAmplifier
	}
	return nil
}

// GetRelayAgent returns the value of the RelayAgent struct pointer
// from Device. If the receiver or the field RelayAgent is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetRelayAgent() *RelayAgent {
	if t != nil && t.RelayAgent != nil {
		return t.RelayAgent
	}
	return nil
}

// GetRoutingPolicy returns the value of the RoutingPolicy struct pointer
// from Device. If the receiver or the field RoutingPolicy is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetRoutingPolicy() *RoutingPolicy {
	if t != nil && t.RoutingPolicy != nil {
		return t.RoutingPolicy
	}
	return nil
}

// GetStp returns the value of the Stp struct pointer
// from Device. If the receiver or the field Stp is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetStp() *Stp {
	if t != nil && t.Stp != nil {
		return t.Stp
	}
	return nil
}

// GetSystem returns the value of the System struct pointer
// from Device. If the receiver or the field System is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetSystem() *System {
	if t != nil && t.System != nil {
		return t.System
	}
	return nil
}

// GetTerminalDevice returns the value of the TerminalDevice struct pointer
// from Device. If the receiver or the field TerminalDevice is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetTerminalDevice() *TerminalDevice {
	if t != nil && t.TerminalDevice != nil {
		return t.TerminalDevice
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Device"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Device) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Device.
func (*Device) ΛBelongingModule() string {
	return ""
}

// Interface represents the /openconfig-interfaces/interfaces/interface YANG schema element.
type Interface struct {
	ΛMetadata        []ygot.Annotation                  `path:"@" ygotAnnotation:"true"`
	AdminStatus      E_Interface_AdminStatus            `path:"state/admin-status" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛAdminStatus     []ygot.Annotation                  `path:"state/@admin-status" ygotAnnotation:"true"`
	Aggregation      *Interface_Aggregation             `path:"aggregation" module:"openconfig-if-aggregate"`
	ΛAggregation     []ygot.Annotation                  `path:"@aggregation" ygotAnnotation:"true"`
	Counters         *Interface_Counters                `path:"state/counters" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛCounters        []ygot.Annotation                  `path:"state/@counters" ygotAnnotation:"true"`
	Cpu              *bool                              `path:"state/cpu" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛCpu             []ygot.Annotation                  `path:"state/@cpu" ygotAnnotation:"true"`
	Description      *string                            `path:"config/description" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛDescription     []ygot.Annotation                  `path:"config/@description" ygotAnnotation:"true"`
	Enabled          *bool                              `path:"config/enabled" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛEnabled         []ygot.Annotation                  `path:"config/@enabled" ygotAnnotation:"true"`
	Ethernet         *Interface_Ethernet                `path:"ethernet" module:"openconfig-if-ethernet"`
	ΛEthernet        []ygot.Annotation                  `path:"@ethernet" ygotAnnotation:"true"`
	HardwarePort     *string                            `path:"state/hardware-port" module:"openconfig-interfaces/openconfig-platform-port"`
	ΛHardwarePort    []ygot.Annotation                  `path:"state/@hardware-port" ygotAnnotation:"true"`
	HoldTime         *Interface_HoldTime                `path:"hold-time" module:"openconfig-interfaces"`
	ΛHoldTime        []ygot.Annotation                  `path:"@hold-time" ygotAnnotation:"true"`
	Ifindex          *uint32                            `path:"state/ifindex" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛIfindex         []ygot.Annotation                  `path:"state/@ifindex" ygotAnnotation:"true"`
	LastChange       *uint64                            `path:"state/last-change" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛLastChange      []ygot.Annotation                  `path:"state/@last-change" ygotAnnotation:"true"`
	Logical          *bool                              `path:"state/logical" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛLogical         []ygot.Annotation                  `path:"state/@logical" ygotAnnotation:"true"`
	LoopbackMode     *bool                              `path:"config/loopback-mode" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛLoopbackMode    []ygot.Annotation                  `path:"config/@loopback-mode" ygotAnnotation:"true"`
	Management       *bool                              `path:"state/management" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛManagement      []ygot.Annotation                  `path:"state/@management" ygotAnnotation:"true"`
	Mtu              *uint16                            `path:"config/mtu" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛMtu             []ygot.Annotation                  `path:"config/@mtu" ygotAnnotation:"true"`
	Name             *string                            `path:"config/name|name" module:"openconfig-interfaces/openconfig-interfaces|openconfig-interfaces"`
	ΛName            []ygot.Annotation                  `path:"config/@name|@name" ygotAnnotation:"true"`
	OperStatus       E_Interface_OperStatus             `path:"state/oper-status" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛOperStatus      []ygot.Annotation                  `path:"state/@oper-status" ygotAnnotation:"true"`
	PhysicalChannel  []uint16                           `path:"state/physical-channel" module:"openconfig-interfaces/openconfig-platform-transceiver"`
	ΛPhysicalChannel []ygot.Annotation                  `path:"state/@physical-channel" ygotAnnotation:"true"`
	RoutedVlan       *Interface_RoutedVlan              `path:"routed-vlan" module:"openconfig-vlan"`
	ΛRoutedVlan      []ygot.Annotation                  `path:"@routed-vlan" ygotAnnotation:"true"`
	Sonet            *Interface_Sonet                   `path:"sonet" module:"openconfig-transport-line-common"`
	ΛSonet           []ygot.Annotation                  `path:"@sonet" ygotAnnotation:"true"`
	Subinterface     map[uint32]*Interface_Subinterface `path:"subinterfaces/subinterface" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛSubinterface    []ygot.Annotation                  `path:"subinterfaces/@subinterface" ygotAnnotation:"true"`
	Tpid             E_VlanTypes_TPID_TYPES             `path:"config/tpid" module:"openconfig-interfaces/openconfig-vlan"`
	ΛTpid            []ygot.Annotation                  `path:"config/@tpid" ygotAnnotation:"true"`
	Transceiver      *string                            `path:"state/transceiver" module:"openconfig-interfaces/openconfig-platform-transceiver"`
	ΛTransceiver     []ygot.Annotation                  `path:"state/@transceiver" ygotAnnotation:"true"`
	Type             E_IETFInterfaces_InterfaceType     `path:"config/type" module:"openconfig-interfaces/openconfig-interfaces"`
	ΛType            []ygot.Annotation                  `path:"config/@type" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Interface) IsYANGGoStruct() {}

// NewSubinterface creates a new entry in the Subinterface list of the
// Interface struct. The keys of the list are populated from the input
// arguments.
func (t *Interface) NewSubinterface(Index uint32) (*Interface_Subinterface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subinterface == nil {
		t.Subinterface = make(map[uint32]*Interface_Subinterface)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Subinterface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Subinterface", key)
	}

	t.Subinterface[key] = &Interface_Subinterface{
		Index: &Index,
	}

	return t.Subinterface[key], nil
}

// RenameSubinterface renames an entry in the list Subinterface within
// the Interface struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Interface) RenameSubinterface(oldK, newK uint32) error {
	if _, ok := t.Subinterface[newK]; ok {
		return fmt.Errorf("key %v already exists in Subinterface", newK)
	}

	e, ok := t.Subinterface[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in Subinterface", oldK)
	}
	e.Index = &newK

	t.Subinterface[newK] = e
	delete(t.Subinterface, oldK)
	return nil
}

// GetOrCreateSubinterface retrieves the value with the specified keys from
// the receiver Interface. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Interface) GetOrCreateSubinterface(Index uint32) *Interface_Subinterface {

	key := Index

	if v, ok := t.Subinterface[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewSubinterface(Index)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateSubinterface got unexpected error: %v", err))
	}
	return v
}

// GetSubinterface retrieves the value with the specified key from
// the Subinterface map field of Interface. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Interface) GetSubinterface(Index uint32) *Interface_Subinterface {

	if t == nil {
		return nil
	}

	key := Index

	if lm, ok := t.Subinterface[key]; ok {
		return lm
	}
	return nil
}

// AppendSubinterface appends the supplied Interface_Subinterface struct to the
// list Subinterface of Interface. If the key value(s) specified in
// the supplied Interface_Subinterface already exist in the list, an error is
// returned.
func (t *Interface) AppendSubinterface(v *Interface_Subinterface) error {
	if v.Index == nil {
		return fmt.Errorf("invalid nil key received for Index")
	}

	key := *v.Index

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subinterface == nil {
		t.Subinterface = make(map[uint32]*Interface_Subinterface)
	}

	if _, ok := t.Subinterface[key]; ok {
		return fmt.Errorf("duplicate key for list Subinterface %v", key)
	}

	t.Subinterface[key] = v
	return nil
}

// GetOrCreateAggregation retrieves the value of the Aggregation field
// or returns the existing field if it already exists.
func (t *Interface) GetOrCreateAggregation() *Interface_Aggregation {
	if t.Aggregation != nil {
		return t.Aggregation
	}
	t.Aggregation = &Interface_Aggregation{}
	return t.Aggregation
}

// GetOrCreateCounters retrieves the value of the Counters field
// or returns the existing field if it already exists.
func (t *Interface) GetOrCreateCounters() *Interface_Counters {
	if t.Counters != nil {
		return t.Counters
	}
	t.Counters = &Interface_Counters{}
	return t.Counters
}

// GetOrCreateEthernet retrieves the value of the Ethernet field
// or returns the existing field if it already exists.
func (t *Interface) GetOrCreateEthernet() *Interface_Ethernet {
	if t.Ethernet != nil {
		return t.Ethernet
	}
	t.Ethernet = &Interface_Ethernet{}
	return t.Ethernet
}

// GetOrCreateHoldTime retrieves the value of the HoldTime field
// or returns the existing field if it already exists.
func (t *Interface) GetOrCreateHoldTime() *Interface_HoldTime {
	if t.HoldTime != nil {
		return t.HoldTime
	}
	t.HoldTime = &Interface_HoldTime{}
	return t.HoldTime
}

// GetOrCreateRoutedVlan retrieves the value of the RoutedVlan field
// or returns the existing field if it already exists.
func (t *Interface) GetOrCreateRoutedVlan() *Interface_RoutedVlan {
	if t.RoutedVlan != nil {
		return t.RoutedVlan
	}
	t.RoutedVlan = &Interface_RoutedVlan{}
	return t.RoutedVlan
}

// GetOrCreateSonet retrieves the value of the Sonet field
// or returns the existing field if it already exists.
func (t *Interface) GetOrCreateSonet() *Interface_Sonet {
	if t.Sonet != nil {
		return t.Sonet
	}
	t.Sonet = &Interface_Sonet{}
	return t.Sonet
}

// GetAggregation returns the value of the Aggregation struct pointer
// from Interface. If the receiver or the field Aggregation is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Interface) GetAggregation() *Interface_Aggregation {
	if t != nil && t.Aggregation != nil {
		return t.Aggregation
	}
	return nil
}

// GetCounters returns the value of the Counters struct pointer
// from Interface. If the receiver or the field Counters is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Interface) GetCounters() *Interface_Counters {
	if t != nil && t.Counters != nil {
		return t.Counters
	}
	return nil
}

// GetEthernet returns the value of the Ethernet struct pointer
// from Interface. If the receiver or the field Ethernet is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Interface) GetEthernet() *Interface_Ethernet {
	if t != nil && t.Ethernet != nil {
		return t.Ethernet
	}
	return nil
}

// GetHoldTime returns the value of the HoldTime struct pointer
// from Interface. If the receiver or the field HoldTime is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Interface) GetHoldTime() *Interface_HoldTime {
	if t != nil && t.HoldTime != nil {
		return t.HoldTime
	}
	return nil
}

// GetRoutedVlan returns the value of the RoutedVlan struct pointer
// from Interface. If the receiver or the field RoutedVlan is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Interface) GetRoutedVlan() *Interface_RoutedVlan {
	if t != nil && t.RoutedVlan != nil {
		return t.RoutedVlan
	}
	return nil
}

// GetSonet returns the value of the Sonet struct pointer
// from Interface. If the receiver or the field Sonet is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Interface) GetSonet() *Interface_Sonet {
	if t != nil && t.Sonet != nil {
		return t.Sonet
	}
	return nil
}

// GetAdminStatus retrieves the value of the leaf AdminStatus from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AdminStatus is set, it can
// safely use t.GetAdminStatus() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AdminStatus == nil' before retrieving the leaf's value.
func (t *Interface) GetAdminStatus() E_Interface_AdminStatus {
	if t == nil || t.AdminStatus == 0 {
		return 0
	}
	return t.AdminStatus
}

// GetCpu retrieves the value of the leaf Cpu from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Cpu is set, it can
// safely use t.GetCpu() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Cpu == nil' before retrieving the leaf's value.
func (t *Interface) GetCpu() bool {
	if t == nil || t.Cpu == nil {
		return false
	}
	return *t.Cpu
}

// GetDescription retrieves the value of the leaf Description from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Description is set, it can
// safely use t.GetDescription() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Description == nil' before retrieving the leaf's value.
func (t *Interface) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetEnabled retrieves the value of the leaf Enabled from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Enabled is set, it can
// safely use t.GetEnabled() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Enabled == nil' before retrieving the leaf's value.
func (t *Interface) GetEnabled() bool {
	if t == nil || t.Enabled == nil {
		return true
	}
	return *t.Enabled
}

// GetHardwarePort retrieves the value of the leaf HardwarePort from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if HardwarePort is set, it can
// safely use t.GetHardwarePort() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.HardwarePort == nil' before retrieving the leaf's value.
func (t *Interface) GetHardwarePort() string {
	if t == nil || t.HardwarePort == nil {
		return ""
	}
	return *t.HardwarePort
}

// GetIfindex retrieves the value of the leaf Ifindex from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Ifindex is set, it can
// safely use t.GetIfindex() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Ifindex == nil' before retrieving the leaf's value.
func (t *Interface) GetIfindex() uint32 {
	if t == nil || t.Ifindex == nil {
		return 0
	}
	return *t.Ifindex
}

// GetLastChange retrieves the value of the leaf LastChange from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastChange is set, it can
// safely use t.GetLastChange() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastChange == nil' before retrieving the leaf's value.
func (t *Interface) GetLastChange() uint64 {
	if t == nil || t.LastChange == nil {
		return 0
	}
	return *t.LastChange
}

// GetLogical retrieves the value of the leaf Logical from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Logical is set, it can
// safely use t.GetLogical() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Logical == nil' before retrieving the leaf's value.
func (t *Interface) GetLogical() bool {
	if t == nil || t.Logical == nil {
		return false
	}
	return *t.Logical
}

// GetLoopbackMode retrieves the value of the leaf LoopbackMode from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LoopbackMode is set, it can
// safely use t.GetLoopbackMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LoopbackMode == nil' before retrieving the leaf's value.
func (t *Interface) GetLoopbackMode() bool {
	if t == nil || t.LoopbackMode == nil {
		return false
	}
	return *t.LoopbackMode
}

// GetManagement retrieves the value of the leaf Management from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Management is set, it can
// safely use t.GetManagement() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Management == nil' before retrieving the leaf's value.
func (t *Interface) GetManagement() bool {
	if t == nil || t.Management == nil {
		return false
	}
	return *t.Management
}

// GetMtu retrieves the value of the leaf Mtu from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Mtu is set, it can
// safely use t.GetMtu() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Mtu == nil' before retrieving the leaf's value.
func (t *Interface) GetMtu() uint16 {
	if t == nil || t.Mtu == nil {
		return 0
	}
	return *t.Mtu
}

// GetName retrieves the value of the leaf Name from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Name is set, it can
// safely use t.GetName() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Name == nil' before retrieving the leaf's value.
func (t *Interface) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetOperStatus retrieves the value of the leaf OperStatus from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if OperStatus is set, it can
// safely use t.GetOperStatus() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.OperStatus == nil' before retrieving the leaf's value.
func (t *Interface) GetOperStatus() E_Interface_OperStatus {
	if t == nil || t.OperStatus == 0 {
		return 0
	}
	return t.OperStatus
}

// GetPhysicalChannel retrieves the value of the leaf PhysicalChannel from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if PhysicalChannel is set, it can
// safely use t.GetPhysicalChannel() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.PhysicalChannel == nil' before retrieving the leaf's value.
func (t *Interface) GetPhysicalChannel() []uint16 {
	if t == nil || t.PhysicalChannel == nil {
		return nil
	}
	return t.PhysicalChannel
}

// GetTpid retrieves the value of the leaf Tpid from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Tpid is set, it can
// safely use t.GetTpid() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Tpid == nil' before retrieving the leaf's value.
func (t *Interface) GetTpid() E_VlanTypes_TPID_TYPES {
	if t == nil || t.Tpid == 0 {
		return VlanTypes_TPID_TYPES_TPID_0X8100
	}
	return t.Tpid
}

// GetTransceiver retrieves the value of the leaf Transceiver from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Transceiver is set, it can
// safely use t.GetTransceiver() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Transceiver == nil' before retrieving the leaf's value.
func (t *Interface) GetTransceiver() string {
	if t == nil || t.Transceiver == nil {
		return ""
	}
	return *t.Transceiver
}

// GetType retrieves the value of the leaf Type from the Interface
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Type is set, it can
// safely use t.GetType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Type == nil' before retrieving the leaf's value.
func (t *Interface) GetType() E_IETFInterfaces_InterfaceType {
	if t == nil || t.Type == 0 {
		return 0
	}
	return t.Type
}

// ΛListKeyMap returns the keys of the Interface struct, which is a YANG list entry.
func (t *Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Interface.
func (*Interface) ΛBelongingModule() string {
	return "openconfig-interfaces"
}

// Interface_Aggregation represents the /openconfig-interfaces/interfaces/interface/aggregation YANG schema element.
type Interface_Aggregation struct {
	ΛMetadata     []ygot.Annotation                   `path:"@" ygotAnnotation:"true"`
	LagSpeed      *uint32                             `path:"state/lag-speed" module:"openconfig-if-aggregate/openconfig-if-aggregate"`
	ΛLagSpeed     []ygot.Annotation                   `path:"state/@lag-speed" ygotAnnotation:"true"`
	LagType       E_IfAggregate_AggregationType       `path:"config/lag-type" module:"openconfig-if-aggregate/openconfig-if-aggregate"`
	ΛLagType      []ygot.Annotation                   `path:"config/@lag-type" ygotAnnotation:"true"`
	Member        []string                            `path:"state/member" module:"openconfig-if-aggregate/openconfig-if-aggregate"`
	ΛMember       []ygot.Annotation                   `path:"state/@member" ygotAnnotation:"true"`
	MinLinks      *uint16                             `path:"config/min-links" module:"openconfig-if-aggregate/openconfig-if-aggregate"`
	ΛMinLinks     []ygot.Annotation                   `path:"config/@min-links" ygotAnnotation:"true"`
	SwitchedVlan  *Interface_Aggregation_SwitchedVlan `path:"switched-vlan" module:"openconfig-vlan"`
	ΛSwitchedVlan []ygot.Annotation                   `path:"@switched-vlan" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Interface_Aggregation implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Interface_Aggregation) IsYANGGoStruct() {}

// GetOrCreateSwitchedVlan retrieves the value of the SwitchedVlan field
// or returns the existing field if it already exists.
func (t *Interface_Aggregation) GetOrCreateSwitchedVlan() *Interface_Aggregation_SwitchedVlan {
	if t.SwitchedVlan != nil {
		return t.SwitchedVlan
	}
	t.SwitchedVlan = &Interface_Aggregation_SwitchedVlan{}
	return t.SwitchedVlan
}

// GetSwitchedVlan returns the value of the SwitchedVlan struct pointer
// from Interface_Aggregation. If the receiver or the field SwitchedVlan is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Interface_Aggregation) GetSwitchedVlan() *Interface_Aggregation_SwitchedVlan {
	if t != nil && t.SwitchedVlan != nil {
		return t.SwitchedVlan
	}
	return nil
}

// GetLagSpeed retrieves the value of the leaf LagSpeed from the Interface_Aggregation
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LagSpeed is set, it can
// safely use t.GetLagSpeed() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LagSpeed == nil' before retrieving the leaf's value.
func (t *Interface_Aggregation) GetLagSpeed() uint32 {
	if t == nil || t.LagSpeed == nil {
		return 0
	}
	return *t.LagSpeed
}

// GetLagType retrieves the value of the leaf LagType from the Interface_Aggregation
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LagType is set, it can
// safely use t.GetLagType() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LagType == nil' before retrieving the leaf's value.
func (t *Interface_Aggregation) GetLagType() E_IfAggregate_AggregationType {
	if t == nil || t.LagType == 0 {
		return 0
	}
	return t.LagType
}

// GetMember retrieves the value of the leaf Member from the Interface_Aggregation
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Member is set, it can
// safely use t.GetMember() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Member == nil' before retrieving the leaf's value.
func (t *Interface_Aggregation) GetMember() []string {
	if t == nil || t.Member == nil {
		return nil
	}
	return t.Member
}

// GetMinLinks retrieves the value of the leaf MinLinks from the Interface_Aggregation
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if MinLinks is set, it can
// safely use t.GetMinLinks() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.MinLinks == nil' before retrieving the leaf's value.
func (t *Interface_Aggregation) GetMinLinks() uint16 {
	if t == nil || t.MinLinks == nil {
		return 0
	}
	return *t.MinLinks
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Interface_Aggregation) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Interface_Aggregation"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Interface_Aggregation) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Interface_Aggregation) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Interface_Aggregation.
func (*Interface_Aggregation) ΛBelongingModule() string {
	return "openconfig-if-aggregate"
}

// Interface_Aggregation_SwitchedVlan represents the /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan YANG schema element.
type Interface_Aggregation_SwitchedVlan struct {
	ΛMetadata      []ygot.Annotation                                     `path:"@" ygotAnnotation:"true"`
	AccessVlan     *uint16                                               `path:"config/access-vlan" module:"openconfig-vlan/openconfig-vlan"`
	ΛAccessVlan    []ygot.Annotation                                     `path:"config/@access-vlan" ygotAnnotation:"true"`
	InterfaceMode  E_VlanTypes_VlanModeType                              `path:"config/interface-mode" module:"openconfig-vlan/openconfig-vlan"`
	ΛInterfaceMode []ygot.Annotation                                     `path:"config/@interface-mode" ygotAnnotation:"true"`
	NativeVlan     *uint16                                               `path:"config/native-vlan" module:"openconfig-vlan/openconfig-vlan"`
	ΛNativeVlan    []ygot.Annotation                                     `path:"config/@native-vlan" ygotAnnotation:"true"`
	TrunkVlans     []Interface_Aggregation_SwitchedVlan_TrunkVlans_Union `path:"config/trunk-vlans" module:"openconfig-vlan/openconfig-vlan"`
	ΛTrunkVlans    []ygot.Annotation                                     `path:"config/@trunk-vlans" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Interface_Aggregation_SwitchedVlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Interface_Aggregation_SwitchedVlan) IsYANGGoStruct() {}

// GetAccessVlan retrieves the value of the leaf AccessVlan from the Interface_Aggregation_SwitchedVlan
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if AccessVlan is set, it can
// safely use t.GetAccessVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.AccessVlan == nil' before retrieving the leaf's value.
func (t *Interface_Aggregation_SwitchedVlan) GetAccessVlan() uint16 {
	if t == nil || t.AccessVlan == nil {
		return 0
	}
	return *t.AccessVlan
}

// GetInterfaceMode retrieves the value of the leaf InterfaceMode from the Interface_Aggregation_SwitchedVlan
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InterfaceMode is set, it can
// safely use t.GetInterfaceMode() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InterfaceMode == nil' before retrieving the leaf's value.
func (t *Interface_Aggregation_SwitchedVlan) GetInterfaceMode() E_VlanTypes_VlanModeType {
	if t == nil || t.InterfaceMode == 0 {
		return 0
	}
	return t.InterfaceMode
}

// GetNativeVlan retrieves the value of the leaf NativeVlan from the Interface_Aggregation_SwitchedVlan
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if NativeVlan is set, it can
// safely use t.GetNativeVlan() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.NativeVlan == nil' before retrieving the leaf's value.
func (t *Interface_Aggregation_SwitchedVlan) GetNativeVlan() uint16 {
	if t == nil || t.NativeVlan == nil {
		return 0
	}
	return *t.NativeVlan
}

// GetTrunkVlans retrieves the value of the leaf TrunkVlans from the Interface_Aggregation_SwitchedVlan
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if TrunkVlans is set, it can
// safely use t.GetTrunkVlans() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.TrunkVlans == nil' before retrieving the leaf's value.
func (t *Interface_Aggregation_SwitchedVlan) GetTrunkVlans() []Interface_Aggregation_SwitchedVlan_TrunkVlans_Union {
	if t == nil || t.TrunkVlans == nil {
		return nil
	}
	return t.TrunkVlans
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Interface_Aggregation_SwitchedVlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Interface_Aggregation_SwitchedVlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Interface_Aggregation_SwitchedVlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Interface_Aggregation_SwitchedVlan) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// ΛBelongingModule returns the name of the module that defines the namespace
// of Interface_Aggregation_SwitchedVlan.
func (*Interface_Aggregation_SwitchedVlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// Interface_Aggregation_SwitchedVlan_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/config/trunk-vlans within the YANG schema.
type Interface_Aggregation_SwitchedVlan_TrunkVlans_Union interface {
	Is_Interface_Aggregation_SwitchedVlan_TrunkVlans_Union()
}

// Interface_Aggregation_SwitchedVlan_TrunkVlans_Union_String is used when /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/config/trunk-vlans
// is to be set to a string value.
type Interface_Aggregation_SwitchedVlan_TrunkVlans_Union_String struct {
	String string
}

// Is_Interface_Aggregation_SwitchedVlan_TrunkVlans_Union ensures that Interface_Aggregation_SwitchedVlan_TrunkVlans_Union_String
// implements the Interface_Aggregation_SwitchedVlan_TrunkVlans_Union interface.
func (*Interface_Aggregation_SwitchedVlan_TrunkVlans_Union_String) Is_Interface_Aggregation_SwitchedVlan_TrunkVlans_Union() {
}

// Interface_Aggregation_SwitchedVlan_TrunkVlans_Union_Uint16 is used when /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/config/trunk-vlans
// is to be set to a uint16 value.
type Interface_Aggregation_SwitchedVlan_TrunkVlans_Union_Uint16 struct {
	Uint16 uint16
}

// Is_Interface_Aggregation_SwitchedVlan_TrunkVlans_Union ensures that Interface_Aggregation_SwitchedVlan_TrunkVlans_Union_Uint16
// implements the Interface_Aggregation_SwitchedVlan_TrunkVlans_Union interface.
func (*Interface_Aggregation_SwitchedVlan_TrunkVlans_Union_Uint16) Is_Interface_Aggregation_SwitchedVlan_TrunkVlans_Union() {
}

// To_Interface_Aggregation_SwitchedVlan_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the Interface_Aggregation_SwitchedVlan_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *Interface_Aggregation_SwitchedVlan) To_Interface_Aggregation_SwitchedVlan_TrunkVlans_Union(i interface{}) (Interface_Aggregation_SwitchedVlan_TrunkVlans_Union, error) {
	switch v := i.(type) {
	case string:
		return &Interface_Aggregation_SwitchedVlan_TrunkVlans_Union_String{v}, nil
	case uint16:
		return &Interface_Aggregation_SwitchedVlan_TrunkVlans_Union_Uint16{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to Interface_Aggregation_SwitchedVlan_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
	}
}

// Interface_Counters represents the /openconfig-interfaces/interfaces/interface/state/counters YANG schema element.
type Interface_Counters struct {
	ΛMetadata           []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	CarrierTransitions  *uint64           `path:"carrier-transitions" module:"openconfig-interfaces"`
	ΛCarrierTransitions []ygot.Annotation `path:"@carrier-transitions" ygotAnnotation:"true"`
	InBroadcastPkts     *uint64           `path:"in-broadcast-pkts" module:"openconfig-interfaces"`
	ΛInBroadcastPkts    []ygot.Annotation `path:"@in-broadcast-pkts" ygotAnnotation:"true"`
	InDiscards          *uint64           `path:"in-discards" module:"openconfig-interfaces"`
	ΛInDiscards         []ygot.Annotation `path:"@in-discards" ygotAnnotation:"true"`
	InErrors            *uint64           `path:"in-errors" module:"openconfig-interfaces"`
	ΛInErrors           []ygot.Annotation `path:"@in-errors" ygotAnnotation:"true"`
	InFcsErrors         *uint64           `path:"in-fcs-errors" module:"openconfig-interfaces"`
	ΛInFcsErrors        []ygot.Annotation `path:"@in-fcs-errors" ygotAnnotation:"true"`
	InMulticastPkts     *uint64           `path:"in-multicast-pkts" module:"openconfig-interfaces"`
	ΛInMulticastPkts    []ygot.Annotation `path:"@in-multicast-pkts" ygotAnnotation:"true"`
	InOctets            *uint64           `path:"in-octets" module:"openconfig-interfaces"`
	ΛInOctets           []ygot.Annotation `path:"@in-octets" ygotAnnotation:"true"`
	InPkts              *uint64           `path:"in-pkts" module:"openconfig-interfaces"`
	ΛInPkts             []ygot.Annotation `path:"@in-pkts" ygotAnnotation:"true"`
	InUnicastPkts       *uint64           `path:"in-unicast-pkts" module:"openconfig-interfaces"`
	ΛInUnicastPkts      []ygot.Annotation `path:"@in-unicast-pkts" ygotAnnotation:"true"`
	InUnknownProtos     *uint64           `path:"in-unknown-protos" module:"openconfig-interfaces"`
	ΛInUnknownProtos    []ygot.Annotation `path:"@in-unknown-protos" ygotAnnotation:"true"`
	LastClear           *uint64           `path:"last-clear" module:"openconfig-interfaces"`
	ΛLastClear          []ygot.Annotation `path:"@last-clear" ygotAnnotation:"true"`
	OutBroadcastPkts    *uint64           `path:"out-broadcast-pkts" module:"openconfig-interfaces"`
	ΛOutBroadcastPkts   []ygot.Annotation `path:"@out-broadcast-pkts" ygotAnnotation:"true"`
	OutDiscards         *uint64           `path:"out-discards" module:"openconfig-interfaces"`
	ΛOutDiscards        []ygot.Annotation `path:"@out-discards" ygotAnnotation:"true"`
	OutErrors           *uint64           `path:"out-errors" module:"openconfig-interfaces"`
	ΛOutErrors          []ygot.Annotation `path:"@out-errors" ygotAnnotation:"true"`
	OutMulticastPkts    *uint64           `path:"out-multicast-pkts" module:"openconfig-interfaces"`
	ΛOutMulticastPkts   []ygot.Annotation `path:"@out-multicast-pkts" ygotAnnotation:"true"`
	OutOctets           *uint64           `path:"out-octets" module:"openconfig-interfaces"`
	ΛOutOctets          []ygot.Annotation `path:"@out-octets" ygotAnnotation:"true"`
	OutPkts             *uint64           `path:"out-pkts" module:"openconfig-interfaces"`
	ΛOutPkts            []ygot.Annotation `path:"@out-pkts" ygotAnnotation:"true"`
	OutUnicastPkts      *uint64           `path:"out-unicast-pkts" module:"openconfig-interfaces"`
	ΛOutUnicastPkts     []ygot.Annotation `path:"@out-unicast-pkts" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Interface_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Interface_Counters) IsYANGGoStruct() {}

// GetCarrierTransitions retrieves the value of the leaf CarrierTransitions from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if CarrierTransitions is set, it can
// safely use t.GetCarrierTransitions() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.CarrierTransitions == nil' before retrieving the leaf's value.
func (t *Interface_Counters) GetCarrierTransitions() uint64 {
	if t == nil || t.CarrierTransitions == nil {
		return 0
	}
	return *t.CarrierTransitions
}

// GetInBroadcastPkts retrieves the value of the leaf InBroadcastPkts from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InBroadcastPkts is set, it can
// safely use t.GetInBroadcastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InBroadcastPkts == nil' before retrieving the leaf's value.
func (t *Interface_Counters) GetInBroadcastPkts() uint64 {
	if t == nil || t.InBroadcastPkts == nil {
		return 0
	}
	return *t.InBroadcastPkts
}

// GetInDiscards retrieves the value of the leaf InDiscards from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InDiscards is set, it can
// safely use t.GetInDiscards() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InDiscards == nil' before retrieving the leaf's value.
func (t *Interface_Counters) GetInDiscards() uint64 {
	if t == nil || t.InDiscards == nil {
		return 0
	}
	return *t.InDiscards
}

// GetInErrors retrieves the value of the leaf InErrors from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InErrors is set, it can
// safely use t.GetInErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InErrors == nil' before retrieving the leaf's value.
func (t *Interface_Counters) GetInErrors() uint64 {
	if t == nil || t.InErrors == nil {
		return 0
	}
	return *t.InErrors
}

// GetInFcsErrors retrieves the value of the leaf InFcsErrors from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InFcsErrors is set, it can
// safely use t.GetInFcsErrors() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InFcsErrors == nil' before retrieving the leaf's value.
func (t *Interface_Counters) GetInFcsErrors() uint64 {
	if t == nil || t.InFcsErrors == nil {
		return 0
	}
	return *t.InFcsErrors
}

// GetInMulticastPkts retrieves the value of the leaf InMulticastPkts from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InMulticastPkts is set, it can
// safely use t.GetInMulticastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InMulticastPkts == nil' before retrieving the leaf's value.
func (t *Interface_Counters) GetInMulticastPkts() uint64 {
	if t == nil || t.InMulticastPkts == nil {
		return 0
	}
	return *t.InMulticastPkts
}

// GetInOctets retrieves the value of the leaf InOctets from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InOctets is set, it can
// safely use t.GetInOctets() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InOctets == nil' before retrieving the leaf's value.
func (t *Interface_Counters) GetInOctets() uint64 {
	if t == nil || t.InOctets == nil {
		return 0
	}
	return *t.InOctets
}

// GetInPkts retrieves the value of the leaf InPkts from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InPkts is set, it can
// safely use t.GetInPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InPkts == nil' before retrieving the leaf's value.
func (t *Interface_Counters) GetInPkts() uint64 {
	if t == nil || t.InPkts == nil {
		return 0
	}
	return *t.InPkts
}

// GetInUnicastPkts retrieves the value of the leaf InUnicastPkts from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InUnicastPkts is set, it can
// safely use t.GetInUnicastPkts() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InUnicastPkts == nil' before retrieving the leaf's value.
func (t *Interface_Counters) GetInUnicastPkts() uint64 {
	if t == nil || t.InUnicastPkts == nil {
		return 0
	}
	return *t.InUnicastPkts
}

// GetInUnknownProtos retrieves the value of the leaf InUnknownProtos from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if InUnknownProtos is set, it can
// safely use t.GetInUnknownProtos() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.InUnknownProtos == nil' before retrieving the leaf's value.
func (t *Interface_Counters) GetInUnknownProtos() uint64 {
	if t == nil || t.InUnknownProtos == nil {
		return 0
	}
	return *t.InUnknownProtos
}

// GetLastClear retrieves the value of the leaf LastClear from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if LastClear is set, it can
// safely use t.GetLastClear() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.LastClear == nil' before retrieving the leaf's value.
func (t *Interface_Counters) GetLastClear() uint64 {
	if t == nil || t.LastClear == nil {
		return 0
	}
	return *t.LastClear
}

// GetOutBroadcastPkts retrieves the value of the leaf OutBroadcastPkts from the Interface_Counters
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero