// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/channel/v1/reports_service.proto

package channelpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CloudChannelReportsService_RunReportJob_FullMethodName       = "/google.cloud.channel.v1.CloudChannelReportsService/RunReportJob"
	CloudChannelReportsService_FetchReportResults_FullMethodName = "/google.cloud.channel.v1.CloudChannelReportsService/FetchReportResults"
	CloudChannelReportsService_ListReports_FullMethodName        = "/google.cloud.channel.v1.CloudChannelReportsService/ListReports"
)

// CloudChannelReportsServiceClient is the client API for CloudChannelReportsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Deprecated: Do not use.
type CloudChannelReportsServiceClient interface {
	// Deprecated: Do not use.
	// Begins generation of data for a given report. The report
	// identifier is a UID (for example, `613bf59q`).
	//
	// Possible error codes:
	//
	//   - PERMISSION_DENIED: The user doesn't have access to this report.
	//   - INVALID_ARGUMENT: Required request parameters are missing
	//     or invalid.
	//   - NOT_FOUND: The report identifier was not found.
	//   - INTERNAL: Any non-user error related to a technical issue
	//     in the backend. Contact Cloud Channel support.
	//   - UNKNOWN: Any non-user error related to a technical issue
	//     in the backend. Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata contains an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	//
	// To get the results of report generation, call
	// [CloudChannelReportsService.FetchReportResults][google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults]
	// with the
	// [RunReportJobResponse.report_job][google.cloud.channel.v1.RunReportJobResponse.report_job].
	//
	// Deprecated: Please use [Export Channel Services data to
	// BigQuery](https://cloud.google.com/channel/docs/rebilling/export-data-to-bigquery)
	// instead.
	RunReportJob(ctx context.Context, in *RunReportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Retrieves data generated by
	// [CloudChannelReportsService.RunReportJob][google.cloud.channel.v1.CloudChannelReportsService.RunReportJob].
	//
	// Deprecated: Please use [Export Channel Services data to
	// BigQuery](https://cloud.google.com/channel/docs/rebilling/export-data-to-bigquery)
	// instead.
	FetchReportResults(ctx context.Context, in *FetchReportResultsRequest, opts ...grpc.CallOption) (*FetchReportResultsResponse, error)
	// Deprecated: Do not use.
	// Lists the reports that RunReportJob can run. These reports include an ID,
	// a description, and the list of columns that will be in the result.
	//
	// Deprecated: Please use [Export Channel Services data to
	// BigQuery](https://cloud.google.com/channel/docs/rebilling/export-data-to-bigquery)
	// instead.
	ListReports(ctx context.Context, in *ListReportsRequest, opts ...grpc.CallOption) (*ListReportsResponse, error)
}

type cloudChannelReportsServiceClient struct {
	cc grpc.ClientConnInterface
}

// Deprecated: Do not use.
func NewCloudChannelReportsServiceClient(cc grpc.ClientConnInterface) CloudChannelReportsServiceClient {
	return &cloudChannelReportsServiceClient{cc}
}

// Deprecated: Do not use.
func (c *cloudChannelReportsServiceClient) RunReportJob(ctx context.Context, in *RunReportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelReportsService_RunReportJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *cloudChannelReportsServiceClient) FetchReportResults(ctx context.Context, in *FetchReportResultsRequest, opts ...grpc.CallOption) (*FetchReportResultsResponse, error) {
	out := new(FetchReportResultsResponse)
	err := c.cc.Invoke(ctx, CloudChannelReportsService_FetchReportResults_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *cloudChannelReportsServiceClient) ListReports(ctx context.Context, in *ListReportsRequest, opts ...grpc.CallOption) (*ListReportsResponse, error) {
	out := new(ListReportsResponse)
	err := c.cc.Invoke(ctx, CloudChannelReportsService_ListReports_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudChannelReportsServiceServer is the server API for CloudChannelReportsService service.
// All implementations should embed UnimplementedCloudChannelReportsServiceServer
// for forward compatibility
//
// Deprecated: Do not use.
type CloudChannelReportsServiceServer interface {
	// Deprecated: Do not use.
	// Begins generation of data for a given report. The report
	// identifier is a UID (for example, `613bf59q`).
	//
	// Possible error codes:
	//
	//   - PERMISSION_DENIED: The user doesn't have access to this report.
	//   - INVALID_ARGUMENT: Required request parameters are missing
	//     or invalid.
	//   - NOT_FOUND: The report identifier was not found.
	//   - INTERNAL: Any non-user error related to a technical issue
	//     in the backend. Contact Cloud Channel support.
	//   - UNKNOWN: Any non-user error related to a technical issue
	//     in the backend. Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata contains an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	//
	// To get the results of report generation, call
	// [CloudChannelReportsService.FetchReportResults][google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults]
	// with the
	// [RunReportJobResponse.report_job][google.cloud.channel.v1.RunReportJobResponse.report_job].
	//
	// Deprecated: Please use [Export Channel Services data to
	// BigQuery](https://cloud.google.com/channel/docs/rebilling/export-data-to-bigquery)
	// instead.
	RunReportJob(context.Context, *RunReportJobRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Retrieves data generated by
	// [CloudChannelReportsService.RunReportJob][google.cloud.channel.v1.CloudChannelReportsService.RunReportJob].
	//
	// Deprecated: Please use [Export Channel Services data to
	// BigQuery](https://cloud.google.com/channel/docs/rebilling/export-data-to-bigquery)
	// instead.
	FetchReportResults(context.Context, *FetchReportResultsRequest) (*FetchReportResultsResponse, error)
	// Deprecated: Do not use.
	// Lists the reports that RunReportJob can run. These reports include an ID,
	// a description, and the list of columns that will be in the result.
	//
	// Deprecated: Please use [Export Channel Services data to
	// BigQuery](https://cloud.google.com/channel/docs/rebilling/export-data-to-bigquery)
	// instead.
	ListReports(context.Context, *ListReportsRequest) (*ListReportsResponse, error)
}

// UnimplementedCloudChannelReportsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedCloudChannelReportsServiceServer struct {
}

func (UnimplementedCloudChannelReportsServiceServer) RunReportJob(context.Context, *RunReportJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunReportJob not implemented")
}
func (UnimplementedCloudChannelReportsServiceServer) FetchReportResults(context.Context, *FetchReportResultsRequest) (*FetchReportResultsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchReportResults not implemented")
}
func (UnimplementedCloudChannelReportsServiceServer) ListReports(context.Context, *ListReportsRequest) (*ListReportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReports not implemented")
}

// UnsafeCloudChannelReportsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CloudChannelReportsServiceServer will
// result in compilation errors.
type UnsafeCloudChannelReportsServiceServer interface {
	mustEmbedUnimplementedCloudChannelReportsServiceServer()
}

// Deprecated: Do not use.
func RegisterCloudChannelReportsServiceServer(s grpc.ServiceRegistrar, srv CloudChannelReportsServiceServer) {
	s.RegisterService(&CloudChannelReportsService_ServiceDesc, srv)
}

func _CloudChannelReportsService_RunReportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunReportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelReportsServiceServer).RunReportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelReportsService_RunReportJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelReportsServiceServer).RunReportJob(ctx, req.(*RunReportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelReportsService_FetchReportResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchReportResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelReportsServiceServer).FetchReportResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelReportsService_FetchReportResults_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelReportsServiceServer).FetchReportResults(ctx, req.(*FetchReportResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelReportsService_ListReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelReportsServiceServer).ListReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelReportsService_ListReports_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelReportsServiceServer).ListReports(ctx, req.(*ListReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CloudChannelReportsService_ServiceDesc is the grpc.ServiceDesc for CloudChannelReportsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CloudChannelReportsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.channel.v1.CloudChannelReportsService",
	HandlerType: (*CloudChannelReportsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RunReportJob",
			Handler:    _CloudChannelReportsService_RunReportJob_Handler,
		},
		{
			MethodName: "FetchReportResults",
			Handler:    _CloudChannelReportsService_FetchReportResults_Handler,
		},
		{
			MethodName: "ListReports",
			Handler:    _CloudChannelReportsService_ListReports_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/channel/v1/reports_service.proto",
}
