# Proposal: Scarf.sh integration

<!-- toc -->
- [Summary](#summary)
  - [What is Scarf?](#what-is-scarf)
- [Motivation](#motivation)
  - [Goals](#goals)
- [Proposal](#proposal)
  - [How will this change impact our users?](#how-will-this-change-impact-our-users)
  - [Known issues/limitations](#known-issueslimitations)
<!-- /toc -->

## Summary

With our focus on CNCF graduation, CNCF aims for its projects to become [vendor-neutral](https://contribute.cncf.io/maintainers/community/vendor-neutrality/) wherever possible. The cert-manager project should uphold this aim. In doing so, it will need to take a further step to move on from its proud Jetstack legacy with a change to remove Jetstack from the container image repository name.

In addition, Quay.io, the current container image registry for cert-manager, has limitations on the amount of analytic data it can provide due to the high volume of downloads that cert-manager receives. The cert-manager maintainers have also found that Quay has had several outages during 2023, and they want to manage that situation quickly in the future if required.

Recently partnered with the Linux Foundation, Scarf is a service designed for open-source projects that will allow for a simple migration.

Scarf will provide multiple benefits:
- Not being tied to a single container image/binary repository vendor gives the freedom to change vendors if required.
- Switching to a more neutral domain (e.g., cert-manager.io).
- Continuing to provide container images at significant volume while improving the analytic data of how the project is downloaded.

### What is Scarf?

The open-source Scarf Gateway is the power behind the Scarf platform. The Scarf Gateway serves as a centralised point of access for the distribution of containers and packages, regardless of their actual hosting location. The Gateway is positioned before an existing registry to reroute download traffic to the storage location while providing essential usage data that the registry does not readily share. It is understood that the Scarf gateway will not act as a full proxy for all image data to pass through but only as a proxy for image metadata, redirecting the download client to the actual hosting location, such as quay.io.

## Motivation

### Goals

- Discontinue using the name "Jetstack" in all container image downloads.
- Continue to provide non-breaking changes for those already using the existing "Jetstack" container image download locations.
- Gain the freedom to change image repositories with ease when necessary.
- Improve observability and reporting to maintainers of how cert-manager is downloaded to serve its users better.

## Proposal

- Obtain a new custom "download" domain through the CNCF to be used for fronting all binary downloads.
- The creation of a free (OSS tier) Scarf account will be configured and managed by the cert-manager maintainers.
- Update documentation referencing "jetstack" binary paths, e.g., quay.io/jetstack/cert-manager-controller, and replace with the new download domain.
- Update helm charts referencing "jetstack" binary paths, replacing with the new download domain.
- Update code referencing "jetstack" binary paths, replacing with the new download domain.
- Add Scarf pixels to selective documentation pages, giving us insight into which pages are most useful or areas to focus on for improvement.
- Automate regular analytics gathering leveraging the Scarf API to publish relevant stats and info publicly. E.g.
  - Region
  - Operating System
  - Container Tags / Versions
  - Container Runtimes


### How will this change impact our users?

Images and binaries should continue to be accessed from their existing locations. Therefore, there should be no impact on any existing downloads, automation, or mirroring.
Going forward, we would encourage users to use the new download paths by specifying the new domain in the documentation.

Any users downloading from secure environments with limited internet connections through firewall restrictions will need to add "allowed" rules for the Scarf gateway domain in addition to any existing rules for the image repository, such as quay.io. These should be clearly documented.

### Known issues/limitations
- Currently, the Scarf service only allows for custom domains and doesn't include custom paths. When speaking with members of the Scarf organisation, this is due to a technical limitation as the path is used in the image identification/verification process. Scarf is investigating a workaround; however, we may need to consider an additional hosting location/service to allow us to remove "jetstack" from the download path. An additional hosting location will increase existing maintenance and deployment process overheads.
