// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

package datatransferpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Parameter type.
type DataSourceParameter_Type int32

const (
	// Type unspecified.
	DataSourceParameter_TYPE_UNSPECIFIED DataSourceParameter_Type = 0
	// String parameter.
	DataSourceParameter_STRING DataSourceParameter_Type = 1
	// Integer parameter (64-bits).
	// Will be serialized to json as string.
	DataSourceParameter_INTEGER DataSourceParameter_Type = 2
	// Double precision floating point parameter.
	DataSourceParameter_DOUBLE DataSourceParameter_Type = 3
	// Boolean parameter.
	DataSourceParameter_BOOLEAN DataSourceParameter_Type = 4
	// Deprecated. This field has no effect.
	DataSourceParameter_RECORD DataSourceParameter_Type = 5
	// Page ID for a Google+ Page.
	DataSourceParameter_PLUS_PAGE DataSourceParameter_Type = 6
	// List of strings parameter.
	DataSourceParameter_LIST DataSourceParameter_Type = 7
)

// Enum value maps for DataSourceParameter_Type.
var (
	DataSourceParameter_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "STRING",
		2: "INTEGER",
		3: "DOUBLE",
		4: "BOOLEAN",
		5: "RECORD",
		6: "PLUS_PAGE",
		7: "LIST",
	}
	DataSourceParameter_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"STRING":           1,
		"INTEGER":          2,
		"DOUBLE":           3,
		"BOOLEAN":          4,
		"RECORD":           5,
		"PLUS_PAGE":        6,
		"LIST":             7,
	}
)

func (x DataSourceParameter_Type) Enum() *DataSourceParameter_Type {
	p := new(DataSourceParameter_Type)
	*p = x
	return p
}

func (x DataSourceParameter_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataSourceParameter_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_enumTypes[0].Descriptor()
}

func (DataSourceParameter_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_enumTypes[0]
}

func (x DataSourceParameter_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataSourceParameter_Type.Descriptor instead.
func (DataSourceParameter_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{0, 0}
}

// The type of authorization needed for this data source.
type DataSource_AuthorizationType int32

const (
	// Type unspecified.
	DataSource_AUTHORIZATION_TYPE_UNSPECIFIED DataSource_AuthorizationType = 0
	// Use OAuth 2 authorization codes that can be exchanged
	// for a refresh token on the backend.
	DataSource_AUTHORIZATION_CODE DataSource_AuthorizationType = 1
	// Return an authorization code for a given Google+ page that can then be
	// exchanged for a refresh token on the backend.
	DataSource_GOOGLE_PLUS_AUTHORIZATION_CODE DataSource_AuthorizationType = 2
	// Use First Party OAuth.
	DataSource_FIRST_PARTY_OAUTH DataSource_AuthorizationType = 3
)

// Enum value maps for DataSource_AuthorizationType.
var (
	DataSource_AuthorizationType_name = map[int32]string{
		0: "AUTHORIZATION_TYPE_UNSPECIFIED",
		1: "AUTHORIZATION_CODE",
		2: "GOOGLE_PLUS_AUTHORIZATION_CODE",
		3: "FIRST_PARTY_OAUTH",
	}
	DataSource_AuthorizationType_value = map[string]int32{
		"AUTHORIZATION_TYPE_UNSPECIFIED": 0,
		"AUTHORIZATION_CODE":             1,
		"GOOGLE_PLUS_AUTHORIZATION_CODE": 2,
		"FIRST_PARTY_OAUTH":              3,
	}
)

func (x DataSource_AuthorizationType) Enum() *DataSource_AuthorizationType {
	p := new(DataSource_AuthorizationType)
	*p = x
	return p
}

func (x DataSource_AuthorizationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataSource_AuthorizationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_enumTypes[1].Descriptor()
}

func (DataSource_AuthorizationType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_enumTypes[1]
}

func (x DataSource_AuthorizationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataSource_AuthorizationType.Descriptor instead.
func (DataSource_AuthorizationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{1, 0}
}

// Represents how the data source supports data auto refresh.
type DataSource_DataRefreshType int32

const (
	// The data source won't support data auto refresh, which is default value.
	DataSource_DATA_REFRESH_TYPE_UNSPECIFIED DataSource_DataRefreshType = 0
	// The data source supports data auto refresh, and runs will be scheduled
	// for the past few days. Does not allow custom values to be set for each
	// transfer config.
	DataSource_SLIDING_WINDOW DataSource_DataRefreshType = 1
	// The data source supports data auto refresh, and runs will be scheduled
	// for the past few days. Allows custom values to be set for each transfer
	// config.
	DataSource_CUSTOM_SLIDING_WINDOW DataSource_DataRefreshType = 2
)

// Enum value maps for DataSource_DataRefreshType.
var (
	DataSource_DataRefreshType_name = map[int32]string{
		0: "DATA_REFRESH_TYPE_UNSPECIFIED",
		1: "SLIDING_WINDOW",
		2: "CUSTOM_SLIDING_WINDOW",
	}
	DataSource_DataRefreshType_value = map[string]int32{
		"DATA_REFRESH_TYPE_UNSPECIFIED": 0,
		"SLIDING_WINDOW":                1,
		"CUSTOM_SLIDING_WINDOW":         2,
	}
)

func (x DataSource_DataRefreshType) Enum() *DataSource_DataRefreshType {
	p := new(DataSource_DataRefreshType)
	*p = x
	return p
}

func (x DataSource_DataRefreshType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataSource_DataRefreshType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_enumTypes[2].Descriptor()
}

func (DataSource_DataRefreshType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_enumTypes[2]
}

func (x DataSource_DataRefreshType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataSource_DataRefreshType.Descriptor instead.
func (DataSource_DataRefreshType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{1, 1}
}

// Represents which runs should be pulled.
type ListTransferRunsRequest_RunAttempt int32

const (
	// All runs should be returned.
	ListTransferRunsRequest_RUN_ATTEMPT_UNSPECIFIED ListTransferRunsRequest_RunAttempt = 0
	// Only latest run per day should be returned.
	ListTransferRunsRequest_LATEST ListTransferRunsRequest_RunAttempt = 1
)

// Enum value maps for ListTransferRunsRequest_RunAttempt.
var (
	ListTransferRunsRequest_RunAttempt_name = map[int32]string{
		0: "RUN_ATTEMPT_UNSPECIFIED",
		1: "LATEST",
	}
	ListTransferRunsRequest_RunAttempt_value = map[string]int32{
		"RUN_ATTEMPT_UNSPECIFIED": 0,
		"LATEST":                  1,
	}
)

func (x ListTransferRunsRequest_RunAttempt) Enum() *ListTransferRunsRequest_RunAttempt {
	p := new(ListTransferRunsRequest_RunAttempt)
	*p = x
	return p
}

func (x ListTransferRunsRequest_RunAttempt) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListTransferRunsRequest_RunAttempt) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_enumTypes[3].Descriptor()
}

func (ListTransferRunsRequest_RunAttempt) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_enumTypes[3]
}

func (x ListTransferRunsRequest_RunAttempt) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListTransferRunsRequest_RunAttempt.Descriptor instead.
func (ListTransferRunsRequest_RunAttempt) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{13, 0}
}

// A parameter used to define custom fields in a data source definition.
type DataSourceParameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parameter identifier.
	ParamId string `protobuf:"bytes,1,opt,name=param_id,json=paramId,proto3" json:"param_id,omitempty"`
	// Parameter display name in the user interface.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Parameter description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Parameter type.
	Type DataSourceParameter_Type `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.bigquery.datatransfer.v1.DataSourceParameter_Type" json:"type,omitempty"`
	// Is parameter required.
	Required bool `protobuf:"varint,5,opt,name=required,proto3" json:"required,omitempty"`
	// Deprecated. This field has no effect.
	Repeated bool `protobuf:"varint,6,opt,name=repeated,proto3" json:"repeated,omitempty"`
	// Regular expression which can be used for parameter validation.
	ValidationRegex string `protobuf:"bytes,7,opt,name=validation_regex,json=validationRegex,proto3" json:"validation_regex,omitempty"`
	// All possible values for the parameter.
	AllowedValues []string `protobuf:"bytes,8,rep,name=allowed_values,json=allowedValues,proto3" json:"allowed_values,omitempty"`
	// For integer and double values specifies minimum allowed value.
	MinValue *wrapperspb.DoubleValue `protobuf:"bytes,9,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// For integer and double values specifies maximum allowed value.
	MaxValue *wrapperspb.DoubleValue `protobuf:"bytes,10,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// Deprecated. This field has no effect.
	Fields []*DataSourceParameter `protobuf:"bytes,11,rep,name=fields,proto3" json:"fields,omitempty"`
	// Description of the requirements for this field, in case the user input does
	// not fulfill the regex pattern or min/max values.
	ValidationDescription string `protobuf:"bytes,12,opt,name=validation_description,json=validationDescription,proto3" json:"validation_description,omitempty"`
	// URL to a help document to further explain the naming requirements.
	ValidationHelpUrl string `protobuf:"bytes,13,opt,name=validation_help_url,json=validationHelpUrl,proto3" json:"validation_help_url,omitempty"`
	// Cannot be changed after initial creation.
	Immutable bool `protobuf:"varint,14,opt,name=immutable,proto3" json:"immutable,omitempty"`
	// Deprecated. This field has no effect.
	Recurse bool `protobuf:"varint,15,opt,name=recurse,proto3" json:"recurse,omitempty"`
	// If true, it should not be used in new transfers, and it should not be
	// visible to users.
	Deprecated bool `protobuf:"varint,20,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
}

func (x *DataSourceParameter) Reset() {
	*x = DataSourceParameter{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataSourceParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSourceParameter) ProtoMessage() {}

func (x *DataSourceParameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSourceParameter.ProtoReflect.Descriptor instead.
func (*DataSourceParameter) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{0}
}

func (x *DataSourceParameter) GetParamId() string {
	if x != nil {
		return x.ParamId
	}
	return ""
}

func (x *DataSourceParameter) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DataSourceParameter) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DataSourceParameter) GetType() DataSourceParameter_Type {
	if x != nil {
		return x.Type
	}
	return DataSourceParameter_TYPE_UNSPECIFIED
}

func (x *DataSourceParameter) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *DataSourceParameter) GetRepeated() bool {
	if x != nil {
		return x.Repeated
	}
	return false
}

func (x *DataSourceParameter) GetValidationRegex() string {
	if x != nil {
		return x.ValidationRegex
	}
	return ""
}

func (x *DataSourceParameter) GetAllowedValues() []string {
	if x != nil {
		return x.AllowedValues
	}
	return nil
}

func (x *DataSourceParameter) GetMinValue() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MinValue
	}
	return nil
}

func (x *DataSourceParameter) GetMaxValue() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MaxValue
	}
	return nil
}

func (x *DataSourceParameter) GetFields() []*DataSourceParameter {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *DataSourceParameter) GetValidationDescription() string {
	if x != nil {
		return x.ValidationDescription
	}
	return ""
}

func (x *DataSourceParameter) GetValidationHelpUrl() string {
	if x != nil {
		return x.ValidationHelpUrl
	}
	return ""
}

func (x *DataSourceParameter) GetImmutable() bool {
	if x != nil {
		return x.Immutable
	}
	return false
}

func (x *DataSourceParameter) GetRecurse() bool {
	if x != nil {
		return x.Recurse
	}
	return false
}

func (x *DataSourceParameter) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

// Defines the properties and custom parameters for a data source.
type DataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Data source resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Data source id.
	DataSourceId string `protobuf:"bytes,2,opt,name=data_source_id,json=dataSourceId,proto3" json:"data_source_id,omitempty"`
	// User friendly data source name.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// User friendly data source description string.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Data source client id which should be used to receive refresh token.
	ClientId string `protobuf:"bytes,5,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Api auth scopes for which refresh token needs to be obtained. These are
	// scopes needed by a data source to prepare data and ingest them into
	// BigQuery, e.g., https://www.googleapis.com/auth/bigquery
	Scopes []string `protobuf:"bytes,6,rep,name=scopes,proto3" json:"scopes,omitempty"`
	// Deprecated. This field has no effect.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/datatransfer/v1/datatransfer.proto.
	TransferType TransferType `protobuf:"varint,7,opt,name=transfer_type,json=transferType,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferType" json:"transfer_type,omitempty"`
	// Deprecated. This field has no effect.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/datatransfer/v1/datatransfer.proto.
	SupportsMultipleTransfers bool `protobuf:"varint,8,opt,name=supports_multiple_transfers,json=supportsMultipleTransfers,proto3" json:"supports_multiple_transfers,omitempty"`
	// The number of seconds to wait for an update from the data source
	// before the Data Transfer Service marks the transfer as FAILED.
	UpdateDeadlineSeconds int32 `protobuf:"varint,9,opt,name=update_deadline_seconds,json=updateDeadlineSeconds,proto3" json:"update_deadline_seconds,omitempty"`
	// Default data transfer schedule.
	// Examples of valid schedules include:
	// `1st,3rd monday of month 15:30`,
	// `every wed,fri of jan,jun 13:15`, and
	// `first sunday of quarter 00:00`.
	DefaultSchedule string `protobuf:"bytes,10,opt,name=default_schedule,json=defaultSchedule,proto3" json:"default_schedule,omitempty"`
	// Specifies whether the data source supports a user defined schedule, or
	// operates on the default schedule.
	// When set to `true`, user can override default schedule.
	SupportsCustomSchedule bool `protobuf:"varint,11,opt,name=supports_custom_schedule,json=supportsCustomSchedule,proto3" json:"supports_custom_schedule,omitempty"`
	// Data source parameters.
	Parameters []*DataSourceParameter `protobuf:"bytes,12,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Url for the help document for this data source.
	HelpUrl string `protobuf:"bytes,13,opt,name=help_url,json=helpUrl,proto3" json:"help_url,omitempty"`
	// Indicates the type of authorization.
	AuthorizationType DataSource_AuthorizationType `protobuf:"varint,14,opt,name=authorization_type,json=authorizationType,proto3,enum=google.cloud.bigquery.datatransfer.v1.DataSource_AuthorizationType" json:"authorization_type,omitempty"`
	// Specifies whether the data source supports automatic data refresh for the
	// past few days, and how it's supported.
	// For some data sources, data might not be complete until a few days later,
	// so it's useful to refresh data automatically.
	DataRefreshType DataSource_DataRefreshType `protobuf:"varint,15,opt,name=data_refresh_type,json=dataRefreshType,proto3,enum=google.cloud.bigquery.datatransfer.v1.DataSource_DataRefreshType" json:"data_refresh_type,omitempty"`
	// Default data refresh window on days.
	// Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
	DefaultDataRefreshWindowDays int32 `protobuf:"varint,16,opt,name=default_data_refresh_window_days,json=defaultDataRefreshWindowDays,proto3" json:"default_data_refresh_window_days,omitempty"`
	// Disables backfilling and manual run scheduling
	// for the data source.
	ManualRunsDisabled bool `protobuf:"varint,17,opt,name=manual_runs_disabled,json=manualRunsDisabled,proto3" json:"manual_runs_disabled,omitempty"`
	// The minimum interval for scheduler to schedule runs.
	MinimumScheduleInterval *durationpb.Duration `protobuf:"bytes,18,opt,name=minimum_schedule_interval,json=minimumScheduleInterval,proto3" json:"minimum_schedule_interval,omitempty"`
}

func (x *DataSource) Reset() {
	*x = DataSource{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSource) ProtoMessage() {}

func (x *DataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSource.ProtoReflect.Descriptor instead.
func (*DataSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{1}
}

func (x *DataSource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataSource) GetDataSourceId() string {
	if x != nil {
		return x.DataSourceId
	}
	return ""
}

func (x *DataSource) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DataSource) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DataSource) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *DataSource) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/bigquery/datatransfer/v1/datatransfer.proto.
func (x *DataSource) GetTransferType() TransferType {
	if x != nil {
		return x.TransferType
	}
	return TransferType_TRANSFER_TYPE_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/cloud/bigquery/datatransfer/v1/datatransfer.proto.
func (x *DataSource) GetSupportsMultipleTransfers() bool {
	if x != nil {
		return x.SupportsMultipleTransfers
	}
	return false
}

func (x *DataSource) GetUpdateDeadlineSeconds() int32 {
	if x != nil {
		return x.UpdateDeadlineSeconds
	}
	return 0
}

func (x *DataSource) GetDefaultSchedule() string {
	if x != nil {
		return x.DefaultSchedule
	}
	return ""
}

func (x *DataSource) GetSupportsCustomSchedule() bool {
	if x != nil {
		return x.SupportsCustomSchedule
	}
	return false
}

func (x *DataSource) GetParameters() []*DataSourceParameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *DataSource) GetHelpUrl() string {
	if x != nil {
		return x.HelpUrl
	}
	return ""
}

func (x *DataSource) GetAuthorizationType() DataSource_AuthorizationType {
	if x != nil {
		return x.AuthorizationType
	}
	return DataSource_AUTHORIZATION_TYPE_UNSPECIFIED
}

func (x *DataSource) GetDataRefreshType() DataSource_DataRefreshType {
	if x != nil {
		return x.DataRefreshType
	}
	return DataSource_DATA_REFRESH_TYPE_UNSPECIFIED
}

func (x *DataSource) GetDefaultDataRefreshWindowDays() int32 {
	if x != nil {
		return x.DefaultDataRefreshWindowDays
	}
	return 0
}

func (x *DataSource) GetManualRunsDisabled() bool {
	if x != nil {
		return x.ManualRunsDisabled
	}
	return false
}

func (x *DataSource) GetMinimumScheduleInterval() *durationpb.Duration {
	if x != nil {
		return x.MinimumScheduleInterval
	}
	return nil
}

// A request to get data source info.
type GetDataSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The field will contain name of the resource requested, for
	// example: `projects/{project_id}/dataSources/{data_source_id}` or
	// `projects/{project_id}/locations/{location_id}/dataSources/{data_source_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataSourceRequest) Reset() {
	*x = GetDataSourceRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDataSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataSourceRequest) ProtoMessage() {}

func (x *GetDataSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataSourceRequest.ProtoReflect.Descriptor instead.
func (*GetDataSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{2}
}

func (x *GetDataSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list supported data sources and their data transfer settings.
type ListDataSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery project id for which data sources should be
	// returned. Must be in the form: `projects/{project_id}` or
	// `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListDataSourcesRequest` list results. For multiple-page
	// results, `ListDataSourcesResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListDataSourcesRequest) Reset() {
	*x = ListDataSourcesRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataSourcesRequest) ProtoMessage() {}

func (x *ListDataSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataSourcesRequest.ProtoReflect.Descriptor instead.
func (*ListDataSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{3}
}

func (x *ListDataSourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataSourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDataSourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Returns list of supported data sources and their metadata.
type ListDataSourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of supported data sources and their transfer settings.
	DataSources []*DataSource `protobuf:"bytes,1,rep,name=data_sources,json=dataSources,proto3" json:"data_sources,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListDataSourcesRequest.page_token`
	// to request the next page of list results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataSourcesResponse) Reset() {
	*x = ListDataSourcesResponse{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataSourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataSourcesResponse) ProtoMessage() {}

func (x *ListDataSourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataSourcesResponse.ProtoReflect.Descriptor instead.
func (*ListDataSourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{4}
}

func (x *ListDataSourcesResponse) GetDataSources() []*DataSource {
	if x != nil {
		return x.DataSources
	}
	return nil
}

func (x *ListDataSourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to create a data transfer configuration. If new credentials are
// needed for this transfer configuration, authorization info must be provided.
// If authorization info is provided, the transfer configuration will be
// associated with the user id corresponding to the authorization info.
// Otherwise, the transfer configuration will be associated with the calling
// user.
//
// When using a cross project service account for creating a transfer config,
// you must enable cross project service account usage. For more information,
// see [Disable attachment of service accounts to resources in other
// projects](https://cloud.google.com/resource-manager/docs/organization-policy/restricting-service-accounts#disable_cross_project_service_accounts).
type CreateTransferConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery project id where the transfer configuration should
	// be created. Must be in the format
	// projects/{project_id}/locations/{location_id} or projects/{project_id}. If
	// specified location and location of the destination bigquery dataset do not
	// match - the request will fail.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Data transfer configuration to create.
	TransferConfig *TransferConfig `protobuf:"bytes,2,opt,name=transfer_config,json=transferConfig,proto3" json:"transfer_config,omitempty"`
	// Deprecated: Authorization code was required when
	// `transferConfig.dataSourceId` is 'youtube_channel' but it is no longer used
	// in any data sources. Use `version_info` instead.
	//
	// Optional OAuth2 authorization code to use with this transfer configuration.
	// This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
	// and new credentials are needed, as indicated by `CheckValidCreds`. In order
	// to obtain authorization_code, make a request to the following URL:
	// <pre class="prettyprint" suppresswarning="true">
	// https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
	// </pre>
	// * The <var>client_id</var> is the OAuth client_id of the data source as
	// returned by ListDataSources method.
	// * <var>data_source_scopes</var> are the scopes returned by ListDataSources
	// method.
	//
	// Note that this should not be set when `service_account_name` is used to
	// create the transfer config.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/datatransfer/v1/datatransfer.proto.
	AuthorizationCode string `protobuf:"bytes,3,opt,name=authorization_code,json=authorizationCode,proto3" json:"authorization_code,omitempty"`
	// Optional version info. This parameter replaces `authorization_code` which
	// is no longer used in any data sources. This is required only if
	// `transferConfig.dataSourceId` is 'youtube_channel' *or* new credentials
	// are needed, as indicated by `CheckValidCreds`. In order to obtain version
	// info, make a request to the following URL:
	// <pre class="prettyprint" suppresswarning="true">
	// https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
	// </pre>
	// * The <var>client_id</var> is the OAuth client_id of the data source as
	// returned by ListDataSources method.
	// * <var>data_source_scopes</var> are the scopes returned by ListDataSources
	// method.
	//
	// Note that this should not be set when `service_account_name` is used to
	// create the transfer config.
	VersionInfo string `protobuf:"bytes,5,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	// Optional service account email. If this field is set, the transfer config
	// will be created with this service account's credentials. It requires that
	// the requesting user calling this API has permissions to act as this service
	// account.
	//
	// Note that not all data sources support service account credentials when
	// creating a transfer config. For the latest list of data sources, read about
	// [using service
	// accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
	ServiceAccountName string `protobuf:"bytes,6,opt,name=service_account_name,json=serviceAccountName,proto3" json:"service_account_name,omitempty"`
}

func (x *CreateTransferConfigRequest) Reset() {
	*x = CreateTransferConfigRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTransferConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTransferConfigRequest) ProtoMessage() {}

func (x *CreateTransferConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTransferConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateTransferConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{5}
}

func (x *CreateTransferConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTransferConfigRequest) GetTransferConfig() *TransferConfig {
	if x != nil {
		return x.TransferConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/bigquery/datatransfer/v1/datatransfer.proto.
func (x *CreateTransferConfigRequest) GetAuthorizationCode() string {
	if x != nil {
		return x.AuthorizationCode
	}
	return ""
}

func (x *CreateTransferConfigRequest) GetVersionInfo() string {
	if x != nil {
		return x.VersionInfo
	}
	return ""
}

func (x *CreateTransferConfigRequest) GetServiceAccountName() string {
	if x != nil {
		return x.ServiceAccountName
	}
	return ""
}

// A request to update a transfer configuration. To update the user id of the
// transfer configuration, authorization info needs to be provided.
//
// When using a cross project service account for updating a transfer config,
// you must enable cross project service account usage. For more information,
// see [Disable attachment of service accounts to resources in other
// projects](https://cloud.google.com/resource-manager/docs/organization-policy/restricting-service-accounts#disable_cross_project_service_accounts).
type UpdateTransferConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Data transfer configuration to create.
	TransferConfig *TransferConfig `protobuf:"bytes,1,opt,name=transfer_config,json=transferConfig,proto3" json:"transfer_config,omitempty"`
	// Deprecated: Authorization code was required when
	// `transferConfig.dataSourceId` is 'youtube_channel' but it is no longer used
	// in any data sources. Use `version_info` instead.
	//
	// Optional OAuth2 authorization code to use with this transfer configuration.
	// This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
	// and new credentials are needed, as indicated by `CheckValidCreds`. In order
	// to obtain authorization_code, make a request to the following URL:
	// <pre class="prettyprint" suppresswarning="true">
	// https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
	// </pre>
	// * The <var>client_id</var> is the OAuth client_id of the data source as
	// returned by ListDataSources method.
	// * <var>data_source_scopes</var> are the scopes returned by ListDataSources
	// method.
	//
	// Note that this should not be set when `service_account_name` is used to
	// update the transfer config.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/datatransfer/v1/datatransfer.proto.
	AuthorizationCode string `protobuf:"bytes,3,opt,name=authorization_code,json=authorizationCode,proto3" json:"authorization_code,omitempty"`
	// Required. Required list of fields to be updated in this request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional version info. This parameter replaces `authorization_code` which
	// is no longer used in any data sources. This is required only if
	// `transferConfig.dataSourceId` is 'youtube_channel' *or* new credentials
	// are needed, as indicated by `CheckValidCreds`. In order to obtain version
	// info, make a request to the following URL:
	// <pre class="prettyprint" suppresswarning="true">
	// https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
	// </pre>
	// * The <var>client_id</var> is the OAuth client_id of the data source as
	// returned by ListDataSources method.
	// * <var>data_source_scopes</var> are the scopes returned by ListDataSources
	// method.
	//
	// Note that this should not be set when `service_account_name` is used to
	// update the transfer config.
	VersionInfo string `protobuf:"bytes,5,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	// Optional service account email. If this field is set, the transfer config
	// will be created with this service account's credentials. It requires that
	// the requesting user calling this API has permissions to act as this service
	// account.
	//
	// Note that not all data sources support service account credentials when
	// creating a transfer config. For the latest list of data sources, read about
	// [using service
	// accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
	ServiceAccountName string `protobuf:"bytes,6,opt,name=service_account_name,json=serviceAccountName,proto3" json:"service_account_name,omitempty"`
}

func (x *UpdateTransferConfigRequest) Reset() {
	*x = UpdateTransferConfigRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateTransferConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTransferConfigRequest) ProtoMessage() {}

func (x *UpdateTransferConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTransferConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateTransferConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateTransferConfigRequest) GetTransferConfig() *TransferConfig {
	if x != nil {
		return x.TransferConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/bigquery/datatransfer/v1/datatransfer.proto.
func (x *UpdateTransferConfigRequest) GetAuthorizationCode() string {
	if x != nil {
		return x.AuthorizationCode
	}
	return ""
}

func (x *UpdateTransferConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTransferConfigRequest) GetVersionInfo() string {
	if x != nil {
		return x.VersionInfo
	}
	return ""
}

func (x *UpdateTransferConfigRequest) GetServiceAccountName() string {
	if x != nil {
		return x.ServiceAccountName
	}
	return ""
}

// A request to get data transfer information.
type GetTransferConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The field will contain name of the resource requested, for
	// example: `projects/{project_id}/transferConfigs/{config_id}` or
	// `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTransferConfigRequest) Reset() {
	*x = GetTransferConfigRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTransferConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTransferConfigRequest) ProtoMessage() {}

func (x *GetTransferConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTransferConfigRequest.ProtoReflect.Descriptor instead.
func (*GetTransferConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{7}
}

func (x *GetTransferConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to delete data transfer information. All associated transfer runs
// and log messages will be deleted as well.
type DeleteTransferConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The field will contain name of the resource requested, for
	// example: `projects/{project_id}/transferConfigs/{config_id}` or
	// `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTransferConfigRequest) Reset() {
	*x = DeleteTransferConfigRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTransferConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTransferConfigRequest) ProtoMessage() {}

func (x *DeleteTransferConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTransferConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteTransferConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteTransferConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to get data transfer run information.
type GetTransferRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The field will contain name of the resource requested, for
	// example: `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
	// or
	// `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTransferRunRequest) Reset() {
	*x = GetTransferRunRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTransferRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTransferRunRequest) ProtoMessage() {}

func (x *GetTransferRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTransferRunRequest.ProtoReflect.Descriptor instead.
func (*GetTransferRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{9}
}

func (x *GetTransferRunRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to delete data transfer run information.
type DeleteTransferRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The field will contain name of the resource requested, for
	// example: `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
	// or
	// `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTransferRunRequest) Reset() {
	*x = DeleteTransferRunRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTransferRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTransferRunRequest) ProtoMessage() {}

func (x *DeleteTransferRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTransferRunRequest.ProtoReflect.Descriptor instead.
func (*DeleteTransferRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteTransferRunRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to list data transfers configured for a BigQuery project.
type ListTransferConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery project id for which transfer configs
	// should be returned: `projects/{project_id}` or
	// `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// When specified, only configurations of requested data sources are returned.
	DataSourceIds []string `protobuf:"bytes,2,rep,name=data_source_ids,json=dataSourceIds,proto3" json:"data_source_ids,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransfersRequest` list results. For multiple-page
	// results, `ListTransfersResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListTransferConfigsRequest) Reset() {
	*x = ListTransferConfigsRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTransferConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferConfigsRequest) ProtoMessage() {}

func (x *ListTransferConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListTransferConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{11}
}

func (x *ListTransferConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTransferConfigsRequest) GetDataSourceIds() []string {
	if x != nil {
		return x.DataSourceIds
	}
	return nil
}

func (x *ListTransferConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTransferConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// The returned list of pipelines in the project.
type ListTransferConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The stored pipeline transfer configurations.
	TransferConfigs []*TransferConfig `protobuf:"bytes,1,rep,name=transfer_configs,json=transferConfigs,proto3" json:"transfer_configs,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListTransferConfigsRequest.page_token`
	// to request the next page of list results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTransferConfigsResponse) Reset() {
	*x = ListTransferConfigsResponse{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTransferConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferConfigsResponse) ProtoMessage() {}

func (x *ListTransferConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListTransferConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{12}
}

func (x *ListTransferConfigsResponse) GetTransferConfigs() []*TransferConfig {
	if x != nil {
		return x.TransferConfigs
	}
	return nil
}

func (x *ListTransferConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to list data transfer runs.
type ListTransferRunsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of transfer configuration for which transfer runs should be
	// retrieved. Format of transfer configuration resource name is:
	// `projects/{project_id}/transferConfigs/{config_id}` or
	// `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// When specified, only transfer runs with requested states are returned.
	States []TransferState `protobuf:"varint,2,rep,packed,name=states,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferState" json:"states,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransferRunsRequest` list results. For multiple-page
	// results, `ListTransferRunsResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Indicates how run attempts are to be pulled.
	RunAttempt ListTransferRunsRequest_RunAttempt `protobuf:"varint,5,opt,name=run_attempt,json=runAttempt,proto3,enum=google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest_RunAttempt" json:"run_attempt,omitempty"`
}

func (x *ListTransferRunsRequest) Reset() {
	*x = ListTransferRunsRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTransferRunsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferRunsRequest) ProtoMessage() {}

func (x *ListTransferRunsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferRunsRequest.ProtoReflect.Descriptor instead.
func (*ListTransferRunsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{13}
}

func (x *ListTransferRunsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTransferRunsRequest) GetStates() []TransferState {
	if x != nil {
		return x.States
	}
	return nil
}

func (x *ListTransferRunsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTransferRunsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTransferRunsRequest) GetRunAttempt() ListTransferRunsRequest_RunAttempt {
	if x != nil {
		return x.RunAttempt
	}
	return ListTransferRunsRequest_RUN_ATTEMPT_UNSPECIFIED
}

// The returned list of pipelines in the project.
type ListTransferRunsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The stored pipeline transfer runs.
	TransferRuns []*TransferRun `protobuf:"bytes,1,rep,name=transfer_runs,json=transferRuns,proto3" json:"transfer_runs,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListTransferRunsRequest.page_token`
	// to request the next page of list results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTransferRunsResponse) Reset() {
	*x = ListTransferRunsResponse{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTransferRunsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferRunsResponse) ProtoMessage() {}

func (x *ListTransferRunsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferRunsResponse.ProtoReflect.Descriptor instead.
func (*ListTransferRunsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{14}
}

func (x *ListTransferRunsResponse) GetTransferRuns() []*TransferRun {
	if x != nil {
		return x.TransferRuns
	}
	return nil
}

func (x *ListTransferRunsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to get user facing log messages associated with data transfer run.
type ListTransferLogsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Transfer run name in the form:
	// `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
	// `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransferLogsRequest` list results. For multiple-page
	// results, `ListTransferLogsResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Message types to return. If not populated - INFO, WARNING and ERROR
	// messages are returned.
	MessageTypes []TransferMessage_MessageSeverity `protobuf:"varint,6,rep,packed,name=message_types,json=messageTypes,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferMessage_MessageSeverity" json:"message_types,omitempty"`
}

func (x *ListTransferLogsRequest) Reset() {
	*x = ListTransferLogsRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTransferLogsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferLogsRequest) ProtoMessage() {}

func (x *ListTransferLogsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferLogsRequest.ProtoReflect.Descriptor instead.
func (*ListTransferLogsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{15}
}

func (x *ListTransferLogsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTransferLogsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTransferLogsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTransferLogsRequest) GetMessageTypes() []TransferMessage_MessageSeverity {
	if x != nil {
		return x.MessageTypes
	}
	return nil
}

// The returned list transfer run messages.
type ListTransferLogsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The stored pipeline transfer messages.
	TransferMessages []*TransferMessage `protobuf:"bytes,1,rep,name=transfer_messages,json=transferMessages,proto3" json:"transfer_messages,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `GetTransferRunLogRequest.page_token`
	// to request the next page of list results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTransferLogsResponse) Reset() {
	*x = ListTransferLogsResponse{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTransferLogsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferLogsResponse) ProtoMessage() {}

func (x *ListTransferLogsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferLogsResponse.ProtoReflect.Descriptor instead.
func (*ListTransferLogsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{16}
}

func (x *ListTransferLogsResponse) GetTransferMessages() []*TransferMessage {
	if x != nil {
		return x.TransferMessages
	}
	return nil
}

func (x *ListTransferLogsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to determine whether the user has valid credentials. This method
// is used to limit the number of OAuth popups in the user interface. The
// user id is inferred from the API call context.
// If the data source has the Google+ authorization type, this method
// returns false, as it cannot be determined whether the credentials are
// already valid merely based on the user id.
type CheckValidCredsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The data source in the form:
	// `projects/{project_id}/dataSources/{data_source_id}` or
	// `projects/{project_id}/locations/{location_id}/dataSources/{data_source_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CheckValidCredsRequest) Reset() {
	*x = CheckValidCredsRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckValidCredsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckValidCredsRequest) ProtoMessage() {}

func (x *CheckValidCredsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckValidCredsRequest.ProtoReflect.Descriptor instead.
func (*CheckValidCredsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{17}
}

func (x *CheckValidCredsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A response indicating whether the credentials exist and are valid.
type CheckValidCredsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set to `true`, the credentials exist and are valid.
	HasValidCreds bool `protobuf:"varint,1,opt,name=has_valid_creds,json=hasValidCreds,proto3" json:"has_valid_creds,omitempty"`
}

func (x *CheckValidCredsResponse) Reset() {
	*x = CheckValidCredsResponse{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckValidCredsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckValidCredsResponse) ProtoMessage() {}

func (x *CheckValidCredsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckValidCredsResponse.ProtoReflect.Descriptor instead.
func (*CheckValidCredsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{18}
}

func (x *CheckValidCredsResponse) GetHasValidCreds() bool {
	if x != nil {
		return x.HasValidCreds
	}
	return false
}

// A request to schedule transfer runs for a time range.
type ScheduleTransferRunsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Transfer configuration name in the form:
	// `projects/{project_id}/transferConfigs/{config_id}` or
	// `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Start time of the range of transfer runs. For example,
	// `"2017-05-25T00:00:00+00:00"`.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Required. End time of the range of transfer runs. For example,
	// `"2017-05-30T00:00:00+00:00"`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *ScheduleTransferRunsRequest) Reset() {
	*x = ScheduleTransferRunsRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScheduleTransferRunsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScheduleTransferRunsRequest) ProtoMessage() {}

func (x *ScheduleTransferRunsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScheduleTransferRunsRequest.ProtoReflect.Descriptor instead.
func (*ScheduleTransferRunsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{19}
}

func (x *ScheduleTransferRunsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ScheduleTransferRunsRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ScheduleTransferRunsRequest) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// A response to schedule transfer runs for a time range.
type ScheduleTransferRunsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The transfer runs that were scheduled.
	Runs []*TransferRun `protobuf:"bytes,1,rep,name=runs,proto3" json:"runs,omitempty"`
}

func (x *ScheduleTransferRunsResponse) Reset() {
	*x = ScheduleTransferRunsResponse{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScheduleTransferRunsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScheduleTransferRunsResponse) ProtoMessage() {}

func (x *ScheduleTransferRunsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScheduleTransferRunsResponse.ProtoReflect.Descriptor instead.
func (*ScheduleTransferRunsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{20}
}

func (x *ScheduleTransferRunsResponse) GetRuns() []*TransferRun {
	if x != nil {
		return x.Runs
	}
	return nil
}

// A request to start manual transfer runs.
type StartManualTransferRunsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Transfer configuration name in the form:
	// `projects/{project_id}/transferConfigs/{config_id}` or
	// `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The requested time specification - this can be a time range or a specific
	// run_time.
	//
	// Types that are assignable to Time:
	//
	//	*StartManualTransferRunsRequest_RequestedTimeRange
	//	*StartManualTransferRunsRequest_RequestedRunTime
	Time isStartManualTransferRunsRequest_Time `protobuf_oneof:"time"`
}

func (x *StartManualTransferRunsRequest) Reset() {
	*x = StartManualTransferRunsRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartManualTransferRunsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartManualTransferRunsRequest) ProtoMessage() {}

func (x *StartManualTransferRunsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartManualTransferRunsRequest.ProtoReflect.Descriptor instead.
func (*StartManualTransferRunsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{21}
}

func (x *StartManualTransferRunsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *StartManualTransferRunsRequest) GetTime() isStartManualTransferRunsRequest_Time {
	if m != nil {
		return m.Time
	}
	return nil
}

func (x *StartManualTransferRunsRequest) GetRequestedTimeRange() *StartManualTransferRunsRequest_TimeRange {
	if x, ok := x.GetTime().(*StartManualTransferRunsRequest_RequestedTimeRange); ok {
		return x.RequestedTimeRange
	}
	return nil
}

func (x *StartManualTransferRunsRequest) GetRequestedRunTime() *timestamppb.Timestamp {
	if x, ok := x.GetTime().(*StartManualTransferRunsRequest_RequestedRunTime); ok {
		return x.RequestedRunTime
	}
	return nil
}

type isStartManualTransferRunsRequest_Time interface {
	isStartManualTransferRunsRequest_Time()
}

type StartManualTransferRunsRequest_RequestedTimeRange struct {
	// A time_range start and end timestamp for historical data files or reports
	// that are scheduled to be transferred by the scheduled transfer run.
	// requested_time_range must be a past time and cannot include future time
	// values.
	RequestedTimeRange *StartManualTransferRunsRequest_TimeRange `protobuf:"bytes,3,opt,name=requested_time_range,json=requestedTimeRange,proto3,oneof"`
}

type StartManualTransferRunsRequest_RequestedRunTime struct {
	// A run_time timestamp for historical data files or reports
	// that are scheduled to be transferred by the scheduled transfer run.
	// requested_run_time must be a past time and cannot include future time
	// values.
	RequestedRunTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=requested_run_time,json=requestedRunTime,proto3,oneof"`
}

func (*StartManualTransferRunsRequest_RequestedTimeRange) isStartManualTransferRunsRequest_Time() {}

func (*StartManualTransferRunsRequest_RequestedRunTime) isStartManualTransferRunsRequest_Time() {}

// A response to start manual transfer runs.
type StartManualTransferRunsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The transfer runs that were created.
	Runs []*TransferRun `protobuf:"bytes,1,rep,name=runs,proto3" json:"runs,omitempty"`
}

func (x *StartManualTransferRunsResponse) Reset() {
	*x = StartManualTransferRunsResponse{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartManualTransferRunsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartManualTransferRunsResponse) ProtoMessage() {}

func (x *StartManualTransferRunsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartManualTransferRunsResponse.ProtoReflect.Descriptor instead.
func (*StartManualTransferRunsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{22}
}

func (x *StartManualTransferRunsResponse) GetRuns() []*TransferRun {
	if x != nil {
		return x.Runs
	}
	return nil
}

// A request to enroll a set of data sources so they are visible in the
// BigQuery UI's `Transfer` tab.
type EnrollDataSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project resource in the form:
	// `projects/{project_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Data sources that are enrolled. It is required to provide at least one
	// data source id.
	DataSourceIds []string `protobuf:"bytes,2,rep,name=data_source_ids,json=dataSourceIds,proto3" json:"data_source_ids,omitempty"`
}

func (x *EnrollDataSourcesRequest) Reset() {
	*x = EnrollDataSourcesRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnrollDataSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnrollDataSourcesRequest) ProtoMessage() {}

func (x *EnrollDataSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnrollDataSourcesRequest.ProtoReflect.Descriptor instead.
func (*EnrollDataSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{23}
}

func (x *EnrollDataSourcesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnrollDataSourcesRequest) GetDataSourceIds() []string {
	if x != nil {
		return x.DataSourceIds
	}
	return nil
}

// A request to unenroll a set of data sources so they are no longer visible in
// the BigQuery UI's `Transfer` tab.
type UnenrollDataSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project resource in the form:
	// `projects/{project_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Data sources that are unenrolled. It is required to provide at least one
	// data source id.
	DataSourceIds []string `protobuf:"bytes,2,rep,name=data_source_ids,json=dataSourceIds,proto3" json:"data_source_ids,omitempty"`
}

func (x *UnenrollDataSourcesRequest) Reset() {
	*x = UnenrollDataSourcesRequest{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UnenrollDataSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnenrollDataSourcesRequest) ProtoMessage() {}

func (x *UnenrollDataSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnenrollDataSourcesRequest.ProtoReflect.Descriptor instead.
func (*UnenrollDataSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{24}
}

func (x *UnenrollDataSourcesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UnenrollDataSourcesRequest) GetDataSourceIds() []string {
	if x != nil {
		return x.DataSourceIds
	}
	return nil
}

// A specification for a time range, this will request transfer runs with
// run_time between start_time (inclusive) and end_time (exclusive).
type StartManualTransferRunsRequest_TimeRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start time of the range of transfer runs. For example,
	// `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
	// the end_time. Creates transfer runs where run_time is in the range
	// between start_time (inclusive) and end_time (exclusive).
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of the range of transfer runs. For example,
	// `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
	// Creates transfer runs where run_time is in the range between start_time
	// (inclusive) and end_time (exclusive).
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *StartManualTransferRunsRequest_TimeRange) Reset() {
	*x = StartManualTransferRunsRequest_TimeRange{}
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartManualTransferRunsRequest_TimeRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartManualTransferRunsRequest_TimeRange) ProtoMessage() {}

func (x *StartManualTransferRunsRequest_TimeRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartManualTransferRunsRequest_TimeRange.ProtoReflect.Descriptor instead.
func (*StartManualTransferRunsRequest_TimeRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP(), []int{21, 0}
}

func (x *StartManualTransferRunsRequest_TimeRange) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *StartManualTransferRunsRequest_TimeRange) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

var File_google_cloud_bigquery_datatransfer_v1_datatransfer_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70,
	0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd2, 0x06, 0x0a, 0x13, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x49, 0x64, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12,
	0x29, 0x0a, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x67, 0x65, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0x39, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x39, 0x0a, 0x09,
	0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6d,
	0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x52, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x35, 0x0a, 0x16, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x68, 0x65, 0x6c, 0x70, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x6c, 0x70, 0x55,
	0x72, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6d, 0x6d, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x6d, 0x6d, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x07, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a,
	0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x22, 0x73, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45, 0x52, 0x10,
	0x02, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x0b, 0x0a,
	0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45,
	0x43, 0x4f, 0x52, 0x44, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x4c, 0x55, 0x53, 0x5f, 0x50,
	0x41, 0x47, 0x45, 0x10, 0x06, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x07, 0x22,
	0xc9, 0x0b, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12,
	0x16, 0x0a, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x5c, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x42, 0x0a, 0x1b, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x19,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x73, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x38, 0x0a, 0x18,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x5a, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x68, 0x65, 0x6c, 0x70, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x68, 0x65, 0x6c, 0x70, 0x55, 0x72, 0x6c, 0x12, 0x72, 0x0a,
	0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x11,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x6d, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73,
	0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0f, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x46, 0x0a, 0x20, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f,
	0x64, 0x61, 0x79, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1c, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x44, 0x61, 0x79, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x6d, 0x61, 0x6e, 0x75,
	0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6e, 0x73, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x52, 0x75,
	0x6e, 0x73, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x55, 0x0a, 0x19, 0x6d, 0x69,
	0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75,
	0x6d, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x22, 0x8a, 0x01, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x41, 0x55, 0x54, 0x48, 0x4f,
	0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x41,
	0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x44,
	0x45, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x50, 0x4c,
	0x55, 0x53, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x43, 0x4f, 0x44, 0x45, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x46, 0x49, 0x52, 0x53, 0x54,
	0x5f, 0x50, 0x41, 0x52, 0x54, 0x59, 0x5f, 0x4f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x03, 0x22, 0x63,
	0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x21, 0x0a, 0x1d, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53,
	0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x4c, 0x49, 0x44, 0x49, 0x4e, 0x47, 0x5f,
	0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x55, 0x53, 0x54,
	0x4f, 0x4d, 0x5f, 0x53, 0x4c, 0x49, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f,
	0x57, 0x10, 0x02, 0x3a, 0xa5, 0x01, 0xea, 0x41, 0xa1, 0x01, 0x0a, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x22, 0x62, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa4, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x30, 0x12, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x9c, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x54, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0b, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xde, 0x02, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12, 0x32, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x63, 0x0a, 0x0f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31,
	0x0a, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x11,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xcc, 0x02, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a, 0x12, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x11, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x12, 0x21, 0x0a, 0x0c, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x6a, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x6d, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x5c, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52,
	0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a,
	0x27, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5f,
	0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xd4, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12, 0x32, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x2b, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8f, 0x03, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x4c, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x6a, 0x0a, 0x0b, 0x72, 0x75, 0x6e,
	0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52,
	0x75, 0x6e, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x52, 0x0a, 0x72, 0x75, 0x6e, 0x41, 0x74,
	0x74, 0x65, 0x6d, 0x70, 0x74, 0x22, 0x35, 0x0a, 0x0a, 0x52, 0x75, 0x6e, 0x41, 0x74, 0x74, 0x65,
	0x6d, 0x70, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x55, 0x4e, 0x5f, 0x41, 0x54, 0x54, 0x45, 0x4d,
	0x50, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x41, 0x54, 0x45, 0x53, 0x54, 0x10, 0x01, 0x22, 0xa5, 0x01, 0x0a,
	0x18, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x0d, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x52, 0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8b, 0x02, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x6b, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x65, 0x76, 0x65,
	0x72, 0x69, 0x74, 0x79, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x22, 0xb1, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x68, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x64, 0x0a, 0x16, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x43, 0x72, 0x65, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x41, 0x0a, 0x17,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x43, 0x72, 0x65, 0x64, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x68, 0x61, 0x73, 0x5f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x68, 0x61, 0x73, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x43, 0x72, 0x65, 0x64, 0x73, 0x22,
	0xed, 0x01, 0x0a, 0x1b, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x52, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0x66, 0x0a, 0x1c, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x46, 0x0a, 0x04, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75,
	0x6e, 0x52, 0x04, 0x72, 0x75, 0x6e, 0x73, 0x22, 0xcd, 0x03, 0x0a, 0x1e, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52,
	0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x34, 0x0a, 0x32, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x83,
	0x01, 0x0a, 0x14, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x61, 0x6e, 0x75, 0x61,
	0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00,
	0x52, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x4a, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x10,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x52, 0x75, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x1a, 0x7d, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x39, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x42,
	0x06, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x69, 0x0a, 0x1f, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x04, 0x72, 0x75,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x72, 0x75,
	0x6e, 0x73, 0x22, 0x5b, 0x0a, 0x18, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x73, 0x22,
	0x5d, 0x0a, 0x1a, 0x55, 0x6e, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0d, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x73, 0x32, 0xd5,
	0x22, 0x0a, 0x13, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xe6, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x65, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x5a, 0x25, 0x12, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x2f,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xf9, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x67, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x58, 0x5a, 0x25, 0x12, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0xb6, 0x02, 0x0a, 0x14,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0xa2, 0x01, 0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x82, 0x01, 0x3a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5a, 0x3a, 0x3a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x22,
	0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x12, 0xdb, 0x02, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xc7, 0x01, 0xda, 0x41, 0x1b, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa2, 0x01,
	0x3a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5a, 0x4a, 0x3a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x32, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x43, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xe1, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x6d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x60, 0x5a, 0x29, 0x2a, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x2a, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfa, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x6d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x60, 0x5a, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x33,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x8d, 0x02, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x6f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x60, 0x5a, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x33,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0xcd, 0x02, 0x0a, 0x14, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xab, 0x01, 0xda, 0x41, 0x1a, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x2c, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x84, 0x01, 0x3a, 0x01, 0x2a, 0x5a,
	0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x75, 0x6e, 0x73, 0x22, 0x42, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x75, 0x6e, 0x73,
	0x88, 0x02, 0x01, 0x12, 0xbc, 0x02, 0x0a, 0x17, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x61, 0x6e,
	0x75, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x12,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x61, 0x6e,
	0x75, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x91,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8a, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x3e, 0x3a, 0x01, 0x2a,
	0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x52, 0x75, 0x6e, 0x73, 0x22, 0x45, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x52, 0x75,
	0x6e, 0x73, 0x12, 0xff, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x52, 0x75, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x22, 0x7b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6e, 0x5a, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe9, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x7b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x6e, 0x5a, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x92, 0x02, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6e, 0x5a, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x72, 0x75, 0x6e, 0x73, 0x12, 0xb2, 0x02, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c,
	0x6f, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c,
	0x6f, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9c, 0x01, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8c, 0x01, 0x5a, 0x3f,
	0x12, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x73, 0x12,
	0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x73, 0x12, 0x9e, 0x02, 0x0a, 0x0f, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x43, 0x72, 0x65, 0x64, 0x73, 0x12, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x43, 0x72, 0x65, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x43, 0x72, 0x65, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8b, 0x01,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7e, 0x3a, 0x01, 0x2a,
	0x5a, 0x38, 0x3a, 0x01, 0x2a, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x43, 0x72, 0x65, 0x64, 0x73, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68, 0x65, 0x63,
	0x6b, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x43, 0x72, 0x65, 0x64, 0x73, 0x12, 0xda, 0x01, 0x0a, 0x11,
	0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x6c, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x66, 0x3a, 0x01, 0x2a, 0x5a, 0x2c, 0x3a, 0x01, 0x2a, 0x22, 0x27, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0xb2, 0x01, 0x0a, 0x13, 0x55, 0x6e, 0x65,
	0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x65, 0x6e, 0x72, 0x6f, 0x6c,
	0x6c, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x40, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x65, 0x6e, 0x72, 0x6f,
	0x6c, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x57, 0xca,
	0x41, 0x23, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x8b, 0x02, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x29, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescData = file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDesc
)

func file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescData)
	})
	return file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDescData
}

var file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_goTypes = []any{
	(DataSourceParameter_Type)(0),                    // 0: google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type
	(DataSource_AuthorizationType)(0),                // 1: google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType
	(DataSource_DataRefreshType)(0),                  // 2: google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType
	(ListTransferRunsRequest_RunAttempt)(0),          // 3: google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt
	(*DataSourceParameter)(nil),                      // 4: google.cloud.bigquery.datatransfer.v1.DataSourceParameter
	(*DataSource)(nil),                               // 5: google.cloud.bigquery.datatransfer.v1.DataSource
	(*GetDataSourceRequest)(nil),                     // 6: google.cloud.bigquery.datatransfer.v1.GetDataSourceRequest
	(*ListDataSourcesRequest)(nil),                   // 7: google.cloud.bigquery.datatransfer.v1.ListDataSourcesRequest
	(*ListDataSourcesResponse)(nil),                  // 8: google.cloud.bigquery.datatransfer.v1.ListDataSourcesResponse
	(*CreateTransferConfigRequest)(nil),              // 9: google.cloud.bigquery.datatransfer.v1.CreateTransferConfigRequest
	(*UpdateTransferConfigRequest)(nil),              // 10: google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest
	(*GetTransferConfigRequest)(nil),                 // 11: google.cloud.bigquery.datatransfer.v1.GetTransferConfigRequest
	(*DeleteTransferConfigRequest)(nil),              // 12: google.cloud.bigquery.datatransfer.v1.DeleteTransferConfigRequest
	(*GetTransferRunRequest)(nil),                    // 13: google.cloud.bigquery.datatransfer.v1.GetTransferRunRequest
	(*DeleteTransferRunRequest)(nil),                 // 14: google.cloud.bigquery.datatransfer.v1.DeleteTransferRunRequest
	(*ListTransferConfigsRequest)(nil),               // 15: google.cloud.bigquery.datatransfer.v1.ListTransferConfigsRequest
	(*ListTransferConfigsResponse)(nil),              // 16: google.cloud.bigquery.datatransfer.v1.ListTransferConfigsResponse
	(*ListTransferRunsRequest)(nil),                  // 17: google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest
	(*ListTransferRunsResponse)(nil),                 // 18: google.cloud.bigquery.datatransfer.v1.ListTransferRunsResponse
	(*ListTransferLogsRequest)(nil),                  // 19: google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest
	(*ListTransferLogsResponse)(nil),                 // 20: google.cloud.bigquery.datatransfer.v1.ListTransferLogsResponse
	(*CheckValidCredsRequest)(nil),                   // 21: google.cloud.bigquery.datatransfer.v1.CheckValidCredsRequest
	(*CheckValidCredsResponse)(nil),                  // 22: google.cloud.bigquery.datatransfer.v1.CheckValidCredsResponse
	(*ScheduleTransferRunsRequest)(nil),              // 23: google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest
	(*ScheduleTransferRunsResponse)(nil),             // 24: google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsResponse
	(*StartManualTransferRunsRequest)(nil),           // 25: google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
	(*StartManualTransferRunsResponse)(nil),          // 26: google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsResponse
	(*EnrollDataSourcesRequest)(nil),                 // 27: google.cloud.bigquery.datatransfer.v1.EnrollDataSourcesRequest
	(*UnenrollDataSourcesRequest)(nil),               // 28: google.cloud.bigquery.datatransfer.v1.UnenrollDataSourcesRequest
	(*StartManualTransferRunsRequest_TimeRange)(nil), // 29: google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
	(*wrapperspb.DoubleValue)(nil),                   // 30: google.protobuf.DoubleValue
	(TransferType)(0),                                // 31: google.cloud.bigquery.datatransfer.v1.TransferType
	(*durationpb.Duration)(nil),                      // 32: google.protobuf.Duration
	(*TransferConfig)(nil),                           // 33: google.cloud.bigquery.datatransfer.v1.TransferConfig
	(*fieldmaskpb.FieldMask)(nil),                    // 34: google.protobuf.FieldMask
	(TransferState)(0),                               // 35: google.cloud.bigquery.datatransfer.v1.TransferState
	(*TransferRun)(nil),                              // 36: google.cloud.bigquery.datatransfer.v1.TransferRun
	(TransferMessage_MessageSeverity)(0),             // 37: google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity
	(*TransferMessage)(nil),                          // 38: google.cloud.bigquery.datatransfer.v1.TransferMessage
	(*timestamppb.Timestamp)(nil),                    // 39: google.protobuf.Timestamp
	(*emptypb.Empty)(nil),                            // 40: google.protobuf.Empty
}
var file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_depIdxs = []int32{
	0,  // 0: google.cloud.bigquery.datatransfer.v1.DataSourceParameter.type:type_name -> google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type
	30, // 1: google.cloud.bigquery.datatransfer.v1.DataSourceParameter.min_value:type_name -> google.protobuf.DoubleValue
	30, // 2: google.cloud.bigquery.datatransfer.v1.DataSourceParameter.max_value:type_name -> google.protobuf.DoubleValue
	4,  // 3: google.cloud.bigquery.datatransfer.v1.DataSourceParameter.fields:type_name -> google.cloud.bigquery.datatransfer.v1.DataSourceParameter
	31, // 4: google.cloud.bigquery.datatransfer.v1.DataSource.transfer_type:type_name -> google.cloud.bigquery.datatransfer.v1.TransferType
	4,  // 5: google.cloud.bigquery.datatransfer.v1.DataSource.parameters:type_name -> google.cloud.bigquery.datatransfer.v1.DataSourceParameter
	1,  // 6: google.cloud.bigquery.datatransfer.v1.DataSource.authorization_type:type_name -> google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType
	2,  // 7: google.cloud.bigquery.datatransfer.v1.DataSource.data_refresh_type:type_name -> google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType
	32, // 8: google.cloud.bigquery.datatransfer.v1.DataSource.minimum_schedule_interval:type_name -> google.protobuf.Duration
	5,  // 9: google.cloud.bigquery.datatransfer.v1.ListDataSourcesResponse.data_sources:type_name -> google.cloud.bigquery.datatransfer.v1.DataSource
	33, // 10: google.cloud.bigquery.datatransfer.v1.CreateTransferConfigRequest.transfer_config:type_name -> google.cloud.bigquery.datatransfer.v1.TransferConfig
	33, // 11: google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest.transfer_config:type_name -> google.cloud.bigquery.datatransfer.v1.TransferConfig
	34, // 12: google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	33, // 13: google.cloud.bigquery.datatransfer.v1.ListTransferConfigsResponse.transfer_configs:type_name -> google.cloud.bigquery.datatransfer.v1.TransferConfig
	35, // 14: google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.states:type_name -> google.cloud.bigquery.datatransfer.v1.TransferState
	3,  // 15: google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.run_attempt:type_name -> google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest.RunAttempt
	36, // 16: google.cloud.bigquery.datatransfer.v1.ListTransferRunsResponse.transfer_runs:type_name -> google.cloud.bigquery.datatransfer.v1.TransferRun
	37, // 17: google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest.message_types:type_name -> google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity
	38, // 18: google.cloud.bigquery.datatransfer.v1.ListTransferLogsResponse.transfer_messages:type_name -> google.cloud.bigquery.datatransfer.v1.TransferMessage
	39, // 19: google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest.start_time:type_name -> google.protobuf.Timestamp
	39, // 20: google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest.end_time:type_name -> google.protobuf.Timestamp
	36, // 21: google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsResponse.runs:type_name -> google.cloud.bigquery.datatransfer.v1.TransferRun
	29, // 22: google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.requested_time_range:type_name -> google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange
	39, // 23: google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.requested_run_time:type_name -> google.protobuf.Timestamp
	36, // 24: google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsResponse.runs:type_name -> google.cloud.bigquery.datatransfer.v1.TransferRun
	39, // 25: google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange.start_time:type_name -> google.protobuf.Timestamp
	39, // 26: google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange.end_time:type_name -> google.protobuf.Timestamp
	6,  // 27: google.cloud.bigquery.datatransfer.v1.DataTransferService.GetDataSource:input_type -> google.cloud.bigquery.datatransfer.v1.GetDataSourceRequest
	7,  // 28: google.cloud.bigquery.datatransfer.v1.DataTransferService.ListDataSources:input_type -> google.cloud.bigquery.datatransfer.v1.ListDataSourcesRequest
	9,  // 29: google.cloud.bigquery.datatransfer.v1.DataTransferService.CreateTransferConfig:input_type -> google.cloud.bigquery.datatransfer.v1.CreateTransferConfigRequest
	10, // 30: google.cloud.bigquery.datatransfer.v1.DataTransferService.UpdateTransferConfig:input_type -> google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest
	12, // 31: google.cloud.bigquery.datatransfer.v1.DataTransferService.DeleteTransferConfig:input_type -> google.cloud.bigquery.datatransfer.v1.DeleteTransferConfigRequest
	11, // 32: google.cloud.bigquery.datatransfer.v1.DataTransferService.GetTransferConfig:input_type -> google.cloud.bigquery.datatransfer.v1.GetTransferConfigRequest
	15, // 33: google.cloud.bigquery.datatransfer.v1.DataTransferService.ListTransferConfigs:input_type -> google.cloud.bigquery.datatransfer.v1.ListTransferConfigsRequest
	23, // 34: google.cloud.bigquery.datatransfer.v1.DataTransferService.ScheduleTransferRuns:input_type -> google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest
	25, // 35: google.cloud.bigquery.datatransfer.v1.DataTransferService.StartManualTransferRuns:input_type -> google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest
	13, // 36: google.cloud.bigquery.datatransfer.v1.DataTransferService.GetTransferRun:input_type -> google.cloud.bigquery.datatransfer.v1.GetTransferRunRequest
	14, // 37: google.cloud.bigquery.datatransfer.v1.DataTransferService.DeleteTransferRun:input_type -> google.cloud.bigquery.datatransfer.v1.DeleteTransferRunRequest
	17, // 38: google.cloud.bigquery.datatransfer.v1.DataTransferService.ListTransferRuns:input_type -> google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest
	19, // 39: google.cloud.bigquery.datatransfer.v1.DataTransferService.ListTransferLogs:input_type -> google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest
	21, // 40: google.cloud.bigquery.datatransfer.v1.DataTransferService.CheckValidCreds:input_type -> google.cloud.bigquery.datatransfer.v1.CheckValidCredsRequest
	27, // 41: google.cloud.bigquery.datatransfer.v1.DataTransferService.EnrollDataSources:input_type -> google.cloud.bigquery.datatransfer.v1.EnrollDataSourcesRequest
	28, // 42: google.cloud.bigquery.datatransfer.v1.DataTransferService.UnenrollDataSources:input_type -> google.cloud.bigquery.datatransfer.v1.UnenrollDataSourcesRequest
	5,  // 43: google.cloud.bigquery.datatransfer.v1.DataTransferService.GetDataSource:output_type -> google.cloud.bigquery.datatransfer.v1.DataSource
	8,  // 44: google.cloud.bigquery.datatransfer.v1.DataTransferService.ListDataSources:output_type -> google.cloud.bigquery.datatransfer.v1.ListDataSourcesResponse
	33, // 45: google.cloud.bigquery.datatransfer.v1.DataTransferService.CreateTransferConfig:output_type -> google.cloud.bigquery.datatransfer.v1.TransferConfig
	33, // 46: google.cloud.bigquery.datatransfer.v1.DataTransferService.UpdateTransferConfig:output_type -> google.cloud.bigquery.datatransfer.v1.TransferConfig
	40, // 47: google.cloud.bigquery.datatransfer.v1.DataTransferService.DeleteTransferConfig:output_type -> google.protobuf.Empty
	33, // 48: google.cloud.bigquery.datatransfer.v1.DataTransferService.GetTransferConfig:output_type -> google.cloud.bigquery.datatransfer.v1.TransferConfig
	16, // 49: google.cloud.bigquery.datatransfer.v1.DataTransferService.ListTransferConfigs:output_type -> google.cloud.bigquery.datatransfer.v1.ListTransferConfigsResponse
	24, // 50: google.cloud.bigquery.datatransfer.v1.DataTransferService.ScheduleTransferRuns:output_type -> google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsResponse
	26, // 51: google.cloud.bigquery.datatransfer.v1.DataTransferService.StartManualTransferRuns:output_type -> google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsResponse
	36, // 52: google.cloud.bigquery.datatransfer.v1.DataTransferService.GetTransferRun:output_type -> google.cloud.bigquery.datatransfer.v1.TransferRun
	40, // 53: google.cloud.bigquery.datatransfer.v1.DataTransferService.DeleteTransferRun:output_type -> google.protobuf.Empty
	18, // 54: google.cloud.bigquery.datatransfer.v1.DataTransferService.ListTransferRuns:output_type -> google.cloud.bigquery.datatransfer.v1.ListTransferRunsResponse
	20, // 55: google.cloud.bigquery.datatransfer.v1.DataTransferService.ListTransferLogs:output_type -> google.cloud.bigquery.datatransfer.v1.ListTransferLogsResponse
	22, // 56: google.cloud.bigquery.datatransfer.v1.DataTransferService.CheckValidCreds:output_type -> google.cloud.bigquery.datatransfer.v1.CheckValidCredsResponse
	40, // 57: google.cloud.bigquery.datatransfer.v1.DataTransferService.EnrollDataSources:output_type -> google.protobuf.Empty
	40, // 58: google.cloud.bigquery.datatransfer.v1.DataTransferService.UnenrollDataSources:output_type -> google.protobuf.Empty
	43, // [43:59] is the sub-list for method output_type
	27, // [27:43] is the sub-list for method input_type
	27, // [27:27] is the sub-list for extension type_name
	27, // [27:27] is the sub-list for extension extendee
	0,  // [0:27] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_init() }
func file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_init() {
	if File_google_cloud_bigquery_datatransfer_v1_datatransfer_proto != nil {
		return
	}
	file_google_cloud_bigquery_datatransfer_v1_transfer_proto_init()
	file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes[21].OneofWrappers = []any{
		(*StartManualTransferRunsRequest_RequestedTimeRange)(nil),
		(*StartManualTransferRunsRequest_RequestedRunTime)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_datatransfer_v1_datatransfer_proto = out.File
	file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_rawDesc = nil
	file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_goTypes = nil
	file_google_cloud_bigquery_datatransfer_v1_datatransfer_proto_depIdxs = nil
}
