package replacer_test

import (
	"sort"
	"strings"
)

// Generated by lipsum.com
const bigLipsum = `Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam faucibus, lorem at luctus vulputate, nisi lectus mollis ante, sit amet finibus nulla dui at urna. Integer turpis turpis, semper suscipit tellus id, hendrerit convallis dolor. Fusce in massa nec augue fermentum vehicula. Sed et arcu lacinia, fermentum purus vitae, pharetra est. Donec diam est, ultricies et egestas vitae, aliquet eu eros. Donec non auctor velit. Sed sodales augue enim, a dapibus turpis sollicitudin nec.

Donec ac faucibus nibh. Vestibulum blandit libero eu eros posuere mattis. Ut sed purus at arcu ultricies elementum vel eu neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam ultricies eu nulla vitae mollis. Proin in lacus at ante maximus sollicitudin nec aliquam arcu. Suspendisse ut feugiat felis, et rutrum dolor. Proin efficitur, tortor vel pharetra efficitur, quam enim dapibus neque, eget mattis nisi quam et quam. Donec quis dolor vel tellus faucibus rutrum.

Aenean accumsan purus nulla, at rutrum lorem fringilla eu. Aliquam lacinia, quam hendrerit fringilla gravida, velit sem porttitor ex, id tristique nunc elit in libero. Nulla facilisi. Proin posuere, lacus id auctor euismod, nulla nisi aliquet tellus, sed eleifend lectus nisi porttitor nibh. Phasellus vitae felis at erat auctor placerat et in erat. Pellentesque vitae velit lorem. Integer in nunc in tortor interdum elementum eu ut sapien.

Donec vitae interdum nulla. Ut tristique ullamcorper posuere. Nullam at tortor augue. Phasellus sem elit, ullamcorper nec ultrices nec, laoreet et neque. Nulla facilisi. Nullam sit amet facilisis massa. Mauris ex massa, vestibulum consequat justo sit amet, rutrum suscipit ex. Curabitur consectetur rhoncus odio, at pulvinar sapien ullamcorper rhoncus. Nunc tincidunt consectetur dolor, id dignissim justo tincidunt ut. Vivamus ex risus, convallis a velit et, pretium efficitur risus. Donec pellentesque eget augue ac bibendum. Duis pellentesque lectus et nunc lobortis elementum. Suspendisse neque massa, imperdiet nec pretium at, varius a lectus.

Vivamus metus quam, finibus non pulvinar vitae, tristique vel augue. Nunc pharetra feugiat neque, ut convallis tortor consequat non. Aenean eu pretium ligula. Cras pulvinar urna eu neque venenatis ullamcorper. Phasellus in commodo sapien. Nullam rhoncus arcu vulputate condimentum ullamcorper. Mauris nec urna sit amet lacus vulputate pretium malesuada ut lorem.`

var bigLipsumSecrets []string

func init() {
	// Find 10 most frequent words in bigLipsum to use as "secrets"
	hist := make(map[string]int)
	for _, w := range strings.Fields(bigLipsum) {
		hist[strings.Trim(w, ".,")]++
	}
	words := make([]string, 0, len(hist))
	for w := range hist {
		words = append(words, w)
	}
	sort.Slice(words, func(i, j int) bool {
		return hist[words[i]] > hist[words[j]]
	})
	bigLipsumSecrets = words[:10]
}
