// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Application Dependency Management API
//
// Use the Application Dependency Management API to create knowledge bases and vulnerability audits.  For more information, see ADM (https://docs.oracle.com/iaas/Content/application-dependency-management/home.htm).
//

package adm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// VulnerabilityAuditSummary vulnerability audit summary.
type VulnerabilityAuditSummary struct {

	// The Oracle Cloud identifier (OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.
	Id *string `mandatory:"true" json:"id"`

	// The Oracle Cloud identifier (OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
	KnowledgeBaseId *string `mandatory:"true" json:"knowledgeBaseId"`

	// The creation date and time of the vulnerability audit (formatted according to RFC3339 (https://datatracker.ietf.org/doc/html/rfc3339)).
	TimeCreated *common.SDKTime `mandatory:"true" json:"timeCreated"`

	// The update date and time of the vulnerability audit (formatted according to RFC3339 (https://datatracker.ietf.org/doc/html/rfc3339)).
	TimeUpdated *common.SDKTime `mandatory:"true" json:"timeUpdated"`

	// The current lifecycle state of the vulnerability audit.
	LifecycleState VulnerabilityAuditLifecycleStateEnum `mandatory:"true" json:"lifecycleState"`

	// Count of non-ignored vulnerable application dependencies.
	VulnerableArtifactsCount *int `mandatory:"true" json:"vulnerableArtifactsCount"`

	// Count of all vulnerable application dependencies.
	VulnerableArtifactsCountWithIgnored *int `mandatory:"true" json:"vulnerableArtifactsCountWithIgnored"`

	// The compartment Oracle Cloud identifier (OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// The name of the vulnerability audit.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable application dependencies.
	MaxObservedCvssV2Score *float32 `mandatory:"false" json:"maxObservedCvssV2Score"`

	// Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable application dependencies.
	MaxObservedCvssV3Score *float32 `mandatory:"false" json:"maxObservedCvssV3Score"`

	// Maximum ADM Severity observed for non-ignored vulnerable application dependencies.
	MaxObservedSeverity VulnerabilitySeverityEnum `mandatory:"false" json:"maxObservedSeverity,omitempty"`

	// Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable application dependencies including ignored ones.
	MaxObservedCvssV2ScoreWithIgnored *float32 `mandatory:"false" json:"maxObservedCvssV2ScoreWithIgnored"`

	// Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable application dependencies including ignored ones.
	MaxObservedCvssV3ScoreWithIgnored *float32 `mandatory:"false" json:"maxObservedCvssV3ScoreWithIgnored"`

	// Maximum ADM Severity observed for vulnerable application dependencies including ignored ones.
	MaxObservedSeverityWithIgnored VulnerabilitySeverityEnum `mandatory:"false" json:"maxObservedSeverityWithIgnored,omitempty"`

	// Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.
	IsSuccess *bool `mandatory:"false" json:"isSuccess"`

	// The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
	BuildType VulnerabilityAuditBuildTypeEnum `mandatory:"false" json:"buildType,omitempty"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// Usage of system tag keys. These predefined keys are scoped to namespaces.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`
}

func (m VulnerabilityAuditSummary) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m VulnerabilityAuditSummary) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingVulnerabilityAuditLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetVulnerabilityAuditLifecycleStateEnumStringValues(), ",")))
	}

	if _, ok := GetMappingVulnerabilitySeverityEnum(string(m.MaxObservedSeverity)); !ok && m.MaxObservedSeverity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for MaxObservedSeverity: %s. Supported values are: %s.", m.MaxObservedSeverity, strings.Join(GetVulnerabilitySeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingVulnerabilitySeverityEnum(string(m.MaxObservedSeverityWithIgnored)); !ok && m.MaxObservedSeverityWithIgnored != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for MaxObservedSeverityWithIgnored: %s. Supported values are: %s.", m.MaxObservedSeverityWithIgnored, strings.Join(GetVulnerabilitySeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingVulnerabilityAuditBuildTypeEnum(string(m.BuildType)); !ok && m.BuildType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for BuildType: %s. Supported values are: %s.", m.BuildType, strings.Join(GetVulnerabilityAuditBuildTypeEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
