// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/maps/places/v1/address_descriptor.proto

package placespb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	localized_text "google.golang.org/genproto/googleapis/type/localized_text"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines the spatial relationship between the target location and the
// landmark.
type AddressDescriptor_Landmark_SpatialRelationship int32

const (
	// This is the default relationship when nothing more specific below
	// applies.
	AddressDescriptor_Landmark_NEAR AddressDescriptor_Landmark_SpatialRelationship = 0
	// The landmark has a spatial geometry and the target is within its
	// bounds.
	AddressDescriptor_Landmark_WITHIN AddressDescriptor_Landmark_SpatialRelationship = 1
	// The target is directly adjacent to the landmark.
	AddressDescriptor_Landmark_BESIDE AddressDescriptor_Landmark_SpatialRelationship = 2
	// The target is directly opposite the landmark on the other side of the
	// road.
	AddressDescriptor_Landmark_ACROSS_THE_ROAD AddressDescriptor_Landmark_SpatialRelationship = 3
	// On the same route as the landmark but not besides or across.
	AddressDescriptor_Landmark_DOWN_THE_ROAD AddressDescriptor_Landmark_SpatialRelationship = 4
	// Not on the same route as the landmark but a single turn away.
	AddressDescriptor_Landmark_AROUND_THE_CORNER AddressDescriptor_Landmark_SpatialRelationship = 5
	// Close to the landmark's structure but further away from its street
	// entrances.
	AddressDescriptor_Landmark_BEHIND AddressDescriptor_Landmark_SpatialRelationship = 6
)

// Enum value maps for AddressDescriptor_Landmark_SpatialRelationship.
var (
	AddressDescriptor_Landmark_SpatialRelationship_name = map[int32]string{
		0: "NEAR",
		1: "WITHIN",
		2: "BESIDE",
		3: "ACROSS_THE_ROAD",
		4: "DOWN_THE_ROAD",
		5: "AROUND_THE_CORNER",
		6: "BEHIND",
	}
	AddressDescriptor_Landmark_SpatialRelationship_value = map[string]int32{
		"NEAR":              0,
		"WITHIN":            1,
		"BESIDE":            2,
		"ACROSS_THE_ROAD":   3,
		"DOWN_THE_ROAD":     4,
		"AROUND_THE_CORNER": 5,
		"BEHIND":            6,
	}
)

func (x AddressDescriptor_Landmark_SpatialRelationship) Enum() *AddressDescriptor_Landmark_SpatialRelationship {
	p := new(AddressDescriptor_Landmark_SpatialRelationship)
	*p = x
	return p
}

func (x AddressDescriptor_Landmark_SpatialRelationship) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AddressDescriptor_Landmark_SpatialRelationship) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_address_descriptor_proto_enumTypes[0].Descriptor()
}

func (AddressDescriptor_Landmark_SpatialRelationship) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_address_descriptor_proto_enumTypes[0]
}

func (x AddressDescriptor_Landmark_SpatialRelationship) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AddressDescriptor_Landmark_SpatialRelationship.Descriptor instead.
func (AddressDescriptor_Landmark_SpatialRelationship) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_address_descriptor_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Defines the spatial relationship between the target location and the
// area.
type AddressDescriptor_Area_Containment int32

const (
	// The containment is unspecified.
	AddressDescriptor_Area_CONTAINMENT_UNSPECIFIED AddressDescriptor_Area_Containment = 0
	// The target location is within the area region, close to the
	// center.
	AddressDescriptor_Area_WITHIN AddressDescriptor_Area_Containment = 1
	// The target location is within the area region, close to the edge.
	AddressDescriptor_Area_OUTSKIRTS AddressDescriptor_Area_Containment = 2
	// The target location is outside the area region, but close by.
	AddressDescriptor_Area_NEAR AddressDescriptor_Area_Containment = 3
)

// Enum value maps for AddressDescriptor_Area_Containment.
var (
	AddressDescriptor_Area_Containment_name = map[int32]string{
		0: "CONTAINMENT_UNSPECIFIED",
		1: "WITHIN",
		2: "OUTSKIRTS",
		3: "NEAR",
	}
	AddressDescriptor_Area_Containment_value = map[string]int32{
		"CONTAINMENT_UNSPECIFIED": 0,
		"WITHIN":                  1,
		"OUTSKIRTS":               2,
		"NEAR":                    3,
	}
)

func (x AddressDescriptor_Area_Containment) Enum() *AddressDescriptor_Area_Containment {
	p := new(AddressDescriptor_Area_Containment)
	*p = x
	return p
}

func (x AddressDescriptor_Area_Containment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AddressDescriptor_Area_Containment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_address_descriptor_proto_enumTypes[1].Descriptor()
}

func (AddressDescriptor_Area_Containment) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_address_descriptor_proto_enumTypes[1]
}

func (x AddressDescriptor_Area_Containment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AddressDescriptor_Area_Containment.Descriptor instead.
func (AddressDescriptor_Area_Containment) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_address_descriptor_proto_rawDescGZIP(), []int{0, 1, 0}
}

// A relational description of a location. Includes a ranked set of nearby
// landmarks and precise containing areas and their relationship to the target
// location.
type AddressDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A ranked list of nearby landmarks. The most recognizable and nearby
	// landmarks are ranked first.
	Landmarks []*AddressDescriptor_Landmark `protobuf:"bytes,1,rep,name=landmarks,proto3" json:"landmarks,omitempty"`
	// A ranked list of containing or adjacent areas. The most recognizable and
	// precise areas are ranked first.
	Areas []*AddressDescriptor_Area `protobuf:"bytes,2,rep,name=areas,proto3" json:"areas,omitempty"`
}

func (x *AddressDescriptor) Reset() {
	*x = AddressDescriptor{}
	mi := &file_google_maps_places_v1_address_descriptor_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddressDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressDescriptor) ProtoMessage() {}

func (x *AddressDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_address_descriptor_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressDescriptor.ProtoReflect.Descriptor instead.
func (*AddressDescriptor) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_address_descriptor_proto_rawDescGZIP(), []int{0}
}

func (x *AddressDescriptor) GetLandmarks() []*AddressDescriptor_Landmark {
	if x != nil {
		return x.Landmarks
	}
	return nil
}

func (x *AddressDescriptor) GetAreas() []*AddressDescriptor_Area {
	if x != nil {
		return x.Areas
	}
	return nil
}

// Basic landmark information and the landmark's relationship with the
// target location.
//
// Landmarks are prominent places that can be used to describe a location.
type AddressDescriptor_Landmark struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The landmark's resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The landmark's place id.
	PlaceId string `protobuf:"bytes,2,opt,name=place_id,json=placeId,proto3" json:"place_id,omitempty"`
	// The landmark's display name.
	DisplayName *localized_text.LocalizedText `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A set of type tags for this landmark. For a complete list of possible
	// values, see
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	Types []string `protobuf:"bytes,4,rep,name=types,proto3" json:"types,omitempty"`
	// Defines the spatial relationship between the target location and the
	// landmark.
	SpatialRelationship AddressDescriptor_Landmark_SpatialRelationship `protobuf:"varint,5,opt,name=spatial_relationship,json=spatialRelationship,proto3,enum=google.maps.places.v1.AddressDescriptor_Landmark_SpatialRelationship" json:"spatial_relationship,omitempty"`
	// The straight line distance, in meters, between the center point of the
	// target and the center point of the landmark. In some situations, this
	// value can be longer than `travel_distance_meters`.
	StraightLineDistanceMeters float32 `protobuf:"fixed32,6,opt,name=straight_line_distance_meters,json=straightLineDistanceMeters,proto3" json:"straight_line_distance_meters,omitempty"`
	// The travel distance, in meters, along the road network from the target to
	// the landmark, if known. This value does not take into account the mode of
	// transportation, such as walking, driving, or biking.
	TravelDistanceMeters *float32 `protobuf:"fixed32,7,opt,name=travel_distance_meters,json=travelDistanceMeters,proto3,oneof" json:"travel_distance_meters,omitempty"`
}

func (x *AddressDescriptor_Landmark) Reset() {
	*x = AddressDescriptor_Landmark{}
	mi := &file_google_maps_places_v1_address_descriptor_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddressDescriptor_Landmark) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressDescriptor_Landmark) ProtoMessage() {}

func (x *AddressDescriptor_Landmark) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_address_descriptor_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressDescriptor_Landmark.ProtoReflect.Descriptor instead.
func (*AddressDescriptor_Landmark) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_address_descriptor_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AddressDescriptor_Landmark) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AddressDescriptor_Landmark) GetPlaceId() string {
	if x != nil {
		return x.PlaceId
	}
	return ""
}

func (x *AddressDescriptor_Landmark) GetDisplayName() *localized_text.LocalizedText {
	if x != nil {
		return x.DisplayName
	}
	return nil
}

func (x *AddressDescriptor_Landmark) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *AddressDescriptor_Landmark) GetSpatialRelationship() AddressDescriptor_Landmark_SpatialRelationship {
	if x != nil {
		return x.SpatialRelationship
	}
	return AddressDescriptor_Landmark_NEAR
}

func (x *AddressDescriptor_Landmark) GetStraightLineDistanceMeters() float32 {
	if x != nil {
		return x.StraightLineDistanceMeters
	}
	return 0
}

func (x *AddressDescriptor_Landmark) GetTravelDistanceMeters() float32 {
	if x != nil && x.TravelDistanceMeters != nil {
		return *x.TravelDistanceMeters
	}
	return 0
}

// Area information and the area's relationship with the target location.
//
// Areas includes precise sublocality, neighborhoods, and large compounds that
// are useful for describing a location.
type AddressDescriptor_Area struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The area's resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The area's place id.
	PlaceId string `protobuf:"bytes,2,opt,name=place_id,json=placeId,proto3" json:"place_id,omitempty"`
	// The area's display name.
	DisplayName *localized_text.LocalizedText `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Defines the spatial relationship between the target location and the
	// area.
	Containment AddressDescriptor_Area_Containment `protobuf:"varint,4,opt,name=containment,proto3,enum=google.maps.places.v1.AddressDescriptor_Area_Containment" json:"containment,omitempty"`
}

func (x *AddressDescriptor_Area) Reset() {
	*x = AddressDescriptor_Area{}
	mi := &file_google_maps_places_v1_address_descriptor_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddressDescriptor_Area) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressDescriptor_Area) ProtoMessage() {}

func (x *AddressDescriptor_Area) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_address_descriptor_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressDescriptor_Area.ProtoReflect.Descriptor instead.
func (*AddressDescriptor_Area) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_address_descriptor_proto_rawDescGZIP(), []int{0, 1}
}

func (x *AddressDescriptor_Area) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AddressDescriptor_Area) GetPlaceId() string {
	if x != nil {
		return x.PlaceId
	}
	return ""
}

func (x *AddressDescriptor_Area) GetDisplayName() *localized_text.LocalizedText {
	if x != nil {
		return x.DisplayName
	}
	return nil
}

func (x *AddressDescriptor_Area) GetContainment() AddressDescriptor_Area_Containment {
	if x != nil {
		return x.Containment
	}
	return AddressDescriptor_Area_CONTAINMENT_UNSPECIFIED
}

var File_google_maps_places_v1_address_descriptor_proto protoreflect.FileDescriptor

var file_google_maps_places_v1_address_descriptor_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbb, 0x08, 0x0a, 0x11, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x4f, 0x0a, 0x09, 0x6c, 0x61,
	0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x4c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b,
	0x52, 0x09, 0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x12, 0x43, 0x0a, 0x05, 0x61,
	0x72, 0x65, 0x61, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x6f, 0x72, 0x2e, 0x41, 0x72, 0x65, 0x61, 0x52, 0x05, 0x61, 0x72, 0x65, 0x61, 0x73,
	0x1a, 0xc8, 0x04, 0x0a, 0x08, 0x4c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x12, 0x34, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d,
	0x0a, 0x1b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x49, 0x64, 0x12, 0x3d,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x78, 0x0a, 0x14, 0x73, 0x70, 0x61, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x72,
	0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x4c, 0x61, 0x6e, 0x64,
	0x6d, 0x61, 0x72, 0x6b, 0x2e, 0x53, 0x70, 0x61, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x52, 0x13, 0x73, 0x70, 0x61, 0x74, 0x69, 0x61,
	0x6c, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x12, 0x41, 0x0a,
	0x1d, 0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x64,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x1a, 0x73, 0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x4c, 0x69,
	0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x39, 0x0a, 0x16, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x02,
	0x48, 0x00, 0x52, 0x14, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x88, 0x01, 0x01, 0x22, 0x82, 0x01, 0x0a, 0x13,
	0x53, 0x70, 0x61, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x68, 0x69, 0x70, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x45, 0x41, 0x52, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x57, 0x49, 0x54, 0x48, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x45, 0x53,
	0x49, 0x44, 0x45, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f,
	0x54, 0x48, 0x45, 0x5f, 0x52, 0x4f, 0x41, 0x44, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x4f,
	0x57, 0x4e, 0x5f, 0x54, 0x48, 0x45, 0x5f, 0x52, 0x4f, 0x41, 0x44, 0x10, 0x04, 0x12, 0x15, 0x0a,
	0x11, 0x41, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x54, 0x48, 0x45, 0x5f, 0x43, 0x4f, 0x52, 0x4e,
	0x45, 0x52, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x45, 0x48, 0x49, 0x4e, 0x44, 0x10, 0x06,
	0x42, 0x19, 0x0a, 0x17, 0x5f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0xc4, 0x02, 0x0a, 0x04,
	0x41, 0x72, 0x65, 0x61, 0x12, 0x34, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x6f, 0x72, 0x2e, 0x41, 0x72, 0x65, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x4f, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x57, 0x49, 0x54, 0x48, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x55, 0x54,
	0x53, 0x4b, 0x49, 0x52, 0x54, 0x53, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x45, 0x41, 0x52,
	0x10, 0x03, 0x42, 0xa7, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x42, 0x16, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x70, 0x62, 0xa2, 0x02, 0x06, 0x47, 0x4d, 0x50, 0x53, 0x56, 0x31, 0xaa, 0x02, 0x15, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x4d, 0x61,
	0x70, 0x73, 0x5c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_places_v1_address_descriptor_proto_rawDescOnce sync.Once
	file_google_maps_places_v1_address_descriptor_proto_rawDescData = file_google_maps_places_v1_address_descriptor_proto_rawDesc
)

func file_google_maps_places_v1_address_descriptor_proto_rawDescGZIP() []byte {
	file_google_maps_places_v1_address_descriptor_proto_rawDescOnce.Do(func() {
		file_google_maps_places_v1_address_descriptor_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_places_v1_address_descriptor_proto_rawDescData)
	})
	return file_google_maps_places_v1_address_descriptor_proto_rawDescData
}

var file_google_maps_places_v1_address_descriptor_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_maps_places_v1_address_descriptor_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_maps_places_v1_address_descriptor_proto_goTypes = []any{
	(AddressDescriptor_Landmark_SpatialRelationship)(0), // 0: google.maps.places.v1.AddressDescriptor.Landmark.SpatialRelationship
	(AddressDescriptor_Area_Containment)(0),             // 1: google.maps.places.v1.AddressDescriptor.Area.Containment
	(*AddressDescriptor)(nil),                           // 2: google.maps.places.v1.AddressDescriptor
	(*AddressDescriptor_Landmark)(nil),                  // 3: google.maps.places.v1.AddressDescriptor.Landmark
	(*AddressDescriptor_Area)(nil),                      // 4: google.maps.places.v1.AddressDescriptor.Area
	(*localized_text.LocalizedText)(nil),                // 5: google.type.LocalizedText
}
var file_google_maps_places_v1_address_descriptor_proto_depIdxs = []int32{
	3, // 0: google.maps.places.v1.AddressDescriptor.landmarks:type_name -> google.maps.places.v1.AddressDescriptor.Landmark
	4, // 1: google.maps.places.v1.AddressDescriptor.areas:type_name -> google.maps.places.v1.AddressDescriptor.Area
	5, // 2: google.maps.places.v1.AddressDescriptor.Landmark.display_name:type_name -> google.type.LocalizedText
	0, // 3: google.maps.places.v1.AddressDescriptor.Landmark.spatial_relationship:type_name -> google.maps.places.v1.AddressDescriptor.Landmark.SpatialRelationship
	5, // 4: google.maps.places.v1.AddressDescriptor.Area.display_name:type_name -> google.type.LocalizedText
	1, // 5: google.maps.places.v1.AddressDescriptor.Area.containment:type_name -> google.maps.places.v1.AddressDescriptor.Area.Containment
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_maps_places_v1_address_descriptor_proto_init() }
func file_google_maps_places_v1_address_descriptor_proto_init() {
	if File_google_maps_places_v1_address_descriptor_proto != nil {
		return
	}
	file_google_maps_places_v1_address_descriptor_proto_msgTypes[1].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_places_v1_address_descriptor_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_places_v1_address_descriptor_proto_goTypes,
		DependencyIndexes: file_google_maps_places_v1_address_descriptor_proto_depIdxs,
		EnumInfos:         file_google_maps_places_v1_address_descriptor_proto_enumTypes,
		MessageInfos:      file_google_maps_places_v1_address_descriptor_proto_msgTypes,
	}.Build()
	File_google_maps_places_v1_address_descriptor_proto = out.File
	file_google_maps_places_v1_address_descriptor_proto_rawDesc = nil
	file_google_maps_places_v1_address_descriptor_proto_goTypes = nil
	file_google_maps_places_v1_address_descriptor_proto_depIdxs = nil
}
