/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvmstat;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.MonitoredValue;
import org.openide.util.NbBundle;

class JvmJvmstatModel_25
extends JvmJvmstatModel {
    private static final String PERM_GEN_PREFIX_META = "sun.gc.metaspace.";
    private static final String GC_TYPE_COUNTER_NAME = "sun.gc.policy.name";
    private static final String G1_NAME = "GarbageFirst";
    private static final String GC_COLLECTOR_COUNTER_NAME = "sun.gc.collector.0.name";
    private static final String GENERATIONAL_ZGC_NAME = "ZGC minor collection pauses";
    private long startup;

    JvmJvmstatModel_25(Application app, JvmstatModel stat) {
        super(app, stat);
        this.initMonitoredVales();
    }

    private void initMonitoredVales() {
        this.loadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.loadedClasses");
        this.sharedLoadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.sharedLoadedClasses");
        this.sharedUnloadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.sharedUnloadedClasses");
        this.unloadedClasses = this.jvmstat.findMonitoredValueByName("java.cls.unloadedClasses");
        this.threadsDaemon = this.jvmstat.findMonitoredValueByName("java.threads.daemon");
        this.threadsLive = this.jvmstat.findMonitoredValueByName("java.threads.live");
        this.threadsLivePeak = this.jvmstat.findMonitoredValueByName("java.threads.livePeak");
        this.threadsStarted = this.jvmstat.findMonitoredValueByName("java.threads.started");
        this.applicationTime = this.jvmstat.findMonitoredValueByName("sun.rt.applicationTime");
        MonitoredValue startTimeMon = this.jvmstat.findMonitoredValueByName("sun.rt.createVmBeginTime");
        this.startup = this.getLongValue(startTimeMon);
        MonitoredValue osFrequencyMon = this.jvmstat.findMonitoredValueByName("sun.os.hrt.frequency");
        this.osFrequency = this.getLongValue(osFrequencyMon);
        this.genCapacity = this.jvmstat.findMonitoredValueByPattern("sun.gc.((generation.[0-9]+)|(metaspace)).capacity");
        this.genName[1] = NbBundle.getMessage(JvmJvmstatModel_25.class, (String)"LBL_Meta");
        this.genUsed = this.jvmstat.findMonitoredValueByPattern("sun.gc.((generation.[0-9]+.space.[0-9]+)|(metaspace)).used");
        this.genMaxCapacity = this.computeMaxCapacity();
    }

    private long[] computeMaxCapacity() {
        String gcType = this.jvmstat.findByName(GC_TYPE_COUNTER_NAME);
        String gcColName = this.jvmstat.findByName(GC_COLLECTOR_COUNTER_NAME);
        if (G1_NAME.equals(gcType) || GENERATIONAL_ZGC_NAME.equals(gcColName)) {
            long[] maxCapacity = new long[2];
            MonitoredValue maxVal = this.jvmstat.findMonitoredValueByName("sun.gc.generation.0.maxCapacity");
            MonitoredValue metaVal = this.jvmstat.findMonitoredValueByName("sun.gc.metaspace.maxCapacity");
            maxCapacity[0] = this.getLongValue(maxVal);
            maxCapacity[1] = this.getLongValue(metaVal);
            return maxCapacity;
        }
        return this.getGenerationSum(this.jvmstat.findMonitoredValueByPattern("sun.gc.((generation.[0-9]+)|(metaspace)).maxCapacity"));
    }

    protected String getPermGenPrefix() {
        return PERM_GEN_PREFIX_META;
    }

    public long getUpTime() {
        return (System.currentTimeMillis() - this.startup) * (this.osFrequency / 1000L);
    }
}

