/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.socketio;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.views.socketio.SocketIOViewSupport;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.ImageUtilities;

abstract class SocketIONode
extends CCTNode {
    private static final String UNKNOWN = "<unknown>";
    private static final SocketIONode[] NO_NODES = new SocketIONode[0];
    private final SocketIONode parent;
    private final List<SocketIONode> children;
    final String key;
    String name;
    final Icon icon;
    long countR;
    long countW = 0L;
    long bytesR;
    long bytesW = 0L;
    Duration durationR;
    Duration durationRMax;
    Duration durationW;
    Duration durationWMax;

    SocketIONode(String key, String name, Icon icon, SocketIONode parent, List<SocketIONode> children) {
        this.key = key;
        this.parent = parent;
        this.children = children;
        this.name = name;
        this.icon = icon;
    }

    final void processRead(Duration duration, long bytes) {
        if (this.parent != null) {
            ++this.countR;
            this.bytesR += bytes;
            this.durationR = this.durationR == null ? duration : this.durationR.plus(duration);
            if (this.durationRMax == null || this.durationRMax.compareTo(duration) < 0) {
                this.durationRMax = duration;
            }
            this.parent.processRead(duration, bytes);
        }
    }

    final void processWrite(Duration duration, long bytes) {
        if (this.parent != null) {
            ++this.countW;
            this.bytesW += bytes;
            this.durationW = this.durationW == null ? duration : this.durationW.plus(duration);
            if (this.durationWMax == null || this.durationWMax.compareTo(duration) < 0) {
                this.durationWMax = duration;
            }
            this.parent.processWrite(duration, bytes);
        }
    }

    SocketIONode getChild(String key) {
        if (this.children != null) {
            for (SocketIONode child : this.children) {
                if (!Objects.equals(key, child.key)) continue;
                return child;
            }
        }
        return null;
    }

    public SocketIONode getChild(int index) {
        return this.children == null ? null : this.children.get(index);
    }

    public SocketIONode[] getChildren() {
        return this.children == null ? NO_NODES : this.children.toArray(NO_NODES);
    }

    public int getIndexOfChild(Object child) {
        return this.children == null ? -1 : this.children.indexOf(child);
    }

    public int getNChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public SocketIONode getParent() {
        return this.parent;
    }

    protected void addChild(SocketIONode child) {
        if (this.children != null) {
            this.children.add(child);
        }
    }

    protected void removeAllChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SocketIONode)) {
            return false;
        }
        return Objects.equals(this.key, ((SocketIONode)((Object)o)).key);
    }

    public String toString() {
        return this.name;
    }

    private void setName(String newName) {
        if (this.name == null || newName.length() > this.name.length()) {
            this.name = newName;
        }
    }

    static final class Root
    extends SocketIONode
    implements JFREventVisitor {
        private final SocketIOViewSupport.Aggregation primary;
        private final SocketIOViewSupport.Aggregation secondary;

        Root() {
            this(null, null);
        }

        Root(SocketIOViewSupport.Aggregation primary, SocketIOViewSupport.Aggregation secondary) {
            super(null, null, null, null, (List<SocketIONode>)(primary == null && secondary == null ? null : new ArrayList<SocketIONode>()));
            this.primary = primary;
            this.secondary = SocketIOViewSupport.Aggregation.NONE.equals((Object)secondary) ? null : secondary;
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            Boolean rw = "jdk.SocketRead".equals(typeName) ? Boolean.FALSE : ("jdk.SocketWrite".equals(typeName) ? Boolean.TRUE : null);
            if (rw != null) {
                SocketIONode primaryNode;
                String primaryKey = Root.getKey(this.primary, event);
                String primaryName = Root.getName(this.primary, event);
                if (primaryKey == null) {
                    primaryKey = SocketIONode.UNKNOWN;
                }
                if (primaryName == null) {
                    primaryName = SocketIONode.UNKNOWN;
                }
                if ((primaryNode = this.getChild(primaryKey)) == null) {
                    primaryNode = this.createNode(primaryKey, primaryName, this.primary, this, this.secondary == null);
                    this.addChild(primaryNode);
                }
                if (this.secondary != null) {
                    SocketIONode secondaryNode;
                    String secondaryKey = Root.getKey(this.secondary, event);
                    String secondaryName = Root.getName(this.secondary, event);
                    if (secondaryKey == null) {
                        secondaryKey = SocketIONode.UNKNOWN;
                    }
                    if (secondaryName == null) {
                        secondaryName = SocketIONode.UNKNOWN;
                    }
                    if ((secondaryNode = primaryNode.getChild(secondaryKey)) == null) {
                        secondaryNode = this.createNode(secondaryKey, secondaryName, this.secondary, primaryNode, true);
                        primaryNode.addChild(secondaryNode);
                    }
                    Root.processEvent(secondaryNode, secondaryName, event, rw);
                } else {
                    Root.processEvent(primaryNode, primaryName, event, rw);
                }
            }
            return false;
        }

        private static void processEvent(SocketIONode node, String name, JFREvent event, Boolean rw) {
            try {
                node.setName(name);
                if (Boolean.FALSE.equals(rw)) {
                    node.processRead(Root.getDuration(event), event.getLong("bytesRead"));
                } else {
                    node.processWrite(Root.getDuration(event), event.getLong("bytesWritten"));
                }
            }
            catch (JFRPropertyNotAvailableException e) {
                System.err.println(">>> " + e);
            }
        }

        @Override
        public int hashCode() {
            return 37;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Root;
        }

        private static String getKey(SocketIOViewSupport.Aggregation aggregation, JFREvent event) {
            try {
                if (SocketIOViewSupport.Aggregation.ADDRESS.equals((Object)aggregation)) {
                    return Root.getAddress(event);
                }
                if (SocketIOViewSupport.Aggregation.PORT.equals((Object)aggregation)) {
                    return Root.getPort(event);
                }
                if (SocketIOViewSupport.Aggregation.ADDRESS_PORT.equals((Object)aggregation)) {
                    String address = Root.getAddress(event);
                    return address + " : " + Root.getPort(event);
                }
                if (SocketIOViewSupport.Aggregation.THREAD.equals((Object)aggregation)) {
                    return event.getThread("eventThread").getName();
                }
            }
            catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                // empty catch block
            }
            return null;
        }

        private static Duration getDuration(JFREvent event) throws JFRPropertyNotAvailableException {
            return event.getDuration("eventDuration");
        }

        private static String getAddress(JFREvent event) throws JFRPropertyNotAvailableException {
            return event.getString("address");
        }

        private static String getName(SocketIOViewSupport.Aggregation aggregation, JFREvent event) {
            try {
                if (SocketIOViewSupport.Aggregation.ADDRESS.equals((Object)aggregation)) {
                    return Root.getFullAddress(event);
                }
                if (SocketIOViewSupport.Aggregation.PORT.equals((Object)aggregation)) {
                    return Root.getPort(event);
                }
                if (SocketIOViewSupport.Aggregation.ADDRESS_PORT.equals((Object)aggregation)) {
                    return Root.getFullAddress(event) + " : " + Root.getPort(event);
                }
                if (SocketIOViewSupport.Aggregation.THREAD.equals((Object)aggregation)) {
                    return event.getThread("eventThread").getName();
                }
            }
            catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                // empty catch block
            }
            return null;
        }

        private static String getPort(JFREvent event) throws JFRPropertyNotAvailableException {
            return String.valueOf(event.getInt("port"));
        }

        private static String getFullAddress(JFREvent event) throws JFRPropertyNotAvailableException {
            String address = Root.getAddress(event);
            String host = event.getString("host");
            if (host != null && !host.trim().isEmpty() && !host.equals(address)) {
                address = address + " (" + host + ")";
            }
            return address;
        }

        private SocketIONode createNode(String key, String name, SocketIOViewSupport.Aggregation aggregation, SocketIONode parent, boolean terminal) {
            if (SocketIOViewSupport.Aggregation.ADDRESS.equals((Object)aggregation)) {
                return new Address(key, name, parent, terminal);
            }
            if (SocketIOViewSupport.Aggregation.PORT.equals((Object)aggregation)) {
                return new Port(name, parent, terminal);
            }
            if (SocketIOViewSupport.Aggregation.ADDRESS_PORT.equals((Object)aggregation)) {
                return new Address(key, name, parent, terminal);
            }
            if (SocketIOViewSupport.Aggregation.THREAD.equals((Object)aggregation)) {
                return new Thread(name, parent, terminal);
            }
            return null;
        }
    }

    static final class Thread
    extends SocketIONode {
        Thread(String name, SocketIONode parent, boolean terminal) {
            super(name, name, Icons.getIcon((String)"ProfilerIcons.Thread"), parent, terminal ? null : new ArrayList());
        }
    }

    static final class Port
    extends SocketIONode {
        private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/port.png";
        private static final Icon ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/jfr/resources/port.png", (boolean)true));

        Port(String name, SocketIONode parent, boolean terminal) {
            super(name, name, ICON, parent, terminal ? null : new ArrayList());
        }
    }

    static final class Address
    extends SocketIONode {
        private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/host.png";
        private static final Icon ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/jfr/resources/host.png", (boolean)true));

        Address(String key, String name, SocketIONode parent, boolean terminal) {
            super(key, name, ICON, parent, terminal ? null : new ArrayList());
        }
    }
}

