/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.Positionable;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DataSourceViewProvider;

public final class DataSourceViewsManager {
    private static final String APP_OVERVIEW_CLASS_workaround = "org.graalvm.visualvm.application.views.overview.ApplicationOverviewViewProvider";
    private static DataSourceViewsManager sharedInstance;
    private final Map<DataSourceViewProvider, Class<? extends DataSource>> providers = Collections.synchronizedMap(new HashMap());

    public static synchronized DataSourceViewsManager sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new DataSourceViewsManager();
        }
        return sharedInstance;
    }

    public void addViewProvider(DataSourceViewProvider provider, Class<? extends DataSource> scope) {
        this.providers.put(provider, scope);
    }

    public void removeViewProvider(DataSourceViewProvider provider) {
        this.providers.remove(provider);
    }

    public boolean canSaveViewsFor(DataSource dataSource, Class<? extends Snapshot> snapshotClass) {
        Set<DataSourceViewProvider> compatibleProviders = this.getCompatibleProviders(dataSource);
        if (compatibleProviders.isEmpty()) {
            return false;
        }
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!APP_OVERVIEW_CLASS_workaround.equals(compatibleProvider.getClass().getName())) continue;
            return true;
        }
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!compatibleProvider.supportsViewFor(dataSource) || !compatibleProvider.supportsSaveViewFor(dataSource, snapshotClass)) continue;
            return true;
        }
        return false;
    }

    public void saveViewsFor(DataSource dataSource, Snapshot snapshot) {
        Set<DataSourceViewProvider> compatibleProviders = this.getCompatibleProviders(dataSource);
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!compatibleProvider.supportsViewFor(dataSource) || !compatibleProvider.supportsSaveViewFor(dataSource, snapshot.getClass())) continue;
            compatibleProvider.viewSaveView(dataSource, snapshot);
        }
    }

    boolean hasViewsFor(DataSource dataSource) {
        Set<DataSourceViewProvider> compatibleProviders = this.getCompatibleProviders(dataSource);
        if (compatibleProviders.isEmpty()) {
            return false;
        }
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!APP_OVERVIEW_CLASS_workaround.equals(compatibleProvider.getClass().getName())) continue;
            return true;
        }
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!compatibleProvider.supportsViewFor(dataSource)) continue;
            return true;
        }
        return false;
    }

    List<? extends DataSourceView> getViews(DataSource dataSource) {
        ArrayList<Positionable> views = new ArrayList<Positionable>();
        Set<DataSourceViewProvider> compatibleProviders = this.getCompatibleProviders(dataSource);
        for (DataSourceViewProvider compatibleProvider : compatibleProviders) {
            if (!compatibleProvider.supportsViewFor(dataSource)) continue;
            views.add(compatibleProvider.getView(dataSource));
        }
        views.sort(Positionable.COMPARATOR);
        return views;
    }

    private Set<DataSourceViewProvider> getCompatibleProviders(DataSource dataSource) {
        HashSet<DataSourceViewProvider> compatibleProviders = new HashSet<DataSourceViewProvider>();
        Set<DataSourceViewProvider> providersSet = this.providers.keySet();
        for (DataSourceViewProvider provider : providersSet) {
            if (!this.providers.get(provider).isInstance(dataSource)) continue;
            compatibleProviders.add(provider);
        }
        return compatibleProviders;
    }

    private DataSourceViewsManager() {
    }
}

