/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.attach;

import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.attach.HeapHistogramImpl;
import org.graalvm.visualvm.tools.attach.AttachModel;
import org.openide.util.Utilities;
import sun.tools.attach.HotSpotVirtualMachine;

class AttachModelImpl
extends AttachModel {
    private static final String LIVE_OBJECTS_OPTION = "-live";
    static final String ALL_OBJECTS_OPTION = "-all";
    private static final String HEAP_DUMP_NO_SPACE_ID = "No space left on device";
    private static final String JCMD_VM_COMMAND_LINE = "VM.command_line";
    static final Logger LOGGER = Logger.getLogger(AttachModelImpl.class.getName());
    private static final ExecutorService winExec = Executors.newCachedThreadPool();
    String pid;
    HotSpotVirtualMachine vm;
    Map<String, String> commandLineMap;

    AttachModelImpl(Application app) {
        this.pid = Integer.toString(app.getPid());
    }

    private static <V> V executeAndWait(Callable<V> call) {
        if (Utilities.isWindows()) {
            Future<V> result = winExec.submit(call);
            try {
                return result.get(SwingUtilities.isEventDispatchThread() ? 5L : 25L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                LOGGER.log(Level.INFO, "executeAndWait get", ex);
                return null;
            }
        }
        try {
            return call.call();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized Properties getSystemProperties() {
        return AttachModelImpl.executeAndWait(() -> {
            try {
                return this.getVirtualMachine().getSystemProperties();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "getSystemProperties", ex);
                return null;
            }
        });
    }

    public synchronized boolean takeHeapDump(String fileName) {
        try {
            InputStream in = this.getVirtualMachine().dumpHeap(fileName, LIVE_OBJECTS_OPTION);
            String out = this.readToEOF(in);
            if (!out.isEmpty()) {
                LOGGER.log(Level.INFO, "takeHeapDump: {0}", out);
            }
            Path f = Paths.get(fileName, new String[0]);
            if (out.contains(HEAP_DUMP_NO_SPACE_ID)) {
                Files.deleteIfExists(f);
                return false;
            }
            return Files.isRegularFile(f, LinkOption.NOFOLLOW_LINKS) && Files.isReadable(f);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "takeHeapDump", ex);
            return false;
        }
    }

    public synchronized String takeThreadDump() {
        try {
            InputStream in = this.getVirtualMachine().remoteDataDump("-l");
            return this.readToEOF(in);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "takeThreadDump", ex);
            return null;
        }
    }

    public synchronized String printFlag(String name) {
        try {
            InputStream in = this.getVirtualMachine().printFlag(name);
            return this.readToEOF(in);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "printFlag", ex);
            return null;
        }
    }

    public synchronized void setFlag(String name, String value) {
        try {
            InputStream in = this.getVirtualMachine().setFlag(name, value);
            String out = this.readToEOF(in);
            if (!out.isEmpty()) {
                LOGGER.log(Level.INFO, "setFlag: {0}", out);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "setFlag", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized HeapHistogramImpl takeHeapHistogram() {
        try (InputStream in = this.getVirtualMachine().heapHisto(ALL_OBJECTS_OPTION);){
            HeapHistogramImpl heapHistogramImpl = new HeapHistogramImpl(in);
            return heapHistogramImpl;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "takeHeapHistogram", ex);
            return null;
        }
    }

    public String getCommandLine() {
        Map<String, String> cmdLineMap = this.getVMCommandLine();
        if (cmdLineMap != null) {
            return cmdLineMap.get("java_command");
        }
        return null;
    }

    public String getJvmArgs() {
        Map<String, String> cmdLineMap = this.getVMCommandLine();
        if (cmdLineMap != null) {
            return cmdLineMap.get("jvm_args");
        }
        return null;
    }

    public String getJvmFlags() {
        Map<String, String> cmdLineMap = this.getVMCommandLine();
        if (cmdLineMap != null) {
            return cmdLineMap.get("jvm_flags");
        }
        return null;
    }

    HotSpotVirtualMachine getVirtualMachine() throws IOException {
        if (this.vm == null) {
            try {
                this.vm = (HotSpotVirtualMachine)VirtualMachine.attach(this.pid);
            }
            catch (Exception x) {
                throw new IOException(x.getLocalizedMessage(), x);
            }
        }
        return this.vm;
    }

    public String executeJCmd(String command, Map<String, Object> pars) {
        StringBuilder commandLine = new StringBuilder(command);
        for (Map.Entry<String, Object> e : pars.entrySet()) {
            String key = e.getKey();
            Object val = e.getValue();
            String par = val == null ? key : String.format("%s=%s", key, AttachModelImpl.quoteString(val.toString()));
            commandLine.append(' ').append(par);
        }
        return this.executeJCmd(commandLine.toString().trim());
    }

    private static String quoteString(String val) {
        if (val.indexOf(32) >= 0) {
            return "\"" + val + "\"";
        }
        return val;
    }

    private synchronized Map<String, String> getVMCommandLine() {
        if (this.commandLineMap == null) {
            String text = this.executeJCmd(JCMD_VM_COMMAND_LINE);
            this.commandLineMap = new HashMap<String, String>();
            if (text != null) {
                String[] lines;
                for (String line : lines = text.split("\\R")) {
                    int offset = line.indexOf(58);
                    if (offset == -1) continue;
                    String key = line.substring(0, offset).trim();
                    String value = line.substring(offset + 1).trim();
                    this.commandLineMap.put(key, value);
                }
            }
        }
        return this.commandLineMap;
    }

    private synchronized String executeJCmd(String command) {
        return AttachModelImpl.executeAndWait(() -> {
            try {
                InputStream in = this.getVirtualMachine().executeJCmd(command);
                return this.readToEOF(in);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "executeJCmd", ex);
                return null;
            }
        });
    }

    private String readToEOF(InputStream in) throws IOException {
        int n;
        StringBuilder buffer = new StringBuilder(1024);
        byte[] b = new byte[256];
        do {
            if ((n = in.read(b)) <= 0) continue;
            String s = new String(b, 0, n, StandardCharsets.UTF_8);
            buffer.append(s);
        } while (n > 0);
        in.close();
        return buffer.toString();
    }

    protected void finalize() throws Throwable {
        if (this.vm != null) {
            this.vm.detach();
        }
        super.finalize();
    }
}

