// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Creates an archive rule.
type CreateArchiveRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the created analyzer.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The criteria for the rule.
	//
	// Filter is a required field
	Filter map[string]Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the rule to create.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateArchiveRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateArchiveRuleInput"}

	if s.AnalyzerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AnalyzerName", 1))
	}

	if s.Filter == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filter"))
	}

	if s.RuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleName", 1))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateArchiveRuleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "filter", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ruleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AnalyzerName != nil {
		v := *s.AnalyzerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "analyzerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateArchiveRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateArchiveRuleOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opCreateArchiveRule = "CreateArchiveRule"

// CreateArchiveRuleRequest returns a request value for making API operation for
// Access Analyzer.
//
// Creates an archive rule for the specified analyzer. Archive rules automatically
// archive findings that meet the criteria you define when you create the rule.
//
//    // Example sending a request using CreateArchiveRuleRequest.
//    req := client.CreateArchiveRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateArchiveRule
func (c *Client) CreateArchiveRuleRequest(input *CreateArchiveRuleInput) CreateArchiveRuleRequest {
	op := &aws.Operation{
		Name:       opCreateArchiveRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule",
	}

	if input == nil {
		input = &CreateArchiveRuleInput{}
	}

	req := c.newRequest(op, input, &CreateArchiveRuleOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return CreateArchiveRuleRequest{Request: req, Input: input, Copy: c.CreateArchiveRuleRequest}
}

// CreateArchiveRuleRequest is the request type for the
// CreateArchiveRule API operation.
type CreateArchiveRuleRequest struct {
	*aws.Request
	Input *CreateArchiveRuleInput
	Copy  func(*CreateArchiveRuleInput) CreateArchiveRuleRequest
}

// Send marshals and sends the CreateArchiveRule API request.
func (r CreateArchiveRuleRequest) Send(ctx context.Context) (*CreateArchiveRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateArchiveRuleResponse{
		CreateArchiveRuleOutput: r.Request.Data.(*CreateArchiveRuleOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateArchiveRuleResponse is the response type for the
// CreateArchiveRule API operation.
type CreateArchiveRuleResponse struct {
	*CreateArchiveRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateArchiveRule request.
func (r *CreateArchiveRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
