// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListPredictorsInput struct {
	_ struct{} `type:"structure"`

	// An array of filters. For each filter, you provide a condition and a match
	// statement. The condition is either IS or IS_NOT, which specifies whether
	// to include or exclude the predictors that match the statement from the list,
	// respectively. The match statement consists of a key and a value.
	//
	// Filter properties
	//
	//    * Condition - The condition to apply. Valid values are IS and IS_NOT.
	//    To include the predictors that match the statement, specify IS. To exclude
	//    matching predictors, specify IS_NOT.
	//
	//    * Key - The name of the parameter to filter on. Valid values are DatasetGroupArn
	//    and Status.
	//
	//    * Value - The value to match.
	//
	// For example, to list all predictors whose status is ACTIVE, you would specify:
	//
	// "Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" } ]
	Filters []Filter `type:"list"`

	// The number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request was truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPredictorsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPredictorsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPredictorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListPredictorsOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon Forecast returns this token. To retrieve
	// the next set of results, use the token in the next request.
	NextToken *string `min:"1" type:"string"`

	// An array of objects that summarize each predictor's properties.
	Predictors []PredictorSummary `type:"list"`
}

// String returns the string representation
func (s ListPredictorsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListPredictors = "ListPredictors"

// ListPredictorsRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Returns a list of predictors created using the CreatePredictor operation.
// For each predictor, this operation returns a summary of its properties, including
// its Amazon Resource Name (ARN). You can retrieve the complete set of properties
// by using the ARN with the DescribePredictor operation. You can filter the
// list using an array of Filter objects.
//
//    // Example sending a request using ListPredictorsRequest.
//    req := client.ListPredictorsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListPredictors
func (c *Client) ListPredictorsRequest(input *ListPredictorsInput) ListPredictorsRequest {
	op := &aws.Operation{
		Name:       opListPredictors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPredictorsInput{}
	}

	req := c.newRequest(op, input, &ListPredictorsOutput{})
	return ListPredictorsRequest{Request: req, Input: input, Copy: c.ListPredictorsRequest}
}

// ListPredictorsRequest is the request type for the
// ListPredictors API operation.
type ListPredictorsRequest struct {
	*aws.Request
	Input *ListPredictorsInput
	Copy  func(*ListPredictorsInput) ListPredictorsRequest
}

// Send marshals and sends the ListPredictors API request.
func (r ListPredictorsRequest) Send(ctx context.Context) (*ListPredictorsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPredictorsResponse{
		ListPredictorsOutput: r.Request.Data.(*ListPredictorsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPredictorsRequestPaginator returns a paginator for ListPredictors.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPredictorsRequest(input)
//   p := forecast.NewListPredictorsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPredictorsPaginator(req ListPredictorsRequest) ListPredictorsPaginator {
	return ListPredictorsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPredictorsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPredictorsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPredictorsPaginator struct {
	aws.Pager
}

func (p *ListPredictorsPaginator) CurrentPage() *ListPredictorsOutput {
	return p.Pager.CurrentPage().(*ListPredictorsOutput)
}

// ListPredictorsResponse is the response type for the
// ListPredictors API operation.
type ListPredictorsResponse struct {
	*ListPredictorsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPredictors request.
func (r *ListPredictorsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
