// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package groundstation

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about how AWS Ground Station should configure an antenna for
// downlink during a contact.
type AntennaDownlinkConfig struct {
	_ struct{} `type:"structure"`

	// Object that describes a spectral Config.
	//
	// SpectrumConfig is a required field
	SpectrumConfig *SpectrumConfig `locationName:"spectrumConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s AntennaDownlinkConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AntennaDownlinkConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AntennaDownlinkConfig"}

	if s.SpectrumConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpectrumConfig"))
	}
	if s.SpectrumConfig != nil {
		if err := s.SpectrumConfig.Validate(); err != nil {
			invalidParams.AddNested("SpectrumConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AntennaDownlinkConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.SpectrumConfig != nil {
		v := s.SpectrumConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spectrumConfig", v, metadata)
	}
	return nil
}

// Information about how AWS Ground Station should conﬁgure an antenna for
// downlink demod decode during a contact.
type AntennaDownlinkDemodDecodeConfig struct {
	_ struct{} `type:"structure"`

	// Information about the decode Config.
	//
	// DecodeConfig is a required field
	DecodeConfig *DecodeConfig `locationName:"decodeConfig" type:"structure" required:"true"`

	// Information about the demodulation Config.
	//
	// DemodulationConfig is a required field
	DemodulationConfig *DemodulationConfig `locationName:"demodulationConfig" type:"structure" required:"true"`

	// Object that describes a spectral Config.
	//
	// SpectrumConfig is a required field
	SpectrumConfig *SpectrumConfig `locationName:"spectrumConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s AntennaDownlinkDemodDecodeConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AntennaDownlinkDemodDecodeConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AntennaDownlinkDemodDecodeConfig"}

	if s.DecodeConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("DecodeConfig"))
	}

	if s.DemodulationConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("DemodulationConfig"))
	}

	if s.SpectrumConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpectrumConfig"))
	}
	if s.DecodeConfig != nil {
		if err := s.DecodeConfig.Validate(); err != nil {
			invalidParams.AddNested("DecodeConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.DemodulationConfig != nil {
		if err := s.DemodulationConfig.Validate(); err != nil {
			invalidParams.AddNested("DemodulationConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.SpectrumConfig != nil {
		if err := s.SpectrumConfig.Validate(); err != nil {
			invalidParams.AddNested("SpectrumConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AntennaDownlinkDemodDecodeConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.DecodeConfig != nil {
		v := s.DecodeConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "decodeConfig", v, metadata)
	}
	if s.DemodulationConfig != nil {
		v := s.DemodulationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "demodulationConfig", v, metadata)
	}
	if s.SpectrumConfig != nil {
		v := s.SpectrumConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spectrumConfig", v, metadata)
	}
	return nil
}

// Information about the uplink Config of an antenna.
type AntennaUplinkConfig struct {
	_ struct{} `type:"structure"`

	// Information about the uplink spectral Config.
	//
	// SpectrumConfig is a required field
	SpectrumConfig *UplinkSpectrumConfig `locationName:"spectrumConfig" type:"structure" required:"true"`

	// Object that represents EIRP.
	//
	// TargetEirp is a required field
	TargetEirp *Eirp `locationName:"targetEirp" type:"structure" required:"true"`
}

// String returns the string representation
func (s AntennaUplinkConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AntennaUplinkConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AntennaUplinkConfig"}

	if s.SpectrumConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpectrumConfig"))
	}

	if s.TargetEirp == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetEirp"))
	}
	if s.SpectrumConfig != nil {
		if err := s.SpectrumConfig.Validate(); err != nil {
			invalidParams.AddNested("SpectrumConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.TargetEirp != nil {
		if err := s.TargetEirp.Validate(); err != nil {
			invalidParams.AddNested("TargetEirp", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AntennaUplinkConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.SpectrumConfig != nil {
		v := s.SpectrumConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spectrumConfig", v, metadata)
	}
	if s.TargetEirp != nil {
		v := s.TargetEirp

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "targetEirp", v, metadata)
	}
	return nil
}

// An item in a list of Config objects.
type ConfigListItem struct {
	_ struct{} `type:"structure"`

	ConfigArn *string `locationName:"configArn" type:"string"`

	ConfigId *string `locationName:"configId" type:"string"`

	ConfigType ConfigCapabilityType `locationName:"configType" type:"string" enum:"true"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s ConfigListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConfigListItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConfigArn != nil {
		v := *s.ConfigArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigId != nil {
		v := *s.ConfigId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ConfigType) > 0 {
		v := s.ConfigType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Object containing the parameters for a Config.
//
// See the subtype definitions for what each type of Config contains.
type ConfigTypeData struct {
	_ struct{} `type:"structure"`

	// Information about how AWS Ground Station should configure an antenna for
	// downlink during a contact.
	AntennaDownlinkConfig *AntennaDownlinkConfig `locationName:"antennaDownlinkConfig" type:"structure"`

	// Information about how AWS Ground Station should conﬁgure an antenna for
	// downlink demod decode during a contact.
	AntennaDownlinkDemodDecodeConfig *AntennaDownlinkDemodDecodeConfig `locationName:"antennaDownlinkDemodDecodeConfig" type:"structure"`

	// Information about the uplink Config of an antenna.
	AntennaUplinkConfig *AntennaUplinkConfig `locationName:"antennaUplinkConfig" type:"structure"`

	// Information about the dataflow endpoint Config.
	DataflowEndpointConfig *DataflowEndpointConfig `locationName:"dataflowEndpointConfig" type:"structure"`

	// Object that determines whether tracking should be used during a contact executed
	// with this Config in the mission profile.
	TrackingConfig *TrackingConfig `locationName:"trackingConfig" type:"structure"`

	// Information about an uplink echo Config.
	//
	// Parameters from the AntennaUplinkConfig, corresponding to the specified AntennaUplinkConfigArn,
	// are used when this UplinkEchoConfig is used in a contact.
	UplinkEchoConfig *UplinkEchoConfig `locationName:"uplinkEchoConfig" type:"structure"`
}

// String returns the string representation
func (s ConfigTypeData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigTypeData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfigTypeData"}
	if s.AntennaDownlinkConfig != nil {
		if err := s.AntennaDownlinkConfig.Validate(); err != nil {
			invalidParams.AddNested("AntennaDownlinkConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.AntennaDownlinkDemodDecodeConfig != nil {
		if err := s.AntennaDownlinkDemodDecodeConfig.Validate(); err != nil {
			invalidParams.AddNested("AntennaDownlinkDemodDecodeConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.AntennaUplinkConfig != nil {
		if err := s.AntennaUplinkConfig.Validate(); err != nil {
			invalidParams.AddNested("AntennaUplinkConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.DataflowEndpointConfig != nil {
		if err := s.DataflowEndpointConfig.Validate(); err != nil {
			invalidParams.AddNested("DataflowEndpointConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.TrackingConfig != nil {
		if err := s.TrackingConfig.Validate(); err != nil {
			invalidParams.AddNested("TrackingConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.UplinkEchoConfig != nil {
		if err := s.UplinkEchoConfig.Validate(); err != nil {
			invalidParams.AddNested("UplinkEchoConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConfigTypeData) MarshalFields(e protocol.FieldEncoder) error {
	if s.AntennaDownlinkConfig != nil {
		v := s.AntennaDownlinkConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "antennaDownlinkConfig", v, metadata)
	}
	if s.AntennaDownlinkDemodDecodeConfig != nil {
		v := s.AntennaDownlinkDemodDecodeConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "antennaDownlinkDemodDecodeConfig", v, metadata)
	}
	if s.AntennaUplinkConfig != nil {
		v := s.AntennaUplinkConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "antennaUplinkConfig", v, metadata)
	}
	if s.DataflowEndpointConfig != nil {
		v := s.DataflowEndpointConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dataflowEndpointConfig", v, metadata)
	}
	if s.TrackingConfig != nil {
		v := s.TrackingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "trackingConfig", v, metadata)
	}
	if s.UplinkEchoConfig != nil {
		v := s.UplinkEchoConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "uplinkEchoConfig", v, metadata)
	}
	return nil
}

// Data describing a contact.
type ContactData struct {
	_ struct{} `type:"structure"`

	ContactId *string `locationName:"contactId" type:"string"`

	ContactStatus ContactStatus `locationName:"contactStatus" type:"string" enum:"true"`

	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	GroundStation *string `locationName:"groundStation" type:"string"`

	// Elevation angle of the satellite in the sky during a contact.
	MaximumElevation *Elevation `locationName:"maximumElevation" type:"structure"`

	MissionProfileArn *string `locationName:"missionProfileArn" type:"string"`

	PostPassEndTime *time.Time `locationName:"postPassEndTime" type:"timestamp"`

	PrePassStartTime *time.Time `locationName:"prePassStartTime" type:"timestamp"`

	SatelliteArn *string `locationName:"satelliteArn" type:"string"`

	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ContactData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContactData) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContactId != nil {
		v := *s.ContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ContactStatus) > 0 {
		v := s.ContactStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contactStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroundStation != nil {
		v := *s.GroundStation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groundStation", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaximumElevation != nil {
		v := s.MaximumElevation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "maximumElevation", v, metadata)
	}
	if s.MissionProfileArn != nil {
		v := *s.MissionProfileArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "missionProfileArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PostPassEndTime != nil {
		v := *s.PostPassEndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "postPassEndTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.PrePassStartTime != nil {
		v := *s.PrePassStartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "prePassStartTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.SatelliteArn != nil {
		v := *s.SatelliteArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "satelliteArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Information about a dataflow endpoint.
type DataflowEndpoint struct {
	_ struct{} `type:"structure"`

	// Information about the socket address.
	Address *SocketAddress `locationName:"address" type:"structure"`

	Name *string `locationName:"name" min:"1" type:"string"`

	Status EndpointStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s DataflowEndpoint) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataflowEndpoint) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataflowEndpoint"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Address != nil {
		if err := s.Address.Validate(); err != nil {
			invalidParams.AddNested("Address", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataflowEndpoint) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := s.Address

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "address", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about the dataflow endpoint Config.
type DataflowEndpointConfig struct {
	_ struct{} `type:"structure"`

	// DataflowEndpointName is a required field
	DataflowEndpointName *string `locationName:"dataflowEndpointName" type:"string" required:"true"`
}

// String returns the string representation
func (s DataflowEndpointConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataflowEndpointConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataflowEndpointConfig"}

	if s.DataflowEndpointName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataflowEndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataflowEndpointConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataflowEndpointName != nil {
		v := *s.DataflowEndpointName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowEndpointName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Item in a list of DataflowEndpoint groups.
type DataflowEndpointListItem struct {
	_ struct{} `type:"structure"`

	DataflowEndpointGroupArn *string `locationName:"dataflowEndpointGroupArn" type:"string"`

	DataflowEndpointGroupId *string `locationName:"dataflowEndpointGroupId" type:"string"`
}

// String returns the string representation
func (s DataflowEndpointListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataflowEndpointListItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataflowEndpointGroupArn != nil {
		v := *s.DataflowEndpointGroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowEndpointGroupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataflowEndpointGroupId != nil {
		v := *s.DataflowEndpointGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowEndpointGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the decode Config.
type DecodeConfig struct {
	_ struct{} `type:"structure"`

	// UnvalidatedJSON is a required field
	UnvalidatedJSON *string `locationName:"unvalidatedJSON" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DecodeConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecodeConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DecodeConfig"}

	if s.UnvalidatedJSON == nil {
		invalidParams.Add(aws.NewErrParamRequired("UnvalidatedJSON"))
	}
	if s.UnvalidatedJSON != nil && len(*s.UnvalidatedJSON) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("UnvalidatedJSON", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DecodeConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.UnvalidatedJSON != nil {
		v := *s.UnvalidatedJSON

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unvalidatedJSON", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the demodulation Config.
type DemodulationConfig struct {
	_ struct{} `type:"structure"`

	// UnvalidatedJSON is a required field
	UnvalidatedJSON *string `locationName:"unvalidatedJSON" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DemodulationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DemodulationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DemodulationConfig"}

	if s.UnvalidatedJSON == nil {
		invalidParams.Add(aws.NewErrParamRequired("UnvalidatedJSON"))
	}
	if s.UnvalidatedJSON != nil && len(*s.UnvalidatedJSON) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("UnvalidatedJSON", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DemodulationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.UnvalidatedJSON != nil {
		v := *s.UnvalidatedJSON

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unvalidatedJSON", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Object that represents EIRP.
type Eirp struct {
	_ struct{} `type:"structure"`

	// Units is a required field
	Units EirpUnits `locationName:"units" type:"string" required:"true" enum:"true"`

	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s Eirp) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Eirp) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Eirp"}
	if len(s.Units) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Units"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Eirp) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Units) > 0 {
		v := s.Units

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "units", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Elevation angle of the satellite in the sky during a contact.
type Elevation struct {
	_ struct{} `type:"structure"`

	// Unit is a required field
	Unit AngleUnits `locationName:"unit" type:"string" required:"true" enum:"true"`

	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s Elevation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Elevation) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Information about the endpoint details.
type EndpointDetails struct {
	_ struct{} `type:"structure"`

	// Information about a dataflow endpoint.
	Endpoint *DataflowEndpoint `locationName:"endpoint" type:"structure"`

	// Information about endpoints.
	SecurityDetails *SecurityDetails `locationName:"securityDetails" type:"structure"`
}

// String returns the string representation
func (s EndpointDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EndpointDetails"}
	if s.Endpoint != nil {
		if err := s.Endpoint.Validate(); err != nil {
			invalidParams.AddNested("Endpoint", err.(aws.ErrInvalidParams))
		}
	}
	if s.SecurityDetails != nil {
		if err := s.SecurityDetails.Validate(); err != nil {
			invalidParams.AddNested("SecurityDetails", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Endpoint != nil {
		v := s.Endpoint

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "endpoint", v, metadata)
	}
	if s.SecurityDetails != nil {
		v := s.SecurityDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "securityDetails", v, metadata)
	}
	return nil
}

// Object that describes the frequency.
type Frequency struct {
	_ struct{} `type:"structure"`

	// Units is a required field
	Units FrequencyUnits `locationName:"units" type:"string" required:"true" enum:"true"`

	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s Frequency) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Frequency) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Frequency"}
	if len(s.Units) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Units"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Frequency) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Units) > 0 {
		v := s.Units

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "units", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Object that describes the frequency bandwidth.
type FrequencyBandwidth struct {
	_ struct{} `type:"structure"`

	// Units is a required field
	Units BandwidthUnits `locationName:"units" type:"string" required:"true" enum:"true"`

	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s FrequencyBandwidth) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FrequencyBandwidth) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FrequencyBandwidth"}
	if len(s.Units) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Units"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FrequencyBandwidth) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Units) > 0 {
		v := s.Units

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "units", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Information about the ground station data.
type GroundStationData struct {
	_ struct{} `type:"structure"`

	GroundStationId *string `locationName:"groundStationId" type:"string"`

	GroundStationName *string `locationName:"groundStationName" type:"string"`

	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation
func (s GroundStationData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroundStationData) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroundStationId != nil {
		v := *s.GroundStationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groundStationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroundStationName != nil {
		v := *s.GroundStationName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groundStationName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Item in a list of mission profiles.
type MissionProfileListItem struct {
	_ struct{} `type:"structure"`

	MissionProfileArn *string `locationName:"missionProfileArn" type:"string"`

	MissionProfileId *string `locationName:"missionProfileId" type:"string"`

	Name *string `locationName:"name" type:"string"`

	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation
func (s MissionProfileListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MissionProfileListItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.MissionProfileArn != nil {
		v := *s.MissionProfileArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "missionProfileArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MissionProfileId != nil {
		v := *s.MissionProfileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "missionProfileId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Item in a list of satellites.
type SatelliteListItem struct {
	_ struct{} `type:"structure"`

	NoradSatelliteID *int64 `locationName:"noradSatelliteID" min:"1" type:"integer"`

	SatelliteArn *string `locationName:"satelliteArn" type:"string"`

	SatelliteId *string `locationName:"satelliteId" min:"1" type:"string"`
}

// String returns the string representation
func (s SatelliteListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SatelliteListItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.NoradSatelliteID != nil {
		v := *s.NoradSatelliteID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "noradSatelliteID", protocol.Int64Value(v), metadata)
	}
	if s.SatelliteArn != nil {
		v := *s.SatelliteArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "satelliteArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SatelliteId != nil {
		v := *s.SatelliteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "satelliteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about endpoints.
type SecurityDetails struct {
	_ struct{} `type:"structure"`

	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// SecurityGroupIds is a required field
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list" required:"true"`

	// SubnetIds is a required field
	SubnetIds []string `locationName:"subnetIds" type:"list" required:"true"`
}

// String returns the string representation
func (s SecurityDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SecurityDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SecurityDetails"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.SecurityGroupIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityGroupIds"))
	}

	if s.SubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SecurityDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Information about the socket address.
type SocketAddress struct {
	_ struct{} `type:"structure"`

	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Port is a required field
	Port *int64 `locationName:"port" type:"integer" required:"true"`
}

// String returns the string representation
func (s SocketAddress) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SocketAddress) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SocketAddress"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SocketAddress) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Object that describes a spectral Config.
type SpectrumConfig struct {
	_ struct{} `type:"structure"`

	// Object that describes the frequency bandwidth.
	//
	// Bandwidth is a required field
	Bandwidth *FrequencyBandwidth `locationName:"bandwidth" type:"structure" required:"true"`

	// Object that describes the frequency.
	//
	// CenterFrequency is a required field
	CenterFrequency *Frequency `locationName:"centerFrequency" type:"structure" required:"true"`

	Polarization Polarization `locationName:"polarization" type:"string" enum:"true"`
}

// String returns the string representation
func (s SpectrumConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SpectrumConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SpectrumConfig"}

	if s.Bandwidth == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bandwidth"))
	}

	if s.CenterFrequency == nil {
		invalidParams.Add(aws.NewErrParamRequired("CenterFrequency"))
	}
	if s.Bandwidth != nil {
		if err := s.Bandwidth.Validate(); err != nil {
			invalidParams.AddNested("Bandwidth", err.(aws.ErrInvalidParams))
		}
	}
	if s.CenterFrequency != nil {
		if err := s.CenterFrequency.Validate(); err != nil {
			invalidParams.AddNested("CenterFrequency", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SpectrumConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bandwidth != nil {
		v := s.Bandwidth

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "bandwidth", v, metadata)
	}
	if s.CenterFrequency != nil {
		v := s.CenterFrequency

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "centerFrequency", v, metadata)
	}
	if len(s.Polarization) > 0 {
		v := s.Polarization

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "polarization", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Object that determines whether tracking should be used during a contact executed
// with this Config in the mission profile.
type TrackingConfig struct {
	_ struct{} `type:"structure"`

	// Autotrack is a required field
	Autotrack Criticality `locationName:"autotrack" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TrackingConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrackingConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TrackingConfig"}
	if len(s.Autotrack) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Autotrack"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TrackingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Autotrack) > 0 {
		v := s.Autotrack

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autotrack", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about an uplink echo Config.
//
// Parameters from the AntennaUplinkConfig, corresponding to the specified AntennaUplinkConfigArn,
// are used when this UplinkEchoConfig is used in a contact.
type UplinkEchoConfig struct {
	_ struct{} `type:"structure"`

	// AntennaUplinkConfigArn is a required field
	AntennaUplinkConfigArn *string `locationName:"antennaUplinkConfigArn" type:"string" required:"true"`

	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation
func (s UplinkEchoConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UplinkEchoConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UplinkEchoConfig"}

	if s.AntennaUplinkConfigArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AntennaUplinkConfigArn"))
	}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UplinkEchoConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AntennaUplinkConfigArn != nil {
		v := *s.AntennaUplinkConfigArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "antennaUplinkConfigArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Information about the uplink spectral Config.
type UplinkSpectrumConfig struct {
	_ struct{} `type:"structure"`

	// Object that describes the frequency.
	//
	// CenterFrequency is a required field
	CenterFrequency *Frequency `locationName:"centerFrequency" type:"structure" required:"true"`

	Polarization Polarization `locationName:"polarization" type:"string" enum:"true"`
}

// String returns the string representation
func (s UplinkSpectrumConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UplinkSpectrumConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UplinkSpectrumConfig"}

	if s.CenterFrequency == nil {
		invalidParams.Add(aws.NewErrParamRequired("CenterFrequency"))
	}
	if s.CenterFrequency != nil {
		if err := s.CenterFrequency.Validate(); err != nil {
			invalidParams.AddNested("CenterFrequency", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UplinkSpectrumConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.CenterFrequency != nil {
		v := s.CenterFrequency

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "centerFrequency", v, metadata)
	}
	if len(s.Polarization) > 0 {
		v := s.Polarization

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "polarization", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}
