// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetJourneyExecutionActivityMetricsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JourneyActivityId is a required field
	JourneyActivityId *string `location:"uri" locationName:"journey-activity-id" type:"string" required:"true"`

	// JourneyId is a required field
	JourneyId *string `location:"uri" locationName:"journey-id" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`
}

// String returns the string representation
func (s GetJourneyExecutionActivityMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJourneyExecutionActivityMetricsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetJourneyExecutionActivityMetricsInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.JourneyActivityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JourneyActivityId"))
	}

	if s.JourneyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JourneyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetJourneyExecutionActivityMetricsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JourneyActivityId != nil {
		v := *s.JourneyActivityId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "journey-activity-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JourneyId != nil {
		v := *s.JourneyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "journey-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "page-size", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetJourneyExecutionActivityMetricsOutput struct {
	_ struct{} `type:"structure" payload:"JourneyExecutionActivityMetricsResponse"`

	// Provides the results of a query that retrieved the data for a standard execution
	// metric that applies to a journey activity, and provides information about
	// that query.
	//
	// JourneyExecutionActivityMetricsResponse is a required field
	JourneyExecutionActivityMetricsResponse *JourneyExecutionActivityMetricsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetJourneyExecutionActivityMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetJourneyExecutionActivityMetricsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.JourneyExecutionActivityMetricsResponse != nil {
		v := s.JourneyExecutionActivityMetricsResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "JourneyExecutionActivityMetricsResponse", v, metadata)
	}
	return nil
}

const opGetJourneyExecutionActivityMetrics = "GetJourneyExecutionActivityMetrics"

// GetJourneyExecutionActivityMetricsRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves (queries) pre-aggregated data for a standard execution metric that
// applies to a journey activity.
//
//    // Example sending a request using GetJourneyExecutionActivityMetricsRequest.
//    req := client.GetJourneyExecutionActivityMetricsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionActivityMetrics
func (c *Client) GetJourneyExecutionActivityMetricsRequest(input *GetJourneyExecutionActivityMetricsInput) GetJourneyExecutionActivityMetricsRequest {
	op := &aws.Operation{
		Name:       opGetJourneyExecutionActivityMetrics,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}/activities/{journey-activity-id}/execution-metrics",
	}

	if input == nil {
		input = &GetJourneyExecutionActivityMetricsInput{}
	}

	req := c.newRequest(op, input, &GetJourneyExecutionActivityMetricsOutput{})
	return GetJourneyExecutionActivityMetricsRequest{Request: req, Input: input, Copy: c.GetJourneyExecutionActivityMetricsRequest}
}

// GetJourneyExecutionActivityMetricsRequest is the request type for the
// GetJourneyExecutionActivityMetrics API operation.
type GetJourneyExecutionActivityMetricsRequest struct {
	*aws.Request
	Input *GetJourneyExecutionActivityMetricsInput
	Copy  func(*GetJourneyExecutionActivityMetricsInput) GetJourneyExecutionActivityMetricsRequest
}

// Send marshals and sends the GetJourneyExecutionActivityMetrics API request.
func (r GetJourneyExecutionActivityMetricsRequest) Send(ctx context.Context) (*GetJourneyExecutionActivityMetricsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetJourneyExecutionActivityMetricsResponse{
		GetJourneyExecutionActivityMetricsOutput: r.Request.Data.(*GetJourneyExecutionActivityMetricsOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetJourneyExecutionActivityMetricsResponse is the response type for the
// GetJourneyExecutionActivityMetrics API operation.
type GetJourneyExecutionActivityMetricsResponse struct {
	*GetJourneyExecutionActivityMetricsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetJourneyExecutionActivityMetrics request.
func (r *GetJourneyExecutionActivityMetricsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
