// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to create an email template. For more information, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
type CreateTemplateInput struct {
	_ struct{} `type:"structure"`

	// The content of the email, composed of a subject line, an HTML part, and a
	// text-only part.
	//
	// Template is a required field
	Template *Template `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTemplateInput"}

	if s.Template == nil {
		invalidParams.Add(aws.NewErrParamRequired("Template"))
	}
	if s.Template != nil {
		if err := s.Template.Validate(); err != nil {
			invalidParams.AddNested("Template", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTemplate = "CreateTemplate"

// CreateTemplateRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Creates an email template. Email templates enable you to send personalized
// email to one or more destinations in a single API operation. For more information,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using CreateTemplateRequest.
//    req := client.CreateTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateTemplate
func (c *Client) CreateTemplateRequest(input *CreateTemplateInput) CreateTemplateRequest {
	op := &aws.Operation{
		Name:       opCreateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTemplateInput{}
	}

	req := c.newRequest(op, input, &CreateTemplateOutput{})
	return CreateTemplateRequest{Request: req, Input: input, Copy: c.CreateTemplateRequest}
}

// CreateTemplateRequest is the request type for the
// CreateTemplate API operation.
type CreateTemplateRequest struct {
	*aws.Request
	Input *CreateTemplateInput
	Copy  func(*CreateTemplateInput) CreateTemplateRequest
}

// Send marshals and sends the CreateTemplate API request.
func (r CreateTemplateRequest) Send(ctx context.Context) (*CreateTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTemplateResponse{
		CreateTemplateOutput: r.Request.Data.(*CreateTemplateOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTemplateResponse is the response type for the
// CreateTemplate API operation.
type CreateTemplateResponse struct {
	*CreateTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTemplate request.
func (r *CreateTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
