// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package playdeveloperreporting provides access to the Google Play Developer Reporting API.
//
// For product documentation, see: https://developers.google.com/play/developer/reporting
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/playdeveloperreporting/v1beta1"
//	...
//	ctx := context.Background()
//	playdeveloperreportingService, err := playdeveloperreporting.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	playdeveloperreportingService, err := playdeveloperreporting.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	playdeveloperreportingService, err := playdeveloperreporting.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package playdeveloperreporting // import "google.golang.org/api/playdeveloperreporting/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "playdeveloperreporting:v1beta1"
const apiName = "playdeveloperreporting"
const apiVersion = "v1beta1"
const basePath = "https://playdeveloperreporting.googleapis.com/"
const mtlsBasePath = "https://playdeveloperreporting.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Anomalies = NewAnomaliesService(s)
	s.Vitals = NewVitalsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Anomalies *AnomaliesService

	Vitals *VitalsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAnomaliesService(s *Service) *AnomaliesService {
	rs := &AnomaliesService{s: s}
	return rs
}

type AnomaliesService struct {
	s *Service
}

func NewVitalsService(s *Service) *VitalsService {
	rs := &VitalsService{s: s}
	rs.Anrrate = NewVitalsAnrrateService(s)
	rs.Crashrate = NewVitalsCrashrateService(s)
	rs.Excessivewakeuprate = NewVitalsExcessivewakeuprateService(s)
	rs.Stuckbackgroundwakelockrate = NewVitalsStuckbackgroundwakelockrateService(s)
	return rs
}

type VitalsService struct {
	s *Service

	Anrrate *VitalsAnrrateService

	Crashrate *VitalsCrashrateService

	Excessivewakeuprate *VitalsExcessivewakeuprateService

	Stuckbackgroundwakelockrate *VitalsStuckbackgroundwakelockrateService
}

func NewVitalsAnrrateService(s *Service) *VitalsAnrrateService {
	rs := &VitalsAnrrateService{s: s}
	return rs
}

type VitalsAnrrateService struct {
	s *Service
}

func NewVitalsCrashrateService(s *Service) *VitalsCrashrateService {
	rs := &VitalsCrashrateService{s: s}
	return rs
}

type VitalsCrashrateService struct {
	s *Service
}

func NewVitalsExcessivewakeuprateService(s *Service) *VitalsExcessivewakeuprateService {
	rs := &VitalsExcessivewakeuprateService{s: s}
	return rs
}

type VitalsExcessivewakeuprateService struct {
	s *Service
}

func NewVitalsStuckbackgroundwakelockrateService(s *Service) *VitalsStuckbackgroundwakelockrateService {
	rs := &VitalsStuckbackgroundwakelockrateService{s: s}
	return rs
}

type VitalsStuckbackgroundwakelockrateService struct {
	s *Service
}

// GooglePlayDeveloperReportingV1beta1Anomaly: Represents an anomaly
// detected in a dataset. Our anomaly detection systems flag datapoints
// in a time series that fall outside of and expected range derived from
// historical data. Although those expected ranges have an upper and a
// lower bound, we only flag anomalies when the data has become
// unexpectedly _worse_, which usually corresponds to the case where the
// metric crosses the upper bound. Multiple contiguous datapoints in a
// timeline outside of the expected range will be grouped into a single
// anomaly. Therefore, an anomaly represents effectively a segment of a
// metric's timeline. The information stored in the `timeline_spec`,
// `dimensions` and `metric` can be used to fetch a full timeline with
// extended ragne for context. **Required permissions**: to access this
// resource, the calling user needs the _View app information
// (read-only)_ permission for the app.
type GooglePlayDeveloperReportingV1beta1Anomaly struct {
	// Dimensions: Combination of dimensions in which the anomaly was
	// detected.
	Dimensions []*GooglePlayDeveloperReportingV1beta1DimensionValue `json:"dimensions,omitempty"`

	// Metric: Metric where the anomaly was detected, together with the
	// anomalous value.
	Metric *GooglePlayDeveloperReportingV1beta1MetricValue `json:"metric,omitempty"`

	// MetricSet: Metric set resource where the anomaly was detected.
	MetricSet string `json:"metricSet,omitempty"`

	// Name: Name of the anomaly. Format: apps/{app}/anomalies/{anomaly}
	Name string `json:"name,omitempty"`

	// TimelineSpec: Timeline specification that covers the anomaly period.
	TimelineSpec *GooglePlayDeveloperReportingV1beta1TimelineSpec `json:"timelineSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1Anomaly) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1Anomaly
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1AnrRateMetricSet: Singleton
// resource representing the set of ANR (Application not responding)
// metrics. This metric set contains ANRs data combined with usage data
// to produce a normalized metric independent of user counts.
// **Supported aggregation periods:** * DAILY: metrics are aggregated in
// calendar date intervals. Due to historical constraints, the only
// supported timezone is `America/Los_Angeles`. **Supported metrics:** *
// `anrRate` (`google.type.Decimal`): Percentage of distinct users in
// the aggregation period that experienced at least one ANR. *
// `anrRate7dUserWeighted` (`google.type.Decimal`): Rolling average
// value of `anrRate` in the last 7 days. The daily values are weighted
// by the count of distinct users for the day. *
// `anrRate28dUserWeighted` (`google.type.Decimal`): Rolling average
// value of `anrRate` in the last 28 days. The daily values are weighted
// by the count of distinct users for the day. * `userPerceivedAnrRate`
// (`google.type.Decimal`): Percentage of distinct users in the
// aggregation period that experienced at least one user-perceived ANR.
// User-perceived ANRs are currently those of 'Input dispatching' type.
// * `userPerceivedAnrRate7dUserWeighted` (`google.type.Decimal`):
// Rolling average value of `userPerceivedAnrRate` in the last 7 days.
// The daily values are weighted by the count of distinct users for the
// day. * `userPerceivedAnrRate28dUserWeighted` (`google.type.Decimal`):
// Rolling average value of `userPerceivedAnrRate` in the last 28 days.
// The daily values are weighted by the count of distinct users for the
// day. * `distinctUsers` (`google.type.Decimal`): Count of distinct
// users in the aggregation period that were used as normalization value
// for the `anrRate` and `userPerceivedAnrRate` metrics. A user is
// counted in this metric if they used the app in the foreground during
// the aggregation period. Care must be taken not to aggregate this
// count further, as it may result in users being counted multiple
// times. **Supported dimensions:** * `apiLevel` (string): the API level
// of Android that was running on the user's device. * `versionCode`
// (int64): version of the app that was running on the user's device. *
// `deviceModel` (string): unique identifier of the user's device model.
// * `deviceType` (string): the type (also known as form factor) of the
// user's device. * `countryCode` (string): the country or region of the
// user's device based on their IP address, represented as a 2-letter
// ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
// (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). *
// `deviceSocMake` (string): Make of the device's primary
// system-on-chip, e.g., Samsung. Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
// * `deviceSocModel` (string): Model of the device's primary
// system-on-chip, e.g., "Exynos 2100". Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
// version of the device, e.g., "196610". * `deviceScreenSize` (string):
// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
// (string): Screen density of the device, e.g., mdpi, hdpi. **Required
// permissions**: to access this resource, the calling user needs the
// _View app information (read-only)_ permission for the app. **Related
// metric sets:** * vitals.errors contains unnormalized version
// (absolute counts) of crashes. * vitals.errors contains normalized
// metrics about crashes, another stability metric.
type GooglePlayDeveloperReportingV1beta1AnrRateMetricSet struct {
	// FreshnessInfo: Summary about data freshness in this resource.
	FreshnessInfo *GooglePlayDeveloperReportingV1beta1FreshnessInfo `json:"freshnessInfo,omitempty"`

	// Name: The resource name. Format: apps/{app}/anrRateMetricSet
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FreshnessInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FreshnessInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1AnrRateMetricSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1AnrRateMetricSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1CrashRateMetricSet: Singleton
// resource representing the set of crashrate metrics. This metric set
// contains crashes data combined with usage data to produce a
// normalized metric independent of user counts. **Supported aggregation
// periods:** * DAILY: metrics are aggregated in calendar date
// intervals. Due to historical constraints, the only supported timezone
// is `America/Los_Angeles`. **Supported metrics:** * `crashRate`
// (`google.type.Decimal`): Percentage of distinct users in the
// aggregation period that experienced at least one crash. *
// `crashRate7dUserWeighted` (`google.type.Decimal`): Rolling average
// value of `crashRate` in the last 7 days. The daily values are
// weighted by the count of distinct users for the day. *
// `crashRate28dUserWeighted` (`google.type.Decimal`): Rolling average
// value of `crashRate` in the last 28 days. The daily values are
// weighted by the count of distinct users for the day. *
// `userPerceivedCrashRate` (`google.type.Decimal`): Percentage of
// distinct users in the aggregation period that experienced at least
// one crash while they were actively using your app (a user-perceived
// crash). An app is considered to be in active use if it is displaying
// any activity or executing any foreground service. *
// `userPerceivedCrashRate7dUserWeighted` (`google.type.Decimal`):
// Rolling average value of `userPerceivedCrashRate` in the last 7 days.
// The daily values are weighted by the count of distinct users for the
// day. * `userPerceivedCrashRate28dUserWeighted`
// (`google.type.Decimal`): Rolling average value of
// `userPerceivedCrashRate` in the last 28 days. The daily values are
// weighted by the count of distinct users for the day. *
// `distinctUsers` (`google.type.Decimal`): Count of distinct users in
// the aggregation period that were used as normalization value for the
// `crashRate` and `userPerceivedCrashRate` metrics. A user is counted
// in this metric if they used the app actively during the aggregation
// period. An app is considered to be in active use if it is displaying
// any activity or executing any foreground service. Care must be taken
// not to aggregate this count further, as it may result in users being
// counted multiple times. **Supported dimensions:** * `apiLevel`
// (string): the API level of Android that was running on the user's
// device. * `versionCode` (int64): version of the app that was running
// on the user's device. * `deviceModel` (string): unique identifier of
// the user's device model. * `deviceType` (string): the type (also
// known as form factor) of the user's device. * `countryCode` (string):
// the country or region of the user's device based on their IP address,
// represented as a 2-letter ISO-3166 code (e.g. US for the United
// States). * `deviceRamBucket` (int64): RAM of the device, in MB, in
// buckets (3GB, 4GB, etc.). * `deviceSocMake` (string): Make of the
// device's primary system-on-chip, e.g., Samsung. Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
// * `deviceSocModel` (string): Model of the device's primary
// system-on-chip, e.g., "Exynos 2100". Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
// version of the device, e.g., "196610". * `deviceScreenSize` (string):
// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
// (string): Screen density of the device, e.g., mdpi, hdpi. **Required
// permissions**: to access this resource, the calling user needs the
// _View app information (read-only)_ permission for the app. **Related
// metric sets:** * vitals.errors contains unnormalized version
// (absolute counts) of crashes. * vitals.errors contains normalized
// metrics about ANRs, another stability metric.
type GooglePlayDeveloperReportingV1beta1CrashRateMetricSet struct {
	// FreshnessInfo: Summary about data freshness in this resource.
	FreshnessInfo *GooglePlayDeveloperReportingV1beta1FreshnessInfo `json:"freshnessInfo,omitempty"`

	// Name: The resource name. Format: apps/{app}/crashRateMetricSet
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FreshnessInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FreshnessInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1CrashRateMetricSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1CrashRateMetricSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1DimensionValue: Represents the
// value of a single dimension.
type GooglePlayDeveloperReportingV1beta1DimensionValue struct {
	// Dimension: Name of the dimension.
	Dimension string `json:"dimension,omitempty"`

	// Int64Value: Actual value, represented as an int64.
	Int64Value int64 `json:"int64Value,omitempty,string"`

	// StringValue: Actual value, represented as a string.
	StringValue string `json:"stringValue,omitempty"`

	// ValueLabel: Optional. Human-friendly label for the value, always in
	// English. For example, 'Spain' for the 'ES' country code. Whereas the
	// dimension value is stable, this value label is subject to change. Do
	// not assume that the (value, value_label) relationship is stable. For
	// example, the ISO country code 'MK' changed its name recently to
	// 'North Macedonia'.
	ValueLabel string `json:"valueLabel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimension") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimension") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1DimensionValue) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1DimensionValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet:
// Singleton resource representing the set of Excessive Weakeups
// metrics. This metric set contains AlarmManager wakeup counts data
// combined with process state data to produce a normalized metric
// independent of user counts. **Supported aggregation periods:** *
// DAILY: metrics are aggregated in calendar date intervals. Due to
// historical constraints, the only supported timezone is
// `America/Los_Angeles`. **Supported metrics:** * `excessiveWakeupRate`
// (`google.type.Decimal`): Percentage of distinct users in the
// aggregation period that had more than 10 wakeups per hour. *
// `excessiveWakeupRate7dUserWeighted` (`google.type.Decimal`): Rolling
// average value of `excessiveWakeupRate` in the last 7 days. The daily
// values are weighted by the count of distinct users for the day. *
// `excessiveWakeupRate28dUserWeighted` (`google.type.Decimal`): Rolling
// average value of `excessiveWakeupRate` in the last 28 days. The daily
// values are weighted by the count of distinct users for the day. *
// `distinctUsers` (`google.type.Decimal`): Count of distinct users in
// the aggregation period that were used as normalization value for the
// `excessiveWakeupRate` metric. A user is counted in this metric if
// they app was doing any work on the device, i.e., not just active
// foreground usage but also background work. Care must be taken not to
// aggregate this count further, as it may result in users being counted
// multiple times. **Supported dimensions:** * `apiLevel` (string): the
// API level of Android that was running on the user's device. *
// `versionCode` (int64): version of the app that was running on the
// user's device. * `deviceModel` (string): unique identifier of the
// user's device model. * `deviceType` (string): the type (also known as
// form factor) of the user's device. * `countryCode` (string): the
// country or region of the user's device based on their IP address,
// represented as a 2-letter ISO-3166 code (e.g. US for the United
// States). * `deviceRamBucket` (int64): RAM of the device, in MB, in
// buckets (3GB, 4GB, etc.). * `deviceSocMake` (string): Make of the
// device's primary system-on-chip, e.g., Samsung. Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
// * `deviceSocModel` (string): Model of the device's primary
// system-on-chip, e.g., "Exynos 2100". Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
// version of the device, e.g., "196610". * `deviceScreenSize` (string):
// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
// (string): Screen density of the device, e.g., mdpi, hdpi. **Required
// permissions**: to access this resource, the calling user needs the
// _View app information (read-only)_ permission for the app.
type GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet struct {
	// FreshnessInfo: Summary about data freshness in this resource.
	FreshnessInfo *GooglePlayDeveloperReportingV1beta1FreshnessInfo `json:"freshnessInfo,omitempty"`

	// Name: The resource name. Format:
	// apps/{app}/excessiveWakeupRateMetricSet
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FreshnessInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FreshnessInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1FreshnessInfo: Represents the
// latest available time that can be requested in a TimelineSpec.
// Different aggregation periods have different freshness. For example,
// `DAILY` aggregation may lag behind `HOURLY` in cases where such
// aggregation is computed only once at the end of the day.
type GooglePlayDeveloperReportingV1beta1FreshnessInfo struct {
	// Freshnesses: Information about data freshness for every supported
	// aggregation period. This field has set semantics, keyed by the
	// `aggregation_period` field.
	Freshnesses []*GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness `json:"freshnesses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Freshnesses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Freshnesses") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1FreshnessInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1FreshnessInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness:
// Information about data freshness for a single aggregation period.
type GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness struct {
	// AggregationPeriod: Aggregation period for which data is available.
	//
	// Possible values:
	//   "AGGREGATION_PERIOD_UNSPECIFIED" - Unspecified granularity.
	//   "HOURLY" - Data is aggregated in hourly intervals.
	//   "DAILY" - Data is aggregated in daily intervals.
	AggregationPeriod string `json:"aggregationPeriod,omitempty"`

	// LatestEndTime: Latest end time for which data is available, for the
	// aggregation period. The time is specified in the metric set's default
	// timezone. *Note:* time ranges in TimelineSpec are represented as
	// `start_time, end_time)`. For example, if the latest available
	// timeline data point for a `DAILY` aggregation period is `2021-06-23
	// 00:00:00 America/Los_Angeles`, the value of this field would be
	// `2021-06-24 00:00:00 America/Los_Angeles` so it can be easily reused
	// in [TimelineSpec.end_time.
	LatestEndTime *GoogleTypeDateTime `json:"latestEndTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AggregationPeriod")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AggregationPeriod") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse: Response
// with a list of anomalies in datasets.
type GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse struct {
	// Anomalies: Anomalies that were found.
	Anomalies []*GooglePlayDeveloperReportingV1beta1Anomaly `json:"anomalies,omitempty"`

	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Anomalies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Anomalies") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1MetricValue: Represents the value
// of a metric.
type GooglePlayDeveloperReportingV1beta1MetricValue struct {
	// DecimalValue: Actual value, represented as a decimal number.
	DecimalValue *GoogleTypeDecimal `json:"decimalValue,omitempty"`

	// Metric: Name of the metric.
	Metric string `json:"metric,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DecimalValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DecimalValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1MetricValue) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1MetricValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1MetricsRow: Represents a row of
// dimensions and metrics.
type GooglePlayDeveloperReportingV1beta1MetricsRow struct {
	// AggregationPeriod: Granularity of the aggregation period of the row.
	//
	// Possible values:
	//   "AGGREGATION_PERIOD_UNSPECIFIED" - Unspecified granularity.
	//   "HOURLY" - Data is aggregated in hourly intervals.
	//   "DAILY" - Data is aggregated in daily intervals.
	AggregationPeriod string `json:"aggregationPeriod,omitempty"`

	// Dimensions: Dimension columns in the row.
	Dimensions []*GooglePlayDeveloperReportingV1beta1DimensionValue `json:"dimensions,omitempty"`

	// Metrics: Metric columns in the row.
	Metrics []*GooglePlayDeveloperReportingV1beta1MetricValue `json:"metrics,omitempty"`

	// StartTime: Starting date (and time for hourly aggregation) of the
	// period covered by this row.
	StartTime *GoogleTypeDateTime `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AggregationPeriod")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AggregationPeriod") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1MetricsRow) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1MetricsRow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetRequest:
// Request message for QueryAnrRateMetricSet.
type GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetRequest struct {
	// Dimensions: Dimensions to slice the metrics by. **Supported
	// dimensions:** * `apiLevel` (string): the API level of Android that
	// was running on the user's device. * `versionCode` (int64): version of
	// the app that was running on the user's device. * `deviceModel`
	// (string): unique identifier of the user's device model. *
	// `deviceType` (string): the type (also known as form factor) of the
	// user's device. * `countryCode` (string): the country or region of the
	// user's device based on their IP address, represented as a 2-letter
	// ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
	// (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). *
	// `deviceSocMake` (string): Make of the device's primary
	// system-on-chip, e.g., Samsung. Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
	// * `deviceSocModel` (string): Model of the device's primary
	// system-on-chip, e.g., "Exynos 2100". Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
	// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
	// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
	// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
	// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
	// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
	// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
	// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
	// version of the device, e.g., "196610". * `deviceScreenSize` (string):
	// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
	// (string): Screen density of the device, e.g., mdpi, hdpi.
	Dimensions []string `json:"dimensions,omitempty"`

	// Filter: Filters to apply to data. The filtering expression follows
	// AIP-160 (https://google.aip.dev/160) standard and supports filtering
	// by equality of all breakdown dimensions.
	Filter string `json:"filter,omitempty"`

	// Metrics: Metrics to aggregate. **Supported metrics:** * `anrRate`
	// (`google.type.Decimal`): Percentage of distinct users in the
	// aggregation period that experienced at least one ANR. *
	// `anrRate7dUserWeighted` (`google.type.Decimal`): Rolling average
	// value of `anrRate` in the last 7 days. The daily values are weighted
	// by the count of distinct users for the day. *
	// `anrRate28dUserWeighted` (`google.type.Decimal`): Rolling average
	// value of `anrRate` in the last 28 days. The daily values are weighted
	// by the count of distinct users for the day. * `userPerceivedAnrRate`
	// (`google.type.Decimal`): Percentage of distinct users in the
	// aggregation period that experienced at least one user-perceived ANR.
	// User-perceived ANRs are currently those of 'Input dispatching' type.
	// * `userPerceivedAnrRate7dUserWeighted` (`google.type.Decimal`):
	// Rolling average value of `userPerceivedAnrRate` in the last 7 days.
	// The daily values are weighted by the count of distinct users for the
	// day. * `userPerceivedAnrRate28dUserWeighted` (`google.type.Decimal`):
	// Rolling average value of `userPerceivedAnrRate` in the last 28 days.
	// The daily values are weighted by the count of distinct users for the
	// day. * `distinctUsers` (`google.type.Decimal`): Count of distinct
	// users in the aggregation period that were used as normalization value
	// for the `anrRate` and `userPerceivedAnrRate` metrics. A user is
	// counted in this metric if they used the app in the foreground during
	// the aggregation period. Care must be taken not to aggregate this
	// count further, as it may result in users being counted multiple
	// times.
	Metrics []string `json:"metrics,omitempty"`

	// PageSize: Maximum size of the returned data. If unspecified, at most
	// 1000 rows will be returned. The maximum value is 100,000; values
	// above 100,000 will be coerced to 100,000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous call. Provide this
	// to retrieve the subsequent page. When paginating, all other
	// parameters provided to the request must match the call that provided
	// the page token.
	PageToken string `json:"pageToken,omitempty"`

	// TimelineSpec: Specification of the timeline aggregation parameters.
	// **Supported aggregation periods:** * DAILY: metrics are aggregated in
	// calendar date intervals. Due to historical constraints, the default
	// and only supported timezone is `America/Los_Angeles`.
	TimelineSpec *GooglePlayDeveloperReportingV1beta1TimelineSpec `json:"timelineSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse:
// Response message for QueryAnrRateMetricSet.
type GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse struct {
	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Rows: Returned rows of data.
	Rows []*GooglePlayDeveloperReportingV1beta1MetricsRow `json:"rows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetRequest:
// Request message for QueryCrashRateMetricSet.
type GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetRequest struct {
	// Dimensions: Dimensions to slice the metrics by. **Supported
	// dimensions:** * `apiLevel` (string): the API level of Android that
	// was running on the user's device. * `versionCode` (int64): version of
	// the app that was running on the user's device. * `deviceModel`
	// (string): unique identifier of the user's device model. *
	// `deviceType` (string): the type (also known as form factor) of the
	// user's device. * `countryCode` (string): the country or region of the
	// user's device based on their IP address, represented as a 2-letter
	// ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
	// (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). *
	// `deviceSocMake` (string): Make of the device's primary
	// system-on-chip, e.g., Samsung. Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
	// * `deviceSocModel` (string): Model of the device's primary
	// system-on-chip, e.g., "Exynos 2100". Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
	// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
	// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
	// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
	// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
	// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
	// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
	// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
	// version of the device, e.g., "196610". * `deviceScreenSize` (string):
	// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
	// (string): Screen density of the device, e.g., mdpi, hdpi.
	Dimensions []string `json:"dimensions,omitempty"`

	// Filter: Filters to apply to data. The filtering expression follows
	// AIP-160 (https://google.aip.dev/160) standard and supports filtering
	// by equality of all breakdown dimensions.
	Filter string `json:"filter,omitempty"`

	// Metrics: Metrics to aggregate. **Supported metrics:** * `crashRate`
	// (`google.type.Decimal`): Percentage of distinct users in the
	// aggregation period that experienced at least one crash. *
	// `crashRate7dUserWeighted` (`google.type.Decimal`): Rolling average
	// value of `crashRate` in the last 7 days. The daily values are
	// weighted by the count of distinct users for the day. *
	// `crashRate28dUserWeighted` (`google.type.Decimal`): Rolling average
	// value of `crashRate` in the last 28 days. The daily values are
	// weighted by the count of distinct users for the day. *
	// `userPerceivedCrashRate` (`google.type.Decimal`): Percentage of
	// distinct users in the aggregation period that experienced at least
	// one crash while they were actively using your app (a user-perceived
	// crash). An app is considered to be in active use if it is displaying
	// any activity or executing any foreground service. *
	// `userPerceivedCrashRate7dUserWeighted` (`google.type.Decimal`):
	// Rolling average value of `userPerceivedCrashRate` in the last 7 days.
	// The daily values are weighted by the count of distinct users for the
	// day. * `userPerceivedCrashRate28dUserWeighted`
	// (`google.type.Decimal`): Rolling average value of
	// `userPerceivedCrashRate` in the last 28 days. The daily values are
	// weighted by the count of distinct users for the day. *
	// `distinctUsers` (`google.type.Decimal`): Count of distinct users in
	// the aggregation period that were used as normalization value for the
	// `crashRate` and `userPerceivedCrashRate` metrics. A user is counted
	// in this metric if they used the app actively during the aggregation
	// period. An app is considered to be in active use if it is displaying
	// any activity or executing any foreground service. Care must be taken
	// not to aggregate this count further, as it may result in users being
	// counted multiple times.
	Metrics []string `json:"metrics,omitempty"`

	// PageSize: Maximum size of the returned data. If unspecified, at most
	// 1000 rows will be returned. The maximum value is 100,000; values
	// above 100,000 will be coerced to 100,000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous call. Provide this
	// to retrieve the subsequent page. When paginating, all other
	// parameters provided to the request must match the call that provided
	// the page token.
	PageToken string `json:"pageToken,omitempty"`

	// TimelineSpec: Specification of the timeline aggregation parameters.
	// **Supported aggregation periods:** * DAILY: metrics are aggregated in
	// calendar date intervals. Due to historical constraints, the default
	// and only supported timezone is `America/Los_Angeles`.
	TimelineSpec *GooglePlayDeveloperReportingV1beta1TimelineSpec `json:"timelineSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse:
// Response message for QueryCrashRateMetricSet.
type GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse struct {
	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Rows: Returned rows of data.
	Rows []*GooglePlayDeveloperReportingV1beta1MetricsRow `json:"rows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRe
// quest: Request message for QueryExcessiveWakeupRateMetricSet.
type GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest struct {
	// Dimensions: Dimensions to slice the data by. **Supported
	// dimensions:** * `apiLevel` (string): the API level of Android that
	// was running on the user's device. * `versionCode` (int64): version of
	// the app that was running on the user's device. * `deviceModel`
	// (string): unique identifier of the user's device model. *
	// `deviceType` (string): the type (also known as form factor) of the
	// user's device. * `countryCode` (string): the country or region of the
	// user's device based on their IP address, represented as a 2-letter
	// ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
	// (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). *
	// `deviceSocMake` (string): Make of the device's primary
	// system-on-chip, e.g., Samsung. Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
	// * `deviceSocModel` (string): Model of the device's primary
	// system-on-chip, e.g., "Exynos 2100". Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
	// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
	// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
	// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
	// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
	// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
	// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
	// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
	// version of the device, e.g., "196610". * `deviceScreenSize` (string):
	// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
	// (string): Screen density of the device, e.g., mdpi, hdpi.
	Dimensions []string `json:"dimensions,omitempty"`

	// Filter: Filters to apply to data. The filtering expression follows
	// AIP-160 (https://google.aip.dev/160) standard and supports filtering
	// by equality of all breakdown dimensions.
	Filter string `json:"filter,omitempty"`

	// Metrics: Metrics to aggregate. **Supported metrics:** *
	// `excessiveWakeupRate` (`google.type.Decimal`): Percentage of distinct
	// users in the aggregation period that had more than 10 wakeups per
	// hour. * `excessiveWakeupRate7dUserWeighted` (`google.type.Decimal`):
	// Rolling average value of `excessiveWakeupRate` in the last 7 days.
	// The daily values are weighted by the count of distinct users for the
	// day. * `excessiveWakeupRate28dUserWeighted` (`google.type.Decimal`):
	// Rolling average value of `excessiveWakeupRate` in the last 28 days.
	// The daily values are weighted by the count of distinct users for the
	// day. * `distinctUsers` (`google.type.Decimal`): Count of distinct
	// users in the aggregation period that were used as normalization value
	// for the `excessiveWakeupRate` metric. A user is counted in this
	// metric if they app was doing any work on the device, i.e., not just
	// active foreground usage but also background work. Care must be taken
	// not to aggregate this count further, as it may result in users being
	// counted multiple times.
	Metrics []string `json:"metrics,omitempty"`

	// PageSize: Maximum size of the returned data. If unspecified, at most
	// 1000 rows will be returned. The maximum value is 100000; values above
	// 100000 will be coerced to 100000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous call. Provide this
	// to retrieve the subsequent page. When paginating, all other
	// parameters provided to the request must match the call that provided
	// the page token.
	PageToken string `json:"pageToken,omitempty"`

	// TimelineSpec: Specification of the timeline aggregation parameters.
	// **Supported aggregation periods:** * DAILY: metrics are aggregated in
	// calendar date intervals. Due to historical constraints, the only
	// supported timezone is `America/Los_Angeles`.
	TimelineSpec *GooglePlayDeveloperReportingV1beta1TimelineSpec `json:"timelineSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRe
// sponse: Response message for QueryExcessiveWakeupRateMetricSet.
type GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetResponse struct {
	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Rows: Returned rows of data.
	Rows []*GooglePlayDeveloperReportingV1beta1MetricsRow `json:"rows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMet
// ricSetRequest: Request message for
// QueryStuckBackgroundWakelockRateMetricSet.
type GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetRequest struct {
	// Dimensions: Dimensions to slice the data by. **Supported
	// dimensions:** * `apiLevel` (string): the API level of Android that
	// was running on the user's device. * `versionCode` (int64): version of
	// the app that was running on the user's device. * `deviceModel`
	// (string): unique identifier of the user's device model. *
	// `deviceType` (string): the type (also known as form factor) of the
	// user's device. * `countryCode` (string): the country or region of the
	// user's device based on their IP address, represented as a 2-letter
	// ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
	// (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). *
	// `deviceSocMake` (string): Make of the device's primary
	// system-on-chip, e.g., Samsung. Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
	// * `deviceSocModel` (string): Model of the device's primary
	// system-on-chip, e.g., "Exynos 2100". Reference
	// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
	// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
	// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
	// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
	// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
	// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
	// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
	// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
	// version of the device, e.g., "196610". * `deviceScreenSize` (string):
	// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
	// (string): Screen density of the device, e.g., mdpi, hdpi.
	Dimensions []string `json:"dimensions,omitempty"`

	// Filter: Filters to apply to data. The filtering expression follows
	// AIP-160 (https://google.aip.dev/160) standard and supports filtering
	// by equality of all breakdown dimensions.
	Filter string `json:"filter,omitempty"`

	// Metrics: Metrics to aggregate. **Supported metrics:** *
	// `stuckBgWakelockRate` (`google.type.Decimal`): Percentage of distinct
	// users in the aggregation period that had a wakelock held in the
	// background for longer than 1 hour. *
	// `stuckBgWakelockRate7dUserWeighted` (`google.type.Decimal`): Rolling
	// average value of `stuckBgWakelockRate` in the last 7 days. The daily
	// values are weighted by the count of distinct users for the day. *
	// `stuckBgWakelockRate28dUserWeighted` (`google.type.Decimal`): Rolling
	// average value of `stuckBgWakelockRate` in the last 28 days. The daily
	// values are weighted by the count of distinct users for the day. *
	// `distinctUsers` (`google.type.Decimal`): Count of distinct users in
	// the aggregation period that were used as normalization value for the
	// `stuckBgWakelockRate` metric. A user is counted in this metric if
	// they app was doing any work on the device, i.e., not just active
	// foreground usage but also background work. Care must be taken not to
	// aggregate this count further, as it may result in users being counted
	// multiple times.
	Metrics []string `json:"metrics,omitempty"`

	// PageSize: Maximum size of the returned data. If unspecified, at most
	// 1000 rows will be returned. The maximum value is 100000; values above
	// 100000 will be coerced to 100000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous call. Provide this
	// to retrieve the subsequent page. When paginating, all other
	// parameters provided to the request must match the call that provided
	// the page token.
	PageToken string `json:"pageToken,omitempty"`

	// TimelineSpec: Specification of the timeline aggregation parameters.
	// **Supported aggregation periods:** * DAILY: metrics are aggregated in
	// calendar date intervals. Due to historical constraints, the only
	// supported timezone is `America/Los_Angeles`.
	TimelineSpec *GooglePlayDeveloperReportingV1beta1TimelineSpec `json:"timelineSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMet
// ricSetResponse: Response message for
// QueryStuckBackgroundWakelockRateMetricSet.
type GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetResponse struct {
	// NextPageToken: Continuation token to fetch the next page of data.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Rows: Returned rows of data.
	Rows []*GooglePlayDeveloperReportingV1beta1MetricsRow `json:"rows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1StuckBackgroundWakelockRateMetricSe
// t: Singleton resource representing the set of Stuck Background
// Wakelocks metrics. This metric set contains PowerManager wakelock
// duration data combined with process state data to produce a
// normalized metric independent of user counts. **Supported aggregation
// periods:** * DAILY: metrics are aggregated in calendar date
// intervals. Due to historical constraints, the only supported timezone
// is `America/Los_Angeles`. **Supported metrics:** *
// `stuckBgWakelockRate` (`google.type.Decimal`): Percentage of distinct
// users in the aggregation period that had a wakelock held in the
// background for longer than 1 hour. *
// `stuckBgWakelockRate7dUserWeighted` (`google.type.Decimal`): Rolling
// average value of `stuckBgWakelockRate` in the last 7 days. The daily
// values are weighted by the count of distinct users for the day. *
// `stuckBgWakelockRate28dUserWeighted` (`google.type.Decimal`): Rolling
// average value of `stuckBgWakelockRate` in the last 28 days. The daily
// values are weighted by the count of distinct users for the day. *
// `distinctUsers` (`google.type.Decimal`): Count of distinct users in
// the aggregation period that were used as normalization value for the
// `stuckBgWakelockRate` metric. A user is counted in this metric if
// their app was doing any work on the device, i.e., not just active
// foreground usage but also background work. Care must be taken not to
// aggregate this count further, as it may result in users being counted
// multiple times. **Supported dimensions:** * `apiLevel` (string): the
// API level of Android that was running on the user's device. *
// `versionCode` (int64): version of the app that was running on the
// user's device. * `deviceModel` (string): unique identifier of the
// user's device model. * `deviceType` (string): the type (also known as
// form factor) of the user's device. * `countryCode` (string): the
// country or region of the user's device based on their IP address,
// represented as a 2-letter ISO-3166 code (e.g. US for the United
// States). * `deviceRamBucket` (int64): RAM of the device, in MB, in
// buckets (3GB, 4GB, etc.). * `deviceSocMake` (string): Make of the
// device's primary system-on-chip, e.g., Samsung. Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER)
// * `deviceSocModel` (string): Model of the device's primary
// system-on-chip, e.g., "Exynos 2100". Reference
// (https://developer.android.com/reference/android/os/Build#SOC_MODEL)
// * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm.
// * `deviceCpuModel` (string): Model of the device's CPU, e.g., "Kryo
// 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g.,
// ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g.,
// Mali. * `deviceGpuVersion` (string): Version of the device's GPU,
// e.g., T750. * `deviceVulkanVersion` (string): Vulkan version of the
// device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES
// version of the device, e.g., "196610". * `deviceScreenSize` (string):
// Screen size of the device, e.g., NORMAL, LARGE. * `deviceScreenDpi`
// (string): Screen density of the device, e.g., mdpi, hdpi. **Required
// permissions**: to access this resource, the calling user needs the
// _View app information (read-only)_ permission for the app.
type GooglePlayDeveloperReportingV1beta1StuckBackgroundWakelockRateMetricSet struct {
	// FreshnessInfo: Summary about data freshness in this resource.
	FreshnessInfo *GooglePlayDeveloperReportingV1beta1FreshnessInfo `json:"freshnessInfo,omitempty"`

	// Name: The resource name. Format:
	// apps/{app}/stuckBackgroundWakelockRateMetricSet
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FreshnessInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FreshnessInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1StuckBackgroundWakelockRateMetricSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1StuckBackgroundWakelockRateMetricSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GooglePlayDeveloperReportingV1beta1TimelineSpec: Specification of the
// time-related aggregation parameters of a timeline. Timelines have an
// aggregation period (`DAILY`, `HOURLY`, etc) which defines how events
// are aggregated in metrics. The points in a timeline are defined by
// the starting DateTime of the aggregation period. The duration is
// implicit in the AggregationPeriod. Hourly aggregation periods, when
// supported by a metric set, are always specified in UTC to avoid
// ambiguities around daylight saving time transitions, where an hour is
// skipped when adopting DST, and repeated when abandoning DST. For
// example, the timestamp '2021-11-07 01:00:00 America/Los_Angeles' is
// ambiguous since it can correspond to '2021-11-07 08:00:00 UTC' or
// '2021-11-07 09:00:00 UTC'. Daily aggregation periods require
// specifying a timezone which will determine the precise instants of
// the start and the end of the day. Not all metric sets support all
// timezones, so make sure to check which timezones are supported by the
// metric set you want to query.
type GooglePlayDeveloperReportingV1beta1TimelineSpec struct {
	// AggregationPeriod: Type of the aggregation period of the datapoints
	// in the timeline. Intervals are identified by the date and time at the
	// start of the interval.
	//
	// Possible values:
	//   "AGGREGATION_PERIOD_UNSPECIFIED" - Unspecified granularity.
	//   "HOURLY" - Data is aggregated in hourly intervals.
	//   "DAILY" - Data is aggregated in daily intervals.
	AggregationPeriod string `json:"aggregationPeriod,omitempty"`

	// EndTime: Ending datapoint of the timeline (exclusive). See start_time
	// for restrictions. The timezone of the end point must match the
	// timezone of the start point.
	EndTime *GoogleTypeDateTime `json:"endTime,omitempty"`

	// StartTime: Starting datapoint of the timeline (inclusive). Must be
	// aligned to the aggregation period as follows: * HOURLY: the
	// 'minutes', 'seconds' and 'nanos' fields must be unset. The time_zone
	// can be left unset (defaults to UTC) or set explicitly to "UTC".
	// Setting any other utc_offset or timezone id will result in a
	// validation error. * DAILY: the 'hours', 'minutes', 'seconds' and
	// 'nanos' fields must be unset. Different metric sets support different
	// timezones. It can be left unset to use the default timezone specified
	// by the metric set. The timezone of the end point must match the
	// timezone of the start point.
	StartTime *GoogleTypeDateTime `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AggregationPeriod")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AggregationPeriod") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GooglePlayDeveloperReportingV1beta1TimelineSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePlayDeveloperReportingV1beta1TimelineSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeDateTime: Represents civil time (or occasionally physical
// time). This type can represent a civil time in one of a few possible
// ways: * When utc_offset is set and time_zone is unset: a civil time
// on a calendar day with a particular offset from UTC. * When time_zone
// is set and utc_offset is unset: a civil time on a calendar day in a
// particular time zone. * When neither time_zone nor utc_offset is set:
// a civil time on a calendar day in local time. The date is relative to
// the Proleptic Gregorian Calendar. If year, month, or day are 0, the
// DateTime is considered not to have a specific year, month, or day
// respectively. This type may also be used to represent a physical time
// if all the date and time fields are set and either case of the
// `time_offset` oneof is set. Consider using `Timestamp` message for
// physical time instead. If your use case also would like to store the
// user's timezone, that can be done in another field. This type is more
// flexible than some applications may want. Make sure to document and
// validate your application's limitations.
type GoogleTypeDateTime struct {
	// Day: Optional. Day of month. Must be from 1 to 31 and valid for the
	// year and month, or 0 if specifying a datetime without a day.
	Day int64 `json:"day,omitempty"`

	// Hours: Optional. Hours of day in 24 hour format. Should be from 0 to
	// 23, defaults to 0 (midnight). An API may choose to allow the value
	// "24:00:00" for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`

	// Minutes: Optional. Minutes of hour of day. Must be from 0 to 59,
	// defaults to 0.
	Minutes int64 `json:"minutes,omitempty"`

	// Month: Optional. Month of year. Must be from 1 to 12, or 0 if
	// specifying a datetime without a month.
	Month int64 `json:"month,omitempty"`

	// Nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0
	// to 999,999,999, defaults to 0.
	Nanos int64 `json:"nanos,omitempty"`

	// Seconds: Optional. Seconds of minutes of the time. Must normally be
	// from 0 to 59, defaults to 0. An API may allow the value 60 if it
	// allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`

	// TimeZone: Time zone.
	TimeZone *GoogleTypeTimeZone `json:"timeZone,omitempty"`

	// UtcOffset: UTC offset. Must be whole seconds, between -18 hours and
	// +18 hours. For example, a UTC offset of -4:00 would be represented as
	// { seconds: -14400 }.
	UtcOffset string `json:"utcOffset,omitempty"`

	// Year: Optional. Year of date. Must be from 1 to 9999, or 0 if
	// specifying a datetime without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDateTime) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDateTime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeDecimal: A representation of a decimal value, such as 2.5.
// Clients may convert values into language-native decimal formats, such
// as Java's BigDecimal or Python's decimal.Decimal. [BigDecimal]:
// https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/math/BigDecimal.html
// [decimal.Decimal]: https://docs.python.org/3/library/decimal.html
type GoogleTypeDecimal struct {
	// Value: The decimal value, as a string. The string representation
	// consists of an optional sign, `+` (`U+002B`) or `-` (`U+002D`),
	// followed by a sequence of zero or more decimal digits ("the
	// integer"), optionally followed by a fraction, optionally followed by
	// an exponent. An empty string **should** be interpreted as `0`. The
	// fraction consists of a decimal point followed by zero or more decimal
	// digits. The string must contain at least one digit in either the
	// integer or the fraction. The number formed by the sign, the integer
	// and the fraction is referred to as the significand. The exponent
	// consists of the character `e` (`U+0065`) or `E` (`U+0045`) followed
	// by one or more decimal digits. Services **should** normalize decimal
	// values before storing them by: - Removing an explicitly-provided `+`
	// sign (`+2.5` -> `2.5`). - Replacing a zero-length integer value with
	// `0` (`.5` -> `0.5`). - Coercing the exponent character to upper-case,
	// with explicit sign (`2.5e8` -> `2.5E+8`). - Removing an
	// explicitly-provided zero exponent (`2.5E0` -> `2.5`). Services
	// **may** perform additional normalization based on its own needs and
	// the internal decimal implementation selected, such as shifting the
	// decimal point and exponent value together (example: `2.5E-1` <->
	// `0.25`). Additionally, services **may** preserve trailing zeroes in
	// the fraction to indicate increased precision, but are not required to
	// do so. Note that only the `.` character is supported to divide the
	// integer and the fraction; `,` **should not** be supported regardless
	// of locale. Additionally, thousand separators **should not** be
	// supported. If a service does support them, values **must** be
	// normalized. The ENBF grammar is: DecimalString = '' | [Sign]
	// Significand [Exponent]; Sign = '+' | '-'; Significand = Digits '.' |
	// [Digits] '.' Digits; Exponent = ('e' | 'E') [Sign] Digits; Digits = {
	// '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' }; Services
	// **should** clearly document the range of supported values, the
	// maximum supported precision (total number of digits), and, if
	// applicable, the scale (number of digits after the decimal point), as
	// well as how it behaves when receiving out-of-bounds values. Services
	// **may** choose to accept values passed as input even when the value
	// has a higher precision or scale than the service supports, and
	// **should** round the value to fit the supported scale. Alternatively,
	// the service **may** error with `400 Bad Request` (`INVALID_ARGUMENT`
	// in gRPC) if precision would be lost. Services **should** error with
	// `400 Bad Request` (`INVALID_ARGUMENT` in gRPC) if the service
	// receives a value outside of the supported range.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDecimal) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDecimal
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeTimeZone: Represents a time zone from the IANA Time Zone
// Database (https://www.iana.org/time-zones).
type GoogleTypeTimeZone struct {
	// Id: IANA Time Zone Database time zone, e.g. "America/New_York".
	Id string `json:"id,omitempty"`

	// Version: Optional. IANA Time Zone Database version number, e.g.
	// "2019a".
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeTimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeTimeZone
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "playdeveloperreporting.anomalies.list":

type AnomaliesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists anomalies in any of the datasets.
//
//   - parent: Parent app for which anomalies were detected. Format:
//     apps/{app}.
func (r *AnomaliesService) List(parent string) *AnomaliesListCall {
	c := &AnomaliesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering criteria for
// anomalies. For basic filter guidance, please check:
// https://google.aip.dev/160. **Supported functions:** *
// `activeBetween(startTime, endTime)`: If specified, only list
// anomalies that were active in between `startTime` (inclusive) and
// `endTime` (exclusive). Both parameters are expected to conform to an
// RFC-3339 formatted string (e.g. `2012-04-21T11:30:00-04:00`). UTC
// offsets are supported. Both `startTime` and `endTime` accept the
// special value `UNBOUNDED`, to signify intervals with no lower or
// upper bound, respectively. Examples: *
// `activeBetween("2021-04-21T11:30:00Z", "2021-07-21T00:00:00Z")` *
// `activeBetween(UNBOUNDED, "2021-11-21T00:00:00-04:00")` *
// `activeBetween("2021-07-21T00:00:00-04:00", UNBOUNDED)`
func (c *AnomaliesListCall) Filter(filter string) *AnomaliesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum size of the
// returned data. If unspecified, at most 10 anomalies will be returned.
// The maximum value is 100; values above 100 will be coerced to 100.
func (c *AnomaliesListCall) PageSize(pageSize int64) *AnomaliesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListErrorReports` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListErrorReports` must match the call that provided the
// page token.
func (c *AnomaliesListCall) PageToken(pageToken string) *AnomaliesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AnomaliesListCall) Fields(s ...googleapi.Field) *AnomaliesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AnomaliesListCall) IfNoneMatch(entityTag string) *AnomaliesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AnomaliesListCall) Context(ctx context.Context) *AnomaliesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AnomaliesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AnomaliesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/anomalies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.anomalies.list" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AnomaliesListCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists anomalies in any of the datasets.",
	//   "flatPath": "v1beta1/apps/{appsId}/anomalies",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.anomalies.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Filtering criteria for anomalies. For basic filter guidance, please check: https://google.aip.dev/160. **Supported functions:** * `activeBetween(startTime, endTime)`: If specified, only list anomalies that were active in between `startTime` (inclusive) and `endTime` (exclusive). Both parameters are expected to conform to an RFC-3339 formatted string (e.g. `2012-04-21T11:30:00-04:00`). UTC offsets are supported. Both `startTime` and `endTime` accept the special value `UNBOUNDED`, to signify intervals with no lower or upper bound, respectively. Examples: * `activeBetween(\"2021-04-21T11:30:00Z\", \"2021-07-21T00:00:00Z\")` * `activeBetween(UNBOUNDED, \"2021-11-21T00:00:00-04:00\")` * `activeBetween(\"2021-07-21T00:00:00-04:00\", UNBOUNDED)`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum size of the returned data. If unspecified, at most 10 anomalies will be returned. The maximum value is 100; values above 100 will be coerced to 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListErrorReports` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListErrorReports` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Parent app for which anomalies were detected. Format: apps/{app}",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/anomalies",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AnomaliesListCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "playdeveloperreporting.vitals.anrrate.get":

type VitalsAnrrateGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describes the properties of the metric set.
//
// - name: The resource name. Format: apps/{app}/anrRateMetricSet.
func (r *VitalsAnrrateService) Get(name string) *VitalsAnrrateGetCall {
	c := &VitalsAnrrateGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsAnrrateGetCall) Fields(s ...googleapi.Field) *VitalsAnrrateGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *VitalsAnrrateGetCall) IfNoneMatch(entityTag string) *VitalsAnrrateGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsAnrrateGetCall) Context(ctx context.Context) *VitalsAnrrateGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsAnrrateGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsAnrrateGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.anrrate.get" call.
// Exactly one of *GooglePlayDeveloperReportingV1beta1AnrRateMetricSet
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GooglePlayDeveloperReportingV1beta1AnrRateMetricSet.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsAnrrateGetCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1beta1AnrRateMetricSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1beta1AnrRateMetricSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Describes the properties of the metric set.",
	//   "flatPath": "v1beta1/apps/{appsId}/anrRateMetricSet",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.vitals.anrrate.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/anrRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/anrRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1AnrRateMetricSet"
	//   }
	// }

}

// method id "playdeveloperreporting.vitals.anrrate.query":

type VitalsAnrrateQueryCall struct {
	s                                                               *Service
	name                                                            string
	googleplaydeveloperreportingv1beta1queryanrratemetricsetrequest *GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetRequest
	urlParams_                                                      gensupport.URLParams
	ctx_                                                            context.Context
	header_                                                         http.Header
}

// Query: Queries the metrics in the metric set.
//
// - name: The resource name. Format: apps/{app}/anrRateMetricSet.
func (r *VitalsAnrrateService) Query(name string, googleplaydeveloperreportingv1beta1queryanrratemetricsetrequest *GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetRequest) *VitalsAnrrateQueryCall {
	c := &VitalsAnrrateQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleplaydeveloperreportingv1beta1queryanrratemetricsetrequest = googleplaydeveloperreportingv1beta1queryanrratemetricsetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsAnrrateQueryCall) Fields(s ...googleapi.Field) *VitalsAnrrateQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsAnrrateQueryCall) Context(ctx context.Context) *VitalsAnrrateQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsAnrrateQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsAnrrateQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleplaydeveloperreportingv1beta1queryanrratemetricsetrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.anrrate.query" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse.Serv
// erResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsAnrrateQueryCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the metrics in the metric set.",
	//   "flatPath": "v1beta1/apps/{appsId}/anrRateMetricSet:query",
	//   "httpMethod": "POST",
	//   "id": "playdeveloperreporting.vitals.anrrate.query",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/anrRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/anrRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:query",
	//   "request": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetRequest"
	//   },
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *VitalsAnrrateQueryCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleplaydeveloperreportingv1beta1queryanrratemetricsetrequest.PageToken = pt }(c.googleplaydeveloperreportingv1beta1queryanrratemetricsetrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleplaydeveloperreportingv1beta1queryanrratemetricsetrequest.PageToken = x.NextPageToken
	}
}

// method id "playdeveloperreporting.vitals.crashrate.get":

type VitalsCrashrateGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describes the properties of the metric set.
//
// - name: The resource name. Format: apps/{app}/crashRateMetricSet.
func (r *VitalsCrashrateService) Get(name string) *VitalsCrashrateGetCall {
	c := &VitalsCrashrateGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsCrashrateGetCall) Fields(s ...googleapi.Field) *VitalsCrashrateGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *VitalsCrashrateGetCall) IfNoneMatch(entityTag string) *VitalsCrashrateGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsCrashrateGetCall) Context(ctx context.Context) *VitalsCrashrateGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsCrashrateGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsCrashrateGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.crashrate.get" call.
// Exactly one of *GooglePlayDeveloperReportingV1beta1CrashRateMetricSet
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GooglePlayDeveloperReportingV1beta1CrashRateMetricSet.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsCrashrateGetCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1beta1CrashRateMetricSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1beta1CrashRateMetricSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Describes the properties of the metric set.",
	//   "flatPath": "v1beta1/apps/{appsId}/crashRateMetricSet",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.vitals.crashrate.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/crashRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/crashRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1CrashRateMetricSet"
	//   }
	// }

}

// method id "playdeveloperreporting.vitals.crashrate.query":

type VitalsCrashrateQueryCall struct {
	s                                                                 *Service
	name                                                              string
	googleplaydeveloperreportingv1beta1querycrashratemetricsetrequest *GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// Query: Queries the metrics in the metric set.
//
// - name: The resource name. Format: apps/{app}/crashRateMetricSet.
func (r *VitalsCrashrateService) Query(name string, googleplaydeveloperreportingv1beta1querycrashratemetricsetrequest *GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetRequest) *VitalsCrashrateQueryCall {
	c := &VitalsCrashrateQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleplaydeveloperreportingv1beta1querycrashratemetricsetrequest = googleplaydeveloperreportingv1beta1querycrashratemetricsetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsCrashrateQueryCall) Fields(s ...googleapi.Field) *VitalsCrashrateQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsCrashrateQueryCall) Context(ctx context.Context) *VitalsCrashrateQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsCrashrateQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsCrashrateQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleplaydeveloperreportingv1beta1querycrashratemetricsetrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.crashrate.query" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse.Se
// rverResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsCrashrateQueryCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the metrics in the metric set.",
	//   "flatPath": "v1beta1/apps/{appsId}/crashRateMetricSet:query",
	//   "httpMethod": "POST",
	//   "id": "playdeveloperreporting.vitals.crashrate.query",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/crashRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/crashRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:query",
	//   "request": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetRequest"
	//   },
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *VitalsCrashrateQueryCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleplaydeveloperreportingv1beta1querycrashratemetricsetrequest.PageToken = pt }(c.googleplaydeveloperreportingv1beta1querycrashratemetricsetrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleplaydeveloperreportingv1beta1querycrashratemetricsetrequest.PageToken = x.NextPageToken
	}
}

// method id "playdeveloperreporting.vitals.excessivewakeuprate.get":

type VitalsExcessivewakeuprateGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describes the properties of the metric set.
//
//   - name: The resource name. Format:
//     apps/{app}/excessiveWakeupRateMetricSet.
func (r *VitalsExcessivewakeuprateService) Get(name string) *VitalsExcessivewakeuprateGetCall {
	c := &VitalsExcessivewakeuprateGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsExcessivewakeuprateGetCall) Fields(s ...googleapi.Field) *VitalsExcessivewakeuprateGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *VitalsExcessivewakeuprateGetCall) IfNoneMatch(entityTag string) *VitalsExcessivewakeuprateGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsExcessivewakeuprateGetCall) Context(ctx context.Context) *VitalsExcessivewakeuprateGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsExcessivewakeuprateGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsExcessivewakeuprateGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.excessivewakeuprate.get" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet.Serve
// rResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsExcessivewakeuprateGetCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Describes the properties of the metric set.",
	//   "flatPath": "v1beta1/apps/{appsId}/excessiveWakeupRateMetricSet",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.vitals.excessivewakeuprate.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/excessiveWakeupRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet"
	//   }
	// }

}

// method id "playdeveloperreporting.vitals.excessivewakeuprate.query":

type VitalsExcessivewakeuprateQueryCall struct {
	s                                                                           *Service
	name                                                                        string
	googleplaydeveloperreportingv1beta1queryexcessivewakeupratemetricsetrequest *GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest
	urlParams_                                                                  gensupport.URLParams
	ctx_                                                                        context.Context
	header_                                                                     http.Header
}

// Query: Queries the metrics in the metric set.
//
//   - name: The resource name. Format:
//     apps/{app}/excessiveWakeupRateMetricSet.
func (r *VitalsExcessivewakeuprateService) Query(name string, googleplaydeveloperreportingv1beta1queryexcessivewakeupratemetricsetrequest *GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest) *VitalsExcessivewakeuprateQueryCall {
	c := &VitalsExcessivewakeuprateQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleplaydeveloperreportingv1beta1queryexcessivewakeupratemetricsetrequest = googleplaydeveloperreportingv1beta1queryexcessivewakeupratemetricsetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsExcessivewakeuprateQueryCall) Fields(s ...googleapi.Field) *VitalsExcessivewakeuprateQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsExcessivewakeuprateQueryCall) Context(ctx context.Context) *VitalsExcessivewakeuprateQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsExcessivewakeuprateQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsExcessivewakeuprateQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleplaydeveloperreportingv1beta1queryexcessivewakeupratemetricsetrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.excessivewakeuprate.query" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetR
// esponse or error will be non-nil. Any non-2xx status code is an
// error. Response headers are in either
// *GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetR
// esponse.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *VitalsExcessivewakeuprateQueryCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the metrics in the metric set.",
	//   "flatPath": "v1beta1/apps/{appsId}/excessiveWakeupRateMetricSet:query",
	//   "httpMethod": "POST",
	//   "id": "playdeveloperreporting.vitals.excessivewakeuprate.query",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/excessiveWakeupRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:query",
	//   "request": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest"
	//   },
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *VitalsExcessivewakeuprateQueryCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) {
		c.googleplaydeveloperreportingv1beta1queryexcessivewakeupratemetricsetrequest.PageToken = pt
	}(c.googleplaydeveloperreportingv1beta1queryexcessivewakeupratemetricsetrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleplaydeveloperreportingv1beta1queryexcessivewakeupratemetricsetrequest.PageToken = x.NextPageToken
	}
}

// method id "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.get":

type VitalsStuckbackgroundwakelockrateGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Describes the properties of the metric set.
//
//   - name: The resource name. Format:
//     apps/{app}/stuckBackgroundWakelockRateMetricSet.
func (r *VitalsStuckbackgroundwakelockrateService) Get(name string) *VitalsStuckbackgroundwakelockrateGetCall {
	c := &VitalsStuckbackgroundwakelockrateGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsStuckbackgroundwakelockrateGetCall) Fields(s ...googleapi.Field) *VitalsStuckbackgroundwakelockrateGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *VitalsStuckbackgroundwakelockrateGetCall) IfNoneMatch(entityTag string) *VitalsStuckbackgroundwakelockrateGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsStuckbackgroundwakelockrateGetCall) Context(ctx context.Context) *VitalsStuckbackgroundwakelockrateGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsStuckbackgroundwakelockrateGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsStuckbackgroundwakelockrateGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.get" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1beta1StuckBackgroundWakelockRateMetricS
// et or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GooglePlayDeveloperReportingV1beta1StuckBackgroundWakelockRateMetricS
// et.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *VitalsStuckbackgroundwakelockrateGetCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1beta1StuckBackgroundWakelockRateMetricSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1beta1StuckBackgroundWakelockRateMetricSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Describes the properties of the metric set.",
	//   "flatPath": "v1beta1/apps/{appsId}/stuckBackgroundWakelockRateMetricSet",
	//   "httpMethod": "GET",
	//   "id": "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/stuckBackgroundWakelockRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1StuckBackgroundWakelockRateMetricSet"
	//   }
	// }

}

// method id "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.query":

type VitalsStuckbackgroundwakelockrateQueryCall struct {
	s                                                                                   *Service
	name                                                                                string
	googleplaydeveloperreportingv1beta1querystuckbackgroundwakelockratemetricsetrequest *GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetRequest
	urlParams_                                                                          gensupport.URLParams
	ctx_                                                                                context.Context
	header_                                                                             http.Header
}

// Query: Queries the metrics in the metric set.
//
//   - name: The resource name. Format:
//     apps/{app}/stuckBackgroundWakelockRateMetricSet.
func (r *VitalsStuckbackgroundwakelockrateService) Query(name string, googleplaydeveloperreportingv1beta1querystuckbackgroundwakelockratemetricsetrequest *GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetRequest) *VitalsStuckbackgroundwakelockrateQueryCall {
	c := &VitalsStuckbackgroundwakelockrateQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleplaydeveloperreportingv1beta1querystuckbackgroundwakelockratemetricsetrequest = googleplaydeveloperreportingv1beta1querystuckbackgroundwakelockratemetricsetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *VitalsStuckbackgroundwakelockrateQueryCall) Fields(s ...googleapi.Field) *VitalsStuckbackgroundwakelockrateQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *VitalsStuckbackgroundwakelockrateQueryCall) Context(ctx context.Context) *VitalsStuckbackgroundwakelockrateQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *VitalsStuckbackgroundwakelockrateQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VitalsStuckbackgroundwakelockrateQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleplaydeveloperreportingv1beta1querystuckbackgroundwakelockratemetricsetrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.query" call.
// Exactly one of
// *GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMe
// tricSetResponse or error will be non-nil. Any non-2xx status code is
// an error. Response headers are in either
// *GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMe
// tricSetResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *VitalsStuckbackgroundwakelockrateQueryCall) Do(opts ...googleapi.CallOption) (*GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the metrics in the metric set.",
	//   "flatPath": "v1beta1/apps/{appsId}/stuckBackgroundWakelockRateMetricSet:query",
	//   "httpMethod": "POST",
	//   "id": "playdeveloperreporting.vitals.stuckbackgroundwakelockrate.query",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet",
	//       "location": "path",
	//       "pattern": "^apps/[^/]+/stuckBackgroundWakelockRateMetricSet$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:query",
	//   "request": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetRequest"
	//   },
	//   "response": {
	//     "$ref": "GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *VitalsStuckbackgroundwakelockrateQueryCall) Pages(ctx context.Context, f func(*GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) {
		c.googleplaydeveloperreportingv1beta1querystuckbackgroundwakelockratemetricsetrequest.PageToken = pt
	}(c.googleplaydeveloperreportingv1beta1querystuckbackgroundwakelockratemetricsetrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleplaydeveloperreportingv1beta1querystuckbackgroundwakelockratemetricsetrequest.PageToken = x.NextPageToken
	}
}
