// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/v2/tool_call.proto

package dialogflowpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Tool call states.
type ToolCall_State int32

const (
	// Default value.
	ToolCall_STATE_UNSPECIFIED ToolCall_State = 0
	// The tool call has been triggered.
	ToolCall_TRIGGERED ToolCall_State = 1
	// The tool call requires confirmation from a human.
	ToolCall_NEEDS_CONFIRMATION ToolCall_State = 2
)

// Enum value maps for ToolCall_State.
var (
	ToolCall_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "TRIGGERED",
		2: "NEEDS_CONFIRMATION",
	}
	ToolCall_State_value = map[string]int32{
		"STATE_UNSPECIFIED":  0,
		"TRIGGERED":          1,
		"NEEDS_CONFIRMATION": 2,
	}
)

func (x ToolCall_State) Enum() *ToolCall_State {
	p := new(ToolCall_State)
	*p = x
	return p
}

func (x ToolCall_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ToolCall_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_tool_call_proto_enumTypes[0].Descriptor()
}

func (ToolCall_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_tool_call_proto_enumTypes[0]
}

func (x ToolCall_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ToolCall_State.Descriptor instead.
func (ToolCall_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_tool_call_proto_rawDescGZIP(), []int{0, 0}
}

// Represents a call of a specific tool's action with the specified inputs.
type ToolCall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the source of this tool call.
	//
	// Types that are assignable to Source:
	//
	//	*ToolCall_Tool
	Source isToolCall_Source `protobuf_oneof:"source"`
	// Optional. A human readable short name of the tool, to be shown on the UI.
	ToolDisplayName string `protobuf:"bytes,9,opt,name=tool_display_name,json=toolDisplayName,proto3" json:"tool_display_name,omitempty"`
	// Optional. A human readable description of the tool.
	ToolDisplayDetails string `protobuf:"bytes,10,opt,name=tool_display_details,json=toolDisplayDetails,proto3" json:"tool_display_details,omitempty"`
	// Optional. The name of the tool's action associated with this call.
	Action string `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
	// Optional. The action's input parameters.
	InputParameters *structpb.Struct `protobuf:"bytes,3,opt,name=input_parameters,json=inputParameters,proto3" json:"input_parameters,omitempty"`
	// Output only. Create time of the tool call.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. The answer record associated with this tool call.
	AnswerRecord string `protobuf:"bytes,6,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
	// Output only. State of the tool call.
	State ToolCall_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.dialogflow.v2.ToolCall_State" json:"state,omitempty"`
}

func (x *ToolCall) Reset() {
	*x = ToolCall{}
	mi := &file_google_cloud_dialogflow_v2_tool_call_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolCall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolCall) ProtoMessage() {}

func (x *ToolCall) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_tool_call_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolCall.ProtoReflect.Descriptor instead.
func (*ToolCall) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_tool_call_proto_rawDescGZIP(), []int{0}
}

func (m *ToolCall) GetSource() isToolCall_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ToolCall) GetTool() string {
	if x, ok := x.GetSource().(*ToolCall_Tool); ok {
		return x.Tool
	}
	return ""
}

func (x *ToolCall) GetToolDisplayName() string {
	if x != nil {
		return x.ToolDisplayName
	}
	return ""
}

func (x *ToolCall) GetToolDisplayDetails() string {
	if x != nil {
		return x.ToolDisplayDetails
	}
	return ""
}

func (x *ToolCall) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *ToolCall) GetInputParameters() *structpb.Struct {
	if x != nil {
		return x.InputParameters
	}
	return nil
}

func (x *ToolCall) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ToolCall) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

func (x *ToolCall) GetState() ToolCall_State {
	if x != nil {
		return x.State
	}
	return ToolCall_STATE_UNSPECIFIED
}

type isToolCall_Source interface {
	isToolCall_Source()
}

type ToolCall_Tool struct {
	// Optional. The [tool][google.cloud.dialogflow.v2.Tool] associated with
	// this call. Format:
	// `projects/<ProjectID>/locations/<LocationID>/tools/<ToolID>`.
	Tool string `protobuf:"bytes,1,opt,name=tool,proto3,oneof"`
}

func (*ToolCall_Tool) isToolCall_Source() {}

// The result of calling a tool's action.
type ToolCallResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the source of this tool call.
	//
	// Types that are assignable to Source:
	//
	//	*ToolCallResult_Tool
	Source isToolCallResult_Source `protobuf_oneof:"source"`
	// Optional. The name of the tool's action associated with this call.
	Action string `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
	// The tool call's result.
	//
	// Types that are assignable to Result:
	//
	//	*ToolCallResult_Error_
	//	*ToolCallResult_RawContent
	//	*ToolCallResult_Content
	Result isToolCallResult_Result `protobuf_oneof:"result"`
	// Output only. Create time of the tool call result.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. The answer record associated with this tool call result.
	AnswerRecord string `protobuf:"bytes,9,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *ToolCallResult) Reset() {
	*x = ToolCallResult{}
	mi := &file_google_cloud_dialogflow_v2_tool_call_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolCallResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolCallResult) ProtoMessage() {}

func (x *ToolCallResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_tool_call_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolCallResult.ProtoReflect.Descriptor instead.
func (*ToolCallResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_tool_call_proto_rawDescGZIP(), []int{1}
}

func (m *ToolCallResult) GetSource() isToolCallResult_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ToolCallResult) GetTool() string {
	if x, ok := x.GetSource().(*ToolCallResult_Tool); ok {
		return x.Tool
	}
	return ""
}

func (x *ToolCallResult) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (m *ToolCallResult) GetResult() isToolCallResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *ToolCallResult) GetError() *ToolCallResult_Error {
	if x, ok := x.GetResult().(*ToolCallResult_Error_); ok {
		return x.Error
	}
	return nil
}

func (x *ToolCallResult) GetRawContent() []byte {
	if x, ok := x.GetResult().(*ToolCallResult_RawContent); ok {
		return x.RawContent
	}
	return nil
}

func (x *ToolCallResult) GetContent() string {
	if x, ok := x.GetResult().(*ToolCallResult_Content); ok {
		return x.Content
	}
	return ""
}

func (x *ToolCallResult) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ToolCallResult) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

type isToolCallResult_Source interface {
	isToolCallResult_Source()
}

type ToolCallResult_Tool struct {
	// Optional. The [tool][google.cloud.dialogflow.v2.Tool] associated with
	// this call. Format:
	// `projects/<ProjectID>/locations/<LocationID>/tools/<ToolID>`.
	Tool string `protobuf:"bytes,1,opt,name=tool,proto3,oneof"`
}

func (*ToolCallResult_Tool) isToolCallResult_Source() {}

type isToolCallResult_Result interface {
	isToolCallResult_Result()
}

type ToolCallResult_Error_ struct {
	// The tool call's error.
	Error *ToolCallResult_Error `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

type ToolCallResult_RawContent struct {
	// Only populated if the response content is not utf-8 encoded.
	// (by definition byte fields are base64 encoded).
	RawContent []byte `protobuf:"bytes,5,opt,name=raw_content,json=rawContent,proto3,oneof"`
}

type ToolCallResult_Content struct {
	// Only populated if the response content is utf-8 encoded.
	Content string `protobuf:"bytes,6,opt,name=content,proto3,oneof"`
}

func (*ToolCallResult_Error_) isToolCallResult_Result() {}

func (*ToolCallResult_RawContent) isToolCallResult_Result() {}

func (*ToolCallResult_Content) isToolCallResult_Result() {}

// An error produced by the tool call.
type ToolCallResult_Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The error message of the function.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *ToolCallResult_Error) Reset() {
	*x = ToolCallResult_Error{}
	mi := &file_google_cloud_dialogflow_v2_tool_call_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolCallResult_Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolCallResult_Error) ProtoMessage() {}

func (x *ToolCallResult_Error) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_tool_call_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolCallResult_Error.ProtoReflect.Descriptor instead.
func (*ToolCallResult_Error) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_tool_call_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ToolCallResult_Error) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_google_cloud_dialogflow_v2_tool_call_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2_tool_call_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x74, 0x6f, 0x6f,
	0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x9a, 0x04, 0x0a, 0x08, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c,
	0x12, 0x3c, 0x0a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x01, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x2f,
	0x0a, 0x11, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x74, 0x6f, 0x6f, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x35, 0x0a, 0x14, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x12, 0x74, 0x6f, 0x6f, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x28,
	0x0a, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22,
	0x45, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x45, 0x44, 0x10, 0x01, 0x12, 0x16,
	0x0a, 0x12, 0x4e, 0x45, 0x45, 0x44, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x22, 0x9c, 0x03, 0x0a, 0x0e, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x04, 0x74, 0x6f, 0x6f,
	0x6c, 0x12, 0x1b, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43,
	0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48,
	0x01, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x21, 0x0a, 0x0b, 0x72, 0x61, 0x77, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x01, 0x52,
	0x0a, 0x72, 0x61, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x07,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x1a, 0x26, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x1d, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42,
	0x93, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x42, 0x0d, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2_tool_call_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2_tool_call_proto_rawDescData = file_google_cloud_dialogflow_v2_tool_call_proto_rawDesc
)

func file_google_cloud_dialogflow_v2_tool_call_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2_tool_call_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2_tool_call_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2_tool_call_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2_tool_call_proto_rawDescData
}

var file_google_cloud_dialogflow_v2_tool_call_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_dialogflow_v2_tool_call_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_dialogflow_v2_tool_call_proto_goTypes = []any{
	(ToolCall_State)(0),           // 0: google.cloud.dialogflow.v2.ToolCall.State
	(*ToolCall)(nil),              // 1: google.cloud.dialogflow.v2.ToolCall
	(*ToolCallResult)(nil),        // 2: google.cloud.dialogflow.v2.ToolCallResult
	(*ToolCallResult_Error)(nil),  // 3: google.cloud.dialogflow.v2.ToolCallResult.Error
	(*structpb.Struct)(nil),       // 4: google.protobuf.Struct
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
}
var file_google_cloud_dialogflow_v2_tool_call_proto_depIdxs = []int32{
	4, // 0: google.cloud.dialogflow.v2.ToolCall.input_parameters:type_name -> google.protobuf.Struct
	5, // 1: google.cloud.dialogflow.v2.ToolCall.create_time:type_name -> google.protobuf.Timestamp
	0, // 2: google.cloud.dialogflow.v2.ToolCall.state:type_name -> google.cloud.dialogflow.v2.ToolCall.State
	3, // 3: google.cloud.dialogflow.v2.ToolCallResult.error:type_name -> google.cloud.dialogflow.v2.ToolCallResult.Error
	5, // 4: google.cloud.dialogflow.v2.ToolCallResult.create_time:type_name -> google.protobuf.Timestamp
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2_tool_call_proto_init() }
func file_google_cloud_dialogflow_v2_tool_call_proto_init() {
	if File_google_cloud_dialogflow_v2_tool_call_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2_tool_call_proto_msgTypes[0].OneofWrappers = []any{
		(*ToolCall_Tool)(nil),
	}
	file_google_cloud_dialogflow_v2_tool_call_proto_msgTypes[1].OneofWrappers = []any{
		(*ToolCallResult_Tool)(nil),
		(*ToolCallResult_Error_)(nil),
		(*ToolCallResult_RawContent)(nil),
		(*ToolCallResult_Content)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2_tool_call_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dialogflow_v2_tool_call_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2_tool_call_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2_tool_call_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2_tool_call_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2_tool_call_proto = out.File
	file_google_cloud_dialogflow_v2_tool_call_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2_tool_call_proto_goTypes = nil
	file_google_cloud_dialogflow_v2_tool_call_proto_depIdxs = nil
}
