// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/cx/v3/data_store_connection.proto

package cxpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of a data store.
// Determines how search is performed in the data store.
type DataStoreType int32

const (
	// Not specified. This value indicates that the data store type is not
	// specified, so it will not be used during search.
	DataStoreType_DATA_STORE_TYPE_UNSPECIFIED DataStoreType = 0
	// A data store that contains public web content.
	DataStoreType_PUBLIC_WEB DataStoreType = 1
	// A data store that contains unstructured private data.
	DataStoreType_UNSTRUCTURED DataStoreType = 2
	// A data store that contains structured data (for example FAQ).
	DataStoreType_STRUCTURED DataStoreType = 3
)

// Enum value maps for DataStoreType.
var (
	DataStoreType_name = map[int32]string{
		0: "DATA_STORE_TYPE_UNSPECIFIED",
		1: "PUBLIC_WEB",
		2: "UNSTRUCTURED",
		3: "STRUCTURED",
	}
	DataStoreType_value = map[string]int32{
		"DATA_STORE_TYPE_UNSPECIFIED": 0,
		"PUBLIC_WEB":                  1,
		"UNSTRUCTURED":                2,
		"STRUCTURED":                  3,
	}
)

func (x DataStoreType) Enum() *DataStoreType {
	p := new(DataStoreType)
	*p = x
	return p
}

func (x DataStoreType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataStoreType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[0].Descriptor()
}

func (DataStoreType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[0]
}

func (x DataStoreType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataStoreType.Descriptor instead.
func (DataStoreType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{0}
}

// The document processing mode of the data store.
type DocumentProcessingMode int32

const (
	// Not specified. This should be set for STRUCTURED type data stores. Due to
	// legacy reasons this is considered as DOCUMENTS for STRUCTURED and
	// PUBLIC_WEB data stores.
	DocumentProcessingMode_DOCUMENT_PROCESSING_MODE_UNSPECIFIED DocumentProcessingMode = 0
	// Documents are processed as documents.
	DocumentProcessingMode_DOCUMENTS DocumentProcessingMode = 1
	// Documents are converted to chunks.
	DocumentProcessingMode_CHUNKS DocumentProcessingMode = 2
)

// Enum value maps for DocumentProcessingMode.
var (
	DocumentProcessingMode_name = map[int32]string{
		0: "DOCUMENT_PROCESSING_MODE_UNSPECIFIED",
		1: "DOCUMENTS",
		2: "CHUNKS",
	}
	DocumentProcessingMode_value = map[string]int32{
		"DOCUMENT_PROCESSING_MODE_UNSPECIFIED": 0,
		"DOCUMENTS":                            1,
		"CHUNKS":                               2,
	}
)

func (x DocumentProcessingMode) Enum() *DocumentProcessingMode {
	p := new(DocumentProcessingMode)
	*p = x
	return p
}

func (x DocumentProcessingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DocumentProcessingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[1].Descriptor()
}

func (DocumentProcessingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[1]
}

func (x DocumentProcessingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DocumentProcessingMode.Descriptor instead.
func (DocumentProcessingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1}
}

// Represents the decision of the grounding check.
type DataStoreConnectionSignals_GroundingSignals_GroundingDecision int32

const (
	// Decision not specified.
	DataStoreConnectionSignals_GroundingSignals_GROUNDING_DECISION_UNSPECIFIED DataStoreConnectionSignals_GroundingSignals_GroundingDecision = 0
	// Grounding have accepted the answer.
	DataStoreConnectionSignals_GroundingSignals_ACCEPTED_BY_GROUNDING DataStoreConnectionSignals_GroundingSignals_GroundingDecision = 1
	// Grounding have rejected the answer.
	DataStoreConnectionSignals_GroundingSignals_REJECTED_BY_GROUNDING DataStoreConnectionSignals_GroundingSignals_GroundingDecision = 2
)

// Enum value maps for DataStoreConnectionSignals_GroundingSignals_GroundingDecision.
var (
	DataStoreConnectionSignals_GroundingSignals_GroundingDecision_name = map[int32]string{
		0: "GROUNDING_DECISION_UNSPECIFIED",
		1: "ACCEPTED_BY_GROUNDING",
		2: "REJECTED_BY_GROUNDING",
	}
	DataStoreConnectionSignals_GroundingSignals_GroundingDecision_value = map[string]int32{
		"GROUNDING_DECISION_UNSPECIFIED": 0,
		"ACCEPTED_BY_GROUNDING":          1,
		"REJECTED_BY_GROUNDING":          2,
	}
)

func (x DataStoreConnectionSignals_GroundingSignals_GroundingDecision) Enum() *DataStoreConnectionSignals_GroundingSignals_GroundingDecision {
	p := new(DataStoreConnectionSignals_GroundingSignals_GroundingDecision)
	*p = x
	return p
}

func (x DataStoreConnectionSignals_GroundingSignals_GroundingDecision) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataStoreConnectionSignals_GroundingSignals_GroundingDecision) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[2].Descriptor()
}

func (DataStoreConnectionSignals_GroundingSignals_GroundingDecision) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[2]
}

func (x DataStoreConnectionSignals_GroundingSignals_GroundingDecision) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataStoreConnectionSignals_GroundingSignals_GroundingDecision.Descriptor instead.
func (DataStoreConnectionSignals_GroundingSignals_GroundingDecision) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1, 5, 0}
}

// Grounding score buckets.
type DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket int32

const (
	// Score not specified.
	DataStoreConnectionSignals_GroundingSignals_GROUNDING_SCORE_BUCKET_UNSPECIFIED DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket = 0
	// We have very low confidence that the answer is grounded.
	DataStoreConnectionSignals_GroundingSignals_VERY_LOW DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket = 1
	// We have low confidence that the answer is grounded.
	DataStoreConnectionSignals_GroundingSignals_LOW DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket = 3
	// We have medium confidence that the answer is grounded.
	DataStoreConnectionSignals_GroundingSignals_MEDIUM DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket = 4
	// We have high confidence that the answer is grounded.
	DataStoreConnectionSignals_GroundingSignals_HIGH DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket = 5
	// We have very high confidence that the answer is grounded.
	DataStoreConnectionSignals_GroundingSignals_VERY_HIGH DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket = 6
)

// Enum value maps for DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket.
var (
	DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket_name = map[int32]string{
		0: "GROUNDING_SCORE_BUCKET_UNSPECIFIED",
		1: "VERY_LOW",
		3: "LOW",
		4: "MEDIUM",
		5: "HIGH",
		6: "VERY_HIGH",
	}
	DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket_value = map[string]int32{
		"GROUNDING_SCORE_BUCKET_UNSPECIFIED": 0,
		"VERY_LOW":                           1,
		"LOW":                                3,
		"MEDIUM":                             4,
		"HIGH":                               5,
		"VERY_HIGH":                          6,
	}
)

func (x DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket) Enum() *DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket {
	p := new(DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket)
	*p = x
	return p
}

func (x DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[3].Descriptor()
}

func (DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[3]
}

func (x DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket.Descriptor instead.
func (DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1, 5, 1}
}

// Safety decision.
// All kinds of check are incorporated into this final decision, including
// banned phrases check.
type DataStoreConnectionSignals_SafetySignals_SafetyDecision int32

const (
	// Decision not specified.
	DataStoreConnectionSignals_SafetySignals_SAFETY_DECISION_UNSPECIFIED DataStoreConnectionSignals_SafetySignals_SafetyDecision = 0
	// No manual or automatic safety check fired.
	DataStoreConnectionSignals_SafetySignals_ACCEPTED_BY_SAFETY_CHECK DataStoreConnectionSignals_SafetySignals_SafetyDecision = 1
	// One ore more safety checks fired.
	DataStoreConnectionSignals_SafetySignals_REJECTED_BY_SAFETY_CHECK DataStoreConnectionSignals_SafetySignals_SafetyDecision = 2
)

// Enum value maps for DataStoreConnectionSignals_SafetySignals_SafetyDecision.
var (
	DataStoreConnectionSignals_SafetySignals_SafetyDecision_name = map[int32]string{
		0: "SAFETY_DECISION_UNSPECIFIED",
		1: "ACCEPTED_BY_SAFETY_CHECK",
		2: "REJECTED_BY_SAFETY_CHECK",
	}
	DataStoreConnectionSignals_SafetySignals_SafetyDecision_value = map[string]int32{
		"SAFETY_DECISION_UNSPECIFIED": 0,
		"ACCEPTED_BY_SAFETY_CHECK":    1,
		"REJECTED_BY_SAFETY_CHECK":    2,
	}
)

func (x DataStoreConnectionSignals_SafetySignals_SafetyDecision) Enum() *DataStoreConnectionSignals_SafetySignals_SafetyDecision {
	p := new(DataStoreConnectionSignals_SafetySignals_SafetyDecision)
	*p = x
	return p
}

func (x DataStoreConnectionSignals_SafetySignals_SafetyDecision) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataStoreConnectionSignals_SafetySignals_SafetyDecision) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[4].Descriptor()
}

func (DataStoreConnectionSignals_SafetySignals_SafetyDecision) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[4]
}

func (x DataStoreConnectionSignals_SafetySignals_SafetyDecision) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataStoreConnectionSignals_SafetySignals_SafetyDecision.Descriptor instead.
func (DataStoreConnectionSignals_SafetySignals_SafetyDecision) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1, 6, 0}
}

// Specifies banned phrase match subject.
type DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch int32

const (
	// No banned phrase check was executed.
	DataStoreConnectionSignals_SafetySignals_BANNED_PHRASE_MATCH_UNSPECIFIED DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch = 0
	// All banned phrase checks led to no match.
	DataStoreConnectionSignals_SafetySignals_BANNED_PHRASE_MATCH_NONE DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch = 1
	// A banned phrase matched the query.
	DataStoreConnectionSignals_SafetySignals_BANNED_PHRASE_MATCH_QUERY DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch = 2
	// A banned phrase matched the response.
	DataStoreConnectionSignals_SafetySignals_BANNED_PHRASE_MATCH_RESPONSE DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch = 3
)

// Enum value maps for DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch.
var (
	DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch_name = map[int32]string{
		0: "BANNED_PHRASE_MATCH_UNSPECIFIED",
		1: "BANNED_PHRASE_MATCH_NONE",
		2: "BANNED_PHRASE_MATCH_QUERY",
		3: "BANNED_PHRASE_MATCH_RESPONSE",
	}
	DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch_value = map[string]int32{
		"BANNED_PHRASE_MATCH_UNSPECIFIED": 0,
		"BANNED_PHRASE_MATCH_NONE":        1,
		"BANNED_PHRASE_MATCH_QUERY":       2,
		"BANNED_PHRASE_MATCH_RESPONSE":    3,
	}
)

func (x DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch) Enum() *DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch {
	p := new(DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch)
	*p = x
	return p
}

func (x DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[5].Descriptor()
}

func (DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes[5]
}

func (x DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch.Descriptor instead.
func (DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1, 6, 1}
}

// A data store connection. It represents a data store in Discovery Engine and
// the type of the contents it contains.
type DataStoreConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the connected data store.
	DataStoreType DataStoreType `protobuf:"varint,1,opt,name=data_store_type,json=dataStoreType,proto3,enum=google.cloud.dialogflow.cx.v3.DataStoreType" json:"data_store_type,omitempty"`
	// The full name of the referenced data store.
	// Formats:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
	// `projects/{project}/locations/{location}/dataStores/{data_store}`
	DataStore string `protobuf:"bytes,2,opt,name=data_store,json=dataStore,proto3" json:"data_store,omitempty"`
	// The document processing mode for the data store connection. Should only be
	// set for PUBLIC_WEB and UNSTRUCTURED data stores. If not set it is
	// considered as DOCUMENTS, as this is the legacy mode.
	DocumentProcessingMode DocumentProcessingMode `protobuf:"varint,4,opt,name=document_processing_mode,json=documentProcessingMode,proto3,enum=google.cloud.dialogflow.cx.v3.DocumentProcessingMode" json:"document_processing_mode,omitempty"`
}

func (x *DataStoreConnection) Reset() {
	*x = DataStoreConnection{}
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStoreConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStoreConnection) ProtoMessage() {}

func (x *DataStoreConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStoreConnection.ProtoReflect.Descriptor instead.
func (*DataStoreConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{0}
}

func (x *DataStoreConnection) GetDataStoreType() DataStoreType {
	if x != nil {
		return x.DataStoreType
	}
	return DataStoreType_DATA_STORE_TYPE_UNSPECIFIED
}

func (x *DataStoreConnection) GetDataStore() string {
	if x != nil {
		return x.DataStore
	}
	return ""
}

func (x *DataStoreConnection) GetDocumentProcessingMode() DocumentProcessingMode {
	if x != nil {
		return x.DocumentProcessingMode
	}
	return DocumentProcessingMode_DOCUMENT_PROCESSING_MODE_UNSPECIFIED
}

// Data store connection feature output signals.
// Might be only partially field if processing stop before the final answer.
// Reasons for this can be, but are not limited to: empty UCS search results,
// positive RAI check outcome, grounding failure, ...
type DataStoreConnectionSignals struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Diagnostic info related to the rewriter model call.
	RewriterModelCallSignals *DataStoreConnectionSignals_RewriterModelCallSignals `protobuf:"bytes,1,opt,name=rewriter_model_call_signals,json=rewriterModelCallSignals,proto3" json:"rewriter_model_call_signals,omitempty"`
	// Optional. Rewritten string query used for search.
	RewrittenQuery string `protobuf:"bytes,2,opt,name=rewritten_query,json=rewrittenQuery,proto3" json:"rewritten_query,omitempty"`
	// Optional. Search snippets included in the answer generation prompt.
	SearchSnippets []*DataStoreConnectionSignals_SearchSnippet `protobuf:"bytes,3,rep,name=search_snippets,json=searchSnippets,proto3" json:"search_snippets,omitempty"`
	// Optional. Diagnostic info related to the answer generation model call.
	AnswerGenerationModelCallSignals *DataStoreConnectionSignals_AnswerGenerationModelCallSignals `protobuf:"bytes,4,opt,name=answer_generation_model_call_signals,json=answerGenerationModelCallSignals,proto3" json:"answer_generation_model_call_signals,omitempty"`
	// Optional. The final compiled answer.
	Answer string `protobuf:"bytes,5,opt,name=answer,proto3" json:"answer,omitempty"`
	// Optional. Answer parts with relevant citations.
	// Concatenation of texts should add up the `answer` (not counting
	// whitespaces).
	AnswerParts []*DataStoreConnectionSignals_AnswerPart `protobuf:"bytes,6,rep,name=answer_parts,json=answerParts,proto3" json:"answer_parts,omitempty"`
	// Optional. Snippets cited by the answer generation model from the most to
	// least relevant.
	CitedSnippets []*DataStoreConnectionSignals_CitedSnippet `protobuf:"bytes,7,rep,name=cited_snippets,json=citedSnippets,proto3" json:"cited_snippets,omitempty"`
	// Optional. Grounding signals.
	GroundingSignals *DataStoreConnectionSignals_GroundingSignals `protobuf:"bytes,8,opt,name=grounding_signals,json=groundingSignals,proto3" json:"grounding_signals,omitempty"`
	// Optional. Safety check result.
	SafetySignals *DataStoreConnectionSignals_SafetySignals `protobuf:"bytes,9,opt,name=safety_signals,json=safetySignals,proto3" json:"safety_signals,omitempty"`
}

func (x *DataStoreConnectionSignals) Reset() {
	*x = DataStoreConnectionSignals{}
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStoreConnectionSignals) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStoreConnectionSignals) ProtoMessage() {}

func (x *DataStoreConnectionSignals) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStoreConnectionSignals.ProtoReflect.Descriptor instead.
func (*DataStoreConnectionSignals) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1}
}

func (x *DataStoreConnectionSignals) GetRewriterModelCallSignals() *DataStoreConnectionSignals_RewriterModelCallSignals {
	if x != nil {
		return x.RewriterModelCallSignals
	}
	return nil
}

func (x *DataStoreConnectionSignals) GetRewrittenQuery() string {
	if x != nil {
		return x.RewrittenQuery
	}
	return ""
}

func (x *DataStoreConnectionSignals) GetSearchSnippets() []*DataStoreConnectionSignals_SearchSnippet {
	if x != nil {
		return x.SearchSnippets
	}
	return nil
}

func (x *DataStoreConnectionSignals) GetAnswerGenerationModelCallSignals() *DataStoreConnectionSignals_AnswerGenerationModelCallSignals {
	if x != nil {
		return x.AnswerGenerationModelCallSignals
	}
	return nil
}

func (x *DataStoreConnectionSignals) GetAnswer() string {
	if x != nil {
		return x.Answer
	}
	return ""
}

func (x *DataStoreConnectionSignals) GetAnswerParts() []*DataStoreConnectionSignals_AnswerPart {
	if x != nil {
		return x.AnswerParts
	}
	return nil
}

func (x *DataStoreConnectionSignals) GetCitedSnippets() []*DataStoreConnectionSignals_CitedSnippet {
	if x != nil {
		return x.CitedSnippets
	}
	return nil
}

func (x *DataStoreConnectionSignals) GetGroundingSignals() *DataStoreConnectionSignals_GroundingSignals {
	if x != nil {
		return x.GroundingSignals
	}
	return nil
}

func (x *DataStoreConnectionSignals) GetSafetySignals() *DataStoreConnectionSignals_SafetySignals {
	if x != nil {
		return x.SafetySignals
	}
	return nil
}

// Diagnostic info related to the rewriter model call.
type DataStoreConnectionSignals_RewriterModelCallSignals struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Prompt as sent to the model.
	RenderedPrompt string `protobuf:"bytes,1,opt,name=rendered_prompt,json=renderedPrompt,proto3" json:"rendered_prompt,omitempty"`
	// Output of the generative model.
	ModelOutput string `protobuf:"bytes,2,opt,name=model_output,json=modelOutput,proto3" json:"model_output,omitempty"`
	// Name of the generative model. For example, "gemini-ultra", "gemini-pro",
	// "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *DataStoreConnectionSignals_RewriterModelCallSignals) Reset() {
	*x = DataStoreConnectionSignals_RewriterModelCallSignals{}
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStoreConnectionSignals_RewriterModelCallSignals) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStoreConnectionSignals_RewriterModelCallSignals) ProtoMessage() {}

func (x *DataStoreConnectionSignals_RewriterModelCallSignals) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStoreConnectionSignals_RewriterModelCallSignals.ProtoReflect.Descriptor instead.
func (*DataStoreConnectionSignals_RewriterModelCallSignals) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1, 0}
}

func (x *DataStoreConnectionSignals_RewriterModelCallSignals) GetRenderedPrompt() string {
	if x != nil {
		return x.RenderedPrompt
	}
	return ""
}

func (x *DataStoreConnectionSignals_RewriterModelCallSignals) GetModelOutput() string {
	if x != nil {
		return x.ModelOutput
	}
	return ""
}

func (x *DataStoreConnectionSignals_RewriterModelCallSignals) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Search snippet details.
type DataStoreConnectionSignals_SearchSnippet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Title of the enclosing document.
	DocumentTitle string `protobuf:"bytes,1,opt,name=document_title,json=documentTitle,proto3" json:"document_title,omitempty"`
	// Uri for the document. Present if specified for the document.
	DocumentUri string `protobuf:"bytes,2,opt,name=document_uri,json=documentUri,proto3" json:"document_uri,omitempty"`
	// Text included in the prompt.
	Text string `protobuf:"bytes,3,opt,name=text,proto3" json:"text,omitempty"`
	// Metadata associated with the document.
	Metadata *structpb.Struct `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *DataStoreConnectionSignals_SearchSnippet) Reset() {
	*x = DataStoreConnectionSignals_SearchSnippet{}
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStoreConnectionSignals_SearchSnippet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStoreConnectionSignals_SearchSnippet) ProtoMessage() {}

func (x *DataStoreConnectionSignals_SearchSnippet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStoreConnectionSignals_SearchSnippet.ProtoReflect.Descriptor instead.
func (*DataStoreConnectionSignals_SearchSnippet) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1, 1}
}

func (x *DataStoreConnectionSignals_SearchSnippet) GetDocumentTitle() string {
	if x != nil {
		return x.DocumentTitle
	}
	return ""
}

func (x *DataStoreConnectionSignals_SearchSnippet) GetDocumentUri() string {
	if x != nil {
		return x.DocumentUri
	}
	return ""
}

func (x *DataStoreConnectionSignals_SearchSnippet) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *DataStoreConnectionSignals_SearchSnippet) GetMetadata() *structpb.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Diagnostic info related to the answer generation model call.
type DataStoreConnectionSignals_AnswerGenerationModelCallSignals struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Prompt as sent to the model.
	RenderedPrompt string `protobuf:"bytes,1,opt,name=rendered_prompt,json=renderedPrompt,proto3" json:"rendered_prompt,omitempty"`
	// Output of the generative model.
	ModelOutput string `protobuf:"bytes,2,opt,name=model_output,json=modelOutput,proto3" json:"model_output,omitempty"`
	// Name of the generative model. For example, "gemini-ultra", "gemini-pro",
	// "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *DataStoreConnectionSignals_AnswerGenerationModelCallSignals) Reset() {
	*x = DataStoreConnectionSignals_AnswerGenerationModelCallSignals{}
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStoreConnectionSignals_AnswerGenerationModelCallSignals) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStoreConnectionSignals_AnswerGenerationModelCallSignals) ProtoMessage() {}

func (x *DataStoreConnectionSignals_AnswerGenerationModelCallSignals) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStoreConnectionSignals_AnswerGenerationModelCallSignals.ProtoReflect.Descriptor instead.
func (*DataStoreConnectionSignals_AnswerGenerationModelCallSignals) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1, 2}
}

func (x *DataStoreConnectionSignals_AnswerGenerationModelCallSignals) GetRenderedPrompt() string {
	if x != nil {
		return x.RenderedPrompt
	}
	return ""
}

func (x *DataStoreConnectionSignals_AnswerGenerationModelCallSignals) GetModelOutput() string {
	if x != nil {
		return x.ModelOutput
	}
	return ""
}

func (x *DataStoreConnectionSignals_AnswerGenerationModelCallSignals) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Answer part with citation.
type DataStoreConnectionSignals_AnswerPart struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Substring of the answer.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Citations for this answer part. Indices of `search_snippets`.
	SupportingIndices []int32 `protobuf:"varint,2,rep,packed,name=supporting_indices,json=supportingIndices,proto3" json:"supporting_indices,omitempty"`
}

func (x *DataStoreConnectionSignals_AnswerPart) Reset() {
	*x = DataStoreConnectionSignals_AnswerPart{}
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStoreConnectionSignals_AnswerPart) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStoreConnectionSignals_AnswerPart) ProtoMessage() {}

func (x *DataStoreConnectionSignals_AnswerPart) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStoreConnectionSignals_AnswerPart.ProtoReflect.Descriptor instead.
func (*DataStoreConnectionSignals_AnswerPart) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1, 3}
}

func (x *DataStoreConnectionSignals_AnswerPart) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *DataStoreConnectionSignals_AnswerPart) GetSupportingIndices() []int32 {
	if x != nil {
		return x.SupportingIndices
	}
	return nil
}

// Snippet cited by the answer generation model.
type DataStoreConnectionSignals_CitedSnippet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details of the snippet.
	SearchSnippet *DataStoreConnectionSignals_SearchSnippet `protobuf:"bytes,1,opt,name=search_snippet,json=searchSnippet,proto3" json:"search_snippet,omitempty"`
	// Index of the snippet in `search_snippets` field.
	SnippetIndex int32 `protobuf:"varint,2,opt,name=snippet_index,json=snippetIndex,proto3" json:"snippet_index,omitempty"`
}

func (x *DataStoreConnectionSignals_CitedSnippet) Reset() {
	*x = DataStoreConnectionSignals_CitedSnippet{}
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStoreConnectionSignals_CitedSnippet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStoreConnectionSignals_CitedSnippet) ProtoMessage() {}

func (x *DataStoreConnectionSignals_CitedSnippet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStoreConnectionSignals_CitedSnippet.ProtoReflect.Descriptor instead.
func (*DataStoreConnectionSignals_CitedSnippet) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1, 4}
}

func (x *DataStoreConnectionSignals_CitedSnippet) GetSearchSnippet() *DataStoreConnectionSignals_SearchSnippet {
	if x != nil {
		return x.SearchSnippet
	}
	return nil
}

func (x *DataStoreConnectionSignals_CitedSnippet) GetSnippetIndex() int32 {
	if x != nil {
		return x.SnippetIndex
	}
	return 0
}

// Grounding signals.
type DataStoreConnectionSignals_GroundingSignals struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the decision of the grounding check.
	Decision DataStoreConnectionSignals_GroundingSignals_GroundingDecision `protobuf:"varint,1,opt,name=decision,proto3,enum=google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals_GroundingSignals_GroundingDecision" json:"decision,omitempty"`
	// Grounding score bucket setting.
	Score DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket `protobuf:"varint,2,opt,name=score,proto3,enum=google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket" json:"score,omitempty"`
}

func (x *DataStoreConnectionSignals_GroundingSignals) Reset() {
	*x = DataStoreConnectionSignals_GroundingSignals{}
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStoreConnectionSignals_GroundingSignals) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStoreConnectionSignals_GroundingSignals) ProtoMessage() {}

func (x *DataStoreConnectionSignals_GroundingSignals) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStoreConnectionSignals_GroundingSignals.ProtoReflect.Descriptor instead.
func (*DataStoreConnectionSignals_GroundingSignals) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1, 5}
}

func (x *DataStoreConnectionSignals_GroundingSignals) GetDecision() DataStoreConnectionSignals_GroundingSignals_GroundingDecision {
	if x != nil {
		return x.Decision
	}
	return DataStoreConnectionSignals_GroundingSignals_GROUNDING_DECISION_UNSPECIFIED
}

func (x *DataStoreConnectionSignals_GroundingSignals) GetScore() DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket {
	if x != nil {
		return x.Score
	}
	return DataStoreConnectionSignals_GroundingSignals_GROUNDING_SCORE_BUCKET_UNSPECIFIED
}

// Safety check results.
type DataStoreConnectionSignals_SafetySignals struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Safety decision.
	Decision DataStoreConnectionSignals_SafetySignals_SafetyDecision `protobuf:"varint,1,opt,name=decision,proto3,enum=google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals_SafetySignals_SafetyDecision" json:"decision,omitempty"`
	// Specifies banned phrase match subject.
	BannedPhraseMatch DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch `protobuf:"varint,2,opt,name=banned_phrase_match,json=bannedPhraseMatch,proto3,enum=google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch" json:"banned_phrase_match,omitempty"`
	// The matched banned phrase if there was a match.
	MatchedBannedPhrase string `protobuf:"bytes,3,opt,name=matched_banned_phrase,json=matchedBannedPhrase,proto3" json:"matched_banned_phrase,omitempty"`
}

func (x *DataStoreConnectionSignals_SafetySignals) Reset() {
	*x = DataStoreConnectionSignals_SafetySignals{}
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStoreConnectionSignals_SafetySignals) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStoreConnectionSignals_SafetySignals) ProtoMessage() {}

func (x *DataStoreConnectionSignals_SafetySignals) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStoreConnectionSignals_SafetySignals.ProtoReflect.Descriptor instead.
func (*DataStoreConnectionSignals_SafetySignals) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP(), []int{1, 6}
}

func (x *DataStoreConnectionSignals_SafetySignals) GetDecision() DataStoreConnectionSignals_SafetySignals_SafetyDecision {
	if x != nil {
		return x.Decision
	}
	return DataStoreConnectionSignals_SafetySignals_SAFETY_DECISION_UNSPECIFIED
}

func (x *DataStoreConnectionSignals_SafetySignals) GetBannedPhraseMatch() DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch {
	if x != nil {
		return x.BannedPhraseMatch
	}
	return DataStoreConnectionSignals_SafetySignals_BANNED_PHRASE_MATCH_UNSPECIFIED
}

func (x *DataStoreConnectionSignals_SafetySignals) GetMatchedBannedPhrase() string {
	if x != nil {
		return x.MatchedBannedPhrase
	}
	return ""
}

var File_google_cloud_dialogflow_cx_v3_data_store_connection_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfb, 0x01, 0x0a, 0x13, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x54, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x6f, 0x0a, 0x18, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x52,
	0x16, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0xdf, 0x15, 0x0a, 0x1a, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x12, 0x96, 0x01, 0x0a, 0x1b, 0x72, 0x65, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x72, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x12,
	0x2c, 0x0a, 0x0f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x72,
	0x65, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x75, 0x0a,
	0x0f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x6e, 0x69, 0x70,
	0x70, 0x65, 0x74, 0x73, 0x12, 0xaf, 0x01, 0x0a, 0x24, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x20, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x53,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x12, 0x6c, 0x0a, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x70, 0x61,
	0x72, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x50, 0x61, 0x72, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x50, 0x61, 0x72, 0x74,
	0x73, 0x12, 0x72, 0x0a, 0x0e, 0x63, 0x69, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70,
	0x65, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x43, 0x69, 0x74, 0x65, 0x64, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x63, 0x69, 0x74, 0x65, 0x64, 0x53, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x73, 0x12, 0x7c, 0x0a, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x6c, 0x73, 0x12, 0x73, 0x0a, 0x0e, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x1a, 0x7c, 0x0a, 0x18, 0x52, 0x65, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x65, 0x64,
	0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x12, 0x21, 0x0a,
	0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x1a, 0xa2, 0x01, 0x0a, 0x0d, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x55,
	0x72, 0x69, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x33, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x84, 0x01, 0x0a, 0x20,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73,
	0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x14, 0x0a, 0x05,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x1a, 0x4f, 0x0a, 0x0a, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x50, 0x61, 0x72, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05,
	0x52, 0x11, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x64, 0x69,
	0x63, 0x65, 0x73, 0x1a, 0xa3, 0x01, 0x0a, 0x0c, 0x43, 0x69, 0x74, 0x65, 0x64, 0x53, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x12, 0x6e, 0x0a, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73,
	0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x6e,
	0x69, 0x70, 0x70, 0x65, 0x74, 0x52, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x73, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x1a, 0xee, 0x03, 0x0a, 0x10, 0x47, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x12, 0x78,
	0x0a, 0x08, 0x64, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x64, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x75, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x6c, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22,
	0x6d, 0x0a, 0x11, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x63, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x1e, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x5f, 0x44, 0x45, 0x43, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x43, 0x43, 0x45,
	0x50, 0x54, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f,
	0x42, 0x59, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0x7a,
	0x0a, 0x14, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x26, 0x0a, 0x22, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44,
	0x49, 0x4e, 0x47, 0x5f, 0x53, 0x43, 0x4f, 0x52, 0x45, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03,
	0x4c, 0x4f, 0x57, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10,
	0x04, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x56,
	0x45, 0x52, 0x59, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x06, 0x1a, 0xcc, 0x04, 0x0a, 0x0d, 0x53,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x12, 0x72, 0x0a, 0x08,
	0x64, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x56,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x44, 0x65,
	0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x89, 0x01, 0x0a, 0x13, 0x62, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x59,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2e, 0x42, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x11, 0x62, 0x61, 0x6e, 0x6e, 0x65,
	0x64, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x32, 0x0a, 0x15,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x64, 0x42, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x22, 0x6d, 0x0a, 0x0e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x44, 0x65, 0x63, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x5f, 0x44, 0x45, 0x43,
	0x49, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x45, 0x44, 0x5f,
	0x42, 0x59, 0x5f, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x10,
	0x01, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x42, 0x59,
	0x5f, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x10, 0x02, 0x22,
	0x97, 0x01, 0x0a, 0x11, 0x42, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x23, 0x0a, 0x1f, 0x42, 0x41, 0x4e, 0x4e, 0x45, 0x44, 0x5f,
	0x50, 0x48, 0x52, 0x41, 0x53, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x42, 0x41,
	0x4e, 0x4e, 0x45, 0x44, 0x5f, 0x50, 0x48, 0x52, 0x41, 0x53, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43,
	0x48, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x42, 0x41, 0x4e, 0x4e,
	0x45, 0x44, 0x5f, 0x50, 0x48, 0x52, 0x41, 0x53, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f,
	0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x42, 0x41, 0x4e, 0x4e, 0x45,
	0x44, 0x5f, 0x50, 0x48, 0x52, 0x41, 0x53, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x52,
	0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x03, 0x2a, 0x62, 0x0a, 0x0d, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x41,
	0x54, 0x41, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50,
	0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x57, 0x45, 0x42, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x55,
	0x4e, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x55, 0x52, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0e, 0x0a,
	0x0a, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x55, 0x52, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x5d, 0x0a,
	0x16, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x28, 0x0a, 0x24, 0x44, 0x4f, 0x43, 0x55, 0x4d,
	0x45, 0x4e, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x53, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x43, 0x48, 0x55, 0x4e, 0x4b, 0x53, 0x10, 0x02, 0x42, 0xbb, 0x01, 0x0a,
	0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x42, 0x18, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x31,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63,
	0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70,
	0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescData = file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_goTypes = []any{
	(DataStoreType)(0),          // 0: google.cloud.dialogflow.cx.v3.DataStoreType
	(DocumentProcessingMode)(0), // 1: google.cloud.dialogflow.cx.v3.DocumentProcessingMode
	(DataStoreConnectionSignals_GroundingSignals_GroundingDecision)(0),    // 2: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision
	(DataStoreConnectionSignals_GroundingSignals_GroundingScoreBucket)(0), // 3: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket
	(DataStoreConnectionSignals_SafetySignals_SafetyDecision)(0),          // 4: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision
	(DataStoreConnectionSignals_SafetySignals_BannedPhraseMatch)(0),       // 5: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch
	(*DataStoreConnection)(nil),                                           // 6: google.cloud.dialogflow.cx.v3.DataStoreConnection
	(*DataStoreConnectionSignals)(nil),                                    // 7: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
	(*DataStoreConnectionSignals_RewriterModelCallSignals)(nil),           // 8: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
	(*DataStoreConnectionSignals_SearchSnippet)(nil),                      // 9: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
	(*DataStoreConnectionSignals_AnswerGenerationModelCallSignals)(nil),   // 10: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals
	(*DataStoreConnectionSignals_AnswerPart)(nil),                         // 11: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
	(*DataStoreConnectionSignals_CitedSnippet)(nil),                       // 12: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
	(*DataStoreConnectionSignals_GroundingSignals)(nil),                   // 13: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
	(*DataStoreConnectionSignals_SafetySignals)(nil),                      // 14: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
	(*structpb.Struct)(nil),                                               // 15: google.protobuf.Struct
}
var file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_depIdxs = []int32{
	0,  // 0: google.cloud.dialogflow.cx.v3.DataStoreConnection.data_store_type:type_name -> google.cloud.dialogflow.cx.v3.DataStoreType
	1,  // 1: google.cloud.dialogflow.cx.v3.DataStoreConnection.document_processing_mode:type_name -> google.cloud.dialogflow.cx.v3.DocumentProcessingMode
	8,  // 2: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.rewriter_model_call_signals:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
	9,  // 3: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.search_snippets:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
	10, // 4: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.answer_generation_model_call_signals:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals
	11, // 5: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.answer_parts:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
	12, // 6: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.cited_snippets:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
	13, // 7: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.grounding_signals:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
	14, // 8: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.safety_signals:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
	15, // 9: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.metadata:type_name -> google.protobuf.Struct
	9,  // 10: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.search_snippet:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
	2,  // 11: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.decision:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision
	3,  // 12: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.score:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket
	4,  // 13: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.decision:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision
	5,  // 14: google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.banned_phrase_match:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_init() }
func file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_init() {
	if File_google_cloud_dialogflow_cx_v3_data_store_connection_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3_data_store_connection_proto = out.File
	file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_depIdxs = nil
}
