// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/cx/v3/playbook.proto

package cxpb

import (
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	_ "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of the playbook.
type Playbook_PlaybookType int32

const (
	// Unspecified type. Default to TASK.
	Playbook_PLAYBOOK_TYPE_UNSPECIFIED Playbook_PlaybookType = 0
	// Task playbook.
	Playbook_TASK Playbook_PlaybookType = 1
	// Routine playbook.
	Playbook_ROUTINE Playbook_PlaybookType = 3
)

// Enum value maps for Playbook_PlaybookType.
var (
	Playbook_PlaybookType_name = map[int32]string{
		0: "PLAYBOOK_TYPE_UNSPECIFIED",
		1: "TASK",
		3: "ROUTINE",
	}
	Playbook_PlaybookType_value = map[string]int32{
		"PLAYBOOK_TYPE_UNSPECIFIED": 0,
		"TASK":                      1,
		"ROUTINE":                   3,
	}
)

func (x Playbook_PlaybookType) Enum() *Playbook_PlaybookType {
	p := new(Playbook_PlaybookType)
	*p = x
	return p
}

func (x Playbook_PlaybookType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Playbook_PlaybookType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_enumTypes[0].Descriptor()
}

func (Playbook_PlaybookType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_playbook_proto_enumTypes[0]
}

func (x Playbook_PlaybookType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Playbook_PlaybookType.Descriptor instead.
func (Playbook_PlaybookType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{6, 0}
}

// Data format of the exported playbook.
type ExportPlaybookRequest_DataFormat int32

const (
	// Unspecified format.
	ExportPlaybookRequest_DATA_FORMAT_UNSPECIFIED ExportPlaybookRequest_DataFormat = 0
	// Flow content will be exported as raw bytes.
	ExportPlaybookRequest_BLOB ExportPlaybookRequest_DataFormat = 1
	// Flow content will be exported in JSON format.
	ExportPlaybookRequest_JSON ExportPlaybookRequest_DataFormat = 2
)

// Enum value maps for ExportPlaybookRequest_DataFormat.
var (
	ExportPlaybookRequest_DataFormat_name = map[int32]string{
		0: "DATA_FORMAT_UNSPECIFIED",
		1: "BLOB",
		2: "JSON",
	}
	ExportPlaybookRequest_DataFormat_value = map[string]int32{
		"DATA_FORMAT_UNSPECIFIED": 0,
		"BLOB":                    1,
		"JSON":                    2,
	}
)

func (x ExportPlaybookRequest_DataFormat) Enum() *ExportPlaybookRequest_DataFormat {
	p := new(ExportPlaybookRequest_DataFormat)
	*p = x
	return p
}

func (x ExportPlaybookRequest_DataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExportPlaybookRequest_DataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_enumTypes[1].Descriptor()
}

func (ExportPlaybookRequest_DataFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_playbook_proto_enumTypes[1]
}

func (x ExportPlaybookRequest_DataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExportPlaybookRequest_DataFormat.Descriptor instead.
func (ExportPlaybookRequest_DataFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{15, 0}
}

// The request message for
// [Playbooks.CreatePlaybook][google.cloud.dialogflow.cx.v3.Playbooks.CreatePlaybook].
type CreatePlaybookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to create a playbook for.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The playbook to create.
	Playbook *Playbook `protobuf:"bytes,2,opt,name=playbook,proto3" json:"playbook,omitempty"`
}

func (x *CreatePlaybookRequest) Reset() {
	*x = CreatePlaybookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePlaybookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePlaybookRequest) ProtoMessage() {}

func (x *CreatePlaybookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePlaybookRequest.ProtoReflect.Descriptor instead.
func (*CreatePlaybookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{0}
}

func (x *CreatePlaybookRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePlaybookRequest) GetPlaybook() *Playbook {
	if x != nil {
		return x.Playbook
	}
	return nil
}

// The request message for
// [Playbooks.DeletePlaybook][google.cloud.dialogflow.cx.v3.Playbooks.DeletePlaybook].
type DeletePlaybookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the playbook to delete.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePlaybookRequest) Reset() {
	*x = DeletePlaybookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePlaybookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePlaybookRequest) ProtoMessage() {}

func (x *DeletePlaybookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePlaybookRequest.ProtoReflect.Descriptor instead.
func (*DeletePlaybookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{1}
}

func (x *DeletePlaybookRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Playbooks.ListPlaybooks][google.cloud.dialogflow.cx.v3.Playbooks.ListPlaybooks].
type ListPlaybooksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to list playbooks from.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPlaybooksRequest) Reset() {
	*x = ListPlaybooksRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPlaybooksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlaybooksRequest) ProtoMessage() {}

func (x *ListPlaybooksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlaybooksRequest.ProtoReflect.Descriptor instead.
func (*ListPlaybooksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{2}
}

func (x *ListPlaybooksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPlaybooksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPlaybooksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Playbooks.ListPlaybooks][google.cloud.dialogflow.cx.v3.Playbooks.ListPlaybooks].
type ListPlaybooksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of playbooks. There will be a maximum number of items returned
	// based on the page_size field in the request.
	Playbooks []*Playbook `protobuf:"bytes,1,rep,name=playbooks,proto3" json:"playbooks,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPlaybooksResponse) Reset() {
	*x = ListPlaybooksResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPlaybooksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlaybooksResponse) ProtoMessage() {}

func (x *ListPlaybooksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlaybooksResponse.ProtoReflect.Descriptor instead.
func (*ListPlaybooksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{3}
}

func (x *ListPlaybooksResponse) GetPlaybooks() []*Playbook {
	if x != nil {
		return x.Playbooks
	}
	return nil
}

func (x *ListPlaybooksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Playbooks.GetPlaybook][google.cloud.dialogflow.cx.v3.Playbooks.GetPlaybook].
type GetPlaybookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the playbook.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPlaybookRequest) Reset() {
	*x = GetPlaybookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPlaybookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPlaybookRequest) ProtoMessage() {}

func (x *GetPlaybookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPlaybookRequest.ProtoReflect.Descriptor instead.
func (*GetPlaybookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{4}
}

func (x *GetPlaybookRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Playbooks.UpdatePlaybook][google.cloud.dialogflow.cx.v3.Playbooks.UpdatePlaybook].
type UpdatePlaybookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The playbook to update.
	Playbook *Playbook `protobuf:"bytes,1,opt,name=playbook,proto3" json:"playbook,omitempty"`
	// The mask to control which fields get updated. If the mask is not present,
	// all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePlaybookRequest) Reset() {
	*x = UpdatePlaybookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePlaybookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePlaybookRequest) ProtoMessage() {}

func (x *UpdatePlaybookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePlaybookRequest.ProtoReflect.Descriptor instead.
func (*UpdatePlaybookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{5}
}

func (x *UpdatePlaybookRequest) GetPlaybook() *Playbook {
	if x != nil {
		return x.Playbook
	}
	return nil
}

func (x *UpdatePlaybookRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Playbook is the basic building block to instruct the LLM how to execute a
// certain task.
//
// A playbook consists of a goal to accomplish, an optional list of step by step
// instructions (the step instruction may refers to name of the custom or
// default plugin tools to use) to perform the task,
// a list of contextual input data to be passed in at the beginning of the
// invoked, and a list of output parameters to store the playbook result.
type Playbook struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the playbook.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the playbook, unique within an agent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. High level description of the goal the playbook intend to
	// accomplish. A goal should be concise since it's visible to other playbooks
	// that may reference this playbook.
	Goal string `protobuf:"bytes,3,opt,name=goal,proto3" json:"goal,omitempty"`
	// Optional. Defined structured input parameters for this playbook.
	InputParameterDefinitions []*ParameterDefinition `protobuf:"bytes,5,rep,name=input_parameter_definitions,json=inputParameterDefinitions,proto3" json:"input_parameter_definitions,omitempty"`
	// Optional. Defined structured output parameters for this playbook.
	OutputParameterDefinitions []*ParameterDefinition `protobuf:"bytes,6,rep,name=output_parameter_definitions,json=outputParameterDefinitions,proto3" json:"output_parameter_definitions,omitempty"`
	// Instruction to accomplish target goal.
	Instruction *Playbook_Instruction `protobuf:"bytes,17,opt,name=instruction,proto3" json:"instruction,omitempty"`
	// Output only. Estimated number of tokes current playbook takes when sent to
	// the LLM.
	TokenCount int64 `protobuf:"varint,8,opt,name=token_count,json=tokenCount,proto3" json:"token_count,omitempty"`
	// Output only. The timestamp of initial playbook creation.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last time the playbook version was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The resource name of other playbooks referenced by the current
	// playbook in the instructions.
	ReferencedPlaybooks []string `protobuf:"bytes,11,rep,name=referenced_playbooks,json=referencedPlaybooks,proto3" json:"referenced_playbooks,omitempty"`
	// Output only. The resource name of flows referenced by the current playbook
	// in the instructions.
	ReferencedFlows []string `protobuf:"bytes,12,rep,name=referenced_flows,json=referencedFlows,proto3" json:"referenced_flows,omitempty"`
	// Optional. The resource name of tools referenced by the current playbook in
	// the instructions. If not provided explicitly, they are will
	// be implied using the tool being referenced in goal and steps.
	ReferencedTools []string `protobuf:"bytes,13,rep,name=referenced_tools,json=referencedTools,proto3" json:"referenced_tools,omitempty"`
	// Optional. Output only. Names of inline actions scoped to this playbook.
	// These actions are in addition to those belonging to referenced tools, child
	// playbooks, and flows, e.g. actions that are defined in the playbook's code
	// block.
	InlineActions []string `protobuf:"bytes,22,rep,name=inline_actions,json=inlineActions,proto3" json:"inline_actions,omitempty"`
	// Optional. The playbook's scoped code block, which may implement handlers
	// and actions.
	CodeBlock *CodeBlock `protobuf:"bytes,21,opt,name=code_block,json=codeBlock,proto3" json:"code_block,omitempty"`
	// Optional. Llm model settings for the playbook.
	LlmModelSettings *LlmModelSettings `protobuf:"bytes,14,opt,name=llm_model_settings,json=llmModelSettings,proto3" json:"llm_model_settings,omitempty"`
	// Optional. A list of registered handlers to execuate based on the specified
	// triggers.
	Handlers []*Handler `protobuf:"bytes,16,rep,name=handlers,proto3" json:"handlers,omitempty"`
	// Optional. Type of the playbook.
	PlaybookType Playbook_PlaybookType `protobuf:"varint,19,opt,name=playbook_type,json=playbookType,proto3,enum=google.cloud.dialogflow.cx.v3.Playbook_PlaybookType" json:"playbook_type,omitempty"`
}

func (x *Playbook) Reset() {
	*x = Playbook{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Playbook) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Playbook) ProtoMessage() {}

func (x *Playbook) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Playbook.ProtoReflect.Descriptor instead.
func (*Playbook) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{6}
}

func (x *Playbook) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Playbook) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Playbook) GetGoal() string {
	if x != nil {
		return x.Goal
	}
	return ""
}

func (x *Playbook) GetInputParameterDefinitions() []*ParameterDefinition {
	if x != nil {
		return x.InputParameterDefinitions
	}
	return nil
}

func (x *Playbook) GetOutputParameterDefinitions() []*ParameterDefinition {
	if x != nil {
		return x.OutputParameterDefinitions
	}
	return nil
}

func (x *Playbook) GetInstruction() *Playbook_Instruction {
	if x != nil {
		return x.Instruction
	}
	return nil
}

func (x *Playbook) GetTokenCount() int64 {
	if x != nil {
		return x.TokenCount
	}
	return 0
}

func (x *Playbook) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Playbook) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Playbook) GetReferencedPlaybooks() []string {
	if x != nil {
		return x.ReferencedPlaybooks
	}
	return nil
}

func (x *Playbook) GetReferencedFlows() []string {
	if x != nil {
		return x.ReferencedFlows
	}
	return nil
}

func (x *Playbook) GetReferencedTools() []string {
	if x != nil {
		return x.ReferencedTools
	}
	return nil
}

func (x *Playbook) GetInlineActions() []string {
	if x != nil {
		return x.InlineActions
	}
	return nil
}

func (x *Playbook) GetCodeBlock() *CodeBlock {
	if x != nil {
		return x.CodeBlock
	}
	return nil
}

func (x *Playbook) GetLlmModelSettings() *LlmModelSettings {
	if x != nil {
		return x.LlmModelSettings
	}
	return nil
}

func (x *Playbook) GetHandlers() []*Handler {
	if x != nil {
		return x.Handlers
	}
	return nil
}

func (x *Playbook) GetPlaybookType() Playbook_PlaybookType {
	if x != nil {
		return x.PlaybookType
	}
	return Playbook_PLAYBOOK_TYPE_UNSPECIFIED
}

// The request message for
// [Playbooks.CreatePlaybookVersion][google.cloud.dialogflow.cx.v3.Playbooks.CreatePlaybookVersion].
type CreatePlaybookVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The playbook to create a version for.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The playbook version to create.
	PlaybookVersion *PlaybookVersion `protobuf:"bytes,2,opt,name=playbook_version,json=playbookVersion,proto3" json:"playbook_version,omitempty"`
}

func (x *CreatePlaybookVersionRequest) Reset() {
	*x = CreatePlaybookVersionRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePlaybookVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePlaybookVersionRequest) ProtoMessage() {}

func (x *CreatePlaybookVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePlaybookVersionRequest.ProtoReflect.Descriptor instead.
func (*CreatePlaybookVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{7}
}

func (x *CreatePlaybookVersionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePlaybookVersionRequest) GetPlaybookVersion() *PlaybookVersion {
	if x != nil {
		return x.PlaybookVersion
	}
	return nil
}

// Playbook version is a snapshot of the playbook at certain timestamp.
type PlaybookVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the playbook version.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>/versions/<VersionID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The description of the playbook version.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Snapshot of the playbook when the playbook version is created.
	Playbook *Playbook `protobuf:"bytes,3,opt,name=playbook,proto3" json:"playbook,omitempty"`
	// Output only. Snapshot of the examples belonging to the playbook when the
	// playbook version is created.
	Examples []*Example `protobuf:"bytes,4,rep,name=examples,proto3" json:"examples,omitempty"`
	// Output only. Last time the playbook version was created or modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *PlaybookVersion) Reset() {
	*x = PlaybookVersion{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaybookVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaybookVersion) ProtoMessage() {}

func (x *PlaybookVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaybookVersion.ProtoReflect.Descriptor instead.
func (*PlaybookVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{8}
}

func (x *PlaybookVersion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PlaybookVersion) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PlaybookVersion) GetPlaybook() *Playbook {
	if x != nil {
		return x.Playbook
	}
	return nil
}

func (x *PlaybookVersion) GetExamples() []*Example {
	if x != nil {
		return x.Examples
	}
	return nil
}

func (x *PlaybookVersion) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The request message for
// [Playbooks.GetPlaybookVersion][google.cloud.dialogflow.cx.v3.Playbooks.GetPlaybookVersion].
type GetPlaybookVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the playbook version.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>/versions/<VersionID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPlaybookVersionRequest) Reset() {
	*x = GetPlaybookVersionRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPlaybookVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPlaybookVersionRequest) ProtoMessage() {}

func (x *GetPlaybookVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPlaybookVersionRequest.ProtoReflect.Descriptor instead.
func (*GetPlaybookVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{9}
}

func (x *GetPlaybookVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Playbooks.RestorePlaybookVersion][google.cloud.dialogflow.cx.v3.Playbooks.RestorePlaybookVersion].
type RestorePlaybookVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the playbook version.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>/versions/<VersionID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RestorePlaybookVersionRequest) Reset() {
	*x = RestorePlaybookVersionRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestorePlaybookVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestorePlaybookVersionRequest) ProtoMessage() {}

func (x *RestorePlaybookVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestorePlaybookVersionRequest.ProtoReflect.Descriptor instead.
func (*RestorePlaybookVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{10}
}

func (x *RestorePlaybookVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response message for
// [Playbooks.RestorePlaybookVersion][google.cloud.dialogflow.cx.v3.Playbooks.RestorePlaybookVersion].
type RestorePlaybookVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The updated playbook.
	Playbook *Playbook `protobuf:"bytes,2,opt,name=playbook,proto3" json:"playbook,omitempty"`
}

func (x *RestorePlaybookVersionResponse) Reset() {
	*x = RestorePlaybookVersionResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestorePlaybookVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestorePlaybookVersionResponse) ProtoMessage() {}

func (x *RestorePlaybookVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestorePlaybookVersionResponse.ProtoReflect.Descriptor instead.
func (*RestorePlaybookVersionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{11}
}

func (x *RestorePlaybookVersionResponse) GetPlaybook() *Playbook {
	if x != nil {
		return x.Playbook
	}
	return nil
}

// The request message for
// [Playbooks.ListPlaybookVersions][google.cloud.dialogflow.cx.v3.Playbooks.ListPlaybookVersions].
type ListPlaybookVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The playbook to list versions for.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPlaybookVersionsRequest) Reset() {
	*x = ListPlaybookVersionsRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPlaybookVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlaybookVersionsRequest) ProtoMessage() {}

func (x *ListPlaybookVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlaybookVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListPlaybookVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{12}
}

func (x *ListPlaybookVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPlaybookVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPlaybookVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Playbooks.ListPlaybookVersions][google.cloud.dialogflow.cx.v3.Playbooks.ListPlaybookVersions].
type ListPlaybookVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of playbook version. There will be a maximum number of items
	// returned based on the page_size field in the request.
	PlaybookVersions []*PlaybookVersion `protobuf:"bytes,1,rep,name=playbook_versions,json=playbookVersions,proto3" json:"playbook_versions,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPlaybookVersionsResponse) Reset() {
	*x = ListPlaybookVersionsResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPlaybookVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlaybookVersionsResponse) ProtoMessage() {}

func (x *ListPlaybookVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlaybookVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListPlaybookVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{13}
}

func (x *ListPlaybookVersionsResponse) GetPlaybookVersions() []*PlaybookVersion {
	if x != nil {
		return x.PlaybookVersions
	}
	return nil
}

func (x *ListPlaybookVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Playbooks.DeletePlaybookVersion][google.cloud.dialogflow.cx.v3.Playbooks.DeletePlaybookVersion].
type DeletePlaybookVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the playbook version to delete.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>/versions/<VersionID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePlaybookVersionRequest) Reset() {
	*x = DeletePlaybookVersionRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePlaybookVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePlaybookVersionRequest) ProtoMessage() {}

func (x *DeletePlaybookVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePlaybookVersionRequest.ProtoReflect.Descriptor instead.
func (*DeletePlaybookVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{14}
}

func (x *DeletePlaybookVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Playbooks.ExportPlaybook][google.cloud.dialogflow.cx.v3.Playbooks.ExportPlaybook].
type ExportPlaybookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the playbook to export.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The [Google Cloud
	// Storage](https://cloud.google.com/storage/docs/) URI to export the playbook
	// to. The format of this URI must be `gs://<bucket-name>/<object-name>`. If
	// left unspecified, the serialized playbook is returned inline.
	//
	// Dialogflow performs a write operation for the Cloud Storage object
	// on the caller's behalf, so your request authentication must
	// have write permissions for the object. For more information, see
	// [Dialogflow access
	// control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	PlaybookUri string `protobuf:"bytes,2,opt,name=playbook_uri,json=playbookUri,proto3" json:"playbook_uri,omitempty"`
	// Optional. The data format of the exported agent. If not specified, `BLOB`
	// is assumed.
	DataFormat ExportPlaybookRequest_DataFormat `protobuf:"varint,3,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.dialogflow.cx.v3.ExportPlaybookRequest_DataFormat" json:"data_format,omitempty"`
}

func (x *ExportPlaybookRequest) Reset() {
	*x = ExportPlaybookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportPlaybookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportPlaybookRequest) ProtoMessage() {}

func (x *ExportPlaybookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportPlaybookRequest.ProtoReflect.Descriptor instead.
func (*ExportPlaybookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{15}
}

func (x *ExportPlaybookRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExportPlaybookRequest) GetPlaybookUri() string {
	if x != nil {
		return x.PlaybookUri
	}
	return ""
}

func (x *ExportPlaybookRequest) GetDataFormat() ExportPlaybookRequest_DataFormat {
	if x != nil {
		return x.DataFormat
	}
	return ExportPlaybookRequest_DATA_FORMAT_UNSPECIFIED
}

// The request message for
// [Playbooks.ImportPlaybook][google.cloud.dialogflow.cx.v3.Playbooks.ImportPlaybook].
type ImportPlaybookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to import the playbook into.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The playbook to import.
	// The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
	// to import playbook from. The format of this URI must be
	// `gs://<bucket-name>/<object-name>`.
	//
	// Dialogflow performs a read operation for the Cloud Storage object
	// on the caller's behalf, so your request authentication must
	// have read permissions for the object. For more information, see
	//
	// Types that are assignable to Playbook:
	//
	//	*ImportPlaybookRequest_PlaybookUri
	//	*ImportPlaybookRequest_PlaybookContent
	Playbook isImportPlaybookRequest_Playbook `protobuf_oneof:"playbook"`
	// Optional. Specifies the import strategy used when resolving resource
	// conflicts.
	ImportStrategy *PlaybookImportStrategy `protobuf:"bytes,4,opt,name=import_strategy,json=importStrategy,proto3" json:"import_strategy,omitempty"`
}

func (x *ImportPlaybookRequest) Reset() {
	*x = ImportPlaybookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportPlaybookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportPlaybookRequest) ProtoMessage() {}

func (x *ImportPlaybookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportPlaybookRequest.ProtoReflect.Descriptor instead.
func (*ImportPlaybookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{16}
}

func (x *ImportPlaybookRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *ImportPlaybookRequest) GetPlaybook() isImportPlaybookRequest_Playbook {
	if m != nil {
		return m.Playbook
	}
	return nil
}

func (x *ImportPlaybookRequest) GetPlaybookUri() string {
	if x, ok := x.GetPlaybook().(*ImportPlaybookRequest_PlaybookUri); ok {
		return x.PlaybookUri
	}
	return ""
}

func (x *ImportPlaybookRequest) GetPlaybookContent() []byte {
	if x, ok := x.GetPlaybook().(*ImportPlaybookRequest_PlaybookContent); ok {
		return x.PlaybookContent
	}
	return nil
}

func (x *ImportPlaybookRequest) GetImportStrategy() *PlaybookImportStrategy {
	if x != nil {
		return x.ImportStrategy
	}
	return nil
}

type isImportPlaybookRequest_Playbook interface {
	isImportPlaybookRequest_Playbook()
}

type ImportPlaybookRequest_PlaybookUri struct {
	// [Dialogflow access
	// control]
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	PlaybookUri string `protobuf:"bytes,2,opt,name=playbook_uri,json=playbookUri,proto3,oneof"`
}

type ImportPlaybookRequest_PlaybookContent struct {
	// Uncompressed raw byte content for playbook.
	PlaybookContent []byte `protobuf:"bytes,3,opt,name=playbook_content,json=playbookContent,proto3,oneof"`
}

func (*ImportPlaybookRequest_PlaybookUri) isImportPlaybookRequest_Playbook() {}

func (*ImportPlaybookRequest_PlaybookContent) isImportPlaybookRequest_Playbook() {}

// The playbook import strategy used for resource conflict resolution associated
// with an
// [ImportPlaybookRequest][google.cloud.dialogflow.cx.v3.ImportPlaybookRequest].
type PlaybookImportStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies the import strategy used when resolving conflicts with
	// the main playbook. If not specified, 'CREATE_NEW' is assumed.
	MainPlaybookImportStrategy ImportStrategy `protobuf:"varint,4,opt,name=main_playbook_import_strategy,json=mainPlaybookImportStrategy,proto3,enum=google.cloud.dialogflow.cx.v3.ImportStrategy" json:"main_playbook_import_strategy,omitempty"`
	// Optional. Specifies the import strategy used when resolving referenced
	// playbook/flow conflicts. If not specified, 'CREATE_NEW' is assumed.
	NestedResourceImportStrategy ImportStrategy `protobuf:"varint,5,opt,name=nested_resource_import_strategy,json=nestedResourceImportStrategy,proto3,enum=google.cloud.dialogflow.cx.v3.ImportStrategy" json:"nested_resource_import_strategy,omitempty"`
	// Optional. Specifies the import strategy used when resolving tool conflicts.
	// If not specified, 'CREATE_NEW' is assumed. This will be applied after the
	// main playbook and nested resource import strategies, meaning if the
	// playbook that references the tool is skipped, the tool will also be
	// skipped.
	ToolImportStrategy ImportStrategy `protobuf:"varint,6,opt,name=tool_import_strategy,json=toolImportStrategy,proto3,enum=google.cloud.dialogflow.cx.v3.ImportStrategy" json:"tool_import_strategy,omitempty"`
}

func (x *PlaybookImportStrategy) Reset() {
	*x = PlaybookImportStrategy{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaybookImportStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaybookImportStrategy) ProtoMessage() {}

func (x *PlaybookImportStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaybookImportStrategy.ProtoReflect.Descriptor instead.
func (*PlaybookImportStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{17}
}

func (x *PlaybookImportStrategy) GetMainPlaybookImportStrategy() ImportStrategy {
	if x != nil {
		return x.MainPlaybookImportStrategy
	}
	return ImportStrategy_IMPORT_STRATEGY_UNSPECIFIED
}

func (x *PlaybookImportStrategy) GetNestedResourceImportStrategy() ImportStrategy {
	if x != nil {
		return x.NestedResourceImportStrategy
	}
	return ImportStrategy_IMPORT_STRATEGY_UNSPECIFIED
}

func (x *PlaybookImportStrategy) GetToolImportStrategy() ImportStrategy {
	if x != nil {
		return x.ToolImportStrategy
	}
	return ImportStrategy_IMPORT_STRATEGY_UNSPECIFIED
}

// The response message for
// [Playbooks.ImportPlaybook][google.cloud.dialogflow.cx.v3.Playbooks.ImportPlaybook].
type ImportPlaybookResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the new playbook.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Playbook string `protobuf:"bytes,1,opt,name=playbook,proto3" json:"playbook,omitempty"`
	// Info which resources have conflicts when
	// [REPORT_CONFLICTS][ImportPlaybookResponse.REPORT_CONFLICTS] import strategy
	// is set for all resources in ImportPlaybookRequest.
	ConflictingResources *ImportPlaybookResponse_ConflictingResources `protobuf:"bytes,2,opt,name=conflicting_resources,json=conflictingResources,proto3" json:"conflicting_resources,omitempty"`
}

func (x *ImportPlaybookResponse) Reset() {
	*x = ImportPlaybookResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportPlaybookResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportPlaybookResponse) ProtoMessage() {}

func (x *ImportPlaybookResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportPlaybookResponse.ProtoReflect.Descriptor instead.
func (*ImportPlaybookResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{18}
}

func (x *ImportPlaybookResponse) GetPlaybook() string {
	if x != nil {
		return x.Playbook
	}
	return ""
}

func (x *ImportPlaybookResponse) GetConflictingResources() *ImportPlaybookResponse_ConflictingResources {
	if x != nil {
		return x.ConflictingResources
	}
	return nil
}

// The response message for
// [Playbooks.ExportPlaybook][google.cloud.dialogflow.cx.v3.Playbooks.ExportPlaybook].
type ExportPlaybookResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The exported playbook.
	//
	// Types that are assignable to Playbook:
	//
	//	*ExportPlaybookResponse_PlaybookUri
	//	*ExportPlaybookResponse_PlaybookContent
	Playbook isExportPlaybookResponse_Playbook `protobuf_oneof:"playbook"`
}

func (x *ExportPlaybookResponse) Reset() {
	*x = ExportPlaybookResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportPlaybookResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportPlaybookResponse) ProtoMessage() {}

func (x *ExportPlaybookResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportPlaybookResponse.ProtoReflect.Descriptor instead.
func (*ExportPlaybookResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{19}
}

func (m *ExportPlaybookResponse) GetPlaybook() isExportPlaybookResponse_Playbook {
	if m != nil {
		return m.Playbook
	}
	return nil
}

func (x *ExportPlaybookResponse) GetPlaybookUri() string {
	if x, ok := x.GetPlaybook().(*ExportPlaybookResponse_PlaybookUri); ok {
		return x.PlaybookUri
	}
	return ""
}

func (x *ExportPlaybookResponse) GetPlaybookContent() []byte {
	if x, ok := x.GetPlaybook().(*ExportPlaybookResponse_PlaybookContent); ok {
		return x.PlaybookContent
	}
	return nil
}

type isExportPlaybookResponse_Playbook interface {
	isExportPlaybookResponse_Playbook()
}

type ExportPlaybookResponse_PlaybookUri struct {
	// The URI to a file containing the exported playbook. This field is
	// populated only if `playbook_uri` is specified in
	// [ExportPlaybookRequest][google.cloud.dialogflow.cx.v3.ExportPlaybookRequest].
	PlaybookUri string `protobuf:"bytes,1,opt,name=playbook_uri,json=playbookUri,proto3,oneof"`
}

type ExportPlaybookResponse_PlaybookContent struct {
	// Uncompressed raw byte content for playbook.
	PlaybookContent []byte `protobuf:"bytes,2,opt,name=playbook_content,json=playbookContent,proto3,oneof"`
}

func (*ExportPlaybookResponse_PlaybookUri) isExportPlaybookResponse_Playbook() {}

func (*ExportPlaybookResponse_PlaybookContent) isExportPlaybookResponse_Playbook() {}

// Handler can be used to define custom logic to be executed based on the
// user-specified triggers.
type Handler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the type of handler to invoke.
	//
	// Types that are assignable to Handler:
	//
	//	*Handler_EventHandler_
	//	*Handler_LifecycleHandler_
	Handler isHandler_Handler `protobuf_oneof:"handler"`
}

func (x *Handler) Reset() {
	*x = Handler{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Handler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Handler) ProtoMessage() {}

func (x *Handler) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Handler.ProtoReflect.Descriptor instead.
func (*Handler) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{20}
}

func (m *Handler) GetHandler() isHandler_Handler {
	if m != nil {
		return m.Handler
	}
	return nil
}

func (x *Handler) GetEventHandler() *Handler_EventHandler {
	if x, ok := x.GetHandler().(*Handler_EventHandler_); ok {
		return x.EventHandler
	}
	return nil
}

func (x *Handler) GetLifecycleHandler() *Handler_LifecycleHandler {
	if x, ok := x.GetHandler().(*Handler_LifecycleHandler_); ok {
		return x.LifecycleHandler
	}
	return nil
}

type isHandler_Handler interface {
	isHandler_Handler()
}

type Handler_EventHandler_ struct {
	// A handler triggered by event.
	EventHandler *Handler_EventHandler `protobuf:"bytes,1,opt,name=event_handler,json=eventHandler,proto3,oneof"`
}

type Handler_LifecycleHandler_ struct {
	// A handler triggered during specific lifecycle of the playbook execution.
	LifecycleHandler *Handler_LifecycleHandler `protobuf:"bytes,3,opt,name=lifecycle_handler,json=lifecycleHandler,proto3,oneof"`
}

func (*Handler_EventHandler_) isHandler_Handler() {}

func (*Handler_LifecycleHandler_) isHandler_Handler() {}

// Message of single step execution.
type Playbook_Step struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instruction on how to execute current step.
	//
	// Types that are assignable to Instruction:
	//
	//	*Playbook_Step_Text
	Instruction isPlaybook_Step_Instruction `protobuf_oneof:"instruction"`
	// Sub-processing needed to execute the current step.
	Steps []*Playbook_Step `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *Playbook_Step) Reset() {
	*x = Playbook_Step{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Playbook_Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Playbook_Step) ProtoMessage() {}

func (x *Playbook_Step) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Playbook_Step.ProtoReflect.Descriptor instead.
func (*Playbook_Step) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{6, 0}
}

func (m *Playbook_Step) GetInstruction() isPlaybook_Step_Instruction {
	if m != nil {
		return m.Instruction
	}
	return nil
}

func (x *Playbook_Step) GetText() string {
	if x, ok := x.GetInstruction().(*Playbook_Step_Text); ok {
		return x.Text
	}
	return ""
}

func (x *Playbook_Step) GetSteps() []*Playbook_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

type isPlaybook_Step_Instruction interface {
	isPlaybook_Step_Instruction()
}

type Playbook_Step_Text struct {
	// Step instruction in text format.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

func (*Playbook_Step_Text) isPlaybook_Step_Instruction() {}

// Message of the Instruction of the playbook.
type Playbook_Instruction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// General guidelines for the playbook. These are unstructured instructions
	// that are not directly part of the goal, e.g. "Always be polite". It's
	// valid for this text to be long and used instead of steps altogether.
	Guidelines string `protobuf:"bytes,1,opt,name=guidelines,proto3" json:"guidelines,omitempty"`
	// Ordered list of step by step execution instructions to accomplish
	// target goal.
	Steps []*Playbook_Step `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *Playbook_Instruction) Reset() {
	*x = Playbook_Instruction{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Playbook_Instruction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Playbook_Instruction) ProtoMessage() {}

func (x *Playbook_Instruction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Playbook_Instruction.ProtoReflect.Descriptor instead.
func (*Playbook_Instruction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Playbook_Instruction) GetGuidelines() string {
	if x != nil {
		return x.Guidelines
	}
	return ""
}

func (x *Playbook_Instruction) GetSteps() []*Playbook_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

// Conflicting resources detected during the import process. Only filled when
// [REPORT_CONFLICTS][ImportPlaybookResponse.REPORT_CONFLICTS] is set in the
// request and there are conflicts in the display names.
type ImportPlaybookResponse_ConflictingResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display name of conflicting main playbook.
	MainPlaybookDisplayName string `protobuf:"bytes,1,opt,name=main_playbook_display_name,json=mainPlaybookDisplayName,proto3" json:"main_playbook_display_name,omitempty"`
	// Display names of conflicting nested playbooks.
	NestedPlaybookDisplayNames []string `protobuf:"bytes,2,rep,name=nested_playbook_display_names,json=nestedPlaybookDisplayNames,proto3" json:"nested_playbook_display_names,omitempty"`
	// Display names of conflicting tools.
	ToolDisplayNames []string `protobuf:"bytes,3,rep,name=tool_display_names,json=toolDisplayNames,proto3" json:"tool_display_names,omitempty"`
}

func (x *ImportPlaybookResponse_ConflictingResources) Reset() {
	*x = ImportPlaybookResponse_ConflictingResources{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportPlaybookResponse_ConflictingResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportPlaybookResponse_ConflictingResources) ProtoMessage() {}

func (x *ImportPlaybookResponse_ConflictingResources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportPlaybookResponse_ConflictingResources.ProtoReflect.Descriptor instead.
func (*ImportPlaybookResponse_ConflictingResources) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{18, 0}
}

func (x *ImportPlaybookResponse_ConflictingResources) GetMainPlaybookDisplayName() string {
	if x != nil {
		return x.MainPlaybookDisplayName
	}
	return ""
}

func (x *ImportPlaybookResponse_ConflictingResources) GetNestedPlaybookDisplayNames() []string {
	if x != nil {
		return x.NestedPlaybookDisplayNames
	}
	return nil
}

func (x *ImportPlaybookResponse_ConflictingResources) GetToolDisplayNames() []string {
	if x != nil {
		return x.ToolDisplayNames
	}
	return nil
}

// A handler that is triggered by the specified
// [event][google.cloud.dialogflow.cx.v3.Handler.EventHandler.event].
type Handler_EventHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the event that triggers this handler.
	Event string `protobuf:"bytes,1,opt,name=event,proto3" json:"event,omitempty"`
	// Optional. The condition that must be satisfied to trigger this handler.
	Condition string `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// Required. The fulfillment to call when the event occurs.
	Fulfillment *Fulfillment `protobuf:"bytes,2,opt,name=fulfillment,proto3" json:"fulfillment,omitempty"`
}

func (x *Handler_EventHandler) Reset() {
	*x = Handler_EventHandler{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Handler_EventHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Handler_EventHandler) ProtoMessage() {}

func (x *Handler_EventHandler) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Handler_EventHandler.ProtoReflect.Descriptor instead.
func (*Handler_EventHandler) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{20, 0}
}

func (x *Handler_EventHandler) GetEvent() string {
	if x != nil {
		return x.Event
	}
	return ""
}

func (x *Handler_EventHandler) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *Handler_EventHandler) GetFulfillment() *Fulfillment {
	if x != nil {
		return x.Fulfillment
	}
	return nil
}

// A handler that is triggered on the specific
// [lifecycle_stage][google.cloud.dialogflow.cx.v3.Handler.LifecycleHandler.lifecycle_stage]
// of the playbook execution.
type Handler_LifecycleHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the lifecycle stage that triggers this handler.
	// Supported values:
	// * `playbook-start`
	// * `pre-action-selection`
	// * `pre-action-execution`
	LifecycleStage string `protobuf:"bytes,1,opt,name=lifecycle_stage,json=lifecycleStage,proto3" json:"lifecycle_stage,omitempty"`
	// Optional. The condition that must be satisfied to trigger this handler.
	Condition string `protobuf:"bytes,2,opt,name=condition,proto3" json:"condition,omitempty"`
	// Required. The fulfillment to call when this handler is triggered.
	Fulfillment *Fulfillment `protobuf:"bytes,3,opt,name=fulfillment,proto3" json:"fulfillment,omitempty"`
}

func (x *Handler_LifecycleHandler) Reset() {
	*x = Handler_LifecycleHandler{}
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Handler_LifecycleHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Handler_LifecycleHandler) ProtoMessage() {}

func (x *Handler_LifecycleHandler) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Handler_LifecycleHandler.ProtoReflect.Descriptor instead.
func (*Handler_LifecycleHandler) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP(), []int{20, 1}
}

func (x *Handler_LifecycleHandler) GetLifecycleStage() string {
	if x != nil {
		return x.LifecycleStage
	}
	return ""
}

func (x *Handler_LifecycleHandler) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *Handler_LifecycleHandler) GetFulfillment() *Fulfillment {
	if x != nil {
		return x.Fulfillment
	}
	return nil
}

var File_google_cloud_dialogflow_cx_v3_playbook_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x63, 0x6f, 0x64, 0x65, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f, 0x66, 0x75, 0x6c,
	0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa5, 0x01, 0x0a, 0x15, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x22, 0x57, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24,
	0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x86, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a,
	0x09, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x09, 0x70, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x54, 0x0a, 0x12,
	0x47, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x9e, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x08,
	0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x83, 0x0d, 0x0a, 0x08, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x67, 0x6f, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x67, 0x6f, 0x61, 0x6c, 0x12, 0x77, 0x0a, 0x1b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x19, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x79,
	0x0a, 0x1c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x44, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x44, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x0b, 0x69, 0x6e, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x14, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x24,
	0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x13, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64,
	0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0x51, 0x0a, 0x10, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x0f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x12, 0x51, 0x0a, 0x10,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x20, 0x0a, 0x1e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x0f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x12,
	0x2d, 0x0a, 0x0e, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4c,
	0x0a, 0x0a, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x62, 0x0a, 0x12,
	0x6c, 0x6c, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x6c, 0x6d, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x6c, 0x6c, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x47, 0x0a, 0x08, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x18, 0x10, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x12, 0x5e, 0x0a, 0x0d, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x6f, 0x0a, 0x04, 0x53, 0x74, 0x65,
	0x70, 0x12, 0x14, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x2e,
	0x53, 0x74, 0x65, 0x70, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x42, 0x0d, 0x0a, 0x0b, 0x69,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x71, 0x0a, 0x0b, 0x49, 0x6e,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x75, 0x69,
	0x64, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x67,
	0x75, 0x69, 0x64, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x65,
	0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x22, 0x44, 0x0a,
	0x0c, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a,
	0x19, 0x50, 0x4c, 0x41, 0x59, 0x42, 0x4f, 0x4f, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x54, 0x41, 0x53, 0x4b, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e,
	0x45, 0x10, 0x03, 0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x4b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x7b,
	0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x7d, 0x22, 0xc9, 0x01, 0x0a, 0x1c, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x12, 0x29, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd6, 0x03, 0x0a, 0x0f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x47,
	0x0a, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x65,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0xb2, 0x01, 0xea, 0x41, 0xae, 0x01,
	0x0a, 0x29, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x7d, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x7b, 0x70,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x10, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x0f, 0x70,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x62,
	0x0a, 0x19, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2b, 0x0a, 0x29, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x66, 0x0a, 0x1d, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x1e, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x08,
	0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x22, 0xae, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xa3, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x11, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10,
	0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x65, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa5, 0x02, 0x0a, 0x15, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x55, 0x72,
	0x69, 0x12, 0x65, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x61,
	0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x3d, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46,
	0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4c, 0x4f, 0x42, 0x10, 0x01, 0x12, 0x08, 0x0a,
	0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x9e, 0x02, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0c, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x70,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x2b, 0x0a, 0x10, 0x70, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x63, 0x0a, 0x0f, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x0a, 0x0a, 0x08,
	0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x22, 0xf0, 0x02, 0x0a, 0x16, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x12, 0x75, 0x0a, 0x1d, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x70, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a,
	0x6d, 0x61, 0x69, 0x6e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x79, 0x0a, 0x1f, 0x6e, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x64, 0x0a, 0x14, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x74, 0x6f, 0x6f, 0x6c, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0xa5, 0x03, 0x0a, 0x16,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x7f, 0x0a, 0x15, 0x63,
	0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0xc4, 0x01, 0x0a,
	0x14, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x1a, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x70, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x6d, 0x61, 0x69, 0x6e, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x41, 0x0a, 0x1d, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1a, 0x6e, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x10, 0x74, 0x6f, 0x6f, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x22, 0x76, 0x0a, 0x16, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a,
	0x0c, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x55,
	0x72, 0x69, 0x12, 0x2b, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0f,
	0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42,
	0x0a, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x22, 0xb3, 0x04, 0x0a, 0x07,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x0d, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x48,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x72, 0x12, 0x66, 0x0a, 0x11, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65,
	0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x48,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x69, 0x66, 0x65, 0x63,
	0x79, 0x63, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x1a, 0x9f, 0x01, 0x0a, 0x0c,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x05,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0b, 0x66, 0x75,
	0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0xb6, 0x01,
	0x0a, 0x10, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x72, 0x12, 0x2c, 0x0a, 0x0f, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65,
	0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0b, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x66, 0x75, 0x6c, 0x66, 0x69,
	0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x72, 0x32, 0x87, 0x15, 0x0a, 0x09, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x12,
	0xcb, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x22, 0x5a, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x08, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x22, 0x36, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0xa5, 0x01,
	0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x45,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x2a, 0x36, 0x2f,
	0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc3, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0xb0, 0x01, 0x0a, 0x0b,
	0x47, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe2,
	0x01, 0x0a, 0x0e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7b, 0xca, 0x41, 0x30, 0x0a, 0x16, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0xe2, 0x01, 0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7b, 0xca, 0x41, 0x30,
	0x0a, 0x16, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x33, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xd9, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x22, 0x68, 0xda, 0x41, 0x14, 0x70,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x32, 0x3f, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfb, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0xda, 0x41, 0x17,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a, 0x10, 0x70,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x41, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0xd0, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0x50, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf2, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5b, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x01, 0x2a, 0x22,
	0x49, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0xe3, 0x01, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f,
	0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0xbe, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x50, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x2a, 0x41,
	0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x8c, 0x01, 0x0a, 0x21,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x42, 0x0d, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x31, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x63, 0x78, 0x70, 0x62,
	0x3b, 0x63, 0x78, 0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescData = file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3_playbook_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_google_cloud_dialogflow_cx_v3_playbook_proto_goTypes = []any{
	(Playbook_PlaybookType)(0),                          // 0: google.cloud.dialogflow.cx.v3.Playbook.PlaybookType
	(ExportPlaybookRequest_DataFormat)(0),               // 1: google.cloud.dialogflow.cx.v3.ExportPlaybookRequest.DataFormat
	(*CreatePlaybookRequest)(nil),                       // 2: google.cloud.dialogflow.cx.v3.CreatePlaybookRequest
	(*DeletePlaybookRequest)(nil),                       // 3: google.cloud.dialogflow.cx.v3.DeletePlaybookRequest
	(*ListPlaybooksRequest)(nil),                        // 4: google.cloud.dialogflow.cx.v3.ListPlaybooksRequest
	(*ListPlaybooksResponse)(nil),                       // 5: google.cloud.dialogflow.cx.v3.ListPlaybooksResponse
	(*GetPlaybookRequest)(nil),                          // 6: google.cloud.dialogflow.cx.v3.GetPlaybookRequest
	(*UpdatePlaybookRequest)(nil),                       // 7: google.cloud.dialogflow.cx.v3.UpdatePlaybookRequest
	(*Playbook)(nil),                                    // 8: google.cloud.dialogflow.cx.v3.Playbook
	(*CreatePlaybookVersionRequest)(nil),                // 9: google.cloud.dialogflow.cx.v3.CreatePlaybookVersionRequest
	(*PlaybookVersion)(nil),                             // 10: google.cloud.dialogflow.cx.v3.PlaybookVersion
	(*GetPlaybookVersionRequest)(nil),                   // 11: google.cloud.dialogflow.cx.v3.GetPlaybookVersionRequest
	(*RestorePlaybookVersionRequest)(nil),               // 12: google.cloud.dialogflow.cx.v3.RestorePlaybookVersionRequest
	(*RestorePlaybookVersionResponse)(nil),              // 13: google.cloud.dialogflow.cx.v3.RestorePlaybookVersionResponse
	(*ListPlaybookVersionsRequest)(nil),                 // 14: google.cloud.dialogflow.cx.v3.ListPlaybookVersionsRequest
	(*ListPlaybookVersionsResponse)(nil),                // 15: google.cloud.dialogflow.cx.v3.ListPlaybookVersionsResponse
	(*DeletePlaybookVersionRequest)(nil),                // 16: google.cloud.dialogflow.cx.v3.DeletePlaybookVersionRequest
	(*ExportPlaybookRequest)(nil),                       // 17: google.cloud.dialogflow.cx.v3.ExportPlaybookRequest
	(*ImportPlaybookRequest)(nil),                       // 18: google.cloud.dialogflow.cx.v3.ImportPlaybookRequest
	(*PlaybookImportStrategy)(nil),                      // 19: google.cloud.dialogflow.cx.v3.PlaybookImportStrategy
	(*ImportPlaybookResponse)(nil),                      // 20: google.cloud.dialogflow.cx.v3.ImportPlaybookResponse
	(*ExportPlaybookResponse)(nil),                      // 21: google.cloud.dialogflow.cx.v3.ExportPlaybookResponse
	(*Handler)(nil),                                     // 22: google.cloud.dialogflow.cx.v3.Handler
	(*Playbook_Step)(nil),                               // 23: google.cloud.dialogflow.cx.v3.Playbook.Step
	(*Playbook_Instruction)(nil),                        // 24: google.cloud.dialogflow.cx.v3.Playbook.Instruction
	(*ImportPlaybookResponse_ConflictingResources)(nil), // 25: google.cloud.dialogflow.cx.v3.ImportPlaybookResponse.ConflictingResources
	(*Handler_EventHandler)(nil),                        // 26: google.cloud.dialogflow.cx.v3.Handler.EventHandler
	(*Handler_LifecycleHandler)(nil),                    // 27: google.cloud.dialogflow.cx.v3.Handler.LifecycleHandler
	(*fieldmaskpb.FieldMask)(nil),                       // 28: google.protobuf.FieldMask
	(*ParameterDefinition)(nil),                         // 29: google.cloud.dialogflow.cx.v3.ParameterDefinition
	(*timestamppb.Timestamp)(nil),                       // 30: google.protobuf.Timestamp
	(*CodeBlock)(nil),                                   // 31: google.cloud.dialogflow.cx.v3.CodeBlock
	(*LlmModelSettings)(nil),                            // 32: google.cloud.dialogflow.cx.v3.LlmModelSettings
	(*Example)(nil),                                     // 33: google.cloud.dialogflow.cx.v3.Example
	(ImportStrategy)(0),                                 // 34: google.cloud.dialogflow.cx.v3.ImportStrategy
	(*Fulfillment)(nil),                                 // 35: google.cloud.dialogflow.cx.v3.Fulfillment
	(*emptypb.Empty)(nil),                               // 36: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),                     // 37: google.longrunning.Operation
}
var file_google_cloud_dialogflow_cx_v3_playbook_proto_depIdxs = []int32{
	8,  // 0: google.cloud.dialogflow.cx.v3.CreatePlaybookRequest.playbook:type_name -> google.cloud.dialogflow.cx.v3.Playbook
	8,  // 1: google.cloud.dialogflow.cx.v3.ListPlaybooksResponse.playbooks:type_name -> google.cloud.dialogflow.cx.v3.Playbook
	8,  // 2: google.cloud.dialogflow.cx.v3.UpdatePlaybookRequest.playbook:type_name -> google.cloud.dialogflow.cx.v3.Playbook
	28, // 3: google.cloud.dialogflow.cx.v3.UpdatePlaybookRequest.update_mask:type_name -> google.protobuf.FieldMask
	29, // 4: google.cloud.dialogflow.cx.v3.Playbook.input_parameter_definitions:type_name -> google.cloud.dialogflow.cx.v3.ParameterDefinition
	29, // 5: google.cloud.dialogflow.cx.v3.Playbook.output_parameter_definitions:type_name -> google.cloud.dialogflow.cx.v3.ParameterDefinition
	24, // 6: google.cloud.dialogflow.cx.v3.Playbook.instruction:type_name -> google.cloud.dialogflow.cx.v3.Playbook.Instruction
	30, // 7: google.cloud.dialogflow.cx.v3.Playbook.create_time:type_name -> google.protobuf.Timestamp
	30, // 8: google.cloud.dialogflow.cx.v3.Playbook.update_time:type_name -> google.protobuf.Timestamp
	31, // 9: google.cloud.dialogflow.cx.v3.Playbook.code_block:type_name -> google.cloud.dialogflow.cx.v3.CodeBlock
	32, // 10: google.cloud.dialogflow.cx.v3.Playbook.llm_model_settings:type_name -> google.cloud.dialogflow.cx.v3.LlmModelSettings
	22, // 11: google.cloud.dialogflow.cx.v3.Playbook.handlers:type_name -> google.cloud.dialogflow.cx.v3.Handler
	0,  // 12: google.cloud.dialogflow.cx.v3.Playbook.playbook_type:type_name -> google.cloud.dialogflow.cx.v3.Playbook.PlaybookType
	10, // 13: google.cloud.dialogflow.cx.v3.CreatePlaybookVersionRequest.playbook_version:type_name -> google.cloud.dialogflow.cx.v3.PlaybookVersion
	8,  // 14: google.cloud.dialogflow.cx.v3.PlaybookVersion.playbook:type_name -> google.cloud.dialogflow.cx.v3.Playbook
	33, // 15: google.cloud.dialogflow.cx.v3.PlaybookVersion.examples:type_name -> google.cloud.dialogflow.cx.v3.Example
	30, // 16: google.cloud.dialogflow.cx.v3.PlaybookVersion.update_time:type_name -> google.protobuf.Timestamp
	8,  // 17: google.cloud.dialogflow.cx.v3.RestorePlaybookVersionResponse.playbook:type_name -> google.cloud.dialogflow.cx.v3.Playbook
	10, // 18: google.cloud.dialogflow.cx.v3.ListPlaybookVersionsResponse.playbook_versions:type_name -> google.cloud.dialogflow.cx.v3.PlaybookVersion
	1,  // 19: google.cloud.dialogflow.cx.v3.ExportPlaybookRequest.data_format:type_name -> google.cloud.dialogflow.cx.v3.ExportPlaybookRequest.DataFormat
	19, // 20: google.cloud.dialogflow.cx.v3.ImportPlaybookRequest.import_strategy:type_name -> google.cloud.dialogflow.cx.v3.PlaybookImportStrategy
	34, // 21: google.cloud.dialogflow.cx.v3.PlaybookImportStrategy.main_playbook_import_strategy:type_name -> google.cloud.dialogflow.cx.v3.ImportStrategy
	34, // 22: google.cloud.dialogflow.cx.v3.PlaybookImportStrategy.nested_resource_import_strategy:type_name -> google.cloud.dialogflow.cx.v3.ImportStrategy
	34, // 23: google.cloud.dialogflow.cx.v3.PlaybookImportStrategy.tool_import_strategy:type_name -> google.cloud.dialogflow.cx.v3.ImportStrategy
	25, // 24: google.cloud.dialogflow.cx.v3.ImportPlaybookResponse.conflicting_resources:type_name -> google.cloud.dialogflow.cx.v3.ImportPlaybookResponse.ConflictingResources
	26, // 25: google.cloud.dialogflow.cx.v3.Handler.event_handler:type_name -> google.cloud.dialogflow.cx.v3.Handler.EventHandler
	27, // 26: google.cloud.dialogflow.cx.v3.Handler.lifecycle_handler:type_name -> google.cloud.dialogflow.cx.v3.Handler.LifecycleHandler
	23, // 27: google.cloud.dialogflow.cx.v3.Playbook.Step.steps:type_name -> google.cloud.dialogflow.cx.v3.Playbook.Step
	23, // 28: google.cloud.dialogflow.cx.v3.Playbook.Instruction.steps:type_name -> google.cloud.dialogflow.cx.v3.Playbook.Step
	35, // 29: google.cloud.dialogflow.cx.v3.Handler.EventHandler.fulfillment:type_name -> google.cloud.dialogflow.cx.v3.Fulfillment
	35, // 30: google.cloud.dialogflow.cx.v3.Handler.LifecycleHandler.fulfillment:type_name -> google.cloud.dialogflow.cx.v3.Fulfillment
	2,  // 31: google.cloud.dialogflow.cx.v3.Playbooks.CreatePlaybook:input_type -> google.cloud.dialogflow.cx.v3.CreatePlaybookRequest
	3,  // 32: google.cloud.dialogflow.cx.v3.Playbooks.DeletePlaybook:input_type -> google.cloud.dialogflow.cx.v3.DeletePlaybookRequest
	4,  // 33: google.cloud.dialogflow.cx.v3.Playbooks.ListPlaybooks:input_type -> google.cloud.dialogflow.cx.v3.ListPlaybooksRequest
	6,  // 34: google.cloud.dialogflow.cx.v3.Playbooks.GetPlaybook:input_type -> google.cloud.dialogflow.cx.v3.GetPlaybookRequest
	17, // 35: google.cloud.dialogflow.cx.v3.Playbooks.ExportPlaybook:input_type -> google.cloud.dialogflow.cx.v3.ExportPlaybookRequest
	18, // 36: google.cloud.dialogflow.cx.v3.Playbooks.ImportPlaybook:input_type -> google.cloud.dialogflow.cx.v3.ImportPlaybookRequest
	7,  // 37: google.cloud.dialogflow.cx.v3.Playbooks.UpdatePlaybook:input_type -> google.cloud.dialogflow.cx.v3.UpdatePlaybookRequest
	9,  // 38: google.cloud.dialogflow.cx.v3.Playbooks.CreatePlaybookVersion:input_type -> google.cloud.dialogflow.cx.v3.CreatePlaybookVersionRequest
	11, // 39: google.cloud.dialogflow.cx.v3.Playbooks.GetPlaybookVersion:input_type -> google.cloud.dialogflow.cx.v3.GetPlaybookVersionRequest
	12, // 40: google.cloud.dialogflow.cx.v3.Playbooks.RestorePlaybookVersion:input_type -> google.cloud.dialogflow.cx.v3.RestorePlaybookVersionRequest
	14, // 41: google.cloud.dialogflow.cx.v3.Playbooks.ListPlaybookVersions:input_type -> google.cloud.dialogflow.cx.v3.ListPlaybookVersionsRequest
	16, // 42: google.cloud.dialogflow.cx.v3.Playbooks.DeletePlaybookVersion:input_type -> google.cloud.dialogflow.cx.v3.DeletePlaybookVersionRequest
	8,  // 43: google.cloud.dialogflow.cx.v3.Playbooks.CreatePlaybook:output_type -> google.cloud.dialogflow.cx.v3.Playbook
	36, // 44: google.cloud.dialogflow.cx.v3.Playbooks.DeletePlaybook:output_type -> google.protobuf.Empty
	5,  // 45: google.cloud.dialogflow.cx.v3.Playbooks.ListPlaybooks:output_type -> google.cloud.dialogflow.cx.v3.ListPlaybooksResponse
	8,  // 46: google.cloud.dialogflow.cx.v3.Playbooks.GetPlaybook:output_type -> google.cloud.dialogflow.cx.v3.Playbook
	37, // 47: google.cloud.dialogflow.cx.v3.Playbooks.ExportPlaybook:output_type -> google.longrunning.Operation
	37, // 48: google.cloud.dialogflow.cx.v3.Playbooks.ImportPlaybook:output_type -> google.longrunning.Operation
	8,  // 49: google.cloud.dialogflow.cx.v3.Playbooks.UpdatePlaybook:output_type -> google.cloud.dialogflow.cx.v3.Playbook
	10, // 50: google.cloud.dialogflow.cx.v3.Playbooks.CreatePlaybookVersion:output_type -> google.cloud.dialogflow.cx.v3.PlaybookVersion
	10, // 51: google.cloud.dialogflow.cx.v3.Playbooks.GetPlaybookVersion:output_type -> google.cloud.dialogflow.cx.v3.PlaybookVersion
	13, // 52: google.cloud.dialogflow.cx.v3.Playbooks.RestorePlaybookVersion:output_type -> google.cloud.dialogflow.cx.v3.RestorePlaybookVersionResponse
	15, // 53: google.cloud.dialogflow.cx.v3.Playbooks.ListPlaybookVersions:output_type -> google.cloud.dialogflow.cx.v3.ListPlaybookVersionsResponse
	36, // 54: google.cloud.dialogflow.cx.v3.Playbooks.DeletePlaybookVersion:output_type -> google.protobuf.Empty
	43, // [43:55] is the sub-list for method output_type
	31, // [31:43] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3_playbook_proto_init() }
func file_google_cloud_dialogflow_cx_v3_playbook_proto_init() {
	if File_google_cloud_dialogflow_cx_v3_playbook_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3_code_block_proto_init()
	file_google_cloud_dialogflow_cx_v3_example_proto_init()
	file_google_cloud_dialogflow_cx_v3_fulfillment_proto_init()
	file_google_cloud_dialogflow_cx_v3_generative_settings_proto_init()
	file_google_cloud_dialogflow_cx_v3_import_strategy_proto_init()
	file_google_cloud_dialogflow_cx_v3_parameter_definition_proto_init()
	file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[16].OneofWrappers = []any{
		(*ImportPlaybookRequest_PlaybookUri)(nil),
		(*ImportPlaybookRequest_PlaybookContent)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[19].OneofWrappers = []any{
		(*ExportPlaybookResponse_PlaybookUri)(nil),
		(*ExportPlaybookResponse_PlaybookContent)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[20].OneofWrappers = []any{
		(*Handler_EventHandler_)(nil),
		(*Handler_LifecycleHandler_)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes[21].OneofWrappers = []any{
		(*Playbook_Step_Text)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3_playbook_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3_playbook_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3_playbook_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3_playbook_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3_playbook_proto = out.File
	file_google_cloud_dialogflow_cx_v3_playbook_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3_playbook_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3_playbook_proto_depIdxs = nil
}
