// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3/playbook.proto

package cxpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Playbooks_CreatePlaybook_FullMethodName         = "/google.cloud.dialogflow.cx.v3.Playbooks/CreatePlaybook"
	Playbooks_DeletePlaybook_FullMethodName         = "/google.cloud.dialogflow.cx.v3.Playbooks/DeletePlaybook"
	Playbooks_ListPlaybooks_FullMethodName          = "/google.cloud.dialogflow.cx.v3.Playbooks/ListPlaybooks"
	Playbooks_GetPlaybook_FullMethodName            = "/google.cloud.dialogflow.cx.v3.Playbooks/GetPlaybook"
	Playbooks_ExportPlaybook_FullMethodName         = "/google.cloud.dialogflow.cx.v3.Playbooks/ExportPlaybook"
	Playbooks_ImportPlaybook_FullMethodName         = "/google.cloud.dialogflow.cx.v3.Playbooks/ImportPlaybook"
	Playbooks_UpdatePlaybook_FullMethodName         = "/google.cloud.dialogflow.cx.v3.Playbooks/UpdatePlaybook"
	Playbooks_CreatePlaybookVersion_FullMethodName  = "/google.cloud.dialogflow.cx.v3.Playbooks/CreatePlaybookVersion"
	Playbooks_GetPlaybookVersion_FullMethodName     = "/google.cloud.dialogflow.cx.v3.Playbooks/GetPlaybookVersion"
	Playbooks_RestorePlaybookVersion_FullMethodName = "/google.cloud.dialogflow.cx.v3.Playbooks/RestorePlaybookVersion"
	Playbooks_ListPlaybookVersions_FullMethodName   = "/google.cloud.dialogflow.cx.v3.Playbooks/ListPlaybookVersions"
	Playbooks_DeletePlaybookVersion_FullMethodName  = "/google.cloud.dialogflow.cx.v3.Playbooks/DeletePlaybookVersion"
)

// PlaybooksClient is the client API for Playbooks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PlaybooksClient interface {
	// Creates a playbook in a specified agent.
	CreatePlaybook(ctx context.Context, in *CreatePlaybookRequest, opts ...grpc.CallOption) (*Playbook, error)
	// Deletes a specified playbook.
	DeletePlaybook(ctx context.Context, in *DeletePlaybookRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns a list of playbooks in the specified agent.
	ListPlaybooks(ctx context.Context, in *ListPlaybooksRequest, opts ...grpc.CallOption) (*ListPlaybooksResponse, error)
	// Retrieves the specified Playbook.
	GetPlaybook(ctx context.Context, in *GetPlaybookRequest, opts ...grpc.CallOption) (*Playbook, error)
	// Exports the specified playbook to a binary file.
	//
	// Note that resources (e.g. examples, tools) that the playbook
	// references will also be exported.
	ExportPlaybook(ctx context.Context, in *ExportPlaybookRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports the specified playbook to the specified agent from a binary file.
	ImportPlaybook(ctx context.Context, in *ImportPlaybookRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified Playbook.
	UpdatePlaybook(ctx context.Context, in *UpdatePlaybookRequest, opts ...grpc.CallOption) (*Playbook, error)
	// Creates a version for the specified Playbook.
	CreatePlaybookVersion(ctx context.Context, in *CreatePlaybookVersionRequest, opts ...grpc.CallOption) (*PlaybookVersion, error)
	// Retrieves the specified version of the Playbook.
	GetPlaybookVersion(ctx context.Context, in *GetPlaybookVersionRequest, opts ...grpc.CallOption) (*PlaybookVersion, error)
	// Retrieves the specified version of the Playbook and stores it as the
	// current playbook draft, returning the playbook with resources updated.
	RestorePlaybookVersion(ctx context.Context, in *RestorePlaybookVersionRequest, opts ...grpc.CallOption) (*RestorePlaybookVersionResponse, error)
	// Lists versions for the specified Playbook.
	ListPlaybookVersions(ctx context.Context, in *ListPlaybookVersionsRequest, opts ...grpc.CallOption) (*ListPlaybookVersionsResponse, error)
	// Deletes the specified version of the Playbook.
	DeletePlaybookVersion(ctx context.Context, in *DeletePlaybookVersionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type playbooksClient struct {
	cc grpc.ClientConnInterface
}

func NewPlaybooksClient(cc grpc.ClientConnInterface) PlaybooksClient {
	return &playbooksClient{cc}
}

func (c *playbooksClient) CreatePlaybook(ctx context.Context, in *CreatePlaybookRequest, opts ...grpc.CallOption) (*Playbook, error) {
	out := new(Playbook)
	err := c.cc.Invoke(ctx, Playbooks_CreatePlaybook_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) DeletePlaybook(ctx context.Context, in *DeletePlaybookRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Playbooks_DeletePlaybook_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) ListPlaybooks(ctx context.Context, in *ListPlaybooksRequest, opts ...grpc.CallOption) (*ListPlaybooksResponse, error) {
	out := new(ListPlaybooksResponse)
	err := c.cc.Invoke(ctx, Playbooks_ListPlaybooks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) GetPlaybook(ctx context.Context, in *GetPlaybookRequest, opts ...grpc.CallOption) (*Playbook, error) {
	out := new(Playbook)
	err := c.cc.Invoke(ctx, Playbooks_GetPlaybook_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) ExportPlaybook(ctx context.Context, in *ExportPlaybookRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Playbooks_ExportPlaybook_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) ImportPlaybook(ctx context.Context, in *ImportPlaybookRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Playbooks_ImportPlaybook_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) UpdatePlaybook(ctx context.Context, in *UpdatePlaybookRequest, opts ...grpc.CallOption) (*Playbook, error) {
	out := new(Playbook)
	err := c.cc.Invoke(ctx, Playbooks_UpdatePlaybook_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) CreatePlaybookVersion(ctx context.Context, in *CreatePlaybookVersionRequest, opts ...grpc.CallOption) (*PlaybookVersion, error) {
	out := new(PlaybookVersion)
	err := c.cc.Invoke(ctx, Playbooks_CreatePlaybookVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) GetPlaybookVersion(ctx context.Context, in *GetPlaybookVersionRequest, opts ...grpc.CallOption) (*PlaybookVersion, error) {
	out := new(PlaybookVersion)
	err := c.cc.Invoke(ctx, Playbooks_GetPlaybookVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) RestorePlaybookVersion(ctx context.Context, in *RestorePlaybookVersionRequest, opts ...grpc.CallOption) (*RestorePlaybookVersionResponse, error) {
	out := new(RestorePlaybookVersionResponse)
	err := c.cc.Invoke(ctx, Playbooks_RestorePlaybookVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) ListPlaybookVersions(ctx context.Context, in *ListPlaybookVersionsRequest, opts ...grpc.CallOption) (*ListPlaybookVersionsResponse, error) {
	out := new(ListPlaybookVersionsResponse)
	err := c.cc.Invoke(ctx, Playbooks_ListPlaybookVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) DeletePlaybookVersion(ctx context.Context, in *DeletePlaybookVersionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Playbooks_DeletePlaybookVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PlaybooksServer is the server API for Playbooks service.
// All implementations should embed UnimplementedPlaybooksServer
// for forward compatibility
type PlaybooksServer interface {
	// Creates a playbook in a specified agent.
	CreatePlaybook(context.Context, *CreatePlaybookRequest) (*Playbook, error)
	// Deletes a specified playbook.
	DeletePlaybook(context.Context, *DeletePlaybookRequest) (*emptypb.Empty, error)
	// Returns a list of playbooks in the specified agent.
	ListPlaybooks(context.Context, *ListPlaybooksRequest) (*ListPlaybooksResponse, error)
	// Retrieves the specified Playbook.
	GetPlaybook(context.Context, *GetPlaybookRequest) (*Playbook, error)
	// Exports the specified playbook to a binary file.
	//
	// Note that resources (e.g. examples, tools) that the playbook
	// references will also be exported.
	ExportPlaybook(context.Context, *ExportPlaybookRequest) (*longrunningpb.Operation, error)
	// Imports the specified playbook to the specified agent from a binary file.
	ImportPlaybook(context.Context, *ImportPlaybookRequest) (*longrunningpb.Operation, error)
	// Updates the specified Playbook.
	UpdatePlaybook(context.Context, *UpdatePlaybookRequest) (*Playbook, error)
	// Creates a version for the specified Playbook.
	CreatePlaybookVersion(context.Context, *CreatePlaybookVersionRequest) (*PlaybookVersion, error)
	// Retrieves the specified version of the Playbook.
	GetPlaybookVersion(context.Context, *GetPlaybookVersionRequest) (*PlaybookVersion, error)
	// Retrieves the specified version of the Playbook and stores it as the
	// current playbook draft, returning the playbook with resources updated.
	RestorePlaybookVersion(context.Context, *RestorePlaybookVersionRequest) (*RestorePlaybookVersionResponse, error)
	// Lists versions for the specified Playbook.
	ListPlaybookVersions(context.Context, *ListPlaybookVersionsRequest) (*ListPlaybookVersionsResponse, error)
	// Deletes the specified version of the Playbook.
	DeletePlaybookVersion(context.Context, *DeletePlaybookVersionRequest) (*emptypb.Empty, error)
}

// UnimplementedPlaybooksServer should be embedded to have forward compatible implementations.
type UnimplementedPlaybooksServer struct {
}

func (UnimplementedPlaybooksServer) CreatePlaybook(context.Context, *CreatePlaybookRequest) (*Playbook, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePlaybook not implemented")
}
func (UnimplementedPlaybooksServer) DeletePlaybook(context.Context, *DeletePlaybookRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePlaybook not implemented")
}
func (UnimplementedPlaybooksServer) ListPlaybooks(context.Context, *ListPlaybooksRequest) (*ListPlaybooksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlaybooks not implemented")
}
func (UnimplementedPlaybooksServer) GetPlaybook(context.Context, *GetPlaybookRequest) (*Playbook, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPlaybook not implemented")
}
func (UnimplementedPlaybooksServer) ExportPlaybook(context.Context, *ExportPlaybookRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportPlaybook not implemented")
}
func (UnimplementedPlaybooksServer) ImportPlaybook(context.Context, *ImportPlaybookRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportPlaybook not implemented")
}
func (UnimplementedPlaybooksServer) UpdatePlaybook(context.Context, *UpdatePlaybookRequest) (*Playbook, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePlaybook not implemented")
}
func (UnimplementedPlaybooksServer) CreatePlaybookVersion(context.Context, *CreatePlaybookVersionRequest) (*PlaybookVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePlaybookVersion not implemented")
}
func (UnimplementedPlaybooksServer) GetPlaybookVersion(context.Context, *GetPlaybookVersionRequest) (*PlaybookVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPlaybookVersion not implemented")
}
func (UnimplementedPlaybooksServer) RestorePlaybookVersion(context.Context, *RestorePlaybookVersionRequest) (*RestorePlaybookVersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestorePlaybookVersion not implemented")
}
func (UnimplementedPlaybooksServer) ListPlaybookVersions(context.Context, *ListPlaybookVersionsRequest) (*ListPlaybookVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlaybookVersions not implemented")
}
func (UnimplementedPlaybooksServer) DeletePlaybookVersion(context.Context, *DeletePlaybookVersionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePlaybookVersion not implemented")
}

// UnsafePlaybooksServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PlaybooksServer will
// result in compilation errors.
type UnsafePlaybooksServer interface {
	mustEmbedUnimplementedPlaybooksServer()
}

func RegisterPlaybooksServer(s grpc.ServiceRegistrar, srv PlaybooksServer) {
	s.RegisterService(&Playbooks_ServiceDesc, srv)
}

func _Playbooks_CreatePlaybook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePlaybookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).CreatePlaybook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_CreatePlaybook_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).CreatePlaybook(ctx, req.(*CreatePlaybookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_DeletePlaybook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePlaybookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).DeletePlaybook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_DeletePlaybook_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).DeletePlaybook(ctx, req.(*DeletePlaybookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_ListPlaybooks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlaybooksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).ListPlaybooks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_ListPlaybooks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).ListPlaybooks(ctx, req.(*ListPlaybooksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_GetPlaybook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPlaybookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).GetPlaybook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_GetPlaybook_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).GetPlaybook(ctx, req.(*GetPlaybookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_ExportPlaybook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportPlaybookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).ExportPlaybook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_ExportPlaybook_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).ExportPlaybook(ctx, req.(*ExportPlaybookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_ImportPlaybook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportPlaybookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).ImportPlaybook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_ImportPlaybook_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).ImportPlaybook(ctx, req.(*ImportPlaybookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_UpdatePlaybook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePlaybookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).UpdatePlaybook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_UpdatePlaybook_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).UpdatePlaybook(ctx, req.(*UpdatePlaybookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_CreatePlaybookVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePlaybookVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).CreatePlaybookVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_CreatePlaybookVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).CreatePlaybookVersion(ctx, req.(*CreatePlaybookVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_GetPlaybookVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPlaybookVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).GetPlaybookVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_GetPlaybookVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).GetPlaybookVersion(ctx, req.(*GetPlaybookVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_RestorePlaybookVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestorePlaybookVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).RestorePlaybookVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_RestorePlaybookVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).RestorePlaybookVersion(ctx, req.(*RestorePlaybookVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_ListPlaybookVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlaybookVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).ListPlaybookVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_ListPlaybookVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).ListPlaybookVersions(ctx, req.(*ListPlaybookVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_DeletePlaybookVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePlaybookVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).DeletePlaybookVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Playbooks_DeletePlaybookVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).DeletePlaybookVersion(ctx, req.(*DeletePlaybookVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Playbooks_ServiceDesc is the grpc.ServiceDesc for Playbooks service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Playbooks_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3.Playbooks",
	HandlerType: (*PlaybooksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePlaybook",
			Handler:    _Playbooks_CreatePlaybook_Handler,
		},
		{
			MethodName: "DeletePlaybook",
			Handler:    _Playbooks_DeletePlaybook_Handler,
		},
		{
			MethodName: "ListPlaybooks",
			Handler:    _Playbooks_ListPlaybooks_Handler,
		},
		{
			MethodName: "GetPlaybook",
			Handler:    _Playbooks_GetPlaybook_Handler,
		},
		{
			MethodName: "ExportPlaybook",
			Handler:    _Playbooks_ExportPlaybook_Handler,
		},
		{
			MethodName: "ImportPlaybook",
			Handler:    _Playbooks_ImportPlaybook_Handler,
		},
		{
			MethodName: "UpdatePlaybook",
			Handler:    _Playbooks_UpdatePlaybook_Handler,
		},
		{
			MethodName: "CreatePlaybookVersion",
			Handler:    _Playbooks_CreatePlaybookVersion_Handler,
		},
		{
			MethodName: "GetPlaybookVersion",
			Handler:    _Playbooks_GetPlaybookVersion_Handler,
		},
		{
			MethodName: "RestorePlaybookVersion",
			Handler:    _Playbooks_RestorePlaybookVersion_Handler,
		},
		{
			MethodName: "ListPlaybookVersions",
			Handler:    _Playbooks_ListPlaybookVersions_Handler,
		},
		{
			MethodName: "DeletePlaybookVersion",
			Handler:    _Playbooks_DeletePlaybookVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3/playbook.proto",
}
