// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/cx/v3/tool_call.proto

package cxpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents a call of a specific tool's action with the specified inputs.
type ToolCall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [tool][google.cloud.dialogflow.cx.v3.Tool] associated with
	// this call. Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>`.
	Tool string `protobuf:"bytes,1,opt,name=tool,proto3" json:"tool,omitempty"`
	// Required. The name of the tool's action associated with this call.
	Action string `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
	// Optional. The action's input parameters.
	InputParameters *structpb.Struct `protobuf:"bytes,3,opt,name=input_parameters,json=inputParameters,proto3" json:"input_parameters,omitempty"`
}

func (x *ToolCall) Reset() {
	*x = ToolCall{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_call_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolCall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolCall) ProtoMessage() {}

func (x *ToolCall) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_call_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolCall.ProtoReflect.Descriptor instead.
func (*ToolCall) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDescGZIP(), []int{0}
}

func (x *ToolCall) GetTool() string {
	if x != nil {
		return x.Tool
	}
	return ""
}

func (x *ToolCall) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *ToolCall) GetInputParameters() *structpb.Struct {
	if x != nil {
		return x.InputParameters
	}
	return nil
}

// The result of calling a tool's action that has been executed by the client.
type ToolCallResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [tool][google.cloud.dialogflow.cx.v3.Tool] associated with
	// this call. Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>`.
	Tool string `protobuf:"bytes,1,opt,name=tool,proto3" json:"tool,omitempty"`
	// Required. The name of the tool's action associated with this call.
	Action string `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
	// The tool call's result.
	//
	// Types that are assignable to Result:
	//
	//	*ToolCallResult_Error_
	//	*ToolCallResult_OutputParameters
	Result isToolCallResult_Result `protobuf_oneof:"result"`
}

func (x *ToolCallResult) Reset() {
	*x = ToolCallResult{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_call_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolCallResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolCallResult) ProtoMessage() {}

func (x *ToolCallResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_call_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolCallResult.ProtoReflect.Descriptor instead.
func (*ToolCallResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDescGZIP(), []int{1}
}

func (x *ToolCallResult) GetTool() string {
	if x != nil {
		return x.Tool
	}
	return ""
}

func (x *ToolCallResult) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (m *ToolCallResult) GetResult() isToolCallResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *ToolCallResult) GetError() *ToolCallResult_Error {
	if x, ok := x.GetResult().(*ToolCallResult_Error_); ok {
		return x.Error
	}
	return nil
}

func (x *ToolCallResult) GetOutputParameters() *structpb.Struct {
	if x, ok := x.GetResult().(*ToolCallResult_OutputParameters); ok {
		return x.OutputParameters
	}
	return nil
}

type isToolCallResult_Result interface {
	isToolCallResult_Result()
}

type ToolCallResult_Error_ struct {
	// The tool call's error.
	Error *ToolCallResult_Error `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

type ToolCallResult_OutputParameters struct {
	// The tool call's output parameters.
	OutputParameters *structpb.Struct `protobuf:"bytes,4,opt,name=output_parameters,json=outputParameters,proto3,oneof"`
}

func (*ToolCallResult_Error_) isToolCallResult_Result() {}

func (*ToolCallResult_OutputParameters) isToolCallResult_Result() {}

// An error produced by the tool call.
type ToolCallResult_Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The error message of the function.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *ToolCallResult_Error) Reset() {
	*x = ToolCallResult_Error{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_call_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolCallResult_Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolCallResult_Error) ProtoMessage() {}

func (x *ToolCallResult_Error) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_call_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolCallResult_Error.ProtoReflect.Descriptor instead.
func (*ToolCallResult_Error) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ToolCallResult_Error) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_google_cloud_dialogflow_cx_v3_tool_call_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xac, 0x01, 0x0a, 0x08, 0x54, 0x6f, 0x6f,
	0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x12, 0x3a, 0x0a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x74, 0x6f, 0x6f,
	0x6c, 0x12, 0x1b, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47,
	0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xb0, 0x02, 0x0a, 0x0e, 0x54, 0x6f, 0x6f, 0x6c,
	0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x74, 0x6f,
	0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20,
	0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c,
	0x52, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x1b, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x46, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x48, 0x00, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x26, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x1d, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0xb0, 0x01, 0x0a, 0x21, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x42, 0x0d, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x31, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b,
	0x63, 0x78, 0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDescData = file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3_tool_call_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_dialogflow_cx_v3_tool_call_proto_goTypes = []any{
	(*ToolCall)(nil),             // 0: google.cloud.dialogflow.cx.v3.ToolCall
	(*ToolCallResult)(nil),       // 1: google.cloud.dialogflow.cx.v3.ToolCallResult
	(*ToolCallResult_Error)(nil), // 2: google.cloud.dialogflow.cx.v3.ToolCallResult.Error
	(*structpb.Struct)(nil),      // 3: google.protobuf.Struct
}
var file_google_cloud_dialogflow_cx_v3_tool_call_proto_depIdxs = []int32{
	3, // 0: google.cloud.dialogflow.cx.v3.ToolCall.input_parameters:type_name -> google.protobuf.Struct
	2, // 1: google.cloud.dialogflow.cx.v3.ToolCallResult.error:type_name -> google.cloud.dialogflow.cx.v3.ToolCallResult.Error
	3, // 2: google.cloud.dialogflow.cx.v3.ToolCallResult.output_parameters:type_name -> google.protobuf.Struct
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3_tool_call_proto_init() }
func file_google_cloud_dialogflow_cx_v3_tool_call_proto_init() {
	if File_google_cloud_dialogflow_cx_v3_tool_call_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3_tool_call_proto_msgTypes[1].OneofWrappers = []any{
		(*ToolCallResult_Error_)(nil),
		(*ToolCallResult_OutputParameters)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3_tool_call_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3_tool_call_proto_depIdxs,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3_tool_call_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3_tool_call_proto = out.File
	file_google_cloud_dialogflow_cx_v3_tool_call_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3_tool_call_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3_tool_call_proto_depIdxs = nil
}
