// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/cx/v3/trace.proto

package cxpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Output state.
type OutputState int32

const (
	// Unspecified output.
	OutputState_OUTPUT_STATE_UNSPECIFIED OutputState = 0
	// Succeeded.
	OutputState_OUTPUT_STATE_OK OutputState = 1
	// Cancelled.
	OutputState_OUTPUT_STATE_CANCELLED OutputState = 2
	// Failed.
	OutputState_OUTPUT_STATE_FAILED OutputState = 3
	// Escalated.
	OutputState_OUTPUT_STATE_ESCALATED OutputState = 4
	// Pending.
	OutputState_OUTPUT_STATE_PENDING OutputState = 5
)

// Enum value maps for OutputState.
var (
	OutputState_name = map[int32]string{
		0: "OUTPUT_STATE_UNSPECIFIED",
		1: "OUTPUT_STATE_OK",
		2: "OUTPUT_STATE_CANCELLED",
		3: "OUTPUT_STATE_FAILED",
		4: "OUTPUT_STATE_ESCALATED",
		5: "OUTPUT_STATE_PENDING",
	}
	OutputState_value = map[string]int32{
		"OUTPUT_STATE_UNSPECIFIED": 0,
		"OUTPUT_STATE_OK":          1,
		"OUTPUT_STATE_CANCELLED":   2,
		"OUTPUT_STATE_FAILED":      3,
		"OUTPUT_STATE_ESCALATED":   4,
		"OUTPUT_STATE_PENDING":     5,
	}
)

func (x OutputState) Enum() *OutputState {
	p := new(OutputState)
	*p = x
	return p
}

func (x OutputState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutputState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_enumTypes[0].Descriptor()
}

func (OutputState) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_trace_proto_enumTypes[0]
}

func (x OutputState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutputState.Descriptor instead.
func (OutputState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP(), []int{0}
}

// Input of the playbook.
type PlaybookInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Summary string of the preceding conversation for the child
	// playbook invocation.
	PrecedingConversationSummary string `protobuf:"bytes,1,opt,name=preceding_conversation_summary,json=precedingConversationSummary,proto3" json:"preceding_conversation_summary,omitempty"`
}

func (x *PlaybookInput) Reset() {
	*x = PlaybookInput{}
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaybookInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaybookInput) ProtoMessage() {}

func (x *PlaybookInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaybookInput.ProtoReflect.Descriptor instead.
func (*PlaybookInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP(), []int{0}
}

func (x *PlaybookInput) GetPrecedingConversationSummary() string {
	if x != nil {
		return x.PrecedingConversationSummary
	}
	return ""
}

// Output of the playbook.
type PlaybookOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Summary string of the execution result of the child playbook.
	ExecutionSummary string `protobuf:"bytes,1,opt,name=execution_summary,json=executionSummary,proto3" json:"execution_summary,omitempty"`
}

func (x *PlaybookOutput) Reset() {
	*x = PlaybookOutput{}
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaybookOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaybookOutput) ProtoMessage() {}

func (x *PlaybookOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaybookOutput.ProtoReflect.Descriptor instead.
func (*PlaybookOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP(), []int{1}
}

func (x *PlaybookOutput) GetExecutionSummary() string {
	if x != nil {
		return x.ExecutionSummary
	}
	return ""
}

// Action performed by end user or Dialogflow agent in the conversation.
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Action details.
	//
	// Types that are assignable to Action:
	//
	//	*Action_UserUtterance
	//	*Action_AgentUtterance
	//	*Action_ToolUse
	//	*Action_PlaybookInvocation
	//	*Action_FlowInvocation
	//	*Action_PlaybookTransition
	//	*Action_FlowTransition
	Action isAction_Action `protobuf_oneof:"action"`
}

func (x *Action) Reset() {
	*x = Action{}
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP(), []int{2}
}

func (m *Action) GetAction() isAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *Action) GetUserUtterance() *UserUtterance {
	if x, ok := x.GetAction().(*Action_UserUtterance); ok {
		return x.UserUtterance
	}
	return nil
}

func (x *Action) GetAgentUtterance() *AgentUtterance {
	if x, ok := x.GetAction().(*Action_AgentUtterance); ok {
		return x.AgentUtterance
	}
	return nil
}

func (x *Action) GetToolUse() *ToolUse {
	if x, ok := x.GetAction().(*Action_ToolUse); ok {
		return x.ToolUse
	}
	return nil
}

func (x *Action) GetPlaybookInvocation() *PlaybookInvocation {
	if x, ok := x.GetAction().(*Action_PlaybookInvocation); ok {
		return x.PlaybookInvocation
	}
	return nil
}

func (x *Action) GetFlowInvocation() *FlowInvocation {
	if x, ok := x.GetAction().(*Action_FlowInvocation); ok {
		return x.FlowInvocation
	}
	return nil
}

func (x *Action) GetPlaybookTransition() *PlaybookTransition {
	if x, ok := x.GetAction().(*Action_PlaybookTransition); ok {
		return x.PlaybookTransition
	}
	return nil
}

func (x *Action) GetFlowTransition() *FlowTransition {
	if x, ok := x.GetAction().(*Action_FlowTransition); ok {
		return x.FlowTransition
	}
	return nil
}

type isAction_Action interface {
	isAction_Action()
}

type Action_UserUtterance struct {
	// Optional. Agent obtained a message from the customer.
	UserUtterance *UserUtterance `protobuf:"bytes,1,opt,name=user_utterance,json=userUtterance,proto3,oneof"`
}

type Action_AgentUtterance struct {
	// Optional. Action performed by the agent as a message.
	AgentUtterance *AgentUtterance `protobuf:"bytes,2,opt,name=agent_utterance,json=agentUtterance,proto3,oneof"`
}

type Action_ToolUse struct {
	// Optional. Action performed on behalf of the agent by calling a plugin
	// tool.
	ToolUse *ToolUse `protobuf:"bytes,3,opt,name=tool_use,json=toolUse,proto3,oneof"`
}

type Action_PlaybookInvocation struct {
	// Optional. Action performed on behalf of the agent by invoking a child
	// playbook.
	PlaybookInvocation *PlaybookInvocation `protobuf:"bytes,4,opt,name=playbook_invocation,json=playbookInvocation,proto3,oneof"`
}

type Action_FlowInvocation struct {
	// Optional. Action performed on behalf of the agent by invoking a CX flow.
	FlowInvocation *FlowInvocation `protobuf:"bytes,5,opt,name=flow_invocation,json=flowInvocation,proto3,oneof"`
}

type Action_PlaybookTransition struct {
	// Optional. Action performed on behalf of the agent by transitioning to a
	// target playbook.
	PlaybookTransition *PlaybookTransition `protobuf:"bytes,12,opt,name=playbook_transition,json=playbookTransition,proto3,oneof"`
}

type Action_FlowTransition struct {
	// Optional. Action performed on behalf of the agent by transitioning to a
	// target CX flow.
	FlowTransition *FlowTransition `protobuf:"bytes,13,opt,name=flow_transition,json=flowTransition,proto3,oneof"`
}

func (*Action_UserUtterance) isAction_Action() {}

func (*Action_AgentUtterance) isAction_Action() {}

func (*Action_ToolUse) isAction_Action() {}

func (*Action_PlaybookInvocation) isAction_Action() {}

func (*Action_FlowInvocation) isAction_Action() {}

func (*Action_PlaybookTransition) isAction_Action() {}

func (*Action_FlowTransition) isAction_Action() {}

// UserUtterance represents one message sent by the customer.
type UserUtterance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Message content in text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *UserUtterance) Reset() {
	*x = UserUtterance{}
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserUtterance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserUtterance) ProtoMessage() {}

func (x *UserUtterance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserUtterance.ProtoReflect.Descriptor instead.
func (*UserUtterance) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP(), []int{3}
}

func (x *UserUtterance) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// AgentUtterance represents one message sent by the agent.
type AgentUtterance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Message content in text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *AgentUtterance) Reset() {
	*x = AgentUtterance{}
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentUtterance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentUtterance) ProtoMessage() {}

func (x *AgentUtterance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentUtterance.ProtoReflect.Descriptor instead.
func (*AgentUtterance) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP(), []int{4}
}

func (x *AgentUtterance) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// Stores metadata of the invocation of an action supported by a tool.
type ToolUse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [tool][google.cloud.dialogflow.cx.v3.Tool] that should be
	// used. Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>`.
	Tool string `protobuf:"bytes,1,opt,name=tool,proto3" json:"tool,omitempty"`
	// Output only. The display name of the tool.
	DisplayName string `protobuf:"bytes,8,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Name of the action to be called during the tool use.
	Action string `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
	// Optional. A list of input parameters for the action.
	InputActionParameters *structpb.Struct `protobuf:"bytes,5,opt,name=input_action_parameters,json=inputActionParameters,proto3" json:"input_action_parameters,omitempty"`
	// Optional. A list of output parameters generated by the action.
	OutputActionParameters *structpb.Struct `protobuf:"bytes,6,opt,name=output_action_parameters,json=outputActionParameters,proto3" json:"output_action_parameters,omitempty"`
}

func (x *ToolUse) Reset() {
	*x = ToolUse{}
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolUse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolUse) ProtoMessage() {}

func (x *ToolUse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolUse.ProtoReflect.Descriptor instead.
func (*ToolUse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP(), []int{5}
}

func (x *ToolUse) GetTool() string {
	if x != nil {
		return x.Tool
	}
	return ""
}

func (x *ToolUse) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ToolUse) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *ToolUse) GetInputActionParameters() *structpb.Struct {
	if x != nil {
		return x.InputActionParameters
	}
	return nil
}

func (x *ToolUse) GetOutputActionParameters() *structpb.Struct {
	if x != nil {
		return x.OutputActionParameters
	}
	return nil
}

// Stores metadata of the invocation of a child playbook.
type PlaybookInvocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the playbook.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Playbook string `protobuf:"bytes,1,opt,name=playbook,proto3" json:"playbook,omitempty"`
	// Output only. The display name of the playbook.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Input of the child playbook invocation.
	PlaybookInput *PlaybookInput `protobuf:"bytes,2,opt,name=playbook_input,json=playbookInput,proto3" json:"playbook_input,omitempty"`
	// Optional. Output of the child playbook invocation.
	PlaybookOutput *PlaybookOutput `protobuf:"bytes,3,opt,name=playbook_output,json=playbookOutput,proto3" json:"playbook_output,omitempty"`
	// Required. Playbook invocation's output state.
	PlaybookState OutputState `protobuf:"varint,4,opt,name=playbook_state,json=playbookState,proto3,enum=google.cloud.dialogflow.cx.v3.OutputState" json:"playbook_state,omitempty"`
}

func (x *PlaybookInvocation) Reset() {
	*x = PlaybookInvocation{}
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaybookInvocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaybookInvocation) ProtoMessage() {}

func (x *PlaybookInvocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaybookInvocation.ProtoReflect.Descriptor instead.
func (*PlaybookInvocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP(), []int{6}
}

func (x *PlaybookInvocation) GetPlaybook() string {
	if x != nil {
		return x.Playbook
	}
	return ""
}

func (x *PlaybookInvocation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PlaybookInvocation) GetPlaybookInput() *PlaybookInput {
	if x != nil {
		return x.PlaybookInput
	}
	return nil
}

func (x *PlaybookInvocation) GetPlaybookOutput() *PlaybookOutput {
	if x != nil {
		return x.PlaybookOutput
	}
	return nil
}

func (x *PlaybookInvocation) GetPlaybookState() OutputState {
	if x != nil {
		return x.PlaybookState
	}
	return OutputState_OUTPUT_STATE_UNSPECIFIED
}

// Stores metadata of the invocation of a CX flow.
type FlowInvocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the flow.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>`.
	Flow string `protobuf:"bytes,1,opt,name=flow,proto3" json:"flow,omitempty"`
	// Output only. The display name of the flow.
	DisplayName string `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Flow invocation's output state.
	FlowState OutputState `protobuf:"varint,4,opt,name=flow_state,json=flowState,proto3,enum=google.cloud.dialogflow.cx.v3.OutputState" json:"flow_state,omitempty"`
}

func (x *FlowInvocation) Reset() {
	*x = FlowInvocation{}
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowInvocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowInvocation) ProtoMessage() {}

func (x *FlowInvocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowInvocation.ProtoReflect.Descriptor instead.
func (*FlowInvocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP(), []int{7}
}

func (x *FlowInvocation) GetFlow() string {
	if x != nil {
		return x.Flow
	}
	return ""
}

func (x *FlowInvocation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *FlowInvocation) GetFlowState() OutputState {
	if x != nil {
		return x.FlowState
	}
	return OutputState_OUTPUT_STATE_UNSPECIFIED
}

// Stores metadata of the transition to another target playbook. Playbook
// transition actions exit the caller playbook and enter the target playbook.
type PlaybookTransition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the playbook.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Playbook string `protobuf:"bytes,1,opt,name=playbook,proto3" json:"playbook,omitempty"`
	// Output only. The display name of the playbook.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *PlaybookTransition) Reset() {
	*x = PlaybookTransition{}
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaybookTransition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaybookTransition) ProtoMessage() {}

func (x *PlaybookTransition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaybookTransition.ProtoReflect.Descriptor instead.
func (*PlaybookTransition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP(), []int{8}
}

func (x *PlaybookTransition) GetPlaybook() string {
	if x != nil {
		return x.Playbook
	}
	return ""
}

func (x *PlaybookTransition) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Stores metadata of the transition to a target CX flow. Flow transition
// actions exit the caller playbook and enter the child flow.
type FlowTransition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the flow.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<Agentflows/<FlowID>`.
	Flow string `protobuf:"bytes,1,opt,name=flow,proto3" json:"flow,omitempty"`
	// Output only. The display name of the flow.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *FlowTransition) Reset() {
	*x = FlowTransition{}
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowTransition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowTransition) ProtoMessage() {}

func (x *FlowTransition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowTransition.ProtoReflect.Descriptor instead.
func (*FlowTransition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP(), []int{9}
}

func (x *FlowTransition) GetFlow() string {
	if x != nil {
		return x.Flow
	}
	return ""
}

func (x *FlowTransition) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

var File_google_cloud_dialogflow_cx_v3_trace_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3_trace_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5a, 0x0a, 0x0d, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x49, 0x0a, 0x1e, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x1c, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x22, 0x42, 0x0a, 0x0e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x12, 0x30, 0x0a, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x22, 0xab, 0x05, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5a, 0x0a, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x75, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x55, 0x74, 0x74, 0x65,
	0x72, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x75, 0x73,
	0x65, 0x72, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x0f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61,
	0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x74, 0x6f,
	0x6f, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f,
	0x6c, 0x55, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x07, 0x74, 0x6f, 0x6f,
	0x6c, 0x55, 0x73, 0x65, 0x12, 0x69, 0x0a, 0x13, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5d, 0x0a, 0x0f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e,
	0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69,
	0x0a, 0x13, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0f, 0x66, 0x6c, 0x6f,
	0x77, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x66, 0x6c, 0x6f, 0x77, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x28, 0x0a, 0x0d, 0x55, 0x73, 0x65, 0x72, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x22, 0x29, 0x0a, 0x0e,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x22, 0xb8, 0x02, 0x0a, 0x07, 0x54, 0x6f, 0x6f, 0x6c,
	0x55, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x17, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x15, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x56, 0x0a, 0x18, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x22, 0x93, 0x03, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x08, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x5b, 0x0a, 0x0f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x12, 0x56, 0x0a, 0x0e, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x0e, 0x46, 0x6c, 0x6f,
	0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x04, 0x66,
	0x6c, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f,
	0x77, 0x52, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x4e, 0x0a, 0x0a, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x6c, 0x6f, 0x77, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22,
	0x84, 0x01, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24,
	0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x74, 0x0a, 0x0e, 0x46, 0x6c, 0x6f, 0x77, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x04, 0x66, 0x6c, 0x6f, 0x77,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x04,
	0x66, 0x6c, 0x6f, 0x77, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x2a, 0xab, 0x01, 0x0a,
	0x0b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x18,
	0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4f, 0x55,
	0x54, 0x50, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x4b, 0x10, 0x01, 0x12,
	0x1a, 0x0a, 0x16, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x4f,
	0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x1a, 0x0a, 0x16, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x45, 0x53, 0x43, 0x41, 0x4c, 0x41, 0x54, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x18, 0x0a, 0x14, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x42, 0xad, 0x01, 0x0a, 0x21, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x42, 0x0a, 0x54, 0x72, 0x61, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x31,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63,
	0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70,
	0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescData = file_google_cloud_dialogflow_cx_v3_trace_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3_trace_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3_trace_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_dialogflow_cx_v3_trace_proto_goTypes = []any{
	(OutputState)(0),           // 0: google.cloud.dialogflow.cx.v3.OutputState
	(*PlaybookInput)(nil),      // 1: google.cloud.dialogflow.cx.v3.PlaybookInput
	(*PlaybookOutput)(nil),     // 2: google.cloud.dialogflow.cx.v3.PlaybookOutput
	(*Action)(nil),             // 3: google.cloud.dialogflow.cx.v3.Action
	(*UserUtterance)(nil),      // 4: google.cloud.dialogflow.cx.v3.UserUtterance
	(*AgentUtterance)(nil),     // 5: google.cloud.dialogflow.cx.v3.AgentUtterance
	(*ToolUse)(nil),            // 6: google.cloud.dialogflow.cx.v3.ToolUse
	(*PlaybookInvocation)(nil), // 7: google.cloud.dialogflow.cx.v3.PlaybookInvocation
	(*FlowInvocation)(nil),     // 8: google.cloud.dialogflow.cx.v3.FlowInvocation
	(*PlaybookTransition)(nil), // 9: google.cloud.dialogflow.cx.v3.PlaybookTransition
	(*FlowTransition)(nil),     // 10: google.cloud.dialogflow.cx.v3.FlowTransition
	(*structpb.Struct)(nil),    // 11: google.protobuf.Struct
}
var file_google_cloud_dialogflow_cx_v3_trace_proto_depIdxs = []int32{
	4,  // 0: google.cloud.dialogflow.cx.v3.Action.user_utterance:type_name -> google.cloud.dialogflow.cx.v3.UserUtterance
	5,  // 1: google.cloud.dialogflow.cx.v3.Action.agent_utterance:type_name -> google.cloud.dialogflow.cx.v3.AgentUtterance
	6,  // 2: google.cloud.dialogflow.cx.v3.Action.tool_use:type_name -> google.cloud.dialogflow.cx.v3.ToolUse
	7,  // 3: google.cloud.dialogflow.cx.v3.Action.playbook_invocation:type_name -> google.cloud.dialogflow.cx.v3.PlaybookInvocation
	8,  // 4: google.cloud.dialogflow.cx.v3.Action.flow_invocation:type_name -> google.cloud.dialogflow.cx.v3.FlowInvocation
	9,  // 5: google.cloud.dialogflow.cx.v3.Action.playbook_transition:type_name -> google.cloud.dialogflow.cx.v3.PlaybookTransition
	10, // 6: google.cloud.dialogflow.cx.v3.Action.flow_transition:type_name -> google.cloud.dialogflow.cx.v3.FlowTransition
	11, // 7: google.cloud.dialogflow.cx.v3.ToolUse.input_action_parameters:type_name -> google.protobuf.Struct
	11, // 8: google.cloud.dialogflow.cx.v3.ToolUse.output_action_parameters:type_name -> google.protobuf.Struct
	1,  // 9: google.cloud.dialogflow.cx.v3.PlaybookInvocation.playbook_input:type_name -> google.cloud.dialogflow.cx.v3.PlaybookInput
	2,  // 10: google.cloud.dialogflow.cx.v3.PlaybookInvocation.playbook_output:type_name -> google.cloud.dialogflow.cx.v3.PlaybookOutput
	0,  // 11: google.cloud.dialogflow.cx.v3.PlaybookInvocation.playbook_state:type_name -> google.cloud.dialogflow.cx.v3.OutputState
	0,  // 12: google.cloud.dialogflow.cx.v3.FlowInvocation.flow_state:type_name -> google.cloud.dialogflow.cx.v3.OutputState
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3_trace_proto_init() }
func file_google_cloud_dialogflow_cx_v3_trace_proto_init() {
	if File_google_cloud_dialogflow_cx_v3_trace_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes[2].OneofWrappers = []any{
		(*Action_UserUtterance)(nil),
		(*Action_AgentUtterance)(nil),
		(*Action_ToolUse)(nil),
		(*Action_PlaybookInvocation)(nil),
		(*Action_FlowInvocation)(nil),
		(*Action_PlaybookTransition)(nil),
		(*Action_FlowTransition)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3_trace_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3_trace_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3_trace_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3_trace_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3_trace_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3_trace_proto = out.File
	file_google_cloud_dialogflow_cx_v3_trace_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3_trace_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3_trace_proto_depIdxs = nil
}
