// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/example.proto

package cxpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Examples_CreateExample_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Examples/CreateExample"
	Examples_DeleteExample_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Examples/DeleteExample"
	Examples_ListExamples_FullMethodName  = "/google.cloud.dialogflow.cx.v3beta1.Examples/ListExamples"
	Examples_GetExample_FullMethodName    = "/google.cloud.dialogflow.cx.v3beta1.Examples/GetExample"
	Examples_UpdateExample_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Examples/UpdateExample"
)

// ExamplesClient is the client API for Examples service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ExamplesClient interface {
	// Creates an example in the specified playbook.
	CreateExample(ctx context.Context, in *CreateExampleRequest, opts ...grpc.CallOption) (*Example, error)
	// Deletes the specified example.
	DeleteExample(ctx context.Context, in *DeleteExampleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns a list of examples in the specified playbook.
	ListExamples(ctx context.Context, in *ListExamplesRequest, opts ...grpc.CallOption) (*ListExamplesResponse, error)
	// Retrieves the specified example.
	GetExample(ctx context.Context, in *GetExampleRequest, opts ...grpc.CallOption) (*Example, error)
	// Update the specified example.
	UpdateExample(ctx context.Context, in *UpdateExampleRequest, opts ...grpc.CallOption) (*Example, error)
}

type examplesClient struct {
	cc grpc.ClientConnInterface
}

func NewExamplesClient(cc grpc.ClientConnInterface) ExamplesClient {
	return &examplesClient{cc}
}

func (c *examplesClient) CreateExample(ctx context.Context, in *CreateExampleRequest, opts ...grpc.CallOption) (*Example, error) {
	out := new(Example)
	err := c.cc.Invoke(ctx, Examples_CreateExample_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *examplesClient) DeleteExample(ctx context.Context, in *DeleteExampleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Examples_DeleteExample_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *examplesClient) ListExamples(ctx context.Context, in *ListExamplesRequest, opts ...grpc.CallOption) (*ListExamplesResponse, error) {
	out := new(ListExamplesResponse)
	err := c.cc.Invoke(ctx, Examples_ListExamples_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *examplesClient) GetExample(ctx context.Context, in *GetExampleRequest, opts ...grpc.CallOption) (*Example, error) {
	out := new(Example)
	err := c.cc.Invoke(ctx, Examples_GetExample_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *examplesClient) UpdateExample(ctx context.Context, in *UpdateExampleRequest, opts ...grpc.CallOption) (*Example, error) {
	out := new(Example)
	err := c.cc.Invoke(ctx, Examples_UpdateExample_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExamplesServer is the server API for Examples service.
// All implementations should embed UnimplementedExamplesServer
// for forward compatibility
type ExamplesServer interface {
	// Creates an example in the specified playbook.
	CreateExample(context.Context, *CreateExampleRequest) (*Example, error)
	// Deletes the specified example.
	DeleteExample(context.Context, *DeleteExampleRequest) (*emptypb.Empty, error)
	// Returns a list of examples in the specified playbook.
	ListExamples(context.Context, *ListExamplesRequest) (*ListExamplesResponse, error)
	// Retrieves the specified example.
	GetExample(context.Context, *GetExampleRequest) (*Example, error)
	// Update the specified example.
	UpdateExample(context.Context, *UpdateExampleRequest) (*Example, error)
}

// UnimplementedExamplesServer should be embedded to have forward compatible implementations.
type UnimplementedExamplesServer struct {
}

func (UnimplementedExamplesServer) CreateExample(context.Context, *CreateExampleRequest) (*Example, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExample not implemented")
}
func (UnimplementedExamplesServer) DeleteExample(context.Context, *DeleteExampleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExample not implemented")
}
func (UnimplementedExamplesServer) ListExamples(context.Context, *ListExamplesRequest) (*ListExamplesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExamples not implemented")
}
func (UnimplementedExamplesServer) GetExample(context.Context, *GetExampleRequest) (*Example, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExample not implemented")
}
func (UnimplementedExamplesServer) UpdateExample(context.Context, *UpdateExampleRequest) (*Example, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExample not implemented")
}

// UnsafeExamplesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ExamplesServer will
// result in compilation errors.
type UnsafeExamplesServer interface {
	mustEmbedUnimplementedExamplesServer()
}

func RegisterExamplesServer(s grpc.ServiceRegistrar, srv ExamplesServer) {
	s.RegisterService(&Examples_ServiceDesc, srv)
}

func _Examples_CreateExample_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExampleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExamplesServer).CreateExample(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Examples_CreateExample_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExamplesServer).CreateExample(ctx, req.(*CreateExampleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Examples_DeleteExample_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExampleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExamplesServer).DeleteExample(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Examples_DeleteExample_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExamplesServer).DeleteExample(ctx, req.(*DeleteExampleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Examples_ListExamples_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExamplesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExamplesServer).ListExamples(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Examples_ListExamples_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExamplesServer).ListExamples(ctx, req.(*ListExamplesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Examples_GetExample_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExampleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExamplesServer).GetExample(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Examples_GetExample_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExamplesServer).GetExample(ctx, req.(*GetExampleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Examples_UpdateExample_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExampleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExamplesServer).UpdateExample(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Examples_UpdateExample_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExamplesServer).UpdateExample(ctx, req.(*UpdateExampleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Examples_ServiceDesc is the grpc.ServiceDesc for Examples service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Examples_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Examples",
	HandlerType: (*ExamplesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateExample",
			Handler:    _Examples_CreateExample_Handler,
		},
		{
			MethodName: "DeleteExample",
			Handler:    _Examples_DeleteExample_Handler,
		},
		{
			MethodName: "ListExamples",
			Handler:    _Examples_ListExamples_Handler,
		},
		{
			MethodName: "GetExample",
			Handler:    _Examples_GetExample_Handler,
		},
		{
			MethodName: "UpdateExample",
			Handler:    _Examples_UpdateExample_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/example.proto",
}
