// Copyright 2019 The Opt Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package opt // import "modernc.org/opt"

import (
	"encoding/hex"
	"fmt"
	"os"
	"path"
	"runtime"
	"runtime/debug"
	"strings"
	"testing"
)

func caller(s string, va ...interface{}) {
	if s == "" {
		s = strings.Repeat("%v ", len(va))
	}
	_, fn, fl, _ := runtime.Caller(2)
	fmt.Fprintf(os.Stderr, "# caller: %s:%d: ", path.Base(fn), fl)
	fmt.Fprintf(os.Stderr, s, va...)
	fmt.Fprintln(os.Stderr)
	_, fn, fl, _ = runtime.Caller(1)
	fmt.Fprintf(os.Stderr, "# \tcallee: %s:%d: ", path.Base(fn), fl)
	fmt.Fprintln(os.Stderr)
	os.Stderr.Sync()
}

func dbg(s string, va ...interface{}) {
	if s == "" {
		s = strings.Repeat("%v ", len(va))
	}
	_, fn, fl, _ := runtime.Caller(1)
	fmt.Fprintf(os.Stderr, "# dbg %s:%d: ", path.Base(fn), fl)
	fmt.Fprintf(os.Stderr, s, va...)
	fmt.Fprintln(os.Stderr)
	os.Stderr.Sync()
}

func TODO(...interface{}) string { //TODOOK
	_, fn, fl, _ := runtime.Caller(1)
	return fmt.Sprintf("# TODO: %s:%d:\n", path.Base(fn), fl) //TODOOK
}

func stack() string { return string(debug.Stack()) }

func use(...interface{}) {}

func hexString(b []byte) string { return hex.Dump(b) }

func init() {
	use(caller, dbg, TODO, stack, hexString) //TODOOK
}

// ============================================================================

func Test(t *testing.T) {
	set := NewSet()
	set.Arg("std", true, func(opt, val string) error {
		if strings.HasPrefix(val, "=") {
			t.Errorf("%q %q", opt, val)
		}
		return nil
	})
	if err := set.Parse([]string{
		"-std=c99",
		"-std c99",
	}, func(opt string) error {
		t.Errorf("%q", opt)
		return nil
	}); err != nil {
		t.Error(err)
	}
}
