// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCancelIngestion = "CancelIngestion"

// CancelIngestionRequest generates a "aws/request.Request" representing the
// client's request for the CancelIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelIngestion for more information on using the CancelIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelIngestionRequest method.
//	req, resp := client.CancelIngestionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion
func (c *QuickSight) CancelIngestionRequest(input *CancelIngestionInput) (req *request.Request, output *CancelIngestionOutput) {
	op := &request.Operation{
		Name:       opCancelIngestion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &CancelIngestionInput{}
	}

	output = &CancelIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelIngestion API operation for Amazon QuickSight.
//
// Cancels an ongoing ingestion of data into SPICE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CancelIngestion for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion
func (c *QuickSight) CancelIngestion(input *CancelIngestionInput) (*CancelIngestionOutput, error) {
	req, out := c.CancelIngestionRequest(input)
	return out, req.Send()
}

// CancelIngestionWithContext is the same as CancelIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See CancelIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CancelIngestionWithContext(ctx aws.Context, input *CancelIngestionInput, opts ...request.Option) (*CancelIngestionOutput, error) {
	req, out := c.CancelIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccountCustomization = "CreateAccountCustomization"

// CreateAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccountCustomization for more information on using the CreateAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccountCustomizationRequest method.
//	req, resp := client.CreateAccountCustomizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization
func (c *QuickSight) CreateAccountCustomizationRequest(input *CreateAccountCustomizationInput) (req *request.Request, output *CreateAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opCreateAccountCustomization,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &CreateAccountCustomizationInput{}
	}

	output = &CreateAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccountCustomization API operation for Amazon QuickSight.
//
// Creates Amazon QuickSight customizations for the current Amazon Web Services
// Region. Currently, you can add a custom default theme by using the CreateAccountCustomization
// or UpdateAccountCustomization API operation. To further customize Amazon
// QuickSight by removing Amazon QuickSight sample assets and videos for all
// new users, see Customizing Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html)
// in the Amazon QuickSight User Guide.
//
// You can create customizations for your Amazon Web Services account or, if
// you specify a namespace, for a QuickSight namespace instead. Customizations
// that apply to a namespace always override customizations that apply to an
// Amazon Web Services account. To find out which customizations apply, use
// the DescribeAccountCustomization API operation.
//
// Before you use the CreateAccountCustomization API operation to add a theme
// as the namespace default, make sure that you first share the theme with the
// namespace. If you don't share it with the namespace, the theme isn't visible
// to your users even if you make it the default theme. To check if the theme
// is shared, view the current permissions by using the DescribeThemePermissions
// (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html)
// API operation. To share the theme, grant permissions by using the UpdateThemePermissions
// (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html)
// API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateAccountCustomization for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization
func (c *QuickSight) CreateAccountCustomization(input *CreateAccountCustomizationInput) (*CreateAccountCustomizationOutput, error) {
	req, out := c.CreateAccountCustomizationRequest(input)
	return out, req.Send()
}

// CreateAccountCustomizationWithContext is the same as CreateAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateAccountCustomizationWithContext(ctx aws.Context, input *CreateAccountCustomizationInput, opts ...request.Option) (*CreateAccountCustomizationOutput, error) {
	req, out := c.CreateAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccountSubscription = "CreateAccountSubscription"

// CreateAccountSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccountSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccountSubscription for more information on using the CreateAccountSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccountSubscriptionRequest method.
//	req, resp := client.CreateAccountSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountSubscription
func (c *QuickSight) CreateAccountSubscriptionRequest(input *CreateAccountSubscriptionInput) (req *request.Request, output *CreateAccountSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateAccountSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/account/{AwsAccountId}",
	}

	if input == nil {
		input = &CreateAccountSubscriptionInput{}
	}

	output = &CreateAccountSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccountSubscription API operation for Amazon QuickSight.
//
// Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight
// Q.
//
// The Amazon Web Services Region for the account is derived from what is configured
// in the CLI or SDK. This operation isn't supported in the US East (Ohio) Region,
// South America (Sao Paulo) Region, or Asia Pacific (Singapore) Region.
//
// Before you use this operation, make sure that you can connect to an existing
// Amazon Web Services account. If you don't have an Amazon Web Services account,
// see Sign up for Amazon Web Services (https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html)
// in the Amazon QuickSight User Guide. The person who signs up for Amazon QuickSight
// needs to have the correct Identity and Access Management (IAM) permissions.
// For more information, see IAM Policy Examples for Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html)
// in the Amazon QuickSight User Guide.
//
// If your IAM policy includes both the Subscribe and CreateAccountSubscription
// actions, make sure that both actions are set to Allow. If either action is
// set to Deny, the Deny action prevails and your API call fails.
//
// You can't pass an existing IAM role to access other Amazon Web Services services
// using this API operation. To pass your existing IAM role to Amazon QuickSight,
// see Passing IAM roles to Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role)
// in the Amazon QuickSight User Guide.
//
// You can't set default resource access on the new account from the Amazon
// QuickSight API. Instead, add default resource access from the Amazon QuickSight
// console. For more information about setting default resource access to Amazon
// Web Services services, see Setting default resource access to Amazon Web
// Services services (https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html)
// in the Amazon QuickSight User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateAccountSubscription for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountSubscription
func (c *QuickSight) CreateAccountSubscription(input *CreateAccountSubscriptionInput) (*CreateAccountSubscriptionOutput, error) {
	req, out := c.CreateAccountSubscriptionRequest(input)
	return out, req.Send()
}

// CreateAccountSubscriptionWithContext is the same as CreateAccountSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccountSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateAccountSubscriptionWithContext(ctx aws.Context, input *CreateAccountSubscriptionInput, opts ...request.Option) (*CreateAccountSubscriptionOutput, error) {
	req, out := c.CreateAccountSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAnalysis = "CreateAnalysis"

// CreateAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnalysis for more information on using the CreateAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAnalysisRequest method.
//	req, resp := client.CreateAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis
func (c *QuickSight) CreateAnalysisRequest(input *CreateAnalysisInput) (req *request.Request, output *CreateAnalysisOutput) {
	op := &request.Operation{
		Name:       opCreateAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &CreateAnalysisInput{}
	}

	output = &CreateAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAnalysis API operation for Amazon QuickSight.
//
// Creates an analysis in Amazon QuickSight. Analyses can be created either
// from a template or from an AnalysisDefinition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis
func (c *QuickSight) CreateAnalysis(input *CreateAnalysisInput) (*CreateAnalysisOutput, error) {
	req, out := c.CreateAnalysisRequest(input)
	return out, req.Send()
}

// CreateAnalysisWithContext is the same as CreateAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateAnalysisWithContext(ctx aws.Context, input *CreateAnalysisInput, opts ...request.Option) (*CreateAnalysisOutput, error) {
	req, out := c.CreateAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDashboard = "CreateDashboard"

// CreateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the CreateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDashboard for more information on using the CreateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDashboardRequest method.
//	req, resp := client.CreateDashboardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard
func (c *QuickSight) CreateDashboardRequest(input *CreateDashboardInput) (req *request.Request, output *CreateDashboardOutput) {
	op := &request.Operation{
		Name:       opCreateDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &CreateDashboardInput{}
	}

	output = &CreateDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDashboard API operation for Amazon QuickSight.
//
// Creates a dashboard from either a template or directly with a DashboardDefinition.
// To first create a template, see the CreateTemplate (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html)
// API operation.
//
// A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight
// reports, created from analyses. You can share Amazon QuickSight dashboards.
// With the right permissions, you can create scheduled email reports from them.
// If you have the correct permissions, you can create a dashboard from a template
// that exists in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDashboard for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard
func (c *QuickSight) CreateDashboard(input *CreateDashboardInput) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	return out, req.Send()
}

// CreateDashboardWithContext is the same as CreateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDashboardWithContext(ctx aws.Context, input *CreateDashboardInput, opts ...request.Option) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSet = "CreateDataSet"

// CreateDataSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSet for more information on using the CreateDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataSetRequest method.
//	req, resp := client.CreateDataSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet
func (c *QuickSight) CreateDataSetRequest(input *CreateDataSetInput) (req *request.Request, output *CreateDataSetOutput) {
	op := &request.Operation{
		Name:       opCreateDataSet,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets",
	}

	if input == nil {
		input = &CreateDataSetInput{}
	}

	output = &CreateDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSet API operation for Amazon QuickSight.
//
// Creates a dataset. This operation doesn't support datasets that include uploaded
// files as a source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDataSet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet
func (c *QuickSight) CreateDataSet(input *CreateDataSetInput) (*CreateDataSetOutput, error) {
	req, out := c.CreateDataSetRequest(input)
	return out, req.Send()
}

// CreateDataSetWithContext is the same as CreateDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDataSetWithContext(ctx aws.Context, input *CreateDataSetInput, opts ...request.Option) (*CreateDataSetOutput, error) {
	req, out := c.CreateDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSource = "CreateDataSource"

// CreateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSource for more information on using the CreateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataSourceRequest method.
//	req, resp := client.CreateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource
func (c *QuickSight) CreateDataSourceRequest(input *CreateDataSourceInput) (req *request.Request, output *CreateDataSourceOutput) {
	op := &request.Operation{
		Name:       opCreateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources",
	}

	if input == nil {
		input = &CreateDataSourceInput{}
	}

	output = &CreateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSource API operation for Amazon QuickSight.
//
// Creates a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource
func (c *QuickSight) CreateDataSource(input *CreateDataSourceInput) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	return out, req.Send()
}

// CreateDataSourceWithContext is the same as CreateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDataSourceWithContext(ctx aws.Context, input *CreateDataSourceInput, opts ...request.Option) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFolder = "CreateFolder"

// CreateFolderRequest generates a "aws/request.Request" representing the
// client's request for the CreateFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFolder for more information on using the CreateFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFolderRequest method.
//	req, resp := client.CreateFolderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolder
func (c *QuickSight) CreateFolderRequest(input *CreateFolderInput) (req *request.Request, output *CreateFolderOutput) {
	op := &request.Operation{
		Name:       opCreateFolder,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &CreateFolderInput{}
	}

	output = &CreateFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFolder API operation for Amazon QuickSight.
//
// Creates an empty shared folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateFolder for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolder
func (c *QuickSight) CreateFolder(input *CreateFolderInput) (*CreateFolderOutput, error) {
	req, out := c.CreateFolderRequest(input)
	return out, req.Send()
}

// CreateFolderWithContext is the same as CreateFolder with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateFolderWithContext(ctx aws.Context, input *CreateFolderInput, opts ...request.Option) (*CreateFolderOutput, error) {
	req, out := c.CreateFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFolderMembership = "CreateFolderMembership"

// CreateFolderMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateFolderMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFolderMembership for more information on using the CreateFolderMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFolderMembershipRequest method.
//	req, resp := client.CreateFolderMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolderMembership
func (c *QuickSight) CreateFolderMembershipRequest(input *CreateFolderMembershipInput) (req *request.Request, output *CreateFolderMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateFolderMembership,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}",
	}

	if input == nil {
		input = &CreateFolderMembershipInput{}
	}

	output = &CreateFolderMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFolderMembership API operation for Amazon QuickSight.
//
// Adds an asset, such as a dashboard, analysis, or dataset into a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateFolderMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolderMembership
func (c *QuickSight) CreateFolderMembership(input *CreateFolderMembershipInput) (*CreateFolderMembershipOutput, error) {
	req, out := c.CreateFolderMembershipRequest(input)
	return out, req.Send()
}

// CreateFolderMembershipWithContext is the same as CreateFolderMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFolderMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateFolderMembershipWithContext(ctx aws.Context, input *CreateFolderMembershipInput, opts ...request.Option) (*CreateFolderMembershipOutput, error) {
	req, out := c.CreateFolderMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGroupRequest method.
//	req, resp := client.CreateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup
func (c *QuickSight) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for Amazon QuickSight.
//
// Use the CreateGroup operation to create a group in Amazon QuickSight. You
// can create up to 10,000 groups in a namespace. If you want to create more
// than 10,000 groups in a namespace, contact AWS Support.
//
// The permissions resource is arn:aws:quicksight:<your-region>:<relevant-aws-account-id>:group/default/<group-name> .
//
// The response is a group object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateGroup for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup
func (c *QuickSight) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroupMembership = "CreateGroupMembership"

// CreateGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroupMembership for more information on using the CreateGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGroupMembershipRequest method.
//	req, resp := client.CreateGroupMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership
func (c *QuickSight) CreateGroupMembershipRequest(input *CreateGroupMembershipInput) (req *request.Request, output *CreateGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateGroupMembership,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &CreateGroupMembershipInput{}
	}

	output = &CreateGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroupMembership API operation for Amazon QuickSight.
//
// Adds an Amazon QuickSight user to an Amazon QuickSight group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateGroupMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership
func (c *QuickSight) CreateGroupMembership(input *CreateGroupMembershipInput) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	return out, req.Send()
}

// CreateGroupMembershipWithContext is the same as CreateGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateGroupMembershipWithContext(ctx aws.Context, input *CreateGroupMembershipInput, opts ...request.Option) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIAMPolicyAssignment = "CreateIAMPolicyAssignment"

// CreateIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIAMPolicyAssignment for more information on using the CreateIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIAMPolicyAssignmentRequest method.
//	req, resp := client.CreateIAMPolicyAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment
func (c *QuickSight) CreateIAMPolicyAssignmentRequest(input *CreateIAMPolicyAssignmentInput) (req *request.Request, output *CreateIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opCreateIAMPolicyAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/",
	}

	if input == nil {
		input = &CreateIAMPolicyAssignmentInput{}
	}

	output = &CreateIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Creates an assignment with one specified IAM policy, identified by its Amazon
// Resource Name (ARN). This policy assignment is attached to the specified
// groups or users of Amazon QuickSight. Assignment names are unique per Amazon
// Web Services account. To avoid overwriting rules in other namespaces, use
// assignment names that are unique.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConcurrentUpdatingException
//     A resource is already in a state that indicates an operation is happening
//     that must complete before a new update can be applied.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment
func (c *QuickSight) CreateIAMPolicyAssignment(input *CreateIAMPolicyAssignmentInput) (*CreateIAMPolicyAssignmentOutput, error) {
	req, out := c.CreateIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// CreateIAMPolicyAssignmentWithContext is the same as CreateIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateIAMPolicyAssignmentWithContext(ctx aws.Context, input *CreateIAMPolicyAssignmentInput, opts ...request.Option) (*CreateIAMPolicyAssignmentOutput, error) {
	req, out := c.CreateIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIngestion = "CreateIngestion"

// CreateIngestionRequest generates a "aws/request.Request" representing the
// client's request for the CreateIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIngestion for more information on using the CreateIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIngestionRequest method.
//	req, resp := client.CreateIngestionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion
func (c *QuickSight) CreateIngestionRequest(input *CreateIngestionInput) (req *request.Request, output *CreateIngestionOutput) {
	op := &request.Operation{
		Name:       opCreateIngestion,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &CreateIngestionInput{}
	}

	output = &CreateIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIngestion API operation for Amazon QuickSight.
//
// Creates and starts a new SPICE ingestion for a dataset. You can manually
// refresh datasets in an Enterprise edition account 32 times in a 24-hour period.
// You can manually refresh datasets in a Standard edition account 8 times in
// a 24-hour period. Each 24-hour period is measured starting 24 hours before
// the current date and time.
//
// Any ingestions operating on tagged datasets inherit the same tags automatically
// for use in access control. For an example, see How do I create an IAM policy
// to control access to Amazon EC2 resources using tags? (http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/)
// in the Amazon Web Services Knowledge Center. Tags are visible on the tagged
// dataset, but not on the ingestion resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateIngestion for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion
func (c *QuickSight) CreateIngestion(input *CreateIngestionInput) (*CreateIngestionOutput, error) {
	req, out := c.CreateIngestionRequest(input)
	return out, req.Send()
}

// CreateIngestionWithContext is the same as CreateIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateIngestionWithContext(ctx aws.Context, input *CreateIngestionInput, opts ...request.Option) (*CreateIngestionOutput, error) {
	req, out := c.CreateIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNamespace = "CreateNamespace"

// CreateNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNamespace for more information on using the CreateNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNamespaceRequest method.
//	req, resp := client.CreateNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace
func (c *QuickSight) CreateNamespaceRequest(input *CreateNamespaceInput) (req *request.Request, output *CreateNamespaceOutput) {
	op := &request.Operation{
		Name:       opCreateNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}",
	}

	if input == nil {
		input = &CreateNamespaceInput{}
	}

	output = &CreateNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNamespace API operation for Amazon QuickSight.
//
// (Enterprise edition only) Creates a new namespace for you to use with Amazon
// QuickSight.
//
// A namespace allows you to isolate the Amazon QuickSight users and groups
// that are registered for that namespace. Users that access the namespace can
// share assets only with other users or groups in the same namespace. They
// can't see users and groups in other namespaces. You can create a namespace
// after your Amazon Web Services account is subscribed to Amazon QuickSight.
// The namespace must be unique within the Amazon Web Services account. By default,
// there is a limit of 100 namespaces per Amazon Web Services account. To increase
// your limit, create a ticket with Amazon Web Services Support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateNamespace for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace
func (c *QuickSight) CreateNamespace(input *CreateNamespaceInput) (*CreateNamespaceOutput, error) {
	req, out := c.CreateNamespaceRequest(input)
	return out, req.Send()
}

// CreateNamespaceWithContext is the same as CreateNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateNamespaceWithContext(ctx aws.Context, input *CreateNamespaceInput, opts ...request.Option) (*CreateNamespaceOutput, error) {
	req, out := c.CreateNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRefreshSchedule = "CreateRefreshSchedule"

// CreateRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRefreshSchedule for more information on using the CreateRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRefreshScheduleRequest method.
//	req, resp := client.CreateRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateRefreshSchedule
func (c *QuickSight) CreateRefreshScheduleRequest(input *CreateRefreshScheduleInput) (req *request.Request, output *CreateRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opCreateRefreshSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules",
	}

	if input == nil {
		input = &CreateRefreshScheduleInput{}
	}

	output = &CreateRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRefreshSchedule API operation for Amazon QuickSight.
//
// Creates a refresh schedule for a dataset. You can create up to 5 different
// schedules for a single dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateRefreshSchedule
func (c *QuickSight) CreateRefreshSchedule(input *CreateRefreshScheduleInput) (*CreateRefreshScheduleOutput, error) {
	req, out := c.CreateRefreshScheduleRequest(input)
	return out, req.Send()
}

// CreateRefreshScheduleWithContext is the same as CreateRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateRefreshScheduleWithContext(ctx aws.Context, input *CreateRefreshScheduleInput, opts ...request.Option) (*CreateRefreshScheduleOutput, error) {
	req, out := c.CreateRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplate = "CreateTemplate"

// CreateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplate for more information on using the CreateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTemplateRequest method.
//	req, resp := client.CreateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate
func (c *QuickSight) CreateTemplateRequest(input *CreateTemplateInput) (req *request.Request, output *CreateTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &CreateTemplateInput{}
	}

	output = &CreateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplate API operation for Amazon QuickSight.
//
// Creates a template either from a TemplateDefinition or from an existing Amazon
// QuickSight analysis or template. You can use the resulting template to create
// additional dashboards, templates, or analyses.
//
// A template is an entity in Amazon QuickSight that encapsulates the metadata
// required to create an analysis and that you can use to create s dashboard.
// A template adds a layer of abstraction by using placeholders to replace the
// dataset associated with the analysis. You can use templates to create dashboards
// by replacing dataset placeholders with datasets that follow the same schema
// that was used to create the source analysis and template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate
func (c *QuickSight) CreateTemplate(input *CreateTemplateInput) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	return out, req.Send()
}

// CreateTemplateWithContext is the same as CreateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateTemplateWithContext(ctx aws.Context, input *CreateTemplateInput, opts ...request.Option) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplateAlias = "CreateTemplateAlias"

// CreateTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplateAlias for more information on using the CreateTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTemplateAliasRequest method.
//	req, resp := client.CreateTemplateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias
func (c *QuickSight) CreateTemplateAliasRequest(input *CreateTemplateAliasInput) (req *request.Request, output *CreateTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateTemplateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &CreateTemplateAliasInput{}
	}

	output = &CreateTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplateAlias API operation for Amazon QuickSight.
//
// Creates a template alias for a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTemplateAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias
func (c *QuickSight) CreateTemplateAlias(input *CreateTemplateAliasInput) (*CreateTemplateAliasOutput, error) {
	req, out := c.CreateTemplateAliasRequest(input)
	return out, req.Send()
}

// CreateTemplateAliasWithContext is the same as CreateTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateTemplateAliasWithContext(ctx aws.Context, input *CreateTemplateAliasInput, opts ...request.Option) (*CreateTemplateAliasOutput, error) {
	req, out := c.CreateTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTheme = "CreateTheme"

// CreateThemeRequest generates a "aws/request.Request" representing the
// client's request for the CreateTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTheme for more information on using the CreateTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateThemeRequest method.
//	req, resp := client.CreateThemeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme
func (c *QuickSight) CreateThemeRequest(input *CreateThemeInput) (req *request.Request, output *CreateThemeOutput) {
	op := &request.Operation{
		Name:       opCreateTheme,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &CreateThemeInput{}
	}

	output = &CreateThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTheme API operation for Amazon QuickSight.
//
// Creates a theme.
//
// A theme is set of configuration options for color and layout. Themes apply
// to analyses and dashboards. For more information, see Using Themes in Amazon
// QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html)
// in the Amazon QuickSight User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTheme for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme
func (c *QuickSight) CreateTheme(input *CreateThemeInput) (*CreateThemeOutput, error) {
	req, out := c.CreateThemeRequest(input)
	return out, req.Send()
}

// CreateThemeWithContext is the same as CreateTheme with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateThemeWithContext(ctx aws.Context, input *CreateThemeInput, opts ...request.Option) (*CreateThemeOutput, error) {
	req, out := c.CreateThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThemeAlias = "CreateThemeAlias"

// CreateThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThemeAlias for more information on using the CreateThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateThemeAliasRequest method.
//	req, resp := client.CreateThemeAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias
func (c *QuickSight) CreateThemeAliasRequest(input *CreateThemeAliasInput) (req *request.Request, output *CreateThemeAliasOutput) {
	op := &request.Operation{
		Name:       opCreateThemeAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &CreateThemeAliasInput{}
	}

	output = &CreateThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThemeAlias API operation for Amazon QuickSight.
//
// Creates a theme alias for a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateThemeAlias for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias
func (c *QuickSight) CreateThemeAlias(input *CreateThemeAliasInput) (*CreateThemeAliasOutput, error) {
	req, out := c.CreateThemeAliasRequest(input)
	return out, req.Send()
}

// CreateThemeAliasWithContext is the same as CreateThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateThemeAliasWithContext(ctx aws.Context, input *CreateThemeAliasInput, opts ...request.Option) (*CreateThemeAliasOutput, error) {
	req, out := c.CreateThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountCustomization = "DeleteAccountCustomization"

// DeleteAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountCustomization for more information on using the DeleteAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccountCustomizationRequest method.
//	req, resp := client.DeleteAccountCustomizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization
func (c *QuickSight) DeleteAccountCustomizationRequest(input *DeleteAccountCustomizationInput) (req *request.Request, output *DeleteAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountCustomization,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &DeleteAccountCustomizationInput{}
	}

	output = &DeleteAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAccountCustomization API operation for Amazon QuickSight.
//
// Deletes all Amazon QuickSight customizations in this Amazon Web Services
// Region for the specified Amazon Web Services account and Amazon QuickSight
// namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteAccountCustomization for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization
func (c *QuickSight) DeleteAccountCustomization(input *DeleteAccountCustomizationInput) (*DeleteAccountCustomizationOutput, error) {
	req, out := c.DeleteAccountCustomizationRequest(input)
	return out, req.Send()
}

// DeleteAccountCustomizationWithContext is the same as DeleteAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteAccountCustomizationWithContext(ctx aws.Context, input *DeleteAccountCustomizationInput, opts ...request.Option) (*DeleteAccountCustomizationOutput, error) {
	req, out := c.DeleteAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountSubscription = "DeleteAccountSubscription"

// DeleteAccountSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountSubscription for more information on using the DeleteAccountSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccountSubscriptionRequest method.
//	req, resp := client.DeleteAccountSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountSubscription
func (c *QuickSight) DeleteAccountSubscriptionRequest(input *DeleteAccountSubscriptionInput) (req *request.Request, output *DeleteAccountSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountSubscription,
		HTTPMethod: "DELETE",
		HTTPPath:   "/account/{AwsAccountId}",
	}

	if input == nil {
		input = &DeleteAccountSubscriptionInput{}
	}

	output = &DeleteAccountSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAccountSubscription API operation for Amazon QuickSight.
//
// Use the DeleteAccountSubscription operation to delete an Amazon QuickSight
// account. This operation will result in an error message if you have configured
// your account termination protection settings to True. To change this setting
// and delete your account, call the UpdateAccountSettings API and set the value
// of the TerminationProtectionEnabled parameter to False, then make another
// call to the DeleteAccountSubscription API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteAccountSubscription for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountSubscription
func (c *QuickSight) DeleteAccountSubscription(input *DeleteAccountSubscriptionInput) (*DeleteAccountSubscriptionOutput, error) {
	req, out := c.DeleteAccountSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteAccountSubscriptionWithContext is the same as DeleteAccountSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteAccountSubscriptionWithContext(ctx aws.Context, input *DeleteAccountSubscriptionInput, opts ...request.Option) (*DeleteAccountSubscriptionOutput, error) {
	req, out := c.DeleteAccountSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnalysis = "DeleteAnalysis"

// DeleteAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnalysis for more information on using the DeleteAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAnalysisRequest method.
//	req, resp := client.DeleteAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis
func (c *QuickSight) DeleteAnalysisRequest(input *DeleteAnalysisInput) (req *request.Request, output *DeleteAnalysisOutput) {
	op := &request.Operation{
		Name:       opDeleteAnalysis,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &DeleteAnalysisInput{}
	}

	output = &DeleteAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAnalysis API operation for Amazon QuickSight.
//
// Deletes an analysis from Amazon QuickSight. You can optionally include a
// recovery window during which you can restore the analysis. If you don't specify
// a recovery window value, the operation defaults to 30 days. Amazon QuickSight
// attaches a DeletionTime stamp to the response that specifies the end of the
// recovery window. At the end of the recovery window, Amazon QuickSight deletes
// the analysis permanently.
//
// At any time before recovery window ends, you can use the RestoreAnalysis
// API operation to remove the DeletionTime stamp and cancel the deletion of
// the analysis. The analysis remains visible in the API until it's deleted,
// so you can describe it but you can't make a template from it.
//
// An analysis that's scheduled for deletion isn't accessible in the Amazon
// QuickSight console. To access it in the console, restore it. Deleting an
// analysis doesn't delete the dashboards that you publish from it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis
func (c *QuickSight) DeleteAnalysis(input *DeleteAnalysisInput) (*DeleteAnalysisOutput, error) {
	req, out := c.DeleteAnalysisRequest(input)
	return out, req.Send()
}

// DeleteAnalysisWithContext is the same as DeleteAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteAnalysisWithContext(ctx aws.Context, input *DeleteAnalysisInput, opts ...request.Option) (*DeleteAnalysisOutput, error) {
	req, out := c.DeleteAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDashboard = "DeleteDashboard"

// DeleteDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDashboard for more information on using the DeleteDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDashboardRequest method.
//	req, resp := client.DeleteDashboardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard
func (c *QuickSight) DeleteDashboardRequest(input *DeleteDashboardInput) (req *request.Request, output *DeleteDashboardOutput) {
	op := &request.Operation{
		Name:       opDeleteDashboard,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &DeleteDashboardInput{}
	}

	output = &DeleteDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDashboard API operation for Amazon QuickSight.
//
// Deletes a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDashboard for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard
func (c *QuickSight) DeleteDashboard(input *DeleteDashboardInput) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	return out, req.Send()
}

// DeleteDashboardWithContext is the same as DeleteDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDashboardWithContext(ctx aws.Context, input *DeleteDashboardInput, opts ...request.Option) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSet = "DeleteDataSet"

// DeleteDataSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSet for more information on using the DeleteDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataSetRequest method.
//	req, resp := client.DeleteDataSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet
func (c *QuickSight) DeleteDataSetRequest(input *DeleteDataSetInput) (req *request.Request, output *DeleteDataSetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &DeleteDataSetInput{}
	}

	output = &DeleteDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSet API operation for Amazon QuickSight.
//
// Deletes a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDataSet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet
func (c *QuickSight) DeleteDataSet(input *DeleteDataSetInput) (*DeleteDataSetOutput, error) {
	req, out := c.DeleteDataSetRequest(input)
	return out, req.Send()
}

// DeleteDataSetWithContext is the same as DeleteDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDataSetWithContext(ctx aws.Context, input *DeleteDataSetInput, opts ...request.Option) (*DeleteDataSetOutput, error) {
	req, out := c.DeleteDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSetRefreshProperties = "DeleteDataSetRefreshProperties"

// DeleteDataSetRefreshPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSetRefreshProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSetRefreshProperties for more information on using the DeleteDataSetRefreshProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataSetRefreshPropertiesRequest method.
//	req, resp := client.DeleteDataSetRefreshPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSetRefreshProperties
func (c *QuickSight) DeleteDataSetRefreshPropertiesRequest(input *DeleteDataSetRefreshPropertiesInput) (req *request.Request, output *DeleteDataSetRefreshPropertiesOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSetRefreshProperties,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-properties",
	}

	if input == nil {
		input = &DeleteDataSetRefreshPropertiesInput{}
	}

	output = &DeleteDataSetRefreshPropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSetRefreshProperties API operation for Amazon QuickSight.
//
// Deletes the dataset refresh properties of the dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDataSetRefreshProperties for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSetRefreshProperties
func (c *QuickSight) DeleteDataSetRefreshProperties(input *DeleteDataSetRefreshPropertiesInput) (*DeleteDataSetRefreshPropertiesOutput, error) {
	req, out := c.DeleteDataSetRefreshPropertiesRequest(input)
	return out, req.Send()
}

// DeleteDataSetRefreshPropertiesWithContext is the same as DeleteDataSetRefreshProperties with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSetRefreshProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDataSetRefreshPropertiesWithContext(ctx aws.Context, input *DeleteDataSetRefreshPropertiesInput, opts ...request.Option) (*DeleteDataSetRefreshPropertiesOutput, error) {
	req, out := c.DeleteDataSetRefreshPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataSourceRequest method.
//	req, resp := client.DeleteDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource
func (c *QuickSight) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSource API operation for Amazon QuickSight.
//
// Deletes the data source permanently. This operation breaks all the datasets
// that reference the deleted data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource
func (c *QuickSight) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFolder = "DeleteFolder"

// DeleteFolderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFolder for more information on using the DeleteFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFolderRequest method.
//	req, resp := client.DeleteFolderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolder
func (c *QuickSight) DeleteFolderRequest(input *DeleteFolderInput) (req *request.Request, output *DeleteFolderOutput) {
	op := &request.Operation{
		Name:       opDeleteFolder,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &DeleteFolderInput{}
	}

	output = &DeleteFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFolder API operation for Amazon QuickSight.
//
// Deletes an empty folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteFolder for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolder
func (c *QuickSight) DeleteFolder(input *DeleteFolderInput) (*DeleteFolderOutput, error) {
	req, out := c.DeleteFolderRequest(input)
	return out, req.Send()
}

// DeleteFolderWithContext is the same as DeleteFolder with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteFolderWithContext(ctx aws.Context, input *DeleteFolderInput, opts ...request.Option) (*DeleteFolderOutput, error) {
	req, out := c.DeleteFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFolderMembership = "DeleteFolderMembership"

// DeleteFolderMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFolderMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFolderMembership for more information on using the DeleteFolderMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFolderMembershipRequest method.
//	req, resp := client.DeleteFolderMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolderMembership
func (c *QuickSight) DeleteFolderMembershipRequest(input *DeleteFolderMembershipInput) (req *request.Request, output *DeleteFolderMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteFolderMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}",
	}

	if input == nil {
		input = &DeleteFolderMembershipInput{}
	}

	output = &DeleteFolderMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFolderMembership API operation for Amazon QuickSight.
//
// Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteFolderMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolderMembership
func (c *QuickSight) DeleteFolderMembership(input *DeleteFolderMembershipInput) (*DeleteFolderMembershipOutput, error) {
	req, out := c.DeleteFolderMembershipRequest(input)
	return out, req.Send()
}

// DeleteFolderMembershipWithContext is the same as DeleteFolderMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFolderMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteFolderMembershipWithContext(ctx aws.Context, input *DeleteFolderMembershipInput, opts ...request.Option) (*DeleteFolderMembershipOutput, error) {
	req, out := c.DeleteFolderMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGroupRequest method.
//	req, resp := client.DeleteGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup
func (c *QuickSight) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroup API operation for Amazon QuickSight.
//
// Removes a user group from Amazon QuickSight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup
func (c *QuickSight) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroupMembership = "DeleteGroupMembership"

// DeleteGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroupMembership for more information on using the DeleteGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGroupMembershipRequest method.
//	req, resp := client.DeleteGroupMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership
func (c *QuickSight) DeleteGroupMembershipRequest(input *DeleteGroupMembershipInput) (req *request.Request, output *DeleteGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteGroupMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &DeleteGroupMembershipInput{}
	}

	output = &DeleteGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroupMembership API operation for Amazon QuickSight.
//
// Removes a user from a group so that the user is no longer a member of the
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteGroupMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership
func (c *QuickSight) DeleteGroupMembership(input *DeleteGroupMembershipInput) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	return out, req.Send()
}

// DeleteGroupMembershipWithContext is the same as DeleteGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteGroupMembershipWithContext(ctx aws.Context, input *DeleteGroupMembershipInput, opts ...request.Option) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIAMPolicyAssignment = "DeleteIAMPolicyAssignment"

// DeleteIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIAMPolicyAssignment for more information on using the DeleteIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIAMPolicyAssignmentRequest method.
//	req, resp := client.DeleteIAMPolicyAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment
func (c *QuickSight) DeleteIAMPolicyAssignmentRequest(input *DeleteIAMPolicyAssignmentInput) (req *request.Request, output *DeleteIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opDeleteIAMPolicyAssignment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespace/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &DeleteIAMPolicyAssignmentInput{}
	}

	output = &DeleteIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Deletes an existing IAM policy assignment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConcurrentUpdatingException
//     A resource is already in a state that indicates an operation is happening
//     that must complete before a new update can be applied.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment
func (c *QuickSight) DeleteIAMPolicyAssignment(input *DeleteIAMPolicyAssignmentInput) (*DeleteIAMPolicyAssignmentOutput, error) {
	req, out := c.DeleteIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// DeleteIAMPolicyAssignmentWithContext is the same as DeleteIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteIAMPolicyAssignmentWithContext(ctx aws.Context, input *DeleteIAMPolicyAssignmentInput, opts ...request.Option) (*DeleteIAMPolicyAssignmentOutput, error) {
	req, out := c.DeleteIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNamespace = "DeleteNamespace"

// DeleteNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNamespace for more information on using the DeleteNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNamespaceRequest method.
//	req, resp := client.DeleteNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace
func (c *QuickSight) DeleteNamespaceRequest(input *DeleteNamespaceInput) (req *request.Request, output *DeleteNamespaceOutput) {
	op := &request.Operation{
		Name:       opDeleteNamespace,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}",
	}

	if input == nil {
		input = &DeleteNamespaceInput{}
	}

	output = &DeleteNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNamespace API operation for Amazon QuickSight.
//
// Deletes a namespace and the users and groups that are associated with the
// namespace. This is an asynchronous process. Assets including dashboards,
// analyses, datasets and data sources are not deleted. To delete these assets,
// you use the API operations for the relevant asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteNamespace for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace
func (c *QuickSight) DeleteNamespace(input *DeleteNamespaceInput) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	return out, req.Send()
}

// DeleteNamespaceWithContext is the same as DeleteNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteNamespaceWithContext(ctx aws.Context, input *DeleteNamespaceInput, opts ...request.Option) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRefreshSchedule = "DeleteRefreshSchedule"

// DeleteRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRefreshSchedule for more information on using the DeleteRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRefreshScheduleRequest method.
//	req, resp := client.DeleteRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRefreshSchedule
func (c *QuickSight) DeleteRefreshScheduleRequest(input *DeleteRefreshScheduleInput) (req *request.Request, output *DeleteRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteRefreshSchedule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules/{ScheduleId}",
	}

	if input == nil {
		input = &DeleteRefreshScheduleInput{}
	}

	output = &DeleteRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRefreshSchedule API operation for Amazon QuickSight.
//
// Deletes a refresh schedule from a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRefreshSchedule
func (c *QuickSight) DeleteRefreshSchedule(input *DeleteRefreshScheduleInput) (*DeleteRefreshScheduleOutput, error) {
	req, out := c.DeleteRefreshScheduleRequest(input)
	return out, req.Send()
}

// DeleteRefreshScheduleWithContext is the same as DeleteRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteRefreshScheduleWithContext(ctx aws.Context, input *DeleteRefreshScheduleInput, opts ...request.Option) (*DeleteRefreshScheduleOutput, error) {
	req, out := c.DeleteRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplate = "DeleteTemplate"

// DeleteTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplate for more information on using the DeleteTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTemplateRequest method.
//	req, resp := client.DeleteTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate
func (c *QuickSight) DeleteTemplateRequest(input *DeleteTemplateInput) (req *request.Request, output *DeleteTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &DeleteTemplateInput{}
	}

	output = &DeleteTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTemplate API operation for Amazon QuickSight.
//
// Deletes a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate
func (c *QuickSight) DeleteTemplate(input *DeleteTemplateInput) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	return out, req.Send()
}

// DeleteTemplateWithContext is the same as DeleteTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteTemplateWithContext(ctx aws.Context, input *DeleteTemplateInput, opts ...request.Option) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplateAlias = "DeleteTemplateAlias"

// DeleteTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplateAlias for more information on using the DeleteTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTemplateAliasRequest method.
//	req, resp := client.DeleteTemplateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias
func (c *QuickSight) DeleteTemplateAliasRequest(input *DeleteTemplateAliasInput) (req *request.Request, output *DeleteTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplateAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DeleteTemplateAliasInput{}
	}

	output = &DeleteTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTemplateAlias API operation for Amazon QuickSight.
//
// Deletes the item that the specified template alias points to. If you provide
// a specific alias, you delete the version of the template that the alias points
// to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTemplateAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias
func (c *QuickSight) DeleteTemplateAlias(input *DeleteTemplateAliasInput) (*DeleteTemplateAliasOutput, error) {
	req, out := c.DeleteTemplateAliasRequest(input)
	return out, req.Send()
}

// DeleteTemplateAliasWithContext is the same as DeleteTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteTemplateAliasWithContext(ctx aws.Context, input *DeleteTemplateAliasInput, opts ...request.Option) (*DeleteTemplateAliasOutput, error) {
	req, out := c.DeleteTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTheme = "DeleteTheme"

// DeleteThemeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTheme for more information on using the DeleteTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteThemeRequest method.
//	req, resp := client.DeleteThemeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme
func (c *QuickSight) DeleteThemeRequest(input *DeleteThemeInput) (req *request.Request, output *DeleteThemeOutput) {
	op := &request.Operation{
		Name:       opDeleteTheme,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &DeleteThemeInput{}
	}

	output = &DeleteThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTheme API operation for Amazon QuickSight.
//
// Deletes a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTheme for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme
func (c *QuickSight) DeleteTheme(input *DeleteThemeInput) (*DeleteThemeOutput, error) {
	req, out := c.DeleteThemeRequest(input)
	return out, req.Send()
}

// DeleteThemeWithContext is the same as DeleteTheme with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteThemeWithContext(ctx aws.Context, input *DeleteThemeInput, opts ...request.Option) (*DeleteThemeOutput, error) {
	req, out := c.DeleteThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThemeAlias = "DeleteThemeAlias"

// DeleteThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThemeAlias for more information on using the DeleteThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteThemeAliasRequest method.
//	req, resp := client.DeleteThemeAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias
func (c *QuickSight) DeleteThemeAliasRequest(input *DeleteThemeAliasInput) (req *request.Request, output *DeleteThemeAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteThemeAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DeleteThemeAliasInput{}
	}

	output = &DeleteThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteThemeAlias API operation for Amazon QuickSight.
//
// Deletes the version of the theme that the specified theme alias points to.
// If you provide a specific alias, you delete the version of the theme that
// the alias points to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteThemeAlias for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias
func (c *QuickSight) DeleteThemeAlias(input *DeleteThemeAliasInput) (*DeleteThemeAliasOutput, error) {
	req, out := c.DeleteThemeAliasRequest(input)
	return out, req.Send()
}

// DeleteThemeAliasWithContext is the same as DeleteThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteThemeAliasWithContext(ctx aws.Context, input *DeleteThemeAliasInput, opts ...request.Option) (*DeleteThemeAliasOutput, error) {
	req, out := c.DeleteThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUserRequest method.
//	req, resp := client.DeleteUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser
func (c *QuickSight) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUser API operation for Amazon QuickSight.
//
// Deletes the Amazon QuickSight user that is associated with the identity of
// the IAM user or role that's making the call. The IAM user isn't deleted as
// a result of this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser
func (c *QuickSight) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserByPrincipalId = "DeleteUserByPrincipalId"

// DeleteUserByPrincipalIdRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserByPrincipalId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserByPrincipalId for more information on using the DeleteUserByPrincipalId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUserByPrincipalIdRequest method.
//	req, resp := client.DeleteUserByPrincipalIdRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId
func (c *QuickSight) DeleteUserByPrincipalIdRequest(input *DeleteUserByPrincipalIdInput) (req *request.Request, output *DeleteUserByPrincipalIdOutput) {
	op := &request.Operation{
		Name:       opDeleteUserByPrincipalId,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/user-principals/{PrincipalId}",
	}

	if input == nil {
		input = &DeleteUserByPrincipalIdInput{}
	}

	output = &DeleteUserByPrincipalIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUserByPrincipalId API operation for Amazon QuickSight.
//
// Deletes a user identified by its principal ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteUserByPrincipalId for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId
func (c *QuickSight) DeleteUserByPrincipalId(input *DeleteUserByPrincipalIdInput) (*DeleteUserByPrincipalIdOutput, error) {
	req, out := c.DeleteUserByPrincipalIdRequest(input)
	return out, req.Send()
}

// DeleteUserByPrincipalIdWithContext is the same as DeleteUserByPrincipalId with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserByPrincipalId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteUserByPrincipalIdWithContext(ctx aws.Context, input *DeleteUserByPrincipalIdInput, opts ...request.Option) (*DeleteUserByPrincipalIdOutput, error) {
	req, out := c.DeleteUserByPrincipalIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountCustomization = "DescribeAccountCustomization"

// DescribeAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountCustomization for more information on using the DescribeAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountCustomizationRequest method.
//	req, resp := client.DescribeAccountCustomizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization
func (c *QuickSight) DescribeAccountCustomizationRequest(input *DescribeAccountCustomizationInput) (req *request.Request, output *DescribeAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountCustomization,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &DescribeAccountCustomizationInput{}
	}

	output = &DescribeAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountCustomization API operation for Amazon QuickSight.
//
// Describes the customizations associated with the provided Amazon Web Services
// account and Amazon Amazon QuickSight namespace in an Amazon Web Services
// Region. The Amazon QuickSight console evaluates which customizations to apply
// by running this API operation with the Resolved flag included.
//
// To determine what customizations display when you run this command, it can
// help to visualize the relationship of the entities involved.
//
//   - Amazon Web Services account - The Amazon Web Services account exists
//     at the top of the hierarchy. It has the potential to use all of the Amazon
//     Web Services Regions and Amazon Web Services Services. When you subscribe
//     to Amazon QuickSight, you choose one Amazon Web Services Region to use
//     as your home Region. That's where your free SPICE capacity is located.
//     You can use Amazon QuickSight in any supported Amazon Web Services Region.
//
//   - Amazon Web Services Region - In each Amazon Web Services Region where
//     you sign in to Amazon QuickSight at least once, Amazon QuickSight acts
//     as a separate instance of the same service. If you have a user directory,
//     it resides in us-east-1, which is the US East (N. Virginia). Generally
//     speaking, these users have access to Amazon QuickSight in any Amazon Web
//     Services Region, unless they are constrained to a namespace. To run the
//     command in a different Amazon Web Services Region, you change your Region
//     settings. If you're using the CLI, you can use one of the following options:
//     Use command line options (https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html).
//     Use named profiles (https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html).
//     Run aws configure to change your default Amazon Web Services Region. Use
//     Enter to key the same settings for your keys. For more information, see
//     Configuring the CLI (https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html).
//
//   - Namespace - A QuickSight namespace is a partition that contains users
//     and assets (data sources, datasets, dashboards, and so on). To access
//     assets that are in a specific namespace, users and groups must also be
//     part of the same namespace. People who share a namespace are completely
//     isolated from users and assets in other namespaces, even if they are in
//     the same Amazon Web Services account and Amazon Web Services Region.
//
//   - Applied customizations - Within an Amazon Web Services Region, a set
//     of Amazon QuickSight customizations can apply to an Amazon Web Services
//     account or to a namespace. Settings that you apply to a namespace override
//     settings that you apply to an Amazon Web Services account. All settings
//     are isolated to a single Amazon Web Services Region. To apply them in
//     other Amazon Web Services Regions, run the CreateAccountCustomization
//     command in each Amazon Web Services Region where you want to apply the
//     same customizations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAccountCustomization for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization
func (c *QuickSight) DescribeAccountCustomization(input *DescribeAccountCustomizationInput) (*DescribeAccountCustomizationOutput, error) {
	req, out := c.DescribeAccountCustomizationRequest(input)
	return out, req.Send()
}

// DescribeAccountCustomizationWithContext is the same as DescribeAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAccountCustomizationWithContext(ctx aws.Context, input *DescribeAccountCustomizationInput, opts ...request.Option) (*DescribeAccountCustomizationOutput, error) {
	req, out := c.DescribeAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountSettings = "DescribeAccountSettings"

// DescribeAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountSettings for more information on using the DescribeAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountSettingsRequest method.
//	req, resp := client.DescribeAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings
func (c *QuickSight) DescribeAccountSettingsRequest(input *DescribeAccountSettingsInput) (req *request.Request, output *DescribeAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/settings",
	}

	if input == nil {
		input = &DescribeAccountSettingsInput{}
	}

	output = &DescribeAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountSettings API operation for Amazon QuickSight.
//
// Describes the settings that were used when your Amazon QuickSight subscription
// was first created in this Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings
func (c *QuickSight) DescribeAccountSettings(input *DescribeAccountSettingsInput) (*DescribeAccountSettingsOutput, error) {
	req, out := c.DescribeAccountSettingsRequest(input)
	return out, req.Send()
}

// DescribeAccountSettingsWithContext is the same as DescribeAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAccountSettingsWithContext(ctx aws.Context, input *DescribeAccountSettingsInput, opts ...request.Option) (*DescribeAccountSettingsOutput, error) {
	req, out := c.DescribeAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountSubscription = "DescribeAccountSubscription"

// DescribeAccountSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountSubscription for more information on using the DescribeAccountSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountSubscriptionRequest method.
//	req, resp := client.DescribeAccountSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSubscription
func (c *QuickSight) DescribeAccountSubscriptionRequest(input *DescribeAccountSubscriptionInput) (req *request.Request, output *DescribeAccountSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountSubscription,
		HTTPMethod: "GET",
		HTTPPath:   "/account/{AwsAccountId}",
	}

	if input == nil {
		input = &DescribeAccountSubscriptionInput{}
	}

	output = &DescribeAccountSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountSubscription API operation for Amazon QuickSight.
//
// Use the DescribeAccountSubscription operation to receive a description of
// an Amazon QuickSight account's subscription. A successful API call returns
// an AccountInfo object that includes an account's name, subscription status,
// authentication type, edition, and notification email address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAccountSubscription for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSubscription
func (c *QuickSight) DescribeAccountSubscription(input *DescribeAccountSubscriptionInput) (*DescribeAccountSubscriptionOutput, error) {
	req, out := c.DescribeAccountSubscriptionRequest(input)
	return out, req.Send()
}

// DescribeAccountSubscriptionWithContext is the same as DescribeAccountSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAccountSubscriptionWithContext(ctx aws.Context, input *DescribeAccountSubscriptionInput, opts ...request.Option) (*DescribeAccountSubscriptionOutput, error) {
	req, out := c.DescribeAccountSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnalysis = "DescribeAnalysis"

// DescribeAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnalysis for more information on using the DescribeAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAnalysisRequest method.
//	req, resp := client.DescribeAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis
func (c *QuickSight) DescribeAnalysisRequest(input *DescribeAnalysisInput) (req *request.Request, output *DescribeAnalysisOutput) {
	op := &request.Operation{
		Name:       opDescribeAnalysis,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &DescribeAnalysisInput{}
	}

	output = &DescribeAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnalysis API operation for Amazon QuickSight.
//
// Provides a summary of the metadata for an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis
func (c *QuickSight) DescribeAnalysis(input *DescribeAnalysisInput) (*DescribeAnalysisOutput, error) {
	req, out := c.DescribeAnalysisRequest(input)
	return out, req.Send()
}

// DescribeAnalysisWithContext is the same as DescribeAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAnalysisWithContext(ctx aws.Context, input *DescribeAnalysisInput, opts ...request.Option) (*DescribeAnalysisOutput, error) {
	req, out := c.DescribeAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnalysisDefinition = "DescribeAnalysisDefinition"

// DescribeAnalysisDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnalysisDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnalysisDefinition for more information on using the DescribeAnalysisDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAnalysisDefinitionRequest method.
//	req, resp := client.DescribeAnalysisDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisDefinition
func (c *QuickSight) DescribeAnalysisDefinitionRequest(input *DescribeAnalysisDefinitionInput) (req *request.Request, output *DescribeAnalysisDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeAnalysisDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}/definition",
	}

	if input == nil {
		input = &DescribeAnalysisDefinitionInput{}
	}

	output = &DescribeAnalysisDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnalysisDefinition API operation for Amazon QuickSight.
//
// Provides a detailed description of the definition of an analysis.
//
// If you do not need to know details about the content of an Analysis, for
// instance if you are trying to check the status of a recently created or updated
// Analysis, use the DescribeAnalysis (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysis.html)
// instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAnalysisDefinition for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisDefinition
func (c *QuickSight) DescribeAnalysisDefinition(input *DescribeAnalysisDefinitionInput) (*DescribeAnalysisDefinitionOutput, error) {
	req, out := c.DescribeAnalysisDefinitionRequest(input)
	return out, req.Send()
}

// DescribeAnalysisDefinitionWithContext is the same as DescribeAnalysisDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnalysisDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAnalysisDefinitionWithContext(ctx aws.Context, input *DescribeAnalysisDefinitionInput, opts ...request.Option) (*DescribeAnalysisDefinitionOutput, error) {
	req, out := c.DescribeAnalysisDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnalysisPermissions = "DescribeAnalysisPermissions"

// DescribeAnalysisPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnalysisPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnalysisPermissions for more information on using the DescribeAnalysisPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAnalysisPermissionsRequest method.
//	req, resp := client.DescribeAnalysisPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions
func (c *QuickSight) DescribeAnalysisPermissionsRequest(input *DescribeAnalysisPermissionsInput) (req *request.Request, output *DescribeAnalysisPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAnalysisPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions",
	}

	if input == nil {
		input = &DescribeAnalysisPermissionsInput{}
	}

	output = &DescribeAnalysisPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnalysisPermissions API operation for Amazon QuickSight.
//
// Provides the read and write permissions for an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAnalysisPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions
func (c *QuickSight) DescribeAnalysisPermissions(input *DescribeAnalysisPermissionsInput) (*DescribeAnalysisPermissionsOutput, error) {
	req, out := c.DescribeAnalysisPermissionsRequest(input)
	return out, req.Send()
}

// DescribeAnalysisPermissionsWithContext is the same as DescribeAnalysisPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnalysisPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAnalysisPermissionsWithContext(ctx aws.Context, input *DescribeAnalysisPermissionsInput, opts ...request.Option) (*DescribeAnalysisPermissionsOutput, error) {
	req, out := c.DescribeAnalysisPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboard = "DescribeDashboard"

// DescribeDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboard for more information on using the DescribeDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDashboardRequest method.
//	req, resp := client.DescribeDashboardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard
func (c *QuickSight) DescribeDashboardRequest(input *DescribeDashboardInput) (req *request.Request, output *DescribeDashboardOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboard,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &DescribeDashboardInput{}
	}

	output = &DescribeDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboard API operation for Amazon QuickSight.
//
// Provides a summary for a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboard for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard
func (c *QuickSight) DescribeDashboard(input *DescribeDashboardInput) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	return out, req.Send()
}

// DescribeDashboardWithContext is the same as DescribeDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardWithContext(ctx aws.Context, input *DescribeDashboardInput, opts ...request.Option) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboardDefinition = "DescribeDashboardDefinition"

// DescribeDashboardDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboardDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboardDefinition for more information on using the DescribeDashboardDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDashboardDefinitionRequest method.
//	req, resp := client.DescribeDashboardDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardDefinition
func (c *QuickSight) DescribeDashboardDefinitionRequest(input *DescribeDashboardDefinitionInput) (req *request.Request, output *DescribeDashboardDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboardDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/definition",
	}

	if input == nil {
		input = &DescribeDashboardDefinitionInput{}
	}

	output = &DescribeDashboardDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboardDefinition API operation for Amazon QuickSight.
//
// Provides a detailed description of the definition of a dashboard.
//
// If you do not need to know details about the content of a dashboard, for
// instance if you are trying to check the status of a recently created or updated
// dashboard, use the DescribeDashboard (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboard.html)
// instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboardDefinition for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardDefinition
func (c *QuickSight) DescribeDashboardDefinition(input *DescribeDashboardDefinitionInput) (*DescribeDashboardDefinitionOutput, error) {
	req, out := c.DescribeDashboardDefinitionRequest(input)
	return out, req.Send()
}

// DescribeDashboardDefinitionWithContext is the same as DescribeDashboardDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboardDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardDefinitionWithContext(ctx aws.Context, input *DescribeDashboardDefinitionInput, opts ...request.Option) (*DescribeDashboardDefinitionOutput, error) {
	req, out := c.DescribeDashboardDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboardPermissions = "DescribeDashboardPermissions"

// DescribeDashboardPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboardPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboardPermissions for more information on using the DescribeDashboardPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDashboardPermissionsRequest method.
//	req, resp := client.DescribeDashboardPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions
func (c *QuickSight) DescribeDashboardPermissionsRequest(input *DescribeDashboardPermissionsInput) (req *request.Request, output *DescribeDashboardPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboardPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
	}

	if input == nil {
		input = &DescribeDashboardPermissionsInput{}
	}

	output = &DescribeDashboardPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboardPermissions API operation for Amazon QuickSight.
//
// Describes read and write permissions for a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboardPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions
func (c *QuickSight) DescribeDashboardPermissions(input *DescribeDashboardPermissionsInput) (*DescribeDashboardPermissionsOutput, error) {
	req, out := c.DescribeDashboardPermissionsRequest(input)
	return out, req.Send()
}

// DescribeDashboardPermissionsWithContext is the same as DescribeDashboardPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboardPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardPermissionsWithContext(ctx aws.Context, input *DescribeDashboardPermissionsInput, opts ...request.Option) (*DescribeDashboardPermissionsOutput, error) {
	req, out := c.DescribeDashboardPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSet = "DescribeDataSet"

// DescribeDataSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSet for more information on using the DescribeDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataSetRequest method.
//	req, resp := client.DescribeDataSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet
func (c *QuickSight) DescribeDataSetRequest(input *DescribeDataSetInput) (req *request.Request, output *DescribeDataSetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSet,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &DescribeDataSetInput{}
	}

	output = &DescribeDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSet API operation for Amazon QuickSight.
//
// Describes a dataset. This operation doesn't support datasets that include
// uploaded files as a source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet
func (c *QuickSight) DescribeDataSet(input *DescribeDataSetInput) (*DescribeDataSetOutput, error) {
	req, out := c.DescribeDataSetRequest(input)
	return out, req.Send()
}

// DescribeDataSetWithContext is the same as DescribeDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSetWithContext(ctx aws.Context, input *DescribeDataSetInput, opts ...request.Option) (*DescribeDataSetOutput, error) {
	req, out := c.DescribeDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSetPermissions = "DescribeDataSetPermissions"

// DescribeDataSetPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSetPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSetPermissions for more information on using the DescribeDataSetPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataSetPermissionsRequest method.
//	req, resp := client.DescribeDataSetPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions
func (c *QuickSight) DescribeDataSetPermissionsRequest(input *DescribeDataSetPermissionsInput) (req *request.Request, output *DescribeDataSetPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSetPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions",
	}

	if input == nil {
		input = &DescribeDataSetPermissionsInput{}
	}

	output = &DescribeDataSetPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSetPermissions API operation for Amazon QuickSight.
//
// Describes the permissions on a dataset.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/data-set-id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSetPermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions
func (c *QuickSight) DescribeDataSetPermissions(input *DescribeDataSetPermissionsInput) (*DescribeDataSetPermissionsOutput, error) {
	req, out := c.DescribeDataSetPermissionsRequest(input)
	return out, req.Send()
}

// DescribeDataSetPermissionsWithContext is the same as DescribeDataSetPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSetPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSetPermissionsWithContext(ctx aws.Context, input *DescribeDataSetPermissionsInput, opts ...request.Option) (*DescribeDataSetPermissionsOutput, error) {
	req, out := c.DescribeDataSetPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSetRefreshProperties = "DescribeDataSetRefreshProperties"

// DescribeDataSetRefreshPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSetRefreshProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSetRefreshProperties for more information on using the DescribeDataSetRefreshProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataSetRefreshPropertiesRequest method.
//	req, resp := client.DescribeDataSetRefreshPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetRefreshProperties
func (c *QuickSight) DescribeDataSetRefreshPropertiesRequest(input *DescribeDataSetRefreshPropertiesInput) (req *request.Request, output *DescribeDataSetRefreshPropertiesOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSetRefreshProperties,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-properties",
	}

	if input == nil {
		input = &DescribeDataSetRefreshPropertiesInput{}
	}

	output = &DescribeDataSetRefreshPropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSetRefreshProperties API operation for Amazon QuickSight.
//
// Describes the refresh properties of a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSetRefreshProperties for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetRefreshProperties
func (c *QuickSight) DescribeDataSetRefreshProperties(input *DescribeDataSetRefreshPropertiesInput) (*DescribeDataSetRefreshPropertiesOutput, error) {
	req, out := c.DescribeDataSetRefreshPropertiesRequest(input)
	return out, req.Send()
}

// DescribeDataSetRefreshPropertiesWithContext is the same as DescribeDataSetRefreshProperties with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSetRefreshProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSetRefreshPropertiesWithContext(ctx aws.Context, input *DescribeDataSetRefreshPropertiesInput, opts ...request.Option) (*DescribeDataSetRefreshPropertiesOutput, error) {
	req, out := c.DescribeDataSetRefreshPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSource = "DescribeDataSource"

// DescribeDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSource for more information on using the DescribeDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataSourceRequest method.
//	req, resp := client.DescribeDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource
func (c *QuickSight) DescribeDataSourceRequest(input *DescribeDataSourceInput) (req *request.Request, output *DescribeDataSourceOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &DescribeDataSourceInput{}
	}

	output = &DescribeDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSource API operation for Amazon QuickSight.
//
// Describes a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource
func (c *QuickSight) DescribeDataSource(input *DescribeDataSourceInput) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	return out, req.Send()
}

// DescribeDataSourceWithContext is the same as DescribeDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSourceWithContext(ctx aws.Context, input *DescribeDataSourceInput, opts ...request.Option) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSourcePermissions = "DescribeDataSourcePermissions"

// DescribeDataSourcePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSourcePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSourcePermissions for more information on using the DescribeDataSourcePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataSourcePermissionsRequest method.
//	req, resp := client.DescribeDataSourcePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions
func (c *QuickSight) DescribeDataSourcePermissionsRequest(input *DescribeDataSourcePermissionsInput) (req *request.Request, output *DescribeDataSourcePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSourcePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
	}

	if input == nil {
		input = &DescribeDataSourcePermissionsInput{}
	}

	output = &DescribeDataSourcePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSourcePermissions API operation for Amazon QuickSight.
//
// Describes the resource permissions for a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSourcePermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions
func (c *QuickSight) DescribeDataSourcePermissions(input *DescribeDataSourcePermissionsInput) (*DescribeDataSourcePermissionsOutput, error) {
	req, out := c.DescribeDataSourcePermissionsRequest(input)
	return out, req.Send()
}

// DescribeDataSourcePermissionsWithContext is the same as DescribeDataSourcePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSourcePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSourcePermissionsWithContext(ctx aws.Context, input *DescribeDataSourcePermissionsInput, opts ...request.Option) (*DescribeDataSourcePermissionsOutput, error) {
	req, out := c.DescribeDataSourcePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFolder = "DescribeFolder"

// DescribeFolderRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFolder for more information on using the DescribeFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFolderRequest method.
//	req, resp := client.DescribeFolderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolder
func (c *QuickSight) DescribeFolderRequest(input *DescribeFolderInput) (req *request.Request, output *DescribeFolderOutput) {
	op := &request.Operation{
		Name:       opDescribeFolder,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &DescribeFolderInput{}
	}

	output = &DescribeFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFolder API operation for Amazon QuickSight.
//
// Describes a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeFolder for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolder
func (c *QuickSight) DescribeFolder(input *DescribeFolderInput) (*DescribeFolderOutput, error) {
	req, out := c.DescribeFolderRequest(input)
	return out, req.Send()
}

// DescribeFolderWithContext is the same as DescribeFolder with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeFolderWithContext(ctx aws.Context, input *DescribeFolderInput, opts ...request.Option) (*DescribeFolderOutput, error) {
	req, out := c.DescribeFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFolderPermissions = "DescribeFolderPermissions"

// DescribeFolderPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFolderPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFolderPermissions for more information on using the DescribeFolderPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFolderPermissionsRequest method.
//	req, resp := client.DescribeFolderPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderPermissions
func (c *QuickSight) DescribeFolderPermissionsRequest(input *DescribeFolderPermissionsInput) (req *request.Request, output *DescribeFolderPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeFolderPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/permissions",
	}

	if input == nil {
		input = &DescribeFolderPermissionsInput{}
	}

	output = &DescribeFolderPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFolderPermissions API operation for Amazon QuickSight.
//
// Describes permissions for a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeFolderPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderPermissions
func (c *QuickSight) DescribeFolderPermissions(input *DescribeFolderPermissionsInput) (*DescribeFolderPermissionsOutput, error) {
	req, out := c.DescribeFolderPermissionsRequest(input)
	return out, req.Send()
}

// DescribeFolderPermissionsWithContext is the same as DescribeFolderPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFolderPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeFolderPermissionsWithContext(ctx aws.Context, input *DescribeFolderPermissionsInput, opts ...request.Option) (*DescribeFolderPermissionsOutput, error) {
	req, out := c.DescribeFolderPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFolderResolvedPermissions = "DescribeFolderResolvedPermissions"

// DescribeFolderResolvedPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFolderResolvedPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFolderResolvedPermissions for more information on using the DescribeFolderResolvedPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFolderResolvedPermissionsRequest method.
//	req, resp := client.DescribeFolderResolvedPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderResolvedPermissions
func (c *QuickSight) DescribeFolderResolvedPermissionsRequest(input *DescribeFolderResolvedPermissionsInput) (req *request.Request, output *DescribeFolderResolvedPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeFolderResolvedPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/resolved-permissions",
	}

	if input == nil {
		input = &DescribeFolderResolvedPermissionsInput{}
	}

	output = &DescribeFolderResolvedPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFolderResolvedPermissions API operation for Amazon QuickSight.
//
// Describes the folder resolved permissions. Permissions consists of both folder
// direct permissions and the inherited permissions from the ancestor folders.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeFolderResolvedPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderResolvedPermissions
func (c *QuickSight) DescribeFolderResolvedPermissions(input *DescribeFolderResolvedPermissionsInput) (*DescribeFolderResolvedPermissionsOutput, error) {
	req, out := c.DescribeFolderResolvedPermissionsRequest(input)
	return out, req.Send()
}

// DescribeFolderResolvedPermissionsWithContext is the same as DescribeFolderResolvedPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFolderResolvedPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeFolderResolvedPermissionsWithContext(ctx aws.Context, input *DescribeFolderResolvedPermissionsInput, opts ...request.Option) (*DescribeFolderResolvedPermissionsOutput, error) {
	req, out := c.DescribeFolderResolvedPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGroup = "DescribeGroup"

// DescribeGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroup for more information on using the DescribeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGroupRequest method.
//	req, resp := client.DescribeGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup
func (c *QuickSight) DescribeGroupRequest(input *DescribeGroupInput) (req *request.Request, output *DescribeGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &DescribeGroupInput{}
	}

	output = &DescribeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroup API operation for Amazon QuickSight.
//
// Returns an Amazon QuickSight group's description and Amazon Resource Name
// (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeGroup for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup
func (c *QuickSight) DescribeGroup(input *DescribeGroupInput) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	return out, req.Send()
}

// DescribeGroupWithContext is the same as DescribeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeGroupWithContext(ctx aws.Context, input *DescribeGroupInput, opts ...request.Option) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGroupMembership = "DescribeGroupMembership"

// DescribeGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroupMembership for more information on using the DescribeGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGroupMembershipRequest method.
//	req, resp := client.DescribeGroupMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroupMembership
func (c *QuickSight) DescribeGroupMembershipRequest(input *DescribeGroupMembershipInput) (req *request.Request, output *DescribeGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opDescribeGroupMembership,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &DescribeGroupMembershipInput{}
	}

	output = &DescribeGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroupMembership API operation for Amazon QuickSight.
//
// Use the DescribeGroupMembership operation to determine if a user is a member
// of the specified group. If the user exists and is a member of the specified
// group, an associated GroupMember object is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeGroupMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroupMembership
func (c *QuickSight) DescribeGroupMembership(input *DescribeGroupMembershipInput) (*DescribeGroupMembershipOutput, error) {
	req, out := c.DescribeGroupMembershipRequest(input)
	return out, req.Send()
}

// DescribeGroupMembershipWithContext is the same as DescribeGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeGroupMembershipWithContext(ctx aws.Context, input *DescribeGroupMembershipInput, opts ...request.Option) (*DescribeGroupMembershipOutput, error) {
	req, out := c.DescribeGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIAMPolicyAssignment = "DescribeIAMPolicyAssignment"

// DescribeIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIAMPolicyAssignment for more information on using the DescribeIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIAMPolicyAssignmentRequest method.
//	req, resp := client.DescribeIAMPolicyAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment
func (c *QuickSight) DescribeIAMPolicyAssignmentRequest(input *DescribeIAMPolicyAssignmentInput) (req *request.Request, output *DescribeIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opDescribeIAMPolicyAssignment,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &DescribeIAMPolicyAssignmentInput{}
	}

	output = &DescribeIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Describes an existing IAM policy assignment, as specified by the assignment
// name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment
func (c *QuickSight) DescribeIAMPolicyAssignment(input *DescribeIAMPolicyAssignmentInput) (*DescribeIAMPolicyAssignmentOutput, error) {
	req, out := c.DescribeIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// DescribeIAMPolicyAssignmentWithContext is the same as DescribeIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeIAMPolicyAssignmentWithContext(ctx aws.Context, input *DescribeIAMPolicyAssignmentInput, opts ...request.Option) (*DescribeIAMPolicyAssignmentOutput, error) {
	req, out := c.DescribeIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIngestion = "DescribeIngestion"

// DescribeIngestionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIngestion for more information on using the DescribeIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIngestionRequest method.
//	req, resp := client.DescribeIngestionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion
func (c *QuickSight) DescribeIngestionRequest(input *DescribeIngestionInput) (req *request.Request, output *DescribeIngestionOutput) {
	op := &request.Operation{
		Name:       opDescribeIngestion,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &DescribeIngestionInput{}
	}

	output = &DescribeIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIngestion API operation for Amazon QuickSight.
//
// Describes a SPICE ingestion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeIngestion for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion
func (c *QuickSight) DescribeIngestion(input *DescribeIngestionInput) (*DescribeIngestionOutput, error) {
	req, out := c.DescribeIngestionRequest(input)
	return out, req.Send()
}

// DescribeIngestionWithContext is the same as DescribeIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeIngestionWithContext(ctx aws.Context, input *DescribeIngestionInput, opts ...request.Option) (*DescribeIngestionOutput, error) {
	req, out := c.DescribeIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIpRestriction = "DescribeIpRestriction"

// DescribeIpRestrictionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIpRestriction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIpRestriction for more information on using the DescribeIpRestriction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIpRestrictionRequest method.
//	req, resp := client.DescribeIpRestrictionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIpRestriction
func (c *QuickSight) DescribeIpRestrictionRequest(input *DescribeIpRestrictionInput) (req *request.Request, output *DescribeIpRestrictionOutput) {
	op := &request.Operation{
		Name:       opDescribeIpRestriction,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/ip-restriction",
	}

	if input == nil {
		input = &DescribeIpRestrictionInput{}
	}

	output = &DescribeIpRestrictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIpRestriction API operation for Amazon QuickSight.
//
// Provides a summary and status of IP rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeIpRestriction for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIpRestriction
func (c *QuickSight) DescribeIpRestriction(input *DescribeIpRestrictionInput) (*DescribeIpRestrictionOutput, error) {
	req, out := c.DescribeIpRestrictionRequest(input)
	return out, req.Send()
}

// DescribeIpRestrictionWithContext is the same as DescribeIpRestriction with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIpRestriction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeIpRestrictionWithContext(ctx aws.Context, input *DescribeIpRestrictionInput, opts ...request.Option) (*DescribeIpRestrictionOutput, error) {
	req, out := c.DescribeIpRestrictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNamespace = "DescribeNamespace"

// DescribeNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNamespace for more information on using the DescribeNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeNamespaceRequest method.
//	req, resp := client.DescribeNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeNamespace
func (c *QuickSight) DescribeNamespaceRequest(input *DescribeNamespaceInput) (req *request.Request, output *DescribeNamespaceOutput) {
	op := &request.Operation{
		Name:       opDescribeNamespace,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}",
	}

	if input == nil {
		input = &DescribeNamespaceInput{}
	}

	output = &DescribeNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNamespace API operation for Amazon QuickSight.
//
// Describes the current namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeNamespace for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeNamespace
func (c *QuickSight) DescribeNamespace(input *DescribeNamespaceInput) (*DescribeNamespaceOutput, error) {
	req, out := c.DescribeNamespaceRequest(input)
	return out, req.Send()
}

// DescribeNamespaceWithContext is the same as DescribeNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeNamespaceWithContext(ctx aws.Context, input *DescribeNamespaceInput, opts ...request.Option) (*DescribeNamespaceOutput, error) {
	req, out := c.DescribeNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRefreshSchedule = "DescribeRefreshSchedule"

// DescribeRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRefreshSchedule for more information on using the DescribeRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRefreshScheduleRequest method.
//	req, resp := client.DescribeRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeRefreshSchedule
func (c *QuickSight) DescribeRefreshScheduleRequest(input *DescribeRefreshScheduleInput) (req *request.Request, output *DescribeRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeRefreshSchedule,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules/{ScheduleId}",
	}

	if input == nil {
		input = &DescribeRefreshScheduleInput{}
	}

	output = &DescribeRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRefreshSchedule API operation for Amazon QuickSight.
//
// Provides a summary of a refresh schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeRefreshSchedule
func (c *QuickSight) DescribeRefreshSchedule(input *DescribeRefreshScheduleInput) (*DescribeRefreshScheduleOutput, error) {
	req, out := c.DescribeRefreshScheduleRequest(input)
	return out, req.Send()
}

// DescribeRefreshScheduleWithContext is the same as DescribeRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeRefreshScheduleWithContext(ctx aws.Context, input *DescribeRefreshScheduleInput, opts ...request.Option) (*DescribeRefreshScheduleOutput, error) {
	req, out := c.DescribeRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplate = "DescribeTemplate"

// DescribeTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplate for more information on using the DescribeTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTemplateRequest method.
//	req, resp := client.DescribeTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate
func (c *QuickSight) DescribeTemplateRequest(input *DescribeTemplateInput) (req *request.Request, output *DescribeTemplateOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &DescribeTemplateInput{}
	}

	output = &DescribeTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplate API operation for Amazon QuickSight.
//
// Describes a template's metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate
func (c *QuickSight) DescribeTemplate(input *DescribeTemplateInput) (*DescribeTemplateOutput, error) {
	req, out := c.DescribeTemplateRequest(input)
	return out, req.Send()
}

// DescribeTemplateWithContext is the same as DescribeTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplateWithContext(ctx aws.Context, input *DescribeTemplateInput, opts ...request.Option) (*DescribeTemplateOutput, error) {
	req, out := c.DescribeTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplateAlias = "DescribeTemplateAlias"

// DescribeTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplateAlias for more information on using the DescribeTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTemplateAliasRequest method.
//	req, resp := client.DescribeTemplateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias
func (c *QuickSight) DescribeTemplateAliasRequest(input *DescribeTemplateAliasInput) (req *request.Request, output *DescribeTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplateAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DescribeTemplateAliasInput{}
	}

	output = &DescribeTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplateAlias API operation for Amazon QuickSight.
//
// Describes the template alias for a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplateAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias
func (c *QuickSight) DescribeTemplateAlias(input *DescribeTemplateAliasInput) (*DescribeTemplateAliasOutput, error) {
	req, out := c.DescribeTemplateAliasRequest(input)
	return out, req.Send()
}

// DescribeTemplateAliasWithContext is the same as DescribeTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplateAliasWithContext(ctx aws.Context, input *DescribeTemplateAliasInput, opts ...request.Option) (*DescribeTemplateAliasOutput, error) {
	req, out := c.DescribeTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplateDefinition = "DescribeTemplateDefinition"

// DescribeTemplateDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplateDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplateDefinition for more information on using the DescribeTemplateDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTemplateDefinitionRequest method.
//	req, resp := client.DescribeTemplateDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateDefinition
func (c *QuickSight) DescribeTemplateDefinitionRequest(input *DescribeTemplateDefinitionInput) (req *request.Request, output *DescribeTemplateDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplateDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/definition",
	}

	if input == nil {
		input = &DescribeTemplateDefinitionInput{}
	}

	output = &DescribeTemplateDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplateDefinition API operation for Amazon QuickSight.
//
// Provides a detailed description of the definition of a template.
//
// If you do not need to know details about the content of a template, for instance
// if you are trying to check the status of a recently created or updated template,
// use the DescribeTemplate (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplate.html)
// instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplateDefinition for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateDefinition
func (c *QuickSight) DescribeTemplateDefinition(input *DescribeTemplateDefinitionInput) (*DescribeTemplateDefinitionOutput, error) {
	req, out := c.DescribeTemplateDefinitionRequest(input)
	return out, req.Send()
}

// DescribeTemplateDefinitionWithContext is the same as DescribeTemplateDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplateDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplateDefinitionWithContext(ctx aws.Context, input *DescribeTemplateDefinitionInput, opts ...request.Option) (*DescribeTemplateDefinitionOutput, error) {
	req, out := c.DescribeTemplateDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplatePermissions = "DescribeTemplatePermissions"

// DescribeTemplatePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplatePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplatePermissions for more information on using the DescribeTemplatePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTemplatePermissionsRequest method.
//	req, resp := client.DescribeTemplatePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions
func (c *QuickSight) DescribeTemplatePermissionsRequest(input *DescribeTemplatePermissionsInput) (req *request.Request, output *DescribeTemplatePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplatePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/permissions",
	}

	if input == nil {
		input = &DescribeTemplatePermissionsInput{}
	}

	output = &DescribeTemplatePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplatePermissions API operation for Amazon QuickSight.
//
// Describes read and write permissions on a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplatePermissions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions
func (c *QuickSight) DescribeTemplatePermissions(input *DescribeTemplatePermissionsInput) (*DescribeTemplatePermissionsOutput, error) {
	req, out := c.DescribeTemplatePermissionsRequest(input)
	return out, req.Send()
}

// DescribeTemplatePermissionsWithContext is the same as DescribeTemplatePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplatePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplatePermissionsWithContext(ctx aws.Context, input *DescribeTemplatePermissionsInput, opts ...request.Option) (*DescribeTemplatePermissionsOutput, error) {
	req, out := c.DescribeTemplatePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTheme = "DescribeTheme"

// DescribeThemeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTheme for more information on using the DescribeTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeThemeRequest method.
//	req, resp := client.DescribeThemeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTheme
func (c *QuickSight) DescribeThemeRequest(input *DescribeThemeInput) (req *request.Request, output *DescribeThemeOutput) {
	op := &request.Operation{
		Name:       opDescribeTheme,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &DescribeThemeInput{}
	}

	output = &DescribeThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTheme API operation for Amazon QuickSight.
//
// Describes a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTheme for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTheme
func (c *QuickSight) DescribeTheme(input *DescribeThemeInput) (*DescribeThemeOutput, error) {
	req, out := c.DescribeThemeRequest(input)
	return out, req.Send()
}

// DescribeThemeWithContext is the same as DescribeTheme with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeThemeWithContext(ctx aws.Context, input *DescribeThemeInput, opts ...request.Option) (*DescribeThemeOutput, error) {
	req, out := c.DescribeThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThemeAlias = "DescribeThemeAlias"

// DescribeThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThemeAlias for more information on using the DescribeThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeThemeAliasRequest method.
//	req, resp := client.DescribeThemeAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemeAlias
func (c *QuickSight) DescribeThemeAliasRequest(input *DescribeThemeAliasInput) (req *request.Request, output *DescribeThemeAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeThemeAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DescribeThemeAliasInput{}
	}

	output = &DescribeThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThemeAlias API operation for Amazon QuickSight.
//
// Describes the alias for a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeThemeAlias for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemeAlias
func (c *QuickSight) DescribeThemeAlias(input *DescribeThemeAliasInput) (*DescribeThemeAliasOutput, error) {
	req, out := c.DescribeThemeAliasRequest(input)
	return out, req.Send()
}

// DescribeThemeAliasWithContext is the same as DescribeThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeThemeAliasWithContext(ctx aws.Context, input *DescribeThemeAliasInput, opts ...request.Option) (*DescribeThemeAliasOutput, error) {
	req, out := c.DescribeThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThemePermissions = "DescribeThemePermissions"

// DescribeThemePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThemePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThemePermissions for more information on using the DescribeThemePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeThemePermissionsRequest method.
//	req, resp := client.DescribeThemePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemePermissions
func (c *QuickSight) DescribeThemePermissionsRequest(input *DescribeThemePermissionsInput) (req *request.Request, output *DescribeThemePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeThemePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/permissions",
	}

	if input == nil {
		input = &DescribeThemePermissionsInput{}
	}

	output = &DescribeThemePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThemePermissions API operation for Amazon QuickSight.
//
// Describes the read and write permissions for a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeThemePermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemePermissions
func (c *QuickSight) DescribeThemePermissions(input *DescribeThemePermissionsInput) (*DescribeThemePermissionsOutput, error) {
	req, out := c.DescribeThemePermissionsRequest(input)
	return out, req.Send()
}

// DescribeThemePermissionsWithContext is the same as DescribeThemePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThemePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeThemePermissionsWithContext(ctx aws.Context, input *DescribeThemePermissionsInput, opts ...request.Option) (*DescribeThemePermissionsOutput, error) {
	req, out := c.DescribeThemePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeUserRequest method.
//	req, resp := client.DescribeUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser
func (c *QuickSight) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for Amazon QuickSight.
//
// Returns information about a user, given the user name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser
func (c *QuickSight) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateEmbedUrlForAnonymousUser = "GenerateEmbedUrlForAnonymousUser"

// GenerateEmbedUrlForAnonymousUserRequest generates a "aws/request.Request" representing the
// client's request for the GenerateEmbedUrlForAnonymousUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateEmbedUrlForAnonymousUser for more information on using the GenerateEmbedUrlForAnonymousUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateEmbedUrlForAnonymousUserRequest method.
//	req, resp := client.GenerateEmbedUrlForAnonymousUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForAnonymousUser
func (c *QuickSight) GenerateEmbedUrlForAnonymousUserRequest(input *GenerateEmbedUrlForAnonymousUserInput) (req *request.Request, output *GenerateEmbedUrlForAnonymousUserOutput) {
	op := &request.Operation{
		Name:       opGenerateEmbedUrlForAnonymousUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/embed-url/anonymous-user",
	}

	if input == nil {
		input = &GenerateEmbedUrlForAnonymousUserInput{}
	}

	output = &GenerateEmbedUrlForAnonymousUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateEmbedUrlForAnonymousUser API operation for Amazon QuickSight.
//
// Generates an embed URL that you can use to embed an Amazon QuickSight dashboard
// or visual in your website, without having to register any reader users. Before
// you use this action, make sure that you have configured the dashboards and
// permissions.
//
// The following rules apply to the generated URL:
//
//   - It contains a temporary bearer token. It is valid for 5 minutes after
//     it is generated. Once redeemed within this period, it cannot be re-used
//     again.
//
//   - The URL validity period should not be confused with the actual session
//     lifetime that can be customized using the SessionLifetimeInMinutes (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes)
//     parameter. The resulting user session is valid for 15 minutes (minimum)
//     to 10 hours (maximum). The default session duration is 10 hours.
//
//   - You are charged only when the URL is used or there is interaction with
//     Amazon QuickSight.
//
// For more information, see Embedded Analytics (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
// in the Amazon QuickSight User Guide.
//
// For more information about the high-level steps for embedding and for an
// interactive demo of the ways you can customize embedding, visit the Amazon
// QuickSight Developer Portal (https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GenerateEmbedUrlForAnonymousUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - SessionLifetimeInMinutesInvalidException
//     The number of minutes specified for the lifetime of a session isn't valid.
//     The session lifetime must be 15-600 minutes.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - UnsupportedPricingPlanException
//     This error indicates that you are calling an embedding operation in Amazon
//     QuickSight without the required pricing plan on your Amazon Web Services
//     account. Before you can use embedding for anonymous users, a QuickSight administrator
//     needs to add capacity pricing to Amazon QuickSight. You can do this on the
//     Manage Amazon QuickSight page.
//
//     After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//     API operation with the --identity-type ANONYMOUS option.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForAnonymousUser
func (c *QuickSight) GenerateEmbedUrlForAnonymousUser(input *GenerateEmbedUrlForAnonymousUserInput) (*GenerateEmbedUrlForAnonymousUserOutput, error) {
	req, out := c.GenerateEmbedUrlForAnonymousUserRequest(input)
	return out, req.Send()
}

// GenerateEmbedUrlForAnonymousUserWithContext is the same as GenerateEmbedUrlForAnonymousUser with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateEmbedUrlForAnonymousUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GenerateEmbedUrlForAnonymousUserWithContext(ctx aws.Context, input *GenerateEmbedUrlForAnonymousUserInput, opts ...request.Option) (*GenerateEmbedUrlForAnonymousUserOutput, error) {
	req, out := c.GenerateEmbedUrlForAnonymousUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateEmbedUrlForRegisteredUser = "GenerateEmbedUrlForRegisteredUser"

// GenerateEmbedUrlForRegisteredUserRequest generates a "aws/request.Request" representing the
// client's request for the GenerateEmbedUrlForRegisteredUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateEmbedUrlForRegisteredUser for more information on using the GenerateEmbedUrlForRegisteredUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateEmbedUrlForRegisteredUserRequest method.
//	req, resp := client.GenerateEmbedUrlForRegisteredUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForRegisteredUser
func (c *QuickSight) GenerateEmbedUrlForRegisteredUserRequest(input *GenerateEmbedUrlForRegisteredUserInput) (req *request.Request, output *GenerateEmbedUrlForRegisteredUserOutput) {
	op := &request.Operation{
		Name:       opGenerateEmbedUrlForRegisteredUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/embed-url/registered-user",
	}

	if input == nil {
		input = &GenerateEmbedUrlForRegisteredUserInput{}
	}

	output = &GenerateEmbedUrlForRegisteredUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateEmbedUrlForRegisteredUser API operation for Amazon QuickSight.
//
// Generates an embed URL that you can use to embed an Amazon QuickSight experience
// in your website. This action can be used for any type of user registered
// in an Amazon QuickSight account. Before you use this action, make sure that
// you have configured the relevant Amazon QuickSight resource and permissions.
//
// The following rules apply to the generated URL:
//
//   - It contains a temporary bearer token. It is valid for 5 minutes after
//     it is generated. Once redeemed within this period, it cannot be re-used
//     again.
//
//   - The URL validity period should not be confused with the actual session
//     lifetime that can be customized using the SessionLifetimeInMinutes (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes)
//     parameter. The resulting user session is valid for 15 minutes (minimum)
//     to 10 hours (maximum). The default session duration is 10 hours.
//
//   - You are charged only when the URL is used or there is interaction with
//     Amazon QuickSight.
//
// For more information, see Embedded Analytics (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
// in the Amazon QuickSight User Guide.
//
// For more information about the high-level steps for embedding and for an
// interactive demo of the ways you can customize embedding, visit the Amazon
// QuickSight Developer Portal (https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GenerateEmbedUrlForRegisteredUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - UserNotFoundException
//     The user with the provided name isn't found. This error can happen in any
//     operation that requires finding a user based on a provided user name, such
//     as DeleteUser, DescribeUser, and so on.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - SessionLifetimeInMinutesInvalidException
//     The number of minutes specified for the lifetime of a session isn't valid.
//     The session lifetime must be 15-600 minutes.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - UnsupportedPricingPlanException
//     This error indicates that you are calling an embedding operation in Amazon
//     QuickSight without the required pricing plan on your Amazon Web Services
//     account. Before you can use embedding for anonymous users, a QuickSight administrator
//     needs to add capacity pricing to Amazon QuickSight. You can do this on the
//     Manage Amazon QuickSight page.
//
//     After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//     API operation with the --identity-type ANONYMOUS option.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForRegisteredUser
func (c *QuickSight) GenerateEmbedUrlForRegisteredUser(input *GenerateEmbedUrlForRegisteredUserInput) (*GenerateEmbedUrlForRegisteredUserOutput, error) {
	req, out := c.GenerateEmbedUrlForRegisteredUserRequest(input)
	return out, req.Send()
}

// GenerateEmbedUrlForRegisteredUserWithContext is the same as GenerateEmbedUrlForRegisteredUser with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateEmbedUrlForRegisteredUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GenerateEmbedUrlForRegisteredUserWithContext(ctx aws.Context, input *GenerateEmbedUrlForRegisteredUserInput, opts ...request.Option) (*GenerateEmbedUrlForRegisteredUserOutput, error) {
	req, out := c.GenerateEmbedUrlForRegisteredUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDashboardEmbedUrl = "GetDashboardEmbedUrl"

// GetDashboardEmbedUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetDashboardEmbedUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDashboardEmbedUrl for more information on using the GetDashboardEmbedUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDashboardEmbedUrlRequest method.
//	req, resp := client.GetDashboardEmbedUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl
func (c *QuickSight) GetDashboardEmbedUrlRequest(input *GetDashboardEmbedUrlInput) (req *request.Request, output *GetDashboardEmbedUrlOutput) {
	op := &request.Operation{
		Name:       opGetDashboardEmbedUrl,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/embed-url",
	}

	if input == nil {
		input = &GetDashboardEmbedUrlInput{}
	}

	output = &GetDashboardEmbedUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDashboardEmbedUrl API operation for Amazon QuickSight.
//
// Generates a temporary session URL and authorization code(bearer token) that
// you can use to embed an Amazon QuickSight read-only dashboard in your website
// or application. Before you use this command, make sure that you have configured
// the dashboards and permissions.
//
// Currently, you can use GetDashboardEmbedURL only from the server, not from
// the user's browser. The following rules apply to the generated URL:
//
//   - They must be used together.
//
//   - They can be used one time only.
//
//   - They are valid for 5 minutes after you run this command.
//
//   - You are charged only when the URL is used or there is interaction with
//     Amazon QuickSight.
//
//   - The resulting user session is valid for 15 minutes (default) up to 10
//     hours (maximum). You can use the optional SessionLifetimeInMinutes parameter
//     to customize session duration.
//
// For more information, see Embedding Analytics Using GetDashboardEmbedUrl
// (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html)
// in the Amazon QuickSight User Guide.
//
// For more information about the high-level steps for embedding and for an
// interactive demo of the ways you can customize embedding, visit the Amazon
// QuickSight Developer Portal (https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GetDashboardEmbedUrl for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - DomainNotWhitelistedException
//     The domain specified isn't on the allow list. All domains for embedded dashboards
//     must be added to the approved list by an Amazon QuickSight admin.
//
//   - UserNotFoundException
//     The user with the provided name isn't found. This error can happen in any
//     operation that requires finding a user based on a provided user name, such
//     as DeleteUser, DescribeUser, and so on.
//
//   - IdentityTypeNotSupportedException
//     The identity type specified isn't supported. Supported identity types include
//     IAM and QUICKSIGHT.
//
//   - SessionLifetimeInMinutesInvalidException
//     The number of minutes specified for the lifetime of a session isn't valid.
//     The session lifetime must be 15-600 minutes.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - UnsupportedPricingPlanException
//     This error indicates that you are calling an embedding operation in Amazon
//     QuickSight without the required pricing plan on your Amazon Web Services
//     account. Before you can use embedding for anonymous users, a QuickSight administrator
//     needs to add capacity pricing to Amazon QuickSight. You can do this on the
//     Manage Amazon QuickSight page.
//
//     After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//     API operation with the --identity-type ANONYMOUS option.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl
func (c *QuickSight) GetDashboardEmbedUrl(input *GetDashboardEmbedUrlInput) (*GetDashboardEmbedUrlOutput, error) {
	req, out := c.GetDashboardEmbedUrlRequest(input)
	return out, req.Send()
}

// GetDashboardEmbedUrlWithContext is the same as GetDashboardEmbedUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetDashboardEmbedUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GetDashboardEmbedUrlWithContext(ctx aws.Context, input *GetDashboardEmbedUrlInput, opts ...request.Option) (*GetDashboardEmbedUrlOutput, error) {
	req, out := c.GetDashboardEmbedUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSessionEmbedUrl = "GetSessionEmbedUrl"

// GetSessionEmbedUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetSessionEmbedUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSessionEmbedUrl for more information on using the GetSessionEmbedUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSessionEmbedUrlRequest method.
//	req, resp := client.GetSessionEmbedUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetSessionEmbedUrl
func (c *QuickSight) GetSessionEmbedUrlRequest(input *GetSessionEmbedUrlInput) (req *request.Request, output *GetSessionEmbedUrlOutput) {
	op := &request.Operation{
		Name:       opGetSessionEmbedUrl,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/session-embed-url",
	}

	if input == nil {
		input = &GetSessionEmbedUrlInput{}
	}

	output = &GetSessionEmbedUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSessionEmbedUrl API operation for Amazon QuickSight.
//
// Generates a session URL and authorization code that you can use to embed
// the Amazon Amazon QuickSight console in your web server code. Use GetSessionEmbedUrl
// where you want to provide an authoring portal that allows users to create
// data sources, datasets, analyses, and dashboards. The users who access an
// embedded Amazon QuickSight console need belong to the author or admin security
// cohort. If you want to restrict permissions to some of these features, add
// a custom permissions profile to the user with the UpdateUser (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html)
// API operation. Use RegisterUser (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html)
// API operation to add a new user with a custom permission profile attached.
// For more information, see the following sections in the Amazon QuickSight
// User Guide:
//
//   - Embedding Analytics (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
//
//   - Customizing Access to the Amazon QuickSight Console (https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GetSessionEmbedUrl for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UserNotFoundException
//     The user with the provided name isn't found. This error can happen in any
//     operation that requires finding a user based on a provided user name, such
//     as DeleteUser, DescribeUser, and so on.
//
//   - SessionLifetimeInMinutesInvalidException
//     The number of minutes specified for the lifetime of a session isn't valid.
//     The session lifetime must be 15-600 minutes.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetSessionEmbedUrl
func (c *QuickSight) GetSessionEmbedUrl(input *GetSessionEmbedUrlInput) (*GetSessionEmbedUrlOutput, error) {
	req, out := c.GetSessionEmbedUrlRequest(input)
	return out, req.Send()
}

// GetSessionEmbedUrlWithContext is the same as GetSessionEmbedUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetSessionEmbedUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GetSessionEmbedUrlWithContext(ctx aws.Context, input *GetSessionEmbedUrlInput, opts ...request.Option) (*GetSessionEmbedUrlOutput, error) {
	req, out := c.GetSessionEmbedUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAnalyses = "ListAnalyses"

// ListAnalysesRequest generates a "aws/request.Request" representing the
// client's request for the ListAnalyses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnalyses for more information on using the ListAnalyses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAnalysesRequest method.
//	req, resp := client.ListAnalysesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses
func (c *QuickSight) ListAnalysesRequest(input *ListAnalysesInput) (req *request.Request, output *ListAnalysesOutput) {
	op := &request.Operation{
		Name:       opListAnalyses,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnalysesInput{}
	}

	output = &ListAnalysesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnalyses API operation for Amazon QuickSight.
//
// Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListAnalyses for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses
func (c *QuickSight) ListAnalyses(input *ListAnalysesInput) (*ListAnalysesOutput, error) {
	req, out := c.ListAnalysesRequest(input)
	return out, req.Send()
}

// ListAnalysesWithContext is the same as ListAnalyses with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnalyses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListAnalysesWithContext(ctx aws.Context, input *ListAnalysesInput, opts ...request.Option) (*ListAnalysesOutput, error) {
	req, out := c.ListAnalysesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnalysesPages iterates over the pages of a ListAnalyses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnalyses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAnalyses operation.
//	pageNum := 0
//	err := client.ListAnalysesPages(params,
//	    func(page *quicksight.ListAnalysesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListAnalysesPages(input *ListAnalysesInput, fn func(*ListAnalysesOutput, bool) bool) error {
	return c.ListAnalysesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnalysesPagesWithContext same as ListAnalysesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListAnalysesPagesWithContext(ctx aws.Context, input *ListAnalysesInput, fn func(*ListAnalysesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnalysesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnalysesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnalysesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDashboardVersions = "ListDashboardVersions"

// ListDashboardVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboardVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboardVersions for more information on using the ListDashboardVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDashboardVersionsRequest method.
//	req, resp := client.ListDashboardVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions
func (c *QuickSight) ListDashboardVersionsRequest(input *ListDashboardVersionsInput) (req *request.Request, output *ListDashboardVersionsOutput) {
	op := &request.Operation{
		Name:       opListDashboardVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardVersionsInput{}
	}

	output = &ListDashboardVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDashboardVersions API operation for Amazon QuickSight.
//
// Lists all the versions of the dashboards in the Amazon QuickSight subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDashboardVersions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions
func (c *QuickSight) ListDashboardVersions(input *ListDashboardVersionsInput) (*ListDashboardVersionsOutput, error) {
	req, out := c.ListDashboardVersionsRequest(input)
	return out, req.Send()
}

// ListDashboardVersionsWithContext is the same as ListDashboardVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboardVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardVersionsWithContext(ctx aws.Context, input *ListDashboardVersionsInput, opts ...request.Option) (*ListDashboardVersionsOutput, error) {
	req, out := c.ListDashboardVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDashboardVersionsPages iterates over the pages of a ListDashboardVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDashboardVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDashboardVersions operation.
//	pageNum := 0
//	err := client.ListDashboardVersionsPages(params,
//	    func(page *quicksight.ListDashboardVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListDashboardVersionsPages(input *ListDashboardVersionsInput, fn func(*ListDashboardVersionsOutput, bool) bool) error {
	return c.ListDashboardVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDashboardVersionsPagesWithContext same as ListDashboardVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardVersionsPagesWithContext(ctx aws.Context, input *ListDashboardVersionsInput, fn func(*ListDashboardVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDashboardVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDashboardVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDashboardVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDashboards = "ListDashboards"

// ListDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboards for more information on using the ListDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDashboardsRequest method.
//	req, resp := client.ListDashboardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards
func (c *QuickSight) ListDashboardsRequest(input *ListDashboardsInput) (req *request.Request, output *ListDashboardsOutput) {
	op := &request.Operation{
		Name:       opListDashboards,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardsInput{}
	}

	output = &ListDashboardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDashboards API operation for Amazon QuickSight.
//
// Lists dashboards in an Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDashboards for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards
func (c *QuickSight) ListDashboards(input *ListDashboardsInput) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	return out, req.Send()
}

// ListDashboardsWithContext is the same as ListDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardsWithContext(ctx aws.Context, input *ListDashboardsInput, opts ...request.Option) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDashboardsPages iterates over the pages of a ListDashboards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDashboards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDashboards operation.
//	pageNum := 0
//	err := client.ListDashboardsPages(params,
//	    func(page *quicksight.ListDashboardsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListDashboardsPages(input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool) error {
	return c.ListDashboardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDashboardsPagesWithContext same as ListDashboardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardsPagesWithContext(ctx aws.Context, input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDashboardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDashboardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDashboardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSets = "ListDataSets"

// ListDataSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSets for more information on using the ListDataSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSetsRequest method.
//	req, resp := client.ListDataSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets
func (c *QuickSight) ListDataSetsRequest(input *ListDataSetsInput) (req *request.Request, output *ListDataSetsOutput) {
	op := &request.Operation{
		Name:       opListDataSets,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSetsInput{}
	}

	output = &ListDataSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSets API operation for Amazon QuickSight.
//
// Lists all of the datasets belonging to the current Amazon Web Services account
// in an Amazon Web Services Region.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/*.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDataSets for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets
func (c *QuickSight) ListDataSets(input *ListDataSetsInput) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	return out, req.Send()
}

// ListDataSetsWithContext is the same as ListDataSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSetsWithContext(ctx aws.Context, input *ListDataSetsInput, opts ...request.Option) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSetsPages iterates over the pages of a ListDataSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSets operation.
//	pageNum := 0
//	err := client.ListDataSetsPages(params,
//	    func(page *quicksight.ListDataSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListDataSetsPages(input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool) error {
	return c.ListDataSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSetsPagesWithContext same as ListDataSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSetsPagesWithContext(ctx aws.Context, input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSourcesRequest method.
//	req, resp := client.ListDataSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources
func (c *QuickSight) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for Amazon QuickSight.
//
// Lists data sources in current Amazon Web Services Region that belong to this
// Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDataSources for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources
func (c *QuickSight) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourcesPages iterates over the pages of a ListDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSources operation.
//	pageNum := 0
//	err := client.ListDataSourcesPages(params,
//	    func(page *quicksight.ListDataSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListDataSourcesPages(input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool) error {
	return c.ListDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourcesPagesWithContext same as ListDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSourcesPagesWithContext(ctx aws.Context, input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFolderMembers = "ListFolderMembers"

// ListFolderMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListFolderMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFolderMembers for more information on using the ListFolderMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFolderMembersRequest method.
//	req, resp := client.ListFolderMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolderMembers
func (c *QuickSight) ListFolderMembersRequest(input *ListFolderMembersInput) (req *request.Request, output *ListFolderMembersOutput) {
	op := &request.Operation{
		Name:       opListFolderMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/members",
	}

	if input == nil {
		input = &ListFolderMembersInput{}
	}

	output = &ListFolderMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFolderMembers API operation for Amazon QuickSight.
//
// List all assets (DASHBOARD, ANALYSIS, and DATASET) in a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListFolderMembers for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolderMembers
func (c *QuickSight) ListFolderMembers(input *ListFolderMembersInput) (*ListFolderMembersOutput, error) {
	req, out := c.ListFolderMembersRequest(input)
	return out, req.Send()
}

// ListFolderMembersWithContext is the same as ListFolderMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListFolderMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListFolderMembersWithContext(ctx aws.Context, input *ListFolderMembersInput, opts ...request.Option) (*ListFolderMembersOutput, error) {
	req, out := c.ListFolderMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFolders = "ListFolders"

// ListFoldersRequest generates a "aws/request.Request" representing the
// client's request for the ListFolders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFolders for more information on using the ListFolders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFoldersRequest method.
//	req, resp := client.ListFoldersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolders
func (c *QuickSight) ListFoldersRequest(input *ListFoldersInput) (req *request.Request, output *ListFoldersOutput) {
	op := &request.Operation{
		Name:       opListFolders,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders",
	}

	if input == nil {
		input = &ListFoldersInput{}
	}

	output = &ListFoldersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFolders API operation for Amazon QuickSight.
//
// Lists all folders in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListFolders for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolders
func (c *QuickSight) ListFolders(input *ListFoldersInput) (*ListFoldersOutput, error) {
	req, out := c.ListFoldersRequest(input)
	return out, req.Send()
}

// ListFoldersWithContext is the same as ListFolders with the addition of
// the ability to pass a context and additional request options.
//
// See ListFolders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListFoldersWithContext(ctx aws.Context, input *ListFoldersInput, opts ...request.Option) (*ListFoldersOutput, error) {
	req, out := c.ListFoldersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupMemberships = "ListGroupMemberships"

// ListGroupMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupMemberships for more information on using the ListGroupMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGroupMembershipsRequest method.
//	req, resp := client.ListGroupMembershipsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships
func (c *QuickSight) ListGroupMembershipsRequest(input *ListGroupMembershipsInput) (req *request.Request, output *ListGroupMembershipsOutput) {
	op := &request.Operation{
		Name:       opListGroupMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members",
	}

	if input == nil {
		input = &ListGroupMembershipsInput{}
	}

	output = &ListGroupMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupMemberships API operation for Amazon QuickSight.
//
// Lists member users in a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListGroupMemberships for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships
func (c *QuickSight) ListGroupMemberships(input *ListGroupMembershipsInput) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	return out, req.Send()
}

// ListGroupMembershipsWithContext is the same as ListGroupMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupMembershipsWithContext(ctx aws.Context, input *ListGroupMembershipsInput, opts ...request.Option) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGroupsRequest method.
//	req, resp := client.ListGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups
func (c *QuickSight) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for Amazon QuickSight.
//
// Lists all user groups in Amazon QuickSight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListGroups for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups
func (c *QuickSight) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIAMPolicyAssignments = "ListIAMPolicyAssignments"

// ListIAMPolicyAssignmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListIAMPolicyAssignments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIAMPolicyAssignments for more information on using the ListIAMPolicyAssignments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIAMPolicyAssignmentsRequest method.
//	req, resp := client.ListIAMPolicyAssignmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments
func (c *QuickSight) ListIAMPolicyAssignmentsRequest(input *ListIAMPolicyAssignmentsInput) (req *request.Request, output *ListIAMPolicyAssignmentsOutput) {
	op := &request.Operation{
		Name:       opListIAMPolicyAssignments,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments",
	}

	if input == nil {
		input = &ListIAMPolicyAssignmentsInput{}
	}

	output = &ListIAMPolicyAssignmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIAMPolicyAssignments API operation for Amazon QuickSight.
//
// Lists IAM policy assignments in the current Amazon QuickSight account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIAMPolicyAssignments for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments
func (c *QuickSight) ListIAMPolicyAssignments(input *ListIAMPolicyAssignmentsInput) (*ListIAMPolicyAssignmentsOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsRequest(input)
	return out, req.Send()
}

// ListIAMPolicyAssignmentsWithContext is the same as ListIAMPolicyAssignments with the addition of
// the ability to pass a context and additional request options.
//
// See ListIAMPolicyAssignments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIAMPolicyAssignmentsWithContext(ctx aws.Context, input *ListIAMPolicyAssignmentsInput, opts ...request.Option) (*ListIAMPolicyAssignmentsOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIAMPolicyAssignmentsForUser = "ListIAMPolicyAssignmentsForUser"

// ListIAMPolicyAssignmentsForUserRequest generates a "aws/request.Request" representing the
// client's request for the ListIAMPolicyAssignmentsForUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIAMPolicyAssignmentsForUser for more information on using the ListIAMPolicyAssignmentsForUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIAMPolicyAssignmentsForUserRequest method.
//	req, resp := client.ListIAMPolicyAssignmentsForUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser
func (c *QuickSight) ListIAMPolicyAssignmentsForUserRequest(input *ListIAMPolicyAssignmentsForUserInput) (req *request.Request, output *ListIAMPolicyAssignmentsForUserOutput) {
	op := &request.Operation{
		Name:       opListIAMPolicyAssignmentsForUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/iam-policy-assignments",
	}

	if input == nil {
		input = &ListIAMPolicyAssignmentsForUserInput{}
	}

	output = &ListIAMPolicyAssignmentsForUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIAMPolicyAssignmentsForUser API operation for Amazon QuickSight.
//
// Lists all the IAM policy assignments, including the Amazon Resource Names
// (ARNs) for the IAM policies assigned to the specified user and group or groups
// that the user belongs to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIAMPolicyAssignmentsForUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConcurrentUpdatingException
//     A resource is already in a state that indicates an operation is happening
//     that must complete before a new update can be applied.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser
func (c *QuickSight) ListIAMPolicyAssignmentsForUser(input *ListIAMPolicyAssignmentsForUserInput) (*ListIAMPolicyAssignmentsForUserOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsForUserRequest(input)
	return out, req.Send()
}

// ListIAMPolicyAssignmentsForUserWithContext is the same as ListIAMPolicyAssignmentsForUser with the addition of
// the ability to pass a context and additional request options.
//
// See ListIAMPolicyAssignmentsForUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIAMPolicyAssignmentsForUserWithContext(ctx aws.Context, input *ListIAMPolicyAssignmentsForUserInput, opts ...request.Option) (*ListIAMPolicyAssignmentsForUserOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsForUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIngestions = "ListIngestions"

// ListIngestionsRequest generates a "aws/request.Request" representing the
// client's request for the ListIngestions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIngestions for more information on using the ListIngestions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIngestionsRequest method.
//	req, resp := client.ListIngestionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions
func (c *QuickSight) ListIngestionsRequest(input *ListIngestionsInput) (req *request.Request, output *ListIngestionsOutput) {
	op := &request.Operation{
		Name:       opListIngestions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIngestionsInput{}
	}

	output = &ListIngestionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIngestions API operation for Amazon QuickSight.
//
// Lists the history of SPICE ingestions for a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIngestions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions
func (c *QuickSight) ListIngestions(input *ListIngestionsInput) (*ListIngestionsOutput, error) {
	req, out := c.ListIngestionsRequest(input)
	return out, req.Send()
}

// ListIngestionsWithContext is the same as ListIngestions with the addition of
// the ability to pass a context and additional request options.
//
// See ListIngestions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIngestionsWithContext(ctx aws.Context, input *ListIngestionsInput, opts ...request.Option) (*ListIngestionsOutput, error) {
	req, out := c.ListIngestionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIngestionsPages iterates over the pages of a ListIngestions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIngestions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIngestions operation.
//	pageNum := 0
//	err := client.ListIngestionsPages(params,
//	    func(page *quicksight.ListIngestionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListIngestionsPages(input *ListIngestionsInput, fn func(*ListIngestionsOutput, bool) bool) error {
	return c.ListIngestionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIngestionsPagesWithContext same as ListIngestionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIngestionsPagesWithContext(ctx aws.Context, input *ListIngestionsInput, fn func(*ListIngestionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIngestionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIngestionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIngestionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNamespaces = "ListNamespaces"

// ListNamespacesRequest generates a "aws/request.Request" representing the
// client's request for the ListNamespaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNamespaces for more information on using the ListNamespaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNamespacesRequest method.
//	req, resp := client.ListNamespacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces
func (c *QuickSight) ListNamespacesRequest(input *ListNamespacesInput) (req *request.Request, output *ListNamespacesOutput) {
	op := &request.Operation{
		Name:       opListNamespaces,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNamespacesInput{}
	}

	output = &ListNamespacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNamespaces API operation for Amazon QuickSight.
//
// Lists the namespaces for the specified Amazon Web Services account. This
// operation doesn't list deleted namespaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListNamespaces for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces
func (c *QuickSight) ListNamespaces(input *ListNamespacesInput) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	return out, req.Send()
}

// ListNamespacesWithContext is the same as ListNamespaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamespaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListNamespacesWithContext(ctx aws.Context, input *ListNamespacesInput, opts ...request.Option) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNamespacesPages iterates over the pages of a ListNamespaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNamespaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNamespaces operation.
//	pageNum := 0
//	err := client.ListNamespacesPages(params,
//	    func(page *quicksight.ListNamespacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListNamespacesPages(input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool) error {
	return c.ListNamespacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNamespacesPagesWithContext same as ListNamespacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListNamespacesPagesWithContext(ctx aws.Context, input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNamespacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNamespacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNamespacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRefreshSchedules = "ListRefreshSchedules"

// ListRefreshSchedulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRefreshSchedules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRefreshSchedules for more information on using the ListRefreshSchedules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRefreshSchedulesRequest method.
//	req, resp := client.ListRefreshSchedulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListRefreshSchedules
func (c *QuickSight) ListRefreshSchedulesRequest(input *ListRefreshSchedulesInput) (req *request.Request, output *ListRefreshSchedulesOutput) {
	op := &request.Operation{
		Name:       opListRefreshSchedules,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules",
	}

	if input == nil {
		input = &ListRefreshSchedulesInput{}
	}

	output = &ListRefreshSchedulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRefreshSchedules API operation for Amazon QuickSight.
//
// Lists the refresh schedules of a dataset. Each dataset can have up to 5 schedules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListRefreshSchedules for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListRefreshSchedules
func (c *QuickSight) ListRefreshSchedules(input *ListRefreshSchedulesInput) (*ListRefreshSchedulesOutput, error) {
	req, out := c.ListRefreshSchedulesRequest(input)
	return out, req.Send()
}

// ListRefreshSchedulesWithContext is the same as ListRefreshSchedules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRefreshSchedules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListRefreshSchedulesWithContext(ctx aws.Context, input *ListRefreshSchedulesInput, opts ...request.Option) (*ListRefreshSchedulesOutput, error) {
	req, out := c.ListRefreshSchedulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource
func (c *QuickSight) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon QuickSight.
//
// Lists the tags assigned to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource
func (c *QuickSight) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTemplateAliases = "ListTemplateAliases"

// ListTemplateAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateAliases for more information on using the ListTemplateAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplateAliasesRequest method.
//	req, resp := client.ListTemplateAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases
func (c *QuickSight) ListTemplateAliasesRequest(input *ListTemplateAliasesInput) (req *request.Request, output *ListTemplateAliasesOutput) {
	op := &request.Operation{
		Name:       opListTemplateAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateAliasesInput{}
	}

	output = &ListTemplateAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateAliases API operation for Amazon QuickSight.
//
// Lists all the aliases of a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplateAliases for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases
func (c *QuickSight) ListTemplateAliases(input *ListTemplateAliasesInput) (*ListTemplateAliasesOutput, error) {
	req, out := c.ListTemplateAliasesRequest(input)
	return out, req.Send()
}

// ListTemplateAliasesWithContext is the same as ListTemplateAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateAliasesWithContext(ctx aws.Context, input *ListTemplateAliasesInput, opts ...request.Option) (*ListTemplateAliasesOutput, error) {
	req, out := c.ListTemplateAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateAliasesPages iterates over the pages of a ListTemplateAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplateAliases operation.
//	pageNum := 0
//	err := client.ListTemplateAliasesPages(params,
//	    func(page *quicksight.ListTemplateAliasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListTemplateAliasesPages(input *ListTemplateAliasesInput, fn func(*ListTemplateAliasesOutput, bool) bool) error {
	return c.ListTemplateAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateAliasesPagesWithContext same as ListTemplateAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateAliasesPagesWithContext(ctx aws.Context, input *ListTemplateAliasesInput, fn func(*ListTemplateAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTemplateVersions = "ListTemplateVersions"

// ListTemplateVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateVersions for more information on using the ListTemplateVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplateVersionsRequest method.
//	req, resp := client.ListTemplateVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions
func (c *QuickSight) ListTemplateVersionsRequest(input *ListTemplateVersionsInput) (req *request.Request, output *ListTemplateVersionsOutput) {
	op := &request.Operation{
		Name:       opListTemplateVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateVersionsInput{}
	}

	output = &ListTemplateVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateVersions API operation for Amazon QuickSight.
//
// Lists all the versions of the templates in the current Amazon QuickSight
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplateVersions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions
func (c *QuickSight) ListTemplateVersions(input *ListTemplateVersionsInput) (*ListTemplateVersionsOutput, error) {
	req, out := c.ListTemplateVersionsRequest(input)
	return out, req.Send()
}

// ListTemplateVersionsWithContext is the same as ListTemplateVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateVersionsWithContext(ctx aws.Context, input *ListTemplateVersionsInput, opts ...request.Option) (*ListTemplateVersionsOutput, error) {
	req, out := c.ListTemplateVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateVersionsPages iterates over the pages of a ListTemplateVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplateVersions operation.
//	pageNum := 0
//	err := client.ListTemplateVersionsPages(params,
//	    func(page *quicksight.ListTemplateVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListTemplateVersionsPages(input *ListTemplateVersionsInput, fn func(*ListTemplateVersionsOutput, bool) bool) error {
	return c.ListTemplateVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateVersionsPagesWithContext same as ListTemplateVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateVersionsPagesWithContext(ctx aws.Context, input *ListTemplateVersionsInput, fn func(*ListTemplateVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplates for more information on using the ListTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplatesRequest method.
//	req, resp := client.ListTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates
func (c *QuickSight) ListTemplatesRequest(input *ListTemplatesInput) (req *request.Request, output *ListTemplatesOutput) {
	op := &request.Operation{
		Name:       opListTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	output = &ListTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplates API operation for Amazon QuickSight.
//
// Lists all the templates in the current Amazon QuickSight account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates
func (c *QuickSight) ListTemplates(input *ListTemplatesInput) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	return out, req.Send()
}

// ListTemplatesWithContext is the same as ListTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplatesWithContext(ctx aws.Context, input *ListTemplatesInput, opts ...request.Option) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplatesPages iterates over the pages of a ListTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplates operation.
//	pageNum := 0
//	err := client.ListTemplatesPages(params,
//	    func(page *quicksight.ListTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListTemplatesPages(input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool) error {
	return c.ListTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplatesPagesWithContext same as ListTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplatesPagesWithContext(ctx aws.Context, input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListThemeAliases = "ListThemeAliases"

// ListThemeAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListThemeAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThemeAliases for more information on using the ListThemeAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListThemeAliasesRequest method.
//	req, resp := client.ListThemeAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeAliases
func (c *QuickSight) ListThemeAliasesRequest(input *ListThemeAliasesInput) (req *request.Request, output *ListThemeAliasesOutput) {
	op := &request.Operation{
		Name:       opListThemeAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases",
	}

	if input == nil {
		input = &ListThemeAliasesInput{}
	}

	output = &ListThemeAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThemeAliases API operation for Amazon QuickSight.
//
// Lists all the aliases of a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListThemeAliases for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeAliases
func (c *QuickSight) ListThemeAliases(input *ListThemeAliasesInput) (*ListThemeAliasesOutput, error) {
	req, out := c.ListThemeAliasesRequest(input)
	return out, req.Send()
}

// ListThemeAliasesWithContext is the same as ListThemeAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListThemeAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemeAliasesWithContext(ctx aws.Context, input *ListThemeAliasesInput, opts ...request.Option) (*ListThemeAliasesOutput, error) {
	req, out := c.ListThemeAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThemeVersions = "ListThemeVersions"

// ListThemeVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListThemeVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThemeVersions for more information on using the ListThemeVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListThemeVersionsRequest method.
//	req, resp := client.ListThemeVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions
func (c *QuickSight) ListThemeVersionsRequest(input *ListThemeVersionsInput) (req *request.Request, output *ListThemeVersionsOutput) {
	op := &request.Operation{
		Name:       opListThemeVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListThemeVersionsInput{}
	}

	output = &ListThemeVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThemeVersions API operation for Amazon QuickSight.
//
// Lists all the versions of the themes in the current Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListThemeVersions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions
func (c *QuickSight) ListThemeVersions(input *ListThemeVersionsInput) (*ListThemeVersionsOutput, error) {
	req, out := c.ListThemeVersionsRequest(input)
	return out, req.Send()
}

// ListThemeVersionsWithContext is the same as ListThemeVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListThemeVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemeVersionsWithContext(ctx aws.Context, input *ListThemeVersionsInput, opts ...request.Option) (*ListThemeVersionsOutput, error) {
	req, out := c.ListThemeVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListThemeVersionsPages iterates over the pages of a ListThemeVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListThemeVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListThemeVersions operation.
//	pageNum := 0
//	err := client.ListThemeVersionsPages(params,
//	    func(page *quicksight.ListThemeVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListThemeVersionsPages(input *ListThemeVersionsInput, fn func(*ListThemeVersionsOutput, bool) bool) error {
	return c.ListThemeVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListThemeVersionsPagesWithContext same as ListThemeVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemeVersionsPagesWithContext(ctx aws.Context, input *ListThemeVersionsInput, fn func(*ListThemeVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListThemeVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListThemeVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListThemeVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListThemes = "ListThemes"

// ListThemesRequest generates a "aws/request.Request" representing the
// client's request for the ListThemes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThemes for more information on using the ListThemes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListThemesRequest method.
//	req, resp := client.ListThemesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes
func (c *QuickSight) ListThemesRequest(input *ListThemesInput) (req *request.Request, output *ListThemesOutput) {
	op := &request.Operation{
		Name:       opListThemes,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListThemesInput{}
	}

	output = &ListThemesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThemes API operation for Amazon QuickSight.
//
// Lists all the themes in the current Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListThemes for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes
func (c *QuickSight) ListThemes(input *ListThemesInput) (*ListThemesOutput, error) {
	req, out := c.ListThemesRequest(input)
	return out, req.Send()
}

// ListThemesWithContext is the same as ListThemes with the addition of
// the ability to pass a context and additional request options.
//
// See ListThemes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemesWithContext(ctx aws.Context, input *ListThemesInput, opts ...request.Option) (*ListThemesOutput, error) {
	req, out := c.ListThemesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListThemesPages iterates over the pages of a ListThemes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListThemes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListThemes operation.
//	pageNum := 0
//	err := client.ListThemesPages(params,
//	    func(page *quicksight.ListThemesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) ListThemesPages(input *ListThemesInput, fn func(*ListThemesOutput, bool) bool) error {
	return c.ListThemesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListThemesPagesWithContext same as ListThemesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemesPagesWithContext(ctx aws.Context, input *ListThemesInput, fn func(*ListThemesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListThemesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListThemesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListThemesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUserGroups = "ListUserGroups"

// ListUserGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserGroups for more information on using the ListUserGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUserGroupsRequest method.
//	req, resp := client.ListUserGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups
func (c *QuickSight) ListUserGroupsRequest(input *ListUserGroupsInput) (req *request.Request, output *ListUserGroupsOutput) {
	op := &request.Operation{
		Name:       opListUserGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/groups",
	}

	if input == nil {
		input = &ListUserGroupsInput{}
	}

	output = &ListUserGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserGroups API operation for Amazon QuickSight.
//
// Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member
// of.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListUserGroups for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups
func (c *QuickSight) ListUserGroups(input *ListUserGroupsInput) (*ListUserGroupsOutput, error) {
	req, out := c.ListUserGroupsRequest(input)
	return out, req.Send()
}

// ListUserGroupsWithContext is the same as ListUserGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUserGroupsWithContext(ctx aws.Context, input *ListUserGroupsInput, opts ...request.Option) (*ListUserGroupsOutput, error) {
	req, out := c.ListUserGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUsersRequest method.
//	req, resp := client.ListUsersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers
func (c *QuickSight) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon QuickSight.
//
// Returns a list of all of the Amazon QuickSight users belonging to this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers
func (c *QuickSight) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDataSetRefreshProperties = "PutDataSetRefreshProperties"

// PutDataSetRefreshPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the PutDataSetRefreshProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDataSetRefreshProperties for more information on using the PutDataSetRefreshProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutDataSetRefreshPropertiesRequest method.
//	req, resp := client.PutDataSetRefreshPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/PutDataSetRefreshProperties
func (c *QuickSight) PutDataSetRefreshPropertiesRequest(input *PutDataSetRefreshPropertiesInput) (req *request.Request, output *PutDataSetRefreshPropertiesOutput) {
	op := &request.Operation{
		Name:       opPutDataSetRefreshProperties,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-properties",
	}

	if input == nil {
		input = &PutDataSetRefreshPropertiesInput{}
	}

	output = &PutDataSetRefreshPropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutDataSetRefreshProperties API operation for Amazon QuickSight.
//
// Creates or updates the dataset refresh properties for the dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation PutDataSetRefreshProperties for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/PutDataSetRefreshProperties
func (c *QuickSight) PutDataSetRefreshProperties(input *PutDataSetRefreshPropertiesInput) (*PutDataSetRefreshPropertiesOutput, error) {
	req, out := c.PutDataSetRefreshPropertiesRequest(input)
	return out, req.Send()
}

// PutDataSetRefreshPropertiesWithContext is the same as PutDataSetRefreshProperties with the addition of
// the ability to pass a context and additional request options.
//
// See PutDataSetRefreshProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) PutDataSetRefreshPropertiesWithContext(ctx aws.Context, input *PutDataSetRefreshPropertiesInput, opts ...request.Option) (*PutDataSetRefreshPropertiesOutput, error) {
	req, out := c.PutDataSetRefreshPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterUser = "RegisterUser"

// RegisterUserRequest generates a "aws/request.Request" representing the
// client's request for the RegisterUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterUser for more information on using the RegisterUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterUserRequest method.
//	req, resp := client.RegisterUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser
func (c *QuickSight) RegisterUserRequest(input *RegisterUserInput) (req *request.Request, output *RegisterUserOutput) {
	op := &request.Operation{
		Name:       opRegisterUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
	}

	if input == nil {
		input = &RegisterUserInput{}
	}

	output = &RegisterUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterUser API operation for Amazon QuickSight.
//
// Creates an Amazon QuickSight user whose identity is associated with the Identity
// and Access Management (IAM) identity or role specified in the request. When
// you register a new user from the Amazon QuickSight API, Amazon QuickSight
// generates a registration URL. The user accesses this registration URL to
// create their account. Amazon QuickSight doesn't send a registration email
// to users who are registered from the Amazon QuickSight API. If you want new
// users to receive a registration email, then add those users in the Amazon
// QuickSight console. For more information on registering a new user in the
// Amazon QuickSight console, see Inviting users to access Amazon QuickSight
// (https://docs.aws.amazon.com/quicksight/latest/user/managing-users.html#inviting-users).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation RegisterUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser
func (c *QuickSight) RegisterUser(input *RegisterUserInput) (*RegisterUserOutput, error) {
	req, out := c.RegisterUserRequest(input)
	return out, req.Send()
}

// RegisterUserWithContext is the same as RegisterUser with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) RegisterUserWithContext(ctx aws.Context, input *RegisterUserInput, opts ...request.Option) (*RegisterUserOutput, error) {
	req, out := c.RegisterUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreAnalysis = "RestoreAnalysis"

// RestoreAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the RestoreAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreAnalysis for more information on using the RestoreAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreAnalysisRequest method.
//	req, resp := client.RestoreAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RestoreAnalysis
func (c *QuickSight) RestoreAnalysisRequest(input *RestoreAnalysisInput) (req *request.Request, output *RestoreAnalysisOutput) {
	op := &request.Operation{
		Name:       opRestoreAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/restore/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &RestoreAnalysisInput{}
	}

	output = &RestoreAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreAnalysis API operation for Amazon QuickSight.
//
// Restores an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation RestoreAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RestoreAnalysis
func (c *QuickSight) RestoreAnalysis(input *RestoreAnalysisInput) (*RestoreAnalysisOutput, error) {
	req, out := c.RestoreAnalysisRequest(input)
	return out, req.Send()
}

// RestoreAnalysisWithContext is the same as RestoreAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) RestoreAnalysisWithContext(ctx aws.Context, input *RestoreAnalysisInput, opts ...request.Option) (*RestoreAnalysisOutput, error) {
	req, out := c.RestoreAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchAnalyses = "SearchAnalyses"

// SearchAnalysesRequest generates a "aws/request.Request" representing the
// client's request for the SearchAnalyses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAnalyses for more information on using the SearchAnalyses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchAnalysesRequest method.
//	req, resp := client.SearchAnalysesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses
func (c *QuickSight) SearchAnalysesRequest(input *SearchAnalysesInput) (req *request.Request, output *SearchAnalysesOutput) {
	op := &request.Operation{
		Name:       opSearchAnalyses,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/analyses",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchAnalysesInput{}
	}

	output = &SearchAnalysesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAnalyses API operation for Amazon QuickSight.
//
// Searches for analyses that belong to the user specified in the filter.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchAnalyses for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses
func (c *QuickSight) SearchAnalyses(input *SearchAnalysesInput) (*SearchAnalysesOutput, error) {
	req, out := c.SearchAnalysesRequest(input)
	return out, req.Send()
}

// SearchAnalysesWithContext is the same as SearchAnalyses with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAnalyses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchAnalysesWithContext(ctx aws.Context, input *SearchAnalysesInput, opts ...request.Option) (*SearchAnalysesOutput, error) {
	req, out := c.SearchAnalysesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchAnalysesPages iterates over the pages of a SearchAnalyses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchAnalyses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchAnalyses operation.
//	pageNum := 0
//	err := client.SearchAnalysesPages(params,
//	    func(page *quicksight.SearchAnalysesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) SearchAnalysesPages(input *SearchAnalysesInput, fn func(*SearchAnalysesOutput, bool) bool) error {
	return c.SearchAnalysesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchAnalysesPagesWithContext same as SearchAnalysesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchAnalysesPagesWithContext(ctx aws.Context, input *SearchAnalysesInput, fn func(*SearchAnalysesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchAnalysesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchAnalysesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchAnalysesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchDashboards = "SearchDashboards"

// SearchDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the SearchDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDashboards for more information on using the SearchDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchDashboardsRequest method.
//	req, resp := client.SearchDashboardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards
func (c *QuickSight) SearchDashboardsRequest(input *SearchDashboardsInput) (req *request.Request, output *SearchDashboardsOutput) {
	op := &request.Operation{
		Name:       opSearchDashboards,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/dashboards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDashboardsInput{}
	}

	output = &SearchDashboardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDashboards API operation for Amazon QuickSight.
//
// Searches for dashboards that belong to a user.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchDashboards for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards
func (c *QuickSight) SearchDashboards(input *SearchDashboardsInput) (*SearchDashboardsOutput, error) {
	req, out := c.SearchDashboardsRequest(input)
	return out, req.Send()
}

// SearchDashboardsWithContext is the same as SearchDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDashboardsWithContext(ctx aws.Context, input *SearchDashboardsInput, opts ...request.Option) (*SearchDashboardsOutput, error) {
	req, out := c.SearchDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchDashboardsPages iterates over the pages of a SearchDashboards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchDashboards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchDashboards operation.
//	pageNum := 0
//	err := client.SearchDashboardsPages(params,
//	    func(page *quicksight.SearchDashboardsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) SearchDashboardsPages(input *SearchDashboardsInput, fn func(*SearchDashboardsOutput, bool) bool) error {
	return c.SearchDashboardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchDashboardsPagesWithContext same as SearchDashboardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDashboardsPagesWithContext(ctx aws.Context, input *SearchDashboardsInput, fn func(*SearchDashboardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchDashboardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchDashboardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchDashboardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchDataSets = "SearchDataSets"

// SearchDataSetsRequest generates a "aws/request.Request" representing the
// client's request for the SearchDataSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDataSets for more information on using the SearchDataSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchDataSetsRequest method.
//	req, resp := client.SearchDataSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSets
func (c *QuickSight) SearchDataSetsRequest(input *SearchDataSetsInput) (req *request.Request, output *SearchDataSetsOutput) {
	op := &request.Operation{
		Name:       opSearchDataSets,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/data-sets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDataSetsInput{}
	}

	output = &SearchDataSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDataSets API operation for Amazon QuickSight.
//
// Use the SearchDataSets operation to search for datasets that belong to an
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchDataSets for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSets
func (c *QuickSight) SearchDataSets(input *SearchDataSetsInput) (*SearchDataSetsOutput, error) {
	req, out := c.SearchDataSetsRequest(input)
	return out, req.Send()
}

// SearchDataSetsWithContext is the same as SearchDataSets with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDataSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDataSetsWithContext(ctx aws.Context, input *SearchDataSetsInput, opts ...request.Option) (*SearchDataSetsOutput, error) {
	req, out := c.SearchDataSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchDataSetsPages iterates over the pages of a SearchDataSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchDataSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchDataSets operation.
//	pageNum := 0
//	err := client.SearchDataSetsPages(params,
//	    func(page *quicksight.SearchDataSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) SearchDataSetsPages(input *SearchDataSetsInput, fn func(*SearchDataSetsOutput, bool) bool) error {
	return c.SearchDataSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchDataSetsPagesWithContext same as SearchDataSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDataSetsPagesWithContext(ctx aws.Context, input *SearchDataSetsInput, fn func(*SearchDataSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchDataSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchDataSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchDataSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchDataSources = "SearchDataSources"

// SearchDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the SearchDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDataSources for more information on using the SearchDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchDataSourcesRequest method.
//	req, resp := client.SearchDataSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSources
func (c *QuickSight) SearchDataSourcesRequest(input *SearchDataSourcesInput) (req *request.Request, output *SearchDataSourcesOutput) {
	op := &request.Operation{
		Name:       opSearchDataSources,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/data-sources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDataSourcesInput{}
	}

	output = &SearchDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDataSources API operation for Amazon QuickSight.
//
// Use the SearchDataSources operation to search for data sources that belong
// to an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchDataSources for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSources
func (c *QuickSight) SearchDataSources(input *SearchDataSourcesInput) (*SearchDataSourcesOutput, error) {
	req, out := c.SearchDataSourcesRequest(input)
	return out, req.Send()
}

// SearchDataSourcesWithContext is the same as SearchDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDataSourcesWithContext(ctx aws.Context, input *SearchDataSourcesInput, opts ...request.Option) (*SearchDataSourcesOutput, error) {
	req, out := c.SearchDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchDataSourcesPages iterates over the pages of a SearchDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchDataSources operation.
//	pageNum := 0
//	err := client.SearchDataSourcesPages(params,
//	    func(page *quicksight.SearchDataSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QuickSight) SearchDataSourcesPages(input *SearchDataSourcesInput, fn func(*SearchDataSourcesOutput, bool) bool) error {
	return c.SearchDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchDataSourcesPagesWithContext same as SearchDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDataSourcesPagesWithContext(ctx aws.Context, input *SearchDataSourcesInput, fn func(*SearchDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchFolders = "SearchFolders"

// SearchFoldersRequest generates a "aws/request.Request" representing the
// client's request for the SearchFolders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchFolders for more information on using the SearchFolders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchFoldersRequest method.
//	req, resp := client.SearchFoldersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchFolders
func (c *QuickSight) SearchFoldersRequest(input *SearchFoldersInput) (req *request.Request, output *SearchFoldersOutput) {
	op := &request.Operation{
		Name:       opSearchFolders,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/folders",
	}

	if input == nil {
		input = &SearchFoldersInput{}
	}

	output = &SearchFoldersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchFolders API operation for Amazon QuickSight.
//
// Searches the subfolders in a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchFolders for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InvalidRequestException
//     You don't have this feature activated for your account. To fix this issue,
//     contact Amazon Web Services support.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchFolders
func (c *QuickSight) SearchFolders(input *SearchFoldersInput) (*SearchFoldersOutput, error) {
	req, out := c.SearchFoldersRequest(input)
	return out, req.Send()
}

// SearchFoldersWithContext is the same as SearchFolders with the addition of
// the ability to pass a context and additional request options.
//
// See SearchFolders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchFoldersWithContext(ctx aws.Context, input *SearchFoldersInput, opts ...request.Option) (*SearchFoldersOutput, error) {
	req, out := c.SearchFoldersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchGroups = "SearchGroups"

// SearchGroupsRequest generates a "aws/request.Request" representing the
// client's request for the SearchGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchGroups for more information on using the SearchGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchGroupsRequest method.
//	req, resp := client.SearchGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchGroups
func (c *QuickSight) SearchGroupsRequest(input *SearchGroupsInput) (req *request.Request, output *SearchGroupsOutput) {
	op := &request.Operation{
		Name:       opSearchGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups-search",
	}

	if input == nil {
		input = &SearchGroupsInput{}
	}

	output = &SearchGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchGroups API operation for Amazon QuickSight.
//
// Use the SearchGroups operation to search groups in a specified Amazon QuickSight
// namespace using the supplied filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchGroups for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidNextTokenException
//     The NextToken value isn't valid.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchGroups
func (c *QuickSight) SearchGroups(input *SearchGroupsInput) (*SearchGroupsOutput, error) {
	req, out := c.SearchGroupsRequest(input)
	return out, req.Send()
}

// SearchGroupsWithContext is the same as SearchGroups with the addition of
// the ability to pass a context and additional request options.
//
// See SearchGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchGroupsWithContext(ctx aws.Context, input *SearchGroupsInput, opts ...request.Option) (*SearchGroupsOutput, error) {
	req, out := c.SearchGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource
func (c *QuickSight) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for Amazon QuickSight.
//
// Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight
// resource.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions, by granting a user permission to access or
// change only resources with certain tag values. You can use the TagResource
// operation with a resource that already has tags. If you specify a new tag
// key for the resource, this tag is appended to the list of tags associated
// with the resource. If you specify a tag key that is already associated with
// the resource, the new tag value that you specify replaces the previous value
// for that tag.
//
// You can associate as many as 50 tags with a resource. Amazon QuickSight supports
// tagging on data set, data source, dashboard, and template.
//
// Tagging for Amazon QuickSight works in a similar way to tagging for other
// Amazon Web Services services, except for the following:
//
//   - You can't use tags to track costs for Amazon QuickSight. This isn't
//     possible because you can't tag the resources that Amazon QuickSight costs
//     are based on, for example Amazon QuickSight storage capacity (SPICE),
//     number of users, type of users, and usage metrics.
//
//   - Amazon QuickSight doesn't currently support the tag editor for Resource
//     Groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource
func (c *QuickSight) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource
func (c *QuickSight) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for Amazon QuickSight.
//
// Removes a tag or tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource
func (c *QuickSight) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountCustomization = "UpdateAccountCustomization"

// UpdateAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountCustomization for more information on using the UpdateAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountCustomizationRequest method.
//	req, resp := client.UpdateAccountCustomizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountCustomization
func (c *QuickSight) UpdateAccountCustomizationRequest(input *UpdateAccountCustomizationInput) (req *request.Request, output *UpdateAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountCustomization,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &UpdateAccountCustomizationInput{}
	}

	output = &UpdateAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountCustomization API operation for Amazon QuickSight.
//
// Updates Amazon QuickSight customizations for the current Amazon Web Services
// Region. Currently, the only customization that you can use is a theme.
//
// You can use customizations for your Amazon Web Services account or, if you
// specify a namespace, for a Amazon QuickSight namespace instead. Customizations
// that apply to a namespace override customizations that apply to an Amazon
// Web Services account. To find out which customizations apply, use the DescribeAccountCustomization
// API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAccountCustomization for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountCustomization
func (c *QuickSight) UpdateAccountCustomization(input *UpdateAccountCustomizationInput) (*UpdateAccountCustomizationOutput, error) {
	req, out := c.UpdateAccountCustomizationRequest(input)
	return out, req.Send()
}

// UpdateAccountCustomizationWithContext is the same as UpdateAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAccountCustomizationWithContext(ctx aws.Context, input *UpdateAccountCustomizationInput, opts ...request.Option) (*UpdateAccountCustomizationOutput, error) {
	req, out := c.UpdateAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountSettings = "UpdateAccountSettings"

// UpdateAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountSettings for more information on using the UpdateAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountSettingsRequest method.
//	req, resp := client.UpdateAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountSettings
func (c *QuickSight) UpdateAccountSettingsRequest(input *UpdateAccountSettingsInput) (req *request.Request, output *UpdateAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/settings",
	}

	if input == nil {
		input = &UpdateAccountSettingsInput{}
	}

	output = &UpdateAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountSettings API operation for Amazon QuickSight.
//
// Updates the Amazon QuickSight settings in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountSettings
func (c *QuickSight) UpdateAccountSettings(input *UpdateAccountSettingsInput) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	return out, req.Send()
}

// UpdateAccountSettingsWithContext is the same as UpdateAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAccountSettingsWithContext(ctx aws.Context, input *UpdateAccountSettingsInput, opts ...request.Option) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnalysis = "UpdateAnalysis"

// UpdateAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnalysis for more information on using the UpdateAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAnalysisRequest method.
//	req, resp := client.UpdateAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysis
func (c *QuickSight) UpdateAnalysisRequest(input *UpdateAnalysisInput) (req *request.Request, output *UpdateAnalysisOutput) {
	op := &request.Operation{
		Name:       opUpdateAnalysis,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &UpdateAnalysisInput{}
	}

	output = &UpdateAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnalysis API operation for Amazon QuickSight.
//
// # Updates an analysis in Amazon QuickSight
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysis
func (c *QuickSight) UpdateAnalysis(input *UpdateAnalysisInput) (*UpdateAnalysisOutput, error) {
	req, out := c.UpdateAnalysisRequest(input)
	return out, req.Send()
}

// UpdateAnalysisWithContext is the same as UpdateAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAnalysisWithContext(ctx aws.Context, input *UpdateAnalysisInput, opts ...request.Option) (*UpdateAnalysisOutput, error) {
	req, out := c.UpdateAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnalysisPermissions = "UpdateAnalysisPermissions"

// UpdateAnalysisPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnalysisPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnalysisPermissions for more information on using the UpdateAnalysisPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAnalysisPermissionsRequest method.
//	req, resp := client.UpdateAnalysisPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysisPermissions
func (c *QuickSight) UpdateAnalysisPermissionsRequest(input *UpdateAnalysisPermissionsInput) (req *request.Request, output *UpdateAnalysisPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateAnalysisPermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions",
	}

	if input == nil {
		input = &UpdateAnalysisPermissionsInput{}
	}

	output = &UpdateAnalysisPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnalysisPermissions API operation for Amazon QuickSight.
//
// Updates the read and write permissions for an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAnalysisPermissions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysisPermissions
func (c *QuickSight) UpdateAnalysisPermissions(input *UpdateAnalysisPermissionsInput) (*UpdateAnalysisPermissionsOutput, error) {
	req, out := c.UpdateAnalysisPermissionsRequest(input)
	return out, req.Send()
}

// UpdateAnalysisPermissionsWithContext is the same as UpdateAnalysisPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnalysisPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAnalysisPermissionsWithContext(ctx aws.Context, input *UpdateAnalysisPermissionsInput, opts ...request.Option) (*UpdateAnalysisPermissionsOutput, error) {
	req, out := c.UpdateAnalysisPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboard = "UpdateDashboard"

// UpdateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboard for more information on using the UpdateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDashboardRequest method.
//	req, resp := client.UpdateDashboardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard
func (c *QuickSight) UpdateDashboardRequest(input *UpdateDashboardInput) (req *request.Request, output *UpdateDashboardOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboard,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &UpdateDashboardInput{}
	}

	output = &UpdateDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboard API operation for Amazon QuickSight.
//
// Updates a dashboard in an Amazon Web Services account.
//
// Updating a Dashboard creates a new dashboard version but does not immediately
// publish the new version. You can update the published version of a dashboard
// by using the UpdateDashboardPublishedVersion (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html)
// API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboard for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard
func (c *QuickSight) UpdateDashboard(input *UpdateDashboardInput) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	return out, req.Send()
}

// UpdateDashboardWithContext is the same as UpdateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardWithContext(ctx aws.Context, input *UpdateDashboardInput, opts ...request.Option) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboardPermissions = "UpdateDashboardPermissions"

// UpdateDashboardPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboardPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboardPermissions for more information on using the UpdateDashboardPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDashboardPermissionsRequest method.
//	req, resp := client.UpdateDashboardPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions
func (c *QuickSight) UpdateDashboardPermissionsRequest(input *UpdateDashboardPermissionsInput) (req *request.Request, output *UpdateDashboardPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboardPermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
	}

	if input == nil {
		input = &UpdateDashboardPermissionsInput{}
	}

	output = &UpdateDashboardPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboardPermissions API operation for Amazon QuickSight.
//
// Updates read and write permissions on a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboardPermissions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions
func (c *QuickSight) UpdateDashboardPermissions(input *UpdateDashboardPermissionsInput) (*UpdateDashboardPermissionsOutput, error) {
	req, out := c.UpdateDashboardPermissionsRequest(input)
	return out, req.Send()
}

// UpdateDashboardPermissionsWithContext is the same as UpdateDashboardPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboardPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardPermissionsWithContext(ctx aws.Context, input *UpdateDashboardPermissionsInput, opts ...request.Option) (*UpdateDashboardPermissionsOutput, error) {
	req, out := c.UpdateDashboardPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboardPublishedVersion = "UpdateDashboardPublishedVersion"

// UpdateDashboardPublishedVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboardPublishedVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboardPublishedVersion for more information on using the UpdateDashboardPublishedVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDashboardPublishedVersionRequest method.
//	req, resp := client.UpdateDashboardPublishedVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion
func (c *QuickSight) UpdateDashboardPublishedVersionRequest(input *UpdateDashboardPublishedVersionInput) (req *request.Request, output *UpdateDashboardPublishedVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboardPublishedVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions/{VersionNumber}",
	}

	if input == nil {
		input = &UpdateDashboardPublishedVersionInput{}
	}

	output = &UpdateDashboardPublishedVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboardPublishedVersion API operation for Amazon QuickSight.
//
// Updates the published version of a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboardPublishedVersion for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion
func (c *QuickSight) UpdateDashboardPublishedVersion(input *UpdateDashboardPublishedVersionInput) (*UpdateDashboardPublishedVersionOutput, error) {
	req, out := c.UpdateDashboardPublishedVersionRequest(input)
	return out, req.Send()
}

// UpdateDashboardPublishedVersionWithContext is the same as UpdateDashboardPublishedVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboardPublishedVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardPublishedVersionWithContext(ctx aws.Context, input *UpdateDashboardPublishedVersionInput, opts ...request.Option) (*UpdateDashboardPublishedVersionOutput, error) {
	req, out := c.UpdateDashboardPublishedVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSet = "UpdateDataSet"

// UpdateDataSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSet for more information on using the UpdateDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSetRequest method.
//	req, resp := client.UpdateDataSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet
func (c *QuickSight) UpdateDataSetRequest(input *UpdateDataSetInput) (req *request.Request, output *UpdateDataSetOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSet,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &UpdateDataSetInput{}
	}

	output = &UpdateDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSet API operation for Amazon QuickSight.
//
// Updates a dataset. This operation doesn't support datasets that include uploaded
// files as a source. Partial updates are not supported by this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet
func (c *QuickSight) UpdateDataSet(input *UpdateDataSetInput) (*UpdateDataSetOutput, error) {
	req, out := c.UpdateDataSetRequest(input)
	return out, req.Send()
}

// UpdateDataSetWithContext is the same as UpdateDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSetWithContext(ctx aws.Context, input *UpdateDataSetInput, opts ...request.Option) (*UpdateDataSetOutput, error) {
	req, out := c.UpdateDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSetPermissions = "UpdateDataSetPermissions"

// UpdateDataSetPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSetPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSetPermissions for more information on using the UpdateDataSetPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSetPermissionsRequest method.
//	req, resp := client.UpdateDataSetPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions
func (c *QuickSight) UpdateDataSetPermissionsRequest(input *UpdateDataSetPermissionsInput) (req *request.Request, output *UpdateDataSetPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSetPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions",
	}

	if input == nil {
		input = &UpdateDataSetPermissionsInput{}
	}

	output = &UpdateDataSetPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSetPermissions API operation for Amazon QuickSight.
//
// Updates the permissions on a dataset.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/data-set-id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSetPermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions
func (c *QuickSight) UpdateDataSetPermissions(input *UpdateDataSetPermissionsInput) (*UpdateDataSetPermissionsOutput, error) {
	req, out := c.UpdateDataSetPermissionsRequest(input)
	return out, req.Send()
}

// UpdateDataSetPermissionsWithContext is the same as UpdateDataSetPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSetPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSetPermissionsWithContext(ctx aws.Context, input *UpdateDataSetPermissionsInput, opts ...request.Option) (*UpdateDataSetPermissionsOutput, error) {
	req, out := c.UpdateDataSetPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSourceRequest method.
//	req, resp := client.UpdateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource
func (c *QuickSight) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSource API operation for Amazon QuickSight.
//
// Updates a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource
func (c *QuickSight) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSourcePermissions = "UpdateDataSourcePermissions"

// UpdateDataSourcePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSourcePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSourcePermissions for more information on using the UpdateDataSourcePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSourcePermissionsRequest method.
//	req, resp := client.UpdateDataSourcePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions
func (c *QuickSight) UpdateDataSourcePermissionsRequest(input *UpdateDataSourcePermissionsInput) (req *request.Request, output *UpdateDataSourcePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSourcePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
	}

	if input == nil {
		input = &UpdateDataSourcePermissionsInput{}
	}

	output = &UpdateDataSourcePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSourcePermissions API operation for Amazon QuickSight.
//
// Updates the permissions to a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSourcePermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions
func (c *QuickSight) UpdateDataSourcePermissions(input *UpdateDataSourcePermissionsInput) (*UpdateDataSourcePermissionsOutput, error) {
	req, out := c.UpdateDataSourcePermissionsRequest(input)
	return out, req.Send()
}

// UpdateDataSourcePermissionsWithContext is the same as UpdateDataSourcePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSourcePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSourcePermissionsWithContext(ctx aws.Context, input *UpdateDataSourcePermissionsInput, opts ...request.Option) (*UpdateDataSourcePermissionsOutput, error) {
	req, out := c.UpdateDataSourcePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFolder = "UpdateFolder"

// UpdateFolderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFolder for more information on using the UpdateFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFolderRequest method.
//	req, resp := client.UpdateFolderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolder
func (c *QuickSight) UpdateFolderRequest(input *UpdateFolderInput) (req *request.Request, output *UpdateFolderOutput) {
	op := &request.Operation{
		Name:       opUpdateFolder,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &UpdateFolderInput{}
	}

	output = &UpdateFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFolder API operation for Amazon QuickSight.
//
// Updates the name of a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateFolder for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolder
func (c *QuickSight) UpdateFolder(input *UpdateFolderInput) (*UpdateFolderOutput, error) {
	req, out := c.UpdateFolderRequest(input)
	return out, req.Send()
}

// UpdateFolderWithContext is the same as UpdateFolder with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateFolderWithContext(ctx aws.Context, input *UpdateFolderInput, opts ...request.Option) (*UpdateFolderOutput, error) {
	req, out := c.UpdateFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFolderPermissions = "UpdateFolderPermissions"

// UpdateFolderPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFolderPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFolderPermissions for more information on using the UpdateFolderPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFolderPermissionsRequest method.
//	req, resp := client.UpdateFolderPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolderPermissions
func (c *QuickSight) UpdateFolderPermissionsRequest(input *UpdateFolderPermissionsInput) (req *request.Request, output *UpdateFolderPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateFolderPermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/permissions",
	}

	if input == nil {
		input = &UpdateFolderPermissionsInput{}
	}

	output = &UpdateFolderPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFolderPermissions API operation for Amazon QuickSight.
//
// Updates permissions of a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateFolderPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolderPermissions
func (c *QuickSight) UpdateFolderPermissions(input *UpdateFolderPermissionsInput) (*UpdateFolderPermissionsOutput, error) {
	req, out := c.UpdateFolderPermissionsRequest(input)
	return out, req.Send()
}

// UpdateFolderPermissionsWithContext is the same as UpdateFolderPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFolderPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateFolderPermissionsWithContext(ctx aws.Context, input *UpdateFolderPermissionsInput, opts ...request.Option) (*UpdateFolderPermissionsOutput, error) {
	req, out := c.UpdateFolderPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGroupRequest method.
//	req, resp := client.UpdateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup
func (c *QuickSight) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroup API operation for Amazon QuickSight.
//
// Changes a group description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup
func (c *QuickSight) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIAMPolicyAssignment = "UpdateIAMPolicyAssignment"

// UpdateIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIAMPolicyAssignment for more information on using the UpdateIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIAMPolicyAssignmentRequest method.
//	req, resp := client.UpdateIAMPolicyAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment
func (c *QuickSight) UpdateIAMPolicyAssignmentRequest(input *UpdateIAMPolicyAssignmentInput) (req *request.Request, output *UpdateIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opUpdateIAMPolicyAssignment,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &UpdateIAMPolicyAssignmentInput{}
	}

	output = &UpdateIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Updates an existing IAM policy assignment. This operation updates only the
// optional parameter or parameters that are specified in the request. This
// overwrites all of the users included in Identities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConcurrentUpdatingException
//     A resource is already in a state that indicates an operation is happening
//     that must complete before a new update can be applied.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment
func (c *QuickSight) UpdateIAMPolicyAssignment(input *UpdateIAMPolicyAssignmentInput) (*UpdateIAMPolicyAssignmentOutput, error) {
	req, out := c.UpdateIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// UpdateIAMPolicyAssignmentWithContext is the same as UpdateIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateIAMPolicyAssignmentWithContext(ctx aws.Context, input *UpdateIAMPolicyAssignmentInput, opts ...request.Option) (*UpdateIAMPolicyAssignmentOutput, error) {
	req, out := c.UpdateIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIpRestriction = "UpdateIpRestriction"

// UpdateIpRestrictionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIpRestriction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIpRestriction for more information on using the UpdateIpRestriction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIpRestrictionRequest method.
//	req, resp := client.UpdateIpRestrictionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIpRestriction
func (c *QuickSight) UpdateIpRestrictionRequest(input *UpdateIpRestrictionInput) (req *request.Request, output *UpdateIpRestrictionOutput) {
	op := &request.Operation{
		Name:       opUpdateIpRestriction,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/ip-restriction",
	}

	if input == nil {
		input = &UpdateIpRestrictionInput{}
	}

	output = &UpdateIpRestrictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIpRestriction API operation for Amazon QuickSight.
//
// Updates the content and status of IP rules. To use this operation, you need
// to provide the entire map of rules. You can use the DescribeIpRestriction
// operation to get the current rule map.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateIpRestriction for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIpRestriction
func (c *QuickSight) UpdateIpRestriction(input *UpdateIpRestrictionInput) (*UpdateIpRestrictionOutput, error) {
	req, out := c.UpdateIpRestrictionRequest(input)
	return out, req.Send()
}

// UpdateIpRestrictionWithContext is the same as UpdateIpRestriction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIpRestriction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateIpRestrictionWithContext(ctx aws.Context, input *UpdateIpRestrictionInput, opts ...request.Option) (*UpdateIpRestrictionOutput, error) {
	req, out := c.UpdateIpRestrictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePublicSharingSettings = "UpdatePublicSharingSettings"

// UpdatePublicSharingSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePublicSharingSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePublicSharingSettings for more information on using the UpdatePublicSharingSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePublicSharingSettingsRequest method.
//	req, resp := client.UpdatePublicSharingSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdatePublicSharingSettings
func (c *QuickSight) UpdatePublicSharingSettingsRequest(input *UpdatePublicSharingSettingsInput) (req *request.Request, output *UpdatePublicSharingSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdatePublicSharingSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/public-sharing-settings",
	}

	if input == nil {
		input = &UpdatePublicSharingSettingsInput{}
	}

	output = &UpdatePublicSharingSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePublicSharingSettings API operation for Amazon QuickSight.
//
// Use the UpdatePublicSharingSettings operation to turn on or turn off the
// public sharing settings of an Amazon QuickSight dashboard.
//
// To use this operation, turn on session capacity pricing for your Amazon QuickSight
// account.
//
// Before you can turn on public sharing on your account, make sure to give
// public sharing permissions to an administrative user in the Identity and
// Access Management (IAM) console. For more information on using IAM with Amazon
// QuickSight, see Using Amazon QuickSight with IAM (https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html)
// in the Amazon QuickSight User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdatePublicSharingSettings for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedPricingPlanException
//     This error indicates that you are calling an embedding operation in Amazon
//     QuickSight without the required pricing plan on your Amazon Web Services
//     account. Before you can use embedding for anonymous users, a QuickSight administrator
//     needs to add capacity pricing to Amazon QuickSight. You can do this on the
//     Manage Amazon QuickSight page.
//
//     After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//     API operation with the --identity-type ANONYMOUS option.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdatePublicSharingSettings
func (c *QuickSight) UpdatePublicSharingSettings(input *UpdatePublicSharingSettingsInput) (*UpdatePublicSharingSettingsOutput, error) {
	req, out := c.UpdatePublicSharingSettingsRequest(input)
	return out, req.Send()
}

// UpdatePublicSharingSettingsWithContext is the same as UpdatePublicSharingSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePublicSharingSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdatePublicSharingSettingsWithContext(ctx aws.Context, input *UpdatePublicSharingSettingsInput, opts ...request.Option) (*UpdatePublicSharingSettingsOutput, error) {
	req, out := c.UpdatePublicSharingSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRefreshSchedule = "UpdateRefreshSchedule"

// UpdateRefreshScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRefreshSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRefreshSchedule for more information on using the UpdateRefreshSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRefreshScheduleRequest method.
//	req, resp := client.UpdateRefreshScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateRefreshSchedule
func (c *QuickSight) UpdateRefreshScheduleRequest(input *UpdateRefreshScheduleInput) (req *request.Request, output *UpdateRefreshScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateRefreshSchedule,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/refresh-schedules",
	}

	if input == nil {
		input = &UpdateRefreshScheduleInput{}
	}

	output = &UpdateRefreshScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRefreshSchedule API operation for Amazon QuickSight.
//
// Updates a refresh schedule for a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateRefreshSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateRefreshSchedule
func (c *QuickSight) UpdateRefreshSchedule(input *UpdateRefreshScheduleInput) (*UpdateRefreshScheduleOutput, error) {
	req, out := c.UpdateRefreshScheduleRequest(input)
	return out, req.Send()
}

// UpdateRefreshScheduleWithContext is the same as UpdateRefreshSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRefreshSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateRefreshScheduleWithContext(ctx aws.Context, input *UpdateRefreshScheduleInput, opts ...request.Option) (*UpdateRefreshScheduleOutput, error) {
	req, out := c.UpdateRefreshScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplate = "UpdateTemplate"

// UpdateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplate for more information on using the UpdateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplateRequest method.
//	req, resp := client.UpdateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate
func (c *QuickSight) UpdateTemplateRequest(input *UpdateTemplateInput) (req *request.Request, output *UpdateTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &UpdateTemplateInput{}
	}

	output = &UpdateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplate API operation for Amazon QuickSight.
//
// Updates a template from an existing Amazon QuickSight analysis or another
// template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate
func (c *QuickSight) UpdateTemplate(input *UpdateTemplateInput) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	return out, req.Send()
}

// UpdateTemplateWithContext is the same as UpdateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplateWithContext(ctx aws.Context, input *UpdateTemplateInput, opts ...request.Option) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplateAlias = "UpdateTemplateAlias"

// UpdateTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplateAlias for more information on using the UpdateTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplateAliasRequest method.
//	req, resp := client.UpdateTemplateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias
func (c *QuickSight) UpdateTemplateAliasRequest(input *UpdateTemplateAliasInput) (req *request.Request, output *UpdateTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplateAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &UpdateTemplateAliasInput{}
	}

	output = &UpdateTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplateAlias API operation for Amazon QuickSight.
//
// Updates the template alias of a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplateAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias
func (c *QuickSight) UpdateTemplateAlias(input *UpdateTemplateAliasInput) (*UpdateTemplateAliasOutput, error) {
	req, out := c.UpdateTemplateAliasRequest(input)
	return out, req.Send()
}

// UpdateTemplateAliasWithContext is the same as UpdateTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplateAliasWithContext(ctx aws.Context, input *UpdateTemplateAliasInput, opts ...request.Option) (*UpdateTemplateAliasOutput, error) {
	req, out := c.UpdateTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplatePermissions = "UpdateTemplatePermissions"

// UpdateTemplatePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplatePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplatePermissions for more information on using the UpdateTemplatePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplatePermissionsRequest method.
//	req, resp := client.UpdateTemplatePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions
func (c *QuickSight) UpdateTemplatePermissionsRequest(input *UpdateTemplatePermissionsInput) (req *request.Request, output *UpdateTemplatePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplatePermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/permissions",
	}

	if input == nil {
		input = &UpdateTemplatePermissionsInput{}
	}

	output = &UpdateTemplatePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplatePermissions API operation for Amazon QuickSight.
//
// Updates the resource permissions for a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplatePermissions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Access is throttled.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions
func (c *QuickSight) UpdateTemplatePermissions(input *UpdateTemplatePermissionsInput) (*UpdateTemplatePermissionsOutput, error) {
	req, out := c.UpdateTemplatePermissionsRequest(input)
	return out, req.Send()
}

// UpdateTemplatePermissionsWithContext is the same as UpdateTemplatePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplatePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplatePermissionsWithContext(ctx aws.Context, input *UpdateTemplatePermissionsInput, opts ...request.Option) (*UpdateTemplatePermissionsOutput, error) {
	req, out := c.UpdateTemplatePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTheme = "UpdateTheme"

// UpdateThemeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTheme for more information on using the UpdateTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateThemeRequest method.
//	req, resp := client.UpdateThemeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTheme
func (c *QuickSight) UpdateThemeRequest(input *UpdateThemeInput) (req *request.Request, output *UpdateThemeOutput) {
	op := &request.Operation{
		Name:       opUpdateTheme,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &UpdateThemeInput{}
	}

	output = &UpdateThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTheme API operation for Amazon QuickSight.
//
// Updates a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTheme for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTheme
func (c *QuickSight) UpdateTheme(input *UpdateThemeInput) (*UpdateThemeOutput, error) {
	req, out := c.UpdateThemeRequest(input)
	return out, req.Send()
}

// UpdateThemeWithContext is the same as UpdateTheme with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateThemeWithContext(ctx aws.Context, input *UpdateThemeInput, opts ...request.Option) (*UpdateThemeOutput, error) {
	req, out := c.UpdateThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThemeAlias = "UpdateThemeAlias"

// UpdateThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThemeAlias for more information on using the UpdateThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateThemeAliasRequest method.
//	req, resp := client.UpdateThemeAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemeAlias
func (c *QuickSight) UpdateThemeAliasRequest(input *UpdateThemeAliasInput) (req *request.Request, output *UpdateThemeAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateThemeAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &UpdateThemeAliasInput{}
	}

	output = &UpdateThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateThemeAlias API operation for Amazon QuickSight.
//
// Updates an alias of a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateThemeAlias for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceExistsException
//     The resource specified already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemeAlias
func (c *QuickSight) UpdateThemeAlias(input *UpdateThemeAliasInput) (*UpdateThemeAliasOutput, error) {
	req, out := c.UpdateThemeAliasRequest(input)
	return out, req.Send()
}

// UpdateThemeAliasWithContext is the same as UpdateThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateThemeAliasWithContext(ctx aws.Context, input *UpdateThemeAliasInput, opts ...request.Option) (*UpdateThemeAliasOutput, error) {
	req, out := c.UpdateThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThemePermissions = "UpdateThemePermissions"

// UpdateThemePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThemePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThemePermissions for more information on using the UpdateThemePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateThemePermissionsRequest method.
//	req, resp := client.UpdateThemePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemePermissions
func (c *QuickSight) UpdateThemePermissionsRequest(input *UpdateThemePermissionsInput) (req *request.Request, output *UpdateThemePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateThemePermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/permissions",
	}

	if input == nil {
		input = &UpdateThemePermissionsInput{}
	}

	output = &UpdateThemePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateThemePermissions API operation for Amazon QuickSight.
//
// Updates the resource permissions for a theme. Permissions apply to the action
// to grant or revoke permissions on, for example "quicksight:DescribeTheme".
//
// Theme permissions apply in groupings. Valid groupings include the following
// for the three levels of permissions, which are user, owner, or no permissions:
//
//   - User "quicksight:DescribeTheme" "quicksight:DescribeThemeAlias" "quicksight:ListThemeAliases"
//     "quicksight:ListThemeVersions"
//
//   - Owner "quicksight:DescribeTheme" "quicksight:DescribeThemeAlias" "quicksight:ListThemeAliases"
//     "quicksight:ListThemeVersions" "quicksight:DeleteTheme" "quicksight:UpdateTheme"
//     "quicksight:CreateThemeAlias" "quicksight:DeleteThemeAlias" "quicksight:UpdateThemeAlias"
//     "quicksight:UpdateThemePermissions" "quicksight:DescribeThemePermissions"
//
//   - To specify no permissions, omit the permissions list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateThemePermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - UnsupportedUserEditionException
//     This error indicates that you are calling an operation on an Amazon QuickSight
//     subscription where the edition doesn't include support for that operation.
//     Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//     Not every operation and capability is available in every edition.
//
//   - LimitExceededException
//     A limit is exceeded.
//
//   - InternalFailureException
//     An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemePermissions
func (c *QuickSight) UpdateThemePermissions(input *UpdateThemePermissionsInput) (*UpdateThemePermissionsOutput, error) {
	req, out := c.UpdateThemePermissionsRequest(input)
	return out, req.Send()
}

// UpdateThemePermissionsWithContext is the same as UpdateThemePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThemePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateThemePermissionsWithContext(ctx aws.Context, input *UpdateThemePermissionsInput, opts ...request.Option) (*UpdateThemePermissionsOutput, error) {
	req, out := c.UpdateThemePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserRequest method.
//	req, resp := client.UpdateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser
func (c *QuickSight) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for Amazon QuickSight.
//
// Updates an Amazon QuickSight user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have access to this item. The provided credentials couldn't be
//     validated. You might not be authorized to carry out the request. Make sure
//     that your account is authorized to use the Amazon QuickSight service, that
//     your policies have the correct permissions, and that you are using the correct
//     credentials.
//
//   - InvalidParameterValueException
//     One or more parameters has a value that isn't valid.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ThrottlingException
//     Access is throttled.
//
//   - PreconditionNotMetException
//     One or more preconditions aren't met.
//
//   - InternalFailureException
//     An internal failure occurred.
//
//   - ResourceUnavailableException
//     This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser
func (c *QuickSight) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have access to this item. The provided credentials couldn't be
// validated. You might not be authorized to carry out the request. Make sure
// that your account is authorized to use the Amazon QuickSight service, that
// your policies have the correct permissions, and that you are using the correct
// credentials.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The Amazon Web Services request ID for this request.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon QuickSight customizations associated with your Amazon Web Services
// account or a QuickSight namespace in a specific Amazon Web Services Region.
type AccountCustomization struct {
	_ struct{} `type:"structure"`

	// The default email customization template.
	DefaultEmailCustomizationTemplate *string `type:"string"`

	// The default theme for this Amazon QuickSight subscription.
	DefaultTheme *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountCustomization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountCustomization) GoString() string {
	return s.String()
}

// SetDefaultEmailCustomizationTemplate sets the DefaultEmailCustomizationTemplate field's value.
func (s *AccountCustomization) SetDefaultEmailCustomizationTemplate(v string) *AccountCustomization {
	s.DefaultEmailCustomizationTemplate = &v
	return s
}

// SetDefaultTheme sets the DefaultTheme field's value.
func (s *AccountCustomization) SetDefaultTheme(v string) *AccountCustomization {
	s.DefaultTheme = &v
	return s
}

// A structure that contains the following account information elements:
//
//   - Your Amazon QuickSight account name.
//
//   - The edition of Amazon QuickSight that your account is using.
//
//   - The notification email address that is associated with the Amazon QuickSight
//     account.
//
//   - The authentication type of the Amazon QuickSight account.
//
//   - The status of the Amazon QuickSight account's subscription.
type AccountInfo struct {
	_ struct{} `type:"structure"`

	// The account name that you provided for the Amazon QuickSight subscription
	// in your Amazon Web Services account. You create this name when you sign up
	// for Amazon QuickSight. It's unique over all of Amazon Web Services, and it
	// appears only when users sign in.
	AccountName *string `type:"string"`

	// The status of your account subscription.
	AccountSubscriptionStatus *string `type:"string"`

	// The way that your Amazon QuickSight account is authenticated.
	AuthenticationType *string `type:"string"`

	// The edition of your Amazon QuickSight account.
	Edition *string `type:"string" enum:"Edition"`

	// The email address that will be used for Amazon QuickSight to send notifications
	// regarding your Amazon Web Services account or Amazon QuickSight subscription.
	NotificationEmail *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountInfo) GoString() string {
	return s.String()
}

// SetAccountName sets the AccountName field's value.
func (s *AccountInfo) SetAccountName(v string) *AccountInfo {
	s.AccountName = &v
	return s
}

// SetAccountSubscriptionStatus sets the AccountSubscriptionStatus field's value.
func (s *AccountInfo) SetAccountSubscriptionStatus(v string) *AccountInfo {
	s.AccountSubscriptionStatus = &v
	return s
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *AccountInfo) SetAuthenticationType(v string) *AccountInfo {
	s.AuthenticationType = &v
	return s
}

// SetEdition sets the Edition field's value.
func (s *AccountInfo) SetEdition(v string) *AccountInfo {
	s.Edition = &v
	return s
}

// SetNotificationEmail sets the NotificationEmail field's value.
func (s *AccountInfo) SetNotificationEmail(v string) *AccountInfo {
	s.NotificationEmail = &v
	return s
}

// The Amazon QuickSight settings associated with your Amazon Web Services account.
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// The "account name" you provided for the Amazon QuickSight subscription in
	// your Amazon Web Services account. You create this name when you sign up for
	// Amazon QuickSight. It is unique in all of Amazon Web Services and it appears
	// only when users sign in.
	AccountName *string `type:"string"`

	// The default Amazon QuickSight namespace for your Amazon Web Services account.
	DefaultNamespace *string `type:"string"`

	// The edition of Amazon QuickSight that you're currently subscribed to: Enterprise
	// edition or Standard edition.
	Edition *string `type:"string" enum:"Edition"`

	// The main notification email for your Amazon QuickSight subscription.
	NotificationEmail *string `type:"string"`

	// A Boolean value that indicates whether public sharing is turned on for an
	// Amazon QuickSight account. For more information about turning on public sharing,
	// see UpdatePublicSharingSettings (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdatePublicSharingSettings.html).
	PublicSharingEnabled *bool `type:"boolean"`

	// A boolean value that determines whether or not an Amazon QuickSight account
	// can be deleted. A True value doesn't allow the account to be deleted and
	// results in an error message if a user tries to make a DeleteAccountSubsctiption
	// request. A False value will allow the ccount to be deleted.
	TerminationProtectionEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) GoString() string {
	return s.String()
}

// SetAccountName sets the AccountName field's value.
func (s *AccountSettings) SetAccountName(v string) *AccountSettings {
	s.AccountName = &v
	return s
}

// SetDefaultNamespace sets the DefaultNamespace field's value.
func (s *AccountSettings) SetDefaultNamespace(v string) *AccountSettings {
	s.DefaultNamespace = &v
	return s
}

// SetEdition sets the Edition field's value.
func (s *AccountSettings) SetEdition(v string) *AccountSettings {
	s.Edition = &v
	return s
}

// SetNotificationEmail sets the NotificationEmail field's value.
func (s *AccountSettings) SetNotificationEmail(v string) *AccountSettings {
	s.NotificationEmail = &v
	return s
}

// SetPublicSharingEnabled sets the PublicSharingEnabled field's value.
func (s *AccountSettings) SetPublicSharingEnabled(v bool) *AccountSettings {
	s.PublicSharingEnabled = &v
	return s
}

// SetTerminationProtectionEnabled sets the TerminationProtectionEnabled field's value.
func (s *AccountSettings) SetTerminationProtectionEnabled(v bool) *AccountSettings {
	s.TerminationProtectionEnabled = &v
	return s
}

// The active Identity and Access Management (IAM) policy assignment.
type ActiveIAMPolicyAssignment struct {
	_ struct{} `type:"structure"`

	// A name for the IAM policy assignment.
	AssignmentName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	PolicyArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveIAMPolicyAssignment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveIAMPolicyAssignment) GoString() string {
	return s.String()
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *ActiveIAMPolicyAssignment) SetAssignmentName(v string) *ActiveIAMPolicyAssignment {
	s.AssignmentName = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *ActiveIAMPolicyAssignment) SetPolicyArn(v string) *ActiveIAMPolicyAssignment {
	s.PolicyArn = &v
	return s
}

// An ad hoc (one-time) filtering option.
type AdHocFilteringOption struct {
	_ struct{} `type:"structure"`

	// Availability status.
	AvailabilityStatus *string `type:"string" enum:"DashboardBehavior"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdHocFilteringOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdHocFilteringOption) GoString() string {
	return s.String()
}

// SetAvailabilityStatus sets the AvailabilityStatus field's value.
func (s *AdHocFilteringOption) SetAvailabilityStatus(v string) *AdHocFilteringOption {
	s.AvailabilityStatus = &v
	return s
}

// An aggregation function aggregates values from a dimension or measure.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type AggregationFunction struct {
	_ struct{} `type:"structure"`

	// Aggregation for categorical values.
	//
	//    * COUNT: Aggregate by the total number of values, including duplicates.
	//
	//    * DISTINCT_COUNT: Aggregate by the total number of distinct values.
	CategoricalAggregationFunction *string `type:"string" enum:"CategoricalAggregationFunction"`

	// Aggregation for date values.
	//
	//    * COUNT: Aggregate by the total number of values, including duplicates.
	//
	//    * DISTINCT_COUNT: Aggregate by the total number of distinct values.
	//
	//    * MIN: Select the smallest date value.
	//
	//    * MAX: Select the largest date value.
	DateAggregationFunction *string `type:"string" enum:"DateAggregationFunction"`

	// Aggregation for numerical values.
	NumericalAggregationFunction *NumericalAggregationFunction `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationFunction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationFunction) GoString() string {
	return s.String()
}

// SetCategoricalAggregationFunction sets the CategoricalAggregationFunction field's value.
func (s *AggregationFunction) SetCategoricalAggregationFunction(v string) *AggregationFunction {
	s.CategoricalAggregationFunction = &v
	return s
}

// SetDateAggregationFunction sets the DateAggregationFunction field's value.
func (s *AggregationFunction) SetDateAggregationFunction(v string) *AggregationFunction {
	s.DateAggregationFunction = &v
	return s
}

// SetNumericalAggregationFunction sets the NumericalAggregationFunction field's value.
func (s *AggregationFunction) SetNumericalAggregationFunction(v *NumericalAggregationFunction) *AggregationFunction {
	s.NumericalAggregationFunction = v
	return s
}

// The configuration options to sort aggregated values.
type AggregationSortConfiguration struct {
	_ struct{} `type:"structure"`

	// The function that aggregates the values in Column.
	//
	// AggregationFunction is a required field
	AggregationFunction *AggregationFunction `type:"structure" required:"true"`

	// The column that determines the sort order of aggregated values.
	//
	// Column is a required field
	Column *ColumnIdentifier `type:"structure" required:"true"`

	// The sort direction of values.
	//
	//    * ASC: Sort in ascending order.
	//
	//    * DESC: Sort in descending order.
	//
	// SortDirection is a required field
	SortDirection *string `type:"string" required:"true" enum:"SortDirection"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationSortConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationSortConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregationSortConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregationSortConfiguration"}
	if s.AggregationFunction == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregationFunction"))
	}
	if s.Column == nil {
		invalidParams.Add(request.NewErrParamRequired("Column"))
	}
	if s.SortDirection == nil {
		invalidParams.Add(request.NewErrParamRequired("SortDirection"))
	}
	if s.Column != nil {
		if err := s.Column.Validate(); err != nil {
			invalidParams.AddNested("Column", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationFunction sets the AggregationFunction field's value.
func (s *AggregationSortConfiguration) SetAggregationFunction(v *AggregationFunction) *AggregationSortConfiguration {
	s.AggregationFunction = v
	return s
}

// SetColumn sets the Column field's value.
func (s *AggregationSortConfiguration) SetColumn(v *ColumnIdentifier) *AggregationSortConfiguration {
	s.Column = v
	return s
}

// SetSortDirection sets the SortDirection field's value.
func (s *AggregationSortConfiguration) SetSortDirection(v string) *AggregationSortConfiguration {
	s.SortDirection = &v
	return s
}

// The parameters for OpenSearch.
type AmazonElasticsearchParameters struct {
	_ struct{} `type:"structure"`

	// The OpenSearch domain.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonElasticsearchParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonElasticsearchParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonElasticsearchParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonElasticsearchParameters"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *AmazonElasticsearchParameters) SetDomain(v string) *AmazonElasticsearchParameters {
	s.Domain = &v
	return s
}

// The parameters for OpenSearch.
type AmazonOpenSearchParameters struct {
	_ struct{} `type:"structure"`

	// The OpenSearch domain.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonOpenSearchParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonOpenSearchParameters"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *AmazonOpenSearchParameters) SetDomain(v string) *AmazonOpenSearchParameters {
	s.Domain = &v
	return s
}

// Metadata structure for an analysis in Amazon QuickSight
type Analysis struct {
	_ struct{} `type:"structure"`

	// The ID of the analysis.
	AnalysisId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the analysis.
	Arn *string `type:"string"`

	// The time that the analysis was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ARNs of the datasets of the analysis.
	DataSetArns []*string `type:"list"`

	// Errors associated with the analysis.
	Errors []*AnalysisError `min:"1" type:"list"`

	// The time that the analysis was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The descriptive name of the analysis.
	Name *string `min:"1" type:"string"`

	// A list of the associated sheets with the unique identifier and name of each
	// sheet.
	Sheets []*Sheet `type:"list"`

	// Status associated with the analysis.
	Status *string `type:"string" enum:"ResourceStatus"`

	// The ARN of the theme of the analysis.
	ThemeArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Analysis) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Analysis) GoString() string {
	return s.String()
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *Analysis) SetAnalysisId(v string) *Analysis {
	s.AnalysisId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Analysis) SetArn(v string) *Analysis {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Analysis) SetCreatedTime(v time.Time) *Analysis {
	s.CreatedTime = &v
	return s
}

// SetDataSetArns sets the DataSetArns field's value.
func (s *Analysis) SetDataSetArns(v []*string) *Analysis {
	s.DataSetArns = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *Analysis) SetErrors(v []*AnalysisError) *Analysis {
	s.Errors = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Analysis) SetLastUpdatedTime(v time.Time) *Analysis {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Analysis) SetName(v string) *Analysis {
	s.Name = &v
	return s
}

// SetSheets sets the Sheets field's value.
func (s *Analysis) SetSheets(v []*Sheet) *Analysis {
	s.Sheets = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Analysis) SetStatus(v string) *Analysis {
	s.Status = &v
	return s
}

// SetThemeArn sets the ThemeArn field's value.
func (s *Analysis) SetThemeArn(v string) *Analysis {
	s.ThemeArn = &v
	return s
}

// The configuration for default analysis settings.
type AnalysisDefaults struct {
	_ struct{} `type:"structure"`

	// The configuration for default new sheet settings.
	//
	// DefaultNewSheetConfiguration is a required field
	DefaultNewSheetConfiguration *DefaultNewSheetConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisDefaults) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisDefaults) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisDefaults"}
	if s.DefaultNewSheetConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultNewSheetConfiguration"))
	}
	if s.DefaultNewSheetConfiguration != nil {
		if err := s.DefaultNewSheetConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DefaultNewSheetConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultNewSheetConfiguration sets the DefaultNewSheetConfiguration field's value.
func (s *AnalysisDefaults) SetDefaultNewSheetConfiguration(v *DefaultNewSheetConfiguration) *AnalysisDefaults {
	s.DefaultNewSheetConfiguration = v
	return s
}

// The definition of an analysis.
type AnalysisDefinition struct {
	_ struct{} `type:"structure"`

	// The configuration for default analysis settings.
	AnalysisDefaults *AnalysisDefaults `type:"structure"`

	// An array of calculated field definitions for the analysis.
	CalculatedFields []*CalculatedField `type:"list"`

	// An array of analysis-level column configurations. Column configurations can
	// be used to set default formatting for a column to be used throughout an analysis.
	ColumnConfigurations []*ColumnConfiguration `type:"list"`

	// An array of dataset identifier declarations. This mapping allows the usage
	// of dataset identifiers instead of dataset ARNs throughout analysis sub-structures.
	//
	// DataSetIdentifierDeclarations is a required field
	DataSetIdentifierDeclarations []*DataSetIdentifierDeclaration `min:"1" type:"list" required:"true"`

	// Filter definitions for an analysis.
	//
	// For more information, see Filtering Data in Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html)
	// in the Amazon QuickSight User Guide.
	FilterGroups []*FilterGroup `type:"list"`

	// An array of parameter declarations for an analysis.
	//
	// Parameters are named variables that can transfer a value for use by an action
	// or an object.
	//
	// For more information, see Parameters in Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html)
	// in the Amazon QuickSight User Guide.
	ParameterDeclarations []*ParameterDeclaration `type:"list"`

	// An array of sheet definitions for an analysis. Each SheetDefinition provides
	// detailed information about a sheet within this analysis.
	Sheets []*SheetDefinition `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisDefinition"}
	if s.DataSetIdentifierDeclarations == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetIdentifierDeclarations"))
	}
	if s.DataSetIdentifierDeclarations != nil && len(s.DataSetIdentifierDeclarations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetIdentifierDeclarations", 1))
	}
	if s.AnalysisDefaults != nil {
		if err := s.AnalysisDefaults.Validate(); err != nil {
			invalidParams.AddNested("AnalysisDefaults", err.(request.ErrInvalidParams))
		}
	}
	if s.CalculatedFields != nil {
		for i, v := range s.CalculatedFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CalculatedFields", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ColumnConfigurations != nil {
		for i, v := range s.ColumnConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataSetIdentifierDeclarations != nil {
		for i, v := range s.DataSetIdentifierDeclarations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSetIdentifierDeclarations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FilterGroups != nil {
		for i, v := range s.FilterGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ParameterDeclarations != nil {
		for i, v := range s.ParameterDeclarations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterDeclarations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sheets != nil {
		for i, v := range s.Sheets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sheets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisDefaults sets the AnalysisDefaults field's value.
func (s *AnalysisDefinition) SetAnalysisDefaults(v *AnalysisDefaults) *AnalysisDefinition {
	s.AnalysisDefaults = v
	return s
}

// SetCalculatedFields sets the CalculatedFields field's value.
func (s *AnalysisDefinition) SetCalculatedFields(v []*CalculatedField) *AnalysisDefinition {
	s.CalculatedFields = v
	return s
}

// SetColumnConfigurations sets the ColumnConfigurations field's value.
func (s *AnalysisDefinition) SetColumnConfigurations(v []*ColumnConfiguration) *AnalysisDefinition {
	s.ColumnConfigurations = v
	return s
}

// SetDataSetIdentifierDeclarations sets the DataSetIdentifierDeclarations field's value.
func (s *AnalysisDefinition) SetDataSetIdentifierDeclarations(v []*DataSetIdentifierDeclaration) *AnalysisDefinition {
	s.DataSetIdentifierDeclarations = v
	return s
}

// SetFilterGroups sets the FilterGroups field's value.
func (s *AnalysisDefinition) SetFilterGroups(v []*FilterGroup) *AnalysisDefinition {
	s.FilterGroups = v
	return s
}

// SetParameterDeclarations sets the ParameterDeclarations field's value.
func (s *AnalysisDefinition) SetParameterDeclarations(v []*ParameterDeclaration) *AnalysisDefinition {
	s.ParameterDeclarations = v
	return s
}

// SetSheets sets the Sheets field's value.
func (s *AnalysisDefinition) SetSheets(v []*SheetDefinition) *AnalysisDefinition {
	s.Sheets = v
	return s
}

// Analysis error.
type AnalysisError struct {
	_ struct{} `type:"structure"`

	// The message associated with the analysis error.
	Message *string `type:"string"`

	// The type of the analysis error.
	Type *string `type:"string" enum:"AnalysisErrorType"`

	// Lists the violated entities that caused the analysis error
	ViolatedEntities []*Entity `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisError) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *AnalysisError) SetMessage(v string) *AnalysisError {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *AnalysisError) SetType(v string) *AnalysisError {
	s.Type = &v
	return s
}

// SetViolatedEntities sets the ViolatedEntities field's value.
func (s *AnalysisError) SetViolatedEntities(v []*Entity) *AnalysisError {
	s.ViolatedEntities = v
	return s
}

// A filter that you apply when searching for one or more analyses.
type AnalysisSearchFilter struct {
	_ struct{} `type:"structure"`

	// The name of the value that you want to use as a filter, for example "Name":
	// "QUICKSIGHT_OWNER".
	//
	// Valid values are defined as follows:
	//
	//    * QUICKSIGHT_VIEWER_OR_OWNER: Provide an ARN of a user or group, and any
	//    analyses with that ARN listed as one of the analysis' owners or viewers
	//    are returned. Implicit permissions from folders or groups are considered.
	//
	//    * QUICKSIGHT_OWNER: Provide an ARN of a user or group, and any analyses
	//    with that ARN listed as one of the owners of the analyses are returned.
	//    Implicit permissions from folders or groups are considered.
	//
	//    * DIRECT_QUICKSIGHT_SOLE_OWNER: Provide an ARN of a user or group, and
	//    any analyses with that ARN listed as the only owner of the analysis are
	//    returned. Implicit permissions from folders or groups are not considered.
	//
	//    * DIRECT_QUICKSIGHT_OWNER: Provide an ARN of a user or group, and any
	//    analyses with that ARN listed as one of the owners of the analyses are
	//    returned. Implicit permissions from folders or groups are not considered.
	//
	//    * DIRECT_QUICKSIGHT_VIEWER_OR_OWNER: Provide an ARN of a user or group,
	//    and any analyses with that ARN listed as one of the owners or viewers
	//    of the analyses are returned. Implicit permissions from folders or groups
	//    are not considered.
	//
	//    * ANALYSIS_NAME: Any analyses whose names have a substring match to this
	//    value will be returned.
	Name *string `type:"string" enum:"AnalysisFilterAttribute"`

	// The comparison operator that you want to use as a filter, for example "Operator":
	// "StringEquals". Valid values are "StringEquals" and "StringLike".
	//
	// If you set the operator value to "StringEquals", you need to provide an ownership
	// related filter in the "NAME" field and the arn of the user or group whose
	// folders you want to search in the "Value" field. For example, "Name":"DIRECT_QUICKSIGHT_OWNER",
	// "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1".
	//
	// If you set the value to "StringLike", you need to provide the name of the
	// folders you are searching for. For example, "Name":"ANALYSIS_NAME", "Operator":
	// "StringLike", "Value": "Test". The "StringLike" operator only supports the
	// NAME value ANALYSIS_NAME.
	Operator *string `type:"string" enum:"FilterOperator"`

	// The value of the named item, in this case QUICKSIGHT_USER, that you want
	// to use as a filter, for example "Value". An example is "arn:aws:quicksight:us-east-1:1:user/default/UserName1".
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSearchFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSearchFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalysisSearchFilter) SetName(v string) *AnalysisSearchFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *AnalysisSearchFilter) SetOperator(v string) *AnalysisSearchFilter {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalysisSearchFilter) SetValue(v string) *AnalysisSearchFilter {
	s.Value = &v
	return s
}

// The source entity of an analysis.
type AnalysisSourceEntity struct {
	_ struct{} `type:"structure"`

	// The source template for the source entity of the analysis.
	SourceTemplate *AnalysisSourceTemplate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceEntity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisSourceEntity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisSourceEntity"}
	if s.SourceTemplate != nil {
		if err := s.SourceTemplate.Validate(); err != nil {
			invalidParams.AddNested("SourceTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceTemplate sets the SourceTemplate field's value.
func (s *AnalysisSourceEntity) SetSourceTemplate(v *AnalysisSourceTemplate) *AnalysisSourceEntity {
	s.SourceTemplate = v
	return s
}

// The source template of an analysis.
type AnalysisSourceTemplate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source template of an analysis.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The dataset references of the source template of an analysis.
	//
	// DataSetReferences is a required field
	DataSetReferences []*DataSetReference `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceTemplate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisSourceTemplate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisSourceTemplate"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.DataSetReferences == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetReferences"))
	}
	if s.DataSetReferences != nil && len(s.DataSetReferences) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetReferences", 1))
	}
	if s.DataSetReferences != nil {
		for i, v := range s.DataSetReferences {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSetReferences", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AnalysisSourceTemplate) SetArn(v string) *AnalysisSourceTemplate {
	s.Arn = &v
	return s
}

// SetDataSetReferences sets the DataSetReferences field's value.
func (s *AnalysisSourceTemplate) SetDataSetReferences(v []*DataSetReference) *AnalysisSourceTemplate {
	s.DataSetReferences = v
	return s
}

// The summary metadata that describes an analysis.
type AnalysisSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the analysis. This ID displays in the URL.
	AnalysisId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the analysis.
	Arn *string `type:"string"`

	// The time that the analysis was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The time that the analysis was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the analysis. This name is displayed in the Amazon QuickSight
	// console.
	Name *string `min:"1" type:"string"`

	// The last known status for the analysis.
	Status *string `type:"string" enum:"ResourceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSummary) GoString() string {
	return s.String()
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *AnalysisSummary) SetAnalysisId(v string) *AnalysisSummary {
	s.AnalysisId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *AnalysisSummary) SetArn(v string) *AnalysisSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AnalysisSummary) SetCreatedTime(v time.Time) *AnalysisSummary {
	s.CreatedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *AnalysisSummary) SetLastUpdatedTime(v time.Time) *AnalysisSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnalysisSummary) SetName(v string) *AnalysisSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnalysisSummary) SetStatus(v string) *AnalysisSummary {
	s.Status = &v
	return s
}

// The date configuration of the filter.
type AnchorDateConfiguration struct {
	_ struct{} `type:"structure"`

	// The options for the date configuration. Choose one of the options below:
	//
	//    * NOW
	AnchorOption *string `type:"string" enum:"AnchorOption"`

	// The name of the parameter that is used for the anchor date configuration.
	ParameterName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnchorDateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnchorDateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnchorDateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnchorDateConfiguration"}
	if s.ParameterName != nil && len(*s.ParameterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnchorOption sets the AnchorOption field's value.
func (s *AnchorDateConfiguration) SetAnchorOption(v string) *AnchorDateConfiguration {
	s.AnchorOption = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *AnchorDateConfiguration) SetParameterName(v string) *AnchorDateConfiguration {
	s.ParameterName = &v
	return s
}

// Information about the dashboard that you want to embed.
type AnonymousUserDashboardEmbeddingConfiguration struct {
	_ struct{} `type:"structure"`

	// The dashboard ID for the dashboard that you want the user to see first. This
	// ID is included in the output URL. When the URL in response is accessed, Amazon
	// QuickSight renders this dashboard.
	//
	// The Amazon Resource Name (ARN) of this dashboard must be included in the
	// AuthorizedResourceArns parameter. Otherwise, the request will fail with InvalidParameterValueException.
	//
	// InitialDashboardId is a required field
	InitialDashboardId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserDashboardEmbeddingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserDashboardEmbeddingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnonymousUserDashboardEmbeddingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnonymousUserDashboardEmbeddingConfiguration"}
	if s.InitialDashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialDashboardId"))
	}
	if s.InitialDashboardId != nil && len(*s.InitialDashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitialDashboardId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialDashboardId sets the InitialDashboardId field's value.
func (s *AnonymousUserDashboardEmbeddingConfiguration) SetInitialDashboardId(v string) *AnonymousUserDashboardEmbeddingConfiguration {
	s.InitialDashboardId = &v
	return s
}

// The experience that you are embedding. You can use this object to generate
// a url that embeds a visual into your application.
type AnonymousUserDashboardVisualEmbeddingConfiguration struct {
	_ struct{} `type:"structure"`

	// The visual ID for the visual that you want the user to see. This ID is included
	// in the output URL. When the URL in response is accessed, Amazon QuickSight
	// renders this visual.
	//
	// The Amazon Resource Name (ARN) of the dashboard that the visual belongs to
	// must be included in the AuthorizedResourceArns parameter. Otherwise, the
	// request will fail with InvalidParameterValueException.
	//
	// InitialDashboardVisualId is a required field
	InitialDashboardVisualId *DashboardVisualId `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserDashboardVisualEmbeddingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserDashboardVisualEmbeddingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnonymousUserDashboardVisualEmbeddingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnonymousUserDashboardVisualEmbeddingConfiguration"}
	if s.InitialDashboardVisualId == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialDashboardVisualId"))
	}
	if s.InitialDashboardVisualId != nil {
		if err := s.InitialDashboardVisualId.Validate(); err != nil {
			invalidParams.AddNested("InitialDashboardVisualId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialDashboardVisualId sets the InitialDashboardVisualId field's value.
func (s *AnonymousUserDashboardVisualEmbeddingConfiguration) SetInitialDashboardVisualId(v *DashboardVisualId) *AnonymousUserDashboardVisualEmbeddingConfiguration {
	s.InitialDashboardVisualId = v
	return s
}

// The type of experience you want to embed. For anonymous users, you can embed
// Amazon QuickSight dashboards.
type AnonymousUserEmbeddingExperienceConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of embedding experience. In this case, Amazon QuickSight dashboards.
	Dashboard *AnonymousUserDashboardEmbeddingConfiguration `type:"structure"`

	// The type of embedding experience. In this case, Amazon QuickSight visuals.
	DashboardVisual *AnonymousUserDashboardVisualEmbeddingConfiguration `type:"structure"`

	// The Q search bar that you want to use for anonymous user embedding.
	QSearchBar *AnonymousUserQSearchBarEmbeddingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserEmbeddingExperienceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserEmbeddingExperienceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnonymousUserEmbeddingExperienceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnonymousUserEmbeddingExperienceConfiguration"}
	if s.Dashboard != nil {
		if err := s.Dashboard.Validate(); err != nil {
			invalidParams.AddNested("Dashboard", err.(request.ErrInvalidParams))
		}
	}
	if s.DashboardVisual != nil {
		if err := s.DashboardVisual.Validate(); err != nil {
			invalidParams.AddNested("DashboardVisual", err.(request.ErrInvalidParams))
		}
	}
	if s.QSearchBar != nil {
		if err := s.QSearchBar.Validate(); err != nil {
			invalidParams.AddNested("QSearchBar", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboard sets the Dashboard field's value.
func (s *AnonymousUserEmbeddingExperienceConfiguration) SetDashboard(v *AnonymousUserDashboardEmbeddingConfiguration) *AnonymousUserEmbeddingExperienceConfiguration {
	s.Dashboard = v
	return s
}

// SetDashboardVisual sets the DashboardVisual field's value.
func (s *AnonymousUserEmbeddingExperienceConfiguration) SetDashboardVisual(v *AnonymousUserDashboardVisualEmbeddingConfiguration) *AnonymousUserEmbeddingExperienceConfiguration {
	s.DashboardVisual = v
	return s
}

// SetQSearchBar sets the QSearchBar field's value.
func (s *AnonymousUserEmbeddingExperienceConfiguration) SetQSearchBar(v *AnonymousUserQSearchBarEmbeddingConfiguration) *AnonymousUserEmbeddingExperienceConfiguration {
	s.QSearchBar = v
	return s
}

// The settings that you want to use with the Q search bar.
type AnonymousUserQSearchBarEmbeddingConfiguration struct {
	_ struct{} `type:"structure"`

	// The QuickSight Q topic ID of the topic that you want the anonymous user to
	// see first. This ID is included in the output URL. When the URL in response
	// is accessed, Amazon QuickSight renders the Q search bar with this topic pre-selected.
	//
	// The Amazon Resource Name (ARN) of this Q topic must be included in the AuthorizedResourceArns
	// parameter. Otherwise, the request will fail with InvalidParameterValueException.
	//
	// InitialTopicId is a required field
	InitialTopicId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserQSearchBarEmbeddingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserQSearchBarEmbeddingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnonymousUserQSearchBarEmbeddingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnonymousUserQSearchBarEmbeddingConfiguration"}
	if s.InitialTopicId == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialTopicId"))
	}
	if s.InitialTopicId != nil && len(*s.InitialTopicId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitialTopicId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialTopicId sets the InitialTopicId field's value.
func (s *AnonymousUserQSearchBarEmbeddingConfiguration) SetInitialTopicId(v string) *AnonymousUserQSearchBarEmbeddingConfiguration {
	s.InitialTopicId = &v
	return s
}

// The arc axis configuration of a GaugeChartVisual.
type ArcAxisConfiguration struct {
	_ struct{} `type:"structure"`

	// The arc axis range of a GaugeChartVisual.
	Range *ArcAxisDisplayRange `type:"structure"`

	// The reserved range of the arc axis.
	ReserveRange *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcAxisConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcAxisConfiguration) GoString() string {
	return s.String()
}

// SetRange sets the Range field's value.
func (s *ArcAxisConfiguration) SetRange(v *ArcAxisDisplayRange) *ArcAxisConfiguration {
	s.Range = v
	return s
}

// SetReserveRange sets the ReserveRange field's value.
func (s *ArcAxisConfiguration) SetReserveRange(v int64) *ArcAxisConfiguration {
	s.ReserveRange = &v
	return s
}

// The arc axis range of a GaugeChartVisual.
type ArcAxisDisplayRange struct {
	_ struct{} `type:"structure"`

	// The maximum value of the arc axis range.
	Max *float64 `type:"double"`

	// The minimum value of the arc axis range.
	Min *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcAxisDisplayRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcAxisDisplayRange) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *ArcAxisDisplayRange) SetMax(v float64) *ArcAxisDisplayRange {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *ArcAxisDisplayRange) SetMin(v float64) *ArcAxisDisplayRange {
	s.Min = &v
	return s
}

// The arc configuration of a GaugeChartVisual.
type ArcConfiguration struct {
	_ struct{} `type:"structure"`

	// The option that determines the arc angle of a GaugeChartVisual.
	ArcAngle *float64 `type:"double"`

	// The options that determine the arc thickness of a GaugeChartVisual.
	ArcThickness *string `type:"string" enum:"ArcThicknessOptions"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcConfiguration) GoString() string {
	return s.String()
}

// SetArcAngle sets the ArcAngle field's value.
func (s *ArcConfiguration) SetArcAngle(v float64) *ArcConfiguration {
	s.ArcAngle = &v
	return s
}

// SetArcThickness sets the ArcThickness field's value.
func (s *ArcConfiguration) SetArcThickness(v string) *ArcConfiguration {
	s.ArcThickness = &v
	return s
}

// The options that determine the arc thickness of a GaugeChartVisual.
type ArcOptions struct {
	_ struct{} `type:"structure"`

	// The arc thickness of a GaugeChartVisual.
	ArcThickness *string `type:"string" enum:"ArcThickness"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArcOptions) GoString() string {
	return s.String()
}

// SetArcThickness sets the ArcThickness field's value.
func (s *ArcOptions) SetArcThickness(v string) *ArcOptions {
	s.ArcThickness = &v
	return s
}

// Parameters for Amazon Athena.
type AthenaParameters struct {
	_ struct{} `type:"structure"`

	// Use the RoleArn structure to override an account-wide role for a specific
	// Athena data source. For example, say an account administrator has turned
	// off all Athena access with an account-wide role. The administrator can then
	// use RoleArn to bypass the account-wide role and allow Athena access for the
	// single Athena data source that is specified in the structure, even if the
	// account-wide role forbidding Athena access is still active.
	RoleArn *string `min:"20" type:"string"`

	// The workgroup that Amazon Athena uses.
	WorkGroup *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AthenaParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AthenaParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AthenaParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AthenaParameters"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.WorkGroup != nil && len(*s.WorkGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *AthenaParameters) SetRoleArn(v string) *AthenaParameters {
	s.RoleArn = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *AthenaParameters) SetWorkGroup(v string) *AthenaParameters {
	s.WorkGroup = &v
	return s
}

// Parameters for Amazon Aurora.
type AuroraParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuroraParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuroraParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *AuroraParameters) SetDatabase(v string) *AuroraParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *AuroraParameters) SetHost(v string) *AuroraParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AuroraParameters) SetPort(v int64) *AuroraParameters {
	s.Port = &v
	return s
}

// Parameters for Amazon Aurora PostgreSQL-Compatible Edition.
type AuroraPostgreSqlParameters struct {
	_ struct{} `type:"structure"`

	// The Amazon Aurora PostgreSQL database to connect to.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// The Amazon Aurora PostgreSQL-Compatible host to connect to.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// The port that Amazon Aurora PostgreSQL is listening on.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraPostgreSqlParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraPostgreSqlParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuroraPostgreSqlParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuroraPostgreSqlParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *AuroraPostgreSqlParameters) SetDatabase(v string) *AuroraPostgreSqlParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *AuroraPostgreSqlParameters) SetHost(v string) *AuroraPostgreSqlParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AuroraPostgreSqlParameters) SetPort(v int64) *AuroraPostgreSqlParameters {
	s.Port = &v
	return s
}

// The parameters for IoT Analytics.
type AwsIotAnalyticsParameters struct {
	_ struct{} `type:"structure"`

	// Dataset name.
	//
	// DataSetName is a required field
	DataSetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIotAnalyticsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIotAnalyticsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIotAnalyticsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIotAnalyticsParameters"}
	if s.DataSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetName"))
	}
	if s.DataSetName != nil && len(*s.DataSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetName sets the DataSetName field's value.
func (s *AwsIotAnalyticsParameters) SetDataSetName(v string) *AwsIotAnalyticsParameters {
	s.DataSetName = &v
	return s
}

// The data options for an axis.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type AxisDataOptions struct {
	_ struct{} `type:"structure"`

	// The options for an axis with a date field.
	DateAxisOptions *DateAxisOptions `type:"structure"`

	// The options for an axis with a numeric field.
	NumericAxisOptions *NumericAxisOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDataOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDataOptions) GoString() string {
	return s.String()
}

// SetDateAxisOptions sets the DateAxisOptions field's value.
func (s *AxisDataOptions) SetDateAxisOptions(v *DateAxisOptions) *AxisDataOptions {
	s.DateAxisOptions = v
	return s
}

// SetNumericAxisOptions sets the NumericAxisOptions field's value.
func (s *AxisDataOptions) SetNumericAxisOptions(v *NumericAxisOptions) *AxisDataOptions {
	s.NumericAxisOptions = v
	return s
}

// The options that are saved for future extension.
type AxisDisplayDataDrivenRange struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayDataDrivenRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayDataDrivenRange) GoString() string {
	return s.String()
}

// The minimum and maximum setup for an axis display range.
type AxisDisplayMinMaxRange struct {
	_ struct{} `type:"structure"`

	// The maximum setup for an axis display range.
	Maximum *float64 `type:"double"`

	// The minimum setup for an axis display range.
	Minimum *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayMinMaxRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayMinMaxRange) GoString() string {
	return s.String()
}

// SetMaximum sets the Maximum field's value.
func (s *AxisDisplayMinMaxRange) SetMaximum(v float64) *AxisDisplayMinMaxRange {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *AxisDisplayMinMaxRange) SetMinimum(v float64) *AxisDisplayMinMaxRange {
	s.Minimum = &v
	return s
}

// The display options for the axis label.
type AxisDisplayOptions struct {
	_ struct{} `type:"structure"`

	// Determines whether or not the axis line is visible.
	AxisLineVisibility *string `type:"string" enum:"Visibility"`

	// The offset value that determines the starting placement of the axis within
	// a visual's bounds.
	AxisOffset *string `type:"string"`

	// The data options for an axis.
	DataOptions *AxisDataOptions `type:"structure"`

	// Determines whether or not the grid line is visible.
	GridLineVisibility *string `type:"string" enum:"Visibility"`

	// The scroll bar options for an axis.
	ScrollbarOptions *ScrollBarOptions `type:"structure"`

	// The tick label options of an axis.
	TickLabelOptions *AxisTickLabelOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayOptions) GoString() string {
	return s.String()
}

// SetAxisLineVisibility sets the AxisLineVisibility field's value.
func (s *AxisDisplayOptions) SetAxisLineVisibility(v string) *AxisDisplayOptions {
	s.AxisLineVisibility = &v
	return s
}

// SetAxisOffset sets the AxisOffset field's value.
func (s *AxisDisplayOptions) SetAxisOffset(v string) *AxisDisplayOptions {
	s.AxisOffset = &v
	return s
}

// SetDataOptions sets the DataOptions field's value.
func (s *AxisDisplayOptions) SetDataOptions(v *AxisDataOptions) *AxisDisplayOptions {
	s.DataOptions = v
	return s
}

// SetGridLineVisibility sets the GridLineVisibility field's value.
func (s *AxisDisplayOptions) SetGridLineVisibility(v string) *AxisDisplayOptions {
	s.GridLineVisibility = &v
	return s
}

// SetScrollbarOptions sets the ScrollbarOptions field's value.
func (s *AxisDisplayOptions) SetScrollbarOptions(v *ScrollBarOptions) *AxisDisplayOptions {
	s.ScrollbarOptions = v
	return s
}

// SetTickLabelOptions sets the TickLabelOptions field's value.
func (s *AxisDisplayOptions) SetTickLabelOptions(v *AxisTickLabelOptions) *AxisDisplayOptions {
	s.TickLabelOptions = v
	return s
}

// The range setup of a numeric axis display range.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type AxisDisplayRange struct {
	_ struct{} `type:"structure"`

	// The data-driven setup of an axis display range.
	DataDriven *AxisDisplayDataDrivenRange `type:"structure"`

	// The minimum and maximum setup of an axis display range.
	MinMax *AxisDisplayMinMaxRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisDisplayRange) GoString() string {
	return s.String()
}

// SetDataDriven sets the DataDriven field's value.
func (s *AxisDisplayRange) SetDataDriven(v *AxisDisplayDataDrivenRange) *AxisDisplayRange {
	s.DataDriven = v
	return s
}

// SetMinMax sets the MinMax field's value.
func (s *AxisDisplayRange) SetMinMax(v *AxisDisplayMinMaxRange) *AxisDisplayRange {
	s.MinMax = v
	return s
}

// The label options for a chart axis. You must specify the field that the label
// is targeted to.
type AxisLabelOptions struct {
	_ struct{} `type:"structure"`

	// The options that indicate which field the label belongs to.
	ApplyTo *AxisLabelReferenceOptions `type:"structure"`

	// The text for the axis label.
	CustomLabel *string `type:"string"`

	// The font configuration of the axis label.
	FontConfiguration *FontConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLabelOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLabelOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AxisLabelOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AxisLabelOptions"}
	if s.ApplyTo != nil {
		if err := s.ApplyTo.Validate(); err != nil {
			invalidParams.AddNested("ApplyTo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyTo sets the ApplyTo field's value.
func (s *AxisLabelOptions) SetApplyTo(v *AxisLabelReferenceOptions) *AxisLabelOptions {
	s.ApplyTo = v
	return s
}

// SetCustomLabel sets the CustomLabel field's value.
func (s *AxisLabelOptions) SetCustomLabel(v string) *AxisLabelOptions {
	s.CustomLabel = &v
	return s
}

// SetFontConfiguration sets the FontConfiguration field's value.
func (s *AxisLabelOptions) SetFontConfiguration(v *FontConfiguration) *AxisLabelOptions {
	s.FontConfiguration = v
	return s
}

// The reference that specifies where the axis label is applied to.
type AxisLabelReferenceOptions struct {
	_ struct{} `type:"structure"`

	// The column that the axis label is targeted to.
	//
	// Column is a required field
	Column *ColumnIdentifier `type:"structure" required:"true"`

	// The field that the axis label is targeted to.
	//
	// FieldId is a required field
	FieldId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLabelReferenceOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLabelReferenceOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AxisLabelReferenceOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AxisLabelReferenceOptions"}
	if s.Column == nil {
		invalidParams.Add(request.NewErrParamRequired("Column"))
	}
	if s.FieldId == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldId"))
	}
	if s.FieldId != nil && len(*s.FieldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldId", 1))
	}
	if s.Column != nil {
		if err := s.Column.Validate(); err != nil {
			invalidParams.AddNested("Column", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumn sets the Column field's value.
func (s *AxisLabelReferenceOptions) SetColumn(v *ColumnIdentifier) *AxisLabelReferenceOptions {
	s.Column = v
	return s
}

// SetFieldId sets the FieldId field's value.
func (s *AxisLabelReferenceOptions) SetFieldId(v string) *AxisLabelReferenceOptions {
	s.FieldId = &v
	return s
}

// The liner axis scale setup.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type AxisLinearScale struct {
	_ struct{} `type:"structure"`

	// The step count setup of a linear axis.
	StepCount *int64 `type:"integer"`

	// The step size setup of a linear axis.
	StepSize *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLinearScale) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLinearScale) GoString() string {
	return s.String()
}

// SetStepCount sets the StepCount field's value.
func (s *AxisLinearScale) SetStepCount(v int64) *AxisLinearScale {
	s.StepCount = &v
	return s
}

// SetStepSize sets the StepSize field's value.
func (s *AxisLinearScale) SetStepSize(v float64) *AxisLinearScale {
	s.StepSize = &v
	return s
}

// The logarithmic axis scale setup.
type AxisLogarithmicScale struct {
	_ struct{} `type:"structure"`

	// The base setup of a logarithmic axis scale.
	Base *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLogarithmicScale) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisLogarithmicScale) GoString() string {
	return s.String()
}

// SetBase sets the Base field's value.
func (s *AxisLogarithmicScale) SetBase(v float64) *AxisLogarithmicScale {
	s.Base = &v
	return s
}

// The scale setup options for a numeric axis display.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type AxisScale struct {
	_ struct{} `type:"structure"`

	// The linear axis scale setup.
	Linear *AxisLinearScale `type:"structure"`

	// The logarithmic axis scale setup.
	Logarithmic *AxisLogarithmicScale `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisScale) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisScale) GoString() string {
	return s.String()
}

// SetLinear sets the Linear field's value.
func (s *AxisScale) SetLinear(v *AxisLinearScale) *AxisScale {
	s.Linear = v
	return s
}

// SetLogarithmic sets the Logarithmic field's value.
func (s *AxisScale) SetLogarithmic(v *AxisLogarithmicScale) *AxisScale {
	s.Logarithmic = v
	return s
}

// The tick label options of an axis.
type AxisTickLabelOptions struct {
	_ struct{} `type:"structure"`

	// Determines whether or not the axis ticks are visible.
	LabelOptions *LabelOptions `type:"structure"`

	// The rotation angle of the axis tick labels.
	RotationAngle *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisTickLabelOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AxisTickLabelOptions) GoString() string {
	return s.String()
}

// SetLabelOptions sets the LabelOptions field's value.
func (s *AxisTickLabelOptions) SetLabelOptions(v *LabelOptions) *AxisTickLabelOptions {
	s.LabelOptions = v
	return s
}

// SetRotationAngle sets the RotationAngle field's value.
func (s *AxisTickLabelOptions) SetRotationAngle(v float64) *AxisTickLabelOptions {
	s.RotationAngle = &v
	return s
}

// The aggregated field wells of a bar chart.
type BarChartAggregatedFieldWells struct {
	_ struct{} `type:"structure"`

	// The category (y-axis) field well of a bar chart.
	Category []*DimensionField `type:"list"`

	// The color (group/color) field well of a bar chart.
	Colors []*DimensionField `type:"list"`

	// The small multiples field well of a bar chart.
	SmallMultiples []*DimensionField `type:"list"`

	// The value field wells of a bar chart. Values are aggregated by category.
	Values []*MeasureField `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartAggregatedFieldWells) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartAggregatedFieldWells) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BarChartAggregatedFieldWells) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BarChartAggregatedFieldWells"}
	if s.Category != nil {
		for i, v := range s.Category {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Category", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Colors != nil {
		for i, v := range s.Colors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Colors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SmallMultiples != nil {
		for i, v := range s.SmallMultiples {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SmallMultiples", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Values != nil {
		for i, v := range s.Values {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Values", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *BarChartAggregatedFieldWells) SetCategory(v []*DimensionField) *BarChartAggregatedFieldWells {
	s.Category = v
	return s
}

// SetColors sets the Colors field's value.
func (s *BarChartAggregatedFieldWells) SetColors(v []*DimensionField) *BarChartAggregatedFieldWells {
	s.Colors = v
	return s
}

// SetSmallMultiples sets the SmallMultiples field's value.
func (s *BarChartAggregatedFieldWells) SetSmallMultiples(v []*DimensionField) *BarChartAggregatedFieldWells {
	s.SmallMultiples = v
	return s
}

// SetValues sets the Values field's value.
func (s *BarChartAggregatedFieldWells) SetValues(v []*MeasureField) *BarChartAggregatedFieldWells {
	s.Values = v
	return s
}

// The configuration of a BarChartVisual.
type BarChartConfiguration struct {
	_ struct{} `type:"structure"`

	// Determines the arrangement of the bars. The orientation and arrangement of
	// bars determine the type of bar that is used in the visual.
	BarsArrangement *string `type:"string" enum:"BarsArrangement"`

	// The label display options (grid line, range, scale, axis step) for bar chart
	// category.
	CategoryAxis *AxisDisplayOptions `type:"structure"`

	// The label options (label text, label visibility and sort icon visibility)
	// for a bar chart.
	CategoryLabelOptions *ChartAxisLabelOptions `type:"structure"`

	// The label options (label text, label visibility and sort icon visibility)
	// for a color that is used in a bar chart.
	ColorLabelOptions *ChartAxisLabelOptions `type:"structure"`

	// The contribution analysis (anomaly configuration) setup of the visual.
	ContributionAnalysisDefaults []*ContributionAnalysisDefault `min:"1" type:"list"`

	// The options that determine if visual data labels are displayed.
	DataLabels *DataLabelOptions `type:"structure"`

	// The field wells of the visual.
	FieldWells *BarChartFieldWells `type:"structure"`

	// The legend display setup of the visual.
	Legend *LegendOptions `type:"structure"`

	// The orientation of the bars in a bar chart visual. There are two valid values
	// in this structure:
	//
	//    * HORIZONTAL: Used for charts that have horizontal bars. Visuals that
	//    use this value are horizontal bar charts, horizontal stacked bar charts,
	//    and horizontal stacked 100% bar charts.
	//
	//    * VERTICAL: Used for charts that have vertical bars. Visuals that use
	//    this value are vertical bar charts, vertical stacked bar charts, and vertical
	//    stacked 100% bar charts.
	Orientation *string `type:"string" enum:"BarChartOrientation"`

	// The reference line setup of the visual.
	ReferenceLines []*ReferenceLine `type:"list"`

	// The small multiples setup for the visual.
	SmallMultiplesOptions *SmallMultiplesOptions `type:"structure"`

	// The sort configuration of a BarChartVisual.
	SortConfiguration *BarChartSortConfiguration `type:"structure"`

	// The tooltip display setup of the visual.
	Tooltip *TooltipOptions `type:"structure"`

	// The label display options (grid line, range, scale, axis step) for a bar
	// chart value.
	ValueAxis *AxisDisplayOptions `type:"structure"`

	// The label options (label text, label visibility and sort icon visibility)
	// for a bar chart value.
	ValueLabelOptions *ChartAxisLabelOptions `type:"structure"`

	// The palette (chart color) display setup of the visual.
	VisualPalette *VisualPalette `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BarChartConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BarChartConfiguration"}
	if s.ContributionAnalysisDefaults != nil && len(s.ContributionAnalysisDefaults) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContributionAnalysisDefaults", 1))
	}
	if s.CategoryLabelOptions != nil {
		if err := s.CategoryLabelOptions.Validate(); err != nil {
			invalidParams.AddNested("CategoryLabelOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ColorLabelOptions != nil {
		if err := s.ColorLabelOptions.Validate(); err != nil {
			invalidParams.AddNested("ColorLabelOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ContributionAnalysisDefaults != nil {
		for i, v := range s.ContributionAnalysisDefaults {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContributionAnalysisDefaults", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataLabels != nil {
		if err := s.DataLabels.Validate(); err != nil {
			invalidParams.AddNested("DataLabels", err.(request.ErrInvalidParams))
		}
	}
	if s.FieldWells != nil {
		if err := s.FieldWells.Validate(); err != nil {
			invalidParams.AddNested("FieldWells", err.(request.ErrInvalidParams))
		}
	}
	if s.ReferenceLines != nil {
		for i, v := range s.ReferenceLines {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReferenceLines", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SmallMultiplesOptions != nil {
		if err := s.SmallMultiplesOptions.Validate(); err != nil {
			invalidParams.AddNested("SmallMultiplesOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.SortConfiguration != nil {
		if err := s.SortConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SortConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tooltip != nil {
		if err := s.Tooltip.Validate(); err != nil {
			invalidParams.AddNested("Tooltip", err.(request.ErrInvalidParams))
		}
	}
	if s.ValueLabelOptions != nil {
		if err := s.ValueLabelOptions.Validate(); err != nil {
			invalidParams.AddNested("ValueLabelOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.VisualPalette != nil {
		if err := s.VisualPalette.Validate(); err != nil {
			invalidParams.AddNested("VisualPalette", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBarsArrangement sets the BarsArrangement field's value.
func (s *BarChartConfiguration) SetBarsArrangement(v string) *BarChartConfiguration {
	s.BarsArrangement = &v
	return s
}

// SetCategoryAxis sets the CategoryAxis field's value.
func (s *BarChartConfiguration) SetCategoryAxis(v *AxisDisplayOptions) *BarChartConfiguration {
	s.CategoryAxis = v
	return s
}

// SetCategoryLabelOptions sets the CategoryLabelOptions field's value.
func (s *BarChartConfiguration) SetCategoryLabelOptions(v *ChartAxisLabelOptions) *BarChartConfiguration {
	s.CategoryLabelOptions = v
	return s
}

// SetColorLabelOptions sets the ColorLabelOptions field's value.
func (s *BarChartConfiguration) SetColorLabelOptions(v *ChartAxisLabelOptions) *BarChartConfiguration {
	s.ColorLabelOptions = v
	return s
}

// SetContributionAnalysisDefaults sets the ContributionAnalysisDefaults field's value.
func (s *BarChartConfiguration) SetContributionAnalysisDefaults(v []*ContributionAnalysisDefault) *BarChartConfiguration {
	s.ContributionAnalysisDefaults = v
	return s
}

// SetDataLabels sets the DataLabels field's value.
func (s *BarChartConfiguration) SetDataLabels(v *DataLabelOptions) *BarChartConfiguration {
	s.DataLabels = v
	return s
}

// SetFieldWells sets the FieldWells field's value.
func (s *BarChartConfiguration) SetFieldWells(v *BarChartFieldWells) *BarChartConfiguration {
	s.FieldWells = v
	return s
}

// SetLegend sets the Legend field's value.
func (s *BarChartConfiguration) SetLegend(v *LegendOptions) *BarChartConfiguration {
	s.Legend = v
	return s
}

// SetOrientation sets the Orientation field's value.
func (s *BarChartConfiguration) SetOrientation(v string) *BarChartConfiguration {
	s.Orientation = &v
	return s
}

// SetReferenceLines sets the ReferenceLines field's value.
func (s *BarChartConfiguration) SetReferenceLines(v []*ReferenceLine) *BarChartConfiguration {
	s.ReferenceLines = v
	return s
}

// SetSmallMultiplesOptions sets the SmallMultiplesOptions field's value.
func (s *BarChartConfiguration) SetSmallMultiplesOptions(v *SmallMultiplesOptions) *BarChartConfiguration {
	s.SmallMultiplesOptions = v
	return s
}

// SetSortConfiguration sets the SortConfiguration field's value.
func (s *BarChartConfiguration) SetSortConfiguration(v *BarChartSortConfiguration) *BarChartConfiguration {
	s.SortConfiguration = v
	return s
}

// SetTooltip sets the Tooltip field's value.
func (s *BarChartConfiguration) SetTooltip(v *TooltipOptions) *BarChartConfiguration {
	s.Tooltip = v
	return s
}

// SetValueAxis sets the ValueAxis field's value.
func (s *BarChartConfiguration) SetValueAxis(v *AxisDisplayOptions) *BarChartConfiguration {
	s.ValueAxis = v
	return s
}

// SetValueLabelOptions sets the ValueLabelOptions field's value.
func (s *BarChartConfiguration) SetValueLabelOptions(v *ChartAxisLabelOptions) *BarChartConfiguration {
	s.ValueLabelOptions = v
	return s
}

// SetVisualPalette sets the VisualPalette field's value.
func (s *BarChartConfiguration) SetVisualPalette(v *VisualPalette) *BarChartConfiguration {
	s.VisualPalette = v
	return s
}

// The field wells of a BarChartVisual.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type BarChartFieldWells struct {
	_ struct{} `type:"structure"`

	// The aggregated field wells of a bar chart.
	BarChartAggregatedFieldWells *BarChartAggregatedFieldWells `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartFieldWells) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartFieldWells) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BarChartFieldWells) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BarChartFieldWells"}
	if s.BarChartAggregatedFieldWells != nil {
		if err := s.BarChartAggregatedFieldWells.Validate(); err != nil {
			invalidParams.AddNested("BarChartAggregatedFieldWells", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBarChartAggregatedFieldWells sets the BarChartAggregatedFieldWells field's value.
func (s *BarChartFieldWells) SetBarChartAggregatedFieldWells(v *BarChartAggregatedFieldWells) *BarChartFieldWells {
	s.BarChartAggregatedFieldWells = v
	return s
}

// sort-configuration-description
type BarChartSortConfiguration struct {
	_ struct{} `type:"structure"`

	// The limit on the number of categories displayed in a bar chart.
	CategoryItemsLimit *ItemsLimitConfiguration `type:"structure"`

	// The sort configuration of category fields.
	CategorySort []*FieldSortOptions `type:"list"`

	// The limit on the number of values displayed in a bar chart.
	ColorItemsLimit *ItemsLimitConfiguration `type:"structure"`

	// The sort configuration of color fields in a bar chart.
	ColorSort []*FieldSortOptions `type:"list"`

	// The limit on the number of small multiples panels that are displayed.
	SmallMultiplesLimitConfiguration *ItemsLimitConfiguration `type:"structure"`

	// The sort configuration of the small multiples field.
	SmallMultiplesSort []*FieldSortOptions `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartSortConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartSortConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BarChartSortConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BarChartSortConfiguration"}
	if s.CategorySort != nil {
		for i, v := range s.CategorySort {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CategorySort", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ColorSort != nil {
		for i, v := range s.ColorSort {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColorSort", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SmallMultiplesSort != nil {
		for i, v := range s.SmallMultiplesSort {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SmallMultiplesSort", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryItemsLimit sets the CategoryItemsLimit field's value.
func (s *BarChartSortConfiguration) SetCategoryItemsLimit(v *ItemsLimitConfiguration) *BarChartSortConfiguration {
	s.CategoryItemsLimit = v
	return s
}

// SetCategorySort sets the CategorySort field's value.
func (s *BarChartSortConfiguration) SetCategorySort(v []*FieldSortOptions) *BarChartSortConfiguration {
	s.CategorySort = v
	return s
}

// SetColorItemsLimit sets the ColorItemsLimit field's value.
func (s *BarChartSortConfiguration) SetColorItemsLimit(v *ItemsLimitConfiguration) *BarChartSortConfiguration {
	s.ColorItemsLimit = v
	return s
}

// SetColorSort sets the ColorSort field's value.
func (s *BarChartSortConfiguration) SetColorSort(v []*FieldSortOptions) *BarChartSortConfiguration {
	s.ColorSort = v
	return s
}

// SetSmallMultiplesLimitConfiguration sets the SmallMultiplesLimitConfiguration field's value.
func (s *BarChartSortConfiguration) SetSmallMultiplesLimitConfiguration(v *ItemsLimitConfiguration) *BarChartSortConfiguration {
	s.SmallMultiplesLimitConfiguration = v
	return s
}

// SetSmallMultiplesSort sets the SmallMultiplesSort field's value.
func (s *BarChartSortConfiguration) SetSmallMultiplesSort(v []*FieldSortOptions) *BarChartSortConfiguration {
	s.SmallMultiplesSort = v
	return s
}

// A bar chart.
//
// The BarChartVisual structure describes a visual that is a member of the bar
// chart family. The following charts can be described using this structure:
//
//   - Horizontal bar chart
//
//   - Vertical bar chart
//
//   - Horizontal stacked bar chart
//
//   - Vertical stacked bar chart
//
//   - Horizontal stacked 100% bar chart
//
//   - Vertical stacked 100% bar chart
//
// For more information, see Using bar charts (https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html)
// in the Amazon QuickSight User Guide.
type BarChartVisual struct {
	_ struct{} `type:"structure"`

	// The list of custom actions that are configured for a visual.
	Actions []*VisualCustomAction `type:"list"`

	// The configuration settings of the visual.
	ChartConfiguration *BarChartConfiguration `type:"structure"`

	// The column hierarchy that is used during drill-downs and drill-ups.
	ColumnHierarchies []*ColumnHierarchy `type:"list"`

	// The subtitle that is displayed on the visual.
	Subtitle *VisualSubtitleLabelOptions `type:"structure"`

	// The title that is displayed on the visual.
	Title *VisualTitleLabelOptions `type:"structure"`

	// The unique identifier of a visual. This identifier must be unique within
	// the context of a dashboard, template, or analysis. Two dashboards, analyses,
	// or templates can have visuals with the same identifiers.
	//
	// VisualId is a required field
	VisualId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartVisual) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BarChartVisual) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BarChartVisual) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BarChartVisual"}
	if s.VisualId == nil {
		invalidParams.Add(request.NewErrParamRequired("VisualId"))
	}
	if s.VisualId != nil && len(*s.VisualId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VisualId", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ChartConfiguration != nil {
		if err := s.ChartConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChartConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ColumnHierarchies != nil {
		for i, v := range s.ColumnHierarchies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnHierarchies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Subtitle != nil {
		if err := s.Subtitle.Validate(); err != nil {
			invalidParams.AddNested("Subtitle", err.(request.ErrInvalidParams))
		}
	}
	if s.Title != nil {
		if err := s.Title.Validate(); err != nil {
			invalidParams.AddNested("Title", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *BarChartVisual) SetActions(v []*VisualCustomAction) *BarChartVisual {
	s.Actions = v
	return s
}

// SetChartConfiguration sets the ChartConfiguration field's value.
func (s *BarChartVisual) SetChartConfiguration(v *BarChartConfiguration) *BarChartVisual {
	s.ChartConfiguration = v
	return s
}

// SetColumnHierarchies sets the ColumnHierarchies field's value.
func (s *BarChartVisual) SetColumnHierarchies(v []*ColumnHierarchy) *BarChartVisual {
	s.ColumnHierarchies = v
	return s
}

// SetSubtitle sets the Subtitle field's value.
func (s *BarChartVisual) SetSubtitle(v *VisualSubtitleLabelOptions) *BarChartVisual {
	s.Subtitle = v
	return s
}

// SetTitle sets the Title field's value.
func (s *BarChartVisual) SetTitle(v *VisualTitleLabelOptions) *BarChartVisual {
	s.Title = v
	return s
}

// SetVisualId sets the VisualId field's value.
func (s *BarChartVisual) SetVisualId(v string) *BarChartVisual {
	s.VisualId = &v
	return s
}

// The options that determine the bin count of a histogram.
type BinCountOptions struct {
	_ struct{} `type:"structure"`

	// The options that determine the bin count value.
	Value *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BinCountOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BinCountOptions) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *BinCountOptions) SetValue(v int64) *BinCountOptions {
	s.Value = &v
	return s
}

// The options that determine the bin width of a histogram.
type BinWidthOptions struct {
	_ struct{} `type:"structure"`

	// The options that determine the bin count limit.
	BinCountLimit *int64 `type:"long"`

	// The options that determine the bin width value.
	Value *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BinWidthOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BinWidthOptions) GoString() string {
	return s.String()
}

// SetBinCountLimit sets the BinCountLimit field's value.
func (s *BinWidthOptions) SetBinCountLimit(v int64) *BinWidthOptions {
	s.BinCountLimit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *BinWidthOptions) SetValue(v float64) *BinWidthOptions {
	s.Value = &v
	return s
}

// The configuration of a body section.
type BodySectionConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of content in a body section.
	//
	// Content is a required field
	Content *BodySectionContent `type:"structure" required:"true"`

	// The configuration of a page break for a section.
	PageBreakConfiguration *SectionPageBreakConfiguration `type:"structure"`

	// The unique identifier of a body section.
	//
	// SectionId is a required field
	SectionId *string `min:"1" type:"string" required:"true"`

	// The style options of a body section.
	Style *SectionStyle `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BodySectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BodySectionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BodySectionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BodySectionConfiguration"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.SectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SectionId"))
	}
	if s.SectionId != nil && len(*s.SectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SectionId", 1))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *BodySectionConfiguration) SetContent(v *BodySectionContent) *BodySectionConfiguration {
	s.Content = v
	return s
}

// SetPageBreakConfiguration sets the PageBreakConfiguration field's value.
func (s *BodySectionConfiguration) SetPageBreakConfiguration(v *SectionPageBreakConfiguration) *BodySectionConfiguration {
	s.PageBreakConfiguration = v
	return s
}

// SetSectionId sets the SectionId field's value.
func (s *BodySectionConfiguration) SetSectionId(v string) *BodySectionConfiguration {
	s.SectionId = &v
	return s
}

// SetStyle sets the Style field's value.
func (s *BodySectionConfiguration) SetStyle(v *SectionStyle) *BodySectionConfiguration {
	s.Style = v
	return s
}

// The configuration of content in a body section.
type BodySectionContent struct {
	_ struct{} `type:"structure"`

	// The layout configuration of a body section.
	Layout *SectionLayoutConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BodySectionContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BodySectionContent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BodySectionContent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BodySectionContent"}
	if s.Layout != nil {
		if err := s.Layout.Validate(); err != nil {
			invalidParams.AddNested("Layout", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayout sets the Layout field's value.
func (s *BodySectionContent) SetLayout(v *SectionLayoutConfiguration) *BodySectionContent {
	s.Layout = v
	return s
}

// The display options for tile borders for visuals.
type BorderStyle struct {
	_ struct{} `type:"structure"`

	// The option to enable display of borders for visuals.
	Show *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BorderStyle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BorderStyle) GoString() string {
	return s.String()
}

// SetShow sets the Show field's value.
func (s *BorderStyle) SetShow(v bool) *BorderStyle {
	s.Show = &v
	return s
}

// The aggregated field well for a box plot.
type BoxPlotAggregatedFieldWells struct {
	_ struct{} `type:"structure"`

	// The group by field well of a box plot chart. Values are grouped based on
	// group by fields.
	GroupBy []*DimensionField `type:"list"`

	// The value field well of a box plot chart. Values are aggregated based on
	// group by fields.
	Values []*MeasureField `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotAggregatedFieldWells) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotAggregatedFieldWells) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BoxPlotAggregatedFieldWells) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BoxPlotAggregatedFieldWells"}
	if s.GroupBy != nil {
		for i, v := range s.GroupBy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GroupBy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Values != nil {
		for i, v := range s.Values {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Values", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupBy sets the GroupBy field's value.
func (s *BoxPlotAggregatedFieldWells) SetGroupBy(v []*DimensionField) *BoxPlotAggregatedFieldWells {
	s.GroupBy = v
	return s
}

// SetValues sets the Values field's value.
func (s *BoxPlotAggregatedFieldWells) SetValues(v []*MeasureField) *BoxPlotAggregatedFieldWells {
	s.Values = v
	return s
}

// The configuration of a BoxPlotVisual.
type BoxPlotChartConfiguration struct {
	_ struct{} `type:"structure"`

	// The box plot chart options for a box plot visual
	BoxPlotOptions *BoxPlotOptions `type:"structure"`

	// The label display options (grid line, range, scale, axis step) of a box plot
	// category.
	CategoryAxis *AxisDisplayOptions `type:"structure"`

	// The label options (label text, label visibility and sort Icon visibility)
	// of a box plot category.
	CategoryLabelOptions *ChartAxisLabelOptions `type:"structure"`

	// The field wells of the visual.
	FieldWells *BoxPlotFieldWells `type:"structure"`

	// The options for the legend setup of a visual.
	Legend *LegendOptions `type:"structure"`

	// The label display options (grid line, range, scale, axis step) of a box plot
	// category.
	PrimaryYAxisDisplayOptions *AxisDisplayOptions `type:"structure"`

	// The label options (label text, label visibility and sort icon visibility)
	// of a box plot value.
	PrimaryYAxisLabelOptions *ChartAxisLabelOptions `type:"structure"`

	// The reference line setup of the visual.
	ReferenceLines []*ReferenceLine `type:"list"`

	// The sort configuration of a BoxPlotVisual.
	SortConfiguration *BoxPlotSortConfiguration `type:"structure"`

	// The tooltip display setup of the visual.
	Tooltip *TooltipOptions `type:"structure"`

	// The palette (chart color) display setup of the visual.
	VisualPalette *VisualPalette `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotChartConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotChartConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BoxPlotChartConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BoxPlotChartConfiguration"}
	if s.CategoryLabelOptions != nil {
		if err := s.CategoryLabelOptions.Validate(); err != nil {
			invalidParams.AddNested("CategoryLabelOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.FieldWells != nil {
		if err := s.FieldWells.Validate(); err != nil {
			invalidParams.AddNested("FieldWells", err.(request.ErrInvalidParams))
		}
	}
	if s.PrimaryYAxisLabelOptions != nil {
		if err := s.PrimaryYAxisLabelOptions.Validate(); err != nil {
			invalidParams.AddNested("PrimaryYAxisLabelOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ReferenceLines != nil {
		for i, v := range s.ReferenceLines {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReferenceLines", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortConfiguration != nil {
		if err := s.SortConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SortConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tooltip != nil {
		if err := s.Tooltip.Validate(); err != nil {
			invalidParams.AddNested("Tooltip", err.(request.ErrInvalidParams))
		}
	}
	if s.VisualPalette != nil {
		if err := s.VisualPalette.Validate(); err != nil {
			invalidParams.AddNested("VisualPalette", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBoxPlotOptions sets the BoxPlotOptions field's value.
func (s *BoxPlotChartConfiguration) SetBoxPlotOptions(v *BoxPlotOptions) *BoxPlotChartConfiguration {
	s.BoxPlotOptions = v
	return s
}

// SetCategoryAxis sets the CategoryAxis field's value.
func (s *BoxPlotChartConfiguration) SetCategoryAxis(v *AxisDisplayOptions) *BoxPlotChartConfiguration {
	s.CategoryAxis = v
	return s
}

// SetCategoryLabelOptions sets the CategoryLabelOptions field's value.
func (s *BoxPlotChartConfiguration) SetCategoryLabelOptions(v *ChartAxisLabelOptions) *BoxPlotChartConfiguration {
	s.CategoryLabelOptions = v
	return s
}

// SetFieldWells sets the FieldWells field's value.
func (s *BoxPlotChartConfiguration) SetFieldWells(v *BoxPlotFieldWells) *BoxPlotChartConfiguration {
	s.FieldWells = v
	return s
}

// SetLegend sets the Legend field's value.
func (s *BoxPlotChartConfiguration) SetLegend(v *LegendOptions) *BoxPlotChartConfiguration {
	s.Legend = v
	return s
}

// SetPrimaryYAxisDisplayOptions sets the PrimaryYAxisDisplayOptions field's value.
func (s *BoxPlotChartConfiguration) SetPrimaryYAxisDisplayOptions(v *AxisDisplayOptions) *BoxPlotChartConfiguration {
	s.PrimaryYAxisDisplayOptions = v
	return s
}

// SetPrimaryYAxisLabelOptions sets the PrimaryYAxisLabelOptions field's value.
func (s *BoxPlotChartConfiguration) SetPrimaryYAxisLabelOptions(v *ChartAxisLabelOptions) *BoxPlotChartConfiguration {
	s.PrimaryYAxisLabelOptions = v
	return s
}

// SetReferenceLines sets the ReferenceLines field's value.
func (s *BoxPlotChartConfiguration) SetReferenceLines(v []*ReferenceLine) *BoxPlotChartConfiguration {
	s.ReferenceLines = v
	return s
}

// SetSortConfiguration sets the SortConfiguration field's value.
func (s *BoxPlotChartConfiguration) SetSortConfiguration(v *BoxPlotSortConfiguration) *BoxPlotChartConfiguration {
	s.SortConfiguration = v
	return s
}

// SetTooltip sets the Tooltip field's value.
func (s *BoxPlotChartConfiguration) SetTooltip(v *TooltipOptions) *BoxPlotChartConfiguration {
	s.Tooltip = v
	return s
}

// SetVisualPalette sets the VisualPalette field's value.
func (s *BoxPlotChartConfiguration) SetVisualPalette(v *VisualPalette) *BoxPlotChartConfiguration {
	s.VisualPalette = v
	return s
}

// The field wells of a BoxPlotVisual.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type BoxPlotFieldWells struct {
	_ struct{} `type:"structure"`

	// The aggregated field wells of a box plot.
	BoxPlotAggregatedFieldWells *BoxPlotAggregatedFieldWells `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotFieldWells) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotFieldWells) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BoxPlotFieldWells) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BoxPlotFieldWells"}
	if s.BoxPlotAggregatedFieldWells != nil {
		if err := s.BoxPlotAggregatedFieldWells.Validate(); err != nil {
			invalidParams.AddNested("BoxPlotAggregatedFieldWells", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBoxPlotAggregatedFieldWells sets the BoxPlotAggregatedFieldWells field's value.
func (s *BoxPlotFieldWells) SetBoxPlotAggregatedFieldWells(v *BoxPlotAggregatedFieldWells) *BoxPlotFieldWells {
	s.BoxPlotAggregatedFieldWells = v
	return s
}

// The options of a box plot visual.
type BoxPlotOptions struct {
	_ struct{} `type:"structure"`

	// Determines the visibility of all data points of the box plot.
	AllDataPointsVisibility *string `type:"string" enum:"Visibility"`

	// Determines the visibility of the outlier in a box plot.
	OutlierVisibility *string `type:"string" enum:"Visibility"`

	// The style options of the box plot.
	StyleOptions *BoxPlotStyleOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotOptions) GoString() string {
	return s.String()
}

// SetAllDataPointsVisibility sets the AllDataPointsVisibility field's value.
func (s *BoxPlotOptions) SetAllDataPointsVisibility(v string) *BoxPlotOptions {
	s.AllDataPointsVisibility = &v
	return s
}

// SetOutlierVisibility sets the OutlierVisibility field's value.
func (s *BoxPlotOptions) SetOutlierVisibility(v string) *BoxPlotOptions {
	s.OutlierVisibility = &v
	return s
}

// SetStyleOptions sets the StyleOptions field's value.
func (s *BoxPlotOptions) SetStyleOptions(v *BoxPlotStyleOptions) *BoxPlotOptions {
	s.StyleOptions = v
	return s
}

// The sort configuration of a BoxPlotVisual.
type BoxPlotSortConfiguration struct {
	_ struct{} `type:"structure"`

	// The sort configuration of a group by fields.
	CategorySort []*FieldSortOptions `type:"list"`

	// The pagination configuration of a table visual or box plot.
	PaginationConfiguration *PaginationConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotSortConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotSortConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BoxPlotSortConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BoxPlotSortConfiguration"}
	if s.CategorySort != nil {
		for i, v := range s.CategorySort {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CategorySort", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PaginationConfiguration != nil {
		if err := s.PaginationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PaginationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategorySort sets the CategorySort field's value.
func (s *BoxPlotSortConfiguration) SetCategorySort(v []*FieldSortOptions) *BoxPlotSortConfiguration {
	s.CategorySort = v
	return s
}

// SetPaginationConfiguration sets the PaginationConfiguration field's value.
func (s *BoxPlotSortConfiguration) SetPaginationConfiguration(v *PaginationConfiguration) *BoxPlotSortConfiguration {
	s.PaginationConfiguration = v
	return s
}

// The style options of the box plot.
type BoxPlotStyleOptions struct {
	_ struct{} `type:"structure"`

	// The fill styles (solid, transparent) of the box plot.
	FillStyle *string `type:"string" enum:"BoxPlotFillStyle"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotStyleOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotStyleOptions) GoString() string {
	return s.String()
}

// SetFillStyle sets the FillStyle field's value.
func (s *BoxPlotStyleOptions) SetFillStyle(v string) *BoxPlotStyleOptions {
	s.FillStyle = &v
	return s
}

// A box plot.
//
// For more information, see Using box plots (https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html)
// in the Amazon QuickSight User Guide.
type BoxPlotVisual struct {
	_ struct{} `type:"structure"`

	// The list of custom actions that are configured for a visual.
	Actions []*VisualCustomAction `type:"list"`

	// The configuration settings of the visual.
	ChartConfiguration *BoxPlotChartConfiguration `type:"structure"`

	// The column hierarchy that is used during drill-downs and drill-ups.
	ColumnHierarchies []*ColumnHierarchy `type:"list"`

	// The subtitle that is displayed on the visual.
	Subtitle *VisualSubtitleLabelOptions `type:"structure"`

	// The title that is displayed on the visual.
	Title *VisualTitleLabelOptions `type:"structure"`

	// The unique identifier of a visual. This identifier must be unique within
	// the context of a dashboard, template, or analysis. Two dashboards, analyses,
	// or templates can have visuals with the same identifiers..
	//
	// VisualId is a required field
	VisualId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotVisual) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoxPlotVisual) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BoxPlotVisual) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BoxPlotVisual"}
	if s.VisualId == nil {
		invalidParams.Add(request.NewErrParamRequired("VisualId"))
	}
	if s.VisualId != nil && len(*s.VisualId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VisualId", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ChartConfiguration != nil {
		if err := s.ChartConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChartConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ColumnHierarchies != nil {
		for i, v := range s.ColumnHierarchies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnHierarchies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Subtitle != nil {
		if err := s.Subtitle.Validate(); err != nil {
			invalidParams.AddNested("Subtitle", err.(request.ErrInvalidParams))
		}
	}
	if s.Title != nil {
		if err := s.Title.Validate(); err != nil {
			invalidParams.AddNested("Title", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *BoxPlotVisual) SetActions(v []*VisualCustomAction) *BoxPlotVisual {
	s.Actions = v
	return s
}

// SetChartConfiguration sets the ChartConfiguration field's value.
func (s *BoxPlotVisual) SetChartConfiguration(v *BoxPlotChartConfiguration) *BoxPlotVisual {
	s.ChartConfiguration = v
	return s
}

// SetColumnHierarchies sets the ColumnHierarchies field's value.
func (s *BoxPlotVisual) SetColumnHierarchies(v []*ColumnHierarchy) *BoxPlotVisual {
	s.ColumnHierarchies = v
	return s
}

// SetSubtitle sets the Subtitle field's value.
func (s *BoxPlotVisual) SetSubtitle(v *VisualSubtitleLabelOptions) *BoxPlotVisual {
	s.Subtitle = v
	return s
}

// SetTitle sets the Title field's value.
func (s *BoxPlotVisual) SetTitle(v *VisualTitleLabelOptions) *BoxPlotVisual {
	s.Title = v
	return s
}

// SetVisualId sets the VisualId field's value.
func (s *BoxPlotVisual) SetVisualId(v string) *BoxPlotVisual {
	s.VisualId = &v
	return s
}

// A calculated column for a dataset.
type CalculatedColumn struct {
	_ struct{} `type:"structure"`

	// A unique ID to identify a calculated column. During a dataset update, if
	// the column ID of a calculated column matches that of an existing calculated
	// column, Amazon QuickSight preserves the existing calculated column.
	//
	// ColumnId is a required field
	ColumnId *string `min:"1" type:"string" required:"true"`

	// Column name.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// An expression that defines the calculated column.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CalculatedColumn's
	// String and GoString methods.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculatedColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculatedColumn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CalculatedColumn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CalculatedColumn"}
	if s.ColumnId == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnId"))
	}
	if s.ColumnId != nil && len(*s.ColumnId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnId", 1))
	}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnId sets the ColumnId field's value.
func (s *CalculatedColumn) SetColumnId(v string) *CalculatedColumn {
	s.ColumnId = &v
	return s
}

// SetColumnName sets the ColumnName field's value.
func (s *CalculatedColumn) SetColumnName(v string) *CalculatedColumn {
	s.ColumnName = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *CalculatedColumn) SetExpression(v string) *CalculatedColumn {
	s.Expression = &v
	return s
}

// The calculated field of an analysis.
type CalculatedField struct {
	_ struct{} `type:"structure"`

	// The data set that is used in this calculated field.
	//
	// DataSetIdentifier is a required field
	DataSetIdentifier *string `min:"1" type:"string" required:"true"`

	// The expression of the calculated field.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CalculatedField's
	// String and GoString methods.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The name of the calculated field.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculatedField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculatedField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CalculatedField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CalculatedField"}
	if s.DataSetIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetIdentifier"))
	}
	if s.DataSetIdentifier != nil && len(*s.DataSetIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetIdentifier", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetIdentifier sets the DataSetIdentifier field's value.
func (s *CalculatedField) SetDataSetIdentifier(v string) *CalculatedField {
	s.DataSetIdentifier = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *CalculatedField) SetExpression(v string) *CalculatedField {
	s.Expression = &v
	return s
}

// SetName sets the Name field's value.
func (s *CalculatedField) SetName(v string) *CalculatedField {
	s.Name = &v
	return s
}

// The table calculation measure field for pivot tables.
type CalculatedMeasureField struct {
	_ struct{} `type:"structure"`

	// The expression in the table calculation.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CalculatedMeasureField's
	// String and GoString methods.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The custom field ID.
	//
	// FieldId is a required field
	FieldId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculatedMeasureField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculatedMeasureField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CalculatedMeasureField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CalculatedMeasureField"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.FieldId == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldId"))
	}
	if s.FieldId != nil && len(*s.FieldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *CalculatedMeasureField) SetExpression(v string) *CalculatedMeasureField {
	s.Expression = &v
	return s
}

// SetFieldId sets the FieldId field's value.
func (s *CalculatedMeasureField) SetFieldId(v string) *CalculatedMeasureField {
	s.FieldId = &v
	return s
}

type CancelIngestionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the dataset used in the ingestion.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// An ID for the ingestion.
	//
	// IngestionId is a required field
	IngestionId *string `location:"uri" locationName:"IngestionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelIngestionInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.IngestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionId"))
	}
	if s.IngestionId != nil && len(*s.IngestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CancelIngestionInput) SetAwsAccountId(v string) *CancelIngestionInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CancelIngestionInput) SetDataSetId(v string) *CancelIngestionInput {
	s.DataSetId = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CancelIngestionInput) SetIngestionId(v string) *CancelIngestionInput {
	s.IngestionId = &v
	return s
}

type CancelIngestionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the data ingestion.
	Arn *string `type:"string"`

	// An ID for the ingestion.
	IngestionId *string `min:"1" type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelIngestionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CancelIngestionOutput) SetArn(v string) *CancelIngestionOutput {
	s.Arn = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CancelIngestionOutput) SetIngestionId(v string) *CancelIngestionOutput {
	s.IngestionId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CancelIngestionOutput) SetRequestId(v string) *CancelIngestionOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CancelIngestionOutput) SetStatus(v int64) *CancelIngestionOutput {
	s.Status = &v
	return s
}

// The values that are displayed in a control can be configured to only show
// values that are valid based on what's selected in other controls.
type CascadingControlConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of source controls that determine the values that are used in the
	// current control.
	SourceControls []*CascadingControlSource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CascadingControlConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CascadingControlConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CascadingControlConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CascadingControlConfiguration"}
	if s.SourceControls != nil {
		for i, v := range s.SourceControls {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceControls", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceControls sets the SourceControls field's value.
func (s *CascadingControlConfiguration) SetSourceControls(v []*CascadingControlSource) *CascadingControlConfiguration {
	s.SourceControls = v
	return s
}

// The source controls that are used in a CascadingControlConfiguration.
type CascadingControlSource struct {
	_ struct{} `type:"structure"`

	// The column identifier that determines which column to look up for the source
	// sheet control.
	ColumnToMatch *ColumnIdentifier `type:"structure"`

	// The source sheet control ID of a CascadingControlSource.
	SourceSheetControlId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CascadingControlSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CascadingControlSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CascadingControlSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CascadingControlSource"}
	if s.ColumnToMatch != nil {
		if err := s.ColumnToMatch.Validate(); err != nil {
			invalidParams.AddNested("ColumnToMatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnToMatch sets the ColumnToMatch field's value.
func (s *CascadingControlSource) SetColumnToMatch(v *ColumnIdentifier) *CascadingControlSource {
	s.ColumnToMatch = v
	return s
}

// SetSourceSheetControlId sets the SourceSheetControlId field's value.
func (s *CascadingControlSource) SetSourceSheetControlId(v string) *CascadingControlSource {
	s.SourceSheetControlId = &v
	return s
}

// A transform operation that casts a column to a different type.
type CastColumnTypeOperation struct {
	_ struct{} `type:"structure"`

	// Column name.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// When casting a column from string to datetime type, you can supply a string
	// in a format supported by Amazon QuickSight to denote the source data format.
	Format *string `type:"string"`

	// New column data type.
	//
	// NewColumnType is a required field
	NewColumnType *string `type:"string" required:"true" enum:"ColumnDataType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CastColumnTypeOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CastColumnTypeOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CastColumnTypeOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CastColumnTypeOperation"}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.NewColumnType == nil {
		invalidParams.Add(request.NewErrParamRequired("NewColumnType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnName sets the ColumnName field's value.
func (s *CastColumnTypeOperation) SetColumnName(v string) *CastColumnTypeOperation {
	s.ColumnName = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CastColumnTypeOperation) SetFormat(v string) *CastColumnTypeOperation {
	s.Format = &v
	return s
}

// SetNewColumnType sets the NewColumnType field's value.
func (s *CastColumnTypeOperation) SetNewColumnType(v string) *CastColumnTypeOperation {
	s.NewColumnType = &v
	return s
}

// The dimension type field with categorical type columns..
type CategoricalDimensionField struct {
	_ struct{} `type:"structure"`

	// The column that is used in the CategoricalDimensionField.
	//
	// Column is a required field
	Column *ColumnIdentifier `type:"structure" required:"true"`

	// The custom field ID.
	//
	// FieldId is a required field
	FieldId *string `min:"1" type:"string" required:"true"`

	// The format configuration of the field.
	FormatConfiguration *StringFormatConfiguration `type:"structure"`

	// The custom hierarchy ID.
	HierarchyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoricalDimensionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoricalDimensionField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoricalDimensionField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CategoricalDimensionField"}
	if s.Column == nil {
		invalidParams.Add(request.NewErrParamRequired("Column"))
	}
	if s.FieldId == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldId"))
	}
	if s.FieldId != nil && len(*s.FieldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldId", 1))
	}
	if s.HierarchyId != nil && len(*s.HierarchyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HierarchyId", 1))
	}
	if s.Column != nil {
		if err := s.Column.Validate(); err != nil {
			invalidParams.AddNested("Column", err.(request.ErrInvalidParams))
		}
	}
	if s.FormatConfiguration != nil {
		if err := s.FormatConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FormatConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumn sets the Column field's value.
func (s *CategoricalDimensionField) SetColumn(v *ColumnIdentifier) *CategoricalDimensionField {
	s.Column = v
	return s
}

// SetFieldId sets the FieldId field's value.
func (s *CategoricalDimensionField) SetFieldId(v string) *CategoricalDimensionField {
	s.FieldId = &v
	return s
}

// SetFormatConfiguration sets the FormatConfiguration field's value.
func (s *CategoricalDimensionField) SetFormatConfiguration(v *StringFormatConfiguration) *CategoricalDimensionField {
	s.FormatConfiguration = v
	return s
}

// SetHierarchyId sets the HierarchyId field's value.
func (s *CategoricalDimensionField) SetHierarchyId(v string) *CategoricalDimensionField {
	s.HierarchyId = &v
	return s
}

// The measure type field with categorical type columns.
type CategoricalMeasureField struct {
	_ struct{} `type:"structure"`

	// The aggregation function of the measure field.
	AggregationFunction *string `type:"string" enum:"CategoricalAggregationFunction"`

	// The column that is used in the CategoricalMeasureField.
	//
	// Column is a required field
	Column *ColumnIdentifier `type:"structure" required:"true"`

	// The custom field ID.
	//
	// FieldId is a required field
	FieldId *string `min:"1" type:"string" required:"true"`

	// The format configuration of the field.
	FormatConfiguration *StringFormatConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoricalMeasureField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoricalMeasureField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoricalMeasureField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CategoricalMeasureField"}
	if s.Column == nil {
		invalidParams.Add(request.NewErrParamRequired("Column"))
	}
	if s.FieldId == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldId"))
	}
	if s.FieldId != nil && len(*s.FieldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldId", 1))
	}
	if s.Column != nil {
		if err := s.Column.Validate(); err != nil {
			invalidParams.AddNested("Column", err.(request.ErrInvalidParams))
		}
	}
	if s.FormatConfiguration != nil {
		if err := s.FormatConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FormatConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationFunction sets the AggregationFunction field's value.
func (s *CategoricalMeasureField) SetAggregationFunction(v string) *CategoricalMeasureField {
	s.AggregationFunction = &v
	return s
}

// SetColumn sets the Column field's value.
func (s *CategoricalMeasureField) SetColumn(v *ColumnIdentifier) *CategoricalMeasureField {
	s.Column = v
	return s
}

// SetFieldId sets the FieldId field's value.
func (s *CategoricalMeasureField) SetFieldId(v string) *CategoricalMeasureField {
	s.FieldId = &v
	return s
}

// SetFormatConfiguration sets the FormatConfiguration field's value.
func (s *CategoricalMeasureField) SetFormatConfiguration(v *StringFormatConfiguration) *CategoricalMeasureField {
	s.FormatConfiguration = v
	return s
}

// The numeric equality type drill down filter.
type CategoryDrillDownFilter struct {
	_ struct{} `type:"structure"`

	// A list of the string inputs that are the values of the category drill down
	// filter.
	//
	// CategoryValues is a required field
	CategoryValues []*string `type:"list" required:"true"`

	// The column that the filter is applied to.
	//
	// Column is a required field
	Column *ColumnIdentifier `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryDrillDownFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryDrillDownFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoryDrillDownFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CategoryDrillDownFilter"}
	if s.CategoryValues == nil {
		invalidParams.Add(request.NewErrParamRequired("CategoryValues"))
	}
	if s.Column == nil {
		invalidParams.Add(request.NewErrParamRequired("Column"))
	}
	if s.Column != nil {
		if err := s.Column.Validate(); err != nil {
			invalidParams.AddNested("Column", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryValues sets the CategoryValues field's value.
func (s *CategoryDrillDownFilter) SetCategoryValues(v []*string) *CategoryDrillDownFilter {
	s.CategoryValues = v
	return s
}

// SetColumn sets the Column field's value.
func (s *CategoryDrillDownFilter) SetColumn(v *ColumnIdentifier) *CategoryDrillDownFilter {
	s.Column = v
	return s
}

// A CategoryFilter filters text values.
//
// For more information, see Adding text filters (https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html)
// in the Amazon QuickSight User Guide.
type CategoryFilter struct {
	_ struct{} `type:"structure"`

	// The column that the filter is applied to.
	//
	// Column is a required field
	Column *ColumnIdentifier `type:"structure" required:"true"`

	// The configuration for a CategoryFilter.
	//
	// Configuration is a required field
	Configuration *CategoryFilterConfiguration `type:"structure" required:"true"`

	// An identifier that uniquely identifies a filter within a dashboard, analysis,
	// or template.
	//
	// FilterId is a required field
	FilterId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoryFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CategoryFilter"}
	if s.Column == nil {
		invalidParams.Add(request.NewErrParamRequired("Column"))
	}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.FilterId == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterId"))
	}
	if s.FilterId != nil && len(*s.FilterId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterId", 1))
	}
	if s.Column != nil {
		if err := s.Column.Validate(); err != nil {
			invalidParams.AddNested("Column", err.(request.ErrInvalidParams))
		}
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumn sets the Column field's value.
func (s *CategoryFilter) SetColumn(v *ColumnIdentifier) *CategoryFilter {
	s.Column = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CategoryFilter) SetConfiguration(v *CategoryFilterConfiguration) *CategoryFilter {
	s.Configuration = v
	return s
}

// SetFilterId sets the FilterId field's value.
func (s *CategoryFilter) SetFilterId(v string) *CategoryFilter {
	s.FilterId = &v
	return s
}

// The configuration for a CategoryFilter.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type CategoryFilterConfiguration struct {
	_ struct{} `type:"structure"`

	// A custom filter that filters based on a single value. This filter can be
	// partially matched.
	CustomFilterConfiguration *CustomFilterConfiguration `type:"structure"`

	// A list of custom filter values. In the Amazon QuickSight console, this filter
	// type is called a custom filter list.
	CustomFilterListConfiguration *CustomFilterListConfiguration `type:"structure"`

	// A list of filter configurations. In the Amazon QuickSight console, this filter
	// type is called a filter list.
	FilterListConfiguration *FilterListConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryFilterConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryFilterConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoryFilterConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CategoryFilterConfiguration"}
	if s.CustomFilterConfiguration != nil {
		if err := s.CustomFilterConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CustomFilterConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomFilterListConfiguration != nil {
		if err := s.CustomFilterListConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CustomFilterListConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.FilterListConfiguration != nil {
		if err := s.FilterListConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FilterListConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomFilterConfiguration sets the CustomFilterConfiguration field's value.
func (s *CategoryFilterConfiguration) SetCustomFilterConfiguration(v *CustomFilterConfiguration) *CategoryFilterConfiguration {
	s.CustomFilterConfiguration = v
	return s
}

// SetCustomFilterListConfiguration sets the CustomFilterListConfiguration field's value.
func (s *CategoryFilterConfiguration) SetCustomFilterListConfiguration(v *CustomFilterListConfiguration) *CategoryFilterConfiguration {
	s.CustomFilterListConfiguration = v
	return s
}

// SetFilterListConfiguration sets the FilterListConfiguration field's value.
func (s *CategoryFilterConfiguration) SetFilterListConfiguration(v *FilterListConfiguration) *CategoryFilterConfiguration {
	s.FilterListConfiguration = v
	return s
}

// The label options for an axis on a chart.
type ChartAxisLabelOptions struct {
	_ struct{} `type:"structure"`

	// The label options for a chart axis.
	AxisLabelOptions []*AxisLabelOptions `type:"list"`

	// The visibility configuration of the sort icon on a chart's axis label.
	SortIconVisibility *string `type:"string" enum:"Visibility"`

	// The visibility of an axis label on a chart. Choose one of the following options:
	//
	//    * VISIBLE: Shows the axis.
	//
	//    * HIDDEN: Hides the axis.
	Visibility *string `type:"string" enum:"Visibility"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChartAxisLabelOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChartAxisLabelOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChartAxisLabelOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChartAxisLabelOptions"}
	if s.AxisLabelOptions != nil {
		for i, v := range s.AxisLabelOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AxisLabelOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAxisLabelOptions sets the AxisLabelOptions field's value.
func (s *ChartAxisLabelOptions) SetAxisLabelOptions(v []*AxisLabelOptions) *ChartAxisLabelOptions {
	s.AxisLabelOptions = v
	return s
}

// SetSortIconVisibility sets the SortIconVisibility field's value.
func (s *ChartAxisLabelOptions) SetSortIconVisibility(v string) *ChartAxisLabelOptions {
	s.SortIconVisibility = &v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *ChartAxisLabelOptions) SetVisibility(v string) *ChartAxisLabelOptions {
	s.Visibility = &v
	return s
}

// The cluster marker that is a part of the cluster marker configuration.
type ClusterMarker struct {
	_ struct{} `type:"structure"`

	// The simple cluster marker of the cluster marker.
	SimpleClusterMarker *SimpleClusterMarker `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterMarker) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterMarker) GoString() string {
	return s.String()
}

// SetSimpleClusterMarker sets the SimpleClusterMarker field's value.
func (s *ClusterMarker) SetSimpleClusterMarker(v *SimpleClusterMarker) *ClusterMarker {
	s.SimpleClusterMarker = v
	return s
}

// The cluster marker configuration of the geospatial map selected point style.
type ClusterMarkerConfiguration struct {
	_ struct{} `type:"structure"`

	// The cluster marker that is a part of the cluster marker configuration
	ClusterMarker *ClusterMarker `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterMarkerConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterMarkerConfiguration) GoString() string {
	return s.String()
}

// SetClusterMarker sets the ClusterMarker field's value.
func (s *ClusterMarkerConfiguration) SetClusterMarker(v *ClusterMarker) *ClusterMarkerConfiguration {
	s.ClusterMarker = v
	return s
}

// Determines the color scale that is applied to the visual.
type ColorScale struct {
	_ struct{} `type:"structure"`

	// Determines the color fill type.
	//
	// ColorFillType is a required field
	ColorFillType *string `type:"string" required:"true" enum:"ColorFillType"`

	// Determines the list of colors that are applied to the visual.
	//
	// Colors is a required field
	Colors []*DataColor `min:"2" type:"list" required:"true"`

	// Determines the color that is applied to null values.
	NullValueColor *DataColor `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColorScale) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColorScale) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColorScale) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColorScale"}
	if s.ColorFillType == nil {
		invalidParams.Add(request.NewErrParamRequired("ColorFillType"))
	}
	if s.Colors == nil {
		invalidParams.Add(request.NewErrParamRequired("Colors"))
	}
	if s.Colors != nil && len(s.Colors) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Colors", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColorFillType sets the ColorFillType field's value.
func (s *ColorScale) SetColorFillType(v string) *ColorScale {
	s.ColorFillType = &v
	return s
}

// SetColors sets the Colors field's value.
func (s *ColorScale) SetColors(v []*DataColor) *ColorScale {
	s.Colors = v
	return s
}

// SetNullValueColor sets the NullValueColor field's value.
func (s *ColorScale) SetNullValueColor(v *DataColor) *ColorScale {
	s.NullValueColor = v
	return s
}

// The general configuration of a column.
type ColumnConfiguration struct {
	_ struct{} `type:"structure"`

	// The column.
	//
	// Column is a required field
	Column *ColumnIdentifier `type:"structure" required:"true"`

	// The format configuration of a column.
	FormatConfiguration *FormatConfiguration `type:"structure"`

	// The role of the column.
	Role *string `type:"string" enum:"ColumnRole"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnConfiguration"}
	if s.Column == nil {
		invalidParams.Add(request.NewErrParamRequired("Column"))
	}
	if s.Column != nil {
		if err := s.Column.Validate(); err != nil {
			invalidParams.AddNested("Column", err.(request.ErrInvalidParams))
		}
	}
	if s.FormatConfiguration != nil {
		if err := s.FormatConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FormatConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumn sets the Column field's value.
func (s *ColumnConfiguration) SetColumn(v *ColumnIdentifier) *ColumnConfiguration {
	s.Column = v
	return s
}

// SetFormatConfiguration sets the FormatConfiguration field's value.
func (s *ColumnConfiguration) SetFormatConfiguration(v *FormatConfiguration) *ColumnConfiguration {
	s.FormatConfiguration = v
	return s
}

// SetRole sets the Role field's value.
func (s *ColumnConfiguration) SetRole(v string) *ColumnConfiguration {
	s.Role = &v
	return s
}

// Metadata that contains a description for a column.
type ColumnDescription struct {
	_ struct{} `type:"structure"`

	// The text of a description for a column.
	Text *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnDescription) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *ColumnDescription) SetText(v string) *ColumnDescription {
	s.Text = &v
	return s
}

// Groupings of columns that work together in certain Amazon QuickSight features.
// This is a variant type structure. For this structure to be valid, only one
// of the attributes can be non-null.
type ColumnGroup struct {
	_ struct{} `type:"structure"`

	// Geospatial column group that denotes a hierarchy.
	GeoSpatialColumnGroup *GeoSpatialColumnGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnGroup"}
	if s.GeoSpatialColumnGroup != nil {
		if err := s.GeoSpatialColumnGroup.Validate(); err != nil {
			invalidParams.AddNested("GeoSpatialColumnGroup", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeoSpatialColumnGroup sets the GeoSpatialColumnGroup field's value.
func (s *ColumnGroup) SetGeoSpatialColumnGroup(v *GeoSpatialColumnGroup) *ColumnGroup {
	s.GeoSpatialColumnGroup = v
	return s
}

// A structure describing the name, data type, and geographic role of the columns.
type ColumnGroupColumnSchema struct {
	_ struct{} `type:"structure"`

	// The name of the column group's column schema.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroupColumnSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroupColumnSchema) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ColumnGroupColumnSchema) SetName(v string) *ColumnGroupColumnSchema {
	s.Name = &v
	return s
}

// The column group schema.
type ColumnGroupSchema struct {
	_ struct{} `type:"structure"`

	// A structure containing the list of schemas for column group columns.
	ColumnGroupColumnSchemaList []*ColumnGroupColumnSchema `type:"list"`

	// The name of the column group schema.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroupSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroupSchema) GoString() string {
	return s.String()
}

// SetColumnGroupColumnSchemaList sets the ColumnGroupColumnSchemaList field's value.
func (s *ColumnGroupSchema) SetColumnGroupColumnSchemaList(v []*ColumnGroupColumnSchema) *ColumnGroupSchema {
	s.ColumnGroupColumnSchemaList = v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnGroupSchema) SetName(v string) *ColumnGroupSchema {
	s.Name = &v
	return s
}

// The option that determines the hierarchy of the fields for a visual element.
type ColumnHierarchy struct {
	_ struct{} `type:"structure"`

	// The option that determines the hierarchy of any DateTime fields.
	DateTimeHierarchy *DateTimeHierarchy `type:"structure"`

	// The option that determines the hierarchy of the fields that are built within
	// a visual's field wells. These fields can't be duplicated to other visuals.
	ExplicitHierarchy *ExplicitHierarchy `type:"structure"`

	// The option that determines the hierarchy of the fields that are defined during
	// data preparation. These fields are available to use in any analysis that
	// uses the data source.
	PredefinedHierarchy *PredefinedHierarchy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnHierarchy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnHierarchy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnHierarchy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnHierarchy"}
	if s.DateTimeHierarchy != nil {
		if err := s.DateTimeHierarchy.Validate(); err != nil {
			invalidParams.AddNested("DateTimeHierarchy", err.(request.ErrInvalidParams))
		}
	}
	if s.ExplicitHierarchy != nil {
		if err := s.ExplicitHierarchy.Validate(); err != nil {
			invalidParams.AddNested("ExplicitHierarchy", err.(request.ErrInvalidParams))
		}
	}
	if s.PredefinedHierarchy != nil {
		if err := s.PredefinedHierarchy.Validate(); err != nil {
			invalidParams.AddNested("PredefinedHierarchy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateTimeHierarchy sets the DateTimeHierarchy field's value.
func (s *ColumnHierarchy) SetDateTimeHierarchy(v *DateTimeHierarchy) *ColumnHierarchy {
	s.DateTimeHierarchy = v
	return s
}

// SetExplicitHierarchy sets the ExplicitHierarchy field's value.
func (s *ColumnHierarchy) SetExplicitHierarchy(v *ExplicitHierarchy) *ColumnHierarchy {
	s.ExplicitHierarchy = v
	return s
}

// SetPredefinedHierarchy sets the PredefinedHierarchy field's value.
func (s *ColumnHierarchy) SetPredefinedHierarchy(v *PredefinedHierarchy) *ColumnHierarchy {
	s.PredefinedHierarchy = v
	return s
}

// A column of a data set.
type ColumnIdentifier struct {
	_ struct{} `type:"structure"`

	// The name of the column.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// The data set that the column belongs to.
	//
	// DataSetIdentifier is a required field
	DataSetIdentifier *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnIdentifier"}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.DataSetIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetIdentifier"))
	}
	if s.DataSetIdentifier != nil && len(*s.DataSetIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnName sets the ColumnName field's value.
func (s *ColumnIdentifier) SetColumnName(v string) *ColumnIdentifier {
	s.ColumnName = &v
	return s
}

// SetDataSetIdentifier sets the DataSetIdentifier field's value.
func (s *ColumnIdentifier) SetDataSetIdentifier(v string) *ColumnIdentifier {
	s.DataSetIdentifier = &v
	return s
}

// A rule defined to grant access on one or more restricted columns. Each dataset
// can have multiple rules. To create a restricted column, you add it to one
// or more rules. Each rule must contain at least one column and at least one
// user or group. To be able to see a restricted column, a user or group needs
// to be added to a rule for that column.
type ColumnLevelPermissionRule struct {
	_ struct{} `type:"structure"`

	// An array of column names.
	ColumnNames []*string `min:"1" type:"list"`

	// An array of Amazon Resource Names (ARNs) for Amazon QuickSight users or groups.
	Principals []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnLevelPermissionRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnLevelPermissionRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnLevelPermissionRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnLevelPermissionRule"}
	if s.ColumnNames != nil && len(s.ColumnNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnNames", 1))
	}
	if s.Principals != nil && len(s.Principals) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Principals", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnNames sets the ColumnNames field's value.
func (s *ColumnLevelPermissionRule) SetColumnNames(v []*string) *ColumnLevelPermissionRule {
	s.ColumnNames = v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *ColumnLevelPermissionRule) SetPrincipals(v []*string) *ColumnLevelPermissionRule {
	s.Principals = v
	return s
}

// The column schema.
type ColumnSchema struct {
	_ struct{} `type:"structure"`

	// The data type of the column schema.
	DataType *string `type:"string"`

	// The geographic role of the column schema.
	GeographicRole *string `type:"string"`

	// The name of the column schema.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnSchema) GoString() string {
	return s.String()
}

// SetDataType sets the DataType field's value.
func (s *ColumnSchema) SetDataType(v string) *ColumnSchema {
	s.DataType = &v
	return s
}

// SetGeographicRole sets the GeographicRole field's value.
func (s *ColumnSchema) SetGeographicRole(v string) *ColumnSchema {
	s.GeographicRole = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnSchema) SetName(v string) *ColumnSchema {
	s.Name = &v
	return s
}

// The sort configuration for a column that is not used in a field well.
type ColumnSort struct {
	_ struct{} `type:"structure"`

	// The aggregation function that is defined in the column sort.
	AggregationFunction *AggregationFunction `type:"structure"`

	// The sort direction.
	//
	// Direction is a required field
	Direction *string `type:"string" required:"true" enum:"SortDirection"`

	// A column of a data set.
	//
	// SortBy is a required field
	SortBy *ColumnIdentifier `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnSort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnSort) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnSort) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnSort"}
	if s.Direction == nil {
		invalidParams.Add(request.NewErrParamRequired("Direction"))
	}
	if s.SortBy == nil {
		invalidParams.Add(request.NewErrParamRequired("SortBy"))
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationFunction sets the AggregationFunction field's value.
func (s *ColumnSort) SetAggregationFunction(v *AggregationFunction) *ColumnSort {
	s.AggregationFunction = v
	return s
}

// SetDirection sets the Direction field's value.
func (s *ColumnSort) SetDirection(v string) *ColumnSort {
	s.Direction = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ColumnSort) SetSortBy(v *ColumnIdentifier) *ColumnSort {
	s.SortBy = v
	return s
}

// A tag for a column in a TagColumnOperation (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_TagColumnOperation.html)
// structure. This is a variant type structure. For this structure to be valid,
// only one of the attributes can be non-null.
type ColumnTag struct {
	_ struct{} `type:"structure"`

	// A description for a column.
	ColumnDescription *ColumnDescription `type:"structure"`

	// A geospatial role for a column.
	ColumnGeographicRole *string `type:"string" enum:"GeoSpatialDataRole"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnTag) GoString() string {
	return s.String()
}

// SetColumnDescription sets the ColumnDescription field's value.
func (s *ColumnTag) SetColumnDescription(v *ColumnDescription) *ColumnTag {
	s.ColumnDescription = v
	return s
}

// SetColumnGeographicRole sets the ColumnGeographicRole field's value.
func (s *ColumnTag) SetColumnGeographicRole(v string) *ColumnTag {
	s.ColumnGeographicRole = &v
	return s
}

// The tooltip item for the columns that are not part of a field well.
type ColumnTooltipItem struct {
	_ struct{} `type:"structure"`

	// The aggregation function of the column tooltip item.
	Aggregation *AggregationFunction `type:"structure"`

	// The target column of the tooltip item.
	//
	// Column is a required field
	Column *ColumnIdentifier `type:"structure" required:"true"`

	// The label of the tooltip item.
	Label *string `type:"string"`

	// The visibility of the tooltip item.
	Visibility *string `type:"string" enum:"Visibility"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnTooltipItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnTooltipItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnTooltipItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnTooltipItem"}
	if s.Column == nil {
		invalidParams.Add(request.NewErrParamRequired("Column"))
	}
	if s.Column != nil {
		if err := s.Column.Validate(); err != nil {
			invalidParams.AddNested("Column", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregation sets the Aggregation field's value.
func (s *ColumnTooltipItem) SetAggregation(v *AggregationFunction) *ColumnTooltipItem {
	s.Aggregation = v
	return s
}

// SetColumn sets the Column field's value.
func (s *ColumnTooltipItem) SetColumn(v *ColumnIdentifier) *ColumnTooltipItem {
	s.Column = v
	return s
}

// SetLabel sets the Label field's value.
func (s *ColumnTooltipItem) SetLabel(v string) *ColumnTooltipItem {
	s.Label = &v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *ColumnTooltipItem) SetVisibility(v string) *ColumnTooltipItem {
	s.Visibility = &v
	return s
}

// The aggregated field wells of a combo chart.
type ComboChartAggregatedFieldWells struct {
	_ struct{} `type:"structure"`

	// The aggregated BarValues field well of a combo chart.
	BarValues []*MeasureField `type:"list"`

	// The aggregated category field wells of a combo chart.
	Category []*DimensionField `type:"list"`

	// The aggregated colors field well of a combo chart.
	Colors []*DimensionField `type:"list"`

	// The aggregated LineValues field well of a combo chart.
	LineValues []*MeasureField `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComboChartAggregatedFieldWells) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComboChartAggregatedFieldWells) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComboChartAggregatedFieldWells) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComboChartAggregatedFieldWells"}
	if s.BarValues != nil {
		for i, v := range s.BarValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BarValues", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Category != nil {
		for i, v := range s.Category {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Category", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Colors != nil {
		for i, v := range s.Colors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Colors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LineValues != nil {
		for i, v := range s.LineValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LineValues", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBarValues sets the BarValues field's value.
func (s *ComboChartAggregatedFieldWells) SetBarValues(v []*MeasureField) *ComboChartAggregatedFieldWells {
	s.BarValues = v
	return s
}

// SetCategory sets the Category field's value.
func (s *ComboChartAggregatedFieldWells) SetCategory(v []*DimensionField) *ComboChartAggregatedFieldWells {
	s.Category = v
	return s
}

// SetColors sets the Colors field's value.
func (s *ComboChartAggregatedFieldWells) SetColors(v []*DimensionField) *ComboChartAggregatedFieldWells {
	s.Colors = v
	return s
}

// SetLineValues sets the LineValues field's value.
func (s *ComboChartAggregatedFieldWells) SetLineValues(v []*MeasureField) *ComboChartAggregatedFieldWells {
	s.LineValues = v
	return s
}

// The configuration of a ComboChartVisual.
type ComboChartConfiguration struct {
	_ struct{} `type:"structure"`

	// The options that determine if visual data labels are displayed.
	//
	// The data label options for a bar in a combo chart.
	BarDataLabels *DataLabelOptions `type:"structure"`

	// Determines the bar arrangement in a combo chart. The following are valid
	// values in this structure:
	//
	//    * CLUSTERED: For clustered bar combo charts.
	//
	//    * STACKED: For stacked bar combo charts.
	//
	//    * STACKED_PERCENT: Do not use. If you use this value, the operation returns
	//    a validation error.
	BarsArrangement *string `type:"string" enum:"BarsArrangement"`

	// The category axis of a combo chart.
	CategoryAxis *AxisDisplayOptions `type:"structure"`

	// The label options (label text, label visibility, and sort icon visibility)
	// of a combo chart category (group/color) field well.
	CategoryLabelOptions *ChartAxisLabelOptions `type:"structure"`

	// The label options (label text, label visibility, and sort icon visibility)
	// of a combo chart's color field well.
	ColorLabelOptions *ChartAxisLabelOptions `type:"structure"`

	// The field wells of the visual.
	FieldWells *ComboChartFieldWells `type:"structure"`

	// The legend display setup of the visual.
	Legend *LegendOptions `type:"structure"`

	// The options that determine if visual data labels are displayed.
	//
	// The data label options for a line in a combo chart.
	LineDataLabels *DataLabelOptions `type:"structure"`

	// The label display options (grid line, range, scale, and axis step) of a combo
	// chart's primary y-axis (bar) field well.
	PrimaryYAxisDisplayOptions *AxisDisplayOptions `type:"structure"`

	// The label options (label text, label visibility, and sort icon visibility)
	// of a combo chart's primary y-axis (bar) field well.
	PrimaryYAxisLabelOptions *ChartAxisLabelOptions `type:"structure"`

	// The reference line setup of the visual.
	ReferenceLines []*ReferenceLine `type:"list"`

	// The label display options (grid line, range, scale, axis step) of a combo
	// chart's secondary y-axis (line) field well.
	SecondaryYAxisDisplayOptions *AxisDisplayOptions `type:"structure"`

	// The label options (label text, label visibility, and sort icon visibility)
	// of a combo chart's secondary y-axis(line) field well.
	SecondaryYAxisLabelOptions *ChartAxisLabelOptions `type:"structure"`

	// The sort configuration of a ComboChartVisual.
	SortConfiguration *ComboChartSortConfiguration `type:"structure"`

	// The legend display setup of the visual.
	Tooltip *TooltipOptions `type:"structure"`

	// The palette (chart color) display setup of the visual.
	VisualPalette *VisualPalette `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComboChartConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComboChartConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComboChartConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComboChartConfiguration"}
	if s.BarDataLabels != nil {
		if err := s.BarDataLabels.Validate(); err != nil {
			invalidParams.AddNested("BarDataLabels", err.(request.ErrInvalidParams))
		}
	}
	if s.CategoryLabelOptions != nil {
		if err := s.CategoryLabelOptions.Validate(); err != nil {
			invalidParams.AddNested("CategoryLabelOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ColorLabelOptions != nil {
		if err := s.ColorLabelOptions.Validate(); err != nil {
			invalidParams.AddNested("ColorLabelOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.FieldWells != nil {
		if err := s.FieldWells.Validate(); err != nil {
			invalidParams.AddNested("FieldWells", err.(request.ErrInvalidParams))
		}
	}
	if s.LineDataLabels != nil {
		if err := s.LineDataLabels.Validate(); err != nil {
			invalidParams.AddNested("LineDataLabels", err.(request.ErrInvalidParams))
		}
	}
	if s.PrimaryYAxisLabelOptions != nil {
		if err := s.PrimaryYAxisLabelOptions.Validate(); err != nil {
			invalidParams.AddNested("PrimaryYAxisLabelOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ReferenceLines != nil {
		for i, v := range s.ReferenceLines {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReferenceLines", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SecondaryYAxisLabelOptions != nil {
		if err := s.SecondaryYAxisLabelOptions.Validate(); err != nil {
			invalidParams.AddNested("SecondaryYAxisLabelOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.SortConfiguration != nil {
		if err := s.SortConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SortConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tooltip != nil {
		if err := s.Tooltip.Validate(); err != nil {
			invalidParams.AddNested("Tooltip", err.(request.ErrInvalidParams))
		}
	}
	if s.VisualPalette != nil {
		if err := s.VisualPalette.Validate(); err != nil {
			invalidParams.AddNested("VisualPalette", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBarDataLabels sets the BarDataLabels field's value.
func (s *ComboChartConfiguration) SetBarDataLabels(v *DataLabelOptions) *ComboChartConfiguration {
	s.BarDataLabels = v
	return s
}

// SetBarsArrangement sets the BarsArrangement field's value.
func (s *ComboChartConfiguration) SetBarsArrangement(v string) *ComboChartConfiguration {
	s.BarsArrangement = &v
	return s
}

// SetCategoryAxis sets the CategoryAxis field's value.
func (s *ComboChartConfiguration) SetCategoryAxis(v *AxisDisplayOptions) *ComboChartConfiguration {
	s.CategoryAxis = v
	return s
}

// SetCategoryLabelOptions sets the CategoryLabelOptions field's value.
func (s *ComboChartConfiguration) SetCategoryLabelOptions(v *ChartAxisLabelOptions) *ComboChartConfiguration {
	s.CategoryLabelOptions = v
	return s
}

// SetColorLabelOptions sets the ColorLabelOptions field's value.
func (s *ComboChartConfiguration) SetColorLabelOptions(v *ChartAxisLabelOptions) *ComboChartConfiguration {
	s.ColorLabelOptions = v
	return s
}

// SetFieldWells sets the FieldWells field's value.
func (s *ComboChartConfiguration) SetFieldWells(v *ComboChartFieldWells) *ComboChartConfiguration {
	s.FieldWells = v
	return s
}

// SetLegend sets the Legend field's value.
func (s *ComboChartConfiguration) SetLegend(v *LegendOptions) *ComboChartConfiguration {
	s.Legend = v
	return s
}

// SetLineDataLabels sets the LineDataLabels field's value.
func (s *ComboChartConfiguration) SetLineDataLabels(v *DataLabelOptions) *ComboChartConfiguration {
	s.LineDataLabels = v
	return s
}

// SetPrimaryYAxisDisplayOptions sets the PrimaryYAxisDisplayOptions field's value.
func (s *ComboChartConfiguration) SetPrimaryYAxisDisplayOptions(v *AxisDisplayOptions) *ComboChartConfiguration {
	s.PrimaryYAxisDisplayOptions = v
	return s
}

// SetPrimaryYAxisLabelOptions sets the PrimaryYAxisLabelOptions field's value.
func (s *ComboChartConfiguration) SetPrimaryYAxisLabelOptions(v *ChartAxisLabelOptions) *ComboChartConfiguration {
	s.PrimaryYAxisLabelOptions = v
	return s
}

// SetReferenceLines sets the ReferenceLines field's value.
func (s *ComboChartConfiguration) SetReferenceLines(v []*ReferenceLine) *ComboChartConfiguration {
	s.ReferenceLines = v
	return s
}

// SetSecondaryYAxisDisplayOptions sets the SecondaryYAxisDisplayOptions field's value.
func (s *ComboChartConfiguration) SetSecondaryYAxisDisplayOptions(v *AxisDisplayOptions) *ComboChartConfiguration {
	s.SecondaryYAxisDisplayOptions = v
	return s
}

// SetSecondaryYAxisLabelOptions sets the SecondaryYAxisLabelOptions field's value.
func (s *ComboChartConfiguration) SetSecondaryYAxisLabelOptions(v *ChartAxisLabelOptions) *ComboChartConfiguration {
	s.SecondaryYAxisLabelOptions = v
	return s
}

// SetSortConfiguration sets the SortConfiguration field's value.
func (s *ComboChartConfiguration) SetSortConfiguration(v *ComboChartSortConfiguration) *ComboChartConfiguration {
	s.SortConfiguration = v
	return s
}

// SetTooltip sets the Tooltip field's value.
func (s *ComboChartConfiguration) SetTooltip(v *TooltipOptions) *ComboChartConfiguration {
	s.Tooltip = v
	return s
}

// SetVisualPalette sets the VisualPalette field's value.
func (s *ComboChartConfiguration) SetVisualPalette(v *VisualPalette) *ComboChartConfiguration {
	s.VisualPalette = v
	return s
}

// The field wells of the visual.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type ComboChartFieldWells struct {
	_ struct{} `type:"structure"`

	// The aggregated field wells of a combo chart. Combo charts only have aggregated
	// field wells. Columns in a combo chart are aggregated by category.
	ComboChartAggregatedFieldWells *ComboChartAggregatedFieldWells `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComboChartFieldWells) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComboChartFieldWells) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComboChartFieldWells) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComboChartFieldWells"}
	if s.ComboChartAggregatedFieldWells != nil {
		if err := s.ComboChartAggregatedFieldWells.Validate(); err != nil {
			invalidParams.AddNested("ComboChartAggregatedFieldWells", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComboChartAggregatedFieldWells sets the ComboChartAggregatedFieldWells field's value.
func (s *ComboChartFieldWells) SetComboChartAggregatedFieldWells(v *ComboChartAggregatedFieldWells) *ComboChartFieldWells {
	s.ComboChartAggregatedFieldWells = v
	return s
}

// The sort configuration of a ComboChartVisual.
type ComboChartSortConfiguration struct {
	_ struct{} `type:"structure"`

	// The item limit configuration for the category field well of a combo chart.
	CategoryItemsLimit *ItemsLimitConfiguration `type:"structure"`

	// The sort configuration of the category field well in a combo chart.
	CategorySort []*FieldSortOptions `type:"list"`

	// The item limit configuration of the color field well in a combo chart.
	ColorItemsLimit *ItemsLimitConfiguration `type:"structure"`

	// The sort configuration of the color field well in a combo chart.
	ColorSort []*FieldSortOptions `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComboChartSortConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComboChartSortConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComboChartSortConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComboChartSortConfiguration"}
	if s.CategorySort != nil {
		for i, v := range s.CategorySort {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CategorySort", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ColorSort != nil {
		for i, v := range s.ColorSort {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColorSort", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryItemsLimit sets the CategoryItemsLimit field's value.
func (s *ComboChartSortConfiguration) SetCategoryItemsLimit(v *ItemsLimitConfiguration) *ComboChartSortConfiguration {
	s.CategoryItemsLimit = v
	return s
}

// SetCategorySort sets the CategorySort field's value.
func (s *ComboChartSortConfiguration) SetCategorySort(v []*FieldSortOptions) *ComboChartSortConfiguration {
	s.CategorySort = v
	return s
}

// SetColorItemsLimit sets the ColorItemsLimit field's value.
func (s *ComboChartSortConfiguration) SetColorItemsLimit(v *ItemsLimitConfiguration) *ComboChartSortConfiguration {
	s.ColorItemsLimit = v
	return s
}

// SetColorSort sets the ColorSort field's value.
func (s *ComboChartSortConfiguration) SetColorSort(v []*FieldSortOptions) *ComboChartSortConfiguration {
	s.ColorSort = v
	return s
}

// A combo chart.
//
// The ComboChartVisual includes stacked bar combo charts and clustered bar
// combo charts
//
// For more information, see Using combo charts (https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html)
// in the Amazon QuickSight User Guide.
type ComboChartVisual struct {
	_ struct{} `type:"structure"`

	// The list of custom actions that are configured for a visual.
	Actions []*VisualCustomAction `type:"list"`

	// The configuration settings of the visual.
	ChartConfiguration *ComboChartConfiguration `type:"structure"`

	// The column hierarchy that is used during drill-downs and drill-ups.
	ColumnHierarchies []*ColumnHierarchy `type:"list"`

	// The subtitle that is displayed on the visual.
	Subtitle *VisualSubtitleLabelOptions `type:"structure"`

	// The title that is displayed on the visual.
	Title *VisualTitleLabelOptions `type:"structure"`

	// The unique identifier of a visual. This identifier must be unique within
	// the context of a dashboard, template, or analysis. Two dashboards, analyses,
	// or templates can have visuals with the same identifiers.
	//
	// VisualId is a required field
	VisualId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComboChartVisual) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComboChartVisual) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComboChartVisual) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComboChartVisual"}
	if s.VisualId == nil {
		invalidParams.Add(request.NewErrParamRequired("VisualId"))
	}
	if s.VisualId != nil && len(*s.VisualId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VisualId", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ChartConfiguration != nil {
		if err := s.ChartConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChartConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ColumnHierarchies != nil {
		for i, v := range s.ColumnHierarchies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnHierarchies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Subtitle != nil {
		if err := s.Subtitle.Validate(); err != nil {
			invalidParams.AddNested("Subtitle", err.(request.ErrInvalidParams))
		}
	}
	if s.Title != nil {
		if err := s.Title.Validate(); err != nil {
			invalidParams.AddNested("Title", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *ComboChartVisual) SetActions(v []*VisualCustomAction) *ComboChartVisual {
	s.Actions = v
	return s
}

// SetChartConfiguration sets the ChartConfiguration field's value.
func (s *ComboChartVisual) SetChartConfiguration(v *ComboChartConfiguration) *ComboChartVisual {
	s.ChartConfiguration = v
	return s
}

// SetColumnHierarchies sets the ColumnHierarchies field's value.
func (s *ComboChartVisual) SetColumnHierarchies(v []*ColumnHierarchy) *ComboChartVisual {
	s.ColumnHierarchies = v
	return s
}

// SetSubtitle sets the Subtitle field's value.
func (s *ComboChartVisual) SetSubtitle(v *VisualSubtitleLabelOptions) *ComboChartVisual {
	s.Subtitle = v
	return s
}

// SetTitle sets the Title field's value.
func (s *ComboChartVisual) SetTitle(v *VisualTitleLabelOptions) *ComboChartVisual {
	s.Title = v
	return s
}

// SetVisualId sets the VisualId field's value.
func (s *ComboChartVisual) SetVisualId(v string) *ComboChartVisual {
	s.VisualId = &v
	return s
}

// The comparison display configuration of a KPI or gauge chart.
type ComparisonConfiguration struct {
	_ struct{} `type:"structure"`

	// The format of the comparison.
	ComparisonFormat *ComparisonFormatConfiguration `type:"structure"`

	// The method of the comparison. Choose from the following options:
	//
	//    * DIFFERENCE
	//
	//    * PERCENT_DIFFERENCE
	//
	//    * PERCENT
	ComparisonMethod *string `type:"string" enum:"ComparisonMethod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComparisonConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComparisonConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComparisonConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComparisonConfiguration"}
	if s.ComparisonFormat != nil {
		if err := s.ComparisonFormat.Validate(); err != nil {
			invalidParams.AddNested("ComparisonFormat", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonFormat sets the ComparisonFormat field's value.
func (s *ComparisonConfiguration) SetComparisonFormat(v *ComparisonFormatConfiguration) *ComparisonConfiguration {
	s.ComparisonFormat = v
	return s
}

// SetComparisonMethod sets the ComparisonMethod field's value.
func (s *ComparisonConfiguration) SetComparisonMethod(v string) *ComparisonConfiguration {
	s.ComparisonMethod = &v
	return s
}

// The format of the comparison.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type ComparisonFormatConfiguration struct {
	_ struct{} `type:"structure"`

	// The number display format.
	NumberDisplayFormatConfiguration *NumberDisplayFormatConfiguration `type:"structure"`

	// The percentage display format.
	PercentageDisplayFormatConfiguration *PercentageDisplayFormatConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComparisonFormatConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComparisonFormatConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComparisonFormatConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComparisonFormatConfiguration"}
	if s.NumberDisplayFormatConfiguration != nil {
		if err := s.NumberDisplayFormatConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NumberDisplayFormatConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PercentageDisplayFormatConfiguration != nil {
		if err := s.PercentageDisplayFormatConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PercentageDisplayFormatConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNumberDisplayFormatConfiguration sets the NumberDisplayFormatConfiguration field's value.
func (s *ComparisonFormatConfiguration) SetNumberDisplayFormatConfiguration(v *NumberDisplayFormatConfiguration) *ComparisonFormatConfiguration {
	s.NumberDisplayFormatConfiguration = v
	return s
}

// SetPercentageDisplayFormatConfiguration sets the PercentageDisplayFormatConfiguration field's value.
func (s *ComparisonFormatConfiguration) SetPercentageDisplayFormatConfiguration(v *PercentageDisplayFormatConfiguration) *ComparisonFormatConfiguration {
	s.PercentageDisplayFormatConfiguration = v
	return s
}

// The computation union that is used in an insight visual.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type Computation struct {
	_ struct{} `type:"structure"`

	// The forecast computation configuration.
	Forecast *ForecastComputation `type:"structure"`

	// The growth rate computation configuration.
	GrowthRate *GrowthRateComputation `type:"structure"`

	// The maximum and minimum computation configuration.
	MaximumMinimum *MaximumMinimumComputation `type:"structure"`

	// The metric comparison computation configuration.
	MetricComparison *MetricComparisonComputation `type:"structure"`

	// The period over period computation configuration.
	PeriodOverPeriod *PeriodOverPeriodComputation `type:"structure"`

	// The period to DataSetIdentifier computation configuration.
	PeriodToDate *PeriodToDateComputation `type:"structure"`

	// The top movers and bottom movers computation configuration.
	TopBottomMovers *TopBottomMoversComputation `type:"structure"`

	// The top ranked and bottom ranked computation configuration.
	TopBottomRanked *TopBottomRankedComputation `type:"structure"`

	// The total aggregation computation configuration.
	TotalAggregation *TotalAggregationComputation `type:"structure"`

	// The unique values computation configuration.
	UniqueValues *UniqueValuesComputation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Computation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Computation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Computation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Computation"}
	if s.Forecast != nil {
		if err := s.Forecast.Validate(); err != nil {
			invalidParams.AddNested("Forecast", err.(request.ErrInvalidParams))
		}
	}
	if s.GrowthRate != nil {
		if err := s.GrowthRate.Validate(); err != nil {
			invalidParams.AddNested("GrowthRate", err.(request.ErrInvalidParams))
		}
	}
	if s.MaximumMinimum != nil {
		if err := s.MaximumMinimum.Validate(); err != nil {
			invalidParams.AddNested("MaximumMinimum", err.(request.ErrInvalidParams))
		}
	}
	if s.MetricComparison != nil {
		if err := s.MetricComparison.Validate(); err != nil {
			invalidParams.AddNested("MetricComparison", err.(request.ErrInvalidParams))
		}
	}
	if s.PeriodOverPeriod != nil {
		if err := s.PeriodOverPeriod.Validate(); err != nil {
			invalidParams.AddNested("PeriodOverPeriod", err.(request.ErrInvalidParams))
		}
	}
	if s.PeriodToDate != nil {
		if err := s.PeriodToDate.Validate(); err != nil {
			invalidParams.AddNested("PeriodToDate", err.(request.ErrInvalidParams))
		}
	}
	if s.TopBottomMovers != nil {
		if err := s.TopBottomMovers.Validate(); err != nil {
			invalidParams.AddNested("TopBottomMovers", err.(request.ErrInvalidParams))
		}
	}
	if s.TopBottomRanked != nil {
		if err := s.TopBottomRanked.Validate(); err != nil {
			invalidParams.AddNested("TopBottomRanked", err.(request.ErrInvalidParams))
		}
	}
	if s.TotalAggregation != nil {
		if err := s.TotalAggregation.Validate(); err != nil {
			invalidParams.AddNested("TotalAggregation", err.(request.ErrInvalidParams))
		}
	}
	if s.UniqueValues != nil {
		if err := s.UniqueValues.Validate(); err != nil {
			invalidParams.AddNested("UniqueValues", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForecast sets the Forecast field's value.
func (s *Computation) SetForecast(v *ForecastComputation) *Computation {
	s.Forecast = v
	return s
}

// SetGrowthRate sets the GrowthRate field's value.
func (s *Computation) SetGrowthRate(v *GrowthRateComputation) *Computation {
	s.GrowthRate = v
	return s
}

// SetMaximumMinimum sets the MaximumMinimum field's value.
func (s *Computation) SetMaximumMinimum(v *MaximumMinimumComputation) *Computation {
	s.MaximumMinimum = v
	return s
}

// SetMetricComparison sets the MetricComparison field's value.
func (s *Computation) SetMetricComparison(v *MetricComparisonComputation) *Computation {
	s.MetricComparison = v
	return s
}

// SetPeriodOverPeriod sets the PeriodOverPeriod field's value.
func (s *Computation) SetPeriodOverPeriod(v *PeriodOverPeriodComputation) *Computation {
	s.PeriodOverPeriod = v
	return s
}

// SetPeriodToDate sets the PeriodToDate field's value.
func (s *Computation) SetPeriodToDate(v *PeriodToDateComputation) *Computation {
	s.PeriodToDate = v
	return s
}

// SetTopBottomMovers sets the TopBottomMovers field's value.
func (s *Computation) SetTopBottomMovers(v *TopBottomMoversComputation) *Computation {
	s.TopBottomMovers = v
	return s
}

// SetTopBottomRanked sets the TopBottomRanked field's value.
func (s *Computation) SetTopBottomRanked(v *TopBottomRankedComputation) *Computation {
	s.TopBottomRanked = v
	return s
}

// SetTotalAggregation sets the TotalAggregation field's value.
func (s *Computation) SetTotalAggregation(v *TotalAggregationComputation) *Computation {
	s.TotalAggregation = v
	return s
}

// SetUniqueValues sets the UniqueValues field's value.
func (s *Computation) SetUniqueValues(v *UniqueValuesComputation) *Computation {
	s.UniqueValues = v
	return s
}

// A resource is already in a state that indicates an operation is happening
// that must complete before a new update can be applied.
type ConcurrentUpdatingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentUpdatingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentUpdatingException) GoString() string {
	return s.String()
}

func newErrorConcurrentUpdatingException(v protocol.ResponseMetadata) error {
	return &ConcurrentUpdatingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentUpdatingException) Code() string {
	return "ConcurrentUpdatingException"
}

// Message returns the exception's message.
func (s *ConcurrentUpdatingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentUpdatingException) OrigErr() error {
	return nil
}

func (s *ConcurrentUpdatingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentUpdatingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentUpdatingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The formatting configuration for the color.
type ConditionalFormattingColor struct {
	_ struct{} `type:"structure"`

	// Formatting configuration for gradient color.
	Gradient *ConditionalFormattingGradientColor `type:"structure"`

	// Formatting configuration for solid color.
	Solid *ConditionalFormattingSolidColor `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingColor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingColor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalFormattingColor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionalFormattingColor"}
	if s.Gradient != nil {
		if err := s.Gradient.Validate(); err != nil {
			invalidParams.AddNested("Gradient", err.(request.ErrInvalidParams))
		}
	}
	if s.Solid != nil {
		if err := s.Solid.Validate(); err != nil {
			invalidParams.AddNested("Solid", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGradient sets the Gradient field's value.
func (s *ConditionalFormattingColor) SetGradient(v *ConditionalFormattingGradientColor) *ConditionalFormattingColor {
	s.Gradient = v
	return s
}

// SetSolid sets the Solid field's value.
func (s *ConditionalFormattingColor) SetSolid(v *ConditionalFormattingSolidColor) *ConditionalFormattingColor {
	s.Solid = v
	return s
}

// Determines the custom condition for an icon set.
type ConditionalFormattingCustomIconCondition struct {
	_ struct{} `type:"structure"`

	// Determines the color of the icon.
	Color *string `type:"string"`

	// Determines the icon display configuration.
	DisplayConfiguration *ConditionalFormattingIconDisplayConfiguration `type:"structure"`

	// The expression that determines the condition of the icon set.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConditionalFormattingCustomIconCondition's
	// String and GoString methods.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Custom icon options for an icon set.
	//
	// IconOptions is a required field
	IconOptions *ConditionalFormattingCustomIconOptions `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingCustomIconCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingCustomIconCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalFormattingCustomIconCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionalFormattingCustomIconCondition"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.IconOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("IconOptions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColor sets the Color field's value.
func (s *ConditionalFormattingCustomIconCondition) SetColor(v string) *ConditionalFormattingCustomIconCondition {
	s.Color = &v
	return s
}

// SetDisplayConfiguration sets the DisplayConfiguration field's value.
func (s *ConditionalFormattingCustomIconCondition) SetDisplayConfiguration(v *ConditionalFormattingIconDisplayConfiguration) *ConditionalFormattingCustomIconCondition {
	s.DisplayConfiguration = v
	return s
}

// SetExpression sets the Expression field's value.
func (s *ConditionalFormattingCustomIconCondition) SetExpression(v string) *ConditionalFormattingCustomIconCondition {
	s.Expression = &v
	return s
}

// SetIconOptions sets the IconOptions field's value.
func (s *ConditionalFormattingCustomIconCondition) SetIconOptions(v *ConditionalFormattingCustomIconOptions) *ConditionalFormattingCustomIconCondition {
	s.IconOptions = v
	return s
}

// Custom icon options for an icon set.
type ConditionalFormattingCustomIconOptions struct {
	_ struct{} `type:"structure"`

	// Determines the type of icon.
	Icon *string `type:"string" enum:"Icon"`

	// Determines the Unicode icon type.
	UnicodeIcon *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingCustomIconOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingCustomIconOptions) GoString() string {
	return s.String()
}

// SetIcon sets the Icon field's value.
func (s *ConditionalFormattingCustomIconOptions) SetIcon(v string) *ConditionalFormattingCustomIconOptions {
	s.Icon = &v
	return s
}

// SetUnicodeIcon sets the UnicodeIcon field's value.
func (s *ConditionalFormattingCustomIconOptions) SetUnicodeIcon(v string) *ConditionalFormattingCustomIconOptions {
	s.UnicodeIcon = &v
	return s
}

// Formatting configuration for gradient color.
type ConditionalFormattingGradientColor struct {
	_ struct{} `type:"structure"`

	// Determines the color.
	//
	// Color is a required field
	Color *GradientColor `type:"structure" required:"true"`

	// The expression that determines the formatting configuration for gradient
	// color.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConditionalFormattingGradientColor's
	// String and GoString methods.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingGradientColor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingGradientColor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalFormattingGradientColor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionalFormattingGradientColor"}
	if s.Color == nil {
		invalidParams.Add(request.NewErrParamRequired("Color"))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Color != nil {
		if err := s.Color.Validate(); err != nil {
			invalidParams.AddNested("Color", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColor sets the Color field's value.
func (s *ConditionalFormattingGradientColor) SetColor(v *GradientColor) *ConditionalFormattingGradientColor {
	s.Color = v
	return s
}

// SetExpression sets the Expression field's value.
func (s *ConditionalFormattingGradientColor) SetExpression(v string) *ConditionalFormattingGradientColor {
	s.Expression = &v
	return s
}

// The formatting configuration for the icon.
type ConditionalFormattingIcon struct {
	_ struct{} `type:"structure"`

	// Determines the custom condition for an icon set.
	CustomCondition *ConditionalFormattingCustomIconCondition `type:"structure"`

	// Formatting configuration for icon set.
	IconSet *ConditionalFormattingIconSet `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingIcon) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingIcon) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalFormattingIcon) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionalFormattingIcon"}
	if s.CustomCondition != nil {
		if err := s.CustomCondition.Validate(); err != nil {
			invalidParams.AddNested("CustomCondition", err.(request.ErrInvalidParams))
		}
	}
	if s.IconSet != nil {
		if err := s.IconSet.Validate(); err != nil {
			invalidParams.AddNested("IconSet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomCondition sets the CustomCondition field's value.
func (s *ConditionalFormattingIcon) SetCustomCondition(v *ConditionalFormattingCustomIconCondition) *ConditionalFormattingIcon {
	s.CustomCondition = v
	return s
}

// SetIconSet sets the IconSet field's value.
func (s *ConditionalFormattingIcon) SetIconSet(v *ConditionalFormattingIconSet) *ConditionalFormattingIcon {
	s.IconSet = v
	return s
}

// Determines the icon display configuration.
type ConditionalFormattingIconDisplayConfiguration struct {
	_ struct{} `type:"structure"`

	// Determines the icon display configuration.
	IconDisplayOption *string `type:"string" enum:"ConditionalFormattingIconDisplayOption"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingIconDisplayConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingIconDisplayConfiguration) GoString() string {
	return s.String()
}

// SetIconDisplayOption sets the IconDisplayOption field's value.
func (s *ConditionalFormattingIconDisplayConfiguration) SetIconDisplayOption(v string) *ConditionalFormattingIconDisplayConfiguration {
	s.IconDisplayOption = &v
	return s
}

// Formatting configuration for icon set.
type ConditionalFormattingIconSet struct {
	_ struct{} `type:"structure"`

	// The expression that determines the formatting configuration for the icon
	// set.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConditionalFormattingIconSet's
	// String and GoString methods.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Determines the icon set type.
	IconSetType *string `type:"string" enum:"ConditionalFormattingIconSetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingIconSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingIconSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalFormattingIconSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionalFormattingIconSet"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *ConditionalFormattingIconSet) SetExpression(v string) *ConditionalFormattingIconSet {
	s.Expression = &v
	return s
}

// SetIconSetType sets the IconSetType field's value.
func (s *ConditionalFormattingIconSet) SetIconSetType(v string) *ConditionalFormattingIconSet {
	s.IconSetType = &v
	return s
}

// Formatting configuration for solid color.
type ConditionalFormattingSolidColor struct {
	_ struct{} `type:"structure"`

	// Determines the color.
	Color *string `type:"string"`

	// The expression that determines the formatting configuration for solid color.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConditionalFormattingSolidColor's
	// String and GoString methods.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingSolidColor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalFormattingSolidColor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalFormattingSolidColor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionalFormattingSolidColor"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColor sets the Color field's value.
func (s *ConditionalFormattingSolidColor) SetColor(v string) *ConditionalFormattingSolidColor {
	s.Color = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *ConditionalFormattingSolidColor) SetExpression(v string) *ConditionalFormattingSolidColor {
	s.Expression = &v
	return s
}

// Updating or deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The Amazon Web Services request ID for this request.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The contribution analysis visual display for a line, pie, or bar chart.
type ContributionAnalysisDefault struct {
	_ struct{} `type:"structure"`

	// The dimensions columns that are used in the contribution analysis, usually
	// a list of ColumnIdentifiers.
	//
	// ContributorDimensions is a required field
	ContributorDimensions []*ColumnIdentifier `min:"1" type:"list" required:"true"`

	// The measure field that is used in the contribution analysis.
	//
	// MeasureFieldId is a required field
	MeasureFieldId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContributionAnalysisDefault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContributionAnalysisDefault) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContributionAnalysisDefault) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContributionAnalysisDefault"}
	if s.ContributorDimensions == nil {
		invalidParams.Add(request.NewErrParamRequired("ContributorDimensions"))
	}
	if s.ContributorDimensions != nil && len(s.ContributorDimensions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContributorDimensions", 1))
	}
	if s.MeasureFieldId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeasureFieldId"))
	}
	if s.MeasureFieldId != nil && len(*s.MeasureFieldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeasureFieldId", 1))
	}
	if s.ContributorDimensions != nil {
		for i, v := range s.ContributorDimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContributorDimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContributorDimensions sets the ContributorDimensions field's value.
func (s *ContributionAnalysisDefault) SetContributorDimensions(v []*ColumnIdentifier) *ContributionAnalysisDefault {
	s.ContributorDimensions = v
	return s
}

// SetMeasureFieldId sets the MeasureFieldId field's value.
func (s *ContributionAnalysisDefault) SetMeasureFieldId(v string) *ContributionAnalysisDefault {
	s.MeasureFieldId = &v
	return s
}

type CreateAccountCustomizationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon QuickSight customizations you're adding in the current Amazon
	// Web Services Region. You can add these to an Amazon Web Services account
	// and a QuickSight namespace.
	//
	// For example, you can add a default theme by setting AccountCustomization
	// to the midnight theme: "AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT"
	// }. Or, you can add a custom theme by specifying "AccountCustomization": {
	// "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639"
	// }.
	//
	// AccountCustomization is a required field
	AccountCustomization *AccountCustomization `type:"structure" required:"true"`

	// The ID for the Amazon Web Services account that you want to customize Amazon
	// QuickSight for.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The Amazon QuickSight namespace that you want to add customizations to.
	Namespace *string `location:"querystring" locationName:"namespace" type:"string"`

	// A list of the tags that you want to attach to this resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountCustomizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountCustomizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountCustomizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccountCustomizationInput"}
	if s.AccountCustomization == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountCustomization"))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountCustomization sets the AccountCustomization field's value.
func (s *CreateAccountCustomizationInput) SetAccountCustomization(v *AccountCustomization) *CreateAccountCustomizationInput {
	s.AccountCustomization = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateAccountCustomizationInput) SetAwsAccountId(v string) *CreateAccountCustomizationInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateAccountCustomizationInput) SetNamespace(v string) *CreateAccountCustomizationInput {
	s.Namespace = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccountCustomizationInput) SetTags(v []*Tag) *CreateAccountCustomizationInput {
	s.Tags = v
	return s
}

type CreateAccountCustomizationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon QuickSight customizations you're adding in the current Amazon
	// Web Services Region.
	AccountCustomization *AccountCustomization `type:"structure"`

	// The Amazon Resource Name (ARN) for the customization that you created for
	// this Amazon Web Services account.
	Arn *string `type:"string"`

	// The ID for the Amazon Web Services account that you want to customize Amazon
	// QuickSight for.
	AwsAccountId *string `min:"12" type:"string"`

	// The namespace associated with the customization you're creating.
	Namespace *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountCustomizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountCustomizationOutput) GoString() string {
	return s.String()
}

// SetAccountCustomization sets the AccountCustomization field's value.
func (s *CreateAccountCustomizationOutput) SetAccountCustomization(v *AccountCustomization) *CreateAccountCustomizationOutput {
	s.AccountCustomization = v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateAccountCustomizationOutput) SetArn(v string) *CreateAccountCustomizationOutput {
	s.Arn = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateAccountCustomizationOutput) SetAwsAccountId(v string) *CreateAccountCustomizationOutput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateAccountCustomizationOutput) SetNamespace(v string) *CreateAccountCustomizationOutput {
	s.Namespace = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateAccountCustomizationOutput) SetRequestId(v string) *CreateAccountCustomizationOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateAccountCustomizationOutput) SetStatus(v int64) *CreateAccountCustomizationOutput {
	s.Status = &v
	return s
}

type CreateAccountSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of your Amazon QuickSight account. This name is unique over all
	// of Amazon Web Services, and it appears only when users sign in. You can't
	// change AccountName value after the Amazon QuickSight account is created.
	//
	// AccountName is a required field
	AccountName *string `type:"string" required:"true"`

	// The name of your Active Directory. This field is required if ACTIVE_DIRECTORY
	// is the selected authentication method of the new Amazon QuickSight account.
	ActiveDirectoryName *string `type:"string"`

	// The admin group associated with your Active Directory. This field is required
	// if ACTIVE_DIRECTORY is the selected authentication method of the new Amazon
	// QuickSight account. For more information about using Active Directory in
	// Amazon QuickSight, see Using Active Directory with Amazon QuickSight Enterprise
	// Edition (https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html)
	// in the Amazon QuickSight User Guide.
	AdminGroup []*string `type:"list"`

	// The method that you want to use to authenticate your Amazon QuickSight account.
	// Currently, the valid values for this parameter are IAM_AND_QUICKSIGHT, IAM_ONLY,
	// and ACTIVE_DIRECTORY.
	//
	// If you choose ACTIVE_DIRECTORY, provide an ActiveDirectoryName and an AdminGroup
	// associated with your Active Directory.
	//
	// AuthenticationMethod is a required field
	AuthenticationMethod *string `type:"string" required:"true" enum:"AuthenticationMethodOption"`

	// The author group associated with your Active Directory. For more information
	// about using Active Directory in Amazon QuickSight, see Using Active Directory
	// with Amazon QuickSight Enterprise Edition (https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html)
	// in the Amazon QuickSight User Guide.
	AuthorGroup []*string `type:"list"`

	// The Amazon Web Services account ID of the account that you're using to create
	// your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// A 10-digit phone number for the author of the Amazon QuickSight account to
	// use for future communications. This field is required if ENTERPPRISE_AND_Q
	// is the selected edition of the new Amazon QuickSight account.
	ContactNumber *string `type:"string"`

	// The ID of the Active Directory that is associated with your Amazon QuickSight
	// account.
	DirectoryId *string `type:"string"`

	// The edition of Amazon QuickSight that you want your account to have. Currently,
	// you can choose from ENTERPRISE or ENTERPRISE_AND_Q.
	//
	// If you choose ENTERPRISE_AND_Q, the following parameters are required:
	//
	//    * FirstName
	//
	//    * LastName
	//
	//    * EmailAddress
	//
	//    * ContactNumber
	//
	// Edition is a required field
	Edition *string `type:"string" required:"true" enum:"Edition"`

	// The email address of the author of the Amazon QuickSight account to use for
	// future communications. This field is required if ENTERPPRISE_AND_Q is the
	// selected edition of the new Amazon QuickSight account.
	EmailAddress *string `type:"string"`

	// The first name of the author of the Amazon QuickSight account to use for
	// future communications. This field is required if ENTERPPRISE_AND_Q is the
	// selected edition of the new Amazon QuickSight account.
	FirstName *string `type:"string"`

	// The last name of the author of the Amazon QuickSight account to use for future
	// communications. This field is required if ENTERPPRISE_AND_Q is the selected
	// edition of the new Amazon QuickSight account.
	LastName *string `type:"string"`

	// The email address that you want Amazon QuickSight to send notifications to
	// regarding your Amazon QuickSight account or Amazon QuickSight subscription.
	//
	// NotificationEmail is a required field
	NotificationEmail *string `type:"string" required:"true"`

	// The reader group associated with your Active Direcrtory. For more information
	// about using Active Directory in Amazon QuickSight, see Using Active Directory
	// with Amazon QuickSight Enterprise Edition (https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html)
	// in the Amazon QuickSight User Guide.
	ReaderGroup []*string `type:"list"`

	// The realm of the Active Directory that is associated with your Amazon QuickSight
	// account. This field is required if ACTIVE_DIRECTORY is the selected authentication
	// method of the new Amazon QuickSight account.
	Realm *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccountSubscriptionInput"}
	if s.AccountName == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountName"))
	}
	if s.AuthenticationMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationMethod"))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Edition == nil {
		invalidParams.Add(request.NewErrParamRequired("Edition"))
	}
	if s.NotificationEmail == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationEmail"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountName sets the AccountName field's value.
func (s *CreateAccountSubscriptionInput) SetAccountName(v string) *CreateAccountSubscriptionInput {
	s.AccountName = &v
	return s
}

// SetActiveDirectoryName sets the ActiveDirectoryName field's value.
func (s *CreateAccountSubscriptionInput) SetActiveDirectoryName(v string) *CreateAccountSubscriptionInput {
	s.ActiveDirectoryName = &v
	return s
}

// SetAdminGroup sets the AdminGroup field's value.
func (s *CreateAccountSubscriptionInput) SetAdminGroup(v []*string) *CreateAccountSubscriptionInput {
	s.AdminGroup = v
	return s
}

// SetAuthenticationMethod sets the AuthenticationMethod field's value.
func (s *CreateAccountSubscriptionInput) SetAuthenticationMethod(v string) *CreateAccountSubscriptionInput {
	s.AuthenticationMethod = &v
	return s
}

// SetAuthorGroup sets the AuthorGroup field's value.
func (s *CreateAccountSubscriptionInput) SetAuthorGroup(v []*string) *CreateAccountSubscriptionInput {
	s.AuthorGroup = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateAccountSubscriptionInput) SetAwsAccountId(v string) *CreateAccountSubscriptionInput {
	s.AwsAccountId = &v
	return s
}

// SetContactNumber sets the ContactNumber field's value.
func (s *CreateAccountSubscriptionInput) SetContactNumber(v string) *CreateAccountSubscriptionInput {
	s.ContactNumber = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateAccountSubscriptionInput) SetDirectoryId(v string) *CreateAccountSubscriptionInput {
	s.DirectoryId = &v
	return s
}

// SetEdition sets the Edition field's value.
func (s *CreateAccountSubscriptionInput) SetEdition(v string) *CreateAccountSubscriptionInput {
	s.Edition = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *CreateAccountSubscriptionInput) SetEmailAddress(v string) *CreateAccountSubscriptionInput {
	s.EmailAddress = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *CreateAccountSubscriptionInput) SetFirstName(v string) *CreateAccountSubscriptionInput {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *CreateAccountSubscriptionInput) SetLastName(v string) *CreateAccountSubscriptionInput {
	s.LastName = &v
	return s
}

// SetNotificationEmail sets the NotificationEmail field's value.
func (s *CreateAccountSubscriptionInput) SetNotificationEmail(v string) *CreateAccountSubscriptionInput {
	s.NotificationEmail = &v
	return s
}

// SetReaderGroup sets the ReaderGroup field's value.
func (s *CreateAccountSubscriptionInput) SetReaderGroup(v []*string) *CreateAccountSubscriptionInput {
	s.ReaderGroup = v
	return s
}

// SetRealm sets the Realm field's value.
func (s *CreateAccountSubscriptionInput) SetRealm(v string) *CreateAccountSubscriptionInput {
	s.Realm = &v
	return s
}

type CreateAccountSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// A SignupResponse object that returns information about a newly created Amazon
	// QuickSight account.
	SignupResponse *SignupResponse `type:"structure"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountSubscriptionOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *CreateAccountSubscriptionOutput) SetRequestId(v string) *CreateAccountSubscriptionOutput {
	s.RequestId = &v
	return s
}

// SetSignupResponse sets the SignupResponse field's value.
func (s *CreateAccountSubscriptionOutput) SetSignupResponse(v *SignupResponse) *CreateAccountSubscriptionOutput {
	s.SignupResponse = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateAccountSubscriptionOutput) SetStatus(v int64) *CreateAccountSubscriptionOutput {
	s.Status = &v
	return s
}

type CreateAnalysisInput struct {
	_ struct{} `type:"structure"`

	// The ID for the analysis that you're creating. This ID displays in the URL
	// of the analysis.
	//
	// AnalysisId is a required field
	AnalysisId *string `location:"uri" locationName:"AnalysisId" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account where you are creating an analysis.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The definition of an analysis.
	//
	// A definition is the data model of all features in a Dashboard, Template,
	// or Analysis.
	//
	// Either a SourceEntity or a Definition must be provided in order for the request
	// to be valid.
	Definition *AnalysisDefinition `type:"structure"`

	// A descriptive name for the analysis that you're creating. This name displays
	// for the analysis in the Amazon QuickSight console.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The parameter names and override values that you want to use. An analysis
	// can have any parameter type, and some parameters might accept multiple values.
	Parameters *Parameters `type:"structure"`

	// A structure that describes the principals and the resource-level permissions
	// on an analysis. You can use the Permissions structure to grant permissions
	// by providing a list of Identity and Access Management (IAM) action information
	// for each principal listed by Amazon Resource Name (ARN).
	//
	// To specify no permissions, omit Permissions.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// A source entity to use for the analysis that you're creating. This metadata
	// structure contains details that describe a source template and one or more
	// datasets.
	//
	// Either a SourceEntity or a Definition must be provided in order for the request
	// to be valid.
	SourceEntity *AnalysisSourceEntity `type:"structure"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the analysis.
	Tags []*Tag `min:"1" type:"list"`

	// The ARN for the theme to apply to the analysis that you're creating. To see
	// the theme in the Amazon QuickSight console, make sure that you have access
	// to it.
	ThemeArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnalysisInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnalysisInput"}
	if s.AnalysisId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisId"))
	}
	if s.AnalysisId != nil && len(*s.AnalysisId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisId", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *CreateAnalysisInput) SetAnalysisId(v string) *CreateAnalysisInput {
	s.AnalysisId = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateAnalysisInput) SetAwsAccountId(v string) *CreateAnalysisInput {
	s.AwsAccountId = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreateAnalysisInput) SetDefinition(v *AnalysisDefinition) *CreateAnalysisInput {
	s.Definition = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAnalysisInput) SetName(v string) *CreateAnalysisInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateAnalysisInput) SetParameters(v *Parameters) *CreateAnalysisInput {
	s.Parameters = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateAnalysisInput) SetPermissions(v []*ResourcePermission) *CreateAnalysisInput {
	s.Permissions = v
	return s
}

// SetSourceEntity sets the SourceEntity field's value.
func (s *CreateAnalysisInput) SetSourceEntity(v *AnalysisSourceEntity) *CreateAnalysisInput {
	s.SourceEntity = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAnalysisInput) SetTags(v []*Tag) *CreateAnalysisInput {
	s.Tags = v
	return s
}

// SetThemeArn sets the ThemeArn field's value.
func (s *CreateAnalysisInput) SetThemeArn(v string) *CreateAnalysisInput {
	s.ThemeArn = &v
	return s
}

type CreateAnalysisOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the analysis.
	AnalysisId *string `min:"1" type:"string"`

	// The ARN for the analysis.
	Arn *string `type:"string"`

	// The status of the creation of the analysis.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisOutput) GoString() string {
	return s.String()
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *CreateAnalysisOutput) SetAnalysisId(v string) *CreateAnalysisOutput {
	s.AnalysisId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateAnalysisOutput) SetArn(v string) *CreateAnalysisOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateAnalysisOutput) SetCreationStatus(v string) *CreateAnalysisOutput {
	s.CreationStatus = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateAnalysisOutput) SetRequestId(v string) *CreateAnalysisOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateAnalysisOutput) SetStatus(v int64) *CreateAnalysisOutput {
	s.Status = &v
	return s
}

// A transform operation that creates calculated columns. Columns created in
// one such operation form a lexical closure.
type CreateColumnsOperation struct {
	_ struct{} `type:"structure"`

	// Calculated columns to create.
	//
	// Columns is a required field
	Columns []*CalculatedColumn `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateColumnsOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateColumnsOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateColumnsOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateColumnsOperation"}
	if s.Columns == nil {
		invalidParams.Add(request.NewErrParamRequired("Columns"))
	}
	if s.Columns != nil && len(s.Columns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Columns", 1))
	}
	if s.Columns != nil {
		for i, v := range s.Columns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Columns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumns sets the Columns field's value.
func (s *CreateColumnsOperation) SetColumns(v []*CalculatedColumn) *CreateColumnsOperation {
	s.Columns = v
	return s
}

type CreateDashboardInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account where you want to create the dashboard.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard, also added to the IAM policy.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// Options for publishing the dashboard when you create it:
	//
	//    * AvailabilityStatus for AdHocFilteringOption - This status can be either
	//    ENABLED or DISABLED. When this is set to DISABLED, Amazon QuickSight disables
	//    the left filter pane on the published dashboard, which can be used for
	//    ad hoc (one-time) filtering. This option is ENABLED by default.
	//
	//    * AvailabilityStatus for ExportToCSVOption - This status can be either
	//    ENABLED or DISABLED. The visual option to export data to .CSV format isn't
	//    enabled when this is set to DISABLED. This option is ENABLED by default.
	//
	//    * VisibilityState for SheetControlsOption - This visibility state can
	//    be either COLLAPSED or EXPANDED. This option is COLLAPSED by default.
	DashboardPublishOptions *DashboardPublishOptions `type:"structure"`

	// The definition of a dashboard.
	//
	// A definition is the data model of all features in a Dashboard, Template,
	// or Analysis.
	//
	// Either a SourceEntity or a Definition must be provided in order for the request
	// to be valid.
	Definition *DashboardVersionDefinition `type:"structure"`

	// The display name of the dashboard.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The parameters for the creation of the dashboard, which you want to use to
	// override the default settings. A dashboard can have any type of parameters,
	// and some parameters might accept multiple values.
	Parameters *Parameters `type:"structure"`

	// A structure that contains the permissions of the dashboard. You can use this
	// structure for granting permissions by providing a list of IAM action information
	// for each principal ARN.
	//
	// To specify no permissions, omit the permissions list.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The entity that you are using as a source when you create the dashboard.
	// In SourceEntity, you specify the type of object you're using as source. You
	// can only create a dashboard from a template, so you use a SourceTemplate
	// entity. If you need to create a dashboard from an analysis, first convert
	// the analysis to a template by using the CreateTemplate (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html)
	// API operation. For SourceTemplate, specify the Amazon Resource Name (ARN)
	// of the source template. The SourceTemplateARN can contain any Amazon Web
	// Services account and any Amazon QuickSight-supported Amazon Web Services
	// Region.
	//
	// Use the DataSetReferences entity within SourceTemplate to list the replacement
	// datasets for the placeholders listed in the original. The schema in each
	// dataset must match its placeholder.
	//
	// Either a SourceEntity or a Definition must be provided in order for the request
	// to be valid.
	SourceEntity *DashboardSourceEntity `type:"structure"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the dashboard.
	Tags []*Tag `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the theme that is being used for this dashboard.
	// If you add a value for this field, it overrides the value that is used in
	// the source entity. The theme ARN must exist in the same Amazon Web Services
	// account where you create the dashboard.
	ThemeArn *string `type:"string"`

	// A description for the first version of the dashboard being created.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDashboardInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateDashboardInput) SetAwsAccountId(v string) *CreateDashboardInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *CreateDashboardInput) SetDashboardId(v string) *CreateDashboardInput {
	s.DashboardId = &v
	return s
}

// SetDashboardPublishOptions sets the DashboardPublishOptions field's value.
func (s *CreateDashboardInput) SetDashboardPublishOptions(v *DashboardPublishOptions) *CreateDashboardInput {
	s.DashboardPublishOptions = v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreateDashboardInput) SetDefinition(v *DashboardVersionDefinition) *CreateDashboardInput {
	s.Definition = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDashboardInput) SetName(v string) *CreateDashboardInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateDashboardInput) SetParameters(v *Parameters) *CreateDashboardInput {
	s.Parameters = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateDashboardInput) SetPermissions(v []*ResourcePermission) *CreateDashboardInput {
	s.Permissions = v
	return s
}

// SetSourceEntity sets the SourceEntity field's value.
func (s *CreateDashboardInput) SetSourceEntity(v *DashboardSourceEntity) *CreateDashboardInput {
	s.SourceEntity = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDashboardInput) SetTags(v []*Tag) *CreateDashboardInput {
	s.Tags = v
	return s
}

// SetThemeArn sets the ThemeArn field's value.
func (s *CreateDashboardInput) SetThemeArn(v string) *CreateDashboardInput {
	s.ThemeArn = &v
	return s
}

// SetVersionDescription sets the VersionDescription field's value.
func (s *CreateDashboardInput) SetVersionDescription(v string) *CreateDashboardInput {
	s.VersionDescription = &v
	return s
}

type CreateDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dashboard.
	Arn *string `type:"string"`

	// The status of the dashboard creation request.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The ID for the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ARN of the dashboard, including the version number of the first version
	// that is created.
	VersionArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDashboardOutput) SetArn(v string) *CreateDashboardOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateDashboardOutput) SetCreationStatus(v string) *CreateDashboardOutput {
	s.CreationStatus = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *CreateDashboardOutput) SetDashboardId(v string) *CreateDashboardOutput {
	s.DashboardId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateDashboardOutput) SetRequestId(v string) *CreateDashboardOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDashboardOutput) SetStatus(v int64) *CreateDashboardOutput {
	s.Status = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *CreateDashboardOutput) SetVersionArn(v string) *CreateDashboardOutput {
	s.VersionArn = &v
	return s
}

type CreateDataSetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// Groupings of columns that work together in certain Amazon QuickSight features.
	// Currently, only geospatial hierarchy is supported.
	ColumnGroups []*ColumnGroup `min:"1" type:"list"`

	// A set of one or more definitions of a ColumnLevelPermissionRule (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html) .
	ColumnLevelPermissionRules []*ColumnLevelPermissionRule `min:"1" type:"list"`

	// An ID for the dataset that you want to create. This ID is unique per Amazon
	// Web Services Region for each Amazon Web Services account.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The usage configuration to apply to child datasets that reference this dataset
	// as a source.
	DataSetUsageConfiguration *DataSetUsageConfiguration `type:"structure"`

	// The folder that contains fields and nested subfolders for your dataset.
	FieldFolders map[string]*FieldFolder `type:"map"`

	// Indicates whether you want to import the data into SPICE.
	//
	// ImportMode is a required field
	ImportMode *string `type:"string" required:"true" enum:"DataSetImportMode"`

	// Configures the combination and transformation of the data from the physical
	// tables.
	LogicalTableMap map[string]*LogicalTable `min:"1" type:"map"`

	// The display name for the dataset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of resource permissions on the dataset.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// Declares the physical tables that are available in the underlying data sources.
	//
	// PhysicalTableMap is a required field
	PhysicalTableMap map[string]*PhysicalTable `type:"map" required:"true"`

	// The row-level security configuration for the data that you want to create.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet `type:"structure"`

	// The configuration of tags on a dataset to set row-level security. Row-level
	// security tags are currently supported for anonymous embedding only.
	RowLevelPermissionTagConfiguration *RowLevelPermissionTagConfiguration `type:"structure"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the dataset.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSetInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ColumnGroups != nil && len(s.ColumnGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnGroups", 1))
	}
	if s.ColumnLevelPermissionRules != nil && len(s.ColumnLevelPermissionRules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnLevelPermissionRules", 1))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.ImportMode == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportMode"))
	}
	if s.LogicalTableMap != nil && len(s.LogicalTableMap) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogicalTableMap", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.PhysicalTableMap == nil {
		invalidParams.Add(request.NewErrParamRequired("PhysicalTableMap"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ColumnGroups != nil {
		for i, v := range s.ColumnGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ColumnLevelPermissionRules != nil {
		for i, v := range s.ColumnLevelPermissionRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnLevelPermissionRules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LogicalTableMap != nil {
		for i, v := range s.LogicalTableMap {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogicalTableMap", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PhysicalTableMap != nil {
		for i, v := range s.PhysicalTableMap {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PhysicalTableMap", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RowLevelPermissionDataSet != nil {
		if err := s.RowLevelPermissionDataSet.Validate(); err != nil {
			invalidParams.AddNested("RowLevelPermissionDataSet", err.(request.ErrInvalidParams))
		}
	}
	if s.RowLevelPermissionTagConfiguration != nil {
		if err := s.RowLevelPermissionTagConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RowLevelPermissionTagConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateDataSetInput) SetAwsAccountId(v string) *CreateDataSetInput {
	s.AwsAccountId = &v
	return s
}

// SetColumnGroups sets the ColumnGroups field's value.
func (s *CreateDataSetInput) SetColumnGroups(v []*ColumnGroup) *CreateDataSetInput {
	s.ColumnGroups = v
	return s
}

// SetColumnLevelPermissionRules sets the ColumnLevelPermissionRules field's value.
func (s *CreateDataSetInput) SetColumnLevelPermissionRules(v []*ColumnLevelPermissionRule) *CreateDataSetInput {
	s.ColumnLevelPermissionRules = v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateDataSetInput) SetDataSetId(v string) *CreateDataSetInput {
	s.DataSetId = &v
	return s
}

// SetDataSetUsageConfiguration sets the DataSetUsageConfiguration field's value.
func (s *CreateDataSetInput) SetDataSetUsageConfiguration(v *DataSetUsageConfiguration) *CreateDataSetInput {
	s.DataSetUsageConfiguration = v
	return s
}

// SetFieldFolders sets the FieldFolders field's value.
func (s *CreateDataSetInput) SetFieldFolders(v map[string]*FieldFolder) *CreateDataSetInput {
	s.FieldFolders = v
	return s
}

// SetImportMode sets the ImportMode field's value.
func (s *CreateDataSetInput) SetImportMode(v string) *CreateDataSetInput {
	s.ImportMode = &v
	return s
}

// SetLogicalTableMap sets the LogicalTableMap field's value.
func (s *CreateDataSetInput) SetLogicalTableMap(v map[string]*LogicalTable) *CreateDataSetInput {
	s.LogicalTableMap = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSetInput) SetName(v string) *CreateDataSetInput {
	s.Name = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateDataSetInput) SetPermissions(v []*ResourcePermission) *CreateDataSetInput {
	s.Permissions = v
	return s
}

// SetPhysicalTableMap sets the PhysicalTableMap field's value.
func (s *CreateDataSetInput) SetPhysicalTableMap(v map[string]*PhysicalTable) *CreateDataSetInput {
	s.PhysicalTableMap = v
	return s
}

// SetRowLevelPermissionDataSet sets the RowLevelPermissionDataSet field's value.
func (s *CreateDataSetInput) SetRowLevelPermissionDataSet(v *RowLevelPermissionDataSet) *CreateDataSetInput {
	s.RowLevelPermissionDataSet = v
	return s
}

// SetRowLevelPermissionTagConfiguration sets the RowLevelPermissionTagConfiguration field's value.
func (s *CreateDataSetInput) SetRowLevelPermissionTagConfiguration(v *RowLevelPermissionTagConfiguration) *CreateDataSetInput {
	s.RowLevelPermissionTagConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataSetInput) SetTags(v []*Tag) *CreateDataSetInput {
	s.Tags = v
	return s
}

type CreateDataSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	Arn *string `type:"string"`

	// The ID for the dataset that you want to create. This ID is unique per Amazon
	// Web Services Region for each Amazon Web Services account.
	DataSetId *string `type:"string"`

	// The ARN for the ingestion, which is triggered as a result of dataset creation
	// if the import mode is SPICE.
	IngestionArn *string `type:"string"`

	// The ID of the ingestion, which is triggered as a result of dataset creation
	// if the import mode is SPICE.
	IngestionId *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDataSetOutput) SetArn(v string) *CreateDataSetOutput {
	s.Arn = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateDataSetOutput) SetDataSetId(v string) *CreateDataSetOutput {
	s.DataSetId = &v
	return s
}

// SetIngestionArn sets the IngestionArn field's value.
func (s *CreateDataSetOutput) SetIngestionArn(v string) *CreateDataSetOutput {
	s.IngestionArn = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CreateDataSetOutput) SetIngestionId(v string) *CreateDataSetOutput {
	s.IngestionId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateDataSetOutput) SetRequestId(v string) *CreateDataSetOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDataSetOutput) SetStatus(v int64) *CreateDataSetOutput {
	s.Status = &v
	return s
}

type CreateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The credentials Amazon QuickSight that uses to connect to your underlying
	// source. Currently, only credentials based on user name and password are supported.
	//
	// Credentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDataSourceInput's
	// String and GoString methods.
	Credentials *DataSourceCredentials `type:"structure" sensitive:"true"`

	// An ID for the data source. This ID is unique per Amazon Web Services Region
	// for each Amazon Web Services account.
	//
	// DataSourceId is a required field
	DataSourceId *string `type:"string" required:"true"`

	// The parameters that Amazon QuickSight uses to connect to your underlying
	// source.
	DataSourceParameters *DataSourceParameters `type:"structure"`

	// A display name for the data source.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of resource permissions on the data source.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects
	// to your underlying source.
	SslProperties *SslProperties `type:"structure"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the data source.
	Tags []*Tag `min:"1" type:"list"`

	// The type of the data source. To return a list of all data sources, use ListDataSources.
	//
	// Use AMAZON_ELASTICSEARCH for Amazon OpenSearch Service.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataSourceType"`

	// Use this parameter only when you want Amazon QuickSight to use a VPC connection
	// when connecting to your underlying source.
	VpcConnectionProperties *VpcConnectionProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}
	if s.DataSourceParameters != nil {
		if err := s.DataSourceParameters.Validate(); err != nil {
			invalidParams.AddNested("DataSourceParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConnectionProperties != nil {
		if err := s.VpcConnectionProperties.Validate(); err != nil {
			invalidParams.AddNested("VpcConnectionProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateDataSourceInput) SetAwsAccountId(v string) *CreateDataSourceInput {
	s.AwsAccountId = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *CreateDataSourceInput) SetCredentials(v *DataSourceCredentials) *CreateDataSourceInput {
	s.Credentials = v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceInput) SetDataSourceId(v string) *CreateDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetDataSourceParameters sets the DataSourceParameters field's value.
func (s *CreateDataSourceInput) SetDataSourceParameters(v *DataSourceParameters) *CreateDataSourceInput {
	s.DataSourceParameters = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSourceInput) SetName(v string) *CreateDataSourceInput {
	s.Name = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateDataSourceInput) SetPermissions(v []*ResourcePermission) *CreateDataSourceInput {
	s.Permissions = v
	return s
}

// SetSslProperties sets the SslProperties field's value.
func (s *CreateDataSourceInput) SetSslProperties(v *SslProperties) *CreateDataSourceInput {
	s.SslProperties = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataSourceInput) SetTags(v []*Tag) *CreateDataSourceInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateDataSourceInput) SetType(v string) *CreateDataSourceInput {
	s.Type = &v
	return s
}

// SetVpcConnectionProperties sets the VpcConnectionProperties field's value.
func (s *CreateDataSourceInput) SetVpcConnectionProperties(v *VpcConnectionProperties) *CreateDataSourceInput {
	s.VpcConnectionProperties = v
	return s
}

type CreateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data source.
	Arn *string `type:"string"`

	// The status of creating the data source.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The ID of the data source. This ID is unique per Amazon Web Services Region
	// for each Amazon Web Services account.
	DataSourceId *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDataSourceOutput) SetArn(v string) *CreateDataSourceOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateDataSourceOutput) SetCreationStatus(v string) *CreateDataSourceOutput {
	s.CreationStatus = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceOutput) SetDataSourceId(v string) *CreateDataSourceOutput {
	s.DataSourceId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateDataSourceOutput) SetRequestId(v string) *CreateDataSourceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDataSourceOutput) SetStatus(v int64) *CreateDataSourceOutput {
	s.Status = &v
	return s
}

type CreateFolderInput struct {
	_ struct{} `type:"structure"`

	// The ID for the Amazon Web Services account where you want to create the folder.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`

	// The type of folder. By default, folderType is SHARED.
	FolderType *string `type:"string" enum:"FolderType"`

	// The name of the folder.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the parent folder.
	//
	// ParentFolderArn can be null. An empty parentFolderArn creates a root-level
	// folder.
	ParentFolderArn *string `type:"string"`

	// A structure that describes the principals and the resource-level permissions
	// of a folder.
	//
	// To specify no permissions, omit Permissions.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// Tags for the folder.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFolderInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateFolderInput) SetAwsAccountId(v string) *CreateFolderInput {
	s.AwsAccountId = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *CreateFolderInput) SetFolderId(v string) *CreateFolderInput {
	s.FolderId = &v
	return s
}

// SetFolderType sets the FolderType field's value.
func (s *CreateFolderInput) SetFolderType(v string) *CreateFolderInput {
	s.FolderType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFolderInput) SetName(v string) *CreateFolderInput {
	s.Name = &v
	return s
}

// SetParentFolderArn sets the ParentFolderArn field's value.
func (s *CreateFolderInput) SetParentFolderArn(v string) *CreateFolderInput {
	s.ParentFolderArn = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateFolderInput) SetPermissions(v []*ResourcePermission) *CreateFolderInput {
	s.Permissions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFolderInput) SetTags(v []*Tag) *CreateFolderInput {
	s.Tags = v
	return s
}

type CreateFolderMembershipInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that contains the folder.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`

	// The ID of the asset (the dashboard, analysis, or dataset).
	//
	// MemberId is a required field
	MemberId *string `location:"uri" locationName:"MemberId" min:"1" type:"string" required:"true"`

	// The type of the member, including DASHBOARD, ANALYSIS, and DATASET.
	//
	// MemberType is a required field
	MemberType *string `location:"uri" locationName:"MemberType" type:"string" required:"true" enum:"MemberType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFolderMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFolderMembershipInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.MemberType == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberType"))
	}
	if s.MemberType != nil && len(*s.MemberType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateFolderMembershipInput) SetAwsAccountId(v string) *CreateFolderMembershipInput {
	s.AwsAccountId = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *CreateFolderMembershipInput) SetFolderId(v string) *CreateFolderMembershipInput {
	s.FolderId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *CreateFolderMembershipInput) SetMemberId(v string) *CreateFolderMembershipInput {
	s.MemberId = &v
	return s
}

// SetMemberType sets the MemberType field's value.
func (s *CreateFolderMembershipInput) SetMemberType(v string) *CreateFolderMembershipInput {
	s.MemberType = &v
	return s
}

type CreateFolderMembershipOutput struct {
	_ struct{} `type:"structure"`

	// Information about the member in the folder.
	FolderMember *FolderMember `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderMembershipOutput) GoString() string {
	return s.String()
}

// SetFolderMember sets the FolderMember field's value.
func (s *CreateFolderMembershipOutput) SetFolderMember(v *FolderMember) *CreateFolderMembershipOutput {
	s.FolderMember = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateFolderMembershipOutput) SetRequestId(v string) *CreateFolderMembershipOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateFolderMembershipOutput) SetStatus(v int64) *CreateFolderMembershipOutput {
	s.Status = &v
	return s
}

type CreateFolderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the newly created folder.
	Arn *string `type:"string"`

	// The folder ID for the newly created folder.
	FolderId *string `min:"1" type:"string"`

	// The request ID for the newly created folder.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFolderOutput) SetArn(v string) *CreateFolderOutput {
	s.Arn = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *CreateFolderOutput) SetFolderId(v string) *CreateFolderOutput {
	s.FolderId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateFolderOutput) SetRequestId(v string) *CreateFolderOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateFolderOutput) SetStatus(v int64) *CreateFolderOutput {
	s.Status = &v
	return s
}

// The request object for this operation.
type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID for the Amazon Web Services account that the group is in. Currently,
	// you use the ID for the Amazon Web Services account that contains your Amazon
	// QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// A description for the group that you want to create.
	Description *string `min:"1" type:"string"`

	// A name for the group that you want to create.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The namespace that you want the group to be a part of.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateGroupInput) SetAwsAccountId(v string) *CreateGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGroupInput) SetDescription(v string) *CreateGroupInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupInput) SetGroupName(v string) *CreateGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateGroupInput) SetNamespace(v string) *CreateGroupInput {
	s.Namespace = &v
	return s
}

type CreateGroupMembershipInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that the group is in. Currently,
	// you use the ID for the Amazon Web Services account that contains your Amazon
	// QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to add the user to.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The name of the user that you want to add to the group membership.
	//
	// MemberName is a required field
	MemberName *string `location:"uri" locationName:"MemberName" min:"1" type:"string" required:"true"`

	// The namespace that you want the user to be a part of.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupMembershipInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MemberName == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberName"))
	}
	if s.MemberName != nil && len(*s.MemberName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateGroupMembershipInput) SetAwsAccountId(v string) *CreateGroupMembershipInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupMembershipInput) SetGroupName(v string) *CreateGroupMembershipInput {
	s.GroupName = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *CreateGroupMembershipInput) SetMemberName(v string) *CreateGroupMembershipInput {
	s.MemberName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateGroupMembershipInput) SetNamespace(v string) *CreateGroupMembershipInput {
	s.Namespace = &v
	return s
}

type CreateGroupMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The group member.
	GroupMember *GroupMember `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipOutput) GoString() string {
	return s.String()
}

// SetGroupMember sets the GroupMember field's value.
func (s *CreateGroupMembershipOutput) SetGroupMember(v *GroupMember) *CreateGroupMembershipOutput {
	s.GroupMember = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateGroupMembershipOutput) SetRequestId(v string) *CreateGroupMembershipOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGroupMembershipOutput) SetStatus(v int64) *CreateGroupMembershipOutput {
	s.Status = &v
	return s
}

// The response object for this operation.
type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group *Group `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *CreateGroupOutput) SetGroup(v *Group) *CreateGroupOutput {
	s.Group = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateGroupOutput) SetRequestId(v string) *CreateGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGroupOutput) SetStatus(v int64) *CreateGroupOutput {
	s.Status = &v
	return s
}

type CreateIAMPolicyAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the assignment, also called a rule. It must be unique within
	// an Amazon Web Services account.
	//
	// AssignmentName is a required field
	AssignmentName *string `min:"1" type:"string" required:"true"`

	// The status of the assignment. Possible values are as follows:
	//
	//    * ENABLED - Anything specified in this assignment is used when creating
	//    the data source.
	//
	//    * DISABLED - This assignment isn't used when creating the data source.
	//
	//    * DRAFT - This assignment is an unfinished draft and isn't used when creating
	//    the data source.
	//
	// AssignmentStatus is a required field
	AssignmentStatus *string `type:"string" required:"true" enum:"AssignmentStatus"`

	// The ID of the Amazon Web Services account where you want to assign an IAM
	// policy to Amazon QuickSight users or groups.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The Amazon QuickSight users, groups, or both that you want to assign the
	// policy to.
	Identities map[string][]*string `type:"map"`

	// The namespace that contains the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The ARN for the IAM policy to apply to the Amazon QuickSight users and groups
	// specified in this assignment.
	PolicyArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIAMPolicyAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIAMPolicyAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIAMPolicyAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIAMPolicyAssignmentInput"}
	if s.AssignmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentName"))
	}
	if s.AssignmentName != nil && len(*s.AssignmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentName", 1))
	}
	if s.AssignmentStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentStatus"))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *CreateIAMPolicyAssignmentInput) SetAssignmentName(v string) *CreateIAMPolicyAssignmentInput {
	s.AssignmentName = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *CreateIAMPolicyAssignmentInput) SetAssignmentStatus(v string) *CreateIAMPolicyAssignmentInput {
	s.AssignmentStatus = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateIAMPolicyAssignmentInput) SetAwsAccountId(v string) *CreateIAMPolicyAssignmentInput {
	s.AwsAccountId = &v
	return s
}

// SetIdentities sets the Identities field's value.
func (s *CreateIAMPolicyAssignmentInput) SetIdentities(v map[string][]*string) *CreateIAMPolicyAssignmentInput {
	s.Identities = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateIAMPolicyAssignmentInput) SetNamespace(v string) *CreateIAMPolicyAssignmentInput {
	s.Namespace = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreateIAMPolicyAssignmentInput) SetPolicyArn(v string) *CreateIAMPolicyAssignmentInput {
	s.PolicyArn = &v
	return s
}

type CreateIAMPolicyAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The ID for the assignment.
	AssignmentId *string `type:"string"`

	// The name of the assignment. This name must be unique within the Amazon Web
	// Services account.
	AssignmentName *string `min:"1" type:"string"`

	// The status of the assignment. Possible values are as follows:
	//
	//    * ENABLED - Anything specified in this assignment is used when creating
	//    the data source.
	//
	//    * DISABLED - This assignment isn't used when creating the data source.
	//
	//    * DRAFT - This assignment is an unfinished draft and isn't used when creating
	//    the data source.
	AssignmentStatus *string `type:"string" enum:"AssignmentStatus"`

	// The Amazon QuickSight users, groups, or both that the IAM policy is assigned
	// to.
	Identities map[string][]*string `type:"map"`

	// The ARN for the IAM policy that is applied to the Amazon QuickSight users
	// and groups specified in this assignment.
	PolicyArn *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIAMPolicyAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIAMPolicyAssignmentOutput) GoString() string {
	return s.String()
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetAssignmentId(v string) *CreateIAMPolicyAssignmentOutput {
	s.AssignmentId = &v
	return s
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetAssignmentName(v string) *CreateIAMPolicyAssignmentOutput {
	s.AssignmentName = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetAssignmentStatus(v string) *CreateIAMPolicyAssignmentOutput {
	s.AssignmentStatus = &v
	return s
}

// SetIdentities sets the Identities field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetIdentities(v map[string][]*string) *CreateIAMPolicyAssignmentOutput {
	s.Identities = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetPolicyArn(v string) *CreateIAMPolicyAssignmentOutput {
	s.PolicyArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetRequestId(v string) *CreateIAMPolicyAssignmentOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetStatus(v int64) *CreateIAMPolicyAssignmentOutput {
	s.Status = &v
	return s
}

type CreateIngestionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the dataset used in the ingestion.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// An ID for the ingestion.
	//
	// IngestionId is a required field
	IngestionId *string `location:"uri" locationName:"IngestionId" min:"1" type:"string" required:"true"`

	// The type of ingestion that you want to create.
	IngestionType *string `type:"string" enum:"IngestionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIngestionInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.IngestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionId"))
	}
	if s.IngestionId != nil && len(*s.IngestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateIngestionInput) SetAwsAccountId(v string) *CreateIngestionInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateIngestionInput) SetDataSetId(v string) *CreateIngestionInput {
	s.DataSetId = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CreateIngestionInput) SetIngestionId(v string) *CreateIngestionInput {
	s.IngestionId = &v
	return s
}

// SetIngestionType sets the IngestionType field's value.
func (s *CreateIngestionInput) SetIngestionType(v string) *CreateIngestionInput {
	s.IngestionType = &v
	return s
}

type CreateIngestionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the data ingestion.
	Arn *string `type:"string"`

	// An ID for the ingestion.
	IngestionId *string `min:"1" type:"string"`

	// The ingestion status.
	IngestionStatus *string `type:"string" enum:"IngestionStatus"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateIngestionOutput) SetArn(v string) *CreateIngestionOutput {
	s.Arn = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CreateIngestionOutput) SetIngestionId(v string) *CreateIngestionOutput {
	s.IngestionId = &v
	return s
}

// SetIngestionStatus sets the IngestionStatus field's value.
func (s *CreateIngestionOutput) SetIngestionStatus(v string) *CreateIngestionOutput {
	s.IngestionStatus = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateIngestionOutput) SetRequestId(v string) *CreateIngestionOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateIngestionOutput) SetStatus(v int64) *CreateIngestionOutput {
	s.Status = &v
	return s
}

type CreateNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The ID for the Amazon Web Services account that you want to create the Amazon
	// QuickSight namespace in.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// Specifies the type of your user identity directory. Currently, this supports
	// users with an identity type of QUICKSIGHT.
	//
	// IdentityStore is a required field
	IdentityStore *string `type:"string" required:"true" enum:"IdentityStore"`

	// The name that you want to use to describe the new namespace.
	//
	// Namespace is a required field
	Namespace *string `type:"string" required:"true"`

	// The tags that you want to associate with the namespace that you're creating.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNamespaceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.IdentityStore == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStore"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateNamespaceInput) SetAwsAccountId(v string) *CreateNamespaceInput {
	s.AwsAccountId = &v
	return s
}

// SetIdentityStore sets the IdentityStore field's value.
func (s *CreateNamespaceInput) SetIdentityStore(v string) *CreateNamespaceInput {
	s.IdentityStore = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateNamespaceInput) SetNamespace(v string) *CreateNamespaceInput {
	s.Namespace = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNamespaceInput) SetTags(v []*Tag) *CreateNamespaceInput {
	s.Tags = v
	return s
}

type CreateNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon QuickSight namespace you created.
	Arn *string `type:"string"`

	// The Amazon Web Services Region; that you want to use for the free SPICE capacity
	// for the new namespace. This is set to the region that you run CreateNamespace
	// in.
	CapacityRegion *string `type:"string"`

	// The status of the creation of the namespace. This is an asynchronous process.
	// A status of CREATED means that your namespace is ready to use. If an error
	// occurs, it indicates if the process is retryable or non-retryable. In the
	// case of a non-retryable error, refer to the error message for follow-up tasks.
	CreationStatus *string `type:"string" enum:"NamespaceStatus"`

	// Specifies the type of your user identity directory. Currently, this supports
	// users with an identity type of QUICKSIGHT.
	IdentityStore *string `type:"string" enum:"IdentityStore"`

	// The name of the new namespace that you created.
	Name *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateNamespaceOutput) SetArn(v string) *CreateNamespaceOutput {
	s.Arn = &v
	return s
}

// SetCapacityRegion sets the CapacityRegion field's value.
func (s *CreateNamespaceOutput) SetCapacityRegion(v string) *CreateNamespaceOutput {
	s.CapacityRegion = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateNamespaceOutput) SetCreationStatus(v string) *CreateNamespaceOutput {
	s.CreationStatus = &v
	return s
}

// SetIdentityStore sets the IdentityStore field's value.
func (s *CreateNamespaceOutput) SetIdentityStore(v string) *CreateNamespaceOutput {
	s.IdentityStore = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateNamespaceOutput) SetName(v string) *CreateNamespaceOutput {
	s.Name = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateNamespaceOutput) SetRequestId(v string) *CreateNamespaceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateNamespaceOutput) SetStatus(v int64) *CreateNamespaceOutput {
	s.Status = &v
	return s
}

type CreateRefreshScheduleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the dataset.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// The refresh schedule.
	//
	// Schedule is a required field
	Schedule *RefreshSchedule `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRefreshScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRefreshScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRefreshScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRefreshScheduleInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.Schedule == nil {
		invalidParams.Add(request.NewErrParamRequired("Schedule"))
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateRefreshScheduleInput) SetAwsAccountId(v string) *CreateRefreshScheduleInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateRefreshScheduleInput) SetDataSetId(v string) *CreateRefreshScheduleInput {
	s.DataSetId = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateRefreshScheduleInput) SetSchedule(v *RefreshSchedule) *CreateRefreshScheduleInput {
	s.Schedule = v
	return s
}

type CreateRefreshScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the refresh schedule.
	Arn *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The ID of the refresh schedule.
	ScheduleId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRefreshScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRefreshScheduleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateRefreshScheduleOutput) SetArn(v string) *CreateRefreshScheduleOutput {
	s.Arn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateRefreshScheduleOutput) SetRequestId(v string) *CreateRefreshScheduleOutput {
	s.RequestId = &v
	return s
}

// SetScheduleId sets the ScheduleId field's value.
func (s *CreateRefreshScheduleOutput) SetScheduleId(v string) *CreateRefreshScheduleOutput {
	s.ScheduleId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateRefreshScheduleOutput) SetStatus(v int64) *CreateRefreshScheduleOutput {
	s.Status = &v
	return s
}

type CreateTemplateAliasInput struct {
	_ struct{} `type:"structure"`

	// The name that you want to give to the template alias that you're creating.
	// Don't start the alias name with the $ character. Alias names that start with
	// $ are reserved by Amazon QuickSight.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that contains the template that
	// you creating an alias for.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// The version number of the template.
	//
	// TemplateVersionNumber is a required field
	TemplateVersionNumber *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.TemplateVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateVersionNumber"))
	}
	if s.TemplateVersionNumber != nil && *s.TemplateVersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TemplateVersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *CreateTemplateAliasInput) SetAliasName(v string) *CreateTemplateAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateTemplateAliasInput) SetAwsAccountId(v string) *CreateTemplateAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateTemplateAliasInput) SetTemplateId(v string) *CreateTemplateAliasInput {
	s.TemplateId = &v
	return s
}

// SetTemplateVersionNumber sets the TemplateVersionNumber field's value.
func (s *CreateTemplateAliasInput) SetTemplateVersionNumber(v int64) *CreateTemplateAliasInput {
	s.TemplateVersionNumber = &v
	return s
}

type CreateTemplateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// Information about the template alias.
	TemplateAlias *TemplateAlias `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateAliasOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *CreateTemplateAliasOutput) SetRequestId(v string) *CreateTemplateAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateTemplateAliasOutput) SetStatus(v int64) *CreateTemplateAliasOutput {
	s.Status = &v
	return s
}

// SetTemplateAlias sets the TemplateAlias field's value.
func (s *CreateTemplateAliasOutput) SetTemplateAlias(v *TemplateAlias) *CreateTemplateAliasOutput {
	s.TemplateAlias = v
	return s
}

type CreateTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID for the Amazon Web Services account that the group is in. You use
	// the ID for the Amazon Web Services account that contains your Amazon QuickSight
	// account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The definition of a template.
	//
	// A definition is the data model of all features in a Dashboard, Template,
	// or Analysis.
	//
	// Either a SourceEntity or a Definition must be provided in order for the request
	// to be valid.
	Definition *TemplateVersionDefinition `type:"structure"`

	// A display name for the template.
	Name *string `min:"1" type:"string"`

	// A list of resource permissions to be set on the template.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The entity that you are using as a source when you create the template. In
	// SourceEntity, you specify the type of object you're using as source: SourceTemplate
	// for a template or SourceAnalysis for an analysis. Both of these require an
	// Amazon Resource Name (ARN). For SourceTemplate, specify the ARN of the source
	// template. For SourceAnalysis, specify the ARN of the source analysis. The
	// SourceTemplate ARN can contain any Amazon Web Services account and any Amazon
	// QuickSight-supported Amazon Web Services Region.
	//
	// Use the DataSetReferences entity within SourceTemplate or SourceAnalysis
	// to list the replacement datasets for the placeholders listed in the original.
	// The schema in each dataset must match its placeholder.
	//
	// Either a SourceEntity or a Definition must be provided in order for the request
	// to be valid.
	SourceEntity *TemplateSourceEntity `type:"structure"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the resource.
	Tags []*Tag `min:"1" type:"list"`

	// An ID for the template that you want to create. This template is unique per
	// Amazon Web Services Region; in each Amazon Web Services account.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// A description of the current template version being created. This API operation
	// creates the first version of the template. Every time UpdateTemplate is called,
	// a new version is created. Each version of the template maintains a description
	// of the version in the VersionDescription field.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateTemplateInput) SetAwsAccountId(v string) *CreateTemplateInput {
	s.AwsAccountId = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreateTemplateInput) SetDefinition(v *TemplateVersionDefinition) *CreateTemplateInput {
	s.Definition = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTemplateInput) SetName(v string) *CreateTemplateInput {
	s.Name = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateTemplateInput) SetPermissions(v []*ResourcePermission) *CreateTemplateInput {
	s.Permissions = v
	return s
}

// SetSourceEntity sets the SourceEntity field's value.
func (s *CreateTemplateInput) SetSourceEntity(v *TemplateSourceEntity) *CreateTemplateInput {
	s.SourceEntity = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTemplateInput) SetTags(v []*Tag) *CreateTemplateInput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateTemplateInput) SetTemplateId(v string) *CreateTemplateInput {
	s.TemplateId = &v
	return s
}

// SetVersionDescription sets the VersionDescription field's value.
func (s *CreateTemplateInput) SetVersionDescription(v string) *CreateTemplateInput {
	s.VersionDescription = &v
	return s
}

type CreateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for the template.
	Arn *string `type:"string"`

	// The template creation status.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ID of the template.
	TemplateId *string `min:"1" type:"string"`

	// The ARN for the template, including the version information of the first
	// version.
	VersionArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateTemplateOutput) SetArn(v string) *CreateTemplateOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateTemplateOutput) SetCreationStatus(v string) *CreateTemplateOutput {
	s.CreationStatus = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateTemplateOutput) SetRequestId(v string) *CreateTemplateOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateTemplateOutput) SetStatus(v int64) *CreateTemplateOutput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateTemplateOutput) SetTemplateId(v string) *CreateTemplateOutput {
	s.TemplateId = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *CreateTemplateOutput) SetVersionArn(v string) *CreateTemplateOutput {
	s.VersionArn = &v
	return s
}

type CreateThemeAliasInput struct {
	_ struct{} `type:"structure"`

	// The name that you want to give to the theme alias that you are creating.
	// The alias name can't begin with a $. Alias names that start with $ are reserved
	// by Amazon QuickSight.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that contains the theme for the
	// new theme alias.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the theme alias.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`

	// The version number of the theme.
	//
	// ThemeVersionNumber is a required field
	ThemeVersionNumber *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThemeAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThemeAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThemeId", 1))
	}
	if s.ThemeVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeVersionNumber"))
	}
	if s.ThemeVersionNumber != nil && *s.ThemeVersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ThemeVersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *CreateThemeAliasInput) SetAliasName(v string) *CreateThemeAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateThemeAliasInput) SetAwsAccountId(v string) *CreateThemeAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *CreateThemeAliasInput) SetThemeId(v string) *CreateThemeAliasInput {
	s.ThemeId = &v
	return s
}

// SetThemeVersionNumber sets the ThemeVersionNumber field's value.
func (s *CreateThemeAliasInput) SetThemeVersionNumber(v int64) *CreateThemeAliasInput {
	s.ThemeVersionNumber = &v
	return s
}

type CreateThemeAliasOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// Information about the theme alias.
	ThemeAlias *ThemeAlias `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeAliasOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *CreateThemeAliasOutput) SetRequestId(v string) *CreateThemeAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateThemeAliasOutput) SetStatus(v int64) *CreateThemeAliasOutput {
	s.Status = &v
	return s
}

// SetThemeAlias sets the ThemeAlias field's value.
func (s *CreateThemeAliasOutput) SetThemeAlias(v *ThemeAlias) *CreateThemeAliasOutput {
	s.ThemeAlias = v
	return s
}

type CreateThemeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account where you want to store the new
	// theme.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the theme that a custom theme will inherit from. All themes inherit
	// from one of the starting themes defined by Amazon QuickSight. For a list
	// of the starting themes, use ListThemes or choose Themes from within an analysis.
	//
	// BaseThemeId is a required field
	BaseThemeId *string `min:"1" type:"string" required:"true"`

	// The theme configuration, which contains the theme display properties.
	//
	// Configuration is a required field
	Configuration *ThemeConfiguration `type:"structure" required:"true"`

	// A display name for the theme.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A valid grouping of resource permissions to apply to the new theme.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// A map of the key-value pairs for the resource tag or tags that you want to
	// add to the resource.
	Tags []*Tag `min:"1" type:"list"`

	// An ID for the theme that you want to create. The theme ID is unique per Amazon
	// Web Services Region in each Amazon Web Services account.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`

	// A description of the first version of the theme that you're creating. Every
	// time UpdateTheme is called, a new version is created. Each version of the
	// theme has a description of the version in the VersionDescription field.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThemeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThemeInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.BaseThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseThemeId"))
	}
	if s.BaseThemeId != nil && len(*s.BaseThemeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BaseThemeId", 1))
	}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThemeId", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateThemeInput) SetAwsAccountId(v string) *CreateThemeInput {
	s.AwsAccountId = &v
	return s
}

// SetBaseThemeId sets the BaseThemeId field's value.
func (s *CreateThemeInput) SetBaseThemeId(v string) *CreateThemeInput {
	s.BaseThemeId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateThemeInput) SetConfiguration(v *ThemeConfiguration) *CreateThemeInput {
	s.Configuration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateThemeInput) SetName(v string) *CreateThemeInput {
	s.Name = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateThemeInput) SetPermissions(v []*ResourcePermission) *CreateThemeInput {
	s.Permissions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateThemeInput) SetTags(v []*Tag) *CreateThemeInput {
	s.Tags = v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *CreateThemeInput) SetThemeId(v string) *CreateThemeInput {
	s.ThemeId = &v
	return s
}

// SetVersionDescription sets the VersionDescription field's value.
func (s *CreateThemeInput) SetVersionDescription(v string) *CreateThemeInput {
	s.VersionDescription = &v
	return s
}

type CreateThemeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the theme.
	Arn *string `type:"string"`

	// The theme creation status.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ID of the theme.
	ThemeId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the new theme.
	VersionArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateThemeOutput) SetArn(v string) *CreateThemeOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateThemeOutput) SetCreationStatus(v string) *CreateThemeOutput {
	s.CreationStatus = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateThemeOutput) SetRequestId(v string) *CreateThemeOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateThemeOutput) SetStatus(v int64) *CreateThemeOutput {
	s.Status = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *CreateThemeOutput) SetThemeId(v string) *CreateThemeOutput {
	s.ThemeId = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *CreateThemeOutput) SetVersionArn(v string) *CreateThemeOutput {
	s.VersionArn = &v
	return s
}

// The combination of user name and password that are used as credentials.
type CredentialPair struct {
	_ struct{} `type:"structure"`

	// A set of alternate data source parameters that you want to share for these
	// credentials. The credentials are applied in tandem with the data source parameters
	// when you copy a data source by using a create or update request. The API
	// operation compares the DataSourceParameters structure that's in the request
	// with the structures in the AlternateDataSourceParameters allow list. If the
	// structures are an exact match, the request is allowed to use the new data
	// source with the existing credentials. If the AlternateDataSourceParameters
	// list is null, the DataSourceParameters originally used with these Credentials
	// is automatically allowed.
	AlternateDataSourceParameters []*DataSourceParameters `min:"1" type:"list"`

	// Password.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true"`

	// User name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CredentialPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CredentialPair) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CredentialPair) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CredentialPair"}
	if s.AlternateDataSourceParameters != nil && len(s.AlternateDataSourceParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlternateDataSourceParameters", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.AlternateDataSourceParameters != nil {
		for i, v := range s.AlternateDataSourceParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AlternateDataSourceParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlternateDataSourceParameters sets the AlternateDataSourceParameters field's value.
func (s *CredentialPair) SetAlternateDataSourceParameters(v []*DataSourceParameters) *CredentialPair {
	s.AlternateDataSourceParameters = v
	return s
}

// SetPassword sets the Password field's value.
func (s *CredentialPair) SetPassword(v string) *CredentialPair {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *CredentialPair) SetUsername(v string) *CredentialPair {
	s.Username = &v
	return s
}

// The options that determine the currency display format configuration.
type CurrencyDisplayFormatConfiguration struct {
	_ struct{} `type:"structure"`

	// The option that determines the decimal places configuration.
	DecimalPlacesConfiguration *DecimalPlacesConfiguration `type:"structure"`

	// The options that determine the negative value configuration.
	NegativeValueConfiguration *NegativeValueConfiguration `type:"structure"`

	// The options that determine the null value format configuration.
	NullValueFormatConfiguration *NullValueFormatConfiguration `type:"structure"`

	// Determines the number scale value for the currency format.
	NumberScale *string `type:"string" enum:"NumberScale"`

	// Determines the prefix value of the currency format.
	//
	// Prefix is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CurrencyDisplayFormatConfiguration's
	// String and GoString methods.
	Prefix *string `min:"1" type:"string" sensitive:"true"`

	// The options that determine the numeric separator configuration.
	SeparatorConfiguration *NumericSeparatorConfiguration `type:"structure"`

	// Determines the suffix value of the currency format.
	//
	// Suffix is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CurrencyDisplayFormatConfiguration's
	// String and GoString methods.
	Suffix *string `min:"1" type:"string" sensitive:"true"`

	// Determines the symbol for the currency format.
	Symbol *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CurrencyDisplayFormatConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CurrencyDisplayFormatConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CurrencyDisplayFormatConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CurrencyDisplayFormatConfiguration"}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}
	if s.Suffix != nil && len(*s.Suffix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Suffix", 1))
	}
	if s.DecimalPlacesConfiguration != nil {
		if err := s.DecimalPlacesConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DecimalPlacesConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.NegativeValueConfiguration != nil {
		if err := s.NegativeValueConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NegativeValueConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.NullValueFormatConfiguration != nil {
		if err := s.NullValueFormatConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NullValueFormatConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecimalPlacesConfiguration sets the DecimalPlacesConfiguration field's value.
func (s *CurrencyDisplayFormatConfiguration) SetDecimalPlacesConfiguration(v *DecimalPlacesConfiguration) *CurrencyDisplayFormatConfiguration {
	s.DecimalPlacesConfiguration = v
	return s
}

// SetNegativeValueConfiguration sets the NegativeValueConfiguration field's value.
func (s *CurrencyDisplayFormatConfiguration) SetNegativeValueConfiguration(v *NegativeValueConfiguration) *CurrencyDisplayFormatConfiguration {
	s.NegativeValueConfiguration = v
	return s
}

// SetNullValueFormatConfiguration sets the NullValueFormatConfiguration field's value.
func (s *CurrencyDisplayFormatConfiguration) SetNullValueFormatConfiguration(v *NullValueFormatConfiguration) *CurrencyDisplayFormatConfiguration {
	s.NullValueFormatConfiguration = v
	return s
}

// SetNumberScale sets the NumberScale field's value.
func (s *CurrencyDisplayFormatConfiguration) SetNumberScale(v string) *CurrencyDisplayFormatConfiguration {
	s.NumberScale = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *CurrencyDisplayFormatConfiguration) SetPrefix(v string) *CurrencyDisplayFormatConfiguration {
	s.Prefix = &v
	return s
}

// SetSeparatorConfiguration sets the SeparatorConfiguration field's value.
func (s *CurrencyDisplayFormatConfiguration) SetSeparatorConfiguration(v *NumericSeparatorConfiguration) *CurrencyDisplayFormatConfiguration {
	s.SeparatorConfiguration = v
	return s
}

// SetSuffix sets the Suffix field's value.
func (s *CurrencyDisplayFormatConfiguration) SetSuffix(v string) *CurrencyDisplayFormatConfiguration {
	s.Suffix = &v
	return s
}

// SetSymbol sets the Symbol field's value.
func (s *CurrencyDisplayFormatConfiguration) SetSymbol(v string) *CurrencyDisplayFormatConfiguration {
	s.Symbol = &v
	return s
}

// The filter operation that filters data included in a visual or in an entire
// sheet.
type CustomActionFilterOperation struct {
	_ struct{} `type:"structure"`

	// The configuration that chooses the fields to be filtered.
	//
	// SelectedFieldsConfiguration is a required field
	SelectedFieldsConfiguration *FilterOperationSelectedFieldsConfiguration `type:"structure" required:"true"`

	// The configuration that chooses the target visuals to be filtered.
	//
	// TargetVisualsConfiguration is a required field
	TargetVisualsConfiguration *FilterOperationTargetVisualsConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomActionFilterOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomActionFilterOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomActionFilterOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomActionFilterOperation"}
	if s.SelectedFieldsConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectedFieldsConfiguration"))
	}
	if s.TargetVisualsConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetVisualsConfiguration"))
	}
	if s.SelectedFieldsConfiguration != nil {
		if err := s.SelectedFieldsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SelectedFieldsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.TargetVisualsConfiguration != nil {
		if err := s.TargetVisualsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TargetVisualsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSelectedFieldsConfiguration sets the SelectedFieldsConfiguration field's value.
func (s *CustomActionFilterOperation) SetSelectedFieldsConfiguration(v *FilterOperationSelectedFieldsConfiguration) *CustomActionFilterOperation {
	s.SelectedFieldsConfiguration = v
	return s
}

// SetTargetVisualsConfiguration sets the TargetVisualsConfiguration field's value.
func (s *CustomActionFilterOperation) SetTargetVisualsConfiguration(v *FilterOperationTargetVisualsConfiguration) *CustomActionFilterOperation {
	s.TargetVisualsConfiguration = v
	return s
}

// The navigation operation that navigates between different sheets in the same
// analysis.
//
// This is a union type structure. For this structure to be valid, only one
// of the attributes can be defined.
type CustomActionNavigationOperation struct {
	_ struct{} `type:"structure"`

	// The configuration that chooses the navigation target.
	LocalNavigationConfiguration *LocalNavigationConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomActionNavigationOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomActionNavigationOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomActionNavigationOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomActionNavigationOperation"}
	if s.LocalNavigationConfiguration != nil {
		if err := s.LocalNavigationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LocalNavigationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocalNavigationConfiguration sets the LocalNavigationConfiguration field's value.
func (s *CustomActionNavigationOperation) SetLocalNavigationConfiguration(v *LocalNavigationConfiguration) *CustomActionNavigationOperation {
	s.LocalNavigationConfiguration = v
	return s
}

// The set parameter operation that sets parameters in custom action.
type CustomActionSetParametersOperation struct {
	_ struct{} `type:"structure"`

	// The parameter that determines the value configuration.
	//
	// ParameterValueConfigurations is a required field
	ParameterValueConfigurations []*SetParameterValueConfiguration `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomActionSetParametersOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomActionSetParametersOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomActionSetParametersOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomActionSetParametersOperation"}
	if s.ParameterValueConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterValueConfigurations"))
	}
	if s.ParameterValueConfigurations != nil && len(s.ParameterValueConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterValueConfigurations", 1))
	}
	if s.ParameterValueConfigurations != nil {
		for i, v := range s.ParameterValueConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterValueConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterValueConfigurations sets the ParameterValueConfigurations field's value.
func (s *CustomActionSetParametersOperation) SetParameterValueConfigurations(v []*SetParameterValueConfiguration) *CustomActionSetParametersOperation {
	s.ParameterValueConfigurations = v
	return s
}

// The URL operation that opens a link to another webpage.
type CustomActionURLOperation struct {
	_ struct{} `type:"structure"`

	// The target of the CustomActionURLOperation.
	//
	// Valid values are defined as follows:
	//
	//    * NEW_TAB: Opens the target URL in a new browser tab.
	//
	//    * NEW_WINDOW: Opens the target URL in a new browser window.
	//
	//    * SAME_TAB: Opens the target URL in the same browser tab.
	//
	// URLTarget is a required field
	URLTarget *string `type:"string" required:"true" enum:"URLTargetConfiguration"`

	// THe URL link of the CustomActionURLOperation.
	//
	// URLTemplate is a required field
	URLTemplate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomActionURLOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomActionURLOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomActionURLOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomActionURLOperation"}
	if s.URLTarget == nil {
		invalidParams.Add(request.NewErrParamRequired("URLTarget"))
	}
	if s.URLTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("URLTemplate"))
	}
	if s.URLTemplate != nil && len(*s.URLTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("URLTemplate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetURLTarget sets the URLTarget field's value.
func (s *CustomActionURLOperation) SetURLTarget(v string) *CustomActionURLOperation {
	s.URLTarget = &v
	return s
}

// SetURLTemplate sets the URLTemplate field's value.
func (s *CustomActionURLOperation) SetURLTemplate(v string) *CustomActionURLOperation {
	s.URLTemplate = &v
	return s
}

// The configuration of a CustomContentVisual.
type CustomContentConfiguration struct {
	_ struct{} `type:"structure"`

	// The content type of the custom content visual. You can use this to have the
	// visual render as an image.
	ContentType *string `type:"string" enum:"CustomContentType"`

	// The input URL that links to the custom content that you want in the custom
	// visual.
	ContentUrl *string `min:"1" type:"string"`

	// The sizing options for the size of the custom content visual. This structure
	// is required when the ContentType of the visual is 'IMAGE'.
	ImageScaling *string `type:"string" enum:"CustomContentImageScalingConfiguration"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomContentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomContentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomContentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomContentConfiguration"}
	if s.ContentUrl != nil && len(*s.ContentUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *CustomContentConfiguration) SetContentType(v string) *CustomContentConfiguration {
	s.ContentType = &v
	return s
}

// SetContentUrl sets the ContentUrl field's value.
func (s *CustomContentConfiguration) SetContentUrl(v string) *CustomContentConfiguration {
	s.ContentUrl = &v
	return s
}

// SetImageScaling sets the ImageScaling field's value.
func (s *CustomContentConfiguration) SetImageScaling(v string) *CustomContentConfiguration {
	s.ImageScaling = &v
	return s
}

// A visual that contains custom content.
//
// For more information, see Using custom visual content (https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html)
// in the Amazon QuickSight User Guide.
type CustomContentVisual struct {
	_ struct{} `type:"structure"`

	// The list of custom actions that are configured for a visual.
	Actions []*VisualCustomAction `type:"list"`

	// The configuration of a CustomContentVisual.
	ChartConfiguration *CustomContentConfiguration `type:"structure"`

	// The dataset that is used to create the custom content visual. You can't create
	// a visual without a dataset.
	//
	// DataSetIdentifier is a required field
	DataSetIdentifier *string `min:"1" type:"string" required:"true"`

	// The subtitle that is displayed on the visual.
	Subtitle *VisualSubtitleLabelOptions `type:"structure"`

	// The title that is displayed on the visual.
	Title *VisualTitleLabelOptions `type:"structure"`

	// The unique identifier of a visual. This identifier must be unique within
	// the context of a dashboard, template, or analysis. Two dashboards, analyses,
	// or templates can have visuals with the same identifiers.
	//
	// VisualId is a required field
	VisualId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomContentVisual) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomContentVisual) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomContentVisual) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomContentVisual"}
	if s.DataSetIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetIdentifier"))
	}
	if s.DataSetIdentifier != nil && len(*s.DataSetIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetIdentifier", 1))
	}
	if s.VisualId == nil {
		invalidParams.Add(request.NewErrParamRequired("VisualId"))
	}
	if s.VisualId != nil && len(*s.VisualId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VisualId", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ChartConfiguration != nil {
		if err := s.ChartConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChartConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Subtitle != nil {
		if err := s.Subtitle.Validate(); err != nil {
			invalidParams.AddNested("Subtitle", err.(request.ErrInvalidParams))
		}
	}
	if s.Title != nil {
		if err := s.Title.Validate(); err != nil {
			invalidParams.AddNested("Title", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CustomContentVisual) SetActions(v []*VisualCustomAction) *CustomContentVisual {
	s.Actions = v
	return s
}

// SetChartConfiguration sets the ChartConfiguration field's value.
func (s *CustomContentVisual) SetChartConfiguration(v *CustomContentConfiguration) *CustomContentVisual {
	s.ChartConfiguration = v
	return s
}

// SetDataSetIdentifier sets the DataSetIdentifier field's value.
func (s *CustomContentVisual) SetDataSetIdentifier(v string) *CustomContentVisual {
	s.DataSetIdentifier = &v
	return s
}

// SetSubtitle sets the Subtitle field's value.
func (s *CustomContentVisual) SetSubtitle(v *VisualSubtitleLabelOptions) *CustomContentVisual {
	s.Subtitle = v
	return s
}

// SetTitle sets the Title field's value.
func (s *CustomContentVisual) SetTitle(v *VisualTitleLabelOptions) *CustomContentVisual {
	s.Title = v
	return s
}

// SetVisualId sets the VisualId field's value.
func (s *CustomContentVisual) SetVisualId(v string) *CustomContentVisual {
	s.VisualId = &v
	return s
}

// A custom filter that filters based on a single value. This filter can be
// partially matched.
type CustomFilterConfiguration struct {
	_ struct{} `type:"structure"`

	// The category value for the filter.
	//
	// This field is mutually exclusive to ParameterName.
	CategoryValue *string `type:"string"`

	// The match operator that is used to determine if a filter should be applied.
	//
	// MatchOperator is a required field
	MatchOperator *string `type:"string" required:"true" enum:"CategoryFilterMatchOperator"`

	// This option determines how null values should be treated when filtering data.
	//
	//    * ALL_VALUES: Include null values in filtered results.
	//
	//    * NULLS_ONLY: Only include null values in filtered results.
	//
	//    * NON_NULLS_ONLY: Exclude null values from filtered results.
	//
	// NullOption is a required field
	NullOption *string `type:"string" required:"true" enum:"FilterNullOption"`

	// The parameter whose value should be used for the filter value.
	//
	// This field is mutually exclusive to CategoryValue.
	ParameterName *string `min:"1" type:"string"`

	// Select all of the values. Null is not the assigned value of select all.
	//
	//    * FILTER_ALL_VALUES
	SelectAllOptions *string `type:"string" enum:"CategoryFilterSelectAllOptions"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomFilterConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomFilterConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomFilterConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomFilterConfiguration"}
	if s.MatchOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("MatchOperator"))
	}
	if s.NullOption == nil {
		invalidParams.Add(request.NewErrParamRequired("NullOption"))
	}
	if s.ParameterName != nil && len(*s.ParameterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryValue sets the CategoryValue field's value.
func (s *CustomFilterConfiguration) SetCategoryValue(v string) *CustomFilterConfiguration {
	s.CategoryValue = &v
	return s
}

// SetMatchOperator sets the MatchOperator field's value.
func (s *CustomFilterConfiguration) SetMatchOperator(v string) *CustomFilterConfiguration {
	s.MatchOperator = &v
	return s
}

// SetNullOption sets the NullOption field's value.
func (s *CustomFilterConfiguration) SetNullOption(v string) *CustomFilterConfiguration {
	s.NullOption = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *CustomFilterConfiguration) SetParameterName(v string) *CustomFilterConfiguration {
	s.ParameterName = &v
	return s
}

// SetSelectAllOptions sets the SelectAllOptions field's value.
func (s *CustomFilterConfiguration) SetSelectAllOptions(v string) *CustomFilterConfiguration {
	s.SelectAllOptions = &v
	return s
}

// A list of custom filter values.
type CustomFilterListConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of category values for the filter.
	CategoryValues []*string `type:"list"`

	// The match operator that is used to determine if a filter should be applied.
	//
	// MatchOperator is a required field
	MatchOperator *string `type:"string" required:"true" enum:"CategoryFilterMatchOperator"`

	// This option determines how null values should be treated when filtering data.
	//
	//    * ALL_VALUES: Include null values in filtered results.
	//
	//    * NULLS_ONLY: Only include null values in filtered results.
	//
	//    * NON_NULLS_ONLY: Exclude null values from filtered results.
	//
	// NullOption is a required field
	NullOption *string `type:"string" required:"true" enum:"FilterNullOption"`

	// Select all of the values. Null is not the assigned value of select all.
	//
	//    * FILTER_A