// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package androidpublisher provides access to the Google Play Android Developer API.
//
// For product documentation, see: https://developers.google.com/android-publisher
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/androidpublisher/v3"
//	...
//	ctx := context.Background()
//	androidpublisherService, err := androidpublisher.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	androidpublisherService, err := androidpublisher.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	androidpublisherService, err := androidpublisher.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package androidpublisher // import "google.golang.org/api/androidpublisher/v3"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "androidpublisher:v3"
const apiName = "androidpublisher"
const apiVersion = "v3"
const basePath = "https://androidpublisher.googleapis.com/"
const basePathTemplate = "https://androidpublisher.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://androidpublisher.mtls.googleapis.com/"
const defaultUniverseDomain = "googleapis.com"

// OAuth2 scopes used by this API.
const (
	// View and manage your Google Play Developer account
	AndroidpublisherScope = "https://www.googleapis.com/auth/androidpublisher"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/androidpublisher",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.WithDefaultUniverseDomain(defaultUniverseDomain))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Applications = NewApplicationsService(s)
	s.Apprecovery = NewApprecoveryService(s)
	s.Edits = NewEditsService(s)
	s.Externaltransactions = NewExternaltransactionsService(s)
	s.Generatedapks = NewGeneratedapksService(s)
	s.Grants = NewGrantsService(s)
	s.Inappproducts = NewInappproductsService(s)
	s.Internalappsharingartifacts = NewInternalappsharingartifactsService(s)
	s.Monetization = NewMonetizationService(s)
	s.Orders = NewOrdersService(s)
	s.Purchases = NewPurchasesService(s)
	s.Reviews = NewReviewsService(s)
	s.Systemapks = NewSystemapksService(s)
	s.Users = NewUsersService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Applications *ApplicationsService

	Apprecovery *ApprecoveryService

	Edits *EditsService

	Externaltransactions *ExternaltransactionsService

	Generatedapks *GeneratedapksService

	Grants *GrantsService

	Inappproducts *InappproductsService

	Internalappsharingartifacts *InternalappsharingartifactsService

	Monetization *MonetizationService

	Orders *OrdersService

	Purchases *PurchasesService

	Reviews *ReviewsService

	Systemapks *SystemapksService

	Users *UsersService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewApplicationsService(s *Service) *ApplicationsService {
	rs := &ApplicationsService{s: s}
	rs.DeviceTierConfigs = NewApplicationsDeviceTierConfigsService(s)
	return rs
}

type ApplicationsService struct {
	s *Service

	DeviceTierConfigs *ApplicationsDeviceTierConfigsService
}

func NewApplicationsDeviceTierConfigsService(s *Service) *ApplicationsDeviceTierConfigsService {
	rs := &ApplicationsDeviceTierConfigsService{s: s}
	return rs
}

type ApplicationsDeviceTierConfigsService struct {
	s *Service
}

func NewApprecoveryService(s *Service) *ApprecoveryService {
	rs := &ApprecoveryService{s: s}
	return rs
}

type ApprecoveryService struct {
	s *Service
}

func NewEditsService(s *Service) *EditsService {
	rs := &EditsService{s: s}
	rs.Apks = NewEditsApksService(s)
	rs.Bundles = NewEditsBundlesService(s)
	rs.Countryavailability = NewEditsCountryavailabilityService(s)
	rs.Deobfuscationfiles = NewEditsDeobfuscationfilesService(s)
	rs.Details = NewEditsDetailsService(s)
	rs.Expansionfiles = NewEditsExpansionfilesService(s)
	rs.Images = NewEditsImagesService(s)
	rs.Listings = NewEditsListingsService(s)
	rs.Testers = NewEditsTestersService(s)
	rs.Tracks = NewEditsTracksService(s)
	return rs
}

type EditsService struct {
	s *Service

	Apks *EditsApksService

	Bundles *EditsBundlesService

	Countryavailability *EditsCountryavailabilityService

	Deobfuscationfiles *EditsDeobfuscationfilesService

	Details *EditsDetailsService

	Expansionfiles *EditsExpansionfilesService

	Images *EditsImagesService

	Listings *EditsListingsService

	Testers *EditsTestersService

	Tracks *EditsTracksService
}

func NewEditsApksService(s *Service) *EditsApksService {
	rs := &EditsApksService{s: s}
	return rs
}

type EditsApksService struct {
	s *Service
}

func NewEditsBundlesService(s *Service) *EditsBundlesService {
	rs := &EditsBundlesService{s: s}
	return rs
}

type EditsBundlesService struct {
	s *Service
}

func NewEditsCountryavailabilityService(s *Service) *EditsCountryavailabilityService {
	rs := &EditsCountryavailabilityService{s: s}
	return rs
}

type EditsCountryavailabilityService struct {
	s *Service
}

func NewEditsDeobfuscationfilesService(s *Service) *EditsDeobfuscationfilesService {
	rs := &EditsDeobfuscationfilesService{s: s}
	return rs
}

type EditsDeobfuscationfilesService struct {
	s *Service
}

func NewEditsDetailsService(s *Service) *EditsDetailsService {
	rs := &EditsDetailsService{s: s}
	return rs
}

type EditsDetailsService struct {
	s *Service
}

func NewEditsExpansionfilesService(s *Service) *EditsExpansionfilesService {
	rs := &EditsExpansionfilesService{s: s}
	return rs
}

type EditsExpansionfilesService struct {
	s *Service
}

func NewEditsImagesService(s *Service) *EditsImagesService {
	rs := &EditsImagesService{s: s}
	return rs
}

type EditsImagesService struct {
	s *Service
}

func NewEditsListingsService(s *Service) *EditsListingsService {
	rs := &EditsListingsService{s: s}
	return rs
}

type EditsListingsService struct {
	s *Service
}

func NewEditsTestersService(s *Service) *EditsTestersService {
	rs := &EditsTestersService{s: s}
	return rs
}

type EditsTestersService struct {
	s *Service
}

func NewEditsTracksService(s *Service) *EditsTracksService {
	rs := &EditsTracksService{s: s}
	return rs
}

type EditsTracksService struct {
	s *Service
}

func NewExternaltransactionsService(s *Service) *ExternaltransactionsService {
	rs := &ExternaltransactionsService{s: s}
	return rs
}

type ExternaltransactionsService struct {
	s *Service
}

func NewGeneratedapksService(s *Service) *GeneratedapksService {
	rs := &GeneratedapksService{s: s}
	return rs
}

type GeneratedapksService struct {
	s *Service
}

func NewGrantsService(s *Service) *GrantsService {
	rs := &GrantsService{s: s}
	return rs
}

type GrantsService struct {
	s *Service
}

func NewInappproductsService(s *Service) *InappproductsService {
	rs := &InappproductsService{s: s}
	return rs
}

type InappproductsService struct {
	s *Service
}

func NewInternalappsharingartifactsService(s *Service) *InternalappsharingartifactsService {
	rs := &InternalappsharingartifactsService{s: s}
	return rs
}

type InternalappsharingartifactsService struct {
	s *Service
}

func NewMonetizationService(s *Service) *MonetizationService {
	rs := &MonetizationService{s: s}
	rs.Subscriptions = NewMonetizationSubscriptionsService(s)
	return rs
}

type MonetizationService struct {
	s *Service

	Subscriptions *MonetizationSubscriptionsService
}

func NewMonetizationSubscriptionsService(s *Service) *MonetizationSubscriptionsService {
	rs := &MonetizationSubscriptionsService{s: s}
	rs.BasePlans = NewMonetizationSubscriptionsBasePlansService(s)
	return rs
}

type MonetizationSubscriptionsService struct {
	s *Service

	BasePlans *MonetizationSubscriptionsBasePlansService
}

func NewMonetizationSubscriptionsBasePlansService(s *Service) *MonetizationSubscriptionsBasePlansService {
	rs := &MonetizationSubscriptionsBasePlansService{s: s}
	rs.Offers = NewMonetizationSubscriptionsBasePlansOffersService(s)
	return rs
}

type MonetizationSubscriptionsBasePlansService struct {
	s *Service

	Offers *MonetizationSubscriptionsBasePlansOffersService
}

func NewMonetizationSubscriptionsBasePlansOffersService(s *Service) *MonetizationSubscriptionsBasePlansOffersService {
	rs := &MonetizationSubscriptionsBasePlansOffersService{s: s}
	return rs
}

type MonetizationSubscriptionsBasePlansOffersService struct {
	s *Service
}

func NewOrdersService(s *Service) *OrdersService {
	rs := &OrdersService{s: s}
	return rs
}

type OrdersService struct {
	s *Service
}

func NewPurchasesService(s *Service) *PurchasesService {
	rs := &PurchasesService{s: s}
	rs.Products = NewPurchasesProductsService(s)
	rs.Subscriptions = NewPurchasesSubscriptionsService(s)
	rs.Subscriptionsv2 = NewPurchasesSubscriptionsv2Service(s)
	rs.Voidedpurchases = NewPurchasesVoidedpurchasesService(s)
	return rs
}

type PurchasesService struct {
	s *Service

	Products *PurchasesProductsService

	Subscriptions *PurchasesSubscriptionsService

	Subscriptionsv2 *PurchasesSubscriptionsv2Service

	Voidedpurchases *PurchasesVoidedpurchasesService
}

func NewPurchasesProductsService(s *Service) *PurchasesProductsService {
	rs := &PurchasesProductsService{s: s}
	return rs
}

type PurchasesProductsService struct {
	s *Service
}

func NewPurchasesSubscriptionsService(s *Service) *PurchasesSubscriptionsService {
	rs := &PurchasesSubscriptionsService{s: s}
	return rs
}

type PurchasesSubscriptionsService struct {
	s *Service
}

func NewPurchasesSubscriptionsv2Service(s *Service) *PurchasesSubscriptionsv2Service {
	rs := &PurchasesSubscriptionsv2Service{s: s}
	return rs
}

type PurchasesSubscriptionsv2Service struct {
	s *Service
}

func NewPurchasesVoidedpurchasesService(s *Service) *PurchasesVoidedpurchasesService {
	rs := &PurchasesVoidedpurchasesService{s: s}
	return rs
}

type PurchasesVoidedpurchasesService struct {
	s *Service
}

func NewReviewsService(s *Service) *ReviewsService {
	rs := &ReviewsService{s: s}
	return rs
}

type ReviewsService struct {
	s *Service
}

func NewSystemapksService(s *Service) *SystemapksService {
	rs := &SystemapksService{s: s}
	rs.Variants = NewSystemapksVariantsService(s)
	return rs
}

type SystemapksService struct {
	s *Service

	Variants *SystemapksVariantsService
}

func NewSystemapksVariantsService(s *Service) *SystemapksVariantsService {
	rs := &SystemapksVariantsService{s: s}
	return rs
}

type SystemapksVariantsService struct {
	s *Service
}

func NewUsersService(s *Service) *UsersService {
	rs := &UsersService{s: s}
	return rs
}

type UsersService struct {
	s *Service
}

// Abi: Represents an Abi.
type Abi struct {
	// Alias: Alias for an abi.
	//
	// Possible values:
	//   "UNSPECIFIED_CPU_ARCHITECTURE" - Unspecified abi.
	//   "ARMEABI" - ARMEABI abi.
	//   "ARMEABI_V7A" - ARMEABI_V7A abi.
	//   "ARM64_V8A" - ARM64_V8A abi.
	//   "X86" - X86 abi.
	//   "X86_64" - X86_64 abi.
	//   "RISCV64" - RISCV64 abi.
	Alias string `json:"alias,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alias") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Abi) MarshalJSON() ([]byte, error) {
	type NoMethod Abi
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbiTargeting: Targeting based on Abi.
type AbiTargeting struct {
	// Alternatives: Targeting of other sibling directories that were in the
	// Bundle. For main splits this is targeting of other main splits.
	Alternatives []*Abi `json:"alternatives,omitempty"`

	// Value: Value of an abi.
	Value []*Abi `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alternatives") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alternatives") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbiTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod AbiTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcquisitionTargetingRule: Represents a targeting rule of the form:
// User never had {scope} before.
type AcquisitionTargetingRule struct {
	// Scope: Required. The scope of subscriptions this rule considers. Only
	// allows "this subscription" and "any subscription in app".
	Scope *TargetingRuleScope `json:"scope,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Scope") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Scope") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcquisitionTargetingRule) MarshalJSON() ([]byte, error) {
	type NoMethod AcquisitionTargetingRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ActivateBasePlanRequest: Request message for ActivateBasePlan.
type ActivateBasePlanRequest struct {
	// BasePlanId: Required. The unique base plan ID of the base plan to
	// activate.
	BasePlanId string `json:"basePlanId,omitempty"`

	// LatencyTolerance: Optional. The latency tolerance for the propagation
	// of this product update. Defaults to latency-sensitive.
	//
	// Possible values:
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
	// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
	// will propagate to clients within several minutes on average and up to
	// a few hours in rare cases. Throughput is limited to 7,200 updates per
	// app per hour.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
	// will propagate to clients within 24 hours. Supports high throughput
	// of up to 720,000 updates per app per hour using batch modification
	// methods.
	LatencyTolerance string `json:"latencyTolerance,omitempty"`

	// PackageName: Required. The parent app (package name) of the base plan
	// to activate.
	PackageName string `json:"packageName,omitempty"`

	// ProductId: Required. The parent subscription (ID) of the base plan to
	// activate.
	ProductId string `json:"productId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BasePlanId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BasePlanId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ActivateBasePlanRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ActivateBasePlanRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ActivateSubscriptionOfferRequest: Request message for
// ActivateSubscriptionOffer.
type ActivateSubscriptionOfferRequest struct {
	// BasePlanId: Required. The parent base plan (ID) of the offer to
	// activate.
	BasePlanId string `json:"basePlanId,omitempty"`

	// LatencyTolerance: Optional. The latency tolerance for the propagation
	// of this product update. Defaults to latency-sensitive.
	//
	// Possible values:
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
	// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
	// will propagate to clients within several minutes on average and up to
	// a few hours in rare cases. Throughput is limited to 7,200 updates per
	// app per hour.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
	// will propagate to clients within 24 hours. Supports high throughput
	// of up to 720,000 updates per app per hour using batch modification
	// methods.
	LatencyTolerance string `json:"latencyTolerance,omitempty"`

	// OfferId: Required. The unique offer ID of the offer to activate.
	OfferId string `json:"offerId,omitempty"`

	// PackageName: Required. The parent app (package name) of the offer to
	// activate.
	PackageName string `json:"packageName,omitempty"`

	// ProductId: Required. The parent subscription (ID) of the offer to
	// activate.
	ProductId string `json:"productId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BasePlanId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BasePlanId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ActivateSubscriptionOfferRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ActivateSubscriptionOfferRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddTargetingRequest: Request message for AddTargeting.
type AddTargetingRequest struct {
	// TargetingUpdate: Specifies targeting updates such as regions, android
	// sdk versions etc.
	TargetingUpdate *TargetingUpdate `json:"targetingUpdate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TargetingUpdate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TargetingUpdate") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AddTargetingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddTargetingRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddTargetingResponse: Response message for AddTargeting.
type AddTargetingResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// AllUsers: Object representation to describe all set of users.
type AllUsers struct {
	// IsAllUsersRequested: Required. Set to true if all set of users are
	// needed.
	IsAllUsersRequested bool `json:"isAllUsersRequested,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsAllUsersRequested")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsAllUsersRequested") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AllUsers) MarshalJSON() ([]byte, error) {
	type NoMethod AllUsers
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AndroidSdks: Android api level targeting data for app recovery action
// targeting.
type AndroidSdks struct {
	// SdkLevels: Android api levels of devices targeted by recovery action.
	// See
	// https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels
	// for different api levels in android.
	SdkLevels googleapi.Int64s `json:"sdkLevels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SdkLevels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SdkLevels") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AndroidSdks) MarshalJSON() ([]byte, error) {
	type NoMethod AndroidSdks
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Apk: Information about an APK. The resource for ApksService.
type Apk struct {
	// Binary: Information about the binary payload of this APK.
	Binary *ApkBinary `json:"binary,omitempty"`

	// VersionCode: The version code of the APK, as specified in the
	// manifest file.
	VersionCode int64 `json:"versionCode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Binary") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Binary") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Apk) MarshalJSON() ([]byte, error) {
	type NoMethod Apk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ApkBinary: Represents the binary payload of an APK.
type ApkBinary struct {
	// Sha1: A sha1 hash of the APK payload, encoded as a hex string and
	// matching the output of the sha1sum command.
	Sha1 string `json:"sha1,omitempty"`

	// Sha256: A sha256 hash of the APK payload, encoded as a hex string and
	// matching the output of the sha256sum command.
	Sha256 string `json:"sha256,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Sha1") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Sha1") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ApkBinary) MarshalJSON() ([]byte, error) {
	type NoMethod ApkBinary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ApkDescription: Description of the created apks.
type ApkDescription struct {
	// AssetSliceMetadata: Set only for asset slices.
	AssetSliceMetadata *SplitApkMetadata `json:"assetSliceMetadata,omitempty"`

	// InstantApkMetadata: Set only for Instant split APKs.
	InstantApkMetadata *SplitApkMetadata `json:"instantApkMetadata,omitempty"`

	// Path: Path of the Apk, will be in the following format: .apk where
	// DownloadId is the ID used to download the apk using
	// GeneratedApks.Download API.
	Path string `json:"path,omitempty"`

	// SplitApkMetadata: Set only for Split APKs.
	SplitApkMetadata *SplitApkMetadata `json:"splitApkMetadata,omitempty"`

	// StandaloneApkMetadata: Set only for standalone APKs.
	StandaloneApkMetadata *StandaloneApkMetadata `json:"standaloneApkMetadata,omitempty"`

	// Targeting: Apk-level targeting.
	Targeting *ApkTargeting `json:"targeting,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AssetSliceMetadata")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetSliceMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ApkDescription) MarshalJSON() ([]byte, error) {
	type NoMethod ApkDescription
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ApkSet: A set of apks representing a module.
type ApkSet struct {
	// ApkDescription: Description of the generated apks.
	ApkDescription []*ApkDescription `json:"apkDescription,omitempty"`

	// ModuleMetadata: Metadata about the module represented by this ApkSet
	ModuleMetadata *ModuleMetadata `json:"moduleMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApkDescription") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApkDescription") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ApkSet) MarshalJSON() ([]byte, error) {
	type NoMethod ApkSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ApkTargeting: Represents a set of apk-level targetings.
type ApkTargeting struct {
	// AbiTargeting: The abi that the apk targets
	AbiTargeting *AbiTargeting `json:"abiTargeting,omitempty"`

	// LanguageTargeting: The language that the apk targets
	LanguageTargeting *LanguageTargeting `json:"languageTargeting,omitempty"`

	// MultiAbiTargeting: Multi-api-level targeting.
	MultiAbiTargeting *MultiAbiTargeting `json:"multiAbiTargeting,omitempty"`

	// ScreenDensityTargeting: The screen density that this apk supports.
	ScreenDensityTargeting *ScreenDensityTargeting `json:"screenDensityTargeting,omitempty"`

	// SdkVersionTargeting: The sdk version that the apk targets
	SdkVersionTargeting *SdkVersionTargeting `json:"sdkVersionTargeting,omitempty"`

	// TextureCompressionFormatTargeting: Texture-compression-format-level
	// targeting
	TextureCompressionFormatTargeting *TextureCompressionFormatTargeting `json:"textureCompressionFormatTargeting,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AbiTargeting") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AbiTargeting") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ApkTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod ApkTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ApksAddExternallyHostedRequest: Request to create a new externally
// hosted APK.
type ApksAddExternallyHostedRequest struct {
	// ExternallyHostedApk: The definition of the externally-hosted APK and
	// where it is located.
	ExternallyHostedApk *ExternallyHostedApk `json:"externallyHostedApk,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExternallyHostedApk")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternallyHostedApk") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ApksAddExternallyHostedRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ApksAddExternallyHostedRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ApksAddExternallyHostedResponse: Response for creating a new
// externally hosted APK.
type ApksAddExternallyHostedResponse struct {
	// ExternallyHostedApk: The definition of the externally-hosted APK and
	// where it is located.
	ExternallyHostedApk *ExternallyHostedApk `json:"externallyHostedApk,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExternallyHostedApk")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternallyHostedApk") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ApksAddExternallyHostedResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ApksAddExternallyHostedResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ApksListResponse: Response listing all APKs.
type ApksListResponse struct {
	// Apks: All APKs.
	Apks []*Apk `json:"apks,omitempty"`

	// Kind: The kind of this response
	// ("androidpublisher#apksListResponse").
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Apks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Apks") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ApksListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ApksListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppDetails: The app details. The resource for DetailsService.
type AppDetails struct {
	// ContactEmail: The user-visible support email for this app.
	ContactEmail string `json:"contactEmail,omitempty"`

	// ContactPhone: The user-visible support telephone number for this app.
	ContactPhone string `json:"contactPhone,omitempty"`

	// ContactWebsite: The user-visible website for this app.
	ContactWebsite string `json:"contactWebsite,omitempty"`

	// DefaultLanguage: Default language code, in BCP 47 format (eg
	// "en-US").
	DefaultLanguage string `json:"defaultLanguage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContactEmail") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContactEmail") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AppDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppEdit: An app edit. The resource for EditsService.
type AppEdit struct {
	// ExpiryTimeSeconds: Output only. The time (as seconds since Epoch) at
	// which the edit will expire and will be no longer valid for use.
	ExpiryTimeSeconds string `json:"expiryTimeSeconds,omitempty"`

	// Id: Output only. Identifier of the edit. Can be used in subsequent
	// API calls.
	Id string `json:"id,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExpiryTimeSeconds")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpiryTimeSeconds") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppEdit) MarshalJSON() ([]byte, error) {
	type NoMethod AppEdit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppRecoveryAction: Information about an app recovery action.
type AppRecoveryAction struct {
	// AppRecoveryId: ID corresponding to the app recovery action.
	AppRecoveryId int64 `json:"appRecoveryId,omitempty,string"`

	// CancelTime: Timestamp of when the app recovery action is canceled by
	// the developer. Only set if the recovery action has been canceled.
	CancelTime string `json:"cancelTime,omitempty"`

	// CreateTime: Timestamp of when the app recovery action is created by
	// the developer. It is always set after creation of the recovery
	// action.
	CreateTime string `json:"createTime,omitempty"`

	// DeployTime: Timestamp of when the app recovery action is deployed to
	// the users. Only set if the recovery action has been deployed.
	DeployTime string `json:"deployTime,omitempty"`

	// LastUpdateTime: Timestamp of when the developer last updated recovery
	// action. In case the action is cancelled, it corresponds to
	// cancellation time. It is always set after creation of the recovery
	// action.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`

	// RemoteInAppUpdateData: Data about the remote in-app update action
	// such as such as recovered user base, recoverable user base etc. Set
	// only if the recovery action type is Remote In-App Update.
	RemoteInAppUpdateData *RemoteInAppUpdateData `json:"remoteInAppUpdateData,omitempty"`

	// Status: The status of the recovery action.
	//
	// Possible values:
	//   "RECOVERY_STATUS_UNSPECIFIED" - RecoveryStatus is unspecified.
	//   "RECOVERY_STATUS_ACTIVE" - The app recovery action has not been
	// canceled since it has been created.
	//   "RECOVERY_STATUS_CANCELED" - The recovery action has been canceled.
	// The action cannot be resumed.
	//   "RECOVERY_STATUS_DRAFT" - The recovery action is in the draft state
	// and has not yet been deployed to users.
	//   "RECOVERY_STATUS_GENERATION_IN_PROGRESS" - The recovery action is
	// generating recovery apks.
	//   "RECOVERY_STATUS_GENERATION_FAILED" - The app recovery action
	// generation has failed.
	Status string `json:"status,omitempty"`

	// Targeting: Specifies targeting criteria for the recovery action such
	// as regions, android sdk versions, app versions etc.
	Targeting *Targeting `json:"targeting,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AppRecoveryId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppRecoveryId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppRecoveryAction) MarshalJSON() ([]byte, error) {
	type NoMethod AppRecoveryAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppVersionList: Data format for a list of app versions.
type AppVersionList struct {
	// VersionCodes: List of app version codes.
	VersionCodes googleapi.Int64s `json:"versionCodes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "VersionCodes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "VersionCodes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppVersionList) MarshalJSON() ([]byte, error) {
	type NoMethod AppVersionList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppVersionRange: Data format for a continuous range of app versions.
type AppVersionRange struct {
	// VersionCodeEnd: Highest app version in the range, inclusive.
	VersionCodeEnd int64 `json:"versionCodeEnd,omitempty,string"`

	// VersionCodeStart: Lowest app version in the range, inclusive.
	VersionCodeStart int64 `json:"versionCodeStart,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "VersionCodeEnd") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "VersionCodeEnd") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppVersionRange) MarshalJSON() ([]byte, error) {
	type NoMethod AppVersionRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ArchiveSubscriptionRequest: Deprecated: subscription archiving is not
// supported.
type ArchiveSubscriptionRequest struct {
}

// AssetModuleMetadata: Metadata of an asset module.
type AssetModuleMetadata struct {
	// DeliveryType: Indicates the delivery type for persistent install.
	//
	// Possible values:
	//   "UNKNOWN_DELIVERY_TYPE" - Unspecified delivery type.
	//   "INSTALL_TIME" - This module will always be downloaded as part of
	// the initial install of the app.
	//   "ON_DEMAND" - This module is requested on-demand, which means it
	// will not be part of the initial install, and will only be sent when
	// requested by the client.
	//   "FAST_FOLLOW" - This module will be downloaded immediately after
	// initial install finishes. The app can be opened before these modules
	// are downloaded.
	DeliveryType string `json:"deliveryType,omitempty"`

	// Name: Module name.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeliveryType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeliveryType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssetModuleMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AssetModuleMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssetSliceSet: Set of asset slices belonging to a single asset
// module.
type AssetSliceSet struct {
	// ApkDescription: Asset slices.
	ApkDescription []*ApkDescription `json:"apkDescription,omitempty"`

	// AssetModuleMetadata: Module level metadata.
	AssetModuleMetadata *AssetModuleMetadata `json:"assetModuleMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApkDescription") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApkDescription") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssetSliceSet) MarshalJSON() ([]byte, error) {
	type NoMethod AssetSliceSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoRenewingBasePlanType: Represents a base plan that automatically
// renews at the end of its subscription period.
type AutoRenewingBasePlanType struct {
	// AccountHoldDuration: Optional. Account hold period of the
	// subscription, specified in ISO 8601 format. Acceptable values must be
	// in DAYS and in the range P0D (zero days) to P30D (30 days). If not
	// specified, the default value is P30D (30 days).
	AccountHoldDuration string `json:"accountHoldDuration,omitempty"`

	// BillingPeriodDuration: Required. Subscription period, specified in
	// ISO 8601 format. For a list of acceptable billing periods, refer to
	// the help center.
	BillingPeriodDuration string `json:"billingPeriodDuration,omitempty"`

	// GracePeriodDuration: Grace period of the subscription, specified in
	// ISO 8601 format. Acceptable values are P0D (zero days), P3D (3 days),
	// P7D (7 days), P14D (14 days), and P30D (30 days). If not specified, a
	// default value will be used based on the recurring period duration.
	GracePeriodDuration string `json:"gracePeriodDuration,omitempty"`

	// LegacyCompatible: Whether the renewing base plan is backward
	// compatible. The backward compatible base plan is returned by the
	// Google Play Billing Library deprecated method querySkuDetailsAsync().
	// Only one renewing base plan can be marked as legacy compatible for a
	// given subscription.
	LegacyCompatible bool `json:"legacyCompatible,omitempty"`

	// LegacyCompatibleSubscriptionOfferId: Subscription offer id which is
	// legacy compatible. The backward compatible subscription offer is
	// returned by the Google Play Billing Library deprecated method
	// querySkuDetailsAsync(). Only one subscription offer can be marked as
	// legacy compatible for a given renewing base plan. To have no
	// Subscription offer as legacy compatible set this field as empty
	// string.
	LegacyCompatibleSubscriptionOfferId string `json:"legacyCompatibleSubscriptionOfferId,omitempty"`

	// ProrationMode: The proration mode for the base plan determines what
	// happens when a user switches to this plan from another base plan. If
	// unspecified, defaults to CHARGE_ON_NEXT_BILLING_DATE.
	//
	// Possible values:
	//   "SUBSCRIPTION_PRORATION_MODE_UNSPECIFIED" - Unspecified mode.
	//   "SUBSCRIPTION_PRORATION_MODE_CHARGE_ON_NEXT_BILLING_DATE" - Users
	// will be charged for their new base plan at the end of their current
	// billing period.
	//   "SUBSCRIPTION_PRORATION_MODE_CHARGE_FULL_PRICE_IMMEDIATELY" - Users
	// will be charged for their new base plan immediately and in full. Any
	// remaining period of their existing subscription will be used to
	// extend the duration of the new billing plan.
	ProrationMode string `json:"prorationMode,omitempty"`

	// ResubscribeState: Whether users should be able to resubscribe to this
	// base plan in Google Play surfaces. Defaults to
	// RESUBSCRIBE_STATE_ACTIVE if not specified.
	//
	// Possible values:
	//   "RESUBSCRIBE_STATE_UNSPECIFIED" - Unspecified state.
	//   "RESUBSCRIBE_STATE_ACTIVE" - Resubscribe is active.
	//   "RESUBSCRIBE_STATE_INACTIVE" - Resubscribe is inactive.
	ResubscribeState string `json:"resubscribeState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountHoldDuration")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountHoldDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoRenewingBasePlanType) MarshalJSON() ([]byte, error) {
	type NoMethod AutoRenewingBasePlanType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoRenewingPlan: Information related to an auto renewing plan.
type AutoRenewingPlan struct {
	// AutoRenewEnabled: If the subscription is currently set to auto-renew,
	// e.g. the user has not canceled the subscription
	AutoRenewEnabled bool `json:"autoRenewEnabled,omitempty"`

	// PriceChangeDetails: The information of the last price change for the
	// item since subscription signup.
	PriceChangeDetails *SubscriptionItemPriceChangeDetails `json:"priceChangeDetails,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoRenewEnabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoRenewEnabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoRenewingPlan) MarshalJSON() ([]byte, error) {
	type NoMethod AutoRenewingPlan
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BasePlan: A single base plan for a subscription.
type BasePlan struct {
	// AutoRenewingBasePlanType: Set when the base plan automatically renews
	// at a regular interval.
	AutoRenewingBasePlanType *AutoRenewingBasePlanType `json:"autoRenewingBasePlanType,omitempty"`

	// BasePlanId: Required. Immutable. The unique identifier of this base
	// plan. Must be unique within the subscription, and conform with
	// RFC-1034. That is, this ID can only contain lower-case letters (a-z),
	// numbers (0-9), and hyphens (-), and be at most 63 characters.
	BasePlanId string `json:"basePlanId,omitempty"`

	// OfferTags: List of up to 20 custom tags specified for this base plan,
	// and returned to the app through the billing library. Subscription
	// offers for this base plan will also receive these offer tags in the
	// billing library.
	OfferTags []*OfferTag `json:"offerTags,omitempty"`

	// OtherRegionsConfig: Pricing information for any new locations Play
	// may launch in the future. If omitted, the BasePlan will not be
	// automatically available any new locations Play may launch in the
	// future.
	OtherRegionsConfig *OtherRegionsBasePlanConfig `json:"otherRegionsConfig,omitempty"`

	// PrepaidBasePlanType: Set when the base plan does not automatically
	// renew at the end of the billing period.
	PrepaidBasePlanType *PrepaidBasePlanType `json:"prepaidBasePlanType,omitempty"`

	// RegionalConfigs: Region-specific information for this base plan.
	RegionalConfigs []*RegionalBasePlanConfig `json:"regionalConfigs,omitempty"`

	// State: Output only. The state of the base plan, i.e. whether it's
	// active. Draft and inactive base plans can be activated or deleted.
	// Active base plans can be made inactive. Inactive base plans can be
	// canceled. This field cannot be changed by updating the resource. Use
	// the dedicated endpoints instead.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "DRAFT" - The base plan is currently in a draft state, and hasn't
	// been activated. It can be safely deleted at this point.
	//   "ACTIVE" - The base plan is active and available for new
	// subscribers.
	//   "INACTIVE" - The base plan is inactive and only available for
	// existing subscribers.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AutoRenewingBasePlanType") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoRenewingBasePlanType")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BasePlan) MarshalJSON() ([]byte, error) {
	type NoMethod BasePlan
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchGetSubscriptionOffersRequest: Request message for
// BatchGetSubscriptionOffers endpoint.
type BatchGetSubscriptionOffersRequest struct {
	// Requests: Required. A list of update requests of up to 100 elements.
	// All requests must update different subscriptions.
	Requests []*GetSubscriptionOfferRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchGetSubscriptionOffersRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchGetSubscriptionOffersRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchGetSubscriptionOffersResponse: Response message for
// BatchGetSubscriptionOffers endpoint.
type BatchGetSubscriptionOffersResponse struct {
	SubscriptionOffers []*SubscriptionOffer `json:"subscriptionOffers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "SubscriptionOffers")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SubscriptionOffers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BatchGetSubscriptionOffersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchGetSubscriptionOffersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchGetSubscriptionsResponse: Response message for
// BatchGetSubscriptions endpoint.
type BatchGetSubscriptionsResponse struct {
	// Subscriptions: The list of requested subscriptions, in the same order
	// as the request.
	Subscriptions []*Subscription `json:"subscriptions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Subscriptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Subscriptions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchGetSubscriptionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchGetSubscriptionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchMigrateBasePlanPricesRequest: Request message for
// BatchMigrateBasePlanPrices.
type BatchMigrateBasePlanPricesRequest struct {
	// Requests: Required. Up to 100 price migration requests. All requests
	// must update different base plans.
	Requests []*MigrateBasePlanPricesRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchMigrateBasePlanPricesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchMigrateBasePlanPricesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchMigrateBasePlanPricesResponse: Response message for
// BatchMigrateBasePlanPrices.
type BatchMigrateBasePlanPricesResponse struct {
	// Responses: Contains one response per requested price migration, in
	// the same order as the request.
	Responses []*MigrateBasePlanPricesResponse `json:"responses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Responses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Responses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchMigrateBasePlanPricesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchMigrateBasePlanPricesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchUpdateBasePlanStatesRequest: Request message for
// BatchUpdateBasePlanStates.
type BatchUpdateBasePlanStatesRequest struct {
	// Requests: Required. The update request list of up to 100 elements.
	// All requests must update different base plans.
	Requests []*UpdateBasePlanStateRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchUpdateBasePlanStatesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateBasePlanStatesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchUpdateBasePlanStatesResponse: Response message for
// BatchUpdateBasePlanStates.
type BatchUpdateBasePlanStatesResponse struct {
	// Subscriptions: The list of updated subscriptions. This list will
	// match the requests one to one, in the same order.
	Subscriptions []*Subscription `json:"subscriptions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Subscriptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Subscriptions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchUpdateBasePlanStatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateBasePlanStatesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchUpdateSubscriptionOfferStatesRequest: Request message for
// BatchUpdateSubscriptionOfferStates.
type BatchUpdateSubscriptionOfferStatesRequest struct {
	// Requests: Required. The update request list of up to 100 elements.
	// All requests must update different offers.
	Requests []*UpdateSubscriptionOfferStateRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchUpdateSubscriptionOfferStatesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateSubscriptionOfferStatesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchUpdateSubscriptionOfferStatesResponse: Response message for
// BatchUpdateSubscriptionOfferStates.
type BatchUpdateSubscriptionOfferStatesResponse struct {
	// SubscriptionOffers: The updated subscription offers list.
	SubscriptionOffers []*SubscriptionOffer `json:"subscriptionOffers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "SubscriptionOffers")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SubscriptionOffers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BatchUpdateSubscriptionOfferStatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateSubscriptionOfferStatesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchUpdateSubscriptionOffersRequest: Request message for
// BatchUpdateSubscriptionOffers.
type BatchUpdateSubscriptionOffersRequest struct {
	// Requests: Required. A list of update requests of up to 100 elements.
	// All requests must update different subscription offers.
	Requests []*UpdateSubscriptionOfferRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchUpdateSubscriptionOffersRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateSubscriptionOffersRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchUpdateSubscriptionOffersResponse: Response message for
// BatchUpdateSubscriptionOffers.
type BatchUpdateSubscriptionOffersResponse struct {
	// SubscriptionOffers: The updated subscription offers list.
	SubscriptionOffers []*SubscriptionOffer `json:"subscriptionOffers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "SubscriptionOffers")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SubscriptionOffers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BatchUpdateSubscriptionOffersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateSubscriptionOffersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchUpdateSubscriptionsRequest: Request message for
// BatchUpdateSubscription.
type BatchUpdateSubscriptionsRequest struct {
	// Requests: Required. A list of update requests of up to 100 elements.
	// All requests must update different subscriptions.
	Requests []*UpdateSubscriptionRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchUpdateSubscriptionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateSubscriptionsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchUpdateSubscriptionsResponse: Response message for
// BatchUpdateSubscription.
type BatchUpdateSubscriptionsResponse struct {
	// Subscriptions: The updated subscriptions list.
	Subscriptions []*Subscription `json:"subscriptions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Subscriptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Subscriptions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchUpdateSubscriptionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateSubscriptionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Bundle: Information about an app bundle. The resource for
// BundlesService.
type Bundle struct {
	// Sha1: A sha1 hash of the upload payload, encoded as a hex string and
	// matching the output of the sha1sum command.
	Sha1 string `json:"sha1,omitempty"`

	// Sha256: A sha256 hash of the upload payload, encoded as a hex string
	// and matching the output of the sha256sum command.
	Sha256 string `json:"sha256,omitempty"`

	// VersionCode: The version code of the Android App Bundle, as specified
	// in the Android App Bundle's base module APK manifest file.
	VersionCode int64 `json:"versionCode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Sha1") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Sha1") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Bundle) MarshalJSON() ([]byte, error) {
	type NoMethod Bundle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BundlesListResponse: Response listing all app bundles.
type BundlesListResponse struct {
	// Bundles: All app bundles.
	Bundles []*Bundle `json:"bundles,omitempty"`

	// Kind: The kind of this response
	// ("androidpublisher#bundlesListResponse").
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Bundles") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bundles") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BundlesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BundlesListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CancelAppRecoveryRequest: Request message for CancelAppRecovery.
type CancelAppRecoveryRequest struct {
}

// CancelAppRecoveryResponse: Response message for CancelAppRecovery.
type CancelAppRecoveryResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// CancelSurveyResult: Result of the cancel survey when the subscription
// was canceled by the user.
type CancelSurveyResult struct {
	// Reason: The reason the user selected in the cancel survey.
	//
	// Possible values:
	//   "CANCEL_SURVEY_REASON_UNSPECIFIED" - Unspecified cancel survey
	// reason.
	//   "CANCEL_SURVEY_REASON_NOT_ENOUGH_USAGE" - Not enough usage of the
	// subscription.
	//   "CANCEL_SURVEY_REASON_TECHNICAL_ISSUES" - Technical issues while
	// using the app.
	//   "CANCEL_SURVEY_REASON_COST_RELATED" - Cost related issues.
	//   "CANCEL_SURVEY_REASON_FOUND_BETTER_APP" - The user found a better
	// app.
	//   "CANCEL_SURVEY_REASON_OTHERS" - Other reasons.
	Reason string `json:"reason,omitempty"`

	// ReasonUserInput: Only set for CANCEL_SURVEY_REASON_OTHERS. This is
	// the user's freeform response to the survey.
	ReasonUserInput string `json:"reasonUserInput,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Reason") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Reason") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CancelSurveyResult) MarshalJSON() ([]byte, error) {
	type NoMethod CancelSurveyResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CanceledStateContext: Information specific to a subscription in
// canceled state.
type CanceledStateContext struct {
	// DeveloperInitiatedCancellation: Subscription was canceled by the
	// developer.
	DeveloperInitiatedCancellation *DeveloperInitiatedCancellation `json:"developerInitiatedCancellation,omitempty"`

	// ReplacementCancellation: Subscription was replaced by a new
	// subscription.
	ReplacementCancellation *ReplacementCancellation `json:"replacementCancellation,omitempty"`

	// SystemInitiatedCancellation: Subscription was canceled by the system,
	// for example because of a billing problem.
	SystemInitiatedCancellation *SystemInitiatedCancellation `json:"systemInitiatedCancellation,omitempty"`

	// UserInitiatedCancellation: Subscription was canceled by user.
	UserInitiatedCancellation *UserInitiatedCancellation `json:"userInitiatedCancellation,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DeveloperInitiatedCancellation") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "DeveloperInitiatedCancellation") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CanceledStateContext) MarshalJSON() ([]byte, error) {
	type NoMethod CanceledStateContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Comment: An entry of conversation between user and developer.
type Comment struct {
	// DeveloperComment: A comment from a developer.
	DeveloperComment *DeveloperComment `json:"developerComment,omitempty"`

	// UserComment: A comment from a user.
	UserComment *UserComment `json:"userComment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeveloperComment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeveloperComment") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Comment) MarshalJSON() ([]byte, error) {
	type NoMethod Comment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConvertRegionPricesRequest: Request message for ConvertRegionPrices.
type ConvertRegionPricesRequest struct {
	// Price: The intital price to convert other regions from. Tax
	// exclusive.
	Price *Money `json:"price,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Price") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Price") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConvertRegionPricesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ConvertRegionPricesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConvertRegionPricesResponse: Response message for
// ConvertRegionPrices.
type ConvertRegionPricesResponse struct {
	// ConvertedOtherRegionsPrice: Converted other regions prices in USD and
	// EUR, to use for countries where Play doesn't support a country's
	// local currency.
	ConvertedOtherRegionsPrice *ConvertedOtherRegionsPrice `json:"convertedOtherRegionsPrice,omitempty"`

	// ConvertedRegionPrices: Map from region code to converted region
	// price.
	ConvertedRegionPrices map[string]ConvertedRegionPrice `json:"convertedRegionPrices,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "ConvertedOtherRegionsPrice") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ConvertedOtherRegionsPrice") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConvertRegionPricesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ConvertRegionPricesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConvertedOtherRegionsPrice: Converted other regions prices.
type ConvertedOtherRegionsPrice struct {
	// EurPrice: Price in EUR to use for the "Other regions" location
	// exclusive of taxes.
	EurPrice *Money `json:"eurPrice,omitempty"`

	// UsdPrice: Price in USD to use for the "Other regions" location
	// exclusive of taxes.
	UsdPrice *Money `json:"usdPrice,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EurPrice") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EurPrice") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConvertedOtherRegionsPrice) MarshalJSON() ([]byte, error) {
	type NoMethod ConvertedOtherRegionsPrice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConvertedRegionPrice: A converted region price.
type ConvertedRegionPrice struct {
	// Price: The converted price tax inclusive.
	Price *Money `json:"price,omitempty"`

	// RegionCode: The region code of the region.
	RegionCode string `json:"regionCode,omitempty"`

	// TaxAmount: The tax amount of the converted price.
	TaxAmount *Money `json:"taxAmount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Price") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Price") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConvertedRegionPrice) MarshalJSON() ([]byte, error) {
	type NoMethod ConvertedRegionPrice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CountryTargeting: Country targeting specification.
type CountryTargeting struct {
	// Countries: Countries to target, specified as two letter CLDR codes
	// (https://unicode.org/cldr/charts/latest/supplemental/territory_containment_un_m_49.html).
	Countries []string `json:"countries,omitempty"`

	// IncludeRestOfWorld: Include "rest of world" as well as explicitly
	// targeted countries.
	IncludeRestOfWorld bool `json:"includeRestOfWorld,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Countries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Countries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CountryTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod CountryTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateDraftAppRecoveryRequest: Request message for
// CreateDraftAppRecovery.
type CreateDraftAppRecoveryRequest struct {
	// RemoteInAppUpdate: Action type is remote in-app update. As a
	// consequence of this action, a downloadable recovery module is also
	// created for testing purposes.
	RemoteInAppUpdate *RemoteInAppUpdate `json:"remoteInAppUpdate,omitempty"`

	// Targeting: Specifies targeting criteria for the recovery action such
	// as regions, android sdk versions, app versions etc.
	Targeting *Targeting `json:"targeting,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RemoteInAppUpdate")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RemoteInAppUpdate") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CreateDraftAppRecoveryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateDraftAppRecoveryRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeactivateBasePlanRequest: Request message for DeactivateBasePlan.
type DeactivateBasePlanRequest struct {
	// BasePlanId: Required. The unique base plan ID of the base plan to
	// deactivate.
	BasePlanId string `json:"basePlanId,omitempty"`

	// LatencyTolerance: Optional. The latency tolerance for the propagation
	// of this product update. Defaults to latency-sensitive.
	//
	// Possible values:
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
	// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
	// will propagate to clients within several minutes on average and up to
	// a few hours in rare cases. Throughput is limited to 7,200 updates per
	// app per hour.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
	// will propagate to clients within 24 hours. Supports high throughput
	// of up to 720,000 updates per app per hour using batch modification
	// methods.
	LatencyTolerance string `json:"latencyTolerance,omitempty"`

	// PackageName: Required. The parent app (package name) of the base plan
	// to deactivate.
	PackageName string `json:"packageName,omitempty"`

	// ProductId: Required. The parent subscription (ID) of the base plan to
	// deactivate.
	ProductId string `json:"productId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BasePlanId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BasePlanId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeactivateBasePlanRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeactivateBasePlanRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeactivateSubscriptionOfferRequest: Request message for
// DeactivateSubscriptionOffer.
type DeactivateSubscriptionOfferRequest struct {
	// BasePlanId: Required. The parent base plan (ID) of the offer to
	// deactivate.
	BasePlanId string `json:"basePlanId,omitempty"`

	// LatencyTolerance: Optional. The latency tolerance for the propagation
	// of this product update. Defaults to latency-sensitive.
	//
	// Possible values:
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
	// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
	// will propagate to clients within several minutes on average and up to
	// a few hours in rare cases. Throughput is limited to 7,200 updates per
	// app per hour.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
	// will propagate to clients within 24 hours. Supports high throughput
	// of up to 720,000 updates per app per hour using batch modification
	// methods.
	LatencyTolerance string `json:"latencyTolerance,omitempty"`

	// OfferId: Required. The unique offer ID of the offer to deactivate.
	OfferId string `json:"offerId,omitempty"`

	// PackageName: Required. The parent app (package name) of the offer to
	// deactivate.
	PackageName string `json:"packageName,omitempty"`

	// ProductId: Required. The parent subscription (ID) of the offer to
	// deactivate.
	ProductId string `json:"productId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BasePlanId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BasePlanId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeactivateSubscriptionOfferRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeactivateSubscriptionOfferRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeferredItemReplacement: Information related to deferred item
// replacement.
type DeferredItemReplacement struct {
	// ProductId: The product_id going to replace the existing product_id.
	ProductId string `json:"productId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProductId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProductId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeferredItemReplacement) MarshalJSON() ([]byte, error) {
	type NoMethod DeferredItemReplacement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeobfuscationFile: Represents a deobfuscation file.
type DeobfuscationFile struct {
	// SymbolType: The type of the deobfuscation file.
	//
	// Possible values:
	//   "deobfuscationFileTypeUnspecified" - Unspecified deobfuscation file
	// type.
	//   "proguard" - Proguard deobfuscation file type.
	//   "nativeCode" - Native debugging symbols file type.
	SymbolType string `json:"symbolType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SymbolType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SymbolType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeobfuscationFile) MarshalJSON() ([]byte, error) {
	type NoMethod DeobfuscationFile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeobfuscationFilesUploadResponse: Responses for the upload.
type DeobfuscationFilesUploadResponse struct {
	// DeobfuscationFile: The uploaded Deobfuscation File configuration.
	DeobfuscationFile *DeobfuscationFile `json:"deobfuscationFile,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DeobfuscationFile")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeobfuscationFile") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DeobfuscationFilesUploadResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DeobfuscationFilesUploadResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeployAppRecoveryRequest: Request message for DeployAppRecovery.
type DeployAppRecoveryRequest struct {
}

// DeployAppRecoveryResponse: Response message for DeployAppRecovery.
type DeployAppRecoveryResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// DeveloperComment: Developer entry from conversation between user and
// developer.
type DeveloperComment struct {
	// LastModified: The last time at which this comment was updated.
	LastModified *Timestamp `json:"lastModified,omitempty"`

	// Text: The content of the comment, i.e. reply body.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LastModified") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LastModified") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeveloperComment) MarshalJSON() ([]byte, error) {
	type NoMethod DeveloperComment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeveloperInitiatedCancellation: Information specific to cancellations
// initiated by developers.
type DeveloperInitiatedCancellation struct {
}

// DeviceFeature: Represents a device feature.
type DeviceFeature struct {
	// FeatureName: Name of the feature.
	FeatureName string `json:"featureName,omitempty"`

	// FeatureVersion: The feature version specified by android:glEsVersion
	// or android:version in in the AndroidManifest.
	FeatureVersion int64 `json:"featureVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FeatureName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeatureName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeviceFeature) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceFeature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceFeatureTargeting: Targeting for a device feature.
type DeviceFeatureTargeting struct {
	// RequiredFeature: Feature of the device.
	RequiredFeature *DeviceFeature `json:"requiredFeature,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RequiredFeature") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequiredFeature") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DeviceFeatureTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceFeatureTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceGroup: A group of devices. A group is defined by a set of
// device selectors. A device belongs to the group if it matches any
// selector (logical OR).
type DeviceGroup struct {
	// DeviceSelectors: Device selectors for this group. A device matching
	// any of the selectors is included in this group.
	DeviceSelectors []*DeviceSelector `json:"deviceSelectors,omitempty"`

	// Name: The name of the group.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceSelectors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceSelectors") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DeviceGroup) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceId: Identifier of a device.
type DeviceId struct {
	// BuildBrand: Value of Build.BRAND.
	BuildBrand string `json:"buildBrand,omitempty"`

	// BuildDevice: Value of Build.DEVICE.
	BuildDevice string `json:"buildDevice,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BuildBrand") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BuildBrand") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeviceId) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceMetadata: Characteristics of the user's device.
type DeviceMetadata struct {
	// CpuMake: Device CPU make, e.g. "Qualcomm"
	CpuMake string `json:"cpuMake,omitempty"`

	// CpuModel: Device CPU model, e.g. "MSM8974"
	CpuModel string `json:"cpuModel,omitempty"`

	// DeviceClass: Device class (e.g. tablet)
	DeviceClass string `json:"deviceClass,omitempty"`

	// GlEsVersion: OpenGL version
	GlEsVersion int64 `json:"glEsVersion,omitempty"`

	// Manufacturer: Device manufacturer (e.g. Motorola)
	Manufacturer string `json:"manufacturer,omitempty"`

	// NativePlatform: Comma separated list of native platforms (e.g. "arm",
	// "arm7")
	NativePlatform string `json:"nativePlatform,omitempty"`

	// ProductName: Device model name (e.g. Droid)
	ProductName string `json:"productName,omitempty"`

	// RamMb: Device RAM in Megabytes, e.g. "2048"
	RamMb int64 `json:"ramMb,omitempty"`

	// ScreenDensityDpi: Screen density in DPI
	ScreenDensityDpi int64 `json:"screenDensityDpi,omitempty"`

	// ScreenHeightPx: Screen height in pixels
	ScreenHeightPx int64 `json:"screenHeightPx,omitempty"`

	// ScreenWidthPx: Screen width in pixels
	ScreenWidthPx int64 `json:"screenWidthPx,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CpuMake") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpuMake") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeviceMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceRam: Conditions about a device's RAM capabilities.
type DeviceRam struct {
	// MaxBytes: Maximum RAM in bytes (bound excluded).
	MaxBytes int64 `json:"maxBytes,omitempty,string"`

	// MinBytes: Minimum RAM in bytes (bound included).
	MinBytes int64 `json:"minBytes,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "MaxBytes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxBytes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeviceRam) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceRam
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceSelector: Selector for a device group. A selector consists of a
// set of conditions on the device that should all match (logical AND)
// to determine a device group eligibility. For instance, if a selector
// specifies RAM conditions, device model inclusion and device model
// exclusion, a device is considered to match if: device matches RAM
// conditions AND device matches one of the included device models AND
// device doesn't match excluded device models
type DeviceSelector struct {
	// DeviceRam: Conditions on the device's RAM.
	DeviceRam *DeviceRam `json:"deviceRam,omitempty"`

	// ExcludedDeviceIds: Device models excluded by this selector, even if
	// they match all other conditions.
	ExcludedDeviceIds []*DeviceId `json:"excludedDeviceIds,omitempty"`

	// ForbiddenSystemFeatures: A device that has any of these system
	// features is excluded by this selector, even if it matches all other
	// conditions.
	ForbiddenSystemFeatures []*SystemFeature `json:"forbiddenSystemFeatures,omitempty"`

	// IncludedDeviceIds: Device models included by this selector.
	IncludedDeviceIds []*DeviceId `json:"includedDeviceIds,omitempty"`

	// RequiredSystemFeatures: A device needs to have all these system
	// features to be included by the selector.
	RequiredSystemFeatures []*SystemFeature `json:"requiredSystemFeatures,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceRam") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceRam") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeviceSelector) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceSelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceSpec: The device spec used to generate a system APK.
type DeviceSpec struct {
	// ScreenDensity: Screen dpi.
	ScreenDensity int64 `json:"screenDensity,omitempty"`

	// SupportedAbis: Supported ABI architectures in the order of
	// preference. The values should be the string as reported by the
	// platform, e.g. "armeabi-v7a", "x86_64".
	SupportedAbis []string `json:"supportedAbis,omitempty"`

	// SupportedLocales: All installed locales represented as BCP-47
	// strings, e.g. "en-US".
	SupportedLocales []string `json:"supportedLocales,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ScreenDensity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ScreenDensity") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeviceSpec) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceTier: A single device tier. Devices matching any of the device
// groups in device_group_names are considered to match the tier.
type DeviceTier struct {
	// DeviceGroupNames: Groups of devices included in this tier. These
	// groups must be defined explicitly under device_groups in this
	// configuration.
	DeviceGroupNames []string `json:"deviceGroupNames,omitempty"`

	// Level: The priority level of the tier. Tiers are evaluated in
	// descending order of level: the highest level tier has the highest
	// priority. The highest tier matching a given device is selected for
	// that device. You should use a contiguous range of levels for your
	// tiers in a tier set; tier levels in a tier set must be unique. For
	// instance, if your tier set has 4 tiers (including the global
	// fallback), you should define tiers 1, 2 and 3 in this configuration.
	// Note: tier 0 is implicitly defined as a global fallback and selected
	// for devices that don't match any of the tiers explicitly defined
	// here. You mustn't define level 0 explicitly in this configuration.
	Level int64 `json:"level,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceGroupNames") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceGroupNames") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DeviceTier) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceTier
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceTierConfig: Configuration describing device targeting criteria
// for the content of an app.
type DeviceTierConfig struct {
	// DeviceGroups: Definition of device groups for the app.
	DeviceGroups []*DeviceGroup `json:"deviceGroups,omitempty"`

	// DeviceTierConfigId: Output only. The device tier config ID.
	DeviceTierConfigId int64 `json:"deviceTierConfigId,omitempty,string"`

	// DeviceTierSet: Definition of the set of device tiers for the app.
	DeviceTierSet *DeviceTierSet `json:"deviceTierSet,omitempty"`

	// UserCountrySets: Definition of user country sets for the app.
	UserCountrySets []*UserCountrySet `json:"userCountrySets,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DeviceGroups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceGroups") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeviceTierConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceTierConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceTierSet: A set of device tiers. A tier set determines what
// variation of app content gets served to a specific device, for
// device-targeted content. You should assign a priority level to each
// tier, which determines the ordering by which they are evaluated by
// Play. See the documentation of DeviceTier.level for more details.
type DeviceTierSet struct {
	// DeviceTiers: Device tiers belonging to the set.
	DeviceTiers []*DeviceTier `json:"deviceTiers,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceTiers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceTiers") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeviceTierSet) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceTierSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExpansionFile: An expansion file. The resource for
// ExpansionFilesService.
type ExpansionFile struct {
	// FileSize: If set, this field indicates that this APK has an expansion
	// file uploaded to it: this APK does not reference another APK's
	// expansion file. The field's value is the size of the uploaded
	// expansion file in bytes.
	FileSize int64 `json:"fileSize,omitempty,string"`

	// ReferencesVersion: If set, this APK's expansion file references
	// another APK's expansion file. The file_size field will not be set.
	ReferencesVersion int64 `json:"referencesVersion,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FileSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileSize") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExpansionFile) MarshalJSON() ([]byte, error) {
	type NoMethod ExpansionFile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExpansionFilesUploadResponse: Response for uploading an expansion
// file.
type ExpansionFilesUploadResponse struct {
	// ExpansionFile: The uploaded expansion file configuration.
	ExpansionFile *ExpansionFile `json:"expansionFile,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExpansionFile") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpansionFile") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExpansionFilesUploadResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExpansionFilesUploadResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalAccountIdentifiers: User account identifier in the
// third-party service.
type ExternalAccountIdentifiers struct {
	// ExternalAccountId: User account identifier in the third-party
	// service. Only present if account linking happened as part of the
	// subscription purchase flow.
	ExternalAccountId string `json:"externalAccountId,omitempty"`

	// ObfuscatedExternalAccountId: An obfuscated version of the id that is
	// uniquely associated with the user's account in your app. Present for
	// the following purchases: * If account linking happened as part of the
	// subscription purchase flow. * It was specified using
	// https://developer.android.com/reference/com/android/billingclient/api/BillingFlowParams.Builder#setobfuscatedaccountid
	// when the purchase was made.
	ObfuscatedExternalAccountId string `json:"obfuscatedExternalAccountId,omitempty"`

	// ObfuscatedExternalProfileId: An obfuscated version of the id that is
	// uniquely associated with the user's profile in your app. Only present
	// if specified using
	// https://developer.android.com/reference/com/android/billingclient/api/BillingFlowParams.Builder#setobfuscatedprofileid
	// when the purchase was made.
	ObfuscatedExternalProfileId string `json:"obfuscatedExternalProfileId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExternalAccountId")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternalAccountId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ExternalAccountIdentifiers) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalAccountIdentifiers
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalSubscription: Details of an external subscription.
type ExternalSubscription struct {
	// SubscriptionType: Required. The type of the external subscription.
	//
	// Possible values:
	//   "SUBSCRIPTION_TYPE_UNSPECIFIED" - Unspecified, do not use.
	//   "RECURRING" - This is a recurring subscription where the user is
	// charged every billing cycle.
	//   "PREPAID" - This is a prepaid subscription where the user pays up
	// front.
	SubscriptionType string `json:"subscriptionType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SubscriptionType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SubscriptionType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ExternalSubscription) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalSubscription
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalTransaction: The details of an external transaction.
type ExternalTransaction struct {
	// CreateTime: Output only. The time when this transaction was created.
	// This is the time when Google was notified of the transaction.
	CreateTime string `json:"createTime,omitempty"`

	// CurrentPreTaxAmount: Output only. The current transaction amount
	// before tax. This represents the current pre-tax amount including any
	// refunds that may have been applied to this transaction.
	CurrentPreTaxAmount *Price `json:"currentPreTaxAmount,omitempty"`

	// CurrentTaxAmount: Output only. The current tax amount. This
	// represents the current tax amount including any refunds that may have
	// been applied to this transaction.
	CurrentTaxAmount *Price `json:"currentTaxAmount,omitempty"`

	// ExternalTransactionId: Output only. The id of this transaction. All
	// transaction ids under the same package name must be unique. Set when
	// creating the external transaction.
	ExternalTransactionId string `json:"externalTransactionId,omitempty"`

	// OneTimeTransaction: This is a one-time transaction and not part of a
	// subscription.
	OneTimeTransaction *OneTimeExternalTransaction `json:"oneTimeTransaction,omitempty"`

	// OriginalPreTaxAmount: Required. The original transaction amount
	// before taxes. This represents the pre-tax amount originally notified
	// to Google before any refunds were applied.
	OriginalPreTaxAmount *Price `json:"originalPreTaxAmount,omitempty"`

	// OriginalTaxAmount: Required. The original tax amount. This represents
	// the tax amount originally notified to Google before any refunds were
	// applied.
	OriginalTaxAmount *Price `json:"originalTaxAmount,omitempty"`

	// PackageName: Output only. The resource name of the external
	// transaction. The package name of the application the inapp products
	// were sold (for example, 'com.some.app').
	PackageName string `json:"packageName,omitempty"`

	// RecurringTransaction: This transaction is part of a recurring series
	// of transactions.
	RecurringTransaction *RecurringExternalTransaction `json:"recurringTransaction,omitempty"`

	// TestPurchase: Output only. If set, this transaction was a test
	// purchase. Google will not charge for a test transaction.
	TestPurchase *ExternalTransactionTestPurchase `json:"testPurchase,omitempty"`

	// TransactionState: Output only. The current state of the transaction.
	//
	// Possible values:
	//   "TRANSACTION_STATE_UNSPECIFIED" - Unspecified transaction state.
	// Not used.
	//   "TRANSACTION_REPORTED" - The transaction has been successfully
	// reported to Google.
	//   "TRANSACTION_CANCELED" - The transaction has been fully refunded.
	TransactionState string `json:"transactionState,omitempty"`

	// TransactionTime: Required. The time when the transaction was
	// completed.
	TransactionTime string `json:"transactionTime,omitempty"`

	// UserTaxAddress: Required. User address for tax computation.
	UserTaxAddress *ExternalTransactionAddress `json:"userTaxAddress,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExternalTransaction) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalTransaction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalTransactionAddress: User's address for the external
// transaction.
type ExternalTransactionAddress struct {
	// AdministrativeArea: Optional. Top-level administrative subdivision of
	// the country/region. Only required for transactions in India. Valid
	// values are "ANDAMAN AND NICOBAR ISLANDS", "ANDHRA PRADESH",
	// "ARUNACHAL PRADESH", "ASSAM", "BIHAR", "CHANDIGARH", "CHHATTISGARH",
	// "DADRA AND NAGAR HAVELI", "DADRA AND NAGAR HAVELI AND DAMAN AND DIU",
	// "DAMAN AND DIU", "DELHI", "GOA", "GUJARAT", "HARYANA", "HIMACHAL
	// PRADESH", "JAMMU AND KASHMIR", "JHARKHAND", "KARNATAKA", "KERALA",
	// "LADAKH", "LAKSHADWEEP", "MADHYA PRADESH", "MAHARASHTRA", "MANIPUR",
	// "MEGHALAYA", "MIZORAM", "NAGALAND", "ODISHA", "PUDUCHERRY", "PUNJAB",
	// "RAJASTHAN", "SIKKIM", "TAMIL NADU", "TELANGANA", "TRIPURA", "UTTAR
	// PRADESH", "UTTARAKHAND", and "WEST BENGAL".
	AdministrativeArea string `json:"administrativeArea,omitempty"`

	// RegionCode: Required. Two letter region code based on ISO-3166-1
	// Alpha-2 (UN region codes).
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdministrativeArea")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdministrativeArea") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ExternalTransactionAddress) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalTransactionAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalTransactionTestPurchase: Represents a transaction performed
// using a test account. These transactions will not be charged by
// Google.
type ExternalTransactionTestPurchase struct {
}

// ExternallyHostedApk: Defines an APK available for this application
// that is hosted externally and not uploaded to Google Play. This
// function is only available to organizations using Managed Play whose
// application is configured to restrict distribution to the
// organizations.
type ExternallyHostedApk struct {
	// ApplicationLabel: The application label.
	ApplicationLabel string `json:"applicationLabel,omitempty"`

	// CertificateBase64s: A certificate (or array of certificates if a
	// certificate-chain is used) used to sign this APK, represented as a
	// base64 encoded byte array.
	CertificateBase64s []string `json:"certificateBase64s,omitempty"`

	// ExternallyHostedUrl: The URL at which the APK is hosted. This must be
	// an https URL.
	ExternallyHostedUrl string `json:"externallyHostedUrl,omitempty"`

	// FileSha1Base64: The sha1 checksum of this APK, represented as a
	// base64 encoded byte array.
	FileSha1Base64 string `json:"fileSha1Base64,omitempty"`

	// FileSha256Base64: The sha256 checksum of this APK, represented as a
	// base64 encoded byte array.
	FileSha256Base64 string `json:"fileSha256Base64,omitempty"`

	// FileSize: The file size in bytes of this APK.
	FileSize int64 `json:"fileSize,omitempty,string"`

	// IconBase64: The icon image from the APK, as a base64 encoded byte
	// array.
	IconBase64 string `json:"iconBase64,omitempty"`

	// MaximumSdk: The maximum SDK supported by this APK (optional).
	MaximumSdk int64 `json:"maximumSdk,omitempty"`

	// MinimumSdk: The minimum SDK targeted by this APK.
	MinimumSdk int64 `json:"minimumSdk,omitempty"`

	// NativeCodes: The native code environments supported by this APK
	// (optional).
	NativeCodes []string `json:"nativeCodes,omitempty"`

	// PackageName: The package name.
	PackageName string `json:"packageName,omitempty"`

	// UsesFeatures: The features required by this APK (optional).
	UsesFeatures []string `json:"usesFeatures,omitempty"`

	// UsesPermissions: The permissions requested by this APK.
	UsesPermissions []*UsesPermission `json:"usesPermissions,omitempty"`

	// VersionCode: The version code of this APK.
	VersionCode int64 `json:"versionCode,omitempty"`

	// VersionName: The version name of this APK.
	VersionName string `json:"versionName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApplicationLabel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApplicationLabel") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ExternallyHostedApk) MarshalJSON() ([]byte, error) {
	type NoMethod ExternallyHostedApk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FullRefund: A full refund of the remaining amount of a transaction.
type FullRefund struct {
}

// GeneratedApksListResponse: Response to list generated APKs.
type GeneratedApksListResponse struct {
	// GeneratedApks: All generated APKs, grouped by the APK signing key.
	GeneratedApks []*GeneratedApksPerSigningKey `json:"generatedApks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "GeneratedApks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GeneratedApks") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GeneratedApksListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GeneratedApksListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GeneratedApksPerSigningKey: Download metadata for split, standalone
// and universal APKs, as well as asset pack slices, signed with a given
// key.
type GeneratedApksPerSigningKey struct {
	// CertificateSha256Hash: SHA256 hash of the APK signing public key
	// certificate.
	CertificateSha256Hash string `json:"certificateSha256Hash,omitempty"`

	// GeneratedAssetPackSlices: List of asset pack slices which will be
	// served for this app bundle, signed with a key corresponding to
	// certificate_sha256_hash.
	GeneratedAssetPackSlices []*GeneratedAssetPackSlice `json:"generatedAssetPackSlices,omitempty"`

	// GeneratedRecoveryModules: Generated recovery apks for recovery
	// actions signed with a key corresponding to certificate_sha256_hash.
	// This includes all generated recovery APKs, also those in draft or
	// cancelled state. This field is not set if no recovery actions were
	// created for this signing key.
	GeneratedRecoveryModules []*GeneratedRecoveryApk `json:"generatedRecoveryModules,omitempty"`

	// GeneratedSplitApks: List of generated split APKs, signed with a key
	// corresponding to certificate_sha256_hash.
	GeneratedSplitApks []*GeneratedSplitApk `json:"generatedSplitApks,omitempty"`

	// GeneratedStandaloneApks: List of generated standalone APKs, signed
	// with a key corresponding to certificate_sha256_hash.
	GeneratedStandaloneApks []*GeneratedStandaloneApk `json:"generatedStandaloneApks,omitempty"`

	// GeneratedUniversalApk: Generated universal APK, signed with a key
	// corresponding to certificate_sha256_hash. This field is not set if no
	// universal APK was generated for this signing key.
	GeneratedUniversalApk *GeneratedUniversalApk `json:"generatedUniversalApk,omitempty"`

	// TargetingInfo: Contains targeting information about the generated
	// apks.
	TargetingInfo *TargetingInfo `json:"targetingInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CertificateSha256Hash") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CertificateSha256Hash") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GeneratedApksPerSigningKey) MarshalJSON() ([]byte, error) {
	type NoMethod GeneratedApksPerSigningKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GeneratedAssetPackSlice: Download metadata for an asset pack slice.
type GeneratedAssetPackSlice struct {
	// DownloadId: Download ID, which uniquely identifies the APK to
	// download. Should be supplied to `generatedapks.download` method.
	DownloadId string `json:"downloadId,omitempty"`

	// ModuleName: Name of the module that this asset slice belongs to.
	ModuleName string `json:"moduleName,omitempty"`

	// SliceId: Asset slice ID.
	SliceId string `json:"sliceId,omitempty"`

	// Version: Asset module version.
	Version int64 `json:"version,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DownloadId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DownloadId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GeneratedAssetPackSlice) MarshalJSON() ([]byte, error) {
	type NoMethod GeneratedAssetPackSlice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GeneratedRecoveryApk: Download metadata for an app recovery module.
type GeneratedRecoveryApk struct {
	// DownloadId: Download ID, which uniquely identifies the APK to
	// download. Should be supplied to `generatedapks.download` method.
	DownloadId string `json:"downloadId,omitempty"`

	// ModuleName: Name of the module which recovery apk belongs to.
	ModuleName string `json:"moduleName,omitempty"`

	// RecoveryId: ID of the recovery action.
	RecoveryId int64 `json:"recoveryId,omitempty,string"`

	// RecoveryStatus: The status of the recovery action corresponding to
	// the recovery apk.
	//
	// Possible values:
	//   "RECOVERY_STATUS_UNSPECIFIED" - RecoveryStatus is unspecified.
	//   "RECOVERY_STATUS_ACTIVE" - The app recovery action has not been
	// canceled since it has been created.
	//   "RECOVERY_STATUS_CANCELED" - The recovery action has been canceled.
	// The action cannot be resumed.
	//   "RECOVERY_STATUS_DRAFT" - The recovery action is in the draft state
	// and has not yet been deployed to users.
	//   "RECOVERY_STATUS_GENERATION_IN_PROGRESS" - The recovery action is
	// generating recovery apks.
	//   "RECOVERY_STATUS_GENERATION_FAILED" - The app recovery action
	// generation has failed.
	RecoveryStatus string `json:"recoveryStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DownloadId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DownloadId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GeneratedRecoveryApk) MarshalJSON() ([]byte, error) {
	type NoMethod GeneratedRecoveryApk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GeneratedSplitApk: Download metadata for a split APK.
type GeneratedSplitApk struct {
	// DownloadId: Download ID, which uniquely identifies the APK to
	// download. Should be supplied to `generatedapks.download` method.
	DownloadId string `json:"downloadId,omitempty"`

	// ModuleName: Name of the module that this APK belongs to.
	ModuleName string `json:"moduleName,omitempty"`

	// SplitId: Split ID. Empty for the main split of the base module.
	SplitId string `json:"splitId,omitempty"`

	// VariantId: ID of the generated variant.
	VariantId int64 `json:"variantId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DownloadId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DownloadId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GeneratedSplitApk) MarshalJSON() ([]byte, error) {
	type NoMethod GeneratedSplitApk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GeneratedStandaloneApk: Download metadata for a standalone APK.
type GeneratedStandaloneApk struct {
	// DownloadId: Download ID, which uniquely identifies the APK to
	// download. Should be supplied to `generatedapks.download` method.
	DownloadId string `json:"downloadId,omitempty"`

	// VariantId: ID of the generated variant.
	VariantId int64 `json:"variantId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DownloadId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DownloadId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GeneratedStandaloneApk) MarshalJSON() ([]byte, error) {
	type NoMethod GeneratedStandaloneApk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GeneratedUniversalApk: Download metadata for a universal APK.
type GeneratedUniversalApk struct {
	// DownloadId: Download ID, which uniquely identifies the APK to
	// download. Should be supplied to `generatedapks.download` method.
	DownloadId string `json:"downloadId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DownloadId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DownloadId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GeneratedUniversalApk) MarshalJSON() ([]byte, error) {
	type NoMethod GeneratedUniversalApk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GetSubscriptionOfferRequest: Request message for
// GetSubscriptionOffer.
type GetSubscriptionOfferRequest struct {
	// BasePlanId: Required. The parent base plan (ID) of the offer to get.
	BasePlanId string `json:"basePlanId,omitempty"`

	// OfferId: Required. The unique offer ID of the offer to get.
	OfferId string `json:"offerId,omitempty"`

	// PackageName: Required. The parent app (package name) of the offer to
	// get.
	PackageName string `json:"packageName,omitempty"`

	// ProductId: Required. The parent subscription (ID) of the offer to
	// get.
	ProductId string `json:"productId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BasePlanId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BasePlanId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetSubscriptionOfferRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GetSubscriptionOfferRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Grant: An access grant resource.
type Grant struct {
	// AppLevelPermissions: The permissions granted to the user for this
	// app.
	//
	// Possible values:
	//   "APP_LEVEL_PERMISSION_UNSPECIFIED" - Unknown or unspecified
	// permission.
	//   "CAN_ACCESS_APP" - View app information (read-only). Deprecated:
	// Try defining a more granular capability. Otherwise, check
	// AppLevelPermission.CAN_VIEW_NON_FINANCIAL_DATA.
	//   "CAN_VIEW_FINANCIAL_DATA" - View financial data.
	//   "CAN_MANAGE_PERMISSIONS" - Admin (all permissions).
	//   "CAN_REPLY_TO_REVIEWS" - Reply to reviews.
	//   "CAN_MANAGE_PUBLIC_APKS" - Release to production, exclude devices,
	// and use app signing by Google Play.
	//   "CAN_MANAGE_TRACK_APKS" - Release to testing tracks.
	//   "CAN_MANAGE_TRACK_USERS" - Manage testing tracks and edit tester
	// lists.
	//   "CAN_MANAGE_PUBLIC_LISTING" - Manage store presence.
	//   "CAN_MANAGE_DRAFT_APPS" - Edit and delete draft apps.
	//   "CAN_MANAGE_ORDERS" - Manage orders and subscriptions.
	//   "CAN_MANAGE_APP_CONTENT" - Manage policy related pages.
	//   "CAN_VIEW_NON_FINANCIAL_DATA" - View app information (read-only).
	//   "CAN_VIEW_APP_QUALITY" - View app quality data such as Vitals,
	// Crashes etc.
	AppLevelPermissions []string `json:"appLevelPermissions,omitempty"`

	// Name: Required. Resource name for this grant, following the pattern
	// "developers/{developer}/users/{email}/grants/{package_name}". If this
	// grant is for a draft app, the app ID will be used in this resource
	// name instead of the package name.
	Name string `json:"name,omitempty"`

	// PackageName: Immutable. The package name of the app. This will be
	// empty for draft apps.
	PackageName string `json:"packageName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AppLevelPermissions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppLevelPermissions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Grant) MarshalJSON() ([]byte, error) {
	type NoMethod Grant
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Image: An uploaded image. The resource for ImagesService.
type Image struct {
	// Id: A unique id representing this image.
	Id string `json:"id,omitempty"`

	// Sha1: A sha1 hash of the image.
	Sha1 string `json:"sha1,omitempty"`

	// Sha256: A sha256 hash of the image.
	Sha256 string `json:"sha256,omitempty"`

	// Url: A URL that will serve a preview of the image.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Image) MarshalJSON() ([]byte, error) {
	type NoMethod Image
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImagesDeleteAllResponse: Response for deleting all images.
type ImagesDeleteAllResponse struct {
	// Deleted: The deleted images.
	Deleted []*Image `json:"deleted,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Deleted") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Deleted") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImagesDeleteAllResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ImagesDeleteAllResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImagesListResponse: Response listing all images.
type ImagesListResponse struct {
	// Images: All listed Images.
	Images []*Image `json:"images,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Images") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Images") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImagesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ImagesListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImagesUploadResponse: Response for uploading an image.
type ImagesUploadResponse struct {
	// Image: The uploaded image.
	Image *Image `json:"image,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Image") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImagesUploadResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ImagesUploadResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InAppProduct: An in-app product. The resource for
// InappproductsService.
type InAppProduct struct {
	// DefaultLanguage: Default language of the localized data, as defined
	// by BCP-47. e.g. "en-US".
	DefaultLanguage string `json:"defaultLanguage,omitempty"`

	// DefaultPrice: Default price. Cannot be zero, as in-app products are
	// never free. Always in the developer's Checkout merchant currency.
	DefaultPrice *Price `json:"defaultPrice,omitempty"`

	// GracePeriod: Grace period of the subscription, specified in ISO 8601
	// format. Allows developers to give their subscribers a grace period
	// when the payment for the new recurrence period is declined.
	// Acceptable values are P0D (zero days), P3D (three days), P7D (seven
	// days), P14D (14 days), and P30D (30 days).
	GracePeriod string `json:"gracePeriod,omitempty"`

	// Listings: List of localized title and description data. Map key is
	// the language of the localized data, as defined by BCP-47, e.g.
	// "en-US".
	Listings map[string]InAppProductListing `json:"listings,omitempty"`

	// ManagedProductTaxesAndComplianceSettings: Details about taxes and
	// legal compliance. Only applicable to managed products.
	ManagedProductTaxesAndComplianceSettings *ManagedProductTaxAndComplianceSettings `json:"managedProductTaxesAndComplianceSettings,omitempty"`

	// PackageName: Package name of the parent app.
	PackageName string `json:"packageName,omitempty"`

	// Prices: Prices per buyer region. None of these can be zero, as in-app
	// products are never free. Map key is region code, as defined by ISO
	// 3166-2.
	Prices map[string]Price `json:"prices,omitempty"`

	// PurchaseType: The type of the product, e.g. a recurring subscription.
	//
	// Possible values:
	//   "purchaseTypeUnspecified" - Unspecified purchase type.
	//   "managedUser" - The default product type - one time purchase.
	//   "subscription" - In-app product with a recurring period.
	PurchaseType string `json:"purchaseType,omitempty"`

	// Sku: Stock-keeping-unit (SKU) of the product, unique within an app.
	Sku string `json:"sku,omitempty"`

	// Status: The status of the product, e.g. whether it's active.
	//
	// Possible values:
	//   "statusUnspecified" - Unspecified status.
	//   "active" - The product is published and active in the store.
	//   "inactive" - The product is not published and therefore inactive in
	// the store.
	Status string `json:"status,omitempty"`

	// SubscriptionPeriod: Subscription period, specified in ISO 8601
	// format. Acceptable values are P1W (one week), P1M (one month), P3M
	// (three months), P6M (six months), and P1Y (one year).
	SubscriptionPeriod string `json:"subscriptionPeriod,omitempty"`

	// SubscriptionTaxesAndComplianceSettings: Details about taxes and legal
	// compliance. Only applicable to subscription products.
	SubscriptionTaxesAndComplianceSettings *SubscriptionTaxAndComplianceSettings `json:"subscriptionTaxesAndComplianceSettings,omitempty"`

	// TrialPeriod: Trial period, specified in ISO 8601 format. Acceptable
	// values are anything between P7D (seven days) and P999D (999 days).
	TrialPeriod string `json:"trialPeriod,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DefaultLanguage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultLanguage") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InAppProduct) MarshalJSON() ([]byte, error) {
	type NoMethod InAppProduct
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InAppProductListing: Store listing of a single in-app product.
type InAppProductListing struct {
	// Benefits: Localized entitlement benefits for a subscription.
	Benefits []string `json:"benefits,omitempty"`

	// Description: Description for the store listing.
	Description string `json:"description,omitempty"`

	// Title: Title for the store listing.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Benefits") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Benefits") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InAppProductListing) MarshalJSON() ([]byte, error) {
	type NoMethod InAppProductListing
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InappproductsBatchDeleteRequest: Request to delete multiple in-app
// products.
type InappproductsBatchDeleteRequest struct {
	// Requests: Individual delete requests. At least one request is
	// required. Can contain up to 100 requests. All requests must
	// correspond to different in-app products.
	Requests []*InappproductsDeleteRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InappproductsBatchDeleteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InappproductsBatchDeleteRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InappproductsBatchGetResponse: Response message for
// BatchGetSubscriptions endpoint.
type InappproductsBatchGetResponse struct {
	// Inappproduct: The list of requested in-app products, in the same
	// order as the request.
	Inappproduct []*InAppProduct `json:"inappproduct,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Inappproduct") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Inappproduct") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InappproductsBatchGetResponse) MarshalJSON() ([]byte, error) {
	type NoMethod InappproductsBatchGetResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InappproductsBatchUpdateRequest: Request to update or insert one or
// more in-app products.
type InappproductsBatchUpdateRequest struct {
	// Requests: Required. Individual update requests. At least one request
	// is required. Can contain up to 100 requests. All requests must
	// correspond to different in-app products.
	Requests []*InappproductsUpdateRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InappproductsBatchUpdateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InappproductsBatchUpdateRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InappproductsBatchUpdateResponse: Response for a batch in-app product
// update.
type InappproductsBatchUpdateResponse struct {
	// Inappproducts: The updated or inserted in-app products.
	Inappproducts []*InAppProduct `json:"inappproducts,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Inappproducts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Inappproducts") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InappproductsBatchUpdateResponse) MarshalJSON() ([]byte, error) {
	type NoMethod InappproductsBatchUpdateResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InappproductsDeleteRequest: Request to delete an in-app product.
type InappproductsDeleteRequest struct {
	// LatencyTolerance: Optional. The latency tolerance for the propagation
	// of this product update. Defaults to latency-sensitive.
	//
	// Possible values:
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
	// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
	// will propagate to clients within several minutes on average and up to
	// a few hours in rare cases. Throughput is limited to 7,200 updates per
	// app per hour.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
	// will propagate to clients within 24 hours. Supports high throughput
	// of up to 720,000 updates per app per hour using batch modification
	// methods.
	LatencyTolerance string `json:"latencyTolerance,omitempty"`

	// PackageName: Package name of the app.
	PackageName string `json:"packageName,omitempty"`

	// Sku: Unique identifier for the in-app product.
	Sku string `json:"sku,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LatencyTolerance") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LatencyTolerance") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InappproductsDeleteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InappproductsDeleteRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InappproductsListResponse: Response listing all in-app products.
type InappproductsListResponse struct {
	// Inappproduct: All in-app products.
	Inappproduct []*InAppProduct `json:"inappproduct,omitempty"`

	// Kind: The kind of this response
	// ("androidpublisher#inappproductsListResponse").
	Kind string `json:"kind,omitempty"`

	// PageInfo: Deprecated and unset.
	PageInfo *PageInfo `json:"pageInfo,omitempty"`

	// TokenPagination: Pagination token, to handle a number of products
	// that is over one page.
	TokenPagination *TokenPagination `json:"tokenPagination,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Inappproduct") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Inappproduct") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InappproductsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod InappproductsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InappproductsUpdateRequest: Request to update an in-app product.
type InappproductsUpdateRequest struct {
	// AllowMissing: If set to true, and the in-app product with the given
	// package_name and sku doesn't exist, the in-app product will be
	// created.
	AllowMissing bool `json:"allowMissing,omitempty"`

	// AutoConvertMissingPrices: If true the prices for all regions targeted
	// by the parent app that don't have a price specified for this in-app
	// product will be auto converted to the target currency based on the
	// default price. Defaults to false.
	AutoConvertMissingPrices bool `json:"autoConvertMissingPrices,omitempty"`

	// Inappproduct: The new in-app product.
	Inappproduct *InAppProduct `json:"inappproduct,omitempty"`

	// LatencyTolerance: Optional. The latency tolerance for the propagation
	// of this product update. Defaults to latency-sensitive.
	//
	// Possible values:
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
	// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
	// will propagate to clients within several minutes on average and up to
	// a few hours in rare cases. Throughput is limited to 7,200 updates per
	// app per hour.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
	// will propagate to clients within 24 hours. Supports high throughput
	// of up to 720,000 updates per app per hour using batch modification
	// methods.
	LatencyTolerance string `json:"latencyTolerance,omitempty"`

	// PackageName: Package name of the app.
	PackageName string `json:"packageName,omitempty"`

	// Sku: Unique identifier for the in-app product.
	Sku string `json:"sku,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowMissing") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InappproductsUpdateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InappproductsUpdateRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InternalAppSharingArtifact: An artifact resource which gets created
// when uploading an APK or Android App Bundle through internal app
// sharing.
type InternalAppSharingArtifact struct {
	// CertificateFingerprint: The sha256 fingerprint of the certificate
	// used to sign the generated artifact.
	CertificateFingerprint string `json:"certificateFingerprint,omitempty"`

	// DownloadUrl: The download URL generated for the uploaded artifact.
	// Users that are authorized to download can follow the link to the Play
	// Store app to install it.
	DownloadUrl string `json:"downloadUrl,omitempty"`

	// Sha256: The sha256 hash of the artifact represented as a lowercase
	// hexadecimal number, matching the output of the sha256sum command.
	Sha256 string `json:"sha256,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "CertificateFingerprint") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CertificateFingerprint")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InternalAppSharingArtifact) MarshalJSON() ([]byte, error) {
	type NoMethod InternalAppSharingArtifact
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IntroductoryPriceInfo: Contains the introductory price information
// for a subscription.
type IntroductoryPriceInfo struct {
	// IntroductoryPriceAmountMicros: Introductory price of the
	// subscription, not including tax. The currency is the same as
	// price_currency_code. Price is expressed in micro-units, where
	// 1,000,000 micro-units represents one unit of the currency. For
	// example, if the subscription price is €1.99, price_amount_micros is
	// 1990000.
	IntroductoryPriceAmountMicros int64 `json:"introductoryPriceAmountMicros,omitempty,string"`

	// IntroductoryPriceCurrencyCode: ISO 4217 currency code for the
	// introductory subscription price. For example, if the price is
	// specified in British pounds sterling, price_currency_code is "GBP".
	IntroductoryPriceCurrencyCode string `json:"introductoryPriceCurrencyCode,omitempty"`

	// IntroductoryPriceCycles: The number of billing period to offer
	// introductory pricing.
	IntroductoryPriceCycles int64 `json:"introductoryPriceCycles,omitempty"`

	// IntroductoryPricePeriod: Introductory price period, specified in ISO
	// 8601 format. Common values are (but not limited to) "P1W" (one week),
	// "P1M" (one month), "P3M" (three months), "P6M" (six months), and
	// "P1Y" (one year).
	IntroductoryPricePeriod string `json:"introductoryPricePeriod,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IntroductoryPriceAmountMicros") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "IntroductoryPriceAmountMicros") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IntroductoryPriceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod IntroductoryPriceInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LanguageTargeting: Targeting based on language.
type LanguageTargeting struct {
	// Alternatives: Alternative languages.
	Alternatives []string `json:"alternatives,omitempty"`

	// Value: ISO-639: 2 or 3 letter language code.
	Value []string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alternatives") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alternatives") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LanguageTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod LanguageTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAppRecoveriesResponse: Response message for ListAppRecoveries. --
// api-linter: core::0158::response-next-page-token-field=disabled
type ListAppRecoveriesResponse struct {
	// RecoveryActions: List of recovery actions associated with the
	// requested package name.
	RecoveryActions []*AppRecoveryAction `json:"recoveryActions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "RecoveryActions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RecoveryActions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListAppRecoveriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAppRecoveriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListDeviceTierConfigsResponse: Response listing existing device tier
// configs.
type ListDeviceTierConfigsResponse struct {
	// DeviceTierConfigs: Device tier configs created by the developer.
	DeviceTierConfigs []*DeviceTierConfig `json:"deviceTierConfigs,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DeviceTierConfigs")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceTierConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListDeviceTierConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDeviceTierConfigsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListSubscriptionOffersResponse: Response message for
// ListSubscriptionOffers.
type ListSubscriptionOffersResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SubscriptionOffers: The subscription offers from the specified
	// subscription.
	SubscriptionOffers []*SubscriptionOffer `json:"subscriptionOffers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListSubscriptionOffersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSubscriptionOffersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListSubscriptionsResponse: Response message for ListSubscriptions.
type ListSubscriptionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Subscriptions: The subscriptions from the specified app.
	Subscriptions []*Subscription `json:"subscriptions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListSubscriptionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSubscriptionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListUsersResponse: A response containing one or more users with
// access to an account.
type ListUsersResponse struct {
	// NextPageToken: A token to pass to subsequent calls in order to
	// retrieve subsequent results. This will not be set if there are no
	// more results to return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Users: The resulting users.
	Users []*User `json:"users,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListUsersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUsersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Listing: A localized store listing. The resource for ListingsService.
type Listing struct {
	// FullDescription: Full description of the app.
	FullDescription string `json:"fullDescription,omitempty"`

	// Language: Language localization code (a BCP-47 language tag; for
	// example, "de-AT" for Austrian German).
	Language string `json:"language,omitempty"`

	// ShortDescription: Short description of the app.
	ShortDescription string `json:"shortDescription,omitempty"`

	// Title: Localized title of the app.
	Title string `json:"title,omitempty"`

	// Video: URL of a promotional YouTube video for the app.
	Video string `json:"video,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FullDescription") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullDescription") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Listing) MarshalJSON() ([]byte, error) {
	type NoMethod Listing
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListingsListResponse: Response listing all localized listings.
type ListingsListResponse struct {
	// Kind: The kind of this response
	// ("androidpublisher#listingsListResponse").
	Kind string `json:"kind,omitempty"`

	// Listings: All localized listings.
	Listings []*Listing `json:"listings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListingsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListingsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LocalizedText: Localized text in given language.
type LocalizedText struct {
	// Language: Language localization code (a BCP-47 language tag; for
	// example, "de-AT" for Austrian German).
	Language string `json:"language,omitempty"`

	// Text: The text in the given language.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Language") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Language") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LocalizedText) MarshalJSON() ([]byte, error) {
	type NoMethod LocalizedText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ManagedProductTaxAndComplianceSettings: Details about taxation and
// legal compliance for managed products.
type ManagedProductTaxAndComplianceSettings struct {
	// EeaWithdrawalRightType: Digital content or service classification for
	// products distributed to users in the European Economic Area (EEA).
	// The withdrawal regime under EEA consumer laws depends on this
	// classification. Refer to the Help Center article
	// (https://support.google.com/googleplay/android-developer/answer/10463498)
	// for more information.
	//
	// Possible values:
	//   "WITHDRAWAL_RIGHT_TYPE_UNSPECIFIED"
	//   "WITHDRAWAL_RIGHT_DIGITAL_CONTENT"
	//   "WITHDRAWAL_RIGHT_SERVICE"
	EeaWithdrawalRightType string `json:"eeaWithdrawalRightType,omitempty"`

	// IsTokenizedDigitalAsset: Whether this in-app product is declared as a
	// product representing a tokenized digital asset.
	IsTokenizedDigitalAsset bool `json:"isTokenizedDigitalAsset,omitempty"`

	// TaxRateInfoByRegionCode: A mapping from region code to tax rate
	// details. The keys are region codes as defined by Unicode's "CLDR".
	TaxRateInfoByRegionCode map[string]RegionalTaxRateInfo `json:"taxRateInfoByRegionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EeaWithdrawalRightType") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EeaWithdrawalRightType")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ManagedProductTaxAndComplianceSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ManagedProductTaxAndComplianceSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MigrateBasePlanPricesRequest: Request message for
// MigrateBasePlanPrices.
type MigrateBasePlanPricesRequest struct {
	// BasePlanId: Required. The unique base plan ID of the base plan to
	// update prices on.
	BasePlanId string `json:"basePlanId,omitempty"`

	// LatencyTolerance: Optional. The latency tolerance for the propagation
	// of this product update. Defaults to latency-sensitive.
	//
	// Possible values:
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
	// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
	// will propagate to clients within several minutes on average and up to
	// a few hours in rare cases. Throughput is limited to 7,200 updates per
	// app per hour.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
	// will propagate to clients within 24 hours. Supports high throughput
	// of up to 720,000 updates per app per hour using batch modification
	// methods.
	LatencyTolerance string `json:"latencyTolerance,omitempty"`

	// PackageName: Required. Package name of the parent app. Must be equal
	// to the package_name field on the Subscription resource.
	PackageName string `json:"packageName,omitempty"`

	// ProductId: Required. The ID of the subscription to update. Must be
	// equal to the product_id field on the Subscription resource.
	ProductId string `json:"productId,omitempty"`

	// RegionalPriceMigrations: Required. The regional prices to update.
	RegionalPriceMigrations []*RegionalPriceMigrationConfig `json:"regionalPriceMigrations,omitempty"`

	// RegionsVersion: Required. The version of the available regions being
	// used for the regional_price_migrations.
	RegionsVersion *RegionsVersion `json:"regionsVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BasePlanId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BasePlanId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MigrateBasePlanPricesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod MigrateBasePlanPricesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MigrateBasePlanPricesResponse: Response message for
// MigrateBasePlanPrices.
type MigrateBasePlanPricesResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// ModuleMetadata: Metadata of a module.
type ModuleMetadata struct {
	// DeliveryType: Indicates the delivery type (e.g. on-demand) of the
	// module.
	//
	// Possible values:
	//   "UNKNOWN_DELIVERY_TYPE" - Unspecified delivery type.
	//   "INSTALL_TIME" - This module will always be downloaded as part of
	// the initial install of the app.
	//   "ON_DEMAND" - This module is requested on-demand, which means it
	// will not be part of the initial install, and will only be sent when
	// requested by the client.
	//   "FAST_FOLLOW" - This module will be downloaded immediately after
	// initial install finishes. The app can be opened before these modules
	// are downloaded.
	DeliveryType string `json:"deliveryType,omitempty"`

	// Dependencies: Names of the modules that this module directly depends
	// on. Each module implicitly depends on the base module.
	Dependencies []string `json:"dependencies,omitempty"`

	// ModuleType: Indicates the type of this feature module.
	//
	// Possible values:
	//   "UNKNOWN_MODULE_TYPE" - Unknown feature module.
	//   "FEATURE_MODULE" - Regular feature module.
	ModuleType string `json:"moduleType,omitempty"`

	// Name: Module name.
	Name string `json:"name,omitempty"`

	// Targeting: The targeting that makes a conditional module installed.
	// Relevant only for Split APKs.
	Targeting *ModuleTargeting `json:"targeting,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeliveryType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeliveryType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ModuleMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ModuleMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ModuleTargeting: Targeting on the module level.
type ModuleTargeting struct {
	// DeviceFeatureTargeting: Targeting for device features.
	DeviceFeatureTargeting []*DeviceFeatureTargeting `json:"deviceFeatureTargeting,omitempty"`

	// SdkVersionTargeting: The sdk version that the variant targets
	SdkVersionTargeting *SdkVersionTargeting `json:"sdkVersionTargeting,omitempty"`

	// UserCountriesTargeting: Countries-level targeting
	UserCountriesTargeting *UserCountriesTargeting `json:"userCountriesTargeting,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DeviceFeatureTargeting") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceFeatureTargeting")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ModuleTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod ModuleTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Money: Represents an amount of money with its currency type.
type Money struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// Nanos: Number of nano (10^-9) units of the amount. The value must be
	// between -999,999,999 and +999,999,999 inclusive. If `units` is
	// positive, `nanos` must be positive or zero. If `units` is zero,
	// `nanos` can be positive, zero, or negative. If `units` is negative,
	// `nanos` must be negative or zero. For example $-1.75 is represented
	// as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`

	// Units: The whole units of the amount. For example if `currencyCode`
	// is "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrencyCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Money) MarshalJSON() ([]byte, error) {
	type NoMethod Money
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MultiAbi: Represents a list of apis.
type MultiAbi struct {
	// Abi: A list of targeted ABIs, as represented by the Android Platform
	Abi []*Abi `json:"abi,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Abi") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Abi") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MultiAbi) MarshalJSON() ([]byte, error) {
	type NoMethod MultiAbi
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MultiAbiTargeting: Targeting based on multiple abis.
type MultiAbiTargeting struct {
	// Alternatives: Targeting of other sibling directories that were in the
	// Bundle. For main splits this is targeting of other main splits.
	Alternatives []*MultiAbi `json:"alternatives,omitempty"`

	// Value: Value of a multi abi.
	Value []*MultiAbi `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alternatives") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alternatives") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MultiAbiTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod MultiAbiTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OfferDetails: Offer details information related to a purchase line
// item.
type OfferDetails struct {
	// BasePlanId: The base plan ID. Present for all base plan and offers.
	BasePlanId string `json:"basePlanId,omitempty"`

	// OfferId: The offer ID. Only present for discounted offers.
	OfferId string `json:"offerId,omitempty"`

	// OfferTags: The latest offer tags associated with the offer. It
	// includes tags inherited from the base plan.
	OfferTags []string `json:"offerTags,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BasePlanId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BasePlanId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OfferDetails) MarshalJSON() ([]byte, error) {
	type NoMethod OfferDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OfferTag: Represents a custom tag specified for base plans and
// subscription offers.
type OfferTag struct {
	// Tag: Must conform with RFC-1034. That is, this string can only
	// contain lower-case letters (a-z), numbers (0-9), and hyphens (-), and
	// be at most 20 characters.
	Tag string `json:"tag,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Tag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Tag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OfferTag) MarshalJSON() ([]byte, error) {
	type NoMethod OfferTag
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OneTimeExternalTransaction: Represents a one-time transaction.
type OneTimeExternalTransaction struct {
	// ExternalTransactionToken: Input only. Provided during the call to
	// Create. Retrieved from the client when the alternative billing flow
	// is launched.
	ExternalTransactionToken string `json:"externalTransactionToken,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ExternalTransactionToken") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternalTransactionToken")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OneTimeExternalTransaction) MarshalJSON() ([]byte, error) {
	type NoMethod OneTimeExternalTransaction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OtherRegionsBasePlanConfig: Pricing information for any new locations
// Play may launch in.
type OtherRegionsBasePlanConfig struct {
	// EurPrice: Required. Price in EUR to use for any new locations Play
	// may launch in.
	EurPrice *Money `json:"eurPrice,omitempty"`

	// NewSubscriberAvailability: Whether the base plan is available for new
	// subscribers in any new locations Play may launch in. If not
	// specified, this will default to false.
	NewSubscriberAvailability bool `json:"newSubscriberAvailability,omitempty"`

	// UsdPrice: Required. Price in USD to use for any new locations Play
	// may launch in.
	UsdPrice *Money `json:"usdPrice,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EurPrice") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EurPrice") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OtherRegionsBasePlanConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OtherRegionsBasePlanConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OtherRegionsSubscriptionOfferConfig: Configuration for any new
// locations Play may launch in specified on a subscription offer.
type OtherRegionsSubscriptionOfferConfig struct {
	// OtherRegionsNewSubscriberAvailability: Whether the subscription offer
	// in any new locations Play may launch in the future. If not specified,
	// this will default to false.
	OtherRegionsNewSubscriberAvailability bool `json:"otherRegionsNewSubscriberAvailability,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "OtherRegionsNewSubscriberAvailability") to unconditionally include
	// in API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "OtherRegionsNewSubscriberAvailability") to include in API requests
	// with the JSON null value. By default, fields with empty values are
	// omitted from API requests. However, any field with an empty value
	// appearing in NullFields will be sent to the server as null. It is an
	// error if a field in this list has a non-empty value. This may be used
	// to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OtherRegionsSubscriptionOfferConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OtherRegionsSubscriptionOfferConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OtherRegionsSubscriptionOfferPhaseConfig: Configuration for any new
// locations Play may launch in for a single offer phase.
type OtherRegionsSubscriptionOfferPhaseConfig struct {
	// AbsoluteDiscounts: The absolute amount of money subtracted from the
	// base plan price prorated over the phase duration that the user pays
	// for this offer phase. For example, if the base plan price for this
	// region is $12 for a period of 1 year, then a $1 absolute discount for
	// a phase of a duration of 3 months would correspond to a price of $2.
	// The resulting price may not be smaller than the minimum price allowed
	// for any new locations Play may launch in.
	AbsoluteDiscounts *OtherRegionsSubscriptionOfferPhasePrices `json:"absoluteDiscounts,omitempty"`

	// OtherRegionsPrices: The absolute price the user pays for this offer
	// phase. The price must not be smaller than the minimum price allowed
	// for any new locations Play may launch in.
	OtherRegionsPrices *OtherRegionsSubscriptionOfferPhasePrices `json:"otherRegionsPrices,omitempty"`

	// RelativeDiscount: The fraction of the base plan price prorated over
	// the phase duration that the user pays for this offer phase. For
	// example, if the base plan price for this region is $12 for a period
	// of 1 year, then a 50% discount for a phase of a duration of 3 months
	// would correspond to a price of $1.50. The discount must be specified
	// as a fraction strictly larger than 0 and strictly smaller than 1. The
	// resulting price will be rounded to the nearest billable unit (e.g.
	// cents for USD). The relative discount is considered invalid if the
	// discounted price ends up being smaller than the minimum price allowed
	// in any new locations Play may launch in.
	RelativeDiscount float64 `json:"relativeDiscount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AbsoluteDiscounts")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AbsoluteDiscounts") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OtherRegionsSubscriptionOfferPhaseConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OtherRegionsSubscriptionOfferPhaseConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *OtherRegionsSubscriptionOfferPhaseConfig) UnmarshalJSON(data []byte) error {
	type NoMethod OtherRegionsSubscriptionOfferPhaseConfig
	var s1 struct {
		RelativeDiscount gensupport.JSONFloat64 `json:"relativeDiscount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelativeDiscount = float64(s1.RelativeDiscount)
	return nil
}

// OtherRegionsSubscriptionOfferPhasePrices: Pricing information for any
// new locations Play may launch in.
type OtherRegionsSubscriptionOfferPhasePrices struct {
	// EurPrice: Required. Price in EUR to use for any new locations Play
	// may launch in.
	EurPrice *Money `json:"eurPrice,omitempty"`

	// UsdPrice: Required. Price in USD to use for any new locations Play
	// may launch in.
	UsdPrice *Money `json:"usdPrice,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EurPrice") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EurPrice") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OtherRegionsSubscriptionOfferPhasePrices) MarshalJSON() ([]byte, error) {
	type NoMethod OtherRegionsSubscriptionOfferPhasePrices
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PageInfo: Information about the current page. List operations that
// supports paging return only one "page" of results. This protocol
// buffer message describes the page that has been returned.
type PageInfo struct {
	// ResultPerPage: Maximum number of results returned in one page. ! The
	// number of results included in the API response.
	ResultPerPage int64 `json:"resultPerPage,omitempty"`

	// StartIndex: Index of the first result returned in the current page.
	StartIndex int64 `json:"startIndex,omitempty"`

	// TotalResults: Total number of results available on the backend ! The
	// total number of results in the result set.
	TotalResults int64 `json:"totalResults,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResultPerPage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResultPerPage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod PageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PartialRefund: A partial refund of a transaction.
type PartialRefund struct {
	// RefundId: Required. A unique id distinguishing this partial refund.
	// If the refund is successful, subsequent refunds with the same id will
	// fail. Must be unique across refunds for one individual transaction.
	RefundId string `json:"refundId,omitempty"`

	// RefundPreTaxAmount: Required. The pre-tax amount of the partial
	// refund. Should be less than the remaining pre-tax amount of the
	// transaction.
	RefundPreTaxAmount *Price `json:"refundPreTaxAmount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RefundId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RefundId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PartialRefund) MarshalJSON() ([]byte, error) {
	type NoMethod PartialRefund
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PausedStateContext: Information specific to a subscription in paused
// state.
type PausedStateContext struct {
	// AutoResumeTime: Time at which the subscription will be automatically
	// resumed.
	AutoResumeTime string `json:"autoResumeTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoResumeTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoResumeTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PausedStateContext) MarshalJSON() ([]byte, error) {
	type NoMethod PausedStateContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PrepaidBasePlanType: Represents a base plan that does not
// automatically renew at the end of the base plan, and must be manually
// renewed by the user.
type PrepaidBasePlanType struct {
	// BillingPeriodDuration: Required. Subscription period, specified in
	// ISO 8601 format. For a list of acceptable billing periods, refer to
	// the help center.
	BillingPeriodDuration string `json:"billingPeriodDuration,omitempty"`

	// TimeExtension: Whether users should be able to extend this prepaid
	// base plan in Google Play surfaces. Defaults to TIME_EXTENSION_ACTIVE
	// if not specified.
	//
	// Possible values:
	//   "TIME_EXTENSION_UNSPECIFIED" - Unspecified state.
	//   "TIME_EXTENSION_ACTIVE" - Time extension is active. Users are
	// allowed to top-up or extend their prepaid plan.
	//   "TIME_EXTENSION_INACTIVE" - Time extension is inactive. Users
	// cannot top-up or extend their prepaid plan.
	TimeExtension string `json:"timeExtension,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BillingPeriodDuration") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BillingPeriodDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PrepaidBasePlanType) MarshalJSON() ([]byte, error) {
	type NoMethod PrepaidBasePlanType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PrepaidPlan: Information related to a prepaid plan.
type PrepaidPlan struct {
	// AllowExtendAfterTime: If present, this is the time after which top up
	// purchases are allowed for the prepaid plan. Will not be present for
	// expired prepaid plans.
	AllowExtendAfterTime string `json:"allowExtendAfterTime,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowExtendAfterTime") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowExtendAfterTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PrepaidPlan) MarshalJSON() ([]byte, error) {
	type NoMethod PrepaidPlan
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Price: Definition of a price, i.e. currency and units.
type Price struct {
	// Currency: 3 letter Currency code, as defined by ISO 4217. See
	// java/com/google/common/money/CurrencyCode.java
	Currency string `json:"currency,omitempty"`

	// PriceMicros: Price in 1/million of the currency base unit,
	// represented as a string.
	PriceMicros string `json:"priceMicros,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Currency") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Currency") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Price) MarshalJSON() ([]byte, error) {
	type NoMethod Price
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ProductPurchase: A ProductPurchase resource indicates the status of a
// user's inapp product purchase.
type ProductPurchase struct {
	// AcknowledgementState: The acknowledgement state of the inapp product.
	// Possible values are: 0. Yet to be acknowledged 1. Acknowledged
	AcknowledgementState int64 `json:"acknowledgementState,omitempty"`

	// ConsumptionState: The consumption state of the inapp product.
	// Possible values are: 0. Yet to be consumed 1. Consumed
	ConsumptionState int64 `json:"consumptionState,omitempty"`

	// DeveloperPayload: A developer-specified string that contains
	// supplemental information about an order.
	DeveloperPayload string `json:"developerPayload,omitempty"`

	// Kind: This kind represents an inappPurchase object in the
	// androidpublisher service.
	Kind string `json:"kind,omitempty"`

	// ObfuscatedExternalAccountId: An obfuscated version of the id that is
	// uniquely associated with the user's account in your app. Only present
	// if specified using
	// https://developer.android.com/reference/com/android/billingclient/api/BillingFlowParams.Builder#setobfuscatedaccountid
	// when the purchase was made.
	ObfuscatedExternalAccountId string `json:"obfuscatedExternalAccountId,omitempty"`

	// ObfuscatedExternalProfileId: An obfuscated version of the id that is
	// uniquely associated with the user's profile in your app. Only present
	// if specified using
	// https://developer.android.com/reference/com/android/billingclient/api/BillingFlowParams.Builder#setobfuscatedprofileid
	// when the purchase was made.
	ObfuscatedExternalProfileId string `json:"obfuscatedExternalProfileId,omitempty"`

	// OrderId: The order id associated with the purchase of the inapp
	// product.
	OrderId string `json:"orderId,omitempty"`

	// ProductId: The inapp product SKU. May not be present.
	ProductId string `json:"productId,omitempty"`

	// PurchaseState: The purchase state of the order. Possible values are:
	// 0. Purchased 1. Canceled 2. Pending
	PurchaseState int64 `json:"purchaseState,omitempty"`

	// PurchaseTimeMillis: The time the product was purchased, in
	// milliseconds since the epoch (Jan 1, 1970).
	PurchaseTimeMillis int64 `json:"purchaseTimeMillis,omitempty,string"`

	// PurchaseToken: The purchase token generated to identify this
	// purchase. May not be present.
	PurchaseToken string `json:"purchaseToken,omitempty"`

	// PurchaseType: The type of purchase of the inapp product. This field
	// is only set if this purchase was not made using the standard in-app
	// billing flow. Possible values are: 0. Test (i.e. purchased from a
	// license testing account) 1. Promo (i.e. purchased using a promo code)
	// 2. Rewarded (i.e. from watching a video ad instead of paying)
	PurchaseType *int64 `json:"purchaseType,omitempty"`

	// Quantity: The quantity associated with the purchase of the inapp
	// product. If not present, the quantity is 1.
	Quantity int64 `json:"quantity,omitempty"`

	// RegionCode: ISO 3166-1 alpha-2 billing region code of the user at the
	// time the product was granted.
	RegionCode string `json:"regionCode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AcknowledgementState") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcknowledgementState") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ProductPurchase) MarshalJSON() ([]byte, error) {
	type NoMethod ProductPurchase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ProductPurchasesAcknowledgeRequest: Request for the
// product.purchases.acknowledge API.
type ProductPurchasesAcknowledgeRequest struct {
	// DeveloperPayload: Payload to attach to the purchase.
	DeveloperPayload string `json:"developerPayload,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeveloperPayload") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeveloperPayload") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ProductPurchasesAcknowledgeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ProductPurchasesAcknowledgeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RecurringExternalTransaction: Represents a transaction that is part
// of a recurring series of payments. This can be a subscription or a
// one-time product with multiple payments (such as preorder).
type RecurringExternalTransaction struct {
	// ExternalSubscription: Details of an external subscription.
	ExternalSubscription *ExternalSubscription `json:"externalSubscription,omitempty"`

	// ExternalTransactionToken: Input only. Provided during the call to
	// Create. Retrieved from the client when the alternative billing flow
	// is launched. Required only for the initial purchase.
	ExternalTransactionToken string `json:"externalTransactionToken,omitempty"`

	// InitialExternalTransactionId: The external transaction id of the
	// first transaction of this recurring series of transactions. For
	// example, for a subscription this would be the transaction id of the
	// first payment. Required when creating recurring external
	// transactions.
	InitialExternalTransactionId string `json:"initialExternalTransactionId,omitempty"`

	// MigratedTransactionProgram: Input only. Provided during the call to
	// Create. Must only be used when migrating a subscription from manual
	// monthly reporting to automated reporting.
	//
	// Possible values:
	//   "EXTERNAL_TRANSACTION_PROGRAM_UNSPECIFIED" - Unspecified
	// transaction program. Not used.
	//   "USER_CHOICE_BILLING" - User choice billing, where a user may
	// choose between Google Play Billing developer-managed billing.
	//   "ALTERNATIVE_BILLING_ONLY" - Alternative billing only, where users
	// may only use developer-manager billing.
	MigratedTransactionProgram string `json:"migratedTransactionProgram,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ExternalSubscription") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternalSubscription") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RecurringExternalTransaction) MarshalJSON() ([]byte, error) {
	type NoMethod RecurringExternalTransaction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RefundExternalTransactionRequest: A request to refund an existing
// external transaction.
type RefundExternalTransactionRequest struct {
	// FullRefund: A full-amount refund.
	FullRefund *FullRefund `json:"fullRefund,omitempty"`

	// PartialRefund: A partial refund.
	PartialRefund *PartialRefund `json:"partialRefund,omitempty"`

	// RefundTime: Required. The time that the transaction was refunded.
	RefundTime string `json:"refundTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FullRefund") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullRefund") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RefundExternalTransactionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RefundExternalTransactionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RegionalBasePlanConfig: Configuration for a base plan specific to a
// region.
type RegionalBasePlanConfig struct {
	// NewSubscriberAvailability: Whether the base plan in the specified
	// region is available for new subscribers. Existing subscribers will
	// not have their subscription canceled if this value is set to false.
	// If not specified, this will default to false.
	NewSubscriberAvailability bool `json:"newSubscriberAvailability,omitempty"`

	// Price: The price of the base plan in the specified region. Must be
	// set if the base plan is available to new subscribers. Must be set in
	// the currency that is linked to the specified region.
	Price *Money `json:"price,omitempty"`

	// RegionCode: Required. Region code this configuration applies to, as
	// defined by ISO 3166-2, e.g. "US".
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "NewSubscriberAvailability") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "NewSubscriberAvailability") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionalBasePlanConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalBasePlanConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RegionalPriceMigrationConfig: Configuration for a price migration.
type RegionalPriceMigrationConfig struct {
	// OldestAllowedPriceVersionTime: Required. The cutoff time for
	// historical prices that subscribers can remain paying. Subscribers on
	// prices which were available at this cutoff time or later will stay on
	// their existing price. Subscribers on older prices will be migrated to
	// the currently-offered price. The migrated subscribers will receive a
	// notification that they will be paying a different price. Subscribers
	// who do not agree to the new price will have their subscription ended
	// at the next renewal.
	OldestAllowedPriceVersionTime string `json:"oldestAllowedPriceVersionTime,omitempty"`

	// PriceIncreaseType: Optional. The behavior the caller wants users to
	// see when there is a price increase during migration. If left unset,
	// the behavior defaults to PRICE_INCREASE_TYPE_OPT_IN. Note that the
	// first opt-out price increase migration for each app must be initiated
	// in Play Console.
	//
	// Possible values:
	//   "PRICE_INCREASE_TYPE_UNSPECIFIED" - Unspecified state.
	//   "PRICE_INCREASE_TYPE_OPT_IN" - Price increase will be presented to
	// users on an opt-in basis.
	//   "PRICE_INCREASE_TYPE_OPT_OUT" - Price increase will be presented to
	// users on an opt-out basis.
	PriceIncreaseType string `json:"priceIncreaseType,omitempty"`

	// RegionCode: Required. Region code this configuration applies to, as
	// defined by ISO 3166-2, e.g. "US".
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "OldestAllowedPriceVersionTime") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "OldestAllowedPriceVersionTime") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionalPriceMigrationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalPriceMigrationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RegionalSubscriptionOfferConfig: Configuration for a subscription
// offer in a single region.
type RegionalSubscriptionOfferConfig struct {
	// NewSubscriberAvailability: Whether the subscription offer in the
	// specified region is available for new subscribers. Existing
	// subscribers will not have their subscription cancelled if this value
	// is set to false. If not specified, this will default to false.
	NewSubscriberAvailability bool `json:"newSubscriberAvailability,omitempty"`

	// RegionCode: Required. Immutable. Region code this configuration
	// applies to, as defined by ISO 3166-2, e.g. "US".
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "NewSubscriberAvailability") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "NewSubscriberAvailability") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionalSubscriptionOfferConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalSubscriptionOfferConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RegionalSubscriptionOfferPhaseConfig: Configuration for a single
// phase of a subscription offer in a single region.
type RegionalSubscriptionOfferPhaseConfig struct {
	// AbsoluteDiscount: The absolute amount of money subtracted from the
	// base plan price prorated over the phase duration that the user pays
	// for this offer phase. For example, if the base plan price for this
	// region is $12 for a period of 1 year, then a $1 absolute discount for
	// a phase of a duration of 3 months would correspond to a price of $2.
	// The resulting price may not be smaller than the minimum price allowed
	// for this region.
	AbsoluteDiscount *Money `json:"absoluteDiscount,omitempty"`

	// Price: The absolute price the user pays for this offer phase. The
	// price must not be smaller than the minimum price allowed for this
	// region.
	Price *Money `json:"price,omitempty"`

	// RegionCode: Required. Immutable. The region to which this config
	// applies.
	RegionCode string `json:"regionCode,omitempty"`

	// RelativeDiscount: The fraction of the base plan price prorated over
	// the phase duration that the user pays for this offer phase. For
	// example, if the base plan price for this region is $12 for a period
	// of 1 year, then a 50% discount for a phase of a duration of 3 months
	// would correspond to a price of $1.50. The discount must be specified
	// as a fraction strictly larger than 0 and strictly smaller than 1. The
	// resulting price will be rounded to the nearest billable unit (e.g.
	// cents for USD). The relative discount is considered invalid if the
	// discounted price ends up being smaller than the minimum price allowed
	// in this region.
	RelativeDiscount float64 `json:"relativeDiscount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AbsoluteDiscount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AbsoluteDiscount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RegionalSubscriptionOfferPhaseConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalSubscriptionOfferPhaseConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *RegionalSubscriptionOfferPhaseConfig) UnmarshalJSON(data []byte) error {
	type NoMethod RegionalSubscriptionOfferPhaseConfig
	var s1 struct {
		RelativeDiscount gensupport.JSONFloat64 `json:"relativeDiscount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelativeDiscount = float64(s1.RelativeDiscount)
	return nil
}

// RegionalTaxRateInfo: Specified details about taxation in a given
// geographical region.
type RegionalTaxRateInfo struct {
	// EligibleForStreamingServiceTaxRate: You must tell us if your app
	// contains streaming products to correctly charge US state and local
	// sales tax. Field only supported in the United States.
	EligibleForStreamingServiceTaxRate bool `json:"eligibleForStreamingServiceTaxRate,omitempty"`

	// StreamingTaxType: To collect communications or amusement taxes in the
	// United States, choose the appropriate tax category. Learn more
	// (https://support.google.com/googleplay/android-developer/answer/10463498#streaming_tax).
	//
	// Possible values:
	//   "STREAMING_TAX_TYPE_UNSPECIFIED" - No telecommunications tax
	// collected.
	//   "STREAMING_TAX_TYPE_TELCO_VIDEO_RENTAL" - US-specific
	// telecommunications tax tier for video streaming, on demand, rentals /
	// subscriptions / pay-per-view.
	//   "STREAMING_TAX_TYPE_TELCO_VIDEO_SALES" - US-specific
	// telecommunications tax tier for video streaming of pre-recorded
	// content like movies, tv shows.
	//   "STREAMING_TAX_TYPE_TELCO_VIDEO_MULTI_CHANNEL" - US-specific
	// telecommunications tax tier for video streaming of multi-channel
	// programming.
	//   "STREAMING_TAX_TYPE_TELCO_AUDIO_RENTAL" - US-specific
	// telecommunications tax tier for audio streaming, rental /
	// subscription.
	//   "STREAMING_TAX_TYPE_TELCO_AUDIO_SALES" - US-specific
	// telecommunications tax tier for audio streaming, sale / permanent
	// download.
	//   "STREAMING_TAX_TYPE_TELCO_AUDIO_MULTI_CHANNEL" - US-specific
	// telecommunications tax tier for multi channel audio streaming like
	// radio.
	StreamingTaxType string `json:"streamingTaxType,omitempty"`

	// TaxTier: Tax tier to specify reduced tax rate. Developers who sell
	// digital news, magazines, newspapers, books, or audiobooks in various
	// regions may be eligible for reduced tax rates. Learn more
	// (https://support.google.com/googleplay/android-developer/answer/10463498).
	//
	// Possible values:
	//   "TAX_TIER_UNSPECIFIED"
	//   "TAX_TIER_BOOKS_1"
	//   "TAX_TIER_NEWS_1"
	//   "TAX_TIER_NEWS_2"
	//   "TAX_TIER_MUSIC_OR_AUDIO_1"
	//   "TAX_TIER_LIVE_OR_BROADCAST_1"
	TaxTier string `json:"taxTier,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EligibleForStreamingServiceTaxRate") to unconditionally include in
	// API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EligibleForStreamingServiceTaxRate") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionalTaxRateInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalTaxRateInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Regions: Region targeting data for app recovery action targeting.
type Regions struct {
	// RegionCode: Regions targeted by the recovery action. Region codes are
	// ISO 3166 Alpha-2 country codes. For example, US stands for United
	// States of America. See
	// https://www.iso.org/iso-3166-country-codes.html for the complete list
	// of country codes.
	RegionCode []string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RegionCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RegionCode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Regions) MarshalJSON() ([]byte, error) {
	type NoMethod Regions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RegionsVersion: The version of the available regions being used for
// the specified resource.
type RegionsVersion struct {
	// Version: Required. A string representing the version of available
	// regions being used for the specified resource. Regional prices for
	// the resource have to be specified according to the information
	// published in this article
	// (https://support.google.com/googleplay/android-developer/answer/10532353).
	// Each time the supported locations substantially change, the version
	// will be incremented. Using this field will ensure that creating and
	// updating the resource with an older region's version and set of
	// regional prices and currencies will succeed even though a new version
	// is available. The latest version is 2022/02.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Version") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Version") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RegionsVersion) MarshalJSON() ([]byte, error) {
	type NoMethod RegionsVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RemoteInAppUpdate: Object representation for Remote in-app update
// action type.
type RemoteInAppUpdate struct {
	// IsRemoteInAppUpdateRequested: Required. Set to true if Remote In-App
	// Update action type is needed.
	IsRemoteInAppUpdateRequested bool `json:"isRemoteInAppUpdateRequested,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IsRemoteInAppUpdateRequested") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "IsRemoteInAppUpdateRequested") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RemoteInAppUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod RemoteInAppUpdate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RemoteInAppUpdateData: Data related to Remote In-App Update action
// such as recovered user count, affected user count etc.
type RemoteInAppUpdateData struct {
	// RemoteAppUpdateDataPerBundle: Data related to the recovery action at
	// bundle level.
	RemoteAppUpdateDataPerBundle []*RemoteInAppUpdateDataPerBundle `json:"remoteAppUpdateDataPerBundle,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "RemoteAppUpdateDataPerBundle") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "RemoteAppUpdateDataPerBundle") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RemoteInAppUpdateData) MarshalJSON() ([]byte, error) {
	type NoMethod RemoteInAppUpdateData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RemoteInAppUpdateDataPerBundle: Data related to the recovery action
// at bundle level.
type RemoteInAppUpdateDataPerBundle struct {
	// RecoveredDeviceCount: Total number of devices which have been
	// rescued.
	RecoveredDeviceCount int64 `json:"recoveredDeviceCount,omitempty,string"`

	// TotalDeviceCount: Total number of devices affected by this recovery
	// action associated with bundle of the app.
	TotalDeviceCount int64 `json:"totalDeviceCount,omitempty,string"`

	// VersionCode: Version Code corresponding to the target bundle.
	VersionCode int64 `json:"versionCode,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "RecoveredDeviceCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RecoveredDeviceCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RemoteInAppUpdateDataPerBundle) MarshalJSON() ([]byte, error) {
	type NoMethod RemoteInAppUpdateDataPerBundle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReplacementCancellation: Information specific to cancellations caused
// by subscription replacement.
type ReplacementCancellation struct {
}

// Review: An Android app review.
type Review struct {
	// AuthorName: The name of the user who wrote the review.
	AuthorName string `json:"authorName,omitempty"`

	// Comments: A repeated field containing comments for the review.
	Comments []*Comment `json:"comments,omitempty"`

	// ReviewId: Unique identifier for this review.
	ReviewId string `json:"reviewId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AuthorName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuthorName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Review) MarshalJSON() ([]byte, error) {
	type NoMethod Review
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReviewReplyResult: The result of replying/updating a reply to review.
type ReviewReplyResult struct {
	// LastEdited: The time at which the reply took effect.
	LastEdited *Timestamp `json:"lastEdited,omitempty"`

	// ReplyText: The reply text that was applied.
	ReplyText string `json:"replyText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LastEdited") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LastEdited") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReviewReplyResult) MarshalJSON() ([]byte, error) {
	type NoMethod ReviewReplyResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReviewsListResponse: Response listing reviews.
type ReviewsListResponse struct {
	// PageInfo: Information about the current page.
	PageInfo *PageInfo `json:"pageInfo,omitempty"`

	// Reviews: List of reviews.
	Reviews []*Review `json:"reviews,omitempty"`

	// TokenPagination: Pagination token, to handle a number of products
	// that is over one page.
	TokenPagination *TokenPagination `json:"tokenPagination,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "PageInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageInfo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReviewsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReviewsListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReviewsReplyRequest: Request to reply to review or update existing
// reply.
type ReviewsReplyRequest struct {
	// ReplyText: The text to set as the reply. Replies of more than
	// approximately 350 characters will be rejected. HTML tags will be
	// stripped.
	ReplyText string `json:"replyText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ReplyText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ReplyText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReviewsReplyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ReviewsReplyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReviewsReplyResponse: Response on status of replying to a review.
type ReviewsReplyResponse struct {
	// Result: The result of replying/updating a reply to review.
	Result *ReviewReplyResult `json:"result,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Result") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReviewsReplyResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReviewsReplyResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RevocationContext: Revocation context of the
// purchases.subscriptionsv2.revoke API.
type RevocationContext struct {
	// ProratedRefund: Optional. Used when users should be refunded a
	// prorated amount they paid for their subscription based on the amount
	// of time remaining in a subscription.
	ProratedRefund *RevocationContextProratedRefund `json:"proratedRefund,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProratedRefund") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProratedRefund") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RevocationContext) MarshalJSON() ([]byte, error) {
	type NoMethod RevocationContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RevocationContextProratedRefund: Used to determine if the refund type
// in the RevocationContext is a prorated refund.
type RevocationContextProratedRefund struct {
}

// RevokeSubscriptionPurchaseRequest: Request for the
// purchases.subscriptionsv2.revoke API.
type RevokeSubscriptionPurchaseRequest struct {
	// RevocationContext: Required. Additional details around the
	// subscription revocation.
	RevocationContext *RevocationContext `json:"revocationContext,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RevocationContext")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RevocationContext") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RevokeSubscriptionPurchaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RevokeSubscriptionPurchaseRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RevokeSubscriptionPurchaseResponse: Response for the
// purchases.subscriptionsv2.revoke API.
type RevokeSubscriptionPurchaseResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// SafetyLabelsUpdateRequest: Request to update Safety Labels of an app.
type SafetyLabelsUpdateRequest struct {
	// SafetyLabels: Required. Contents of the CSV file containing Data
	// Safety responses. For the format of this file, see the Help Center
	// documentation at
	// https://support.google.com/googleplay/android-developer/answer/10787469?#zippy=%2Cunderstand-the-csv-format
	// To download an up to date template, follow the steps at
	// https://support.google.com/googleplay/android-developer/answer/10787469?#zippy=%2Cexport-to-a-csv-file
	SafetyLabels string `json:"safetyLabels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SafetyLabels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SafetyLabels") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SafetyLabelsUpdateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SafetyLabelsUpdateRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SafetyLabelsUpdateResponse: Response for SafetyLabelsUpdate rpc.
type SafetyLabelsUpdateResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// ScreenDensity: Represents a screen density.
type ScreenDensity struct {
	// DensityAlias: Alias for a screen density.
	//
	// Possible values:
	//   "DENSITY_UNSPECIFIED" - Unspecified screen density.
	//   "NODPI" - NODPI screen density.
	//   "LDPI" - LDPI screen density.
	//   "MDPI" - MDPI screen density.
	//   "TVDPI" - TVDPI screen density.
	//   "HDPI" - HDPI screen density.
	//   "XHDPI" - XHDPI screen density.
	//   "XXHDPI" - XXHDPI screen density.
	//   "XXXHDPI" - XXXHDPI screen density.
	DensityAlias string `json:"densityAlias,omitempty"`

	// DensityDpi: Value for density dpi.
	DensityDpi int64 `json:"densityDpi,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DensityAlias") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DensityAlias") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ScreenDensity) MarshalJSON() ([]byte, error) {
	type NoMethod ScreenDensity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ScreenDensityTargeting: Targeting based on screen density.
type ScreenDensityTargeting struct {
	// Alternatives: Targeting of other sibling directories that were in the
	// Bundle. For main splits this is targeting of other main splits.
	Alternatives []*ScreenDensity `json:"alternatives,omitempty"`

	// Value: Value of a screen density.
	Value []*ScreenDensity `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alternatives") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alternatives") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ScreenDensityTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod ScreenDensityTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SdkVersion: Represents an sdk version.
type SdkVersion struct {
	// Min: Inclusive minimum value of an sdk version.
	Min int64 `json:"min,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Min") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Min") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SdkVersion) MarshalJSON() ([]byte, error) {
	type NoMethod SdkVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SdkVersionTargeting: Targeting based on sdk version.
type SdkVersionTargeting struct {
	// Alternatives: Targeting of other sibling directories that were in the
	// Bundle. For main splits this is targeting of other main splits.
	Alternatives []*SdkVersion `json:"alternatives,omitempty"`

	// Value: Value of an sdk version.
	Value []*SdkVersion `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alternatives") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alternatives") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SdkVersionTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod SdkVersionTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SplitApkMetadata: Holds data specific to Split APKs.
type SplitApkMetadata struct {
	// IsMasterSplit: Indicates whether this APK is the main split of the
	// module.
	IsMasterSplit bool `json:"isMasterSplit,omitempty"`

	// SplitId: Id of the split.
	SplitId string `json:"splitId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsMasterSplit") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsMasterSplit") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SplitApkMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod SplitApkMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SplitApkVariant: Variant is a group of APKs that covers a part of the
// device configuration space. APKs from multiple variants are never
// combined on one device.
type SplitApkVariant struct {
	// ApkSet: Set of APKs, one set per module.
	ApkSet []*ApkSet `json:"apkSet,omitempty"`

	// Targeting: Variant-level targeting.
	Targeting *VariantTargeting `json:"targeting,omitempty"`

	// VariantNumber: Number of the variant, starting at 0 (unless
	// overridden). A device will receive APKs from the first variant that
	// matches the device configuration, with higher variant numbers having
	// priority over lower variant numbers.
	VariantNumber int64 `json:"variantNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApkSet") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApkSet") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SplitApkVariant) MarshalJSON() ([]byte, error) {
	type NoMethod SplitApkVariant
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StandaloneApkMetadata: Holds data specific to Standalone APKs.
type StandaloneApkMetadata struct {
	// FusedModuleName: Names of the modules fused in this standalone APK.
	FusedModuleName []string `json:"fusedModuleName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FusedModuleName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FusedModuleName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *StandaloneApkMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod StandaloneApkMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscribeWithGoogleInfo: Information associated with purchases made
// with 'Subscribe with Google'.
type SubscribeWithGoogleInfo struct {
	// EmailAddress: The email address of the user when the subscription was
	// purchased.
	EmailAddress string `json:"emailAddress,omitempty"`

	// FamilyName: The family name of the user when the subscription was
	// purchased.
	FamilyName string `json:"familyName,omitempty"`

	// GivenName: The given name of the user when the subscription was
	// purchased.
	GivenName string `json:"givenName,omitempty"`

	// ProfileId: The Google profile id of the user when the subscription
	// was purchased.
	ProfileId string `json:"profileId,omitempty"`

	// ProfileName: The profile name of the user when the subscription was
	// purchased.
	ProfileName string `json:"profileName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EmailAddress") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EmailAddress") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SubscribeWithGoogleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SubscribeWithGoogleInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Subscription: A single subscription for an app.
type Subscription struct {
	// Archived: Output only. Deprecated: subscription archiving is not
	// supported.
	Archived bool `json:"archived,omitempty"`

	// BasePlans: The set of base plans for this subscription. Represents
	// the prices and duration of the subscription if no other offers apply.
	BasePlans []*BasePlan `json:"basePlans,omitempty"`

	// Listings: Required. List of localized listings for this subscription.
	// Must contain at least an entry for the default language of the parent
	// app.
	Listings []*SubscriptionListing `json:"listings,omitempty"`

	// PackageName: Immutable. Package name of the parent app.
	PackageName string `json:"packageName,omitempty"`

	// ProductId: Immutable. Unique product ID of the product. Unique within
	// the parent app. Product IDs must be composed of lower-case letters
	// (a-z), numbers (0-9), underscores (_) and dots (.). It must start
	// with a lower-case letter or number, and be between 1 and 40
	// (inclusive) characters in length.
	ProductId string `json:"productId,omitempty"`

	// TaxAndComplianceSettings: Details about taxes and legal compliance.
	TaxAndComplianceSettings *SubscriptionTaxAndComplianceSettings `json:"taxAndComplianceSettings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Archived") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Archived") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Subscription) MarshalJSON() ([]byte, error) {
	type NoMethod Subscription
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionCancelSurveyResult: Information provided by the user when
// they complete the subscription cancellation flow (cancellation reason
// survey).
type SubscriptionCancelSurveyResult struct {
	// CancelSurveyReason: The cancellation reason the user chose in the
	// survey. Possible values are: 0. Other 1. I don't use this service
	// enough 2. Technical issues 3. Cost-related reasons 4. I found a
	// better app
	CancelSurveyReason int64 `json:"cancelSurveyReason,omitempty"`

	// UserInputCancelReason: The customized input cancel reason from the
	// user. Only present when cancelReason is 0.
	UserInputCancelReason string `json:"userInputCancelReason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CancelSurveyReason")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CancelSurveyReason") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionCancelSurveyResult) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionCancelSurveyResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionDeferralInfo: A SubscriptionDeferralInfo contains the
// data needed to defer a subscription purchase to a future expiry time.
type SubscriptionDeferralInfo struct {
	// DesiredExpiryTimeMillis: The desired next expiry time to assign to
	// the subscription, in milliseconds since the Epoch. The given time
	// must be later/greater than the current expiry time for the
	// subscription.
	DesiredExpiryTimeMillis int64 `json:"desiredExpiryTimeMillis,omitempty,string"`

	// ExpectedExpiryTimeMillis: The expected expiry time for the
	// subscription. If the current expiry time for the subscription is not
	// the value specified here, the deferral will not occur.
	ExpectedExpiryTimeMillis int64 `json:"expectedExpiryTimeMillis,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "DesiredExpiryTimeMillis") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DesiredExpiryTimeMillis")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionDeferralInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionDeferralInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionItemPriceChangeDetails: Price change related information
// of a subscription item.
type SubscriptionItemPriceChangeDetails struct {
	// ExpectedNewPriceChargeTime: The renewal time at which the price
	// change will become effective for the user. This is subject to
	// change(to a future time) due to cases where the renewal time shifts
	// like pause. This field is only populated if the price change has not
	// taken effect.
	ExpectedNewPriceChargeTime string `json:"expectedNewPriceChargeTime,omitempty"`

	// NewPrice: New recurring price for the subscription item.
	NewPrice *Money `json:"newPrice,omitempty"`

	// PriceChangeMode: Price change mode specifies how the subscription
	// item price is changing.
	//
	// Possible values:
	//   "PRICE_CHANGE_MODE_UNSPECIFIED" - Price change mode unspecified.
	// This value should never be set.
	//   "PRICE_DECREASE" - If the subscription price is decreasing.
	//   "PRICE_INCREASE" - If the subscription price is increasing and the
	// user needs to accept it.
	//   "OPT_OUT_PRICE_INCREASE" - If the subscription price is increasing
	// with opt out mode.
	PriceChangeMode string `json:"priceChangeMode,omitempty"`

	// PriceChangeState: State the price change is currently in.
	//
	// Possible values:
	//   "PRICE_CHANGE_STATE_UNSPECIFIED" - Price change state unspecified.
	// This value should not be used.
	//   "OUTSTANDING" - Waiting for the user to agree for the price change.
	//   "CONFIRMED" - The price change is confirmed to happen for the user.
	//   "APPLIED" - The price change is applied, i.e. the user has started
	// being charged the new price.
	PriceChangeState string `json:"priceChangeState,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ExpectedNewPriceChargeTime") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ExpectedNewPriceChargeTime") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionItemPriceChangeDetails) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionItemPriceChangeDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionListing: The consumer-visible metadata of a subscription.
type SubscriptionListing struct {
	// Benefits: A list of benefits shown to the user on platforms such as
	// the Play Store and in restoration flows in the language of this
	// listing. Plain text. Ordered list of at most four benefits.
	Benefits []string `json:"benefits,omitempty"`

	// Description: The description of this subscription in the language of
	// this listing. Maximum length - 80 characters. Plain text.
	Description string `json:"description,omitempty"`

	// LanguageCode: Required. The language of this listing, as defined by
	// BCP-47, e.g. "en-US".
	LanguageCode string `json:"languageCode,omitempty"`

	// Title: Required. The title of this subscription in the language of
	// this listing. Plain text.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Benefits") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Benefits") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionListing) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionListing
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionOffer: A single, temporary offer
type SubscriptionOffer struct {
	// BasePlanId: Required. Immutable. The ID of the base plan to which
	// this offer is an extension.
	BasePlanId string `json:"basePlanId,omitempty"`

	// OfferId: Required. Immutable. Unique ID of this subscription offer.
	// Must be unique within the base plan.
	OfferId string `json:"offerId,omitempty"`

	// OfferTags: List of up to 20 custom tags specified for this offer, and
	// returned to the app through the billing library.
	OfferTags []*OfferTag `json:"offerTags,omitempty"`

	// OtherRegionsConfig: The configuration for any new locations Play may
	// launch in the future.
	OtherRegionsConfig *OtherRegionsSubscriptionOfferConfig `json:"otherRegionsConfig,omitempty"`

	// PackageName: Required. Immutable. The package name of the app the
	// parent subscription belongs to.
	PackageName string `json:"packageName,omitempty"`

	// Phases: Required. The phases of this subscription offer. Must contain
	// at least one entry, and may contain at most five. Users will always
	// receive all these phases in the specified order. Phases may not be
	// added, removed, or reordered after initial creation.
	Phases []*SubscriptionOfferPhase `json:"phases,omitempty"`

	// ProductId: Required. Immutable. The ID of the parent subscription
	// this offer belongs to.
	ProductId string `json:"productId,omitempty"`

	// RegionalConfigs: Required. The region-specific configuration of this
	// offer. Must contain at least one entry.
	RegionalConfigs []*RegionalSubscriptionOfferConfig `json:"regionalConfigs,omitempty"`

	// State: Output only. The current state of this offer. Can be changed
	// using Activate and Deactivate actions. NB: the base plan state
	// supersedes this state, so an active offer may not be available if the
	// base plan is not active.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value, should never be used.
	//   "DRAFT" - The subscription offer is not and has never been
	// available to users.
	//   "ACTIVE" - The subscription offer is available to new and existing
	// users.
	//   "INACTIVE" - The subscription offer is not available to new users.
	// Existing users retain access.
	State string `json:"state,omitempty"`

	// Targeting: The requirements that users need to fulfil to be eligible
	// for this offer. Represents the requirements that Play will evaluate
	// to decide whether an offer should be returned. Developers may further
	// filter these offers themselves.
	Targeting *SubscriptionOfferTargeting `json:"targeting,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BasePlanId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BasePlanId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionOffer) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionOffer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionOfferPhase: A single phase of a subscription offer.
type SubscriptionOfferPhase struct {
	// Duration: Required. The duration of a single recurrence of this
	// phase. Specified in ISO 8601 format.
	Duration string `json:"duration,omitempty"`

	// OtherRegionsConfig: Pricing information for any new locations Play
	// may launch in.
	OtherRegionsConfig *OtherRegionsSubscriptionOfferPhaseConfig `json:"otherRegionsConfig,omitempty"`

	// RecurrenceCount: Required. The number of times this phase repeats. If
	// this offer phase is not free, each recurrence charges the user the
	// price of this offer phase.
	RecurrenceCount int64 `json:"recurrenceCount,omitempty"`

	// RegionalConfigs: Required. The region-specific configuration of this
	// offer phase. This list must contain exactly one entry for each region
	// for which the subscription offer has a regional config.
	RegionalConfigs []*RegionalSubscriptionOfferPhaseConfig `json:"regionalConfigs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Duration") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionOfferPhase) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionOfferPhase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionOfferTargeting: Defines the rule a user needs to satisfy
// to receive this offer.
type SubscriptionOfferTargeting struct {
	// AcquisitionRule: Offer targeting rule for new user acquisition.
	AcquisitionRule *AcquisitionTargetingRule `json:"acquisitionRule,omitempty"`

	// UpgradeRule: Offer targeting rule for upgrading users' existing
	// plans.
	UpgradeRule *UpgradeTargetingRule `json:"upgradeRule,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AcquisitionRule") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcquisitionRule") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionOfferTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionOfferTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionPriceChange: Contains the price change information for a
// subscription that can be used to control the user journey for the
// price change in the app. This can be in the form of seeking
// confirmation from the user or tailoring the experience for a
// successful conversion.
type SubscriptionPriceChange struct {
	// NewPrice: The new price the subscription will renew with if the price
	// change is accepted by the user.
	NewPrice *Price `json:"newPrice,omitempty"`

	// State: The current state of the price change. Possible values are: 0.
	// Outstanding: State for a pending price change waiting for the user to
	// agree. In this state, you can optionally seek confirmation from the
	// user using the In-App API. 1. Accepted: State for an accepted price
	// change that the subscription will renew with unless it's canceled.
	// The price change takes effect on a future date when the subscription
	// renews. Note that the change might not occur when the subscription is
	// renewed next.
	State int64 `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NewPrice") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NewPrice") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionPriceChange) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionPriceChange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionPurchase: A SubscriptionPurchase resource indicates the
// status of a user's subscription purchase.
type SubscriptionPurchase struct {
	// AcknowledgementState: The acknowledgement state of the subscription
	// product. Possible values are: 0. Yet to be acknowledged 1.
	// Acknowledged
	AcknowledgementState int64 `json:"acknowledgementState,omitempty"`

	// AutoRenewing: Whether the subscription will automatically be renewed
	// when it reaches its current expiry time.
	AutoRenewing bool `json:"autoRenewing,omitempty"`

	// AutoResumeTimeMillis: Time at which the subscription will be
	// automatically resumed, in milliseconds since the Epoch. Only present
	// if the user has requested to pause the subscription.
	AutoResumeTimeMillis int64 `json:"autoResumeTimeMillis,omitempty,string"`

	// CancelReason: The reason why a subscription was canceled or is not
	// auto-renewing. Possible values are: 0. User canceled the subscription
	// 1. Subscription was canceled by the system, for example because of a
	// billing problem 2. Subscription was replaced with a new subscription
	// 3. Subscription was canceled by the developer
	CancelReason int64 `json:"cancelReason,omitempty"`

	// CancelSurveyResult: Information provided by the user when they
	// complete the subscription cancellation flow (cancellation reason
	// survey).
	CancelSurveyResult *SubscriptionCancelSurveyResult `json:"cancelSurveyResult,omitempty"`

	// CountryCode: ISO 3166-1 alpha-2 billing country/region code of the
	// user at the time the subscription was granted.
	CountryCode string `json:"countryCode,omitempty"`

	// DeveloperPayload: A developer-specified string that contains
	// supplemental information about an order.
	DeveloperPayload string `json:"developerPayload,omitempty"`

	// EmailAddress: The email address of the user when the subscription was
	// purchased. Only present for purchases made with 'Subscribe with
	// Google'.
	EmailAddress string `json:"emailAddress,omitempty"`

	// ExpiryTimeMillis: Time at which the subscription will expire, in
	// milliseconds since the Epoch.
	ExpiryTimeMillis int64 `json:"expiryTimeMillis,omitempty,string"`

	// ExternalAccountId: User account identifier in the third-party
	// service. Only present if account linking happened as part of the
	// subscription purchase flow.
	ExternalAccountId string `json:"externalAccountId,omitempty"`

	// FamilyName: The family name of the user when the subscription was
	// purchased. Only present for purchases made with 'Subscribe with
	// Google'.
	FamilyName string `json:"familyName,omitempty"`

	// GivenName: The given name of the user when the subscription was
	// purchased. Only present for purchases made with 'Subscribe with
	// Google'.
	GivenName string `json:"givenName,omitempty"`

	// IntroductoryPriceInfo: Introductory price information of the
	// subscription. This is only present when the subscription was
	// purchased with an introductory price. This field does not indicate
	// the subscription is currently in introductory price period.
	IntroductoryPriceInfo *IntroductoryPriceInfo `json:"introductoryPriceInfo,omitempty"`

	// Kind: This kind represents a subscriptionPurchase object in the
	// androidpublisher service.
	Kind string `json:"kind,omitempty"`

	// LinkedPurchaseToken: The purchase token of the originating purchase
	// if this subscription is one of the following: 0. Re-signup of a
	// canceled but non-lapsed subscription 1. Upgrade/downgrade from a
	// previous subscription For example, suppose a user originally signs up
	// and you receive purchase token X, then the user cancels and goes
	// through the resignup flow (before their subscription lapses) and you
	// receive purchase token Y, and finally the user upgrades their
	// subscription and you receive purchase token Z. If you call this API
	// with purchase token Z, this field will be set to Y. If you call this
	// API with purchase token Y, this field will be set to X. If you call
	// this API with purchase token X, this field will not be set.
	LinkedPurchaseToken string `json:"linkedPurchaseToken,omitempty"`

	// ObfuscatedExternalAccountId: An obfuscated version of the id that is
	// uniquely associated with the user's account in your app. Present for
	// the following purchases: * If account linking happened as part of the
	// subscription purchase flow. * It was specified using
	// https://developer.android.com/reference/com/android/billingclient/api/BillingFlowParams.Builder#setobfuscatedaccountid
	// when the purchase was made.
	ObfuscatedExternalAccountId string `json:"obfuscatedExternalAccountId,omitempty"`

	// ObfuscatedExternalProfileId: An obfuscated version of the id that is
	// uniquely associated with the user's profile in your app. Only present
	// if specified using
	// https://developer.android.com/reference/com/android/billingclient/api/BillingFlowParams.Builder#setobfuscatedprofileid
	// when the purchase was made.
	ObfuscatedExternalProfileId string `json:"obfuscatedExternalProfileId,omitempty"`

	// OrderId: The order id of the latest recurring order associated with
	// the purchase of the subscription. If the subscription was canceled
	// because payment was declined, this will be the order id from the
	// payment declined order.
	OrderId string `json:"orderId,omitempty"`

	// PaymentState: The payment state of the subscription. Possible values
	// are: 0. Payment pending 1. Payment received 2. Free trial 3. Pending
	// deferred upgrade/downgrade Not present for canceled, expired
	// subscriptions.
	PaymentState *int64 `json:"paymentState,omitempty"`

	// PriceAmountMicros: Price of the subscription, For tax exclusive
	// countries, the price doesn't include tax. For tax inclusive
	// countries, the price includes tax. Price is expressed in micro-units,
	// where 1,000,000 micro-units represents one unit of the currency. For
	// example, if the subscription price is €1.99, price_amount_micros is
	// 1990000.
	PriceAmountMicros int64 `json:"priceAmountMicros,omitempty,string"`

	// PriceChange: The latest price change information available. This is
	// present only when there is an upcoming price change for the
	// subscription yet to be applied. Once the subscription renews with the
	// new price or the subscription is canceled, no price change
	// information will be returned.
	PriceChange *SubscriptionPriceChange `json:"priceChange,omitempty"`

	// PriceCurrencyCode: ISO 4217 currency code for the subscription price.
	// For example, if the price is specified in British pounds sterling,
	// price_currency_code is "GBP".
	PriceCurrencyCode string `json:"priceCurrencyCode,omitempty"`

	// ProfileId: The Google profile id of the user when the subscription
	// was purchased. Only present for purchases made with 'Subscribe with
	// Google'.
	ProfileId string `json:"profileId,omitempty"`

	// ProfileName: The profile name of the user when the subscription was
	// purchased. Only present for purchases made with 'Subscribe with
	// Google'.
	ProfileName string `json:"profileName,omitempty"`

	// PromotionCode: The promotion code applied on this purchase. This
	// field is only set if a vanity code promotion is applied when the
	// subscription was purchased.
	PromotionCode string `json:"promotionCode,omitempty"`

	// PromotionType: The type of promotion applied on this purchase. This
	// field is only set if a promotion is applied when the subscription was
	// purchased. Possible values are: 0. One time code 1. Vanity code
	PromotionType int64 `json:"promotionType,omitempty"`

	// PurchaseType: The type of purchase of the subscription. This field is
	// only set if this purchase was not made using the standard in-app
	// billing flow. Possible values are: 0. Test (i.e. purchased from a
	// license testing account) 1. Promo (i.e. purchased using a promo code)
	PurchaseType *int64 `json:"purchaseType,omitempty"`

	// StartTimeMillis: Time at which the subscription was granted, in
	// milliseconds since the Epoch.
	StartTimeMillis int64 `json:"startTimeMillis,omitempty,string"`

	// UserCancellationTimeMillis: The time at which the subscription was
	// canceled by the user, in milliseconds since the epoch. Only present
	// if cancelReason is 0.
	UserCancellationTimeMillis int64 `json:"userCancellationTimeMillis,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AcknowledgementState") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcknowledgementState") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionPurchase) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionPurchase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionPurchaseLineItem: Item-level info for a subscription
// purchase.
type SubscriptionPurchaseLineItem struct {
	// AutoRenewingPlan: The item is auto renewing.
	AutoRenewingPlan *AutoRenewingPlan `json:"autoRenewingPlan,omitempty"`

	// DeferredItemReplacement: Information for deferred item replacement.
	DeferredItemReplacement *DeferredItemReplacement `json:"deferredItemReplacement,omitempty"`

	// ExpiryTime: Time at which the subscription expired or will expire
	// unless the access is extended (ex. renews).
	ExpiryTime string `json:"expiryTime,omitempty"`

	// OfferDetails: The offer details for this item.
	OfferDetails *OfferDetails `json:"offerDetails,omitempty"`

	// PrepaidPlan: The item is prepaid.
	PrepaidPlan *PrepaidPlan `json:"prepaidPlan,omitempty"`

	// ProductId: The purchased product ID (for example, 'monthly001').
	ProductId string `json:"productId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoRenewingPlan") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoRenewingPlan") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionPurchaseLineItem) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionPurchaseLineItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionPurchaseV2: Indicates the status of a user's subscription
// purchase.
type SubscriptionPurchaseV2 struct {
	// AcknowledgementState: The acknowledgement state of the subscription.
	//
	// Possible values:
	//   "ACKNOWLEDGEMENT_STATE_UNSPECIFIED" - Unspecified acknowledgement
	// state.
	//   "ACKNOWLEDGEMENT_STATE_PENDING" - The subscription is not
	// acknowledged yet.
	//   "ACKNOWLEDGEMENT_STATE_ACKNOWLEDGED" - The subscription is
	// acknowledged.
	AcknowledgementState string `json:"acknowledgementState,omitempty"`

	// CanceledStateContext: Additional context around canceled
	// subscriptions. Only present if the subscription currently has
	// subscription_state SUBSCRIPTION_STATE_CANCELED.
	CanceledStateContext *CanceledStateContext `json:"canceledStateContext,omitempty"`

	// ExternalAccountIdentifiers: User account identifier in the
	// third-party service.
	ExternalAccountIdentifiers *ExternalAccountIdentifiers `json:"externalAccountIdentifiers,omitempty"`

	// Kind: This kind represents a SubscriptionPurchaseV2 object in the
	// androidpublisher service.
	Kind string `json:"kind,omitempty"`

	// LatestOrderId: The order id of the latest order associated with the
	// purchase of the subscription. For autoRenewing subscription, this is
	// the order id of signup order if it is not renewed yet, or the last
	// recurring order id (success, pending, or declined order). For prepaid
	// subscription, this is the order id associated with the queried
	// purchase token.
	LatestOrderId string `json:"latestOrderId,omitempty"`

	// LineItems: Item-level info for a subscription purchase. The items in
	// the same purchase should be either all with AutoRenewingPlan or all
	// with PrepaidPlan.
	LineItems []*SubscriptionPurchaseLineItem `json:"lineItems,omitempty"`

	// LinkedPurchaseToken: The purchase token of the old subscription if
	// this subscription is one of the following: * Re-signup of a canceled
	// but non-lapsed subscription * Upgrade/downgrade from a previous
	// subscription. * Convert from prepaid to auto renewing subscription. *
	// Convert from an auto renewing subscription to prepaid. * Topup a
	// prepaid subscription.
	LinkedPurchaseToken string `json:"linkedPurchaseToken,omitempty"`

	// PausedStateContext: Additional context around paused subscriptions.
	// Only present if the subscription currently has subscription_state
	// SUBSCRIPTION_STATE_PAUSED.
	PausedStateContext *PausedStateContext `json:"pausedStateContext,omitempty"`

	// RegionCode: ISO 3166-1 alpha-2 billing country/region code of the
	// user at the time the subscription was granted.
	RegionCode string `json:"regionCode,omitempty"`

	// StartTime: Time at which the subscription was granted. Not set for
	// pending subscriptions (subscription was created but awaiting payment
	// during signup).
	StartTime string `json:"startTime,omitempty"`

	// SubscribeWithGoogleInfo: User profile associated with purchases made
	// with 'Subscribe with Google'.
	SubscribeWithGoogleInfo *SubscribeWithGoogleInfo `json:"subscribeWithGoogleInfo,omitempty"`

	// SubscriptionState: The current state of the subscription.
	//
	// Possible values:
	//   "SUBSCRIPTION_STATE_UNSPECIFIED" - Unspecified subscription state.
	//   "SUBSCRIPTION_STATE_PENDING" - Subscription was created but
	// awaiting payment during signup. In this state, all items are awaiting
	// payment.
	//   "SUBSCRIPTION_STATE_ACTIVE" - Subscription is active. - (1) If the
	// subscription is an auto renewing plan, at least one item is
	// auto_renew_enabled and not expired. - (2) If the subscription is a
	// prepaid plan, at least one item is not expired.
	//   "SUBSCRIPTION_STATE_PAUSED" - Subscription is paused. The state is
	// only available when the subscription is an auto renewing plan. In
	// this state, all items are in paused state.
	//   "SUBSCRIPTION_STATE_IN_GRACE_PERIOD" - Subscription is in grace
	// period. The state is only available when the subscription is an auto
	// renewing plan. In this state, all items are in grace period.
	//   "SUBSCRIPTION_STATE_ON_HOLD" - Subscription is on hold (suspended).
	// The state is only available when the subscription is an auto renewing
	// plan. In this state, all items are on hold.
	//   "SUBSCRIPTION_STATE_CANCELED" - Subscription is canceled but not
	// expired yet. The state is only available when the subscription is an
	// auto renewing plan. All items have auto_renew_enabled set to false.
	//   "SUBSCRIPTION_STATE_EXPIRED" - Subscription is expired. All items
	// have expiry_time in the past.
	SubscriptionState string `json:"subscriptionState,omitempty"`

	// TestPurchase: Only present if this subscription purchase is a test
	// purchase.
	TestPurchase *TestPurchase `json:"testPurchase,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AcknowledgementState") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcknowledgementState") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionPurchaseV2) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionPurchaseV2
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionPurchasesAcknowledgeRequest: Request for the
// purchases.subscriptions.acknowledge API.
type SubscriptionPurchasesAcknowledgeRequest struct {
	// DeveloperPayload: Payload to attach to the purchase.
	DeveloperPayload string `json:"developerPayload,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeveloperPayload") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeveloperPayload") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionPurchasesAcknowledgeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionPurchasesAcknowledgeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionPurchasesDeferRequest: Request for the
// purchases.subscriptions.defer API.
type SubscriptionPurchasesDeferRequest struct {
	// DeferralInfo: The information about the new desired expiry time for
	// the subscription.
	DeferralInfo *SubscriptionDeferralInfo `json:"deferralInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeferralInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeferralInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionPurchasesDeferRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionPurchasesDeferRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionPurchasesDeferResponse: Response for the
// purchases.subscriptions.defer API.
type SubscriptionPurchasesDeferResponse struct {
	// NewExpiryTimeMillis: The new expiry time for the subscription in
	// milliseconds since the Epoch.
	NewExpiryTimeMillis int64 `json:"newExpiryTimeMillis,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NewExpiryTimeMillis")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NewExpiryTimeMillis") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionPurchasesDeferResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionPurchasesDeferResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SubscriptionTaxAndComplianceSettings: Details about taxation, Google
// Play policy and legal compliance for subscription products.
type SubscriptionTaxAndComplianceSettings struct {
	// EeaWithdrawalRightType: Digital content or service classification for
	// products distributed to users in the European Economic Area (EEA).
	// The withdrawal regime under EEA consumer laws depends on this
	// classification. Refer to the Help Center article
	// (https://support.google.com/googleplay/android-developer/answer/10463498)
	// for more information.
	//
	// Possible values:
	//   "WITHDRAWAL_RIGHT_TYPE_UNSPECIFIED"
	//   "WITHDRAWAL_RIGHT_DIGITAL_CONTENT"
	//   "WITHDRAWAL_RIGHT_SERVICE"
	EeaWithdrawalRightType string `json:"eeaWithdrawalRightType,omitempty"`

	// IsTokenizedDigitalAsset: Whether this subscription is declared as a
	// product representing a tokenized digital asset.
	IsTokenizedDigitalAsset bool `json:"isTokenizedDigitalAsset,omitempty"`

	// TaxRateInfoByRegionCode: A mapping from region code to tax rate
	// details. The keys are region codes as defined by Unicode's "CLDR".
	TaxRateInfoByRegionCode map[string]RegionalTaxRateInfo `json:"taxRateInfoByRegionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EeaWithdrawalRightType") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EeaWithdrawalRightType")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SubscriptionTaxAndComplianceSettings) MarshalJSON() ([]byte, error) {
	type NoMethod SubscriptionTaxAndComplianceSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SystemApkOptions: Options for system APKs.
type SystemApkOptions struct {
	// Rotated: Whether to use the rotated key for signing the system APK.
	Rotated bool `json:"rotated,omitempty"`

	// UncompressedDexFiles: Whether system APK was generated with
	// uncompressed dex files.
	UncompressedDexFiles bool `json:"uncompressedDexFiles,omitempty"`

	// UncompressedNativeLibraries: Whether system APK was generated with
	// uncompressed native libraries.
	UncompressedNativeLibraries bool `json:"uncompressedNativeLibraries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Rotated") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Rotated") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SystemApkOptions) MarshalJSON() ([]byte, error) {
	type NoMethod SystemApkOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SystemApksListResponse: Response to list previously created system
// APK variants.
type SystemApksListResponse struct {
	// Variants: All system APK variants created.
	Variants []*Variant `json:"variants,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Variants") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Variants") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SystemApksListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SystemApksListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SystemFeature: Representation of a system feature.
type SystemFeature struct {
	// Name: The name of the feature.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SystemFeature) MarshalJSON() ([]byte, error) {
	type NoMethod SystemFeature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SystemInitiatedCancellation: Information specific to cancellations
// initiated by Google system.
type SystemInitiatedCancellation struct {
}

// Targeting: Targeting details for a recovery action such as regions,
// android sdk levels, app versions etc.
type Targeting struct {
	// AllUsers: All users are targeted.
	AllUsers *AllUsers `json:"allUsers,omitempty"`

	// AndroidSdks: Targeting is based on android api levels of devices.
	AndroidSdks *AndroidSdks `json:"androidSdks,omitempty"`

	// Regions: Targeting is based on the user account region.
	Regions *Regions `json:"regions,omitempty"`

	// VersionList: Target version codes as a list.
	VersionList *AppVersionList `json:"versionList,omitempty"`

	// VersionRange: Target version codes as a range.
	VersionRange *AppVersionRange `json:"versionRange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllUsers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllUsers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Targeting) MarshalJSON() ([]byte, error) {
	type NoMethod Targeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TargetingInfo: Targeting information about the generated apks.
type TargetingInfo struct {
	// AssetSliceSet: List of created asset slices.
	AssetSliceSet []*AssetSliceSet `json:"assetSliceSet,omitempty"`

	// PackageName: The package name of this app.
	PackageName string `json:"packageName,omitempty"`

	// Variant: List of the created variants.
	Variant []*SplitApkVariant `json:"variant,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AssetSliceSet") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetSliceSet") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TargetingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod TargetingInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TargetingRuleScope: Defines the scope of subscriptions which a
// targeting rule can match to target offers to users based on past or
// current entitlement.
type TargetingRuleScope struct {
	// SpecificSubscriptionInApp: The scope of the current targeting rule is
	// the subscription with the specified subscription ID. Must be a
	// subscription within the same parent app.
	SpecificSubscriptionInApp string `json:"specificSubscriptionInApp,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SpecificSubscriptionInApp") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "SpecificSubscriptionInApp") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TargetingRuleScope) MarshalJSON() ([]byte, error) {
	type NoMethod TargetingRuleScope
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TargetingUpdate: Update type for targeting. Note it is always a
// subset Targeting.
type TargetingUpdate struct {
	// AllUsers: All users are targeted.
	AllUsers *AllUsers `json:"allUsers,omitempty"`

	// AndroidSdks: Additional android sdk levels are targeted by the
	// recovery action.
	AndroidSdks *AndroidSdks `json:"androidSdks,omitempty"`

	// Regions: Additional regions are targeted by the recovery action.
	Regions *Regions `json:"regions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllUsers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllUsers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TargetingUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod TargetingUpdate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TestPurchase: Whether this subscription purchase is a test purchase.
type TestPurchase struct {
}

// Testers: The testers of an app. The resource for TestersService.
// Note: while it is possible in the Play Console UI to add testers via
// email lists, email lists are not supported by this resource.
type Testers struct {
	// GoogleGroups: All testing Google Groups, as email addresses.
	GoogleGroups []string `json:"googleGroups,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "GoogleGroups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GoogleGroups") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Testers) MarshalJSON() ([]byte, error) {
	type NoMethod Testers
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TextureCompressionFormat: Represents texture compression format.
type TextureCompressionFormat struct {
	// Alias: Alias for texture compression format.
	//
	// Possible values:
	//   "UNSPECIFIED_TEXTURE_COMPRESSION_FORMAT" - Unspecified format.
	//   "ETC1_RGB8" - ETC1_RGB8 format.
	//   "PALETTED" - PALETTED format.
	//   "THREE_DC" - THREE_DC format.
	//   "ATC" - ATC format.
	//   "LATC" - LATC format.
	//   "DXT1" - DXT1 format.
	//   "S3TC" - S3TC format.
	//   "PVRTC" - PVRTC format.
	//   "ASTC" - ASTC format.
	//   "ETC2" - ETC2 format.
	Alias string `json:"alias,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alias") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TextureCompressionFormat) MarshalJSON() ([]byte, error) {
	type NoMethod TextureCompressionFormat
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TextureCompressionFormatTargeting: Targeting by a texture compression
// format.
type TextureCompressionFormatTargeting struct {
	// Alternatives: List of alternative TCFs (TCFs targeted by the sibling
	// splits).
	Alternatives []*TextureCompressionFormat `json:"alternatives,omitempty"`

	// Value: The list of targeted TCFs. Should not be empty.
	Value []*TextureCompressionFormat `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alternatives") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alternatives") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TextureCompressionFormatTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod TextureCompressionFormatTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Timestamp: A Timestamp represents a point in time independent of any
// time zone or local calendar, encoded as a count of seconds and
// fractions of seconds at nanosecond resolution. The count is relative
// to an epoch at UTC midnight on January 1, 1970.
type Timestamp struct {
	// Nanos: Non-negative fractions of a second at nanosecond resolution.
	// Must be from 0 to 999,999,999 inclusive.
	Nanos int64 `json:"nanos,omitempty"`

	// Seconds: Represents seconds of UTC time since Unix epoch.
	Seconds int64 `json:"seconds,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Nanos") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Nanos") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Timestamp) MarshalJSON() ([]byte, error) {
	type NoMethod Timestamp
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TokenPagination: Pagination information returned by a List operation
// when token pagination is enabled. List operations that supports
// paging return only one "page" of results. This protocol buffer
// message describes the page that has been returned. When using token
// pagination, clients should use the next/previous token to get another
// page of the result. The presence or absence of next/previous token
// indicates whether a next/previous page is available and provides a
// mean of accessing this page. ListRequest.page_token should be set to
// either next_page_token or previous_page_token to access another page.
type TokenPagination struct {
	// NextPageToken: Tokens to pass to the standard list field
	// 'page_token'. Whenever available, tokens are preferred over
	// manipulating start_index.
	NextPageToken string `json:"nextPageToken,omitempty"`

	PreviousPageToken string `json:"previousPageToken,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TokenPagination) MarshalJSON() ([]byte, error) {
	type NoMethod TokenPagination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Track: A track configuration. The resource for TracksService.
type Track struct {
	// Releases: In a read request, represents all active releases in the
	// track. In an update request, represents desired changes.
	Releases []*TrackRelease `json:"releases,omitempty"`

	// Track: Identifier of the track. Form factor tracks have a special
	// prefix as an identifier, for example `wear:production`,
	// `automotive:production`. More on track name
	// (https://developers.google.com/android-publisher/tracks#ff-track-name)
	Track string `json:"track,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Releases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Releases") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Track) MarshalJSON() ([]byte, error) {
	type NoMethod Track
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TrackConfig: Configurations of the new track.
type TrackConfig struct {
	// FormFactor: Required. Form factor of the new track. Defaults to the
	// default track.
	//
	// Possible values:
	//   "FORM_FACTOR_UNSPECIFIED" - Fallback value, do not use.
	//   "DEFAULT" - Default track.
	//   "WEAR" - Wear form factor track.
	//   "AUTOMOTIVE" - Automotive form factor track.
	FormFactor string `json:"formFactor,omitempty"`

	// Track: Required. Identifier of the new track. For default tracks,
	// this field consists of the track alias only. Form factor tracks have
	// a special prefix as an identifier, for example `wear:production`,
	// `automotive:production`. This prefix must match the value of the
	// `form_factor` field, if it is not a default track. More on track name
	// (https://developers.google.com/android-publisher/tracks#ff-track-name)
	Track string `json:"track,omitempty"`

	// Type: Required. Type of the new track. Currently, the only supported
	// value is closedTesting.
	//
	// Possible values:
	//   "TRACK_TYPE_UNSPECIFIED" - Fallback value, do not use.
	//   "CLOSED_TESTING" - Closed testing track.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormFactor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormFactor") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TrackConfig) MarshalJSON() ([]byte, error) {
	type NoMethod TrackConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TrackCountryAvailability: Resource for per-track country availability
// information.
type TrackCountryAvailability struct {
	// Countries: A list of one or more countries where artifacts in this
	// track are available. This list includes all countries that are
	// targeted by the track, even if only specific carriers are targeted in
	// that country.
	Countries []*TrackTargetedCountry `json:"countries,omitempty"`

	// RestOfWorld: Whether artifacts in this track are available to "rest
	// of the world" countries.
	RestOfWorld bool `json:"restOfWorld,omitempty"`

	// SyncWithProduction: Whether this track's availability is synced with
	// the default production track. See
	// https://support.google.com/googleplay/android-developer/answer/7550024
	// for more information on syncing country availability with production.
	// Note that if this is true, the returned "countries" and
	// "rest_of_world" fields will reflect the values for the default
	// production track.
	SyncWithProduction bool `json:"syncWithProduction,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Countries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Countries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TrackCountryAvailability) MarshalJSON() ([]byte, error) {
	type NoMethod TrackCountryAvailability
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TrackRelease: A release within a track.
type TrackRelease struct {
	// CountryTargeting: Restricts a release to a specific set of countries.
	CountryTargeting *CountryTargeting `json:"countryTargeting,omitempty"`

	// InAppUpdatePriority: In-app update priority of the release. All newly
	// added APKs in the release will be considered at this priority. Can
	// take values in the range [0, 5], with 5 the highest priority.
	// Defaults to 0. in_app_update_priority can not be updated once the
	// release is rolled out. See
	// https://developer.android.com/guide/playcore/in-app-updates.
	InAppUpdatePriority int64 `json:"inAppUpdatePriority,omitempty"`

	// Name: The release name. Not required to be unique. If not set, the
	// name is generated from the APK's version_name. If the release
	// contains multiple APKs, the name is generated from the date.
	Name string `json:"name,omitempty"`

	// ReleaseNotes: A description of what is new in this release.
	ReleaseNotes []*LocalizedText `json:"releaseNotes,omitempty"`

	// Status: The status of the release.
	//
	// Possible values:
	//   "statusUnspecified" - Unspecified status.
	//   "draft" - The release's APKs are not being served to users.
	//   "inProgress" - The release's APKs are being served to a fraction of
	// users, determined by 'user_fraction'.
	//   "halted" - The release's APKs will no longer be served to users.
	// Users who already have these APKs are unaffected.
	//   "completed" - The release will have no further changes. Its APKs
	// are being served to all users, unless they are eligible to APKs of a
	// more recent release.
	Status string `json:"status,omitempty"`

	// UserFraction: Fraction of users who are eligible for a staged
	// release. 0 < fraction < 1. Can only be set when status is
	// "inProgress" or "halted".
	UserFraction float64 `json:"userFraction,omitempty"`

	// VersionCodes: Version codes of all APKs in the release. Must include
	// version codes to retain from previous releases.
	VersionCodes googleapi.Int64s `json:"versionCodes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CountryTargeting") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CountryTargeting") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *TrackRelease) MarshalJSON() ([]byte, error) {
	type NoMethod TrackRelease
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *TrackRelease) UnmarshalJSON(data []byte) error {
	type NoMethod TrackRelease
	var s1 struct {
		UserFraction gensupport.JSONFloat64 `json:"userFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.UserFraction = float64(s1.UserFraction)
	return nil
}

// TrackTargetedCountry: Representation of a single country where the
// contents of a track are available.
type TrackTargetedCountry struct {
	// CountryCode: The country to target, as a two-letter CLDR code.
	CountryCode string `json:"countryCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CountryCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CountryCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TrackTargetedCountry) MarshalJSON() ([]byte, error) {
	type NoMethod TrackTargetedCountry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TracksListResponse: Response listing all tracks.
type TracksListResponse struct {
	// Kind: The kind of this response
	// ("androidpublisher#tracksListResponse").
	Kind string `json:"kind,omitempty"`

	// Tracks: All tracks (including tracks with no releases).
	Tracks []*Track `json:"tracks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TracksListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TracksListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpdateBasePlanStateRequest: Request message to update the state of a
// subscription base plan.
type UpdateBasePlanStateRequest struct {
	// ActivateBasePlanRequest: Activates a base plan. Once activated, base
	// plans will be available to new subscribers.
	ActivateBasePlanRequest *ActivateBasePlanRequest `json:"activateBasePlanRequest,omitempty"`

	// DeactivateBasePlanRequest: Deactivates a base plan. Once deactivated,
	// the base plan will become unavailable to new subscribers, but
	// existing subscribers will maintain their subscription
	DeactivateBasePlanRequest *DeactivateBasePlanRequest `json:"deactivateBasePlanRequest,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ActivateBasePlanRequest") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActivateBasePlanRequest")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *UpdateBasePlanStateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateBasePlanStateRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpdateSubscriptionOfferRequest: Request message for
// UpdateSubscriptionOffer.
type UpdateSubscriptionOfferRequest struct {
	// AllowMissing: Optional. If set to true, and the subscription offer
	// with the given package_name, product_id, base_plan_id and offer_id
	// doesn't exist, an offer will be created. If a new offer is created,
	// update_mask is ignored.
	AllowMissing bool `json:"allowMissing,omitempty"`

	// LatencyTolerance: Optional. The latency tolerance for the propagation
	// of this product update. Defaults to latency-sensitive.
	//
	// Possible values:
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
	// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
	// will propagate to clients within several minutes on average and up to
	// a few hours in rare cases. Throughput is limited to 7,200 updates per
	// app per hour.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
	// will propagate to clients within 24 hours. Supports high throughput
	// of up to 720,000 updates per app per hour using batch modification
	// methods.
	LatencyTolerance string `json:"latencyTolerance,omitempty"`

	// RegionsVersion: Required. The version of the available regions being
	// used for the subscription_offer.
	RegionsVersion *RegionsVersion `json:"regionsVersion,omitempty"`

	// SubscriptionOffer: Required. The subscription offer to update.
	SubscriptionOffer *SubscriptionOffer `json:"subscriptionOffer,omitempty"`

	// UpdateMask: Required. The list of fields to be updated.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowMissing") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UpdateSubscriptionOfferRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateSubscriptionOfferRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpdateSubscriptionOfferStateRequest: Request message to update the
// state of a subscription offer.
type UpdateSubscriptionOfferStateRequest struct {
	// ActivateSubscriptionOfferRequest: Activates an offer. Once activated,
	// the offer will be available to new subscribers.
	ActivateSubscriptionOfferRequest *ActivateSubscriptionOfferRequest `json:"activateSubscriptionOfferRequest,omitempty"`

	// DeactivateSubscriptionOfferRequest: Deactivates an offer. Once
	// deactivated, the offer will become unavailable to new subscribers,
	// but existing subscribers will maintain their subscription
	DeactivateSubscriptionOfferRequest *DeactivateSubscriptionOfferRequest `json:"deactivateSubscriptionOfferRequest,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ActivateSubscriptionOfferRequest") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ActivateSubscriptionOfferRequest") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UpdateSubscriptionOfferStateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateSubscriptionOfferStateRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpdateSubscriptionRequest: Request message for UpdateSubscription.
type UpdateSubscriptionRequest struct {
	// AllowMissing: Optional. If set to true, and the subscription with the
	// given package_name and product_id doesn't exist, the subscription
	// will be created. If a new subscription is created, update_mask is
	// ignored.
	AllowMissing bool `json:"allowMissing,omitempty"`

	// LatencyTolerance: Optional. The latency tolerance for the propagation
	// of this product update. Defaults to latency-sensitive.
	//
	// Possible values:
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
	// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
	// will propagate to clients within several minutes on average and up to
	// a few hours in rare cases. Throughput is limited to 7,200 updates per
	// app per hour.
	//   "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
	// will propagate to clients within 24 hours. Supports high throughput
	// of up to 720,000 updates per app per hour using batch modification
	// methods.
	LatencyTolerance string `json:"latencyTolerance,omitempty"`

	// RegionsVersion: Required. The version of the available regions being
	// used for the subscription.
	RegionsVersion *RegionsVersion `json:"regionsVersion,omitempty"`

	// Subscription: Required. The subscription to update.
	Subscription *Subscription `json:"subscription,omitempty"`

	// UpdateMask: Required. The list of fields to be updated.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowMissing") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UpdateSubscriptionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateSubscriptionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpgradeTargetingRule: Represents a targeting rule of the form: User
// currently has {scope} [with billing period {billing_period}].
type UpgradeTargetingRule struct {
	// BillingPeriodDuration: The specific billing period duration,
	// specified in ISO 8601 format, that a user must be currently
	// subscribed to to be eligible for this rule. If not specified, users
	// subscribed to any billing period are matched.
	BillingPeriodDuration string `json:"billingPeriodDuration,omitempty"`

	// OncePerUser: Limit this offer to only once per user. If set to true,
	// a user can never be eligible for this offer again if they ever
	// subscribed to this offer.
	OncePerUser bool `json:"oncePerUser,omitempty"`

	// Scope: Required. The scope of subscriptions this rule considers. Only
	// allows "this subscription" and "specific subscription in app".
	Scope *TargetingRuleScope `json:"scope,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BillingPeriodDuration") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BillingPeriodDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *UpgradeTargetingRule) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeTargetingRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// User: A user resource.
type User struct {
	// AccessState: Output only. The state of the user's access to the Play
	// Console.
	//
	// Possible values:
	//   "ACCESS_STATE_UNSPECIFIED" - Unknown or unspecified access state.
	//   "INVITED" - User is invited but has not yet accepted the
	// invitation.
	//   "INVITATION_EXPIRED" - Invitation has expired.
	//   "ACCESS_GRANTED" - User has accepted an invitation and has access
	// to the Play Console.
	//   "ACCESS_EXPIRED" - Account access has expired.
	AccessState string `json:"accessState,omitempty"`

	// DeveloperAccountPermissions: Permissions for the user which apply
	// across the developer account.
	//
	// Possible values:
	//   "DEVELOPER_LEVEL_PERMISSION_UNSPECIFIED" - Unknown or unspecified
	// permission.
	//   "CAN_SEE_ALL_APPS" - View app information and download bulk reports
	// (read-only). Deprecated: Check CAN_VIEW_NON_FINANCIAL_DATA_GLOBAL.
	//   "CAN_VIEW_FINANCIAL_DATA_GLOBAL" - View financial data, orders, and
	// cancellation survey responses.
	//   "CAN_MANAGE_PERMISSIONS_GLOBAL" - Admin (all permissions).
	//   "CAN_EDIT_GAMES_GLOBAL" - Edit Play Games Services projects.
	//   "CAN_PUBLISH_GAMES_GLOBAL" - Publish Play Games Services projects.
	//   "CAN_REPLY_TO_REVIEWS_GLOBAL" - Reply to reviews.
	//   "CAN_MANAGE_PUBLIC_APKS_GLOBAL" - Release to production, exclude
	// devices, and use app signing by Google Play.
	//   "CAN_MANAGE_TRACK_APKS_GLOBAL" - Release to testing tracks.
	//   "CAN_MANAGE_TRACK_USERS_GLOBAL" - Manage testing tracks and edit
	// tester lists.
	//   "CAN_MANAGE_PUBLIC_LISTING_GLOBAL" - Manage store presence.
	//   "CAN_MANAGE_DRAFT_APPS_GLOBAL" - Create, edit, and delete draft
	// apps.
	//   "CAN_CREATE_MANAGED_PLAY_APPS_GLOBAL" - Create and publish private
	// apps to your organization.
	//   "CAN_CHANGE_MANAGED_PLAY_SETTING_GLOBAL" - Choose whether apps are
	// public, or only available to your organization.
	//   "CAN_MANAGE_ORDERS_GLOBAL" - Manage orders and subscriptions.
	//   "CAN_MANAGE_APP_CONTENT_GLOBAL" - Manage policy related pages on
	// all apps for the developer.
	//   "CAN_VIEW_NON_FINANCIAL_DATA_GLOBAL" - View app information and
	// download bulk reports (read-only).
	//   "CAN_VIEW_APP_QUALITY_GLOBAL" - View app quality information for
	// all apps for the developer.
	DeveloperAccountPermissions []string `json:"developerAccountPermissions,omitempty"`

	// Email: Immutable. The user's email address.
	Email string `json:"email,omitempty"`

	// ExpirationTime: The time at which the user's access expires, if set.
	// When setting this value, it must always be in the future.
	ExpirationTime string `json:"expirationTime,omitempty"`

	// Grants: Output only. Per-app permissions for the user.
	Grants []*Grant `json:"grants,omitempty"`

	// Name: Required. Resource name for this user, following the pattern
	// "developers/{developer}/users/{email}".
	Name string `json:"name,omitempty"`

	// Partial: Output only. Whether there are more permissions for the user
	// that are not represented here. This can happen if the caller does not
	// have permission to manage all apps in the account. This is also
	// `true` if this user is the account owner. If this field is `true`, it
	// should be taken as a signal that this user cannot be fully managed
	// via the API. That is, the API caller is not be able to manage all of
	// the permissions this user holds, either because it doesn't know about
	// them or because the user is the account owner.
	Partial bool `json:"partial,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessState") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessState") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *User) MarshalJSON() ([]byte, error) {
	type NoMethod User
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UserComment: User entry from conversation between user and developer.
type UserComment struct {
	// AndroidOsVersion: Integer Android SDK version of the user's device at
	// the time the review was written, e.g. 23 is Marshmallow. May be
	// absent.
	AndroidOsVersion int64 `json:"androidOsVersion,omitempty"`

	// AppVersionCode: Integer version code of the app as installed at the
	// time the review was written. May be absent.
	AppVersionCode int64 `json:"appVersionCode,omitempty"`

	// AppVersionName: String version name of the app as installed at the
	// time the review was written. May be absent.
	AppVersionName string `json:"appVersionName,omitempty"`

	// Device: Codename for the reviewer's device, e.g. klte, flounder. May
	// be absent.
	Device string `json:"device,omitempty"`

	// DeviceMetadata: Information about the characteristics of the user's
	// device.
	DeviceMetadata *DeviceMetadata `json:"deviceMetadata,omitempty"`

	// LastModified: The last time at which this comment was updated.
	LastModified *Timestamp `json:"lastModified,omitempty"`

	// OriginalText: Untranslated text of the review, where the review was
	// translated. If the review was not translated this is left blank.
	OriginalText string `json:"originalText,omitempty"`

	// ReviewerLanguage: Language code for the reviewer. This is taken from
	// the device settings so is not guaranteed to match the language the
	// review is written in. May be absent.
	ReviewerLanguage string `json:"reviewerLanguage,omitempty"`

	// StarRating: The star rating associated with the review, from 1 to 5.
	StarRating int64 `json:"starRating,omitempty"`

	// Text: The content of the comment, i.e. review body. In some cases
	// users have been able to write a review with separate title and body;
	// in those cases the title and body are concatenated and separated by a
	// tab character.
	Text string `json:"text,omitempty"`

	// ThumbsDownCount: Number of users who have given this review a thumbs
	// down.
	ThumbsDownCount int64 `json:"thumbsDownCount,omitempty"`

	// ThumbsUpCount: Number of users who have given this review a thumbs
	// up.
	ThumbsUpCount int64 `json:"thumbsUpCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AndroidOsVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndroidOsVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *UserComment) MarshalJSON() ([]byte, error) {
	type NoMethod UserComment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UserCountriesTargeting: Describes an inclusive/exclusive list of
// country codes that module targets.
type UserCountriesTargeting struct {
	// CountryCodes: List of country codes in the two-letter CLDR territory
	// format.
	CountryCodes []string `json:"countryCodes,omitempty"`

	// Exclude: Indicates if the list above is exclusive.
	Exclude bool `json:"exclude,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CountryCodes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CountryCodes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UserCountriesTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod UserCountriesTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UserCountrySet: A set of user countries. A country set determines
// what variation of app content gets served to a specific location.
type UserCountrySet struct {
	// CountryCodes: List of country codes representing countries. A Country
	// code is represented in ISO 3166 alpha-2 format. For Example:- "IT"
	// for Italy, "GE" for Georgia.
	CountryCodes []string `json:"countryCodes,omitempty"`

	// Name: Country set name.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CountryCodes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CountryCodes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UserCountrySet) MarshalJSON() ([]byte, error) {
	type NoMethod UserCountrySet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UserInitiatedCancellation: Information specific to cancellations
// initiated by users.
type UserInitiatedCancellation struct {
	// CancelSurveyResult: Information provided by the user when they
	// complete the subscription cancellation flow (cancellation reason
	// survey).
	CancelSurveyResult *CancelSurveyResult `json:"cancelSurveyResult,omitempty"`

	// CancelTime: The time at which the subscription was canceled by the
	// user. The user might still have access to the subscription after this
	// time. Use line_items.expiry_time to determine if a user still has
	// access.
	CancelTime string `json:"cancelTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CancelSurveyResult")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CancelSurveyResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *UserInitiatedCancellation) MarshalJSON() ([]byte, error) {
	type NoMethod UserInitiatedCancellation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UsesPermission: A permission used by this APK.
type UsesPermission struct {
	// MaxSdkVersion: Optionally, the maximum SDK version for which the
	// permission is required.
	MaxSdkVersion int64 `json:"maxSdkVersion,omitempty"`

	// Name: The name of the permission requested.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxSdkVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxSdkVersion") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UsesPermission) MarshalJSON() ([]byte, error) {
	type NoMethod UsesPermission
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Variant: APK that is suitable for inclusion in a system image. The
// resource of SystemApksService.
type Variant struct {
	// DeviceSpec: The device spec used to generate the APK.
	DeviceSpec *DeviceSpec `json:"deviceSpec,omitempty"`

	// Options: Optional. Options applied to the generated APK.
	Options *SystemApkOptions `json:"options,omitempty"`

	// VariantId: Output only. The ID of a previously created system APK
	// variant.
	VariantId int64 `json:"variantId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DeviceSpec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceSpec") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Variant) MarshalJSON() ([]byte, error) {
	type NoMethod Variant
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VariantTargeting: Targeting on the level of variants.
type VariantTargeting struct {
	// AbiTargeting: The abi that the variant targets
	AbiTargeting *AbiTargeting `json:"abiTargeting,omitempty"`

	// MultiAbiTargeting: Multi-api-level targeting
	MultiAbiTargeting *MultiAbiTargeting `json:"multiAbiTargeting,omitempty"`

	// ScreenDensityTargeting: The screen densities that this variant
	// supports
	ScreenDensityTargeting *ScreenDensityTargeting `json:"screenDensityTargeting,omitempty"`

	// SdkVersionTargeting: The sdk version that the variant targets
	SdkVersionTargeting *SdkVersionTargeting `json:"sdkVersionTargeting,omitempty"`

	// TextureCompressionFormatTargeting: Texture-compression-format-level
	// targeting
	TextureCompressionFormatTargeting *TextureCompressionFormatTargeting `json:"textureCompressionFormatTargeting,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AbiTargeting") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AbiTargeting") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VariantTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod VariantTargeting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VoidedPurchase: A VoidedPurchase resource indicates a purchase that
// was either canceled/refunded/charged-back.
type VoidedPurchase struct {
	// Kind: This kind represents a voided purchase object in the
	// androidpublisher service.
	Kind string `json:"kind,omitempty"`

	// OrderId: The order id which uniquely identifies a one-time purchase,
	// subscription purchase, or subscription renewal.
	OrderId string `json:"orderId,omitempty"`

	// PurchaseTimeMillis: The time at which the purchase was made, in
	// milliseconds since the epoch (Jan 1, 1970).
	PurchaseTimeMillis int64 `json:"purchaseTimeMillis,omitempty,string"`

	// PurchaseToken: The token which uniquely identifies a one-time
	// purchase or subscription. To uniquely identify subscription renewals
	// use order_id (available starting from version 3 of the API).
	PurchaseToken string `json:"purchaseToken,omitempty"`

	// VoidedQuantity: The voided quantity as the result of a quantity-based
	// partial refund. Voided purchases of quantity-based partial refunds
	// may only be returned when includeQuantityBasedPartialRefund is set to
	// true.
	VoidedQuantity int64 `json:"voidedQuantity,omitempty"`

	// VoidedReason: The reason why the purchase was voided, possible values
	// are: 0. Other 1. Remorse 2. Not_received 3. Defective 4.
	// Accidental_purchase 5. Fraud 6. Friendly_fraud 7. Chargeback
	VoidedReason int64 `json:"voidedReason,omitempty"`

	// VoidedSource: The initiator of voided purchase, possible values are:
	// 0. User 1. Developer 2. Google
	VoidedSource int64 `json:"voidedSource,omitempty"`

	// VoidedTimeMillis: The time at which the purchase was
	// canceled/refunded/charged-back, in milliseconds since the epoch (Jan
	// 1, 1970).
	VoidedTimeMillis int64 `json:"voidedTimeMillis,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VoidedPurchase) MarshalJSON() ([]byte, error) {
	type NoMethod VoidedPurchase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VoidedPurchasesListResponse: Response for the voidedpurchases.list
// API.
type VoidedPurchasesListResponse struct {
	// PageInfo: General pagination information.
	PageInfo *PageInfo `json:"pageInfo,omitempty"`

	// TokenPagination: Pagination information for token pagination.
	TokenPagination *TokenPagination `json:"tokenPagination,omitempty"`

	VoidedPurchases []*VoidedPurchase `json:"voidedPurchases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "PageInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageInfo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VoidedPurchasesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod VoidedPurchasesListResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "androidpublisher.applications.dataSafety":

type ApplicationsDataSafetyCall struct {
	s                         *Service
	packageName               string
	safetylabelsupdaterequest *SafetyLabelsUpdateRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// DataSafety: Writes the Safety Labels declaration of an app.
//
// - packageName: Package name of the app.
func (r *ApplicationsService) DataSafety(packageName string, safetylabelsupdaterequest *SafetyLabelsUpdateRequest) *ApplicationsDataSafetyCall {
	c := &ApplicationsDataSafetyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.safetylabelsupdaterequest = safetylabelsupdaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ApplicationsDataSafetyCall) Fields(s ...googleapi.Field) *ApplicationsDataSafetyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ApplicationsDataSafetyCall) Context(ctx context.Context) *ApplicationsDataSafetyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ApplicationsDataSafetyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ApplicationsDataSafetyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.safetylabelsupdaterequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/dataSafety")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.applications.dataSafety" call.
// Exactly one of *SafetyLabelsUpdateResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *SafetyLabelsUpdateResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ApplicationsDataSafetyCall) Do(opts ...googleapi.CallOption) (*SafetyLabelsUpdateResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SafetyLabelsUpdateResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Writes the Safety Labels declaration of an app.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/dataSafety",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.applications.dataSafety",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/dataSafety",
	//   "request": {
	//     "$ref": "SafetyLabelsUpdateRequest"
	//   },
	//   "response": {
	//     "$ref": "SafetyLabelsUpdateResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.applications.deviceTierConfigs.create":

type ApplicationsDeviceTierConfigsCreateCall struct {
	s                *Service
	packageName      string
	devicetierconfig *DeviceTierConfig
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Create: Creates a new device tier config for an app.
//
// - packageName: Package name of the app.
func (r *ApplicationsDeviceTierConfigsService) Create(packageName string, devicetierconfig *DeviceTierConfig) *ApplicationsDeviceTierConfigsCreateCall {
	c := &ApplicationsDeviceTierConfigsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.devicetierconfig = devicetierconfig
	return c
}

// AllowUnknownDevices sets the optional parameter
// "allowUnknownDevices": Whether the service should accept device IDs
// that are unknown to Play's device catalog.
func (c *ApplicationsDeviceTierConfigsCreateCall) AllowUnknownDevices(allowUnknownDevices bool) *ApplicationsDeviceTierConfigsCreateCall {
	c.urlParams_.Set("allowUnknownDevices", fmt.Sprint(allowUnknownDevices))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ApplicationsDeviceTierConfigsCreateCall) Fields(s ...googleapi.Field) *ApplicationsDeviceTierConfigsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ApplicationsDeviceTierConfigsCreateCall) Context(ctx context.Context) *ApplicationsDeviceTierConfigsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ApplicationsDeviceTierConfigsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ApplicationsDeviceTierConfigsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.devicetierconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/deviceTierConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.applications.deviceTierConfigs.create" call.
// Exactly one of *DeviceTierConfig or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *DeviceTierConfig.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ApplicationsDeviceTierConfigsCreateCall) Do(opts ...googleapi.CallOption) (*DeviceTierConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DeviceTierConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new device tier config for an app.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/deviceTierConfigs",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.applications.deviceTierConfigs.create",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "allowUnknownDevices": {
	//       "description": "Whether the service should accept device IDs that are unknown to Play's device catalog.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/deviceTierConfigs",
	//   "request": {
	//     "$ref": "DeviceTierConfig"
	//   },
	//   "response": {
	//     "$ref": "DeviceTierConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.applications.deviceTierConfigs.get":

type ApplicationsDeviceTierConfigsGetCall struct {
	s                  *Service
	packageName        string
	deviceTierConfigId int64
	urlParams_         gensupport.URLParams
	ifNoneMatch_       string
	ctx_               context.Context
	header_            http.Header
}

// Get: Returns a particular device tier config.
//
// - deviceTierConfigId: Id of an existing device tier config.
// - packageName: Package name of the app.
func (r *ApplicationsDeviceTierConfigsService) Get(packageName string, deviceTierConfigId int64) *ApplicationsDeviceTierConfigsGetCall {
	c := &ApplicationsDeviceTierConfigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.deviceTierConfigId = deviceTierConfigId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ApplicationsDeviceTierConfigsGetCall) Fields(s ...googleapi.Field) *ApplicationsDeviceTierConfigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ApplicationsDeviceTierConfigsGetCall) IfNoneMatch(entityTag string) *ApplicationsDeviceTierConfigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ApplicationsDeviceTierConfigsGetCall) Context(ctx context.Context) *ApplicationsDeviceTierConfigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ApplicationsDeviceTierConfigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ApplicationsDeviceTierConfigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/deviceTierConfigs/{deviceTierConfigId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName":        c.packageName,
		"deviceTierConfigId": strconv.FormatInt(c.deviceTierConfigId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.applications.deviceTierConfigs.get" call.
// Exactly one of *DeviceTierConfig or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *DeviceTierConfig.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ApplicationsDeviceTierConfigsGetCall) Do(opts ...googleapi.CallOption) (*DeviceTierConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DeviceTierConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a particular device tier config.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/deviceTierConfigs/{deviceTierConfigId}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.applications.deviceTierConfigs.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "deviceTierConfigId"
	//   ],
	//   "parameters": {
	//     "deviceTierConfigId": {
	//       "description": "Required. Id of an existing device tier config.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/deviceTierConfigs/{deviceTierConfigId}",
	//   "response": {
	//     "$ref": "DeviceTierConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.applications.deviceTierConfigs.list":

type ApplicationsDeviceTierConfigsListCall struct {
	s            *Service
	packageName  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns created device tier configs, ordered by descending
// creation time.
//
// - packageName: Package name of the app.
func (r *ApplicationsDeviceTierConfigsService) List(packageName string) *ApplicationsDeviceTierConfigsListCall {
	c := &ApplicationsDeviceTierConfigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of device tier configs to return. The service may return fewer than
// this value. If unspecified, at most 10 device tier configs will be
// returned. The maximum value for this field is 100; values above 100
// will be coerced to 100. Device tier configs will be ordered by
// descending creation time.
func (c *ApplicationsDeviceTierConfigsListCall) PageSize(pageSize int64) *ApplicationsDeviceTierConfigsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListDeviceTierConfigs` call. Provide this
// to retrieve the subsequent page.
func (c *ApplicationsDeviceTierConfigsListCall) PageToken(pageToken string) *ApplicationsDeviceTierConfigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ApplicationsDeviceTierConfigsListCall) Fields(s ...googleapi.Field) *ApplicationsDeviceTierConfigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ApplicationsDeviceTierConfigsListCall) IfNoneMatch(entityTag string) *ApplicationsDeviceTierConfigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ApplicationsDeviceTierConfigsListCall) Context(ctx context.Context) *ApplicationsDeviceTierConfigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ApplicationsDeviceTierConfigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ApplicationsDeviceTierConfigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/deviceTierConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.applications.deviceTierConfigs.list" call.
// Exactly one of *ListDeviceTierConfigsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListDeviceTierConfigsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ApplicationsDeviceTierConfigsListCall) Do(opts ...googleapi.CallOption) (*ListDeviceTierConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDeviceTierConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns created device tier configs, ordered by descending creation time.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/deviceTierConfigs",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.applications.deviceTierConfigs.list",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of device tier configs to return. The service may return fewer than this value. If unspecified, at most 10 device tier configs will be returned. The maximum value for this field is 100; values above 100 will be coerced to 100. Device tier configs will be ordered by descending creation time.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListDeviceTierConfigs` call. Provide this to retrieve the subsequent page.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/deviceTierConfigs",
	//   "response": {
	//     "$ref": "ListDeviceTierConfigsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ApplicationsDeviceTierConfigsListCall) Pages(ctx context.Context, f func(*ListDeviceTierConfigsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "androidpublisher.apprecovery.addTargeting":

type ApprecoveryAddTargetingCall struct {
	s                   *Service
	packageName         string
	appRecoveryId       int64
	addtargetingrequest *AddTargetingRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// AddTargeting: Incrementally update targeting for a recovery action.
// Note that only the criteria selected during the creation of recovery
// action can be expanded.
//
//   - appRecoveryId: ID corresponding to the app recovery action.
//   - packageName: Package name of the app for which recovery action is
//     to be updated.
func (r *ApprecoveryService) AddTargeting(packageName string, appRecoveryId int64, addtargetingrequest *AddTargetingRequest) *ApprecoveryAddTargetingCall {
	c := &ApprecoveryAddTargetingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.appRecoveryId = appRecoveryId
	c.addtargetingrequest = addtargetingrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ApprecoveryAddTargetingCall) Fields(s ...googleapi.Field) *ApprecoveryAddTargetingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ApprecoveryAddTargetingCall) Context(ctx context.Context) *ApprecoveryAddTargetingCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ApprecoveryAddTargetingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ApprecoveryAddTargetingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addtargetingrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:addTargeting")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName":   c.packageName,
		"appRecoveryId": strconv.FormatInt(c.appRecoveryId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.apprecovery.addTargeting" call.
// Exactly one of *AddTargetingResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *AddTargetingResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ApprecoveryAddTargetingCall) Do(opts ...googleapi.CallOption) (*AddTargetingResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AddTargetingResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Incrementally update targeting for a recovery action. Note that only the criteria selected during the creation of recovery action can be expanded.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:addTargeting",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.apprecovery.addTargeting",
	//   "parameterOrder": [
	//     "packageName",
	//     "appRecoveryId"
	//   ],
	//   "parameters": {
	//     "appRecoveryId": {
	//       "description": "Required. ID corresponding to the app recovery action.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. Package name of the app for which recovery action is to be updated.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:addTargeting",
	//   "request": {
	//     "$ref": "AddTargetingRequest"
	//   },
	//   "response": {
	//     "$ref": "AddTargetingResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.apprecovery.appRecoveries":

type ApprecoveryAppRecoveriesCall struct {
	s           *Service
	packageName string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// AppRecoveries: List all app recovery action resources associated with
// a particular package name and app version.
//
//   - packageName: Package name of the app for which list of recovery
//     actions is requested.
func (r *ApprecoveryService) AppRecoveries(packageName string) *ApprecoveryAppRecoveriesCall {
	c := &ApprecoveryAppRecoveriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	return c
}

// VersionCode sets the optional parameter "versionCode": Required.
// Version code targeted by the list of recovery actions.
func (c *ApprecoveryAppRecoveriesCall) VersionCode(versionCode int64) *ApprecoveryAppRecoveriesCall {
	c.urlParams_.Set("versionCode", fmt.Sprint(versionCode))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ApprecoveryAppRecoveriesCall) Fields(s ...googleapi.Field) *ApprecoveryAppRecoveriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ApprecoveryAppRecoveriesCall) Context(ctx context.Context) *ApprecoveryAppRecoveriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ApprecoveryAppRecoveriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ApprecoveryAppRecoveriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/appRecoveries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.apprecovery.appRecoveries" call.
// Exactly one of *ListAppRecoveriesResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListAppRecoveriesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ApprecoveryAppRecoveriesCall) Do(opts ...googleapi.CallOption) (*ListAppRecoveriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAppRecoveriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "List all app recovery action resources associated with a particular package name and app version.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/appRecoveries",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.apprecovery.appRecoveries",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. Package name of the app for which list of recovery actions is requested.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "versionCode": {
	//       "description": "Required. Version code targeted by the list of recovery actions.",
	//       "format": "int64",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/appRecoveries",
	//   "response": {
	//     "$ref": "ListAppRecoveriesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.apprecovery.cancel":

type ApprecoveryCancelCall struct {
	s                        *Service
	packageName              string
	appRecoveryId            int64
	cancelapprecoveryrequest *CancelAppRecoveryRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Cancel: Cancel an already executing app recovery action. Note that
// this action changes status of the recovery action to CANCELED.
//
//   - appRecoveryId: ID corresponding to the app recovery action.
//   - packageName: Package name of the app for which recovery action
//     cancellation is requested.
func (r *ApprecoveryService) Cancel(packageName string, appRecoveryId int64, cancelapprecoveryrequest *CancelAppRecoveryRequest) *ApprecoveryCancelCall {
	c := &ApprecoveryCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.appRecoveryId = appRecoveryId
	c.cancelapprecoveryrequest = cancelapprecoveryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ApprecoveryCancelCall) Fields(s ...googleapi.Field) *ApprecoveryCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ApprecoveryCancelCall) Context(ctx context.Context) *ApprecoveryCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ApprecoveryCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ApprecoveryCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.cancelapprecoveryrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName":   c.packageName,
		"appRecoveryId": strconv.FormatInt(c.appRecoveryId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.apprecovery.cancel" call.
// Exactly one of *CancelAppRecoveryResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *CancelAppRecoveryResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ApprecoveryCancelCall) Do(opts ...googleapi.CallOption) (*CancelAppRecoveryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CancelAppRecoveryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Cancel an already executing app recovery action. Note that this action changes status of the recovery action to CANCELED.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:cancel",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.apprecovery.cancel",
	//   "parameterOrder": [
	//     "packageName",
	//     "appRecoveryId"
	//   ],
	//   "parameters": {
	//     "appRecoveryId": {
	//       "description": "Required. ID corresponding to the app recovery action.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. Package name of the app for which recovery action cancellation is requested.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:cancel",
	//   "request": {
	//     "$ref": "CancelAppRecoveryRequest"
	//   },
	//   "response": {
	//     "$ref": "CancelAppRecoveryResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.apprecovery.create":

type ApprecoveryCreateCall struct {
	s                             *Service
	packageName                   string
	createdraftapprecoveryrequest *CreateDraftAppRecoveryRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Create: Create an app recovery action with recovery status as DRAFT.
// Note that this action does not execute the recovery action.
//
//   - packageName: Package name of the app on which recovery action is
//     performed.
func (r *ApprecoveryService) Create(packageName string, createdraftapprecoveryrequest *CreateDraftAppRecoveryRequest) *ApprecoveryCreateCall {
	c := &ApprecoveryCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.createdraftapprecoveryrequest = createdraftapprecoveryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ApprecoveryCreateCall) Fields(s ...googleapi.Field) *ApprecoveryCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ApprecoveryCreateCall) Context(ctx context.Context) *ApprecoveryCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ApprecoveryCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ApprecoveryCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.createdraftapprecoveryrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/appRecoveries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.apprecovery.create" call.
// Exactly one of *AppRecoveryAction or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *AppRecoveryAction.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ApprecoveryCreateCall) Do(opts ...googleapi.CallOption) (*AppRecoveryAction, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AppRecoveryAction{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create an app recovery action with recovery status as DRAFT. Note that this action does not execute the recovery action.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/appRecoveries",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.apprecovery.create",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. Package name of the app on which recovery action is performed.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/appRecoveries",
	//   "request": {
	//     "$ref": "CreateDraftAppRecoveryRequest"
	//   },
	//   "response": {
	//     "$ref": "AppRecoveryAction"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.apprecovery.deploy":

type ApprecoveryDeployCall struct {
	s                        *Service
	packageName              string
	appRecoveryId            int64
	deployapprecoveryrequest *DeployAppRecoveryRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Deploy: Deploy an already created app recovery action with recovery
// status DRAFT. Note that this action activates the recovery action for
// all targeted users and changes its status to ACTIVE.
//
//   - appRecoveryId: ID corresponding to the app recovery action to
//     deploy.
//   - packageName: Package name of the app for which recovery action is
//     deployed.
func (r *ApprecoveryService) Deploy(packageName string, appRecoveryId int64, deployapprecoveryrequest *DeployAppRecoveryRequest) *ApprecoveryDeployCall {
	c := &ApprecoveryDeployCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.appRecoveryId = appRecoveryId
	c.deployapprecoveryrequest = deployapprecoveryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ApprecoveryDeployCall) Fields(s ...googleapi.Field) *ApprecoveryDeployCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ApprecoveryDeployCall) Context(ctx context.Context) *ApprecoveryDeployCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ApprecoveryDeployCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ApprecoveryDeployCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deployapprecoveryrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:deploy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName":   c.packageName,
		"appRecoveryId": strconv.FormatInt(c.appRecoveryId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.apprecovery.deploy" call.
// Exactly one of *DeployAppRecoveryResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *DeployAppRecoveryResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ApprecoveryDeployCall) Do(opts ...googleapi.CallOption) (*DeployAppRecoveryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DeployAppRecoveryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deploy an already created app recovery action with recovery status DRAFT. Note that this action activates the recovery action for all targeted users and changes its status to ACTIVE.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:deploy",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.apprecovery.deploy",
	//   "parameterOrder": [
	//     "packageName",
	//     "appRecoveryId"
	//   ],
	//   "parameters": {
	//     "appRecoveryId": {
	//       "description": "Required. ID corresponding to the app recovery action to deploy.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. Package name of the app for which recovery action is deployed.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/appRecoveries/{appRecoveryId}:deploy",
	//   "request": {
	//     "$ref": "DeployAppRecoveryRequest"
	//   },
	//   "response": {
	//     "$ref": "DeployAppRecoveryResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.commit":

type EditsCommitCall struct {
	s           *Service
	packageName string
	editId      string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Commit: Commits an app edit.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsService) Commit(packageName string, editId string) *EditsCommitCall {
	c := &EditsCommitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// ChangesNotSentForReview sets the optional parameter
// "changesNotSentForReview": Indicates that the changes in this edit
// will not be reviewed until they are explicitly sent for review from
// the Google Play Console UI. These changes will be added to any other
// changes that are not yet sent for review.
func (c *EditsCommitCall) ChangesNotSentForReview(changesNotSentForReview bool) *EditsCommitCall {
	c.urlParams_.Set("changesNotSentForReview", fmt.Sprint(changesNotSentForReview))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsCommitCall) Fields(s ...googleapi.Field) *EditsCommitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsCommitCall) Context(ctx context.Context) *EditsCommitCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsCommitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsCommitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}:commit")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.commit" call.
// Exactly one of *AppEdit or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *AppEdit.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsCommitCall) Do(opts ...googleapi.CallOption) (*AppEdit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AppEdit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Commits an app edit.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}:commit",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.edits.commit",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "changesNotSentForReview": {
	//       "description": "Indicates that the changes in this edit will not be reviewed until they are explicitly sent for review from the Google Play Console UI. These changes will be added to any other changes that are not yet sent for review.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}:commit",
	//   "response": {
	//     "$ref": "AppEdit"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.delete":

type EditsDeleteCall struct {
	s           *Service
	packageName string
	editId      string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Delete: Deletes an app edit.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsService) Delete(packageName string, editId string) *EditsDeleteCall {
	c := &EditsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsDeleteCall) Fields(s ...googleapi.Field) *EditsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsDeleteCall) Context(ctx context.Context) *EditsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.delete" call.
func (c *EditsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Deletes an app edit.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}",
	//   "httpMethod": "DELETE",
	//   "id": "androidpublisher.edits.delete",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.get":

type EditsGetCall struct {
	s            *Service
	packageName  string
	editId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an app edit.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsService) Get(packageName string, editId string) *EditsGetCall {
	c := &EditsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsGetCall) Fields(s ...googleapi.Field) *EditsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsGetCall) IfNoneMatch(entityTag string) *EditsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsGetCall) Context(ctx context.Context) *EditsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.get" call.
// Exactly one of *AppEdit or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *AppEdit.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsGetCall) Do(opts ...googleapi.CallOption) (*AppEdit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AppEdit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an app edit.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}",
	//   "response": {
	//     "$ref": "AppEdit"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.insert":

type EditsInsertCall struct {
	s           *Service
	packageName string
	appedit     *AppEdit
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Insert: Creates a new edit for an app.
//
// - packageName: Package name of the app.
func (r *EditsService) Insert(packageName string, appedit *AppEdit) *EditsInsertCall {
	c := &EditsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.appedit = appedit
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsInsertCall) Fields(s ...googleapi.Field) *EditsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsInsertCall) Context(ctx context.Context) *EditsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.appedit)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.insert" call.
// Exactly one of *AppEdit or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *AppEdit.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsInsertCall) Do(opts ...googleapi.CallOption) (*AppEdit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AppEdit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new edit for an app.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.edits.insert",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits",
	//   "request": {
	//     "$ref": "AppEdit"
	//   },
	//   "response": {
	//     "$ref": "AppEdit"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.validate":

type EditsValidateCall struct {
	s           *Service
	packageName string
	editId      string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Validate: Validates an app edit.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsService) Validate(packageName string, editId string) *EditsValidateCall {
	c := &EditsValidateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsValidateCall) Fields(s ...googleapi.Field) *EditsValidateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsValidateCall) Context(ctx context.Context) *EditsValidateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsValidateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsValidateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}:validate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.validate" call.
// Exactly one of *AppEdit or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *AppEdit.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsValidateCall) Do(opts ...googleapi.CallOption) (*AppEdit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AppEdit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Validates an app edit.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}:validate",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.edits.validate",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}:validate",
	//   "response": {
	//     "$ref": "AppEdit"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.apks.addexternallyhosted":

type EditsApksAddexternallyhostedCall struct {
	s                              *Service
	packageName                    string
	editId                         string
	apksaddexternallyhostedrequest *ApksAddExternallyHostedRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Addexternallyhosted: Creates a new APK without uploading the APK
// itself to Google Play, instead hosting the APK at a specified URL.
// This function is only available to organizations using Managed Play
// whose application is configured to restrict distribution to the
// organizations.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsApksService) Addexternallyhosted(packageName string, editId string, apksaddexternallyhostedrequest *ApksAddExternallyHostedRequest) *EditsApksAddexternallyhostedCall {
	c := &EditsApksAddexternallyhostedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.apksaddexternallyhostedrequest = apksaddexternallyhostedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsApksAddexternallyhostedCall) Fields(s ...googleapi.Field) *EditsApksAddexternallyhostedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsApksAddexternallyhostedCall) Context(ctx context.Context) *EditsApksAddexternallyhostedCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsApksAddexternallyhostedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsApksAddexternallyhostedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.apksaddexternallyhostedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/externallyHosted")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.apks.addexternallyhosted" call.
// Exactly one of *ApksAddExternallyHostedResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ApksAddExternallyHostedResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsApksAddexternallyhostedCall) Do(opts ...googleapi.CallOption) (*ApksAddExternallyHostedResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ApksAddExternallyHostedResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new APK without uploading the APK itself to Google Play, instead hosting the APK at a specified URL. This function is only available to organizations using Managed Play whose application is configured to restrict distribution to the organizations.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/externallyHosted",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.edits.apks.addexternallyhosted",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/externallyHosted",
	//   "request": {
	//     "$ref": "ApksAddExternallyHostedRequest"
	//   },
	//   "response": {
	//     "$ref": "ApksAddExternallyHostedResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.apks.list":

type EditsApksListCall struct {
	s            *Service
	packageName  string
	editId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all current APKs of the app and edit.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsApksService) List(packageName string, editId string) *EditsApksListCall {
	c := &EditsApksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsApksListCall) Fields(s ...googleapi.Field) *EditsApksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsApksListCall) IfNoneMatch(entityTag string) *EditsApksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsApksListCall) Context(ctx context.Context) *EditsApksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsApksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsApksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.apks.list" call.
// Exactly one of *ApksListResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ApksListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsApksListCall) Do(opts ...googleapi.CallOption) (*ApksListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ApksListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all current APKs of the app and edit.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.apks.list",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks",
	//   "response": {
	//     "$ref": "ApksListResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.apks.upload":

type EditsApksUploadCall struct {
	s           *Service
	packageName string
	editId      string
	urlParams_  gensupport.URLParams
	mediaInfo_  *gensupport.MediaInfo
	ctx_        context.Context
	header_     http.Header
}

// Upload: Uploads an APK and adds to the current edit.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsApksService) Upload(packageName string, editId string) *EditsApksUploadCall {
	c := &EditsApksUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk
// size may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the
// upload request will be determined by sniffing the contents of r,
// unless a MediaOption generated by googleapi.ContentType is
// supplied.
// At most one of Media and ResumableMedia may be set.
func (c *EditsApksUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *EditsApksUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be
// canceled with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType
// identifies the MIME media type of the upload, such as "image/png". If
// mediaType is "", it will be auto-detected. The provided ctx will
// supersede any context previously provided to the Context method.
func (c *EditsApksUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *EditsApksUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called
// after every chunk. It should be a low-latency function in order to
// not slow down the upload operation. This should only be called when
// using ResumableMedia (as opposed to Media).
func (c *EditsApksUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *EditsApksUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsApksUploadCall) Fields(s ...googleapi.Field) *EditsApksUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *EditsApksUploadCall) Context(ctx context.Context) *EditsApksUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsApksUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsApksUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/apks")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	if body == nil {
		body = new(bytes.Buffer)
		reqHeaders.Set("Content-Type", "application/json")
	}
	body, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.apks.upload" call.
// Exactly one of *Apk or error will be non-nil. Any non-2xx status code
// is an error. Response headers are in either
// *Apk.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *EditsApksUploadCall) Do(opts ...googleapi.CallOption) (*Apk, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &Apk{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Uploads an APK and adds to the current edit.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.edits.apks.upload",
	//   "mediaUpload": {
	//     "accept": [
	//       "application/octet-stream",
	//       "application/vnd.android.package-archive"
	//     ],
	//     "maxSize": "10737418240",
	//     "protocols": {
	//       "resumable": {
	//         "multipart": true,
	//         "path": "/resumable/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/apks"
	//       },
	//       "simple": {
	//         "multipart": true,
	//         "path": "/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/apks"
	//       }
	//     }
	//   },
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks",
	//   "response": {
	//     "$ref": "Apk"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ],
	//   "supportsMediaUpload": true
	// }

}

// method id "androidpublisher.edits.bundles.list":

type EditsBundlesListCall struct {
	s            *Service
	packageName  string
	editId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all current Android App Bundles of the app and edit.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsBundlesService) List(packageName string, editId string) *EditsBundlesListCall {
	c := &EditsBundlesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsBundlesListCall) Fields(s ...googleapi.Field) *EditsBundlesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsBundlesListCall) IfNoneMatch(entityTag string) *EditsBundlesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsBundlesListCall) Context(ctx context.Context) *EditsBundlesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsBundlesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsBundlesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.bundles.list" call.
// Exactly one of *BundlesListResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *BundlesListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsBundlesListCall) Do(opts ...googleapi.CallOption) (*BundlesListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BundlesListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all current Android App Bundles of the app and edit.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.bundles.list",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles",
	//   "response": {
	//     "$ref": "BundlesListResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.bundles.upload":

type EditsBundlesUploadCall struct {
	s           *Service
	packageName string
	editId      string
	urlParams_  gensupport.URLParams
	mediaInfo_  *gensupport.MediaInfo
	ctx_        context.Context
	header_     http.Header
}

// Upload: Uploads a new Android App Bundle to this edit. If you are
// using the Google API client libraries, please increase the timeout of
// the http request before calling this endpoint (a timeout of 2 minutes
// is recommended). See Timeouts and Errors
// (https://developers.google.com/api-client-library/java/google-api-java-client/errors)
// for an example in java.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsBundlesService) Upload(packageName string, editId string) *EditsBundlesUploadCall {
	c := &EditsBundlesUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// AckBundleInstallationWarning sets the optional parameter
// "ackBundleInstallationWarning": Must be set to true if the app bundle
// installation may trigger a warning on user devices (for example, if
// installation size may be over a threshold, typically 100 MB).
func (c *EditsBundlesUploadCall) AckBundleInstallationWarning(ackBundleInstallationWarning bool) *EditsBundlesUploadCall {
	c.urlParams_.Set("ackBundleInstallationWarning", fmt.Sprint(ackBundleInstallationWarning))
	return c
}

// DeviceTierConfigId sets the optional parameter "deviceTierConfigId":
// Device tier config (DTC) to be used for generating deliverables
// (APKs). Contains id of the DTC or "LATEST" for last uploaded DTC.
func (c *EditsBundlesUploadCall) DeviceTierConfigId(deviceTierConfigId string) *EditsBundlesUploadCall {
	c.urlParams_.Set("deviceTierConfigId", deviceTierConfigId)
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk
// size may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the
// upload request will be determined by sniffing the contents of r,
// unless a MediaOption generated by googleapi.ContentType is
// supplied.
// At most one of Media and ResumableMedia may be set.
func (c *EditsBundlesUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *EditsBundlesUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be
// canceled with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType
// identifies the MIME media type of the upload, such as "image/png". If
// mediaType is "", it will be auto-detected. The provided ctx will
// supersede any context previously provided to the Context method.
func (c *EditsBundlesUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *EditsBundlesUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called
// after every chunk. It should be a low-latency function in order to
// not slow down the upload operation. This should only be called when
// using ResumableMedia (as opposed to Media).
func (c *EditsBundlesUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *EditsBundlesUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsBundlesUploadCall) Fields(s ...googleapi.Field) *EditsBundlesUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *EditsBundlesUploadCall) Context(ctx context.Context) *EditsBundlesUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsBundlesUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsBundlesUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	if body == nil {
		body = new(bytes.Buffer)
		reqHeaders.Set("Content-Type", "application/json")
	}
	body, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.bundles.upload" call.
// Exactly one of *Bundle or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Bundle.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsBundlesUploadCall) Do(opts ...googleapi.CallOption) (*Bundle, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &Bundle{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Uploads a new Android App Bundle to this edit. If you are using the Google API client libraries, please increase the timeout of the http request before calling this endpoint (a timeout of 2 minutes is recommended). See [Timeouts and Errors](https://developers.google.com/api-client-library/java/google-api-java-client/errors) for an example in java.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.edits.bundles.upload",
	//   "mediaUpload": {
	//     "accept": [
	//       "application/octet-stream"
	//     ],
	//     "maxSize": "10737418240",
	//     "protocols": {
	//       "resumable": {
	//         "multipart": true,
	//         "path": "/resumable/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles"
	//       },
	//       "simple": {
	//         "multipart": true,
	//         "path": "/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles"
	//       }
	//     }
	//   },
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "ackBundleInstallationWarning": {
	//       "description": "Must be set to true if the app bundle installation may trigger a warning on user devices (for example, if installation size may be over a threshold, typically 100 MB).",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "deviceTierConfigId": {
	//       "description": "Device tier config (DTC) to be used for generating deliverables (APKs). Contains id of the DTC or \"LATEST\" for last uploaded DTC.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/bundles",
	//   "response": {
	//     "$ref": "Bundle"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ],
	//   "supportsMediaUpload": true
	// }

}

// method id "androidpublisher.edits.countryavailability.get":

type EditsCountryavailabilityGetCall struct {
	s            *Service
	packageName  string
	editId       string
	track        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets country availability.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
// - track: The track to read from.
func (r *EditsCountryavailabilityService) Get(packageName string, editId string, track string) *EditsCountryavailabilityGetCall {
	c := &EditsCountryavailabilityGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.track = track
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsCountryavailabilityGetCall) Fields(s ...googleapi.Field) *EditsCountryavailabilityGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsCountryavailabilityGetCall) IfNoneMatch(entityTag string) *EditsCountryavailabilityGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsCountryavailabilityGetCall) Context(ctx context.Context) *EditsCountryavailabilityGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsCountryavailabilityGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsCountryavailabilityGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/countryAvailability/{track}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"track":       c.track,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.countryavailability.get" call.
// Exactly one of *TrackCountryAvailability or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *TrackCountryAvailability.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsCountryavailabilityGetCall) Do(opts ...googleapi.CallOption) (*TrackCountryAvailability, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TrackCountryAvailability{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets country availability.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/countryAvailability/{track}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.countryavailability.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "track"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "track": {
	//       "description": "The track to read from.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/countryAvailability/{track}",
	//   "response": {
	//     "$ref": "TrackCountryAvailability"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.deobfuscationfiles.upload":

type EditsDeobfuscationfilesUploadCall struct {
	s                     *Service
	packageNameid         string
	editId                string
	apkVersionCode        int64
	deobfuscationFileType string
	urlParams_            gensupport.URLParams
	mediaInfo_            *gensupport.MediaInfo
	ctx_                  context.Context
	header_               http.Header
}

// Upload: Uploads a new deobfuscation file and attaches to the
// specified APK.
//
//   - apkVersionCode: The version code of the APK whose Deobfuscation
//     File is being uploaded.
//   - deobfuscationFileType: The type of the deobfuscation file.
//   - editId: Unique identifier for this edit.
//   - packageName: Unique identifier for the Android app.
func (r *EditsDeobfuscationfilesService) Upload(packageNameid string, editId string, apkVersionCode int64, deobfuscationFileType string) *EditsDeobfuscationfilesUploadCall {
	c := &EditsDeobfuscationfilesUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageNameid = packageNameid
	c.editId = editId
	c.apkVersionCode = apkVersionCode
	c.deobfuscationFileType = deobfuscationFileType
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk
// size may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the
// upload request will be determined by sniffing the contents of r,
// unless a MediaOption generated by googleapi.ContentType is
// supplied.
// At most one of Media and ResumableMedia may be set.
func (c *EditsDeobfuscationfilesUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *EditsDeobfuscationfilesUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be
// canceled with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType
// identifies the MIME media type of the upload, such as "image/png". If
// mediaType is "", it will be auto-detected. The provided ctx will
// supersede any context previously provided to the Context method.
func (c *EditsDeobfuscationfilesUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *EditsDeobfuscationfilesUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called
// after every chunk. It should be a low-latency function in order to
// not slow down the upload operation. This should only be called when
// using ResumableMedia (as opposed to Media).
func (c *EditsDeobfuscationfilesUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *EditsDeobfuscationfilesUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsDeobfuscationfilesUploadCall) Fields(s ...googleapi.Field) *EditsDeobfuscationfilesUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *EditsDeobfuscationfilesUploadCall) Context(ctx context.Context) *EditsDeobfuscationfilesUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsDeobfuscationfilesUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsDeobfuscationfilesUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/deobfuscationFiles/{deobfuscationFileType}")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/deobfuscationFiles/{deobfuscationFileType}")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	if body == nil {
		body = new(bytes.Buffer)
		reqHeaders.Set("Content-Type", "application/json")
	}
	body, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"packageName":           c.packageNameid,
		"editId":                c.editId,
		"apkVersionCode":        strconv.FormatInt(c.apkVersionCode, 10),
		"deobfuscationFileType": c.deobfuscationFileType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.deobfuscationfiles.upload" call.
// Exactly one of *DeobfuscationFilesUploadResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *DeobfuscationFilesUploadResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsDeobfuscationfilesUploadCall) Do(opts ...googleapi.CallOption) (*DeobfuscationFilesUploadResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &DeobfuscationFilesUploadResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Uploads a new deobfuscation file and attaches to the specified APK.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/deobfuscationFiles/{deobfuscationFileType}",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.edits.deobfuscationfiles.upload",
	//   "mediaUpload": {
	//     "accept": [
	//       "application/octet-stream"
	//     ],
	//     "maxSize": "1677721600",
	//     "protocols": {
	//       "resumable": {
	//         "multipart": true,
	//         "path": "/resumable/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/deobfuscationFiles/{deobfuscationFileType}"
	//       },
	//       "simple": {
	//         "multipart": true,
	//         "path": "/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/deobfuscationFiles/{deobfuscationFileType}"
	//       }
	//     }
	//   },
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "apkVersionCode",
	//     "deobfuscationFileType"
	//   ],
	//   "parameters": {
	//     "apkVersionCode": {
	//       "description": "The version code of the APK whose Deobfuscation File is being uploaded.",
	//       "format": "int32",
	//       "location": "path",
	//       "required": true,
	//       "type": "integer"
	//     },
	//     "deobfuscationFileType": {
	//       "description": "The type of the deobfuscation file.",
	//       "enum": [
	//         "deobfuscationFileTypeUnspecified",
	//         "proguard",
	//         "nativeCode"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified deobfuscation file type.",
	//         "Proguard deobfuscation file type.",
	//         "Native debugging symbols file type."
	//       ],
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "editId": {
	//       "description": "Unique identifier for this edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Unique identifier for the Android app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/deobfuscationFiles/{deobfuscationFileType}",
	//   "response": {
	//     "$ref": "DeobfuscationFilesUploadResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ],
	//   "supportsMediaUpload": true
	// }

}

// method id "androidpublisher.edits.details.get":

type EditsDetailsGetCall struct {
	s            *Service
	packageName  string
	editId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of an app.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsDetailsService) Get(packageName string, editId string) *EditsDetailsGetCall {
	c := &EditsDetailsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsDetailsGetCall) Fields(s ...googleapi.Field) *EditsDetailsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsDetailsGetCall) IfNoneMatch(entityTag string) *EditsDetailsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsDetailsGetCall) Context(ctx context.Context) *EditsDetailsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsDetailsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsDetailsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/details")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.details.get" call.
// Exactly one of *AppDetails or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AppDetails.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EditsDetailsGetCall) Do(opts ...googleapi.CallOption) (*AppDetails, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AppDetails{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of an app.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/details",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.details.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/details",
	//   "response": {
	//     "$ref": "AppDetails"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.details.patch":

type EditsDetailsPatchCall struct {
	s           *Service
	packageName string
	editId      string
	appdetails  *AppDetails
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Patches details of an app.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsDetailsService) Patch(packageName string, editId string, appdetails *AppDetails) *EditsDetailsPatchCall {
	c := &EditsDetailsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.appdetails = appdetails
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsDetailsPatchCall) Fields(s ...googleapi.Field) *EditsDetailsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsDetailsPatchCall) Context(ctx context.Context) *EditsDetailsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsDetailsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsDetailsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.appdetails)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/details")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.details.patch" call.
// Exactly one of *AppDetails or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AppDetails.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EditsDetailsPatchCall) Do(opts ...googleapi.CallOption) (*AppDetails, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AppDetails{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Patches details of an app.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/details",
	//   "httpMethod": "PATCH",
	//   "id": "androidpublisher.edits.details.patch",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/details",
	//   "request": {
	//     "$ref": "AppDetails"
	//   },
	//   "response": {
	//     "$ref": "AppDetails"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.details.update":

type EditsDetailsUpdateCall struct {
	s           *Service
	packageName string
	editId      string
	appdetails  *AppDetails
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Updates details of an app.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsDetailsService) Update(packageName string, editId string, appdetails *AppDetails) *EditsDetailsUpdateCall {
	c := &EditsDetailsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.appdetails = appdetails
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsDetailsUpdateCall) Fields(s ...googleapi.Field) *EditsDetailsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsDetailsUpdateCall) Context(ctx context.Context) *EditsDetailsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsDetailsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsDetailsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.appdetails)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/details")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.details.update" call.
// Exactly one of *AppDetails or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AppDetails.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EditsDetailsUpdateCall) Do(opts ...googleapi.CallOption) (*AppDetails, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AppDetails{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates details of an app.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/details",
	//   "httpMethod": "PUT",
	//   "id": "androidpublisher.edits.details.update",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/details",
	//   "request": {
	//     "$ref": "AppDetails"
	//   },
	//   "response": {
	//     "$ref": "AppDetails"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.expansionfiles.get":

type EditsExpansionfilesGetCall struct {
	s                 *Service
	packageName       string
	editId            string
	apkVersionCode    int64
	expansionFileType string
	urlParams_        gensupport.URLParams
	ifNoneMatch_      string
	ctx_              context.Context
	header_           http.Header
}

// Get: Fetches the expansion file configuration for the specified APK.
//
//   - apkVersionCode: The version code of the APK whose expansion file
//     configuration is being read or modified.
//   - editId: Identifier of the edit.
//   - expansionFileType: The file type of the file configuration which is
//     being read or modified.
//   - packageName: Package name of the app.
func (r *EditsExpansionfilesService) Get(packageName string, editId string, apkVersionCode int64, expansionFileType string) *EditsExpansionfilesGetCall {
	c := &EditsExpansionfilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.apkVersionCode = apkVersionCode
	c.expansionFileType = expansionFileType
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsExpansionfilesGetCall) Fields(s ...googleapi.Field) *EditsExpansionfilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsExpansionfilesGetCall) IfNoneMatch(entityTag string) *EditsExpansionfilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsExpansionfilesGetCall) Context(ctx context.Context) *EditsExpansionfilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsExpansionfilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsExpansionfilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName":       c.packageName,
		"editId":            c.editId,
		"apkVersionCode":    strconv.FormatInt(c.apkVersionCode, 10),
		"expansionFileType": c.expansionFileType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.expansionfiles.get" call.
// Exactly one of *ExpansionFile or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *ExpansionFile.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsExpansionfilesGetCall) Do(opts ...googleapi.CallOption) (*ExpansionFile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExpansionFile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Fetches the expansion file configuration for the specified APK.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.expansionfiles.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "apkVersionCode",
	//     "expansionFileType"
	//   ],
	//   "parameters": {
	//     "apkVersionCode": {
	//       "description": "The version code of the APK whose expansion file configuration is being read or modified.",
	//       "format": "int32",
	//       "location": "path",
	//       "required": true,
	//       "type": "integer"
	//     },
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "expansionFileType": {
	//       "description": "The file type of the file configuration which is being read or modified.",
	//       "enum": [
	//         "expansionFileTypeUnspecified",
	//         "main",
	//         "patch"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified expansion file type.",
	//         "Main expansion file.",
	//         "Patch expansion file."
	//       ],
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}",
	//   "response": {
	//     "$ref": "ExpansionFile"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.expansionfiles.patch":

type EditsExpansionfilesPatchCall struct {
	s                 *Service
	packageName       string
	editId            string
	apkVersionCode    int64
	expansionFileType string
	expansionfile     *ExpansionFile
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Patch: Patches the APK's expansion file configuration to reference
// another APK's expansion file. To add a new expansion file use the
// Upload method.
//
//   - apkVersionCode: The version code of the APK whose expansion file
//     configuration is being read or modified.
//   - editId: Identifier of the edit.
//   - expansionFileType: The file type of the expansion file
//     configuration which is being updated.
//   - packageName: Package name of the app.
func (r *EditsExpansionfilesService) Patch(packageName string, editId string, apkVersionCode int64, expansionFileType string, expansionfile *ExpansionFile) *EditsExpansionfilesPatchCall {
	c := &EditsExpansionfilesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.apkVersionCode = apkVersionCode
	c.expansionFileType = expansionFileType
	c.expansionfile = expansionfile
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsExpansionfilesPatchCall) Fields(s ...googleapi.Field) *EditsExpansionfilesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsExpansionfilesPatchCall) Context(ctx context.Context) *EditsExpansionfilesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsExpansionfilesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsExpansionfilesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.expansionfile)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName":       c.packageName,
		"editId":            c.editId,
		"apkVersionCode":    strconv.FormatInt(c.apkVersionCode, 10),
		"expansionFileType": c.expansionFileType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.expansionfiles.patch" call.
// Exactly one of *ExpansionFile or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *ExpansionFile.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsExpansionfilesPatchCall) Do(opts ...googleapi.CallOption) (*ExpansionFile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExpansionFile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Patches the APK's expansion file configuration to reference another APK's expansion file. To add a new expansion file use the Upload method.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}",
	//   "httpMethod": "PATCH",
	//   "id": "androidpublisher.edits.expansionfiles.patch",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "apkVersionCode",
	//     "expansionFileType"
	//   ],
	//   "parameters": {
	//     "apkVersionCode": {
	//       "description": "The version code of the APK whose expansion file configuration is being read or modified.",
	//       "format": "int32",
	//       "location": "path",
	//       "required": true,
	//       "type": "integer"
	//     },
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "expansionFileType": {
	//       "description": "The file type of the expansion file configuration which is being updated.",
	//       "enum": [
	//         "expansionFileTypeUnspecified",
	//         "main",
	//         "patch"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified expansion file type.",
	//         "Main expansion file.",
	//         "Patch expansion file."
	//       ],
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}",
	//   "request": {
	//     "$ref": "ExpansionFile"
	//   },
	//   "response": {
	//     "$ref": "ExpansionFile"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.expansionfiles.update":

type EditsExpansionfilesUpdateCall struct {
	s                 *Service
	packageName       string
	editId            string
	apkVersionCode    int64
	expansionFileType string
	expansionfile     *ExpansionFile
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Update: Updates the APK's expansion file configuration to reference
// another APK's expansion file. To add a new expansion file use the
// Upload method.
//
//   - apkVersionCode: The version code of the APK whose expansion file
//     configuration is being read or modified.
//   - editId: Identifier of the edit.
//   - expansionFileType: The file type of the file configuration which is
//     being read or modified.
//   - packageName: Package name of the app.
func (r *EditsExpansionfilesService) Update(packageName string, editId string, apkVersionCode int64, expansionFileType string, expansionfile *ExpansionFile) *EditsExpansionfilesUpdateCall {
	c := &EditsExpansionfilesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.apkVersionCode = apkVersionCode
	c.expansionFileType = expansionFileType
	c.expansionfile = expansionfile
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsExpansionfilesUpdateCall) Fields(s ...googleapi.Field) *EditsExpansionfilesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsExpansionfilesUpdateCall) Context(ctx context.Context) *EditsExpansionfilesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsExpansionfilesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsExpansionfilesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.expansionfile)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName":       c.packageName,
		"editId":            c.editId,
		"apkVersionCode":    strconv.FormatInt(c.apkVersionCode, 10),
		"expansionFileType": c.expansionFileType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.expansionfiles.update" call.
// Exactly one of *ExpansionFile or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *ExpansionFile.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsExpansionfilesUpdateCall) Do(opts ...googleapi.CallOption) (*ExpansionFile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExpansionFile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the APK's expansion file configuration to reference another APK's expansion file. To add a new expansion file use the Upload method.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}",
	//   "httpMethod": "PUT",
	//   "id": "androidpublisher.edits.expansionfiles.update",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "apkVersionCode",
	//     "expansionFileType"
	//   ],
	//   "parameters": {
	//     "apkVersionCode": {
	//       "description": "The version code of the APK whose expansion file configuration is being read or modified.",
	//       "format": "int32",
	//       "location": "path",
	//       "required": true,
	//       "type": "integer"
	//     },
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "expansionFileType": {
	//       "description": "The file type of the file configuration which is being read or modified.",
	//       "enum": [
	//         "expansionFileTypeUnspecified",
	//         "main",
	//         "patch"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified expansion file type.",
	//         "Main expansion file.",
	//         "Patch expansion file."
	//       ],
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}",
	//   "request": {
	//     "$ref": "ExpansionFile"
	//   },
	//   "response": {
	//     "$ref": "ExpansionFile"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.expansionfiles.upload":

type EditsExpansionfilesUploadCall struct {
	s                 *Service
	packageName       string
	editId            string
	apkVersionCode    int64
	expansionFileType string
	urlParams_        gensupport.URLParams
	mediaInfo_        *gensupport.MediaInfo
	ctx_              context.Context
	header_           http.Header
}

// Upload: Uploads a new expansion file and attaches to the specified
// APK.
//
//   - apkVersionCode: The version code of the APK whose expansion file
//     configuration is being read or modified.
//   - editId: Identifier of the edit.
//   - expansionFileType: The file type of the expansion file
//     configuration which is being updated.
//   - packageName: Package name of the app.
func (r *EditsExpansionfilesService) Upload(packageName string, editId string, apkVersionCode int64, expansionFileType string) *EditsExpansionfilesUploadCall {
	c := &EditsExpansionfilesUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.apkVersionCode = apkVersionCode
	c.expansionFileType = expansionFileType
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk
// size may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the
// upload request will be determined by sniffing the contents of r,
// unless a MediaOption generated by googleapi.ContentType is
// supplied.
// At most one of Media and ResumableMedia may be set.
func (c *EditsExpansionfilesUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *EditsExpansionfilesUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be
// canceled with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType
// identifies the MIME media type of the upload, such as "image/png". If
// mediaType is "", it will be auto-detected. The provided ctx will
// supersede any context previously provided to the Context method.
func (c *EditsExpansionfilesUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *EditsExpansionfilesUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called
// after every chunk. It should be a low-latency function in order to
// not slow down the upload operation. This should only be called when
// using ResumableMedia (as opposed to Media).
func (c *EditsExpansionfilesUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *EditsExpansionfilesUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsExpansionfilesUploadCall) Fields(s ...googleapi.Field) *EditsExpansionfilesUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *EditsExpansionfilesUploadCall) Context(ctx context.Context) *EditsExpansionfilesUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsExpansionfilesUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsExpansionfilesUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	if body == nil {
		body = new(bytes.Buffer)
		reqHeaders.Set("Content-Type", "application/json")
	}
	body, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"packageName":       c.packageName,
		"editId":            c.editId,
		"apkVersionCode":    strconv.FormatInt(c.apkVersionCode, 10),
		"expansionFileType": c.expansionFileType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.expansionfiles.upload" call.
// Exactly one of *ExpansionFilesUploadResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ExpansionFilesUploadResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsExpansionfilesUploadCall) Do(opts ...googleapi.CallOption) (*ExpansionFilesUploadResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &ExpansionFilesUploadResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Uploads a new expansion file and attaches to the specified APK.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.edits.expansionfiles.upload",
	//   "mediaUpload": {
	//     "accept": [
	//       "application/octet-stream"
	//     ],
	//     "maxSize": "2147483648",
	//     "protocols": {
	//       "resumable": {
	//         "multipart": true,
	//         "path": "/resumable/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}"
	//       },
	//       "simple": {
	//         "multipart": true,
	//         "path": "/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}"
	//       }
	//     }
	//   },
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "apkVersionCode",
	//     "expansionFileType"
	//   ],
	//   "parameters": {
	//     "apkVersionCode": {
	//       "description": "The version code of the APK whose expansion file configuration is being read or modified.",
	//       "format": "int32",
	//       "location": "path",
	//       "required": true,
	//       "type": "integer"
	//     },
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "expansionFileType": {
	//       "description": "The file type of the expansion file configuration which is being updated.",
	//       "enum": [
	//         "expansionFileTypeUnspecified",
	//         "main",
	//         "patch"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified expansion file type.",
	//         "Main expansion file.",
	//         "Patch expansion file."
	//       ],
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/expansionFiles/{expansionFileType}",
	//   "response": {
	//     "$ref": "ExpansionFilesUploadResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ],
	//   "supportsMediaUpload": true
	// }

}

// method id "androidpublisher.edits.images.delete":

type EditsImagesDeleteCall struct {
	s           *Service
	packageName string
	editId      string
	language    string
	imageType   string
	imageId     string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Delete: Deletes the image (specified by id) from the edit.
//
//   - editId: Identifier of the edit.
//   - imageId: Unique identifier an image within the set of images
//     attached to this edit.
//   - imageType: Type of the Image.
//   - language: Language localization code (a BCP-47 language tag; for
//     example, "de-AT" for Austrian German).
//   - packageName: Package name of the app.
func (r *EditsImagesService) Delete(packageName string, editId string, language string, imageType string, imageId string) *EditsImagesDeleteCall {
	c := &EditsImagesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.language = language
	c.imageType = imageType
	c.imageId = imageId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsImagesDeleteCall) Fields(s ...googleapi.Field) *EditsImagesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsImagesDeleteCall) Context(ctx context.Context) *EditsImagesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsImagesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsImagesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}/{imageId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"language":    c.language,
		"imageType":   c.imageType,
		"imageId":     c.imageId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.images.delete" call.
func (c *EditsImagesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Deletes the image (specified by id) from the edit.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}/{imageId}",
	//   "httpMethod": "DELETE",
	//   "id": "androidpublisher.edits.images.delete",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "language",
	//     "imageType",
	//     "imageId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "imageId": {
	//       "description": "Unique identifier an image within the set of images attached to this edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "imageType": {
	//       "description": "Type of the Image.",
	//       "enum": [
	//         "appImageTypeUnspecified",
	//         "phoneScreenshots",
	//         "sevenInchScreenshots",
	//         "tenInchScreenshots",
	//         "tvScreenshots",
	//         "wearScreenshots",
	//         "icon",
	//         "featureGraphic",
	//         "tvBanner"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified type. Do not use.",
	//         "Phone screenshot.",
	//         "Seven inch screenshot.",
	//         "Ten inch screenshot.",
	//         "TV screenshot.",
	//         "Wear screenshot.",
	//         "Icon.",
	//         "Feature graphic.",
	//         "TV banner."
	//       ],
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "language": {
	//       "description": "Language localization code (a BCP-47 language tag; for example, \"de-AT\" for Austrian German).",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}/{imageId}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.images.deleteall":

type EditsImagesDeleteallCall struct {
	s           *Service
	packageName string
	editId      string
	language    string
	imageType   string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Deleteall: Deletes all images for the specified language and image
// type. Returns an empty response if no images are found.
//
//   - editId: Identifier of the edit.
//   - imageType: Type of the Image. Providing an image type that refers
//     to no images is a no-op.
//   - language: Language localization code (a BCP-47 language tag; for
//     example, "de-AT" for Austrian German). Providing a language that is
//     not supported by the App is a no-op.
//   - packageName: Package name of the app.
func (r *EditsImagesService) Deleteall(packageName string, editId string, language string, imageType string) *EditsImagesDeleteallCall {
	c := &EditsImagesDeleteallCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.language = language
	c.imageType = imageType
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsImagesDeleteallCall) Fields(s ...googleapi.Field) *EditsImagesDeleteallCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsImagesDeleteallCall) Context(ctx context.Context) *EditsImagesDeleteallCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsImagesDeleteallCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsImagesDeleteallCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"language":    c.language,
		"imageType":   c.imageType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.images.deleteall" call.
// Exactly one of *ImagesDeleteAllResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ImagesDeleteAllResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsImagesDeleteallCall) Do(opts ...googleapi.CallOption) (*ImagesDeleteAllResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ImagesDeleteAllResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes all images for the specified language and image type. Returns an empty response if no images are found.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}",
	//   "httpMethod": "DELETE",
	//   "id": "androidpublisher.edits.images.deleteall",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "language",
	//     "imageType"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "imageType": {
	//       "description": "Type of the Image. Providing an image type that refers to no images is a no-op.",
	//       "enum": [
	//         "appImageTypeUnspecified",
	//         "phoneScreenshots",
	//         "sevenInchScreenshots",
	//         "tenInchScreenshots",
	//         "tvScreenshots",
	//         "wearScreenshots",
	//         "icon",
	//         "featureGraphic",
	//         "tvBanner"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified type. Do not use.",
	//         "Phone screenshot.",
	//         "Seven inch screenshot.",
	//         "Ten inch screenshot.",
	//         "TV screenshot.",
	//         "Wear screenshot.",
	//         "Icon.",
	//         "Feature graphic.",
	//         "TV banner."
	//       ],
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "language": {
	//       "description": "Language localization code (a BCP-47 language tag; for example, \"de-AT\" for Austrian German). Providing a language that is not supported by the App is a no-op.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}",
	//   "response": {
	//     "$ref": "ImagesDeleteAllResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.images.list":

type EditsImagesListCall struct {
	s            *Service
	packageName  string
	editId       string
	language     string
	imageType    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all images. The response may be empty.
//
//   - editId: Identifier of the edit.
//   - imageType: Type of the Image. Providing an image type that refers
//     to no images will return an empty response.
//   - language: Language localization code (a BCP-47 language tag; for
//     example, "de-AT" for Austrian German). There must be a store
//     listing for the specified language.
//   - packageName: Package name of the app.
func (r *EditsImagesService) List(packageName string, editId string, language string, imageType string) *EditsImagesListCall {
	c := &EditsImagesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.language = language
	c.imageType = imageType
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsImagesListCall) Fields(s ...googleapi.Field) *EditsImagesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsImagesListCall) IfNoneMatch(entityTag string) *EditsImagesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsImagesListCall) Context(ctx context.Context) *EditsImagesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsImagesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsImagesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"language":    c.language,
		"imageType":   c.imageType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.images.list" call.
// Exactly one of *ImagesListResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ImagesListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsImagesListCall) Do(opts ...googleapi.CallOption) (*ImagesListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ImagesListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all images. The response may be empty.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.images.list",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "language",
	//     "imageType"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "imageType": {
	//       "description": "Type of the Image. Providing an image type that refers to no images will return an empty response.",
	//       "enum": [
	//         "appImageTypeUnspecified",
	//         "phoneScreenshots",
	//         "sevenInchScreenshots",
	//         "tenInchScreenshots",
	//         "tvScreenshots",
	//         "wearScreenshots",
	//         "icon",
	//         "featureGraphic",
	//         "tvBanner"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified type. Do not use.",
	//         "Phone screenshot.",
	//         "Seven inch screenshot.",
	//         "Ten inch screenshot.",
	//         "TV screenshot.",
	//         "Wear screenshot.",
	//         "Icon.",
	//         "Feature graphic.",
	//         "TV banner."
	//       ],
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "language": {
	//       "description": "Language localization code (a BCP-47 language tag; for example, \"de-AT\" for Austrian German). There must be a store listing for the specified language.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}",
	//   "response": {
	//     "$ref": "ImagesListResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.images.upload":

type EditsImagesUploadCall struct {
	s           *Service
	packageName string
	editId      string
	language    string
	imageType   string
	urlParams_  gensupport.URLParams
	mediaInfo_  *gensupport.MediaInfo
	ctx_        context.Context
	header_     http.Header
}

// Upload: Uploads an image of the specified language and image type,
// and adds to the edit.
//
//   - editId: Identifier of the edit.
//   - imageType: Type of the Image.
//   - language: Language localization code (a BCP-47 language tag; for
//     example, "de-AT" for Austrian German). Providing a language that is
//     not supported by the App is a no-op.
//   - packageName: Package name of the app.
func (r *EditsImagesService) Upload(packageName string, editId string, language string, imageType string) *EditsImagesUploadCall {
	c := &EditsImagesUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.language = language
	c.imageType = imageType
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk
// size may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the
// upload request will be determined by sniffing the contents of r,
// unless a MediaOption generated by googleapi.ContentType is
// supplied.
// At most one of Media and ResumableMedia may be set.
func (c *EditsImagesUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *EditsImagesUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be
// canceled with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType
// identifies the MIME media type of the upload, such as "image/png". If
// mediaType is "", it will be auto-detected. The provided ctx will
// supersede any context previously provided to the Context method.
func (c *EditsImagesUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *EditsImagesUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called
// after every chunk. It should be a low-latency function in order to
// not slow down the upload operation. This should only be called when
// using ResumableMedia (as opposed to Media).
func (c *EditsImagesUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *EditsImagesUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsImagesUploadCall) Fields(s ...googleapi.Field) *EditsImagesUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *EditsImagesUploadCall) Context(ctx context.Context) *EditsImagesUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsImagesUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsImagesUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	if body == nil {
		body = new(bytes.Buffer)
		reqHeaders.Set("Content-Type", "application/json")
	}
	body, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"language":    c.language,
		"imageType":   c.imageType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.images.upload" call.
// Exactly one of *ImagesUploadResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ImagesUploadResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsImagesUploadCall) Do(opts ...googleapi.CallOption) (*ImagesUploadResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &ImagesUploadResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Uploads an image of the specified language and image type, and adds to the edit.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.edits.images.upload",
	//   "mediaUpload": {
	//     "accept": [
	//       "image/*"
	//     ],
	//     "maxSize": "15728640",
	//     "protocols": {
	//       "resumable": {
	//         "multipart": true,
	//         "path": "/resumable/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}"
	//       },
	//       "simple": {
	//         "multipart": true,
	//         "path": "/upload/androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}"
	//       }
	//     }
	//   },
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "language",
	//     "imageType"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "imageType": {
	//       "description": "Type of the Image.",
	//       "enum": [
	//         "appImageTypeUnspecified",
	//         "phoneScreenshots",
	//         "sevenInchScreenshots",
	//         "tenInchScreenshots",
	//         "tvScreenshots",
	//         "wearScreenshots",
	//         "icon",
	//         "featureGraphic",
	//         "tvBanner"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified type. Do not use.",
	//         "Phone screenshot.",
	//         "Seven inch screenshot.",
	//         "Ten inch screenshot.",
	//         "TV screenshot.",
	//         "Wear screenshot.",
	//         "Icon.",
	//         "Feature graphic.",
	//         "TV banner."
	//       ],
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "language": {
	//       "description": "Language localization code (a BCP-47 language tag; for example, \"de-AT\" for Austrian German). Providing a language that is not supported by the App is a no-op.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}",
	//   "response": {
	//     "$ref": "ImagesUploadResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ],
	//   "supportsMediaUpload": true
	// }

}

// method id "androidpublisher.edits.listings.delete":

type EditsListingsDeleteCall struct {
	s           *Service
	packageName string
	editId      string
	language    string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Delete: Deletes a localized store listing.
//
//   - editId: Identifier of the edit.
//   - language: Language localization code (a BCP-47 language tag; for
//     example, "de-AT" for Austrian German).
//   - packageName: Package name of the app.
func (r *EditsListingsService) Delete(packageName string, editId string, language string) *EditsListingsDeleteCall {
	c := &EditsListingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.language = language
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsListingsDeleteCall) Fields(s ...googleapi.Field) *EditsListingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsListingsDeleteCall) Context(ctx context.Context) *EditsListingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsListingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsListingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"language":    c.language,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.listings.delete" call.
func (c *EditsListingsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Deletes a localized store listing.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}",
	//   "httpMethod": "DELETE",
	//   "id": "androidpublisher.edits.listings.delete",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "language"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "language": {
	//       "description": "Language localization code (a BCP-47 language tag; for example, \"de-AT\" for Austrian German).",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.listings.deleteall":

type EditsListingsDeleteallCall struct {
	s           *Service
	packageName string
	editId      string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Deleteall: Deletes all store listings.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsListingsService) Deleteall(packageName string, editId string) *EditsListingsDeleteallCall {
	c := &EditsListingsDeleteallCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsListingsDeleteallCall) Fields(s ...googleapi.Field) *EditsListingsDeleteallCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsListingsDeleteallCall) Context(ctx context.Context) *EditsListingsDeleteallCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsListingsDeleteallCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsListingsDeleteallCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.listings.deleteall" call.
func (c *EditsListingsDeleteallCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Deletes all store listings.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings",
	//   "httpMethod": "DELETE",
	//   "id": "androidpublisher.edits.listings.deleteall",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.listings.get":

type EditsListingsGetCall struct {
	s            *Service
	packageName  string
	editId       string
	language     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a localized store listing.
//
//   - editId: Identifier of the edit.
//   - language: Language localization code (a BCP-47 language tag; for
//     example, "de-AT" for Austrian German).
//   - packageName: Package name of the app.
func (r *EditsListingsService) Get(packageName string, editId string, language string) *EditsListingsGetCall {
	c := &EditsListingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.language = language
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsListingsGetCall) Fields(s ...googleapi.Field) *EditsListingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsListingsGetCall) IfNoneMatch(entityTag string) *EditsListingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsListingsGetCall) Context(ctx context.Context) *EditsListingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsListingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsListingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"language":    c.language,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.listings.get" call.
// Exactly one of *Listing or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Listing.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsListingsGetCall) Do(opts ...googleapi.CallOption) (*Listing, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Listing{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a localized store listing.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.listings.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "language"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "language": {
	//       "description": "Language localization code (a BCP-47 language tag; for example, \"de-AT\" for Austrian German).",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}",
	//   "response": {
	//     "$ref": "Listing"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.listings.list":

type EditsListingsListCall struct {
	s            *Service
	packageName  string
	editId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all localized store listings.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsListingsService) List(packageName string, editId string) *EditsListingsListCall {
	c := &EditsListingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsListingsListCall) Fields(s ...googleapi.Field) *EditsListingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsListingsListCall) IfNoneMatch(entityTag string) *EditsListingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsListingsListCall) Context(ctx context.Context) *EditsListingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsListingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsListingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.listings.list" call.
// Exactly one of *ListingsListResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListingsListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsListingsListCall) Do(opts ...googleapi.CallOption) (*ListingsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListingsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all localized store listings.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.listings.list",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings",
	//   "response": {
	//     "$ref": "ListingsListResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.listings.patch":

type EditsListingsPatchCall struct {
	s           *Service
	packageName string
	editId      string
	language    string
	listing     *Listing
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Patches a localized store listing.
//
//   - editId: Identifier of the edit.
//   - language: Language localization code (a BCP-47 language tag; for
//     example, "de-AT" for Austrian German).
//   - packageName: Package name of the app.
func (r *EditsListingsService) Patch(packageName string, editId string, language string, listing *Listing) *EditsListingsPatchCall {
	c := &EditsListingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.language = language
	c.listing = listing
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsListingsPatchCall) Fields(s ...googleapi.Field) *EditsListingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsListingsPatchCall) Context(ctx context.Context) *EditsListingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsListingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsListingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.listing)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"language":    c.language,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.listings.patch" call.
// Exactly one of *Listing or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Listing.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsListingsPatchCall) Do(opts ...googleapi.CallOption) (*Listing, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Listing{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Patches a localized store listing.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}",
	//   "httpMethod": "PATCH",
	//   "id": "androidpublisher.edits.listings.patch",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "language"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "language": {
	//       "description": "Language localization code (a BCP-47 language tag; for example, \"de-AT\" for Austrian German).",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}",
	//   "request": {
	//     "$ref": "Listing"
	//   },
	//   "response": {
	//     "$ref": "Listing"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.listings.update":

type EditsListingsUpdateCall struct {
	s           *Service
	packageName string
	editId      string
	language    string
	listing     *Listing
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Creates or updates a localized store listing.
//
//   - editId: Identifier of the edit.
//   - language: Language localization code (a BCP-47 language tag; for
//     example, "de-AT" for Austrian German).
//   - packageName: Package name of the app.
func (r *EditsListingsService) Update(packageName string, editId string, language string, listing *Listing) *EditsListingsUpdateCall {
	c := &EditsListingsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.language = language
	c.listing = listing
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsListingsUpdateCall) Fields(s ...googleapi.Field) *EditsListingsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsListingsUpdateCall) Context(ctx context.Context) *EditsListingsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsListingsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsListingsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.listing)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"language":    c.language,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.listings.update" call.
// Exactly one of *Listing or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Listing.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsListingsUpdateCall) Do(opts ...googleapi.CallOption) (*Listing, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Listing{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates or updates a localized store listing.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}",
	//   "httpMethod": "PUT",
	//   "id": "androidpublisher.edits.listings.update",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "language"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "language": {
	//       "description": "Language localization code (a BCP-47 language tag; for example, \"de-AT\" for Austrian German).",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}",
	//   "request": {
	//     "$ref": "Listing"
	//   },
	//   "response": {
	//     "$ref": "Listing"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.testers.get":

type EditsTestersGetCall struct {
	s            *Service
	packageName  string
	editId       string
	track        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets testers. Note: Testers resource does not support email
// lists.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
// - track: The track to read from.
func (r *EditsTestersService) Get(packageName string, editId string, track string) *EditsTestersGetCall {
	c := &EditsTestersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.track = track
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsTestersGetCall) Fields(s ...googleapi.Field) *EditsTestersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsTestersGetCall) IfNoneMatch(entityTag string) *EditsTestersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsTestersGetCall) Context(ctx context.Context) *EditsTestersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsTestersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsTestersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"track":       c.track,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.testers.get" call.
// Exactly one of *Testers or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Testers.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsTestersGetCall) Do(opts ...googleapi.CallOption) (*Testers, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Testers{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets testers. Note: Testers resource does not support email lists.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.testers.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "track"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "track": {
	//       "description": "The track to read from.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}",
	//   "response": {
	//     "$ref": "Testers"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.testers.patch":

type EditsTestersPatchCall struct {
	s           *Service
	packageName string
	editId      string
	track       string
	testers     *Testers
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Patches testers. Note: Testers resource does not support email
// lists.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
// - track: The track to update.
func (r *EditsTestersService) Patch(packageName string, editId string, track string, testers *Testers) *EditsTestersPatchCall {
	c := &EditsTestersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.track = track
	c.testers = testers
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsTestersPatchCall) Fields(s ...googleapi.Field) *EditsTestersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsTestersPatchCall) Context(ctx context.Context) *EditsTestersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsTestersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsTestersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testers)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"track":       c.track,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.testers.patch" call.
// Exactly one of *Testers or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Testers.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsTestersPatchCall) Do(opts ...googleapi.CallOption) (*Testers, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Testers{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Patches testers. Note: Testers resource does not support email lists.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}",
	//   "httpMethod": "PATCH",
	//   "id": "androidpublisher.edits.testers.patch",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "track"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "track": {
	//       "description": "The track to update.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}",
	//   "request": {
	//     "$ref": "Testers"
	//   },
	//   "response": {
	//     "$ref": "Testers"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.testers.update":

type EditsTestersUpdateCall struct {
	s           *Service
	packageName string
	editId      string
	track       string
	testers     *Testers
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Updates testers. Note: Testers resource does not support
// email lists.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
// - track: The track to update.
func (r *EditsTestersService) Update(packageName string, editId string, track string, testers *Testers) *EditsTestersUpdateCall {
	c := &EditsTestersUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.track = track
	c.testers = testers
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsTestersUpdateCall) Fields(s ...googleapi.Field) *EditsTestersUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsTestersUpdateCall) Context(ctx context.Context) *EditsTestersUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsTestersUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsTestersUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testers)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"track":       c.track,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.testers.update" call.
// Exactly one of *Testers or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Testers.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsTestersUpdateCall) Do(opts ...googleapi.CallOption) (*Testers, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Testers{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates testers. Note: Testers resource does not support email lists.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}",
	//   "httpMethod": "PUT",
	//   "id": "androidpublisher.edits.testers.update",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "track"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "track": {
	//       "description": "The track to update.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/testers/{track}",
	//   "request": {
	//     "$ref": "Testers"
	//   },
	//   "response": {
	//     "$ref": "Testers"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.tracks.create":

type EditsTracksCreateCall struct {
	s           *Service
	packageName string
	editId      string
	trackconfig *TrackConfig
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates a new track.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsTracksService) Create(packageName string, editId string, trackconfig *TrackConfig) *EditsTracksCreateCall {
	c := &EditsTracksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.trackconfig = trackconfig
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsTracksCreateCall) Fields(s ...googleapi.Field) *EditsTracksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsTracksCreateCall) Context(ctx context.Context) *EditsTracksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsTracksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsTracksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.trackconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.tracks.create" call.
// Exactly one of *Track or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Track.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsTracksCreateCall) Do(opts ...googleapi.CallOption) (*Track, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Track{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new track.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.edits.tracks.create",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Required. Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks",
	//   "request": {
	//     "$ref": "TrackConfig"
	//   },
	//   "response": {
	//     "$ref": "Track"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.tracks.get":

type EditsTracksGetCall struct {
	s            *Service
	packageName  string
	editId       string
	track        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a track.
//
//   - editId: Identifier of the edit.
//   - packageName: Package name of the app.
//   - track: Identifier of the track. More on track name
//     (https://developers.google.com/android-publisher/tracks#ff-track-name).
func (r *EditsTracksService) Get(packageName string, editId string, track string) *EditsTracksGetCall {
	c := &EditsTracksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.track = track
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsTracksGetCall) Fields(s ...googleapi.Field) *EditsTracksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsTracksGetCall) IfNoneMatch(entityTag string) *EditsTracksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsTracksGetCall) Context(ctx context.Context) *EditsTracksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsTracksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsTracksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"track":       c.track,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.tracks.get" call.
// Exactly one of *Track or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Track.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsTracksGetCall) Do(opts ...googleapi.CallOption) (*Track, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Track{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a track.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.tracks.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "track"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "track": {
	//       "description": "Identifier of the track. [More on track name](https://developers.google.com/android-publisher/tracks#ff-track-name)",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}",
	//   "response": {
	//     "$ref": "Track"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.tracks.list":

type EditsTracksListCall struct {
	s            *Service
	packageName  string
	editId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all tracks.
//
// - editId: Identifier of the edit.
// - packageName: Package name of the app.
func (r *EditsTracksService) List(packageName string, editId string) *EditsTracksListCall {
	c := &EditsTracksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsTracksListCall) Fields(s ...googleapi.Field) *EditsTracksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *EditsTracksListCall) IfNoneMatch(entityTag string) *EditsTracksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsTracksListCall) Context(ctx context.Context) *EditsTracksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsTracksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsTracksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.tracks.list" call.
// Exactly one of *TracksListResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *TracksListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *EditsTracksListCall) Do(opts ...googleapi.CallOption) (*TracksListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TracksListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all tracks.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.edits.tracks.list",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks",
	//   "response": {
	//     "$ref": "TracksListResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.tracks.patch":

type EditsTracksPatchCall struct {
	s           *Service
	packageName string
	editId      string
	track       string
	track2      *Track
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Patches a track.
//
//   - editId: Identifier of the edit.
//   - packageName: Package name of the app.
//   - track: Identifier of the track. More on track name
//     (https://developers.google.com/android-publisher/tracks#ff-track-name).
func (r *EditsTracksService) Patch(packageName string, editId string, track string, track2 *Track) *EditsTracksPatchCall {
	c := &EditsTracksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.track = track
	c.track2 = track2
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsTracksPatchCall) Fields(s ...googleapi.Field) *EditsTracksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsTracksPatchCall) Context(ctx context.Context) *EditsTracksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsTracksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsTracksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.track2)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"track":       c.track,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.tracks.patch" call.
// Exactly one of *Track or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Track.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsTracksPatchCall) Do(opts ...googleapi.CallOption) (*Track, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Track{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Patches a track.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}",
	//   "httpMethod": "PATCH",
	//   "id": "androidpublisher.edits.tracks.patch",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "track"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "track": {
	//       "description": "Identifier of the track. [More on track name](https://developers.google.com/android-publisher/tracks#ff-track-name)",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}",
	//   "request": {
	//     "$ref": "Track"
	//   },
	//   "response": {
	//     "$ref": "Track"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.edits.tracks.update":

type EditsTracksUpdateCall struct {
	s           *Service
	packageName string
	editId      string
	track       string
	track2      *Track
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Updates a track.
//
//   - editId: Identifier of the edit.
//   - packageName: Package name of the app.
//   - track: Identifier of the track. More on track name
//     (https://developers.google.com/android-publisher/tracks#ff-track-name).
func (r *EditsTracksService) Update(packageName string, editId string, track string, track2 *Track) *EditsTracksUpdateCall {
	c := &EditsTracksUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.editId = editId
	c.track = track
	c.track2 = track2
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *EditsTracksUpdateCall) Fields(s ...googleapi.Field) *EditsTracksUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *EditsTracksUpdateCall) Context(ctx context.Context) *EditsTracksUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *EditsTracksUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EditsTracksUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.track2)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"editId":      c.editId,
		"track":       c.track,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.edits.tracks.update" call.
// Exactly one of *Track or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Track.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *EditsTracksUpdateCall) Do(opts ...googleapi.CallOption) (*Track, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Track{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a track.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}",
	//   "httpMethod": "PUT",
	//   "id": "androidpublisher.edits.tracks.update",
	//   "parameterOrder": [
	//     "packageName",
	//     "editId",
	//     "track"
	//   ],
	//   "parameters": {
	//     "editId": {
	//       "description": "Identifier of the edit.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "track": {
	//       "description": "Identifier of the track. [More on track name](https://developers.google.com/android-publisher/tracks#ff-track-name)",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/edits/{editId}/tracks/{track}",
	//   "request": {
	//     "$ref": "Track"
	//   },
	//   "response": {
	//     "$ref": "Track"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.externaltransactions.createexternaltransaction":

type ExternaltransactionsCreateexternaltransactionCall struct {
	s                   *Service
	parent              string
	externaltransaction *ExternalTransaction
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Createexternaltransaction: Creates a new external transaction.
//
//   - parent: The parent resource where this external transaction will be
//     created. Format: applications/{package_name}.
func (r *ExternaltransactionsService) Createexternaltransaction(parent string, externaltransaction *ExternalTransaction) *ExternaltransactionsCreateexternaltransactionCall {
	c := &ExternaltransactionsCreateexternaltransactionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.externaltransaction = externaltransaction
	return c
}

// ExternalTransactionId sets the optional parameter
// "externalTransactionId": Required. The id to use for the external
// transaction. Must be unique across all other transactions for the
// app. This value should be 1-63 characters and valid characters are
// /a-zA-Z0-9_-/. Do not use this field to store any Personally
// Identifiable Information (PII) such as emails. Attempting to store
// PII in this field may result in requests being blocked.
func (c *ExternaltransactionsCreateexternaltransactionCall) ExternalTransactionId(externalTransactionId string) *ExternaltransactionsCreateexternaltransactionCall {
	c.urlParams_.Set("externalTransactionId", externalTransactionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ExternaltransactionsCreateexternaltransactionCall) Fields(s ...googleapi.Field) *ExternaltransactionsCreateexternaltransactionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ExternaltransactionsCreateexternaltransactionCall) Context(ctx context.Context) *ExternaltransactionsCreateexternaltransactionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ExternaltransactionsCreateexternaltransactionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ExternaltransactionsCreateexternaltransactionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.externaltransaction)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/{+parent}/externalTransactions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.externaltransactions.createexternaltransaction" call.
// Exactly one of *ExternalTransaction or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ExternalTransaction.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ExternaltransactionsCreateexternaltransactionCall) Do(opts ...googleapi.CallOption) (*ExternalTransaction, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExternalTransaction{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new external transaction.",
	//   "flatPath": "androidpublisher/v3/applications/{applicationsId}/externalTransactions",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.externaltransactions.createexternaltransaction",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "externalTransactionId": {
	//       "description": "Required. The id to use for the external transaction. Must be unique across all other transactions for the app. This value should be 1-63 characters and valid characters are /a-zA-Z0-9_-/. Do not use this field to store any Personally Identifiable Information (PII) such as emails. Attempting to store PII in this field may result in requests being blocked.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource where this external transaction will be created. Format: applications/{package_name}",
	//       "location": "path",
	//       "pattern": "^applications/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/{+parent}/externalTransactions",
	//   "request": {
	//     "$ref": "ExternalTransaction"
	//   },
	//   "response": {
	//     "$ref": "ExternalTransaction"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.externaltransactions.getexternaltransaction":

type ExternaltransactionsGetexternaltransactionCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Getexternaltransaction: Gets an existing external transaction.
//
//   - name: The name of the external transaction to retrieve. Format:
//     applications/{package_name}/externalTransactions/{external_transacti
//     on}.
func (r *ExternaltransactionsService) Getexternaltransaction(name string) *ExternaltransactionsGetexternaltransactionCall {
	c := &ExternaltransactionsGetexternaltransactionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ExternaltransactionsGetexternaltransactionCall) Fields(s ...googleapi.Field) *ExternaltransactionsGetexternaltransactionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ExternaltransactionsGetexternaltransactionCall) IfNoneMatch(entityTag string) *ExternaltransactionsGetexternaltransactionCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ExternaltransactionsGetexternaltransactionCall) Context(ctx context.Context) *ExternaltransactionsGetexternaltransactionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ExternaltransactionsGetexternaltransactionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ExternaltransactionsGetexternaltransactionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.externaltransactions.getexternaltransaction" call.
// Exactly one of *ExternalTransaction or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ExternalTransaction.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ExternaltransactionsGetexternaltransactionCall) Do(opts ...googleapi.CallOption) (*ExternalTransaction, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExternalTransaction{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an existing external transaction.",
	//   "flatPath": "androidpublisher/v3/applications/{applicationsId}/externalTransactions/{externalTransactionsId}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.externaltransactions.getexternaltransaction",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the external transaction to retrieve. Format: applications/{package_name}/externalTransactions/{external_transaction}",
	//       "location": "path",
	//       "pattern": "^applications/[^/]+/externalTransactions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/{+name}",
	//   "response": {
	//     "$ref": "ExternalTransaction"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.externaltransactions.refundexternaltransaction":

type ExternaltransactionsRefundexternaltransactionCall struct {
	s                                *Service
	name                             string
	refundexternaltransactionrequest *RefundExternalTransactionRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Refundexternaltransaction: Refunds or partially refunds an existing
// external transaction.
//
//   - name: The name of the external transaction that will be refunded.
//     Format:
//     applications/{package_name}/externalTransactions/{external_transacti
//     on}.
func (r *ExternaltransactionsService) Refundexternaltransaction(name string, refundexternaltransactionrequest *RefundExternalTransactionRequest) *ExternaltransactionsRefundexternaltransactionCall {
	c := &ExternaltransactionsRefundexternaltransactionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.refundexternaltransactionrequest = refundexternaltransactionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ExternaltransactionsRefundexternaltransactionCall) Fields(s ...googleapi.Field) *ExternaltransactionsRefundexternaltransactionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ExternaltransactionsRefundexternaltransactionCall) Context(ctx context.Context) *ExternaltransactionsRefundexternaltransactionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ExternaltransactionsRefundexternaltransactionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ExternaltransactionsRefundexternaltransactionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.refundexternaltransactionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/{+name}:refund")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.externaltransactions.refundexternaltransaction" call.
// Exactly one of *ExternalTransaction or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ExternalTransaction.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ExternaltransactionsRefundexternaltransactionCall) Do(opts ...googleapi.CallOption) (*ExternalTransaction, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExternalTransaction{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Refunds or partially refunds an existing external transaction.",
	//   "flatPath": "androidpublisher/v3/applications/{applicationsId}/externalTransactions/{externalTransactionsId}:refund",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.externaltransactions.refundexternaltransaction",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the external transaction that will be refunded. Format: applications/{package_name}/externalTransactions/{external_transaction}",
	//       "location": "path",
	//       "pattern": "^applications/[^/]+/externalTransactions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/{+name}:refund",
	//   "request": {
	//     "$ref": "RefundExternalTransactionRequest"
	//   },
	//   "response": {
	//     "$ref": "ExternalTransaction"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.generatedapks.download":

type GeneratedapksDownloadCall struct {
	s            *Service
	packageName  string
	versionCode  int64
	downloadId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Download: Downloads a single signed APK generated from an app bundle.
//
//   - downloadId: Download ID, which uniquely identifies the APK to
//     download. Can be obtained from the response of `generatedapks.list`
//     method.
//   - packageName: Package name of the app.
//   - versionCode: Version code of the app bundle.
func (r *GeneratedapksService) Download(packageName string, versionCode int64, downloadId string) *GeneratedapksDownloadCall {
	c := &GeneratedapksDownloadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.versionCode = versionCode
	c.downloadId = downloadId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GeneratedapksDownloadCall) Fields(s ...googleapi.Field) *GeneratedapksDownloadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GeneratedapksDownloadCall) IfNoneMatch(entityTag string) *GeneratedapksDownloadCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do and Download
// methods. Any pending HTTP request will be aborted if the provided
// context is canceled.
func (c *GeneratedapksDownloadCall) Context(ctx context.Context) *GeneratedapksDownloadCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GeneratedapksDownloadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GeneratedapksDownloadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/generatedApks/{versionCode}/downloads/{downloadId}:download")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"versionCode": strconv.FormatInt(c.versionCode, 10),
		"downloadId":  c.downloadId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Download fetches the API endpoint's "media" value, instead of the normal
// API response value. If the returned error is nil, the Response is guaranteed to
// have a 2xx status code. Callers must close the Response.Body as usual.
func (c *GeneratedapksDownloadCall) Download(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("media")
	if err != nil {
		return nil, err
	}
	if err := googleapi.CheckResponse(res); err != nil {
		res.Body.Close()
		return nil, gensupport.WrapError(err)
	}
	return res, nil
}

// Do executes the "androidpublisher.generatedapks.download" call.
func (c *GeneratedapksDownloadCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Downloads a single signed APK generated from an app bundle.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/generatedApks/{versionCode}/downloads/{downloadId}:download",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.generatedapks.download",
	//   "parameterOrder": [
	//     "packageName",
	//     "versionCode",
	//     "downloadId"
	//   ],
	//   "parameters": {
	//     "downloadId": {
	//       "description": "Download ID, which uniquely identifies the APK to download. Can be obtained from the response of `generatedapks.list` method.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "versionCode": {
	//       "description": "Version code of the app bundle.",
	//       "format": "int32",
	//       "location": "path",
	//       "required": true,
	//       "type": "integer"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/generatedApks/{versionCode}/downloads/{downloadId}:download",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ],
	//   "supportsMediaDownload": true,
	//   "useMediaDownloadService": true
	// }

}

// method id "androidpublisher.generatedapks.list":

type GeneratedapksListCall struct {
	s            *Service
	packageName  string
	versionCode  int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns download metadata for all APKs that were generated from
// a given app bundle.
//
// - packageName: Package name of the app.
// - versionCode: Version code of the app bundle.
func (r *GeneratedapksService) List(packageName string, versionCode int64) *GeneratedapksListCall {
	c := &GeneratedapksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.versionCode = versionCode
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GeneratedapksListCall) Fields(s ...googleapi.Field) *GeneratedapksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GeneratedapksListCall) IfNoneMatch(entityTag string) *GeneratedapksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GeneratedapksListCall) Context(ctx context.Context) *GeneratedapksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GeneratedapksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GeneratedapksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/generatedApks/{versionCode}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"versionCode": strconv.FormatInt(c.versionCode, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.generatedapks.list" call.
// Exactly one of *GeneratedApksListResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GeneratedApksListResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *GeneratedapksListCall) Do(opts ...googleapi.CallOption) (*GeneratedApksListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GeneratedApksListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns download metadata for all APKs that were generated from a given app bundle.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/generatedApks/{versionCode}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.generatedapks.list",
	//   "parameterOrder": [
	//     "packageName",
	//     "versionCode"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "versionCode": {
	//       "description": "Version code of the app bundle.",
	//       "format": "int32",
	//       "location": "path",
	//       "required": true,
	//       "type": "integer"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/generatedApks/{versionCode}",
	//   "response": {
	//     "$ref": "GeneratedApksListResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.grants.create":

type GrantsCreateCall struct {
	s          *Service
	parent     string
	grant      *Grant
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Grant access for a user to the given package.
//
//   - parent: The user which needs permission. Format:
//     developers/{developer}/users/{user}.
func (r *GrantsService) Create(parent string, grant *Grant) *GrantsCreateCall {
	c := &GrantsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.grant = grant
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GrantsCreateCall) Fields(s ...googleapi.Field) *GrantsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GrantsCreateCall) Context(ctx context.Context) *GrantsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GrantsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GrantsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.grant)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/{+parent}/grants")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.grants.create" call.
// Exactly one of *Grant or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Grant.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *GrantsCreateCall) Do(opts ...googleapi.CallOption) (*Grant, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Grant{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Grant access for a user to the given package.",
	//   "flatPath": "androidpublisher/v3/developers/{developersId}/users/{usersId}/grants",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.grants.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The user which needs permission. Format: developers/{developer}/users/{user}",
	//       "location": "path",
	//       "pattern": "^developers/[^/]+/users/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/{+parent}/grants",
	//   "request": {
	//     "$ref": "Grant"
	//   },
	//   "response": {
	//     "$ref": "Grant"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.grants.delete":

type GrantsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes all access for the user to the given package or
// developer account.
//
//   - name: The name of the grant to delete. Format:
//     developers/{developer}/users/{email}/grants/{package_name}.
func (r *GrantsService) Delete(name string) *GrantsDeleteCall {
	c := &GrantsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GrantsDeleteCall) Fields(s ...googleapi.Field) *GrantsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GrantsDeleteCall) Context(ctx context.Context) *GrantsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GrantsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GrantsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.grants.delete" call.
func (c *GrantsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Removes all access for the user to the given package or developer account.",
	//   "flatPath": "androidpublisher/v3/developers/{developersId}/users/{usersId}/grants/{grantsId}",
	//   "httpMethod": "DELETE",
	//   "id": "androidpublisher.grants.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the grant to delete. Format: developers/{developer}/users/{email}/grants/{package_name}",
	//       "location": "path",
	//       "pattern": "^developers/[^/]+/users/[^/]+/grants/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/{+name}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.grants.patch":

type GrantsPatchCall struct {
	s          *Service
	name       string
	grant      *Grant
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates access for the user to the given package.
//
//   - name: Resource name for this grant, following the pattern
//     "developers/{developer}/users/{email}/grants/{package_name}". If
//     this grant is for a draft app, the app ID will be used in this
//     resource name instead of the package name.
func (r *GrantsService) Patch(name string, grant *Grant) *GrantsPatchCall {
	c := &GrantsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.grant = grant
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *GrantsPatchCall) UpdateMask(updateMask string) *GrantsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GrantsPatchCall) Fields(s ...googleapi.Field) *GrantsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GrantsPatchCall) Context(ctx context.Context) *GrantsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GrantsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GrantsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.grant)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.grants.patch" call.
// Exactly one of *Grant or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Grant.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *GrantsPatchCall) Do(opts ...googleapi.CallOption) (*Grant, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Grant{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates access for the user to the given package.",
	//   "flatPath": "androidpublisher/v3/developers/{developersId}/users/{usersId}/grants/{grantsId}",
	//   "httpMethod": "PATCH",
	//   "id": "androidpublisher.grants.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Resource name for this grant, following the pattern \"developers/{developer}/users/{email}/grants/{package_name}\". If this grant is for a draft app, the app ID will be used in this resource name instead of the package name.",
	//       "location": "path",
	//       "pattern": "^developers/[^/]+/users/[^/]+/grants/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Optional. The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/{+name}",
	//   "request": {
	//     "$ref": "Grant"
	//   },
	//   "response": {
	//     "$ref": "Grant"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.inappproducts.batchDelete":

type InappproductsBatchDeleteCall struct {
	s                               *Service
	packageName                     string
	inappproductsbatchdeleterequest *InappproductsBatchDeleteRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// BatchDelete: Deletes in-app products (managed products or
// subscriptions). Set the latencyTolerance field on nested requests to
// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum
// update throughput. This method should not be used to delete
// subscriptions. See this article
// (https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html)
// for more information.
//
// - packageName: Package name of the app.
func (r *InappproductsService) BatchDelete(packageName string, inappproductsbatchdeleterequest *InappproductsBatchDeleteRequest) *InappproductsBatchDeleteCall {
	c := &InappproductsBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.inappproductsbatchdeleterequest = inappproductsbatchdeleterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *InappproductsBatchDeleteCall) Fields(s ...googleapi.Field) *InappproductsBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *InappproductsBatchDeleteCall) Context(ctx context.Context) *InappproductsBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *InappproductsBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InappproductsBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.inappproductsbatchdeleterequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/inappproducts:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.inappproducts.batchDelete" call.
func (c *InappproductsBatchDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Deletes in-app products (managed products or subscriptions). Set the latencyTolerance field on nested requests to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum update throughput. This method should not be used to delete subscriptions. See [this article](https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html) for more information.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/inappproducts:batchDelete",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.inappproducts.batchDelete",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/inappproducts:batchDelete",
	//   "request": {
	//     "$ref": "InappproductsBatchDeleteRequest"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.inappproducts.batchGet":

type InappproductsBatchGetCall struct {
	s            *Service
	packageName  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Reads multiple in-app products, which can be managed
// products or subscriptions. This method should not be used to retrieve
// subscriptions. See this article
// (https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html)
// for more information.
//
// - packageName: Package name of the app.
func (r *InappproductsService) BatchGet(packageName string) *InappproductsBatchGetCall {
	c := &InappproductsBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	return c
}

// Sku sets the optional parameter "sku": Unique identifier for the
// in-app products.
func (c *InappproductsBatchGetCall) Sku(sku ...string) *InappproductsBatchGetCall {
	c.urlParams_.SetMulti("sku", append([]string{}, sku...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *InappproductsBatchGetCall) Fields(s ...googleapi.Field) *InappproductsBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *InappproductsBatchGetCall) IfNoneMatch(entityTag string) *InappproductsBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *InappproductsBatchGetCall) Context(ctx context.Context) *InappproductsBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *InappproductsBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InappproductsBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/inappproducts:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.inappproducts.batchGet" call.
// Exactly one of *InappproductsBatchGetResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *InappproductsBatchGetResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *InappproductsBatchGetCall) Do(opts ...googleapi.CallOption) (*InappproductsBatchGetResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InappproductsBatchGetResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Reads multiple in-app products, which can be managed products or subscriptions. This method should not be used to retrieve subscriptions. See [this article](https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html) for more information.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/inappproducts:batchGet",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.inappproducts.batchGet",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "sku": {
	//       "description": "Unique identifier for the in-app products.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/inappproducts:batchGet",
	//   "response": {
	//     "$ref": "InappproductsBatchGetResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.inappproducts.batchUpdate":

type InappproductsBatchUpdateCall struct {
	s                               *Service
	packageName                     string
	inappproductsbatchupdaterequest *InappproductsBatchUpdateRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// BatchUpdate: Updates or inserts one or more in-app products (managed
// products or subscriptions). Set the latencyTolerance field on nested
// requests to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to
// achieve maximum update throughput. This method should no longer be
// used to update subscriptions. See this article
// (https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html)
// for more information.
//
// - packageName: Package name of the app.
func (r *InappproductsService) BatchUpdate(packageName string, inappproductsbatchupdaterequest *InappproductsBatchUpdateRequest) *InappproductsBatchUpdateCall {
	c := &InappproductsBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.inappproductsbatchupdaterequest = inappproductsbatchupdaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *InappproductsBatchUpdateCall) Fields(s ...googleapi.Field) *InappproductsBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *InappproductsBatchUpdateCall) Context(ctx context.Context) *InappproductsBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *InappproductsBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InappproductsBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.inappproductsbatchupdaterequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/inappproducts:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.inappproducts.batchUpdate" call.
// Exactly one of *InappproductsBatchUpdateResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *InappproductsBatchUpdateResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *InappproductsBatchUpdateCall) Do(opts ...googleapi.CallOption) (*InappproductsBatchUpdateResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InappproductsBatchUpdateResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates or inserts one or more in-app products (managed products or subscriptions). Set the latencyTolerance field on nested requests to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum update throughput. This method should no longer be used to update subscriptions. See [this article](https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html) for more information.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/inappproducts:batchUpdate",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.inappproducts.batchUpdate",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/inappproducts:batchUpdate",
	//   "request": {
	//     "$ref": "InappproductsBatchUpdateRequest"
	//   },
	//   "response": {
	//     "$ref": "InappproductsBatchUpdateResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.inappproducts.delete":

type InappproductsDeleteCall struct {
	s           *Service
	packageName string
	skuid       string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Delete: Deletes an in-app product (a managed product or a
// subscription). This method should no longer be used to delete
// subscriptions. See this article
// (https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html)
// for more information.
//
// - packageName: Package name of the app.
// - sku: Unique identifier for the in-app product.
func (r *InappproductsService) Delete(packageName string, skuid string) *InappproductsDeleteCall {
	c := &InappproductsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.skuid = skuid
	return c
}

// LatencyTolerance sets the optional parameter "latencyTolerance": The
// latency tolerance for the propagation of this product update.
// Defaults to latency-sensitive.
//
// Possible values:
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
//
// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
//
// will propagate to clients within several minutes on average and up to
// a few hours in rare cases. Throughput is limited to 7,200 updates per
// app per hour.
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
//
// will propagate to clients within 24 hours. Supports high throughput
// of up to 720,000 updates per app per hour using batch modification
// methods.
func (c *InappproductsDeleteCall) LatencyTolerance(latencyTolerance string) *InappproductsDeleteCall {
	c.urlParams_.Set("latencyTolerance", latencyTolerance)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *InappproductsDeleteCall) Fields(s ...googleapi.Field) *InappproductsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *InappproductsDeleteCall) Context(ctx context.Context) *InappproductsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *InappproductsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InappproductsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"sku":         c.skuid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.inappproducts.delete" call.
func (c *InappproductsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Deletes an in-app product (a managed product or a subscription). This method should no longer be used to delete subscriptions. See [this article](https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html) for more information.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}",
	//   "httpMethod": "DELETE",
	//   "id": "androidpublisher.inappproducts.delete",
	//   "parameterOrder": [
	//     "packageName",
	//     "sku"
	//   ],
	//   "parameters": {
	//     "latencyTolerance": {
	//       "description": "Optional. The latency tolerance for the propagation of this product update. Defaults to latency-sensitive.",
	//       "enum": [
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED",
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE",
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT"
	//       ],
	//       "enumDescriptions": [
	//         "Defaults to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.",
	//         "The update will propagate to clients within several minutes on average and up to a few hours in rare cases. Throughput is limited to 7,200 updates per app per hour.",
	//         "The update will propagate to clients within 24 hours. Supports high throughput of up to 720,000 updates per app per hour using batch modification methods."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "sku": {
	//       "description": "Unique identifier for the in-app product.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.inappproducts.get":

type InappproductsGetCall struct {
	s            *Service
	packageName  string
	skuid        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an in-app product, which can be a managed product or a
// subscription. This method should no longer be used to retrieve
// subscriptions. See this article
// (https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html)
// for more information.
//
// - packageName: Package name of the app.
// - sku: Unique identifier for the in-app product.
func (r *InappproductsService) Get(packageName string, skuid string) *InappproductsGetCall {
	c := &InappproductsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.skuid = skuid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *InappproductsGetCall) Fields(s ...googleapi.Field) *InappproductsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *InappproductsGetCall) IfNoneMatch(entityTag string) *InappproductsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *InappproductsGetCall) Context(ctx context.Context) *InappproductsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *InappproductsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InappproductsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"sku":         c.skuid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.inappproducts.get" call.
// Exactly one of *InAppProduct or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *InAppProduct.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InappproductsGetCall) Do(opts ...googleapi.CallOption) (*InAppProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InAppProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an in-app product, which can be a managed product or a subscription. This method should no longer be used to retrieve subscriptions. See [this article](https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html) for more information.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.inappproducts.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "sku"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "sku": {
	//       "description": "Unique identifier for the in-app product.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}",
	//   "response": {
	//     "$ref": "InAppProduct"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.inappproducts.insert":

type InappproductsInsertCall struct {
	s            *Service
	packageName  string
	inappproduct *InAppProduct
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Insert: Creates an in-app product (a managed product or a
// subscription). This method should no longer be used to create
// subscriptions. See this article
// (https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html)
// for more information.
//
// - packageName: Package name of the app.
func (r *InappproductsService) Insert(packageName string, inappproduct *InAppProduct) *InappproductsInsertCall {
	c := &InappproductsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.inappproduct = inappproduct
	return c
}

// AutoConvertMissingPrices sets the optional parameter
// "autoConvertMissingPrices": If true the prices for all regions
// targeted by the parent app that don't have a price specified for this
// in-app product will be auto converted to the target currency based on
// the default price. Defaults to false.
func (c *InappproductsInsertCall) AutoConvertMissingPrices(autoConvertMissingPrices bool) *InappproductsInsertCall {
	c.urlParams_.Set("autoConvertMissingPrices", fmt.Sprint(autoConvertMissingPrices))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *InappproductsInsertCall) Fields(s ...googleapi.Field) *InappproductsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *InappproductsInsertCall) Context(ctx context.Context) *InappproductsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *InappproductsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InappproductsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.inappproduct)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/inappproducts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.inappproducts.insert" call.
// Exactly one of *InAppProduct or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *InAppProduct.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InappproductsInsertCall) Do(opts ...googleapi.CallOption) (*InAppProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InAppProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an in-app product (a managed product or a subscription). This method should no longer be used to create subscriptions. See [this article](https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html) for more information.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/inappproducts",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.inappproducts.insert",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "autoConvertMissingPrices": {
	//       "description": "If true the prices for all regions targeted by the parent app that don't have a price specified for this in-app product will be auto converted to the target currency based on the default price. Defaults to false.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/inappproducts",
	//   "request": {
	//     "$ref": "InAppProduct"
	//   },
	//   "response": {
	//     "$ref": "InAppProduct"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.inappproducts.list":

type InappproductsListCall struct {
	s            *Service
	packageName  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all in-app products - both managed products and
// subscriptions. If an app has a large number of in-app products, the
// response may be paginated. In this case the response field
// `tokenPagination.nextPageToken` will be set and the caller should
// provide its value as a `token` request parameter to retrieve the next
// page. This method should no longer be used to retrieve subscriptions.
// See this article
// (https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html)
// for more information.
//
// - packageName: Package name of the app.
func (r *InappproductsService) List(packageName string) *InappproductsListCall {
	c := &InappproductsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	return c
}

// MaxResults sets the optional parameter "maxResults": Deprecated and
// ignored. The page size is determined by the server.
func (c *InappproductsListCall) MaxResults(maxResults int64) *InappproductsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// StartIndex sets the optional parameter "startIndex": Deprecated and
// ignored. Set the `token` parameter to retrieve the next page.
func (c *InappproductsListCall) StartIndex(startIndex int64) *InappproductsListCall {
	c.urlParams_.Set("startIndex", fmt.Sprint(startIndex))
	return c
}

// Token sets the optional parameter "token": Pagination token. If
// empty, list starts at the first product.
func (c *InappproductsListCall) Token(token string) *InappproductsListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *InappproductsListCall) Fields(s ...googleapi.Field) *InappproductsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *InappproductsListCall) IfNoneMatch(entityTag string) *InappproductsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *InappproductsListCall) Context(ctx context.Context) *InappproductsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *InappproductsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InappproductsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/inappproducts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.inappproducts.list" call.
// Exactly one of *InappproductsListResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *InappproductsListResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *InappproductsListCall) Do(opts ...googleapi.CallOption) (*InappproductsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InappproductsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all in-app products - both managed products and subscriptions. If an app has a large number of in-app products, the response may be paginated. In this case the response field `tokenPagination.nextPageToken` will be set and the caller should provide its value as a `token` request parameter to retrieve the next page. This method should no longer be used to retrieve subscriptions. See [this article](https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html) for more information.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/inappproducts",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.inappproducts.list",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "maxResults": {
	//       "deprecated": true,
	//       "description": "Deprecated and ignored. The page size is determined by the server.",
	//       "format": "uint32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "startIndex": {
	//       "deprecated": true,
	//       "description": "Deprecated and ignored. Set the `token` parameter to retrieve the next page.",
	//       "format": "uint32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "token": {
	//       "description": "Pagination token. If empty, list starts at the first product.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/inappproducts",
	//   "response": {
	//     "$ref": "InappproductsListResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.inappproducts.patch":

type InappproductsPatchCall struct {
	s            *Service
	packageName  string
	skuid        string
	inappproduct *InAppProduct
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Patches an in-app product (a managed product or a
// subscription). This method should no longer be used to update
// subscriptions. See this article
// (https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html)
// for more information.
//
// - packageName: Package name of the app.
// - sku: Unique identifier for the in-app product.
func (r *InappproductsService) Patch(packageName string, skuid string, inappproduct *InAppProduct) *InappproductsPatchCall {
	c := &InappproductsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.skuid = skuid
	c.inappproduct = inappproduct
	return c
}

// AutoConvertMissingPrices sets the optional parameter
// "autoConvertMissingPrices": If true the prices for all regions
// targeted by the parent app that don't have a price specified for this
// in-app product will be auto converted to the target currency based on
// the default price. Defaults to false.
func (c *InappproductsPatchCall) AutoConvertMissingPrices(autoConvertMissingPrices bool) *InappproductsPatchCall {
	c.urlParams_.Set("autoConvertMissingPrices", fmt.Sprint(autoConvertMissingPrices))
	return c
}

// LatencyTolerance sets the optional parameter "latencyTolerance": The
// latency tolerance for the propagation of this product update.
// Defaults to latency-sensitive.
//
// Possible values:
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
//
// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
//
// will propagate to clients within several minutes on average and up to
// a few hours in rare cases. Throughput is limited to 7,200 updates per
// app per hour.
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
//
// will propagate to clients within 24 hours. Supports high throughput
// of up to 720,000 updates per app per hour using batch modification
// methods.
func (c *InappproductsPatchCall) LatencyTolerance(latencyTolerance string) *InappproductsPatchCall {
	c.urlParams_.Set("latencyTolerance", latencyTolerance)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *InappproductsPatchCall) Fields(s ...googleapi.Field) *InappproductsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *InappproductsPatchCall) Context(ctx context.Context) *InappproductsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *InappproductsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InappproductsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.inappproduct)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"sku":         c.skuid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.inappproducts.patch" call.
// Exactly one of *InAppProduct or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *InAppProduct.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InappproductsPatchCall) Do(opts ...googleapi.CallOption) (*InAppProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InAppProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Patches an in-app product (a managed product or a subscription). This method should no longer be used to update subscriptions. See [this article](https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html) for more information.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}",
	//   "httpMethod": "PATCH",
	//   "id": "androidpublisher.inappproducts.patch",
	//   "parameterOrder": [
	//     "packageName",
	//     "sku"
	//   ],
	//   "parameters": {
	//     "autoConvertMissingPrices": {
	//       "description": "If true the prices for all regions targeted by the parent app that don't have a price specified for this in-app product will be auto converted to the target currency based on the default price. Defaults to false.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "latencyTolerance": {
	//       "description": "Optional. The latency tolerance for the propagation of this product update. Defaults to latency-sensitive.",
	//       "enum": [
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED",
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE",
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT"
	//       ],
	//       "enumDescriptions": [
	//         "Defaults to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.",
	//         "The update will propagate to clients within several minutes on average and up to a few hours in rare cases. Throughput is limited to 7,200 updates per app per hour.",
	//         "The update will propagate to clients within 24 hours. Supports high throughput of up to 720,000 updates per app per hour using batch modification methods."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "sku": {
	//       "description": "Unique identifier for the in-app product.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}",
	//   "request": {
	//     "$ref": "InAppProduct"
	//   },
	//   "response": {
	//     "$ref": "InAppProduct"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.inappproducts.update":

type InappproductsUpdateCall struct {
	s            *Service
	packageName  string
	skuid        string
	inappproduct *InAppProduct
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Update: Updates an in-app product (a managed product or a
// subscription). This method should no longer be used to update
// subscriptions. See this article
// (https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html)
// for more information.
//
// - packageName: Package name of the app.
// - sku: Unique identifier for the in-app product.
func (r *InappproductsService) Update(packageName string, skuid string, inappproduct *InAppProduct) *InappproductsUpdateCall {
	c := &InappproductsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.skuid = skuid
	c.inappproduct = inappproduct
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the in-app product with the given package_name and sku
// doesn't exist, the in-app product will be created.
func (c *InappproductsUpdateCall) AllowMissing(allowMissing bool) *InappproductsUpdateCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// AutoConvertMissingPrices sets the optional parameter
// "autoConvertMissingPrices": If true the prices for all regions
// targeted by the parent app that don't have a price specified for this
// in-app product will be auto converted to the target currency based on
// the default price. Defaults to false.
func (c *InappproductsUpdateCall) AutoConvertMissingPrices(autoConvertMissingPrices bool) *InappproductsUpdateCall {
	c.urlParams_.Set("autoConvertMissingPrices", fmt.Sprint(autoConvertMissingPrices))
	return c
}

// LatencyTolerance sets the optional parameter "latencyTolerance": The
// latency tolerance for the propagation of this product update.
// Defaults to latency-sensitive.
//
// Possible values:
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
//
// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
//
// will propagate to clients within several minutes on average and up to
// a few hours in rare cases. Throughput is limited to 7,200 updates per
// app per hour.
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
//
// will propagate to clients within 24 hours. Supports high throughput
// of up to 720,000 updates per app per hour using batch modification
// methods.
func (c *InappproductsUpdateCall) LatencyTolerance(latencyTolerance string) *InappproductsUpdateCall {
	c.urlParams_.Set("latencyTolerance", latencyTolerance)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *InappproductsUpdateCall) Fields(s ...googleapi.Field) *InappproductsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *InappproductsUpdateCall) Context(ctx context.Context) *InappproductsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *InappproductsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InappproductsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.inappproduct)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"sku":         c.skuid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.inappproducts.update" call.
// Exactly one of *InAppProduct or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *InAppProduct.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InappproductsUpdateCall) Do(opts ...googleapi.CallOption) (*InAppProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InAppProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an in-app product (a managed product or a subscription). This method should no longer be used to update subscriptions. See [this article](https://android-developers.googleblog.com/2023/06/changes-to-google-play-developer-api-june-2023.html) for more information.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}",
	//   "httpMethod": "PUT",
	//   "id": "androidpublisher.inappproducts.update",
	//   "parameterOrder": [
	//     "packageName",
	//     "sku"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the in-app product with the given package_name and sku doesn't exist, the in-app product will be created.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "autoConvertMissingPrices": {
	//       "description": "If true the prices for all regions targeted by the parent app that don't have a price specified for this in-app product will be auto converted to the target currency based on the default price. Defaults to false.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "latencyTolerance": {
	//       "description": "Optional. The latency tolerance for the propagation of this product update. Defaults to latency-sensitive.",
	//       "enum": [
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED",
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE",
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT"
	//       ],
	//       "enumDescriptions": [
	//         "Defaults to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.",
	//         "The update will propagate to clients within several minutes on average and up to a few hours in rare cases. Throughput is limited to 7,200 updates per app per hour.",
	//         "The update will propagate to clients within 24 hours. Supports high throughput of up to 720,000 updates per app per hour using batch modification methods."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "sku": {
	//       "description": "Unique identifier for the in-app product.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/inappproducts/{sku}",
	//   "request": {
	//     "$ref": "InAppProduct"
	//   },
	//   "response": {
	//     "$ref": "InAppProduct"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.internalappsharingartifacts.uploadapk":

type InternalappsharingartifactsUploadapkCall struct {
	s           *Service
	packageName string
	urlParams_  gensupport.URLParams
	mediaInfo_  *gensupport.MediaInfo
	ctx_        context.Context
	header_     http.Header
}

// Uploadapk: Uploads an APK to internal app sharing. If you are using
// the Google API client libraries, please increase the timeout of the
// http request before calling this endpoint (a timeout of 2 minutes is
// recommended). See Timeouts and Errors
// (https://developers.google.com/api-client-library/java/google-api-java-client/errors)
// for an example in java.
//
// - packageName: Package name of the app.
func (r *InternalappsharingartifactsService) Uploadapk(packageName string) *InternalappsharingartifactsUploadapkCall {
	c := &InternalappsharingartifactsUploadapkCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk
// size may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the
// upload request will be determined by sniffing the contents of r,
// unless a MediaOption generated by googleapi.ContentType is
// supplied.
// At most one of Media and ResumableMedia may be set.
func (c *InternalappsharingartifactsUploadapkCall) Media(r io.Reader, options ...googleapi.MediaOption) *InternalappsharingartifactsUploadapkCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be
// canceled with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType
// identifies the MIME media type of the upload, such as "image/png". If
// mediaType is "", it will be auto-detected. The provided ctx will
// supersede any context previously provided to the Context method.
func (c *InternalappsharingartifactsUploadapkCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *InternalappsharingartifactsUploadapkCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called
// after every chunk. It should be a low-latency function in order to
// not slow down the upload operation. This should only be called when
// using ResumableMedia (as opposed to Media).
func (c *InternalappsharingartifactsUploadapkCall) ProgressUpdater(pu googleapi.ProgressUpdater) *InternalappsharingartifactsUploadapkCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *InternalappsharingartifactsUploadapkCall) Fields(s ...googleapi.Field) *InternalappsharingartifactsUploadapkCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *InternalappsharingartifactsUploadapkCall) Context(ctx context.Context) *InternalappsharingartifactsUploadapkCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *InternalappsharingartifactsUploadapkCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InternalappsharingartifactsUploadapkCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/apk")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/apk")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	if body == nil {
		body = new(bytes.Buffer)
		reqHeaders.Set("Content-Type", "application/json")
	}
	body, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.internalappsharingartifacts.uploadapk" call.
// Exactly one of *InternalAppSharingArtifact or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *InternalAppSharingArtifact.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *InternalappsharingartifactsUploadapkCall) Do(opts ...googleapi.CallOption) (*InternalAppSharingArtifact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &InternalAppSharingArtifact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Uploads an APK to internal app sharing. If you are using the Google API client libraries, please increase the timeout of the http request before calling this endpoint (a timeout of 2 minutes is recommended). See [Timeouts and Errors](https://developers.google.com/api-client-library/java/google-api-java-client/errors) for an example in java.",
	//   "flatPath": "androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/apk",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.internalappsharingartifacts.uploadapk",
	//   "mediaUpload": {
	//     "accept": [
	//       "application/octet-stream",
	//       "application/vnd.android.package-archive"
	//     ],
	//     "maxSize": "1073741824",
	//     "protocols": {
	//       "resumable": {
	//         "multipart": true,
	//         "path": "/resumable/upload/androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/apk"
	//       },
	//       "simple": {
	//         "multipart": true,
	//         "path": "/upload/androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/apk"
	//       }
	//     }
	//   },
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/apk",
	//   "response": {
	//     "$ref": "InternalAppSharingArtifact"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ],
	//   "supportsMediaUpload": true
	// }

}

// method id "androidpublisher.internalappsharingartifacts.uploadbundle":

type InternalappsharingartifactsUploadbundleCall struct {
	s           *Service
	packageName string
	urlParams_  gensupport.URLParams
	mediaInfo_  *gensupport.MediaInfo
	ctx_        context.Context
	header_     http.Header
}

// Uploadbundle: Uploads an app bundle to internal app sharing. If you
// are using the Google API client libraries, please increase the
// timeout of the http request before calling this endpoint (a timeout
// of 2 minutes is recommended). See Timeouts and Errors
// (https://developers.google.com/api-client-library/java/google-api-java-client/errors)
// for an example in java.
//
// - packageName: Package name of the app.
func (r *InternalappsharingartifactsService) Uploadbundle(packageName string) *InternalappsharingartifactsUploadbundleCall {
	c := &InternalappsharingartifactsUploadbundleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk
// size may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the
// upload request will be determined by sniffing the contents of r,
// unless a MediaOption generated by googleapi.ContentType is
// supplied.
// At most one of Media and ResumableMedia may be set.
func (c *InternalappsharingartifactsUploadbundleCall) Media(r io.Reader, options ...googleapi.MediaOption) *InternalappsharingartifactsUploadbundleCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be
// canceled with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType
// identifies the MIME media type of the upload, such as "image/png". If
// mediaType is "", it will be auto-detected. The provided ctx will
// supersede any context previously provided to the Context method.
func (c *InternalappsharingartifactsUploadbundleCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *InternalappsharingartifactsUploadbundleCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called
// after every chunk. It should be a low-latency function in order to
// not slow down the upload operation. This should only be called when
// using ResumableMedia (as opposed to Media).
func (c *InternalappsharingartifactsUploadbundleCall) ProgressUpdater(pu googleapi.ProgressUpdater) *InternalappsharingartifactsUploadbundleCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *InternalappsharingartifactsUploadbundleCall) Fields(s ...googleapi.Field) *InternalappsharingartifactsUploadbundleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *InternalappsharingartifactsUploadbundleCall) Context(ctx context.Context) *InternalappsharingartifactsUploadbundleCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *InternalappsharingartifactsUploadbundleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InternalappsharingartifactsUploadbundleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/bundle")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/bundle")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	if body == nil {
		body = new(bytes.Buffer)
		reqHeaders.Set("Content-Type", "application/json")
	}
	body, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.internalappsharingartifacts.uploadbundle" call.
// Exactly one of *InternalAppSharingArtifact or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *InternalAppSharingArtifact.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *InternalappsharingartifactsUploadbundleCall) Do(opts ...googleapi.CallOption) (*InternalAppSharingArtifact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &InternalAppSharingArtifact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Uploads an app bundle to internal app sharing. If you are using the Google API client libraries, please increase the timeout of the http request before calling this endpoint (a timeout of 2 minutes is recommended). See [Timeouts and Errors](https://developers.google.com/api-client-library/java/google-api-java-client/errors) for an example in java.",
	//   "flatPath": "androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/bundle",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.internalappsharingartifacts.uploadbundle",
	//   "mediaUpload": {
	//     "accept": [
	//       "application/octet-stream"
	//     ],
	//     "maxSize": "10737418240",
	//     "protocols": {
	//       "resumable": {
	//         "multipart": true,
	//         "path": "/resumable/upload/androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/bundle"
	//       },
	//       "simple": {
	//         "multipart": true,
	//         "path": "/upload/androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/bundle"
	//       }
	//     }
	//   },
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Package name of the app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/internalappsharing/{packageName}/artifacts/bundle",
	//   "response": {
	//     "$ref": "InternalAppSharingArtifact"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ],
	//   "supportsMediaUpload": true
	// }

}

// method id "androidpublisher.monetization.convertRegionPrices":

type MonetizationConvertRegionPricesCall struct {
	s                          *Service
	packageName                string
	convertregionpricesrequest *ConvertRegionPricesRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// ConvertRegionPrices: Calculates the region prices, using today's
// exchange rate and country-specific pricing patterns, based on the
// price in the request for a set of regions.
//
// - packageName: The app package name.
func (r *MonetizationService) ConvertRegionPrices(packageName string, convertregionpricesrequest *ConvertRegionPricesRequest) *MonetizationConvertRegionPricesCall {
	c := &MonetizationConvertRegionPricesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.convertregionpricesrequest = convertregionpricesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationConvertRegionPricesCall) Fields(s ...googleapi.Field) *MonetizationConvertRegionPricesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationConvertRegionPricesCall) Context(ctx context.Context) *MonetizationConvertRegionPricesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationConvertRegionPricesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationConvertRegionPricesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.convertregionpricesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/pricing:convertRegionPrices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.convertRegionPrices" call.
// Exactly one of *ConvertRegionPricesResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ConvertRegionPricesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationConvertRegionPricesCall) Do(opts ...googleapi.CallOption) (*ConvertRegionPricesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConvertRegionPricesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the region prices, using today's exchange rate and country-specific pricing patterns, based on the price in the request for a set of regions.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/pricing:convertRegionPrices",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.convertRegionPrices",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. The app package name.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/pricing:convertRegionPrices",
	//   "request": {
	//     "$ref": "ConvertRegionPricesRequest"
	//   },
	//   "response": {
	//     "$ref": "ConvertRegionPricesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.archive":

type MonetizationSubscriptionsArchiveCall struct {
	s                          *Service
	packageName                string
	productId                  string
	archivesubscriptionrequest *ArchiveSubscriptionRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Archive: Deprecated: subscription archiving is not supported.
//
//   - packageName: The parent app (package name) of the app of the
//     subscription to delete.
//   - productId: The unique product ID of the subscription to delete.
func (r *MonetizationSubscriptionsService) Archive(packageName string, productId string, archivesubscriptionrequest *ArchiveSubscriptionRequest) *MonetizationSubscriptionsArchiveCall {
	c := &MonetizationSubscriptionsArchiveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.archivesubscriptionrequest = archivesubscriptionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsArchiveCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsArchiveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsArchiveCall) Context(ctx context.Context) *MonetizationSubscriptionsArchiveCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsArchiveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsArchiveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.archivesubscriptionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}:archive")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.archive" call.
// Exactly one of *Subscription or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Subscription.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsArchiveCall) Do(opts ...googleapi.CallOption) (*Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "deprecated": true,
	//   "description": "Deprecated: subscription archiving is not supported.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}:archive",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.archive",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the app of the subscription to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The unique product ID of the subscription to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}:archive",
	//   "request": {
	//     "$ref": "ArchiveSubscriptionRequest"
	//   },
	//   "response": {
	//     "$ref": "Subscription"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.batchGet":

type MonetizationSubscriptionsBatchGetCall struct {
	s            *Service
	packageName  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Reads one or more subscriptions.
//
//   - packageName: The parent app (package name) for which the
//     subscriptions should be retrieved. Must be equal to the
//     package_name field on all the requests.
func (r *MonetizationSubscriptionsService) BatchGet(packageName string) *MonetizationSubscriptionsBatchGetCall {
	c := &MonetizationSubscriptionsBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	return c
}

// ProductIds sets the optional parameter "productIds": Required. A list
// of up to 100 subscription product IDs to retrieve. All the IDs must
// be different.
func (c *MonetizationSubscriptionsBatchGetCall) ProductIds(productIds ...string) *MonetizationSubscriptionsBatchGetCall {
	c.urlParams_.SetMulti("productIds", append([]string{}, productIds...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBatchGetCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MonetizationSubscriptionsBatchGetCall) IfNoneMatch(entityTag string) *MonetizationSubscriptionsBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBatchGetCall) Context(ctx context.Context) *MonetizationSubscriptionsBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.batchGet" call.
// Exactly one of *BatchGetSubscriptionsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *BatchGetSubscriptionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBatchGetCall) Do(opts ...googleapi.CallOption) (*BatchGetSubscriptionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchGetSubscriptionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Reads one or more subscriptions.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions:batchGet",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.monetization.subscriptions.batchGet",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. The parent app (package name) for which the subscriptions should be retrieved. Must be equal to the package_name field on all the requests.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productIds": {
	//       "description": "Required. A list of up to 100 subscription product IDs to retrieve. All the IDs must be different.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions:batchGet",
	//   "response": {
	//     "$ref": "BatchGetSubscriptionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.batchUpdate":

type MonetizationSubscriptionsBatchUpdateCall struct {
	s                               *Service
	packageName                     string
	batchupdatesubscriptionsrequest *BatchUpdateSubscriptionsRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// BatchUpdate: Updates a batch of subscriptions. Set the
// latencyTolerance field on nested requests to
// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum
// update throughput.
//
//   - packageName: The parent app (package name) for which the
//     subscriptions should be updated. Must be equal to the package_name
//     field on all the Subscription resources.
func (r *MonetizationSubscriptionsService) BatchUpdate(packageName string, batchupdatesubscriptionsrequest *BatchUpdateSubscriptionsRequest) *MonetizationSubscriptionsBatchUpdateCall {
	c := &MonetizationSubscriptionsBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.batchupdatesubscriptionsrequest = batchupdatesubscriptionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBatchUpdateCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBatchUpdateCall) Context(ctx context.Context) *MonetizationSubscriptionsBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchupdatesubscriptionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.batchUpdate" call.
// Exactly one of *BatchUpdateSubscriptionsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *BatchUpdateSubscriptionsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBatchUpdateCall) Do(opts ...googleapi.CallOption) (*BatchUpdateSubscriptionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchUpdateSubscriptionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a batch of subscriptions. Set the latencyTolerance field on nested requests to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum update throughput.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions:batchUpdate",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.batchUpdate",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. The parent app (package name) for which the subscriptions should be updated. Must be equal to the package_name field on all the Subscription resources.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions:batchUpdate",
	//   "request": {
	//     "$ref": "BatchUpdateSubscriptionsRequest"
	//   },
	//   "response": {
	//     "$ref": "BatchUpdateSubscriptionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.create":

type MonetizationSubscriptionsCreateCall struct {
	s            *Service
	packageName  string
	subscription *Subscription
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new subscription. Newly added base plans will
// remain in draft state until activated.
//
//   - packageName: The parent app (package name) for which the
//     subscription should be created. Must be equal to the package_name
//     field on the Subscription resource.
func (r *MonetizationSubscriptionsService) Create(packageName string, subscription *Subscription) *MonetizationSubscriptionsCreateCall {
	c := &MonetizationSubscriptionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.subscription = subscription
	return c
}

// ProductId sets the optional parameter "productId": Required. The ID
// to use for the subscription. For the requirements on this format, see
// the documentation of the product_id field on the Subscription
// resource.
func (c *MonetizationSubscriptionsCreateCall) ProductId(productId string) *MonetizationSubscriptionsCreateCall {
	c.urlParams_.Set("productId", productId)
	return c
}

// RegionsVersionVersion sets the optional parameter
// "regionsVersion.version": Required. A string representing the version
// of available regions being used for the specified resource. Regional
// prices for the resource have to be specified according to the
// information published in this article
// (https://support.google.com/googleplay/android-developer/answer/10532353).
// Each time the supported locations substantially change, the version
// will be incremented. Using this field will ensure that creating and
// updating the resource with an older region's version and set of
// regional prices and currencies will succeed even though a new version
// is available. The latest version is 2022/02.
func (c *MonetizationSubscriptionsCreateCall) RegionsVersionVersion(regionsVersionVersion string) *MonetizationSubscriptionsCreateCall {
	c.urlParams_.Set("regionsVersion.version", regionsVersionVersion)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsCreateCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsCreateCall) Context(ctx context.Context) *MonetizationSubscriptionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.subscription)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.create" call.
// Exactly one of *Subscription or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Subscription.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsCreateCall) Do(opts ...googleapi.CallOption) (*Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new subscription. Newly added base plans will remain in draft state until activated.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.create",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. The parent app (package name) for which the subscription should be created. Must be equal to the package_name field on the Subscription resource.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The ID to use for the subscription. For the requirements on this format, see the documentation of the product_id field on the Subscription resource.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "regionsVersion.version": {
	//       "description": "Required. A string representing the version of available regions being used for the specified resource. Regional prices for the resource have to be specified according to the information published in [this article](https://support.google.com/googleplay/android-developer/answer/10532353). Each time the supported locations substantially change, the version will be incremented. Using this field will ensure that creating and updating the resource with an older region's version and set of regional prices and currencies will succeed even though a new version is available. The latest version is 2022/02.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions",
	//   "request": {
	//     "$ref": "Subscription"
	//   },
	//   "response": {
	//     "$ref": "Subscription"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.delete":

type MonetizationSubscriptionsDeleteCall struct {
	s           *Service
	packageName string
	productId   string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Delete: Deletes a subscription. A subscription can only be deleted if
// it has never had a base plan published.
//
//   - packageName: The parent app (package name) of the app of the
//     subscription to delete.
//   - productId: The unique product ID of the subscription to delete.
func (r *MonetizationSubscriptionsService) Delete(packageName string, productId string) *MonetizationSubscriptionsDeleteCall {
	c := &MonetizationSubscriptionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsDeleteCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsDeleteCall) Context(ctx context.Context) *MonetizationSubscriptionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.delete" call.
func (c *MonetizationSubscriptionsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Deletes a subscription. A subscription can only be deleted if it has never had a base plan published.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}",
	//   "httpMethod": "DELETE",
	//   "id": "androidpublisher.monetization.subscriptions.delete",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the app of the subscription to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The unique product ID of the subscription to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.get":

type MonetizationSubscriptionsGetCall struct {
	s            *Service
	packageName  string
	productId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Reads a single subscription.
//
//   - packageName: The parent app (package name) of the subscription to
//     get.
//   - productId: The unique product ID of the subscription to get.
func (r *MonetizationSubscriptionsService) Get(packageName string, productId string) *MonetizationSubscriptionsGetCall {
	c := &MonetizationSubscriptionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsGetCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MonetizationSubscriptionsGetCall) IfNoneMatch(entityTag string) *MonetizationSubscriptionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsGetCall) Context(ctx context.Context) *MonetizationSubscriptionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.get" call.
// Exactly one of *Subscription or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Subscription.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsGetCall) Do(opts ...googleapi.CallOption) (*Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Reads a single subscription.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.monetization.subscriptions.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the subscription to get.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The unique product ID of the subscription to get.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}",
	//   "response": {
	//     "$ref": "Subscription"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.list":

type MonetizationSubscriptionsListCall struct {
	s            *Service
	packageName  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all subscriptions under a given app.
//
//   - packageName: The parent app (package name) for which the
//     subscriptions should be read.
func (r *MonetizationSubscriptionsService) List(packageName string) *MonetizationSubscriptionsListCall {
	c := &MonetizationSubscriptionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of subscriptions to return. The service may return fewer than this
// value. If unspecified, at most 50 subscriptions will be returned. The
// maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *MonetizationSubscriptionsListCall) PageSize(pageSize int64) *MonetizationSubscriptionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListSubscriptions` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListSubscriptions` must match the call that provided the
// page token.
func (c *MonetizationSubscriptionsListCall) PageToken(pageToken string) *MonetizationSubscriptionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowArchived sets the optional parameter "showArchived": Deprecated:
// subscription archiving is not supported.
func (c *MonetizationSubscriptionsListCall) ShowArchived(showArchived bool) *MonetizationSubscriptionsListCall {
	c.urlParams_.Set("showArchived", fmt.Sprint(showArchived))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsListCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MonetizationSubscriptionsListCall) IfNoneMatch(entityTag string) *MonetizationSubscriptionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsListCall) Context(ctx context.Context) *MonetizationSubscriptionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.list" call.
// Exactly one of *ListSubscriptionsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListSubscriptionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsListCall) Do(opts ...googleapi.CallOption) (*ListSubscriptionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSubscriptionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all subscriptions under a given app.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.monetization.subscriptions.list",
	//   "parameterOrder": [
	//     "packageName"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. The parent app (package name) for which the subscriptions should be read.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of subscriptions to return. The service may return fewer than this value. If unspecified, at most 50 subscriptions will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListSubscriptions` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListSubscriptions` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "showArchived": {
	//       "deprecated": true,
	//       "description": "Deprecated: subscription archiving is not supported.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions",
	//   "response": {
	//     "$ref": "ListSubscriptionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *MonetizationSubscriptionsListCall) Pages(ctx context.Context, f func(*ListSubscriptionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "androidpublisher.monetization.subscriptions.patch":

type MonetizationSubscriptionsPatchCall struct {
	s            *Service
	packageName  string
	productId    string
	subscription *Subscription
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates an existing subscription.
//
//   - packageName: Immutable. Package name of the parent app.
//   - productId: Immutable. Unique product ID of the product. Unique
//     within the parent app. Product IDs must be composed of lower-case
//     letters (a-z), numbers (0-9), underscores (_) and dots (.). It must
//     start with a lower-case letter or number, and be between 1 and 40
//     (inclusive) characters in length.
func (r *MonetizationSubscriptionsService) Patch(packageName string, productId string, subscription *Subscription) *MonetizationSubscriptionsPatchCall {
	c := &MonetizationSubscriptionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.subscription = subscription
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the subscription with the given package_name and product_id
// doesn't exist, the subscription will be created. If a new
// subscription is created, update_mask is ignored.
func (c *MonetizationSubscriptionsPatchCall) AllowMissing(allowMissing bool) *MonetizationSubscriptionsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// LatencyTolerance sets the optional parameter "latencyTolerance": The
// latency tolerance for the propagation of this product update.
// Defaults to latency-sensitive.
//
// Possible values:
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
//
// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
//
// will propagate to clients within several minutes on average and up to
// a few hours in rare cases. Throughput is limited to 7,200 updates per
// app per hour.
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
//
// will propagate to clients within 24 hours. Supports high throughput
// of up to 720,000 updates per app per hour using batch modification
// methods.
func (c *MonetizationSubscriptionsPatchCall) LatencyTolerance(latencyTolerance string) *MonetizationSubscriptionsPatchCall {
	c.urlParams_.Set("latencyTolerance", latencyTolerance)
	return c
}

// RegionsVersionVersion sets the optional parameter
// "regionsVersion.version": Required. A string representing the version
// of available regions being used for the specified resource. Regional
// prices for the resource have to be specified according to the
// information published in this article
// (https://support.google.com/googleplay/android-developer/answer/10532353).
// Each time the supported locations substantially change, the version
// will be incremented. Using this field will ensure that creating and
// updating the resource with an older region's version and set of
// regional prices and currencies will succeed even though a new version
// is available. The latest version is 2022/02.
func (c *MonetizationSubscriptionsPatchCall) RegionsVersionVersion(regionsVersionVersion string) *MonetizationSubscriptionsPatchCall {
	c.urlParams_.Set("regionsVersion.version", regionsVersionVersion)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated.
func (c *MonetizationSubscriptionsPatchCall) UpdateMask(updateMask string) *MonetizationSubscriptionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsPatchCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsPatchCall) Context(ctx context.Context) *MonetizationSubscriptionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.subscription)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.patch" call.
// Exactly one of *Subscription or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Subscription.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsPatchCall) Do(opts ...googleapi.CallOption) (*Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an existing subscription.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}",
	//   "httpMethod": "PATCH",
	//   "id": "androidpublisher.monetization.subscriptions.patch",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "Optional. If set to true, and the subscription with the given package_name and product_id doesn't exist, the subscription will be created. If a new subscription is created, update_mask is ignored.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "latencyTolerance": {
	//       "description": "Optional. The latency tolerance for the propagation of this product update. Defaults to latency-sensitive.",
	//       "enum": [
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED",
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE",
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT"
	//       ],
	//       "enumDescriptions": [
	//         "Defaults to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.",
	//         "The update will propagate to clients within several minutes on average and up to a few hours in rare cases. Throughput is limited to 7,200 updates per app per hour.",
	//         "The update will propagate to clients within 24 hours. Supports high throughput of up to 720,000 updates per app per hour using batch modification methods."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Immutable. Package name of the parent app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Immutable. Unique product ID of the product. Unique within the parent app. Product IDs must be composed of lower-case letters (a-z), numbers (0-9), underscores (_) and dots (.). It must start with a lower-case letter or number, and be between 1 and 40 (inclusive) characters in length.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "regionsVersion.version": {
	//       "description": "Required. A string representing the version of available regions being used for the specified resource. Regional prices for the resource have to be specified according to the information published in [this article](https://support.google.com/googleplay/android-developer/answer/10532353). Each time the supported locations substantially change, the version will be incremented. Using this field will ensure that creating and updating the resource with an older region's version and set of regional prices and currencies will succeed even though a new version is available. The latest version is 2022/02.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}",
	//   "request": {
	//     "$ref": "Subscription"
	//   },
	//   "response": {
	//     "$ref": "Subscription"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.activate":

type MonetizationSubscriptionsBasePlansActivateCall struct {
	s                       *Service
	packageName             string
	productId               string
	basePlanId              string
	activatebaseplanrequest *ActivateBasePlanRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Activate: Activates a base plan. Once activated, base plans will be
// available to new subscribers.
//
//   - basePlanId: The unique base plan ID of the base plan to activate.
//   - packageName: The parent app (package name) of the base plan to
//     activate.
//   - productId: The parent subscription (ID) of the base plan to
//     activate.
func (r *MonetizationSubscriptionsBasePlansService) Activate(packageName string, productId string, basePlanId string, activatebaseplanrequest *ActivateBasePlanRequest) *MonetizationSubscriptionsBasePlansActivateCall {
	c := &MonetizationSubscriptionsBasePlansActivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.activatebaseplanrequest = activatebaseplanrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansActivateCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansActivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansActivateCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansActivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansActivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansActivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.activatebaseplanrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:activate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.activate" call.
// Exactly one of *Subscription or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Subscription.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBasePlansActivateCall) Do(opts ...googleapi.CallOption) (*Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Activates a base plan. Once activated, base plans will be available to new subscribers.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:activate",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.activate",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The unique base plan ID of the base plan to activate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the base plan to activate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The parent subscription (ID) of the base plan to activate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:activate",
	//   "request": {
	//     "$ref": "ActivateBasePlanRequest"
	//   },
	//   "response": {
	//     "$ref": "Subscription"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.batchMigratePrices":

type MonetizationSubscriptionsBasePlansBatchMigratePricesCall struct {
	s                                 *Service
	packageName                       string
	productId                         string
	batchmigratebaseplanpricesrequest *BatchMigrateBasePlanPricesRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// BatchMigratePrices: Batch variant of the MigrateBasePlanPrices
// endpoint. Set the latencyTolerance field on nested requests to
// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum
// update throughput.
//
//   - packageName: The parent app (package name) for which the
//     subscriptions should be created or updated. Must be equal to the
//     package_name field on all the Subscription resources.
//   - productId: The product ID of the parent subscription, if all
//     updated offers belong to the same subscription. If this batch
//     update spans multiple subscriptions, set this field to "-". Must be
//     set.
func (r *MonetizationSubscriptionsBasePlansService) BatchMigratePrices(packageName string, productId string, batchmigratebaseplanpricesrequest *BatchMigrateBasePlanPricesRequest) *MonetizationSubscriptionsBasePlansBatchMigratePricesCall {
	c := &MonetizationSubscriptionsBasePlansBatchMigratePricesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.batchmigratebaseplanpricesrequest = batchmigratebaseplanpricesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansBatchMigratePricesCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansBatchMigratePricesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansBatchMigratePricesCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansBatchMigratePricesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansBatchMigratePricesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansBatchMigratePricesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchmigratebaseplanpricesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans:batchMigratePrices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.batchMigratePrices" call.
// Exactly one of *BatchMigrateBasePlanPricesResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *BatchMigrateBasePlanPricesResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *MonetizationSubscriptionsBasePlansBatchMigratePricesCall) Do(opts ...googleapi.CallOption) (*BatchMigrateBasePlanPricesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchMigrateBasePlanPricesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Batch variant of the MigrateBasePlanPrices endpoint. Set the latencyTolerance field on nested requests to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum update throughput.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans:batchMigratePrices",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.batchMigratePrices",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. The parent app (package name) for which the subscriptions should be created or updated. Must be equal to the package_name field on all the Subscription resources.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The product ID of the parent subscription, if all updated offers belong to the same subscription. If this batch update spans multiple subscriptions, set this field to \"-\". Must be set.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans:batchMigratePrices",
	//   "request": {
	//     "$ref": "BatchMigrateBasePlanPricesRequest"
	//   },
	//   "response": {
	//     "$ref": "BatchMigrateBasePlanPricesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.batchUpdateStates":

type MonetizationSubscriptionsBasePlansBatchUpdateStatesCall struct {
	s                                *Service
	packageName                      string
	productId                        string
	batchupdatebaseplanstatesrequest *BatchUpdateBasePlanStatesRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// BatchUpdateStates: Activates or deactivates base plans across one or
// multiple subscriptions. Set the latencyTolerance field on nested
// requests to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to
// achieve maximum update throughput.
//
//   - packageName: The parent app (package name) of the updated base
//     plans.
//   - productId: The product ID of the parent subscription, if all
//     updated base plans belong to the same subscription. If this batch
//     update spans multiple subscriptions, set this field to "-". Must be
//     set.
func (r *MonetizationSubscriptionsBasePlansService) BatchUpdateStates(packageName string, productId string, batchupdatebaseplanstatesrequest *BatchUpdateBasePlanStatesRequest) *MonetizationSubscriptionsBasePlansBatchUpdateStatesCall {
	c := &MonetizationSubscriptionsBasePlansBatchUpdateStatesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.batchupdatebaseplanstatesrequest = batchupdatebaseplanstatesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansBatchUpdateStatesCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansBatchUpdateStatesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansBatchUpdateStatesCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansBatchUpdateStatesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansBatchUpdateStatesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansBatchUpdateStatesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchupdatebaseplanstatesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans:batchUpdateStates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.batchUpdateStates" call.
// Exactly one of *BatchUpdateBasePlanStatesResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *BatchUpdateBasePlanStatesResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *MonetizationSubscriptionsBasePlansBatchUpdateStatesCall) Do(opts ...googleapi.CallOption) (*BatchUpdateBasePlanStatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchUpdateBasePlanStatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Activates or deactivates base plans across one or multiple subscriptions. Set the latencyTolerance field on nested requests to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum update throughput.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans:batchUpdateStates",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.batchUpdateStates",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the updated base plans.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The product ID of the parent subscription, if all updated base plans belong to the same subscription. If this batch update spans multiple subscriptions, set this field to \"-\". Must be set.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans:batchUpdateStates",
	//   "request": {
	//     "$ref": "BatchUpdateBasePlanStatesRequest"
	//   },
	//   "response": {
	//     "$ref": "BatchUpdateBasePlanStatesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.deactivate":

type MonetizationSubscriptionsBasePlansDeactivateCall struct {
	s                         *Service
	packageName               string
	productId                 string
	basePlanId                string
	deactivatebaseplanrequest *DeactivateBasePlanRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Deactivate: Deactivates a base plan. Once deactivated, the base plan
// will become unavailable to new subscribers, but existing subscribers
// will maintain their subscription
//
//   - basePlanId: The unique base plan ID of the base plan to deactivate.
//   - packageName: The parent app (package name) of the base plan to
//     deactivate.
//   - productId: The parent subscription (ID) of the base plan to
//     deactivate.
func (r *MonetizationSubscriptionsBasePlansService) Deactivate(packageName string, productId string, basePlanId string, deactivatebaseplanrequest *DeactivateBasePlanRequest) *MonetizationSubscriptionsBasePlansDeactivateCall {
	c := &MonetizationSubscriptionsBasePlansDeactivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.deactivatebaseplanrequest = deactivatebaseplanrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansDeactivateCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansDeactivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansDeactivateCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansDeactivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansDeactivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansDeactivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deactivatebaseplanrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:deactivate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.deactivate" call.
// Exactly one of *Subscription or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Subscription.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBasePlansDeactivateCall) Do(opts ...googleapi.CallOption) (*Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deactivates a base plan. Once deactivated, the base plan will become unavailable to new subscribers, but existing subscribers will maintain their subscription",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:deactivate",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.deactivate",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The unique base plan ID of the base plan to deactivate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the base plan to deactivate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The parent subscription (ID) of the base plan to deactivate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:deactivate",
	//   "request": {
	//     "$ref": "DeactivateBasePlanRequest"
	//   },
	//   "response": {
	//     "$ref": "Subscription"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.delete":

type MonetizationSubscriptionsBasePlansDeleteCall struct {
	s           *Service
	packageName string
	productId   string
	basePlanId  string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Delete: Deletes a base plan. Can only be done for draft base plans.
// This action is irreversible.
//
//   - basePlanId: The unique offer ID of the base plan to delete.
//   - packageName: The parent app (package name) of the base plan to
//     delete.
//   - productId: The parent subscription (ID) of the base plan to delete.
func (r *MonetizationSubscriptionsBasePlansService) Delete(packageName string, productId string, basePlanId string) *MonetizationSubscriptionsBasePlansDeleteCall {
	c := &MonetizationSubscriptionsBasePlansDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansDeleteCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansDeleteCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.delete" call.
func (c *MonetizationSubscriptionsBasePlansDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Deletes a base plan. Can only be done for draft base plans. This action is irreversible.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}",
	//   "httpMethod": "DELETE",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.delete",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The unique offer ID of the base plan to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the base plan to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The parent subscription (ID) of the base plan to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.migratePrices":

type MonetizationSubscriptionsBasePlansMigratePricesCall struct {
	s                            *Service
	packageName                  string
	productId                    string
	basePlanId                   string
	migratebaseplanpricesrequest *MigrateBasePlanPricesRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// MigratePrices: Migrates subscribers who are receiving an historical
// subscription price to the currently-offered price for the specified
// region. Requests will cause price change notifications to be sent to
// users who are currently receiving an historical price older than the
// supplied timestamp. Subscribers who do not agree to the new price
// will have their subscription ended at the next renewal.
//
//   - basePlanId: The unique base plan ID of the base plan to update
//     prices on.
//   - packageName: Package name of the parent app. Must be equal to the
//     package_name field on the Subscription resource.
//   - productId: The ID of the subscription to update. Must be equal to
//     the product_id field on the Subscription resource.
func (r *MonetizationSubscriptionsBasePlansService) MigratePrices(packageName string, productId string, basePlanId string, migratebaseplanpricesrequest *MigrateBasePlanPricesRequest) *MonetizationSubscriptionsBasePlansMigratePricesCall {
	c := &MonetizationSubscriptionsBasePlansMigratePricesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.migratebaseplanpricesrequest = migratebaseplanpricesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansMigratePricesCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansMigratePricesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansMigratePricesCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansMigratePricesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansMigratePricesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansMigratePricesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.migratebaseplanpricesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:migratePrices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.migratePrices" call.
// Exactly one of *MigrateBasePlanPricesResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *MigrateBasePlanPricesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBasePlansMigratePricesCall) Do(opts ...googleapi.CallOption) (*MigrateBasePlanPricesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MigrateBasePlanPricesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Migrates subscribers who are receiving an historical subscription price to the currently-offered price for the specified region. Requests will cause price change notifications to be sent to users who are currently receiving an historical price older than the supplied timestamp. Subscribers who do not agree to the new price will have their subscription ended at the next renewal.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:migratePrices",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.migratePrices",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The unique base plan ID of the base plan to update prices on.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. Package name of the parent app. Must be equal to the package_name field on the Subscription resource.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The ID of the subscription to update. Must be equal to the product_id field on the Subscription resource.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}:migratePrices",
	//   "request": {
	//     "$ref": "MigrateBasePlanPricesRequest"
	//   },
	//   "response": {
	//     "$ref": "MigrateBasePlanPricesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.offers.activate":

type MonetizationSubscriptionsBasePlansOffersActivateCall struct {
	s                                *Service
	packageName                      string
	productId                        string
	basePlanId                       string
	offerId                          string
	activatesubscriptionofferrequest *ActivateSubscriptionOfferRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Activate: Activates a subscription offer. Once activated,
// subscription offers will be available to new subscribers.
//
//   - basePlanId: The parent base plan (ID) of the offer to activate.
//   - offerId: The unique offer ID of the offer to activate.
//   - packageName: The parent app (package name) of the offer to
//     activate.
//   - productId: The parent subscription (ID) of the offer to activate.
func (r *MonetizationSubscriptionsBasePlansOffersService) Activate(packageName string, productId string, basePlanId string, offerId string, activatesubscriptionofferrequest *ActivateSubscriptionOfferRequest) *MonetizationSubscriptionsBasePlansOffersActivateCall {
	c := &MonetizationSubscriptionsBasePlansOffersActivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.offerId = offerId
	c.activatesubscriptionofferrequest = activatesubscriptionofferrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansOffersActivateCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansOffersActivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansOffersActivateCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansOffersActivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansOffersActivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansOffersActivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.activatesubscriptionofferrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}:activate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
		"offerId":     c.offerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.offers.activate" call.
// Exactly one of *SubscriptionOffer or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *SubscriptionOffer.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBasePlansOffersActivateCall) Do(opts ...googleapi.CallOption) (*SubscriptionOffer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SubscriptionOffer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Activates a subscription offer. Once activated, subscription offers will be available to new subscribers.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}:activate",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.offers.activate",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId",
	//     "offerId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The parent base plan (ID) of the offer to activate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "offerId": {
	//       "description": "Required. The unique offer ID of the offer to activate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the offer to activate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The parent subscription (ID) of the offer to activate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}:activate",
	//   "request": {
	//     "$ref": "ActivateSubscriptionOfferRequest"
	//   },
	//   "response": {
	//     "$ref": "SubscriptionOffer"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.offers.batchGet":

type MonetizationSubscriptionsBasePlansOffersBatchGetCall struct {
	s                                 *Service
	packageName                       string
	productId                         string
	basePlanId                        string
	batchgetsubscriptionoffersrequest *BatchGetSubscriptionOffersRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// BatchGet: Reads one or more subscription offers.
//
//   - basePlanId: The parent base plan (ID) for which the offers should
//     be read. May be specified as '-' to read offers from multiple base
//     plans.
//   - packageName: The parent app (package name) for which the
//     subscriptions should be created or updated. Must be equal to the
//     package_name field on all the requests.
//   - productId: The product ID of the parent subscription, if all
//     updated offers belong to the same subscription. If this request
//     spans multiple subscriptions, set this field to "-". Must be set.
func (r *MonetizationSubscriptionsBasePlansOffersService) BatchGet(packageName string, productId string, basePlanId string, batchgetsubscriptionoffersrequest *BatchGetSubscriptionOffersRequest) *MonetizationSubscriptionsBasePlansOffersBatchGetCall {
	c := &MonetizationSubscriptionsBasePlansOffersBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.batchgetsubscriptionoffersrequest = batchgetsubscriptionoffersrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansOffersBatchGetCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansOffersBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansOffersBatchGetCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansOffersBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansOffersBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansOffersBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchgetsubscriptionoffersrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.offers.batchGet" call.
// Exactly one of *BatchGetSubscriptionOffersResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *BatchGetSubscriptionOffersResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *MonetizationSubscriptionsBasePlansOffersBatchGetCall) Do(opts ...googleapi.CallOption) (*BatchGetSubscriptionOffersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchGetSubscriptionOffersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Reads one or more subscription offers.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchGet",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.offers.batchGet",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The parent base plan (ID) for which the offers should be read. May be specified as '-' to read offers from multiple base plans.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) for which the subscriptions should be created or updated. Must be equal to the package_name field on all the requests.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The product ID of the parent subscription, if all updated offers belong to the same subscription. If this request spans multiple subscriptions, set this field to \"-\". Must be set.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchGet",
	//   "request": {
	//     "$ref": "BatchGetSubscriptionOffersRequest"
	//   },
	//   "response": {
	//     "$ref": "BatchGetSubscriptionOffersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.offers.batchUpdate":

type MonetizationSubscriptionsBasePlansOffersBatchUpdateCall struct {
	s                                    *Service
	packageName                          string
	productId                            string
	basePlanId                           string
	batchupdatesubscriptionoffersrequest *BatchUpdateSubscriptionOffersRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// BatchUpdate: Updates a batch of subscription offers. Set the
// latencyTolerance field on nested requests to
// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum
// update throughput.
//
//   - basePlanId: The parent base plan (ID) for which the offers should
//     be updated. May be specified as '-' to update offers from multiple
//     base plans.
//   - packageName: The parent app (package name) of the updated
//     subscription offers. Must be equal to the package_name field on all
//     the updated SubscriptionOffer resources.
//   - productId: The product ID of the parent subscription, if all
//     updated offers belong to the same subscription. If this request
//     spans multiple subscriptions, set this field to "-". Must be set.
func (r *MonetizationSubscriptionsBasePlansOffersService) BatchUpdate(packageName string, productId string, basePlanId string, batchupdatesubscriptionoffersrequest *BatchUpdateSubscriptionOffersRequest) *MonetizationSubscriptionsBasePlansOffersBatchUpdateCall {
	c := &MonetizationSubscriptionsBasePlansOffersBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.batchupdatesubscriptionoffersrequest = batchupdatesubscriptionoffersrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansOffersBatchUpdateCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansOffersBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansOffersBatchUpdateCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansOffersBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansOffersBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansOffersBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchupdatesubscriptionoffersrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.offers.batchUpdate" call.
// Exactly one of *BatchUpdateSubscriptionOffersResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *BatchUpdateSubscriptionOffersResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBasePlansOffersBatchUpdateCall) Do(opts ...googleapi.CallOption) (*BatchUpdateSubscriptionOffersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchUpdateSubscriptionOffersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a batch of subscription offers. Set the latencyTolerance field on nested requests to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum update throughput.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchUpdate",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.offers.batchUpdate",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The parent base plan (ID) for which the offers should be updated. May be specified as '-' to update offers from multiple base plans.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the updated subscription offers. Must be equal to the package_name field on all the updated SubscriptionOffer resources.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The product ID of the parent subscription, if all updated offers belong to the same subscription. If this request spans multiple subscriptions, set this field to \"-\". Must be set.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchUpdate",
	//   "request": {
	//     "$ref": "BatchUpdateSubscriptionOffersRequest"
	//   },
	//   "response": {
	//     "$ref": "BatchUpdateSubscriptionOffersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.offers.batchUpdateStates":

type MonetizationSubscriptionsBasePlansOffersBatchUpdateStatesCall struct {
	s                                         *Service
	packageName                               string
	productId                                 string
	basePlanId                                string
	batchupdatesubscriptionofferstatesrequest *BatchUpdateSubscriptionOfferStatesRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// BatchUpdateStates: Updates a batch of subscription offer states. Set
// the latencyTolerance field on nested requests to
// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum
// update throughput.
//
//   - basePlanId: The parent base plan (ID) for which the offers should
//     be updated. May be specified as '-' to update offers from multiple
//     base plans.
//   - packageName: The parent app (package name) of the updated
//     subscription offers. Must be equal to the package_name field on all
//     the updated SubscriptionOffer resources.
//   - productId: The product ID of the parent subscription, if all
//     updated offers belong to the same subscription. If this request
//     spans multiple subscriptions, set this field to "-". Must be set.
func (r *MonetizationSubscriptionsBasePlansOffersService) BatchUpdateStates(packageName string, productId string, basePlanId string, batchupdatesubscriptionofferstatesrequest *BatchUpdateSubscriptionOfferStatesRequest) *MonetizationSubscriptionsBasePlansOffersBatchUpdateStatesCall {
	c := &MonetizationSubscriptionsBasePlansOffersBatchUpdateStatesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.batchupdatesubscriptionofferstatesrequest = batchupdatesubscriptionofferstatesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansOffersBatchUpdateStatesCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansOffersBatchUpdateStatesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansOffersBatchUpdateStatesCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansOffersBatchUpdateStatesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansOffersBatchUpdateStatesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansOffersBatchUpdateStatesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchupdatesubscriptionofferstatesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchUpdateStates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.offers.batchUpdateStates" call.
// Exactly one of *BatchUpdateSubscriptionOfferStatesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *BatchUpdateSubscriptionOfferStatesResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *MonetizationSubscriptionsBasePlansOffersBatchUpdateStatesCall) Do(opts ...googleapi.CallOption) (*BatchUpdateSubscriptionOfferStatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchUpdateSubscriptionOfferStatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a batch of subscription offer states. Set the latencyTolerance field on nested requests to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT to achieve maximum update throughput.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchUpdateStates",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.offers.batchUpdateStates",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The parent base plan (ID) for which the offers should be updated. May be specified as '-' to update offers from multiple base plans.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the updated subscription offers. Must be equal to the package_name field on all the updated SubscriptionOffer resources.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The product ID of the parent subscription, if all updated offers belong to the same subscription. If this request spans multiple subscriptions, set this field to \"-\". Must be set.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers:batchUpdateStates",
	//   "request": {
	//     "$ref": "BatchUpdateSubscriptionOfferStatesRequest"
	//   },
	//   "response": {
	//     "$ref": "BatchUpdateSubscriptionOfferStatesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.offers.create":

type MonetizationSubscriptionsBasePlansOffersCreateCall struct {
	s                 *Service
	packageName       string
	productId         string
	basePlanId        string
	subscriptionoffer *SubscriptionOffer
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates a new subscription offer. Only auto-renewing base
// plans can have subscription offers. The offer state will be DRAFT
// until it is activated.
//
//   - basePlanId: The parent base plan (ID) for which the offer should be
//     created. Must be equal to the base_plan_id field on the
//     SubscriptionOffer resource.
//   - packageName: The parent app (package name) for which the offer
//     should be created. Must be equal to the package_name field on the
//     Subscription resource.
//   - productId: The parent subscription (ID) for which the offer should
//     be created. Must be equal to the product_id field on the
//     SubscriptionOffer resource.
func (r *MonetizationSubscriptionsBasePlansOffersService) Create(packageName string, productId string, basePlanId string, subscriptionoffer *SubscriptionOffer) *MonetizationSubscriptionsBasePlansOffersCreateCall {
	c := &MonetizationSubscriptionsBasePlansOffersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.subscriptionoffer = subscriptionoffer
	return c
}

// OfferId sets the optional parameter "offerId": Required. The ID to
// use for the offer. For the requirements on this format, see the
// documentation of the offer_id field on the SubscriptionOffer
// resource.
func (c *MonetizationSubscriptionsBasePlansOffersCreateCall) OfferId(offerId string) *MonetizationSubscriptionsBasePlansOffersCreateCall {
	c.urlParams_.Set("offerId", offerId)
	return c
}

// RegionsVersionVersion sets the optional parameter
// "regionsVersion.version": Required. A string representing the version
// of available regions being used for the specified resource. Regional
// prices for the resource have to be specified according to the
// information published in this article
// (https://support.google.com/googleplay/android-developer/answer/10532353).
// Each time the supported locations substantially change, the version
// will be incremented. Using this field will ensure that creating and
// updating the resource with an older region's version and set of
// regional prices and currencies will succeed even though a new version
// is available. The latest version is 2022/02.
func (c *MonetizationSubscriptionsBasePlansOffersCreateCall) RegionsVersionVersion(regionsVersionVersion string) *MonetizationSubscriptionsBasePlansOffersCreateCall {
	c.urlParams_.Set("regionsVersion.version", regionsVersionVersion)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansOffersCreateCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansOffersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansOffersCreateCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansOffersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansOffersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansOffersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.subscriptionoffer)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.offers.create" call.
// Exactly one of *SubscriptionOffer or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *SubscriptionOffer.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBasePlansOffersCreateCall) Do(opts ...googleapi.CallOption) (*SubscriptionOffer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SubscriptionOffer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new subscription offer. Only auto-renewing base plans can have subscription offers. The offer state will be DRAFT until it is activated.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.offers.create",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The parent base plan (ID) for which the offer should be created. Must be equal to the base_plan_id field on the SubscriptionOffer resource.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "offerId": {
	//       "description": "Required. The ID to use for the offer. For the requirements on this format, see the documentation of the offer_id field on the SubscriptionOffer resource.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) for which the offer should be created. Must be equal to the package_name field on the Subscription resource.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The parent subscription (ID) for which the offer should be created. Must be equal to the product_id field on the SubscriptionOffer resource.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "regionsVersion.version": {
	//       "description": "Required. A string representing the version of available regions being used for the specified resource. Regional prices for the resource have to be specified according to the information published in [this article](https://support.google.com/googleplay/android-developer/answer/10532353). Each time the supported locations substantially change, the version will be incremented. Using this field will ensure that creating and updating the resource with an older region's version and set of regional prices and currencies will succeed even though a new version is available. The latest version is 2022/02.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers",
	//   "request": {
	//     "$ref": "SubscriptionOffer"
	//   },
	//   "response": {
	//     "$ref": "SubscriptionOffer"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.offers.deactivate":

type MonetizationSubscriptionsBasePlansOffersDeactivateCall struct {
	s                                  *Service
	packageName                        string
	productId                          string
	basePlanId                         string
	offerId                            string
	deactivatesubscriptionofferrequest *DeactivateSubscriptionOfferRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Deactivate: Deactivates a subscription offer. Once deactivated,
// existing subscribers will maintain their subscription, but the offer
// will become unavailable to new subscribers.
//
//   - basePlanId: The parent base plan (ID) of the offer to deactivate.
//   - offerId: The unique offer ID of the offer to deactivate.
//   - packageName: The parent app (package name) of the offer to
//     deactivate.
//   - productId: The parent subscription (ID) of the offer to deactivate.
func (r *MonetizationSubscriptionsBasePlansOffersService) Deactivate(packageName string, productId string, basePlanId string, offerId string, deactivatesubscriptionofferrequest *DeactivateSubscriptionOfferRequest) *MonetizationSubscriptionsBasePlansOffersDeactivateCall {
	c := &MonetizationSubscriptionsBasePlansOffersDeactivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.offerId = offerId
	c.deactivatesubscriptionofferrequest = deactivatesubscriptionofferrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansOffersDeactivateCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansOffersDeactivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansOffersDeactivateCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansOffersDeactivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansOffersDeactivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansOffersDeactivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deactivatesubscriptionofferrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}:deactivate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
		"offerId":     c.offerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.offers.deactivate" call.
// Exactly one of *SubscriptionOffer or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *SubscriptionOffer.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBasePlansOffersDeactivateCall) Do(opts ...googleapi.CallOption) (*SubscriptionOffer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SubscriptionOffer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deactivates a subscription offer. Once deactivated, existing subscribers will maintain their subscription, but the offer will become unavailable to new subscribers.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}:deactivate",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.offers.deactivate",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId",
	//     "offerId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The parent base plan (ID) of the offer to deactivate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "offerId": {
	//       "description": "Required. The unique offer ID of the offer to deactivate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the offer to deactivate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The parent subscription (ID) of the offer to deactivate.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}:deactivate",
	//   "request": {
	//     "$ref": "DeactivateSubscriptionOfferRequest"
	//   },
	//   "response": {
	//     "$ref": "SubscriptionOffer"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.offers.delete":

type MonetizationSubscriptionsBasePlansOffersDeleteCall struct {
	s           *Service
	packageName string
	productId   string
	basePlanId  string
	offerId     string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Delete: Deletes a subscription offer. Can only be done for draft
// offers. This action is irreversible.
//
// - basePlanId: The parent base plan (ID) of the offer to delete.
// - offerId: The unique offer ID of the offer to delete.
// - packageName: The parent app (package name) of the offer to delete.
// - productId: The parent subscription (ID) of the offer to delete.
func (r *MonetizationSubscriptionsBasePlansOffersService) Delete(packageName string, productId string, basePlanId string, offerId string) *MonetizationSubscriptionsBasePlansOffersDeleteCall {
	c := &MonetizationSubscriptionsBasePlansOffersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.offerId = offerId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansOffersDeleteCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansOffersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansOffersDeleteCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansOffersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansOffersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansOffersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
		"offerId":     c.offerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.offers.delete" call.
func (c *MonetizationSubscriptionsBasePlansOffersDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Deletes a subscription offer. Can only be done for draft offers. This action is irreversible.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}",
	//   "httpMethod": "DELETE",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.offers.delete",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId",
	//     "offerId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The parent base plan (ID) of the offer to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "offerId": {
	//       "description": "Required. The unique offer ID of the offer to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the offer to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The parent subscription (ID) of the offer to delete.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.offers.get":

type MonetizationSubscriptionsBasePlansOffersGetCall struct {
	s            *Service
	packageName  string
	productId    string
	basePlanId   string
	offerId      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Reads a single offer
//
// - basePlanId: The parent base plan (ID) of the offer to get.
// - offerId: The unique offer ID of the offer to get.
// - packageName: The parent app (package name) of the offer to get.
// - productId: The parent subscription (ID) of the offer to get.
func (r *MonetizationSubscriptionsBasePlansOffersService) Get(packageName string, productId string, basePlanId string, offerId string) *MonetizationSubscriptionsBasePlansOffersGetCall {
	c := &MonetizationSubscriptionsBasePlansOffersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.offerId = offerId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansOffersGetCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansOffersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MonetizationSubscriptionsBasePlansOffersGetCall) IfNoneMatch(entityTag string) *MonetizationSubscriptionsBasePlansOffersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansOffersGetCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansOffersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansOffersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansOffersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
		"offerId":     c.offerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.offers.get" call.
// Exactly one of *SubscriptionOffer or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *SubscriptionOffer.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBasePlansOffersGetCall) Do(opts ...googleapi.CallOption) (*SubscriptionOffer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SubscriptionOffer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Reads a single offer",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.offers.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId",
	//     "offerId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The parent base plan (ID) of the offer to get.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "offerId": {
	//       "description": "Required. The unique offer ID of the offer to get.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) of the offer to get.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The parent subscription (ID) of the offer to get.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}",
	//   "response": {
	//     "$ref": "SubscriptionOffer"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.monetization.subscriptions.basePlans.offers.list":

type MonetizationSubscriptionsBasePlansOffersListCall struct {
	s            *Service
	packageName  string
	productId    string
	basePlanId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all offers under a given subscription.
//
//   - basePlanId: The parent base plan (ID) for which the offers should
//     be read. May be specified as '-' to read all offers under a
//     subscription or an app. Must be specified as '-' if product_id is
//     specified as '-'.
//   - packageName: The parent app (package name) for which the
//     subscriptions should be read.
//   - productId: The parent subscription (ID) for which the offers should
//     be read. May be specified as '-' to read all offers under an app.
func (r *MonetizationSubscriptionsBasePlansOffersService) List(packageName string, productId string, basePlanId string) *MonetizationSubscriptionsBasePlansOffersListCall {
	c := &MonetizationSubscriptionsBasePlansOffersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of subscriptions to return. The service may return fewer than this
// value. If unspecified, at most 50 subscriptions will be returned. The
// maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *MonetizationSubscriptionsBasePlansOffersListCall) PageSize(pageSize int64) *MonetizationSubscriptionsBasePlansOffersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListSubscriptionsOffers` call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to `ListSubscriptionOffers` must match the call
// that provided the page token.
func (c *MonetizationSubscriptionsBasePlansOffersListCall) PageToken(pageToken string) *MonetizationSubscriptionsBasePlansOffersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansOffersListCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansOffersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MonetizationSubscriptionsBasePlansOffersListCall) IfNoneMatch(entityTag string) *MonetizationSubscriptionsBasePlansOffersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansOffersListCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansOffersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansOffersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansOffersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.offers.list" call.
// Exactly one of *ListSubscriptionOffersResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListSubscriptionOffersResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBasePlansOffersListCall) Do(opts ...googleapi.CallOption) (*ListSubscriptionOffersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSubscriptionOffersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all offers under a given subscription.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.offers.list",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId"
	//   ],
	//   "parameters": {
	//     "basePlanId": {
	//       "description": "Required. The parent base plan (ID) for which the offers should be read. May be specified as '-' to read all offers under a subscription or an app. Must be specified as '-' if product_id is specified as '-'.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. The parent app (package name) for which the subscriptions should be read.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of subscriptions to return. The service may return fewer than this value. If unspecified, at most 50 subscriptions will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListSubscriptionsOffers` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListSubscriptionOffers` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The parent subscription (ID) for which the offers should be read. May be specified as '-' to read all offers under an app.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers",
	//   "response": {
	//     "$ref": "ListSubscriptionOffersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *MonetizationSubscriptionsBasePlansOffersListCall) Pages(ctx context.Context, f func(*ListSubscriptionOffersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "androidpublisher.monetization.subscriptions.basePlans.offers.patch":

type MonetizationSubscriptionsBasePlansOffersPatchCall struct {
	s                 *Service
	packageName       string
	productId         string
	basePlanId        string
	offerId           string
	subscriptionoffer *SubscriptionOffer
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Patch: Updates an existing subscription offer.
//
//   - basePlanId: Immutable. The ID of the base plan to which this offer
//     is an extension.
//   - offerId: Immutable. Unique ID of this subscription offer. Must be
//     unique within the base plan.
//   - packageName: Immutable. The package name of the app the parent
//     subscription belongs to.
//   - productId: Immutable. The ID of the parent subscription this offer
//     belongs to.
func (r *MonetizationSubscriptionsBasePlansOffersService) Patch(packageName string, productId string, basePlanId string, offerId string, subscriptionoffer *SubscriptionOffer) *MonetizationSubscriptionsBasePlansOffersPatchCall {
	c := &MonetizationSubscriptionsBasePlansOffersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.basePlanId = basePlanId
	c.offerId = offerId
	c.subscriptionoffer = subscriptionoffer
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the subscription offer with the given package_name,
// product_id, base_plan_id and offer_id doesn't exist, an offer will be
// created. If a new offer is created, update_mask is ignored.
func (c *MonetizationSubscriptionsBasePlansOffersPatchCall) AllowMissing(allowMissing bool) *MonetizationSubscriptionsBasePlansOffersPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// LatencyTolerance sets the optional parameter "latencyTolerance": The
// latency tolerance for the propagation of this product update.
// Defaults to latency-sensitive.
//
// Possible values:
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED" - Defaults to
//
// PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE" - The update
//
// will propagate to clients within several minutes on average and up to
// a few hours in rare cases. Throughput is limited to 7,200 updates per
// app per hour.
//
//	"PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT" - The update
//
// will propagate to clients within 24 hours. Supports high throughput
// of up to 720,000 updates per app per hour using batch modification
// methods.
func (c *MonetizationSubscriptionsBasePlansOffersPatchCall) LatencyTolerance(latencyTolerance string) *MonetizationSubscriptionsBasePlansOffersPatchCall {
	c.urlParams_.Set("latencyTolerance", latencyTolerance)
	return c
}

// RegionsVersionVersion sets the optional parameter
// "regionsVersion.version": Required. A string representing the version
// of available regions being used for the specified resource. Regional
// prices for the resource have to be specified according to the
// information published in this article
// (https://support.google.com/googleplay/android-developer/answer/10532353).
// Each time the supported locations substantially change, the version
// will be incremented. Using this field will ensure that creating and
// updating the resource with an older region's version and set of
// regional prices and currencies will succeed even though a new version
// is available. The latest version is 2022/02.
func (c *MonetizationSubscriptionsBasePlansOffersPatchCall) RegionsVersionVersion(regionsVersionVersion string) *MonetizationSubscriptionsBasePlansOffersPatchCall {
	c.urlParams_.Set("regionsVersion.version", regionsVersionVersion)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated.
func (c *MonetizationSubscriptionsBasePlansOffersPatchCall) UpdateMask(updateMask string) *MonetizationSubscriptionsBasePlansOffersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MonetizationSubscriptionsBasePlansOffersPatchCall) Fields(s ...googleapi.Field) *MonetizationSubscriptionsBasePlansOffersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MonetizationSubscriptionsBasePlansOffersPatchCall) Context(ctx context.Context) *MonetizationSubscriptionsBasePlansOffersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MonetizationSubscriptionsBasePlansOffersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonetizationSubscriptionsBasePlansOffersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.subscriptionoffer)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"basePlanId":  c.basePlanId,
		"offerId":     c.offerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.monetization.subscriptions.basePlans.offers.patch" call.
// Exactly one of *SubscriptionOffer or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *SubscriptionOffer.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MonetizationSubscriptionsBasePlansOffersPatchCall) Do(opts ...googleapi.CallOption) (*SubscriptionOffer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SubscriptionOffer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an existing subscription offer.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}",
	//   "httpMethod": "PATCH",
	//   "id": "androidpublisher.monetization.subscriptions.basePlans.offers.patch",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "basePlanId",
	//     "offerId"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "Optional. If set to true, and the subscription offer with the given package_name, product_id, base_plan_id and offer_id doesn't exist, an offer will be created. If a new offer is created, update_mask is ignored.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "basePlanId": {
	//       "description": "Required. Immutable. The ID of the base plan to which this offer is an extension.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "latencyTolerance": {
	//       "description": "Optional. The latency tolerance for the propagation of this product update. Defaults to latency-sensitive.",
	//       "enum": [
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_UNSPECIFIED",
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE",
	//         "PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_TOLERANT"
	//       ],
	//       "enumDescriptions": [
	//         "Defaults to PRODUCT_UPDATE_LATENCY_TOLERANCE_LATENCY_SENSITIVE.",
	//         "The update will propagate to clients within several minutes on average and up to a few hours in rare cases. Throughput is limited to 7,200 updates per app per hour.",
	//         "The update will propagate to clients within 24 hours. Supports high throughput of up to 720,000 updates per app per hour using batch modification methods."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "offerId": {
	//       "description": "Required. Immutable. Unique ID of this subscription offer. Must be unique within the base plan.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "Required. Immutable. The package name of the app the parent subscription belongs to.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. Immutable. The ID of the parent subscription this offer belongs to.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "regionsVersion.version": {
	//       "description": "Required. A string representing the version of available regions being used for the specified resource. Regional prices for the resource have to be specified according to the information published in [this article](https://support.google.com/googleplay/android-developer/answer/10532353). Each time the supported locations substantially change, the version will be incremented. Using this field will ensure that creating and updating the resource with an older region's version and set of regional prices and currencies will succeed even though a new version is available. The latest version is 2022/02.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/subscriptions/{productId}/basePlans/{basePlanId}/offers/{offerId}",
	//   "request": {
	//     "$ref": "SubscriptionOffer"
	//   },
	//   "response": {
	//     "$ref": "SubscriptionOffer"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.orders.refund":

type OrdersRefundCall struct {
	s           *Service
	packageName string
	orderId     string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Refund: Refunds a user's subscription or in-app purchase order.
// Orders older than 3 years cannot be refunded.
//
//   - orderId: The order ID provided to the user when the subscription or
//     in-app order was purchased.
//   - packageName: The package name of the application for which this
//     subscription or in-app item was purchased (for example,
//     'com.some.thing').
func (r *OrdersService) Refund(packageName string, orderId string) *OrdersRefundCall {
	c := &OrdersRefundCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.orderId = orderId
	return c
}

// Revoke sets the optional parameter "revoke": Whether to revoke the
// purchased item. If set to true, access to the subscription or in-app
// item will be terminated immediately. If the item is a recurring
// subscription, all future payments will also be terminated. Consumed
// in-app items need to be handled by developer's app. (optional).
func (c *OrdersRefundCall) Revoke(revoke bool) *OrdersRefundCall {
	c.urlParams_.Set("revoke", fmt.Sprint(revoke))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrdersRefundCall) Fields(s ...googleapi.Field) *OrdersRefundCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrdersRefundCall) Context(ctx context.Context) *OrdersRefundCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrdersRefundCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrdersRefundCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/orders/{orderId}:refund")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"orderId":     c.orderId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.orders.refund" call.
func (c *OrdersRefundCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Refunds a user's subscription or in-app purchase order. Orders older than 3 years cannot be refunded.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/orders/{orderId}:refund",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.orders.refund",
	//   "parameterOrder": [
	//     "packageName",
	//     "orderId"
	//   ],
	//   "parameters": {
	//     "orderId": {
	//       "description": "The order ID provided to the user when the subscription or in-app order was purchased.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "packageName": {
	//       "description": "The package name of the application for which this subscription or in-app item was purchased (for example, 'com.some.thing').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "revoke": {
	//       "description": "Whether to revoke the purchased item. If set to true, access to the subscription or in-app item will be terminated immediately. If the item is a recurring subscription, all future payments will also be terminated. Consumed in-app items need to be handled by developer's app. (optional).",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/orders/{orderId}:refund",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.purchases.products.acknowledge":

type PurchasesProductsAcknowledgeCall struct {
	s                                  *Service
	packageName                        string
	productId                          string
	token                              string
	productpurchasesacknowledgerequest *ProductPurchasesAcknowledgeRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Acknowledge: Acknowledges a purchase of an inapp item.
//
//   - packageName: The package name of the application the inapp product
//     was sold in (for example, 'com.some.thing').
//   - productId: The inapp product SKU (for example,
//     'com.some.thing.inapp1').
//   - token: The token provided to the user's device when the inapp
//     product was purchased.
func (r *PurchasesProductsService) Acknowledge(packageName string, productId string, token string, productpurchasesacknowledgerequest *ProductPurchasesAcknowledgeRequest) *PurchasesProductsAcknowledgeCall {
	c := &PurchasesProductsAcknowledgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.token = token
	c.productpurchasesacknowledgerequest = productpurchasesacknowledgerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PurchasesProductsAcknowledgeCall) Fields(s ...googleapi.Field) *PurchasesProductsAcknowledgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PurchasesProductsAcknowledgeCall) Context(ctx context.Context) *PurchasesProductsAcknowledgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PurchasesProductsAcknowledgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PurchasesProductsAcknowledgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.productpurchasesacknowledgerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}:acknowledge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"token":       c.token,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.purchases.products.acknowledge" call.
func (c *PurchasesProductsAcknowledgeCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Acknowledges a purchase of an inapp item.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}:acknowledge",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.purchases.products.acknowledge",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "token"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "The package name of the application the inapp product was sold in (for example, 'com.some.thing').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "The inapp product SKU (for example, 'com.some.thing.inapp1').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "token": {
	//       "description": "The token provided to the user's device when the inapp product was purchased.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}:acknowledge",
	//   "request": {
	//     "$ref": "ProductPurchasesAcknowledgeRequest"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.purchases.products.consume":

type PurchasesProductsConsumeCall struct {
	s           *Service
	packageName string
	productId   string
	token       string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Consume: Consumes a purchase for an inapp item.
//
//   - packageName: The package name of the application the inapp product
//     was sold in (for example, 'com.some.thing').
//   - productId: The inapp product SKU (for example,
//     'com.some.thing.inapp1').
//   - token: The token provided to the user's device when the inapp
//     product was purchased.
func (r *PurchasesProductsService) Consume(packageName string, productId string, token string) *PurchasesProductsConsumeCall {
	c := &PurchasesProductsConsumeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.token = token
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PurchasesProductsConsumeCall) Fields(s ...googleapi.Field) *PurchasesProductsConsumeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PurchasesProductsConsumeCall) Context(ctx context.Context) *PurchasesProductsConsumeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PurchasesProductsConsumeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PurchasesProductsConsumeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}:consume")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"token":       c.token,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.purchases.products.consume" call.
func (c *PurchasesProductsConsumeCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Consumes a purchase for an inapp item.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}:consume",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.purchases.products.consume",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "token"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "The package name of the application the inapp product was sold in (for example, 'com.some.thing').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "The inapp product SKU (for example, 'com.some.thing.inapp1').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "token": {
	//       "description": "The token provided to the user's device when the inapp product was purchased.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}:consume",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.purchases.products.get":

type PurchasesProductsGetCall struct {
	s            *Service
	packageName  string
	productId    string
	token        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Checks the purchase and consumption status of an inapp item.
//
//   - packageName: The package name of the application the inapp product
//     was sold in (for example, 'com.some.thing').
//   - productId: The inapp product SKU (for example,
//     'com.some.thing.inapp1').
//   - token: The token provided to the user's device when the inapp
//     product was purchased.
func (r *PurchasesProductsService) Get(packageName string, productId string, token string) *PurchasesProductsGetCall {
	c := &PurchasesProductsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.productId = productId
	c.token = token
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PurchasesProductsGetCall) Fields(s ...googleapi.Field) *PurchasesProductsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PurchasesProductsGetCall) IfNoneMatch(entityTag string) *PurchasesProductsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PurchasesProductsGetCall) Context(ctx context.Context) *PurchasesProductsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PurchasesProductsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PurchasesProductsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName": c.packageName,
		"productId":   c.productId,
		"token":       c.token,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.purchases.products.get" call.
// Exactly one of *ProductPurchase or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *ProductPurchase.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PurchasesProductsGetCall) Do(opts ...googleapi.CallOption) (*ProductPurchase, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ProductPurchase{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Checks the purchase and consumption status of an inapp item.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}",
	//   "httpMethod": "GET",
	//   "id": "androidpublisher.purchases.products.get",
	//   "parameterOrder": [
	//     "packageName",
	//     "productId",
	//     "token"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "The package name of the application the inapp product was sold in (for example, 'com.some.thing').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "The inapp product SKU (for example, 'com.some.thing.inapp1').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "token": {
	//       "description": "The token provided to the user's device when the inapp product was purchased.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/purchases/products/{productId}/tokens/{token}",
	//   "response": {
	//     "$ref": "ProductPurchase"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.purchases.subscriptions.acknowledge":

type PurchasesSubscriptionsAcknowledgeCall struct {
	s                                       *Service
	packageName                             string
	subscriptionId                          string
	token                                   string
	subscriptionpurchasesacknowledgerequest *SubscriptionPurchasesAcknowledgeRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Acknowledge: Acknowledges a subscription purchase.
//
//   - packageName: The package name of the application for which this
//     subscription was purchased (for example, 'com.some.thing').
//   - subscriptionId: The purchased subscription ID (for example,
//     'monthly001').
//   - token: The token provided to the user's device when the
//     subscription was purchased.
func (r *PurchasesSubscriptionsService) Acknowledge(packageName string, subscriptionId string, token string, subscriptionpurchasesacknowledgerequest *SubscriptionPurchasesAcknowledgeRequest) *PurchasesSubscriptionsAcknowledgeCall {
	c := &PurchasesSubscriptionsAcknowledgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.subscriptionId = subscriptionId
	c.token = token
	c.subscriptionpurchasesacknowledgerequest = subscriptionpurchasesacknowledgerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PurchasesSubscriptionsAcknowledgeCall) Fields(s ...googleapi.Field) *PurchasesSubscriptionsAcknowledgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PurchasesSubscriptionsAcknowledgeCall) Context(ctx context.Context) *PurchasesSubscriptionsAcknowledgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PurchasesSubscriptionsAcknowledgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PurchasesSubscriptionsAcknowledgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.subscriptionpurchasesacknowledgerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:acknowledge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName":    c.packageName,
		"subscriptionId": c.subscriptionId,
		"token":          c.token,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.purchases.subscriptions.acknowledge" call.
func (c *PurchasesSubscriptionsAcknowledgeCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Acknowledges a subscription purchase.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:acknowledge",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.purchases.subscriptions.acknowledge",
	//   "parameterOrder": [
	//     "packageName",
	//     "subscriptionId",
	//     "token"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "The package name of the application for which this subscription was purchased (for example, 'com.some.thing').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "subscriptionId": {
	//       "description": "The purchased subscription ID (for example, 'monthly001').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "token": {
	//       "description": "The token provided to the user's device when the subscription was purchased.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:acknowledge",
	//   "request": {
	//     "$ref": "SubscriptionPurchasesAcknowledgeRequest"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.purchases.subscriptions.cancel":

type PurchasesSubscriptionsCancelCall struct {
	s              *Service
	packageName    string
	subscriptionId string
	token          string
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Cancel: Cancels a user's subscription purchase. The subscription
// remains valid until its expiration time.
//
//   - packageName: The package name of the application for which this
//     subscription was purchased (for example, 'com.some.thing').
//   - subscriptionId: The purchased subscription ID (for example,
//     'monthly001').
//   - token: The token provided to the user's device when the
//     subscription was purchased.
func (r *PurchasesSubscriptionsService) Cancel(packageName string, subscriptionId string, token string) *PurchasesSubscriptionsCancelCall {
	c := &PurchasesSubscriptionsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.subscriptionId = subscriptionId
	c.token = token
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PurchasesSubscriptionsCancelCall) Fields(s ...googleapi.Field) *PurchasesSubscriptionsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PurchasesSubscriptionsCancelCall) Context(ctx context.Context) *PurchasesSubscriptionsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PurchasesSubscriptionsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PurchasesSubscriptionsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName":    c.packageName,
		"subscriptionId": c.subscriptionId,
		"token":          c.token,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.purchases.subscriptions.cancel" call.
func (c *PurchasesSubscriptionsCancelCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Cancels a user's subscription purchase. The subscription remains valid until its expiration time.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:cancel",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.purchases.subscriptions.cancel",
	//   "parameterOrder": [
	//     "packageName",
	//     "subscriptionId",
	//     "token"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "The package name of the application for which this subscription was purchased (for example, 'com.some.thing').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "subscriptionId": {
	//       "description": "The purchased subscription ID (for example, 'monthly001').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "token": {
	//       "description": "The token provided to the user's device when the subscription was purchased.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:cancel",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.purchases.subscriptions.defer":

type PurchasesSubscriptionsDeferCall struct {
	s                                 *Service
	packageName                       string
	subscriptionId                    string
	token                             string
	subscriptionpurchasesdeferrequest *SubscriptionPurchasesDeferRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Defer: Defers a user's subscription purchase until a specified future
// expiration time.
//
//   - packageName: The package name of the application for which this
//     subscription was purchased (for example, 'com.some.thing').
//   - subscriptionId: The purchased subscription ID (for example,
//     'monthly001').
//   - token: The token provided to the user's device when the
//     subscription was purchased.
func (r *PurchasesSubscriptionsService) Defer(packageName string, subscriptionId string, token string, subscriptionpurchasesdeferrequest *SubscriptionPurchasesDeferRequest) *PurchasesSubscriptionsDeferCall {
	c := &PurchasesSubscriptionsDeferCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.packageName = packageName
	c.subscriptionId = subscriptionId
	c.token = token
	c.subscriptionpurchasesdeferrequest = subscriptionpurchasesdeferrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PurchasesSubscriptionsDeferCall) Fields(s ...googleapi.Field) *PurchasesSubscriptionsDeferCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PurchasesSubscriptionsDeferCall) Context(ctx context.Context) *PurchasesSubscriptionsDeferCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PurchasesSubscriptionsDeferCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PurchasesSubscriptionsDeferCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.subscriptionpurchasesdeferrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:defer")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"packageName":    c.packageName,
		"subscriptionId": c.subscriptionId,
		"token":          c.token,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "androidpublisher.purchases.subscriptions.defer" call.
// Exactly one of *SubscriptionPurchasesDeferResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SubscriptionPurchasesDeferResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PurchasesSubscriptionsDeferCall) Do(opts ...googleapi.CallOption) (*SubscriptionPurchasesDeferResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SubscriptionPurchasesDeferResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Defers a user's subscription purchase until a specified future expiration time.",
	//   "flatPath": "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:defer",
	//   "httpMethod": "POST",
	//   "id": "androidpublisher.purchases.subscriptions.defer",
	//   "parameterOrder": [
	//     "packageName",
	//     "subscriptionId",
	//     "token"
	//   ],
	//   "parameters": {
	//     "packageName": {
	//       "description": "The package name of the application for which this subscription was purchased (for example, 'com.some.thing').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "subscriptionId": {
	//       "description": "The purchased subscription ID (for example, 'monthly001').",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "token": {
	//       "description": "The token provided to the user's device when the subscription was purchased.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "androidpublisher/v3/applications/{packageName}/purchases/subscriptions/{subscriptionId}/tokens/{token}:defer",
	//   "request": {
	//     "$ref": "SubscriptionPurchasesDeferRequest"
	//   },
	//   "response": {
	//     "$ref": "SubscriptionPurchasesDeferResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/androidpublisher"
	//   ]
	// }

}

// method id "androidpublisher.purchases.subscriptions.get":

type PurchasesSubscriptionsGetCall struct {
	s              *Service
	packageName    string
	subscriptionId string
	token          string
	urlParams_     gensupport.URLParams
	ifNoneMatch_   string
	ctx_           context.Context
	header_        http.Header
}

// Get: Checks whether a user's subscription purchase is valid and
/