// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/texttospeech/v1/cloud_tts.proto

package texttospeechpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TextToSpeech_ListVoices_FullMethodName          = "/google.cloud.texttospeech.v1.TextToSpeech/ListVoices"
	TextToSpeech_SynthesizeSpeech_FullMethodName    = "/google.cloud.texttospeech.v1.TextToSpeech/SynthesizeSpeech"
	TextToSpeech_StreamingSynthesize_FullMethodName = "/google.cloud.texttospeech.v1.TextToSpeech/StreamingSynthesize"
)

// TextToSpeechClient is the client API for TextToSpeech service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TextToSpeechClient interface {
	// Returns a list of Voice supported for synthesis.
	ListVoices(ctx context.Context, in *ListVoicesRequest, opts ...grpc.CallOption) (*ListVoicesResponse, error)
	// Synthesizes speech synchronously: receive results after all text input
	// has been processed.
	SynthesizeSpeech(ctx context.Context, in *SynthesizeSpeechRequest, opts ...grpc.CallOption) (*SynthesizeSpeechResponse, error)
	// Performs bidirectional streaming speech synthesis: receives audio while
	// sending text.
	StreamingSynthesize(ctx context.Context, opts ...grpc.CallOption) (TextToSpeech_StreamingSynthesizeClient, error)
}

type textToSpeechClient struct {
	cc grpc.ClientConnInterface
}

func NewTextToSpeechClient(cc grpc.ClientConnInterface) TextToSpeechClient {
	return &textToSpeechClient{cc}
}

func (c *textToSpeechClient) ListVoices(ctx context.Context, in *ListVoicesRequest, opts ...grpc.CallOption) (*ListVoicesResponse, error) {
	out := new(ListVoicesResponse)
	err := c.cc.Invoke(ctx, TextToSpeech_ListVoices_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *textToSpeechClient) SynthesizeSpeech(ctx context.Context, in *SynthesizeSpeechRequest, opts ...grpc.CallOption) (*SynthesizeSpeechResponse, error) {
	out := new(SynthesizeSpeechResponse)
	err := c.cc.Invoke(ctx, TextToSpeech_SynthesizeSpeech_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *textToSpeechClient) StreamingSynthesize(ctx context.Context, opts ...grpc.CallOption) (TextToSpeech_StreamingSynthesizeClient, error) {
	stream, err := c.cc.NewStream(ctx, &TextToSpeech_ServiceDesc.Streams[0], TextToSpeech_StreamingSynthesize_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &textToSpeechStreamingSynthesizeClient{stream}
	return x, nil
}

type TextToSpeech_StreamingSynthesizeClient interface {
	Send(*StreamingSynthesizeRequest) error
	Recv() (*StreamingSynthesizeResponse, error)
	grpc.ClientStream
}

type textToSpeechStreamingSynthesizeClient struct {
	grpc.ClientStream
}

func (x *textToSpeechStreamingSynthesizeClient) Send(m *StreamingSynthesizeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *textToSpeechStreamingSynthesizeClient) Recv() (*StreamingSynthesizeResponse, error) {
	m := new(StreamingSynthesizeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TextToSpeechServer is the server API for TextToSpeech service.
// All implementations should embed UnimplementedTextToSpeechServer
// for forward compatibility
type TextToSpeechServer interface {
	// Returns a list of Voice supported for synthesis.
	ListVoices(context.Context, *ListVoicesRequest) (*ListVoicesResponse, error)
	// Synthesizes speech synchronously: receive results after all text input
	// has been processed.
	SynthesizeSpeech(context.Context, *SynthesizeSpeechRequest) (*SynthesizeSpeechResponse, error)
	// Performs bidirectional streaming speech synthesis: receives audio while
	// sending text.
	StreamingSynthesize(TextToSpeech_StreamingSynthesizeServer) error
}

// UnimplementedTextToSpeechServer should be embedded to have forward compatible implementations.
type UnimplementedTextToSpeechServer struct {
}

func (UnimplementedTextToSpeechServer) ListVoices(context.Context, *ListVoicesRequest) (*ListVoicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVoices not implemented")
}
func (UnimplementedTextToSpeechServer) SynthesizeSpeech(context.Context, *SynthesizeSpeechRequest) (*SynthesizeSpeechResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SynthesizeSpeech not implemented")
}
func (UnimplementedTextToSpeechServer) StreamingSynthesize(TextToSpeech_StreamingSynthesizeServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingSynthesize not implemented")
}

// UnsafeTextToSpeechServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TextToSpeechServer will
// result in compilation errors.
type UnsafeTextToSpeechServer interface {
	mustEmbedUnimplementedTextToSpeechServer()
}

func RegisterTextToSpeechServer(s grpc.ServiceRegistrar, srv TextToSpeechServer) {
	s.RegisterService(&TextToSpeech_ServiceDesc, srv)
}

func _TextToSpeech_ListVoices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVoicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TextToSpeechServer).ListVoices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TextToSpeech_ListVoices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TextToSpeechServer).ListVoices(ctx, req.(*ListVoicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TextToSpeech_SynthesizeSpeech_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SynthesizeSpeechRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TextToSpeechServer).SynthesizeSpeech(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TextToSpeech_SynthesizeSpeech_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TextToSpeechServer).SynthesizeSpeech(ctx, req.(*SynthesizeSpeechRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TextToSpeech_StreamingSynthesize_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(TextToSpeechServer).StreamingSynthesize(&textToSpeechStreamingSynthesizeServer{stream})
}

type TextToSpeech_StreamingSynthesizeServer interface {
	Send(*StreamingSynthesizeResponse) error
	Recv() (*StreamingSynthesizeRequest, error)
	grpc.ServerStream
}

type textToSpeechStreamingSynthesizeServer struct {
	grpc.ServerStream
}

func (x *textToSpeechStreamingSynthesizeServer) Send(m *StreamingSynthesizeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *textToSpeechStreamingSynthesizeServer) Recv() (*StreamingSynthesizeRequest, error) {
	m := new(StreamingSynthesizeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TextToSpeech_ServiceDesc is the grpc.ServiceDesc for TextToSpeech service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TextToSpeech_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.texttospeech.v1.TextToSpeech",
	HandlerType: (*TextToSpeechServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListVoices",
			Handler:    _TextToSpeech_ListVoices_Handler,
		},
		{
			MethodName: "SynthesizeSpeech",
			Handler:    _TextToSpeech_SynthesizeSpeech_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingSynthesize",
			Handler:       _TextToSpeech_StreamingSynthesize_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/texttospeech/v1/cloud_tts.proto",
}
