/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.ChannelHandler;
import jakarta.inject.Inject;
import org.traccar.BaseProtocol;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerServer;
import org.traccar.config.Config;
import org.traccar.protocol.MeiligaoFrameDecoder;
import org.traccar.protocol.MeiligaoProtocolDecoder;
import org.traccar.protocol.MeiligaoProtocolEncoder;

public class MeiligaoProtocol
extends BaseProtocol {
    @Inject
    public MeiligaoProtocol(Config config) {
        this.setSupportedDataCommands("positionSingle", "positionPeriodic", "outputControl", "engineStop", "engineResume", "alarmGeofence", "setTimezone", "requestPhoto", "rebootDevice");
        this.addServer(new TrackerServer(config, this.getName(), false){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new MeiligaoFrameDecoder());
                pipeline.addLast((ChannelHandler)new MeiligaoProtocolEncoder(MeiligaoProtocol.this));
                pipeline.addLast((ChannelHandler)new MeiligaoProtocolDecoder(MeiligaoProtocol.this));
            }
        });
        this.addServer(new TrackerServer(config, this.getName(), true){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new MeiligaoProtocolEncoder(MeiligaoProtocol.this));
                pipeline.addLast((ChannelHandler)new MeiligaoProtocolDecoder(MeiligaoProtocol.this));
            }
        });
    }
}

