// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataqna/v1alpha/question_service.proto

package dataqnapb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	QuestionService_GetQuestion_FullMethodName        = "/google.cloud.dataqna.v1alpha.QuestionService/GetQuestion"
	QuestionService_CreateQuestion_FullMethodName     = "/google.cloud.dataqna.v1alpha.QuestionService/CreateQuestion"
	QuestionService_ExecuteQuestion_FullMethodName    = "/google.cloud.dataqna.v1alpha.QuestionService/ExecuteQuestion"
	QuestionService_GetUserFeedback_FullMethodName    = "/google.cloud.dataqna.v1alpha.QuestionService/GetUserFeedback"
	QuestionService_UpdateUserFeedback_FullMethodName = "/google.cloud.dataqna.v1alpha.QuestionService/UpdateUserFeedback"
)

// QuestionServiceClient is the client API for QuestionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type QuestionServiceClient interface {
	// Gets a previously created question.
	GetQuestion(ctx context.Context, in *GetQuestionRequest, opts ...grpc.CallOption) (*Question, error)
	// Creates a question.
	CreateQuestion(ctx context.Context, in *CreateQuestionRequest, opts ...grpc.CallOption) (*Question, error)
	// Executes an interpretation.
	ExecuteQuestion(ctx context.Context, in *ExecuteQuestionRequest, opts ...grpc.CallOption) (*Question, error)
	// Gets previously created user feedback.
	GetUserFeedback(ctx context.Context, in *GetUserFeedbackRequest, opts ...grpc.CallOption) (*UserFeedback, error)
	// Updates user feedback. This creates user feedback if there was none before
	// (upsert).
	UpdateUserFeedback(ctx context.Context, in *UpdateUserFeedbackRequest, opts ...grpc.CallOption) (*UserFeedback, error)
}

type questionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewQuestionServiceClient(cc grpc.ClientConnInterface) QuestionServiceClient {
	return &questionServiceClient{cc}
}

func (c *questionServiceClient) GetQuestion(ctx context.Context, in *GetQuestionRequest, opts ...grpc.CallOption) (*Question, error) {
	out := new(Question)
	err := c.cc.Invoke(ctx, QuestionService_GetQuestion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *questionServiceClient) CreateQuestion(ctx context.Context, in *CreateQuestionRequest, opts ...grpc.CallOption) (*Question, error) {
	out := new(Question)
	err := c.cc.Invoke(ctx, QuestionService_CreateQuestion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *questionServiceClient) ExecuteQuestion(ctx context.Context, in *ExecuteQuestionRequest, opts ...grpc.CallOption) (*Question, error) {
	out := new(Question)
	err := c.cc.Invoke(ctx, QuestionService_ExecuteQuestion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *questionServiceClient) GetUserFeedback(ctx context.Context, in *GetUserFeedbackRequest, opts ...grpc.CallOption) (*UserFeedback, error) {
	out := new(UserFeedback)
	err := c.cc.Invoke(ctx, QuestionService_GetUserFeedback_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *questionServiceClient) UpdateUserFeedback(ctx context.Context, in *UpdateUserFeedbackRequest, opts ...grpc.CallOption) (*UserFeedback, error) {
	out := new(UserFeedback)
	err := c.cc.Invoke(ctx, QuestionService_UpdateUserFeedback_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// QuestionServiceServer is the server API for QuestionService service.
// All implementations should embed UnimplementedQuestionServiceServer
// for forward compatibility
type QuestionServiceServer interface {
	// Gets a previously created question.
	GetQuestion(context.Context, *GetQuestionRequest) (*Question, error)
	// Creates a question.
	CreateQuestion(context.Context, *CreateQuestionRequest) (*Question, error)
	// Executes an interpretation.
	ExecuteQuestion(context.Context, *ExecuteQuestionRequest) (*Question, error)
	// Gets previously created user feedback.
	GetUserFeedback(context.Context, *GetUserFeedbackRequest) (*UserFeedback, error)
	// Updates user feedback. This creates user feedback if there was none before
	// (upsert).
	UpdateUserFeedback(context.Context, *UpdateUserFeedbackRequest) (*UserFeedback, error)
}

// UnimplementedQuestionServiceServer should be embedded to have forward compatible implementations.
type UnimplementedQuestionServiceServer struct {
}

func (UnimplementedQuestionServiceServer) GetQuestion(context.Context, *GetQuestionRequest) (*Question, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetQuestion not implemented")
}
func (UnimplementedQuestionServiceServer) CreateQuestion(context.Context, *CreateQuestionRequest) (*Question, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateQuestion not implemented")
}
func (UnimplementedQuestionServiceServer) ExecuteQuestion(context.Context, *ExecuteQuestionRequest) (*Question, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteQuestion not implemented")
}
func (UnimplementedQuestionServiceServer) GetUserFeedback(context.Context, *GetUserFeedbackRequest) (*UserFeedback, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserFeedback not implemented")
}
func (UnimplementedQuestionServiceServer) UpdateUserFeedback(context.Context, *UpdateUserFeedbackRequest) (*UserFeedback, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUserFeedback not implemented")
}

// UnsafeQuestionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to QuestionServiceServer will
// result in compilation errors.
type UnsafeQuestionServiceServer interface {
	mustEmbedUnimplementedQuestionServiceServer()
}

func RegisterQuestionServiceServer(s grpc.ServiceRegistrar, srv QuestionServiceServer) {
	s.RegisterService(&QuestionService_ServiceDesc, srv)
}

func _QuestionService_GetQuestion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetQuestionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QuestionServiceServer).GetQuestion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: QuestionService_GetQuestion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QuestionServiceServer).GetQuestion(ctx, req.(*GetQuestionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _QuestionService_CreateQuestion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateQuestionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QuestionServiceServer).CreateQuestion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: QuestionService_CreateQuestion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QuestionServiceServer).CreateQuestion(ctx, req.(*CreateQuestionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _QuestionService_ExecuteQuestion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteQuestionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QuestionServiceServer).ExecuteQuestion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: QuestionService_ExecuteQuestion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QuestionServiceServer).ExecuteQuestion(ctx, req.(*ExecuteQuestionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _QuestionService_GetUserFeedback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserFeedbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QuestionServiceServer).GetUserFeedback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: QuestionService_GetUserFeedback_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QuestionServiceServer).GetUserFeedback(ctx, req.(*GetUserFeedbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _QuestionService_UpdateUserFeedback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserFeedbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QuestionServiceServer).UpdateUserFeedback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: QuestionService_UpdateUserFeedback_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QuestionServiceServer).UpdateUserFeedback(ctx, req.(*UpdateUserFeedbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// QuestionService_ServiceDesc is the grpc.ServiceDesc for QuestionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var QuestionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataqna.v1alpha.QuestionService",
	HandlerType: (*QuestionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetQuestion",
			Handler:    _QuestionService_GetQuestion_Handler,
		},
		{
			MethodName: "CreateQuestion",
			Handler:    _QuestionService_CreateQuestion_Handler,
		},
		{
			MethodName: "ExecuteQuestion",
			Handler:    _QuestionService_ExecuteQuestion_Handler,
		},
		{
			MethodName: "GetUserFeedback",
			Handler:    _QuestionService_GetUserFeedback_Handler,
		},
		{
			MethodName: "UpdateUserFeedback",
			Handler:    _QuestionService_UpdateUserFeedback_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataqna/v1alpha/question_service.proto",
}
