// SPDX-License-Identifier: Unlicense OR BSD-3-Clause

package harfbuzz

// Code generated by typesettings-utils/generators/unicodedata/cmd/main.go DO NOT EDIT.

import "github.com/go-text/typesetting/language"

var arabicJoinings = map[rune]arabicJoining{ // 828 entries
	0x0600:  'U',
	0x0601:  'U',
	0x0602:  'U',
	0x0603:  'U',
	0x0604:  'U',
	0x0605:  'U',
	0x0608:  'U',
	0x060b:  'U',
	0x0620:  'D',
	0x0621:  'U',
	0x0622:  'R',
	0x0623:  'R',
	0x0624:  'R',
	0x0625:  'R',
	0x0626:  'D',
	0x0627:  'R',
	0x0628:  'D',
	0x0629:  'R',
	0x062a:  'D',
	0x062b:  'D',
	0x062c:  'D',
	0x062d:  'D',
	0x062e:  'D',
	0x062f:  'R',
	0x0630:  'R',
	0x0631:  'R',
	0x0632:  'R',
	0x0633:  'D',
	0x0634:  'D',
	0x0635:  'D',
	0x0636:  'D',
	0x0637:  'D',
	0x0638:  'D',
	0x0639:  'D',
	0x063a:  'D',
	0x063b:  'D',
	0x063c:  'D',
	0x063d:  'D',
	0x063e:  'D',
	0x063f:  'D',
	0x0640:  'C',
	0x0641:  'D',
	0x0642:  'D',
	0x0643:  'D',
	0x0644:  'D',
	0x0645:  'D',
	0x0646:  'D',
	0x0647:  'D',
	0x0648:  'R',
	0x0649:  'D',
	0x064a:  'D',
	0x066e:  'D',
	0x066f:  'D',
	0x0671:  'R',
	0x0672:  'R',
	0x0673:  'R',
	0x0674:  'U',
	0x0675:  'R',
	0x0676:  'R',
	0x0677:  'R',
	0x0678:  'D',
	0x0679:  'D',
	0x067a:  'D',
	0x067b:  'D',
	0x067c:  'D',
	0x067d:  'D',
	0x067e:  'D',
	0x067f:  'D',
	0x0680:  'D',
	0x0681:  'D',
	0x0682:  'D',
	0x0683:  'D',
	0x0684:  'D',
	0x0685:  'D',
	0x0686:  'D',
	0x0687:  'D',
	0x0688:  'R',
	0x0689:  'R',
	0x068a:  'R',
	0x068b:  'R',
	0x068c:  'R',
	0x068d:  'R',
	0x068e:  'R',
	0x068f:  'R',
	0x0690:  'R',
	0x0691:  'R',
	0x0692:  'R',
	0x0693:  'R',
	0x0694:  'R',
	0x0695:  'R',
	0x0696:  'R',
	0x0697:  'R',
	0x0698:  'R',
	0x0699:  'R',
	0x069a:  'D',
	0x069b:  'D',
	0x069c:  'D',
	0x069d:  'D',
	0x069e:  'D',
	0x069f:  'D',
	0x06a0:  'D',
	0x06a1:  'D',
	0x06a2:  'D',
	0x06a3:  'D',
	0x06a4:  'D',
	0x06a5:  'D',
	0x06a6:  'D',
	0x06a7:  'D',
	0x06a8:  'D',
	0x06a9:  'D',
	0x06aa:  'D',
	0x06ab:  'D',
	0x06ac:  'D',
	0x06ad:  'D',
	0x06ae:  'D',
	0x06af:  'D',
	0x06b0:  'D',
	0x06b1:  'D',
	0x06b2:  'D',
	0x06b3:  'D',
	0x06b4:  'D',
	0x06b5:  'D',
	0x06b6:  'D',
	0x06b7:  'D',
	0x06b8:  'D',
	0x06b9:  'D',
	0x06ba:  'D',
	0x06bb:  'D',
	0x06bc:  'D',
	0x06bd:  'D',
	0x06be:  'D',
	0x06bf:  'D',
	0x06c0:  'R',
	0x06c1:  'D',
	0x06c2:  'D',
	0x06c3:  'R',
	0x06c4:  'R',
	0x06c5:  'R',
	0x06c6:  'R',
	0x06c7:  'R',
	0x06c8:  'R',
	0x06c9:  'R',
	0x06ca:  'R',
	0x06cb:  'R',
	0x06cc:  'D',
	0x06cd:  'R',
	0x06ce:  'D',
	0x06cf:  'R',
	0x06d0:  'D',
	0x06d1:  'D',
	0x06d2:  'R',
	0x06d3:  'R',
	0x06d5:  'R',
	0x06dd:  'U',
	0x06ee:  'R',
	0x06ef:  'R',
	0x06fa:  'D',
	0x06fb:  'D',
	0x06fc:  'D',
	0x06ff:  'D',
	0x070f:  'T',
	0x0710:  'a',
	0x0712:  'D',
	0x0713:  'D',
	0x0714:  'D',
	0x0715:  'd',
	0x0716:  'd',
	0x0717:  'R',
	0x0718:  'R',
	0x0719:  'R',
	0x071a:  'D',
	0x071b:  'D',
	0x071c:  'D',
	0x071d:  'D',
	0x071e:  'R',
	0x071f:  'D',
	0x0720:  'D',
	0x0721:  'D',
	0x0722:  'D',
	0x0723:  'D',
	0x0724:  'D',
	0x0725:  'D',
	0x0726:  'D',
	0x0727:  'D',
	0x0728:  'R',
	0x0729:  'D',
	0x072a:  'd',
	0x072b:  'D',
	0x072c:  'R',
	0x072d:  'D',
	0x072e:  'D',
	0x072f:  'd',
	0x074d:  'R',
	0x074e:  'D',
	0x074f:  'D',
	0x0750:  'D',
	0x0751:  'D',
	0x0752:  'D',
	0x0753:  'D',
	0x0754:  'D',
	0x0755:  'D',
	0x0756:  'D',
	0x0757:  'D',
	0x0758:  'D',
	0x0759:  'R',
	0x075a:  'R',
	0x075b:  'R',
	0x075c:  'D',
	0x075d:  'D',
	0x075e:  'D',
	0x075f:  'D',
	0x0760:  'D',
	0x0761:  'D',
	0x0762:  'D',
	0x0763:  'D',
	0x0764:  'D',
	0x0765:  'D',
	0x0766:  'D',
	0x0767:  'D',
	0x0768:  'D',
	0x0769:  'D',
	0x076a:  'D',
	0x076b:  'R',
	0x076c:  'R',
	0x076d:  'D',
	0x076e:  'D',
	0x076f:  'D',
	0x0770:  'D',
	0x0771:  'R',
	0x0772:  'D',
	0x0773:  'R',
	0x0774:  'R',
	0x0775:  'D',
	0x0776:  'D',
	0x0777:  'D',
	0x0778:  'R',
	0x0779:  'R',
	0x077a:  'D',
	0x077b:  'D',
	0x077c:  'D',
	0x077d:  'D',
	0x077e:  'D',
	0x077f:  'D',
	0x07ca:  'D',
	0x07cb:  'D',
	0x07cc:  'D',
	0x07cd:  'D',
	0x07ce:  'D',
	0x07cf:  'D',
	0x07d0:  'D',
	0x07d1:  'D',
	0x07d2:  'D',
	0x07d3:  'D',
	0x07d4:  'D',
	0x07d5:  'D',
	0x07d6:  'D',
	0x07d7:  'D',
	0x07d8:  'D',
	0x07d9:  'D',
	0x07da:  'D',
	0x07db:  'D',
	0x07dc:  'D',
	0x07dd:  'D',
	0x07de:  'D',
	0x07df:  'D',
	0x07e0:  'D',
	0x07e1:  'D',
	0x07e2:  'D',
	0x07e3:  'D',
	0x07e4:  'D',
	0x07e5:  'D',
	0x07e6:  'D',
	0x07e7:  'D',
	0x07e8:  'D',
	0x07e9:  'D',
	0x07ea:  'D',
	0x07fa:  'C',
	0x0840:  'R',
	0x0841:  'D',
	0x0842:  'D',
	0x0843:  'D',
	0x0844:  'D',
	0x0845:  'D',
	0x0846:  'R',
	0x0847:  'R',
	0x0848:  'D',
	0x0849:  'R',
	0x084a:  'D',
	0x084b:  'D',
	0x084c:  'D',
	0x084d:  'D',
	0x084e:  'D',
	0x084f:  'D',
	0x0850:  'D',
	0x0851:  'D',
	0x0852:  'D',
	0x0853:  'D',
	0x0854:  'R',
	0x0855:  'D',
	0x0856:  'R',
	0x0857:  'R',
	0x0858:  'R',
	0x0860:  'D',
	0x0861:  'U',
	0x0862:  'D',
	0x0863:  'D',
	0x0864:  'D',
	0x0865:  'D',
	0x0866:  'U',
	0x0867:  'R',
	0x0868:  'D',
	0x0869:  'R',
	0x086a:  'R',
	0x0870:  'R',
	0x0871:  'R',
	0x0872:  'R',
	0x0873:  'R',
	0x0874:  'R',
	0x0875:  'R',
	0x0876:  'R',
	0x0877:  'R',
	0x0878:  'R',
	0x0879:  'R',
	0x087a:  'R',
	0x087b:  'R',
	0x087c:  'R',
	0x087d:  'R',
	0x087e:  'R',
	0x087f:  'R',
	0x0880:  'R',
	0x0881:  'R',
	0x0882:  'R',
	0x0883:  'C',
	0x0884:  'C',
	0x0885:  'C',
	0x0886:  'D',
	0x0887:  'U',
	0x0888:  'U',
	0x0889:  'D',
	0x088a:  'D',
	0x088b:  'D',
	0x088c:  'D',
	0x088d:  'D',
	0x088e:  'R',
	0x0890:  'U',
	0x0891:  'U',
	0x08a0:  'D',
	0x08a1:  'D',
	0x08a2:  'D',
	0x08a3:  'D',
	0x08a4:  'D',
	0x08a5:  'D',
	0x08a6:  'D',
	0x08a7:  'D',
	0x08a8:  'D',
	0x08a9:  'D',
	0x08aa:  'R',
	0x08ab:  'R',
	0x08ac:  'R',
	0x08ad:  'U',
	0x08ae:  'R',
	0x08af:  'D',
	0x08b0:  'D',
	0x08b1:  'R',
	0x08b2:  'R',
	0x08b3:  'D',
	0x08b4:  'D',
	0x08b5:  'D',
	0x08b6:  'D',
	0x08b7:  'D',
	0x08b8:  'D',
	0x08b9:  'R',
	0x08ba:  'D',
	0x08bb:  'D',
	0x08bc:  'D',
	0x08bd:  'D',
	0x08be:  'D',
	0x08bf:  'D',
	0x08c0:  'D',
	0x08c1:  'D',
	0x08c2:  'D',
	0x08c3:  'D',
	0x08c4:  'D',
	0x08c5:  'D',
	0x08c6:  'D',
	0x08c7:  'D',
	0x08c8:  'D',
	0x08e2:  'U',
	0x1806:  'U',
	0x1807:  'D',
	0x180a:  'C',
	0x180e:  'U',
	0x1820:  'D',
	0x1821:  'D',
	0x1822:  'D',
	0x1823:  'D',
	0x1824:  'D',
	0x1825:  'D',
	0x1826:  'D',
	0x1827:  'D',
	0x1828:  'D',
	0x1829:  'D',
	0x182a:  'D',
	0x182b:  'D',
	0x182c:  'D',
	0x182d:  'D',
	0x182e:  'D',
	0x182f:  'D',
	0x1830:  'D',
	0x1831:  'D',
	0x1832:  'D',
	0x1833:  'D',
	0x1834:  'D',
	0x1835:  'D',
	0x1836:  'D',
	0x1837:  'D',
	0x1838:  'D',
	0x1839:  'D',
	0x183a:  'D',
	0x183b:  'D',
	0x183c:  'D',
	0x183d:  'D',
	0x183e:  'D',
	0x183f:  'D',
	0x1840:  'D',
	0x1841:  'D',
	0x1842:  'D',
	0x1843:  'D',
	0x1844:  'D',
	0x1845:  'D',
	0x1846:  'D',
	0x1847:  'D',
	0x1848:  'D',
	0x1849:  'D',
	0x184a:  'D',
	0x184b:  'D',
	0x184c:  'D',
	0x184d:  'D',
	0x184e:  'D',
	0x184f:  'D',
	0x1850:  'D',
	0x1851:  'D',
	0x1852:  'D',
	0x1853:  'D',
	0x1854:  'D',
	0x1855:  'D',
	0x1856:  'D',
	0x1857:  'D',
	0x1858:  'D',
	0x1859:  'D',
	0x185a:  'D',
	0x185b:  'D',
	0x185c:  'D',
	0x185d:  'D',
	0x185e:  'D',
	0x185f:  'D',
	0x1860:  'D',
	0x1861:  'D',
	0x1862:  'D',
	0x1863:  'D',
	0x1864:  'D',
	0x1865:  'D',
	0x1866:  'D',
	0x1867:  'D',
	0x1868:  'D',
	0x1869:  'D',
	0x186a:  'D',
	0x186b:  'D',
	0x186c:  'D',
	0x186d:  'D',
	0x186e:  'D',
	0x186f:  'D',
	0x1870:  'D',
	0x1871:  'D',
	0x1872:  'D',
	0x1873:  'D',
	0x1874:  'D',
	0x1875:  'D',
	0x1876:  'D',
	0x1877:  'D',
	0x1878:  'D',
	0x1880:  'U',
	0x1881:  'U',
	0x1882:  'U',
	0x1883:  'U',
	0x1884:  'U',
	0x1885:  'T',
	0x1886:  'T',
	0x1887:  'D',
	0x1888:  'D',
	0x1889:  'D',
	0x188a:  'D',
	0x188b:  'D',
	0x188c:  'D',
	0x188d:  'D',
	0x188e:  'D',
	0x188f:  'D',
	0x1890:  'D',
	0x1891:  'D',
	0x1892:  'D',
	0x1893:  'D',
	0x1894:  'D',
	0x1895:  'D',
	0x1896:  'D',
	0x1897:  'D',
	0x1898:  'D',
	0x1899:  'D',
	0x189a:  'D',
	0x189b:  'D',
	0x189c:  'D',
	0x189d:  'D',
	0x189e:  'D',
	0x189f:  'D',
	0x18a0:  'D',
	0x18a1:  'D',
	0x18a2:  'D',
	0x18a3:  'D',
	0x18a4:  'D',
	0x18a5:  'D',
	0x18a6:  'D',
	0x18a7:  'D',
	0x18a8:  'D',
	0x18aa:  'D',
	0x200c:  'U',
	0x200d:  'C',
	0x202f:  'U',
	0x2066:  'U',
	0x2067:  'U',
	0x2068:  'U',
	0x2069:  'U',
	0xa840:  'D',
	0xa841:  'D',
	0xa842:  'D',
	0xa843:  'D',
	0xa844:  'D',
	0xa845:  'D',
	0xa846:  'D',
	0xa847:  'D',
	0xa848:  'D',
	0xa849:  'D',
	0xa84a:  'D',
	0xa84b:  'D',
	0xa84c:  'D',
	0xa84d:  'D',
	0xa84e:  'D',
	0xa84f:  'D',
	0xa850:  'D',
	0xa851:  'D',
	0xa852:  'D',
	0xa853:  'D',
	0xa854:  'D',
	0xa855:  'D',
	0xa856:  'D',
	0xa857:  'D',
	0xa858:  'D',
	0xa859:  'D',
	0xa85a:  'D',
	0xa85b:  'D',
	0xa85c:  'D',
	0xa85d:  'D',
	0xa85e:  'D',
	0xa85f:  'D',
	0xa860:  'D',
	0xa861:  'D',
	0xa862:  'D',
	0xa863:  'D',
	0xa864:  'D',
	0xa865:  'D',
	0xa866:  'D',
	0xa867:  'D',
	0xa868:  'D',
	0xa869:  'D',
	0xa86a:  'D',
	0xa86b:  'D',
	0xa86c:  'D',
	0xa86d:  'D',
	0xa86e:  'D',
	0xa86f:  'D',
	0xa870:  'D',
	0xa871:  'D',
	0xa872:  'L',
	0xa873:  'U',
	0x10ac0: 'D',
	0x10ac1: 'D',
	0x10ac2: 'D',
	0x10ac3: 'D',
	0x10ac4: 'D',
	0x10ac5: 'R',
	0x10ac6: 'U',
	0x10ac7: 'R',
	0x10ac8: 'U',
	0x10ac9: 'R',
	0x10aca: 'R',
	0x10acb: 'U',
	0x10acc: 'U',
	0x10acd: 'L',
	0x10ace: 'R',
	0x10acf: 'R',
	0x10ad0: 'R',
	0x10ad1: 'R',
	0x10ad2: 'R',
	0x10ad3: 'D',
	0x10ad4: 'D',
	0x10ad5: 'D',
	0x10ad6: 'D',
	0x10ad7: 'L',
	0x10ad8: 'D',
	0x10ad9: 'D',
	0x10ada: 'D',
	0x10adb: 'D',
	0x10adc: 'D',
	0x10add: 'R',
	0x10ade: 'D',
	0x10adf: 'D',
	0x10ae0: 'D',
	0x10ae1: 'R',
	0x10ae2: 'U',
	0x10ae3: 'U',
	0x10ae4: 'R',
	0x10aeb: 'D',
	0x10aec: 'D',
	0x10aed: 'D',
	0x10aee: 'D',
	0x10aef: 'R',
	0x10b80: 'D',
	0x10b81: 'R',
	0x10b82: 'D',
	0x10b83: 'R',
	0x10b84: 'R',
	0x10b85: 'R',
	0x10b86: 'D',
	0x10b87: 'D',
	0x10b88: 'D',
	0x10b89: 'R',
	0x10b8a: 'D',
	0x10b8b: 'D',
	0x10b8c: 'R',
	0x10b8d: 'D',
	0x10b8e: 'R',
	0x10b8f: 'R',
	0x10b90: 'D',
	0x10b91: 'R',
	0x10ba9: 'R',
	0x10baa: 'R',
	0x10bab: 'R',
	0x10bac: 'R',
	0x10bad: 'D',
	0x10bae: 'D',
	0x10baf: 'U',
	0x10d00: 'L',
	0x10d01: 'D',
	0x10d02: 'D',
	0x10d03: 'D',
	0x10d04: 'D',
	0x10d05: 'D',
	0x10d06: 'D',
	0x10d07: 'D',
	0x10d08: 'D',
	0x10d09: 'D',
	0x10d0a: 'D',
	0x10d0b: 'D',
	0x10d0c: 'D',
	0x10d0d: 'D',
	0x10d0e: 'D',
	0x10d0f: 'D',
	0x10d10: 'D',
	0x10d11: 'D',
	0x10d12: 'D',
	0x10d13: 'D',
	0x10d14: 'D',
	0x10d15: 'D',
	0x10d16: 'D',
	0x10d17: 'D',
	0x10d18: 'D',
	0x10d19: 'D',
	0x10d1a: 'D',
	0x10d1b: 'D',
	0x10d1c: 'D',
	0x10d1d: 'D',
	0x10d1e: 'D',
	0x10d1f: 'D',
	0x10d20: 'D',
	0x10d21: 'D',
	0x10d22: 'R',
	0x10d23: 'D',
	0x10f30: 'D',
	0x10f31: 'D',
	0x10f32: 'D',
	0x10f33: 'R',
	0x10f34: 'D',
	0x10f35: 'D',
	0x10f36: 'D',
	0x10f37: 'D',
	0x10f38: 'D',
	0x10f39: 'D',
	0x10f3a: 'D',
	0x10f3b: 'D',
	0x10f3c: 'D',
	0x10f3d: 'D',
	0x10f3e: 'D',
	0x10f3f: 'D',
	0x10f40: 'D',
	0x10f41: 'D',
	0x10f42: 'D',
	0x10f43: 'D',
	0x10f44: 'D',
	0x10f45: 'U',
	0x10f51: 'D',
	0x10f52: 'D',
	0x10f53: 'D',
	0x10f54: 'R',
	0x10f70: 'D',
	0x10f71: 'D',
	0x10f72: 'D',
	0x10f73: 'D',
	0x10f74: 'R',
	0x10f75: 'R',
	0x10f76: 'D',
	0x10f77: 'D',
	0x10f78: 'D',
	0x10f79: 'D',
	0x10f7a: 'D',
	0x10f7b: 'D',
	0x10f7c: 'D',
	0x10f7d: 'D',
	0x10f7e: 'D',
	0x10f7f: 'D',
	0x10f80: 'D',
	0x10f81: 'D',
	0x10fb0: 'D',
	0x10fb1: 'U',
	0x10fb2: 'D',
	0x10fb3: 'D',
	0x10fb4: 'R',
	0x10fb5: 'R',
	0x10fb6: 'R',
	0x10fb7: 'U',
	0x10fb8: 'D',
	0x10fb9: 'R',
	0x10fba: 'R',
	0x10fbb: 'D',
	0x10fbc: 'D',
	0x10fbd: 'R',
	0x10fbe: 'D',
	0x10fbf: 'D',
	0x10fc0: 'U',
	0x10fc1: 'D',
	0x10fc2: 'R',
	0x10fc3: 'R',
	0x10fc4: 'D',
	0x10fc5: 'U',
	0x10fc6: 'U',
	0x10fc7: 'U',
	0x10fc8: 'U',
	0x10fc9: 'R',
	0x10fca: 'D',
	0x10fcb: 'L',
	0x110bd: 'U',
	0x110cd: 'U',
	0x1e900: 'D',
	0x1e901: 'D',
	0x1e902: 'D',
	0x1e903: 'D',
	0x1e904: 'D',
	0x1e905: 'D',
	0x1e906: 'D',
	0x1e907: 'D',
	0x1e908: 'D',
	0x1e909: 'D',
	0x1e90a: 'D',
	0x1e90b: 'D',
	0x1e90c: 'D',
	0x1e90d: 'D',
	0x1e90e: 'D',
	0x1e90f: 'D',
	0x1e910: 'D',
	0x1e911: 'D',
	0x1e912: 'D',
	0x1e913: 'D',
	0x1e914: 'D',
	0x1e915: 'D',
	0x1e916: 'D',
	0x1e917: 'D',
	0x1e918: 'D',
	0x1e919: 'D',
	0x1e91a: 'D',
	0x1e91b: 'D',
	0x1e91c: 'D',
	0x1e91d: 'D',
	0x1e91e: 'D',
	0x1e91f: 'D',
	0x1e920: 'D',
	0x1e921: 'D',
	0x1e922: 'D',
	0x1e923: 'D',
	0x1e924: 'D',
	0x1e925: 'D',
	0x1e926: 'D',
	0x1e927: 'D',
	0x1e928: 'D',
	0x1e929: 'D',
	0x1e92a: 'D',
	0x1e92b: 'D',
	0x1e92c: 'D',
	0x1e92d: 'D',
	0x1e92e: 'D',
	0x1e92f: 'D',
	0x1e930: 'D',
	0x1e931: 'D',
	0x1e932: 'D',
	0x1e933: 'D',
	0x1e934: 'D',
	0x1e935: 'D',
	0x1e936: 'D',
	0x1e937: 'D',
	0x1e938: 'D',
	0x1e939: 'D',
	0x1e93a: 'D',
	0x1e93b: 'D',
	0x1e93c: 'D',
	0x1e93d: 'D',
	0x1e93e: 'D',
	0x1e93f: 'D',
	0x1e940: 'D',
	0x1e941: 'D',
	0x1e942: 'D',
	0x1e943: 'D',
	0x1e94b: 'T',
}

const firstArabicShape = 0x0621
const lastArabicShape = 0x06d3

// arabicShaping defines the shaping for arabic runes. Each entry is indexed by
// the shape, between 0 and 3:
//   - 0: initial
//   - 1: medial
//   - 2: final
//   - 3: isolated
// See also the bounds given by [firstArabicShape] and [lastArabicShape].
var arabicShaping = [...][4]uint16{ // required memory: 2 KB
	{0x0000, 0x0000, 0x0000, 0xfe80},
	{0x0000, 0x0000, 0xfe82, 0xfe81},
	{0x0000, 0x0000, 0xfe84, 0xfe83},
	{0x0000, 0x0000, 0xfe86, 0xfe85},
	{0x0000, 0x0000, 0xfe88, 0xfe87},
	{0xfe8b, 0xfe8c, 0xfe8a, 0xfe89},
	{0x0000, 0x0000, 0xfe8e, 0xfe8d},
	{0xfe91, 0xfe92, 0xfe90, 0xfe8f},
	{0x0000, 0x0000, 0xfe94, 0xfe93},
	{0xfe97, 0xfe98, 0xfe96, 0xfe95},
	{0xfe9b, 0xfe9c, 0xfe9a, 0xfe99},
	{0xfe9f, 0xfea0, 0xfe9e, 0xfe9d},
	{0xfea3, 0xfea4, 0xfea2, 0xfea1},
	{0xfea7, 0xfea8, 0xfea6, 0xfea5},
	{0x0000, 0x0000, 0xfeaa, 0xfea9},
	{0x0000, 0x0000, 0xfeac, 0xfeab},
	{0x0000, 0x0000, 0xfeae, 0xfead},
	{0x0000, 0x0000, 0xfeb0, 0xfeaf},
	{0xfeb3, 0xfeb4, 0xfeb2, 0xfeb1},
	{0xfeb7, 0xfeb8, 0xfeb6, 0xfeb5},
	{0xfebb, 0xfebc, 0xfeba, 0xfeb9},
	{0xfebf, 0xfec0, 0xfebe, 0xfebd},
	{0xfec3, 0xfec4, 0xfec2, 0xfec1},
	{0xfec7, 0xfec8, 0xfec6, 0xfec5},
	{0xfecb, 0xfecc, 0xfeca, 0xfec9},
	{0xfecf, 0xfed0, 0xfece, 0xfecd},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfed3, 0xfed4, 0xfed2, 0xfed1},
	{0xfed7, 0xfed8, 0xfed6, 0xfed5},
	{0xfedb, 0xfedc, 0xfeda, 0xfed9},
	{0xfedf, 0xfee0, 0xfede, 0xfedd},
	{0xfee3, 0xfee4, 0xfee2, 0xfee1},
	{0xfee7, 0xfee8, 0xfee6, 0xfee5},
	{0xfeeb, 0xfeec, 0xfeea, 0xfee9},
	{0x0000, 0x0000, 0xfeee, 0xfeed},
	{0xfbe8, 0xfbe9, 0xfef0, 0xfeef},
	{0xfef3, 0xfef4, 0xfef2, 0xfef1},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xfb51, 0xfb50},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0xfbdd},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfb68, 0xfb69, 0xfb67, 0xfb66},
	{0xfb60, 0xfb61, 0xfb5f, 0xfb5e},
	{0xfb54, 0xfb55, 0xfb53, 0xfb52},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfb58, 0xfb59, 0xfb57, 0xfb56},
	{0xfb64, 0xfb65, 0xfb63, 0xfb62},
	{0xfb5c, 0xfb5d, 0xfb5b, 0xfb5a},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfb78, 0xfb79, 0xfb77, 0xfb76},
	{0xfb74, 0xfb75, 0xfb73, 0xfb72},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfb7c, 0xfb7d, 0xfb7b, 0xfb7a},
	{0xfb80, 0xfb81, 0xfb7f, 0xfb7e},
	{0x0000, 0x0000, 0xfb89, 0xfb88},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xfb85, 0xfb84},
	{0x0000, 0x0000, 0xfb83, 0xfb82},
	{0x0000, 0x0000, 0xfb87, 0xfb86},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xfb8d, 0xfb8c},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xfb8b, 0xfb8a},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfb6c, 0xfb6d, 0xfb6b, 0xfb6a},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfb70, 0xfb71, 0xfb6f, 0xfb6e},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfb90, 0xfb91, 0xfb8f, 0xfb8e},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfbd5, 0xfbd6, 0xfbd4, 0xfbd3},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfb94, 0xfb95, 0xfb93, 0xfb92},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfb9c, 0xfb9d, 0xfb9b, 0xfb9a},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfb98, 0xfb99, 0xfb97, 0xfb96},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xfb9f, 0xfb9e},
	{0xfba2, 0xfba3, 0xfba1, 0xfba0},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfbac, 0xfbad, 0xfbab, 0xfbaa},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xfba5, 0xfba4},
	{0xfba8, 0xfba9, 0xfba7, 0xfba6},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xfbe1, 0xfbe0},
	{0x0000, 0x0000, 0xfbda, 0xfbd9},
	{0x0000, 0x0000, 0xfbd8, 0xfbd7},
	{0x0000, 0x0000, 0xfbdc, 0xfbdb},
	{0x0000, 0x0000, 0xfbe3, 0xfbe2},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xfbdf, 0xfbde},
	{0xfbfe, 0xfbff, 0xfbfd, 0xfbfc},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0xfbe6, 0xfbe7, 0xfbe5, 0xfbe4},
	{0x0000, 0x0000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xfbaf, 0xfbae},
	{0x0000, 0x0000, 0xfbb1, 0xfbb0},
}

type arabicLig struct {
	components []rune // currently with length 1 or 2
	ligature   rune
}

type arabicTableEntry struct {
	First     rune
	Ligatures []arabicLig
}

// arabicLigatureTable exposes lam-alef ligatures
var arabicLigatureTable = [...]arabicTableEntry{
	{0xfe91, []arabicLig{
		{[]rune{0xfea0}, 0xfc9c},
		{[]rune{0xfea4}, 0xfc9d},
		{[]rune{0xfea8}, 0xfc9e},
		{[]rune{0xfee2}, 0xfc08},
		{[]rune{0xfee4}, 0xfc9f},
	}},
	{0xfe92, []arabicLig{
		{[]rune{0xfeae}, 0xfc6a},
		{[]rune{0xfee6}, 0xfc6d},
		{[]rune{0xfef2}, 0xfc6f},
	}},
	{0xfe97, []arabicLig{
		{[]rune{0xfea0}, 0xfca1},
		{[]rune{0xfea4}, 0xfca2},
		{[]rune{0xfea8}, 0xfca3},
		{[]rune{0xfee2}, 0xfc0e},
		{[]rune{0xfee4}, 0xfca4},
	}},
	{0xfe98, []arabicLig{
		{[]rune{0xfeae}, 0xfc70},
		{[]rune{0xfee6}, 0xfc73},
		{[]rune{0xfef2}, 0xfc75},
	}},
	{0xfe9b, []arabicLig{
		{[]rune{0xfee2}, 0xfc12},
	}},
	{0xfe9f, []arabicLig{
		{[]rune{0xfee4}, 0xfca8},
	}},
	{0xfea3, []arabicLig{
		{[]rune{0xfee4}, 0xfcaa},
	}},
	{0xfea7, []arabicLig{
		{[]rune{0xfee4}, 0xfcac},
	}},
	{0xfeb3, []arabicLig{
		{[]rune{0xfee4}, 0xfcb0},
	}},
	{0xfeb7, []arabicLig{
		{[]rune{0xfee4}, 0xfd30},
	}},
	{0xfed3, []arabicLig{
		{[]rune{0xfef2}, 0xfc32},
	}},
	{0xfedf, []arabicLig{
		{[]rune{0xfe82}, 0xfef5},
		{[]rune{0xfe84}, 0xfef7},
		{[]rune{0xfe88}, 0xfef9},
		{[]rune{0xfe8e}, 0xfefb},
		{[]rune{0xfe9e}, 0xfc3f},
		{[]rune{0xfea0}, 0xfcc9},
		{[]rune{0xfea2}, 0xfc40},
		{[]rune{0xfea4}, 0xfcca},
		{[]rune{0xfea6}, 0xfc41},
		{[]rune{0xfea8}, 0xfccb},
		{[]rune{0xfee2}, 0xfc42},
		{[]rune{0xfee4}, 0xfccc},
		{[]rune{0xfeec}, 0xfccd},
		{[]rune{0xfef2}, 0xfc44},
	}},
	{0xfee0, []arabicLig{
		{[]rune{0xfe82}, 0xfef6},
		{[]rune{0xfe84}, 0xfef8},
		{[]rune{0xfe88}, 0xfefa},
		{[]rune{0xfe8e}, 0xfefc},
		{[]rune{0xfef0}, 0xfc86},
	}},
	{0xfee3, []arabicLig{
		{[]rune{0xfea0}, 0xfcce},
		{[]rune{0xfea4}, 0xfccf},
		{[]rune{0xfea8}, 0xfcd0},
		{[]rune{0xfee4}, 0xfcd1},
	}},
	{0xfee7, []arabicLig{
		{[]rune{0xfea0}, 0xfcd2},
		{[]rune{0xfea4}, 0xfcd3},
		{[]rune{0xfee2}, 0xfc4e},
		{[]rune{0xfee4}, 0xfcd5},
	}},
	{0xfee8, []arabicLig{
		{[]rune{0xfef2}, 0xfc8f},
	}},
	{0xfef3, []arabicLig{
		{[]rune{0xfea0}, 0xfcda},
		{[]rune{0xfea4}, 0xfcdb},
		{[]rune{0xfea8}, 0xfcdc},
		{[]rune{0xfee4}, 0xfcdd},
	}},
	{0xfef4, []arabicLig{
		{[]rune{0xfeae}, 0xfc91},
		{[]rune{0xfee6}, 0xfc94},
	}},
}

var arabicLigatureMarkTable = [...]arabicTableEntry{
	{0x0651, []arabicLig{
		{[]rune{0x064b}, 0xf2ee},
		{[]rune{0x064c}, 0xfc5e},
		{[]rune{0x064e}, 0xfc60},
		{[]rune{0x064f}, 0xfc61},
		{[]rune{0x0650}, 0xfc62},
	}},
}

var arabicLigature3Table = [...]arabicTableEntry{
	{0xfedf, []arabicLig{
		{[]rune{0xfee0, 0xfeea}, 0xf201},
		{[]rune{0xfee4, 0xfea4}, 0xfd88},
		{[]rune{0xfee4, 0xfea0}, 0xf211},
	}},
}

// hasArabicJoining return 'true' if the given script has arabic joining.
func hasArabicJoining(script language.Script) bool {
	switch script {
	case language.Adlam, language.Arabic, language.Chorasmian, language.Hanifi_Rohingya, language.Mandaic, language.Manichaean, language.Mongolian, language.Nko, language.Old_Uyghur, language.Phags_Pa, language.Psalter_Pahlavi, language.Sogdian, language.Syriac:
		return true
	default:
		return false
	}
}
