// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestAttributesToSnippet(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.AttributesToSnippetOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.AttributesToSnippet([]string{}...),
		},
		{
			opts:     []interface{}{opt.AttributesToSnippet("value1")},
			expected: opt.AttributesToSnippet("value1"),
		},
		{
			opts:     []interface{}{opt.AttributesToSnippet("value1", "value2", "value3")},
			expected: opt.AttributesToSnippet("value1", "value2", "value3"),
		},
	} {
		var (
			in  = ExtractAttributesToSnippet(c.opts...)
			out opt.AttributesToSnippetOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), out.Get())
	}
}

func TestAttributesToSnippet_CommaSeparatedString(t *testing.T) {
	for _, c := range []struct {
		payload  string
		expected *opt.AttributesToSnippetOption
	}{
		{
			payload:  `""`,
			expected: opt.AttributesToSnippet([]string{}...),
		},
		{
			payload:  `"value1"`,
			expected: opt.AttributesToSnippet("value1"),
		},
		{
			payload:  `"value1,value2,value3"`,
			expected: opt.AttributesToSnippet("value1", "value2", "value3"),
		},
	} {
		var got opt.AttributesToSnippetOption
		err := json.Unmarshal([]byte(c.payload), &got)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), got.Get())
	}
}
